/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.language.arguments;

import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.profiles.BranchProfile;
import org.jruby.truffle.language.RubyNode;
import org.jruby.truffle.language.arguments.RubyArguments;
import org.jruby.truffle.language.control.RaiseException;
import org.jruby.truffle.language.methods.Arity;

public class CheckArityNode
extends RubyNode {
    private final Arity arity;
    private final BranchProfile checkFailedProfile = BranchProfile.create();

    public CheckArityNode(Arity arity) {
        this.arity = arity;
    }

    @Override
    public void executeVoid(VirtualFrame frame) {
        int given = RubyArguments.getArgumentsCount(frame);
        if (!CheckArityNode.checkArity(this.arity, given)) {
            this.checkFailedProfile.enter();
            throw new RaiseException(this.coreExceptions().argumentError(given, this.arity.getRequired(), this));
        }
    }

    @Override
    public Object execute(VirtualFrame frame) {
        this.executeVoid(frame);
        return this.nil();
    }

    public static boolean checkArity(Arity arity, int given) {
        int required = arity.getRequired();
        if (required != 0 && given < required) {
            return false;
        }
        return arity.hasRest() || given <= required + arity.getOptional();
    }
}

