
####### Expanded from @PACKAGE_INIT@ by configure_package_config_file() #######
####### Any changes to this file will be overwritten by the next CMake run ####
####### The input file was KaduConfig.cmake.in                            ########

get_filename_component(PACKAGE_PREFIX_DIR "${CMAKE_CURRENT_LIST_DIR}/../../../" ABSOLUTE)

####################################################################################

set (KADU_VERSION "3.0")

set (KADU_INSTALL_SDK_DIR "share/kadu/sdk")
set (KADU_INSTALL_BIN_DIR "bin")
set (KADU_INSTALL_LIB_DIR "lib")
set (KADU_INSTALL_DATA_DIR "share/kadu")
set (KADU_INSTALL_PLUGINS_DATA_DIR "share/kadu/plugins")
set (KADU_INSTALL_PLUGINS_LIB_DIR "lib/kadu/plugins")
set (KADU_INSTALL_INCLUDE_DIR "include/kadu")
set (KADU_INSTALL_CMAKE_DIR "share/cmake/Kadu")
set (KADU_FULL_INSTALL_CMAKE_DIR "/usr/share/cmake/Kadu" )

if (UNIX AND NOT APPLE)
	set (KADU_DESKTOP_FILE_DIR "${PACKAGE_PREFIX_DIR}/share/applications")
	set (KADU_DESKTOP_FILE_NAME "kadu.desktop")
endif ()

set (KADU_INCLUDE_DIR "${PACKAGE_PREFIX_DIR}/include/kadu")
set (KADU_INCLUDE_DIRS "${PACKAGE_PREFIX_DIR}/include/kadu" "${PACKAGE_PREFIX_DIR}/include/kadu/kadu-core")
set (KADU_SDK_DIR "${PACKAGE_PREFIX_DIR}/share/kadu/sdk")
set (KADU_INSTALL_PREFIX "${PACKAGE_PREFIX_DIR}")

set (KADU_INSTALL_SDK "ON")

set (KADU_C_FLAGS "-Wwrite-strings")
set (KADU_CXX_FLAGS "-Woverloaded-virtual -Wnon-virtual-dtor -std=c++0x -fvisibility-inlines-hidden")
set (KADU_COMPILE_FLAGS "-Wall -Wextra -Wundef -Wunused -Wuninitialized -Wcast-align -Wpointer-arith -fno-common -fvisibility=hidden")
set (KADU_LINK_FLAGS " -Wl,--no-undefined")
set (KADU_DEFINITIONS "QT_USE_QSTRINGBUILDER;QT_NO_CAST_TO_ASCII;QT_DISABLE_DEPRECATED_BEFORE=0x040900")
set (KADU_DEFINITIONS_DEBUG "DEBUG_ENABLED;DEBUG_OUTPUT_ENABLED")

if (NOT DEFINED CMAKE_CONFIGURATION_TYPES)
	set (KADU_BUILD_TYPE "Release")
endif ()

get_filename_component (_real_current_list_dir "${CMAKE_CURRENT_LIST_DIR}" REALPATH)
get_filename_component (_real_binary_dir "${CMAKE_BINARY_DIR}" REALPATH)
if (_real_current_list_dir STREQUAL _real_binary_dir)
	# In build tree.
	set (KADU_BUILD TRUE)

	include ("${CMAKE_SOURCE_DIR}/cmake/KaduMacros.cmake")
else ()
	# In installation tree.
	set (KADU_BUILD FALSE)

	if (NOT TARGET libkadu)
		set (KADU_WITH_LIBINDICATE_QT "")
		set (KADU_INSTALL_UNOFFICIAL_TRANSLATIONS "OFF")
		set (KADU_ENABLED_LANGUAGES "cs;en;es_MX;fr;pl;tr")

		include ("${CMAKE_CURRENT_LIST_DIR}/KaduTargets.cmake")
		include ("${CMAKE_CURRENT_LIST_DIR}/KaduMacros.cmake")
	endif ()
endif ()

set (KADU_LIBRARIES libkadu)
set (KADU_EXECUTABLE kadu)
