unreachable-branch-transform
============================

[![Build Status](https://travis-ci.org/zertosh/unreachable-branch-transform.svg?branch=master)](https://travis-ci.org/zertosh/unreachable-branch-transform)

Removes unreachable code branches in `if` statements, ternaries `?`, and logical operations `||` `&&`, where the test is determinable (like comparing two constants). This is similar to what [UglifyJS](https://github.com/mishoo/UglifyJS2)'s "dead_code" compressor option does, but without the extra code transformations.

When combined with something like [envify](https://github.com/hughsk/envify) and [browserify](https://github.com/substack/node-browserify), you can perform conditional `require` calls without including more code than you need.

#### Install ####

```bash
npm install unreachable-branch-transform
```

#### Example outputs #####

```js
// original 
var transport = process.env.TARGET === 'client' ? require('ajax') : require('fs');

// after envify
var transport = 'server' === 'client' ? require('ajax') : require('fs');
// then after unreachable-branch-transform
var transport = require('fs');
```

```js
// original
if (process.env.NODE_ENV === 'development') {
  console.log('in dev mode');
} else {
  console.log('in some other mode');
}

// after envify
if ('production' === 'development') {
  console.log('in dev mode');
} else {
  console.log('in some other mode');
}

// then after unreachable-branch-transform
{
  console.log('in some other mode');
}
```

#### Usage



* `unreachable-branch-transform` can be used a [browserify](https://github.com/substack/node-browserify) transform. Just include it like any other transform.
* `unreachable-branch-transform` can also be used on raw code by calling the `transform` function exposed by requiring the package.

#### Frequently asked questions ####

##### Why are `undefined` equality references not removed?

If you have a branch with the format

```javascript
if (undefined === 'production') {
  /* ... */
}
```

it will not be removed. Unfortunately, `undefined` is _not_ a constant in older browser runtimes and can be reassigned. In this case, it could be possible that `undefined` does indeed equal `'production`'.

Credit
------
`esmangle-evaluator` is from the [esmangle](https://github.com/Constellation/esmangle) project.
