/*
 * Decompiled with CFR 0.152.
 */
package ch.softenvironment.util;

import ch.softenvironment.util.DeveloperException;
import ch.softenvironment.util.StringUtils;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Date;

public class BeanReflector {
    private transient Object source = null;
    private transient String property = null;
    public static final int NONE = 0;
    public static final int GETTER = 1;
    public static final int SETTER = 2;
    public static final int GETTER_AND_SETTER = 3;

    public static final boolean isInherited(Class son, Class predecessor) {
        for (Class current = son; current != Object.class && current != null; current = current.getSuperclass()) {
            if (!current.equals(predecessor)) continue;
            return true;
        }
        return false;
    }

    public BeanReflector(Object source, String property) {
        this.source = source;
        this.property = BeanReflector.convertPropertyName(property);
    }

    public Object getSource() {
        return this.source;
    }

    public String getProperty() {
        return this.property;
    }

    protected String getPropertyUpper() {
        return StringUtils.firstLetterToUppercase(this.property);
    }

    public Field getField() {
        try {
            return this.getSource().getClass().getField("field" + this.getPropertyUpper());
        }
        catch (NoSuchFieldException e) {
            throw new DeveloperException("<" + this.getSource().getClass().getName() + "> must implement <" + "public field" + this.getPropertyUpper() + ">", null, e);
        }
    }

    private Method getGetterMethod() throws NoSuchMethodException {
        Class[] parameterTypes = new Class[]{};
        return this.getSource().getClass().getMethod("get" + this.getPropertyUpper(), parameterTypes);
    }

    private Method getSetterMethod() throws NoSuchMethodException {
        Class[] parameterTypes = new Class[]{this.getType()};
        return this.getSource().getClass().getMethod("set" + this.getPropertyUpper(), parameterTypes);
    }

    public Class getType() throws NoSuchMethodException {
        return this.getGetterMethod().getReturnType();
    }

    public Object getValue() throws IllegalAccessException, InvocationTargetException {
        try {
            Object[] parameters = new Object[]{};
            return this.getGetterMethod().invoke(this.getSource(), parameters);
        }
        catch (NoSuchMethodException e) {
            throw new DeveloperException("<" + this.getSource().getClass().getName() + "> must implement <" + "get" + this.getPropertyUpper() + "()", null, e);
        }
    }

    public int hasProperty() {
        int implementationDegree = 0;
        try {
            this.getGetterMethod();
            implementationDegree = 1;
        }
        catch (NoSuchMethodException e) {
            // empty catch block
        }
        try {
            this.getSetterMethod();
            implementationDegree += 2;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        return implementationDegree;
    }

    public void setField(Object value) {
        try {
            this.getField().set(this.getSource(), value);
        }
        catch (IllegalAccessException e) {
            throw new DeveloperException("<" + this.getSource().getClass().getName() + "#field" + this.getPropertyUpper() + ">  must be PUBLIC!", null, e);
        }
    }

    public void setValue(Object value) throws InvocationTargetException, IllegalAccessException {
        try {
            Object[] args = new Object[]{value};
            this.getSetterMethod().invoke(this.getSource(), args);
        }
        catch (NoSuchMethodException e) {
            throw new DeveloperException("<" + this.getSource().getClass().getName() + "> must implement <" + "set" + this.getPropertyUpper() + "(<type>)", null, e);
        }
    }

    public static Object createInstance(Class target) throws InstantiationException, InvocationTargetException {
        try {
            Class[] types = new Class[]{};
            Object[] args = new Object[]{};
            Constructor constructor = target.getConstructor(types);
            return constructor.newInstance(args);
        }
        catch (NoSuchMethodException e) {
            throw new DeveloperException("Class <" + target + "> must implement: Constructor()!", null, e);
        }
        catch (IllegalAccessException e) {
            throw new DeveloperException("Class <" + target + ".Constructor()> must be: PUBLIC!", null, e);
        }
    }

    public Object cloneValue() throws IllegalAccessException, InvocationTargetException {
        Object value = this.getValue();
        if (value == null) {
            return null;
        }
        if (value instanceof String) {
            return value.toString();
        }
        if (value instanceof Long) {
            return new Long(value.toString());
        }
        if (value instanceof Double) {
            return new Double(value.toString());
        }
        if (value instanceof Integer) {
            return new Integer(value.toString());
        }
        if (value instanceof Float) {
            return new Float(value.toString());
        }
        if (value instanceof Boolean) {
            return value;
        }
        if (value instanceof Date) {
            return new Date(((Date)value).getTime());
        }
        return null;
    }

    public static String convertPropertyName(String property) {
        return property.substring(0, 1).toLowerCase() + property.substring(1, property.length());
    }
}

