#ifndef _ELDBUS_MODEL_OBJECT_EO_H_
#define _ELDBUS_MODEL_OBJECT_EO_H_

#ifndef _ELDBUS_MODEL_OBJECT_EO_CLASS_TYPE
#define _ELDBUS_MODEL_OBJECT_EO_CLASS_TYPE

typedef Eo Eldbus_Model_Object;

#endif

#ifndef _ELDBUS_MODEL_OBJECT_EO_TYPES
#define _ELDBUS_MODEL_OBJECT_EO_TYPES


#endif
#define ELDBUS_MODEL_OBJECT_CLASS eldbus_model_object_class_get()

EAPI const Eo_Class *eldbus_model_object_class_get(void) EINA_CONST;

EOAPI void eldbus_model_object_type_set(int value);

EOAPI int eldbus_model_object_type_get(void);

EOAPI void eldbus_model_object_address_set(const char *value);

EOAPI const char *eldbus_model_object_address_get(void);

EOAPI void eldbus_model_object_private_set(Eina_Bool value);

EOAPI Eina_Bool eldbus_model_object_private_get(void);

EOAPI void eldbus_model_object_bus_set(const char *value);

EOAPI const char *eldbus_model_object_bus_get(void);

EOAPI void eldbus_model_object_path_set(const char *value);

EOAPI const char *eldbus_model_object_path_get(void);

/**
 * @brief Custom Eldbus_Model_Object constructor.
 *
 * @param[in] address Remote address of dbus
 * @param[in] private_ Non shared dbus connection
 * @param[in] bus DBus Name or unique-id
 * @param[in] path DBus path
 *
 * @since 1.16
 *
 * @ingroup Eldbus_Model_Object
 */
EOAPI void eldbus_model_object_constructor(int type, const char *address, Eina_Bool private_, const char *bus, const char *path);

/**
 * @brief Custom Eldbus_Model_Object connection_constructor.
 *
 * @param[in] bus DBus Name or unique-id
 * @param[in] path DBus path
 *
 * @since 1.16
 *
 * @ingroup Eldbus_Model_Object
 */
EOAPI void eldbus_model_object_connection_constructor(Eldbus_Connection *connection, const char *bus, const char *path);


#endif
