/*
 * Decompiled with CFR 0.152.
 */
package org.hamcrest.generator;

import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.hamcrest.generator.FactoryMethod;
import org.hamcrest.generator.FactoryWriter;
import org.hamcrest.generator.SugarConfiguration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SugarGenerator
implements Closeable,
SugarConfiguration {
    private final List<FactoryWriter> factoryWriters = new ArrayList<FactoryWriter>();
    private final List<FactoryMethod> factoryMethods = new ArrayList<FactoryMethod>();

    @Override
    public void addWriter(FactoryWriter factoryWriter) {
        this.factoryWriters.add(factoryWriter);
    }

    @Override
    public void addFactoryMethod(FactoryMethod method) {
        this.factoryMethods.add(method);
    }

    @Override
    public void addFactoryMethods(Iterable<FactoryMethod> methods) {
        for (FactoryMethod method : methods) {
            this.addFactoryMethod(method);
        }
    }

    public void generate() throws IOException {
        for (FactoryWriter factoryWriter : this.factoryWriters) {
            factoryWriter.writeHeader();
            for (FactoryMethod factoryMethod : this.factoryMethods) {
                factoryWriter.writeMethod(factoryMethod.getName(), factoryMethod);
            }
            factoryWriter.writeFooter();
            factoryWriter.flush();
        }
    }

    @Override
    public void close() throws IOException {
        for (FactoryWriter factoryWriter : this.factoryWriters) {
            factoryWriter.close();
        }
    }
}

