/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action;

import java.io.IOException;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.ShardOperationFailedException;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Streamable;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentBuilderString;
import org.elasticsearch.rest.RestStatus;

public class ActionWriteResponse
extends ActionResponse {
    public static final ShardInfo.Failure[] EMPTY = new ShardInfo.Failure[0];
    private ShardInfo shardInfo;

    @Override
    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        this.shardInfo = ShardInfo.readShardInfo(in);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        this.shardInfo.writeTo(out);
    }

    public ShardInfo getShardInfo() {
        return this.shardInfo;
    }

    public void setShardInfo(ShardInfo shardInfo) {
        this.shardInfo = shardInfo;
    }

    public static class ShardInfo
    implements Streamable,
    ToXContent {
        private int total;
        private int successful;
        private Failure[] failures = EMPTY;

        public ShardInfo() {
        }

        public ShardInfo(int total, int successful, Failure ... failures) {
            assert (total >= 0 && successful >= 0);
            this.total = total;
            this.successful = successful;
            this.failures = failures;
        }

        public int getTotal() {
            return this.total;
        }

        public int getSuccessful() {
            return this.successful;
        }

        public int getFailed() {
            return this.failures.length;
        }

        public Failure[] getFailures() {
            return this.failures;
        }

        public RestStatus status() {
            RestStatus status = RestStatus.OK;
            for (Failure failure : this.failures) {
                if (!failure.primary() || failure.status().getStatus() <= status.getStatus()) continue;
                status = failure.status();
            }
            return status;
        }

        @Override
        public void readFrom(StreamInput in) throws IOException {
            this.total = in.readVInt();
            this.successful = in.readVInt();
            int size = in.readVInt();
            this.failures = new Failure[size];
            for (int i = 0; i < size; ++i) {
                Failure failure = new Failure();
                failure.readFrom(in);
                this.failures[i] = failure;
            }
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeVInt(this.total);
            out.writeVInt(this.successful);
            out.writeVInt(this.failures.length);
            for (Failure failure : this.failures) {
                failure.writeTo(out);
            }
        }

        @Override
        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject(Fields._SHARDS);
            builder.field(Fields.TOTAL, this.total);
            builder.field(Fields.SUCCESSFUL, this.successful);
            builder.field(Fields.FAILED, this.getFailed());
            if (this.failures.length > 0) {
                builder.startArray(Fields.FAILURES);
                for (Failure failure : this.failures) {
                    failure.toXContent(builder, params);
                }
                builder.endArray();
            }
            builder.endObject();
            return builder;
        }

        public String toString() {
            return Strings.toString(this);
        }

        public static ShardInfo readShardInfo(StreamInput in) throws IOException {
            ShardInfo shardInfo = new ShardInfo();
            shardInfo.readFrom(in);
            return shardInfo;
        }

        private static class Fields {
            private static final XContentBuilderString _SHARDS = new XContentBuilderString("_shards");
            private static final XContentBuilderString TOTAL = new XContentBuilderString("total");
            private static final XContentBuilderString SUCCESSFUL = new XContentBuilderString("successful");
            private static final XContentBuilderString PENDING = new XContentBuilderString("pending");
            private static final XContentBuilderString FAILED = new XContentBuilderString("failed");
            private static final XContentBuilderString FAILURES = new XContentBuilderString("failures");

            private Fields() {
            }
        }

        public static class Failure
        implements ShardOperationFailedException,
        ToXContent {
            private String index;
            private int shardId;
            private String nodeId;
            private Throwable cause;
            private RestStatus status;
            private boolean primary;

            public Failure(String index, int shardId, @Nullable String nodeId, Throwable cause, RestStatus status, boolean primary) {
                this.index = index;
                this.shardId = shardId;
                this.nodeId = nodeId;
                this.cause = cause;
                this.status = status;
                this.primary = primary;
            }

            Failure() {
            }

            @Override
            public String index() {
                return this.index;
            }

            @Override
            public int shardId() {
                return this.shardId;
            }

            @Nullable
            public String nodeId() {
                return this.nodeId;
            }

            @Override
            public String reason() {
                return ExceptionsHelper.detailedMessage(this.cause);
            }

            @Override
            public RestStatus status() {
                return this.status;
            }

            @Override
            public Throwable getCause() {
                return this.cause;
            }

            public boolean primary() {
                return this.primary;
            }

            @Override
            public void readFrom(StreamInput in) throws IOException {
                this.index = in.readString();
                this.shardId = in.readVInt();
                this.nodeId = in.readOptionalString();
                this.cause = in.readThrowable();
                this.status = RestStatus.readFrom(in);
                this.primary = in.readBoolean();
            }

            @Override
            public void writeTo(StreamOutput out) throws IOException {
                out.writeString(this.index);
                out.writeVInt(this.shardId);
                out.writeOptionalString(this.nodeId);
                out.writeThrowable(this.cause);
                RestStatus.writeTo(out, this.status);
                out.writeBoolean(this.primary);
            }

            @Override
            public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
                builder.startObject();
                builder.field(Fields._INDEX, this.index);
                builder.field(Fields._SHARD, this.shardId);
                builder.field(Fields._NODE, this.nodeId);
                builder.field(Fields.REASON);
                builder.startObject();
                ElasticsearchException.toXContent(builder, params, this.cause);
                builder.endObject();
                builder.field(Fields.STATUS, (Object)this.status);
                builder.field(Fields.PRIMARY, this.primary);
                builder.endObject();
                return builder;
            }

            private static class Fields {
                private static final XContentBuilderString _INDEX = new XContentBuilderString("_index");
                private static final XContentBuilderString _SHARD = new XContentBuilderString("_shard");
                private static final XContentBuilderString _NODE = new XContentBuilderString("_node");
                private static final XContentBuilderString REASON = new XContentBuilderString("reason");
                private static final XContentBuilderString STATUS = new XContentBuilderString("status");
                private static final XContentBuilderString PRIMARY = new XContentBuilderString("primary");

                private Fields() {
                }
            }
        }
    }
}

