/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.metadata;

import java.io.IOException;
import java.util.Map;
import org.elasticsearch.ElasticsearchGenerationException;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Streamable;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.index.query.QueryBuilder;

public class AliasAction
implements Streamable {
    private Type actionType;
    private String index;
    private String alias;
    @Nullable
    private String filter;
    @Nullable
    private String indexRouting;
    @Nullable
    private String searchRouting;

    private AliasAction() {
    }

    public AliasAction(AliasAction other) {
        this.actionType = other.actionType;
        this.index = other.index;
        this.alias = other.alias;
        this.filter = other.filter;
        this.indexRouting = other.indexRouting;
        this.searchRouting = other.searchRouting;
    }

    public AliasAction(Type actionType) {
        this.actionType = actionType;
    }

    public AliasAction(Type actionType, String index, String alias) {
        this.actionType = actionType;
        this.index = index;
        this.alias = alias;
    }

    public AliasAction(Type actionType, String index, String alias, String filter) {
        this.actionType = actionType;
        this.index = index;
        this.alias = alias;
        this.filter = filter;
    }

    public Type actionType() {
        return this.actionType;
    }

    public AliasAction index(String index) {
        this.index = index;
        return this;
    }

    public String index() {
        return this.index;
    }

    public AliasAction alias(String alias) {
        this.alias = alias;
        return this;
    }

    public String alias() {
        return this.alias;
    }

    public String filter() {
        return this.filter;
    }

    public AliasAction filter(String filter) {
        this.filter = filter;
        return this;
    }

    public AliasAction filter(Map<String, Object> filter) {
        if (filter == null || filter.isEmpty()) {
            this.filter = null;
            return this;
        }
        try {
            XContentBuilder builder = XContentFactory.contentBuilder(XContentType.JSON);
            builder.map(filter);
            this.filter = builder.string();
            return this;
        }
        catch (IOException e) {
            throw new ElasticsearchGenerationException("Failed to generate [" + filter + "]", e);
        }
    }

    public AliasAction filter(QueryBuilder queryBuilder) {
        if (queryBuilder == null) {
            this.filter = null;
            return this;
        }
        try {
            XContentBuilder builder = XContentFactory.jsonBuilder();
            queryBuilder.toXContent(builder, ToXContent.EMPTY_PARAMS);
            builder.close();
            this.filter = builder.string();
            return this;
        }
        catch (IOException e) {
            throw new ElasticsearchGenerationException("Failed to build json for alias request", e);
        }
    }

    public AliasAction routing(String routing) {
        this.indexRouting = routing;
        this.searchRouting = routing;
        return this;
    }

    public String indexRouting() {
        return this.indexRouting;
    }

    public AliasAction indexRouting(String indexRouting) {
        this.indexRouting = indexRouting;
        return this;
    }

    public String searchRouting() {
        return this.searchRouting;
    }

    public AliasAction searchRouting(String searchRouting) {
        this.searchRouting = searchRouting;
        return this;
    }

    public static AliasAction readAliasAction(StreamInput in) throws IOException {
        AliasAction aliasAction = new AliasAction();
        aliasAction.readFrom(in);
        return aliasAction;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        this.actionType = Type.fromValue(in.readByte());
        this.index = in.readOptionalString();
        this.alias = in.readOptionalString();
        this.filter = in.readOptionalString();
        this.indexRouting = in.readOptionalString();
        this.searchRouting = in.readOptionalString();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeByte(this.actionType.value());
        out.writeOptionalString(this.index);
        out.writeOptionalString(this.alias);
        out.writeOptionalString(this.filter);
        out.writeOptionalString(this.indexRouting);
        out.writeOptionalString(this.searchRouting);
    }

    public static AliasAction newAddAliasAction(String index, String alias) {
        return new AliasAction(Type.ADD, index, alias);
    }

    public static AliasAction newRemoveAliasAction(String index, String alias) {
        return new AliasAction(Type.REMOVE, index, alias);
    }

    public static enum Type {
        ADD(0),
        REMOVE(1);

        private final byte value;

        private Type(byte value) {
            this.value = value;
        }

        public byte value() {
            return this.value;
        }

        public static Type fromValue(byte value) {
            if (value == 0) {
                return ADD;
            }
            if (value == 1) {
                return REMOVE;
            }
            throw new IllegalArgumentException("No type for action [" + value + "]");
        }
    }
}

