/*
 * Decompiled with CFR 0.152.
 */
package esmska.utils;

import java.awt.Dimension;
import java.text.Normalizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComponent;
import org.apache.commons.lang.StringEscapeUtils;

public class MiscUtils {
    private static final Logger logger = Logger.getLogger(MiscUtils.class.getName());

    public static String escapeHtml(String input) {
        if (input == null) {
            return input;
        }
        String output = StringEscapeUtils.escapeHtml(input);
        output = output.replaceAll("\\&scaron;", "\\&#353;");
        output = output.replaceAll("\\&Scaron;", "\\&#352;");
        output = output.replaceAll("\\&euro;", "\\&#8364;");
        return output;
    }

    public static String stripHtml(String input) {
        if (input == null) {
            return input;
        }
        String output = input.replaceAll("\\<.*?>", "");
        output = StringEscapeUtils.unescapeHtml(output);
        return output;
    }

    public static boolean isCropped(JComponent component) {
        component.revalidate();
        Dimension bounds = component.getBounds().getSize();
        Dimension visible = component.getVisibleRect().getSize();
        return !bounds.equals(visible);
    }

    public static boolean needsResize(JComponent container, Direction direction) {
        if (direction == null) {
            direction = Direction.BOTH;
        }
        container.revalidate();
        Dimension size = container.getSize();
        Dimension prefSize = container.getPreferredSize();
        boolean needWidth = size.getWidth() < prefSize.getWidth();
        boolean needHeight = size.getHeight() < prefSize.getHeight();
        switch (direction) {
            case WIDTH: {
                return needWidth;
            }
            case HEIGHT: {
                return needHeight;
            }
            case BOTH: {
                return needWidth || needHeight;
            }
        }
        String message = "Unknown direction: " + (Object)((Object)direction);
        logger.log(Level.SEVERE, message);
        throw new IllegalStateException(message);
    }

    public static String removeAccents(String text) {
        return Normalizer.normalize(text, Normalizer.Form.NFD).replaceAll("\\p{InCombiningDiacriticalMarks}+", "");
    }

    public static enum Direction {
        WIDTH,
        HEIGHT,
        BOTH;

    }
}

