/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.changedetection.state;

import java.io.EOFException;
import java.util.HashSet;
import java.util.Set;
import org.gradle.api.Action;
import org.gradle.api.internal.cache.StringInterner;
import org.gradle.api.internal.changedetection.state.FileCollectionSnapshot;
import org.gradle.api.internal.changedetection.state.TreeSnapshot;
import org.gradle.api.internal.changedetection.state.TreeSnapshotSerializer;
import org.gradle.cache.PersistentIndexedCache;
import org.gradle.cache.PersistentStore;
import org.gradle.internal.serialize.Decoder;
import org.gradle.internal.serialize.Encoder;
import org.gradle.internal.serialize.Serializer;
import org.gradle.internal.serialize.SetSerializer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TreeSnapshotRepository {
    private final PersistentIndexedCache<Long, TreeSnapshot> treeSnapshotsCache;
    private final PersistentIndexedCache<Long, Set<Long>> treeSnapshotUsageTrackingCache;
    private final PersistentIndexedCache<Long, Set<Long>> fileSnapshotToTreeSnapshotsCache;

    public TreeSnapshotRepository(PersistentStore store, StringInterner stringInterner) {
        this.treeSnapshotsCache = store.createCache("treeSnapshots", Long.class, new TreeSnapshotSerializer(stringInterner));
        this.treeSnapshotUsageTrackingCache = store.createCache("treeSnapshotUsage", Long.class, new SetSerializer((Serializer)new LongSerializer()));
        this.fileSnapshotToTreeSnapshotsCache = store.createCache("fileSnapshotsToTreeSnapshotsIndex", Long.class, new SetSerializer((Serializer)new LongSerializer()));
    }

    public TreeSnapshot getTreeSnapshot(Long id) {
        return this.treeSnapshotsCache.get(id);
    }

    public long maybeStoreTreeSnapshot(final TreeSnapshot treeSnapshot) {
        return treeSnapshot.maybeStoreEntry(new Action<Long>(){

            public void execute(Long assignedId) {
                TreeSnapshotRepository.this.treeSnapshotsCache.put(assignedId, treeSnapshot);
            }
        });
    }

    public synchronized void addTreeSnapshotUsage(FileCollectionSnapshot snapshot, long fileCollectionSnapshotId) {
        HashSet<Long> treeSnapshotIds = new HashSet<Long>(snapshot.getTreeSnapshotIds());
        for (Long treeSnapshotId : treeSnapshotIds) {
            this.addTreeSnapshotUser(treeSnapshotId, fileCollectionSnapshotId);
        }
        this.updateFileSnapshotToTreeSnapshotIndex(fileCollectionSnapshotId, treeSnapshotIds);
    }

    private void updateFileSnapshotToTreeSnapshotIndex(long fileCollectionSnapshotId, Set<Long> treeSnapshotIds) {
        Set<Long> currentTreeSnapshotIds = this.fileSnapshotToTreeSnapshotsCache.get(fileCollectionSnapshotId);
        if (currentTreeSnapshotIds == null || !currentTreeSnapshotIds.equals(treeSnapshotIds)) {
            this.fileSnapshotToTreeSnapshotsCache.put(fileCollectionSnapshotId, treeSnapshotIds);
        }
    }

    private void addTreeSnapshotUser(Long treeSnapshotId, long fileCollectionSnapshotId) {
        Set<Long> usageTracking = this.treeSnapshotUsageTrackingCache.get(treeSnapshotId);
        if (usageTracking == null) {
            usageTracking = new HashSet<Long>();
        }
        if (!usageTracking.contains(fileCollectionSnapshotId)) {
            usageTracking.add(fileCollectionSnapshotId);
            this.treeSnapshotUsageTrackingCache.put(treeSnapshotId, usageTracking);
        }
    }

    public synchronized void removeTreeSnapshotUsage(long fileCollectionSnapshotId) {
        Set<Long> treeSnapshotIds = this.fileSnapshotToTreeSnapshotsCache.get(fileCollectionSnapshotId);
        this.fileSnapshotToTreeSnapshotsCache.remove(fileCollectionSnapshotId);
        for (Long treeSnapshotId : treeSnapshotIds) {
            this.removeTreeSnapshotUsageAndMaybeRemove(fileCollectionSnapshotId, treeSnapshotId);
        }
    }

    private void removeTreeSnapshotUsageAndMaybeRemove(long fileCollectionSnapshotId, Long treeSnapshotId) {
        Set<Long> fileCollectionSnapshotIds = this.treeSnapshotUsageTrackingCache.get(treeSnapshotId);
        if (fileCollectionSnapshotIds != null && fileCollectionSnapshotIds.contains(fileCollectionSnapshotId)) {
            fileCollectionSnapshotIds.remove(fileCollectionSnapshotId);
            if (fileCollectionSnapshotIds.size() > 0) {
                this.treeSnapshotUsageTrackingCache.put(treeSnapshotId, fileCollectionSnapshotIds);
            } else {
                this.treeSnapshotUsageTrackingCache.remove(treeSnapshotId);
                this.treeSnapshotsCache.remove(treeSnapshotId);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class LongSerializer
    implements Serializer<Long> {
        private LongSerializer() {
        }

        public Long read(Decoder decoder) throws EOFException, Exception {
            return decoder.readLong();
        }

        public void write(Encoder encoder, Long value) throws Exception {
            encoder.writeLong(value.longValue());
        }
    }
}

