/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.project.taskfactory;

import java.io.File;
import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.concurrent.Callable;
import org.gradle.api.Action;
import org.gradle.api.Task;
import org.gradle.api.Transformer;
import org.gradle.api.internal.TaskInternal;
import org.gradle.api.internal.project.taskfactory.PropertyActionContext;
import org.gradle.api.internal.project.taskfactory.PropertyAnnotationHandler;
import org.gradle.api.internal.project.taskfactory.UpdateAction;
import org.gradle.api.internal.project.taskfactory.ValidationAction;
import org.gradle.internal.FileUtils;
import org.gradle.util.GFileUtils;
import org.gradle.util.GUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OutputDirectoryPropertyAnnotationHandler
implements PropertyAnnotationHandler {
    private final Class<? extends Annotation> annotationType;
    private final Transformer<Iterable<File>, Object> valueTransformer;
    private final ValidationAction outputDirValidation = new ValidationAction(){

        @Override
        public void validate(String propertyName, Object value, Collection<String> messages) {
            block0: for (File file : (Iterable)OutputDirectoryPropertyAnnotationHandler.this.valueTransformer.transform(value)) {
                if (file.exists() && !file.isDirectory()) {
                    messages.add(String.format("Directory '%s' specified for property '%s' is not a directory.", file, propertyName));
                    return;
                }
                for (File candidate = file; candidate != null && !candidate.isDirectory(); candidate = candidate.getParentFile()) {
                    if (!candidate.exists() || candidate.isDirectory()) continue;
                    messages.add(String.format("Cannot write to directory '%s' specified for property '%s', as ancestor '%s' is not a directory.", file, propertyName, candidate));
                    continue block0;
                }
            }
        }
    };

    public OutputDirectoryPropertyAnnotationHandler(Class<? extends Annotation> annotationType, Transformer<Iterable<File>, Object> valueTransformer) {
        this.annotationType = annotationType;
        this.valueTransformer = valueTransformer;
    }

    @Override
    public Class<? extends Annotation> getAnnotationType() {
        return this.annotationType;
    }

    @Override
    public void attachActions(PropertyActionContext context) {
        context.setValidationAction(this.outputDirValidation);
        context.setConfigureAction(new UpdateAction(){

            @Override
            public void update(TaskInternal task, final Callable<Object> futureValue) {
                task.getOutputs().files(futureValue);
                task.prependParallelSafeAction((Action<? super Task>)new Action<Task>(){

                    public void execute(Task task) {
                        Iterable files = (Iterable)OutputDirectoryPropertyAnnotationHandler.this.valueTransformer.transform(GUtil.uncheckedCall((Callable)futureValue));
                        for (File file : files) {
                            file = FileUtils.canonicalize((File)file);
                            GFileUtils.mkdirs(file);
                        }
                    }
                });
            }
        });
    }
}

