/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.plugins.quality;

import com.google.common.util.concurrent.Callables;
import java.io.File;
import java.util.concurrent.Callable;
import org.gradle.api.Action;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.DependencySet;
import org.gradle.api.internal.ConventionMapping;
import org.gradle.api.plugins.quality.CodeQualityExtension;
import org.gradle.api.plugins.quality.JDepend;
import org.gradle.api.plugins.quality.JDependExtension;
import org.gradle.api.plugins.quality.internal.AbstractCodeQualityPlugin;
import org.gradle.api.reporting.SingleFileReport;
import org.gradle.api.tasks.SourceSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JDependPlugin
extends AbstractCodeQualityPlugin<JDepend> {
    public static final String DEFAULT_JDEPEND_VERSION = "2.9.1";
    private JDependExtension extension;

    @Override
    protected String getToolName() {
        return "JDepend";
    }

    @Override
    protected Class<JDepend> getTaskType() {
        return JDepend.class;
    }

    @Override
    protected CodeQualityExtension createExtension() {
        this.extension = (JDependExtension)((Object)this.project.getExtensions().create("jdepend", JDependExtension.class, new Object[0]));
        this.extension.setToolVersion(DEFAULT_JDEPEND_VERSION);
        return this.extension;
    }

    @Override
    protected void configureTaskDefaults(JDepend task, String baseName) {
        Configuration configuration = this.project.getConfigurations().getAt("jdepend");
        this.configureDefaultDependencies(configuration);
        this.configureTaskConventionMapping(configuration, task);
        this.configureReportsConventionMapping(task, baseName);
    }

    private void configureDefaultDependencies(Configuration configuration) {
        configuration.defaultDependencies((Action)new Action<DependencySet>(){

            public void execute(DependencySet dependencies) {
                dependencies.add((Object)JDependPlugin.this.project.getDependencies().create((Object)("jdepend:jdepend:" + JDependPlugin.this.extension.getToolVersion())));
                dependencies.add((Object)JDependPlugin.this.project.getDependencies().create((Object)"org.apache.ant:ant-jdepend:1.9.6"));
            }
        });
    }

    private void configureTaskConventionMapping(Configuration configuration, JDepend task) {
        JDependPlugin.conventionMappingOf((Object)task).map("jdependClasspath", Callables.returning((Object)configuration));
    }

    private void configureReportsConventionMapping(JDepend task, final String baseName) {
        task.getReports().all((Action)new Action<SingleFileReport>(){

            public void execute(final SingleFileReport report) {
                ConventionMapping reportMapping = JDependPlugin.conventionMappingOf(report);
                reportMapping.map("enabled", (Callable)new Callable<Boolean>(){

                    @Override
                    public Boolean call() {
                        return report.getName().equals("xml");
                    }
                });
                reportMapping.map("destination", (Callable)new Callable<File>(){

                    @Override
                    public File call() {
                        String fileSuffix = report.getName().equals("text") ? "txt" : report.getName();
                        return new File(JDependPlugin.this.extension.getReportsDir(), baseName + "." + fileSuffix);
                    }
                });
            }
        });
    }

    @Override
    protected void configureForSourceSet(final SourceSet sourceSet, JDepend task) {
        task.dependsOn(new Object[]{sourceSet.getOutput()});
        task.setDescription("Run JDepend analysis for " + sourceSet.getName() + " classes");
        JDependPlugin.conventionMappingOf((Object)task).map("classesDir", (Callable)new Callable<File>(){

            @Override
            public File call() throws Exception {
                return sourceSet.getOutput().getClassesDir();
            }
        });
    }
}

