/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.platform.base.internal.registry;

import org.gradle.api.Nullable;
import org.gradle.model.internal.inspect.ExtractedModelRule;
import org.gradle.model.internal.inspect.MethodModelRuleExtractionContext;
import org.gradle.model.internal.inspect.MethodModelRuleExtractor;
import org.gradle.model.internal.inspect.MethodRuleDefinition;
import org.gradle.platform.base.BinaryType;
import org.gradle.platform.base.ComponentType;
import org.gradle.platform.base.LanguageType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeprecatedAnnotationsInspector
implements MethodModelRuleExtractor {
    public boolean isSatisfiedBy(MethodRuleDefinition<?, ?> definition) {
        return definition.isAnnotationPresent(BinaryType.class) || definition.isAnnotationPresent(LanguageType.class);
    }

    public String getDescription() {
        return "annotated with no longer supported BinaryType or LanguageType annotations";
    }

    @Nullable
    public <R, S> ExtractedModelRule registration(MethodRuleDefinition<R, S> ruleDefinition, MethodModelRuleExtractionContext context) {
        context.add(ruleDefinition, this.deprecationMessageFor(ruleDefinition));
        return null;
    }

    private <R, S> String deprecationMessageFor(MethodRuleDefinition<R, S> ruleDefinition) {
        Class annotation = ruleDefinition.isAnnotationPresent(BinaryType.class) ? BinaryType.class : LanguageType.class;
        return String.format("Annotation %s is no longer supported. Please replace it with %s.", annotation.getSimpleName(), ComponentType.class.getSimpleName());
    }
}

