/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.resolveengine.excludes;

import org.apache.ivy.core.module.id.ArtifactId;
import org.gradle.api.artifacts.ModuleIdentifier;
import org.gradle.api.internal.artifacts.DefaultModuleIdentifier;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.excludes.AbstractModuleExcludeRuleFilter;
import org.gradle.internal.component.model.DefaultIvyArtifactName;
import org.gradle.internal.component.model.IvyArtifactName;

class ArtifactExcludeSpec
extends AbstractModuleExcludeRuleFilter {
    private final ModuleIdentifier moduleId;
    private final IvyArtifactName ivyArtifactName;

    ArtifactExcludeSpec(ArtifactId artifactId) {
        this.moduleId = DefaultModuleIdentifier.newId(artifactId.getModuleId().getOrganisation(), artifactId.getModuleId().getName());
        this.ivyArtifactName = new DefaultIvyArtifactName(artifactId.getName(), artifactId.getType(), artifactId.getExt());
    }

    public String toString() {
        return String.format("{artifact %s:%s}", this.moduleId, this.ivyArtifactName);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || o.getClass() != this.getClass()) {
            return false;
        }
        ArtifactExcludeSpec other = (ArtifactExcludeSpec)o;
        return this.moduleId.equals(other.moduleId) && this.ivyArtifactName.equals(other.ivyArtifactName);
    }

    public int hashCode() {
        return this.moduleId.hashCode() ^ this.ivyArtifactName.hashCode();
    }

    protected boolean doAcceptsSameModulesAs(AbstractModuleExcludeRuleFilter other) {
        return true;
    }

    protected boolean acceptsAllModules() {
        return true;
    }

    public boolean acceptModule(ModuleIdentifier module) {
        return true;
    }

    public boolean acceptArtifact(ModuleIdentifier module, IvyArtifactName artifact) {
        return !this.matches(this.moduleId.getGroup(), module.getGroup()) || !this.matches(this.moduleId.getName(), module.getName()) || !this.matches(this.ivyArtifactName.getName(), artifact.getName()) || !this.matches(this.ivyArtifactName.getExtension(), artifact.getExtension()) || !this.matches(this.ivyArtifactName.getType(), artifact.getType());
    }

    public boolean acceptsAllArtifacts() {
        return false;
    }

    private boolean matches(String expression, String input) {
        return ArtifactExcludeSpec.isWildcard(expression) || expression.equals(input);
    }
}

