/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.language.scala.internal;

import org.gradle.language.scala.ScalaPlatform;
import org.gradle.util.VersionNumber;

public class DefaultScalaPlatform
implements ScalaPlatform {
    private final String scalaCompatibilityVersion;
    private final String scalaVersion;

    public DefaultScalaPlatform() {
        this("2.10.4");
    }

    public DefaultScalaPlatform(String scalaVersion) {
        this(VersionNumber.parse((String)scalaVersion));
    }

    public DefaultScalaPlatform(VersionNumber versionNumber) {
        this.scalaVersion = versionNumber.getMajor() + "." + versionNumber.getMinor() + "." + versionNumber.getMicro();
        this.scalaCompatibilityVersion = versionNumber.getMajor() + "." + versionNumber.getMinor();
    }

    public String getScalaVersion() {
        return this.scalaVersion;
    }

    public String getScalaCompatibilityVersion() {
        return this.scalaCompatibilityVersion;
    }

    public String getDisplayName() {
        return "Scala Platform (Scala " + this.scalaVersion + ")";
    }

    public String getName() {
        return "ScalaPlatform" + this.scalaVersion;
    }
}

