/*
 * Decompiled with CFR 0.152.
 */
package org.springsource.loaded;

import org.springsource.loaded.Constants;
import org.springsource.loaded.MethodInvokerRewriter;
import sl.org.objectweb.asm.ClassReader;
import sl.org.objectweb.asm.ClassVisitor;
import sl.org.objectweb.asm.ClassWriter;
import sl.org.objectweb.asm.MethodVisitor;
import sl.org.objectweb.asm.Opcodes;

public class SystemClassReflectionInvestigator {
    public static int investigate(String slashedClassName, byte[] bytes, boolean print) {
        ClassReader fileReader = new ClassReader(bytes);
        RewriteClassAdaptor classAdaptor = new RewriteClassAdaptor(print);
        fileReader.accept(classAdaptor, 4);
        return classAdaptor.hitCount;
    }

    static class RewriteClassAdaptor
    extends ClassVisitor
    implements Constants {
        int hitCount = 0;
        private ClassWriter cw;
        int bits = 0;
        private boolean print;
        private String classname;

        private static boolean isInterceptable(String owner, String methodName) {
            return MethodInvokerRewriter.RewriteClassAdaptor.intercepted.contains(owner + "." + methodName);
        }

        public RewriteClassAdaptor(boolean print) {
            super(327680, new ClassWriter(1));
            this.print = print;
            this.cw = (ClassWriter)this.cv;
        }

        public byte[] getBytes() {
            byte[] bytes = this.cw.toByteArray();
            return bytes;
        }

        public int getBits() {
            return this.bits;
        }

        public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
            super.visit(version, access, name, signature, superName, interfaces);
            this.classname = name;
        }

        public MethodVisitor visitMethod(int flags, String name, String descriptor, String signature, String[] exceptions) {
            MethodVisitor mv = super.visitMethod(flags, name, descriptor, signature, exceptions);
            return new RewritingMethodAdapter(mv);
        }

        class RewritingMethodAdapter
        extends MethodVisitor
        implements Opcodes,
        Constants {
            int unitializedObjectsCount;

            public RewritingMethodAdapter(MethodVisitor mv) {
                super(327680, mv);
                this.unitializedObjectsCount = 0;
            }

            private boolean interceptReflection(String owner, String name, String desc) {
                if (RewriteClassAdaptor.isInterceptable(owner, name)) {
                    ++RewriteClassAdaptor.this.hitCount;
                    if (RewriteClassAdaptor.this.print) {
                        System.out.println("SystemClassReflectionInvestigator: " + RewriteClassAdaptor.this.classname + "  uses " + owner + "." + name + desc);
                    }
                }
                return false;
            }

            public void visitTypeInsn(int opcode, String type) {
                if (opcode == 187) {
                    ++this.unitializedObjectsCount;
                }
                super.visitTypeInsn(opcode, type);
            }

            public void visitMethodInsn(int opcode, String owner, String name, String desc, boolean itf) {
                if (this.rewriteReflectiveCall(opcode, owner, name, desc)) {
                    return;
                }
                if (opcode == 183) {
                    --this.unitializedObjectsCount;
                }
                super.visitMethodInsn(opcode, owner, name, desc, itf);
            }

            private boolean rewriteReflectiveCall(int opcode, String owner, String name, String desc) {
                boolean rewritten;
                return owner.length() > 10 && owner.charAt(8) == 'g' && (owner.startsWith("java/lang/reflect/") || owner.equals("java/lang/Class")) && (rewritten = this.interceptReflection(owner, name, desc));
            }
        }
    }
}

