/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.pluginmgr;

import java.util.Stack;
import org.gjt.sp.jedit.options.PluginOptions;
import org.gjt.sp.jedit.pluginmgr.MirrorList;
import org.gjt.sp.util.Log;
import org.gjt.sp.util.XMLUtilities;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.helpers.DefaultHandler;

class MirrorListHandler
extends DefaultHandler {
    private String id;
    private final StringBuilder description = new StringBuilder();
    private final StringBuilder location = new StringBuilder();
    private final StringBuilder country = new StringBuilder();
    private final StringBuilder continent = new StringBuilder();
    private final MirrorList mirrors;
    private MirrorList.Mirror mirror;
    private final Stack<String> stateStack = new Stack();
    private final String path;

    MirrorListHandler(MirrorList mirrorList, String string) {
        this.mirrors = mirrorList;
        this.path = string;
    }

    @Override
    public InputSource resolveEntity(String string, String string2) {
        return XMLUtilities.findEntity(string2, "mirrors.dtd", PluginOptions.class);
    }

    @Override
    public void characters(char[] cArray, int n, int n2) {
        String string = this.peekElement();
        if (string == "DESCRIPTION") {
            this.description.append(cArray, n, n2);
        } else if (string == "LOCATION") {
            this.location.append(cArray, n, n2);
        } else if (string == "COUNTRY") {
            this.country.append(cArray, n, n2);
        } else if (string == "CONTINENT") {
            this.continent.append(cArray, n, n2);
        }
    }

    @Override
    public void startElement(String string, String string2, String string3, Attributes attributes) {
        if ((string3 = this.pushElement(string3)).equals("MIRROR")) {
            this.mirror = new MirrorList.Mirror();
            this.id = attributes.getValue("ID");
        }
    }

    @Override
    public void endElement(String string, String string2, String string3) {
        this.popElement();
        if (string3.equals("MIRROR")) {
            this.mirror.id = this.id;
            this.mirror.description = this.description.toString();
            this.mirror.location = this.location.toString();
            this.mirror.country = this.country.toString();
            this.mirror.continent = this.continent.toString();
            this.mirrors.add(this.mirror);
            this.description.setLength(0);
            this.location.setLength(0);
            this.country.setLength(0);
            this.continent.setLength(0);
        }
    }

    @Override
    public void startDocument() {
        try {
            this.pushElement(null);
        }
        catch (Exception exception) {
            Log.log(9, this, exception);
        }
    }

    @Override
    public void endDocument() {
        this.mirrors.finished();
    }

    private String pushElement(String string) {
        string = string == null ? null : string.intern();
        this.stateStack.push(string);
        return string;
    }

    private String peekElement() {
        return this.stateStack.peek();
    }

    private void popElement() {
        this.stateStack.pop();
    }
}

