/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.core.rope;

import com.oracle.truffle.api.object.DynamicObject;
import org.jruby.truffle.core.rope.CodeRange;
import org.jruby.truffle.core.rope.LeafRope;
import org.jruby.truffle.core.rope.Rope;
import org.jruby.truffle.core.rope.RopeBuffer;
import org.jruby.truffle.core.string.StringOperations;
import org.jruby.truffle.language.RubyGuards;

public class RopeGuards {
    public static boolean isSingleByteString(Rope rope) {
        return rope.byteLength() == 1;
    }

    public static boolean is7Bit(Rope rope) {
        return rope.getCodeRange() == CodeRange.CR_7BIT;
    }

    public static boolean isRopeBuffer(Rope rope) {
        return rope instanceof RopeBuffer;
    }

    protected boolean isRopeBuffer(DynamicObject string) {
        assert (RubyGuards.isRubyString(string));
        return StringOperations.rope(string) instanceof RopeBuffer;
    }

    public static boolean isLeafRope(Rope rope) {
        return rope instanceof LeafRope;
    }
}

