/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.language.parser.jruby;

import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.source.Source;
import com.oracle.truffle.api.source.SourceSection;
import java.util.ArrayList;
import org.jruby.ast.ArgsNode;
import org.jruby.ast.ArgumentNode;
import org.jruby.ast.MultipleAsgnNode;
import org.jruby.ast.OptArgNode;
import org.jruby.ast.RestArgNode;
import org.jruby.ast.visitor.NodeVisitor;
import org.jruby.truffle.RubyContext;
import org.jruby.truffle.language.RubyNode;
import org.jruby.truffle.language.arguments.MissingArgumentBehavior;
import org.jruby.truffle.language.arguments.ReadPreArgumentNode;
import org.jruby.truffle.language.control.SequenceNode;
import org.jruby.truffle.language.parser.jruby.BodyTranslator;
import org.jruby.truffle.language.parser.jruby.Translator;

public class ReloadArgumentsTranslator
extends Translator {
    private final BodyTranslator methodBodyTranslator;
    private int index = 0;
    private boolean hasRestParameter = false;

    public ReloadArgumentsTranslator(Node currentNode, RubyContext context, Source source, BodyTranslator methodBodyTranslator) {
        super(currentNode, context, source);
        this.methodBodyTranslator = methodBodyTranslator;
    }

    public RubyNode visitArgsNode(ArgsNode node) {
        int optArgsCount;
        SourceSection sourceSection = this.translate(node.getPosition());
        ArrayList<Object> sequence = new ArrayList<Object>();
        org.jruby.ast.Node[] args = node.getArgs();
        int preCount = node.getPreCount();
        if (preCount > 0) {
            for (int i = 0; i < preCount; ++i) {
                sequence.add(args[i].accept((NodeVisitor)this));
                ++this.index;
            }
        }
        if ((optArgsCount = node.getOptionalArgsCount()) > 0) {
            int optArgsIndex = node.getOptArgIndex();
            for (int i = 0; i < optArgsCount; ++i) {
                sequence.add(args[optArgsIndex + i].accept((NodeVisitor)this));
                ++this.index;
            }
        }
        if (node.hasRestArg()) {
            this.hasRestParameter = true;
            sequence.add(node.getRestArgNode().accept((NodeVisitor)this));
        }
        if (node.getPostCount() > 0) {
            System.err.println("WARNING: post args in zsuper not yet implemented at " + sourceSection.getShortDescription());
        }
        if (node.hasKwargs() && !sourceSection.getSource().getPath().endsWith("/language/fixtures/super.rb")) {
            System.err.println("WARNING: kwargs in zsuper not yet implemented at " + sourceSection.getShortDescription());
        }
        return new SequenceNode(this.context, sourceSection, sequence.toArray(new RubyNode[sequence.size()]));
    }

    public RubyNode visitArgumentNode(ArgumentNode node) {
        SourceSection sourceSection = this.translate(node.getPosition());
        return this.methodBodyTranslator.getEnvironment().findLocalVarNode(node.getName(), sourceSection);
    }

    public RubyNode visitOptArgNode(OptArgNode node) {
        SourceSection sourceSection = this.translate(node.getPosition());
        return this.methodBodyTranslator.getEnvironment().findLocalVarNode(node.getName(), sourceSection);
    }

    public RubyNode visitMultipleAsgnNode(MultipleAsgnNode node) {
        SourceSection sourceSection = this.translate(node.getPosition());
        return new ReadPreArgumentNode(this.index, MissingArgumentBehavior.NIL);
    }

    public RubyNode visitRestArgNode(RestArgNode node) {
        SourceSection sourceSection = this.translate(node.getPosition());
        return this.methodBodyTranslator.getEnvironment().findLocalVarNode(node.getName(), sourceSection);
    }

    protected RubyNode defaultVisit(org.jruby.ast.Node node) {
        SourceSection sourceSection = this.translate(node.getPosition());
        return this.nilNode(sourceSection);
    }

    @Override
    protected String getIdentifier() {
        return this.methodBodyTranslator.getIdentifier();
    }

    public boolean isSplatted() {
        return this.hasRestParameter;
    }
}

