/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.validation;

import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtOperationReferenceExpression;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.tasks.DynamicCallsKt;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.validation.SymbolUsageValidator;
import org.jetbrains.kotlin.types.ErrorUtils;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \r2\u00020\u0001:\u0001\rB\u0005\u00a2\u0006\u0002\u0010\u0002J.\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/resolve/validation/InfixValidator;", "Lorg/jetbrains/kotlin/resolve/validation/SymbolUsageValidator;", "()V", "validateCall", "", "resolvedCall", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "targetDescriptor", "Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;", "trace", "Lorg/jetbrains/kotlin/resolve/BindingTrace;", "element", "Lcom/intellij/psi/PsiElement;", "Companion", "kotlin-compiler"})
public final class InfixValidator
implements SymbolUsageValidator {
    public static final Companion Companion = new Companion(null);

    @Override
    public void validateCall(@Nullable ResolvedCall<?> resolvedCall2, @NotNull CallableDescriptor targetDescriptor, @NotNull BindingTrace trace, @NotNull PsiElement element) {
        Intrinsics.checkParameterIsNotNull(targetDescriptor, "targetDescriptor");
        Intrinsics.checkParameterIsNotNull(trace, "trace");
        Intrinsics.checkParameterIsNotNull(element, "element");
        CallableDescriptor callableDescriptor = targetDescriptor;
        if (!(callableDescriptor instanceof FunctionDescriptor)) {
            callableDescriptor = null;
        }
        FunctionDescriptor functionDescriptor = (FunctionDescriptor)callableDescriptor;
        if (functionDescriptor == null) {
            return;
        }
        FunctionDescriptor functionDescriptor2 = functionDescriptor;
        if (DynamicCallsKt.isDynamic(functionDescriptor2) || ErrorUtils.isError(functionDescriptor2)) {
            return;
        }
        if (Companion.isInfixCall(element) && !functionDescriptor2.isInfix()) {
            PsiElement psiElement = element;
            if (!(psiElement instanceof KtOperationReferenceExpression)) {
                psiElement = null;
            }
            KtOperationReferenceExpression ktOperationReferenceExpression = (KtOperationReferenceExpression)psiElement;
            if (ktOperationReferenceExpression == null) {
                return;
            }
            KtOperationReferenceExpression operationRefExpression = ktOperationReferenceExpression;
            String containingDeclarationName = DescriptorUtilsKt.getFqNameUnsafe(functionDescriptor2.getContainingDeclaration()).asString();
            trace.report(Errors.INFIX_MODIFIER_REQUIRED.on((KtOperationReferenceExpression)((PsiElement)operationRefExpression), functionDescriptor2, containingDeclarationName));
        }
    }

    @Override
    public void validateTypeUsage(@NotNull ClassifierDescriptor targetDescriptor, @NotNull BindingTrace trace, @NotNull PsiElement element) {
        Intrinsics.checkParameterIsNotNull(targetDescriptor, "targetDescriptor");
        Intrinsics.checkParameterIsNotNull(trace, "trace");
        Intrinsics.checkParameterIsNotNull(element, "element");
        SymbolUsageValidator.DefaultImpls.validateTypeUsage(this, targetDescriptor, trace, element);
    }

    @Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/resolve/validation/InfixValidator$Companion;", "", "()V", "isInfixCall", "", "element", "Lcom/intellij/psi/PsiElement;", "kotlin-compiler"})
    public static final class Companion {
        public final boolean isInfixCall(@Nullable PsiElement element) {
            PsiElement psiElement = element;
            if (!(psiElement instanceof KtOperationReferenceExpression)) {
                psiElement = null;
            }
            KtOperationReferenceExpression ktOperationReferenceExpression = (KtOperationReferenceExpression)psiElement;
            if (ktOperationReferenceExpression == null) {
                return false;
            }
            KtOperationReferenceExpression operationRefExpression = ktOperationReferenceExpression;
            PsiElement psiElement2 = operationRefExpression.getParent();
            if (!(psiElement2 instanceof KtBinaryExpression)) {
                psiElement2 = null;
            }
            KtBinaryExpression ktBinaryExpression = (KtBinaryExpression)psiElement2;
            if (ktBinaryExpression == null) {
                return false;
            }
            KtBinaryExpression binaryExpression = ktBinaryExpression;
            return binaryExpression.getOperationReference() == operationRefExpression && !operationRefExpression.isPredefinedOperator();
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

