/*
 * Decompiled with CFR 0.152.
 */
package org.encog.ml.kmeans;

import java.util.ArrayList;
import org.encog.ml.MLCluster;
import org.encog.ml.MLClustering;
import org.encog.ml.data.MLDataPair;
import org.encog.ml.data.MLDataSet;
import org.encog.ml.data.basic.BasicMLDataPair;
import org.encog.ml.kmeans.BasicCluster;
import org.encog.util.kmeans.KMeansUtil;

public class KMeansClustering
implements MLClustering {
    private KMeansUtil<BasicMLDataPair> kmeans;
    private MLCluster[] clusters;
    private int k;

    public KMeansClustering(int theK, MLDataSet theSet) {
        ArrayList<BasicMLDataPair> list = new ArrayList<BasicMLDataPair>();
        for (MLDataPair pair : theSet) {
            list.add((BasicMLDataPair)pair);
        }
        this.k = theK;
        this.kmeans = new KMeansUtil(this.k, list);
    }

    @Override
    public final void iteration() {
        this.kmeans.process();
        this.clusters = new MLCluster[this.k];
        for (int i = 0; i < this.k; ++i) {
            this.clusters[i] = new BasicCluster(this.kmeans.getCluster(i));
        }
    }

    @Override
    public final void iteration(int count) {
        for (int i = 0; i < count; ++i) {
            this.iteration();
        }
    }

    @Override
    public MLCluster[] getClusters() {
        return this.clusters;
    }

    @Override
    public int numClusters() {
        return this.k;
    }
}

