/*
 * Decompiled with CFR 0.152.
 */
package org.libreoffice.report.pentaho.parser.rpt;

import java.util.ArrayList;
import java.util.List;
import org.jfree.report.structure.Element;
import org.jfree.report.structure.Section;
import org.libreoffice.report.pentaho.model.OfficeReport;
import org.libreoffice.report.pentaho.parser.ElementReadHandler;
import org.libreoffice.report.pentaho.parser.chart.ChartReadHandler;
import org.libreoffice.report.pentaho.parser.rpt.DetailRootTableReadHandler;
import org.libreoffice.report.pentaho.parser.rpt.FunctionReadHandler;
import org.libreoffice.report.pentaho.parser.rpt.GroupReadHandler;
import org.libreoffice.report.pentaho.parser.rpt.RootTableReadHandler;
import org.pentaho.reporting.libraries.xmlns.parser.AbstractXmlReadHandler;
import org.pentaho.reporting.libraries.xmlns.parser.XmlReadHandler;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReportReadHandler
extends ElementReadHandler {
    private RootTableReadHandler pageHeader;
    private RootTableReadHandler pageFooter;
    private RootTableReadHandler reportHeader;
    private RootTableReadHandler reportFooter;
    private RootTableReadHandler detail;
    private GroupReadHandler groups;
    private final OfficeReport rootSection = new OfficeReport();
    private final List<FunctionReadHandler> functionHandlers;
    private final List<ElementReadHandler> preBodyHandlers;
    private final List<ElementReadHandler> postBodyHandlers;
    private boolean pre = true;

    public ReportReadHandler() {
        this.rootSection.setAttribute("http://jfreereport.sourceforge.net/namespaces/engine", "simple-report-structure", Boolean.TRUE);
        this.functionHandlers = new ArrayList<FunctionReadHandler>();
        this.preBodyHandlers = new ArrayList<ElementReadHandler>();
        this.postBodyHandlers = new ArrayList<ElementReadHandler>();
    }

    protected XmlReadHandler getHandlerForChild(String uri, String tagName, Attributes atts) throws SAXException {
        AbstractXmlReadHandler erh;
        if ("urn:oasis:names:tc:opendocument:xmlns:chart:1.0".equals(uri)) {
            ChartReadHandler crh = new ChartReadHandler(this);
            if (this.pre) {
                this.preBodyHandlers.add(crh);
            } else {
                this.postBodyHandlers.add(crh);
            }
            erh = crh;
        } else if ("http://openoffice.org/2005/report".equals(uri)) {
            if ("function".equals(tagName)) {
                FunctionReadHandler frh = new FunctionReadHandler();
                this.functionHandlers.add(frh);
                erh = frh;
            } else if ("page-header".equals(tagName)) {
                this.pageHeader = new RootTableReadHandler();
                erh = this.pageHeader;
            } else if ("report-header".equals(tagName)) {
                this.reportHeader = new RootTableReadHandler();
                erh = this.reportHeader;
            } else if ("report-footer".equals(tagName)) {
                this.reportFooter = new RootTableReadHandler();
                erh = this.reportFooter;
            } else if ("page-footer".equals(tagName)) {
                this.pageFooter = new RootTableReadHandler();
                erh = this.pageFooter;
            } else if ("detail".equals(tagName)) {
                this.pre = false;
                this.detail = new DetailRootTableReadHandler();
                erh = this.detail;
            } else if ("group".equals(tagName)) {
                this.groups = new GroupReadHandler(this);
                erh = this.groups;
            } else {
                erh = null;
            }
        } else {
            erh = null;
        }
        return erh;
    }

    protected void doneParsing() throws SAXException {
        Section preBody;
        if (this.pageHeader != null) {
            this.rootSection.setPageHeader(this.pageHeader.getElement());
        }
        if (this.pageFooter != null) {
            this.rootSection.setPageFooter(this.pageFooter.getElement());
        }
        if (this.reportHeader != null) {
            this.rootSection.setReportHeader(this.reportHeader.getElement());
        }
        if ((preBody = this.createSection("report-pre-body", this.preBodyHandlers)) != null) {
            this.rootSection.setPreBodySection(preBody);
        }
        Section groupBody = new Section();
        groupBody.setNamespace("http://jfreereport.sourceforge.net/namespaces/engine");
        groupBody.setType("report-body");
        this.rootSection.setBodySection(groupBody);
        if (this.groups != null) {
            groupBody.addNode(this.groups.getElement());
        } else if (this.detail != null) {
            groupBody.addNode(this.detail.getElement());
        }
        Section postBody = this.createSection("report-post-body", this.postBodyHandlers);
        if (postBody != null) {
            this.rootSection.setPostBodySection(postBody);
        }
        if (this.reportFooter != null) {
            this.rootSection.setReportFooter(this.reportFooter.getElement());
        }
        for (int i = 0; i < this.functionHandlers.size(); ++i) {
            FunctionReadHandler handler = this.functionHandlers.get(i);
            this.rootSection.addExpression(handler.getExpression());
        }
    }

    @Override
    public Element getElement() {
        return this.rootSection;
    }

    private final Section createSection(String name, List<ElementReadHandler> handler) {
        if (!handler.isEmpty()) {
            Section section = new Section();
            section.setNamespace("http://jfreereport.sourceforge.net/namespaces/engine");
            section.setType(name);
            for (int i = 0; i < handler.size(); ++i) {
                ElementReadHandler erh = handler.get(i);
                section.addNode(erh.getElement());
            }
            return section;
        }
        return null;
    }

    public void setDetail(RootTableReadHandler detail) {
        this.detail = detail;
    }

    public final RootTableReadHandler getDetail() {
        return this.detail;
    }
}

