{%MainUnit ../lconvencoding.pp}

{******************************************************************************
                         Asian Unicode Conversion Tables
 ******************************************************************************

 *****************************************************************************
  This file is part of the Lazarus Component Library (LCL)

  See the file COPYING.modifiedLGPL.txt, included in this distribution,
  for details about the license.
 *****************************************************************************
}
type  
CP936Arr = array[0..22046] of word;
CP950Arr = array[0..13758] of word;
CP949Arr = array[0..17303] of word;
CP932Arr = array[0..7979] of word;

const CP936CC: CP936Arr =
($00,$01,$02,$03,$04,$05,$06,$07,$08,$09,$0A,$0B,$0C,$0D,$0E,$0F,$10,$11,$12,
$13,$14,$15,$16,$17,$18,$19,$1A,$1B,$1C,$1D,$1E,$1F,$20,$21,$22,$23,$24,$25,
$26,$27,$28,$29,$2A,$2B,$2C,$2D,$2E,$2F,$30,$31,$32,$33,$34,$35,$36,$37,$38,
$39,$3A,$3B,$3C,$3D,$3E,$3F,$40,$41,$42,$43,$44,$45,$46,$47,$48,$49,$4A,$4B,
$4C,$4D,$4E,$4F,$50,$51,$52,$53,$54,$55,$56,$57,$58,$59,$5A,$5B,$5C,$5D,$5E,
$5F,$60,$61,$62,$63,$64,$65,$66,$67,$68,$69,$6A,$6B,$6C,$6D,$6E,$6F,$70,$71,
$72,$73,$74,$75,$76,$77,$78,$79,$7A,$7B,$7C,$7D,$7E,$7F,$80,$81,$82,$83,$84,
$85,$86,$87,$88,$89,$8A,$8B,$8C,$8D,$8E,$8F,$90,$91,$92,$93,$94,$95,$96,$97,
$98,$99,$9A,$9B,$9C,$9D,$9E,$9F,$A0,$A1,$A2,$A3,$A4,$A5,$A6,$A7,$A8,$A9,$AA,
$AB,$AC,$AD,$AE,$AF,$B0,$B1,$B2,$B3,$B4,$B5,$B6,$B7,$B8,$B9,$BA,$BB,$BC,$BD,
$BE,$BF,$C0,$C1,$C2,$C3,$C4,$C5,$C6,$C7,$C8,$C9,$CA,$CB,$CC,$CD,$CE,$CF,$D0,
$D1,$D2,$D3,$D4,$D5,$D6,$D7,$D8,$D9,$DA,$DB,$DC,$DD,$DE,$DF,$E0,$E1,$E2,$E3,
$E4,$E5,$E6,$E7,$E8,$E9,$EA,$EB,$EC,$ED,$EE,$EF,$F0,$F1,$F2,$F3,$F4,$F5,$F6,
$F7,$F8,$F9,$FA,$FB,$FC,$FD,$FE,$FF,$8140,$8141,$8142,$8143,$8144,$8145,$8146,
$8147,$8148,$8149,$814A,$814B,$814C,$814D,$814E,$814F,$8150,$8151,$8152,$8153,
$8154,$8155,$8156,$8157,$8158,$8159,$815A,$815B,$815C,$815D,$815E,$815F,$8160,
$8161,$8162,$8163,$8164,$8165,$8166,$8167,$8168,$8169,$816A,$816B,$816C,$816D,
$816E,$816F,$8170,$8171,$8172,$8173,$8174,$8175,$8176,$8177,$8178,$8179,$817A,
$817B,$817C,$817D,$817E,$8180,$8181,$8182,$8183,$8184,$8185,$8186,$8187,$8188,
$8189,$818A,$818B,$818C,$818D,$818E,$818F,$8190,$8191,$8192,$8193,$8194,$8195,
$8196,$8197,$8198,$8199,$819A,$819B,$819C,$819D,$819E,$819F,$81A0,$81A1,$81A2,
$81A3,$81A4,$81A5,$81A6,$81A7,$81A8,$81A9,$81AA,$81AB,$81AC,$81AD,$81AE,$81AF,
$81B0,$81B1,$81B2,$81B3,$81B4,$81B5,$81B6,$81B7,$81B8,$81B9,$81BA,$81BB,$81BC,
$81BD,$81BE,$81BF,$81C0,$81C1,$81C2,$81C3,$81C4,$81C5,$81C6,$81C7,$81C8,$81C9,
$81CA,$81CB,$81CC,$81CD,$81CE,$81CF,$81D0,$81D1,$81D2,$81D3,$81D4,$81D5,$81D6,
$81D7,$81D8,$81D9,$81DA,$81DB,$81DC,$81DD,$81DE,$81DF,$81E0,$81E1,$81E2,$81E3,
$81E4,$81E5,$81E6,$81E7,$81E8,$81E9,$81EA,$81EB,$81EC,$81ED,$81EE,$81EF,$81F0,
$81F1,$81F2,$81F3,$81F4,$81F5,$81F6,$81F7,$81F8,$81F9,$81FA,$81FB,$81FC,$81FD,
$81FE,$8240,$8241,$8242,$8243,$8244,$8245,$8246,$8247,$8248,$8249,$824A,$824B,
$824C,$824D,$824E,$824F,$8250,$8251,$8252,$8253,$8254,$8255,$8256,$8257,$8258,
$8259,$825A,$825B,$825C,$825D,$825E,$825F,$8260,$8261,$8262,$8263,$8264,$8265,
$8266,$8267,$8268,$8269,$826A,$826B,$826C,$826D,$826E,$826F,$8270,$8271,$8272,
$8273,$8274,$8275,$8276,$8277,$8278,$8279,$827A,$827B,$827C,$827D,$827E,$8280,
$8281,$8282,$8283,$8284,$8285,$8286,$8287,$8288,$8289,$828A,$828B,$828C,$828D,
$828E,$828F,$8290,$8291,$8292,$8293,$8294,$8295,$8296,$8297,$8298,$8299,$829A,
$829B,$829C,$829D,$829E,$829F,$82A0,$82A1,$82A2,$82A3,$82A4,$82A5,$82A6,$82A7,
$82A8,$82A9,$82AA,$82AB,$82AC,$82AD,$82AE,$82AF,$82B0,$82B1,$82B2,$82B3,$82B4,
$82B5,$82B6,$82B7,$82B8,$82B9,$82BA,$82BB,$82BC,$82BD,$82BE,$82BF,$82C0,$82C1,
$82C2,$82C3,$82C4,$82C5,$82C6,$82C7,$82C8,$82C9,$82CA,$82CB,$82CC,$82CD,$82CE,
$82CF,$82D0,$82D1,$82D2,$82D3,$82D4,$82D5,$82D6,$82D7,$82D8,$82D9,$82DA,$82DB,
$82DC,$82DD,$82DE,$82DF,$82E0,$82E1,$82E2,$82E3,$82E4,$82E5,$82E6,$82E7,$82E8,
$82E9,$82EA,$82EB,$82EC,$82ED,$82EE,$82EF,$82F0,$82F1,$82F2,$82F3,$82F4,$82F5,
$82F6,$82F7,$82F8,$82F9,$82FA,$82FB,$82FC,$82FD,$82FE,$8340,$8341,$8342,$8343,
$8344,$8345,$8346,$8347,$8348,$8349,$834A,$834B,$834C,$834D,$834E,$834F,$8350,
$8351,$8352,$8353,$8354,$8355,$8356,$8357,$8358,$8359,$835A,$835B,$835C,$835D,
$835E,$835F,$8360,$8361,$8362,$8363,$8364,$8365,$8366,$8367,$8368,$8369,$836A,
$836B,$836C,$836D,$836E,$836F,$8370,$8371,$8372,$8373,$8374,$8375,$8376,$8377,
$8378,$8379,$837A,$837B,$837C,$837D,$837E,$8380,$8381,$8382,$8383,$8384,$8385,
$8386,$8387,$8388,$8389,$838A,$838B,$838C,$838D,$838E,$838F,$8390,$8391,$8392,
$8393,$8394,$8395,$8396,$8397,$8398,$8399,$839A,$839B,$839C,$839D,$839E,$839F,
$83A0,$83A1,$83A2,$83A3,$83A4,$83A5,$83A6,$83A7,$83A8,$83A9,$83AA,$83AB,$83AC,
$83AD,$83AE,$83AF,$83B0,$83B1,$83B2,$83B3,$83B4,$83B5,$83B6,$83B7,$83B8,$83B9,
$83BA,$83BB,$83BC,$83BD,$83BE,$83BF,$83C0,$83C1,$83C2,$83C3,$83C4,$83C5,$83C6,
$83C7,$83C8,$83C9,$83CA,$83CB,$83CC,$83CD,$83CE,$83CF,$83D0,$83D1,$83D2,$83D3,
$83D4,$83D5,$83D6,$83D7,$83D8,$83D9,$83DA,$83DB,$83DC,$83DD,$83DE,$83DF,$83E0,
$83E1,$83E2,$83E3,$83E4,$83E5,$83E6,$83E7,$83E8,$83E9,$83EA,$83EB,$83EC,$83ED,
$83EE,$83EF,$83F0,$83F1,$83F2,$83F3,$83F4,$83F5,$83F6,$83F7,$83F8,$83F9,$83FA,
$83FB,$83FC,$83FD,$83FE,$8440,$8441,$8442,$8443,$8444,$8445,$8446,$8447,$8448,
$8449,$844A,$844B,$844C,$844D,$844E,$844F,$8450,$8451,$8452,$8453,$8454,$8455,
$8456,$8457,$8458,$8459,$845A,$845B,$845C,$845D,$845E,$845F,$8460,$8461,$8462,
$8463,$8464,$8465,$8466,$8467,$8468,$8469,$846A,$846B,$846C,$846D,$846E,$846F,
$8470,$8471,$8472,$8473,$8474,$8475,$8476,$8477,$8478,$8479,$847A,$847B,$847C,
$847D,$847E,$8480,$8481,$8482,$8483,$8484,$8485,$8486,$8487,$8488,$8489,$848A,
$848B,$848C,$848D,$848E,$848F,$8490,$8491,$8492,$8493,$8494,$8495,$8496,$8497,
$8498,$8499,$849A,$849B,$849C,$849D,$849E,$849F,$84A0,$84A1,$84A2,$84A3,$84A4,
$84A5,$84A6,$84A7,$84A8,$84A9,$84AA,$84AB,$84AC,$84AD,$84AE,$84AF,$84B0,$84B1,
$84B2,$84B3,$84B4,$84B5,$84B6,$84B7,$84B8,$84B9,$84BA,$84BB,$84BC,$84BD,$84BE,
$84BF,$84C0,$84C1,$84C2,$84C3,$84C4,$84C5,$84C6,$84C7,$84C8,$84C9,$84CA,$84CB,
$84CC,$84CD,$84CE,$84CF,$84D0,$84D1,$84D2,$84D3,$84D4,$84D5,$84D6,$84D7,$84D8,
$84D9,$84DA,$84DB,$84DC,$84DD,$84DE,$84DF,$84E0,$84E1,$84E2,$84E3,$84E4,$84E5,
$84E6,$84E7,$84E8,$84E9,$84EA,$84EB,$84EC,$84ED,$84EE,$84EF,$84F0,$84F1,$84F2,
$84F3,$84F4,$84F5,$84F6,$84F7,$84F8,$84F9,$84FA,$84FB,$84FC,$84FD,$84FE,$8540,
$8541,$8542,$8543,$8544,$8545,$8546,$8547,$8548,$8549,$854A,$854B,$854C,$854D,
$854E,$854F,$8550,$8551,$8552,$8553,$8554,$8555,$8556,$8557,$8558,$8559,$855A,
$855B,$855C,$855D,$855E,$855F,$8560,$8561,$8562,$8563,$8564,$8565,$8566,$8567,
$8568,$8569,$856A,$856B,$856C,$856D,$856E,$856F,$8570,$8571,$8572,$8573,$8574,
$8575,$8576,$8577,$8578,$8579,$857A,$857B,$857C,$857D,$857E,$8580,$8581,$8582,
$8583,$8584,$8585,$8586,$8587,$8588,$8589,$858A,$858B,$858C,$858D,$858E,$858F,
$8590,$8591,$8592,$8593,$8594,$8595,$8596,$8597,$8598,$8599,$859A,$859B,$859C,
$859D,$859E,$859F,$85A0,$85A1,$85A2,$85A3,$85A4,$85A5,$85A6,$85A7,$85A8,$85A9,
$85AA,$85AB,$85AC,$85AD,$85AE,$85AF,$85B0,$85B1,$85B2,$85B3,$85B4,$85B5,$85B6,
$85B7,$85B8,$85B9,$85BA,$85BB,$85BC,$85BD,$85BE,$85BF,$85C0,$85C1,$85C2,$85C3,
$85C4,$85C5,$85C6,$85C7,$85C8,$85C9,$85CA,$85CB,$85CC,$85CD,$85CE,$85CF,$85D0,
$85D1,$85D2,$85D3,$85D4,$85D5,$85D6,$85D7,$85D8,$85D9,$85DA,$85DB,$85DC,$85DD,
$85DE,$85DF,$85E0,$85E1,$85E2,$85E3,$85E4,$85E5,$85E6,$85E7,$85E8,$85E9,$85EA,
$85EB,$85EC,$85ED,$85EE,$85EF,$85F0,$85F1,$85F2,$85F3,$85F4,$85F5,$85F6,$85F7,
$85F8,$85F9,$85FA,$85FB,$85FC,$85FD,$85FE,$8640,$8641,$8642,$8643,$8644,$8645,
$8646,$8647,$8648,$8649,$864A,$864B,$864C,$864D,$864E,$864F,$8650,$8651,$8652,
$8653,$8654,$8655,$8656,$8657,$8658,$8659,$865A,$865B,$865C,$865D,$865E,$865F,
$8660,$8661,$8662,$8663,$8664,$8665,$8666,$8667,$8668,$8669,$866A,$866B,$866C,
$866D,$866E,$866F,$8670,$8671,$8672,$8673,$8674,$8675,$8676,$8677,$8678,$8679,
$867A,$867B,$867C,$867D,$867E,$8680,$8681,$8682,$8683,$8684,$8685,$8686,$8687,
$8688,$8689,$868A,$868B,$868C,$868D,$868E,$868F,$8690,$8691,$8692,$8693,$8694,
$8695,$8696,$8697,$8698,$8699,$869A,$869B,$869C,$869D,$869E,$869F,$86A0,$86A1,
$86A2,$86A3,$86A4,$86A5,$86A6,$86A7,$86A8,$86A9,$86AA,$86AB,$86AC,$86AD,$86AE,
$86AF,$86B0,$86B1,$86B2,$86B3,$86B4,$86B5,$86B6,$86B7,$86B8,$86B9,$86BA,$86BB,
$86BC,$86BD,$86BE,$86BF,$86C0,$86C1,$86C2,$86C3,$86C4,$86C5,$86C6,$86C7,$86C8,
$86C9,$86CA,$86CB,$86CC,$86CD,$86CE,$86CF,$86D0,$86D1,$86D2,$86D3,$86D4,$86D5,
$86D6,$86D7,$86D8,$86D9,$86DA,$86DB,$86DC,$86DD,$86DE,$86DF,$86E0,$86E1,$86E2,
$86E3,$86E4,$86E5,$86E6,$86E7,$86E8,$86E9,$86EA,$86EB,$86EC,$86ED,$86EE,$86EF,
$86F0,$86F1,$86F2,$86F3,$86F4,$86F5,$86F6,$86F7,$86F8,$86F9,$86FA,$86FB,$86FC,
$86FD,$86FE,$8740,$8741,$8742,$8743,$8744,$8745,$8746,$8747,$8748,$8749,$874A,
$874B,$874C,$874D,$874E,$874F,$8750,$8751,$8752,$8753,$8754,$8755,$8756,$8757,
$8758,$8759,$875A,$875B,$875C,$875D,$875E,$875F,$8760,$8761,$8762,$8763,$8764,
$8765,$8766,$8767,$8768,$8769,$876A,$876B,$876C,$876D,$876E,$876F,$8770,$8771,
$8772,$8773,$8774,$8775,$8776,$8777,$8778,$8779,$877A,$877B,$877C,$877D,$877E,
$8780,$8781,$8782,$8783,$8784,$8785,$8786,$8787,$8788,$8789,$878A,$878B,$878C,
$878D,$878E,$878F,$8790,$8791,$8792,$8793,$8794,$8795,$8796,$8797,$8798,$8799,
$879A,$879B,$879C,$879D,$879E,$879F,$87A0,$87A1,$87A2,$87A3,$87A4,$87A5,$87A6,
$87A7,$87A8,$87A9,$87AA,$87AB,$87AC,$87AD,$87AE,$87AF,$87B0,$87B1,$87B2,$87B3,
$87B4,$87B5,$87B6,$87B7,$87B8,$87B9,$87BA,$87BB,$87BC,$87BD,$87BE,$87BF,$87C0,
$87C1,$87C2,$87C3,$87C4,$87C5,$87C6,$87C7,$87C8,$87C9,$87CA,$87CB,$87CC,$87CD,
$87CE,$87CF,$87D0,$87D1,$87D2,$87D3,$87D4,$87D5,$87D6,$87D7,$87D8,$87D9,$87DA,
$87DB,$87DC,$87DD,$87DE,$87DF,$87E0,$87E1,$87E2,$87E3,$87E4,$87E5,$87E6,$87E7,
$87E8,$87E9,$87EA,$87EB,$87EC,$87ED,$87EE,$87EF,$87F0,$87F1,$87F2,$87F3,$87F4,
$87F5,$87F6,$87F7,$87F8,$87F9,$87FA,$87FB,$87FC,$87FD,$87FE,$8840,$8841,$8842,
$8843,$8844,$8845,$8846,$8847,$8848,$8849,$884A,$884B,$884C,$884D,$884E,$884F,
$8850,$8851,$8852,$8853,$8854,$8855,$8856,$8857,$8858,$8859,$885A,$885B,$885C,
$885D,$885E,$885F,$8860,$8861,$8862,$8863,$8864,$8865,$8866,$8867,$8868,$8869,
$886A,$886B,$886C,$886D,$886E,$886F,$8870,$8871,$8872,$8873,$8874,$8875,$8876,
$8877,$8878,$8879,$887A,$887B,$887C,$887D,$887E,$8880,$8881,$8882,$8883,$8884,
$8885,$8886,$8887,$8888,$8889,$888A,$888B,$888C,$888D,$888E,$888F,$8890,$8891,
$8892,$8893,$8894,$8895,$8896,$8897,$8898,$8899,$889A,$889B,$889C,$889D,$889E,
$889F,$88A0,$88A1,$88A2,$88A3,$88A4,$88A5,$88A6,$88A7,$88A8,$88A9,$88AA,$88AB,
$88AC,$88AD,$88AE,$88AF,$88B0,$88B1,$88B2,$88B3,$88B4,$88B5,$88B6,$88B7,$88B8,
$88B9,$88BA,$88BB,$88BC,$88BD,$88BE,$88BF,$88C0,$88C1,$88C2,$88C3,$88C4,$88C5,
$88C6,$88C7,$88C8,$88C9,$88CA,$88CB,$88CC,$88CD,$88CE,$88CF,$88D0,$88D1,$88D2,
$88D3,$88D4,$88D5,$88D6,$88D7,$88D8,$88D9,$88DA,$88DB,$88DC,$88DD,$88DE,$88DF,
$88E0,$88E1,$88E2,$88E3,$88E4,$88E5,$88E6,$88E7,$88E8,$88E9,$88EA,$88EB,$88EC,
$88ED,$88EE,$88EF,$88F0,$88F1,$88F2,$88F3,$88F4,$88F5,$88F6,$88F7,$88F8,$88F9,
$88FA,$88FB,$88FC,$88FD,$88FE,$8940,$8941,$8942,$8943,$8944,$8945,$8946,$8947,
$8948,$8949,$894A,$894B,$894C,$894D,$894E,$894F,$8950,$8951,$8952,$8953,$8954,
$8955,$8956,$8957,$8958,$8959,$895A,$895B,$895C,$895D,$895E,$895F,$8960,$8961,
$8962,$8963,$8964,$8965,$8966,$8967,$8968,$8969,$896A,$896B,$896C,$896D,$896E,
$896F,$8970,$8971,$8972,$8973,$8974,$8975,$8976,$8977,$8978,$8979,$897A,$897B,
$897C,$897D,$897E,$8980,$8981,$8982,$8983,$8984,$8985,$8986,$8987,$8988,$8989,
$898A,$898B,$898C,$898D,$898E,$898F,$8990,$8991,$8992,$8993,$8994,$8995,$8996,
$8997,$8998,$8999,$899A,$899B,$899C,$899D,$899E,$899F,$89A0,$89A1,$89A2,$89A3,
$89A4,$89A5,$89A6,$89A7,$89A8,$89A9,$89AA,$89AB,$89AC,$89AD,$89AE,$89AF,$89B0,
$89B1,$89B2,$89B3,$89B4,$89B5,$89B6,$89B7,$89B8,$89B9,$89BA,$89BB,$89BC,$89BD,
$89BE,$89BF,$89C0,$89C1,$89C2,$89C3,$89C4,$89C5,$89C6,$89C7,$89C8,$89C9,$89CA,
$89CB,$89CC,$89CD,$89CE,$89CF,$89D0,$89D1,$89D2,$89D3,$89D4,$89D5,$89D6,$89D7,
$89D8,$89D9,$89DA,$89DB,$89DC,$89DD,$89DE,$89DF,$89E0,$89E1,$89E2,$89E3,$89E4,
$89E5,$89E6,$89E7,$89E8,$89E9,$89EA,$89EB,$89EC,$89ED,$89EE,$89EF,$89F0,$89F1,
$89F2,$89F3,$89F4,$89F5,$89F6,$89F7,$89F8,$89F9,$89FA,$89FB,$89FC,$89FD,$89FE,
$8A40,$8A41,$8A42,$8A43,$8A44,$8A45,$8A46,$8A47,$8A48,$8A49,$8A4A,$8A4B,$8A4C,
$8A4D,$8A4E,$8A4F,$8A50,$8A51,$8A52,$8A53,$8A54,$8A55,$8A56,$8A57,$8A58,$8A59,
$8A5A,$8A5B,$8A5C,$8A5D,$8A5E,$8A5F,$8A60,$8A61,$8A62,$8A63,$8A64,$8A65,$8A66,
$8A67,$8A68,$8A69,$8A6A,$8A6B,$8A6C,$8A6D,$8A6E,$8A6F,$8A70,$8A71,$8A72,$8A73,
$8A74,$8A75,$8A76,$8A77,$8A78,$8A79,$8A7A,$8A7B,$8A7C,$8A7D,$8A7E,$8A80,$8A81,
$8A82,$8A83,$8A84,$8A85,$8A86,$8A87,$8A88,$8A89,$8A8A,$8A8B,$8A8C,$8A8D,$8A8E,
$8A8F,$8A90,$8A91,$8A92,$8A93,$8A94,$8A95,$8A96,$8A97,$8A98,$8A99,$8A9A,$8A9B,
$8A9C,$8A9D,$8A9E,$8A9F,$8AA0,$8AA1,$8AA2,$8AA3,$8AA4,$8AA5,$8AA6,$8AA7,$8AA8,
$8AA9,$8AAA,$8AAB,$8AAC,$8AAD,$8AAE,$8AAF,$8AB0,$8AB1,$8AB2,$8AB3,$8AB4,$8AB5,
$8AB6,$8AB7,$8AB8,$8AB9,$8ABA,$8ABB,$8ABC,$8ABD,$8ABE,$8ABF,$8AC0,$8AC1,$8AC2,
$8AC3,$8AC4,$8AC5,$8AC6,$8AC7,$8AC8,$8AC9,$8ACA,$8ACB,$8ACC,$8ACD,$8ACE,$8ACF,
$8AD0,$8AD1,$8AD2,$8AD3,$8AD4,$8AD5,$8AD6,$8AD7,$8AD8,$8AD9,$8ADA,$8ADB,$8ADC,
$8ADD,$8ADE,$8ADF,$8AE0,$8AE1,$8AE2,$8AE3,$8AE4,$8AE5,$8AE6,$8AE7,$8AE8,$8AE9,
$8AEA,$8AEB,$8AEC,$8AED,$8AEE,$8AEF,$8AF0,$8AF1,$8AF2,$8AF3,$8AF4,$8AF5,$8AF6,
$8AF7,$8AF8,$8AF9,$8AFA,$8AFB,$8AFC,$8AFD,$8AFE,$8B40,$8B41,$8B42,$8B43,$8B44,
$8B45,$8B46,$8B47,$8B48,$8B49,$8B4A,$8B4B,$8B4C,$8B4D,$8B4E,$8B4F,$8B50,$8B51,
$8B52,$8B53,$8B54,$8B55,$8B56,$8B57,$8B58,$8B59,$8B5A,$8B5B,$8B5C,$8B5D,$8B5E,
$8B5F,$8B60,$8B61,$8B62,$8B63,$8B64,$8B65,$8B66,$8B67,$8B68,$8B69,$8B6A,$8B6B,
$8B6C,$8B6D,$8B6E,$8B6F,$8B70,$8B71,$8B72,$8B73,$8B74,$8B75,$8B76,$8B77,$8B78,
$8B79,$8B7A,$8B7B,$8B7C,$8B7D,$8B7E,$8B80,$8B81,$8B82,$8B83,$8B84,$8B85,$8B86,
$8B87,$8B88,$8B89,$8B8A,$8B8B,$8B8C,$8B8D,$8B8E,$8B8F,$8B90,$8B91,$8B92,$8B93,
$8B94,$8B95,$8B96,$8B97,$8B98,$8B99,$8B9A,$8B9B,$8B9C,$8B9D,$8B9E,$8B9F,$8BA0,
$8BA1,$8BA2,$8BA3,$8BA4,$8BA5,$8BA6,$8BA7,$8BA8,$8BA9,$8BAA,$8BAB,$8BAC,$8BAD,
$8BAE,$8BAF,$8BB0,$8BB1,$8BB2,$8BB3,$8BB4,$8BB5,$8BB6,$8BB7,$8BB8,$8BB9,$8BBA,
$8BBB,$8BBC,$8BBD,$8BBE,$8BBF,$8BC0,$8BC1,$8BC2,$8BC3,$8BC4,$8BC5,$8BC6,$8BC7,
$8BC8,$8BC9,$8BCA,$8BCB,$8BCC,$8BCD,$8BCE,$8BCF,$8BD0,$8BD1,$8BD2,$8BD3,$8BD4,
$8BD5,$8BD6,$8BD7,$8BD8,$8BD9,$8BDA,$8BDB,$8BDC,$8BDD,$8BDE,$8BDF,$8BE0,$8BE1,
$8BE2,$8BE3,$8BE4,$8BE5,$8BE6,$8BE7,$8BE8,$8BE9,$8BEA,$8BEB,$8BEC,$8BED,$8BEE,
$8BEF,$8BF0,$8BF1,$8BF2,$8BF3,$8BF4,$8BF5,$8BF6,$8BF7,$8BF8,$8BF9,$8BFA,$8BFB,
$8BFC,$8BFD,$8BFE,$8C40,$8C41,$8C42,$8C43,$8C44,$8C45,$8C46,$8C47,$8C48,$8C49,
$8C4A,$8C4B,$8C4C,$8C4D,$8C4E,$8C4F,$8C50,$8C51,$8C52,$8C53,$8C54,$8C55,$8C56,
$8C57,$8C58,$8C59,$8C5A,$8C5B,$8C5C,$8C5D,$8C5E,$8C5F,$8C60,$8C61,$8C62,$8C63,
$8C64,$8C65,$8C66,$8C67,$8C68,$8C69,$8C6A,$8C6B,$8C6C,$8C6D,$8C6E,$8C6F,$8C70,
$8C71,$8C72,$8C73,$8C74,$8C75,$8C76,$8C77,$8C78,$8C79,$8C7A,$8C7B,$8C7C,$8C7D,
$8C7E,$8C80,$8C81,$8C82,$8C83,$8C84,$8C85,$8C86,$8C87,$8C88,$8C89,$8C8A,$8C8B,
$8C8C,$8C8D,$8C8E,$8C8F,$8C90,$8C91,$8C92,$8C93,$8C94,$8C95,$8C96,$8C97,$8C98,
$8C99,$8C9A,$8C9B,$8C9C,$8C9D,$8C9E,$8C9F,$8CA0,$8CA1,$8CA2,$8CA3,$8CA4,$8CA5,
$8CA6,$8CA7,$8CA8,$8CA9,$8CAA,$8CAB,$8CAC,$8CAD,$8CAE,$8CAF,$8CB0,$8CB1,$8CB2,
$8CB3,$8CB4,$8CB5,$8CB6,$8CB7,$8CB8,$8CB9,$8CBA,$8CBB,$8CBC,$8CBD,$8CBE,$8CBF,
$8CC0,$8CC1,$8CC2,$8CC3,$8CC4,$8CC5,$8CC6,$8CC7,$8CC8,$8CC9,$8CCA,$8CCB,$8CCC,
$8CCD,$8CCE,$8CCF,$8CD0,$8CD1,$8CD2,$8CD3,$8CD4,$8CD5,$8CD6,$8CD7,$8CD8,$8CD9,
$8CDA,$8CDB,$8CDC,$8CDD,$8CDE,$8CDF,$8CE0,$8CE1,$8CE2,$8CE3,$8CE4,$8CE5,$8CE6,
$8CE7,$8CE8,$8CE9,$8CEA,$8CEB,$8CEC,$8CED,$8CEE,$8CEF,$8CF0,$8CF1,$8CF2,$8CF3,
$8CF4,$8CF5,$8CF6,$8CF7,$8CF8,$8CF9,$8CFA,$8CFB,$8CFC,$8CFD,$8CFE,$8D40,$8D41,
$8D42,$8D43,$8D44,$8D45,$8D46,$8D47,$8D48,$8D49,$8D4A,$8D4B,$8D4C,$8D4D,$8D4E,
$8D4F,$8D50,$8D51,$8D52,$8D53,$8D54,$8D55,$8D56,$8D57,$8D58,$8D59,$8D5A,$8D5B,
$8D5C,$8D5D,$8D5E,$8D5F,$8D60,$8D61,$8D62,$8D63,$8D64,$8D65,$8D66,$8D67,$8D68,
$8D69,$8D6A,$8D6B,$8D6C,$8D6D,$8D6E,$8D6F,$8D70,$8D71,$8D72,$8D73,$8D74,$8D75,
$8D76,$8D77,$8D78,$8D79,$8D7A,$8D7B,$8D7C,$8D7D,$8D7E,$8D80,$8D81,$8D82,$8D83,
$8D84,$8D85,$8D86,$8D87,$8D88,$8D89,$8D8A,$8D8B,$8D8C,$8D8D,$8D8E,$8D8F,$8D90,
$8D91,$8D92,$8D93,$8D94,$8D95,$8D96,$8D97,$8D98,$8D99,$8D9A,$8D9B,$8D9C,$8D9D,
$8D9E,$8D9F,$8DA0,$8DA1,$8DA2,$8DA3,$8DA4,$8DA5,$8DA6,$8DA7,$8DA8,$8DA9,$8DAA,
$8DAB,$8DAC,$8DAD,$8DAE,$8DAF,$8DB0,$8DB1,$8DB2,$8DB3,$8DB4,$8DB5,$8DB6,$8DB7,
$8DB8,$8DB9,$8DBA,$8DBB,$8DBC,$8DBD,$8DBE,$8DBF,$8DC0,$8DC1,$8DC2,$8DC3,$8DC4,
$8DC5,$8DC6,$8DC7,$8DC8,$8DC9,$8DCA,$8DCB,$8DCC,$8DCD,$8DCE,$8DCF,$8DD0,$8DD1,
$8DD2,$8DD3,$8DD4,$8DD5,$8DD6,$8DD7,$8DD8,$8DD9,$8DDA,$8DDB,$8DDC,$8DDD,$8DDE,
$8DDF,$8DE0,$8DE1,$8DE2,$8DE3,$8DE4,$8DE5,$8DE6,$8DE7,$8DE8,$8DE9,$8DEA,$8DEB,
$8DEC,$8DED,$8DEE,$8DEF,$8DF0,$8DF1,$8DF2,$8DF3,$8DF4,$8DF5,$8DF6,$8DF7,$8DF8,
$8DF9,$8DFA,$8DFB,$8DFC,$8DFD,$8DFE,$8E40,$8E41,$8E42,$8E43,$8E44,$8E45,$8E46,
$8E47,$8E48,$8E49,$8E4A,$8E4B,$8E4C,$8E4D,$8E4E,$8E4F,$8E50,$8E51,$8E52,$8E53,
$8E54,$8E55,$8E56,$8E57,$8E58,$8E59,$8E5A,$8E5B,$8E5C,$8E5D,$8E5E,$8E5F,$8E60,
$8E61,$8E62,$8E63,$8E64,$8E65,$8E66,$8E67,$8E68,$8E69,$8E6A,$8E6B,$8E6C,$8E6D,
$8E6E,$8E6F,$8E70,$8E71,$8E72,$8E73,$8E74,$8E75,$8E76,$8E77,$8E78,$8E79,$8E7A,
$8E7B,$8E7C,$8E7D,$8E7E,$8E80,$8E81,$8E82,$8E83,$8E84,$8E85,$8E86,$8E87,$8E88,
$8E89,$8E8A,$8E8B,$8E8C,$8E8D,$8E8E,$8E8F,$8E90,$8E91,$8E92,$8E93,$8E94,$8E95,
$8E96,$8E97,$8E98,$8E99,$8E9A,$8E9B,$8E9C,$8E9D,$8E9E,$8E9F,$8EA0,$8EA1,$8EA2,
$8EA3,$8EA4,$8EA5,$8EA6,$8EA7,$8EA8,$8EA9,$8EAA,$8EAB,$8EAC,$8EAD,$8EAE,$8EAF,
$8EB0,$8EB1,$8EB2,$8EB3,$8EB4,$8EB5,$8EB6,$8EB7,$8EB8,$8EB9,$8EBA,$8EBB,$8EBC,
$8EBD,$8EBE,$8EBF,$8EC0,$8EC1,$8EC2,$8EC3,$8EC4,$8EC5,$8EC6,$8EC7,$8EC8,$8EC9,
$8ECA,$8ECB,$8ECC,$8ECD,$8ECE,$8ECF,$8ED0,$8ED1,$8ED2,$8ED3,$8ED4,$8ED5,$8ED6,
$8ED7,$8ED8,$8ED9,$8EDA,$8EDB,$8EDC,$8EDD,$8EDE,$8EDF,$8EE0,$8EE1,$8EE2,$8EE3,
$8EE4,$8EE5,$8EE6,$8EE7,$8EE8,$8EE9,$8EEA,$8EEB,$8EEC,$8EED,$8EEE,$8EEF,$8EF0,
$8EF1,$8EF2,$8EF3,$8EF4,$8EF5,$8EF6,$8EF7,$8EF8,$8EF9,$8EFA,$8EFB,$8EFC,$8EFD,
$8EFE,$8F40,$8F41,$8F42,$8F43,$8F44,$8F45,$8F46,$8F47,$8F48,$8F49,$8F4A,$8F4B,
$8F4C,$8F4D,$8F4E,$8F4F,$8F50,$8F51,$8F52,$8F53,$8F54,$8F55,$8F56,$8F57,$8F58,
$8F59,$8F5A,$8F5B,$8F5C,$8F5D,$8F5E,$8F5F,$8F60,$8F61,$8F62,$8F63,$8F64,$8F65,
$8F66,$8F67,$8F68,$8F69,$8F6A,$8F6B,$8F6C,$8F6D,$8F6E,$8F6F,$8F70,$8F71,$8F72,
$8F73,$8F74,$8F75,$8F76,$8F77,$8F78,$8F79,$8F7A,$8F7B,$8F7C,$8F7D,$8F7E,$8F80,
$8F81,$8F82,$8F83,$8F84,$8F85,$8F86,$8F87,$8F88,$8F89,$8F8A,$8F8B,$8F8C,$8F8D,
$8F8E,$8F8F,$8F90,$8F91,$8F92,$8F93,$8F94,$8F95,$8F96,$8F97,$8F98,$8F99,$8F9A,
$8F9B,$8F9C,$8F9D,$8F9E,$8F9F,$8FA0,$8FA1,$8FA2,$8FA3,$8FA4,$8FA5,$8FA6,$8FA7,
$8FA8,$8FA9,$8FAA,$8FAB,$8FAC,$8FAD,$8FAE,$8FAF,$8FB0,$8FB1,$8FB2,$8FB3,$8FB4,
$8FB5,$8FB6,$8FB7,$8FB8,$8FB9,$8FBA,$8FBB,$8FBC,$8FBD,$8FBE,$8FBF,$8FC0,$8FC1,
$8FC2,$8FC3,$8FC4,$8FC5,$8FC6,$8FC7,$8FC8,$8FC9,$8FCA,$8FCB,$8FCC,$8FCD,$8FCE,
$8FCF,$8FD0,$8FD1,$8FD2,$8FD3,$8FD4,$8FD5,$8FD6,$8FD7,$8FD8,$8FD9,$8FDA,$8FDB,
$8FDC,$8FDD,$8FDE,$8FDF,$8FE0,$8FE1,$8FE2,$8FE3,$8FE4,$8FE5,$8FE6,$8FE7,$8FE8,
$8FE9,$8FEA,$8FEB,$8FEC,$8FED,$8FEE,$8FEF,$8FF0,$8FF1,$8FF2,$8FF3,$8FF4,$8FF5,
$8FF6,$8FF7,$8FF8,$8FF9,$8FFA,$8FFB,$8FFC,$8FFD,$8FFE,$9040,$9041,$9042,$9043,
$9044,$9045,$9046,$9047,$9048,$9049,$904A,$904B,$904C,$904D,$904E,$904F,$9050,
$9051,$9052,$9053,$9054,$9055,$9056,$9057,$9058,$9059,$905A,$905B,$905C,$905D,
$905E,$905F,$9060,$9061,$9062,$9063,$9064,$9065,$9066,$9067,$9068,$9069,$906A,
$906B,$906C,$906D,$906E,$906F,$9070,$9071,$9072,$9073,$9074,$9075,$9076,$9077,
$9078,$9079,$907A,$907B,$907C,$907D,$907E,$9080,$9081,$9082,$9083,$9084,$9085,
$9086,$9087,$9088,$9089,$908A,$908B,$908C,$908D,$908E,$908F,$9090,$9091,$9092,
$9093,$9094,$9095,$9096,$9097,$9098,$9099,$909A,$909B,$909C,$909D,$909E,$909F,
$90A0,$90A1,$90A2,$90A3,$90A4,$90A5,$90A6,$90A7,$90A8,$90A9,$90AA,$90AB,$90AC,
$90AD,$90AE,$90AF,$90B0,$90B1,$90B2,$90B3,$90B4,$90B5,$90B6,$90B7,$90B8,$90B9,
$90BA,$90BB,$90BC,$90BD,$90BE,$90BF,$90C0,$90C1,$90C2,$90C3,$90C4,$90C5,$90C6,
$90C7,$90C8,$90C9,$90CA,$90CB,$90CC,$90CD,$90CE,$90CF,$90D0,$90D1,$90D2,$90D3,
$90D4,$90D5,$90D6,$90D7,$90D8,$90D9,$90DA,$90DB,$90DC,$90DD,$90DE,$90DF,$90E0,
$90E1,$90E2,$90E3,$90E4,$90E5,$90E6,$90E7,$90E8,$90E9,$90EA,$90EB,$90EC,$90ED,
$90EE,$90EF,$90F0,$90F1,$90F2,$90F3,$90F4,$90F5,$90F6,$90F7,$90F8,$90F9,$90FA,
$90FB,$90FC,$90FD,$90FE,$9140,$9141,$9142,$9143,$9144,$9145,$9146,$9147,$9148,
$9149,$914A,$914B,$914C,$914D,$914E,$914F,$9150,$9151,$9152,$9153,$9154,$9155,
$9156,$9157,$9158,$9159,$915A,$915B,$915C,$915D,$915E,$915F,$9160,$9161,$9162,
$9163,$9164,$9165,$9166,$9167,$9168,$9169,$916A,$916B,$916C,$916D,$916E,$916F,
$9170,$9171,$9172,$9173,$9174,$9175,$9176,$9177,$9178,$9179,$917A,$917B,$917C,
$917D,$917E,$9180,$9181,$9182,$9183,$9184,$9185,$9186,$9187,$9188,$9189,$918A,
$918B,$918C,$918D,$918E,$918F,$9190,$9191,$9192,$9193,$9194,$9195,$9196,$9197,
$9198,$9199,$919A,$919B,$919C,$919D,$919E,$919F,$91A0,$91A1,$91A2,$91A3,$91A4,
$91A5,$91A6,$91A7,$91A8,$91A9,$91AA,$91AB,$91AC,$91AD,$91AE,$91AF,$91B0,$91B1,
$91B2,$91B3,$91B4,$91B5,$91B6,$91B7,$91B8,$91B9,$91BA,$91BB,$91BC,$91BD,$91BE,
$91BF,$91C0,$91C1,$91C2,$91C3,$91C4,$91C5,$91C6,$91C7,$91C8,$91C9,$91CA,$91CB,
$91CC,$91CD,$91CE,$91CF,$91D0,$91D1,$91D2,$91D3,$91D4,$91D5,$91D6,$91D7,$91D8,
$91D9,$91DA,$91DB,$91DC,$91DD,$91DE,$91DF,$91E0,$91E1,$91E2,$91E3,$91E4,$91E5,
$91E6,$91E7,$91E8,$91E9,$91EA,$91EB,$91EC,$91ED,$91EE,$91EF,$91F0,$91F1,$91F2,
$91F3,$91F4,$91F5,$91F6,$91F7,$91F8,$91F9,$91FA,$91FB,$91FC,$91FD,$91FE,$9240,
$9241,$9242,$9243,$9244,$9245,$9246,$9247,$9248,$9249,$924A,$924B,$924C,$924D,
$924E,$924F,$9250,$9251,$9252,$9253,$9254,$9255,$9256,$9257,$9258,$9259,$925A,
$925B,$925C,$925D,$925E,$925F,$9260,$9261,$9262,$9263,$9264,$9265,$9266,$9267,
$9268,$9269,$926A,$926B,$926C,$926D,$926E,$926F,$9270,$9271,$9272,$9273,$9274,
$9275,$9276,$9277,$9278,$9279,$927A,$927B,$927C,$927D,$927E,$9280,$9281,$9282,
$9283,$9284,$9285,$9286,$9287,$9288,$9289,$928A,$928B,$928C,$928D,$928E,$928F,
$9290,$9291,$9292,$9293,$9294,$9295,$9296,$9297,$9298,$9299,$929A,$929B,$929C,
$929D,$929E,$929F,$92A0,$92A1,$92A2,$92A3,$92A4,$92A5,$92A6,$92A7,$92A8,$92A9,
$92AA,$92AB,$92AC,$92AD,$92AE,$92AF,$92B0,$92B1,$92B2,$92B3,$92B4,$92B5,$92B6,
$92B7,$92B8,$92B9,$92BA,$92BB,$92BC,$92BD,$92BE,$92BF,$92C0,$92C1,$92C2,$92C3,
$92C4,$92C5,$92C6,$92C7,$92C8,$92C9,$92CA,$92CB,$92CC,$92CD,$92CE,$92CF,$92D0,
$92D1,$92D2,$92D3,$92D4,$92D5,$92D6,$92D7,$92D8,$92D9,$92DA,$92DB,$92DC,$92DD,
$92DE,$92DF,$92E0,$92E1,$92E2,$92E3,$92E4,$92E5,$92E6,$92E7,$92E8,$92E9,$92EA,
$92EB,$92EC,$92ED,$92EE,$92EF,$92F0,$92F1,$92F2,$92F3,$92F4,$92F5,$92F6,$92F7,
$92F8,$92F9,$92FA,$92FB,$92FC,$92FD,$92FE,$9340,$9341,$9342,$9343,$9344,$9345,
$9346,$9347,$9348,$9349,$934A,$934B,$934C,$934D,$934E,$934F,$9350,$9351,$9352,
$9353,$9354,$9355,$9356,$9357,$9358,$9359,$935A,$935B,$935C,$935D,$935E,$935F,
$9360,$9361,$9362,$9363,$9364,$9365,$9366,$9367,$9368,$9369,$936A,$936B,$936C,
$936D,$936E,$936F,$9370,$9371,$9372,$9373,$9374,$9375,$9376,$9377,$9378,$9379,
$937A,$937B,$937C,$937D,$937E,$9380,$9381,$9382,$9383,$9384,$9385,$9386,$9387,
$9388,$9389,$938A,$938B,$938C,$938D,$938E,$938F,$9390,$9391,$9392,$9393,$9394,
$9395,$9396,$9397,$9398,$9399,$939A,$939B,$939C,$939D,$939E,$939F,$93A0,$93A1,
$93A2,$93A3,$93A4,$93A5,$93A6,$93A7,$93A8,$93A9,$93AA,$93AB,$93AC,$93AD,$93AE,
$93AF,$93B0,$93B1,$93B2,$93B3,$93B4,$93B5,$93B6,$93B7,$93B8,$93B9,$93BA,$93BB,
$93BC,$93BD,$93BE,$93BF,$93C0,$93C1,$93C2,$93C3,$93C4,$93C5,$93C6,$93C7,$93C8,
$93C9,$93CA,$93CB,$93CC,$93CD,$93CE,$93CF,$93D0,$93D1,$93D2,$93D3,$93D4,$93D5,
$93D6,$93D7,$93D8,$93D9,$93DA,$93DB,$93DC,$93DD,$93DE,$93DF,$93E0,$93E1,$93E2,
$93E3,$93E4,$93E5,$93E6,$93E7,$93E8,$93E9,$93EA,$93EB,$93EC,$93ED,$93EE,$93EF,
$93F0,$93F1,$93F2,$93F3,$93F4,$93F5,$93F6,$93F7,$93F8,$93F9,$93FA,$93FB,$93FC,
$93FD,$93FE,$9440,$9441,$9442,$9443,$9444,$9445,$9446,$9447,$9448,$9449,$944A,
$944B,$944C,$944D,$944E,$944F,$9450,$9451,$9452,$9453,$9454,$9455,$9456,$9457,
$9458,$9459,$945A,$945B,$945C,$945D,$945E,$945F,$9460,$9461,$9462,$9463,$9464,
$9465,$9466,$9467,$9468,$9469,$946A,$946B,$946C,$946D,$946E,$946F,$9470,$9471,
$9472,$9473,$9474,$9475,$9476,$9477,$9478,$9479,$947A,$947B,$947C,$947D,$947E,
$9480,$9481,$9482,$9483,$9484,$9485,$9486,$9487,$9488,$9489,$948A,$948B,$948C,
$948D,$948E,$948F,$9490,$9491,$9492,$9493,$9494,$9495,$9496,$9497,$9498,$9499,
$949A,$949B,$949C,$949D,$949E,$949F,$94A0,$94A1,$94A2,$94A3,$94A4,$94A5,$94A6,
$94A7,$94A8,$94A9,$94AA,$94AB,$94AC,$94AD,$94AE,$94AF,$94B0,$94B1,$94B2,$94B3,
$94B4,$94B5,$94B6,$94B7,$94B8,$94B9,$94BA,$94BB,$94BC,$94BD,$94BE,$94BF,$94C0,
$94C1,$94C2,$94C3,$94C4,$94C5,$94C6,$94C7,$94C8,$94C9,$94CA,$94CB,$94CC,$94CD,
$94CE,$94CF,$94D0,$94D1,$94D2,$94D3,$94D4,$94D5,$94D6,$94D7,$94D8,$94D9,$94DA,
$94DB,$94DC,$94DD,$94DE,$94DF,$94E0,$94E1,$94E2,$94E3,$94E4,$94E5,$94E6,$94E7,
$94E8,$94E9,$94EA,$94EB,$94EC,$94ED,$94EE,$94EF,$94F0,$94F1,$94F2,$94F3,$94F4,
$94F5,$94F6,$94F7,$94F8,$94F9,$94FA,$94FB,$94FC,$94FD,$94FE,$9540,$9541,$9542,
$9543,$9544,$9545,$9546,$9547,$9548,$9549,$954A,$954B,$954C,$954D,$954E,$954F,
$9550,$9551,$9552,$9553,$9554,$9555,$9556,$9557,$9558,$9559,$955A,$955B,$955C,
$955D,$955E,$955F,$9560,$9561,$9562,$9563,$9564,$9565,$9566,$9567,$9568,$9569,
$956A,$956B,$956C,$956D,$956E,$956F,$9570,$9571,$9572,$9573,$9574,$9575,$9576,
$9577,$9578,$9579,$957A,$957B,$957C,$957D,$957E,$9580,$9581,$9582,$9583,$9584,
$9585,$9586,$9587,$9588,$9589,$958A,$958B,$958C,$958D,$958E,$958F,$9590,$9591,
$9592,$9593,$9594,$9595,$9596,$9597,$9598,$9599,$959A,$959B,$959C,$959D,$959E,
$959F,$95A0,$95A1,$95A2,$95A3,$95A4,$95A5,$95A6,$95A7,$95A8,$95A9,$95AA,$95AB,
$95AC,$95AD,$95AE,$95AF,$95B0,$95B1,$95B2,$95B3,$95B4,$95B5,$95B6,$95B7,$95B8,
$95B9,$95BA,$95BB,$95BC,$95BD,$95BE,$95BF,$95C0,$95C1,$95C2,$95C3,$95C4,$95C5,
$95C6,$95C7,$95C8,$95C9,$95CA,$95CB,$95CC,$95CD,$95CE,$95CF,$95D0,$95D1,$95D2,
$95D3,$95D4,$95D5,$95D6,$95D7,$95D8,$95D9,$95DA,$95DB,$95DC,$95DD,$95DE,$95DF,
$95E0,$95E1,$95E2,$95E3,$95E4,$95E5,$95E6,$95E7,$95E8,$95E9,$95EA,$95EB,$95EC,
$95ED,$95EE,$95EF,$95F0,$95F1,$95F2,$95F3,$95F4,$95F5,$95F6,$95F7,$95F8,$95F9,
$95FA,$95FB,$95FC,$95FD,$95FE,$9640,$9641,$9642,$9643,$9644,$9645,$9646,$9647,
$9648,$9649,$964A,$964B,$964C,$964D,$964E,$964F,$9650,$9651,$9652,$9653,$9654,
$9655,$9656,$9657,$9658,$9659,$965A,$965B,$965C,$965D,$965E,$965F,$9660,$9661,
$9662,$9663,$9664,$9665,$9666,$9667,$9668,$9669,$966A,$966B,$966C,$966D,$966E,
$966F,$9670,$9671,$9672,$9673,$9674,$9675,$9676,$9677,$9678,$9679,$967A,$967B,
$967C,$967D,$967E,$9680,$9681,$9682,$9683,$9684,$9685,$9686,$9687,$9688,$9689,
$968A,$968B,$968C,$968D,$968E,$968F,$9690,$9691,$9692,$9693,$9694,$9695,$9696,
$9697,$9698,$9699,$969A,$969B,$969C,$969D,$969E,$969F,$96A0,$96A1,$96A2,$96A3,
$96A4,$96A5,$96A6,$96A7,$96A8,$96A9,$96AA,$96AB,$96AC,$96AD,$96AE,$96AF,$96B0,
$96B1,$96B2,$96B3,$96B4,$96B5,$96B6,$96B7,$96B8,$96B9,$96BA,$96BB,$96BC,$96BD,
$96BE,$96BF,$96C0,$96C1,$96C2,$96C3,$96C4,$96C5,$96C6,$96C7,$96C8,$96C9,$96CA,
$96CB,$96CC,$96CD,$96CE,$96CF,$96D0,$96D1,$96D2,$96D3,$96D4,$96D5,$96D6,$96D7,
$96D8,$96D9,$96DA,$96DB,$96DC,$96DD,$96DE,$96DF,$96E0,$96E1,$96E2,$96E3,$96E4,
$96E5,$96E6,$96E7,$96E8,$96E9,$96EA,$96EB,$96EC,$96ED,$96EE,$96EF,$96F0,$96F1,
$96F2,$96F3,$96F4,$96F5,$96F6,$96F7,$96F8,$96F9,$96FA,$96FB,$96FC,$96FD,$96FE,
$9740,$9741,$9742,$9743,$9744,$9745,$9746,$9747,$9748,$9749,$974A,$974B,$974C,
$974D,$974E,$974F,$9750,$9751,$9752,$9753,$9754,$9755,$9756,$9757,$9758,$9759,
$975A,$975B,$975C,$975D,$975E,$975F,$9760,$9761,$9762,$9763,$9764,$9765,$9766,
$9767,$9768,$9769,$976A,$976B,$976C,$976D,$976E,$976F,$9770,$9771,$9772,$9773,
$9774,$9775,$9776,$9777,$9778,$9779,$977A,$977B,$977C,$977D,$977E,$9780,$9781,
$9782,$9783,$9784,$9785,$9786,$9787,$9788,$9789,$978A,$978B,$978C,$978D,$978E,
$978F,$9790,$9791,$9792,$9793,$9794,$9795,$9796,$9797,$9798,$9799,$979A,$979B,
$979C,$979D,$979E,$979F,$97A0,$97A1,$97A2,$97A3,$97A4,$97A5,$97A6,$97A7,$97A8,
$97A9,$97AA,$97AB,$97AC,$97AD,$97AE,$97AF,$97B0,$97B1,$97B2,$97B3,$97B4,$97B5,
$97B6,$97B7,$97B8,$97B9,$97BA,$97BB,$97BC,$97BD,$97BE,$97BF,$97C0,$97C1,$97C2,
$97C3,$97C4,$97C5,$97C6,$97C7,$97C8,$97C9,$97CA,$97CB,$97CC,$97CD,$97CE,$97CF,
$97D0,$97D1,$97D2,$97D3,$97D4,$97D5,$97D6,$97D7,$97D8,$97D9,$97DA,$97DB,$97DC,
$97DD,$97DE,$97DF,$97E0,$97E1,$97E2,$97E3,$97E4,$97E5,$97E6,$97E7,$97E8,$97E9,
$97EA,$97EB,$97EC,$97ED,$97EE,$97EF,$97F0,$97F1,$97F2,$97F3,$97F4,$97F5,$97F6,
$97F7,$97F8,$97F9,$97FA,$97FB,$97FC,$97FD,$97FE,$9840,$9841,$9842,$9843,$9844,
$9845,$9846,$9847,$9848,$9849,$984A,$984B,$984C,$984D,$984E,$984F,$9850,$9851,
$9852,$9853,$9854,$9855,$9856,$9857,$9858,$9859,$985A,$985B,$985C,$985D,$985E,
$985F,$9860,$9861,$9862,$9863,$9864,$9865,$9866,$9867,$9868,$9869,$986A,$986B,
$986C,$986D,$986E,$986F,$9870,$9871,$9872,$9873,$9874,$9875,$9876,$9877,$9878,
$9879,$987A,$987B,$987C,$987D,$987E,$9880,$9881,$9882,$9883,$9884,$9885,$9886,
$9887,$9888,$9889,$988A,$988B,$988C,$988D,$988E,$988F,$9890,$9891,$9892,$9893,
$9894,$9895,$9896,$9897,$9898,$9899,$989A,$989B,$989C,$989D,$989E,$989F,$98A0,
$98A1,$98A2,$98A3,$98A4,$98A5,$98A6,$98A7,$98A8,$98A9,$98AA,$98AB,$98AC,$98AD,
$98AE,$98AF,$98B0,$98B1,$98B2,$98B3,$98B4,$98B5,$98B6,$98B7,$98B8,$98B9,$98BA,
$98BB,$98BC,$98BD,$98BE,$98BF,$98C0,$98C1,$98C2,$98C3,$98C4,$98C5,$98C6,$98C7,
$98C8,$98C9,$98CA,$98CB,$98CC,$98CD,$98CE,$98CF,$98D0,$98D1,$98D2,$98D3,$98D4,
$98D5,$98D6,$98D7,$98D8,$98D9,$98DA,$98DB,$98DC,$98DD,$98DE,$98DF,$98E0,$98E1,
$98E2,$98E3,$98E4,$98E5,$98E6,$98E7,$98E8,$98E9,$98EA,$98EB,$98EC,$98ED,$98EE,
$98EF,$98F0,$98F1,$98F2,$98F3,$98F4,$98F5,$98F6,$98F7,$98F8,$98F9,$98FA,$98FB,
$98FC,$98FD,$98FE,$9940,$9941,$9942,$9943,$9944,$9945,$9946,$9947,$9948,$9949,
$994A,$994B,$994C,$994D,$994E,$994F,$9950,$9951,$9952,$9953,$9954,$9955,$9956,
$9957,$9958,$9959,$995A,$995B,$995C,$995D,$995E,$995F,$9960,$9961,$9962,$9963,
$9964,$9965,$9966,$9967,$9968,$9969,$996A,$996B,$996C,$996D,$996E,$996F,$9970,
$9971,$9972,$9973,$9974,$9975,$9976,$9977,$9978,$9979,$997A,$997B,$997C,$997D,
$997E,$9980,$9981,$9982,$9983,$9984,$9985,$9986,$9987,$9988,$9989,$998A,$998B,
$998C,$998D,$998E,$998F,$9990,$9991,$9992,$9993,$9994,$9995,$9996,$9997,$9998,
$9999,$999A,$999B,$999C,$999D,$999E,$999F,$99A0,$99A1,$99A2,$99A3,$99A4,$99A5,
$99A6,$99A7,$99A8,$99A9,$99AA,$99AB,$99AC,$99AD,$99AE,$99AF,$99B0,$99B1,$99B2,
$99B3,$99B4,$99B5,$99B6,$99B7,$99B8,$99B9,$99BA,$99BB,$99BC,$99BD,$99BE,$99BF,
$99C0,$99C1,$99C2,$99C3,$99C4,$99C5,$99C6,$99C7,$99C8,$99C9,$99CA,$99CB,$99CC,
$99CD,$99CE,$99CF,$99D0,$99D1,$99D2,$99D3,$99D4,$99D5,$99D6,$99D7,$99D8,$99D9,
$99DA,$99DB,$99DC,$99DD,$99DE,$99DF,$99E0,$99E1,$99E2,$99E3,$99E4,$99E5,$99E6,
$99E7,$99E8,$99E9,$99EA,$99EB,$99EC,$99ED,$99EE,$99EF,$99F0,$99F1,$99F2,$99F3,
$99F4,$99F5,$99F6,$99F7,$99F8,$99F9,$99FA,$99FB,$99FC,$99FD,$99FE,$9A40,$9A41,
$9A42,$9A43,$9A44,$9A45,$9A46,$9A47,$9A48,$9A49,$9A4A,$9A4B,$9A4C,$9A4D,$9A4E,
$9A4F,$9A50,$9A51,$9A52,$9A53,$9A54,$9A55,$9A56,$9A57,$9A58,$9A59,$9A5A,$9A5B,
$9A5C,$9A5D,$9A5E,$9A5F,$9A60,$9A61,$9A62,$9A63,$9A64,$9A65,$9A66,$9A67,$9A68,
$9A69,$9A6A,$9A6B,$9A6C,$9A6D,$9A6E,$9A6F,$9A70,$9A71,$9A72,$9A73,$9A74,$9A75,
$9A76,$9A77,$9A78,$9A79,$9A7A,$9A7B,$9A7C,$9A7D,$9A7E,$9A80,$9A81,$9A82,$9A83,
$9A84,$9A85,$9A86,$9A87,$9A88,$9A89,$9A8A,$9A8B,$9A8C,$9A8D,$9A8E,$9A8F,$9A90,
$9A91,$9A92,$9A93,$9A94,$9A95,$9A96,$9A97,$9A98,$9A99,$9A9A,$9A9B,$9A9C,$9A9D,
$9A9E,$9A9F,$9AA0,$9AA1,$9AA2,$9AA3,$9AA4,$9AA5,$9AA6,$9AA7,$9AA8,$9AA9,$9AAA,
$9AAB,$9AAC,$9AAD,$9AAE,$9AAF,$9AB0,$9AB1,$9AB2,$9AB3,$9AB4,$9AB5,$9AB6,$9AB7,
$9AB8,$9AB9,$9ABA,$9ABB,$9ABC,$9ABD,$9ABE,$9ABF,$9AC0,$9AC1,$9AC2,$9AC3,$9AC4,
$9AC5,$9AC6,$9AC7,$9AC8,$9AC9,$9ACA,$9ACB,$9ACC,$9ACD,$9ACE,$9ACF,$9AD0,$9AD1,
$9AD2,$9AD3,$9AD4,$9AD5,$9AD6,$9AD7,$9AD8,$9AD9,$9ADA,$9ADB,$9ADC,$9ADD,$9ADE,
$9ADF,$9AE0,$9AE1,$9AE2,$9AE3,$9AE4,$9AE5,$9AE6,$9AE7,$9AE8,$9AE9,$9AEA,$9AEB,
$9AEC,$9AED,$9AEE,$9AEF,$9AF0,$9AF1,$9AF2,$9AF3,$9AF4,$9AF5,$9AF6,$9AF7,$9AF8,
$9AF9,$9AFA,$9AFB,$9AFC,$9AFD,$9AFE,$9B40,$9B41,$9B42,$9B43,$9B44,$9B45,$9B46,
$9B47,$9B48,$9B49,$9B4A,$9B4B,$9B4C,$9B4D,$9B4E,$9B4F,$9B50,$9B51,$9B52,$9B53,
$9B54,$9B55,$9B56,$9B57,$9B58,$9B59,$9B5A,$9B5B,$9B5C,$9B5D,$9B5E,$9B5F,$9B60,
$9B61,$9B62,$9B63,$9B64,$9B65,$9B66,$9B67,$9B68,$9B69,$9B6A,$9B6B,$9B6C,$9B6D,
$9B6E,$9B6F,$9B70,$9B71,$9B72,$9B73,$9B74,$9B75,$9B76,$9B77,$9B78,$9B79,$9B7A,
$9B7B,$9B7C,$9B7D,$9B7E,$9B80,$9B81,$9B82,$9B83,$9B84,$9B85,$9B86,$9B87,$9B88,
$9B89,$9B8A,$9B8B,$9B8C,$9B8D,$9B8E,$9B8F,$9B90,$9B91,$9B92,$9B93,$9B94,$9B95,
$9B96,$9B97,$9B98,$9B99,$9B9A,$9B9B,$9B9C,$9B9D,$9B9E,$9B9F,$9BA0,$9BA1,$9BA2,
$9BA3,$9BA4,$9BA5,$9BA6,$9BA7,$9BA8,$9BA9,$9BAA,$9BAB,$9BAC,$9BAD,$9BAE,$9BAF,
$9BB0,$9BB1,$9BB2,$9BB3,$9BB4,$9BB5,$9BB6,$9BB7,$9BB8,$9BB9,$9BBA,$9BBB,$9BBC,
$9BBD,$9BBE,$9BBF,$9BC0,$9BC1,$9BC2,$9BC3,$9BC4,$9BC5,$9BC6,$9BC7,$9BC8,$9BC9,
$9BCA,$9BCB,$9BCC,$9BCD,$9BCE,$9BCF,$9BD0,$9BD1,$9BD2,$9BD3,$9BD4,$9BD5,$9BD6,
$9BD7,$9BD8,$9BD9,$9BDA,$9BDB,$9BDC,$9BDD,$9BDE,$9BDF,$9BE0,$9BE1,$9BE2,$9BE3,
$9BE4,$9BE5,$9BE6,$9BE7,$9BE8,$9BE9,$9BEA,$9BEB,$9BEC,$9BED,$9BEE,$9BEF,$9BF0,
$9BF1,$9BF2,$9BF3,$9BF4,$9BF5,$9BF6,$9BF7,$9BF8,$9BF9,$9BFA,$9BFB,$9BFC,$9BFD,
$9BFE,$9C40,$9C41,$9C42,$9C43,$9C44,$9C45,$9C46,$9C47,$9C48,$9C49,$9C4A,$9C4B,
$9C4C,$9C4D,$9C4E,$9C4F,$9C50,$9C51,$9C52,$9C53,$9C54,$9C55,$9C56,$9C57,$9C58,
$9C59,$9C5A,$9C5B,$9C5C,$9C5D,$9C5E,$9C5F,$9C60,$9C61,$9C62,$9C63,$9C64,$9C65,
$9C66,$9C67,$9C68,$9C69,$9C6A,$9C6B,$9C6C,$9C6D,$9C6E,$9C6F,$9C70,$9C71,$9C72,
$9C73,$9C74,$9C75,$9C76,$9C77,$9C78,$9C79,$9C7A,$9C7B,$9C7C,$9C7D,$9C7E,$9C80,
$9C81,$9C82,$9C83,$9C84,$9C85,$9C86,$9C87,$9C88,$9C89,$9C8A,$9C8B,$9C8C,$9C8D,
$9C8E,$9C8F,$9C90,$9C91,$9C92,$9C93,$9C94,$9C95,$9C96,$9C97,$9C98,$9C99,$9C9A,
$9C9B,$9C9C,$9C9D,$9C9E,$9C9F,$9CA0,$9CA1,$9CA2,$9CA3,$9CA4,$9CA5,$9CA6,$9CA7,
$9CA8,$9CA9,$9CAA,$9CAB,$9CAC,$9CAD,$9CAE,$9CAF,$9CB0,$9CB1,$9CB2,$9CB3,$9CB4,
$9CB5,$9CB6,$9CB7,$9CB8,$9CB9,$9CBA,$9CBB,$9CBC,$9CBD,$9CBE,$9CBF,$9CC0,$9CC1,
$9CC2,$9CC3,$9CC4,$9CC5,$9CC6,$9CC7,$9CC8,$9CC9,$9CCA,$9CCB,$9CCC,$9CCD,$9CCE,
$9CCF,$9CD0,$9CD1,$9CD2,$9CD3,$9CD4,$9CD5,$9CD6,$9CD7,$9CD8,$9CD9,$9CDA,$9CDB,
$9CDC,$9CDD,$9CDE,$9CDF,$9CE0,$9CE1,$9CE2,$9CE3,$9CE4,$9CE5,$9CE6,$9CE7,$9CE8,
$9CE9,$9CEA,$9CEB,$9CEC,$9CED,$9CEE,$9CEF,$9CF0,$9CF1,$9CF2,$9CF3,$9CF4,$9CF5,
$9CF6,$9CF7,$9CF8,$9CF9,$9CFA,$9CFB,$9CFC,$9CFD,$9CFE,$9D40,$9D41,$9D42,$9D43,
$9D44,$9D45,$9D46,$9D47,$9D48,$9D49,$9D4A,$9D4B,$9D4C,$9D4D,$9D4E,$9D4F,$9D50,
$9D51,$9D52,$9D53,$9D54,$9D55,$9D56,$9D57,$9D58,$9D59,$9D5A,$9D5B,$9D5C,$9D5D,
$9D5E,$9D5F,$9D60,$9D61,$9D62,$9D63,$9D64,$9D65,$9D66,$9D67,$9D68,$9D69,$9D6A,
$9D6B,$9D6C,$9D6D,$9D6E,$9D6F,$9D70,$9D71,$9D72,$9D73,$9D74,$9D75,$9D76,$9D77,
$9D78,$9D79,$9D7A,$9D7B,$9D7C,$9D7D,$9D7E,$9D80,$9D81,$9D82,$9D83,$9D84,$9D85,
$9D86,$9D87,$9D88,$9D89,$9D8A,$9D8B,$9D8C,$9D8D,$9D8E,$9D8F,$9D90,$9D91,$9D92,
$9D93,$9D94,$9D95,$9D96,$9D97,$9D98,$9D99,$9D9A,$9D9B,$9D9C,$9D9D,$9D9E,$9D9F,
$9DA0,$9DA1,$9DA2,$9DA3,$9DA4,$9DA5,$9DA6,$9DA7,$9DA8,$9DA9,$9DAA,$9DAB,$9DAC,
$9DAD,$9DAE,$9DAF,$9DB0,$9DB1,$9DB2,$9DB3,$9DB4,$9DB5,$9DB6,$9DB7,$9DB8,$9DB9,
$9DBA,$9DBB,$9DBC,$9DBD,$9DBE,$9DBF,$9DC0,$9DC1,$9DC2,$9DC3,$9DC4,$9DC5,$9DC6,
$9DC7,$9DC8,$9DC9,$9DCA,$9DCB,$9DCC,$9DCD,$9DCE,$9DCF,$9DD0,$9DD1,$9DD2,$9DD3,
$9DD4,$9DD5,$9DD6,$9DD7,$9DD8,$9DD9,$9DDA,$9DDB,$9DDC,$9DDD,$9DDE,$9DDF,$9DE0,
$9DE1,$9DE2,$9DE3,$9DE4,$9DE5,$9DE6,$9DE7,$9DE8,$9DE9,$9DEA,$9DEB,$9DEC,$9DED,
$9DEE,$9DEF,$9DF0,$9DF1,$9DF2,$9DF3,$9DF4,$9DF5,$9DF6,$9DF7,$9DF8,$9DF9,$9DFA,
$9DFB,$9DFC,$9DFD,$9DFE,$9E40,$9E41,$9E42,$9E43,$9E44,$9E45,$9E46,$9E47,$9E48,
$9E49,$9E4A,$9E4B,$9E4C,$9E4D,$9E4E,$9E4F,$9E50,$9E51,$9E52,$9E53,$9E54,$9E55,
$9E56,$9E57,$9E58,$9E59,$9E5A,$9E5B,$9E5C,$9E5D,$9E5E,$9E5F,$9E60,$9E61,$9E62,
$9E63,$9E64,$9E65,$9E66,$9E67,$9E68,$9E69,$9E6A,$9E6B,$9E6C,$9E6D,$9E6E,$9E6F,
$9E70,$9E71,$9E72,$9E73,$9E74,$9E75,$9E76,$9E77,$9E78,$9E79,$9E7A,$9E7B,$9E7C,
$9E7D,$9E7E,$9E80,$9E81,$9E82,$9E83,$9E84,$9E85,$9E86,$9E87,$9E88,$9E89,$9E8A,
$9E8B,$9E8C,$9E8D,$9E8E,$9E8F,$9E90,$9E91,$9E92,$9E93,$9E94,$9E95,$9E96,$9E97,
$9E98,$9E99,$9E9A,$9E9B,$9E9C,$9E9D,$9E9E,$9E9F,$9EA0,$9EA1,$9EA2,$9EA3,$9EA4,
$9EA5,$9EA6,$9EA7,$9EA8,$9EA9,$9EAA,$9EAB,$9EAC,$9EAD,$9EAE,$9EAF,$9EB0,$9EB1,
$9EB2,$9EB3,$9EB4,$9EB5,$9EB6,$9EB7,$9EB8,$9EB9,$9EBA,$9EBB,$9EBC,$9EBD,$9EBE,
$9EBF,$9EC0,$9EC1,$9EC2,$9EC3,$9EC4,$9EC5,$9EC6,$9EC7,$9EC8,$9EC9,$9ECA,$9ECB,
$9ECC,$9ECD,$9ECE,$9ECF,$9ED0,$9ED1,$9ED2,$9ED3,$9ED4,$9ED5,$9ED6,$9ED7,$9ED8,
$9ED9,$9EDA,$9EDB,$9EDC,$9EDD,$9EDE,$9EDF,$9EE0,$9EE1,$9EE2,$9EE3,$9EE4,$9EE5,
$9EE6,$9EE7,$9EE8,$9EE9,$9EEA,$9EEB,$9EEC,$9EED,$9EEE,$9EEF,$9EF0,$9EF1,$9EF2,
$9EF3,$9EF4,$9EF5,$9EF6,$9EF7,$9EF8,$9EF9,$9EFA,$9EFB,$9EFC,$9EFD,$9EFE,$9F40,
$9F41,$9F42,$9F43,$9F44,$9F45,$9F46,$9F47,$9F48,$9F49,$9F4A,$9F4B,$9F4C,$9F4D,
$9F4E,$9F4F,$9F50,$9F51,$9F52,$9F53,$9F54,$9F55,$9F56,$9F57,$9F58,$9F59,$9F5A,
$9F5B,$9F5C,$9F5D,$9F5E,$9F5F,$9F60,$9F61,$9F62,$9F63,$9F64,$9F65,$9F66,$9F67,
$9F68,$9F69,$9F6A,$9F6B,$9F6C,$9F6D,$9F6E,$9F6F,$9F70,$9F71,$9F72,$9F73,$9F74,
$9F75,$9F76,$9F77,$9F78,$9F79,$9F7A,$9F7B,$9F7C,$9F7D,$9F7E,$9F80,$9F81,$9F82,
$9F83,$9F84,$9F85,$9F86,$9F87,$9F88,$9F89,$9F8A,$9F8B,$9F8C,$9F8D,$9F8E,$9F8F,
$9F90,$9F91,$9F92,$9F93,$9F94,$9F95,$9F96,$9F97,$9F98,$9F99,$9F9A,$9F9B,$9F9C,
$9F9D,$9F9E,$9F9F,$9FA0,$9FA1,$9FA2,$9FA3,$9FA4,$9FA5,$9FA6,$9FA7,$9FA8,$9FA9,
$9FAA,$9FAB,$9FAC,$9FAD,$9FAE,$9FAF,$9FB0,$9FB1,$9FB2,$9FB3,$9FB4,$9FB5,$9FB6,
$9FB7,$9FB8,$9FB9,$9FBA,$9FBB,$9FBC,$9FBD,$9FBE,$9FBF,$9FC0,$9FC1,$9FC2,$9FC3,
$9FC4,$9FC5,$9FC6,$9FC7,$9FC8,$9FC9,$9FCA,$9FCB,$9FCC,$9FCD,$9FCE,$9FCF,$9FD0,
$9FD1,$9FD2,$9FD3,$9FD4,$9FD5,$9FD6,$9FD7,$9FD8,$9FD9,$9FDA,$9FDB,$9FDC,$9FDD,
$9FDE,$9FDF,$9FE0,$9FE1,$9FE2,$9FE3,$9FE4,$9FE5,$9FE6,$9FE7,$9FE8,$9FE9,$9FEA,
$9FEB,$9FEC,$9FED,$9FEE,$9FEF,$9FF0,$9FF1,$9FF2,$9FF3,$9FF4,$9FF5,$9FF6,$9FF7,
$9FF8,$9FF9,$9FFA,$9FFB,$9FFC,$9FFD,$9FFE,$A040,$A041,$A042,$A043,$A044,$A045,
$A046,$A047,$A048,$A049,$A04A,$A04B,$A04C,$A04D,$A04E,$A04F,$A050,$A051,$A052,
$A053,$A054,$A055,$A056,$A057,$A058,$A059,$A05A,$A05B,$A05C,$A05D,$A05E,$A05F,
$A060,$A061,$A062,$A063,$A064,$A065,$A066,$A067,$A068,$A069,$A06A,$A06B,$A06C,
$A06D,$A06E,$A06F,$A070,$A071,$A072,$A073,$A074,$A075,$A076,$A077,$A078,$A079,
$A07A,$A07B,$A07C,$A07D,$A07E,$A080,$A081,$A082,$A083,$A084,$A085,$A086,$A087,
$A088,$A089,$A08A,$A08B,$A08C,$A08D,$A08E,$A08F,$A090,$A091,$A092,$A093,$A094,
$A095,$A096,$A097,$A098,$A099,$A09A,$A09B,$A09C,$A09D,$A09E,$A09F,$A0A0,$A0A1,
$A0A2,$A0A3,$A0A4,$A0A5,$A0A6,$A0A7,$A0A8,$A0A9,$A0AA,$A0AB,$A0AC,$A0AD,$A0AE,
$A0AF,$A0B0,$A0B1,$A0B2,$A0B3,$A0B4,$A0B5,$A0B6,$A0B7,$A0B8,$A0B9,$A0BA,$A0BB,
$A0BC,$A0BD,$A0BE,$A0BF,$A0C0,$A0C1,$A0C2,$A0C3,$A0C4,$A0C5,$A0C6,$A0C7,$A0C8,
$A0C9,$A0CA,$A0CB,$A0CC,$A0CD,$A0CE,$A0CF,$A0D0,$A0D1,$A0D2,$A0D3,$A0D4,$A0D5,
$A0D6,$A0D7,$A0D8,$A0D9,$A0DA,$A0DB,$A0DC,$A0DD,$A0DE,$A0DF,$A0E0,$A0E1,$A0E2,
$A0E3,$A0E4,$A0E5,$A0E6,$A0E7,$A0E8,$A0E9,$A0EA,$A0EB,$A0EC,$A0ED,$A0EE,$A0EF,
$A0F0,$A0F1,$A0F2,$A0F3,$A0F4,$A0F5,$A0F6,$A0F7,$A0F8,$A0F9,$A0FA,$A0FB,$A0FC,
$A0FD,$A0FE,$A1A1,$A1A2,$A1A3,$A1A4,$A1A5,$A1A6,$A1A7,$A1A8,$A1A9,$A1AA,$A1AB,
$A1AC,$A1AD,$A1AE,$A1AF,$A1B0,$A1B1,$A1B2,$A1B3,$A1B4,$A1B5,$A1B6,$A1B7,$A1B8,
$A1B9,$A1BA,$A1BB,$A1BC,$A1BD,$A1BE,$A1BF,$A1C0,$A1C1,$A1C2,$A1C3,$A1C4,$A1C5,
$A1C6,$A1C7,$A1C8,$A1C9,$A1CA,$A1CB,$A1CC,$A1CD,$A1CE,$A1CF,$A1D0,$A1D1,$A1D2,
$A1D3,$A1D4,$A1D5,$A1D6,$A1D7,$A1D8,$A1D9,$A1DA,$A1DB,$A1DC,$A1DD,$A1DE,$A1DF,
$A1E0,$A1E1,$A1E2,$A1E3,$A1E4,$A1E5,$A1E6,$A1E7,$A1E8,$A1E9,$A1EA,$A1EB,$A1EC,
$A1ED,$A1EE,$A1EF,$A1F0,$A1F1,$A1F2,$A1F3,$A1F4,$A1F5,$A1F6,$A1F7,$A1F8,$A1F9,
$A1FA,$A1FB,$A1FC,$A1FD,$A1FE,$A2A1,$A2A2,$A2A3,$A2A4,$A2A5,$A2A6,$A2A7,$A2A8,
$A2A9,$A2AA,$A2B1,$A2B2,$A2B3,$A2B4,$A2B5,$A2B6,$A2B7,$A2B8,$A2B9,$A2BA,$A2BB,
$A2BC,$A2BD,$A2BE,$A2BF,$A2C0,$A2C1,$A2C2,$A2C3,$A2C4,$A2C5,$A2C6,$A2C7,$A2C8,
$A2C9,$A2CA,$A2CB,$A2CC,$A2CD,$A2CE,$A2CF,$A2D0,$A2D1,$A2D2,$A2D3,$A2D4,$A2D5,
$A2D6,$A2D7,$A2D8,$A2D9,$A2DA,$A2DB,$A2DC,$A2DD,$A2DE,$A2DF,$A2E0,$A2E1,$A2E2,
$A2E5,$A2E6,$A2E7,$A2E8,$A2E9,$A2EA,$A2EB,$A2EC,$A2ED,$A2EE,$A2F1,$A2F2,$A2F3,
$A2F4,$A2F5,$A2F6,$A2F7,$A2F8,$A2F9,$A2FA,$A2FB,$A2FC,$A3A1,$A3A2,$A3A3,$A3A4,
$A3A5,$A3A6,$A3A7,$A3A8,$A3A9,$A3AA,$A3AB,$A3AC,$A3AD,$A3AE,$A3AF,$A3B0,$A3B1,
$A3B2,$A3B3,$A3B4,$A3B5,$A3B6,$A3B7,$A3B8,$A3B9,$A3BA,$A3BB,$A3BC,$A3BD,$A3BE,
$A3BF,$A3C0,$A3C1,$A3C2,$A3C3,$A3C4,$A3C5,$A3C6,$A3C7,$A3C8,$A3C9,$A3CA,$A3CB,
$A3CC,$A3CD,$A3CE,$A3CF,$A3D0,$A3D1,$A3D2,$A3D3,$A3D4,$A3D5,$A3D6,$A3D7,$A3D8,
$A3D9,$A3DA,$A3DB,$A3DC,$A3DD,$A3DE,$A3DF,$A3E0,$A3E1,$A3E2,$A3E3,$A3E4,$A3E5,
$A3E6,$A3E7,$A3E8,$A3E9,$A3EA,$A3EB,$A3EC,$A3ED,$A3EE,$A3EF,$A3F0,$A3F1,$A3F2,
$A3F3,$A3F4,$A3F5,$A3F6,$A3F7,$A3F8,$A3F9,$A3FA,$A3FB,$A3FC,$A3FD,$A3FE,$A4A1,
$A4A2,$A4A3,$A4A4,$A4A5,$A4A6,$A4A7,$A4A8,$A4A9,$A4AA,$A4AB,$A4AC,$A4AD,$A4AE,
$A4AF,$A4B0,$A4B1,$A4B2,$A4B3,$A4B4,$A4B5,$A4B6,$A4B7,$A4B8,$A4B9,$A4BA,$A4BB,
$A4BC,$A4BD,$A4BE,$A4BF,$A4C0,$A4C1,$A4C2,$A4C3,$A4C4,$A4C5,$A4C6,$A4C7,$A4C8,
$A4C9,$A4CA,$A4CB,$A4CC,$A4CD,$A4CE,$A4CF,$A4D0,$A4D1,$A4D2,$A4D3,$A4D4,$A4D5,
$A4D6,$A4D7,$A4D8,$A4D9,$A4DA,$A4DB,$A4DC,$A4DD,$A4DE,$A4DF,$A4E0,$A4E1,$A4E2,
$A4E3,$A4E4,$A4E5,$A4E6,$A4E7,$A4E8,$A4E9,$A4EA,$A4EB,$A4EC,$A4ED,$A4EE,$A4EF,
$A4F0,$A4F1,$A4F2,$A4F3,$A5A1,$A5A2,$A5A3,$A5A4,$A5A5,$A5A6,$A5A7,$A5A8,$A5A9,
$A5AA,$A5AB,$A5AC,$A5AD,$A5AE,$A5AF,$A5B0,$A5B1,$A5B2,$A5B3,$A5B4,$A5B5,$A5B6,
$A5B7,$A5B8,$A5B9,$A5BA,$A5BB,$A5BC,$A5BD,$A5BE,$A5BF,$A5C0,$A5C1,$A5C2,$A5C3,
$A5C4,$A5C5,$A5C6,$A5C7,$A5C8,$A5C9,$A5CA,$A5CB,$A5CC,$A5CD,$A5CE,$A5CF,$A5D0,
$A5D1,$A5D2,$A5D3,$A5D4,$A5D5,$A5D6,$A5D7,$A5D8,$A5D9,$A5DA,$A5DB,$A5DC,$A5DD,
$A5DE,$A5DF,$A5E0,$A5E1,$A5E2,$A5E3,$A5E4,$A5E5,$A5E6,$A5E7,$A5E8,$A5E9,$A5EA,
$A5EB,$A5EC,$A5ED,$A5EE,$A5EF,$A5F0,$A5F1,$A5F2,$A5F3,$A5F4,$A5F5,$A5F6,$A6A1,
$A6A2,$A6A3,$A6A4,$A6A5,$A6A6,$A6A7,$A6A8,$A6A9,$A6AA,$A6AB,$A6AC,$A6AD,$A6AE,
$A6AF,$A6B0,$A6B1,$A6B2,$A6B3,$A6B4,$A6B5,$A6B6,$A6B7,$A6B8,$A6C1,$A6C2,$A6C3,
$A6C4,$A6C5,$A6C6,$A6C7,$A6C8,$A6C9,$A6CA,$A6CB,$A6CC,$A6CD,$A6CE,$A6CF,$A6D0,
$A6D1,$A6D2,$A6D3,$A6D4,$A6D5,$A6D6,$A6D7,$A6D8,$A6E0,$A6E1,$A6E2,$A6E3,$A6E4,
$A6E5,$A6E6,$A6E7,$A6E8,$A6E9,$A6EA,$A6EB,$A6EE,$A6EF,$A6F0,$A6F1,$A6F2,$A6F4,
$A6F5,$A7A1,$A7A2,$A7A3,$A7A4,$A7A5,$A7A6,$A7A7,$A7A8,$A7A9,$A7AA,$A7AB,$A7AC,
$A7AD,$A7AE,$A7AF,$A7B0,$A7B1,$A7B2,$A7B3,$A7B4,$A7B5,$A7B6,$A7B7,$A7B8,$A7B9,
$A7BA,$A7BB,$A7BC,$A7BD,$A7BE,$A7BF,$A7C0,$A7C1,$A7D1,$A7D2,$A7D3,$A7D4,$A7D5,
$A7D6,$A7D7,$A7D8,$A7D9,$A7DA,$A7DB,$A7DC,$A7DD,$A7DE,$A7DF,$A7E0,$A7E1,$A7E2,
$A7E3,$A7E4,$A7E5,$A7E6,$A7E7,$A7E8,$A7E9,$A7EA,$A7EB,$A7EC,$A7ED,$A7EE,$A7EF,
$A7F0,$A7F1,$A840,$A841,$A842,$A843,$A844,$A845,$A846,$A847,$A848,$A849,$A84A,
$A84B,$A84C,$A84D,$A84E,$A84F,$A850,$A851,$A852,$A853,$A854,$A855,$A856,$A857,
$A858,$A859,$A85A,$A85B,$A85C,$A85D,$A85E,$A85F,$A860,$A861,$A862,$A863,$A864,
$A865,$A866,$A867,$A868,$A869,$A86A,$A86B,$A86C,$A86D,$A86E,$A86F,$A870,$A871,
$A872,$A873,$A874,$A875,$A876,$A877,$A878,$A879,$A87A,$A87B,$A87C,$A87D,$A87E,
$A880,$A881,$A882,$A883,$A884,$A885,$A886,$A887,$A888,$A889,$A88A,$A88B,$A88C,
$A88D,$A88E,$A88F,$A890,$A891,$A892,$A893,$A894,$A895,$A8A1,$A8A2,$A8A3,$A8A4,
$A8A5,$A8A6,$A8A7,$A8A8,$A8A9,$A8AA,$A8AB,$A8AC,$A8AD,$A8AE,$A8AF,$A8B0,$A8B1,
$A8B2,$A8B3,$A8B4,$A8B5,$A8B6,$A8B7,$A8B8,$A8B9,$A8BA,$A8BB,$A8BD,$A8BE,$A8C0,
$A8C5,$A8C6,$A8C7,$A8C8,$A8C9,$A8CA,$A8CB,$A8CC,$A8CD,$A8CE,$A8CF,$A8D0,$A8D1,
$A8D2,$A8D3,$A8D4,$A8D5,$A8D6,$A8D7,$A8D8,$A8D9,$A8DA,$A8DB,$A8DC,$A8DD,$A8DE,
$A8DF,$A8E0,$A8E1,$A8E2,$A8E3,$A8E4,$A8E5,$A8E6,$A8E7,$A8E8,$A8E9,$A940,$A941,
$A942,$A943,$A944,$A945,$A946,$A947,$A948,$A949,$A94A,$A94B,$A94C,$A94D,$A94E,
$A94F,$A950,$A951,$A952,$A953,$A954,$A955,$A956,$A957,$A959,$A95A,$A95C,$A960,
$A961,$A962,$A963,$A964,$A965,$A966,$A967,$A968,$A969,$A96A,$A96B,$A96C,$A96D,
$A96E,$A96F,$A970,$A971,$A972,$A973,$A974,$A975,$A976,$A977,$A978,$A979,$A97A,
$A97B,$A97C,$A97D,$A97E,$A980,$A981,$A982,$A983,$A984,$A985,$A986,$A987,$A988,
$A996,$A9A4,$A9A5,$A9A6,$A9A7,$A9A8,$A9A9,$A9AA,$A9AB,$A9AC,$A9AD,$A9AE,$A9AF,
$A9B0,$A9B1,$A9B2,$A9B3,$A9B4,$A9B5,$A9B6,$A9B7,$A9B8,$A9B9,$A9BA,$A9BB,$A9BC,
$A9BD,$A9BE,$A9BF,$A9C0,$A9C1,$A9C2,$A9C3,$A9C4,$A9C5,$A9C6,$A9C7,$A9C8,$A9C9,
$A9CA,$A9CB,$A9CC,$A9CD,$A9CE,$A9CF,$A9D0,$A9D1,$A9D2,$A9D3,$A9D4,$A9D5,$A9D6,
$A9D7,$A9D8,$A9D9,$A9DA,$A9DB,$A9DC,$A9DD,$A9DE,$A9DF,$A9E0,$A9E1,$A9E2,$A9E3,
$A9E4,$A9E5,$A9E6,$A9E7,$A9E8,$A9E9,$A9EA,$A9EB,$A9EC,$A9ED,$A9EE,$A9EF,$AA40,
$AA41,$AA42,$AA43,$AA44,$AA45,$AA46,$AA47,$AA48,$AA49,$AA4A,$AA4B,$AA4C,$AA4D,
$AA4E,$AA4F,$AA50,$AA51,$AA52,$AA53,$AA54,$AA55,$AA56,$AA57,$AA58,$AA59,$AA5A,
$AA5B,$AA5C,$AA5D,$AA5E,$AA5F,$AA60,$AA61,$AA62,$AA63,$AA64,$AA65,$AA66,$AA67,
$AA68,$AA69,$AA6A,$AA6B,$AA6C,$AA6D,$AA6E,$AA6F,$AA70,$AA71,$AA72,$AA73,$AA74,
$AA75,$AA76,$AA77,$AA78,$AA79,$AA7A,$AA7B,$AA7C,$AA7D,$AA7E,$AA80,$AA81,$AA82,
$AA83,$AA84,$AA85,$AA86,$AA87,$AA88,$AA89,$AA8A,$AA8B,$AA8C,$AA8D,$AA8E,$AA8F,
$AA90,$AA91,$AA92,$AA93,$AA94,$AA95,$AA96,$AA97,$AA98,$AA99,$AA9A,$AA9B,$AA9C,
$AA9D,$AA9E,$AA9F,$AAA0,$AB40,$AB41,$AB42,$AB43,$AB44,$AB45,$AB46,$AB47,$AB48,
$AB49,$AB4A,$AB4B,$AB4C,$AB4D,$AB4E,$AB4F,$AB50,$AB51,$AB52,$AB53,$AB54,$AB55,
$AB56,$AB57,$AB58,$AB59,$AB5A,$AB5B,$AB5C,$AB5D,$AB5E,$AB5F,$AB60,$AB61,$AB62,
$AB63,$AB64,$AB65,$AB66,$AB67,$AB68,$AB69,$AB6A,$AB6B,$AB6C,$AB6D,$AB6E,$AB6F,
$AB70,$AB71,$AB72,$AB73,$AB74,$AB75,$AB76,$AB77,$AB78,$AB79,$AB7A,$AB7B,$AB7C,
$AB7D,$AB7E,$AB80,$AB81,$AB82,$AB83,$AB84,$AB85,$AB86,$AB87,$AB88,$AB89,$AB8A,
$AB8B,$AB8C,$AB8D,$AB8E,$AB8F,$AB90,$AB91,$AB92,$AB93,$AB94,$AB95,$AB96,$AB97,
$AB98,$AB99,$AB9A,$AB9B,$AB9C,$AB9D,$AB9E,$AB9F,$ABA0,$AC40,$AC41,$AC42,$AC43,
$AC44,$AC45,$AC46,$AC47,$AC48,$AC49,$AC4A,$AC4B,$AC4C,$AC4D,$AC4E,$AC4F,$AC50,
$AC51,$AC52,$AC53,$AC54,$AC55,$AC56,$AC57,$AC58,$AC59,$AC5A,$AC5B,$AC5C,$AC5D,
$AC5E,$AC5F,$AC60,$AC61,$AC62,$AC63,$AC64,$AC65,$AC66,$AC67,$AC68,$AC69,$AC6A,
$AC6B,$AC6C,$AC6D,$AC6E,$AC6F,$AC70,$AC71,$AC72,$AC73,$AC74,$AC75,$AC76,$AC77,
$AC78,$AC79,$AC7A,$AC7B,$AC7C,$AC7D,$AC7E,$AC80,$AC81,$AC82,$AC83,$AC84,$AC85,
$AC86,$AC87,$AC88,$AC89,$AC8A,$AC8B,$AC8C,$AC8D,$AC8E,$AC8F,$AC90,$AC91,$AC92,
$AC93,$AC94,$AC95,$AC96,$AC97,$AC98,$AC99,$AC9A,$AC9B,$AC9C,$AC9D,$AC9E,$AC9F,
$ACA0,$AD40,$AD41,$AD42,$AD43,$AD44,$AD45,$AD46,$AD47,$AD48,$AD49,$AD4A,$AD4B,
$AD4C,$AD4D,$AD4E,$AD4F,$AD50,$AD51,$AD52,$AD53,$AD54,$AD55,$AD56,$AD57,$AD58,
$AD59,$AD5A,$AD5B,$AD5C,$AD5D,$AD5E,$AD5F,$AD60,$AD61,$AD62,$AD63,$AD64,$AD65,
$AD66,$AD67,$AD68,$AD69,$AD6A,$AD6B,$AD6C,$AD6D,$AD6E,$AD6F,$AD70,$AD71,$AD72,
$AD73,$AD74,$AD75,$AD76,$AD77,$AD78,$AD79,$AD7A,$AD7B,$AD7C,$AD7D,$AD7E,$AD80,
$AD81,$AD82,$AD83,$AD84,$AD85,$AD86,$AD87,$AD88,$AD89,$AD8A,$AD8B,$AD8C,$AD8D,
$AD8E,$AD8F,$AD90,$AD91,$AD92,$AD93,$AD94,$AD95,$AD96,$AD97,$AD98,$AD99,$AD9A,
$AD9B,$AD9C,$AD9D,$AD9E,$AD9F,$ADA0,$AE40,$AE41,$AE42,$AE43,$AE44,$AE45,$AE46,
$AE47,$AE48,$AE49,$AE4A,$AE4B,$AE4C,$AE4D,$AE4E,$AE4F,$AE50,$AE51,$AE52,$AE53,
$AE54,$AE55,$AE56,$AE57,$AE58,$AE59,$AE5A,$AE5B,$AE5C,$AE5D,$AE5E,$AE5F,$AE60,
$AE61,$AE62,$AE63,$AE64,$AE65,$AE66,$AE67,$AE68,$AE69,$AE6A,$AE6B,$AE6C,$AE6D,
$AE6E,$AE6F,$AE70,$AE71,$AE72,$AE73,$AE74,$AE75,$AE76,$AE77,$AE78,$AE79,$AE7A,
$AE7B,$AE7C,$AE7D,$AE7E,$AE80,$AE81,$AE82,$AE83,$AE84,$AE85,$AE86,$AE87,$AE88,
$AE89,$AE8A,$AE8B,$AE8C,$AE8D,$AE8E,$AE8F,$AE90,$AE91,$AE92,$AE93,$AE94,$AE95,
$AE96,$AE97,$AE98,$AE99,$AE9A,$AE9B,$AE9C,$AE9D,$AE9E,$AE9F,$AEA0,$AF40,$AF41,
$AF42,$AF43,$AF44,$AF45,$AF46,$AF47,$AF48,$AF49,$AF4A,$AF4B,$AF4C,$AF4D,$AF4E,
$AF4F,$AF50,$AF51,$AF52,$AF53,$AF54,$AF55,$AF56,$AF57,$AF58,$AF59,$AF5A,$AF5B,
$AF5C,$AF5D,$AF5E,$AF5F,$AF60,$AF61,$AF62,$AF63,$AF64,$AF65,$AF66,$AF67,$AF68,
$AF69,$AF6A,$AF6B,$AF6C,$AF6D,$AF6E,$AF6F,$AF70,$AF71,$AF72,$AF73,$AF74,$AF75,
$AF76,$AF77,$AF78,$AF79,$AF7A,$AF7B,$AF7C,$AF7D,$AF7E,$AF80,$AF81,$AF82,$AF83,
$AF84,$AF85,$AF86,$AF87,$AF88,$AF89,$AF8A,$AF8B,$AF8C,$AF8D,$AF8E,$AF8F,$AF90,
$AF91,$AF92,$AF93,$AF94,$AF95,$AF96,$AF97,$AF98,$AF99,$AF9A,$AF9B,$AF9C,$AF9D,
$AF9E,$AF9F,$AFA0,$B040,$B041,$B042,$B043,$B044,$B045,$B046,$B047,$B048,$B049,
$B04A,$B04B,$B04C,$B04D,$B04E,$B04F,$B050,$B051,$B052,$B053,$B054,$B055,$B056,
$B057,$B058,$B059,$B05A,$B05B,$B05C,$B05D,$B05E,$B05F,$B060,$B061,$B062,$B063,
$B064,$B065,$B066,$B067,$B068,$B069,$B06A,$B06B,$B06C,$B06D,$B06E,$B06F,$B070,
$B071,$B072,$B073,$B074,$B075,$B076,$B077,$B078,$B079,$B07A,$B07B,$B07C,$B07D,
$B07E,$B080,$B081,$B082,$B083,$B084,$B085,$B086,$B087,$B088,$B089,$B08A,$B08B,
$B08C,$B08D,$B08E,$B08F,$B090,$B091,$B092,$B093,$B094,$B095,$B096,$B097,$B098,
$B099,$B09A,$B09B,$B09C,$B09D,$B09E,$B09F,$B0A0,$B0A1,$B0A2,$B0A3,$B0A4,$B0A5,
$B0A6,$B0A7,$B0A8,$B0A9,$B0AA,$B0AB,$B0AC,$B0AD,$B0AE,$B0AF,$B0B0,$B0B1,$B0B2,
$B0B3,$B0B4,$B0B5,$B0B6,$B0B7,$B0B8,$B0B9,$B0BA,$B0BB,$B0BC,$B0BD,$B0BE,$B0BF,
$B0C0,$B0C1,$B0C2,$B0C3,$B0C4,$B0C5,$B0C6,$B0C7,$B0C8,$B0C9,$B0CA,$B0CB,$B0CC,
$B0CD,$B0CE,$B0CF,$B0D0,$B0D1,$B0D2,$B0D3,$B0D4,$B0D5,$B0D6,$B0D7,$B0D8,$B0D9,
$B0DA,$B0DB,$B0DC,$B0DD,$B0DE,$B0DF,$B0E0,$B0E1,$B0E2,$B0E3,$B0E4,$B0E5,$B0E6,
$B0E7,$B0E8,$B0E9,$B0EA,$B0EB,$B0EC,$B0ED,$B0EE,$B0EF,$B0F0,$B0F1,$B0F2,$B0F3,
$B0F4,$B0F5,$B0F6,$B0F7,$B0F8,$B0F9,$B0FA,$B0FB,$B0FC,$B0FD,$B0FE,$B140,$B141,
$B142,$B143,$B144,$B145,$B146,$B147,$B148,$B149,$B14A,$B14B,$B14C,$B14D,$B14E,
$B14F,$B150,$B151,$B152,$B153,$B154,$B155,$B156,$B157,$B158,$B159,$B15A,$B15B,
$B15C,$B15D,$B15E,$B15F,$B160,$B161,$B162,$B163,$B164,$B165,$B166,$B167,$B168,
$B169,$B16A,$B16B,$B16C,$B16D,$B16E,$B16F,$B170,$B171,$B172,$B173,$B174,$B175,
$B176,$B177,$B178,$B179,$B17A,$B17B,$B17C,$B17D,$B17E,$B180,$B181,$B182,$B183,
$B184,$B185,$B186,$B187,$B188,$B189,$B18A,$B18B,$B18C,$B18D,$B18E,$B18F,$B190,
$B191,$B192,$B193,$B194,$B195,$B196,$B197,$B198,$B199,$B19A,$B19B,$B19C,$B19D,
$B19E,$B19F,$B1A0,$B1A1,$B1A2,$B1A3,$B1A4,$B1A5,$B1A6,$B1A7,$B1A8,$B1A9,$B1AA,
$B1AB,$B1AC,$B1AD,$B1AE,$B1AF,$B1B0,$B1B1,$B1B2,$B1B3,$B1B4,$B1B5,$B1B6,$B1B7,
$B1B8,$B1B9,$B1BA,$B1BB,$B1BC,$B1BD,$B1BE,$B1BF,$B1C0,$B1C1,$B1C2,$B1C3,$B1C4,
$B1C5,$B1C6,$B1C7,$B1C8,$B1C9,$B1CA,$B1CB,$B1CC,$B1CD,$B1CE,$B1CF,$B1D0,$B1D1,
$B1D2,$B1D3,$B1D4,$B1D5,$B1D6,$B1D7,$B1D8,$B1D9,$B1DA,$B1DB,$B1DC,$B1DD,$B1DE,
$B1DF,$B1E0,$B1E1,$B1E2,$B1E3,$B1E4,$B1E5,$B1E6,$B1E7,$B1E8,$B1E9,$B1EA,$B1EB,
$B1EC,$B1ED,$B1EE,$B1EF,$B1F0,$B1F1,$B1F2,$B1F3,$B1F4,$B1F5,$B1F6,$B1F7,$B1F8,
$B1F9,$B1FA,$B1FB,$B1FC,$B1FD,$B1FE,$B240,$B241,$B242,$B243,$B244,$B245,$B246,
$B247,$B248,$B249,$B24A,$B24B,$B24C,$B24D,$B24E,$B24F,$B250,$B251,$B252,$B253,
$B254,$B255,$B256,$B257,$B258,$B259,$B25A,$B25B,$B25C,$B25D,$B25E,$B25F,$B260,
$B261,$B262,$B263,$B264,$B265,$B266,$B267,$B268,$B269,$B26A,$B26B,$B26C,$B26D,
$B26E,$B26F,$B270,$B271,$B272,$B273,$B274,$B275,$B276,$B277,$B278,$B279,$B27A,
$B27B,$B27C,$B27D,$B27E,$B280,$B281,$B282,$B283,$B284,$B285,$B286,$B287,$B288,
$B289,$B28A,$B28B,$B28C,$B28D,$B28E,$B28F,$B290,$B291,$B292,$B293,$B294,$B295,
$B296,$B297,$B298,$B299,$B29A,$B29B,$B29C,$B29D,$B29E,$B29F,$B2A0,$B2A1,$B2A2,
$B2A3,$B2A4,$B2A5,$B2A6,$B2A7,$B2A8,$B2A9,$B2AA,$B2AB,$B2AC,$B2AD,$B2AE,$B2AF,
$B2B0,$B2B1,$B2B2,$B2B3,$B2B4,$B2B5,$B2B6,$B2B7,$B2B8,$B2B9,$B2BA,$B2BB,$B2BC,
$B2BD,$B2BE,$B2BF,$B2C0,$B2C1,$B2C2,$B2C3,$B2C4,$B2C5,$B2C6,$B2C7,$B2C8,$B2C9,
$B2CA,$B2CB,$B2CC,$B2CD,$B2CE,$B2CF,$B2D0,$B2D1,$B2D2,$B2D3,$B2D4,$B2D5,$B2D6,
$B2D7,$B2D8,$B2D9,$B2DA,$B2DB,$B2DC,$B2DD,$B2DE,$B2DF,$B2E0,$B2E1,$B2E2,$B2E3,
$B2E4,$B2E5,$B2E6,$B2E7,$B2E8,$B2E9,$B2EA,$B2EB,$B2EC,$B2ED,$B2EE,$B2EF,$B2F0,
$B2F1,$B2F2,$B2F3,$B2F4,$B2F5,$B2F6,$B2F7,$B2F8,$B2F9,$B2FA,$B2FB,$B2FC,$B2FD,
$B2FE,$B340,$B341,$B342,$B343,$B344,$B345,$B346,$B347,$B348,$B349,$B34A,$B34B,
$B34C,$B34D,$B34E,$B34F,$B350,$B351,$B352,$B353,$B354,$B355,$B356,$B357,$B358,
$B359,$B35A,$B35B,$B35C,$B35D,$B35E,$B35F,$B360,$B361,$B362,$B363,$B364,$B365,
$B366,$B367,$B368,$B369,$B36A,$B36B,$B36C,$B36D,$B36E,$B36F,$B370,$B371,$B372,
$B373,$B374,$B375,$B376,$B377,$B378,$B379,$B37A,$B37B,$B37C,$B37D,$B37E,$B380,
$B381,$B382,$B383,$B384,$B385,$B386,$B387,$B388,$B389,$B38A,$B38B,$B38C,$B38D,
$B38E,$B38F,$B390,$B391,$B392,$B393,$B394,$B395,$B396,$B397,$B398,$B399,$B39A,
$B39B,$B39C,$B39D,$B39E,$B39F,$B3A0,$B3A1,$B3A2,$B3A3,$B3A4,$B3A5,$B3A6,$B3A7,
$B3A8,$B3A9,$B3AA,$B3AB,$B3AC,$B3AD,$B3AE,$B3AF,$B3B0,$B3B1,$B3B2,$B3B3,$B3B4,
$B3B5,$B3B6,$B3B7,$B3B8,$B3B9,$B3BA,$B3BB,$B3BC,$B3BD,$B3BE,$B3BF,$B3C0,$B3C1,
$B3C2,$B3C3,$B3C4,$B3C5,$B3C6,$B3C7,$B3C8,$B3C9,$B3CA,$B3CB,$B3CC,$B3CD,$B3CE,
$B3CF,$B3D0,$B3D1,$B3D2,$B3D3,$B3D4,$B3D5,$B3D6,$B3D7,$B3D8,$B3D9,$B3DA,$B3DB,
$B3DC,$B3DD,$B3DE,$B3DF,$B3E0,$B3E1,$B3E2,$B3E3,$B3E4,$B3E5,$B3E6,$B3E7,$B3E8,
$B3E9,$B3EA,$B3EB,$B3EC,$B3ED,$B3EE,$B3EF,$B3F0,$B3F1,$B3F2,$B3F3,$B3F4,$B3F5,
$B3F6,$B3F7,$B3F8,$B3F9,$B3FA,$B3FB,$B3FC,$B3FD,$B3FE,$B440,$B441,$B442,$B443,
$B444,$B445,$B446,$B447,$B448,$B449,$B44A,$B44B,$B44C,$B44D,$B44E,$B44F,$B450,
$B451,$B452,$B453,$B454,$B455,$B456,$B457,$B458,$B459,$B45A,$B45B,$B45C,$B45D,
$B45E,$B45F,$B460,$B461,$B462,$B463,$B464,$B465,$B466,$B467,$B468,$B469,$B46A,
$B46B,$B46C,$B46D,$B46E,$B46F,$B470,$B471,$B472,$B473,$B474,$B475,$B476,$B477,
$B478,$B479,$B47A,$B47B,$B47C,$B47D,$B47E,$B480,$B481,$B482,$B483,$B484,$B485,
$B486,$B487,$B488,$B489,$B48A,$B48B,$B48C,$B48D,$B48E,$B48F,$B490,$B491,$B492,
$B493,$B494,$B495,$B496,$B497,$B498,$B499,$B49A,$B49B,$B49C,$B49D,$B49E,$B49F,
$B4A0,$B4A1,$B4A2,$B4A3,$B4A4,$B4A5,$B4A6,$B4A7,$B4A8,$B4A9,$B4AA,$B4AB,$B4AC,
$B4AD,$B4AE,$B4AF,$B4B0,$B4B1,$B4B2,$B4B3,$B4B4,$B4B5,$B4B6,$B4B7,$B4B8,$B4B9,
$B4BA,$B4BB,$B4BC,$B4BD,$B4BE,$B4BF,$B4C0,$B4C1,$B4C2,$B4C3,$B4C4,$B4C5,$B4C6,
$B4C7,$B4C8,$B4C9,$B4CA,$B4CB,$B4CC,$B4CD,$B4CE,$B4CF,$B4D0,$B4D1,$B4D2,$B4D3,
$B4D4,$B4D5,$B4D6,$B4D7,$B4D8,$B4D9,$B4DA,$B4DB,$B4DC,$B4DD,$B4DE,$B4DF,$B4E0,
$B4E1,$B4E2,$B4E3,$B4E4,$B4E5,$B4E6,$B4E7,$B4E8,$B4E9,$B4EA,$B4EB,$B4EC,$B4ED,
$B4EE,$B4EF,$B4F0,$B4F1,$B4F2,$B4F3,$B4F4,$B4F5,$B4F6,$B4F7,$B4F8,$B4F9,$B4FA,
$B4FB,$B4FC,$B4FD,$B4FE,$B540,$B541,$B542,$B543,$B544,$B545,$B546,$B547,$B548,
$B549,$B54A,$B54B,$B54C,$B54D,$B54E,$B54F,$B550,$B551,$B552,$B553,$B554,$B555,
$B556,$B557,$B558,$B559,$B55A,$B55B,$B55C,$B55D,$B55E,$B55F,$B560,$B561,$B562,
$B563,$B564,$B565,$B566,$B567,$B568,$B569,$B56A,$B56B,$B56C,$B56D,$B56E,$B56F,
$B570,$B571,$B572,$B573,$B574,$B575,$B576,$B577,$B578,$B579,$B57A,$B57B,$B57C,
$B57D,$B57E,$B580,$B581,$B582,$B583,$B584,$B585,$B586,$B587,$B588,$B589,$B58A,
$B58B,$B58C,$B58D,$B58E,$B58F,$B590,$B591,$B592,$B593,$B594,$B595,$B596,$B597,
$B598,$B599,$B59A,$B59B,$B59C,$B59D,$B59E,$B59F,$B5A0,$B5A1,$B5A2,$B5A3,$B5A4,
$B5A5,$B5A6,$B5A7,$B5A8,$B5A9,$B5AA,$B5AB,$B5AC,$B5AD,$B5AE,$B5AF,$B5B0,$B5B1,
$B5B2,$B5B3,$B5B4,$B5B5,$B5B6,$B5B7,$B5B8,$B5B9,$B5BA,$B5BB,$B5BC,$B5BD,$B5BE,
$B5BF,$B5C0,$B5C1,$B5C2,$B5C3,$B5C4,$B5C5,$B5C6,$B5C7,$B5C8,$B5C9,$B5CA,$B5CB,
$B5CC,$B5CD,$B5CE,$B5CF,$B5D0,$B5D1,$B5D2,$B5D3,$B5D4,$B5D5,$B5D6,$B5D7,$B5D8,
$B5D9,$B5DA,$B5DB,$B5DC,$B5DD,$B5DE,$B5DF,$B5E0,$B5E1,$B5E2,$B5E3,$B5E4,$B5E5,
$B5E6,$B5E7,$B5E8,$B5E9,$B5EA,$B5EB,$B5EC,$B5ED,$B5EE,$B5EF,$B5F0,$B5F1,$B5F2,
$B5F3,$B5F4,$B5F5,$B5F6,$B5F7,$B5F8,$B5F9,$B5FA,$B5FB,$B5FC,$B5FD,$B5FE,$B640,
$B641,$B642,$B643,$B644,$B645,$B646,$B647,$B648,$B649,$B64A,$B64B,$B64C,$B64D,
$B64E,$B64F,$B650,$B651,$B652,$B653,$B654,$B655,$B656,$B657,$B658,$B659,$B65A,
$B65B,$B65C,$B65D,$B65E,$B65F,$B660,$B661,$B662,$B663,$B664,$B665,$B666,$B667,
$B668,$B669,$B66A,$B66B,$B66C,$B66D,$B66E,$B66F,$B670,$B671,$B672,$B673,$B674,
$B675,$B676,$B677,$B678,$B679,$B67A,$B67B,$B67C,$B67D,$B67E,$B680,$B681,$B682,
$B683,$B684,$B685,$B686,$B687,$B688,$B689,$B68A,$B68B,$B68C,$B68D,$B68E,$B68F,
$B690,$B691,$B692,$B693,$B694,$B695,$B696,$B697,$B698,$B699,$B69A,$B69B,$B69C,
$B69D,$B69E,$B69F,$B6A0,$B6A1,$B6A2,$B6A3,$B6A4,$B6A5,$B6A6,$B6A7,$B6A8,$B6A9,
$B6AA,$B6AB,$B6AC,$B6AD,$B6AE,$B6AF,$B6B0,$B6B1,$B6B2,$B6B3,$B6B4,$B6B5,$B6B6,
$B6B7,$B6B8,$B6B9,$B6BA,$B6BB,$B6BC,$B6BD,$B6BE,$B6BF,$B6C0,$B6C1,$B6C2,$B6C3,
$B6C4,$B6C5,$B6C6,$B6C7,$B6C8,$B6C9,$B6CA,$B6CB,$B6CC,$B6CD,$B6CE,$B6CF,$B6D0,
$B6D1,$B6D2,$B6D3,$B6D4,$B6D5,$B6D6,$B6D7,$B6D8,$B6D9,$B6DA,$B6DB,$B6DC,$B6DD,
$B6DE,$B6DF,$B6E0,$B6E1,$B6E2,$B6E3,$B6E4,$B6E5,$B6E6,$B6E7,$B6E8,$B6E9,$B6EA,
$B6EB,$B6EC,$B6ED,$B6EE,$B6EF,$B6F0,$B6F1,$B6F2,$B6F3,$B6F4,$B6F5,$B6F6,$B6F7,
$B6F8,$B6F9,$B6FA,$B6FB,$B6FC,$B6FD,$B6FE,$B740,$B741,$B742,$B743,$B744,$B745,
$B746,$B747,$B748,$B749,$B74A,$B74B,$B74C,$B74D,$B74E,$B74F,$B750,$B751,$B752,
$B753,$B754,$B755,$B756,$B757,$B758,$B759,$B75A,$B75B,$B75C,$B75D,$B75E,$B75F,
$B760,$B761,$B762,$B763,$B764,$B765,$B766,$B767,$B768,$B769,$B76A,$B76B,$B76C,
$B76D,$B76E,$B76F,$B770,$B771,$B772,$B773,$B774,$B775,$B776,$B777,$B778,$B779,
$B77A,$B77B,$B77C,$B77D,$B77E,$B780,$B781,$B782,$B783,$B784,$B785,$B786,$B787,
$B788,$B789,$B78A,$B78B,$B78C,$B78D,$B78E,$B78F,$B790,$B791,$B792,$B793,$B794,
$B795,$B796,$B797,$B798,$B799,$B79A,$B79B,$B79C,$B79D,$B79E,$B79F,$B7A0,$B7A1,
$B7A2,$B7A3,$B7A4,$B7A5,$B7A6,$B7A7,$B7A8,$B7A9,$B7AA,$B7AB,$B7AC,$B7AD,$B7AE,
$B7AF,$B7B0,$B7B1,$B7B2,$B7B3,$B7B4,$B7B5,$B7B6,$B7B7,$B7B8,$B7B9,$B7BA,$B7BB,
$B7BC,$B7BD,$B7BE,$B7BF,$B7C0,$B7C1,$B7C2,$B7C3,$B7C4,$B7C5,$B7C6,$B7C7,$B7C8,
$B7C9,$B7CA,$B7CB,$B7CC,$B7CD,$B7CE,$B7CF,$B7D0,$B7D1,$B7D2,$B7D3,$B7D4,$B7D5,
$B7D6,$B7D7,$B7D8,$B7D9,$B7DA,$B7DB,$B7DC,$B7DD,$B7DE,$B7DF,$B7E0,$B7E1,$B7E2,
$B7E3,$B7E4,$B7E5,$B7E6,$B7E7,$B7E8,$B7E9,$B7EA,$B7EB,$B7EC,$B7ED,$B7EE,$B7EF,
$B7F0,$B7F1,$B7F2,$B7F3,$B7F4,$B7F5,$B7F6,$B7F7,$B7F8,$B7F9,$B7FA,$B7FB,$B7FC,
$B7FD,$B7FE,$B840,$B841,$B842,$B843,$B844,$B845,$B846,$B847,$B848,$B849,$B84A,
$B84B,$B84C,$B84D,$B84E,$B84F,$B850,$B851,$B852,$B853,$B854,$B855,$B856,$B857,
$B858,$B859,$B85A,$B85B,$B85C,$B85D,$B85E,$B85F,$B860,$B861,$B862,$B863,$B864,
$B865,$B866,$B867,$B868,$B869,$B86A,$B86B,$B86C,$B86D,$B86E,$B86F,$B870,$B871,
$B872,$B873,$B874,$B875,$B876,$B877,$B878,$B879,$B87A,$B87B,$B87C,$B87D,$B87E,
$B880,$B881,$B882,$B883,$B884,$B885,$B886,$B887,$B888,$B889,$B88A,$B88B,$B88C,
$B88D,$B88E,$B88F,$B890,$B891,$B892,$B893,$B894,$B895,$B896,$B897,$B898,$B899,
$B89A,$B89B,$B89C,$B89D,$B89E,$B89F,$B8A0,$B8A1,$B8A2,$B8A3,$B8A4,$B8A5,$B8A6,
$B8A7,$B8A8,$B8A9,$B8AA,$B8AB,$B8AC,$B8AD,$B8AE,$B8AF,$B8B0,$B8B1,$B8B2,$B8B3,
$B8B4,$B8B5,$B8B6,$B8B7,$B8B8,$B8B9,$B8BA,$B8BB,$B8BC,$B8BD,$B8BE,$B8BF,$B8C0,
$B8C1,$B8C2,$B8C3,$B8C4,$B8C5,$B8C6,$B8C7,$B8C8,$B8C9,$B8CA,$B8CB,$B8CC,$B8CD,
$B8CE,$B8CF,$B8D0,$B8D1,$B8D2,$B8D3,$B8D4,$B8D5,$B8D6,$B8D7,$B8D8,$B8D9,$B8DA,
$B8DB,$B8DC,$B8DD,$B8DE,$B8DF,$B8E0,$B8E1,$B8E2,$B8E3,$B8E4,$B8E5,$B8E6,$B8E7,
$B8E8,$B8E9,$B8EA,$B8EB,$B8EC,$B8ED,$B8EE,$B8EF,$B8F0,$B8F1,$B8F2,$B8F3,$B8F4,
$B8F5,$B8F6,$B8F7,$B8F8,$B8F9,$B8FA,$B8FB,$B8FC,$B8FD,$B8FE,$B940,$B941,$B942,
$B943,$B944,$B945,$B946,$B947,$B948,$B949,$B94A,$B94B,$B94C,$B94D,$B94E,$B94F,
$B950,$B951,$B952,$B953,$B954,$B955,$B956,$B957,$B958,$B959,$B95A,$B95B,$B95C,
$B95D,$B95E,$B95F,$B960,$B961,$B962,$B963,$B964,$B965,$B966,$B967,$B968,$B969,
$B96A,$B96B,$B96C,$B96D,$B96E,$B96F,$B970,$B971,$B972,$B973,$B974,$B975,$B976,
$B977,$B978,$B979,$B97A,$B97B,$B97C,$B97D,$B97E,$B980,$B981,$B982,$B983,$B984,
$B985,$B986,$B987,$B988,$B989,$B98A,$B98B,$B98C,$B98D,$B98E,$B98F,$B990,$B991,
$B992,$B993,$B994,$B995,$B996,$B997,$B998,$B999,$B99A,$B99B,$B99C,$B99D,$B99E,
$B99F,$B9A0,$B9A1,$B9A2,$B9A3,$B9A4,$B9A5,$B9A6,$B9A7,$B9A8,$B9A9,$B9AA,$B9AB,
$B9AC,$B9AD,$B9AE,$B9AF,$B9B0,$B9B1,$B9B2,$B9B3,$B9B4,$B9B5,$B9B6,$B9B7,$B9B8,
$B9B9,$B9BA,$B9BB,$B9BC,$B9BD,$B9BE,$B9BF,$B9C0,$B9C1,$B9C2,$B9C3,$B9C4,$B9C5,
$B9C6,$B9C7,$B9C8,$B9C9,$B9CA,$B9CB,$B9CC,$B9CD,$B9CE,$B9CF,$B9D0,$B9D1,$B9D2,
$B9D3,$B9D4,$B9D5,$B9D6,$B9D7,$B9D8,$B9D9,$B9DA,$B9DB,$B9DC,$B9DD,$B9DE,$B9DF,
$B9E0,$B9E1,$B9E2,$B9E3,$B9E4,$B9E5,$B9E6,$B9E7,$B9E8,$B9E9,$B9EA,$B9EB,$B9EC,
$B9ED,$B9EE,$B9EF,$B9F0,$B9F1,$B9F2,$B9F3,$B9F4,$B9F5,$B9F6,$B9F7,$B9F8,$B9F9,
$B9FA,$B9FB,$B9FC,$B9FD,$B9FE,$BA40,$BA41,$BA42,$BA43,$BA44,$BA45,$BA46,$BA47,
$BA48,$BA49,$BA4A,$BA4B,$BA4C,$BA4D,$BA4E,$BA4F,$BA50,$BA51,$BA52,$BA53,$BA54,
$BA55,$BA56,$BA57,$BA58,$BA59,$BA5A,$BA5B,$BA5C,$BA5D,$BA5E,$BA5F,$BA60,$BA61,
$BA62,$BA63,$BA64,$BA65,$BA66,$BA67,$BA68,$BA69,$BA6A,$BA6B,$BA6C,$BA6D,$BA6E,
$BA6F,$BA70,$BA71,$BA72,$BA73,$BA74,$BA75,$BA76,$BA77,$BA78,$BA79,$BA7A,$BA7B,
$BA7C,$BA7D,$BA7E,$BA80,$BA81,$BA82,$BA83,$BA84,$BA85,$BA86,$BA87,$BA88,$BA89,
$BA8A,$BA8B,$BA8C,$BA8D,$BA8E,$BA8F,$BA90,$BA91,$BA92,$BA93,$BA94,$BA95,$BA96,
$BA97,$BA98,$BA99,$BA9A,$BA9B,$BA9C,$BA9D,$BA9E,$BA9F,$BAA0,$BAA1,$BAA2,$BAA3,
$BAA4,$BAA5,$BAA6,$BAA7,$BAA8,$BAA9,$BAAA,$BAAB,$BAAC,$BAAD,$BAAE,$BAAF,$BAB0,
$BAB1,$BAB2,$BAB3,$BAB4,$BAB5,$BAB6,$BAB7,$BAB8,$BAB9,$BABA,$BABB,$BABC,$BABD,
$BABE,$BABF,$BAC0,$BAC1,$BAC2,$BAC3,$BAC4,$BAC5,$BAC6,$BAC7,$BAC8,$BAC9,$BACA,
$BACB,$BACC,$BACD,$BACE,$BACF,$BAD0,$BAD1,$BAD2,$BAD3,$BAD4,$BAD5,$BAD6,$BAD7,
$BAD8,$BAD9,$BADA,$BADB,$BADC,$BADD,$BADE,$BADF,$BAE0,$BAE1,$BAE2,$BAE3,$BAE4,
$BAE5,$BAE6,$BAE7,$BAE8,$BAE9,$BAEA,$BAEB,$BAEC,$BAED,$BAEE,$BAEF,$BAF0,$BAF1,
$BAF2,$BAF3,$BAF4,$BAF5,$BAF6,$BAF7,$BAF8,$BAF9,$BAFA,$BAFB,$BAFC,$BAFD,$BAFE,
$BB40,$BB41,$BB42,$BB43,$BB44,$BB45,$BB46,$BB47,$BB48,$BB49,$BB4A,$BB4B,$BB4C,
$BB4D,$BB4E,$BB4F,$BB50,$BB51,$BB52,$BB53,$BB54,$BB55,$BB56,$BB57,$BB58,$BB59,
$BB5A,$BB5B,$BB5C,$BB5D,$BB5E,$BB5F,$BB60,$BB61,$BB62,$BB63,$BB64,$BB65,$BB66,
$BB67,$BB68,$BB69,$BB6A,$BB6B,$BB6C,$BB6D,$BB6E,$BB6F,$BB70,$BB71,$BB72,$BB73,
$BB74,$BB75,$BB76,$BB77,$BB78,$BB79,$BB7A,$BB7B,$BB7C,$BB7D,$BB7E,$BB80,$BB81,
$BB82,$BB83,$BB84,$BB85,$BB86,$BB87,$BB88,$BB89,$BB8A,$BB8B,$BB8C,$BB8D,$BB8E,
$BB8F,$BB90,$BB91,$BB92,$BB93,$BB94,$BB95,$BB96,$BB97,$BB98,$BB99,$BB9A,$BB9B,
$BB9C,$BB9D,$BB9E,$BB9F,$BBA0,$BBA1,$BBA2,$BBA3,$BBA4,$BBA5,$BBA6,$BBA7,$BBA8,
$BBA9,$BBAA,$BBAB,$BBAC,$BBAD,$BBAE,$BBAF,$BBB0,$BBB1,$BBB2,$BBB3,$BBB4,$BBB5,
$BBB6,$BBB7,$BBB8,$BBB9,$BBBA,$BBBB,$BBBC,$BBBD,$BBBE,$BBBF,$BBC0,$BBC1,$BBC2,
$BBC3,$BBC4,$BBC5,$BBC6,$BBC7,$BBC8,$BBC9,$BBCA,$BBCB,$BBCC,$BBCD,$BBCE,$BBCF,
$BBD0,$BBD1,$BBD2,$BBD3,$BBD4,$BBD5,$BBD6,$BBD7,$BBD8,$BBD9,$BBDA,$BBDB,$BBDC,
$BBDD,$BBDE,$BBDF,$BBE0,$BBE1,$BBE2,$BBE3,$BBE4,$BBE5,$BBE6,$BBE7,$BBE8,$BBE9,
$BBEA,$BBEB,$BBEC,$BBED,$BBEE,$BBEF,$BBF0,$BBF1,$BBF2,$BBF3,$BBF4,$BBF5,$BBF6,
$BBF7,$BBF8,$BBF9,$BBFA,$BBFB,$BBFC,$BBFD,$BBFE,$BC40,$BC41,$BC42,$BC43,$BC44,
$BC45,$BC46,$BC47,$BC48,$BC49,$BC4A,$BC4B,$BC4C,$BC4D,$BC4E,$BC4F,$BC50,$BC51,
$BC52,$BC53,$BC54,$BC55,$BC56,$BC57,$BC58,$BC59,$BC5A,$BC5B,$BC5C,$BC5D,$BC5E,
$BC5F,$BC60,$BC61,$BC62,$BC63,$BC64,$BC65,$BC66,$BC67,$BC68,$BC69,$BC6A,$BC6B,
$BC6C,$BC6D,$BC6E,$BC6F,$BC70,$BC71,$BC72,$BC73,$BC74,$BC75,$BC76,$BC77,$BC78,
$BC79,$BC7A,$BC7B,$BC7C,$BC7D,$BC7E,$BC80,$BC81,$BC82,$BC83,$BC84,$BC85,$BC86,
$BC87,$BC88,$BC89,$BC8A,$BC8B,$BC8C,$BC8D,$BC8E,$BC8F,$BC90,$BC91,$BC92,$BC93,
$BC94,$BC95,$BC96,$BC97,$BC98,$BC99,$BC9A,$BC9B,$BC9C,$BC9D,$BC9E,$BC9F,$BCA0,
$BCA1,$BCA2,$BCA3,$BCA4,$BCA5,$BCA6,$BCA7,$BCA8,$BCA9,$BCAA,$BCAB,$BCAC,$BCAD,
$BCAE,$BCAF,$BCB0,$BCB1,$BCB2,$BCB3,$BCB4,$BCB5,$BCB6,$BCB7,$BCB8,$BCB9,$BCBA,
$BCBB,$BCBC,$BCBD,$BCBE,$BCBF,$BCC0,$BCC1,$BCC2,$BCC3,$BCC4,$BCC5,$BCC6,$BCC7,
$BCC8,$BCC9,$BCCA,$BCCB,$BCCC,$BCCD,$BCCE,$BCCF,$BCD0,$BCD1,$BCD2,$BCD3,$BCD4,
$BCD5,$BCD6,$BCD7,$BCD8,$BCD9,$BCDA,$BCDB,$BCDC,$BCDD,$BCDE,$BCDF,$BCE0,$BCE1,
$BCE2,$BCE3,$BCE4,$BCE5,$BCE6,$BCE7,$BCE8,$BCE9,$BCEA,$BCEB,$BCEC,$BCED,$BCEE,
$BCEF,$BCF0,$BCF1,$BCF2,$BCF3,$BCF4,$BCF5,$BCF6,$BCF7,$BCF8,$BCF9,$BCFA,$BCFB,
$BCFC,$BCFD,$BCFE,$BD40,$BD41,$BD42,$BD43,$BD44,$BD45,$BD46,$BD47,$BD48,$BD49,
$BD4A,$BD4B,$BD4C,$BD4D,$BD4E,$BD4F,$BD50,$BD51,$BD52,$BD53,$BD54,$BD55,$BD56,
$BD57,$BD58,$BD59,$BD5A,$BD5B,$BD5C,$BD5D,$BD5E,$BD5F,$BD60,$BD61,$BD62,$BD63,
$BD64,$BD65,$BD66,$BD67,$BD68,$BD69,$BD6A,$BD6B,$BD6C,$BD6D,$BD6E,$BD6F,$BD70,
$BD71,$BD72,$BD73,$BD74,$BD75,$BD76,$BD77,$BD78,$BD79,$BD7A,$BD7B,$BD7C,$BD7D,
$BD7E,$BD80,$BD81,$BD82,$BD83,$BD84,$BD85,$BD86,$BD87,$BD88,$BD89,$BD8A,$BD8B,
$BD8C,$BD8D,$BD8E,$BD8F,$BD90,$BD91,$BD92,$BD93,$BD94,$BD95,$BD96,$BD97,$BD98,
$BD99,$BD9A,$BD9B,$BD9C,$BD9D,$BD9E,$BD9F,$BDA0,$BDA1,$BDA2,$BDA3,$BDA4,$BDA5,
$BDA6,$BDA7,$BDA8,$BDA9,$BDAA,$BDAB,$BDAC,$BDAD,$BDAE,$BDAF,$BDB0,$BDB1,$BDB2,
$BDB3,$BDB4,$BDB5,$BDB6,$BDB7,$BDB8,$BDB9,$BDBA,$BDBB,$BDBC,$BDBD,$BDBE,$BDBF,
$BDC0,$BDC1,$BDC2,$BDC3,$BDC4,$BDC5,$BDC6,$BDC7,$BDC8,$BDC9,$BDCA,$BDCB,$BDCC,
$BDCD,$BDCE,$BDCF,$BDD0,$BDD1,$BDD2,$BDD3,$BDD4,$BDD5,$BDD6,$BDD7,$BDD8,$BDD9,
$BDDA,$BDDB,$BDDC,$BDDD,$BDDE,$BDDF,$BDE0,$BDE1,$BDE2,$BDE3,$BDE4,$BDE5,$BDE6,
$BDE7,$BDE8,$BDE9,$BDEA,$BDEB,$BDEC,$BDED,$BDEE,$BDEF,$BDF0,$BDF1,$BDF2,$BDF3,
$BDF4,$BDF5,$BDF6,$BDF7,$BDF8,$BDF9,$BDFA,$BDFB,$BDFC,$BDFD,$BDFE,$BE40,$BE41,
$BE42,$BE43,$BE44,$BE45,$BE46,$BE47,$BE48,$BE49,$BE4A,$BE4B,$BE4C,$BE4D,$BE4E,
$BE4F,$BE50,$BE51,$BE52,$BE53,$BE54,$BE55,$BE56,$BE57,$BE58,$BE59,$BE5A,$BE5B,
$BE5C,$BE5D,$BE5E,$BE5F,$BE60,$BE61,$BE62,$BE63,$BE64,$BE65,$BE66,$BE67,$BE68,
$BE69,$BE6A,$BE6B,$BE6C,$BE6D,$BE6E,$BE6F,$BE70,$BE71,$BE72,$BE73,$BE74,$BE75,
$BE76,$BE77,$BE78,$BE79,$BE7A,$BE7B,$BE7C,$BE7D,$BE7E,$BE80,$BE81,$BE82,$BE83,
$BE84,$BE85,$BE86,$BE87,$BE88,$BE89,$BE8A,$BE8B,$BE8C,$BE8D,$BE8E,$BE8F,$BE90,
$BE91,$BE92,$BE93,$BE94,$BE95,$BE96,$BE97,$BE98,$BE99,$BE9A,$BE9B,$BE9C,$BE9D,
$BE9E,$BE9F,$BEA0,$BEA1,$BEA2,$BEA3,$BEA4,$BEA5,$BEA6,$BEA7,$BEA8,$BEA9,$BEAA,
$BEAB,$BEAC,$BEAD,$BEAE,$BEAF,$BEB0,$BEB1,$BEB2,$BEB3,$BEB4,$BEB5,$BEB6,$BEB7,
$BEB8,$BEB9,$BEBA,$BEBB,$BEBC,$BEBD,$BEBE,$BEBF,$BEC0,$BEC1,$BEC2,$BEC3,$BEC4,
$BEC5,$BEC6,$BEC7,$BEC8,$BEC9,$BECA,$BECB,$BECC,$BECD,$BECE,$BECF,$BED0,$BED1,
$BED2,$BED3,$BED4,$BED5,$BED6,$BED7,$BED8,$BED9,$BEDA,$BEDB,$BEDC,$BEDD,$BEDE,
$BEDF,$BEE0,$BEE1,$BEE2,$BEE3,$BEE4,$BEE5,$BEE6,$BEE7,$BEE8,$BEE9,$BEEA,$BEEB,
$BEEC,$BEED,$BEEE,$BEEF,$BEF0,$BEF1,$BEF2,$BEF3,$BEF4,$BEF5,$BEF6,$BEF7,$BEF8,
$BEF9,$BEFA,$BEFB,$BEFC,$BEFD,$BEFE,$BF40,$BF41,$BF42,$BF43,$BF44,$BF45,$BF46,
$BF47,$BF48,$BF49,$BF4A,$BF4B,$BF4C,$BF4D,$BF4E,$BF4F,$BF50,$BF51,$BF52,$BF53,
$BF54,$BF55,$BF56,$BF57,$BF58,$BF59,$BF5A,$BF5B,$BF5C,$BF5D,$BF5E,$BF5F,$BF60,
$BF61,$BF62,$BF63,$BF64,$BF65,$BF66,$BF67,$BF68,$BF69,$BF6A,$BF6B,$BF6C,$BF6D,
$BF6E,$BF6F,$BF70,$BF71,$BF72,$BF73,$BF74,$BF75,$BF76,$BF77,$BF78,$BF79,$BF7A,
$BF7B,$BF7C,$BF7D,$BF7E,$BF80,$BF81,$BF82,$BF83,$BF84,$BF85,$BF86,$BF87,$BF88,
$BF89,$BF8A,$BF8B,$BF8C,$BF8D,$BF8E,$BF8F,$BF90,$BF91,$BF92,$BF93,$BF94,$BF95,
$BF96,$BF97,$BF98,$BF99,$BF9A,$BF9B,$BF9C,$BF9D,$BF9E,$BF9F,$BFA0,$BFA1,$BFA2,
$BFA3,$BFA4,$BFA5,$BFA6,$BFA7,$BFA8,$BFA9,$BFAA,$BFAB,$BFAC,$BFAD,$BFAE,$BFAF,
$BFB0,$BFB1,$BFB2,$BFB3,$BFB4,$BFB5,$BFB6,$BFB7,$BFB8,$BFB9,$BFBA,$BFBB,$BFBC,
$BFBD,$BFBE,$BFBF,$BFC0,$BFC1,$BFC2,$BFC3,$BFC4,$BFC5,$BFC6,$BFC7,$BFC8,$BFC9,
$BFCA,$BFCB,$BFCC,$BFCD,$BFCE,$BFCF,$BFD0,$BFD1,$BFD2,$BFD3,$BFD4,$BFD5,$BFD6,
$BFD7,$BFD8,$BFD9,$BFDA,$BFDB,$BFDC,$BFDD,$BFDE,$BFDF,$BFE0,$BFE1,$BFE2,$BFE3,
$BFE4,$BFE5,$BFE6,$BFE7,$BFE8,$BFE9,$BFEA,$BFEB,$BFEC,$BFED,$BFEE,$BFEF,$BFF0,
$BFF1,$BFF2,$BFF3,$BFF4,$BFF5,$BFF6,$BFF7,$BFF8,$BFF9,$BFFA,$BFFB,$BFFC,$BFFD,
$BFFE,$C040,$C041,$C042,$C043,$C044,$C045,$C046,$C047,$C048,$C049,$C04A,$C04B,
$C04C,$C04D,$C04E,$C04F,$C050,$C051,$C052,$C053,$C054,$C055,$C056,$C057,$C058,
$C059,$C05A,$C05B,$C05C,$C05D,$C05E,$C05F,$C060,$C061,$C062,$C063,$C064,$C065,
$C066,$C067,$C068,$C069,$C06A,$C06B,$C06C,$C06D,$C06E,$C06F,$C070,$C071,$C072,
$C073,$C074,$C075,$C076,$C077,$C078,$C079,$C07A,$C07B,$C07C,$C07D,$C07E,$C080,
$C081,$C082,$C083,$C084,$C085,$C086,$C087,$C088,$C089,$C08A,$C08B,$C08C,$C08D,
$C08E,$C08F,$C090,$C091,$C092,$C093,$C094,$C095,$C096,$C097,$C098,$C099,$C09A,
$C09B,$C09C,$C09D,$C09E,$C09F,$C0A0,$C0A1,$C0A2,$C0A3,$C0A4,$C0A5,$C0A6,$C0A7,
$C0A8,$C0A9,$C0AA,$C0AB,$C0AC,$C0AD,$C0AE,$C0AF,$C0B0,$C0B1,$C0B2,$C0B3,$C0B4,
$C0B5,$C0B6,$C0B7,$C0B8,$C0B9,$C0BA,$C0BB,$C0BC,$C0BD,$C0BE,$C0BF,$C0C0,$C0C1,
$C0C2,$C0C3,$C0C4,$C0C5,$C0C6,$C0C7,$C0C8,$C0C9,$C0CA,$C0CB,$C0CC,$C0CD,$C0CE,
$C0CF,$C0D0,$C0D1,$C0D2,$C0D3,$C0D4,$C0D5,$C0D6,$C0D7,$C0D8,$C0D9,$C0DA,$C0DB,
$C0DC,$C0DD,$C0DE,$C0DF,$C0E0,$C0E1,$C0E2,$C0E3,$C0E4,$C0E5,$C0E6,$C0E7,$C0E8,
$C0E9,$C0EA,$C0EB,$C0EC,$C0ED,$C0EE,$C0EF,$C0F0,$C0F1,$C0F2,$C0F3,$C0F4,$C0F5,
$C0F6,$C0F7,$C0F8,$C0F9,$C0FA,$C0FB,$C0FC,$C0FD,$C0FE,$C140,$C141,$C142,$C143,
$C144,$C145,$C146,$C147,$C148,$C149,$C14A,$C14B,$C14C,$C14D,$C14E,$C14F,$C150,
$C151,$C152,$C153,$C154,$C155,$C156,$C157,$C158,$C159,$C15A,$C15B,$C15C,$C15D,
$C15E,$C15F,$C160,$C161,$C162,$C163,$C164,$C165,$C166,$C167,$C168,$C169,$C16A,
$C16B,$C16C,$C16D,$C16E,$C16F,$C170,$C171,$C172,$C173,$C174,$C175,$C176,$C177,
$C178,$C179,$C17A,$C17B,$C17C,$C17D,$C17E,$C180,$C181,$C182,$C183,$C184,$C185,
$C186,$C187,$C188,$C189,$C18A,$C18B,$C18C,$C18D,$C18E,$C18F,$C190,$C191,$C192,
$C193,$C194,$C195,$C196,$C197,$C198,$C199,$C19A,$C19B,$C19C,$C19D,$C19E,$C19F,
$C1A0,$C1A1,$C1A2,$C1A3,$C1A4,$C1A5,$C1A6,$C1A7,$C1A8,$C1A9,$C1AA,$C1AB,$C1AC,
$C1AD,$C1AE,$C1AF,$C1B0,$C1B1,$C1B2,$C1B3,$C1B4,$C1B5,$C1B6,$C1B7,$C1B8,$C1B9,
$C1BA,$C1BB,$C1BC,$C1BD,$C1BE,$C1BF,$C1C0,$C1C1,$C1C2,$C1C3,$C1C4,$C1C5,$C1C6,
$C1C7,$C1C8,$C1C9,$C1CA,$C1CB,$C1CC,$C1CD,$C1CE,$C1CF,$C1D0,$C1D1,$C1D2,$C1D3,
$C1D4,$C1D5,$C1D6,$C1D7,$C1D8,$C1D9,$C1DA,$C1DB,$C1DC,$C1DD,$C1DE,$C1DF,$C1E0,
$C1E1,$C1E2,$C1E3,$C1E4,$C1E5,$C1E6,$C1E7,$C1E8,$C1E9,$C1EA,$C1EB,$C1EC,$C1ED,
$C1EE,$C1EF,$C1F0,$C1F1,$C1F2,$C1F3,$C1F4,$C1F5,$C1F6,$C1F7,$C1F8,$C1F9,$C1FA,
$C1FB,$C1FC,$C1FD,$C1FE,$C240,$C241,$C242,$C243,$C244,$C245,$C246,$C247,$C248,
$C249,$C24A,$C24B,$C24C,$C24D,$C24E,$C24F,$C250,$C251,$C252,$C253,$C254,$C255,
$C256,$C257,$C258,$C259,$C25A,$C25B,$C25C,$C25D,$C25E,$C25F,$C260,$C261,$C262,
$C263,$C264,$C265,$C266,$C267,$C268,$C269,$C26A,$C26B,$C26C,$C26D,$C26E,$C26F,
$C270,$C271,$C272,$C273,$C274,$C275,$C276,$C277,$C278,$C279,$C27A,$C27B,$C27C,
$C27D,$C27E,$C280,$C281,$C282,$C283,$C284,$C285,$C286,$C287,$C288,$C289,$C28A,
$C28B,$C28C,$C28D,$C28E,$C28F,$C290,$C291,$C292,$C293,$C294,$C295,$C296,$C297,
$C298,$C299,$C29A,$C29B,$C29C,$C29D,$C29E,$C29F,$C2A0,$C2A1,$C2A2,$C2A3,$C2A4,
$C2A5,$C2A6,$C2A7,$C2A8,$C2A9,$C2AA,$C2AB,$C2AC,$C2AD,$C2AE,$C2AF,$C2B0,$C2B1,
$C2B2,$C2B3,$C2B4,$C2B5,$C2B6,$C2B7,$C2B8,$C2B9,$C2BA,$C2BB,$C2BC,$C2BD,$C2BE,
$C2BF,$C2C0,$C2C1,$C2C2,$C2C3,$C2C4,$C2C5,$C2C6,$C2C7,$C2C8,$C2C9,$C2CA,$C2CB,
$C2CC,$C2CD,$C2CE,$C2CF,$C2D0,$C2D1,$C2D2,$C2D3,$C2D4,$C2D5,$C2D6,$C2D7,$C2D8,
$C2D9,$C2DA,$C2DB,$C2DC,$C2DD,$C2DE,$C2DF,$C2E0,$C2E1,$C2E2,$C2E3,$C2E4,$C2E5,
$C2E6,$C2E7,$C2E8,$C2E9,$C2EA,$C2EB,$C2EC,$C2ED,$C2EE,$C2EF,$C2F0,$C2F1,$C2F2,
$C2F3,$C2F4,$C2F5,$C2F6,$C2F7,$C2F8,$C2F9,$C2FA,$C2FB,$C2FC,$C2FD,$C2FE,$C340,
$C341,$C342,$C343,$C344,$C345,$C346,$C347,$C348,$C349,$C34A,$C34B,$C34C,$C34D,
$C34E,$C34F,$C350,$C351,$C352,$C353,$C354,$C355,$C356,$C357,$C358,$C359,$C35A,
$C35B,$C35C,$C35D,$C35E,$C35F,$C360,$C361,$C362,$C363,$C364,$C365,$C366,$C367,
$C368,$C369,$C36A,$C36B,$C36C,$C36D,$C36E,$C36F,$C370,$C371,$C372,$C373,$C374,
$C375,$C376,$C377,$C378,$C379,$C37A,$C37B,$C37C,$C37D,$C37E,$C380,$C381,$C382,
$C383,$C384,$C385,$C386,$C387,$C388,$C389,$C38A,$C38B,$C38C,$C38D,$C38E,$C38F,
$C390,$C391,$C392,$C393,$C394,$C395,$C396,$C397,$C398,$C399,$C39A,$C39B,$C39C,
$C39D,$C39E,$C39F,$C3A0,$C3A1,$C3A2,$C3A3,$C3A4,$C3A5,$C3A6,$C3A7,$C3A8,$C3A9,
$C3AA,$C3AB,$C3AC,$C3AD,$C3AE,$C3AF,$C3B0,$C3B1,$C3B2,$C3B3,$C3B4,$C3B5,$C3B6,
$C3B7,$C3B8,$C3B9,$C3BA,$C3BB,$C3BC,$C3BD,$C3BE,$C3BF,$C3C0,$C3C1,$C3C2,$C3C3,
$C3C4,$C3C5,$C3C6,$C3C7,$C3C8,$C3C9,$C3CA,$C3CB,$C3CC,$C3CD,$C3CE,$C3CF,$C3D0,
$C3D1,$C3D2,$C3D3,$C3D4,$C3D5,$C3D6,$C3D7,$C3D8,$C3D9,$C3DA,$C3DB,$C3DC,$C3DD,
$C3DE,$C3DF,$C3E0,$C3E1,$C3E2,$C3E3,$C3E4,$C3E5,$C3E6,$C3E7,$C3E8,$C3E9,$C3EA,
$C3EB,$C3EC,$C3ED,$C3EE,$C3EF,$C3F0,$C3F1,$C3F2,$C3F3,$C3F4,$C3F5,$C3F6,$C3F7,
$C3F8,$C3F9,$C3FA,$C3FB,$C3FC,$C3FD,$C3FE,$C440,$C441,$C442,$C443,$C444,$C445,
$C446,$C447,$C448,$C449,$C44A,$C44B,$C44C,$C44D,$C44E,$C44F,$C450,$C451,$C452,
$C453,$C454,$C455,$C456,$C457,$C458,$C459,$C45A,$C45B,$C45C,$C45D,$C45E,$C45F,
$C460,$C461,$C462,$C463,$C464,$C465,$C466,$C467,$C468,$C469,$C46A,$C46B,$C46C,
$C46D,$C46E,$C46F,$C470,$C471,$C472,$C473,$C474,$C475,$C476,$C477,$C478,$C479,
$C47A,$C47B,$C47C,$C47D,$C47E,$C480,$C481,$C482,$C483,$C484,$C485,$C486,$C487,
$C488,$C489,$C48A,$C48B,$C48C,$C48D,$C48E,$C48F,$C490,$C491,$C492,$C493,$C494,
$C495,$C496,$C497,$C498,$C499,$C49A,$C49B,$C49C,$C49D,$C49E,$C49F,$C4A0,$C4A1,
$C4A2,$C4A3,$C4A4,$C4A5,$C4A6,$C4A7,$C4A8,$C4A9,$C4AA,$C4AB,$C4AC,$C4AD,$C4AE,
$C4AF,$C4B0,$C4B1,$C4B2,$C4B3,$C4B4,$C4B5,$C4B6,$C4B7,$C4B8,$C4B9,$C4BA,$C4BB,
$C4BC,$C4BD,$C4BE,$C4BF,$C4C0,$C4C1,$C4C2,$C4C3,$C4C4,$C4C5,$C4C6,$C4C7,$C4C8,
$C4C9,$C4CA,$C4CB,$C4CC,$C4CD,$C4CE,$C4CF,$C4D0,$C4D1,$C4D2,$C4D3,$C4D4,$C4D5,
$C4D6,$C4D7,$C4D8,$C4D9,$C4DA,$C4DB,$C4DC,$C4DD,$C4DE,$C4DF,$C4E0,$C4E1,$C4E2,
$C4E3,$C4E4,$C4E5,$C4E6,$C4E7,$C4E8,$C4E9,$C4EA,$C4EB,$C4EC,$C4ED,$C4EE,$C4EF,
$C4F0,$C4F1,$C4F2,$C4F3,$C4F4,$C4F5,$C4F6,$C4F7,$C4F8,$C4F9,$C4FA,$C4FB,$C4FC,
$C4FD,$C4FE,$C540,$C541,$C542,$C543,$C544,$C545,$C546,$C547,$C548,$C549,$C54A,
$C54B,$C54C,$C54D,$C54E,$C54F,$C550,$C551,$C552,$C553,$C554,$C555,$C556,$C557,
$C558,$C559,$C55A,$C55B,$C55C,$C55D,$C55E,$C55F,$C560,$C561,$C562,$C563,$C564,
$C565,$C566,$C567,$C568,$C569,$C56A,$C56B,$C56C,$C56D,$C56E,$C56F,$C570,$C571,
$C572,$C573,$C574,$C575,$C576,$C577,$C578,$C579,$C57A,$C57B,$C57C,$C57D,$C57E,
$C580,$C581,$C582,$C583,$C584,$C585,$C586,$C587,$C588,$C589,$C58A,$C58B,$C58C,
$C58D,$C58E,$C58F,$C590,$C591,$C592,$C593,$C594,$C595,$C596,$C597,$C598,$C599,
$C59A,$C59B,$C59C,$C59D,$C59E,$C59F,$C5A0,$C5A1,$C5A2,$C5A3,$C5A4,$C5A5,$C5A6,
$C5A7,$C5A8,$C5A9,$C5AA,$C5AB,$C5AC,$C5AD,$C5AE,$C5AF,$C5B0,$C5B1,$C5B2,$C5B3,
$C5B4,$C5B5,$C5B6,$C5B7,$C5B8,$C5B9,$C5BA,$C5BB,$C5BC,$C5BD,$C5BE,$C5BF,$C5C0,
$C5C1,$C5C2,$C5C3,$C5C4,$C5C5,$C5C6,$C5C7,$C5C8,$C5C9,$C5CA,$C5CB,$C5CC,$C5CD,
$C5CE,$C5CF,$C5D0,$C5D1,$C5D2,$C5D3,$C5D4,$C5D5,$C5D6,$C5D7,$C5D8,$C5D9,$C5DA,
$C5DB,$C5DC,$C5DD,$C5DE,$C5DF,$C5E0,$C5E1,$C5E2,$C5E3,$C5E4,$C5E5,$C5E6,$C5E7,
$C5E8,$C5E9,$C5EA,$C5EB,$C5EC,$C5ED,$C5EE,$C5EF,$C5F0,$C5F1,$C5F2,$C5F3,$C5F4,
$C5F5,$C5F6,$C5F7,$C5F8,$C5F9,$C5FA,$C5FB,$C5FC,$C5FD,$C5FE,$C640,$C641,$C642,
$C643,$C644,$C645,$C646,$C647,$C648,$C649,$C64A,$C64B,$C64C,$C64D,$C64E,$C64F,
$C650,$C651,$C652,$C653,$C654,$C655,$C656,$C657,$C658,$C659,$C65A,$C65B,$C65C,
$C65D,$C65E,$C65F,$C660,$C661,$C662,$C663,$C664,$C665,$C666,$C667,$C668,$C669,
$C66A,$C66B,$C66C,$C66D,$C66E,$C66F,$C670,$C671,$C672,$C673,$C674,$C675,$C676,
$C677,$C678,$C679,$C67A,$C67B,$C67C,$C67D,$C67E,$C680,$C681,$C682,$C683,$C684,
$C685,$C686,$C687,$C688,$C689,$C68A,$C68B,$C68C,$C68D,$C68E,$C68F,$C690,$C691,
$C692,$C693,$C694,$C695,$C696,$C697,$C698,$C699,$C69A,$C69B,$C69C,$C69D,$C69E,
$C69F,$C6A0,$C6A1,$C6A2,$C6A3,$C6A4,$C6A5,$C6A6,$C6A7,$C6A8,$C6A9,$C6AA,$C6AB,
$C6AC,$C6AD,$C6AE,$C6AF,$C6B0,$C6B1,$C6B2,$C6B3,$C6B4,$C6B5,$C6B6,$C6B7,$C6B8,
$C6B9,$C6BA,$C6BB,$C6BC,$C6BD,$C6BE,$C6BF,$C6C0,$C6C1,$C6C2,$C6C3,$C6C4,$C6C5,
$C6C6,$C6C7,$C6C8,$C6C9,$C6CA,$C6CB,$C6CC,$C6CD,$C6CE,$C6CF,$C6D0,$C6D1,$C6D2,
$C6D3,$C6D4,$C6D5,$C6D6,$C6D7,$C6D8,$C6D9,$C6DA,$C6DB,$C6DC,$C6DD,$C6DE,$C6DF,
$C6E0,$C6E1,$C6E2,$C6E3,$C6E4,$C6E5,$C6E6,$C6E7,$C6E8,$C6E9,$C6EA,$C6EB,$C6EC,
$C6ED,$C6EE,$C6EF,$C6F0,$C6F1,$C6F2,$C6F3,$C6F4,$C6F5,$C6F6,$C6F7,$C6F8,$C6F9,
$C6FA,$C6FB,$C6FC,$C6FD,$C6FE,$C740,$C741,$C742,$C743,$C744,$C745,$C746,$C747,
$C748,$C749,$C74A,$C74B,$C74C,$C74D,$C74E,$C74F,$C750,$C751,$C752,$C753,$C754,
$C755,$C756,$C757,$C758,$C759,$C75A,$C75B,$C75C,$C75D,$C75E,$C75F,$C760,$C761,
$C762,$C763,$C764,$C765,$C766,$C767,$C768,$C769,$C76A,$C76B,$C76C,$C76D,$C76E,
$C76F,$C770,$C771,$C772,$C773,$C774,$C775,$C776,$C777,$C778,$C779,$C77A,$C77B,
$C77C,$C77D,$C77E,$C780,$C781,$C782,$C783,$C784,$C785,$C786,$C787,$C788,$C789,
$C78A,$C78B,$C78C,$C78D,$C78E,$C78F,$C790,$C791,$C792,$C793,$C794,$C795,$C796,
$C797,$C798,$C799,$C79A,$C79B,$C79C,$C79D,$C79E,$C79F,$C7A0,$C7A1,$C7A2,$C7A3,
$C7A4,$C7A5,$C7A6,$C7A7,$C7A8,$C7A9,$C7AA,$C7AB,$C7AC,$C7AD,$C7AE,$C7AF,$C7B0,
$C7B1,$C7B2,$C7B3,$C7B4,$C7B5,$C7B6,$C7B7,$C7B8,$C7B9,$C7BA,$C7BB,$C7BC,$C7BD,
$C7BE,$C7BF,$C7C0,$C7C1,$C7C2,$C7C3,$C7C4,$C7C5,$C7C6,$C7C7,$C7C8,$C7C9,$C7CA,
$C7CB,$C7CC,$C7CD,$C7CE,$C7CF,$C7D0,$C7D1,$C7D2,$C7D3,$C7D4,$C7D5,$C7D6,$C7D7,
$C7D8,$C7D9,$C7DA,$C7DB,$C7DC,$C7DD,$C7DE,$C7DF,$C7E0,$C7E1,$C7E2,$C7E3,$C7E4,
$C7E5,$C7E6,$C7E7,$C7E8,$C7E9,$C7EA,$C7EB,$C7EC,$C7ED,$C7EE,$C7EF,$C7F0,$C7F1,
$C7F2,$C7F3,$C7F4,$C7F5,$C7F6,$C7F7,$C7F8,$C7F9,$C7FA,$C7FB,$C7FC,$C7FD,$C7FE,
$C840,$C841,$C842,$C843,$C844,$C845,$C846,$C847,$C848,$C849,$C84A,$C84B,$C84C,
$C84D,$C84E,$C84F,$C850,$C851,$C852,$C853,$C854,$C855,$C856,$C857,$C858,$C859,
$C85A,$C85B,$C85C,$C85D,$C85E,$C85F,$C860,$C861,$C862,$C863,$C864,$C865,$C866,
$C867,$C868,$C869,$C86A,$C86B,$C86C,$C86D,$C86E,$C86F,$C870,$C871,$C872,$C873,
$C874,$C875,$C876,$C877,$C878,$C879,$C87A,$C87B,$C87C,$C87D,$C87E,$C880,$C881,
$C882,$C883,$C884,$C885,$C886,$C887,$C888,$C889,$C88A,$C88B,$C88C,$C88D,$C88E,
$C88F,$C890,$C891,$C892,$C893,$C894,$C895,$C896,$C897,$C898,$C899,$C89A,$C89B,
$C89C,$C89D,$C89E,$C89F,$C8A0,$C8A1,$C8A2,$C8A3,$C8A4,$C8A5,$C8A6,$C8A7,$C8A8,
$C8A9,$C8AA,$C8AB,$C8AC,$C8AD,$C8AE,$C8AF,$C8B0,$C8B1,$C8B2,$C8B3,$C8B4,$C8B5,
$C8B6,$C8B7,$C8B8,$C8B9,$C8BA,$C8BB,$C8BC,$C8BD,$C8BE,$C8BF,$C8C0,$C8C1,$C8C2,
$C8C3,$C8C4,$C8C5,$C8C6,$C8C7,$C8C8,$C8C9,$C8CA,$C8CB,$C8CC,$C8CD,$C8CE,$C8CF,
$C8D0,$C8D1,$C8D2,$C8D3,$C8D4,$C8D5,$C8D6,$C8D7,$C8D8,$C8D9,$C8DA,$C8DB,$C8DC,
$C8DD,$C8DE,$C8DF,$C8E0,$C8E1,$C8E2,$C8E3,$C8E4,$C8E5,$C8E6,$C8E7,$C8E8,$C8E9,
$C8EA,$C8EB,$C8EC,$C8ED,$C8EE,$C8EF,$C8F0,$C8F1,$C8F2,$C8F3,$C8F4,$C8F5,$C8F6,
$C8F7,$C8F8,$C8F9,$C8FA,$C8FB,$C8FC,$C8FD,$C8FE,$C940,$C941,$C942,$C943,$C944,
$C945,$C946,$C947,$C948,$C949,$C94A,$C94B,$C94C,$C94D,$C94E,$C94F,$C950,$C951,
$C952,$C953,$C954,$C955,$C956,$C957,$C958,$C959,$C95A,$C95B,$C95C,$C95D,$C95E,
$C95F,$C960,$C961,$C962,$C963,$C964,$C965,$C966,$C967,$C968,$C969,$C96A,$C96B,
$C96C,$C96D,$C96E,$C96F,$C970,$C971,$C972,$C973,$C974,$C975,$C976,$C977,$C978,
$C979,$C97A,$C97B,$C97C,$C97D,$C97E,$C980,$C981,$C982,$C983,$C984,$C985,$C986,
$C987,$C988,$C989,$C98A,$C98B,$C98C,$C98D,$C98E,$C98F,$C990,$C991,$C992,$C993,
$C994,$C995,$C996,$C997,$C998,$C999,$C99A,$C99B,$C99C,$C99D,$C99E,$C99F,$C9A0,
$C9A1,$C9A2,$C9A3,$C9A4,$C9A5,$C9A6,$C9A7,$C9A8,$C9A9,$C9AA,$C9AB,$C9AC,$C9AD,
$C9AE,$C9AF,$C9B0,$C9B1,$C9B2,$C9B3,$C9B4,$C9B5,$C9B6,$C9B7,$C9B8,$C9B9,$C9BA,
$C9BB,$C9BC,$C9BD,$C9BE,$C9BF,$C9C0,$C9C1,$C9C2,$C9C3,$C9C4,$C9C5,$C9C6,$C9C7,
$C9C8,$C9C9,$C9CA,$C9CB,$C9CC,$C9CD,$C9CE,$C9CF,$C9D0,$C9D1,$C9D2,$C9D3,$C9D4,
$C9D5,$C9D6,$C9D7,$C9D8,$C9D9,$C9DA,$C9DB,$C9DC,$C9DD,$C9DE,$C9DF,$C9E0,$C9E1,
$C9E2,$C9E3,$C9E4,$C9E5,$C9E6,$C9E7,$C9E8,$C9E9,$C9EA,$C9EB,$C9EC,$C9ED,$C9EE,
$C9EF,$C9F0,$C9F1,$C9F2,$C9F3,$C9F4,$C9F5,$C9F6,$C9F7,$C9F8,$C9F9,$C9FA,$C9FB,
$C9FC,$C9FD,$C9FE,$CA40,$CA41,$CA42,$CA43,$CA44,$CA45,$CA46,$CA47,$CA48,$CA49,
$CA4A,$CA4B,$CA4C,$CA4D,$CA4E,$CA4F,$CA50,$CA51,$CA52,$CA53,$CA54,$CA55,$CA56,
$CA57,$CA58,$CA59,$CA5A,$CA5B,$CA5C,$CA5D,$CA5E,$CA5F,$CA60,$CA61,$CA62,$CA63,
$CA64,$CA65,$CA66,$CA67,$CA68,$CA69,$CA6A,$CA6B,$CA6C,$CA6D,$CA6E,$CA6F,$CA70,
$CA71,$CA72,$CA73,$CA74,$CA75,$CA76,$CA77,$CA78,$CA79,$CA7A,$CA7B,$CA7C,$CA7D,
$CA7E,$CA80,$CA81,$CA82,$CA83,$CA84,$CA85,$CA86,$CA87,$CA88,$CA89,$CA8A,$CA8B,
$CA8C,$CA8D,$CA8E,$CA8F,$CA90,$CA91,$CA92,$CA93,$CA94,$CA95,$CA96,$CA97,$CA98,
$CA99,$CA9A,$CA9B,$CA9C,$CA9D,$CA9E,$CA9F,$CAA0,$CAA1,$CAA2,$CAA3,$CAA4,$CAA5,
$CAA6,$CAA7,$CAA8,$CAA9,$CAAA,$CAAB,$CAAC,$CAAD,$CAAE,$CAAF,$CAB0,$CAB1,$CAB2,
$CAB3,$CAB4,$CAB5,$CAB6,$CAB7,$CAB8,$CAB9,$CABA,$CABB,$CABC,$CABD,$CABE,$CABF,
$CAC0,$CAC1,$CAC2,$CAC3,$CAC4,$CAC5,$CAC6,$CAC7,$CAC8,$CAC9,$CACA,$CACB,$CACC,
$CACD,$CACE,$CACF,$CAD0,$CAD1,$CAD2,$CAD3,$CAD4,$CAD5,$CAD6,$CAD7,$CAD8,$CAD9,
$CADA,$CADB,$CADC,$CADD,$CADE,$CADF,$CAE0,$CAE1,$CAE2,$CAE3,$CAE4,$CAE5,$CAE6,
$CAE7,$CAE8,$CAE9,$CAEA,$CAEB,$CAEC,$CAED,$CAEE,$CAEF,$CAF0,$CAF1,$CAF2,$CAF3,
$CAF4,$CAF5,$CAF6,$CAF7,$CAF8,$CAF9,$CAFA,$CAFB,$CAFC,$CAFD,$CAFE,$CB40,$CB41,
$CB42,$CB43,$CB44,$CB45,$CB46,$CB47,$CB48,$CB49,$CB4A,$CB4B,$CB4C,$CB4D,$CB4E,
$CB4F,$CB50,$CB51,$CB52,$CB53,$CB54,$CB55,$CB56,$CB57,$CB58,$CB59,$CB5A,$CB5B,
$CB5C,$CB5D,$CB5E,$CB5F,$CB60,$CB61,$CB62,$CB63,$CB64,$CB65,$CB66,$CB67,$CB68,
$CB69,$CB6A,$CB6B,$CB6C,$CB6D,$CB6E,$CB6F,$CB70,$CB71,$CB72,$CB73,$CB74,$CB75,
$CB76,$CB77,$CB78,$CB79,$CB7A,$CB7B,$CB7C,$CB7D,$CB7E,$CB80,$CB81,$CB82,$CB83,
$CB84,$CB85,$CB86,$CB87,$CB88,$CB89,$CB8A,$CB8B,$CB8C,$CB8D,$CB8E,$CB8F,$CB90,
$CB91,$CB92,$CB93,$CB94,$CB95,$CB96,$CB97,$CB98,$CB99,$CB9A,$CB9B,$CB9C,$CB9D,
$CB9E,$CB9F,$CBA0,$CBA1,$CBA2,$CBA3,$CBA4,$CBA5,$CBA6,$CBA7,$CBA8,$CBA9,$CBAA,
$CBAB,$CBAC,$CBAD,$CBAE,$CBAF,$CBB0,$CBB1,$CBB2,$CBB3,$CBB4,$CBB5,$CBB6,$CBB7,
$CBB8,$CBB9,$CBBA,$CBBB,$CBBC,$CBBD,$CBBE,$CBBF,$CBC0,$CBC1,$CBC2,$CBC3,$CBC4,
$CBC5,$CBC6,$CBC7,$CBC8,$CBC9,$CBCA,$CBCB,$CBCC,$CBCD,$CBCE,$CBCF,$CBD0,$CBD1,
$CBD2,$CBD3,$CBD4,$CBD5,$CBD6,$CBD7,$CBD8,$CBD9,$CBDA,$CBDB,$CBDC,$CBDD,$CBDE,
$CBDF,$CBE0,$CBE1,$CBE2,$CBE3,$CBE4,$CBE5,$CBE6,$CBE7,$CBE8,$CBE9,$CBEA,$CBEB,
$CBEC,$CBED,$CBEE,$CBEF,$CBF0,$CBF1,$CBF2,$CBF3,$CBF4,$CBF5,$CBF6,$CBF7,$CBF8,
$CBF9,$CBFA,$CBFB,$CBFC,$CBFD,$CBFE,$CC40,$CC41,$CC42,$CC43,$CC44,$CC45,$CC46,
$CC47,$CC48,$CC49,$CC4A,$CC4B,$CC4C,$CC4D,$CC4E,$CC4F,$CC50,$CC51,$CC52,$CC53,
$CC54,$CC55,$CC56,$CC57,$CC58,$CC59,$CC5A,$CC5B,$CC5C,$CC5D,$CC5E,$CC5F,$CC60,
$CC61,$CC62,$CC63,$CC64,$CC65,$CC66,$CC67,$CC68,$CC69,$CC6A,$CC6B,$CC6C,$CC6D,
$CC6E,$CC6F,$CC70,$CC71,$CC72,$CC73,$CC74,$CC75,$CC76,$CC77,$CC78,$CC79,$CC7A,
$CC7B,$CC7C,$CC7D,$CC7E,$CC80,$CC81,$CC82,$CC83,$CC84,$CC85,$CC86,$CC87,$CC88,
$CC89,$CC8A,$CC8B,$CC8C,$CC8D,$CC8E,$CC8F,$CC90,$CC91,$CC92,$CC93,$CC94,$CC95,
$CC96,$CC97,$CC98,$CC99,$CC9A,$CC9B,$CC9C,$CC9D,$CC9E,$CC9F,$CCA0,$CCA1,$CCA2,
$CCA3,$CCA4,$CCA5,$CCA6,$CCA7,$CCA8,$CCA9,$CCAA,$CCAB,$CCAC,$CCAD,$CCAE,$CCAF,
$CCB0,$CCB1,$CCB2,$CCB3,$CCB4,$CCB5,$CCB6,$CCB7,$CCB8,$CCB9,$CCBA,$CCBB,$CCBC,
$CCBD,$CCBE,$CCBF,$CCC0,$CCC1,$CCC2,$CCC3,$CCC4,$CCC5,$CCC6,$CCC7,$CCC8,$CCC9,
$CCCA,$CCCB,$CCCC,$CCCD,$CCCE,$CCCF,$CCD0,$CCD1,$CCD2,$CCD3,$CCD4,$CCD5,$CCD6,
$CCD7,$CCD8,$CCD9,$CCDA,$CCDB,$CCDC,$CCDD,$CCDE,$CCDF,$CCE0,$CCE1,$CCE2,$CCE3,
$CCE4,$CCE5,$CCE6,$CCE7,$CCE8,$CCE9,$CCEA,$CCEB,$CCEC,$CCED,$CCEE,$CCEF,$CCF0,
$CCF1,$CCF2,$CCF3,$CCF4,$CCF5,$CCF6,$CCF7,$CCF8,$CCF9,$CCFA,$CCFB,$CCFC,$CCFD,
$CCFE,$CD40,$CD41,$CD42,$CD43,$CD44,$CD45,$CD46,$CD47,$CD48,$CD49,$CD4A,$CD4B,
$CD4C,$CD4D,$CD4E,$CD4F,$CD50,$CD51,$CD52,$CD53,$CD54,$CD55,$CD56,$CD57,$CD58,
$CD59,$CD5A,$CD5B,$CD5C,$CD5D,$CD5E,$CD5F,$CD60,$CD61,$CD62,$CD63,$CD64,$CD65,
$CD66,$CD67,$CD68,$CD69,$CD6A,$CD6B,$CD6C,$CD6D,$CD6E,$CD6F,$CD70,$CD71,$CD72,
$CD73,$CD74,$CD75,$CD76,$CD77,$CD78,$CD79,$CD7A,$CD7B,$CD7C,$CD7D,$CD7E,$CD80,
$CD81,$CD82,$CD83,$CD84,$CD85,$CD86,$CD87,$CD88,$CD89,$CD8A,$CD8B,$CD8C,$CD8D,
$CD8E,$CD8F,$CD90,$CD91,$CD92,$CD93,$CD94,$CD95,$CD96,$CD97,$CD98,$CD99,$CD9A,
$CD9B,$CD9C,$CD9D,$CD9E,$CD9F,$CDA0,$CDA1,$CDA2,$CDA3,$CDA4,$CDA5,$CDA6,$CDA7,
$CDA8,$CDA9,$CDAA,$CDAB,$CDAC,$CDAD,$CDAE,$CDAF,$CDB0,$CDB1,$CDB2,$CDB3,$CDB4,
$CDB5,$CDB6,$CDB7,$CDB8,$CDB9,$CDBA,$CDBB,$CDBC,$CDBD,$CDBE,$CDBF,$CDC0,$CDC1,
$CDC2,$CDC3,$CDC4,$CDC5,$CDC6,$CDC7,$CDC8,$CDC9,$CDCA,$CDCB,$CDCC,$CDCD,$CDCE,
$CDCF,$CDD0,$CDD1,$CDD2,$CDD3,$CDD4,$CDD5,$CDD6,$CDD7,$CDD8,$CDD9,$CDDA,$CDDB,
$CDDC,$CDDD,$CDDE,$CDDF,$CDE0,$CDE1,$CDE2,$CDE3,$CDE4,$CDE5,$CDE6,$CDE7,$CDE8,
$CDE9,$CDEA,$CDEB,$CDEC,$CDED,$CDEE,$CDEF,$CDF0,$CDF1,$CDF2,$CDF3,$CDF4,$CDF5,
$CDF6,$CDF7,$CDF8,$CDF9,$CDFA,$CDFB,$CDFC,$CDFD,$CDFE,$CE40,$CE41,$CE42,$CE43,
$CE44,$CE45,$CE46,$CE47,$CE48,$CE49,$CE4A,$CE4B,$CE4C,$CE4D,$CE4E,$CE4F,$CE50,
$CE51,$CE52,$CE53,$CE54,$CE55,$CE56,$CE57,$CE58,$CE59,$CE5A,$CE5B,$CE5C,$CE5D,
$CE5E,$CE5F,$CE60,$CE61,$CE62,$CE63,$CE64,$CE65,$CE66,$CE67,$CE68,$CE69,$CE6A,
$CE6B,$CE6C,$CE6D,$CE6E,$CE6F,$CE70,$CE71,$CE72,$CE73,$CE74,$CE75,$CE76,$CE77,
$CE78,$CE79,$CE7A,$CE7B,$CE7C,$CE7D,$CE7E,$CE80,$CE81,$CE82,$CE83,$CE84,$CE85,
$CE86,$CE87,$CE88,$CE89,$CE8A,$CE8B,$CE8C,$CE8D,$CE8E,$CE8F,$CE90,$CE91,$CE92,
$CE93,$CE94,$CE95,$CE96,$CE97,$CE98,$CE99,$CE9A,$CE9B,$CE9C,$CE9D,$CE9E,$CE9F,
$CEA0,$CEA1,$CEA2,$CEA3,$CEA4,$CEA5,$CEA6,$CEA7,$CEA8,$CEA9,$CEAA,$CEAB,$CEAC,
$CEAD,$CEAE,$CEAF,$CEB0,$CEB1,$CEB2,$CEB3,$CEB4,$CEB5,$CEB6,$CEB7,$CEB8,$CEB9,
$CEBA,$CEBB,$CEBC,$CEBD,$CEBE,$CEBF,$CEC0,$CEC1,$CEC2,$CEC3,$CEC4,$CEC5,$CEC6,
$CEC7,$CEC8,$CEC9,$CECA,$CECB,$CECC,$CECD,$CECE,$CECF,$CED0,$CED1,$CED2,$CED3,
$CED4,$CED5,$CED6,$CED7,$CED8,$CED9,$CEDA,$CEDB,$CEDC,$CEDD,$CEDE,$CEDF,$CEE0,
$CEE1,$CEE2,$CEE3,$CEE4,$CEE5,$CEE6,$CEE7,$CEE8,$CEE9,$CEEA,$CEEB,$CEEC,$CEED,
$CEEE,$CEEF,$CEF0,$CEF1,$CEF2,$CEF3,$CEF4,$CEF5,$CEF6,$CEF7,$CEF8,$CEF9,$CEFA,
$CEFB,$CEFC,$CEFD,$CEFE,$CF40,$CF41,$CF42,$CF43,$CF44,$CF45,$CF46,$CF47,$CF48,
$CF49,$CF4A,$CF4B,$CF4C,$CF4D,$CF4E,$CF4F,$CF50,$CF51,$CF52,$CF53,$CF54,$CF55,
$CF56,$CF57,$CF58,$CF59,$CF5A,$CF5B,$CF5C,$CF5D,$CF5E,$CF5F,$CF60,$CF61,$CF62,
$CF63,$CF64,$CF65,$CF66,$CF67,$CF68,$CF69,$CF6A,$CF6B,$CF6C,$CF6D,$CF6E,$CF6F,
$CF70,$CF71,$CF72,$CF73,$CF74,$CF75,$CF76,$CF77,$CF78,$CF79,$CF7A,$CF7B,$CF7C,
$CF7D,$CF7E,$CF80,$CF81,$CF82,$CF83,$CF84,$CF85,$CF86,$CF87,$CF88,$CF89,$CF8A,
$CF8B,$CF8C,$CF8D,$CF8E,$CF8F,$CF90,$CF91,$CF92,$CF93,$CF94,$CF95,$CF96,$CF97,
$CF98,$CF99,$CF9A,$CF9B,$CF9C,$CF9D,$CF9E,$CF9F,$CFA0,$CFA1,$CFA2,$CFA3,$CFA4,
$CFA5,$CFA6,$CFA7,$CFA8,$CFA9,$CFAA,$CFAB,$CFAC,$CFAD,$CFAE,$CFAF,$CFB0,$CFB1,
$CFB2,$CFB3,$CFB4,$CFB5,$CFB6,$CFB7,$CFB8,$CFB9,$CFBA,$CFBB,$CFBC,$CFBD,$CFBE,
$CFBF,$CFC0,$CFC1,$CFC2,$CFC3,$CFC4,$CFC5,$CFC6,$CFC7,$CFC8,$CFC9,$CFCA,$CFCB,
$CFCC,$CFCD,$CFCE,$CFCF,$CFD0,$CFD1,$CFD2,$CFD3,$CFD4,$CFD5,$CFD6,$CFD7,$CFD8,
$CFD9,$CFDA,$CFDB,$CFDC,$CFDD,$CFDE,$CFDF,$CFE0,$CFE1,$CFE2,$CFE3,$CFE4,$CFE5,
$CFE6,$CFE7,$CFE8,$CFE9,$CFEA,$CFEB,$CFEC,$CFED,$CFEE,$CFEF,$CFF0,$CFF1,$CFF2,
$CFF3,$CFF4,$CFF5,$CFF6,$CFF7,$CFF8,$CFF9,$CFFA,$CFFB,$CFFC,$CFFD,$CFFE,$D040,
$D041,$D042,$D043,$D044,$D045,$D046,$D047,$D048,$D049,$D04A,$D04B,$D04C,$D04D,
$D04E,$D04F,$D050,$D051,$D052,$D053,$D054,$D055,$D056,$D057,$D058,$D059,$D05A,
$D05B,$D05C,$D05D,$D05E,$D05F,$D060,$D061,$D062,$D063,$D064,$D065,$D066,$D067,
$D068,$D069,$D06A,$D06B,$D06C,$D06D,$D06E,$D06F,$D070,$D071,$D072,$D073,$D074,
$D075,$D076,$D077,$D078,$D079,$D07A,$D07B,$D07C,$D07D,$D07E,$D080,$D081,$D082,
$D083,$D084,$D085,$D086,$D087,$D088,$D089,$D08A,$D08B,$D08C,$D08D,$D08E,$D08F,
$D090,$D091,$D092,$D093,$D094,$D095,$D096,$D097,$D098,$D099,$D09A,$D09B,$D09C,
$D09D,$D09E,$D09F,$D0A0,$D0A1,$D0A2,$D0A3,$D0A4,$D0A5,$D0A6,$D0A7,$D0A8,$D0A9,
$D0AA,$D0AB,$D0AC,$D0AD,$D0AE,$D0AF,$D0B0,$D0B1,$D0B2,$D0B3,$D0B4,$D0B5,$D0B6,
$D0B7,$D0B8,$D0B9,$D0BA,$D0BB,$D0BC,$D0BD,$D0BE,$D0BF,$D0C0,$D0C1,$D0C2,$D0C3,
$D0C4,$D0C5,$D0C6,$D0C7,$D0C8,$D0C9,$D0CA,$D0CB,$D0CC,$D0CD,$D0CE,$D0CF,$D0D0,
$D0D1,$D0D2,$D0D3,$D0D4,$D0D5,$D0D6,$D0D7,$D0D8,$D0D9,$D0DA,$D0DB,$D0DC,$D0DD,
$D0DE,$D0DF,$D0E0,$D0E1,$D0E2,$D0E3,$D0E4,$D0E5,$D0E6,$D0E7,$D0E8,$D0E9,$D0EA,
$D0EB,$D0EC,$D0ED,$D0EE,$D0EF,$D0F0,$D0F1,$D0F2,$D0F3,$D0F4,$D0F5,$D0F6,$D0F7,
$D0F8,$D0F9,$D0FA,$D0FB,$D0FC,$D0FD,$D0FE,$D140,$D141,$D142,$D143,$D144,$D145,
$D146,$D147,$D148,$D149,$D14A,$D14B,$D14C,$D14D,$D14E,$D14F,$D150,$D151,$D152,
$D153,$D154,$D155,$D156,$D157,$D158,$D159,$D15A,$D15B,$D15C,$D15D,$D15E,$D15F,
$D160,$D161,$D162,$D163,$D164,$D165,$D166,$D167,$D168,$D169,$D16A,$D16B,$D16C,
$D16D,$D16E,$D16F,$D170,$D171,$D172,$D173,$D174,$D175,$D176,$D177,$D178,$D179,
$D17A,$D17B,$D17C,$D17D,$D17E,$D180,$D181,$D182,$D183,$D184,$D185,$D186,$D187,
$D188,$D189,$D18A,$D18B,$D18C,$D18D,$D18E,$D18F,$D190,$D191,$D192,$D193,$D194,
$D195,$D196,$D197,$D198,$D199,$D19A,$D19B,$D19C,$D19D,$D19E,$D19F,$D1A0,$D1A1,
$D1A2,$D1A3,$D1A4,$D1A5,$D1A6,$D1A7,$D1A8,$D1A9,$D1AA,$D1AB,$D1AC,$D1AD,$D1AE,
$D1AF,$D1B0,$D1B1,$D1B2,$D1B3,$D1B4,$D1B5,$D1B6,$D1B7,$D1B8,$D1B9,$D1BA,$D1BB,
$D1BC,$D1BD,$D1BE,$D1BF,$D1C0,$D1C1,$D1C2,$D1C3,$D1C4,$D1C5,$D1C6,$D1C7,$D1C8,
$D1C9,$D1CA,$D1CB,$D1CC,$D1CD,$D1CE,$D1CF,$D1D0,$D1D1,$D1D2,$D1D3,$D1D4,$D1D5,
$D1D6,$D1D7,$D1D8,$D1D9,$D1DA,$D1DB,$D1DC,$D1DD,$D1DE,$D1DF,$D1E0,$D1E1,$D1E2,
$D1E3,$D1E4,$D1E5,$D1E6,$D1E7,$D1E8,$D1E9,$D1EA,$D1EB,$D1EC,$D1ED,$D1EE,$D1EF,
$D1F0,$D1F1,$D1F2,$D1F3,$D1F4,$D1F5,$D1F6,$D1F7,$D1F8,$D1F9,$D1FA,$D1FB,$D1FC,
$D1FD,$D1FE,$D240,$D241,$D242,$D243,$D244,$D245,$D246,$D247,$D248,$D249,$D24A,
$D24B,$D24C,$D24D,$D24E,$D24F,$D250,$D251,$D252,$D253,$D254,$D255,$D256,$D257,
$D258,$D259,$D25A,$D25B,$D25C,$D25D,$D25E,$D25F,$D260,$D261,$D262,$D263,$D264,
$D265,$D266,$D267,$D268,$D269,$D26A,$D26B,$D26C,$D26D,$D26E,$D26F,$D270,$D271,
$D272,$D273,$D274,$D275,$D276,$D277,$D278,$D279,$D27A,$D27B,$D27C,$D27D,$D27E,
$D280,$D281,$D282,$D283,$D284,$D285,$D286,$D287,$D288,$D289,$D28A,$D28B,$D28C,
$D28D,$D28E,$D28F,$D290,$D291,$D292,$D293,$D294,$D295,$D296,$D297,$D298,$D299,
$D29A,$D29B,$D29C,$D29D,$D29E,$D29F,$D2A0,$D2A1,$D2A2,$D2A3,$D2A4,$D2A5,$D2A6,
$D2A7,$D2A8,$D2A9,$D2AA,$D2AB,$D2AC,$D2AD,$D2AE,$D2AF,$D2B0,$D2B1,$D2B2,$D2B3,
$D2B4,$D2B5,$D2B6,$D2B7,$D2B8,$D2B9,$D2BA,$D2BB,$D2BC,$D2BD,$D2BE,$D2BF,$D2C0,
$D2C1,$D2C2,$D2C3,$D2C4,$D2C5,$D2C6,$D2C7,$D2C8,$D2C9,$D2CA,$D2CB,$D2CC,$D2CD,
$D2CE,$D2CF,$D2D0,$D2D1,$D2D2,$D2D3,$D2D4,$D2D5,$D2D6,$D2D7,$D2D8,$D2D9,$D2DA,
$D2DB,$D2DC,$D2DD,$D2DE,$D2DF,$D2E0,$D2E1,$D2E2,$D2E3,$D2E4,$D2E5,$D2E6,$D2E7,
$D2E8,$D2E9,$D2EA,$D2EB,$D2EC,$D2ED,$D2EE,$D2EF,$D2F0,$D2F1,$D2F2,$D2F3,$D2F4,
$D2F5,$D2F6,$D2F7,$D2F8,$D2F9,$D2FA,$D2FB,$D2FC,$D2FD,$D2FE,$D340,$D341,$D342,
$D343,$D344,$D345,$D346,$D347,$D348,$D349,$D34A,$D34B,$D34C,$D34D,$D34E,$D34F,
$D350,$D351,$D352,$D353,$D354,$D355,$D356,$D357,$D358,$D359,$D35A,$D35B,$D35C,
$D35D,$D35E,$D35F,$D360,$D361,$D362,$D363,$D364,$D365,$D366,$D367,$D368,$D369,
$D36A,$D36B,$D36C,$D36D,$D36E,$D36F,$D370,$D371,$D372,$D373,$D374,$D375,$D376,
$D377,$D378,$D379,$D37A,$D37B,$D37C,$D37D,$D37E,$D380,$D381,$D382,$D383,$D384,
$D385,$D386,$D387,$D388,$D389,$D38A,$D38B,$D38C,$D38D,$D38E,$D38F,$D390,$D391,
$D392,$D393,$D394,$D395,$D396,$D397,$D398,$D399,$D39A,$D39B,$D39C,$D39D,$D39E,
$D39F,$D3A0,$D3A1,$D3A2,$D3A3,$D3A4,$D3A5,$D3A6,$D3A7,$D3A8,$D3A9,$D3AA,$D3AB,
$D3AC,$D3AD,$D3AE,$D3AF,$D3B0,$D3B1,$D3B2,$D3B3,$D3B4,$D3B5,$D3B6,$D3B7,$D3B8,
$D3B9,$D3BA,$D3BB,$D3BC,$D3BD,$D3BE,$D3BF,$D3C0,$D3C1,$D3C2,$D3C3,$D3C4,$D3C5,
$D3C6,$D3C7,$D3C8,$D3C9,$D3CA,$D3CB,$D3CC,$D3CD,$D3CE,$D3CF,$D3D0,$D3D1,$D3D2,
$D3D3,$D3D4,$D3D5,$D3D6,$D3D7,$D3D8,$D3D9,$D3DA,$D3DB,$D3DC,$D3DD,$D3DE,$D3DF,
$D3E0,$D3E1,$D3E2,$D3E3,$D3E4,$D3E5,$D3E6,$D3E7,$D3E8,$D3E9,$D3EA,$D3EB,$D3EC,
$D3ED,$D3EE,$D3EF,$D3F0,$D3F1,$D3F2,$D3F3,$D3F4,$D3F5,$D3F6,$D3F7,$D3F8,$D3F9,
$D3FA,$D3FB,$D3FC,$D3FD,$D3FE,$D440,$D441,$D442,$D443,$D444,$D445,$D446,$D447,
$D448,$D449,$D44A,$D44B,$D44C,$D44D,$D44E,$D44F,$D450,$D451,$D452,$D453,$D454,
$D455,$D456,$D457,$D458,$D459,$D45A,$D45B,$D45C,$D45D,$D45E,$D45F,$D460,$D461,
$D462,$D463,$D464,$D465,$D466,$D467,$D468,$D469,$D46A,$D46B,$D46C,$D46D,$D46E,
$D46F,$D470,$D471,$D472,$D473,$D474,$D475,$D476,$D477,$D478,$D479,$D47A,$D47B,
$D47C,$D47D,$D47E,$D480,$D481,$D482,$D483,$D484,$D485,$D486,$D487,$D488,$D489,
$D48A,$D48B,$D48C,$D48D,$D48E,$D48F,$D490,$D491,$D492,$D493,$D494,$D495,$D496,
$D497,$D498,$D499,$D49A,$D49B,$D49C,$D49D,$D49E,$D49F,$D4A0,$D4A1,$D4A2,$D4A3,
$D4A4,$D4A5,$D4A6,$D4A7,$D4A8,$D4A9,$D4AA,$D4AB,$D4AC,$D4AD,$D4AE,$D4AF,$D4B0,
$D4B1,$D4B2,$D4B3,$D4B4,$D4B5,$D4B6,$D4B7,$D4B8,$D4B9,$D4BA,$D4BB,$D4BC,$D4BD,
$D4BE,$D4BF,$D4C0,$D4C1,$D4C2,$D4C3,$D4C4,$D4C5,$D4C6,$D4C7,$D4C8,$D4C9,$D4CA,
$D4CB,$D4CC,$D4CD,$D4CE,$D4CF,$D4D0,$D4D1,$D4D2,$D4D3,$D4D4,$D4D5,$D4D6,$D4D7,
$D4D8,$D4D9,$D4DA,$D4DB,$D4DC,$D4DD,$D4DE,$D4DF,$D4E0,$D4E1,$D4E2,$D4E3,$D4E4,
$D4E5,$D4E6,$D4E7,$D4E8,$D4E9,$D4EA,$D4EB,$D4EC,$D4ED,$D4EE,$D4EF,$D4F0,$D4F1,
$D4F2,$D4F3,$D4F4,$D4F5,$D4F6,$D4F7,$D4F8,$D4F9,$D4FA,$D4FB,$D4FC,$D4FD,$D4FE,
$D540,$D541,$D542,$D543,$D544,$D545,$D546,$D547,$D548,$D549,$D54A,$D54B,$D54C,
$D54D,$D54E,$D54F,$D550,$D551,$D552,$D553,$D554,$D555,$D556,$D557,$D558,$D559,
$D55A,$D55B,$D55C,$D55D,$D55E,$D55F,$D560,$D561,$D562,$D563,$D564,$D565,$D566,
$D567,$D568,$D569,$D56A,$D56B,$D56C,$D56D,$D56E,$D56F,$D570,$D571,$D572,$D573,
$D574,$D575,$D576,$D577,$D578,$D579,$D57A,$D57B,$D57C,$D57D,$D57E,$D580,$D581,
$D582,$D583,$D584,$D585,$D586,$D587,$D588,$D589,$D58A,$D58B,$D58C,$D58D,$D58E,
$D58F,$D590,$D591,$D592,$D593,$D594,$D595,$D596,$D597,$D598,$D599,$D59A,$D59B,
$D59C,$D59D,$D59E,$D59F,$D5A0,$D5A1,$D5A2,$D5A3,$D5A4,$D5A5,$D5A6,$D5A7,$D5A8,
$D5A9,$D5AA,$D5AB,$D5AC,$D5AD,$D5AE,$D5AF,$D5B0,$D5B1,$D5B2,$D5B3,$D5B4,$D5B5,
$D5B6,$D5B7,$D5B8,$D5B9,$D5BA,$D5BB,$D5BC,$D5BD,$D5BE,$D5BF,$D5C0,$D5C1,$D5C2,
$D5C3,$D5C4,$D5C5,$D5C6,$D5C7,$D5C8,$D5C9,$D5CA,$D5CB,$D5CC,$D5CD,$D5CE,$D5CF,
$D5D0,$D5D1,$D5D2,$D5D3,$D5D4,$D5D5,$D5D6,$D5D7,$D5D8,$D5D9,$D5DA,$D5DB,$D5DC,
$D5DD,$D5DE,$D5DF,$D5E0,$D5E1,$D5E2,$D5E3,$D5E4,$D5E5,$D5E6,$D5E7,$D5E8,$D5E9,
$D5EA,$D5EB,$D5EC,$D5ED,$D5EE,$D5EF,$D5F0,$D5F1,$D5F2,$D5F3,$D5F4,$D5F5,$D5F6,
$D5F7,$D5F8,$D5F9,$D5FA,$D5FB,$D5FC,$D5FD,$D5FE,$D640,$D641,$D642,$D643,$D644,
$D645,$D646,$D647,$D648,$D649,$D64A,$D64B,$D64C,$D64D,$D64E,$D64F,$D650,$D651,
$D652,$D653,$D654,$D655,$D656,$D657,$D658,$D659,$D65A,$D65B,$D65C,$D65D,$D65E,
$D65F,$D660,$D661,$D662,$D663,$D664,$D665,$D666,$D667,$D668,$D669,$D66A,$D66B,
$D66C,$D66D,$D66E,$D66F,$D670,$D671,$D672,$D673,$D674,$D675,$D676,$D677,$D678,
$D679,$D67A,$D67B,$D67C,$D67D,$D67E,$D680,$D681,$D682,$D683,$D684,$D685,$D686,
$D687,$D688,$D689,$D68A,$D68B,$D68C,$D68D,$D68E,$D68F,$D690,$D691,$D692,$D693,
$D694,$D695,$D696,$D697,$D698,$D699,$D69A,$D69B,$D69C,$D69D,$D69E,$D69F,$D6A0,
$D6A1,$D6A2,$D6A3,$D6A4,$D6A5,$D6A6,$D6A7,$D6A8,$D6A9,$D6AA,$D6AB,$D6AC,$D6AD,
$D6AE,$D6AF,$D6B0,$D6B1,$D6B2,$D6B3,$D6B4,$D6B5,$D6B6,$D6B7,$D6B8,$D6B9,$D6BA,
$D6BB,$D6BC,$D6BD,$D6BE,$D6BF,$D6C0,$D6C1,$D6C2,$D6C3,$D6C4,$D6C5,$D6C6,$D6C7,
$D6C8,$D6C9,$D6CA,$D6CB,$D6CC,$D6CD,$D6CE,$D6CF,$D6D0,$D6D1,$D6D2,$D6D3,$D6D4,
$D6D5,$D6D6,$D6D7,$D6D8,$D6D9,$D6DA,$D6DB,$D6DC,$D6DD,$D6DE,$D6DF,$D6E0,$D6E1,
$D6E2,$D6E3,$D6E4,$D6E5,$D6E6,$D6E7,$D6E8,$D6E9,$D6EA,$D6EB,$D6EC,$D6ED,$D6EE,
$D6EF,$D6F0,$D6F1,$D6F2,$D6F3,$D6F4,$D6F5,$D6F6,$D6F7,$D6F8,$D6F9,$D6FA,$D6FB,
$D6FC,$D6FD,$D6FE,$D740,$D741,$D742,$D743,$D744,$D745,$D746,$D747,$D748,$D749,
$D74A,$D74B,$D74C,$D74D,$D74E,$D74F,$D750,$D751,$D752,$D753,$D754,$D755,$D756,
$D757,$D758,$D759,$D75A,$D75B,$D75C,$D75D,$D75E,$D75F,$D760,$D761,$D762,$D763,
$D764,$D765,$D766,$D767,$D768,$D769,$D76A,$D76B,$D76C,$D76D,$D76E,$D76F,$D770,
$D771,$D772,$D773,$D774,$D775,$D776,$D777,$D778,$D779,$D77A,$D77B,$D77C,$D77D,
$D77E,$D780,$D781,$D782,$D783,$D784,$D785,$D786,$D787,$D788,$D789,$D78A,$D78B,
$D78C,$D78D,$D78E,$D78F,$D790,$D791,$D792,$D793,$D794,$D795,$D796,$D797,$D798,
$D799,$D79A,$D79B,$D79C,$D79D,$D79E,$D79F,$D7A0,$D7A1,$D7A2,$D7A3,$D7A4,$D7A5,
$D7A6,$D7A7,$D7A8,$D7A9,$D7AA,$D7AB,$D7AC,$D7AD,$D7AE,$D7AF,$D7B0,$D7B1,$D7B2,
$D7B3,$D7B4,$D7B5,$D7B6,$D7B7,$D7B8,$D7B9,$D7BA,$D7BB,$D7BC,$D7BD,$D7BE,$D7BF,
$D7C0,$D7C1,$D7C2,$D7C3,$D7C4,$D7C5,$D7C6,$D7C7,$D7C8,$D7C9,$D7CA,$D7CB,$D7CC,
$D7CD,$D7CE,$D7CF,$D7D0,$D7D1,$D7D2,$D7D3,$D7D4,$D7D5,$D7D6,$D7D7,$D7D8,$D7D9,
$D7DA,$D7DB,$D7DC,$D7DD,$D7DE,$D7DF,$D7E0,$D7E1,$D7E2,$D7E3,$D7E4,$D7E5,$D7E6,
$D7E7,$D7E8,$D7E9,$D7EA,$D7EB,$D7EC,$D7ED,$D7EE,$D7EF,$D7F0,$D7F1,$D7F2,$D7F3,
$D7F4,$D7F5,$D7F6,$D7F7,$D7F8,$D7F9,$D840,$D841,$D842,$D843,$D844,$D845,$D846,
$D847,$D848,$D849,$D84A,$D84B,$D84C,$D84D,$D84E,$D84F,$D850,$D851,$D852,$D853,
$D854,$D855,$D856,$D857,$D858,$D859,$D85A,$D85B,$D85C,$D85D,$D85E,$D85F,$D860,
$D861,$D862,$D863,$D864,$D865,$D866,$D867,$D868,$D869,$D86A,$D86B,$D86C,$D86D,
$D86E,$D86F,$D870,$D871,$D872,$D873,$D874,$D875,$D876,$D877,$D878,$D879,$D87A,
$D87B,$D87C,$D87D,$D87E,$D880,$D881,$D882,$D883,$D884,$D885,$D886,$D887,$D888,
$D889,$D88A,$D88B,$D88C,$D88D,$D88E,$D88F,$D890,$D891,$D892,$D893,$D894,$D895,
$D896,$D897,$D898,$D899,$D89A,$D89B,$D89C,$D89D,$D89E,$D89F,$D8A0,$D8A1,$D8A2,
$D8A3,$D8A4,$D8A5,$D8A6,$D8A7,$D8A8,$D8A9,$D8AA,$D8AB,$D8AC,$D8AD,$D8AE,$D8AF,
$D8B0,$D8B1,$D8B2,$D8B3,$D8B4,$D8B5,$D8B6,$D8B7,$D8B8,$D8B9,$D8BA,$D8BB,$D8BC,
$D8BD,$D8BE,$D8BF,$D8C0,$D8C1,$D8C2,$D8C3,$D8C4,$D8C5,$D8C6,$D8C7,$D8C8,$D8C9,
$D8CA,$D8CB,$D8CC,$D8CD,$D8CE,$D8CF,$D8D0,$D8D1,$D8D2,$D8D3,$D8D4,$D8D5,$D8D6,
$D8D7,$D8D8,$D8D9,$D8DA,$D8DB,$D8DC,$D8DD,$D8DE,$D8DF,$D8E0,$D8E1,$D8E2,$D8E3,
$D8E4,$D8E5,$D8E6,$D8E7,$D8E8,$D8E9,$D8EA,$D8EB,$D8EC,$D8ED,$D8EE,$D8EF,$D8F0,
$D8F1,$D8F2,$D8F3,$D8F4,$D8F5,$D8F6,$D8F7,$D8F8,$D8F9,$D8FA,$D8FB,$D8FC,$D8FD,
$D8FE,$D940,$D941,$D942,$D943,$D944,$D945,$D946,$D947,$D948,$D949,$D94A,$D94B,
$D94C,$D94D,$D94E,$D94F,$D950,$D951,$D952,$D953,$D954,$D955,$D956,$D957,$D958,
$D959,$D95A,$D95B,$D95C,$D95D,$D95E,$D95F,$D960,$D961,$D962,$D963,$D964,$D965,
$D966,$D967,$D968,$D969,$D96A,$D96B,$D96C,$D96D,$D96E,$D96F,$D970,$D971,$D972,
$D973,$D974,$D975,$D976,$D977,$D978,$D979,$D97A,$D97B,$D97C,$D97D,$D97E,$D980,
$D981,$D982,$D983,$D984,$D985,$D986,$D987,$D988,$D989,$D98A,$D98B,$D98C,$D98D,
$D98E,$D98F,$D990,$D991,$D992,$D993,$D994,$D995,$D996,$D997,$D998,$D999,$D99A,
$D99B,$D99C,$D99D,$D99E,$D99F,$D9A0,$D9A1,$D9A2,$D9A3,$D9A4,$D9A5,$D9A6,$D9A7,
$D9A8,$D9A9,$D9AA,$D9AB,$D9AC,$D9AD,$D9AE,$D9AF,$D9B0,$D9B1,$D9B2,$D9B3,$D9B4,
$D9B5,$D9B6,$D9B7,$D9B8,$D9B9,$D9BA,$D9BB,$D9BC,$D9BD,$D9BE,$D9BF,$D9C0,$D9C1,
$D9C2,$D9C3,$D9C4,$D9C5,$D9C6,$D9C7,$D9C8,$D9C9,$D9CA,$D9CB,$D9CC,$D9CD,$D9CE,
$D9CF,$D9D0,$D9D1,$D9D2,$D9D3,$D9D4,$D9D5,$D9D6,$D9D7,$D9D8,$D9D9,$D9DA,$D9DB,
$D9DC,$D9DD,$D9DE,$D9DF,$D9E0,$D9E1,$D9E2,$D9E3,$D9E4,$D9E5,$D9E6,$D9E7,$D9E8,
$D9E9,$D9EA,$D9EB,$D9EC,$D9ED,$D9EE,$D9EF,$D9F0,$D9F1,$D9F2,$D9F3,$D9F4,$D9F5,
$D9F6,$D9F7,$D9F8,$D9F9,$D9FA,$D9FB,$D9FC,$D9FD,$D9FE,$DA40,$DA41,$DA42,$DA43,
$DA44,$DA45,$DA46,$DA47,$DA48,$DA49,$DA4A,$DA4B,$DA4C,$DA4D,$DA4E,$DA4F,$DA50,
$DA51,$DA52,$DA53,$DA54,$DA55,$DA56,$DA57,$DA58,$DA59,$DA5A,$DA5B,$DA5C,$DA5D,
$DA5E,$DA5F,$DA60,$DA61,$DA62,$DA63,$DA64,$DA65,$DA66,$DA67,$DA68,$DA69,$DA6A,
$DA6B,$DA6C,$DA6D,$DA6E,$DA6F,$DA70,$DA71,$DA72,$DA73,$DA74,$DA75,$DA76,$DA77,
$DA78,$DA79,$DA7A,$DA7B,$DA7C,$DA7D,$DA7E,$DA80,$DA81,$DA82,$DA83,$DA84,$DA85,
$DA86,$DA87,$DA88,$DA89,$DA8A,$DA8B,$DA8C,$DA8D,$DA8E,$DA8F,$DA90,$DA91,$DA92,
$DA93,$DA94,$DA95,$DA96,$DA97,$DA98,$DA99,$DA9A,$DA9B,$DA9C,$DA9D,$DA9E,$DA9F,
$DAA0,$DAA1,$DAA2,$DAA3,$DAA4,$DAA5,$DAA6,$DAA7,$DAA8,$DAA9,$DAAA,$DAAB,$DAAC,
$DAAD,$DAAE,$DAAF,$DAB0,$DAB1,$DAB2,$DAB3,$DAB4,$DAB5,$DAB6,$DAB7,$DAB8,$DAB9,
$DABA,$DABB,$DABC,$DABD,$DABE,$DABF,$DAC0,$DAC1,$DAC2,$DAC3,$DAC4,$DAC5,$DAC6,
$DAC7,$DAC8,$DAC9,$DACA,$DACB,$DACC,$DACD,$DACE,$DACF,$DAD0,$DAD1,$DAD2,$DAD3,
$DAD4,$DAD5,$DAD6,$DAD7,$DAD8,$DAD9,$DADA,$DADB,$DADC,$DADD,$DADE,$DADF,$DAE0,
$DAE1,$DAE2,$DAE3,$DAE4,$DAE5,$DAE6,$DAE7,$DAE8,$DAE9,$DAEA,$DAEB,$DAEC,$DAED,
$DAEE,$DAEF,$DAF0,$DAF1,$DAF2,$DAF3,$DAF4,$DAF5,$DAF6,$DAF7,$DAF8,$DAF9,$DAFA,
$DAFB,$DAFC,$DAFD,$DAFE,$DB40,$DB41,$DB42,$DB43,$DB44,$DB45,$DB46,$DB47,$DB48,
$DB49,$DB4A,$DB4B,$DB4C,$DB4D,$DB4E,$DB4F,$DB50,$DB51,$DB52,$DB53,$DB54,$DB55,
$DB56,$DB57,$DB58,$DB59,$DB5A,$DB5B,$DB5C,$DB5D,$DB5E,$DB5F,$DB60,$DB61,$DB62,
$DB63,$DB64,$DB65,$DB66,$DB67,$DB68,$DB69,$DB6A,$DB6B,$DB6C,$DB6D,$DB6E,$DB6F,
$DB70,$DB71,$DB72,$DB73,$DB74,$DB75,$DB76,$DB77,$DB78,$DB79,$DB7A,$DB7B,$DB7C,
$DB7D,$DB7E,$DB80,$DB81,$DB82,$DB83,$DB84,$DB85,$DB86,$DB87,$DB88,$DB89,$DB8A,
$DB8B,$DB8C,$DB8D,$DB8E,$DB8F,$DB90,$DB91,$DB92,$DB93,$DB94,$DB95,$DB96,$DB97,
$DB98,$DB99,$DB9A,$DB9B,$DB9C,$DB9D,$DB9E,$DB9F,$DBA0,$DBA1,$DBA2,$DBA3,$DBA4,
$DBA5,$DBA6,$DBA7,$DBA8,$DBA9,$DBAA,$DBAB,$DBAC,$DBAD,$DBAE,$DBAF,$DBB0,$DBB1,
$DBB2,$DBB3,$DBB4,$DBB5,$DBB6,$DBB7,$DBB8,$DBB9,$DBBA,$DBBB,$DBBC,$DBBD,$DBBE,
$DBBF,$DBC0,$DBC1,$DBC2,$DBC3,$DBC4,$DBC5,$DBC6,$DBC7,$DBC8,$DBC9,$DBCA,$DBCB,
$DBCC,$DBCD,$DBCE,$DBCF,$DBD0,$DBD1,$DBD2,$DBD3,$DBD4,$DBD5,$DBD6,$DBD7,$DBD8,
$DBD9,$DBDA,$DBDB,$DBDC,$DBDD,$DBDE,$DBDF,$DBE0,$DBE1,$DBE2,$DBE3,$DBE4,$DBE5,
$DBE6,$DBE7,$DBE8,$DBE9,$DBEA,$DBEB,$DBEC,$DBED,$DBEE,$DBEF,$DBF0,$DBF1,$DBF2,
$DBF3,$DBF4,$DBF5,$DBF6,$DBF7,$DBF8,$DBF9,$DBFA,$DBFB,$DBFC,$DBFD,$DBFE,$DC40,
$DC41,$DC42,$DC43,$DC44,$DC45,$DC46,$DC47,$DC48,$DC49,$DC4A,$DC4B,$DC4C,$DC4D,
$DC4E,$DC4F,$DC50,$DC51,$DC52,$DC53,$DC54,$DC55,$DC56,$DC57,$DC58,$DC59,$DC5A,
$DC5B,$DC5C,$DC5D,$DC5E,$DC5F,$DC60,$DC61,$DC62,$DC63,$DC64,$DC65,$DC66,$DC67,
$DC68,$DC69,$DC6A,$DC6B,$DC6C,$DC6D,$DC6E,$DC6F,$DC70,$DC71,$DC72,$DC73,$DC74,
$DC75,$DC76,$DC77,$DC78,$DC79,$DC7A,$DC7B,$DC7C,$DC7D,$DC7E,$DC80,$DC81,$DC82,
$DC83,$DC84,$DC85,$DC86,$DC87,$DC88,$DC89,$DC8A,$DC8B,$DC8C,$DC8D,$DC8E,$DC8F,
$DC90,$DC91,$DC92,$DC93,$DC94,$DC95,$DC96,$DC97,$DC98,$DC99,$DC9A,$DC9B,$DC9C,
$DC9D,$DC9E,$DC9F,$DCA0,$DCA1,$DCA2,$DCA3,$DCA4,$DCA5,$DCA6,$DCA7,$DCA8,$DCA9,
$DCAA,$DCAB,$DCAC,$DCAD,$DCAE,$DCAF,$DCB0,$DCB1,$DCB2,$DCB3,$DCB4,$DCB5,$DCB6,
$DCB7,$DCB8,$DCB9,$DCBA,$DCBB,$DCBC,$DCBD,$DCBE,$DCBF,$DCC0,$DCC1,$DCC2,$DCC3,
$DCC4,$DCC5,$DCC6,$DCC7,$DCC8,$DCC9,$DCCA,$DCCB,$DCCC,$DCCD,$DCCE,$DCCF,$DCD0,
$DCD1,$DCD2,$DCD3,$DCD4,$DCD5,$DCD6,$DCD7,$DCD8,$DCD9,$DCDA,$DCDB,$DCDC,$DCDD,
$DCDE,$DCDF,$DCE0,$DCE1,$DCE2,$DCE3,$DCE4,$DCE5,$DCE6,$DCE7,$DCE8,$DCE9,$DCEA,
$DCEB,$DCEC,$DCED,$DCEE,$DCEF,$DCF0,$DCF1,$DCF2,$DCF3,$DCF4,$DCF5,$DCF6,$DCF7,
$DCF8,$DCF9,$DCFA,$DCFB,$DCFC,$DCFD,$DCFE,$DD40,$DD41,$DD42,$DD43,$DD44,$DD45,
$DD46,$DD47,$DD48,$DD49,$DD4A,$DD4B,$DD4C,$DD4D,$DD4E,$DD4F,$DD50,$DD51,$DD52,
$DD53,$DD54,$DD55,$DD56,$DD57,$DD58,$DD59,$DD5A,$DD5B,$DD5C,$DD5D,$DD5E,$DD5F,
$DD60,$DD61,$DD62,$DD63,$DD64,$DD65,$DD66,$DD67,$DD68,$DD69,$DD6A,$DD6B,$DD6C,
$DD6D,$DD6E,$DD6F,$DD70,$DD71,$DD72,$DD73,$DD74,$DD75,$DD76,$DD77,$DD78,$DD79,
$DD7A,$DD7B,$DD7C,$DD7D,$DD7E,$DD80,$DD81,$DD82,$DD83,$DD84,$DD85,$DD86,$DD87,
$DD88,$DD89,$DD8A,$DD8B,$DD8C,$DD8D,$DD8E,$DD8F,$DD90,$DD91,$DD92,$DD93,$DD94,
$DD95,$DD96,$DD97,$DD98,$DD99,$DD9A,$DD9B,$DD9C,$DD9D,$DD9E,$DD9F,$DDA0,$DDA1,
$DDA2,$DDA3,$DDA4,$DDA5,$DDA6,$DDA7,$DDA8,$DDA9,$DDAA,$DDAB,$DDAC,$DDAD,$DDAE,
$DDAF,$DDB0,$DDB1,$DDB2,$DDB3,$DDB4,$DDB5,$DDB6,$DDB7,$DDB8,$DDB9,$DDBA,$DDBB,
$DDBC,$DDBD,$DDBE,$DDBF,$DDC0,$DDC1,$DDC2,$DDC3,$DDC4,$DDC5,$DDC6,$DDC7,$DDC8,
$DDC9,$DDCA,$DDCB,$DDCC,$DDCD,$DDCE,$DDCF,$DDD0,$DDD1,$DDD2,$DDD3,$DDD4,$DDD5,
$DDD6,$DDD7,$DDD8,$DDD9,$DDDA,$DDDB,$DDDC,$DDDD,$DDDE,$DDDF,$DDE0,$DDE1,$DDE2,
$DDE3,$DDE4,$DDE5,$DDE6,$DDE7,$DDE8,$DDE9,$DDEA,$DDEB,$DDEC,$DDED,$DDEE,$DDEF,
$DDF0,$DDF1,$DDF2,$DDF3,$DDF4,$DDF5,$DDF6,$DDF7,$DDF8,$DDF9,$DDFA,$DDFB,$DDFC,
$DDFD,$DDFE,$DE40,$DE41,$DE42,$DE43,$DE44,$DE45,$DE46,$DE47,$DE48,$DE49,$DE4A,
$DE4B,$DE4C,$DE4D,$DE4E,$DE4F,$DE50,$DE51,$DE52,$DE53,$DE54,$DE55,$DE56,$DE57,
$DE58,$DE59,$DE5A,$DE5B,$DE5C,$DE5D,$DE5E,$DE5F,$DE60,$DE61,$DE62,$DE63,$DE64,
$DE65,$DE66,$DE67,$DE68,$DE69,$DE6A,$DE6B,$DE6C,$DE6D,$DE6E,$DE6F,$DE70,$DE71,
$DE72,$DE73,$DE74,$DE75,$DE76,$DE77,$DE78,$DE79,$DE7A,$DE7B,$DE7C,$DE7D,$DE7E,
$DE80,$DE81,$DE82,$DE83,$DE84,$DE85,$DE86,$DE87,$DE88,$DE89,$DE8A,$DE8B,$DE8C,
$DE8D,$DE8E,$DE8F,$DE90,$DE91,$DE92,$DE93,$DE94,$DE95,$DE96,$DE97,$DE98,$DE99,
$DE9A,$DE9B,$DE9C,$DE9D,$DE9E,$DE9F,$DEA0,$DEA1,$DEA2,$DEA3,$DEA4,$DEA5,$DEA6,
$DEA7,$DEA8,$DEA9,$DEAA,$DEAB,$DEAC,$DEAD,$DEAE,$DEAF,$DEB0,$DEB1,$DEB2,$DEB3,
$DEB4,$DEB5,$DEB6,$DEB7,$DEB8,$DEB9,$DEBA,$DEBB,$DEBC,$DEBD,$DEBE,$DEBF,$DEC0,
$DEC1,$DEC2,$DEC3,$DEC4,$DEC5,$DEC6,$DEC7,$DEC8,$DEC9,$DECA,$DECB,$DECC,$DECD,
$DECE,$DECF,$DED0,$DED1,$DED2,$DED3,$DED4,$DED5,$DED6,$DED7,$DED8,$DED9,$DEDA,
$DEDB,$DEDC,$DEDD,$DEDE,$DEDF,$DEE0,$DEE1,$DEE2,$DEE3,$DEE4,$DEE5,$DEE6,$DEE7,
$DEE8,$DEE9,$DEEA,$DEEB,$DEEC,$DEED,$DEEE,$DEEF,$DEF0,$DEF1,$DEF2,$DEF3,$DEF4,
$DEF5,$DEF6,$DEF7,$DEF8,$DEF9,$DEFA,$DEFB,$DEFC,$DEFD,$DEFE,$DF40,$DF41,$DF42,
$DF43,$DF44,$DF45,$DF46,$DF47,$DF48,$DF49,$DF4A,$DF4B,$DF4C,$DF4D,$DF4E,$DF4F,
$DF50,$DF51,$DF52,$DF53,$DF54,$DF55,$DF56,$DF57,$DF58,$DF59,$DF5A,$DF5B,$DF5C,
$DF5D,$DF5E,$DF5F,$DF60,$DF61,$DF62,$DF63,$DF64,$DF65,$DF66,$DF67,$DF68,$DF69,
$DF6A,$DF6B,$DF6C,$DF6D,$DF6E,$DF6F,$DF70,$DF71,$DF72,$DF73,$DF74,$DF75,$DF76,
$DF77,$DF78,$DF79,$DF7A,$DF7B,$DF7C,$DF7D,$DF7E,$DF80,$DF81,$DF82,$DF83,$DF84,
$DF85,$DF86,$DF87,$DF88,$DF89,$DF8A,$DF8B,$DF8C,$DF8D,$DF8E,$DF8F,$DF90,$DF91,
$DF92,$DF93,$DF94,$DF95,$DF96,$DF97,$DF98,$DF99,$DF9A,$DF9B,$DF9C,$DF9D,$DF9E,
$DF9F,$DFA0,$DFA1,$DFA2,$DFA3,$DFA4,$DFA5,$DFA6,$DFA7,$DFA8,$DFA9,$DFAA,$DFAB,
$DFAC,$DFAD,$DFAE,$DFAF,$DFB0,$DFB1,$DFB2,$DFB3,$DFB4,$DFB5,$DFB6,$DFB7,$DFB8,
$DFB9,$DFBA,$DFBB,$DFBC,$DFBD,$DFBE,$DFBF,$DFC0,$DFC1,$DFC2,$DFC3,$DFC4,$DFC5,
$DFC6,$DFC7,$DFC8,$DFC9,$DFCA,$DFCB,$DFCC,$DFCD,$DFCE,$DFCF,$DFD0,$DFD1,$DFD2,
$DFD3,$DFD4,$DFD5,$DFD6,$DFD7,$DFD8,$DFD9,$DFDA,$DFDB,$DFDC,$DFDD,$DFDE,$DFDF,
$DFE0,$DFE1,$DFE2,$DFE3,$DFE4,$DFE5,$DFE6,$DFE7,$DFE8,$DFE9,$DFEA,$DFEB,$DFEC,
$DFED,$DFEE,$DFEF,$DFF0,$DFF1,$DFF2,$DFF3,$DFF4,$DFF5,$DFF6,$DFF7,$DFF8,$DFF9,
$DFFA,$DFFB,$DFFC,$DFFD,$DFFE,$E040,$E041,$E042,$E043,$E044,$E045,$E046,$E047,
$E048,$E049,$E04A,$E04B,$E04C,$E04D,$E04E,$E04F,$E050,$E051,$E052,$E053,$E054,
$E055,$E056,$E057,$E058,$E059,$E05A,$E05B,$E05C,$E05D,$E05E,$E05F,$E060,$E061,
$E062,$E063,$E064,$E065,$E066,$E067,$E068,$E069,$E06A,$E06B,$E06C,$E06D,$E06E,
$E06F,$E070,$E071,$E072,$E073,$E074,$E075,$E076,$E077,$E078,$E079,$E07A,$E07B,
$E07C,$E07D,$E07E,$E080,$E081,$E082,$E083,$E084,$E085,$E086,$E087,$E088,$E089,
$E08A,$E08B,$E08C,$E08D,$E08E,$E08F,$E090,$E091,$E092,$E093,$E094,$E095,$E096,
$E097,$E098,$E099,$E09A,$E09B,$E09C,$E09D,$E09E,$E09F,$E0A0,$E0A1,$E0A2,$E0A3,
$E0A4,$E0A5,$E0A6,$E0A7,$E0A8,$E0A9,$E0AA,$E0AB,$E0AC,$E0AD,$E0AE,$E0AF,$E0B0,
$E0B1,$E0B2,$E0B3,$E0B4,$E0B5,$E0B6,$E0B7,$E0B8,$E0B9,$E0BA,$E0BB,$E0BC,$E0BD,
$E0BE,$E0BF,$E0C0,$E0C1,$E0C2,$E0C3,$E0C4,$E0C5,$E0C6,$E0C7,$E0C8,$E0C9,$E0CA,
$E0CB,$E0CC,$E0CD,$E0CE,$E0CF,$E0D0,$E0D1,$E0D2,$E0D3,$E0D4,$E0D5,$E0D6,$E0D7,
$E0D8,$E0D9,$E0DA,$E0DB,$E0DC,$E0DD,$E0DE,$E0DF,$E0E0,$E0E1,$E0E2,$E0E3,$E0E4,
$E0E5,$E0E6,$E0E7,$E0E8,$E0E9,$E0EA,$E0EB,$E0EC,$E0ED,$E0EE,$E0EF,$E0F0,$E0F1,
$E0F2,$E0F3,$E0F4,$E0F5,$E0F6,$E0F7,$E0F8,$E0F9,$E0FA,$E0FB,$E0FC,$E0FD,$E0FE,
$E140,$E141,$E142,$E143,$E144,$E145,$E146,$E147,$E148,$E149,$E14A,$E14B,$E14C,
$E14D,$E14E,$E14F,$E150,$E151,$E152,$E153,$E154,$E155,$E156,$E157,$E158,$E159,
$E15A,$E15B,$E15C,$E15D,$E15E,$E15F,$E160,$E161,$E162,$E163,$E164,$E165,$E166,
$E167,$E168,$E169,$E16A,$E16B,$E16C,$E16D,$E16E,$E16F,$E170,$E171,$E172,$E173,
$E174,$E175,$E176,$E177,$E178,$E179,$E17A,$E17B,$E17C,$E17D,$E17E,$E180,$E181,
$E182,$E183,$E184,$E185,$E186,$E187,$E188,$E189,$E18A,$E18B,$E18C,$E18D,$E18E,
$E18F,$E190,$E191,$E192,$E193,$E194,$E195,$E196,$E197,$E198,$E199,$E19A,$E19B,
$E19C,$E19D,$E19E,$E19F,$E1A0,$E1A1,$E1A2,$E1A3,$E1A4,$E1A5,$E1A6,$E1A7,$E1A8,
$E1A9,$E1AA,$E1AB,$E1AC,$E1AD,$E1AE,$E1AF,$E1B0,$E1B1,$E1B2,$E1B3,$E1B4,$E1B5,
$E1B6,$E1B7,$E1B8,$E1B9,$E1BA,$E1BB,$E1BC,$E1BD,$E1BE,$E1BF,$E1C0,$E1C1,$E1C2,
$E1C3,$E1C4,$E1C5,$E1C6,$E1C7,$E1C8,$E1C9,$E1CA,$E1CB,$E1CC,$E1CD,$E1CE,$E1CF,
$E1D0,$E1D1,$E1D2,$E1D3,$E1D4,$E1D5,$E1D6,$E1D7,$E1D8,$E1D9,$E1DA,$E1DB,$E1DC,
$E1DD,$E1DE,$E1DF,$E1E0,$E1E1,$E1E2,$E1E3,$E1E4,$E1E5,$E1E6,$E1E7,$E1E8,$E1E9,
$E1EA,$E1EB,$E1EC,$E1ED,$E1EE,$E1EF,$E1F0,$E1F1,$E1F2,$E1F3,$E1F4,$E1F5,$E1F6,
$E1F7,$E1F8,$E1F9,$E1FA,$E1FB,$E1FC,$E1FD,$E1FE,$E240,$E241,$E242,$E243,$E244,
$E245,$E246,$E247,$E248,$E249,$E24A,$E24B,$E24C,$E24D,$E24E,$E24F,$E250,$E251,
$E252,$E253,$E254,$E255,$E256,$E257,$E258,$E259,$E25A,$E25B,$E25C,$E25D,$E25E,
$E25F,$E260,$E261,$E262,$E263,$E264,$E265,$E266,$E267,$E268,$E269,$E26A,$E26B,
$E26C,$E26D,$E26E,$E26F,$E270,$E271,$E272,$E273,$E274,$E275,$E276,$E277,$E278,
$E279,$E27A,$E27B,$E27C,$E27D,$E27E,$E280,$E281,$E282,$E283,$E284,$E285,$E286,
$E287,$E288,$E289,$E28A,$E28B,$E28C,$E28D,$E28E,$E28F,$E290,$E291,$E292,$E293,
$E294,$E295,$E296,$E297,$E298,$E299,$E29A,$E29B,$E29C,$E29D,$E29E,$E29F,$E2A0,
$E2A1,$E2A2,$E2A3,$E2A4,$E2A5,$E2A6,$E2A7,$E2A8,$E2A9,$E2AA,$E2AB,$E2AC,$E2AD,
$E2AE,$E2AF,$E2B0,$E2B1,$E2B2,$E2B3,$E2B4,$E2B5,$E2B6,$E2B7,$E2B8,$E2B9,$E2BA,
$E2BB,$E2BC,$E2BD,$E2BE,$E2BF,$E2C0,$E2C1,$E2C2,$E2C3,$E2C4,$E2C5,$E2C6,$E2C7,
$E2C8,$E2C9,$E2CA,$E2CB,$E2CC,$E2CD,$E2CE,$E2CF,$E2D0,$E2D1,$E2D2,$E2D3,$E2D4,
$E2D5,$E2D6,$E2D7,$E2D8,$E2D9,$E2DA,$E2DB,$E2DC,$E2DD,$E2DE,$E2DF,$E2E0,$E2E1,
$E2E2,$E2E3,$E2E4,$E2E5,$E2E6,$E2E7,$E2E8,$E2E9,$E2EA,$E2EB,$E2EC,$E2ED,$E2EE,
$E2EF,$E2F0,$E2F1,$E2F2,$E2F3,$E2F4,$E2F5,$E2F6,$E2F7,$E2F8,$E2F9,$E2FA,$E2FB,
$E2FC,$E2FD,$E2FE,$E340,$E341,$E342,$E343,$E344,$E345,$E346,$E347,$E348,$E349,
$E34A,$E34B,$E34C,$E34D,$E34E,$E34F,$E350,$E351,$E352,$E353,$E354,$E355,$E356,
$E357,$E358,$E359,$E35A,$E35B,$E35C,$E35D,$E35E,$E35F,$E360,$E361,$E362,$E363,
$E364,$E365,$E366,$E367,$E368,$E369,$E36A,$E36B,$E36C,$E36D,$E36E,$E36F,$E370,
$E371,$E372,$E373,$E374,$E375,$E376,$E377,$E378,$E379,$E37A,$E37B,$E37C,$E37D,
$E37E,$E380,$E381,$E382,$E383,$E384,$E385,$E386,$E387,$E388,$E389,$E38A,$E38B,
$E38C,$E38D,$E38E,$E38F,$E390,$E391,$E392,$E393,$E394,$E395,$E396,$E397,$E398,
$E399,$E39A,$E39B,$E39C,$E39D,$E39E,$E39F,$E3A0,$E3A1,$E3A2,$E3A3,$E3A4,$E3A5,
$E3A6,$E3A7,$E3A8,$E3A9,$E3AA,$E3AB,$E3AC,$E3AD,$E3AE,$E3AF,$E3B0,$E3B1,$E3B2,
$E3B3,$E3B4,$E3B5,$E3B6,$E3B7,$E3B8,$E3B9,$E3BA,$E3BB,$E3BC,$E3BD,$E3BE,$E3BF,
$E3C0,$E3C1,$E3C2,$E3C3,$E3C4,$E3C5,$E3C6,$E3C7,$E3C8,$E3C9,$E3CA,$E3CB,$E3CC,
$E3CD,$E3CE,$E3CF,$E3D0,$E3D1,$E3D2,$E3D3,$E3D4,$E3D5,$E3D6,$E3D7,$E3D8,$E3D9,
$E3DA,$E3DB,$E3DC,$E3DD,$E3DE,$E3DF,$E3E0,$E3E1,$E3E2,$E3E3,$E3E4,$E3E5,$E3E6,
$E3E7,$E3E8,$E3E9,$E3EA,$E3EB,$E3EC,$E3ED,$E3EE,$E3EF,$E3F0,$E3F1,$E3F2,$E3F3,
$E3F4,$E3F5,$E3F6,$E3F7,$E3F8,$E3F9,$E3FA,$E3FB,$E3FC,$E3FD,$E3FE,$E440,$E441,
$E442,$E443,$E444,$E445,$E446,$E447,$E448,$E449,$E44A,$E44B,$E44C,$E44D,$E44E,
$E44F,$E450,$E451,$E452,$E453,$E454,$E455,$E456,$E457,$E458,$E459,$E45A,$E45B,
$E45C,$E45D,$E45E,$E45F,$E460,$E461,$E462,$E463,$E464,$E465,$E466,$E467,$E468,
$E469,$E46A,$E46B,$E46C,$E46D,$E46E,$E46F,$E470,$E471,$E472,$E473,$E474,$E475,
$E476,$E477,$E478,$E479,$E47A,$E47B,$E47C,$E47D,$E47E,$E480,$E481,$E482,$E483,
$E484,$E485,$E486,$E487,$E488,$E489,$E48A,$E48B,$E48C,$E48D,$E48E,$E48F,$E490,
$E491,$E492,$E493,$E494,$E495,$E496,$E497,$E498,$E499,$E49A,$E49B,$E49C,$E49D,
$E49E,$E49F,$E4A0,$E4A1,$E4A2,$E4A3,$E4A4,$E4A5,$E4A6,$E4A7,$E4A8,$E4A9,$E4AA,
$E4AB,$E4AC,$E4AD,$E4AE,$E4AF,$E4B0,$E4B1,$E4B2,$E4B3,$E4B4,$E4B5,$E4B6,$E4B7,
$E4B8,$E4B9,$E4BA,$E4BB,$E4BC,$E4BD,$E4BE,$E4BF,$E4C0,$E4C1,$E4C2,$E4C3,$E4C4,
$E4C5,$E4C6,$E4C7,$E4C8,$E4C9,$E4CA,$E4CB,$E4CC,$E4CD,$E4CE,$E4CF,$E4D0,$E4D1,
$E4D2,$E4D3,$E4D4,$E4D5,$E4D6,$E4D7,$E4D8,$E4D9,$E4DA,$E4DB,$E4DC,$E4DD,$E4DE,
$E4DF,$E4E0,$E4E1,$E4E2,$E4E3,$E4E4,$E4E5,$E4E6,$E4E7,$E4E8,$E4E9,$E4EA,$E4EB,
$E4EC,$E4ED,$E4EE,$E4EF,$E4F0,$E4F1,$E4F2,$E4F3,$E4F4,$E4F5,$E4F6,$E4F7,$E4F8,
$E4F9,$E4FA,$E4FB,$E4FC,$E4FD,$E4FE,$E540,$E541,$E542,$E543,$E544,$E545,$E546,
$E547,$E548,$E549,$E54A,$E54B,$E54C,$E54D,$E54E,$E54F,$E550,$E551,$E552,$E553,
$E554,$E555,$E556,$E557,$E558,$E559,$E55A,$E55B,$E55C,$E55D,$E55E,$E55F,$E560,
$E561,$E562,$E563,$E564,$E565,$E566,$E567,$E568,$E569,$E56A,$E56B,$E56C,$E56D,
$E56E,$E56F,$E570,$E571,$E572,$E573,$E574,$E575,$E576,$E577,$E578,$E579,$E57A,
$E57B,$E57C,$E57D,$E57E,$E580,$E581,$E582,$E583,$E584,$E585,$E586,$E587,$E588,
$E589,$E58A,$E58B,$E58C,$E58D,$E58E,$E58F,$E590,$E591,$E592,$E593,$E594,$E595,
$E596,$E597,$E598,$E599,$E59A,$E59B,$E59C,$E59D,$E59E,$E59F,$E5A0,$E5A1,$E5A2,
$E5A3,$E5A4,$E5A5,$E5A6,$E5A7,$E5A8,$E5A9,$E5AA,$E5AB,$E5AC,$E5AD,$E5AE,$E5AF,
$E5B0,$E5B1,$E5B2,$E5B3,$E5B4,$E5B5,$E5B6,$E5B7,$E5B8,$E5B9,$E5BA,$E5BB,$E5BC,
$E5BD,$E5BE,$E5BF,$E5C0,$E5C1,$E5C2,$E5C3,$E5C4,$E5C5,$E5C6,$E5C7,$E5C8,$E5C9,
$E5CA,$E5CB,$E5CC,$E5CD,$E5CE,$E5CF,$E5D0,$E5D1,$E5D2,$E5D3,$E5D4,$E5D5,$E5D6,
$E5D7,$E5D8,$E5D9,$E5DA,$E5DB,$E5DC,$E5DD,$E5DE,$E5DF,$E5E0,$E5E1,$E5E2,$E5E3,
$E5E4,$E5E5,$E5E6,$E5E7,$E5E8,$E5E9,$E5EA,$E5EB,$E5EC,$E5ED,$E5EE,$E5EF,$E5F0,
$E5F1,$E5F2,$E5F3,$E5F4,$E5F5,$E5F6,$E5F7,$E5F8,$E5F9,$E5FA,$E5FB,$E5FC,$E5FD,
$E5FE,$E640,$E641,$E642,$E643,$E644,$E645,$E646,$E647,$E648,$E649,$E64A,$E64B,
$E64C,$E64D,$E64E,$E64F,$E650,$E651,$E652,$E653,$E654,$E655,$E656,$E657,$E658,
$E659,$E65A,$E65B,$E65C,$E65D,$E65E,$E65F,$E660,$E661,$E662,$E663,$E664,$E665,
$E666,$E667,$E668,$E669,$E66A,$E66B,$E66C,$E66D,$E66E,$E66F,$E670,$E671,$E672,
$E673,$E674,$E675,$E676,$E677,$E678,$E679,$E67A,$E67B,$E67C,$E67D,$E67E,$E680,
$E681,$E682,$E683,$E684,$E685,$E686,$E687,$E688,$E689,$E68A,$E68B,$E68C,$E68D,
$E68E,$E68F,$E690,$E691,$E692,$E693,$E694,$E695,$E696,$E697,$E698,$E699,$E69A,
$E69B,$E69C,$E69D,$E69E,$E69F,$E6A0,$E6A1,$E6A2,$E6A3,$E6A4,$E6A5,$E6A6,$E6A7,
$E6A8,$E6A9,$E6AA,$E6AB,$E6AC,$E6AD,$E6AE,$E6AF,$E6B0,$E6B1,$E6B2,$E6B3,$E6B4,
$E6B5,$E6B6,$E6B7,$E6B8,$E6B9,$E6BA,$E6BB,$E6BC,$E6BD,$E6BE,$E6BF,$E6C0,$E6C1,
$E6C2,$E6C3,$E6C4,$E6C5,$E6C6,$E6C7,$E6C8,$E6C9,$E6CA,$E6CB,$E6CC,$E6CD,$E6CE,
$E6CF,$E6D0,$E6D1,$E6D2,$E6D3,$E6D4,$E6D5,$E6D6,$E6D7,$E6D8,$E6D9,$E6DA,$E6DB,
$E6DC,$E6DD,$E6DE,$E6DF,$E6E0,$E6E1,$E6E2,$E6E3,$E6E4,$E6E5,$E6E6,$E6E7,$E6E8,
$E6E9,$E6EA,$E6EB,$E6EC,$E6ED,$E6EE,$E6EF,$E6F0,$E6F1,$E6F2,$E6F3,$E6F4,$E6F5,
$E6F6,$E6F7,$E6F8,$E6F9,$E6FA,$E6FB,$E6FC,$E6FD,$E6FE,$E740,$E741,$E742,$E743,
$E744,$E745,$E746,$E747,$E748,$E749,$E74A,$E74B,$E74C,$E74D,$E74E,$E74F,$E750,
$E751,$E752,$E753,$E754,$E755,$E756,$E757,$E758,$E759,$E75A,$E75B,$E75C,$E75D,
$E75E,$E75F,$E760,$E761,$E762,$E763,$E764,$E765,$E766,$E767,$E768,$E769,$E76A,
$E76B,$E76C,$E76D,$E76E,$E76F,$E770,$E771,$E772,$E773,$E774,$E775,$E776,$E777,
$E778,$E779,$E77A,$E77B,$E77C,$E77D,$E77E,$E780,$E781,$E782,$E783,$E784,$E785,
$E786,$E787,$E788,$E789,$E78A,$E78B,$E78C,$E78D,$E78E,$E78F,$E790,$E791,$E792,
$E793,$E794,$E795,$E796,$E797,$E798,$E799,$E79A,$E79B,$E79C,$E79D,$E79E,$E79F,
$E7A0,$E7A1,$E7A2,$E7A3,$E7A4,$E7A5,$E7A6,$E7A7,$E7A8,$E7A9,$E7AA,$E7AB,$E7AC,
$E7AD,$E7AE,$E7AF,$E7B0,$E7B1,$E7B2,$E7B3,$E7B4,$E7B5,$E7B6,$E7B7,$E7B8,$E7B9,
$E7BA,$E7BB,$E7BC,$E7BD,$E7BE,$E7BF,$E7C0,$E7C1,$E7C2,$E7C3,$E7C4,$E7C5,$E7C6,
$E7C7,$E7C8,$E7C9,$E7CA,$E7CB,$E7CC,$E7CD,$E7CE,$E7CF,$E7D0,$E7D1,$E7D2,$E7D3,
$E7D4,$E7D5,$E7D6,$E7D7,$E7D8,$E7D9,$E7DA,$E7DB,$E7DC,$E7DD,$E7DE,$E7DF,$E7E0,
$E7E1,$E7E2,$E7E3,$E7E4,$E7E5,$E7E6,$E7E7,$E7E8,$E7E9,$E7EA,$E7EB,$E7EC,$E7ED,
$E7EE,$E7EF,$E7F0,$E7F1,$E7F2,$E7F3,$E7F4,$E7F5,$E7F6,$E7F7,$E7F8,$E7F9,$E7FA,
$E7FB,$E7FC,$E7FD,$E7FE,$E840,$E841,$E842,$E843,$E844,$E845,$E846,$E847,$E848,
$E849,$E84A,$E84B,$E84C,$E84D,$E84E,$E84F,$E850,$E851,$E852,$E853,$E854,$E855,
$E856,$E857,$E858,$E859,$E85A,$E85B,$E85C,$E85D,$E85E,$E85F,$E860,$E861,$E862,
$E863,$E864,$E865,$E866,$E867,$E868,$E869,$E86A,$E86B,$E86C,$E86D,$E86E,$E86F,
$E870,$E871,$E872,$E873,$E874,$E875,$E876,$E877,$E878,$E879,$E87A,$E87B,$E87C,
$E87D,$E87E,$E880,$E881,$E882,$E883,$E884,$E885,$E886,$E887,$E888,$E889,$E88A,
$E88B,$E88C,$E88D,$E88E,$E88F,$E890,$E891,$E892,$E893,$E894,$E895,$E896,$E897,
$E898,$E899,$E89A,$E89B,$E89C,$E89D,$E89E,$E89F,$E8A0,$E8A1,$E8A2,$E8A3,$E8A4,
$E8A5,$E8A6,$E8A7,$E8A8,$E8A9,$E8AA,$E8AB,$E8AC,$E8AD,$E8AE,$E8AF,$E8B0,$E8B1,
$E8B2,$E8B3,$E8B4,$E8B5,$E8B6,$E8B7,$E8B8,$E8B9,$E8BA,$E8BB,$E8BC,$E8BD,$E8BE,
$E8BF,$E8C0,$E8C1,$E8C2,$E8C3,$E8C4,$E8C5,$E8C6,$E8C7,$E8C8,$E8C9,$E8CA,$E8CB,
$E8CC,$E8CD,$E8CE,$E8CF,$E8D0,$E8D1,$E8D2,$E8D3,$E8D4,$E8D5,$E8D6,$E8D7,$E8D8,
$E8D9,$E8DA,$E8DB,$E8DC,$E8DD,$E8DE,$E8DF,$E8E0,$E8E1,$E8E2,$E8E3,$E8E4,$E8E5,
$E8E6,$E8E7,$E8E8,$E8E9,$E8EA,$E8EB,$E8EC,$E8ED,$E8EE,$E8EF,$E8F0,$E8F1,$E8F2,
$E8F3,$E8F4,$E8F5,$E8F6,$E8F7,$E8F8,$E8F9,$E8FA,$E8FB,$E8FC,$E8FD,$E8FE,$E940,
$E941,$E942,$E943,$E944,$E945,$E946,$E947,$E948,$E949,$E94A,$E94B,$E94C,$E94D,
$E94E,$E94F,$E950,$E951,$E952,$E953,$E954,$E955,$E956,$E957,$E958,$E959,$E95A,
$E95B,$E95C,$E95D,$E95E,$E95F,$E960,$E961,$E962,$E963,$E964,$E965,$E966,$E967,
$E968,$E969,$E96A,$E96B,$E96C,$E96D,$E96E,$E96F,$E970,$E971,$E972,$E973,$E974,
$E975,$E976,$E977,$E978,$E979,$E97A,$E97B,$E97C,$E97D,$E97E,$E980,$E981,$E982,
$E983,$E984,$E985,$E986,$E987,$E988,$E989,$E98A,$E98B,$E98C,$E98D,$E98E,$E98F,
$E990,$E991,$E992,$E993,$E994,$E995,$E996,$E997,$E998,$E999,$E99A,$E99B,$E99C,
$E99D,$E99E,$E99F,$E9A0,$E9A1,$E9A2,$E9A3,$E9A4,$E9A5,$E9A6,$E9A7,$E9A8,$E9A9,
$E9AA,$E9AB,$E9AC,$E9AD,$E9AE,$E9AF,$E9B0,$E9B1,$E9B2,$E9B3,$E9B4,$E9B5,$E9B6,
$E9B7,$E9B8,$E9B9,$E9BA,$E9BB,$E9BC,$E9BD,$E9BE,$E9BF,$E9C0,$E9C1,$E9C2,$E9C3,
$E9C4,$E9C5,$E9C6,$E9C7,$E9C8,$E9C9,$E9CA,$E9CB,$E9CC,$E9CD,$E9CE,$E9CF,$E9D0,
$E9D1,$E9D2,$E9D3,$E9D4,$E9D5,$E9D6,$E9D7,$E9D8,$E9D9,$E9DA,$E9DB,$E9DC,$E9DD,
$E9DE,$E9DF,$E9E0,$E9E1,$E9E2,$E9E3,$E9E4,$E9E5,$E9E6,$E9E7,$E9E8,$E9E9,$E9EA,
$E9EB,$E9EC,$E9ED,$E9EE,$E9EF,$E9F0,$E9F1,$E9F2,$E9F3,$E9F4,$E9F5,$E9F6,$E9F7,
$E9F8,$E9F9,$E9FA,$E9FB,$E9FC,$E9FD,$E9FE,$EA40,$EA41,$EA42,$EA43,$EA44,$EA45,
$EA46,$EA47,$EA48,$EA49,$EA4A,$EA4B,$EA4C,$EA4D,$EA4E,$EA4F,$EA50,$EA51,$EA52,
$EA53,$EA54,$EA55,$EA56,$EA57,$EA58,$EA59,$EA5A,$EA5B,$EA5C,$EA5D,$EA5E,$EA5F,
$EA60,$EA61,$EA62,$EA63,$EA64,$EA65,$EA66,$EA67,$EA68,$EA69,$EA6A,$EA6B,$EA6C,
$EA6D,$EA6E,$EA6F,$EA70,$EA71,$EA72,$EA73,$EA74,$EA75,$EA76,$EA77,$EA78,$EA79,
$EA7A,$EA7B,$EA7C,$EA7D,$EA7E,$EA80,$EA81,$EA82,$EA83,$EA84,$EA85,$EA86,$EA87,
$EA88,$EA89,$EA8A,$EA8B,$EA8C,$EA8D,$EA8E,$EA8F,$EA90,$EA91,$EA92,$EA93,$EA94,
$EA95,$EA96,$EA97,$EA98,$EA99,$EA9A,$EA9B,$EA9C,$EA9D,$EA9E,$EA9F,$EAA0,$EAA1,
$EAA2,$EAA3,$EAA4,$EAA5,$EAA6,$EAA7,$EAA8,$EAA9,$EAAA,$EAAB,$EAAC,$EAAD,$EAAE,
$EAAF,$EAB0,$EAB1,$EAB2,$EAB3,$EAB4,$EAB5,$EAB6,$EAB7,$EAB8,$EAB9,$EABA,$EABB,
$EABC,$EABD,$EABE,$EABF,$EAC0,$EAC1,$EAC2,$EAC3,$EAC4,$EAC5,$EAC6,$EAC7,$EAC8,
$EAC9,$EACA,$EACB,$EACC,$EACD,$EACE,$EACF,$EAD0,$EAD1,$EAD2,$EAD3,$EAD4,$EAD5,
$EAD6,$EAD7,$EAD8,$EAD9,$EADA,$EADB,$EADC,$EADD,$EADE,$EADF,$EAE0,$EAE1,$EAE2,
$EAE3,$EAE4,$EAE5,$EAE6,$EAE7,$EAE8,$EAE9,$EAEA,$EAEB,$EAEC,$EAED,$EAEE,$EAEF,
$EAF0,$EAF1,$EAF2,$EAF3,$EAF4,$EAF5,$EAF6,$EAF7,$EAF8,$EAF9,$EAFA,$EAFB,$EAFC,
$EAFD,$EAFE,$EB40,$EB41,$EB42,$EB43,$EB44,$EB45,$EB46,$EB47,$EB48,$EB49,$EB4A,
$EB4B,$EB4C,$EB4D,$EB4E,$EB4F,$EB50,$EB51,$EB52,$EB53,$EB54,$EB55,$EB56,$EB57,
$EB58,$EB59,$EB5A,$EB5B,$EB5C,$EB5D,$EB5E,$EB5F,$EB60,$EB61,$EB62,$EB63,$EB64,
$EB65,$EB66,$EB67,$EB68,$EB69,$EB6A,$EB6B,$EB6C,$EB6D,$EB6E,$EB6F,$EB70,$EB71,
$EB72,$EB73,$EB74,$EB75,$EB76,$EB77,$EB78,$EB79,$EB7A,$EB7B,$EB7C,$EB7D,$EB7E,
$EB80,$EB81,$EB82,$EB83,$EB84,$EB85,$EB86,$EB87,$EB88,$EB89,$EB8A,$EB8B,$EB8C,
$EB8D,$EB8E,$EB8F,$EB90,$EB91,$EB92,$EB93,$EB94,$EB95,$EB96,$EB97,$EB98,$EB99,
$EB9A,$EB9B,$EB9C,$EB9D,$EB9E,$EB9F,$EBA0,$EBA1,$EBA2,$EBA3,$EBA4,$EBA5,$EBA6,
$EBA7,$EBA8,$EBA9,$EBAA,$EBAB,$EBAC,$EBAD,$EBAE,$EBAF,$EBB0,$EBB1,$EBB2,$EBB3,
$EBB4,$EBB5,$EBB6,$EBB7,$EBB8,$EBB9,$EBBA,$EBBB,$EBBC,$EBBD,$EBBE,$EBBF,$EBC0,
$EBC1,$EBC2,$EBC3,$EBC4,$EBC5,$EBC6,$EBC7,$EBC8,$EBC9,$EBCA,$EBCB,$EBCC,$EBCD,
$EBCE,$EBCF,$EBD0,$EBD1,$EBD2,$EBD3,$EBD4,$EBD5,$EBD6,$EBD7,$EBD8,$EBD9,$EBDA,
$EBDB,$EBDC,$EBDD,$EBDE,$EBDF,$EBE0,$EBE1,$EBE2,$EBE3,$EBE4,$EBE5,$EBE6,$EBE7,
$EBE8,$EBE9,$EBEA,$EBEB,$EBEC,$EBED,$EBEE,$EBEF,$EBF0,$EBF1,$EBF2,$EBF3,$EBF4,
$EBF5,$EBF6,$EBF7,$EBF8,$EBF9,$EBFA,$EBFB,$EBFC,$EBFD,$EBFE,$EC40,$EC41,$EC42,
$EC43,$EC44,$EC45,$EC46,$EC47,$EC48,$EC49,$EC4A,$EC4B,$EC4C,$EC4D,$EC4E,$EC4F,
$EC50,$EC51,$EC52,$EC53,$EC54,$EC55,$EC56,$EC57,$EC58,$EC59,$EC5A,$EC5B,$EC5C,
$EC5D,$EC5E,$EC5F,$EC60,$EC61,$EC62,$EC63,$EC64,$EC65,$EC66,$EC67,$EC68,$EC69,
$EC6A,$EC6B,$EC6C,$EC6D,$EC6E,$EC6F,$EC70,$EC71,$EC72,$EC73,$EC74,$EC75,$EC76,
$EC77,$EC78,$EC79,$EC7A,$EC7B,$EC7C,$EC7D,$EC7E,$EC80,$EC81,$EC82,$EC83,$EC84,
$EC85,$EC86,$EC87,$EC88,$EC89,$EC8A,$EC8B,$EC8C,$EC8D,$EC8E,$EC8F,$EC90,$EC91,
$EC92,$EC93,$EC94,$EC95,$EC96,$EC97,$EC98,$EC99,$EC9A,$EC9B,$EC9C,$EC9D,$EC9E,
$EC9F,$ECA0,$ECA1,$ECA2,$ECA3,$ECA4,$ECA5,$ECA6,$ECA7,$ECA8,$ECA9,$ECAA,$ECAB,
$ECAC,$ECAD,$ECAE,$ECAF,$ECB0,$ECB1,$ECB2,$ECB3,$ECB4,$ECB5,$ECB6,$ECB7,$ECB8,
$ECB9,$ECBA,$ECBB,$ECBC,$ECBD,$ECBE,$ECBF,$ECC0,$ECC1,$ECC2,$ECC3,$ECC4,$ECC5,
$ECC6,$ECC7,$ECC8,$ECC9,$ECCA,$ECCB,$ECCC,$ECCD,$ECCE,$ECCF,$ECD0,$ECD1,$ECD2,
$ECD3,$ECD4,$ECD5,$ECD6,$ECD7,$ECD8,$ECD9,$ECDA,$ECDB,$ECDC,$ECDD,$ECDE,$ECDF,
$ECE0,$ECE1,$ECE2,$ECE3,$ECE4,$ECE5,$ECE6,$ECE7,$ECE8,$ECE9,$ECEA,$ECEB,$ECEC,
$ECED,$ECEE,$ECEF,$ECF0,$ECF1,$ECF2,$ECF3,$ECF4,$ECF5,$ECF6,$ECF7,$ECF8,$ECF9,
$ECFA,$ECFB,$ECFC,$ECFD,$ECFE,$ED40,$ED41,$ED42,$ED43,$ED44,$ED45,$ED46,$ED47,
$ED48,$ED49,$ED4A,$ED4B,$ED4C,$ED4D,$ED4E,$ED4F,$ED50,$ED51,$ED52,$ED53,$ED54,
$ED55,$ED56,$ED57,$ED58,$ED59,$ED5A,$ED5B,$ED5C,$ED5D,$ED5E,$ED5F,$ED60,$ED61,
$ED62,$ED63,$ED64,$ED65,$ED66,$ED67,$ED68,$ED69,$ED6A,$ED6B,$ED6C,$ED6D,$ED6E,
$ED6F,$ED70,$ED71,$ED72,$ED73,$ED74,$ED75,$ED76,$ED77,$ED78,$ED79,$ED7A,$ED7B,
$ED7C,$ED7D,$ED7E,$ED80,$ED81,$ED82,$ED83,$ED84,$ED85,$ED86,$ED87,$ED88,$ED89,
$ED8A,$ED8B,$ED8C,$ED8D,$ED8E,$ED8F,$ED90,$ED91,$ED92,$ED93,$ED94,$ED95,$ED96,
$ED97,$ED98,$ED99,$ED9A,$ED9B,$ED9C,$ED9D,$ED9E,$ED9F,$EDA0,$EDA1,$EDA2,$EDA3,
$EDA4,$EDA5,$EDA6,$EDA7,$EDA8,$EDA9,$EDAA,$EDAB,$EDAC,$EDAD,$EDAE,$EDAF,$EDB0,
$EDB1,$EDB2,$EDB3,$EDB4,$EDB5,$EDB6,$EDB7,$EDB8,$EDB9,$EDBA,$EDBB,$EDBC,$EDBD,
$EDBE,$EDBF,$EDC0,$EDC1,$EDC2,$EDC3,$EDC4,$EDC5,$EDC6,$EDC7,$EDC8,$EDC9,$EDCA,
$EDCB,$EDCC,$EDCD,$EDCE,$EDCF,$EDD0,$EDD1,$EDD2,$EDD3,$EDD4,$EDD5,$EDD6,$EDD7,
$EDD8,$EDD9,$EDDA,$EDDB,$EDDC,$EDDD,$EDDE,$EDDF,$EDE0,$EDE1,$EDE2,$EDE3,$EDE4,
$EDE5,$EDE6,$EDE7,$EDE8,$EDE9,$EDEA,$EDEB,$EDEC,$EDED,$EDEE,$EDEF,$EDF0,$EDF1,
$EDF2,$EDF3,$EDF4,$EDF5,$EDF6,$EDF7,$EDF8,$EDF9,$EDFA,$EDFB,$EDFC,$EDFD,$EDFE,
$EE40,$EE41,$EE42,$EE43,$EE44,$EE45,$EE46,$EE47,$EE48,$EE49,$EE4A,$EE4B,$EE4C,
$EE4D,$EE4E,$EE4F,$EE50,$EE51,$EE52,$EE53,$EE54,$EE55,$EE56,$EE57,$EE58,$EE59,
$EE5A,$EE5B,$EE5C,$EE5D,$EE5E,$EE5F,$EE60,$EE61,$EE62,$EE63,$EE64,$EE65,$EE66,
$EE67,$EE68,$EE69,$EE6A,$EE6B,$EE6C,$EE6D,$EE6E,$EE6F,$EE70,$EE71,$EE72,$EE73,
$EE74,$EE75,$EE76,$EE77,$EE78,$EE79,$EE7A,$EE7B,$EE7C,$EE7D,$EE7E,$EE80,$EE81,
$EE82,$EE83,$EE84,$EE85,$EE86,$EE87,$EE88,$EE89,$EE8A,$EE8B,$EE8C,$EE8D,$EE8E,
$EE8F,$EE90,$EE91,$EE92,$EE93,$EE94,$EE95,$EE96,$EE97,$EE98,$EE99,$EE9A,$EE9B,
$EE9C,$EE9D,$EE9E,$EE9F,$EEA0,$EEA1,$EEA2,$EEA3,$EEA4,$EEA5,$EEA6,$EEA7,$EEA8,
$EEA9,$EEAA,$EEAB,$EEAC,$EEAD,$EEAE,$EEAF,$EEB0,$EEB1,$EEB2,$EEB3,$EEB4,$EEB5,
$EEB6,$EEB7,$EEB8,$EEB9,$EEBA,$EEBB,$EEBC,$EEBD,$EEBE,$EEBF,$EEC0,$EEC1,$EEC2,
$EEC3,$EEC4,$EEC5,$EEC6,$EEC7,$EEC8,$EEC9,$EECA,$EECB,$EECC,$EECD,$EECE,$EECF,
$EED0,$EED1,$EED2,$EED3,$EED4,$EED5,$EED6,$EED7,$EED8,$EED9,$EEDA,$EEDB,$EEDC,
$EEDD,$EEDE,$EEDF,$EEE0,$EEE1,$EEE2,$EEE3,$EEE4,$EEE5,$EEE6,$EEE7,$EEE8,$EEE9,
$EEEA,$EEEB,$EEEC,$EEED,$EEEE,$EEEF,$EEF0,$EEF1,$EEF2,$EEF3,$EEF4,$EEF5,$EEF6,
$EEF7,$EEF8,$EEF9,$EEFA,$EEFB,$EEFC,$EEFD,$EEFE,$EF40,$EF41,$EF42,$EF43,$EF44,
$EF45,$EF46,$EF47,$EF48,$EF49,$EF4A,$EF4B,$EF4C,$EF4D,$EF4E,$EF4F,$EF50,$EF51,
$EF52,$EF53,$EF54,$EF55,$EF56,$EF57,$EF58,$EF59,$EF5A,$EF5B,$EF5C,$EF5D,$EF5E,
$EF5F,$EF60,$EF61,$EF62,$EF63,$EF64,$EF65,$EF66,$EF67,$EF68,$EF69,$EF6A,$EF6B,
$EF6C,$EF6D,$EF6E,$EF6F,$EF70,$EF71,$EF72,$EF73,$EF74,$EF75,$EF76,$EF77,$EF78,
$EF79,$EF7A,$EF7B,$EF7C,$EF7D,$EF7E,$EF80,$EF81,$EF82,$EF83,$EF84,$EF85,$EF86,
$EF87,$EF88,$EF89,$EF8A,$EF8B,$EF8C,$EF8D,$EF8E,$EF8F,$EF90,$EF91,$EF92,$EF93,
$EF94,$EF95,$EF96,$EF97,$EF98,$EF99,$EF9A,$EF9B,$EF9C,$EF9D,$EF9E,$EF9F,$EFA0,
$EFA1,$EFA2,$EFA3,$EFA4,$EFA5,$EFA6,$EFA7,$EFA8,$EFA9,$EFAA,$EFAB,$EFAC,$EFAD,
$EFAE,$EFAF,$EFB0,$EFB1,$EFB2,$EFB3,$EFB4,$EFB5,$EFB6,$EFB7,$EFB8,$EFB9,$EFBA,
$EFBB,$EFBC,$EFBD,$EFBE,$EFBF,$EFC0,$EFC1,$EFC2,$EFC3,$EFC4,$EFC5,$EFC6,$EFC7,
$EFC8,$EFC9,$EFCA,$EFCB,$EFCC,$EFCD,$EFCE,$EFCF,$EFD0,$EFD1,$EFD2,$EFD3,$EFD4,
$EFD5,$EFD6,$EFD7,$EFD8,$EFD9,$EFDA,$EFDB,$EFDC,$EFDD,$EFDE,$EFDF,$EFE0,$EFE1,
$EFE2,$EFE3,$EFE4,$EFE5,$EFE6,$EFE7,$EFE8,$EFE9,$EFEA,$EFEB,$EFEC,$EFED,$EFEE,
$EFEF,$EFF0,$EFF1,$EFF2,$EFF3,$EFF4,$EFF5,$EFF6,$EFF7,$EFF8,$EFF9,$EFFA,$EFFB,
$EFFC,$EFFD,$EFFE,$F040,$F041,$F042,$F043,$F044,$F045,$F046,$F047,$F048,$F049,
$F04A,$F04B,$F04C,$F04D,$F04E,$F04F,$F050,$F051,$F052,$F053,$F054,$F055,$F056,
$F057,$F058,$F059,$F05A,$F05B,$F05C,$F05D,$F05E,$F05F,$F060,$F061,$F062,$F063,
$F064,$F065,$F066,$F067,$F068,$F069,$F06A,$F06B,$F06C,$F06D,$F06E,$F06F,$F070,
$F071,$F072,$F073,$F074,$F075,$F076,$F077,$F078,$F079,$F07A,$F07B,$F07C,$F07D,
$F07E,$F080,$F081,$F082,$F083,$F084,$F085,$F086,$F087,$F088,$F089,$F08A,$F08B,
$F08C,$F08D,$F08E,$F08F,$F090,$F091,$F092,$F093,$F094,$F095,$F096,$F097,$F098,
$F099,$F09A,$F09B,$F09C,$F09D,$F09E,$F09F,$F0A0,$F0A1,$F0A2,$F0A3,$F0A4,$F0A5,
$F0A6,$F0A7,$F0A8,$F0A9,$F0AA,$F0AB,$F0AC,$F0AD,$F0AE,$F0AF,$F0B0,$F0B1,$F0B2,
$F0B3,$F0B4,$F0B5,$F0B6,$F0B7,$F0B8,$F0B9,$F0BA,$F0BB,$F0BC,$F0BD,$F0BE,$F0BF,
$F0C0,$F0C1,$F0C2,$F0C3,$F0C4,$F0C5,$F0C6,$F0C7,$F0C8,$F0C9,$F0CA,$F0CB,$F0CC,
$F0CD,$F0CE,$F0CF,$F0D0,$F0D1,$F0D2,$F0D3,$F0D4,$F0D5,$F0D6,$F0D7,$F0D8,$F0D9,
$F0DA,$F0DB,$F0DC,$F0DD,$F0DE,$F0DF,$F0E0,$F0E1,$F0E2,$F0E3,$F0E4,$F0E5,$F0E6,
$F0E7,$F0E8,$F0E9,$F0EA,$F0EB,$F0EC,$F0ED,$F0EE,$F0EF,$F0F0,$F0F1,$F0F2,$F0F3,
$F0F4,$F0F5,$F0F6,$F0F7,$F0F8,$F0F9,$F0FA,$F0FB,$F0FC,$F0FD,$F0FE,$F140,$F141,
$F142,$F143,$F144,$F145,$F146,$F147,$F148,$F149,$F14A,$F14B,$F14C,$F14D,$F14E,
$F14F,$F150,$F151,$F152,$F153,$F154,$F155,$F156,$F157,$F158,$F159,$F15A,$F15B,
$F15C,$F15D,$F15E,$F15F,$F160,$F161,$F162,$F163,$F164,$F165,$F166,$F167,$F168,
$F169,$F16A,$F16B,$F16C,$F16D,$F16E,$F16F,$F170,$F171,$F172,$F173,$F174,$F175,
$F176,$F177,$F178,$F179,$F17A,$F17B,$F17C,$F17D,$F17E,$F180,$F181,$F182,$F183,
$F184,$F185,$F186,$F187,$F188,$F189,$F18A,$F18B,$F18C,$F18D,$F18E,$F18F,$F190,
$F191,$F192,$F193,$F194,$F195,$F196,$F197,$F198,$F199,$F19A,$F19B,$F19C,$F19D,
$F19E,$F19F,$F1A0,$F1A1,$F1A2,$F1A3,$F1A4,$F1A5,$F1A6,$F1A7,$F1A8,$F1A9,$F1AA,
$F1AB,$F1AC,$F1AD,$F1AE,$F1AF,$F1B0,$F1B1,$F1B2,$F1B3,$F1B4,$F1B5,$F1B6,$F1B7,
$F1B8,$F1B9,$F1BA,$F1BB,$F1BC,$F1BD,$F1BE,$F1BF,$F1C0,$F1C1,$F1C2,$F1C3,$F1C4,
$F1C5,$F1C6,$F1C7,$F1C8,$F1C9,$F1CA,$F1CB,$F1CC,$F1CD,$F1CE,$F1CF,$F1D0,$F1D1,
$F1D2,$F1D3,$F1D4,$F1D5,$F1D6,$F1D7,$F1D8,$F1D9,$F1DA,$F1DB,$F1DC,$F1DD,$F1DE,
$F1DF,$F1E0,$F1E1,$F1E2,$F1E3,$F1E4,$F1E5,$F1E6,$F1E7,$F1E8,$F1E9,$F1EA,$F1EB,
$F1EC,$F1ED,$F1EE,$F1EF,$F1F0,$F1F1,$F1F2,$F1F3,$F1F4,$F1F5,$F1F6,$F1F7,$F1F8,
$F1F9,$F1FA,$F1FB,$F1FC,$F1FD,$F1FE,$F240,$F241,$F242,$F243,$F244,$F245,$F246,
$F247,$F248,$F249,$F24A,$F24B,$F24C,$F24D,$F24E,$F24F,$F250,$F251,$F252,$F253,
$F254,$F255,$F256,$F257,$F258,$F259,$F25A,$F25B,$F25C,$F25D,$F25E,$F25F,$F260,
$F261,$F262,$F263,$F264,$F265,$F266,$F267,$F268,$F269,$F26A,$F26B,$F26C,$F26D,
$F26E,$F26F,$F270,$F271,$F272,$F273,$F274,$F275,$F276,$F277,$F278,$F279,$F27A,
$F27B,$F27C,$F27D,$F27E,$F280,$F281,$F282,$F283,$F284,$F285,$F286,$F287,$F288,
$F289,$F28A,$F28B,$F28C,$F28D,$F28E,$F28F,$F290,$F291,$F292,$F293,$F294,$F295,
$F296,$F297,$F298,$F299,$F29A,$F29B,$F29C,$F29D,$F29E,$F29F,$F2A0,$F2A1,$F2A2,
$F2A3,$F2A4,$F2A5,$F2A6,$F2A7,$F2A8,$F2A9,$F2AA,$F2AB,$F2AC,$F2AD,$F2AE,$F2AF,
$F2B0,$F2B1,$F2B2,$F2B3,$F2B4,$F2B5,$F2B6,$F2B7,$F2B8,$F2B9,$F2BA,$F2BB,$F2BC,
$F2BD,$F2BE,$F2BF,$F2C0,$F2C1,$F2C2,$F2C3,$F2C4,$F2C5,$F2C6,$F2C7,$F2C8,$F2C9,
$F2CA,$F2CB,$F2CC,$F2CD,$F2CE,$F2CF,$F2D0,$F2D1,$F2D2,$F2D3,$F2D4,$F2D5,$F2D6,
$F2D7,$F2D8,$F2D9,$F2DA,$F2DB,$F2DC,$F2DD,$F2DE,$F2DF,$F2E0,$F2E1,$F2E2,$F2E3,
$F2E4,$F2E5,$F2E6,$F2E7,$F2E8,$F2E9,$F2EA,$F2EB,$F2EC,$F2ED,$F2EE,$F2EF,$F2F0,
$F2F1,$F2F2,$F2F3,$F2F4,$F2F5,$F2F6,$F2F7,$F2F8,$F2F9,$F2FA,$F2FB,$F2FC,$F2FD,
$F2FE,$F340,$F341,$F342,$F343,$F344,$F345,$F346,$F347,$F348,$F349,$F34A,$F34B,
$F34C,$F34D,$F34E,$F34F,$F350,$F351,$F352,$F353,$F354,$F355,$F356,$F357,$F358,
$F359,$F35A,$F35B,$F35C,$F35D,$F35E,$F35F,$F360,$F361,$F362,$F363,$F364,$F365,
$F366,$F367,$F368,$F369,$F36A,$F36B,$F36C,$F36D,$F36E,$F36F,$F370,$F371,$F372,
$F373,$F374,$F375,$F376,$F377,$F378,$F379,$F37A,$F37B,$F37C,$F37D,$F37E,$F380,
$F381,$F382,$F383,$F384,$F385,$F386,$F387,$F388,$F389,$F38A,$F38B,$F38C,$F38D,
$F38E,$F38F,$F390,$F391,$F392,$F393,$F394,$F395,$F396,$F397,$F398,$F399,$F39A,
$F39B,$F39C,$F39D,$F39E,$F39F,$F3A0,$F3A1,$F3A2,$F3A3,$F3A4,$F3A5,$F3A6,$F3A7,
$F3A8,$F3A9,$F3AA,$F3AB,$F3AC,$F3AD,$F3AE,$F3AF,$F3B0,$F3B1,$F3B2,$F3B3,$F3B4,
$F3B5,$F3B6,$F3B7,$F3B8,$F3B9,$F3BA,$F3BB,$F3BC,$F3BD,$F3BE,$F3BF,$F3C0,$F3C1,
$F3C2,$F3C3,$F3C4,$F3C5,$F3C6,$F3C7,$F3C8,$F3C9,$F3CA,$F3CB,$F3CC,$F3CD,$F3CE,
$F3CF,$F3D0,$F3D1,$F3D2,$F3D3,$F3D4,$F3D5,$F3D6,$F3D7,$F3D8,$F3D9,$F3DA,$F3DB,
$F3DC,$F3DD,$F3DE,$F3DF,$F3E0,$F3E1,$F3E2,$F3E3,$F3E4,$F3E5,$F3E6,$F3E7,$F3E8,
$F3E9,$F3EA,$F3EB,$F3EC,$F3ED,$F3EE,$F3EF,$F3F0,$F3F1,$F3F2,$F3F3,$F3F4,$F3F5,
$F3F6,$F3F7,$F3F8,$F3F9,$F3FA,$F3FB,$F3FC,$F3FD,$F3FE,$F440,$F441,$F442,$F443,
$F444,$F445,$F446,$F447,$F448,$F449,$F44A,$F44B,$F44C,$F44D,$F44E,$F44F,$F450,
$F451,$F452,$F453,$F454,$F455,$F456,$F457,$F458,$F459,$F45A,$F45B,$F45C,$F45D,
$F45E,$F45F,$F460,$F461,$F462,$F463,$F464,$F465,$F466,$F467,$F468,$F469,$F46A,
$F46B,$F46C,$F46D,$F46E,$F46F,$F470,$F471,$F472,$F473,$F474,$F475,$F476,$F477,
$F478,$F479,$F47A,$F47B,$F47C,$F47D,$F47E,$F480,$F481,$F482,$F483,$F484,$F485,
$F486,$F487,$F488,$F489,$F48A,$F48B,$F48C,$F48D,$F48E,$F48F,$F490,$F491,$F492,
$F493,$F494,$F495,$F496,$F497,$F498,$F499,$F49A,$F49B,$F49C,$F49D,$F49E,$F49F,
$F4A0,$F4A1,$F4A2,$F4A3,$F4A4,$F4A5,$F4A6,$F4A7,$F4A8,$F4A9,$F4AA,$F4AB,$F4AC,
$F4AD,$F4AE,$F4AF,$F4B0,$F4B1,$F4B2,$F4B3,$F4B4,$F4B5,$F4B6,$F4B7,$F4B8,$F4B9,
$F4BA,$F4BB,$F4BC,$F4BD,$F4BE,$F4BF,$F4C0,$F4C1,$F4C2,$F4C3,$F4C4,$F4C5,$F4C6,
$F4C7,$F4C8,$F4C9,$F4CA,$F4CB,$F4CC,$F4CD,$F4CE,$F4CF,$F4D0,$F4D1,$F4D2,$F4D3,
$F4D4,$F4D5,$F4D6,$F4D7,$F4D8,$F4D9,$F4DA,$F4DB,$F4DC,$F4DD,$F4DE,$F4DF,$F4E0,
$F4E1,$F4E2,$F4E3,$F4E4,$F4E5,$F4E6,$F4E7,$F4E8,$F4E9,$F4EA,$F4EB,$F4EC,$F4ED,
$F4EE,$F4EF,$F4F0,$F4F1,$F4F2,$F4F3,$F4F4,$F4F5,$F4F6,$F4F7,$F4F8,$F4F9,$F4FA,
$F4FB,$F4FC,$F4FD,$F4FE,$F540,$F541,$F542,$F543,$F544,$F545,$F546,$F547,$F548,
$F549,$F54A,$F54B,$F54C,$F54D,$F54E,$F54F,$F550,$F551,$F552,$F553,$F554,$F555,
$F556,$F557,$F558,$F559,$F55A,$F55B,$F55C,$F55D,$F55E,$F55F,$F560,$F561,$F562,
$F563,$F564,$F565,$F566,$F567,$F568,$F569,$F56A,$F56B,$F56C,$F56D,$F56E,$F56F,
$F570,$F571,$F572,$F573,$F574,$F575,$F576,$F577,$F578,$F579,$F57A,$F57B,$F57C,
$F57D,$F57E,$F580,$F581,$F582,$F583,$F584,$F585,$F586,$F587,$F588,$F589,$F58A,
$F58B,$F58C,$F58D,$F58E,$F58F,$F590,$F591,$F592,$F593,$F594,$F595,$F596,$F597,
$F598,$F599,$F59A,$F59B,$F59C,$F59D,$F59E,$F59F,$F5A0,$F5A1,$F5A2,$F5A3,$F5A4,
$F5A5,$F5A6,$F5A7,$F5A8,$F5A9,$F5AA,$F5AB,$F5AC,$F5AD,$F5AE,$F5AF,$F5B0,$F5B1,
$F5B2,$F5B3,$F5B4,$F5B5,$F5B6,$F5B7,$F5B8,$F5B9,$F5BA,$F5BB,$F5BC,$F5BD,$F5BE,
$F5BF,$F5C0,$F5C1,$F5C2,$F5C3,$F5C4,$F5C5,$F5C6,$F5C7,$F5C8,$F5C9,$F5CA,$F5CB,
$F5CC,$F5CD,$F5CE,$F5CF,$F5D0,$F5D1,$F5D2,$F5D3,$F5D4,$F5D5,$F5D6,$F5D7,$F5D8,
$F5D9,$F5DA,$F5DB,$F5DC,$F5DD,$F5DE,$F5DF,$F5E0,$F5E1,$F5E2,$F5E3,$F5E4,$F5E5,
$F5E6,$F5E7,$F5E8,$F5E9,$F5EA,$F5EB,$F5EC,$F5ED,$F5EE,$F5EF,$F5F0,$F5F1,$F5F2,
$F5F3,$F5F4,$F5F5,$F5F6,$F5F7,$F5F8,$F5F9,$F5FA,$F5FB,$F5FC,$F5FD,$F5FE,$F640,
$F641,$F642,$F643,$F644,$F645,$F646,$F647,$F648,$F649,$F64A,$F64B,$F64C,$F64D,
$F64E,$F64F,$F650,$F651,$F652,$F653,$F654,$F655,$F656,$F657,$F658,$F659,$F65A,
$F65B,$F65C,$F65D,$F65E,$F65F,$F660,$F661,$F662,$F663,$F664,$F665,$F666,$F667,
$F668,$F669,$F66A,$F66B,$F66C,$F66D,$F66E,$F66F,$F670,$F671,$F672,$F673,$F674,
$F675,$F676,$F677,$F678,$F679,$F67A,$F67B,$F67C,$F67D,$F67E,$F680,$F681,$F682,
$F683,$F684,$F685,$F686,$F687,$F688,$F689,$F68A,$F68B,$F68C,$F68D,$F68E,$F68F,
$F690,$F691,$F692,$F693,$F694,$F695,$F696,$F697,$F698,$F699,$F69A,$F69B,$F69C,
$F69D,$F69E,$F69F,$F6A0,$F6A1,$F6A2,$F6A3,$F6A4,$F6A5,$F6A6,$F6A7,$F6A8,$F6A9,
$F6AA,$F6AB,$F6AC,$F6AD,$F6AE,$F6AF,$F6B0,$F6B1,$F6B2,$F6B3,$F6B4,$F6B5,$F6B6,
$F6B7,$F6B8,$F6B9,$F6BA,$F6BB,$F6BC,$F6BD,$F6BE,$F6BF,$F6C0,$F6C1,$F6C2,$F6C3,
$F6C4,$F6C5,$F6C6,$F6C7,$F6C8,$F6C9,$F6CA,$F6CB,$F6CC,$F6CD,$F6CE,$F6CF,$F6D0,
$F6D1,$F6D2,$F6D3,$F6D4,$F6D5,$F6D6,$F6D7,$F6D8,$F6D9,$F6DA,$F6DB,$F6DC,$F6DD,
$F6DE,$F6DF,$F6E0,$F6E1,$F6E2,$F6E3,$F6E4,$F6E5,$F6E6,$F6E7,$F6E8,$F6E9,$F6EA,
$F6EB,$F6EC,$F6ED,$F6EE,$F6EF,$F6F0,$F6F1,$F6F2,$F6F3,$F6F4,$F6F5,$F6F6,$F6F7,
$F6F8,$F6F9,$F6FA,$F6FB,$F6FC,$F6FD,$F6FE,$F740,$F741,$F742,$F743,$F744,$F745,
$F746,$F747,$F748,$F749,$F74A,$F74B,$F74C,$F74D,$F74E,$F74F,$F750,$F751,$F752,
$F753,$F754,$F755,$F756,$F757,$F758,$F759,$F75A,$F75B,$F75C,$F75D,$F75E,$F75F,
$F760,$F761,$F762,$F763,$F764,$F765,$F766,$F767,$F768,$F769,$F76A,$F76B,$F76C,
$F76D,$F76E,$F76F,$F770,$F771,$F772,$F773,$F774,$F775,$F776,$F777,$F778,$F779,
$F77A,$F77B,$F77C,$F77D,$F77E,$F780,$F781,$F782,$F783,$F784,$F785,$F786,$F787,
$F788,$F789,$F78A,$F78B,$F78C,$F78D,$F78E,$F78F,$F790,$F791,$F792,$F793,$F794,
$F795,$F796,$F797,$F798,$F799,$F79A,$F79B,$F79C,$F79D,$F79E,$F79F,$F7A0,$F7A1,
$F7A2,$F7A3,$F7A4,$F7A5,$F7A6,$F7A7,$F7A8,$F7A9,$F7AA,$F7AB,$F7AC,$F7AD,$F7AE,
$F7AF,$F7B0,$F7B1,$F7B2,$F7B3,$F7B4,$F7B5,$F7B6,$F7B7,$F7B8,$F7B9,$F7BA,$F7BB,
$F7BC,$F7BD,$F7BE,$F7BF,$F7C0,$F7C1,$F7C2,$F7C3,$F7C4,$F7C5,$F7C6,$F7C7,$F7C8,
$F7C9,$F7CA,$F7CB,$F7CC,$F7CD,$F7CE,$F7CF,$F7D0,$F7D1,$F7D2,$F7D3,$F7D4,$F7D5,
$F7D6,$F7D7,$F7D8,$F7D9,$F7DA,$F7DB,$F7DC,$F7DD,$F7DE,$F7DF,$F7E0,$F7E1,$F7E2,
$F7E3,$F7E4,$F7E5,$F7E6,$F7E7,$F7E8,$F7E9,$F7EA,$F7EB,$F7EC,$F7ED,$F7EE,$F7EF,
$F7F0,$F7F1,$F7F2,$F7F3,$F7F4,$F7F5,$F7F6,$F7F7,$F7F8,$F7F9,$F7FA,$F7FB,$F7FC,
$F7FD,$F7FE,$F840,$F841,$F842,$F843,$F844,$F845,$F846,$F847,$F848,$F849,$F84A,
$F84B,$F84C,$F84D,$F84E,$F84F,$F850,$F851,$F852,$F853,$F854,$F855,$F856,$F857,
$F858,$F859,$F85A,$F85B,$F85C,$F85D,$F85E,$F85F,$F860,$F861,$F862,$F863,$F864,
$F865,$F866,$F867,$F868,$F869,$F86A,$F86B,$F86C,$F86D,$F86E,$F86F,$F870,$F871,
$F872,$F873,$F874,$F875,$F876,$F877,$F878,$F879,$F87A,$F87B,$F87C,$F87D,$F87E,
$F880,$F881,$F882,$F883,$F884,$F885,$F886,$F887,$F888,$F889,$F88A,$F88B,$F88C,
$F88D,$F88E,$F88F,$F890,$F891,$F892,$F893,$F894,$F895,$F896,$F897,$F898,$F899,
$F89A,$F89B,$F89C,$F89D,$F89E,$F89F,$F8A0,$F940,$F941,$F942,$F943,$F944,$F945,
$F946,$F947,$F948,$F949,$F94A,$F94B,$F94C,$F94D,$F94E,$F94F,$F950,$F951,$F952,
$F953,$F954,$F955,$F956,$F957,$F958,$F959,$F95A,$F95B,$F95C,$F95D,$F95E,$F95F,
$F960,$F961,$F962,$F963,$F964,$F965,$F966,$F967,$F968,$F969,$F96A,$F96B,$F96C,
$F96D,$F96E,$F96F,$F970,$F971,$F972,$F973,$F974,$F975,$F976,$F977,$F978,$F979,
$F97A,$F97B,$F97C,$F97D,$F97E,$F980,$F981,$F982,$F983,$F984,$F985,$F986,$F987,
$F988,$F989,$F98A,$F98B,$F98C,$F98D,$F98E,$F98F,$F990,$F991,$F992,$F993,$F994,
$F995,$F996,$F997,$F998,$F999,$F99A,$F99B,$F99C,$F99D,$F99E,$F99F,$F9A0,$FA40,
$FA41,$FA42,$FA43,$FA44,$FA45,$FA46,$FA47,$FA48,$FA49,$FA4A,$FA4B,$FA4C,$FA4D,
$FA4E,$FA4F,$FA50,$FA51,$FA52,$FA53,$FA54,$FA55,$FA56,$FA57,$FA58,$FA59,$FA5A,
$FA5B,$FA5C,$FA5D,$FA5E,$FA5F,$FA60,$FA61,$FA62,$FA63,$FA64,$FA65,$FA66,$FA67,
$FA68,$FA69,$FA6A,$FA6B,$FA6C,$FA6D,$FA6E,$FA6F,$FA70,$FA71,$FA72,$FA73,$FA74,
$FA75,$FA76,$FA77,$FA78,$FA79,$FA7A,$FA7B,$FA7C,$FA7D,$FA7E,$FA80,$FA81,$FA82,
$FA83,$FA84,$FA85,$FA86,$FA87,$FA88,$FA89,$FA8A,$FA8B,$FA8C,$FA8D,$FA8E,$FA8F,
$FA90,$FA91,$FA92,$FA93,$FA94,$FA95,$FA96,$FA97,$FA98,$FA99,$FA9A,$FA9B,$FA9C,
$FA9D,$FA9E,$FA9F,$FAA0,$FB40,$FB41,$FB42,$FB43,$FB44,$FB45,$FB46,$FB47,$FB48,
$FB49,$FB4A,$FB4B,$FB4C,$FB4D,$FB4E,$FB4F,$FB50,$FB51,$FB52,$FB53,$FB54,$FB55,
$FB56,$FB57,$FB58,$FB59,$FB5A,$FB5B,$FB5C,$FB5D,$FB5E,$FB5F,$FB60,$FB61,$FB62,
$FB63,$FB64,$FB65,$FB66,$FB67,$FB68,$FB69,$FB6A,$FB6B,$FB6C,$FB6D,$FB6E,$FB6F,
$FB70,$FB71,$FB72,$FB73,$FB74,$FB75,$FB76,$FB77,$FB78,$FB79,$FB7A,$FB7B,$FB7C,
$FB7D,$FB7E,$FB80,$FB81,$FB82,$FB83,$FB84,$FB85,$FB86,$FB87,$FB88,$FB89,$FB8A,
$FB8B,$FB8C,$FB8D,$FB8E,$FB8F,$FB90,$FB91,$FB92,$FB93,$FB94,$FB95,$FB96,$FB97,
$FB98,$FB99,$FB9A,$FB9B,$FB9C,$FB9D,$FB9E,$FB9F,$FBA0,$FC40,$FC41,$FC42,$FC43,
$FC44,$FC45,$FC46,$FC47,$FC48,$FC49,$FC4A,$FC4B,$FC4C,$FC4D,$FC4E,$FC4F,$FC50,
$FC51,$FC52,$FC53,$FC54,$FC55,$FC56,$FC57,$FC58,$FC59,$FC5A,$FC5B,$FC5C,$FC5D,
$FC5E,$FC5F,$FC60,$FC61,$FC62,$FC63,$FC64,$FC65,$FC66,$FC67,$FC68,$FC69,$FC6A,
$FC6B,$FC6C,$FC6D,$FC6E,$FC6F,$FC70,$FC71,$FC72,$FC73,$FC74,$FC75,$FC76,$FC77,
$FC78,$FC79,$FC7A,$FC7B,$FC7C,$FC7D,$FC7E,$FC80,$FC81,$FC82,$FC83,$FC84,$FC85,
$FC86,$FC87,$FC88,$FC89,$FC8A,$FC8B,$FC8C,$FC8D,$FC8E,$FC8F,$FC90,$FC91,$FC92,
$FC93,$FC94,$FC95,$FC96,$FC97,$FC98,$FC99,$FC9A,$FC9B,$FC9C,$FC9D,$FC9E,$FC9F,
$FCA0,$FD40,$FD41,$FD42,$FD43,$FD44,$FD45,$FD46,$FD47,$FD48,$FD49,$FD4A,$FD4B,
$FD4C,$FD4D,$FD4E,$FD4F,$FD50,$FD51,$FD52,$FD53,$FD54,$FD55,$FD56,$FD57,$FD58,
$FD59,$FD5A,$FD5B,$FD5C,$FD5D,$FD5E,$FD5F,$FD60,$FD61,$FD62,$FD63,$FD64,$FD65,
$FD66,$FD67,$FD68,$FD69,$FD6A,$FD6B,$FD6C,$FD6D,$FD6E,$FD6F,$FD70,$FD71,$FD72,
$FD73,$FD74,$FD75,$FD76,$FD77,$FD78,$FD79,$FD7A,$FD7B,$FD7C,$FD7D,$FD7E,$FD80,
$FD81,$FD82,$FD83,$FD84,$FD85,$FD86,$FD87,$FD88,$FD89,$FD8A,$FD8B,$FD8C,$FD8D,
$FD8E,$FD8F,$FD90,$FD91,$FD92,$FD93,$FD94,$FD95,$FD96,$FD97,$FD98,$FD99,$FD9A,
$FD9B,$FD9C,$FD9D,$FD9E,$FD9F,$FDA0,$FE40,$FE41,$FE42,$FE43,$FE44,$FE45,$FE46,
$FE47,$FE48,$FE49,$FE4A,$FE4B,$FE4C,$FE4D,$FE4E,$FE4F);

const Uni936C: CP936Arr =
($0000,$0001,$0002,$0003,$0004,$0005,$0006,$0007,$0008,$0009,$000A,$000B,$000C,
$000D,$000E,$000F,$0010,$0011,$0012,$0013,$0014,$0015,$0016,$0017,$0018,$0019,
$001A,$001B,$001C,$001D,$001E,$001F,$0020,$0021,$0022,$0023,$0024,$0025,$0026,
$0027,$0028,$0029,$002A,$002B,$002C,$002D,$002E,$002F,$0030,$0031,$0032,$0033,
$0034,$0035,$0036,$0037,$0038,$0039,$003A,$003B,$003C,$003D,$003E,$003F,$0040,
$0041,$0042,$0043,$0044,$0045,$0046,$0047,$0048,$0049,$004A,$004B,$004C,$004D,
$004E,$004F,$0050,$0051,$0052,$0053,$0054,$0055,$0056,$0057,$0058,$0059,$005A,
$005B,$005C,$005D,$005E,$005F,$0060,$0061,$0062,$0063,$0064,$0065,$0066,$0067,
$0068,$0069,$006A,$006B,$006C,$006D,$006E,$006F,$0070,$0071,$0072,$0073,$0074,
$0075,$0076,$0077,$0078,$0079,$007A,$007B,$007C,$007D,$007E,$007F,$20AC,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,$4E02,$4E04,$4E05,$4E06,$4E0F,$4E12,$4E17,$4E1F,$4E20,$4E21,$4E23,$4E26,
$4E29,$4E2E,$4E2F,$4E31,$4E33,$4E35,$4E37,$4E3C,$4E40,$4E41,$4E42,$4E44,$4E46,
$4E4A,$4E51,$4E55,$4E57,$4E5A,$4E5B,$4E62,$4E63,$4E64,$4E65,$4E67,$4E68,$4E6A,
$4E6B,$4E6C,$4E6D,$4E6E,$4E6F,$4E72,$4E74,$4E75,$4E76,$4E77,$4E78,$4E79,$4E7A,
$4E7B,$4E7C,$4E7D,$4E7F,$4E80,$4E81,$4E82,$4E83,$4E84,$4E85,$4E87,$4E8A,$4E90,
$4E96,$4E97,$4E99,$4E9C,$4E9D,$4E9E,$4EA3,$4EAA,$4EAF,$4EB0,$4EB1,$4EB4,$4EB6,
$4EB7,$4EB8,$4EB9,$4EBC,$4EBD,$4EBE,$4EC8,$4ECC,$4ECF,$4ED0,$4ED2,$4EDA,$4EDB,
$4EDC,$4EE0,$4EE2,$4EE6,$4EE7,$4EE9,$4EED,$4EEE,$4EEF,$4EF1,$4EF4,$4EF8,$4EF9,
$4EFA,$4EFC,$4EFE,$4F00,$4F02,$4F03,$4F04,$4F05,$4F06,$4F07,$4F08,$4F0B,$4F0C,
$4F12,$4F13,$4F14,$4F15,$4F16,$4F1C,$4F1D,$4F21,$4F23,$4F28,$4F29,$4F2C,$4F2D,
$4F2E,$4F31,$4F33,$4F35,$4F37,$4F39,$4F3B,$4F3E,$4F3F,$4F40,$4F41,$4F42,$4F44,
$4F45,$4F47,$4F48,$4F49,$4F4A,$4F4B,$4F4C,$4F52,$4F54,$4F56,$4F61,$4F62,$4F66,
$4F68,$4F6A,$4F6B,$4F6D,$4F6E,$4F71,$4F72,$4F75,$4F77,$4F78,$4F79,$4F7A,$4F7D,
$4F80,$4F81,$4F82,$4F85,$4F86,$4F87,$4F8A,$4F8C,$4F8E,$4F90,$4F92,$4F93,$4F95,
$4F96,$4F98,$4F99,$4F9A,$4F9C,$4F9E,$4F9F,$4FA1,$4FA2,$4FA4,$4FAB,$4FAD,$4FB0,
$4FB1,$4FB2,$4FB3,$4FB4,$4FB6,$4FB7,$4FB8,$4FB9,$4FBA,$4FBB,$4FBC,$4FBD,$4FBE,
$4FC0,$4FC1,$4FC2,$4FC6,$4FC7,$4FC8,$4FC9,$4FCB,$4FCC,$4FCD,$4FD2,$4FD3,$4FD4,
$4FD5,$4FD6,$4FD9,$4FDB,$4FE0,$4FE2,$4FE4,$4FE5,$4FE7,$4FEB,$4FEC,$4FF0,$4FF2,
$4FF4,$4FF5,$4FF6,$4FF7,$4FF9,$4FFB,$4FFC,$4FFD,$4FFF,$5000,$5001,$5002,$5003,
$5004,$5005,$5006,$5007,$5008,$5009,$500A,$500B,$500E,$5010,$5011,$5013,$5015,
$5016,$5017,$501B,$501D,$501E,$5020,$5022,$5023,$5024,$5027,$502B,$502F,$5030,
$5031,$5032,$5033,$5034,$5035,$5036,$5037,$5038,$5039,$503B,$503D,$503F,$5040,
$5041,$5042,$5044,$5045,$5046,$5049,$504A,$504B,$504D,$5050,$5051,$5052,$5053,
$5054,$5056,$5057,$5058,$5059,$505B,$505D,$505E,$505F,$5060,$5061,$5062,$5063,
$5064,$5066,$5067,$5068,$5069,$506A,$506B,$506D,$506E,$506F,$5070,$5071,$5072,
$5073,$5074,$5075,$5078,$5079,$507A,$507C,$507D,$5081,$5082,$5083,$5084,$5086,
$5087,$5089,$508A,$508B,$508C,$508E,$508F,$5090,$5091,$5092,$5093,$5094,$5095,
$5096,$5097,$5098,$5099,$509A,$509B,$509C,$509D,$509E,$509F,$50A0,$50A1,$50A2,
$50A4,$50A6,$50AA,$50AB,$50AD,$50AE,$50AF,$50B0,$50B1,$50B3,$50B4,$50B5,$50B6,
$50B7,$50B8,$50B9,$50BC,$50BD,$50BE,$50BF,$50C0,$50C1,$50C2,$50C3,$50C4,$50C5,
$50C6,$50C7,$50C8,$50C9,$50CA,$50CB,$50CC,$50CD,$50CE,$50D0,$50D1,$50D2,$50D3,
$50D4,$50D5,$50D7,$50D8,$50D9,$50DB,$50DC,$50DD,$50DE,$50DF,$50E0,$50E1,$50E2,
$50E3,$50E4,$50E5,$50E8,$50E9,$50EA,$50EB,$50EF,$50F0,$50F1,$50F2,$50F4,$50F6,
$50F7,$50F8,$50F9,$50FA,$50FC,$50FD,$50FE,$50FF,$5100,$5101,$5102,$5103,$5104,
$5105,$5108,$5109,$510A,$510C,$510D,$510E,$510F,$5110,$5111,$5113,$5114,$5115,
$5116,$5117,$5118,$5119,$511A,$511B,$511C,$511D,$511E,$511F,$5120,$5122,$5123,
$5124,$5125,$5126,$5127,$5128,$5129,$512A,$512B,$512C,$512D,$512E,$512F,$5130,
$5131,$5132,$5133,$5134,$5135,$5136,$5137,$5138,$5139,$513A,$513B,$513C,$513D,
$513E,$5142,$5147,$514A,$514C,$514E,$514F,$5150,$5152,$5153,$5157,$5158,$5159,
$515B,$515D,$515E,$515F,$5160,$5161,$5163,$5164,$5166,$5167,$5169,$516A,$516F,
$5172,$517A,$517E,$517F,$5183,$5184,$5186,$5187,$518A,$518B,$518E,$518F,$5190,
$5191,$5193,$5194,$5198,$519A,$519D,$519E,$519F,$51A1,$51A3,$51A6,$51A7,$51A8,
$51A9,$51AA,$51AD,$51AE,$51B4,$51B8,$51B9,$51BA,$51BE,$51BF,$51C1,$51C2,$51C3,
$51C5,$51C8,$51CA,$51CD,$51CE,$51D0,$51D2,$51D3,$51D4,$51D5,$51D6,$51D7,$51D8,
$51D9,$51DA,$51DC,$51DE,$51DF,$51E2,$51E3,$51E5,$51E6,$51E7,$51E8,$51E9,$51EA,
$51EC,$51EE,$51F1,$51F2,$51F4,$51F7,$51FE,$5204,$5205,$5209,$520B,$520C,$520F,
$5210,$5213,$5214,$5215,$521C,$521E,$521F,$5221,$5222,$5223,$5225,$5226,$5227,
$522A,$522C,$522F,$5231,$5232,$5234,$5235,$523C,$523E,$5244,$5245,$5246,$5247,
$5248,$5249,$524B,$524E,$524F,$5252,$5253,$5255,$5257,$5258,$5259,$525A,$525B,
$525D,$525F,$5260,$5262,$5263,$5264,$5266,$5268,$526B,$526C,$526D,$526E,$5270,
$5271,$5273,$5274,$5275,$5276,$5277,$5278,$5279,$527A,$527B,$527C,$527E,$5280,
$5283,$5284,$5285,$5286,$5287,$5289,$528A,$528B,$528C,$528D,$528E,$528F,$5291,
$5292,$5294,$5295,$5296,$5297,$5298,$5299,$529A,$529C,$52A4,$52A5,$52A6,$52A7,
$52AE,$52AF,$52B0,$52B4,$52B5,$52B6,$52B7,$52B8,$52B9,$52BA,$52BB,$52BC,$52BD,
$52C0,$52C1,$52C2,$52C4,$52C5,$52C6,$52C8,$52CA,$52CC,$52CD,$52CE,$52CF,$52D1,
$52D3,$52D4,$52D5,$52D7,$52D9,$52DA,$52DB,$52DC,$52DD,$52DE,$52E0,$52E1,$52E2,
$52E3,$52E5,$52E6,$52E7,$52E8,$52E9,$52EA,$52EB,$52EC,$52ED,$52EE,$52EF,$52F1,
$52F2,$52F3,$52F4,$52F5,$52F6,$52F7,$52F8,$52FB,$52FC,$52FD,$5301,$5302,$5303,
$5304,$5307,$5309,$530A,$530B,$530C,$530E,$5311,$5312,$5313,$5314,$5318,$531B,
$531C,$531E,$531F,$5322,$5324,$5325,$5327,$5328,$5329,$532B,$532C,$532D,$532F,
$5330,$5331,$5332,$5333,$5334,$5335,$5336,$5337,$5338,$533C,$533D,$5340,$5342,
$5344,$5346,$534B,$534C,$534D,$5350,$5354,$5358,$5359,$535B,$535D,$5365,$5368,
$536A,$536C,$536D,$5372,$5376,$5379,$537B,$537C,$537D,$537E,$5380,$5381,$5383,
$5387,$5388,$538A,$538E,$538F,$5390,$5391,$5392,$5393,$5394,$5396,$5397,$5399,
$539B,$539C,$539E,$53A0,$53A1,$53A4,$53A7,$53AA,$53AB,$53AC,$53AD,$53AF,$53B0,
$53B1,$53B2,$53B3,$53B4,$53B5,$53B7,$53B8,$53B9,$53BA,$53BC,$53BD,$53BE,$53C0,
$53C3,$53C4,$53C5,$53C6,$53C7,$53CE,$53CF,$53D0,$53D2,$53D3,$53D5,$53DA,$53DC,
$53DD,$53DE,$53E1,$53E2,$53E7,$53F4,$53FA,$53FE,$53FF,$5400,$5402,$5405,$5407,
$540B,$5414,$5418,$5419,$541A,$541C,$5422,$5424,$5425,$542A,$5430,$5433,$5436,
$5437,$543A,$543D,$543F,$5441,$5442,$5444,$5445,$5447,$5449,$544C,$544D,$544E,
$544F,$5451,$545A,$545D,$545E,$545F,$5460,$5461,$5463,$5465,$5467,$5469,$546A,
$546B,$546C,$546D,$546E,$546F,$5470,$5474,$5479,$547A,$547E,$547F,$5481,$5483,
$5485,$5487,$5488,$5489,$548A,$548D,$5491,$5493,$5497,$5498,$549C,$549E,$549F,
$54A0,$54A1,$54A2,$54A5,$54AE,$54B0,$54B2,$54B5,$54B6,$54B7,$54B9,$54BA,$54BC,
$54BE,$54C3,$54C5,$54CA,$54CB,$54D6,$54D8,$54DB,$54E0,$54E1,$54E2,$54E3,$54E4,
$54EB,$54EC,$54EF,$54F0,$54F1,$54F4,$54F5,$54F6,$54F7,$54F8,$54F9,$54FB,$54FE,
$5500,$5502,$5503,$5504,$5505,$5508,$550A,$550B,$550C,$550D,$550E,$5512,$5513,
$5515,$5516,$5517,$5518,$5519,$551A,$551C,$551D,$551E,$551F,$5521,$5525,$5526,
$5528,$5529,$552B,$552D,$5532,$5534,$5535,$5536,$5538,$5539,$553A,$553B,$553D,
$5540,$5542,$5545,$5547,$5548,$554B,$554C,$554D,$554E,$554F,$5551,$5552,$5553,
$5554,$5557,$5558,$5559,$555A,$555B,$555D,$555E,$555F,$5560,$5562,$5563,$5568,
$5569,$556B,$556F,$5570,$5571,$5572,$5573,$5574,$5579,$557A,$557D,$557F,$5585,
$5586,$558C,$558D,$558E,$5590,$5592,$5593,$5595,$5596,$5597,$559A,$559B,$559E,
$55A0,$55A1,$55A2,$55A3,$55A4,$55A5,$55A6,$55A8,$55A9,$55AA,$55AB,$55AC,$55AD,
$55AE,$55AF,$55B0,$55B2,$55B4,$55B6,$55B8,$55BA,$55BC,$55BF,$55C0,$55C1,$55C2,
$55C3,$55C6,$55C7,$55C8,$55CA,$55CB,$55CE,$55CF,$55D0,$55D5,$55D7,$55D8,$55D9,
$55DA,$55DB,$55DE,$55E0,$55E2,$55E7,$55E9,$55ED,$55EE,$55F0,$55F1,$55F4,$55F6,
$55F8,$55F9,$55FA,$55FB,$55FC,$55FF,$5602,$5603,$5604,$5605,$5606,$5607,$560A,
$560B,$560D,$5610,$5611,$5612,$5613,$5614,$5615,$5616,$5617,$5619,$561A,$561C,
$561D,$5620,$5621,$5622,$5625,$5626,$5628,$5629,$562A,$562B,$562E,$562F,$5630,
$5633,$5635,$5637,$5638,$563A,$563C,$563D,$563E,$5640,$5641,$5642,$5643,$5644,
$5645,$5646,$5647,$5648,$5649,$564A,$564B,$564F,$5650,$5651,$5652,$5653,$5655,
$5656,$565A,$565B,$565D,$565E,$565F,$5660,$5661,$5663,$5665,$5666,$5667,$566D,
$566E,$566F,$5670,$5672,$5673,$5674,$5675,$5677,$5678,$5679,$567A,$567D,$567E,
$567F,$5680,$5681,$5682,$5683,$5684,$5687,$5688,$5689,$568A,$568B,$568C,$568D,
$5690,$5691,$5692,$5694,$5695,$5696,$5697,$5698,$5699,$569A,$569B,$569C,$569D,
$569E,$569F,$56A0,$56A1,$56A2,$56A4,$56A5,$56A6,$56A7,$56A8,$56A9,$56AA,$56AB,
$56AC,$56AD,$56AE,$56B0,$56B1,$56B2,$56B3,$56B4,$56B5,$56B6,$56B8,$56B9,$56BA,
$56BB,$56BD,$56BE,$56BF,$56C0,$56C1,$56C2,$56C3,$56C4,$56C5,$56C6,$56C7,$56C8,
$56C9,$56CB,$56CC,$56CD,$56CE,$56CF,$56D0,$56D1,$56D2,$56D3,$56D5,$56D6,$56D8,
$56D9,$56DC,$56E3,$56E5,$56E6,$56E7,$56E8,$56E9,$56EA,$56EC,$56EE,$56EF,$56F2,
$56F3,$56F6,$56F7,$56F8,$56FB,$56FC,$5700,$5701,$5702,$5705,$5707,$570B,$570C,
$570D,$570E,$570F,$5710,$5711,$5712,$5713,$5714,$5715,$5716,$5717,$5718,$5719,
$571A,$571B,$571D,$571E,$5720,$5721,$5722,$5724,$5725,$5726,$5727,$572B,$5731,
$5732,$5734,$5735,$5736,$5737,$5738,$573C,$573D,$573F,$5741,$5743,$5744,$5745,
$5746,$5748,$5749,$574B,$5752,$5753,$5754,$5755,$5756,$5758,$5759,$5762,$5763,
$5765,$5767,$576C,$576E,$5770,$5771,$5772,$5774,$5775,$5778,$5779,$577A,$577D,
$577E,$577F,$5780,$5781,$5787,$5788,$5789,$578A,$578D,$578E,$578F,$5790,$5791,
$5794,$5795,$5796,$5797,$5798,$5799,$579A,$579C,$579D,$579E,$579F,$57A5,$57A8,
$57AA,$57AC,$57AF,$57B0,$57B1,$57B3,$57B5,$57B6,$57B7,$57B9,$57BA,$57BB,$57BC,
$57BD,$57BE,$57BF,$57C0,$57C1,$57C4,$57C5,$57C6,$57C7,$57C8,$57C9,$57CA,$57CC,
$57CD,$57D0,$57D1,$57D3,$57D6,$57D7,$57DB,$57DC,$57DE,$57E1,$57E2,$57E3,$57E5,
$57E6,$57E7,$57E8,$57E9,$57EA,$57EB,$57EC,$57EE,$57F0,$57F1,$57F2,$57F3,$57F5,
$57F6,$57F7,$57FB,$57FC,$57FE,$57FF,$5801,$5803,$5804,$5805,$5808,$5809,$580A,
$580C,$580E,$580F,$5810,$5812,$5813,$5814,$5816,$5817,$5818,$581A,$581B,$581C,
$581D,$581F,$5822,$5823,$5825,$5826,$5827,$5828,$5829,$582B,$582C,$582D,$582E,
$582F,$5831,$5832,$5833,$5834,$5836,$5837,$5838,$5839,$583A,$583B,$583C,$583D,
$583E,$583F,$5840,$5841,$5842,$5843,$5845,$5846,$5847,$5848,$5849,$584A,$584B,
$584E,$584F,$5850,$5852,$5853,$5855,$5856,$5857,$5859,$585A,$585B,$585C,$585D,
$585F,$5860,$5861,$5862,$5863,$5864,$5866,$5867,$5868,$5869,$586A,$586D,$586E,
$586F,$5870,$5871,$5872,$5873,$5874,$5875,$5876,$5877,$5878,$5879,$587A,$587B,
$587C,$587D,$587F,$5882,$5884,$5886,$5887,$5888,$588A,$588B,$588C,$588D,$588E,
$588F,$5890,$5891,$5894,$5895,$5896,$5897,$5898,$589B,$589C,$589D,$58A0,$58A1,
$58A2,$58A3,$58A4,$58A5,$58A6,$58A7,$58AA,$58AB,$58AC,$58AD,$58AE,$58AF,$58B0,
$58B1,$58B2,$58B3,$58B4,$58B5,$58B6,$58B7,$58B8,$58B9,$58BA,$58BB,$58BD,$58BE,
$58BF,$58C0,$58C2,$58C3,$58C4,$58C6,$58C7,$58C8,$58C9,$58CA,$58CB,$58CC,$58CD,
$58CE,$58CF,$58D0,$58D2,$58D3,$58D4,$58D6,$58D7,$58D8,$58D9,$58DA,$58DB,$58DC,
$58DD,$58DE,$58DF,$58E0,$58E1,$58E2,$58E3,$58E5,$58E6,$58E7,$58E8,$58E9,$58EA,
$58ED,$58EF,$58F1,$58F2,$58F4,$58F5,$58F7,$58F8,$58FA,$58FB,$58FC,$58FD,$58FE,
$58FF,$5900,$5901,$5903,$5905,$5906,$5908,$5909,$590A,$590B,$590C,$590E,$5910,
$5911,$5912,$5913,$5917,$5918,$591B,$591D,$591E,$5920,$5921,$5922,$5923,$5926,
$5928,$592C,$5930,$5932,$5933,$5935,$5936,$593B,$593D,$593E,$593F,$5940,$5943,
$5945,$5946,$594A,$594C,$594D,$5950,$5952,$5953,$5959,$595B,$595C,$595D,$595E,
$595F,$5961,$5963,$5964,$5966,$5967,$5968,$5969,$596A,$596B,$596C,$596D,$596E,
$596F,$5970,$5971,$5972,$5975,$5977,$597A,$597B,$597C,$597E,$597F,$5980,$5985,
$5989,$598B,$598C,$598E,$598F,$5990,$5991,$5994,$5995,$5998,$599A,$599B,$599C,
$599D,$599F,$59A0,$59A1,$59A2,$59A6,$59A7,$59AC,$59AD,$59B0,$59B1,$59B3,$59B4,
$59B5,$59B6,$59B7,$59B8,$59BA,$59BC,$59BD,$59BF,$59C0,$59C1,$59C2,$59C3,$59C4,
$59C5,$59C7,$59C8,$59C9,$59CC,$59CD,$59CE,$59CF,$59D5,$59D6,$59D9,$59DB,$59DE,
$59DF,$59E0,$59E1,$59E2,$59E4,$59E6,$59E7,$59E9,$59EA,$59EB,$59ED,$59EE,$59EF,
$59F0,$59F1,$59F2,$59F3,$59F4,$59F5,$59F6,$59F7,$59F8,$59FA,$59FC,$59FD,$59FE,
$5A00,$5A02,$5A0A,$5A0B,$5A0D,$5A0E,$5A0F,$5A10,$5A12,$5A14,$5A15,$5A16,$5A17,
$5A19,$5A1A,$5A1B,$5A1D,$5A1E,$5A21,$5A22,$5A24,$5A26,$5A27,$5A28,$5A2A,$5A2B,
$5A2C,$5A2D,$5A2E,$5A2F,$5A30,$5A33,$5A35,$5A37,$5A38,$5A39,$5A3A,$5A3B,$5A3D,
$5A3E,$5A3F,$5A41,$5A42,$5A43,$5A44,$5A45,$5A47,$5A48,$5A4B,$5A4C,$5A4D,$5A4E,
$5A4F,$5A50,$5A51,$5A52,$5A53,$5A54,$5A56,$5A57,$5A58,$5A59,$5A5B,$5A5C,$5A5D,
$5A5E,$5A5F,$5A60,$5A61,$5A63,$5A64,$5A65,$5A66,$5A68,$5A69,$5A6B,$5A6C,$5A6D,
$5A6E,$5A6F,$5A70,$5A71,$5A72,$5A73,$5A78,$5A79,$5A7B,$5A7C,$5A7D,$5A7E,$5A80,
$5A81,$5A82,$5A83,$5A84,$5A85,$5A86,$5A87,$5A88,$5A89,$5A8A,$5A8B,$5A8C,$5A8D,
$5A8E,$5A8F,$5A90,$5A91,$5A93,$5A94,$5A95,$5A96,$5A97,$5A98,$5A99,$5A9C,$5A9D,
$5A9E,$5A9F,$5AA0,$5AA1,$5AA2,$5AA3,$5AA4,$5AA5,$5AA6,$5AA7,$5AA8,$5AA9,$5AAB,
$5AAC,$5AAD,$5AAE,$5AAF,$5AB0,$5AB1,$5AB4,$5AB6,$5AB7,$5AB9,$5ABA,$5ABB,$5ABC,
$5ABD,$5ABF,$5AC0,$5AC3,$5AC4,$5AC5,$5AC6,$5AC7,$5AC8,$5ACA,$5ACB,$5ACD,$5ACE,
$5ACF,$5AD0,$5AD1,$5AD3,$5AD5,$5AD7,$5AD9,$5ADA,$5ADB,$5ADD,$5ADE,$5ADF,$5AE2,
$5AE4,$5AE5,$5AE7,$5AE8,$5AEA,$5AEC,$5AED,$5AEE,$5AEF,$5AF0,$5AF2,$5AF3,$5AF4,
$5AF5,$5AF6,$5AF7,$5AF8,$5AF9,$5AFA,$5AFB,$5AFC,$5AFD,$5AFE,$5AFF,$5B00,$5B01,
$5B02,$5B03,$5B04,$5B05,$5B06,$5B07,$5B08,$5B0A,$5B0B,$5B0C,$5B0D,$5B0E,$5B0F,
$5B10,$5B11,$5B12,$5B13,$5B14,$5B15,$5B18,$5B19,$5B1A,$5B1B,$5B1C,$5B1D,$5B1E,
$5B1F,$5B20,$5B21,$5B22,$5B23,$5B24,$5B25,$5B26,$5B27,$5B28,$5B29,$5B2A,$5B2B,
$5B2C,$5B2D,$5B2E,$5B2F,$5B30,$5B31,$5B33,$5B35,$5B36,$5B38,$5B39,$5B3A,$5B3B,
$5B3C,$5B3D,$5B3E,$5B3F,$5B41,$5B42,$5B43,$5B44,$5B45,$5B46,$5B47,$5B48,$5B49,
$5B4A,$5B4B,$5B4C,$5B4D,$5B4E,$5B4F,$5B52,$5B56,$5B5E,$5B60,$5B61,$5B67,$5B68,
$5B6B,$5B6D,$5B6E,$5B6F,$5B72,$5B74,$5B76,$5B77,$5B78,$5B79,$5B7B,$5B7C,$5B7E,
$5B7F,$5B82,$5B86,$5B8A,$5B8D,$5B8E,$5B90,$5B91,$5B92,$5B94,$5B96,$5B9F,$5BA7,
$5BA8,$5BA9,$5BAC,$5BAD,$5BAE,$5BAF,$5BB1,$5BB2,$5BB7,$5BBA,$5BBB,$5BBC,$5BC0,
$5BC1,$5BC3,$5BC8,$5BC9,$5BCA,$5BCB,$5BCD,$5BCE,$5BCF,$5BD1,$5BD4,$5BD5,$5BD6,
$5BD7,$5BD8,$5BD9,$5BDA,$5BDB,$5BDC,$5BE0,$5BE2,$5BE3,$5BE6,$5BE7,$5BE9,$5BEA,
$5BEB,$5BEC,$5BED,$5BEF,$5BF1,$5BF2,$5BF3,$5BF4,$5BF5,$5BF6,$5BF7,$5BFD,$5BFE,
$5C00,$5C02,$5C03,$5C05,$5C07,$5C08,$5C0B,$5C0C,$5C0D,$5C0E,$5C10,$5C12,$5C13,
$5C17,$5C19,$5C1B,$5C1E,$5C1F,$5C20,$5C21,$5C23,$5C26,$5C28,$5C29,$5C2A,$5C2B,
$5C2D,$5C2E,$5C2F,$5C30,$5C32,$5C33,$5C35,$5C36,$5C37,$5C43,$5C44,$5C46,$5C47,
$5C4C,$5C4D,$5C52,$5C53,$5C54,$5C56,$5C57,$5C58,$5C5A,$5C5B,$5C5C,$5C5D,$5C5F,
$5C62,$5C64,$5C67,$5C68,$5C69,$5C6A,$5C6B,$5C6C,$5C6D,$5C70,$5C72,$5C73,$5C74,
$5C75,$5C76,$5C77,$5C78,$5C7B,$5C7C,$5C7D,$5C7E,$5C80,$5C83,$5C84,$5C85,$5C86,
$5C87,$5C89,$5C8A,$5C8B,$5C8E,$5C8F,$5C92,$5C93,$5C95,$5C9D,$5C9E,$5C9F,$5CA0,
$5CA1,$5CA4,$5CA5,$5CA6,$5CA7,$5CA8,$5CAA,$5CAE,$5CAF,$5CB0,$5CB2,$5CB4,$5CB6,
$5CB9,$5CBA,$5CBB,$5CBC,$5CBE,$5CC0,$5CC2,$5CC3,$5CC5,$5CC6,$5CC7,$5CC8,$5CC9,
$5CCA,$5CCC,$5CCD,$5CCE,$5CCF,$5CD0,$5CD1,$5CD3,$5CD4,$5CD5,$5CD6,$5CD7,$5CD8,
$5CDA,$5CDB,$5CDC,$5CDD,$5CDE,$5CDF,$5CE0,$5CE2,$5CE3,$5CE7,$5CE9,$5CEB,$5CEC,
$5CEE,$5CEF,$5CF1,$5CF2,$5CF3,$5CF4,$5CF5,$5CF6,$5CF7,$5CF8,$5CF9,$5CFA,$5CFC,
$5CFD,$5CFE,$5CFF,$5D00,$5D01,$5D04,$5D05,$5D08,$5D09,$5D0A,$5D0B,$5D0C,$5D0D,
$5D0F,$5D10,$5D11,$5D12,$5D13,$5D15,$5D17,$5D18,$5D19,$5D1A,$5D1C,$5D1D,$5D1F,
$5D20,$5D21,$5D22,$5D23,$5D25,$5D28,$5D2A,$5D2B,$5D2C,$5D2F,$5D30,$5D31,$5D32,
$5D33,$5D35,$5D36,$5D37,$5D38,$5D39,$5D3A,$5D3B,$5D3C,$5D3F,$5D40,$5D41,$5D42,
$5D43,$5D44,$5D45,$5D46,$5D48,$5D49,$5D4D,$5D4E,$5D4F,$5D50,$5D51,$5D52,$5D53,
$5D54,$5D55,$5D56,$5D57,$5D59,$5D5A,$5D5C,$5D5E,$5D5F,$5D60,$5D61,$5D62,$5D63,
$5D64,$5D65,$5D66,$5D67,$5D68,$5D6A,$5D6D,$5D6E,$5D70,$5D71,$5D72,$5D73,$5D75,
$5D76,$5D77,$5D78,$5D79,$5D7A,$5D7B,$5D7C,$5D7D,$5D7E,$5D7F,$5D80,$5D81,$5D83,
$5D84,$5D85,$5D86,$5D87,$5D88,$5D89,$5D8A,$5D8B,$5D8C,$5D8D,$5D8E,$5D8F,$5D90,
$5D91,$5D92,$5D93,$5D94,$5D95,$5D96,$5D97,$5D98,$5D9A,$5D9B,$5D9C,$5D9E,$5D9F,
$5DA0,$5DA1,$5DA2,$5DA3,$5DA4,$5DA5,$5DA6,$5DA7,$5DA8,$5DA9,$5DAA,$5DAB,$5DAC,
$5DAD,$5DAE,$5DAF,$5DB0,$5DB1,$5DB2,$5DB3,$5DB4,$5DB5,$5DB6,$5DB8,$5DB9,$5DBA,
$5DBB,$5DBC,$5DBD,$5DBE,$5DBF,$5DC0,$5DC1,$5DC2,$5DC3,$5DC4,$5DC6,$5DC7,$5DC8,
$5DC9,$5DCA,$5DCB,$5DCC,$5DCE,$5DCF,$5DD0,$5DD1,$5DD2,$5DD3,$5DD4,$5DD5,$5DD6,
$5DD7,$5DD8,$5DD9,$5DDA,$5DDC,$5DDF,$5DE0,$5DE3,$5DE4,$5DEA,$5DEC,$5DED,$5DF0,
$5DF5,$5DF6,$5DF8,$5DF9,$5DFA,$5DFB,$5DFC,$5DFF,$5E00,$5E04,$5E07,$5E09,$5E0A,
$5E0B,$5E0D,$5E0E,$5E12,$5E13,$5E17,$5E1E,$5E1F,$5E20,$5E21,$5E22,$5E23,$5E24,
$5E25,$5E28,$5E29,$5E2A,$5E2B,$5E2C,$5E2F,$5E30,$5E32,$5E33,$5E34,$5E35,$5E36,
$5E39,$5E3A,$5E3E,$5E3F,$5E40,$5E41,$5E43,$5E46,$5E47,$5E48,$5E49,$5E4A,$5E4B,
$5E4D,$5E4E,$5E4F,$5E50,$5E51,$5E52,$5E53,$5E56,$5E57,$5E58,$5E59,$5E5A,$5E5C,
$5E5D,$5E5F,$5E60,$5E63,$5E64,$5E65,$5E66,$5E67,$5E68,$5E69,$5E6A,$5E6B,$5E6C,
$5E6D,$5E6E,$5E6F,$5E70,$5E71,$5E75,$5E77,$5E79,$5E7E,$5E81,$5E82,$5E83,$5E85,
$5E88,$5E89,$5E8C,$5E8D,$5E8E,$5E92,$5E98,$5E9B,$5E9D,$5EA1,$5EA2,$5EA3,$5EA4,
$5EA8,$5EA9,$5EAA,$5EAB,$5EAC,$5EAE,$5EAF,$5EB0,$5EB1,$5EB2,$5EB4,$5EBA,$5EBB,
$5EBC,$5EBD,$5EBF,$5EC0,$5EC1,$5EC2,$5EC3,$5EC4,$5EC5,$5EC6,$5EC7,$5EC8,$5ECB,
$5ECC,$5ECD,$5ECE,$5ECF,$5ED0,$5ED4,$5ED5,$5ED7,$5ED8,$5ED9,$5EDA,$5EDC,$5EDD,
$5EDE,$5EDF,$5EE0,$5EE1,$5EE2,$5EE3,$5EE4,$5EE5,$5EE6,$5EE7,$5EE9,$5EEB,$5EEC,
$5EED,$5EEE,$5EEF,$5EF0,$5EF1,$5EF2,$5EF3,$5EF5,$5EF8,$5EF9,$5EFB,$5EFC,$5EFD,
$5F05,$5F06,$5F07,$5F09,$5F0C,$5F0D,$5F0E,$5F10,$5F12,$5F14,$5F16,$5F19,$5F1A,
$5F1C,$5F1D,$5F1E,$5F21,$5F22,$5F23,$5F24,$5F28,$5F2B,$5F2C,$5F2E,$5F30,$5F32,
$5F33,$5F34,$5F35,$5F36,$5F37,$5F38,$5F3B,$5F3D,$5F3E,$5F3F,$5F41,$5F42,$5F43,
$5F44,$5F45,$5F46,$5F47,$5F48,$5F49,$5F4A,$5F4B,$5F4C,$5F4D,$5F4E,$5F4F,$5F51,
$5F54,$5F59,$5F5A,$5F5B,$5F5C,$5F5E,$5F5F,$5F60,$5F63,$5F65,$5F67,$5F68,$5F6B,
$5F6E,$5F6F,$5F72,$5F74,$5F75,$5F76,$5F78,$5F7A,$5F7D,$5F7E,$5F7F,$5F83,$5F86,
$5F8D,$5F8E,$5F8F,$5F91,$5F93,$5F94,$5F96,$5F9A,$5F9B,$5F9D,$5F9E,$5F9F,$5FA0,
$5FA2,$5FA3,$5FA4,$5FA5,$5FA6,$5FA7,$5FA9,$5FAB,$5FAC,$5FAF,$5FB0,$5FB1,$5FB2,
$5FB3,$5FB4,$5FB6,$5FB8,$5FB9,$5FBA,$5FBB,$5FBE,$5FBF,$5FC0,$5FC1,$5FC2,$5FC7,
$5FC8,$5FCA,$5FCB,$5FCE,$5FD3,$5FD4,$5FD5,$5FDA,$5FDB,$5FDC,$5FDE,$5FDF,$5FE2,
$5FE3,$5FE5,$5FE6,$5FE8,$5FE9,$5FEC,$5FEF,$5FF0,$5FF2,$5FF3,$5FF4,$5FF6,$5FF7,
$5FF9,$5FFA,$5FFC,$6007,$6008,$6009,$600B,$600C,$6010,$6011,$6013,$6017,$6018,
$601A,$601E,$601F,$6022,$6023,$6024,$602C,$602D,$602E,$6030,$6031,$6032,$6033,
$6034,$6036,$6037,$6038,$6039,$603A,$603D,$603E,$6040,$6044,$6045,$6046,$6047,
$6048,$6049,$604A,$604C,$604E,$604F,$6051,$6053,$6054,$6056,$6057,$6058,$605B,
$605C,$605E,$605F,$6060,$6061,$6065,$6066,$606E,$6071,$6072,$6074,$6075,$6077,
$607E,$6080,$6081,$6082,$6085,$6086,$6087,$6088,$608A,$608B,$608E,$608F,$6090,
$6091,$6093,$6095,$6097,$6098,$6099,$609C,$609E,$60A1,$60A2,$60A4,$60A5,$60A7,
$60A9,$60AA,$60AE,$60B0,$60B3,$60B5,$60B6,$60B7,$60B9,$60BA,$60BD,$60BE,$60BF,
$60C0,$60C1,$60C2,$60C3,$60C4,$60C7,$60C8,$60C9,$60CC,$60CD,$60CE,$60CF,$60D0,
$60D2,$60D3,$60D4,$60D6,$60D7,$60D9,$60DB,$60DE,$60E1,$60E2,$60E3,$60E4,$60E5,
$60EA,$60F1,$60F2,$60F5,$60F7,$60F8,$60FB,$60FC,$60FD,$60FE,$60FF,$6102,$6103,
$6104,$6105,$6107,$610A,$610B,$610C,$6110,$6111,$6112,$6113,$6114,$6116,$6117,
$6118,$6119,$611B,$611C,$611D,$611E,$6121,$6122,$6125,$6128,$6129,$612A,$612C,
$612D,$612E,$612F,$6130,$6131,$6132,$6133,$6134,$6135,$6136,$6137,$6138,$6139,
$613A,$613B,$613C,$613D,$613E,$6140,$6141,$6142,$6143,$6144,$6145,$6146,$6147,
$6149,$614B,$614D,$614F,$6150,$6152,$6153,$6154,$6156,$6157,$6158,$6159,$615A,
$615B,$615C,$615E,$615F,$6160,$6161,$6163,$6164,$6165,$6166,$6169,$616A,$616B,
$616C,$616D,$616E,$616F,$6171,$6172,$6173,$6174,$6176,$6178,$6179,$617A,$617B,
$617C,$617D,$617E,$617F,$6180,$6181,$6182,$6183,$6184,$6185,$6186,$6187,$6188,
$6189,$618A,$618C,$618D,$618F,$6190,$6191,$6192,$6193,$6195,$6196,$6197,$6198,
$6199,$619A,$619B,$619C,$619E,$619F,$61A0,$61A1,$61A2,$61A3,$61A4,$61A5,$61A6,
$61AA,$61AB,$61AD,$61AE,$61AF,$61B0,$61B1,$61B2,$61B3,$61B4,$61B5,$61B6,$61B8,
$61B9,$61BA,$61BB,$61BC,$61BD,$61BF,$61C0,$61C1,$61C3,$61C4,$61C5,$61C6,$61C7,
$61C9,$61CC,$61CD,$61CE,$61CF,$61D0,$61D3,$61D5,$61D6,$61D7,$61D8,$61D9,$61DA,
$61DB,$61DC,$61DD,$61DE,$61DF,$61E0,$61E1,$61E2,$61E3,$61E4,$61E5,$61E7,$61E8,
$61E9,$61EA,$61EB,$61EC,$61ED,$61EE,$61EF,$61F0,$61F1,$61F2,$61F3,$61F4,$61F6,
$61F7,$61F8,$61F9,$61FA,$61FB,$61FC,$61FD,$61FE,$6200,$6201,$6202,$6203,$6204,
$6205,$6207,$6209,$6213,$6214,$6219,$621C,$621D,$621E,$6220,$6223,$6226,$6227,
$6228,$6229,$622B,$622D,$622F,$6230,$6231,$6232,$6235,$6236,$6238,$6239,$623A,
$623B,$623C,$6242,$6244,$6245,$6246,$624A,$624F,$6250,$6255,$6256,$6257,$6259,
$625A,$625C,$625D,$625E,$625F,$6260,$6261,$6262,$6264,$6265,$6268,$6271,$6272,
$6274,$6275,$6277,$6278,$627A,$627B,$627D,$6281,$6282,$6283,$6285,$6286,$6287,
$6288,$628B,$628C,$628D,$628E,$628F,$6290,$6294,$6299,$629C,$629D,$629E,$62A3,
$62A6,$62A7,$62A9,$62AA,$62AD,$62AE,$62AF,$62B0,$62B2,$62B3,$62B4,$62B6,$62B7,
$62B8,$62BA,$62BE,$62C0,$62C1,$62C3,$62CB,$62CF,$62D1,$62D5,$62DD,$62DE,$62E0,
$62E1,$62E4,$62EA,$62EB,$62F0,$62F2,$62F5,$62F8,$62F9,$62FA,$62FB,$6300,$6303,
$6304,$6305,$6306,$630A,$630B,$630C,$630D,$630F,$6310,$6312,$6313,$6314,$6315,
$6317,$6318,$6319,$631C,$6326,$6327,$6329,$632C,$632D,$632E,$6330,$6331,$6333,
$6334,$6335,$6336,$6337,$6338,$633B,$633C,$633E,$633F,$6340,$6341,$6344,$6347,
$6348,$634A,$6351,$6352,$6353,$6354,$6356,$6357,$6358,$6359,$635A,$635B,$635C,
$635D,$6360,$6364,$6365,$6366,$6368,$636A,$636B,$636C,$636F,$6370,$6372,$6373,
$6374,$6375,$6378,$6379,$637C,$637D,$637E,$637F,$6381,$6383,$6384,$6385,$6386,
$638B,$638D,$6391,$6393,$6394,$6395,$6397,$6399,$639A,$639B,$639C,$639D,$639E,
$639F,$63A1,$63A4,$63A6,$63AB,$63AF,$63B1,$63B2,$63B5,$63B6,$63B9,$63BB,$63BD,
$63BF,$63C0,$63C1,$63C2,$63C3,$63C5,$63C7,$63C8,$63CA,$63CB,$63CC,$63D1,$63D3,
$63D4,$63D5,$63D7,$63D8,$63D9,$63DA,$63DB,$63DC,$63DD,$63DF,$63E2,$63E4,$63E5,
$63E6,$63E7,$63E8,$63EB,$63EC,$63EE,$63EF,$63F0,$63F1,$63F3,$63F5,$63F7,$63F9,
$63FA,$63FB,$63FC,$63FE,$6403,$6404,$6406,$6407,$6408,$6409,$640A,$640D,$640E,
$6411,$6412,$6415,$6416,$6417,$6418,$6419,$641A,$641D,$641F,$6422,$6423,$6424,
$6425,$6427,$6428,$6429,$642B,$642E,$642F,$6430,$6431,$6432,$6433,$6435,$6436,
$6437,$6438,$6439,$643B,$643C,$643E,$6440,$6442,$6443,$6449,$644B,$644C,$644D,
$644E,$644F,$6450,$6451,$6453,$6455,$6456,$6457,$6459,$645A,$645B,$645C,$645D,
$645F,$6460,$6461,$6462,$6463,$6464,$6465,$6466,$6468,$646A,$646B,$646C,$646E,
$646F,$6470,$6471,$6472,$6473,$6474,$6475,$6476,$6477,$647B,$647C,$647D,$647E,
$647F,$6480,$6481,$6483,$6486,$6488,$6489,$648A,$648B,$648C,$648D,$648E,$648F,
$6490,$6493,$6494,$6497,$6498,$649A,$649B,$649C,$649D,$649F,$64A0,$64A1,$64A2,
$64A3,$64A5,$64A6,$64A7,$64A8,$64AA,$64AB,$64AF,$64B1,$64B2,$64B3,$64B4,$64B6,
$64B9,$64BB,$64BD,$64BE,$64BF,$64C1,$64C3,$64C4,$64C6,$64C7,$64C8,$64C9,$64CA,
$64CB,$64CC,$64CF,$64D1,$64D3,$64D4,$64D5,$64D6,$64D9,$64DA,$64DB,$64DC,$64DD,
$64DF,$64E0,$64E1,$64E3,$64E5,$64E7,$64E8,$64E9,$64EA,$64EB,$64EC,$64ED,$64EE,
$64EF,$64F0,$64F1,$64F2,$64F3,$64F4,$64F5,$64F6,$64F7,$64F8,$64F9,$64FA,$64FB,
$64FC,$64FD,$64FE,$64FF,$6501,$6502,$6503,$6504,$6505,$6506,$6507,$6508,$650A,
$650B,$650C,$650D,$650E,$650F,$6510,$6511,$6513,$6514,$6515,$6516,$6517,$6519,
$651A,$651B,$651C,$651D,$651E,$651F,$6520,$6521,$6522,$6523,$6524,$6526,$6527,
$6528,$6529,$652A,$652C,$652D,$6530,$6531,$6532,$6533,$6537,$653A,$653C,$653D,
$6540,$6541,$6542,$6543,$6544,$6546,$6547,$654A,$654B,$654D,$654E,$6550,$6552,
$6553,$6554,$6557,$6558,$655A,$655C,$655F,$6560,$6561,$6564,$6565,$6567,$6568,
$6569,$656A,$656D,$656E,$656F,$6571,$6573,$6575,$6576,$6578,$6579,$657A,$657B,
$657C,$657D,$657E,$657F,$6580,$6581,$6582,$6583,$6584,$6585,$6586,$6588,$6589,
$658A,$658D,$658E,$658F,$6592,$6594,$6595,$6596,$6598,$659A,$659D,$659E,$65A0,
$65A2,$65A3,$65A6,$65A8,$65AA,$65AC,$65AE,$65B1,$65B2,$65B3,$65B4,$65B5,$65B6,
$65B7,$65B8,$65BA,$65BB,$65BE,$65BF,$65C0,$65C2,$65C7,$65C8,$65C9,$65CA,$65CD,
$65D0,$65D1,$65D3,$65D4,$65D5,$65D8,$65D9,$65DA,$65DB,$65DC,$65DD,$65DE,$65DF,
$65E1,$65E3,$65E4,$65EA,$65EB,$65F2,$65F3,$65F4,$65F5,$65F8,$65F9,$65FB,$65FC,
$65FD,$65FE,$65FF,$6601,$6604,$6605,$6607,$6608,$6609,$660B,$660D,$6610,$6611,
$6612,$6616,$6617,$6618,$661A,$661B,$661C,$661E,$6621,$6622,$6623,$6624,$6626,
$6629,$662A,$662B,$662C,$662E,$6630,$6632,$6633,$6637,$6638,$6639,$663A,$663B,
$663D,$663F,$6640,$6642,$6644,$6645,$6646,$6647,$6648,$6649,$664A,$664D,$664E,
$6650,$6651,$6658,$6659,$665B,$665C,$665D,$665E,$6660,$6662,$6663,$6665,$6667,
$6669,$666A,$666B,$666C,$666D,$6671,$6672,$6673,$6675,$6678,$6679,$667B,$667C,
$667D,$667F,$6680,$6681,$6683,$6685,$6686,$6688,$6689,$668A,$668B,$668D,$668E,
$668F,$6690,$6692,$6693,$6694,$6695,$6698,$6699,$669A,$669B,$669C,$669E,$669F,
$66A0,$66A1,$66A2,$66A3,$66A4,$66A5,$66A6,$66A9,$66AA,$66AB,$66AC,$66AD,$66AF,
$66B0,$66B1,$66B2,$66B3,$66B5,$66B6,$66B7,$66B8,$66BA,$66BB,$66BC,$66BD,$66BF,
$66C0,$66C1,$66C2,$66C3,$66C4,$66C5,$66C6,$66C7,$66C8,$66C9,$66CA,$66CB,$66CC,
$66CD,$66CE,$66CF,$66D0,$66D1,$66D2,$66D3,$66D4,$66D5,$66D6,$66D7,$66D8,$66DA,
$66DE,$66DF,$66E0,$66E1,$66E2,$66E3,$66E4,$66E5,$66E7,$66E8,$66EA,$66EB,$66EC,
$66ED,$66EE,$66EF,$66F1,$66F5,$66F6,$66F8,$66FA,$66FB,$66FD,$6701,$6702,$6703,
$6704,$6705,$6706,$6707,$670C,$670E,$670F,$6711,$6712,$6713,$6716,$6718,$6719,
$671A,$671C,$671E,$6720,$6721,$6722,$6723,$6724,$6725,$6727,$6729,$672E,$6730,
$6732,$6733,$6736,$6737,$6738,$6739,$673B,$673C,$673E,$673F,$6741,$6744,$6745,
$6747,$674A,$674B,$674D,$6752,$6754,$6755,$6757,$6758,$6759,$675A,$675B,$675D,
$6762,$6763,$6764,$6766,$6767,$676B,$676C,$676E,$6771,$6774,$6776,$6778,$6779,
$677A,$677B,$677D,$6780,$6782,$6783,$6785,$6786,$6788,$678A,$678C,$678D,$678E,
$678F,$6791,$6792,$6793,$6794,$6796,$6799,$679B,$679F,$67A0,$67A1,$67A4,$67A6,
$67A9,$67AC,$67AE,$67B1,$67B2,$67B4,$67B9,$67BA,$67BB,$67BC,$67BD,$67BE,$67BF,
$67C0,$67C2,$67C5,$67C6,$67C7,$67C8,$67C9,$67CA,$67CB,$67CC,$67CD,$67CE,$67D5,
$67D6,$67D7,$67DB,$67DF,$67E1,$67E3,$67E4,$67E6,$67E7,$67E8,$67EA,$67EB,$67ED,
$67EE,$67F2,$67F5,$67F6,$67F7,$67F8,$67F9,$67FA,$67FB,$67FC,$67FE,$6801,$6802,
$6803,$6804,$6806,$680D,$6810,$6812,$6814,$6815,$6818,$6819,$681A,$681B,$681C,
$681E,$681F,$6820,$6822,$6823,$6824,$6825,$6826,$6827,$6828,$682B,$682C,$682D,
$682E,$682F,$6830,$6831,$6834,$6835,$6836,$683A,$683B,$683F,$6847,$684B,$684D,
$684F,$6852,$6856,$6857,$6858,$6859,$685A,$685B,$685C,$685D,$685E,$685F,$686A,
$686C,$686D,$686E,$686F,$6870,$6871,$6872,$6873,$6875,$6878,$6879,$687A,$687B,
$687C,$687D,$687E,$687F,$6880,$6882,$6884,$6887,$6888,$6889,$688A,$688B,$688C,
$688D,$688E,$6890,$6891,$6892,$6894,$6895,$6896,$6898,$6899,$689A,$689B,$689C,
$689D,$689E,$689F,$68A0,$68A1,$68A3,$68A4,$68A5,$68A9,$68AA,$68AB,$68AC,$68AE,
$68B1,$68B2,$68B4,$68B6,$68B7,$68B8,$68B9,$68BA,$68BB,$68BC,$68BD,$68BE,$68BF,
$68C1,$68C3,$68C4,$68C5,$68C6,$68C7,$68C8,$68CA,$68CC,$68CE,$68CF,$68D0,$68D1,
$68D3,$68D4,$68D6,$68D7,$68D9,$68DB,$68DC,$68DD,$68DE,$68DF,$68E1,$68E2,$68E4,
$68E5,$68E6,$68E7,$68E8,$68E9,$68EA,$68EB,$68EC,$68ED,$68EF,$68F2,$68F3,$68F4,
$68F6,$68F7,$68F8,$68FB,$68FD,$68FE,$68FF,$6900,$6902,$6903,$6904,$6906,$6907,
$6908,$6909,$690A,$690C,$690F,$6911,$6913,$6914,$6915,$6916,$6917,$6918,$6919,
$691A,$691B,$691C,$691D,$691E,$6921,$6922,$6923,$6925,$6926,$6927,$6928,$6929,
$692A,$692B,$692C,$692E,$692F,$6931,$6932,$6933,$6935,$6936,$6937,$6938,$693A,
$693B,$693C,$693E,$6940,$6941,$6943,$6944,$6945,$6946,$6947,$6948,$6949,$694A,
$694B,$694C,$694D,$694E,$694F,$6950,$6951,$6952,$6953,$6955,$6956,$6958,$6959,
$695B,$695C,$695F,$6961,$6962,$6964,$6965,$6967,$6968,$6969,$696A,$696C,$696D,
$696F,$6970,$6972,$6973,$6974,$6975,$6976,$697A,$697B,$697D,$697E,$697F,$6981,
$6983,$6985,$698A,$698B,$698C,$698E,$698F,$6990,$6991,$6992,$6993,$6996,$6997,
$6999,$699A,$699D,$699E,$699F,$69A0,$69A1,$69A2,$69A3,$69A4,$69A5,$69A6,$69A9,
$69AA,$69AC,$69AE,$69AF,$69B0,$69B2,$69B3,$69B5,$69B6,$69B8,$69B9,$69BA,$69BC,
$69BD,$69BE,$69BF,$69C0,$69C2,$69C3,$69C4,$69C5,$69C6,$69C7,$69C8,$69C9,$69CB,
$69CD,$69CF,$69D1,$69D2,$69D3,$69D5,$69D6,$69D7,$69D8,$69D9,$69DA,$69DC,$69DD,
$69DE,$69E1,$69E2,$69E3,$69E4,$69E5,$69E6,$69E7,$69E8,$69E9,$69EA,$69EB,$69EC,
$69EE,$69EF,$69F0,$69F1,$69F3,$69F4,$69F5,$69F6,$69F7,$69F8,$69F9,$69FA,$69FB,
$69FC,$69FE,$6A00,$6A01,$6A02,$6A03,$6A04,$6A05,$6A06,$6A07,$6A08,$6A09,$6A0B,
$6A0C,$6A0D,$6A0E,$6A0F,$6A10,$6A11,$6A12,$6A13,$6A14,$6A15,$6A16,$6A19,$6A1A,
$6A1B,$6A1C,$6A1D,$6A1E,$6A20,$6A22,$6A23,$6A24,$6A25,$6A26,$6A27,$6A29,$6A2B,
$6A2C,$6A2D,$6A2E,$6A30,$6A32,$6A33,$6A34,$6A36,$6A37,$6A38,$6A39,$6A3A,$6A3B,
$6A3C,$6A3F,$6A40,$6A41,$6A42,$6A43,$6A45,$6A46,$6A48,$6A49,$6A4A,$6A4B,$6A4C,
$6A4D,$6A4E,$6A4F,$6A51,$6A52,$6A53,$6A54,$6A55,$6A56,$6A57,$6A5A,$6A5C,$6A5D,
$6A5E,$6A5F,$6A60,$6A62,$6A63,$6A64,$6A66,$6A67,$6A68,$6A69,$6A6A,$6A6B,$6A6C,
$6A6D,$6A6E,$6A6F,$6A70,$6A72,$6A73,$6A74,$6A75,$6A76,$6A77,$6A78,$6A7A,$6A7B,
$6A7D,$6A7E,$6A7F,$6A81,$6A82,$6A83,$6A85,$6A86,$6A87,$6A88,$6A89,$6A8A,$6A8B,
$6A8C,$6A8D,$6A8F,$6A92,$6A93,$6A94,$6A95,$6A96,$6A98,$6A99,$6A9A,$6A9B,$6A9C,
$6A9D,$6A9E,$6A9F,$6AA1,$6AA2,$6AA3,$6AA4,$6AA5,$6AA6,$6AA7,$6AA8,$6AAA,$6AAD,
$6AAE,$6AAF,$6AB0,$6AB1,$6AB2,$6AB3,$6AB4,$6AB5,$6AB6,$6AB7,$6AB8,$6AB9,$6ABA,
$6ABB,$6ABC,$6ABD,$6ABE,$6ABF,$6AC0,$6AC1,$6AC2,$6AC3,$6AC4,$6AC5,$6AC6,$6AC7,
$6AC8,$6AC9,$6ACA,$6ACB,$6ACC,$6ACD,$6ACE,$6ACF,$6AD0,$6AD1,$6AD2,$6AD3,$6AD4,
$6AD5,$6AD6,$6AD7,$6AD8,$6AD9,$6ADA,$6ADB,$6ADC,$6ADD,$6ADE,$6ADF,$6AE0,$6AE1,
$6AE2,$6AE3,$6AE4,$6AE5,$6AE6,$6AE7,$6AE8,$6AE9,$6AEA,$6AEB,$6AEC,$6AED,$6AEE,
$6AEF,$6AF0,$6AF1,$6AF2,$6AF3,$6AF4,$6AF5,$6AF6,$6AF7,$6AF8,$6AF9,$6AFA,$6AFB,
$6AFC,$6AFD,$6AFE,$6AFF,$6B00,$6B01,$6B02,$6B03,$6B04,$6B05,$6B06,$6B07,$6B08,
$6B09,$6B0A,$6B0B,$6B0C,$6B0D,$6B0E,$6B0F,$6B10,$6B11,$6B12,$6B13,$6B14,$6B15,
$6B16,$6B17,$6B18,$6B19,$6B1A,$6B1B,$6B1C,$6B1D,$6B1E,$6B1F,$6B25,$6B26,$6B28,
$6B29,$6B2A,$6B2B,$6B2C,$6B2D,$6B2E,$6B2F,$6B30,$6B31,$6B33,$6B34,$6B35,$6B36,
$6B38,$6B3B,$6B3C,$6B3D,$6B3F,$6B40,$6B41,$6B42,$6B44,$6B45,$6B48,$6B4A,$6B4B,
$6B4D,$6B4E,$6B4F,$6B50,$6B51,$6B52,$6B53,$6B54,$6B55,$6B56,$6B57,$6B58,$6B5A,
$6B5B,$6B5C,$6B5D,$6B5E,$6B5F,$6B60,$6B61,$6B68,$6B69,$6B6B,$6B6C,$6B6D,$6B6E,
$6B6F,$6B70,$6B71,$6B72,$6B73,$6B74,$6B75,$6B76,$6B77,$6B78,$6B7A,$6B7D,$6B7E,
$6B7F,$6B80,$6B85,$6B88,$6B8C,$6B8E,$6B8F,$6B90,$6B91,$6B94,$6B95,$6B97,$6B98,
$6B99,$6B9C,$6B9D,$6B9E,$6B9F,$6BA0,$6BA2,$6BA3,$6BA4,$6BA5,$6BA6,$6BA7,$6BA8,
$6BA9,$6BAB,$6BAC,$6BAD,$6BAE,$6BAF,$6BB0,$6BB1,$6BB2,$6BB6,$6BB8,$6BB9,$6BBA,
$6BBB,$6BBC,$6BBD,$6BBE,$6BC0,$6BC3,$6BC4,$6BC6,$6BC7,$6BC8,$6BC9,$6BCA,$6BCC,
$6BCE,$6BD0,$6BD1,$6BD8,$6BDA,$6BDC,$6BDD,$6BDE,$6BDF,$6BE0,$6BE2,$6BE3,$6BE4,
$6BE5,$6BE6,$6BE7,$6BE8,$6BE9,$6BEC,$6BED,$6BEE,$6BF0,$6BF1,$6BF2,$6BF4,$6BF6,
$6BF7,$6BF8,$6BFA,$6BFB,$6BFC,$6BFE,$6BFF,$6C00,$6C01,$6C02,$6C03,$6C04,$6C08,
$6C09,$6C0A,$6C0B,$6C0C,$6C0E,$6C12,$6C17,$6C1C,$6C1D,$6C1E,$6C20,$6C23,$6C25,
$6C2B,$6C2C,$6C2D,$6C31,$6C33,$6C36,$6C37,$6C39,$6C3A,$6C3B,$6C3C,$6C3E,$6C3F,
$6C43,$6C44,$6C45,$6C48,$6C4B,$6C4C,$6C4D,$6C4E,$6C4F,$6C51,$6C52,$6C53,$6C56,
$6C58,$6C59,$6C5A,$6C62,$6C63,$6C65,$6C66,$6C67,$6C6B,$6C6C,$6C6D,$6C6E,$6C6F,
$6C71,$6C73,$6C75,$6C77,$6C78,$6C7A,$6C7B,$6C7C,$6C7F,$6C80,$6C84,$6C87,$6C8A,
$6C8B,$6C8D,$6C8E,$6C91,$6C92,$6C95,$6C96,$6C97,$6C98,$6C9A,$6C9C,$6C9D,$6C9E,
$6CA0,$6CA2,$6CA8,$6CAC,$6CAF,$6CB0,$6CB4,$6CB5,$6CB6,$6CB7,$6CBA,$6CC0,$6CC1,
$6CC2,$6CC3,$6CC6,$6CC7,$6CC8,$6CCB,$6CCD,$6CCE,$6CCF,$6CD1,$6CD2,$6CD8,$6CD9,
$6CDA,$6CDC,$6CDD,$6CDF,$6CE4,$6CE6,$6CE7,$6CE9,$6CEC,$6CED,$6CF2,$6CF4,$6CF9,
$6CFF,$6D00,$6D02,$6D03,$6D05,$6D06,$6D08,$6D09,$6D0A,$6D0D,$6D0F,$6D10,$6D11,
$6D13,$6D14,$6D15,$6D16,$6D18,$6D1C,$6D1D,$6D1F,$6D20,$6D21,$6D22,$6D23,$6D24,
$6D26,$6D28,$6D29,$6D2C,$6D2D,$6D2F,$6D30,$6D34,$6D36,$6D37,$6D38,$6D3A,$6D3F,
$6D40,$6D42,$6D44,$6D49,$6D4C,$6D50,$6D55,$6D56,$6D57,$6D58,$6D5B,$6D5D,$6D5F,
$6D61,$6D62,$6D64,$6D65,$6D67,$6D68,$6D6B,$6D6C,$6D6D,$6D70,$6D71,$6D72,$6D73,
$6D75,$6D76,$6D79,$6D7A,$6D7B,$6D7D,$6D7E,$6D7F,$6D80,$6D81,$6D83,$6D84,$6D86,
$6D87,$6D8A,$6D8B,$6D8D,$6D8F,$6D90,$6D92,$6D96,$6D97,$6D98,$6D99,$6D9A,$6D9C,
$6DA2,$6DA5,$6DAC,$6DAD,$6DB0,$6DB1,$6DB3,$6DB4,$6DB6,$6DB7,$6DB9,$6DBA,$6DBB,
$6DBC,$6DBD,$6DBE,$6DC1,$6DC2,$6DC3,$6DC8,$6DC9,$6DCA,$6DCD,$6DCE,$6DCF,$6DD0,
$6DD2,$6DD3,$6DD4,$6DD5,$6DD7,$6DDA,$6DDB,$6DDC,$6DDF,$6DE2,$6DE3,$6DE5,$6DE7,
$6DE8,$6DE9,$6DEA,$6DED,$6DEF,$6DF0,$6DF2,$6DF4,$6DF5,$6DF6,$6DF8,$6DFA,$6DFD,
$6DFE,$6DFF,$6E00,$6E01,$6E02,$6E03,$6E04,$6E06,$6E07,$6E08,$6E09,$6E0B,$6E0F,
$6E12,$6E13,$6E15,$6E18,$6E19,$6E1B,$6E1C,$6E1E,$6E1F,$6E22,$6E26,$6E27,$6E28,
$6E2A,$6E2C,$6E2E,$6E30,$6E31,$6E33,$6E35,$6E36,$6E37,$6E39,$6E3B,$6E3C,$6E3D,
$6E3E,$6E3F,$6E40,$6E41,$6E42,$6E45,$6E46,$6E47,$6E48,$6E49,$6E4A,$6E4B,$6E4C,
$6E4F,$6E50,$6E51,$6E52,$6E55,$6E57,$6E59,$6E5A,$6E5C,$6E5D,$6E5E,$6E60,$6E61,
$6E62,$6E63,$6E64,$6E65,$6E66,$6E67,$6E68,$6E69,$6E6A,$6E6C,$6E6D,$6E6F,$6E70,
$6E71,$6E72,$6E73,$6E74,$6E75,$6E76,$6E77,$6E78,$6E79,$6E7A,$6E7B,$6E7C,$6E7D,
$6E80,$6E81,$6E82,$6E84,$6E87,$6E88,$6E8A,$6E8B,$6E8C,$6E8D,$6E8E,$6E91,$6E92,
$6E93,$6E94,$6E95,$6E96,$6E97,$6E99,$6E9A,$6E9B,$6E9D,$6E9E,$6EA0,$6EA1,$6EA3,
$6EA4,$6EA6,$6EA8,$6EA9,$6EAB,$6EAC,$6EAD,$6EAE,$6EB0,$6EB3,$6EB5,$6EB8,$6EB9,
$6EBC,$6EBE,$6EBF,$6EC0,$6EC3,$6EC4,$6EC5,$6EC6,$6EC8,$6EC9,$6ECA,$6ECC,$6ECD,
$6ECE,$6ED0,$6ED2,$6ED6,$6ED8,$6ED9,$6EDB,$6EDC,$6EDD,$6EE3,$6EE7,$6EEA,$6EEB,
$6EEC,$6EED,$6EEE,$6EEF,$6EF0,$6EF1,$6EF2,$6EF3,$6EF5,$6EF6,$6EF7,$6EF8,$6EFA,
$6EFB,$6EFC,$6EFD,$6EFE,$6EFF,$6F00,$6F01,$6F03,$6F04,$6F05,$6F07,$6F08,$6F0A,
$6F0B,$6F0C,$6F0D,$6F0E,$6F10,$6F11,$6F12,$6F16,$6F17,$6F18,$6F19,$6F1A,$6F1B,
$6F1C,$6F1D,$6F1E,$6F1F,$6F21,$6F22,$6F23,$6F25,$6F26,$6F27,$6F28,$6F2C,$6F2E,
$6F30,$6F32,$6F34,$6F35,$6F37,$6F38,$6F39,$6F3A,$6F3B,$6F3C,$6F3D,$6F3F,$6F40,
$6F41,$6F42,$6F43,$6F44,$6F45,$6F48,$6F49,$6F4A,$6F4C,$6F4E,$6F4F,$6F50,$6F51,
$6F52,$6F53,$6F54,$6F55,$6F56,$6F57,$6F59,$6F5A,$6F5B,$6F5D,$6F5F,$6F60,$6F61,
$6F63,$6F64,$6F65,$6F67,$6F68,$6F69,$6F6A,$6F6B,$6F6C,$6F6F,$6F70,$6F71,$6F73,
$6F75,$6F76,$6F77,$6F79,$6F7B,$6F7D,$6F7E,$6F7F,$6F80,$6F81,$6F82,$6F83,$6F85,
$6F86,$6F87,$6F8A,$6F8B,$6F8F,$6F90,$6F91,$6F92,$6F93,$6F94,$6F95,$6F96,$6F97,
$6F98,$6F99,$6F9A,$6F9B,$6F9D,$6F9E,$6F9F,$6FA0,$6FA2,$6FA3,$6FA4,$6FA5,$6FA6,
$6FA8,$6FA9,$6FAA,$6FAB,$6FAC,$6FAD,$6FAE,$6FAF,$6FB0,$6FB1,$6FB2,$6FB4,$6FB5,
$6FB7,$6FB8,$6FBA,$6FBB,$6FBC,$6FBD,$6FBE,$6FBF,$6FC1,$6FC3,$6FC4,$6FC5,$6FC6,
$6FC7,$6FC8,$6FCA,$6FCB,$6FCC,$6FCD,$6FCE,$6FCF,$6FD0,$6FD3,$6FD4,$6FD5,$6FD6,
$6FD7,$6FD8,$6FD9,$6FDA,$6FDB,$6FDC,$6FDD,$6FDF,$6FE2,$6FE3,$6FE4,$6FE5,$6FE6,
$6FE7,$6FE8,$6FE9,$6FEA,$6FEB,$6FEC,$6FED,$6FF0,$6FF1,$6FF2,$6FF3,$6FF4,$6FF5,
$6FF6,$6FF7,$6FF8,$6FF9,$6FFA,$6FFB,$6FFC,$6FFD,$6FFE,$6FFF,$7000,$7001,$7002,
$7003,$7004,$7005,$7006,$7007,$7008,$7009,$700A,$700B,$700C,$700D,$700E,$700F,
$7010,$7012,$7013,$7014,$7015,$7016,$7017,$7018,$7019,$701C,$701D,$701E,$701F,
$7020,$7021,$7022,$7024,$7025,$7026,$7027,$7028,$7029,$702A,$702B,$702C,$702D,
$702E,$702F,$7030,$7031,$7032,$7033,$7034,$7036,$7037,$7038,$703A,$703B,$703C,
$703D,$703E,$703F,$7040,$7041,$7042,$7043,$7044,$7045,$7046,$7047,$7048,$7049,
$704A,$704B,$704D,$704E,$7050,$7051,$7052,$7053,$7054,$7055,$7056,$7057,$7058,
$7059,$705A,$705B,$705C,$705D,$705F,$7060,$7061,$7062,$7063,$7064,$7065,$7066,
$7067,$7068,$7069,$706A,$706E,$7071,$7072,$7073,$7074,$7077,$7079,$707A,$707B,
$707D,$7081,$7082,$7083,$7084,$7086,$7087,$7088,$708B,$708C,$708D,$708F,$7090,
$7091,$7093,$7097,$7098,$709A,$709B,$709E,$709F,$70A0,$70A1,$70A2,$70A3,$70A4,
$70A5,$70A6,$70A7,$70A8,$70A9,$70AA,$70B0,$70B2,$70B4,$70B5,$70B6,$70BA,$70BE,
$70BF,$70C4,$70C5,$70C6,$70C7,$70C9,$70CB,$70CC,$70CD,$70CE,$70CF,$70D0,$70D1,
$70D2,$70D3,$70D4,$70D5,$70D6,$70D7,$70DA,$70DC,$70DD,$70DE,$70E0,$70E1,$70E2,
$70E3,$70E5,$70EA,$70EE,$70F0,$70F1,$70F2,$70F3,$70F4,$70F5,$70F6,$70F8,$70FA,
$70FB,$70FC,$70FE,$70FF,$7100,$7101,$7102,$7103,$7104,$7105,$7106,$7107,$7108,
$710B,$710C,$710D,$710E,$710F,$7111,$7112,$7114,$7117,$711B,$711C,$711D,$711E,
$711F,$7120,$7121,$7122,$7123,$7124,$7125,$7127,$7128,$7129,$712A,$712B,$712C,
$712D,$712E,$7132,$7133,$7134,$7135,$7137,$7138,$7139,$713A,$713B,$713C,$713D,
$713E,$713F,$7140,$7141,$7142,$7143,$7144,$7146,$7147,$7148,$7149,$714B,$714D,
$714F,$7150,$7151,$7152,$7153,$7154,$7155,$7156,$7157,$7158,$7159,$715A,$715B,
$715D,$715F,$7160,$7161,$7162,$7163,$7165,$7169,$716A,$716B,$716C,$716D,$716F,
$7170,$7171,$7174,$7175,$7176,$7177,$7179,$717B,$717C,$717E,$717F,$7180,$7181,
$7182,$7183,$7185,$7186,$7187,$7188,$7189,$718B,$718C,$718D,$718E,$7190,$7191,
$7192,$7193,$7195,$7196,$7197,$719A,$719B,$719C,$719D,$719E,$71A1,$71A2,$71A3,
$71A4,$71A5,$71A6,$71A7,$71A9,$71AA,$71AB,$71AD,$71AE,$71AF,$71B0,$71B1,$71B2,
$71B4,$71B6,$71B7,$71B8,$71BA,$71BB,$71BC,$71BD,$71BE,$71BF,$71C0,$71C1,$71C2,
$71C4,$71C5,$71C6,$71C7,$71C8,$71C9,$71CA,$71CB,$71CC,$71CD,$71CF,$71D0,$71D1,
$71D2,$71D3,$71D6,$71D7,$71D8,$71D9,$71DA,$71DB,$71DC,$71DD,$71DE,$71DF,$71E1,
$71E2,$71E3,$71E4,$71E6,$71E8,$71E9,$71EA,$71EB,$71EC,$71ED,$71EF,$71F0,$71F1,
$71F2,$71F3,$71F4,$71F5,$71F6,$71F7,$71F8,$71FA,$71FB,$71FC,$71FD,$71FE,$71FF,
$7200,$7201,$7202,$7203,$7204,$7205,$7207,$7208,$7209,$720A,$720B,$720C,$720D,
$720E,$720F,$7210,$7211,$7212,$7213,$7214,$7215,$7216,$7217,$7218,$7219,$721A,
$721B,$721C,$721E,$721F,$7220,$7221,$7222,$7223,$7224,$7225,$7226,$7227,$7229,
$722B,$722D,$722E,$722F,$7232,$7233,$7234,$723A,$723C,$723E,$7240,$7241,$7242,
$7243,$7244,$7245,$7246,$7249,$724A,$724B,$724E,$724F,$7250,$7251,$7253,$7254,
$7255,$7257,$7258,$725A,$725C,$725E,$7260,$7263,$7264,$7265,$7268,$726A,$726B,
$726C,$726D,$7270,$7271,$7273,$7274,$7276,$7277,$7278,$727B,$727C,$727D,$7282,
$7283,$7285,$7286,$7287,$7288,$7289,$728C,$728E,$7290,$7291,$7293,$7294,$7295,
$7296,$7297,$7298,$7299,$729A,$729B,$729C,$729D,$729E,$72A0,$72A1,$72A2,$72A3,
$72A4,$72A5,$72A6,$72A7,$72A8,$72A9,$72AA,$72AB,$72AE,$72B1,$72B2,$72B3,$72B5,
$72BA,$72BB,$72BC,$72BD,$72BE,$72BF,$72C0,$72C5,$72C6,$72C7,$72C9,$72CA,$72CB,
$72CC,$72CF,$72D1,$72D3,$72D4,$72D5,$72D6,$72D8,$72DA,$72DB,$3000,$3001,$3002,
$00B7,$02C9,$02C7,$00A8,$3003,$3005,$2014,$FF5E,$2016,$2026,$2018,$2019,$201C,
$201D,$3014,$3015,$3008,$3009,$300A,$300B,$300C,$300D,$300E,$300F,$3016,$3017,
$3010,$3011,$00B1,$00D7,$00F7,$2236,$2227,$2228,$2211,$220F,$222A,$2229,$2208,
$2237,$221A,$22A5,$2225,$2220,$2312,$2299,$222B,$222E,$2261,$224C,$2248,$223D,
$221D,$2260,$226E,$226F,$2264,$2265,$221E,$2235,$2234,$2642,$2640,$00B0,$2032,
$2033,$2103,$FF04,$00A4,$FFE0,$FFE1,$2030,$00A7,$2116,$2606,$2605,$25CB,$25CF,
$25CE,$25C7,$25C6,$25A1,$25A0,$25B3,$25B2,$203B,$2192,$2190,$2191,$2193,$3013,
$2170,$2171,$2172,$2173,$2174,$2175,$2176,$2177,$2178,$2179,$2488,$2489,$248A,
$248B,$248C,$248D,$248E,$248F,$2490,$2491,$2492,$2493,$2494,$2495,$2496,$2497,
$2498,$2499,$249A,$249B,$2474,$2475,$2476,$2477,$2478,$2479,$247A,$247B,$247C,
$247D,$247E,$247F,$2480,$2481,$2482,$2483,$2484,$2485,$2486,$2487,$2460,$2461,
$2462,$2463,$2464,$2465,$2466,$2467,$2468,$2469,$3220,$3221,$3222,$3223,$3224,
$3225,$3226,$3227,$3228,$3229,$2160,$2161,$2162,$2163,$2164,$2165,$2166,$2167,
$2168,$2169,$216A,$216B,$FF01,$FF02,$FF03,$FFE5,$FF05,$FF06,$FF07,$FF08,$FF09,
$FF0A,$FF0B,$FF0C,$FF0D,$FF0E,$FF0F,$FF10,$FF11,$FF12,$FF13,$FF14,$FF15,$FF16,
$FF17,$FF18,$FF19,$FF1A,$FF1B,$FF1C,$FF1D,$FF1E,$FF1F,$FF20,$FF21,$FF22,$FF23,
$FF24,$FF25,$FF26,$FF27,$FF28,$FF29,$FF2A,$FF2B,$FF2C,$FF2D,$FF2E,$FF2F,$FF30,
$FF31,$FF32,$FF33,$FF34,$FF35,$FF36,$FF37,$FF38,$FF39,$FF3A,$FF3B,$FF3C,$FF3D,
$FF3E,$FF3F,$FF40,$FF41,$FF42,$FF43,$FF44,$FF45,$FF46,$FF47,$FF48,$FF49,$FF4A,
$FF4B,$FF4C,$FF4D,$FF4E,$FF4F,$FF50,$FF51,$FF52,$FF53,$FF54,$FF55,$FF56,$FF57,
$FF58,$FF59,$FF5A,$FF5B,$FF5C,$FF5D,$FFE3,$3041,$3042,$3043,$3044,$3045,$3046,
$3047,$3048,$3049,$304A,$304B,$304C,$304D,$304E,$304F,$3050,$3051,$3052,$3053,
$3054,$3055,$3056,$3057,$3058,$3059,$305A,$305B,$305C,$305D,$305E,$305F,$3060,
$3061,$3062,$3063,$3064,$3065,$3066,$3067,$3068,$3069,$306A,$306B,$306C,$306D,
$306E,$306F,$3070,$3071,$3072,$3073,$3074,$3075,$3076,$3077,$3078,$3079,$307A,
$307B,$307C,$307D,$307E,$307F,$3080,$3081,$3082,$3083,$3084,$3085,$3086,$3087,
$3088,$3089,$308A,$308B,$308C,$308D,$308E,$308F,$3090,$3091,$3092,$3093,$30A1,
$30A2,$30A3,$30A4,$30A5,$30A6,$30A7,$30A8,$30A9,$30AA,$30AB,$30AC,$30AD,$30AE,
$30AF,$30B0,$30B1,$30B2,$30B3,$30B4,$30B5,$30B6,$30B7,$30B8,$30B9,$30BA,$30BB,
$30BC,$30BD,$30BE,$30BF,$30C0,$30C1,$30C2,$30C3,$30C4,$30C5,$30C6,$30C7,$30C8,
$30C9,$30CA,$30CB,$30CC,$30CD,$30CE,$30CF,$30D0,$30D1,$30D2,$30D3,$30D4,$30D5,
$30D6,$30D7,$30D8,$30D9,$30DA,$30DB,$30DC,$30DD,$30DE,$30DF,$30E0,$30E1,$30E2,
$30E3,$30E4,$30E5,$30E6,$30E7,$30E8,$30E9,$30EA,$30EB,$30EC,$30ED,$30EE,$30EF,
$30F0,$30F1,$30F2,$30F3,$30F4,$30F5,$30F6,$0391,$0392,$0393,$0394,$0395,$0396,
$0397,$0398,$0399,$039A,$039B,$039C,$039D,$039E,$039F,$03A0,$03A1,$03A3,$03A4,
$03A5,$03A6,$03A7,$03A8,$03A9,$03B1,$03B2,$03B3,$03B4,$03B5,$03B6,$03B7,$03B8,
$03B9,$03BA,$03BB,$03BC,$03BD,$03BE,$03BF,$03C0,$03C1,$03C3,$03C4,$03C5,$03C6,
$03C7,$03C8,$03C9,$FE35,$FE36,$FE39,$FE3A,$FE3F,$FE40,$FE3D,$FE3E,$FE41,$FE42,
$FE43,$FE44,$FE3B,$FE3C,$FE37,$FE38,$FE31,$FE33,$FE34,$0410,$0411,$0412,$0413,
$0414,$0415,$0401,$0416,$0417,$0418,$0419,$041A,$041B,$041C,$041D,$041E,$041F,
$0420,$0421,$0422,$0423,$0424,$0425,$0426,$0427,$0428,$0429,$042A,$042B,$042C,
$042D,$042E,$042F,$0430,$0431,$0432,$0433,$0434,$0435,$0451,$0436,$0437,$0438,
$0439,$043A,$043B,$043C,$043D,$043E,$043F,$0440,$0441,$0442,$0443,$0444,$0445,
$0446,$0447,$0448,$0449,$044A,$044B,$044C,$044D,$044E,$044F,$02CA,$02CB,$02D9,
$2013,$2015,$2025,$2035,$2105,$2109,$2196,$2197,$2198,$2199,$2215,$221F,$2223,
$2252,$2266,$2267,$22BF,$2550,$2551,$2552,$2553,$2554,$2555,$2556,$2557,$2558,
$2559,$255A,$255B,$255C,$255D,$255E,$255F,$2560,$2561,$2562,$2563,$2564,$2565,
$2566,$2567,$2568,$2569,$256A,$256B,$256C,$256D,$256E,$256F,$2570,$2571,$2572,
$2573,$2581,$2582,$2583,$2584,$2585,$2586,$2587,$2588,$2589,$258A,$258B,$258C,
$258D,$258E,$258F,$2593,$2594,$2595,$25BC,$25BD,$25E2,$25E3,$25E4,$25E5,$2609,
$2295,$3012,$301D,$301E,$0101,$00E1,$01CE,$00E0,$0113,$00E9,$011B,$00E8,$012B,
$00ED,$01D0,$00EC,$014D,$00F3,$01D2,$00F2,$016B,$00FA,$01D4,$00F9,$01D6,$01D8,
$01DA,$01DC,$00FC,$00EA,$0251,$0144,$0148,$0261,$3105,$3106,$3107,$3108,$3109,
$310A,$310B,$310C,$310D,$310E,$310F,$3110,$3111,$3112,$3113,$3114,$3115,$3116,
$3117,$3118,$3119,$311A,$311B,$311C,$311D,$311E,$311F,$3120,$3121,$3122,$3123,
$3124,$3125,$3126,$3127,$3128,$3129,$3021,$3022,$3023,$3024,$3025,$3026,$3027,
$3028,$3029,$32A3,$338E,$338F,$339C,$339D,$339E,$33A1,$33C4,$33CE,$33D1,$33D2,
$33D5,$FE30,$FFE2,$FFE4,$2121,$3231,$2010,$30FC,$309B,$309C,$30FD,$30FE,$3006,
$309D,$309E,$FE49,$FE4A,$FE4B,$FE4C,$FE4D,$FE4E,$FE4F,$FE50,$FE51,$FE52,$FE54,
$FE55,$FE56,$FE57,$FE59,$FE5A,$FE5B,$FE5C,$FE5D,$FE5E,$FE5F,$FE60,$FE61,$FE62,
$FE63,$FE64,$FE65,$FE66,$FE68,$FE69,$FE6A,$FE6B,$3007,$2500,$2501,$2502,$2503,
$2504,$2505,$2506,$2507,$2508,$2509,$250A,$250B,$250C,$250D,$250E,$250F,$2510,
$2511,$2512,$2513,$2514,$2515,$2516,$2517,$2518,$2519,$251A,$251B,$251C,$251D,
$251E,$251F,$2520,$2521,$2522,$2523,$2524,$2525,$2526,$2527,$2528,$2529,$252A,
$252B,$252C,$252D,$252E,$252F,$2530,$2531,$2532,$2533,$2534,$2535,$2536,$2537,
$2538,$2539,$253A,$253B,$253C,$253D,$253E,$253F,$2540,$2541,$2542,$2543,$2544,
$2545,$2546,$2547,$2548,$2549,$254A,$254B,$72DC,$72DD,$72DF,$72E2,$72E3,$72E4,
$72E5,$72E6,$72E7,$72EA,$72EB,$72F5,$72F6,$72F9,$72FD,$72FE,$72FF,$7300,$7302,
$7304,$7305,$7306,$7307,$7308,$7309,$730B,$730C,$730D,$730F,$7310,$7311,$7312,
$7314,$7318,$7319,$731A,$731F,$7320,$7323,$7324,$7326,$7327,$7328,$732D,$732F,
$7330,$7332,$7333,$7335,$7336,$733A,$733B,$733C,$733D,$7340,$7341,$7342,$7343,
$7344,$7345,$7346,$7347,$7348,$7349,$734A,$734B,$734C,$734E,$734F,$7351,$7353,
$7354,$7355,$7356,$7358,$7359,$735A,$735B,$735C,$735D,$735E,$735F,$7361,$7362,
$7363,$7364,$7365,$7366,$7367,$7368,$7369,$736A,$736B,$736E,$7370,$7371,$7372,
$7373,$7374,$7375,$7376,$7377,$7378,$7379,$737A,$737B,$737C,$737D,$737F,$7380,
$7381,$7382,$7383,$7385,$7386,$7388,$738A,$738C,$738D,$738F,$7390,$7392,$7393,
$7394,$7395,$7397,$7398,$7399,$739A,$739C,$739D,$739E,$73A0,$73A1,$73A3,$73A4,
$73A5,$73A6,$73A7,$73A8,$73AA,$73AC,$73AD,$73B1,$73B4,$73B5,$73B6,$73B8,$73B9,
$73BC,$73BD,$73BE,$73BF,$73C1,$73C3,$73C4,$73C5,$73C6,$73C7,$73CB,$73CC,$73CE,
$73D2,$73D3,$73D4,$73D5,$73D6,$73D7,$73D8,$73DA,$73DB,$73DC,$73DD,$73DF,$73E1,
$73E2,$73E3,$73E4,$73E6,$73E8,$73EA,$73EB,$73EC,$73EE,$73EF,$73F0,$73F1,$73F3,
$73F4,$73F5,$73F6,$73F7,$73F8,$73F9,$73FA,$73FB,$73FC,$73FD,$73FE,$73FF,$7400,
$7401,$7402,$7404,$7407,$7408,$740B,$740C,$740D,$740E,$7411,$7412,$7413,$7414,
$7415,$7416,$7417,$7418,$7419,$741C,$741D,$741E,$741F,$7420,$7421,$7423,$7424,
$7427,$7429,$742B,$742D,$742F,$7431,$7432,$7437,$7438,$7439,$743A,$743B,$743D,
$743E,$743F,$7440,$7442,$7443,$7444,$7445,$7446,$7447,$7448,$7449,$744A,$744B,
$744C,$744D,$744E,$744F,$7450,$7451,$7452,$7453,$7454,$7456,$7458,$745D,$7460,
$7461,$7462,$7463,$7464,$7465,$7466,$7467,$7468,$7469,$746A,$746B,$746C,$746E,
$746F,$7471,$7472,$7473,$7474,$7475,$7478,$7479,$747A,$747B,$747C,$747D,$747F,
$7482,$7484,$7485,$7486,$7488,$7489,$748A,$748C,$748D,$748F,$7491,$7492,$7493,
$7494,$7495,$7496,$7497,$7498,$7499,$749A,$749B,$749D,$749F,$74A0,$74A1,$74A2,
$74A3,$74A4,$74A5,$74A6,$74AA,$74AB,$74AC,$74AD,$74AE,$74AF,$74B0,$74B1,$74B2,
$74B3,$74B4,$74B5,$74B6,$74B7,$74B8,$74B9,$74BB,$74BC,$74BD,$74BE,$74BF,$74C0,
$74C1,$74C2,$74C3,$74C4,$74C5,$74C6,$74C7,$74C8,$74C9,$74CA,$74CB,$74CC,$74CD,
$74CE,$74CF,$74D0,$74D1,$74D3,$74D4,$74D5,$74D6,$74D7,$74D8,$74D9,$74DA,$74DB,
$74DD,$74DF,$74E1,$74E5,$74E7,$74E8,$74E9,$74EA,$74EB,$74EC,$74ED,$74F0,$74F1,
$74F2,$74F3,$74F5,$74F8,$74F9,$74FA,$74FB,$74FC,$74FD,$74FE,$7500,$7501,$7502,
$7503,$7505,$7506,$7507,$7508,$7509,$750A,$750B,$750C,$750E,$7510,$7512,$7514,
$7515,$7516,$7517,$751B,$751D,$751E,$7520,$7521,$7522,$7523,$7524,$7526,$7527,
$752A,$752E,$7534,$7536,$7539,$753C,$753D,$753F,$7541,$7542,$7543,$7544,$7546,
$7547,$7549,$754A,$754D,$7550,$7551,$7552,$7553,$7555,$7556,$7557,$7558,$755D,
$755E,$755F,$7560,$7561,$7562,$7563,$7564,$7567,$7568,$7569,$756B,$756C,$756D,
$756E,$756F,$7570,$7571,$7573,$7575,$7576,$7577,$757A,$757B,$757C,$757D,$757E,
$7580,$7581,$7582,$7584,$7585,$7587,$7588,$7589,$758A,$758C,$758D,$758E,$7590,
$7593,$7595,$7598,$759B,$759C,$759E,$75A2,$75A6,$75A7,$75A8,$75A9,$75AA,$75AD,
$75B6,$75B7,$75BA,$75BB,$75BF,$75C0,$75C1,$75C6,$75CB,$75CC,$75CE,$75CF,$75D0,
$75D1,$75D3,$75D7,$75D9,$75DA,$75DC,$75DD,$75DF,$75E0,$75E1,$75E5,$75E9,$75EC,
$75ED,$75EE,$75EF,$75F2,$75F3,$75F5,$75F6,$75F7,$75F8,$75FA,$75FB,$75FD,$75FE,
$7602,$7604,$7606,$7607,$7608,$7609,$760B,$760D,$760E,$760F,$7611,$7612,$7613,
$7614,$7616,$761A,$761C,$761D,$761E,$7621,$7623,$7627,$7628,$762C,$762E,$762F,
$7631,$7632,$7636,$7637,$7639,$763A,$763B,$763D,$7641,$7642,$7644,$7645,$7646,
$7647,$7648,$7649,$764A,$764B,$764E,$764F,$7650,$7651,$7652,$7653,$7655,$7657,
$7658,$7659,$765A,$765B,$765D,$765F,$7660,$7661,$7662,$7664,$7665,$7666,$7667,
$7668,$7669,$766A,$766C,$766D,$766E,$7670,$7671,$7672,$7673,$7674,$7675,$7676,
$7677,$7679,$767A,$767C,$767F,$7680,$7681,$7683,$7685,$7689,$768A,$768C,$768D,
$768F,$7690,$7692,$7694,$7695,$7697,$7698,$769A,$769B,$769C,$769D,$769E,$769F,
$76A0,$76A1,$76A2,$76A3,$76A5,$76A6,$76A7,$76A8,$76A9,$76AA,$76AB,$76AC,$76AD,
$76AF,$76B0,$76B3,$76B5,$76B6,$76B7,$76B8,$76B9,$76BA,$76BB,$76BC,$76BD,$76BE,
$76C0,$76C1,$76C3,$554A,$963F,$57C3,$6328,$54CE,$5509,$54C0,$7691,$764C,$853C,
$77EE,$827E,$788D,$7231,$9698,$978D,$6C28,$5B89,$4FFA,$6309,$6697,$5CB8,$80FA,
$6848,$80AE,$6602,$76CE,$51F9,$6556,$71AC,$7FF1,$8884,$50B2,$5965,$61CA,$6FB3,
$82AD,$634C,$6252,$53ED,$5427,$7B06,$516B,$75A4,$5DF4,$62D4,$8DCB,$9776,$628A,
$8019,$575D,$9738,$7F62,$7238,$767D,$67CF,$767E,$6446,$4F70,$8D25,$62DC,$7A17,
$6591,$73ED,$642C,$6273,$822C,$9881,$677F,$7248,$626E,$62CC,$4F34,$74E3,$534A,
$529E,$7ECA,$90A6,$5E2E,$6886,$699C,$8180,$7ED1,$68D2,$78C5,$868C,$9551,$508D,
$8C24,$82DE,$80DE,$5305,$8912,$5265,$76C4,$76C7,$76C9,$76CB,$76CC,$76D3,$76D5,
$76D9,$76DA,$76DC,$76DD,$76DE,$76E0,$76E1,$76E2,$76E3,$76E4,$76E6,$76E7,$76E8,
$76E9,$76EA,$76EB,$76EC,$76ED,$76F0,$76F3,$76F5,$76F6,$76F7,$76FA,$76FB,$76FD,
$76FF,$7700,$7702,$7703,$7705,$7706,$770A,$770C,$770E,$770F,$7710,$7711,$7712,
$7713,$7714,$7715,$7716,$7717,$7718,$771B,$771C,$771D,$771E,$7721,$7723,$7724,
$7725,$7727,$772A,$772B,$772C,$772E,$7730,$7731,$7732,$7733,$7734,$7739,$773B,
$773D,$773E,$773F,$7742,$7744,$7745,$7746,$7748,$7749,$774A,$774B,$774C,$774D,
$774E,$774F,$7752,$7753,$7754,$7755,$7756,$7757,$7758,$7759,$775C,$8584,$96F9,
$4FDD,$5821,$9971,$5B9D,$62B1,$62A5,$66B4,$8C79,$9C8D,$7206,$676F,$7891,$60B2,
$5351,$5317,$8F88,$80CC,$8D1D,$94A1,$500D,$72C8,$5907,$60EB,$7119,$88AB,$5954,
$82EF,$672C,$7B28,$5D29,$7EF7,$752D,$6CF5,$8E66,$8FF8,$903C,$9F3B,$6BD4,$9119,
$7B14,$5F7C,$78A7,$84D6,$853D,$6BD5,$6BD9,$6BD6,$5E01,$5E87,$75F9,$95ED,$655D,
$5F0A,$5FC5,$8F9F,$58C1,$81C2,$907F,$965B,$97AD,$8FB9,$7F16,$8D2C,$6241,$4FBF,
$53D8,$535E,$8FA8,$8FA9,$8FAB,$904D,$6807,$5F6A,$8198,$8868,$9CD6,$618B,$522B,
$762A,$5F6C,$658C,$6FD2,$6EE8,$5BBE,$6448,$5175,$51B0,$67C4,$4E19,$79C9,$997C,
$70B3,$775D,$775E,$775F,$7760,$7764,$7767,$7769,$776A,$776D,$776E,$776F,$7770,
$7771,$7772,$7773,$7774,$7775,$7776,$7777,$7778,$777A,$777B,$777C,$7781,$7782,
$7783,$7786,$7787,$7788,$7789,$778A,$778B,$778F,$7790,$7793,$7794,$7795,$7796,
$7797,$7798,$7799,$779A,$779B,$779C,$779D,$779E,$77A1,$77A3,$77A4,$77A6,$77A8,
$77AB,$77AD,$77AE,$77AF,$77B1,$77B2,$77B4,$77B6,$77B7,$77B8,$77B9,$77BA,$77BC,
$77BE,$77C0,$77C1,$77C2,$77C3,$77C4,$77C5,$77C6,$77C7,$77C8,$77C9,$77CA,$77CB,
$77CC,$77CE,$77CF,$77D0,$77D1,$77D2,$77D3,$77D4,$77D5,$77D6,$77D8,$77D9,$77DA,
$77DD,$77DE,$77DF,$77E0,$77E1,$77E4,$75C5,$5E76,$73BB,$83E0,$64AD,$62E8,$94B5,
$6CE2,$535A,$52C3,$640F,$94C2,$7B94,$4F2F,$5E1B,$8236,$8116,$818A,$6E24,$6CCA,
$9A73,$6355,$535C,$54FA,$8865,$57E0,$4E0D,$5E03,$6B65,$7C3F,$90E8,$6016,$64E6,
$731C,$88C1,$6750,$624D,$8D22,$776C,$8E29,$91C7,$5F69,$83DC,$8521,$9910,$53C2,
$8695,$6B8B,$60ED,$60E8,$707F,$82CD,$8231,$4ED3,$6CA7,$85CF,$64CD,$7CD9,$69FD,
$66F9,$8349,$5395,$7B56,$4FA7,$518C,$6D4B,$5C42,$8E6D,$63D2,$53C9,$832C,$8336,
$67E5,$78B4,$643D,$5BDF,$5C94,$5DEE,$8BE7,$62C6,$67F4,$8C7A,$6400,$63BA,$8749,
$998B,$8C17,$7F20,$94F2,$4EA7,$9610,$98A4,$660C,$7316,$77E6,$77E8,$77EA,$77EF,
$77F0,$77F1,$77F2,$77F4,$77F5,$77F7,$77F9,$77FA,$77FB,$77FC,$7803,$7804,$7805,
$7806,$7807,$7808,$780A,$780B,$780E,$780F,$7810,$7813,$7815,$7819,$781B,$781E,
$7820,$7821,$7822,$7824,$7828,$782A,$782B,$782E,$782F,$7831,$7832,$7833,$7835,
$7836,$783D,$783F,$7841,$7842,$7843,$7844,$7846,$7848,$7849,$784A,$784B,$784D,
$784F,$7851,$7853,$7854,$7858,$7859,$785A,$785B,$785C,$785E,$785F,$7860,$7861,
$7862,$7863,$7864,$7865,$7866,$7867,$7868,$7869,$786F,$7870,$7871,$7872,$7873,
$7874,$7875,$7876,$7878,$7879,$787A,$787B,$787D,$787E,$787F,$7880,$7881,$7882,
$7883,$573A,$5C1D,$5E38,$957F,$507F,$80A0,$5382,$655E,$7545,$5531,$5021,$8D85,
$6284,$949E,$671D,$5632,$6F6E,$5DE2,$5435,$7092,$8F66,$626F,$64A4,$63A3,$5F7B,
$6F88,$90F4,$81E3,$8FB0,$5C18,$6668,$5FF1,$6C89,$9648,$8D81,$886C,$6491,$79F0,
$57CE,$6A59,$6210,$5448,$4E58,$7A0B,$60E9,$6F84,$8BDA,$627F,$901E,$9A8B,$79E4,
$5403,$75F4,$6301,$5319,$6C60,$8FDF,$5F1B,$9A70,$803B,$9F7F,$4F88,$5C3A,$8D64,
$7FC5,$65A5,$70BD,$5145,$51B2,$866B,$5D07,$5BA0,$62BD,$916C,$7574,$8E0C,$7A20,
$6101,$7B79,$4EC7,$7EF8,$7785,$4E11,$81ED,$521D,$51FA,$6A71,$53A8,$8E87,$9504,
$96CF,$6EC1,$9664,$695A,$7884,$7885,$7886,$7888,$788A,$788B,$788F,$7890,$7892,
$7894,$7895,$7896,$7899,$789D,$789E,$78A0,$78A2,$78A4,$78A6,$78A8,$78A9,$78AA,
$78AB,$78AC,$78AD,$78AE,$78AF,$78B5,$78B6,$78B7,$78B8,$78BA,$78BB,$78BC,$78BD,
$78BF,$78C0,$78C2,$78C3,$78C4,$78C6,$78C7,$78C8,$78CC,$78CD,$78CE,$78CF,$78D1,
$78D2,$78D3,$78D6,$78D7,$78D8,$78DA,$78DB,$78DC,$78DD,$78DE,$78DF,$78E0,$78E1,
$78E2,$78E3,$78E4,$78E5,$78E6,$78E7,$78E9,$78EA,$78EB,$78ED,$78EE,$78EF,$78F0,
$78F1,$78F3,$78F5,$78F6,$78F8,$78F9,$78FB,$78FC,$78FD,$78FE,$78FF,$7900,$7902,
$7903,$7904,$7906,$7907,$7908,$7909,$790A,$790B,$790C,$7840,$50A8,$77D7,$6410,
$89E6,$5904,$63E3,$5DDD,$7A7F,$693D,$4F20,$8239,$5598,$4E32,$75AE,$7A97,$5E62,
$5E8A,$95EF,$521B,$5439,$708A,$6376,$9524,$5782,$6625,$693F,$9187,$5507,$6DF3,
$7EAF,$8822,$6233,$7EF0,$75B5,$8328,$78C1,$96CC,$8F9E,$6148,$74F7,$8BCD,$6B64,
$523A,$8D50,$6B21,$806A,$8471,$56F1,$5306,$4ECE,$4E1B,$51D1,$7C97,$918B,$7C07,
$4FC3,$8E7F,$7BE1,$7A9C,$6467,$5D14,$50AC,$8106,$7601,$7CB9,$6DEC,$7FE0,$6751,
$5B58,$5BF8,$78CB,$64AE,$6413,$63AA,$632B,$9519,$642D,$8FBE,$7B54,$7629,$6253,
$5927,$5446,$6B79,$50A3,$6234,$5E26,$6B86,$4EE3,$8D37,$888B,$5F85,$902E,$790D,
$790E,$790F,$7910,$7911,$7912,$7914,$7915,$7916,$7917,$7918,$7919,$791A,$791B,
$791C,$791D,$791F,$7920,$7921,$7922,$7923,$7925,$7926,$7927,$7928,$7929,$792A,
$792B,$792C,$792D,$792E,$792F,$7930,$7931,$7932,$7933,$7935,$7936,$7937,$7938,
$7939,$793D,$793F,$7942,$7943,$7944,$7945,$7947,$794A,$794B,$794C,$794D,$794E,
$794F,$7950,$7951,$7952,$7954,$7955,$7958,$7959,$7961,$7963,$7964,$7966,$7969,
$796A,$796B,$796C,$796E,$7970,$7971,$7972,$7973,$7974,$7975,$7976,$7979,$797B,
$797C,$797D,$797E,$797F,$7982,$7983,$7986,$7987,$7988,$7989,$798B,$798C,$798D,
$798E,$7990,$7991,$7992,$6020,$803D,$62C5,$4E39,$5355,$90F8,$63B8,$80C6,$65E6,
$6C2E,$4F46,$60EE,$6DE1,$8BDE,$5F39,$86CB,$5F53,$6321,$515A,$8361,$6863,$5200,
$6363,$8E48,$5012,$5C9B,$7977,$5BFC,$5230,$7A3B,$60BC,$9053,$76D7,$5FB7,$5F97,
$7684,$8E6C,$706F,$767B,$7B49,$77AA,$51F3,$9093,$5824,$4F4E,$6EF4,$8FEA,$654C,
$7B1B,$72C4,$6DA4,$7FDF,$5AE1,$62B5,$5E95,$5730,$8482,$7B2C,$5E1D,$5F1F,$9012,
$7F14,$98A0,$6382,$6EC7,$7898,$70B9,$5178,$975B,$57AB,$7535,$4F43,$7538,$5E97,
$60E6,$5960,$6DC0,$6BBF,$7889,$53FC,$96D5,$51CB,$5201,$6389,$540A,$9493,$8C03,
$8DCC,$7239,$789F,$8776,$8FED,$8C0D,$53E0,$7993,$7994,$7995,$7996,$7997,$7998,
$7999,$799B,$799C,$799D,$799E,$799F,$79A0,$79A1,$79A2,$79A3,$79A4,$79A5,$79A6,
$79A8,$79A9,$79AA,$79AB,$79AC,$79AD,$79AE,$79AF,$79B0,$79B1,$79B2,$79B4,$79B5,
$79B6,$79B7,$79B8,$79BC,$79BF,$79C2,$79C4,$79C5,$79C7,$79C8,$79CA,$79CC,$79CE,
$79CF,$79D0,$79D3,$79D4,$79D6,$79D7,$79D9,$79DA,$79DB,$79DC,$79DD,$79DE,$79E0,
$79E1,$79E2,$79E5,$79E8,$79EA,$79EC,$79EE,$79F1,$79F2,$79F3,$79F4,$79F5,$79F6,
$79F7,$79F9,$79FA,$79FC,$79FE,$79FF,$7A01,$7A04,$7A05,$7A07,$7A08,$7A09,$7A0A,
$7A0C,$7A0F,$7A10,$7A11,$7A12,$7A13,$7A15,$7A16,$7A18,$7A19,$7A1B,$7A1C,$4E01,
$76EF,$53EE,$9489,$9876,$9F0E,$952D,$5B9A,$8BA2,$4E22,$4E1C,$51AC,$8463,$61C2,
$52A8,$680B,$4F97,$606B,$51BB,$6D1E,$515C,$6296,$6597,$9661,$8C46,$9017,$75D8,
$90FD,$7763,$6BD2,$728A,$72EC,$8BFB,$5835,$7779,$8D4C,$675C,$9540,$809A,$5EA6,
$6E21,$5992,$7AEF,$77ED,$953B,$6BB5,$65AD,$7F0E,$5806,$5151,$961F,$5BF9,$58A9,
$5428,$8E72,$6566,$987F,$56E4,$949D,$76FE,$9041,$6387,$54C6,$591A,$593A,$579B,
$8EB2,$6735,$8DFA,$8235,$5241,$60F0,$5815,$86FE,$5CE8,$9E45,$4FC4,$989D,$8BB9,
$5A25,$6076,$5384,$627C,$904F,$9102,$997F,$6069,$800C,$513F,$8033,$5C14,$9975,
$6D31,$4E8C,$7A1D,$7A1F,$7A21,$7A22,$7A24,$7A25,$7A26,$7A27,$7A28,$7A29,$7A2A,
$7A2B,$7A2C,$7A2D,$7A2E,$7A2F,$7A30,$7A31,$7A32,$7A34,$7A35,$7A36,$7A38,$7A3A,
$7A3E,$7A40,$7A41,$7A42,$7A43,$7A44,$7A45,$7A47,$7A48,$7A49,$7A4A,$7A4B,$7A4C,
$7A4D,$7A4E,$7A4F,$7A50,$7A52,$7A53,$7A54,$7A55,$7A56,$7A58,$7A59,$7A5A,$7A5B,
$7A5C,$7A5D,$7A5E,$7A5F,$7A60,$7A61,$7A62,$7A63,$7A64,$7A65,$7A66,$7A67,$7A68,
$7A69,$7A6A,$7A6B,$7A6C,$7A6D,$7A6E,$7A6F,$7A71,$7A72,$7A73,$7A75,$7A7B,$7A7C,
$7A7D,$7A7E,$7A82,$7A85,$7A87,$7A89,$7A8A,$7A8B,$7A8C,$7A8E,$7A8F,$7A90,$7A93,
$7A94,$7A99,$7A9A,$7A9B,$7A9E,$7AA1,$7AA2,$8D30,$53D1,$7F5A,$7B4F,$4F10,$4E4F,
$9600,$6CD5,$73D0,$85E9,$5E06,$756A,$7FFB,$6A0A,$77FE,$9492,$7E41,$51E1,$70E6,
$53CD,$8FD4,$8303,$8D29,$72AF,$996D,$6CDB,$574A,$82B3,$65B9,$80AA,$623F,$9632,
$59A8,$4EFF,$8BBF,$7EBA,$653E,$83F2,$975E,$5561,$98DE,$80A5,$532A,$8BFD,$5420,
$80BA,$5E9F,$6CB8,$8D39,$82AC,$915A,$5429,$6C1B,$5206,$7EB7,$575F,$711A,$6C7E,
$7C89,$594B,$4EFD,$5FFF,$6124,$7CAA,$4E30,$5C01,$67AB,$8702,$5CF0,$950B,$98CE,
$75AF,$70FD,$9022,$51AF,$7F1D,$8BBD,$5949,$51E4,$4F5B,$5426,$592B,$6577,$80A4,
$5B75,$6276,$62C2,$8F90,$5E45,$6C1F,$7B26,$4F0F,$4FD8,$670D,$7AA3,$7AA4,$7AA7,
$7AA9,$7AAA,$7AAB,$7AAE,$7AAF,$7AB0,$7AB1,$7AB2,$7AB4,$7AB5,$7AB6,$7AB7,$7AB8,
$7AB9,$7ABA,$7ABB,$7ABC,$7ABD,$7ABE,$7AC0,$7AC1,$7AC2,$7AC3,$7AC4,$7AC5,$7AC6,
$7AC7,$7AC8,$7AC9,$7ACA,$7ACC,$7ACD,$7ACE,$7ACF,$7AD0,$7AD1,$7AD2,$7AD3,$7AD4,
$7AD5,$7AD7,$7AD8,$7ADA,$7ADB,$7ADC,$7ADD,$7AE1,$7AE2,$7AE4,$7AE7,$7AE8,$7AE9,
$7AEA,$7AEB,$7AEC,$7AEE,$7AF0,$7AF1,$7AF2,$7AF3,$7AF4,$7AF5,$7AF6,$7AF7,$7AF8,
$7AFB,$7AFC,$7AFE,$7B00,$7B01,$7B02,$7B05,$7B07,$7B09,$7B0C,$7B0D,$7B0E,$7B10,
$7B12,$7B13,$7B16,$7B17,$7B18,$7B1A,$7B1C,$7B1D,$7B1F,$7B21,$7B22,$7B23,$7B27,
$7B29,$7B2D,$6D6E,$6DAA,$798F,$88B1,$5F17,$752B,$629A,$8F85,$4FEF,$91DC,$65A7,
$812F,$8151,$5E9C,$8150,$8D74,$526F,$8986,$8D4B,$590D,$5085,$4ED8,$961C,$7236,
$8179,$8D1F,$5BCC,$8BA3,$9644,$5987,$7F1A,$5490,$5676,$560E,$8BE5,$6539,$6982,
$9499,$76D6,$6E89,$5E72,$7518,$6746,$67D1,$7AFF,$809D,$8D76,$611F,$79C6,$6562,
$8D63,$5188,$521A,$94A2,$7F38,$809B,$7EB2,$5C97,$6E2F,$6760,$7BD9,$768B,$9AD8,
$818F,$7F94,$7CD5,$641E,$9550,$7A3F,$544A,$54E5,$6B4C,$6401,$6208,$9E3D,$80F3,
$7599,$5272,$9769,$845B,$683C,$86E4,$9601,$9694,$94EC,$4E2A,$5404,$7ED9,$6839,
$8DDF,$8015,$66F4,$5E9A,$7FB9,$7B2F,$7B30,$7B32,$7B34,$7B35,$7B36,$7B37,$7B39,
$7B3B,$7B3D,$7B3F,$7B40,$7B41,$7B42,$7B43,$7B44,$7B46,$7B48,$7B4A,$7B4D,$7B4E,
$7B53,$7B55,$7B57,$7B59,$7B5C,$7B5E,$7B5F,$7B61,$7B63,$7B64,$7B65,$7B66,$7B67,
$7B68,$7B69,$7B6A,$7B6B,$7B6C,$7B6D,$7B6F,$7B70,$7B73,$7B74,$7B76,$7B78,$7B7A,
$7B7C,$7B7D,$7B7F,$7B81,$7B82,$7B83,$7B84,$7B86,$7B87,$7B88,$7B89,$7B8A,$7B8B,
$7B8C,$7B8E,$7B8F,$7B91,$7B92,$7B93,$7B96,$7B98,$7B99,$7B9A,$7B9B,$7B9E,$7B9F,
$7BA0,$7BA3,$7BA4,$7BA5,$7BAE,$7BAF,$7BB0,$7BB2,$7BB3,$7BB5,$7BB6,$7BB7,$7BB9,
$7BBA,$7BBB,$7BBC,$7BBD,$7BBE,$7BBF,$7BC0,$7BC2,$7BC3,$7BC4,$57C2,$803F,$6897,
$5DE5,$653B,$529F,$606D,$9F9A,$4F9B,$8EAC,$516C,$5BAB,$5F13,$5DE9,$6C5E,$62F1,
$8D21,$5171,$94A9,$52FE,$6C9F,$82DF,$72D7,$57A2,$6784,$8D2D,$591F,$8F9C,$83C7,
$5495,$7B8D,$4F30,$6CBD,$5B64,$59D1,$9F13,$53E4,$86CA,$9AA8,$8C37,$80A1,$6545,
$987E,$56FA,$96C7,$522E,$74DC,$5250,$5BE1,$6302,$8902,$4E56,$62D0,$602A,$68FA,
$5173,$5B98,$51A0,$89C2,$7BA1,$9986,$7F50,$60EF,$704C,$8D2F,$5149,$5E7F,$901B,
$7470,$89C4,$572D,$7845,$5F52,$9F9F,$95FA,$8F68,$9B3C,$8BE1,$7678,$6842,$67DC,
$8DEA,$8D35,$523D,$8F8A,$6EDA,$68CD,$9505,$90ED,$56FD,$679C,$88F9,$8FC7,$54C8,
$7BC5,$7BC8,$7BC9,$7BCA,$7BCB,$7BCD,$7BCE,$7BCF,$7BD0,$7BD2,$7BD4,$7BD5,$7BD6,
$7BD7,$7BD8,$7BDB,$7BDC,$7BDE,$7BDF,$7BE0,$7BE2,$7BE3,$7BE4,$7BE7,$7BE8,$7BE9,
$7BEB,$7BEC,$7BED,$7BEF,$7BF0,$7BF2,$7BF3,$7BF4,$7BF5,$7BF6,$7BF8,$7BF9,$7BFA,
$7BFB,$7BFD,$7BFF,$7C00,$7C01,$7C02,$7C03,$7C04,$7C05,$7C06,$7C08,$7C09,$7C0A,
$7C0D,$7C0E,$7C10,$7C11,$7C12,$7C13,$7C14,$7C15,$7C17,$7C18,$7C19,$7C1A,$7C1B,
$7C1C,$7C1D,$7C1E,$7C20,$7C21,$7C22,$7C23,$7C24,$7C25,$7C28,$7C29,$7C2B,$7C2C,
$7C2D,$7C2E,$7C2F,$7C30,$7C31,$7C32,$7C33,$7C34,$7C35,$7C36,$7C37,$7C39,$7C3A,
$7C3B,$7C3C,$7C3D,$7C3E,$7C42,$9AB8,$5B69,$6D77,$6C26,$4EA5,$5BB3,$9A87,$9163,
$61A8,$90AF,$97E9,$542B,$6DB5,$5BD2,$51FD,$558A,$7F55,$7FF0,$64BC,$634D,$65F1,
$61BE,$608D,$710A,$6C57,$6C49,$592F,$676D,$822A,$58D5,$568E,$8C6A,$6BEB,$90DD,
$597D,$8017,$53F7,$6D69,$5475,$559D,$8377,$83CF,$6838,$79BE,$548C,$4F55,$5408,
$76D2,$8C89,$9602,$6CB3,$6DB8,$8D6B,$8910,$9E64,$8D3A,$563F,$9ED1,$75D5,$5F88,
$72E0,$6068,$54FC,$4EA8,$6A2A,$8861,$6052,$8F70,$54C4,$70D8,$8679,$9E3F,$6D2A,
$5B8F,$5F18,$7EA2,$5589,$4FAF,$7334,$543C,$539A,$5019,$540E,$547C,$4E4E,$5FFD,
$745A,$58F6,$846B,$80E1,$8774,$72D0,$7CCA,$6E56,$7C43,$7C44,$7C45,$7C46,$7C47,
$7C48,$7C49,$7C4A,$7C4B,$7C4C,$7C4E,$7C4F,$7C50,$7C51,$7C52,$7C53,$7C54,$7C55,
$7C56,$7C57,$7C58,$7C59,$7C5A,$7C5B,$7C5C,$7C5D,$7C5E,$7C5F,$7C60,$7C61,$7C62,
$7C63,$7C64,$7C65,$7C66,$7C67,$7C68,$7C69,$7C6A,$7C6B,$7C6C,$7C6D,$7C6E,$7C6F,
$7C70,$7C71,$7C72,$7C75,$7C76,$7C77,$7C78,$7C79,$7C7A,$7C7E,$7C7F,$7C80,$7C81,
$7C82,$7C83,$7C84,$7C85,$7C86,$7C87,$7C88,$7C8A,$7C8B,$7C8C,$7C8D,$7C8E,$7C8F,
$7C90,$7C93,$7C94,$7C96,$7C99,$7C9A,$7C9B,$7CA0,$7CA1,$7CA3,$7CA6,$7CA7,$7CA8,
$7CA9,$7CAB,$7CAC,$7CAD,$7CAF,$7CB0,$7CB4,$7CB5,$7CB6,$7CB7,$7CB8,$7CBA,$7CBB,
$5F27,$864E,$552C,$62A4,$4E92,$6CAA,$6237,$82B1,$54D7,$534E,$733E,$6ED1,$753B,
$5212,$5316,$8BDD,$69D0,$5F8A,$6000,$6DEE,$574F,$6B22,$73AF,$6853,$8FD8,$7F13,
$6362,$60A3,$5524,$75EA,$8C62,$7115,$6DA3,$5BA6,$5E7B,$8352,$614C,$9EC4,$78FA,
$8757,$7C27,$7687,$51F0,$60F6,$714C,$6643,$5E4C,$604D,$8C0E,$7070,$6325,$8F89,
$5FBD,$6062,$86D4,$56DE,$6BC1,$6094,$6167,$5349,$60E0,$6666,$8D3F,$79FD,$4F1A,
$70E9,$6C47,$8BB3,$8BF2,$7ED8,$8364,$660F,$5A5A,$9B42,$6D51,$6DF7,$8C41,$6D3B,
$4F19,$706B,$83B7,$6216,$60D1,$970D,$8D27,$7978,$51FB,$573E,$57FA,$673A,$7578,
$7A3D,$79EF,$7B95,$7CBF,$7CC0,$7CC2,$7CC3,$7CC4,$7CC6,$7CC9,$7CCB,$7CCE,$7CCF,
$7CD0,$7CD1,$7CD2,$7CD3,$7CD4,$7CD8,$7CDA,$7CDB,$7CDD,$7CDE,$7CE1,$7CE2,$7CE3,
$7CE4,$7CE5,$7CE6,$7CE7,$7CE9,$7CEA,$7CEB,$7CEC,$7CED,$7CEE,$7CF0,$7CF1,$7CF2,
$7CF3,$7CF4,$7CF5,$7CF6,$7CF7,$7CF9,$7CFA,$7CFC,$7CFD,$7CFE,$7CFF,$7D00,$7D01,
$7D02,$7D03,$7D04,$7D05,$7D06,$7D07,$7D08,$7D09,$7D0B,$7D0C,$7D0D,$7D0E,$7D0F,
$7D10,$7D11,$7D12,$7D13,$7D14,$7D15,$7D16,$7D17,$7D18,$7D19,$7D1A,$7D1B,$7D1C,
$7D1D,$7D1E,$7D1F,$7D21,$7D23,$7D24,$7D25,$7D26,$7D28,$7D29,$7D2A,$7D2C,$7D2D,
$7D2E,$7D30,$7D31,$7D32,$7D33,$7D34,$7D35,$7D36,$808C,$9965,$8FF9,$6FC0,$8BA5,
$9E21,$59EC,$7EE9,$7F09,$5409,$6781,$68D8,$8F91,$7C4D,$96C6,$53CA,$6025,$75BE,
$6C72,$5373,$5AC9,$7EA7,$6324,$51E0,$810A,$5DF1,$84DF,$6280,$5180,$5B63,$4F0E,
$796D,$5242,$60B8,$6D4E,$5BC4,$5BC2,$8BA1,$8BB0,$65E2,$5FCC,$9645,$5993,$7EE7,
$7EAA,$5609,$67B7,$5939,$4F73,$5BB6,$52A0,$835A,$988A,$8D3E,$7532,$94BE,$5047,
$7A3C,$4EF7,$67B6,$9A7E,$5AC1,$6B7C,$76D1,$575A,$5C16,$7B3A,$95F4,$714E,$517C,
$80A9,$8270,$5978,$7F04,$8327,$68C0,$67EC,$78B1,$7877,$62E3,$6361,$7B80,$4FED,
$526A,$51CF,$8350,$69DB,$9274,$8DF5,$8D31,$89C1,$952E,$7BAD,$4EF6,$7D37,$7D38,
$7D39,$7D3A,$7D3B,$7D3C,$7D3D,$7D3E,$7D3F,$7D40,$7D41,$7D42,$7D43,$7D44,$7D45,
$7D46,$7D47,$7D48,$7D49,$7D4A,$7D4B,$7D4C,$7D4D,$7D4E,$7D4F,$7D50,$7D51,$7D52,
$7D53,$7D54,$7D55,$7D56,$7D57,$7D58,$7D59,$7D5A,$7D5B,$7D5C,$7D5D,$7D5E,$7D5F,
$7D60,$7D61,$7D62,$7D63,$7D64,$7D65,$7D66,$7D67,$7D68,$7D69,$7D6A,$7D6B,$7D6C,
$7D6D,$7D6F,$7D70,$7D71,$7D72,$7D73,$7D74,$7D75,$7D76,$7D78,$7D79,$7D7A,$7D7B,
$7D7C,$7D7D,$7D7E,$7D7F,$7D80,$7D81,$7D82,$7D83,$7D84,$7D85,$7D86,$7D87,$7D88,
$7D89,$7D8A,$7D8B,$7D8C,$7D8D,$7D8E,$7D8F,$7D90,$7D91,$7D92,$7D93,$7D94,$7D95,
$7D96,$7D97,$7D98,$5065,$8230,$5251,$996F,$6E10,$6E85,$6DA7,$5EFA,$50F5,$59DC,
$5C06,$6D46,$6C5F,$7586,$848B,$6868,$5956,$8BB2,$5320,$9171,$964D,$8549,$6912,
$7901,$7126,$80F6,$4EA4,$90CA,$6D47,$9A84,$5A07,$56BC,$6405,$94F0,$77EB,$4FA5,
$811A,$72E1,$89D2,$997A,$7F34,$7EDE,$527F,$6559,$9175,$8F7F,$8F83,$53EB,$7A96,
$63ED,$63A5,$7686,$79F8,$8857,$9636,$622A,$52AB,$8282,$6854,$6770,$6377,$776B,
$7AED,$6D01,$7ED3,$89E3,$59D0,$6212,$85C9,$82A5,$754C,$501F,$4ECB,$75A5,$8BEB,
$5C4A,$5DFE,$7B4B,$65A4,$91D1,$4ECA,$6D25,$895F,$7D27,$9526,$4EC5,$8C28,$8FDB,
$9773,$664B,$7981,$8FD1,$70EC,$6D78,$7D99,$7D9A,$7D9B,$7D9C,$7D9D,$7D9E,$7D9F,
$7DA0,$7DA1,$7DA2,$7DA3,$7DA4,$7DA5,$7DA7,$7DA8,$7DA9,$7DAA,$7DAB,$7DAC,$7DAD,
$7DAF,$7DB0,$7DB1,$7DB2,$7DB3,$7DB4,$7DB5,$7DB6,$7DB7,$7DB8,$7DB9,$7DBA,$7DBB,
$7DBC,$7DBD,$7DBE,$7DBF,$7DC0,$7DC1,$7DC2,$7DC3,$7DC4,$7DC5,$7DC6,$7DC7,$7DC8,
$7DC9,$7DCA,$7DCB,$7DCC,$7DCD,$7DCE,$7DCF,$7DD0,$7DD1,$7DD2,$7DD3,$7DD4,$7DD5,
$7DD6,$7DD7,$7DD8,$7DD9,$7DDA,$7DDB,$7DDC,$7DDD,$7DDE,$7DDF,$7DE0,$7DE1,$7DE2,
$7DE3,$7DE4,$7DE5,$7DE6,$7DE7,$7DE8,$7DE9,$7DEA,$7DEB,$7DEC,$7DED,$7DEE,$7DEF,
$7DF0,$7DF1,$7DF2,$7DF3,$7DF4,$7DF5,$7DF6,$7DF7,$7DF8,$7DF9,$7DFA,$5C3D,$52B2,
$8346,$5162,$830E,$775B,$6676,$9CB8,$4EAC,$60CA,$7CBE,$7CB3,$7ECF,$4E95,$8B66,
$666F,$9888,$9759,$5883,$656C,$955C,$5F84,$75C9,$9756,$7ADF,$7ADE,$51C0,$70AF,
$7A98,$63EA,$7A76,$7EA0,$7396,$97ED,$4E45,$7078,$4E5D,$9152,$53A9,$6551,$65E7,
$81FC,$8205,$548E,$5C31,$759A,$97A0,$62D8,$72D9,$75BD,$5C45,$9A79,$83CA,$5C40,
$5480,$77E9,$4E3E,$6CAE,$805A,$62D2,$636E,$5DE8,$5177,$8DDD,$8E1E,$952F,$4FF1,
$53E5,$60E7,$70AC,$5267,$6350,$9E43,$5A1F,$5026,$7737,$5377,$7EE2,$6485,$652B,
$6289,$6398,$5014,$7235,$89C9,$51B3,$8BC0,$7EDD,$5747,$83CC,$94A7,$519B,$541B,
$5CFB,$7DFB,$7DFC,$7DFD,$7DFE,$7DFF,$7E00,$7E01,$7E02,$7E03,$7E04,$7E05,$7E06,
$7E07,$7E08,$7E09,$7E0A,$7E0B,$7E0C,$7E0D,$7E0E,$7E0F,$7E10,$7E11,$7E12,$7E13,
$7E14,$7E15,$7E16,$7E17,$7E18,$7E19,$7E1A,$7E1B,$7E1C,$7E1D,$7E1E,$7E1F,$7E20,
$7E21,$7E22,$7E23,$7E24,$7E25,$7E26,$7E27,$7E28,$7E29,$7E2A,$7E2B,$7E2C,$7E2D,
$7E2E,$7E2F,$7E30,$7E31,$7E32,$7E33,$7E34,$7E35,$7E36,$7E37,$7E38,$7E39,$7E3A,
$7E3C,$7E3D,$7E3E,$7E3F,$7E40,$7E42,$7E43,$7E44,$7E45,$7E46,$7E48,$7E49,$7E4A,
$7E4B,$7E4C,$7E4D,$7E4E,$7E4F,$7E50,$7E51,$7E52,$7E53,$7E54,$7E55,$7E56,$7E57,
$7E58,$7E59,$7E5A,$7E5B,$7E5C,$7E5D,$4FCA,$7AE3,$6D5A,$90E1,$9A8F,$5580,$5496,
$5361,$54AF,$5F00,$63E9,$6977,$51EF,$6168,$520A,$582A,$52D8,$574E,$780D,$770B,
$5EB7,$6177,$7CE0,$625B,$6297,$4EA2,$7095,$8003,$62F7,$70E4,$9760,$5777,$82DB,
$67EF,$68F5,$78D5,$9897,$79D1,$58F3,$54B3,$53EF,$6E34,$514B,$523B,$5BA2,$8BFE,
$80AF,$5543,$57A6,$6073,$5751,$542D,$7A7A,$6050,$5B54,$63A7,$62A0,$53E3,$6263,
$5BC7,$67AF,$54ED,$7A9F,$82E6,$9177,$5E93,$88E4,$5938,$57AE,$630E,$8DE8,$80EF,
$5757,$7B77,$4FA9,$5FEB,$5BBD,$6B3E,$5321,$7B50,$72C2,$6846,$77FF,$7736,$65F7,
$51B5,$4E8F,$76D4,$5CBF,$7AA5,$8475,$594E,$9B41,$5080,$7E5E,$7E5F,$7E60,$7E61,
$7E62,$7E63,$7E64,$7E65,$7E66,$7E67,$7E68,$7E69,$7E6A,$7E6B,$7E6C,$7E6D,$7E6E,
$7E6F,$7E70,$7E71,$7E72,$7E73,$7E74,$7E75,$7E76,$7E77,$7E78,$7E79,$7E7A,$7E7B,
$7E7C,$7E7D,$7E7E,$7E7F,$7E80,$7E81,$7E83,$7E84,$7E85,$7E86,$7E87,$7E88,$7E89,
$7E8A,$7E8B,$7E8C,$7E8D,$7E8E,$7E8F,$7E90,$7E91,$7E92,$7E93,$7E94,$7E95,$7E96,
$7E97,$7E98,$7E99,$7E9A,$7E9C,$7E9D,$7E9E,$7EAE,$7EB4,$7EBB,$7EBC,$7ED6,$7EE4,
$7EEC,$7EF9,$7F0A,$7F10,$7F1E,$7F37,$7F39,$7F3B,$7F3C,$7F3D,$7F3E,$7F3F,$7F40,
$7F41,$7F43,$7F46,$7F47,$7F48,$7F49,$7F4A,$7F4B,$7F4C,$7F4D,$7F4E,$7F4F,$7F52,
$7F53,$9988,$6127,$6E83,$5764,$6606,$6346,$56F0,$62EC,$6269,$5ED3,$9614,$5783,
$62C9,$5587,$8721,$814A,$8FA3,$5566,$83B1,$6765,$8D56,$84DD,$5A6A,$680F,$62E6,
$7BEE,$9611,$5170,$6F9C,$8C30,$63FD,$89C8,$61D2,$7F06,$70C2,$6EE5,$7405,$6994,
$72FC,$5ECA,$90CE,$6717,$6D6A,$635E,$52B3,$7262,$8001,$4F6C,$59E5,$916A,$70D9,
$6D9D,$52D2,$4E50,$96F7,$956D,$857E,$78CA,$7D2F,$5121,$5792,$64C2,$808B,$7C7B,
$6CEA,$68F1,$695E,$51B7,$5398,$68A8,$7281,$9ECE,$7BF1,$72F8,$79BB,$6F13,$7406,
$674E,$91CC,$9CA4,$793C,$8389,$8354,$540F,$6817,$4E3D,$5389,$52B1,$783E,$5386,
$5229,$5088,$4F8B,$4FD0,$7F56,$7F59,$7F5B,$7F5C,$7F5D,$7F5E,$7F60,$7F63,$7F64,
$7F65,$7F66,$7F67,$7F6B,$7F6C,$7F6D,$7F6F,$7F70,$7F73,$7F75,$7F76,$7F77,$7F78,
$7F7A,$7F7B,$7F7C,$7F7D,$7F7F,$7F80,$7F82,$7F83,$7F84,$7F85,$7F86,$7F87,$7F88,
$7F89,$7F8B,$7F8D,$7F8F,$7F90,$7F91,$7F92,$7F93,$7F95,$7F96,$7F97,$7F98,$7F99,
$7F9B,$7F9C,$7FA0,$7FA2,$7FA3,$7FA5,$7FA6,$7FA8,$7FA9,$7FAA,$7FAB,$7FAC,$7FAD,
$7FAE,$7FB1,$7FB3,$7FB4,$7FB5,$7FB6,$7FB7,$7FBA,$7FBB,$7FBE,$7FC0,$7FC2,$7FC3,
$7FC4,$7FC6,$7FC7,$7FC8,$7FC9,$7FCB,$7FCD,$7FCF,$7FD0,$7FD1,$7FD2,$7FD3,$7FD6,
$7FD7,$7FD9,$7FDA,$7FDB,$7FDC,$7FDD,$7FDE,$7FE2,$7FE3,$75E2,$7ACB,$7C92,$6CA5,
$96B6,$529B,$7483,$54E9,$4FE9,$8054,$83B2,$8FDE,$9570,$5EC9,$601C,$6D9F,$5E18,
$655B,$8138,$94FE,$604B,$70BC,$7EC3,$7CAE,$51C9,$6881,$7CB1,$826F,$4E24,$8F86,
$91CF,$667E,$4EAE,$8C05,$64A9,$804A,$50DA,$7597,$71CE,$5BE5,$8FBD,$6F66,$4E86,
$6482,$9563,$5ED6,$6599,$5217,$88C2,$70C8,$52A3,$730E,$7433,$6797,$78F7,$9716,
$4E34,$90BB,$9CDE,$6DCB,$51DB,$8D41,$541D,$62CE,$73B2,$83F1,$96F6,$9F84,$94C3,
$4F36,$7F9A,$51CC,$7075,$9675,$5CAD,$9886,$53E6,$4EE4,$6E9C,$7409,$69B4,$786B,
$998F,$7559,$5218,$7624,$6D41,$67F3,$516D,$9F99,$804B,$5499,$7B3C,$7ABF,$7FE4,
$7FE7,$7FE8,$7FEA,$7FEB,$7FEC,$7FED,$7FEF,$7FF2,$7FF4,$7FF5,$7FF6,$7FF7,$7FF8,
$7FF9,$7FFA,$7FFD,$7FFE,$7FFF,$8002,$8007,$8008,$8009,$800A,$800E,$800F,$8011,
$8013,$801A,$801B,$801D,$801E,$801F,$8021,$8023,$8024,$802B,$802C,$802D,$802E,
$802F,$8030,$8032,$8034,$8039,$803A,$803C,$803E,$8040,$8041,$8044,$8045,$8047,
$8048,$8049,$804E,$804F,$8050,$8051,$8053,$8055,$8056,$8057,$8059,$805B,$805C,
$805D,$805E,$805F,$8060,$8061,$8062,$8063,$8064,$8065,$8066,$8067,$8068,$806B,
$806C,$806D,$806E,$806F,$8070,$8072,$8073,$8074,$8075,$8076,$8077,$8078,$8079,
$807A,$807B,$807C,$807D,$9686,$5784,$62E2,$9647,$697C,$5A04,$6402,$7BD3,$6F0F,
$964B,$82A6,$5362,$9885,$5E90,$7089,$63B3,$5364,$864F,$9C81,$9E93,$788C,$9732,
$8DEF,$8D42,$9E7F,$6F5E,$7984,$5F55,$9646,$622E,$9A74,$5415,$94DD,$4FA3,$65C5,
$5C65,$5C61,$7F15,$8651,$6C2F,$5F8B,$7387,$6EE4,$7EFF,$5CE6,$631B,$5B6A,$6EE6,
$5375,$4E71,$63A0,$7565,$62A1,$8F6E,$4F26,$4ED1,$6CA6,$7EB6,$8BBA,$841D,$87BA,
$7F57,$903B,$9523,$7BA9,$9AA1,$88F8,$843D,$6D1B,$9A86,$7EDC,$5988,$9EBB,$739B,
$7801,$8682,$9A6C,$9A82,$561B,$5417,$57CB,$4E70,$9EA6,$5356,$8FC8,$8109,$7792,
$9992,$86EE,$6EE1,$8513,$66FC,$6162,$6F2B,$807E,$8081,$8082,$8085,$8088,$808A,
$808D,$808E,$808F,$8090,$8091,$8092,$8094,$8095,$8097,$8099,$809E,$80A3,$80A6,
$80A7,$80A8,$80AC,$80B0,$80B3,$80B5,$80B6,$80B8,$80B9,$80BB,$80C5,$80C7,$80C8,
$80C9,$80CA,$80CB,$80CF,$80D0,$80D1,$80D2,$80D3,$80D4,$80D5,$80D8,$80DF,$80E0,
$80E2,$80E3,$80E6,$80EE,$80F5,$80F7,$80F9,$80FB,$80FE,$80FF,$8100,$8101,$8103,
$8104,$8105,$8107,$8108,$810B,$810C,$8115,$8117,$8119,$811B,$811C,$811D,$811F,
$8120,$8121,$8122,$8123,$8124,$8125,$8126,$8127,$8128,$8129,$812A,$812B,$812D,
$812E,$8130,$8133,$8134,$8135,$8137,$8139,$813A,$813B,$813C,$813D,$813F,$8C29,
$8292,$832B,$76F2,$6C13,$5FD9,$83BD,$732B,$8305,$951A,$6BDB,$77DB,$94C6,$536F,
$8302,$5192,$5E3D,$8C8C,$8D38,$4E48,$73AB,$679A,$6885,$9176,$9709,$7164,$6CA1,
$7709,$5A92,$9541,$6BCF,$7F8E,$6627,$5BD0,$59B9,$5A9A,$95E8,$95F7,$4EEC,$840C,
$8499,$6AAC,$76DF,$9530,$731B,$68A6,$5B5F,$772F,$919A,$9761,$7CDC,$8FF7,$8C1C,
$5F25,$7C73,$79D8,$89C5,$6CCC,$871C,$5BC6,$5E42,$68C9,$7720,$7EF5,$5195,$514D,
$52C9,$5A29,$7F05,$9762,$82D7,$63CF,$7784,$85D0,$79D2,$6E3A,$5E99,$5999,$8511,
$706D,$6C11,$62BF,$76BF,$654F,$60AF,$95FD,$660E,$879F,$9E23,$94ED,$540D,$547D,
$8C2C,$6478,$8140,$8141,$8142,$8143,$8144,$8145,$8147,$8149,$814D,$814E,$814F,
$8152,$8156,$8157,$8158,$815B,$815C,$815D,$815E,$815F,$8161,$8162,$8163,$8164,
$8166,$8168,$816A,$816B,$816C,$816F,$8172,$8173,$8175,$8176,$8177,$8178,$8181,
$8183,$8184,$8185,$8186,$8187,$8189,$818B,$818C,$818D,$818E,$8190,$8192,$8193,
$8194,$8195,$8196,$8197,$8199,$819A,$819E,$819F,$81A0,$81A1,$81A2,$81A4,$81A5,
$81A7,$81A9,$81AB,$81AC,$81AD,$81AE,$81AF,$81B0,$81B1,$81B2,$81B4,$81B5,$81B6,
$81B7,$81B8,$81B9,$81BC,$81BD,$81BE,$81BF,$81C4,$81C5,$81C7,$81C8,$81C9,$81CB,
$81CD,$81CE,$81CF,$81D0,$81D1,$81D2,$81D3,$6479,$8611,$6A21,$819C,$78E8,$6469,
$9B54,$62B9,$672B,$83AB,$58A8,$9ED8,$6CAB,$6F20,$5BDE,$964C,$8C0B,$725F,$67D0,
$62C7,$7261,$4EA9,$59C6,$6BCD,$5893,$66AE,$5E55,$52DF,$6155,$6728,$76EE,$7766,
$7267,$7A46,$62FF,$54EA,$5450,$94A0,$90A3,$5A1C,$7EB3,$6C16,$4E43,$5976,$8010,
$5948,$5357,$7537,$96BE,$56CA,$6320,$8111,$607C,$95F9,$6DD6,$5462,$9981,$5185,
$5AE9,$80FD,$59AE,$9713,$502A,$6CE5,$5C3C,$62DF,$4F60,$533F,$817B,$9006,$6EBA,
$852B,$62C8,$5E74,$78BE,$64B5,$637B,$5FF5,$5A18,$917F,$9E1F,$5C3F,$634F,$8042,
$5B7D,$556E,$954A,$954D,$6D85,$60A8,$67E0,$72DE,$51DD,$5B81,$81D4,$81D5,$81D6,
$81D7,$81D8,$81D9,$81DA,$81DB,$81DC,$81DD,$81DE,$81DF,$81E0,$81E1,$81E2,$81E4,
$81E5,$81E6,$81E8,$81E9,$81EB,$81EE,$81EF,$81F0,$81F1,$81F2,$81F5,$81F6,$81F7,
$81F8,$81F9,$81FA,$81FD,$81FF,$8203,$8207,$8208,$8209,$820A,$820B,$820E,$820F,
$8211,$8213,$8215,$8216,$8217,$8218,$8219,$821A,$821D,$8220,$8224,$8225,$8226,
$8227,$8229,$822E,$8232,$823A,$823C,$823D,$823F,$8240,$8241,$8242,$8243,$8245,
$8246,$8248,$824A,$824C,$824D,$824E,$8250,$8251,$8252,$8253,$8254,$8255,$8256,
$8257,$8259,$825B,$825C,$825D,$825E,$8260,$8261,$8262,$8263,$8264,$8265,$8266,
$8267,$8269,$62E7,$6CDE,$725B,$626D,$94AE,$7EBD,$8113,$6D53,$519C,$5F04,$5974,
$52AA,$6012,$5973,$6696,$8650,$759F,$632A,$61E6,$7CEF,$8BFA,$54E6,$6B27,$9E25,
$6BB4,$85D5,$5455,$5076,$6CA4,$556A,$8DB4,$722C,$5E15,$6015,$7436,$62CD,$6392,
$724C,$5F98,$6E43,$6D3E,$6500,$6F58,$76D8,$78D0,$76FC,$7554,$5224,$53DB,$4E53,
$5E9E,$65C1,$802A,$80D6,$629B,$5486,$5228,$70AE,$888D,$8DD1,$6CE1,$5478,$80DA,
$57F9,$88F4,$8D54,$966A,$914D,$4F69,$6C9B,$55B7,$76C6,$7830,$62A8,$70F9,$6F8E,
$5F6D,$84EC,$68DA,$787C,$7BF7,$81A8,$670B,$9E4F,$6367,$78B0,$576F,$7812,$9739,
$6279,$62AB,$5288,$7435,$6BD7,$826A,$826B,$826C,$826D,$8271,$8275,$8276,$8277,
$8278,$827B,$827C,$8280,$8281,$8283,$8285,$8286,$8287,$8289,$828C,$8290,$8293,
$8294,$8295,$8296,$829A,$829B,$829E,$82A0,$82A2,$82A3,$82A7,$82B2,$82B5,$82B6,
$82BA,$82BB,$82BC,$82BF,$82C0,$82C2,$82C3,$82C5,$82C6,$82C9,$82D0,$82D6,$82D9,
$82DA,$82DD,$82E2,$82E7,$82E8,$82E9,$82EA,$82EC,$82ED,$82EE,$82F0,$82F2,$82F3,
$82F5,$82F6,$82F8,$82FA,$82FC,$82FD,$82FE,$82FF,$8300,$830A,$830B,$830D,$8310,
$8312,$8313,$8316,$8318,$8319,$831D,$831E,$831F,$8320,$8321,$8322,$8323,$8324,
$8325,$8326,$8329,$832A,$832E,$8330,$8332,$8337,$833B,$833D,$5564,$813E,$75B2,
$76AE,$5339,$75DE,$50FB,$5C41,$8B6C,$7BC7,$504F,$7247,$9A97,$98D8,$6F02,$74E2,
$7968,$6487,$77A5,$62FC,$9891,$8D2B,$54C1,$8058,$4E52,$576A,$82F9,$840D,$5E73,
$51ED,$74F6,$8BC4,$5C4F,$5761,$6CFC,$9887,$5A46,$7834,$9B44,$8FEB,$7C95,$5256,
$6251,$94FA,$4EC6,$8386,$8461,$83E9,$84B2,$57D4,$6734,$5703,$666E,$6D66,$8C31,
$66DD,$7011,$671F,$6B3A,$6816,$621A,$59BB,$4E03,$51C4,$6F06,$67D2,$6C8F,$5176,
$68CB,$5947,$6B67,$7566,$5D0E,$8110,$9F50,$65D7,$7948,$7941,$9A91,$8D77,$5C82,
$4E5E,$4F01,$542F,$5951,$780C,$5668,$6C14,$8FC4,$5F03,$6C7D,$6CE3,$8BAB,$6390,
$833E,$833F,$8341,$8342,$8344,$8345,$8348,$834A,$834B,$834C,$834D,$834E,$8353,
$8355,$8356,$8357,$8358,$8359,$835D,$8362,$8370,$8371,$8372,$8373,$8374,$8375,
$8376,$8379,$837A,$837E,$837F,$8380,$8381,$8382,$8383,$8384,$8387,$8388,$838A,
$838B,$838C,$838D,$838F,$8390,$8391,$8394,$8395,$8396,$8397,$8399,$839A,$839D,
$839F,$83A1,$83A2,$83A3,$83A4,$83A5,$83A6,$83A7,$83AC,$83AD,$83AE,$83AF,$83B5,
$83BB,$83BE,$83BF,$83C2,$83C3,$83C4,$83C6,$83C8,$83C9,$83CB,$83CD,$83CE,$83D0,
$83D1,$83D2,$83D3,$83D5,$83D7,$83D9,$83DA,$83DB,$83DE,$83E2,$83E3,$83E4,$83E6,
$83E7,$83E8,$83EB,$83EC,$83ED,$6070,$6D3D,$7275,$6266,$948E,$94C5,$5343,$8FC1,
$7B7E,$4EDF,$8C26,$4E7E,$9ED4,$94B1,$94B3,$524D,$6F5C,$9063,$6D45,$8C34,$5811,
$5D4C,$6B20,$6B49,$67AA,$545B,$8154,$7F8C,$5899,$8537,$5F3A,$62A2,$6A47,$9539,
$6572,$6084,$6865,$77A7,$4E54,$4FA8,$5DE7,$9798,$64AC,$7FD8,$5CED,$4FCF,$7A8D,
$5207,$8304,$4E14,$602F,$7A83,$94A6,$4FB5,$4EB2,$79E6,$7434,$52E4,$82B9,$64D2,
$79BD,$5BDD,$6C81,$9752,$8F7B,$6C22,$503E,$537F,$6E05,$64CE,$6674,$6C30,$60C5,
$9877,$8BF7,$5E86,$743C,$7A77,$79CB,$4E18,$90B1,$7403,$6C42,$56DA,$914B,$6CC5,
$8D8B,$533A,$86C6,$66F2,$8EAF,$5C48,$9A71,$6E20,$83EE,$83EF,$83F3,$83F4,$83F5,
$83F6,$83F7,$83FA,$83FB,$83FC,$83FE,$83FF,$8400,$8402,$8405,$8407,$8408,$8409,
$840A,$8410,$8412,$8413,$8414,$8415,$8416,$8417,$8419,$841A,$841B,$841E,$841F,
$8420,$8421,$8422,$8423,$8429,$842A,$842B,$842C,$842D,$842E,$842F,$8430,$8432,
$8433,$8434,$8435,$8436,$8437,$8439,$843A,$843B,$843E,$843F,$8440,$8441,$8442,
$8443,$8444,$8445,$8447,$8448,$8449,$844A,$844B,$844C,$844D,$844E,$844F,$8450,
$8452,$8453,$8454,$8455,$8456,$8458,$845D,$845E,$845F,$8460,$8462,$8464,$8465,
$8466,$8467,$8468,$846A,$846E,$846F,$8470,$8472,$8474,$8477,$8479,$847B,$847C,
$53D6,$5A36,$9F8B,$8DA3,$53BB,$5708,$98A7,$6743,$919B,$6CC9,$5168,$75CA,$62F3,
$72AC,$5238,$529D,$7F3A,$7094,$7638,$5374,$9E4A,$69B7,$786E,$96C0,$88D9,$7FA4,
$7136,$71C3,$5189,$67D3,$74E4,$58E4,$6518,$56B7,$8BA9,$9976,$6270,$7ED5,$60F9,
$70ED,$58EC,$4EC1,$4EBA,$5FCD,$97E7,$4EFB,$8BA4,$5203,$598A,$7EAB,$6254,$4ECD,
$65E5,$620E,$8338,$84C9,$8363,$878D,$7194,$6EB6,$5BB9,$7ED2,$5197,$63C9,$67D4,
$8089,$8339,$8815,$5112,$5B7A,$5982,$8FB1,$4E73,$6C5D,$5165,$8925,$8F6F,$962E,
$854A,$745E,$9510,$95F0,$6DA6,$82E5,$5F31,$6492,$6D12,$8428,$816E,$9CC3,$585E,
$8D5B,$4E09,$53C1,$847D,$847E,$847F,$8480,$8481,$8483,$8484,$8485,$8486,$848A,
$848D,$848F,$8490,$8491,$8492,$8493,$8494,$8495,$8496,$8498,$849A,$849B,$849D,
$849E,$849F,$84A0,$84A2,$84A3,$84A4,$84A5,$84A6,$84A7,$84A8,$84A9,$84AA,$84AB,
$84AC,$84AD,$84AE,$84B0,$84B1,$84B3,$84B5,$84B6,$84B7,$84BB,$84BC,$84BE,$84C0,
$84C2,$84C3,$84C5,$84C6,$84C7,$84C8,$84CB,$84CC,$84CE,$84CF,$84D2,$84D4,$84D5,
$84D7,$84D8,$84D9,$84DA,$84DB,$84DC,$84DE,$84E1,$84E2,$84E4,$84E7,$84E8,$84E9,
$84EA,$84EB,$84ED,$84EE,$84EF,$84F1,$84F2,$84F3,$84F4,$84F5,$84F6,$84F7,$84F8,
$84F9,$84FA,$84FB,$84FD,$84FE,$8500,$8501,$8502,$4F1E,$6563,$6851,$55D3,$4E27,
$6414,$9A9A,$626B,$5AC2,$745F,$8272,$6DA9,$68EE,$50E7,$838E,$7802,$6740,$5239,
$6C99,$7EB1,$50BB,$5565,$715E,$7B5B,$6652,$73CA,$82EB,$6749,$5C71,$5220,$717D,
$886B,$95EA,$9655,$64C5,$8D61,$81B3,$5584,$6C55,$6247,$7F2E,$5892,$4F24,$5546,
$8D4F,$664C,$4E0A,$5C1A,$88F3,$68A2,$634E,$7A0D,$70E7,$828D,$52FA,$97F6,$5C11,
$54E8,$90B5,$7ECD,$5962,$8D4A,$86C7,$820C,$820D,$8D66,$6444,$5C04,$6151,$6D89,
$793E,$8BBE,$7837,$7533,$547B,$4F38,$8EAB,$6DF1,$5A20,$7EC5,$795E,$6C88,$5BA1,
$5A76,$751A,$80BE,$614E,$6E17,$58F0,$751F,$7525,$7272,$5347,$7EF3,$8503,$8504,
$8505,$8506,$8507,$8508,$8509,$850A,$850B,$850D,$850E,$850F,$8510,$8512,$8514,
$8515,$8516,$8518,$8519,$851B,$851C,$851D,$851E,$8520,$8522,$8523,$8524,$8525,
$8526,$8527,$8528,$8529,$852A,$852D,$852E,$852F,$8530,$8531,$8532,$8533,$8534,
$8535,$8536,$853E,$853F,$8540,$8541,$8542,$8544,$8545,$8546,$8547,$854B,$854C,
$854D,$854E,$854F,$8550,$8551,$8552,$8553,$8554,$8555,$8557,$8558,$855A,$855B,
$855C,$855D,$855F,$8560,$8561,$8562,$8563,$8565,$8566,$8567,$8569,$856A,$856B,
$856C,$856D,$856E,$856F,$8570,$8571,$8573,$8575,$8576,$8577,$8578,$857C,$857D,
$857F,$8580,$8581,$7701,$76DB,$5269,$80DC,$5723,$5E08,$5931,$72EE,$65BD,$6E7F,
$8BD7,$5C38,$8671,$5341,$77F3,$62FE,$65F6,$4EC0,$98DF,$8680,$5B9E,$8BC6,$53F2,
$77E2,$4F7F,$5C4E,$9A76,$59CB,$5F0F,$793A,$58EB,$4E16,$67FF,$4E8B,$62ED,$8A93,
$901D,$52BF,$662F,$55DC,$566C,$9002,$4ED5,$4F8D,$91CA,$9970,$6C0F,$5E02,$6043,
$5BA4,$89C6,$8BD5,$6536,$624B,$9996,$5B88,$5BFF,$6388,$552E,$53D7,$7626,$517D,
$852C,$67A2,$68B3,$6B8A,$6292,$8F93,$53D4,$8212,$6DD1,$758F,$4E66,$8D4E,$5B70,
$719F,$85AF,$6691,$66D9,$7F72,$8700,$9ECD,$9F20,$5C5E,$672F,$8FF0,$6811,$675F,
$620D,$7AD6,$5885,$5EB6,$6570,$6F31,$8582,$8583,$8586,$8588,$8589,$858A,$858B,
$858C,$858D,$858E,$8590,$8591,$8592,$8593,$8594,$8595,$8596,$8597,$8598,$8599,
$859A,$859D,$859E,$859F,$85A0,$85A1,$85A2,$85A3,$85A5,$85A6,$85A7,$85A9,$85AB,
$85AC,$85AD,$85B1,$85B2,$85B3,$85B4,$85B5,$85B6,$85B8,$85BA,$85BB,$85BC,$85BD,
$85BE,$85BF,$85C0,$85C2,$85C3,$85C4,$85C5,$85C6,$85C7,$85C8,$85CA,$85CB,$85CC,
$85CD,$85CE,$85D1,$85D2,$85D4,$85D6,$85D7,$85D8,$85D9,$85DA,$85DB,$85DD,$85DE,
$85DF,$85E0,$85E1,$85E2,$85E3,$85E5,$85E6,$85E7,$85E8,$85EA,$85EB,$85EC,$85ED,
$85EE,$85EF,$85F0,$85F1,$85F2,$85F3,$85F4,$85F5,$85F6,$85F7,$85F8,$6055,$5237,
$800D,$6454,$8870,$7529,$5E05,$6813,$62F4,$971C,$53CC,$723D,$8C01,$6C34,$7761,
$7A0E,$542E,$77AC,$987A,$821C,$8BF4,$7855,$6714,$70C1,$65AF,$6495,$5636,$601D,
$79C1,$53F8,$4E1D,$6B7B,$8086,$5BFA,$55E3,$56DB,$4F3A,$4F3C,$9972,$5DF3,$677E,
$8038,$6002,$9882,$9001,$5B8B,$8BBC,$8BF5,$641C,$8258,$64DE,$55FD,$82CF,$9165,
$4FD7,$7D20,$901F,$7C9F,$50F3,$5851,$6EAF,$5BBF,$8BC9,$8083,$9178,$849C,$7B97,
$867D,$968B,$968F,$7EE5,$9AD3,$788E,$5C81,$7A57,$9042,$96A7,$795F,$5B59,$635F,
$7B0B,$84D1,$68AD,$5506,$7F29,$7410,$7D22,$9501,$6240,$584C,$4ED6,$5B83,$5979,
$5854,$85F9,$85FA,$85FC,$85FD,$85FE,$8600,$8601,$8602,$8603,$8604,$8606,$8607,
$8608,$8609,$860A,$860B,$860C,$860D,$860E,$860F,$8610,$8612,$8613,$8614,$8615,
$8617,$8618,$8619,$861A,$861B,$861C,$861D,$861E,$861F,$8620,$8621,$8622,$8623,
$8624,$8625,$8626,$8628,$862A,$862B,$862C,$862D,$862E,$862F,$8630,$8631,$8632,
$8633,$8634,$8635,$8636,$8637,$8639,$863A,$863B,$863D,$863E,$863F,$8640,$8641,
$8642,$8643,$8644,$8645,$8646,$8647,$8648,$8649,$864A,$864B,$864C,$8652,$8653,
$8655,$8656,$8657,$8658,$8659,$865B,$865C,$865D,$865F,$8660,$8661,$8663,$8664,
$8665,$8666,$8667,$8668,$8669,$866A,$736D,$631E,$8E4B,$8E0F,$80CE,$82D4,$62AC,
$53F0,$6CF0,$915E,$592A,$6001,$6C70,$574D,$644A,$8D2A,$762B,$6EE9,$575B,$6A80,
$75F0,$6F6D,$8C2D,$8C08,$5766,$6BEF,$8892,$78B3,$63A2,$53F9,$70AD,$6C64,$5858,
$642A,$5802,$68E0,$819B,$5510,$7CD6,$5018,$8EBA,$6DCC,$8D9F,$70EB,$638F,$6D9B,
$6ED4,$7EE6,$8404,$6843,$9003,$6DD8,$9676,$8BA8,$5957,$7279,$85E4,$817E,$75BC,
$8A8A,$68AF,$5254,$8E22,$9511,$63D0,$9898,$8E44,$557C,$4F53,$66FF,$568F,$60D5,
$6D95,$5243,$5C49,$5929,$6DFB,$586B,$7530,$751C,$606C,$8214,$8146,$6311,$6761,
$8FE2,$773A,$8DF3,$8D34,$94C1,$5E16,$5385,$542C,$70C3,$866D,$866F,$8670,$8672,
$8673,$8674,$8675,$8676,$8677,$8678,$8683,$8684,$8685,$8686,$8687,$8688,$8689,
$868E,$868F,$8690,$8691,$8692,$8694,$8696,$8697,$8698,$8699,$869A,$869B,$869E,
$869F,$86A0,$86A1,$86A2,$86A5,$86A6,$86AB,$86AD,$86AE,$86B2,$86B3,$86B7,$86B8,
$86B9,$86BB,$86BC,$86BD,$86BE,$86BF,$86C1,$86C2,$86C3,$86C5,$86C8,$86CC,$86CD,
$86D2,$86D3,$86D5,$86D6,$86D7,$86DA,$86DC,$86DD,$86E0,$86E1,$86E2,$86E3,$86E5,
$86E6,$86E7,$86E8,$86EA,$86EB,$86EC,$86EF,$86F5,$86F6,$86F7,$86FA,$86FB,$86FC,
$86FD,$86FF,$8701,$8704,$8705,$8706,$870B,$870C,$870E,$870F,$8710,$8711,$8714,
$8716,$6C40,$5EF7,$505C,$4EAD,$5EAD,$633A,$8247,$901A,$6850,$916E,$77B3,$540C,
$94DC,$5F64,$7AE5,$6876,$6345,$7B52,$7EDF,$75DB,$5077,$6295,$5934,$900F,$51F8,
$79C3,$7A81,$56FE,$5F92,$9014,$6D82,$5C60,$571F,$5410,$5154,$6E4D,$56E2,$63A8,
$9893,$817F,$8715,$892A,$9000,$541E,$5C6F,$81C0,$62D6,$6258,$8131,$9E35,$9640,
$9A6E,$9A7C,$692D,$59A5,$62D3,$553E,$6316,$54C7,$86D9,$6D3C,$5A03,$74E6,$889C,
$6B6A,$5916,$8C4C,$5F2F,$6E7E,$73A9,$987D,$4E38,$70F7,$5B8C,$7897,$633D,$665A,
$7696,$60CB,$5B9B,$5A49,$4E07,$8155,$6C6A,$738B,$4EA1,$6789,$7F51,$5F80,$65FA,
$671B,$5FD8,$5984,$5A01,$8719,$871B,$871D,$871F,$8720,$8724,$8726,$8727,$8728,
$872A,$872B,$872C,$872D,$872F,$8730,$8732,$8733,$8735,$8736,$8738,$8739,$873A,
$873C,$873D,$8740,$8741,$8742,$8743,$8744,$8745,$8746,$874A,$874B,$874D,$874F,
$8750,$8751,$8752,$8754,$8755,$8756,$8758,$875A,$875B,$875C,$875D,$875E,$875F,
$8761,$8762,$8766,$8767,$8768,$8769,$876A,$876B,$876C,$876D,$876F,$8771,$8772,
$8773,$8775,$8777,$8778,$8779,$877A,$877F,$8780,$8781,$8784,$8786,$8787,$8789,
$878A,$878C,$878E,$878F,$8790,$8791,$8792,$8794,$8795,$8796,$8798,$8799,$879A,
$879B,$879C,$879D,$879E,$87A0,$87A1,$87A2,$87A3,$87A4,$5DCD,$5FAE,$5371,$97E6,
$8FDD,$6845,$56F4,$552F,$60DF,$4E3A,$6F4D,$7EF4,$82C7,$840E,$59D4,$4F1F,$4F2A,
$5C3E,$7EAC,$672A,$851A,$5473,$754F,$80C3,$5582,$9B4F,$4F4D,$6E2D,$8C13,$5C09,
$6170,$536B,$761F,$6E29,$868A,$6587,$95FB,$7EB9,$543B,$7A33,$7D0A,$95EE,$55E1,
$7FC1,$74EE,$631D,$8717,$6DA1,$7A9D,$6211,$65A1,$5367,$63E1,$6C83,$5DEB,$545C,
$94A8,$4E4C,$6C61,$8BEC,$5C4B,$65E0,$829C,$68A7,$543E,$5434,$6BCB,$6B66,$4E94,
$6342,$5348,$821E,$4F0D,$4FAE,$575E,$620A,$96FE,$6664,$7269,$52FF,$52A1,$609F,
$8BEF,$6614,$7199,$6790,$897F,$7852,$77FD,$6670,$563B,$5438,$9521,$727A,$87A5,
$87A6,$87A7,$87A9,$87AA,$87AE,$87B0,$87B1,$87B2,$87B4,$87B6,$87B7,$87B8,$87B9,
$87BB,$87BC,$87BE,$87BF,$87C1,$87C2,$87C3,$87C4,$87C5,$87C7,$87C8,$87C9,$87CC,
$87CD,$87CE,$87CF,$87D0,$87D4,$87D5,$87D6,$87D7,$87D8,$87D9,$87DA,$87DC,$87DD,
$87DE,$87DF,$87E1,$87E2,$87E3,$87E4,$87E6,$87E7,$87E8,$87E9,$87EB,$87EC,$87ED,
$87EF,$87F0,$87F1,$87F2,$87F3,$87F4,$87F5,$87F6,$87F7,$87F8,$87FA,$87FB,$87FC,
$87FD,$87FF,$8800,$8801,$8802,$8804,$8805,$8806,$8807,$8808,$8809,$880B,$880C,
$880D,$880E,$880F,$8810,$8811,$8812,$8814,$8817,$8818,$8819,$881A,$881C,$881D,
$881E,$881F,$8820,$8823,$7A00,$606F,$5E0C,$6089,$819D,$5915,$60DC,$7184,$70EF,
$6EAA,$6C50,$7280,$6A84,$88AD,$5E2D,$4E60,$5AB3,$559C,$94E3,$6D17,$7CFB,$9699,
$620F,$7EC6,$778E,$867E,$5323,$971E,$8F96,$6687,$5CE1,$4FA0,$72ED,$4E0B,$53A6,
$590F,$5413,$6380,$9528,$5148,$4ED9,$9C9C,$7EA4,$54B8,$8D24,$8854,$8237,$95F2,
$6D8E,$5F26,$5ACC,$663E,$9669,$73B0,$732E,$53BF,$817A,$9985,$7FA1,$5BAA,$9677,
$9650,$7EBF,$76F8,$53A2,$9576,$9999,$7BB1,$8944,$6E58,$4E61,$7FD4,$7965,$8BE6,
$60F3,$54CD,$4EAB,$9879,$5DF7,$6A61,$50CF,$5411,$8C61,$8427,$785D,$9704,$524A,
$54EE,$56A3,$9500,$6D88,$5BB5,$6DC6,$6653,$8824,$8825,$8826,$8827,$8828,$8829,
$882A,$882B,$882C,$882D,$882E,$882F,$8830,$8831,$8833,$8834,$8835,$8836,$8837,
$8838,$883A,$883B,$883D,$883E,$883F,$8841,$8842,$8843,$8846,$8847,$8848,$8849,
$884A,$884B,$884E,$884F,$8850,$8851,$8852,$8853,$8855,$8856,$8858,$885A,$885B,
$885C,$885D,$885E,$885F,$8860,$8866,$8867,$886A,$886D,$886F,$8871,$8873,$8874,
$8875,$8876,$8878,$8879,$887A,$887B,$887C,$8880,$8883,$8886,$8887,$8889,$888A,
$888C,$888E,$888F,$8890,$8891,$8893,$8894,$8895,$8897,$8898,$8899,$889A,$889B,
$889D,$889E,$889F,$88A0,$88A1,$88A3,$88A5,$88A6,$88A7,$88A8,$88A9,$88AA,$5C0F,
$5B5D,$6821,$8096,$5578,$7B11,$6548,$6954,$4E9B,$6B47,$874E,$978B,$534F,$631F,
$643A,$90AA,$659C,$80C1,$8C10,$5199,$68B0,$5378,$87F9,$61C8,$6CC4,$6CFB,$8C22,
$5C51,$85AA,$82AF,$950C,$6B23,$8F9B,$65B0,$5FFB,$5FC3,$4FE1,$8845,$661F,$8165,
$7329,$60FA,$5174,$5211,$578B,$5F62,$90A2,$884C,$9192,$5E78,$674F,$6027,$59D3,
$5144,$51F6,$80F8,$5308,$6C79,$96C4,$718A,$4F11,$4FEE,$7F9E,$673D,$55C5,$9508,
$79C0,$8896,$7EE3,$589F,$620C,$9700,$865A,$5618,$987B,$5F90,$8BB8,$84C4,$9157,
$53D9,$65ED,$5E8F,$755C,$6064,$7D6E,$5A7F,$7EEA,$7EED,$8F69,$55A7,$5BA3,$60AC,
$65CB,$7384,$88AC,$88AE,$88AF,$88B0,$88B2,$88B3,$88B4,$88B5,$88B6,$88B8,$88B9,
$88BA,$88BB,$88BD,$88BE,$88BF,$88C0,$88C3,$88C4,$88C7,$88C8,$88CA,$88CB,$88CC,
$88CD,$88CF,$88D0,$88D1,$88D3,$88D6,$88D7,$88DA,$88DB,$88DC,$88DD,$88DE,$88E0,
$88E1,$88E6,$88E7,$88E9,$88EA,$88EB,$88EC,$88ED,$88EE,$88EF,$88F2,$88F5,$88F6,
$88F7,$88FA,$88FB,$88FD,$88FF,$8900,$8901,$8903,$8904,$8905,$8906,$8907,$8908,
$8909,$890B,$890C,$890D,$890E,$890F,$8911,$8914,$8915,$8916,$8917,$8918,$891C,
$891D,$891E,$891F,$8920,$8922,$8923,$8924,$8926,$8927,$8928,$8929,$892C,$892D,
$892E,$892F,$8931,$8932,$8933,$8935,$8937,$9009,$7663,$7729,$7EDA,$9774,$859B,
$5B66,$7A74,$96EA,$8840,$52CB,$718F,$5FAA,$65EC,$8BE2,$5BFB,$9A6F,$5DE1,$6B89,
$6C5B,$8BAD,$8BAF,$900A,$8FC5,$538B,$62BC,$9E26,$9E2D,$5440,$4E2B,$82BD,$7259,
$869C,$5D16,$8859,$6DAF,$96C5,$54D1,$4E9A,$8BB6,$7109,$54BD,$9609,$70DF,$6DF9,
$76D0,$4E25,$7814,$8712,$5CA9,$5EF6,$8A00,$989C,$960E,$708E,$6CBF,$5944,$63A9,
$773C,$884D,$6F14,$8273,$5830,$71D5,$538C,$781A,$96C1,$5501,$5F66,$7130,$5BB4,
$8C1A,$9A8C,$6B83,$592E,$9E2F,$79E7,$6768,$626C,$4F6F,$75A1,$7F8A,$6D0B,$9633,
$6C27,$4EF0,$75D2,$517B,$6837,$6F3E,$9080,$8170,$5996,$7476,$8938,$8939,$893A,
$893B,$893C,$893D,$893E,$893F,$8940,$8942,$8943,$8945,$8946,$8947,$8948,$8949,
$894A,$894B,$894C,$894D,$894E,$894F,$8950,$8951,$8952,$8953,$8954,$8955,$8956,
$8957,$8958,$8959,$895A,$895B,$895C,$895D,$8960,$8961,$8962,$8963,$8964,$8965,
$8967,$8968,$8969,$896A,$896B,$896C,$896D,$896E,$896F,$8970,$8971,$8972,$8973,
$8974,$8975,$8976,$8977,$8978,$8979,$897A,$897C,$897D,$897E,$8980,$8982,$8984,
$8985,$8987,$8988,$8989,$898A,$898B,$898C,$898D,$898E,$898F,$8990,$8991,$8992,
$8993,$8994,$8995,$8996,$8997,$8998,$8999,$899A,$899B,$899C,$899D,$899E,$899F,
$89A0,$89A1,$6447,$5C27,$9065,$7A91,$8C23,$59DA,$54AC,$8200,$836F,$8981,$8000,
$6930,$564E,$8036,$7237,$91CE,$51B6,$4E5F,$9875,$6396,$4E1A,$53F6,$66F3,$814B,
$591C,$6DB2,$4E00,$58F9,$533B,$63D6,$94F1,$4F9D,$4F0A,$8863,$9890,$5937,$9057,
$79FB,$4EEA,$80F0,$7591,$6C82,$5B9C,$59E8,$5F5D,$6905,$8681,$501A,$5DF2,$4E59,
$77E3,$4EE5,$827A,$6291,$6613,$9091,$5C79,$4EBF,$5F79,$81C6,$9038,$8084,$75AB,
$4EA6,$88D4,$610F,$6BC5,$5FC6,$4E49,$76CA,$6EA2,$8BE3,$8BAE,$8C0A,$8BD1,$5F02,
$7FFC,$7FCC,$7ECE,$8335,$836B,$56E0,$6BB7,$97F3,$9634,$59FB,$541F,$94F6,$6DEB,
$5BC5,$996E,$5C39,$5F15,$9690,$89A2,$89A3,$89A4,$89A5,$89A6,$89A7,$89A8,$89A9,
$89AA,$89AB,$89AC,$89AD,$89AE,$89AF,$89B0,$89B1,$89B2,$89B3,$89B4,$89B5,$89B6,
$89B7,$89B8,$89B9,$89BA,$89BB,$89BC,$89BD,$89BE,$89BF,$89C0,$89C3,$89CD,$89D3,
$89D4,$89D5,$89D7,$89D8,$89D9,$89DB,$89DD,$89DF,$89E0,$89E1,$89E2,$89E4,$89E7,
$89E8,$89E9,$89EA,$89EC,$89ED,$89EE,$89F0,$89F1,$89F2,$89F4,$89F5,$89F6,$89F7,
$89F8,$89F9,$89FA,$89FB,$89FC,$89FD,$89FE,$89FF,$8A01,$8A02,$8A03,$8A04,$8A05,
$8A06,$8A08,$8A09,$8A0A,$8A0B,$8A0C,$8A0D,$8A0E,$8A0F,$8A10,$8A11,$8A12,$8A13,
$8A14,$8A15,$8A16,$8A17,$8A18,$8A19,$8A1A,$8A1B,$8A1C,$8A1D,$5370,$82F1,$6A31,
$5A74,$9E70,$5E94,$7F28,$83B9,$8424,$8425,$8367,$8747,$8FCE,$8D62,$76C8,$5F71,
$9896,$786C,$6620,$54DF,$62E5,$4F63,$81C3,$75C8,$5EB8,$96CD,$8E0A,$86F9,$548F,
$6CF3,$6D8C,$6C38,$607F,$52C7,$7528,$5E7D,$4F18,$60A0,$5FE7,$5C24,$7531,$90AE,
$94C0,$72B9,$6CB9,$6E38,$9149,$6709,$53CB,$53F3,$4F51,$91C9,$8BF1,$53C8,$5E7C,
$8FC2,$6DE4,$4E8E,$76C2,$6986,$865E,$611A,$8206,$4F59,$4FDE,$903E,$9C7C,$6109,
$6E1D,$6E14,$9685,$4E88,$5A31,$96E8,$4E0E,$5C7F,$79B9,$5B87,$8BED,$7FBD,$7389,
$57DF,$828B,$90C1,$5401,$9047,$55BB,$5CEA,$5FA1,$6108,$6B32,$72F1,$80B2,$8A89,
$8A1E,$8A1F,$8A20,$8A21,$8A22,$8A23,$8A24,$8A25,$8A26,$8A27,$8A28,$8A29,$8A2A,
$8A2B,$8A2C,$8A2D,$8A2E,$8A2F,$8A30,$8A31,$8A32,$8A33,$8A34,$8A35,$8A36,$8A37,
$8A38,$8A39,$8A3A,$8A3B,$8A3C,$8A3D,$8A3F,$8A40,$8A41,$8A42,$8A43,$8A44,$8A45,
$8A46,$8A47,$8A49,$8A4A,$8A4B,$8A4C,$8A4D,$8A4E,$8A4F,$8A50,$8A51,$8A52,$8A53,
$8A54,$8A55,$8A56,$8A57,$8A58,$8A59,$8A5A,$8A5B,$8A5C,$8A5D,$8A5E,$8A5F,$8A60,
$8A61,$8A62,$8A63,$8A64,$8A65,$8A66,$8A67,$8A68,$8A69,$8A6A,$8A6B,$8A6C,$8A6D,
$8A6E,$8A6F,$8A70,$8A71,$8A72,$8A73,$8A74,$8A75,$8A76,$8A77,$8A78,$8A7A,$8A7B,
$8A7C,$8A7D,$8A7E,$8A7F,$8A80,$6D74,$5BD3,$88D5,$9884,$8C6B,$9A6D,$9E33,$6E0A,
$51A4,$5143,$57A3,$8881,$539F,$63F4,$8F95,$56ED,$5458,$5706,$733F,$6E90,$7F18,
$8FDC,$82D1,$613F,$6028,$9662,$66F0,$7EA6,$8D8A,$8DC3,$94A5,$5CB3,$7CA4,$6708,
$60A6,$9605,$8018,$4E91,$90E7,$5300,$9668,$5141,$8FD0,$8574,$915D,$6655,$97F5,
$5B55,$531D,$7838,$6742,$683D,$54C9,$707E,$5BB0,$8F7D,$518D,$5728,$54B1,$6512,
$6682,$8D5E,$8D43,$810F,$846C,$906D,$7CDF,$51FF,$85FB,$67A3,$65E9,$6FA1,$86A4,
$8E81,$566A,$9020,$7682,$7076,$71E5,$8D23,$62E9,$5219,$6CFD,$8D3C,$600E,$589E,
$618E,$66FE,$8D60,$624E,$55B3,$6E23,$672D,$8F67,$8A81,$8A82,$8A83,$8A84,$8A85,
$8A86,$8A87,$8A88,$8A8B,$8A8C,$8A8D,$8A8E,$8A8F,$8A90,$8A91,$8A92,$8A94,$8A95,
$8A96,$8A97,$8A98,$8A99,$8A9A,$8A9B,$8A9C,$8A9D,$8A9E,$8A9F,$8AA0,$8AA1,$8AA2,
$8AA3,$8AA4,$8AA5,$8AA6,$8AA7,$8AA8,$8AA9,$8AAA,$8AAB,$8AAC,$8AAD,$8AAE,$8AAF,
$8AB0,$8AB1,$8AB2,$8AB3,$8AB4,$8AB5,$8AB6,$8AB7,$8AB8,$8AB9,$8ABA,$8ABB,$8ABC,
$8ABD,$8ABE,$8ABF,$8AC0,$8AC1,$8AC2,$8AC3,$8AC4,$8AC5,$8AC6,$8AC7,$8AC8,$8AC9,
$8ACA,$8ACB,$8ACC,$8ACD,$8ACE,$8ACF,$8AD0,$8AD1,$8AD2,$8AD3,$8AD4,$8AD5,$8AD6,
$8AD7,$8AD8,$8AD9,$8ADA,$8ADB,$8ADC,$8ADD,$8ADE,$8ADF,$8AE0,$8AE1,$8AE2,$8AE3,
$94E1,$95F8,$7728,$6805,$69A8,$548B,$4E4D,$70B8,$8BC8,$6458,$658B,$5B85,$7A84,
$503A,$5BE8,$77BB,$6BE1,$8A79,$7C98,$6CBE,$76CF,$65A9,$8F97,$5D2D,$5C55,$8638,
$6808,$5360,$6218,$7AD9,$6E5B,$7EFD,$6A1F,$7AE0,$5F70,$6F33,$5F20,$638C,$6DA8,
$6756,$4E08,$5E10,$8D26,$4ED7,$80C0,$7634,$969C,$62DB,$662D,$627E,$6CBC,$8D75,
$7167,$7F69,$5146,$8087,$53EC,$906E,$6298,$54F2,$86F0,$8F99,$8005,$9517,$8517,
$8FD9,$6D59,$73CD,$659F,$771F,$7504,$7827,$81FB,$8D1E,$9488,$4FA6,$6795,$75B9,
$8BCA,$9707,$632F,$9547,$9635,$84B8,$6323,$7741,$5F81,$72F0,$4E89,$6014,$6574,
$62EF,$6B63,$653F,$8AE4,$8AE5,$8AE6,$8AE7,$8AE8,$8AE9,$8AEA,$8AEB,$8AEC,$8AED,
$8AEE,$8AEF,$8AF0,$8AF1,$8AF2,$8AF3,$8AF4,$8AF5,$8AF6,$8AF7,$8AF8,$8AF9,$8AFA,
$8AFB,$8AFC,$8AFD,$8AFE,$8AFF,$8B00,$8B01,$8B02,$8B03,$8B04,$8B05,$8B06,$8B08,
$8B09,$8B0A,$8B0B,$8B0C,$8B0D,$8B0E,$8B0F,$8B10,$8B11,$8B12,$8B13,$8B14,$8B15,
$8B16,$8B17,$8B18,$8B19,$8B1A,$8B1B,$8B1C,$8B1D,$8B1E,$8B1F,$8B20,$8B21,$8B22,
$8B23,$8B24,$8B25,$8B27,$8B28,$8B29,$8B2A,$8B2B,$8B2C,$8B2D,$8B2E,$8B2F,$8B30,
$8B31,$8B32,$8B33,$8B34,$8B35,$8B36,$8B37,$8B38,$8B39,$8B3A,$8B3B,$8B3C,$8B3D,
$8B3E,$8B3F,$8B40,$8B41,$8B42,$8B43,$8B44,$8B45,$5E27,$75C7,$90D1,$8BC1,$829D,
$679D,$652F,$5431,$8718,$77E5,$80A2,$8102,$6C41,$4E4B,$7EC7,$804C,$76F4,$690D,
$6B96,$6267,$503C,$4F84,$5740,$6307,$6B62,$8DBE,$53EA,$65E8,$7EB8,$5FD7,$631A,
$63B7,$81F3,$81F4,$7F6E,$5E1C,$5CD9,$5236,$667A,$79E9,$7A1A,$8D28,$7099,$75D4,
$6EDE,$6CBB,$7A92,$4E2D,$76C5,$5FE0,$949F,$8877,$7EC8,$79CD,$80BF,$91CD,$4EF2,
$4F17,$821F,$5468,$5DDE,$6D32,$8BCC,$7CA5,$8F74,$8098,$5E1A,$5492,$76B1,$5B99,
$663C,$9AA4,$73E0,$682A,$86DB,$6731,$732A,$8BF8,$8BDB,$9010,$7AF9,$70DB,$716E,
$62C4,$77A9,$5631,$4E3B,$8457,$67F1,$52A9,$86C0,$8D2E,$94F8,$7B51,$8B46,$8B47,
$8B48,$8B49,$8B4A,$8B4B,$8B4C,$8B4D,$8B4E,$8B4F,$8B50,$8B51,$8B52,$8B53,$8B54,
$8B55,$8B56,$8B57,$8B58,$8B59,$8B5A,$8B5B,$8B5C,$8B5D,$8B5E,$8B5F,$8B60,$8B61,
$8B62,$8B63,$8B64,$8B65,$8B67,$8B68,$8B69,$8B6A,$8B6B,$8B6D,$8B6E,$8B6F,$8B70,
$8B71,$8B72,$8B73,$8B74,$8B75,$8B76,$8B77,$8B78,$8B79,$8B7A,$8B7B,$8B7C,$8B7D,
$8B7E,$8B7F,$8B80,$8B81,$8B82,$8B83,$8B84,$8B85,$8B86,$8B87,$8B88,$8B89,$8B8A,
$8B8B,$8B8C,$8B8D,$8B8E,$8B8F,$8B90,$8B91,$8B92,$8B93,$8B94,$8B95,$8B96,$8B97,
$8B98,$8B99,$8B9A,$8B9B,$8B9C,$8B9D,$8B9E,$8B9F,$8BAC,$8BB1,$8BBB,$8BC7,$8BD0,
$8BEA,$8C09,$8C1E,$4F4F,$6CE8,$795D,$9A7B,$6293,$722A,$62FD,$4E13,$7816,$8F6C,
$64B0,$8D5A,$7BC6,$6869,$5E84,$88C5,$5986,$649E,$58EE,$72B6,$690E,$9525,$8FFD,
$8D58,$5760,$7F00,$8C06,$51C6,$6349,$62D9,$5353,$684C,$7422,$8301,$914C,$5544,
$7740,$707C,$6D4A,$5179,$54A8,$8D44,$59FF,$6ECB,$6DC4,$5B5C,$7D2B,$4ED4,$7C7D,
$6ED3,$5B50,$81EA,$6E0D,$5B57,$9B03,$68D5,$8E2A,$5B97,$7EFC,$603B,$7EB5,$90B9,
$8D70,$594F,$63CD,$79DF,$8DB3,$5352,$65CF,$7956,$8BC5,$963B,$7EC4,$94BB,$7E82,
$5634,$9189,$6700,$7F6A,$5C0A,$9075,$6628,$5DE6,$4F50,$67DE,$505A,$4F5C,$5750,
$5EA7,$8C38,$8C39,$8C3A,$8C3B,$8C3C,$8C3D,$8C3E,$8C3F,$8C40,$8C42,$8C43,$8C44,
$8C45,$8C48,$8C4A,$8C4B,$8C4D,$8C4E,$8C4F,$8C50,$8C51,$8C52,$8C53,$8C54,$8C56,
$8C57,$8C58,$8C59,$8C5B,$8C5C,$8C5D,$8C5E,$8C5F,$8C60,$8C63,$8C64,$8C65,$8C66,
$8C67,$8C68,$8C69,$8C6C,$8C6D,$8C6E,$8C6F,$8C70,$8C71,$8C72,$8C74,$8C75,$8C76,
$8C77,$8C7B,$8C7C,$8C7D,$8C7E,$8C7F,$8C80,$8C81,$8C83,$8C84,$8C86,$8C87,$8C88,
$8C8B,$8C8D,$8C8E,$8C8F,$8C90,$8C91,$8C92,$8C93,$8C95,$8C96,$8C97,$8C99,$8C9A,
$8C9B,$8C9C,$8C9D,$8C9E,$8C9F,$8CA0,$8CA1,$8CA2,$8CA3,$8CA4,$8CA5,$8CA6,$8CA7,
$8CA8,$8CA9,$8CAA,$8CAB,$8CAC,$8CAD,$4E8D,$4E0C,$5140,$4E10,$5EFF,$5345,$4E15,
$4E98,$4E1E,$9B32,$5B6C,$5669,$4E28,$79BA,$4E3F,$5315,$4E47,$592D,$723B,$536E,
$6C10,$56DF,$80E4,$9997,$6BD3,$777E,$9F17,$4E36,$4E9F,$9F10,$4E5C,$4E69,$4E93,
$8288,$5B5B,$556C,$560F,$4EC4,$538D,$539D,$53A3,$53A5,$53AE,$9765,$8D5D,$531A,
$53F5,$5326,$532E,$533E,$8D5C,$5366,$5363,$5202,$5208,$520E,$522D,$5233,$523F,
$5240,$524C,$525E,$5261,$525C,$84AF,$527D,$5282,$5281,$5290,$5293,$5182,$7F54,
$4EBB,$4EC3,$4EC9,$4EC2,$4EE8,$4EE1,$4EEB,$4EDE,$4F1B,$4EF3,$4F22,$4F64,$4EF5,
$4F25,$4F27,$4F09,$4F2B,$4F5E,$4F67,$6538,$4F5A,$4F5D,$8CAE,$8CAF,$8CB0,$8CB1,
$8CB2,$8CB3,$8CB4,$8CB5,$8CB6,$8CB7,$8CB8,$8CB9,$8CBA,$8CBB,$8CBC,$8CBD,$8CBE,
$8CBF,$8CC0,$8CC1,$8CC2,$8CC3,$8CC4,$8CC5,$8CC6,$8CC7,$8CC8,$8CC9,$8CCA,$8CCB,
$8CCC,$8CCD,$8CCE,$8CCF,$8CD0,$8CD1,$8CD2,$8CD3,$8CD4,$8CD5,$8CD6,$8CD7,$8CD8,
$8CD9,$8CDA,$8CDB,$8CDC,$8CDD,$8CDE,$8CDF,$8CE0,$8CE1,$8CE2,$8CE3,$8CE4,$8CE5,
$8CE6,$8CE7,$8CE8,$8CE9,$8CEA,$8CEB,$8CEC,$8CED,$8CEE,$8CEF,$8CF0,$8CF1,$8CF2,
$8CF3,$8CF4,$8CF5,$8CF6,$8CF7,$8CF8,$8CF9,$8CFA,$8CFB,$8CFC,$8CFD,$8CFE,$8CFF,
$8D00,$8D01,$8D02,$8D03,$8D04,$8D05,$8D06,$8D07,$8D08,$8D09,$8D0A,$8D0B,$8D0C,
$8D0D,$4F5F,$4F57,$4F32,$4F3D,$4F76,$4F74,$4F91,$4F89,$4F83,$4F8F,$4F7E,$4F7B,
$4FAA,$4F7C,$4FAC,$4F94,$4FE6,$4FE8,$4FEA,$4FC5,$4FDA,$4FE3,$4FDC,$4FD1,$4FDF,
$4FF8,$5029,$504C,$4FF3,$502C,$500F,$502E,$502D,$4FFE,$501C,$500C,$5025,$5028,
$507E,$5043,$5055,$5048,$504E,$506C,$507B,$50A5,$50A7,$50A9,$50BA,$50D6,$5106,
$50ED,$50EC,$50E6,$50EE,$5107,$510B,$4EDD,$6C3D,$4F58,$4F65,$4FCE,$9FA0,$6C46,
$7C74,$516E,$5DFD,$9EC9,$9998,$5181,$5914,$52F9,$530D,$8A07,$5310,$51EB,$5919,
$5155,$4EA0,$5156,$4EB3,$886E,$88A4,$4EB5,$8114,$88D2,$7980,$5B34,$8803,$7FB8,
$51AB,$51B1,$51BD,$51BC,$8D0E,$8D0F,$8D10,$8D11,$8D12,$8D13,$8D14,$8D15,$8D16,
$8D17,$8D18,$8D19,$8D1A,$8D1B,$8D1C,$8D20,$8D51,$8D52,$8D57,$8D5F,$8D65,$8D68,
$8D69,$8D6A,$8D6C,$8D6E,$8D6F,$8D71,$8D72,$8D78,$8D79,$8D7A,$8D7B,$8D7C,$8D7D,
$8D7E,$8D7F,$8D80,$8D82,$8D83,$8D86,$8D87,$8D88,$8D89,$8D8C,$8D8D,$8D8E,$8D8F,
$8D90,$8D92,$8D93,$8D95,$8D96,$8D97,$8D98,$8D99,$8D9A,$8D9B,$8D9C,$8D9D,$8D9E,
$8DA0,$8DA1,$8DA2,$8DA4,$8DA5,$8DA6,$8DA7,$8DA8,$8DA9,$8DAA,$8DAB,$8DAC,$8DAD,
$8DAE,$8DAF,$8DB0,$8DB2,$8DB6,$8DB7,$8DB9,$8DBB,$8DBD,$8DC0,$8DC1,$8DC2,$8DC5,
$8DC7,$8DC8,$8DC9,$8DCA,$8DCD,$8DD0,$8DD2,$8DD3,$8DD4,$51C7,$5196,$51A2,$51A5,
$8BA0,$8BA6,$8BA7,$8BAA,$8BB4,$8BB5,$8BB7,$8BC2,$8BC3,$8BCB,$8BCF,$8BCE,$8BD2,
$8BD3,$8BD4,$8BD6,$8BD8,$8BD9,$8BDC,$8BDF,$8BE0,$8BE4,$8BE8,$8BE9,$8BEE,$8BF0,
$8BF3,$8BF6,$8BF9,$8BFC,$8BFF,$8C00,$8C02,$8C04,$8C07,$8C0C,$8C0F,$8C11,$8C12,
$8C14,$8C15,$8C16,$8C19,$8C1B,$8C18,$8C1D,$8C1F,$8C20,$8C21,$8C25,$8C27,$8C2A,
$8C2B,$8C2E,$8C2F,$8C32,$8C33,$8C35,$8C36,$5369,$537A,$961D,$9622,$9621,$9631,
$962A,$963D,$963C,$9642,$9649,$9654,$965F,$9667,$966C,$9672,$9674,$9688,$968D,
$9697,$96B0,$9097,$909B,$909D,$9099,$90AC,$90A1,$90B4,$90B3,$90B6,$90BA,$8DD5,
$8DD8,$8DD9,$8DDC,$8DE0,$8DE1,$8DE2,$8DE5,$8DE6,$8DE7,$8DE9,$8DED,$8DEE,$8DF0,
$8DF1,$8DF2,$8DF4,$8DF6,$8DFC,$8DFE,$8DFF,$8E00,$8E01,$8E02,$8E03,$8E04,$8E06,
$8E07,$8E08,$8E0B,$8E0D,$8E0E,$8E10,$8E11,$8E12,$8E13,$8E15,$8E16,$8E17,$8E18,
$8E19,$8E1A,$8E1B,$8E1C,$8E20,$8E21,$8E24,$8E25,$8E26,$8E27,$8E28,$8E2B,$8E2D,
$8E30,$8E32,$8E33,$8E34,$8E36,$8E37,$8E38,$8E3B,$8E3C,$8E3E,$8E3F,$8E43,$8E45,
$8E46,$8E4C,$8E4D,$8E4E,$8E4F,$8E50,$8E53,$8E54,$8E55,$8E56,$8E57,$8E58,$8E5A,
$8E5B,$8E5C,$8E5D,$8E5E,$8E5F,$8E60,$8E61,$8E62,$8E63,$8E64,$8E65,$8E67,$8E68,
$8E6A,$8E6B,$8E6E,$8E71,$90B8,$90B0,$90CF,$90C5,$90BE,$90D0,$90C4,$90C7,$90D3,
$90E6,$90E2,$90DC,$90D7,$90DB,$90EB,$90EF,$90FE,$9104,$9122,$911E,$9123,$9131,
$912F,$9139,$9143,$9146,$520D,$5942,$52A2,$52AC,$52AD,$52BE,$54FF,$52D0,$52D6,
$52F0,$53DF,$71EE,$77CD,$5EF4,$51F5,$51FC,$9B2F,$53B6,$5F01,$755A,$5DEF,$574C,
$57A9,$57A1,$587E,$58BC,$58C5,$58D1,$5729,$572C,$572A,$5733,$5739,$572E,$572F,
$575C,$573B,$5742,$5769,$5785,$576B,$5786,$577C,$577B,$5768,$576D,$5776,$5773,
$57AD,$57A4,$578C,$57B2,$57CF,$57A7,$57B4,$5793,$57A0,$57D5,$57D8,$57DA,$57D9,
$57D2,$57B8,$57F4,$57EF,$57F8,$57E4,$57DD,$8E73,$8E75,$8E77,$8E78,$8E79,$8E7A,
$8E7B,$8E7D,$8E7E,$8E80,$8E82,$8E83,$8E84,$8E86,$8E88,$8E89,$8E8A,$8E8B,$8E8C,
$8E8D,$8E8E,$8E91,$8E92,$8E93,$8E95,$8E96,$8E97,$8E98,$8E99,$8E9A,$8E9B,$8E9D,
$8E9F,$8EA0,$8EA1,$8EA2,$8EA3,$8EA4,$8EA5,$8EA6,$8EA7,$8EA8,$8EA9,$8EAA,$8EAD,
$8EAE,$8EB0,$8EB1,$8EB3,$8EB4,$8EB5,$8EB6,$8EB7,$8EB8,$8EB9,$8EBB,$8EBC,$8EBD,
$8EBE,$8EBF,$8EC0,$8EC1,$8EC2,$8EC3,$8EC4,$8EC5,$8EC6,$8EC7,$8EC8,$8EC9,$8ECA,
$8ECB,$8ECC,$8ECD,$8ECF,$8ED0,$8ED1,$8ED2,$8ED3,$8ED4,$8ED5,$8ED6,$8ED7,$8ED8,
$8ED9,$8EDA,$8EDB,$8EDC,$8EDD,$8EDE,$8EDF,$8EE0,$8EE1,$8EE2,$8EE3,$8EE4,$580B,
$580D,$57FD,$57ED,$5800,$581E,$5819,$5844,$5820,$5865,$586C,$5881,$5889,$589A,
$5880,$99A8,$9F19,$61FF,$8279,$827D,$827F,$828F,$828A,$82A8,$8284,$828E,$8291,
$8297,$8299,$82AB,$82B8,$82BE,$82B0,$82C8,$82CA,$82E3,$8298,$82B7,$82AE,$82CB,
$82CC,$82C1,$82A9,$82B4,$82A1,$82AA,$829F,$82C4,$82CE,$82A4,$82E1,$8309,$82F7,
$82E4,$830F,$8307,$82DC,$82F4,$82D2,$82D8,$830C,$82FB,$82D3,$8311,$831A,$8306,
$8314,$8315,$82E0,$82D5,$831C,$8351,$835B,$835C,$8308,$8392,$833C,$8334,$8331,
$839B,$835E,$832F,$834F,$8347,$8343,$835F,$8340,$8317,$8360,$832D,$833A,$8333,
$8366,$8365,$8EE5,$8EE6,$8EE7,$8EE8,$8EE9,$8EEA,$8EEB,$8EEC,$8EED,$8EEE,$8EEF,
$8EF0,$8EF1,$8EF2,$8EF3,$8EF4,$8EF5,$8EF6,$8EF7,$8EF8,$8EF9,$8EFA,$8EFB,$8EFC,
$8EFD,$8EFE,$8EFF,$8F00,$8F01,$8F02,$8F03,$8F04,$8F05,$8F06,$8F07,$8F08,$8F09,
$8F0A,$8F0B,$8F0C,$8F0D,$8F0E,$8F0F,$8F10,$8F11,$8F12,$8F13,$8F14,$8F15,$8F16,
$8F17,$8F18,$8F19,$8F1A,$8F1B,$8F1C,$8F1D,$8F1E,$8F1F,$8F20,$8F21,$8F22,$8F23,
$8F24,$8F25,$8F26,$8F27,$8F28,$8F29,$8F2A,$8F2B,$8F2C,$8F2D,$8F2E,$8F2F,$8F30,
$8F31,$8F32,$8F33,$8F34,$8F35,$8F36,$8F37,$8F38,$8F39,$8F3A,$8F3B,$8F3C,$8F3D,
$8F3E,$8F3F,$8F40,$8F41,$8F42,$8F43,$8F44,$8368,$831B,$8369,$836C,$836A,$836D,
$836E,$83B0,$8378,$83B3,$83B4,$83A0,$83AA,$8393,$839C,$8385,$837C,$83B6,$83A9,
$837D,$83B8,$837B,$8398,$839E,$83A8,$83BA,$83BC,$83C1,$8401,$83E5,$83D8,$5807,
$8418,$840B,$83DD,$83FD,$83D6,$841C,$8438,$8411,$8406,$83D4,$83DF,$840F,$8403,
$83F8,$83F9,$83EA,$83C5,$83C0,$8426,$83F0,$83E1,$845C,$8451,$845A,$8459,$8473,
$8487,$8488,$847A,$8489,$8478,$843C,$8446,$8469,$8476,$848C,$848E,$8431,$846D,
$84C1,$84CD,$84D0,$84E6,$84BD,$84D3,$84CA,$84BF,$84BA,$84E0,$84A1,$84B9,$84B4,
$8497,$84E5,$84E3,$850C,$750D,$8538,$84F0,$8539,$851F,$853A,$8F45,$8F46,$8F47,
$8F48,$8F49,$8F4A,$8F4B,$8F4C,$8F4D,$8F4E,$8F4F,$8F50,$8F51,$8F52,$8F53,$8F54,
$8F55,$8F56,$8F57,$8F58,$8F59,$8F5A,$8F5B,$8F5C,$8F5D,$8F5E,$8F5F,$8F60,$8F61,
$8F62,$8F63,$8F64,$8F65,$8F6A,$8F80,$8F8C,$8F92,$8F9D,$8FA0,$8FA1,$8FA2,$8FA4,
$8FA5,$8FA6,$8FA7,$8FAA,$8FAC,$8FAD,$8FAE,$8FAF,$8FB2,$8FB3,$8FB4,$8FB5,$8FB7,
$8FB8,$8FBA,$8FBB,$8FBC,$8FBF,$8FC0,$8FC3,$8FC6,$8FC9,$8FCA,$8FCB,$8FCC,$8FCD,
$8FCF,$8FD2,$8FD6,$8FD7,$8FDA,$8FE0,$8FE1,$8FE3,$8FE7,$8FEC,$8FEF,$8FF1,$8FF2,
$8FF4,$8FF5,$8FF6,$8FFA,$8FFB,$8FFC,$8FFE,$8FFF,$9007,$9008,$900C,$900E,$9013,
$9015,$9018,$8556,$853B,$84FF,$84FC,$8559,$8548,$8568,$8564,$855E,$857A,$77A2,
$8543,$8572,$857B,$85A4,$85A8,$8587,$858F,$8579,$85AE,$859C,$8585,$85B9,$85B7,
$85B0,$85D3,$85C1,$85DC,$85FF,$8627,$8605,$8629,$8616,$863C,$5EFE,$5F08,$593C,
$5941,$8037,$5955,$595A,$5958,$530F,$5C22,$5C25,$5C2C,$5C34,$624C,$626A,$629F,
$62BB,$62CA,$62DA,$62D7,$62EE,$6322,$62F6,$6339,$634B,$6343,$63AD,$63F6,$6371,
$637A,$638E,$63B4,$636D,$63AC,$638A,$6369,$63AE,$63BC,$63F2,$63F8,$63E0,$63FF,
$63C4,$63DE,$63CE,$6452,$63C6,$63BE,$6445,$6441,$640B,$641B,$6420,$640C,$6426,
$6421,$645E,$6484,$646D,$6496,$9019,$901C,$9023,$9024,$9025,$9027,$9028,$9029,
$902A,$902B,$902C,$9030,$9031,$9032,$9033,$9034,$9037,$9039,$903A,$903D,$903F,
$9040,$9043,$9045,$9046,$9048,$9049,$904A,$904B,$904C,$904E,$9054,$9055,$9056,
$9059,$905A,$905C,$905D,$905E,$905F,$9060,$9061,$9064,$9066,$9067,$9069,$906A,
$906B,$906C,$906F,$9070,$9071,$9072,$9073,$9076,$9077,$9078,$9079,$907A,$907B,
$907C,$907E,$9081,$9084,$9085,$9086,$9087,$9089,$908A,$908C,$908D,$908E,$908F,
$9090,$9092,$9094,$9096,$9098,$909A,$909C,$909E,$909F,$90A0,$90A4,$90A5,$90A7,
$90A8,$90A9,$90AB,$90AD,$90B2,$90B7,$90BC,$90BD,$90BF,$90C0,$647A,$64B7,$64B8,
$6499,$64BA,$64C0,$64D0,$64D7,$64E4,$64E2,$6509,$6525,$652E,$5F0B,$5FD2,$7519,
$5F11,$535F,$53F1,$53FD,$53E9,$53E8,$53FB,$5412,$5416,$5406,$544B,$5452,$5453,
$5454,$5456,$5443,$5421,$5457,$5459,$5423,$5432,$5482,$5494,$5477,$5471,$5464,
$549A,$549B,$5484,$5476,$5466,$549D,$54D0,$54AD,$54C2,$54B4,$54D2,$54A7,$54A6,
$54D3,$54D4,$5472,$54A3,$54D5,$54BB,$54BF,$54CC,$54D9,$54DA,$54DC,$54A9,$54AA,
$54A4,$54DD,$54CF,$54DE,$551B,$54E7,$5520,$54FD,$5514,$54F3,$5522,$5523,$550F,
$5511,$5527,$552A,$5567,$558F,$55B5,$5549,$556D,$5541,$5555,$553F,$5550,$553C,
$90C2,$90C3,$90C6,$90C8,$90C9,$90CB,$90CC,$90CD,$90D2,$90D4,$90D5,$90D6,$90D8,
$90D9,$90DA,$90DE,$90DF,$90E0,$90E3,$90E4,$90E5,$90E9,$90EA,$90EC,$90EE,$90F0,
$90F1,$90F2,$90F3,$90F5,$90F6,$90F7,$90F9,$90FA,$90FB,$90FC,$90FF,$9100,$9101,
$9103,$9105,$9106,$9107,$9108,$9109,$910A,$910B,$910C,$910D,$910E,$910F,$9110,
$9111,$9112,$9113,$9114,$9115,$9116,$9117,$9118,$911A,$911B,$911C,$911D,$911F,
$9120,$9121,$9124,$9125,$9126,$9127,$9128,$9129,$912A,$912B,$912C,$912D,$912E,
$9130,$9132,$9133,$9134,$9135,$9136,$9137,$9138,$913A,$913B,$913C,$913D,$913E,
$913F,$9140,$9141,$9142,$9144,$5537,$5556,$5575,$5576,$5577,$5533,$5530,$555C,
$558B,$55D2,$5583,$55B1,$55B9,$5588,$5581,$559F,$557E,$55D6,$5591,$557B,$55DF,
$55BD,$55BE,$5594,$5599,$55EA,$55F7,$55C9,$561F,$55D1,$55EB,$55EC,$55D4,$55E6,
$55DD,$55C4,$55EF,$55E5,$55F2,$55F3,$55CC,$55CD,$55E8,$55F5,$55E4,$8F94,$561E,
$5608,$560C,$5601,$5624,$5623,$55FE,$5600,$5627,$562D,$5658,$5639,$5657,$562C,
$564D,$5662,$5659,$565C,$564C,$5654,$5686,$5664,$5671,$566B,$567B,$567C,$5685,
$5693,$56AF,$56D4,$56D7,$56DD,$56E1,$56F5,$56EB,$56F9,$56FF,$5704,$570A,$5709,
$571C,$5E0F,$5E19,$5E14,$5E11,$5E31,$5E3B,$5E3C,$9145,$9147,$9148,$9151,$9153,
$9154,$9155,$9156,$9158,$9159,$915B,$915C,$915F,$9160,$9166,$9167,$9168,$916B,
$916D,$9173,$917A,$917B,$917C,$9180,$9181,$9182,$9183,$9184,$9186,$9188,$918A,
$918E,$918F,$9193,$9194,$9195,$9196,$9197,$9198,$9199,$919C,$919D,$919E,$919F,
$91A0,$91A1,$91A4,$91A5,$91A6,$91A7,$91A8,$91A9,$91AB,$91AC,$91B0,$91B1,$91B2,
$91B3,$91B6,$91B7,$91B8,$91B9,$91BB,$91BC,$91BD,$91BE,$91BF,$91C0,$91C1,$91C2,
$91C3,$91C4,$91C5,$91C6,$91C8,$91CB,$91D0,$91D2,$91D3,$91D4,$91D5,$91D6,$91D7,
$91D8,$91D9,$91DA,$91DB,$91DD,$91DE,$91DF,$91E0,$91E1,$91E2,$91E3,$91E4,$91E5,
$5E37,$5E44,$5E54,$5E5B,$5E5E,$5E61,$5C8C,$5C7A,$5C8D,$5C90,$5C96,$5C88,$5C98,
$5C99,$5C91,$5C9A,$5C9C,$5CB5,$5CA2,$5CBD,$5CAC,$5CAB,$5CB1,$5CA3,$5CC1,$5CB7,
$5CC4,$5CD2,$5CE4,$5CCB,$5CE5,$5D02,$5D03,$5D27,$5D26,$5D2E,$5D24,$5D1E,$5D06,
$5D1B,$5D58,$5D3E,$5D34,$5D3D,$5D6C,$5D5B,$5D6F,$5D5D,$5D6B,$5D4B,$5D4A,$5D69,
$5D74,$5D82,$5D99,$5D9D,$8C73,$5DB7,$5DC5,$5F73,$5F77,$5F82,$5F87,$5F89,$5F8C,
$5F95,$5F99,$5F9C,$5FA8,$5FAD,$5FB5,$5FBC,$8862,$5F61,$72AD,$72B0,$72B4,$72B7,
$72B8,$72C3,$72C1,$72CE,$72CD,$72D2,$72E8,$72EF,$72E9,$72F2,$72F4,$72F7,$7301,
$72F3,$7303,$72FA,$91E6,$91E7,$91E8,$91E9,$91EA,$91EB,$91EC,$91ED,$91EE,$91EF,
$91F0,$91F1,$91F2,$91F3,$91F4,$91F5,$91F6,$91F7,$91F8,$91F9,$91FA,$91FB,$91FC,
$91FD,$91FE,$91FF,$9200,$9201,$9202,$9203,$9204,$9205,$9206,$9207,$9208,$9209,
$920A,$920B,$920C,$920D,$920E,$920F,$9210,$9211,$9212,$9213,$9214,$9215,$9216,
$9217,$9218,$9219,$921A,$921B,$921C,$921D,$921E,$921F,$9220,$9221,$9222,$9223,
$9224,$9225,$9226,$9227,$9228,$9229,$922A,$922B,$922C,$922D,$922E,$922F,$9230,
$9231,$9232,$9233,$9234,$9235,$9236,$9237,$9238,$9239,$923A,$923B,$923C,$923D,
$923E,$923F,$9240,$9241,$9242,$9243,$9244,$9245,$72FB,$7317,$7313,$7321,$730A,
$731E,$731D,$7315,$7322,$7339,$7325,$732C,$7338,$7331,$7350,$734D,$7357,$7360,
$736C,$736F,$737E,$821B,$5925,$98E7,$5924,$5902,$9963,$9967,$9968,$9969,$996A,
$996B,$996C,$9974,$9977,$997D,$9980,$9984,$9987,$998A,$998D,$9990,$9991,$9993,
$9994,$9995,$5E80,$5E91,$5E8B,$5E96,$5EA5,$5EA0,$5EB9,$5EB5,$5EBE,$5EB3,$8D53,
$5ED2,$5ED1,$5EDB,$5EE8,$5EEA,$81BA,$5FC4,$5FC9,$5FD6,$5FCF,$6003,$5FEE,$6004,
$5FE1,$5FE4,$5FFE,$6005,$6006,$5FEA,$5FED,$5FF8,$6019,$6035,$6026,$601B,$600F,
$600D,$6029,$602B,$600A,$603F,$6021,$6078,$6079,$607B,$607A,$6042,$9246,$9247,
$9248,$9249,$924A,$924B,$924C,$924D,$924E,$924F,$9250,$9251,$9252,$9253,$9254,
$9255,$9256,$9257,$9258,$9259,$925A,$925B,$925C,$925D,$925E,$925F,$9260,$9261,
$9262,$9263,$9264,$9265,$9266,$9267,$9268,$9269,$926A,$926B,$926C,$926D,$926E,
$926F,$9270,$9271,$9272,$9273,$9275,$9276,$9277,$9278,$9279,$927A,$927B,$927C,
$927D,$927E,$927F,$9280,$9281,$9282,$9283,$9284,$9285,$9286,$9287,$9288,$9289,
$928A,$928B,$928C,$928D,$928F,$9290,$9291,$9292,$9293,$9294,$9295,$9296,$9297,
$9298,$9299,$929A,$929B,$929C,$929D,$929E,$929F,$92A0,$92A1,$92A2,$92A3,$92A4,
$92A5,$92A6,$92A7,$606A,$607D,$6096,$609A,$60AD,$609D,$6083,$6092,$608C,$609B,
$60EC,$60BB,$60B1,$60DD,$60D8,$60C6,$60DA,$60B4,$6120,$6126,$6115,$6123,$60F4,
$6100,$610E,$612B,$614A,$6175,$61AC,$6194,$61A7,$61B7,$61D4,$61F5,$5FDD,$96B3,
$95E9,$95EB,$95F1,$95F3,$95F5,$95F6,$95FC,$95FE,$9603,$9604,$9606,$9608,$960A,
$960B,$960C,$960D,$960F,$9612,$9615,$9616,$9617,$9619,$961A,$4E2C,$723F,$6215,
$6C35,$6C54,$6C5C,$6C4A,$6CA3,$6C85,$6C90,$6C94,$6C8C,$6C68,$6C69,$6C74,$6C76,
$6C86,$6CA9,$6CD0,$6CD4,$6CAD,$6CF7,$6CF8,$6CF1,$6CD7,$6CB2,$6CE0,$6CD6,$6CFA,
$6CEB,$6CEE,$6CB1,$6CD3,$6CEF,$6CFE,$92A8,$92A9,$92AA,$92AB,$92AC,$92AD,$92AF,
$92B0,$92B1,$92B2,$92B3,$92B4,$92B5,$92B6,$92B7,$92B8,$92B9,$92BA,$92BB,$92BC,
$92BD,$92BE,$92BF,$92C0,$92C1,$92C2,$92C3,$92C4,$92C5,$92C6,$92C7,$92C9,$92CA,
$92CB,$92CC,$92CD,$92CE,$92CF,$92D0,$92D1,$92D2,$92D3,$92D4,$92D5,$92D6,$92D7,
$92D8,$92D9,$92DA,$92DB,$92DC,$92DD,$92DE,$92DF,$92E0,$92E1,$92E2,$92E3,$92E4,
$92E5,$92E6,$92E7,$92E8,$92E9,$92EA,$92EB,$92EC,$92ED,$92EE,$92EF,$92F0,$92F1,
$92F2,$92F3,$92F4,$92F5,$92F6,$92F7,$92F8,$92F9,$92FA,$92FB,$92FC,$92FD,$92FE,
$92FF,$9300,$9301,$9302,$9303,$9304,$9305,$9306,$9307,$9308,$9309,$6D39,$6D27,
$6D0C,$6D43,$6D48,$6D07,$6D04,$6D19,$6D0E,$6D2B,$6D4D,$6D2E,$6D35,$6D1A,$6D4F,
$6D52,$6D54,$6D33,$6D91,$6D6F,$6D9E,$6DA0,$6D5E,$6D93,$6D94,$6D5C,$6D60,$6D7C,
$6D63,$6E1A,$6DC7,$6DC5,$6DDE,$6E0E,$6DBF,$6DE0,$6E11,$6DE6,$6DDD,$6DD9,$6E16,
$6DAB,$6E0C,$6DAE,$6E2B,$6E6E,$6E4E,$6E6B,$6EB2,$6E5F,$6E86,$6E53,$6E54,$6E32,
$6E25,$6E44,$6EDF,$6EB1,$6E98,$6EE0,$6F2D,$6EE2,$6EA5,$6EA7,$6EBD,$6EBB,$6EB7,
$6ED7,$6EB4,$6ECF,$6E8F,$6EC2,$6E9F,$6F62,$6F46,$6F47,$6F24,$6F15,$6EF9,$6F2F,
$6F36,$6F4B,$6F74,$6F2A,$6F09,$6F29,$6F89,$6F8D,$6F8C,$6F78,$6F72,$6F7C,$6F7A,
$6FD1,$930A,$930B,$930C,$930D,$930E,$930F,$9310,$9311,$9312,$9313,$9314,$9315,
$9316,$9317,$9318,$9319,$931A,$931B,$931C,$931D,$931E,$931F,$9320,$9321,$9322,
$9323,$9324,$9325,$9326,$9327,$9328,$9329,$932A,$932B,$932C,$932D,$932E,$932F,
$9330,$9331,$9332,$9333,$9334,$9335,$9336,$9337,$9338,$9339,$933A,$933B,$933C,
$933D,$933F,$9340,$9341,$9342,$9343,$9344,$9345,$9346,$9347,$9348,$9349,$934A,
$934B,$934C,$934D,$934E,$934F,$9350,$9351,$9352,$9353,$9354,$9355,$9356,$9357,
$9358,$9359,$935A,$935B,$935C,$935D,$935E,$935F,$9360,$9361,$9362,$9363,$9364,
$9365,$9366,$9367,$9368,$9369,$936B,$6FC9,$6FA7,$6FB9,$6FB6,$6FC2,$6FE1,$6FEE,
$6FDE,$6FE0,$6FEF,$701A,$7023,$701B,$7039,$7035,$704F,$705E,$5B80,$5B84,$5B95,
$5B93,$5BA5,$5BB8,$752F,$9A9E,$6434,$5BE4,$5BEE,$8930,$5BF0,$8E47,$8B07,$8FB6,
$8FD3,$8FD5,$8FE5,$8FEE,$8FE4,$8FE9,$8FE6,$8FF3,$8FE8,$9005,$9004,$900B,$9026,
$9011,$900D,$9016,$9021,$9035,$9036,$902D,$902F,$9044,$9051,$9052,$9050,$9068,
$9058,$9062,$905B,$66B9,$9074,$907D,$9082,$9088,$9083,$908B,$5F50,$5F57,$5F56,
$5F58,$5C3B,$54AB,$5C50,$5C59,$5B71,$5C63,$5C66,$7FBC,$5F2A,$5F29,$5F2D,$8274,
$5F3C,$9B3B,$5C6E,$5981,$5983,$598D,$59A9,$59AA,$59A3,$936C,$936D,$936E,$936F,
$9370,$9371,$9372,$9373,$9374,$9375,$9376,$9377,$9378,$9379,$937A,$937B,$937C,
$937D,$937E,$937F,$9380,$9381,$9382,$9383,$9384,$9385,$9386,$9387,$9388,$9389,
$938A,$938B,$938C,$938D,$938E,$9390,$9391,$9392,$9393,$9394,$9395,$9396,$9397,
$9398,$9399,$939A,$939B,$939C,$939D,$939E,$939F,$93A0,$93A1,$93A2,$93A3,$93A4,
$93A5,$93A6,$93A7,$93A8,$93A9,$93AA,$93AB,$93AC,$93AD,$93AE,$93AF,$93B0,$93B1,
$93B2,$93B3,$93B4,$93B5,$93B6,$93B7,$93B8,$93B9,$93BA,$93BB,$93BC,$93BD,$93BE,
$93BF,$93C0,$93C1,$93C2,$93C3,$93C4,$93C5,$93C6,$93C7,$93C8,$93C9,$93CB,$93CC,
$93CD,$5997,$59CA,$59AB,$599E,$59A4,$59D2,$59B2,$59AF,$59D7,$59BE,$5A05,$5A06,
$59DD,$5A08,$59E3,$59D8,$59F9,$5A0C,$5A09,$5A32,$5A34,$5A11,$5A23,$5A13,$5A40,
$5A67,$5A4A,$5A55,$5A3C,$5A62,$5A75,$80EC,$5AAA,$5A9B,$5A77,$5A7A,$5ABE,$5AEB,
$5AB2,$5AD2,$5AD4,$5AB8,$5AE0,$5AE3,$5AF1,$5AD6,$5AE6,$5AD8,$5ADC,$5B09,$5B17,
$5B16,$5B32,$5B37,$5B40,$5C15,$5C1C,$5B5A,$5B65,$5B73,$5B51,$5B53,$5B62,$9A75,
$9A77,$9A78,$9A7A,$9A7F,$9A7D,$9A80,$9A81,$9A85,$9A88,$9A8A,$9A90,$9A92,$9A93,
$9A96,$9A98,$9A9B,$9A9C,$9A9D,$9A9F,$9AA0,$9AA2,$9AA3,$9AA5,$9AA7,$7E9F,$7EA1,
$7EA3,$7EA5,$7EA8,$7EA9,$93CE,$93CF,$93D0,$93D1,$93D2,$93D3,$93D4,$93D5,$93D7,
$93D8,$93D9,$93DA,$93DB,$93DC,$93DD,$93DE,$93DF,$93E0,$93E1,$93E2,$93E3,$93E4,
$93E5,$93E6,$93E7,$93E8,$93E9,$93EA,$93EB,$93EC,$93ED,$93EE,$93EF,$93F0,$93F1,
$93F2,$93F3,$93F4,$93F5,$93F6,$93F7,$93F8,$93F9,$93FA,$93FB,$93FC,$93FD,$93FE,
$93FF,$9400,$9401,$9402,$9403,$9404,$9405,$9406,$9407,$9408,$9409,$940A,$940B,
$940C,$940D,$940E,$940F,$9410,$9411,$9412,$9413,$9414,$9415,$9416,$9417,$9418,
$9419,$941A,$941B,$941C,$941D,$941E,$941F,$9420,$9421,$9422,$9423,$9424,$9425,
$9426,$9427,$9428,$9429,$942A,$942B,$942C,$942D,$942E,$7EAD,$7EB0,$7EBE,$7EC0,
$7EC1,$7EC2,$7EC9,$7ECB,$7ECC,$7ED0,$7ED4,$7ED7,$7EDB,$7EE0,$7EE1,$7EE8,$7EEB,
$7EEE,$7EEF,$7EF1,$7EF2,$7F0D,$7EF6,$7EFA,$7EFB,$7EFE,$7F01,$7F02,$7F03,$7F07,
$7F08,$7F0B,$7F0C,$7F0F,$7F11,$7F12,$7F17,$7F19,$7F1C,$7F1B,$7F1F,$7F21,$7F22,
$7F23,$7F24,$7F25,$7F26,$7F27,$7F2A,$7F2B,$7F2C,$7F2D,$7F2F,$7F30,$7F31,$7F32,
$7F33,$7F35,$5E7A,$757F,$5DDB,$753E,$9095,$738E,$7391,$73AE,$73A2,$739F,$73CF,
$73C2,$73D1,$73B7,$73B3,$73C0,$73C9,$73C8,$73E5,$73D9,$987C,$740A,$73E9,$73E7,
$73DE,$73BA,$73F2,$740F,$742A,$745B,$7426,$7425,$7428,$7430,$742E,$742C,$942F,
$9430,$9431,$9432,$9433,$9434,$9435,$9436,$9437,$9438,$9439,$943A,$943B,$943C,
$943D,$943F,$9440,$9441,$9442,$9443,$9444,$9445,$9446,$9447,$9448,$9449,$944A,
$944B,$944C,$944D,$944E,$944F,$9450,$9451,$9452,$9453,$9454,$9455,$9456,$9457,
$9458,$9459,$945A,$945B,$945C,$945D,$945E,$945F,$9460,$9461,$9462,$9463,$9464,
$9465,$9466,$9467,$9468,$9469,$946A,$946C,$946D,$946E,$946F,$9470,$9471,$9472,
$9473,$9474,$9475,$9476,$9477,$9478,$9479,$947A,$947B,$947C,$947D,$947E,$947F,
$9480,$9481,$9482,$9483,$9484,$9491,$9496,$9498,$94C7,$94CF,$94D3,$94D4,$94DA,
$94E6,$94FB,$951C,$9520,$741B,$741A,$7441,$745C,$7457,$7455,$7459,$7477,$746D,
$747E,$749C,$748E,$7480,$7481,$7487,$748B,$749E,$74A8,$74A9,$7490,$74A7,$74D2,
$74BA,$97EA,$97EB,$97EC,$674C,$6753,$675E,$6748,$6769,$67A5,$6787,$676A,$6773,
$6798,$67A7,$6775,$67A8,$679E,$67AD,$678B,$6777,$677C,$67F0,$6809,$67D8,$680A,
$67E9,$67B0,$680C,$67D9,$67B5,$67DA,$67B3,$67DD,$6800,$67C3,$67B8,$67E2,$680E,
$67C1,$67FD,$6832,$6833,$6860,$6861,$684E,$6862,$6844,$6864,$6883,$681D,$6855,
$6866,$6841,$6867,$6840,$683E,$684A,$6849,$6829,$68B5,$688F,$6874,$6877,$6893,
$686B,$68C2,$696E,$68FC,$691F,$6920,$68F9,$9527,$9533,$953D,$9543,$9548,$954B,
$9555,$955A,$9560,$956E,$9574,$9575,$9577,$9578,$9579,$957A,$957B,$957C,$957D,
$957E,$9580,$9581,$9582,$9583,$9584,$9585,$9586,$9587,$9588,$9589,$958A,$958B,
$958C,$958D,$958E,$958F,$9590,$9591,$9592,$9593,$9594,$9595,$9596,$9597,$9598,
$9599,$959A,$959B,$959C,$959D,$959E,$959F,$95A0,$95A1,$95A2,$95A3,$95A4,$95A5,
$95A6,$95A7,$95A8,$95A9,$95AA,$95AB,$95AC,$95AD,$95AE,$95AF,$95B0,$95B1,$95B2,
$95B3,$95B4,$95B5,$95B6,$95B7,$95B8,$95B9,$95BA,$95BB,$95BC,$95BD,$95BE,$95BF,
$95C0,$95C1,$95C2,$95C3,$95C4,$95C5,$95C6,$95C7,$95C8,$95C9,$95CA,$95CB,$6924,
$68F0,$690B,$6901,$6957,$68E3,$6910,$6971,$6939,$6960,$6942,$695D,$6984,$696B,
$6980,$6998,$6978,$6934,$69CC,$6987,$6988,$69CE,$6989,$6966,$6963,$6979,$699B,
$69A7,$69BB,$69AB,$69AD,$69D4,$69B1,$69C1,$69CA,$69DF,$6995,$69E0,$698D,$69FF,
$6A2F,$69ED,$6A17,$6A18,$6A65,$69F2,$6A44,$6A3E,$6AA0,$6A50,$6A5B,$6A35,$6A8E,
$6A79,$6A3D,$6A28,$6A58,$6A7C,$6A91,$6A90,$6AA9,$6A97,$6AAB,$7337,$7352,$6B81,
$6B82,$6B87,$6B84,$6B92,$6B93,$6B8D,$6B9A,$6B9B,$6BA1,$6BAA,$8F6B,$8F6D,$8F71,
$8F72,$8F73,$8F75,$8F76,$8F78,$8F77,$8F79,$8F7A,$8F7C,$8F7E,$8F81,$8F82,$8F84,
$8F87,$8F8B,$95CC,$95CD,$95CE,$95CF,$95D0,$95D1,$95D2,$95D3,$95D4,$95D5,$95D6,
$95D7,$95D8,$95D9,$95DA,$95DB,$95DC,$95DD,$95DE,$95DF,$95E0,$95E1,$95E2,$95E3,
$95E4,$95E5,$95E6,$95E7,$95EC,$95FF,$9607,$9613,$9618,$961B,$961E,$9620,$9623,
$9624,$9625,$9626,$9627,$9628,$9629,$962B,$962C,$962D,$962F,$9630,$9637,$9638,
$9639,$963A,$963E,$9641,$9643,$964A,$964E,$964F,$9651,$9652,$9653,$9656,$9657,
$9658,$9659,$965A,$965C,$965D,$965E,$9660,$9663,$9665,$9666,$966B,$966D,$966E,
$966F,$9670,$9671,$9673,$9678,$9679,$967A,$967B,$967C,$967D,$967E,$967F,$9680,
$9681,$9682,$9683,$9684,$9687,$9689,$968A,$8F8D,$8F8E,$8F8F,$8F98,$8F9A,$8ECE,
$620B,$6217,$621B,$621F,$6222,$6221,$6225,$6224,$622C,$81E7,$74EF,$74F4,$74FF,
$750F,$7511,$7513,$6534,$65EE,$65EF,$65F0,$660A,$6619,$6772,$6603,$6615,$6600,
$7085,$66F7,$661D,$6634,$6631,$6636,$6635,$8006,$665F,$6654,$6641,$664F,$6656,
$6661,$6657,$6677,$6684,$668C,$66A7,$669D,$66BE,$66DB,$66DC,$66E6,$66E9,$8D32,
$8D33,$8D36,$8D3B,$8D3D,$8D40,$8D45,$8D46,$8D48,$8D49,$8D47,$8D4D,$8D55,$8D59,
$89C7,$89CA,$89CB,$89CC,$89CE,$89CF,$89D0,$89D1,$726E,$729F,$725D,$7266,$726F,
$727E,$727F,$7284,$728B,$728D,$728F,$7292,$6308,$6332,$63B0,$968C,$968E,$9691,
$9692,$9693,$9695,$9696,$969A,$969B,$969D,$969E,$969F,$96A0,$96A1,$96A2,$96A3,
$96A4,$96A5,$96A6,$96A8,$96A9,$96AA,$96AB,$96AC,$96AD,$96AE,$96AF,$96B1,$96B2,
$96B4,$96B5,$96B7,$96B8,$96BA,$96BB,$96BF,$96C2,$96C3,$96C8,$96CA,$96CB,$96D0,
$96D1,$96D3,$96D4,$96D6,$96D7,$96D8,$96D9,$96DA,$96DB,$96DC,$96DD,$96DE,$96DF,
$96E1,$96E2,$96E3,$96E4,$96E5,$96E6,$96E7,$96EB,$96EC,$96ED,$96EE,$96F0,$96F1,
$96F2,$96F4,$96F5,$96F8,$96FA,$96FB,$96FC,$96FD,$96FF,$9702,$9703,$9705,$970A,
$970B,$970C,$9710,$9711,$9712,$9714,$9715,$9717,$9718,$9719,$971A,$971B,$971D,
$971F,$9720,$643F,$64D8,$8004,$6BEA,$6BF3,$6BFD,$6BF5,$6BF9,$6C05,$6C07,$6C06,
$6C0D,$6C15,$6C18,$6C19,$6C1A,$6C21,$6C29,$6C24,$6C2A,$6C32,$6535,$6555,$656B,
$724D,$7252,$7256,$7230,$8662,$5216,$809F,$809C,$8093,$80BC,$670A,$80BD,$80B1,
$80AB,$80AD,$80B4,$80B7,$80E7,$80E8,$80E9,$80EA,$80DB,$80C2,$80C4,$80D9,$80CD,
$80D7,$6710,$80DD,$80EB,$80F1,$80F4,$80ED,$810D,$810E,$80F2,$80FC,$6715,$8112,
$8C5A,$8136,$811E,$812C,$8118,$8132,$8148,$814C,$8153,$8174,$8159,$815A,$8171,
$8160,$8169,$817C,$817D,$816D,$8167,$584D,$5AB5,$8188,$8182,$8191,$6ED5,$81A3,
$81AA,$81CC,$6726,$81CA,$81BB,$9721,$9722,$9723,$9724,$9725,$9726,$9727,$9728,
$9729,$972B,$972C,$972E,$972F,$9731,$9733,$9734,$9735,$9736,$9737,$973A,$973B,
$973C,$973D,$973F,$9740,$9741,$9742,$9743,$9744,$9745,$9746,$9747,$9748,$9749,
$974A,$974B,$974C,$974D,$974E,$974F,$9750,$9751,$9754,$9755,$9757,$9758,$975A,
$975C,$975D,$975F,$9763,$9764,$9766,$9767,$9768,$976A,$976B,$976C,$976D,$976E,
$976F,$9770,$9771,$9772,$9775,$9777,$9778,$9779,$977A,$977B,$977D,$977E,$977F,
$9780,$9781,$9782,$9783,$9784,$9786,$9787,$9788,$9789,$978A,$978C,$978E,$978F,
$9790,$9793,$9795,$9796,$9797,$9799,$979A,$979B,$979C,$979D,$81C1,$81A6,$6B24,
$6B37,$6B39,$6B43,$6B46,$6B59,$98D1,$98D2,$98D3,$98D5,$98D9,$98DA,$6BB3,$5F40,
$6BC2,$89F3,$6590,$9F51,$6593,$65BC,$65C6,$65C4,$65C3,$65CC,$65CE,$65D2,$65D6,
$7080,$709C,$7096,$709D,$70BB,$70C0,$70B7,$70AB,$70B1,$70E8,$70CA,$7110,$7113,
$7116,$712F,$7131,$7173,$715C,$7168,$7145,$7172,$714A,$7178,$717A,$7198,$71B3,
$71B5,$71A8,$71A0,$71E0,$71D4,$71E7,$71F9,$721D,$7228,$706C,$7118,$7166,$71B9,
$623E,$623D,$6243,$6248,$6249,$793B,$7940,$7946,$7949,$795B,$795C,$7953,$795A,
$7962,$7957,$7960,$796F,$7967,$797A,$7985,$798A,$799A,$79A7,$79B3,$5FD1,$5FD0,
$979E,$979F,$97A1,$97A2,$97A4,$97A5,$97A6,$97A7,$97A8,$97A9,$97AA,$97AC,$97AE,
$97B0,$97B1,$97B3,$97B5,$97B6,$97B7,$97B8,$97B9,$97BA,$97BB,$97BC,$97BD,$97BE,
$97BF,$97C0,$97C1,$97C2,$97C3,$97C4,$97C5,$97C6,$97C7,$97C8,$97C9,$97CA,$97CB,
$97CC,$97CD,$97CE,$97CF,$97D0,$97D1,$97D2,$97D3,$97D4,$97D5,$97D6,$97D7,$97D8,
$97D9,$97DA,$97DB,$97DC,$97DD,$97DE,$97DF,$97E0,$97E1,$97E2,$97E3,$97E4,$97E5,
$97E8,$97EE,$97EF,$97F0,$97F1,$97F2,$97F4,$97F7,$97F8,$97F9,$97FA,$97FB,$97FC,
$97FD,$97FE,$97FF,$9800,$9801,$9802,$9803,$9804,$9805,$9806,$9807,$9808,$9809,
$980A,$980B,$980C,$980D,$980E,$603C,$605D,$605A,$6067,$6041,$6059,$6063,$60AB,
$6106,$610D,$615D,$61A9,$619D,$61CB,$61D1,$6206,$8080,$807F,$6C93,$6CF6,$6DFC,
$77F6,$77F8,$7800,$7809,$7817,$7818,$7811,$65AB,$782D,$781C,$781D,$7839,$783A,
$783B,$781F,$783C,$7825,$782C,$7823,$7829,$784E,$786D,$7856,$7857,$7826,$7850,
$7847,$784C,$786A,$789B,$7893,$789A,$7887,$789C,$78A1,$78A3,$78B2,$78B9,$78A5,
$78D4,$78D9,$78C9,$78EC,$78F2,$7905,$78F4,$7913,$7924,$791E,$7934,$9F9B,$9EF9,
$9EFB,$9EFC,$76F1,$7704,$770D,$76F9,$7707,$7708,$771A,$7722,$7719,$772D,$7726,
$7735,$7738,$7750,$7751,$7747,$7743,$775A,$7768,$980F,$9810,$9811,$9812,$9813,
$9814,$9815,$9816,$9817,$9818,$9819,$981A,$981B,$981C,$981D,$981E,$981F,$9820,
$9821,$9822,$9823,$9824,$9825,$9826,$9827,$9828,$9829,$982A,$982B,$982C,$982D,
$982E,$982F,$9830,$9831,$9832,$9833,$9834,$9835,$9836,$9837,$9838,$9839,$983A,
$983B,$983C,$983D,$983E,$983F,$9840,$9841,$9842,$9843,$9844,$9845,$9846,$9847,
$9848,$9849,$984A,$984B,$984C,$984D,$984E,$984F,$9850,$9851,$9852,$9853,$9854,
$9855,$9856,$9857,$9858,$9859,$985A,$985B,$985C,$985D,$985E,$985F,$9860,$9861,
$9862,$9863,$9864,$9865,$9866,$9867,$9868,$9869,$986A,$986B,$986C,$986D,$986E,
$7762,$7765,$777F,$778D,$777D,$7780,$778C,$7791,$779F,$77A0,$77B0,$77B5,$77BD,
$753A,$7540,$754E,$754B,$7548,$755B,$7572,$7579,$7583,$7F58,$7F61,$7F5F,$8A48,
$7F68,$7F74,$7F71,$7F79,$7F81,$7F7E,$76CD,$76E5,$8832,$9485,$9486,$9487,$948B,
$948A,$948C,$948D,$948F,$9490,$9494,$9497,$9495,$949A,$949B,$949C,$94A3,$94A4,
$94AB,$94AA,$94AD,$94AC,$94AF,$94B0,$94B2,$94B4,$94B6,$94B7,$94B8,$94B9,$94BA,
$94BC,$94BD,$94BF,$94C4,$94C8,$94C9,$94CA,$94CB,$94CC,$94CD,$94CE,$94D0,$94D1,
$94D2,$94D5,$94D6,$94D7,$94D9,$94D8,$94DB,$94DE,$94DF,$94E0,$94E2,$94E4,$94E5,
$94E7,$94E8,$94EA,$986F,$9870,$9871,$9872,$9873,$9874,$988B,$988E,$9892,$9895,
$9899,$98A3,$98A8,$98A9,$98AA,$98AB,$98AC,$98AD,$98AE,$98AF,$98B0,$98B1,$98B2,
$98B3,$98B4,$98B5,$98B6,$98B7,$98B8,$98B9,$98BA,$98BB,$98BC,$98BD,$98BE,$98BF,
$98C0,$98C1,$98C2,$98C3,$98C4,$98C5,$98C6,$98C7,$98C8,$98C9,$98CA,$98CB,$98CC,
$98CD,$98CF,$98D0,$98D4,$98D6,$98D7,$98DB,$98DC,$98DD,$98E0,$98E1,$98E2,$98E3,
$98E4,$98E5,$98E6,$98E9,$98EA,$98EB,$98EC,$98ED,$98EE,$98EF,$98F0,$98F1,$98F2,
$98F3,$98F4,$98F5,$98F6,$98F7,$98F8,$98F9,$98FA,$98FB,$98FC,$98FD,$98FE,$98FF,
$9900,$9901,$9902,$9903,$9904,$9905,$9906,$9907,$94E9,$94EB,$94EE,$94EF,$94F3,
$94F4,$94F5,$94F7,$94F9,$94FC,$94FD,$94FF,$9503,$9502,$9506,$9507,$9509,$950A,
$950D,$950E,$950F,$9512,$9513,$9514,$9515,$9516,$9518,$951B,$951D,$951E,$951F,
$9522,$952A,$952B,$9529,$952C,$9531,$9532,$9534,$9536,$9537,$9538,$953C,$953E,
$953F,$9542,$9535,$9544,$9545,$9546,$9549,$954C,$954E,$954F,$9552,$9553,$9554,
$9556,$9557,$9558,$9559,$955B,$955E,$955F,$955D,$9561,$9562,$9564,$9565,$9566,
$9567,$9568,$9569,$956A,$956B,$956C,$956F,$9571,$9572,$9573,$953A,$77E7,$77EC,
$96C9,$79D5,$79ED,$79E3,$79EB,$7A06,$5D47,$7A03,$7A02,$7A1E,$7A14,$9908,$9909,
$990A,$990B,$990C,$990E,$990F,$9911,$9912,$9913,$9914,$9915,$9916,$9917,$9918,
$9919,$991A,$991B,$991C,$991D,$991E,$991F,$9920,$9921,$9922,$9923,$9924,$9925,
$9926,$9927,$9928,$9929,$992A,$992B,$992C,$992D,$992F,$9930,$9931,$9932,$9933,
$9934,$9935,$9936,$9937,$9938,$9939,$993A,$993B,$993C,$993D,$993E,$993F,$9940,
$9941,$9942,$9943,$9944,$9945,$9946,$9947,$9948,$9949,$994A,$994B,$994C,$994D,
$994E,$994F,$9950,$9951,$9952,$9953,$9956,$9957,$9958,$9959,$995A,$995B,$995C,
$995D,$995E,$995F,$9960,$9961,$9962,$9964,$9966,$9973,$9978,$9979,$997B,$997E,
$9982,$9983,$9989,$7A39,$7A37,$7A51,$9ECF,$99A5,$7A70,$7688,$768E,$7693,$7699,
$76A4,$74DE,$74E0,$752C,$9E20,$9E22,$9E28,$9E29,$9E2A,$9E2B,$9E2C,$9E32,$9E31,
$9E36,$9E38,$9E37,$9E39,$9E3A,$9E3E,$9E41,$9E42,$9E44,$9E46,$9E47,$9E48,$9E49,
$9E4B,$9E4C,$9E4E,$9E51,$9E55,$9E57,$9E5A,$9E5B,$9E5C,$9E5E,$9E63,$9E66,$9E67,
$9E68,$9E69,$9E6A,$9E6B,$9E6C,$9E71,$9E6D,$9E73,$7592,$7594,$7596,$75A0,$759D,
$75AC,$75A3,$75B3,$75B4,$75B8,$75C4,$75B1,$75B0,$75C3,$75C2,$75D6,$75CD,$75E3,
$75E8,$75E6,$75E4,$75EB,$75E7,$7603,$75F1,$75FC,$75FF,$7610,$7600,$7605,$760C,
$7617,$760A,$7625,$7618,$7615,$7619,$998C,$998E,$999A,$999B,$999C,$999D,$999E,
$999F,$99A0,$99A1,$99A2,$99A3,$99A4,$99A6,$99A7,$99A9,$99AA,$99AB,$99AC,$99AD,
$99AE,$99AF,$99B0,$99B1,$99B2,$99B3,$99B4,$99B5,$99B6,$99B7,$99B8,$99B9,$99BA,
$99BB,$99BC,$99BD,$99BE,$99BF,$99C0,$99C1,$99C2,$99C3,$99C4,$99C5,$99C6,$99C7,
$99C8,$99C9,$99CA,$99CB,$99CC,$99CD,$99CE,$99CF,$99D0,$99D1,$99D2,$99D3,$99D4,
$99D5,$99D6,$99D7,$99D8,$99D9,$99DA,$99DB,$99DC,$99DD,$99DE,$99DF,$99E0,$99E1,
$99E2,$99E3,$99E4,$99E5,$99E6,$99E7,$99E8,$99E9,$99EA,$99EB,$99EC,$99ED,$99EE,
$99EF,$99F0,$99F1,$99F2,$99F3,$99F4,$99F5,$99F6,$99F7,$99F8,$99F9,$761B,$763C,
$7622,$7620,$7640,$762D,$7630,$763F,$7635,$7643,$763E,$7633,$764D,$765E,$7654,
$765C,$7656,$766B,$766F,$7FCA,$7AE6,$7A78,$7A79,$7A80,$7A86,$7A88,$7A95,$7AA6,
$7AA0,$7AAC,$7AA8,$7AAD,$7AB3,$8864,$8869,$8872,$887D,$887F,$8882,$88A2,$88C6,
$88B7,$88BC,$88C9,$88E2,$88CE,$88E3,$88E5,$88F1,$891A,$88FC,$88E8,$88FE,$88F0,
$8921,$8919,$8913,$891B,$890A,$8934,$892B,$8936,$8941,$8966,$897B,$758B,$80E5,
$76B2,$76B4,$77DC,$8012,$8014,$8016,$801C,$8020,$8022,$8025,$8026,$8027,$8029,
$8028,$8031,$800B,$8035,$8043,$8046,$804D,$8052,$8069,$8071,$8983,$9878,$9880,
$9883,$99FA,$99FB,$99FC,$99FD,$99FE,$99FF,$9A00,$9A01,$9A02,$9A03,$9A04,$9A05,
$9A06,$9A07,$9A08,$9A09,$9A0A,$9A0B,$9A0C,$9A0D,$9A0E,$9A0F,$9A10,$9A11,$9A12,
$9A13,$9A14,$9A15,$9A16,$9A17,$9A18,$9A19,$9A1A,$9A1B,$9A1C,$9A1D,$9A1E,$9A1F,
$9A20,$9A21,$9A22,$9A23,$9A24,$9A25,$9A26,$9A27,$9A28,$9A29,$9A2A,$9A2B,$9A2C,
$9A2D,$9A2E,$9A2F,$9A30,$9A31,$9A32,$9A33,$9A34,$9A35,$9A36,$9A37,$9A38,$9A39,
$9A3A,$9A3B,$9A3C,$9A3D,$9A3E,$9A3F,$9A40,$9A41,$9A42,$9A43,$9A44,$9A45,$9A46,
$9A47,$9A48,$9A49,$9A4A,$9A4B,$9A4C,$9A4D,$9A4E,$9A4F,$9A50,$9A51,$9A52,$9A53,
$9A54,$9A55,$9A56,$9A57,$9A58,$9A59,$9889,$988C,$988D,$988F,$9894,$989A,$989B,
$989E,$989F,$98A1,$98A2,$98A5,$98A6,$864D,$8654,$866C,$866E,$867F,$867A,$867C,
$867B,$86A8,$868D,$868B,$86AC,$869D,$86A7,$86A3,$86AA,$8693,$86A9,$86B6,$86C4,
$86B5,$86CE,$86B0,$86BA,$86B1,$86AF,$86C9,$86CF,$86B4,$86E9,$86F1,$86F2,$86ED,
$86F3,$86D0,$8713,$86DE,$86F4,$86DF,$86D8,$86D1,$8703,$8707,$86F8,$8708,$870A,
$870D,$8709,$8723,$873B,$871E,$8725,$872E,$871A,$873E,$8748,$8734,$8731,$8729,
$8737,$873F,$8782,$8722,$877D,$877E,$877B,$8760,$8770,$874C,$876E,$878B,$8753,
$8763,$877C,$8764,$8759,$8765,$8793,$87AF,$87A8,$87D2,$9A5A,$9A5B,$9A5C,$9A5D,
$9A5E,$9A5F,$9A60,$9A61,$9A62,$9A63,$9A64,$9A65,$9A66,$9A67,$9A68,$9A69,$9A6A,
$9A6B,$9A72,$9A83,$9A89,$9A8D,$9A8E,$9A94,$9A95,$9A99,$9AA6,$9AA9,$9AAA,$9AAB,
$9AAC,$9AAD,$9AAE,$9AAF,$9AB2,$9AB3,$9AB4,$9AB5,$9AB9,$9ABB,$9ABD,$9ABE,$9ABF,
$9AC3,$9AC4,$9AC6,$9AC7,$9AC8,$9AC9,$9ACA,$9ACD,$9ACE,$9ACF,$9AD0,$9AD2,$9AD4,
$9AD5,$9AD6,$9AD7,$9AD9,$9ADA,$9ADB,$9ADC,$9ADD,$9ADE,$9AE0,$9AE2,$9AE3,$9AE4,
$9AE5,$9AE7,$9AE8,$9AE9,$9AEA,$9AEC,$9AEE,$9AF0,$9AF1,$9AF2,$9AF3,$9AF4,$9AF5,
$9AF6,$9AF7,$9AF8,$9AFA,$9AFC,$9AFD,$9AFE,$9AFF,$9B00,$9B01,$9B02,$9B04,$9B05,
$9B06,$87C6,$8788,$8785,$87AD,$8797,$8783,$87AB,$87E5,$87AC,$87B5,$87B3,$87CB,
$87D3,$87BD,$87D1,$87C0,$87CA,$87DB,$87EA,$87E0,$87EE,$8816,$8813,$87FE,$880A,
$881B,$8821,$8839,$883C,$7F36,$7F42,$7F44,$7F45,$8210,$7AFA,$7AFD,$7B08,$7B03,
$7B04,$7B15,$7B0A,$7B2B,$7B0F,$7B47,$7B38,$7B2A,$7B19,$7B2E,$7B31,$7B20,$7B25,
$7B24,$7B33,$7B3E,$7B1E,$7B58,$7B5A,$7B45,$7B75,$7B4C,$7B5D,$7B60,$7B6E,$7B7B,
$7B62,$7B72,$7B71,$7B90,$7BA6,$7BA7,$7BB8,$7BAC,$7B9D,$7BA8,$7B85,$7BAA,$7B9C,
$7BA2,$7BAB,$7BB4,$7BD1,$7BC1,$7BCC,$7BDD,$7BDA,$7BE5,$7BE6,$7BEA,$7C0C,$7BFE,
$7BFC,$7C0F,$7C16,$7C0B,$9B07,$9B09,$9B0A,$9B0B,$9B0C,$9B0D,$9B0E,$9B10,$9B11,
$9B12,$9B14,$9B15,$9B16,$9B17,$9B18,$9B19,$9B1A,$9B1B,$9B1C,$9B1D,$9B1E,$9B20,
$9B21,$9B22,$9B24,$9B25,$9B26,$9B27,$9B28,$9B29,$9B2A,$9B2B,$9B2C,$9B2D,$9B2E,
$9B30,$9B31,$9B33,$9B34,$9B35,$9B36,$9B37,$9B38,$9B39,$9B3A,$9B3D,$9B3E,$9B3F,
$9B40,$9B46,$9B4A,$9B4B,$9B4C,$9B4E,$9B50,$9B52,$9B53,$9B55,$9B56,$9B57,$9B58,
$9B59,$9B5A,$9B5B,$9B5C,$9B5D,$9B5E,$9B5F,$9B60,$9B61,$9B62,$9B63,$9B64,$9B65,
$9B66,$9B67,$9B68,$9B69,$9B6A,$9B6B,$9B6C,$9B6D,$9B6E,$9B6F,$9B70,$9B71,$9B72,
$9B73,$9B74,$9B75,$9B76,$9B77,$9B78,$9B79,$9B7A,$9B7B,$7C1F,$7C2A,$7C26,$7C38,
$7C41,$7C40,$81FE,$8201,$8202,$8204,$81EC,$8844,$8221,$8222,$8223,$822D,$822F,
$8228,$822B,$8238,$823B,$8233,$8234,$823E,$8244,$8249,$824B,$824F,$825A,$825F,
$8268,$887E,$8885,$8888,$88D8,$88DF,$895E,$7F9D,$7F9F,$7FA7,$7FAF,$7FB0,$7FB2,
$7C7C,$6549,$7C91,$7C9D,$7C9C,$7C9E,$7CA2,$7CB2,$7CBC,$7CBD,$7CC1,$7CC7,$7CCC,
$7CCD,$7CC8,$7CC5,$7CD7,$7CE8,$826E,$66A8,$7FBF,$7FCE,$7FD5,$7FE5,$7FE1,$7FE6,
$7FE9,$7FEE,$7FF3,$7CF8,$7D77,$7DA6,$7DAE,$7E47,$7E9B,$9EB8,$9EB4,$8D73,$8D84,
$8D94,$8D91,$8DB1,$8D67,$8D6D,$8C47,$8C49,$914A,$9150,$914E,$914F,$9164,$9B7C,
$9B7D,$9B7E,$9B7F,$9B80,$9B81,$9B82,$9B83,$9B84,$9B85,$9B86,$9B87,$9B88,$9B89,
$9B8A,$9B8B,$9B8C,$9B8D,$9B8E,$9B8F,$9B90,$9B91,$9B92,$9B93,$9B94,$9B95,$9B96,
$9B97,$9B98,$9B99,$9B9A,$9B9B,$9B9C,$9B9D,$9B9E,$9B9F,$9BA0,$9BA1,$9BA2,$9BA3,
$9BA4,$9BA5,$9BA6,$9BA7,$9BA8,$9BA9,$9BAA,$9BAB,$9BAC,$9BAD,$9BAE,$9BAF,$9BB0,
$9BB1,$9BB2,$9BB3,$9BB4,$9BB5,$9BB6,$9BB7,$9BB8,$9BB9,$9BBA,$9BBB,$9BBC,$9BBD,
$9BBE,$9BBF,$9BC0,$9BC1,$9BC2,$9BC3,$9BC4,$9BC5,$9BC6,$9BC7,$9BC8,$9BC9,$9BCA,
$9BCB,$9BCC,$9BCD,$9BCE,$9BCF,$9BD0,$9BD1,$9BD2,$9BD3,$9BD4,$9BD5,$9BD6,$9BD7,
$9BD8,$9BD9,$9BDA,$9BDB,$9162,$9161,$9170,$9169,$916F,$917D,$917E,$9172,$9174,
$9179,$918C,$9185,$9190,$918D,$9191,$91A2,$91A3,$91AA,$91AD,$91AE,$91AF,$91B5,
$91B4,$91BA,$8C55,$9E7E,$8DB8,$8DEB,$8E05,$8E59,$8E69,$8DB5,$8DBF,$8DBC,$8DBA,
$8DC4,$8DD6,$8DD7,$8DDA,$8DDE,$8DCE,$8DCF,$8DDB,$8DC6,$8DEC,$8DF7,$8DF8,$8DE3,
$8DF9,$8DFB,$8DE4,$8E09,$8DFD,$8E14,$8E1D,$8E1F,$8E2C,$8E2E,$8E23,$8E2F,$8E3A,
$8E40,$8E39,$8E35,$8E3D,$8E31,$8E49,$8E41,$8E42,$8E51,$8E52,$8E4A,$8E70,$8E76,
$8E7C,$8E6F,$8E74,$8E85,$8E8F,$8E94,$8E90,$8E9C,$8E9E,$8C78,$8C82,$8C8A,$8C85,
$8C98,$8C94,$659B,$89D6,$89DE,$89DA,$89DC,$9BDC,$9BDD,$9BDE,$9BDF,$9BE0,$9BE1,
$9BE2,$9BE3,$9BE4,$9BE5,$9BE6,$9BE7,$9BE8,$9BE9,$9BEA,$9BEB,$9BEC,$9BED,$9BEE,
$9BEF,$9BF0,$9BF1,$9BF2,$9BF3,$9BF4,$9BF5,$9BF6,$9BF7,$9BF8,$9BF9,$9BFA,$9BFB,
$9BFC,$9BFD,$9BFE,$9BFF,$9C00,$9C01,$9C02,$9C03,$9C04,$9C05,$9C06,$9C07,$9C08,
$9C09,$9C0A,$9C0B,$9C0C,$9C0D,$9C0E,$9C0F,$9C10,$9C11,$9C12,$9C13,$9C14,$9C15,
$9C16,$9C17,$9C18,$9C19,$9C1A,$9C1B,$9C1C,$9C1D,$9C1E,$9C1F,$9C20,$9C21,$9C22,
$9C23,$9C24,$9C25,$9C26,$9C27,$9C28,$9C29,$9C2A,$9C2B,$9C2C,$9C2D,$9C2E,$9C2F,
$9C30,$9C31,$9C32,$9C33,$9C34,$9C35,$9C36,$9C37,$9C38,$9C39,$9C3A,$9C3B,$89E5,
$89EB,$89EF,$8A3E,$8B26,$9753,$96E9,$96F3,$96EF,$9706,$9701,$9708,$970F,$970E,
$972A,$972D,$9730,$973E,$9F80,$9F83,$9F85,$9F86,$9F87,$9F88,$9F89,$9F8A,$9F8C,
$9EFE,$9F0B,$9F0D,$96B9,$96BC,$96BD,$96CE,$96D2,$77BF,$96E0,$928E,$92AE,$92C8,
$933E,$936A,$93CA,$938F,$943E,$946B,$9C7F,$9C82,$9C85,$9C86,$9C87,$9C88,$7A23,
$9C8B,$9C8E,$9C90,$9C91,$9C92,$9C94,$9C95,$9C9A,$9C9B,$9C9E,$9C9F,$9CA0,$9CA1,
$9CA2,$9CA3,$9CA5,$9CA6,$9CA7,$9CA8,$9CA9,$9CAB,$9CAD,$9CAE,$9CB0,$9CB1,$9CB2,
$9CB3,$9CB4,$9CB5,$9CB6,$9CB7,$9CBA,$9CBB,$9CBC,$9CBD,$9CC4,$9CC5,$9CC6,$9CC7,
$9CCA,$9CCB,$9C3C,$9C3D,$9C3E,$9C3F,$9C40,$9C41,$9C42,$9C43,$9C44,$9C45,$9C46,
$9C47,$9C48,$9C49,$9C4A,$9C4B,$9C4C,$9C4D,$9C4E,$9C4F,$9C50,$9C51,$9C52,$9C53,
$9C54,$9C55,$9C56,$9C57,$9C58,$9C59,$9C5A,$9C5B,$9C5C,$9C5D,$9C5E,$9C5F,$9C60,
$9C61,$9C62,$9C63,$9C64,$9C65,$9C66,$9C67,$9C68,$9C69,$9C6A,$9C6B,$9C6C,$9C6D,
$9C6E,$9C6F,$9C70,$9C71,$9C72,$9C73,$9C74,$9C75,$9C76,$9C77,$9C78,$9C79,$9C7A,
$9C7B,$9C7D,$9C7E,$9C80,$9C83,$9C84,$9C89,$9C8A,$9C8C,$9C8F,$9C93,$9C96,$9C97,
$9C98,$9C99,$9C9D,$9CAA,$9CAC,$9CAF,$9CB9,$9CBE,$9CBF,$9CC0,$9CC1,$9CC2,$9CC8,
$9CC9,$9CD1,$9CD2,$9CDA,$9CDB,$9CE0,$9CE1,$9CCC,$9CCD,$9CCE,$9CCF,$9CD0,$9CD3,
$9CD4,$9CD5,$9CD7,$9CD8,$9CD9,$9CDC,$9CDD,$9CDF,$9CE2,$977C,$9785,$9791,$9792,
$9794,$97AF,$97AB,$97A3,$97B2,$97B4,$9AB1,$9AB0,$9AB7,$9E58,$9AB6,$9ABA,$9ABC,
$9AC1,$9AC0,$9AC5,$9AC2,$9ACB,$9ACC,$9AD1,$9B45,$9B43,$9B47,$9B49,$9B48,$9B4D,
$9B51,$98E8,$990D,$992E,$9955,$9954,$9ADF,$9AE1,$9AE6,$9AEF,$9AEB,$9AFB,$9AED,
$9AF9,$9B08,$9B0F,$9B13,$9B1F,$9B23,$9EBD,$9EBE,$7E3B,$9E82,$9E87,$9E88,$9E8B,
$9E92,$93D6,$9E9D,$9E9F,$9EDB,$9EDC,$9EDD,$9EE0,$9EDF,$9EE2,$9EE9,$9EE7,$9EE5,
$9EEA,$9EEF,$9F22,$9F2C,$9F2F,$9F39,$9F37,$9F3D,$9F3E,$9F44,$9CE3,$9CE4,$9CE5,
$9CE6,$9CE7,$9CE8,$9CE9,$9CEA,$9CEB,$9CEC,$9CED,$9CEE,$9CEF,$9CF0,$9CF1,$9CF2,
$9CF3,$9CF4,$9CF5,$9CF6,$9CF7,$9CF8,$9CF9,$9CFA,$9CFB,$9CFC,$9CFD,$9CFE,$9CFF,
$9D00,$9D01,$9D02,$9D03,$9D04,$9D05,$9D06,$9D07,$9D08,$9D09,$9D0A,$9D0B,$9D0C,
$9D0D,$9D0E,$9D0F,$9D10,$9D11,$9D12,$9D13,$9D14,$9D15,$9D16,$9D17,$9D18,$9D19,
$9D1A,$9D1B,$9D1C,$9D1D,$9D1E,$9D1F,$9D20,$9D21,$9D22,$9D23,$9D24,$9D25,$9D26,
$9D27,$9D28,$9D29,$9D2A,$9D2B,$9D2C,$9D2D,$9D2E,$9D2F,$9D30,$9D31,$9D32,$9D33,
$9D34,$9D35,$9D36,$9D37,$9D38,$9D39,$9D3A,$9D3B,$9D3C,$9D3D,$9D3E,$9D3F,$9D40,
$9D41,$9D42,$9D43,$9D44,$9D45,$9D46,$9D47,$9D48,$9D49,$9D4A,$9D4B,$9D4C,$9D4D,
$9D4E,$9D4F,$9D50,$9D51,$9D52,$9D53,$9D54,$9D55,$9D56,$9D57,$9D58,$9D59,$9D5A,
$9D5B,$9D5C,$9D5D,$9D5E,$9D5F,$9D60,$9D61,$9D62,$9D63,$9D64,$9D65,$9D66,$9D67,
$9D68,$9D69,$9D6A,$9D6B,$9D6C,$9D6D,$9D6E,$9D6F,$9D70,$9D71,$9D72,$9D73,$9D74,
$9D75,$9D76,$9D77,$9D78,$9D79,$9D7A,$9D7B,$9D7C,$9D7D,$9D7E,$9D7F,$9D80,$9D81,
$9D82,$9D83,$9D84,$9D85,$9D86,$9D87,$9D88,$9D89,$9D8A,$9D8B,$9D8C,$9D8D,$9D8E,
$9D8F,$9D90,$9D91,$9D92,$9D93,$9D94,$9D95,$9D96,$9D97,$9D98,$9D99,$9D9A,$9D9B,
$9D9C,$9D9D,$9D9E,$9D9F,$9DA0,$9DA1,$9DA2,$9DA3,$9DA4,$9DA5,$9DA6,$9DA7,$9DA8,
$9DA9,$9DAA,$9DAB,$9DAC,$9DAD,$9DAE,$9DAF,$9DB0,$9DB1,$9DB2,$9DB3,$9DB4,$9DB5,
$9DB6,$9DB7,$9DB8,$9DB9,$9DBA,$9DBB,$9DBC,$9DBD,$9DBE,$9DBF,$9DC0,$9DC1,$9DC2,
$9DC3,$9DC4,$9DC5,$9DC6,$9DC7,$9DC8,$9DC9,$9DCA,$9DCB,$9DCC,$9DCD,$9DCE,$9DCF,
$9DD0,$9DD1,$9DD2,$9DD3,$9DD4,$9DD5,$9DD6,$9DD7,$9DD8,$9DD9,$9DDA,$9DDB,$9DDC,
$9DDD,$9DDE,$9DDF,$9DE0,$9DE1,$9DE2,$9DE3,$9DE4,$9DE5,$9DE6,$9DE7,$9DE8,$9DE9,
$9DEA,$9DEB,$9DEC,$9DED,$9DEE,$9DEF,$9DF0,$9DF1,$9DF2,$9DF3,$9DF4,$9DF5,$9DF6,
$9DF7,$9DF8,$9DF9,$9DFA,$9DFB,$9DFC,$9DFD,$9DFE,$9DFF,$9E00,$9E01,$9E02,$9E03,
$9E04,$9E05,$9E06,$9E07,$9E08,$9E09,$9E0A,$9E0B,$9E0C,$9E0D,$9E0E,$9E0F,$9E10,
$9E11,$9E12,$9E13,$9E14,$9E15,$9E16,$9E17,$9E18,$9E19,$9E1A,$9E1B,$9E1C,$9E1D,
$9E1E,$9E24,$9E27,$9E2E,$9E30,$9E34,$9E3B,$9E3C,$9E40,$9E4D,$9E50,$9E52,$9E53,
$9E54,$9E56,$9E59,$9E5D,$9E5F,$9E60,$9E61,$9E62,$9E65,$9E6E,$9E6F,$9E72,$9E74,
$9E75,$9E76,$9E77,$9E78,$9E79,$9E7A,$9E7B,$9E7C,$9E7D,$9E80,$9E81,$9E83,$9E84,
$9E85,$9E86,$9E89,$9E8A,$9E8C,$9E8D,$9E8E,$9E8F,$9E90,$9E91,$9E94,$9E95,$9E96,
$9E97,$9E98,$9E99,$9E9A,$9E9B,$9E9C,$9E9E,$9EA0,$9EA1,$9EA2,$9EA3,$9EA4,$9EA5,
$9EA7,$9EA8,$9EA9,$9EAA,$9EAB,$9EAC,$9EAD,$9EAE,$9EAF,$9EB0,$9EB1,$9EB2,$9EB3,
$9EB5,$9EB6,$9EB7,$9EB9,$9EBA,$9EBC,$9EBF,$9EC0,$9EC1,$9EC2,$9EC3,$9EC5,$9EC6,
$9EC7,$9EC8,$9ECA,$9ECB,$9ECC,$9ED0,$9ED2,$9ED3,$9ED5,$9ED6,$9ED7,$9ED9,$9EDA,
$9EDE,$9EE1,$9EE3,$9EE4,$9EE6,$9EE8,$9EEB,$9EEC,$9EED,$9EEE,$9EF0,$9EF1,$9EF2,
$9EF3,$9EF4,$9EF5,$9EF6,$9EF7,$9EF8,$9EFA,$9EFD,$9EFF,$9F00,$9F01,$9F02,$9F03,
$9F04,$9F05,$9F06,$9F07,$9F08,$9F09,$9F0A,$9F0C,$9F0F,$9F11,$9F12,$9F14,$9F15,
$9F16,$9F18,$9F1A,$9F1B,$9F1C,$9F1D,$9F1E,$9F1F,$9F21,$9F23,$9F24,$9F25,$9F26,
$9F27,$9F28,$9F29,$9F2A,$9F2B,$9F2D,$9F2E,$9F30,$9F31,$9F32,$9F33,$9F34,$9F35,
$9F36,$9F38,$9F3A,$9F3C,$9F3F,$9F40,$9F41,$9F42,$9F43,$9F45,$9F46,$9F47,$9F48,
$9F49,$9F4A,$9F4B,$9F4C,$9F4D,$9F4E,$9F4F,$9F52,$9F53,$9F54,$9F55,$9F56,$9F57,
$9F58,$9F59,$9F5A,$9F5B,$9F5C,$9F5D,$9F5E,$9F5F,$9F60,$9F61,$9F62,$9F63,$9F64,
$9F65,$9F66,$9F67,$9F68,$9F69,$9F6A,$9F6B,$9F6C,$9F6D,$9F6E,$9F6F,$9F70,$9F71,
$9F72,$9F73,$9F74,$9F75,$9F76,$9F77,$9F78,$9F79,$9F7A,$9F7B,$9F7C,$9F7D,$9F7E,
$9F81,$9F82,$9F8D,$9F8E,$9F8F,$9F90,$9F91,$9F92,$9F93,$9F94,$9F95,$9F96,$9F97,
$9F98,$9F9C,$9F9D,$9F9E,$9FA1,$9FA2,$9FA3,$9FA4,$9FA5,$F92C,$F979,$F995,$F9E7,
$F9F1,$FA0C,$FA0D,$FA0E,$FA0F,$FA11,$FA13,$FA14,$FA18,$FA1F,$FA20,$FA21,$FA23,
$FA24,$FA27,$FA28,$FA29);

{$IfNDef UseSystemCPConv}
const CP936CU: CP936Arr =
($81,$82,$83,$84,$85,$86,$87,$88,$89,$8A,$8B,$8C,$8D,$8E,$8F,$90,$91,$92,$93,
$94,$95,$96,$97,$98,$99,$9A,$9B,$9C,$9D,$9E,$9F,$A0,$A1,$A2,$A3,$A4,$A5,$A6,
$A7,$A8,$A9,$AA,$AB,$AC,$AD,$AE,$AF,$B0,$B1,$B2,$B3,$B4,$B5,$B6,$B7,$B8,$B9,
$BA,$BB,$BC,$BD,$BE,$BF,$C0,$C1,$C2,$C3,$C4,$C5,$C6,$C7,$C8,$C9,$CA,$CB,$CC,
$CD,$CE,$CF,$D0,$D1,$D2,$D3,$D4,$D5,$D6,$D7,$D8,$D9,$DA,$DB,$DC,$DD,$DE,$DF,
$E0,$E1,$E2,$E3,$E4,$E5,$E6,$E7,$E8,$E9,$EA,$EB,$EC,$ED,$EE,$EF,$F0,$F1,$F2,
$F3,$F4,$F5,$F6,$F7,$F8,$F9,$FA,$FB,$FC,$FD,$FE,$FF,$00,$01,$02,$03,$04,$05,
$06,$07,$08,$09,$0A,$0B,$0C,$0D,$0E,$0F,$10,$11,$12,$13,$14,$15,$16,$17,$18,
$19,$1A,$1B,$1C,$1D,$1E,$1F,$20,$21,$22,$23,$24,$25,$26,$27,$28,$29,$2A,$2B,
$2C,$2D,$2E,$2F,$30,$31,$32,$33,$34,$35,$36,$37,$38,$39,$3A,$3B,$3C,$3D,$3E,
$3F,$40,$41,$42,$43,$44,$45,$46,$47,$48,$49,$4A,$4B,$4C,$4D,$4E,$4F,$50,$51,
$52,$53,$54,$55,$56,$57,$58,$59,$5A,$5B,$5C,$5D,$5E,$5F,$60,$61,$62,$63,$64,
$65,$66,$67,$68,$69,$6A,$6B,$6C,$6D,$6E,$6F,$70,$71,$72,$73,$74,$75,$76,$77,
$78,$79,$7A,$7B,$7C,$7D,$7E,$7F,$A1E8,$A1EC,$A1A7,$A1E3,$A1C0,$A1A4,$A1C1,$A8A4,
$A8A2,$A8A8,$A8A6,$A8BA,$A8AC,$A8AA,$A8B0,$A8AE,$A1C2,$A8B4,$A8B2,$A8B9,$A8A1,
$A8A5,$A8A7,$A8A9,$A8BD,$A8BE,$A8AD,$A8B1,$A8A3,$A8AB,$A8AF,$A8B3,$A8B5,$A8B6,
$A8B7,$A8B8,$A8BB,$A8C0,$A1A6,$A1A5,$A840,$A841,$A842,$A6A1,$A6A2,$A6A3,$A6A4,
$A6A5,$A6A6,$A6A7,$A6A8,$A6A9,$A6AA,$A6AB,$A6AC,$A6AD,$A6AE,$A6AF,$A6B0,$A6B1,
$A6B2,$A6B3,$A6B4,$A6B5,$A6B6,$A6B7,$A6B8,$A6C1,$A6C2,$A6C3,$A6C4,$A6C5,$A6C6,
$A6C7,$A6C8,$A6C9,$A6CA,$A6CB,$A6CC,$A6CD,$A6CE,$A6CF,$A6D0,$A6D1,$A6D2,$A6D3,
$A6D4,$A6D5,$A6D6,$A6D7,$A6D8,$A7A7,$A7A1,$A7A2,$A7A3,$A7A4,$A7A5,$A7A6,$A7A8,
$A7A9,$A7AA,$A7AB,$A7AC,$A7AD,$A7AE,$A7AF,$A7B0,$A7B1,$A7B2,$A7B3,$A7B4,$A7B5,
$A7B6,$A7B7,$A7B8,$A7B9,$A7BA,$A7BB,$A7BC,$A7BD,$A7BE,$A7BF,$A7C0,$A7C1,$A7D1,
$A7D2,$A7D3,$A7D4,$A7D5,$A7D6,$A7D8,$A7D9,$A7DA,$A7DB,$A7DC,$A7DD,$A7DE,$A7DF,
$A7E0,$A7E1,$A7E2,$A7E3,$A7E4,$A7E5,$A7E6,$A7E7,$A7E8,$A7E9,$A7EA,$A7EB,$A7EC,
$A7ED,$A7EE,$A7EF,$A7F0,$A7F1,$A7D7,$A95C,$A843,$A1AA,$A844,$A1AC,$A1AE,$A1AF,
$A1B0,$A1B1,$A845,$A1AD,$A1EB,$A1E4,$A1E5,$A846,$A1F9,$80,$A1E6,$A847,$A848,
$A1ED,$A959,$A2F1,$A2F2,$A2F3,$A2F4,$A2F5,$A2F6,$A2F7,$A2F8,$A2F9,$A2FA,$A2FB,
$A2FC,$A2A1,$A2A2,$A2A3,$A2A4,$A2A5,$A2A6,$A2A7,$A2A8,$A2A9,$A2AA,$A1FB,$A1FC,
$A1FA,$A1FD,$A849,$A84A,$A84B,$A84C,$A1CA,$A1C7,$A1C6,$A84D,$A1CC,$A1D8,$A1DE,
$A84E,$A1CF,$A84F,$A1CE,$A1C4,$A1C5,$A1C9,$A1C8,$A1D2,$A1D3,$A1E0,$A1DF,$A1C3,
$A1CB,$A1D7,$A1D6,$A1D5,$A850,$A1D9,$A1D4,$A1DC,$A1DD,$A851,$A852,$A1DA,$A1DB,
$A892,$A1D1,$A1CD,$A853,$A1D0,$A2D9,$A2DA,$A2DB,$A2DC,$A2DD,$A2DE,$A2DF,$A2E0,
$A2E1,$A2E2,$A2C5,$A2C6,$A2C7,$A2C8,$A2C9,$A2CA,$A2CB,$A2CC,$A2CD,$A2CE,$A2CF,
$A2D0,$A2D1,$A2D2,$A2D3,$A2D4,$A2D5,$A2D6,$A2D7,$A2D8,$A2B1,$A2B2,$A2B3,$A2B4,
$A2B5,$A2B6,$A2B7,$A2B8,$A2B9,$A2BA,$A2BB,$A2BC,$A2BD,$A2BE,$A2BF,$A2C0,$A2C1,
$A2C2,$A2C3,$A2C4,$A9A4,$A9A5,$A9A6,$A9A7,$A9A8,$A9A9,$A9AA,$A9AB,$A9AC,$A9AD,
$A9AE,$A9AF,$A9B0,$A9B1,$A9B2,$A9B3,$A9B4,$A9B5,$A9B6,$A9B7,$A9B8,$A9B9,$A9BA,
$A9BB,$A9BC,$A9BD,$A9BE,$A9BF,$A9C0,$A9C1,$A9C2,$A9C3,$A9C4,$A9C5,$A9C6,$A9C7,
$A9C8,$A9C9,$A9CA,$A9CB,$A9CC,$A9CD,$A9CE,$A9CF,$A9D0,$A9D1,$A9D2,$A9D3,$A9D4,
$A9D5,$A9D6,$A9D7,$A9D8,$A9D9,$A9DA,$A9DB,$A9DC,$A9DD,$A9DE,$A9DF,$A9E0,$A9E1,
$A9E2,$A9E3,$A9E4,$A9E5,$A9E6,$A9E7,$A9E8,$A9E9,$A9EA,$A9EB,$A9EC,$A9ED,$A9EE,
$A9EF,$A854,$A855,$A856,$A857,$A858,$A859,$A85A,$A85B,$A85C,$A85D,$A85E,$A85F,
$A860,$A861,$A862,$A863,$A864,$A865,$A866,$A867,$A868,$A869,$A86A,$A86B,$A86C,
$A86D,$A86E,$A86F,$A870,$A871,$A872,$A873,$A874,$A875,$A876,$A877,$A878,$A879,
$A87A,$A87B,$A87C,$A87D,$A87E,$A880,$A881,$A882,$A883,$A884,$A885,$A886,$A887,
$A888,$A889,$A88A,$A1F6,$A1F5,$A1F8,$A1F7,$A88B,$A88C,$A1F4,$A1F3,$A1F0,$A1F2,
$A1F1,$A88D,$A88E,$A88F,$A890,$A1EF,$A1EE,$A891,$A1E2,$A1E1,$A1A1,$A1A2,$A1A3,
$A1A8,$A1A9,$A965,$A996,$A1B4,$A1B5,$A1B6,$A1B7,$A1B8,$A1B9,$A1BA,$A1BB,$A1BE,
$A1BF,$A893,$A1FE,$A1B2,$A1B3,$A1BC,$A1BD,$A894,$A895,$A940,$A941,$A942,$A943,
$A944,$A945,$A946,$A947,$A948,$A4A1,$A4A2,$A4A3,$A4A4,$A4A5,$A4A6,$A4A7,$A4A8,
$A4A9,$A4AA,$A4AB,$A4AC,$A4AD,$A4AE,$A4AF,$A4B0,$A4B1,$A4B2,$A4B3,$A4B4,$A4B5,
$A4B6,$A4B7,$A4B8,$A4B9,$A4BA,$A4BB,$A4BC,$A4BD,$A4BE,$A4BF,$A4C0,$A4C1,$A4C2,
$A4C3,$A4C4,$A4C5,$A4C6,$A4C7,$A4C8,$A4C9,$A4CA,$A4CB,$A4CC,$A4CD,$A4CE,$A4CF,
$A4D0,$A4D1,$A4D2,$A4D3,$A4D4,$A4D5,$A4D6,$A4D7,$A4D8,$A4D9,$A4DA,$A4DB,$A4DC,
$A4DD,$A4DE,$A4DF,$A4E0,$A4E1,$A4E2,$A4E3,$A4E4,$A4E5,$A4E6,$A4E7,$A4E8,$A4E9,
$A4EA,$A4EB,$A4EC,$A4ED,$A4EE,$A4EF,$A4F0,$A4F1,$A4F2,$A4F3,$A961,$A962,$A966,
$A967,$A5A1,$A5A2,$A5A3,$A5A4,$A5A5,$A5A6,$A5A7,$A5A8,$A5A9,$A5AA,$A5AB,$A5AC,
$A5AD,$A5AE,$A5AF,$A5B0,$A5B1,$A5B2,$A5B3,$A5B4,$A5B5,$A5B6,$A5B7,$A5B8,$A5B9,
$A5BA,$A5BB,$A5BC,$A5BD,$A5BE,$A5BF,$A5C0,$A5C1,$A5C2,$A5C3,$A5C4,$A5C5,$A5C6,
$A5C7,$A5C8,$A5C9,$A5CA,$A5CB,$A5CC,$A5CD,$A5CE,$A5CF,$A5D0,$A5D1,$A5D2,$A5D3,
$A5D4,$A5D5,$A5D6,$A5D7,$A5D8,$A5D9,$A5DA,$A5DB,$A5DC,$A5DD,$A5DE,$A5DF,$A5E0,
$A5E1,$A5E2,$A5E3,$A5E4,$A5E5,$A5E6,$A5E7,$A5E8,$A5E9,$A5EA,$A5EB,$A5EC,$A5ED,
$A5EE,$A5EF,$A5F0,$A5F1,$A5F2,$A5F3,$A5F4,$A5F5,$A5F6,$A960,$A963,$A964,$A8C5,
$A8C6,$A8C7,$A8C8,$A8C9,$A8CA,$A8CB,$A8CC,$A8CD,$A8CE,$A8CF,$A8D0,$A8D1,$A8D2,
$A8D3,$A8D4,$A8D5,$A8D6,$A8D7,$A8D8,$A8D9,$A8DA,$A8DB,$A8DC,$A8DD,$A8DE,$A8DF,
$A8E0,$A8E1,$A8E2,$A8E3,$A8E4,$A8E5,$A8E6,$A8E7,$A8E8,$A8E9,$A2E5,$A2E6,$A2E7,
$A2E8,$A2E9,$A2EA,$A2EB,$A2EC,$A2ED,$A2EE,$A95A,$A949,$A94A,$A94B,$A94C,$A94D,
$A94E,$A94F,$A950,$A951,$A952,$A953,$A954,$D2BB,$B6A1,$8140,$C6DF,$8141,$8142,
$8143,$CDF2,$D5C9,$C8FD,$C9CF,$CFC2,$D8A2,$B2BB,$D3EB,$8144,$D8A4,$B3F3,$8145,
$D7A8,$C7D2,$D8A7,$CAC0,$8146,$C7F0,$B1FB,$D2B5,$B4D4,$B6AB,$CBBF,$D8A9,$8147,
$8148,$8149,$B6AA,$814A,$C1BD,$D1CF,$814B,$C9A5,$D8AD,$814C,$B8F6,$D1BE,$E3DC,
$D6D0,$814D,$814E,$B7E1,$814F,$B4AE,$8150,$C1D9,$8151,$D8BC,$8152,$CDE8,$B5A4,
$CEAA,$D6F7,$8153,$C0F6,$BED9,$D8AF,$8154,$8155,$8156,$C4CB,$8157,$BEC3,$8158,
$D8B1,$C3B4,$D2E5,$8159,$D6AE,$CEDA,$D5A7,$BAF5,$B7A6,$C0D6,$815A,$C6B9,$C5D2,
$C7C7,$815B,$B9D4,$815C,$B3CB,$D2D2,$815D,$815E,$D8BF,$BEC5,$C6F2,$D2B2,$CFB0,
$CFE7,$815F,$8160,$8161,$8162,$CAE9,$8163,$8164,$D8C0,$8165,$8166,$8167,$8168,
$8169,$816A,$C2F2,$C2D2,$816B,$C8E9,$816C,$816D,$816E,$816F,$8170,$8171,$8172,
$8173,$8174,$8175,$C7AC,$8176,$8177,$8178,$8179,$817A,$817B,$817C,$C1CB,$817D,
$D3E8,$D5F9,$817E,$CAC2,$B6FE,$D8A1,$D3DA,$BFF7,$8180,$D4C6,$BBA5,$D8C1,$CEE5,
$BEAE,$8181,$8182,$D8A8,$8183,$D1C7,$D0A9,$8184,$8185,$8186,$D8BD,$D9EF,$CDF6,
$BFBA,$8187,$BDBB,$BAA5,$D2E0,$B2FA,$BAE0,$C4B6,$8188,$CFED,$BEA9,$CDA4,$C1C1,
$8189,$818A,$818B,$C7D7,$D9F1,$818C,$D9F4,$818D,$818E,$818F,$8190,$C8CB,$D8E9,
$8191,$8192,$8193,$D2DA,$CAB2,$C8CA,$D8EC,$D8EA,$D8C6,$BDF6,$C6CD,$B3F0,$8194,
$D8EB,$BDF1,$BDE9,$8195,$C8D4,$B4D3,$8196,$8197,$C2D8,$8198,$B2D6,$D7D0,$CACB,
$CBFB,$D5CC,$B8B6,$CFC9,$8199,$819A,$819B,$D9DA,$D8F0,$C7AA,$819C,$D8EE,$819D,
$B4FA,$C1EE,$D2D4,$819E,$819F,$D8ED,$81A0,$D2C7,$D8EF,$C3C7,$81A1,$81A2,$81A3,
$D1F6,$81A4,$D6D9,$D8F2,$81A5,$D8F5,$BCFE,$BCDB,$81A6,$81A7,$81A8,$C8CE,$81A9,
$B7DD,$81AA,$B7C2,$81AB,$C6F3,$81AC,$81AD,$81AE,$81AF,$81B0,$81B1,$81B2,$D8F8,
$D2C1,$81B3,$81B4,$CEE9,$BCBF,$B7FC,$B7A5,$D0DD,$81B5,$81B6,$81B7,$81B8,$81B9,
$D6DA,$D3C5,$BBEF,$BBE1,$D8F1,$81BA,$81BB,$C9A1,$CEB0,$B4AB,$81BC,$D8F3,$81BD,
$C9CB,$D8F6,$C2D7,$D8F7,$81BE,$81BF,$CEB1,$D8F9,$81C0,$81C1,$81C2,$B2AE,$B9C0,
$81C3,$D9A3,$81C4,$B0E9,$81C5,$C1E6,$81C6,$C9EC,$81C7,$CBC5,$81C8,$CBC6,$D9A4,
$81C9,$81CA,$81CB,$81CC,$81CD,$B5E8,$81CE,$81CF,$B5AB,$81D0,$81D1,$81D2,$81D3,
$81D4,$81D5,$CEBB,$B5CD,$D7A1,$D7F4,$D3D3,$81D6,$CCE5,$81D7,$BACE,$81D8,$D9A2,
$D9DC,$D3E0,$D8FD,$B7F0,$D7F7,$D8FE,$D8FA,$D9A1,$C4E3,$81D9,$81DA,$D3B6,$D8F4,
$D9DD,$81DB,$D8FB,$81DC,$C5E5,$81DD,$81DE,$C0D0,$81DF,$81E0,$D1F0,$B0DB,$81E1,
$81E2,$BCD1,$D9A6,$81E3,$D9A5,$81E4,$81E5,$81E6,$81E7,$D9AC,$D9AE,$81E8,$D9AB,
$CAB9,$81E9,$81EA,$81EB,$D9A9,$D6B6,$81EC,$81ED,$81EE,$B3DE,$D9A8,$81EF,$C0FD,
$81F0,$CACC,$81F1,$D9AA,$81F2,$D9A7,$81F3,$81F4,$D9B0,$81F5,$81F6,$B6B1,$81F7,
$81F8,$81F9,$B9A9,$81FA,$D2C0,$81FB,$81FC,$CFC0,$81FD,$81FE,$C2C2,$8240,$BDC4,
$D5EC,$B2E0,$C7C8,$BFEB,$D9AD,$8241,$D9AF,$8242,$CEEA,$BAEE,$8243,$8244,$8245,
$8246,$8247,$C7D6,$8248,$8249,$824A,$824B,$824C,$824D,$824E,$824F,$8250,$B1E3,
$8251,$8252,$8253,$B4D9,$B6ED,$D9B4,$8254,$8255,$8256,$8257,$BFA1,$8258,$8259,
$825A,$D9DE,$C7CE,$C0FE,$D9B8,$825B,$825C,$825D,$825E,$825F,$CBD7,$B7FD,$8260,
$D9B5,$8261,$D9B7,$B1A3,$D3E1,$D9B9,$8262,$D0C5,$8263,$D9B6,$8264,$8265,$D9B1,
$8266,$D9B2,$C1A9,$D9B3,$8267,$8268,$BCF3,$D0DE,$B8A9,$8269,$BEE3,$826A,$D9BD,
$826B,$826C,$826D,$826E,$D9BA,$826F,$B0B3,$8270,$8271,$8272,$D9C2,$8273,$8274,
$8275,$8276,$8277,$8278,$8279,$827A,$827B,$827C,$827D,$827E,$8280,$D9C4,$B1B6,
$8281,$D9BF,$8282,$8283,$B5B9,$8284,$BEF3,$8285,$8286,$8287,$CCC8,$BAF2,$D2D0,
$8288,$D9C3,$8289,$828A,$BDE8,$828B,$B3AB,$828C,$828D,$828E,$D9C5,$BEEB,$828F,
$D9C6,$D9BB,$C4DF,$8290,$D9BE,$D9C1,$D9C0,$8291,$8292,$8293,$8294,$8295,$8296,
$8297,$8298,$8299,$829A,$829B,$D5AE,$829C,$D6B5,$829D,$C7E3,$829E,$829F,$82A0,
$82A1,$D9C8,$82A2,$82A3,$82A4,$BCD9,$D9CA,$82A5,$82A6,$82A7,$D9BC,$82A8,$D9CB,
$C6AB,$82A9,$82AA,$82AB,$82AC,$82AD,$D9C9,$82AE,$82AF,$82B0,$82B1,$D7F6,$82B2,
$CDA3,$82B3,$82B4,$82B5,$82B6,$82B7,$82B8,$82B9,$82BA,$BDA1,$82BB,$82BC,$82BD,
$82BE,$82BF,$82C0,$D9CC,$82C1,$82C2,$82C3,$82C4,$82C5,$82C6,$82C7,$82C8,$82C9,
$C5BC,$CDB5,$82CA,$82CB,$82CC,$D9CD,$82CD,$82CE,$D9C7,$B3A5,$BFFE,$82CF,$82D0,
$82D1,$82D2,$B8B5,$82D3,$82D4,$C0FC,$82D5,$82D6,$82D7,$82D8,$B0F8,$82D9,$82DA,
$82DB,$82DC,$82DD,$82DE,$82DF,$82E0,$82E1,$82E2,$82E3,$82E4,$82E5,$82E6,$82E7,
$82E8,$82E9,$82EA,$82EB,$82EC,$82ED,$B4F6,$82EE,$D9CE,$82EF,$D9CF,$B4A2,$D9D0,
$82F0,$82F1,$B4DF,$82F2,$82F3,$82F4,$82F5,$82F6,$B0C1,$82F7,$82F8,$82F9,$82FA,
$82FB,$82FC,$82FD,$D9D1,$C9B5,$82FE,$8340,$8341,$8342,$8343,$8344,$8345,$8346,
$8347,$8348,$8349,$834A,$834B,$834C,$834D,$834E,$834F,$8350,$8351,$CFF1,$8352,
$8353,$8354,$8355,$8356,$8357,$D9D2,$8358,$8359,$835A,$C1C5,$835B,$835C,$835D,
$835E,$835F,$8360,$8361,$8362,$8363,$8364,$8365,$D9D6,$C9AE,$8366,$8367,$8368,
$8369,$D9D5,$D9D4,$D9D7,$836A,$836B,$836C,$836D,$CBDB,$836E,$BDA9,$836F,$8370,
$8371,$8372,$8373,$C6A7,$8374,$8375,$8376,$8377,$8378,$8379,$837A,$837B,$837C,
$837D,$D9D3,$D9D8,$837E,$8380,$8381,$D9D9,$8382,$8383,$8384,$8385,$8386,$8387,
$C8E5,$8388,$8389,$838A,$838B,$838C,$838D,$838E,$838F,$8390,$8391,$8392,$8393,
$8394,$8395,$C0DC,$8396,$8397,$8398,$8399,$839A,$839B,$839C,$839D,$839E,$839F,
$83A0,$83A1,$83A2,$83A3,$83A4,$83A5,$83A6,$83A7,$83A8,$83A9,$83AA,$83AB,$83AC,
$83AD,$83AE,$83AF,$83B0,$83B1,$83B2,$B6F9,$D8A3,$D4CA,$83B3,$D4AA,$D0D6,$B3E4,
$D5D7,$83B4,$CFC8,$B9E2,$83B5,$BFCB,$83B6,$C3E2,$83B7,$83B8,$83B9,$B6D2,$83BA,
$83BB,$CDC3,$D9EE,$D9F0,$83BC,$83BD,$83BE,$B5B3,$83BF,$B6B5,$83C0,$83C1,$83C2,
$83C3,$83C4,$BEA4,$83C5,$83C6,$C8EB,$83C7,$83C8,$C8AB,$83C9,$83CA,$B0CB,$B9AB,
$C1F9,$D9E2,$83CB,$C0BC,$B9B2,$83CC,$B9D8,$D0CB,$B1F8,$C6E4,$BEDF,$B5E4,$D7C8,
$83CD,$D1F8,$BCE6,$CADE,$83CE,$83CF,$BCBD,$D9E6,$D8E7,$83D0,$83D1,$C4DA,$83D2,
$83D3,$B8D4,$C8BD,$83D4,$83D5,$B2E1,$D4D9,$83D6,$83D7,$83D8,$83D9,$C3B0,$83DA,
$83DB,$C3E1,$DAA2,$C8DF,$83DC,$D0B4,$83DD,$BEFC,$C5A9,$83DE,$83DF,$83E0,$B9DA,
$83E1,$DAA3,$83E2,$D4A9,$DAA4,$83E3,$83E4,$83E5,$83E6,$83E7,$D9FB,$B6AC,$83E8,
$83E9,$B7EB,$B1F9,$D9FC,$B3E5,$BEF6,$83EA,$BFF6,$D2B1,$C0E4,$83EB,$83EC,$83ED,
$B6B3,$D9FE,$D9FD,$83EE,$83EF,$BEBB,$83F0,$83F1,$83F2,$C6E0,$83F3,$D7BC,$DAA1,
$83F4,$C1B9,$83F5,$B5F2,$C1E8,$83F6,$83F7,$BCF5,$83F8,$B4D5,$83F9,$83FA,$83FB,
$83FC,$83FD,$83FE,$8440,$8441,$8442,$C1DD,$8443,$C4FD,$8444,$8445,$BCB8,$B7B2,
$8446,$8447,$B7EF,$8448,$8449,$844A,$844B,$844C,$844D,$D9EC,$844E,$C6BE,$844F,
$BFAD,$BBCB,$8450,$8451,$B5CA,$8452,$DBC9,$D0D7,$8453,$CDB9,$B0BC,$B3F6,$BBF7,
$DBCA,$BAAF,$8454,$D4E4,$B5B6,$B5F3,$D8D6,$C8D0,$8455,$8456,$B7D6,$C7D0,$D8D7,
$8457,$BFAF,$8458,$8459,$DBBB,$D8D8,$845A,$845B,$D0CC,$BBAE,$845C,$845D,$845E,
$EBBE,$C1D0,$C1F5,$D4F2,$B8D5,$B4B4,$845F,$B3F5,$8460,$8461,$C9BE,$8462,$8463,
$8464,$C5D0,$8465,$8466,$8467,$C5D9,$C0FB,$8468,$B1F0,$8469,$D8D9,$B9CE,$846A,
$B5BD,$846B,$846C,$D8DA,$846D,$846E,$D6C6,$CBA2,$C8AF,$C9B2,$B4CC,$BFCC,$846F,
$B9F4,$8470,$D8DB,$D8DC,$B6E7,$BCC1,$CCEA,$8471,$8472,$8473,$8474,$8475,$8476,
$CFF7,$8477,$D8DD,$C7B0,$8478,$8479,$B9D0,$BDA3,$847A,$847B,$CCDE,$847C,$C6CA,
$847D,$847E,$8480,$8481,$8482,$D8E0,$8483,$D8DE,$8484,$8485,$D8DF,$8486,$8487,
$8488,$B0FE,$8489,$BEE7,$848A,$CAA3,$BCF4,$848B,$848C,$848D,$848E,$B8B1,$848F,
$8490,$B8EE,$8491,$8492,$8493,$8494,$8495,$8496,$8497,$8498,$8499,$849A,$D8E2,
$849B,$BDCB,$849C,$D8E4,$D8E3,$849D,$849E,$849F,$84A0,$84A1,$C5FC,$84A2,$84A3,
$84A4,$84A5,$84A6,$84A7,$84A8,$D8E5,$84A9,$84AA,$D8E6,$84AB,$84AC,$84AD,$84AE,
$84AF,$84B0,$84B1,$C1A6,$84B2,$C8B0,$B0EC,$B9A6,$BCD3,$CEF1,$DBBD,$C1D3,$84B3,
$84B4,$84B5,$84B6,$B6AF,$D6FA,$C5AC,$BDD9,$DBBE,$DBBF,$84B7,$84B8,$84B9,$C0F8,
$BEA2,$C0CD,$84BA,$84BB,$84BC,$84BD,$84BE,$84BF,$84C0,$84C1,$84C2,$84C3,$DBC0,
$CAC6,$84C4,$84C5,$84C6,$B2AA,$84C7,$84C8,$84C9,$D3C2,$84CA,$C3E3,$84CB,$D1AB,
$84CC,$84CD,$84CE,$84CF,$DBC2,$84D0,$C0D5,$84D1,$84D2,$84D3,$DBC3,$84D4,$BFB1,
$84D5,$84D6,$84D7,$84D8,$84D9,$84DA,$C4BC,$84DB,$84DC,$84DD,$84DE,$C7DA,$84DF,
$84E0,$84E1,$84E2,$84E3,$84E4,$84E5,$84E6,$84E7,$84E8,$84E9,$DBC4,$84EA,$84EB,
$84EC,$84ED,$84EE,$84EF,$84F0,$84F1,$D9E8,$C9D7,$84F2,$84F3,$84F4,$B9B4,$CEF0,
$D4C8,$84F5,$84F6,$84F7,$84F8,$B0FC,$B4D2,$84F9,$D0D9,$84FA,$84FB,$84FC,$84FD,
$D9E9,$84FE,$DECB,$D9EB,$8540,$8541,$8542,$8543,$D8B0,$BBAF,$B1B1,$8544,$B3D7,
$D8CE,$8545,$8546,$D4D1,$8547,$8548,$BDB3,$BFEF,$8549,$CFBB,$854A,$854B,$D8D0,
$854C,$854D,$854E,$B7CB,$854F,$8550,$8551,$D8D1,$8552,$8553,$8554,$8555,$8556,
$8557,$8558,$8559,$855A,$855B,$C6A5,$C7F8,$D2BD,$855C,$855D,$D8D2,$C4E4,$855E,
$CAAE,$855F,$C7A7,$8560,$D8A6,$8561,$C9FD,$CEE7,$BBDC,$B0EB,$8562,$8563,$8564,
$BBAA,$D0AD,$8565,$B1B0,$D7E4,$D7BF,$8566,$B5A5,$C2F4,$C4CF,$8567,$8568,$B2A9,
$8569,$B2B7,$856A,$B1E5,$DFB2,$D5BC,$BFA8,$C2AC,$D8D5,$C2B1,$856B,$D8D4,$CED4,
$856C,$DAE0,$856D,$CEC0,$856E,$856F,$D8B4,$C3AE,$D3A1,$CEA3,$8570,$BCB4,$C8B4,
$C2D1,$8571,$BEED,$D0B6,$8572,$DAE1,$8573,$8574,$8575,$8576,$C7E4,$8577,$8578,
$B3A7,$8579,$B6F2,$CCFC,$C0FA,$857A,$857B,$C0F7,$857C,$D1B9,$D1E1,$D8C7,$857D,
$857E,$8580,$8581,$8582,$8583,$8584,$B2DE,$8585,$8586,$C0E5,$8587,$BAF1,$8588,
$8589,$D8C8,$858A,$D4AD,$858B,$858C,$CFE1,$D8C9,$858D,$D8CA,$CFC3,$858E,$B3F8,
$BEC7,$858F,$8590,$8591,$8592,$D8CB,$8593,$8594,$8595,$8596,$8597,$8598,$8599,
$DBCC,$859A,$859B,$859C,$859D,$C8A5,$859E,$859F,$85A0,$CFD8,$85A1,$C8FE,$B2CE,
$85A2,$85A3,$85A4,$85A5,$85A6,$D3D6,$B2E6,$BCB0,$D3D1,$CBAB,$B7B4,$85A7,$85A8,
$85A9,$B7A2,$85AA,$85AB,$CAE5,$85AC,$C8A1,$CADC,$B1E4,$D0F0,$85AD,$C5D1,$85AE,
$85AF,$85B0,$DBC5,$B5FE,$85B1,$85B2,$BFDA,$B9C5,$BEE4,$C1ED,$85B3,$DFB6,$DFB5,
$D6BB,$BDD0,$D5D9,$B0C8,$B6A3,$BFC9,$CCA8,$DFB3,$CAB7,$D3D2,$85B4,$D8CF,$D2B6,
$BAC5,$CBBE,$CCBE,$85B5,$DFB7,$B5F0,$DFB4,$85B6,$85B7,$85B8,$D3F5,$85B9,$B3D4,
$B8F7,$85BA,$DFBA,$85BB,$BACF,$BCAA,$B5F5,$85BC,$CDAC,$C3FB,$BAF3,$C0F4,$CDC2,
$CFF2,$DFB8,$CFC5,$85BD,$C2C0,$DFB9,$C2F0,$85BE,$85BF,$85C0,$BEFD,$85C1,$C1DF,
$CDCC,$D2F7,$B7CD,$DFC1,$85C2,$DFC4,$85C3,$85C4,$B7F1,$B0C9,$B6D6,$B7D4,$85C5,
$BAAC,$CCFD,$BFD4,$CBB1,$C6F4,$85C6,$D6A8,$DFC5,$85C7,$CEE2,$B3B3,$85C8,$85C9,
$CEFC,$B4B5,$85CA,$CEC7,$BAF0,$85CB,$CEE1,$85CC,$D1BD,$85CD,$85CE,$DFC0,$85CF,
$85D0,$B4F4,$85D1,$B3CA,$85D2,$B8E6,$DFBB,$85D3,$85D4,$85D5,$85D6,$C4C5,$85D7,
$DFBC,$DFBD,$DFBE,$C5BB,$DFBF,$DFC2,$D4B1,$DFC3,$85D8,$C7BA,$CED8,$85D9,$85DA,
$85DB,$85DC,$85DD,$C4D8,$85DE,$DFCA,$85DF,$DFCF,$85E0,$D6DC,$85E1,$85E2,$85E3,
$85E4,$85E5,$85E6,$85E7,$85E8,$DFC9,$DFDA,$CEB6,$85E9,$BAC7,$DFCE,$DFC8,$C5DE,
$85EA,$85EB,$C9EB,$BAF4,$C3FC,$85EC,$85ED,$BED7,$85EE,$DFC6,$85EF,$DFCD,$85F0,
$C5D8,$85F1,$85F2,$85F3,$85F4,$D5A6,$BACD,$85F5,$BECC,$D3BD,$B8C0,$85F6,$D6E4,
$85F7,$DFC7,$B9BE,$BFA7,$85F8,$85F9,$C1FC,$DFCB,$DFCC,$85FA,$DFD0,$85FB,$85FC,
$85FD,$85FE,$8640,$DFDB,$DFE5,$8641,$DFD7,$DFD6,$D7C9,$DFE3,$DFE4,$E5EB,$D2A7,
$DFD2,$8642,$BFA9,$8643,$D4DB,$8644,$BFC8,$DFD4,$8645,$8646,$8647,$CFCC,$8648,
$8649,$DFDD,$864A,$D1CA,$864B,$DFDE,$B0A7,$C6B7,$DFD3,$864C,$BAE5,$864D,$B6DF,
$CDDB,$B9FE,$D4D5,$864E,$864F,$DFDF,$CFEC,$B0A5,$DFE7,$DFD1,$D1C6,$DFD5,$DFD8,
$DFD9,$DFDC,$8650,$BBA9,$8651,$DFE0,$DFE1,$8652,$DFE2,$DFE6,$DFE8,$D3B4,$8653,
$8654,$8655,$8656,$8657,$B8E7,$C5B6,$DFEA,$C9DA,$C1A8,$C4C4,$8658,$8659,$BFDE,
$CFF8,$865A,$865B,$865C,$D5DC,$DFEE,$865D,$865E,$865F,$8660,$8661,$8662,$B2B8,
$8663,$BADF,$DFEC,$8664,$DBC1,$8665,$D1E4,$8666,$8667,$8668,$8669,$CBF4,$B4BD,
$866A,$B0A6,$866B,$866C,$866D,$866E,$866F,$DFF1,$CCC6,$DFF2,$8670,$8671,$DFED,
$8672,$8673,$8674,$8675,$8676,$8677,$DFE9,$8678,$8679,$867A,$867B,$DFEB,$867C,
$DFEF,$DFF0,$BBBD,$867D,$867E,$DFF3,$8680,$8681,$DFF4,$8682,$BBA3,$8683,$CADB,
$CEA8,$E0A7,$B3AA,$8684,$E0A6,$8685,$8686,$8687,$E0A1,$8688,$8689,$868A,$868B,
$DFFE,$868C,$CDD9,$DFFC,$868D,$DFFA,$868E,$BFD0,$D7C4,$868F,$C9CC,$8690,$8691,
$DFF8,$B0A1,$8692,$8693,$8694,$8695,$8696,$DFFD,$8697,$8698,$8699,$869A,$DFFB,
$E0A2,$869B,$869C,$869D,$869E,$869F,$E0A8,$86A0,$86A1,$86A2,$86A3,$B7C8,$86A4,
$86A5,$C6A1,$C9B6,$C0B2,$DFF5,$86A6,$86A7,$C5BE,$86A8,$D8C4,$DFF9,$C4F6,$86A9,
$86AA,$86AB,$86AC,$86AD,$86AE,$E0A3,$E0A4,$E0A5,$D0A5,$86AF,$86B0,$E0B4,$CCE4,
$86B1,$E0B1,$86B2,$BFA6,$E0AF,$CEB9,$E0AB,$C9C6,$86B3,$86B4,$C0AE,$E0AE,$BAED,
$BAB0,$E0A9,$86B5,$86B6,$86B7,$DFF6,$86B8,$E0B3,$86B9,$86BA,$E0B8,$86BB,$86BC,
$86BD,$B4AD,$E0B9,$86BE,$86BF,$CFB2,$BAC8,$86C0,$E0B0,$86C1,$86C2,$86C3,$86C4,
$86C5,$86C6,$86C7,$D0FA,$86C8,$86C9,$86CA,$86CB,$86CC,$86CD,$86CE,$86CF,$86D0,
$E0AC,$86D1,$D4FB,$86D2,$DFF7,$86D3,$C5E7,$86D4,$E0AD,$86D5,$D3F7,$86D6,$E0B6,
$E0B7,$86D7,$86D8,$86D9,$86DA,$86DB,$E0C4,$D0E1,$86DC,$86DD,$86DE,$E0BC,$86DF,
$86E0,$E0C9,$E0CA,$86E1,$86E2,$86E3,$E0BE,$E0AA,$C9A4,$E0C1,$86E4,$E0B2,$86E5,
$86E6,$86E7,$86E8,$86E9,$CAC8,$E0C3,$86EA,$E0B5,$86EB,$CECB,$86EC,$CBC3,$E0CD,
$E0C6,$E0C2,$86ED,$E0CB,$86EE,$E0BA,$E0BF,$E0C0,$86EF,$86F0,$E0C5,$86F1,$86F2,
$E0C7,$E0C8,$86F3,$E0CC,$86F4,$E0BB,$86F5,$86F6,$86F7,$86F8,$86F9,$CBD4,$E0D5,
$86FA,$E0D6,$E0D2,$86FB,$86FC,$86FD,$86FE,$8740,$8741,$E0D0,$BCCE,$8742,$8743,
$E0D1,$8744,$B8C2,$D8C5,$8745,$8746,$8747,$8748,$8749,$874A,$874B,$874C,$D0EA,
$874D,$874E,$C2EF,$874F,$8750,$E0CF,$E0BD,$8751,$8752,$8753,$E0D4,$E0D3,$8754,
$8755,$E0D7,$8756,$8757,$8758,$8759,$E0DC,$E0D8,$875A,$875B,$875C,$D6F6,$B3B0,
$875D,$D7EC,$875E,$CBBB,$875F,$8760,$E0DA,$8761,$CEFB,$8762,$8763,$8764,$BAD9,
$8765,$8766,$8767,$8768,$8769,$876A,$876B,$876C,$876D,$876E,$876F,$8770,$E0E1,
$E0DD,$D2AD,$8771,$8772,$8773,$8774,$8775,$E0E2,$8776,$8777,$E0DB,$E0D9,$E0DF,
$8778,$8779,$E0E0,$877A,$877B,$877C,$877D,$877E,$E0DE,$8780,$E0E4,$8781,$8782,
$8783,$C6F7,$D8AC,$D4EB,$E0E6,$CAC9,$8784,$8785,$8786,$8787,$E0E5,$8788,$8789,
$878A,$878B,$B8C1,$878C,$878D,$878E,$878F,$E0E7,$E0E8,$8790,$8791,$8792,$8793,
$8794,$8795,$8796,$8797,$E0E9,$E0E3,$8798,$8799,$879A,$879B,$879C,$879D,$879E,
$BABF,$CCE7,$879F,$87A0,$87A1,$E0EA,$87A2,$87A3,$87A4,$87A5,$87A6,$87A7,$87A8,
$87A9,$87AA,$87AB,$87AC,$87AD,$87AE,$87AF,$87B0,$CFF9,$87B1,$87B2,$87B3,$87B4,
$87B5,$87B6,$87B7,$87B8,$87B9,$87BA,$87BB,$E0EB,$87BC,$87BD,$87BE,$87BF,$87C0,
$87C1,$87C2,$C8C2,$87C3,$87C4,$87C5,$87C6,$BDC0,$87C7,$87C8,$87C9,$87CA,$87CB,
$87CC,$87CD,$87CE,$87CF,$87D0,$87D1,$87D2,$87D3,$C4D2,$87D4,$87D5,$87D6,$87D7,
$87D8,$87D9,$87DA,$87DB,$87DC,$E0EC,$87DD,$87DE,$E0ED,$87DF,$87E0,$C7F4,$CBC4,
$87E1,$E0EE,$BBD8,$D8B6,$D2F2,$E0EF,$CDC5,$87E2,$B6DA,$87E3,$87E4,$87E5,$87E6,
$87E7,$87E8,$E0F1,$87E9,$D4B0,$87EA,$87EB,$C0A7,$B4D1,$87EC,$87ED,$CEA7,$E0F0,
$87EE,$87EF,$87F0,$E0F2,$B9CC,$87F1,$87F2,$B9FA,$CDBC,$E0F3,$87F3,$87F4,$87F5,
$C6D4,$E0F4,$87F6,$D4B2,$87F7,$C8A6,$E0F6,$E0F5,$87F8,$87F9,$87FA,$87FB,$87FC,
$87FD,$87FE,$8840,$8841,$8842,$8843,$8844,$8845,$8846,$8847,$8848,$8849,$E0F7,
$884A,$884B,$CDC1,$884C,$884D,$884E,$CAA5,$884F,$8850,$8851,$8852,$D4DA,$DBD7,
$DBD9,$8853,$DBD8,$B9E7,$DBDC,$DBDD,$B5D8,$8854,$8855,$DBDA,$8856,$8857,$8858,
$8859,$885A,$DBDB,$B3A1,$DBDF,$885B,$885C,$BBF8,$885D,$D6B7,$885E,$DBE0,$885F,
$8860,$8861,$8862,$BEF9,$8863,$8864,$B7BB,$8865,$DBD0,$CCAE,$BFB2,$BBB5,$D7F8,
$BFD3,$8866,$8867,$8868,$8869,$886A,$BFE9,$886B,$886C,$BCE1,$CCB3,$DBDE,$B0D3,
$CEEB,$B7D8,$D7B9,$C6C2,$886D,$886E,$C0A4,$886F,$CCB9,$8870,$DBE7,$DBE1,$C6BA,
$DBE3,$8871,$DBE8,$8872,$C5F7,$8873,$8874,$8875,$DBEA,$8876,$8877,$DBE9,$BFC0,
$8878,$8879,$887A,$DBE6,$DBE5,$887B,$887C,$887D,$887E,$8880,$B4B9,$C0AC,$C2A2,
$DBE2,$DBE4,$8881,$8882,$8883,$8884,$D0CD,$DBED,$8885,$8886,$8887,$8888,$8889,
$C0DD,$DBF2,$888A,$888B,$888C,$888D,$888E,$888F,$8890,$B6E2,$8891,$8892,$8893,
$8894,$DBF3,$DBD2,$B9B8,$D4AB,$DBEC,$8895,$BFD1,$DBF0,$8896,$DBD1,$8897,$B5E6,
$8898,$DBEB,$BFE5,$8899,$889A,$889B,$DBEE,$889C,$DBF1,$889D,$889E,$889F,$DBF9,
$88A0,$88A1,$88A2,$88A3,$88A4,$88A5,$88A6,$88A7,$88A8,$B9A1,$B0A3,$88A9,$88AA,
$88AB,$88AC,$88AD,$88AE,$88AF,$C2F1,$88B0,$88B1,$B3C7,$DBEF,$88B2,$88B3,$DBF8,
$88B4,$C6D2,$DBF4,$88B5,$88B6,$DBF5,$DBF7,$DBF6,$88B7,$88B8,$DBFE,$88B9,$D3F2,
$B2BA,$88BA,$88BB,$88BC,$DBFD,$88BD,$88BE,$88BF,$88C0,$88C1,$88C2,$88C3,$88C4,
$DCA4,$88C5,$DBFB,$88C6,$88C7,$88C8,$88C9,$DBFA,$88CA,$88CB,$88CC,$DBFC,$C5E0,
$BBF9,$88CD,$88CE,$DCA3,$88CF,$88D0,$DCA5,$88D1,$CCC3,$88D2,$88D3,$88D4,$B6D1,
$DDC0,$88D5,$88D6,$88D7,$DCA1,$88D8,$DCA2,$88D9,$88DA,$88DB,$C7B5,$88DC,$88DD,
$88DE,$B6E9,$88DF,$88E0,$88E1,$DCA7,$88E2,$88E3,$88E4,$88E5,$DCA6,$88E6,$DCA9,
$B1A4,$88E7,$88E8,$B5CC,$88E9,$88EA,$88EB,$88EC,$88ED,$BFB0,$88EE,$88EF,$88F0,
$88F1,$88F2,$D1DF,$88F3,$88F4,$88F5,$88F6,$B6C2,$88F7,$88F8,$88F9,$88FA,$88FB,
$88FC,$88FD,$88FE,$8940,$8941,$8942,$8943,$8944,$8945,$DCA8,$8946,$8947,$8948,
$8949,$894A,$894B,$894C,$CBFA,$EBF3,$894D,$894E,$894F,$CBDC,$8950,$8951,$CBFE,
$8952,$8953,$8954,$CCC1,$8955,$8956,$8957,$8958,$8959,$C8FB,$895A,$895B,$895C,
$895D,$895E,$895F,$DCAA,$8960,$8961,$8962,$8963,$8964,$CCEE,$DCAB,$8965,$8966,
$8967,$8968,$8969,$896A,$896B,$896C,$896D,$896E,$896F,$8970,$8971,$8972,$8973,
$8974,$8975,$DBD3,$8976,$DCAF,$DCAC,$8977,$BEB3,$8978,$CAFB,$8979,$897A,$897B,
$DCAD,$897C,$897D,$897E,$8980,$8981,$8982,$8983,$8984,$C9CA,$C4B9,$8985,$8986,
$8987,$8988,$8989,$C7BD,$DCAE,$898A,$898B,$898C,$D4F6,$D0E6,$898D,$898E,$898F,
$8990,$8991,$8992,$8993,$8994,$C4AB,$B6D5,$8995,$8996,$8997,$8998,$8999,$899A,
$899B,$899C,$899D,$899E,$899F,$89A0,$89A1,$89A2,$89A3,$89A4,$89A5,$89A6,$DBD4,
$89A7,$89A8,$89A9,$89AA,$B1DA,$89AB,$89AC,$89AD,$DBD5,$89AE,$89AF,$89B0,$89B1,
$89B2,$89B3,$89B4,$89B5,$89B6,$89B7,$89B8,$DBD6,$89B9,$89BA,$89BB,$BABE,$89BC,
$89BD,$89BE,$89BF,$89C0,$89C1,$89C2,$89C3,$89C4,$89C5,$89C6,$89C7,$89C8,$89C9,
$C8C0,$89CA,$89CB,$89CC,$89CD,$89CE,$89CF,$CABF,$C8C9,$89D0,$D7B3,$89D1,$C9F9,
$89D2,$89D3,$BFC7,$89D4,$89D5,$BAF8,$89D6,$89D7,$D2BC,$89D8,$89D9,$89DA,$89DB,
$89DC,$89DD,$89DE,$89DF,$E2BA,$89E0,$B4A6,$89E1,$89E2,$B1B8,$89E3,$89E4,$89E5,
$89E6,$89E7,$B8B4,$89E8,$CFC4,$89E9,$89EA,$89EB,$89EC,$D9E7,$CFA6,$CDE2,$89ED,
$89EE,$D9ED,$B6E0,$89EF,$D2B9,$89F0,$89F1,$B9BB,$89F2,$89F3,$89F4,$89F5,$E2B9,
$E2B7,$89F6,$B4F3,$89F7,$CCEC,$CCAB,$B7F2,$89F8,$D8B2,$D1EB,$BABB,$89F9,$CAA7,
$89FA,$89FB,$CDB7,$89FC,$89FD,$D2C4,$BFE4,$BCD0,$B6E1,$89FE,$DEC5,$8A40,$8A41,
$8A42,$8A43,$DEC6,$DBBC,$8A44,$D1D9,$8A45,$8A46,$C6E6,$C4CE,$B7EE,$8A47,$B7DC,
$8A48,$8A49,$BFFC,$D7E0,$8A4A,$C6F5,$8A4B,$8A4C,$B1BC,$DEC8,$BDB1,$CCD7,$DECA,
$8A4D,$DEC9,$8A4E,$8A4F,$8A50,$8A51,$8A52,$B5EC,$8A53,$C9DD,$8A54,$8A55,$B0C2,
$8A56,$8A57,$8A58,$8A59,$8A5A,$8A5B,$8A5C,$8A5D,$8A5E,$8A5F,$8A60,$8A61,$8A62,
$C5AE,$C5AB,$8A63,$C4CC,$8A64,$BCE9,$CBFD,$8A65,$8A66,$8A67,$BAC3,$8A68,$8A69,
$8A6A,$E5F9,$C8E7,$E5FA,$CDFD,$8A6B,$D7B1,$B8BE,$C2E8,$8A6C,$C8D1,$8A6D,$8A6E,
$E5FB,$8A6F,$8A70,$8A71,$8A72,$B6CA,$BCCB,$8A73,$8A74,$D1FD,$E6A1,$8A75,$C3EE,
$8A76,$8A77,$8A78,$8A79,$E6A4,$8A7A,$8A7B,$8A7C,$8A7D,$E5FE,$E6A5,$CDD7,$8A7E,
$8A80,$B7C1,$E5FC,$E5FD,$E6A3,$8A81,$8A82,$C4DD,$E6A8,$8A83,$8A84,$E6A7,$8A85,
$8A86,$8A87,$8A88,$8A89,$8A8A,$C3C3,$8A8B,$C6DE,$8A8C,$8A8D,$E6AA,$8A8E,$8A8F,
$8A90,$8A91,$8A92,$8A93,$8A94,$C4B7,$8A95,$8A96,$8A97,$E6A2,$CABC,$8A98,$8A99,
$8A9A,$8A9B,$BDE3,$B9C3,$E6A6,$D0D5,$CEAF,$8A9C,$8A9D,$E6A9,$E6B0,$8A9E,$D2A6,
$8A9F,$BDAA,$E6AD,$8AA0,$8AA1,$8AA2,$8AA3,$8AA4,$E6AF,$8AA5,$C0D1,$8AA6,$8AA7,
$D2CC,$8AA8,$8AA9,$8AAA,$BCA7,$8AAB,$8AAC,$8AAD,$8AAE,$8AAF,$8AB0,$8AB1,$8AB2,
$8AB3,$8AB4,$8AB5,$8AB6,$E6B1,$8AB7,$D2F6,$8AB8,$8AB9,$8ABA,$D7CB,$8ABB,$CDFE,
$8ABC,$CDDE,$C2A6,$E6AB,$E6AC,$BDBF,$E6AE,$E6B3,$8ABD,$8ABE,$E6B2,$8ABF,$8AC0,
$8AC1,$8AC2,$E6B6,$8AC3,$E6B8,$8AC4,$8AC5,$8AC6,$8AC7,$C4EF,$8AC8,$8AC9,$8ACA,
$C4C8,$8ACB,$8ACC,$BEEA,$C9EF,$8ACD,$8ACE,$E6B7,$8ACF,$B6F0,$8AD0,$8AD1,$8AD2,
$C3E4,$8AD3,$8AD4,$8AD5,$8AD6,$8AD7,$8AD8,$8AD9,$D3E9,$E6B4,$8ADA,$E6B5,$8ADB,
$C8A2,$8ADC,$8ADD,$8ADE,$8ADF,$8AE0,$E6BD,$8AE1,$8AE2,$8AE3,$E6B9,$8AE4,$8AE5,
$8AE6,$8AE7,$8AE8,$C6C5,$8AE9,$8AEA,$CDF1,$E6BB,$8AEB,$8AEC,$8AED,$8AEE,$8AEF,
$8AF0,$8AF1,$8AF2,$8AF3,$8AF4,$E6BC,$8AF5,$8AF6,$8AF7,$8AF8,$BBE9,$8AF9,$8AFA,
$8AFB,$8AFC,$8AFD,$8AFE,$8B40,$E6BE,$8B41,$8B42,$8B43,$8B44,$E6BA,$8B45,$8B46,
$C0B7,$8B47,$8B48,$8B49,$8B4A,$8B4B,$8B4C,$8B4D,$8B4E,$8B4F,$D3A4,$E6BF,$C9F4,
$E6C3,$8B50,$8B51,$E6C4,$8B52,$8B53,$8B54,$8B55,$D0F6,$8B56,$8B57,$8B58,$8B59,
$8B5A,$8B5B,$8B5C,$8B5D,$8B5E,$8B5F,$8B60,$8B61,$8B62,$8B63,$8B64,$8B65,$8B66,
$8B67,$C3BD,$8B68,$8B69,$8B6A,$8B6B,$8B6C,$8B6D,$8B6E,$C3C4,$E6C2,$8B6F,$8B70,
$8B71,$8B72,$8B73,$8B74,$8B75,$8B76,$8B77,$8B78,$8B79,$8B7A,$8B7B,$8B7C,$E6C1,
$8B7D,$8B7E,$8B80,$8B81,$8B82,$8B83,$8B84,$E6C7,$CFB1,$8B85,$EBF4,$8B86,$8B87,
$E6CA,$8B88,$8B89,$8B8A,$8B8B,$8B8C,$E6C5,$8B8D,$8B8E,$BCDE,$C9A9,$8B8F,$8B90,
$8B91,$8B92,$8B93,$8B94,$BCB5,$8B95,$8B96,$CFD3,$8B97,$8B98,$8B99,$8B9A,$8B9B,
$E6C8,$8B9C,$E6C9,$8B9D,$E6CE,$8B9E,$E6D0,$8B9F,$8BA0,$8BA1,$E6D1,$8BA2,$8BA3,
$8BA4,$E6CB,$B5D5,$8BA5,$E6CC,$8BA6,$8BA7,$E6CF,$8BA8,$8BA9,$C4DB,$8BAA,$E6C6,
$8BAB,$8BAC,$8BAD,$8BAE,$8BAF,$E6CD,$8BB0,$8BB1,$8BB2,$8BB3,$8BB4,$8BB5,$8BB6,
$8BB7,$8BB8,$8BB9,$8BBA,$8BBB,$8BBC,$8BBD,$8BBE,$8BBF,$8BC0,$8BC1,$8BC2,$8BC3,
$8BC4,$8BC5,$8BC6,$E6D2,$8BC7,$8BC8,$8BC9,$8BCA,$8BCB,$8BCC,$8BCD,$8BCE,$8BCF,
$8BD0,$8BD1,$8BD2,$E6D4,$E6D3,$8BD3,$8BD4,$8BD5,$8BD6,$8BD7,$8BD8,$8BD9,$8BDA,
$8BDB,$8BDC,$8BDD,$8BDE,$8BDF,$8BE0,$8BE1,$8BE2,$8BE3,$8BE4,$8BE5,$8BE6,$8BE7,
$8BE8,$8BE9,$8BEA,$8BEB,$8BEC,$E6D5,$8BED,$D9F8,$8BEE,$8BEF,$E6D6,$8BF0,$8BF1,
$8BF2,$8BF3,$8BF4,$8BF5,$8BF6,$8BF7,$E6D7,$8BF8,$8BF9,$8BFA,$8BFB,$8BFC,$8BFD,
$8BFE,$8C40,$8C41,$8C42,$8C43,$8C44,$8C45,$8C46,$8C47,$D7D3,$E6DD,$8C48,$E6DE,
$BFD7,$D4D0,$8C49,$D7D6,$B4E6,$CBEF,$E6DA,$D8C3,$D7CE,$D0A2,$8C4A,$C3CF,$8C4B,
$8C4C,$E6DF,$BCBE,$B9C2,$E6DB,$D1A7,$8C4D,$8C4E,$BAA2,$C2CF,$8C4F,$D8AB,$8C50,
$8C51,$8C52,$CAEB,$E5EE,$8C53,$E6DC,$8C54,$B7F5,$8C55,$8C56,$8C57,$8C58,$C8E6,
$8C59,$8C5A,$C4F5,$8C5B,$8C5C,$E5B2,$C4FE,$8C5D,$CBFC,$E5B3,$D5AC,$8C5E,$D3EE,
$CAD8,$B0B2,$8C5F,$CBCE,$CDEA,$8C60,$8C61,$BAEA,$8C62,$8C63,$8C64,$E5B5,$8C65,
$E5B4,$8C66,$D7DA,$B9D9,$D6E6,$B6A8,$CDF0,$D2CB,$B1A6,$CAB5,$8C67,$B3E8,$C9F3,
$BFCD,$D0FB,$CAD2,$E5B6,$BBC2,$8C68,$8C69,$8C6A,$CFDC,$B9AC,$8C6B,$8C6C,$8C6D,
$8C6E,$D4D7,$8C6F,$8C70,$BAA6,$D1E7,$CFFC,$BCD2,$8C71,$E5B7,$C8DD,$8C72,$8C73,
$8C74,$BFED,$B1F6,$CBDE,$8C75,$8C76,$BCC5,$8C77,$BCC4,$D2FA,$C3DC,$BFDC,$8C78,
$8C79,$8C7A,$8C7B,$B8BB,$8C7C,$8C7D,$8C7E,$C3C2,$8C80,$BAAE,$D4A2,$8C81,$8C82,
$8C83,$8C84,$8C85,$8C86,$8C87,$8C88,$8C89,$C7DE,$C4AF,$B2EC,$8C8A,$B9D1,$8C8B,
$8C8C,$E5BB,$C1C8,$8C8D,$8C8E,$D5AF,$8C8F,$8C90,$8C91,$8C92,$8C93,$E5BC,$8C94,
$E5BE,$8C95,$8C96,$8C97,$8C98,$8C99,$8C9A,$8C9B,$B4E7,$B6D4,$CBC2,$D1B0,$B5BC,
$8C9C,$8C9D,$CAD9,$8C9E,$B7E2,$8C9F,$8CA0,$C9E4,$8CA1,$BDAB,$8CA2,$8CA3,$CEBE,
$D7F0,$8CA4,$8CA5,$8CA6,$8CA7,$D0A1,$8CA8,$C9D9,$8CA9,$8CAA,$B6FB,$E6D8,$BCE2,
$8CAB,$B3BE,$8CAC,$C9D0,$8CAD,$E6D9,$B3A2,$8CAE,$8CAF,$8CB0,$8CB1,$DECC,$8CB2,
$D3C8,$DECD,$8CB3,$D2A2,$8CB4,$8CB5,$8CB6,$8CB7,$DECE,$8CB8,$8CB9,$8CBA,$8CBB,
$BECD,$8CBC,$8CBD,$DECF,$8CBE,$8CBF,$8CC0,$CAAC,$D2FC,$B3DF,$E5EA,$C4E1,$BEA1,
$CEB2,$C4F2,$BED6,$C6A8,$B2E3,$8CC1,$8CC2,$BED3,$8CC3,$8CC4,$C7FC,$CCEB,$BDEC,
$CEDD,$8CC5,$8CC6,$CABA,$C6C1,$E5EC,$D0BC,$8CC7,$8CC8,$8CC9,$D5B9,$8CCA,$8CCB,
$8CCC,$E5ED,$8CCD,$8CCE,$8CCF,$8CD0,$CAF4,$8CD1,$CDC0,$C2C5,$8CD2,$E5EF,$8CD3,
$C2C4,$E5F0,$8CD4,$8CD5,$8CD6,$8CD7,$8CD8,$8CD9,$8CDA,$E5F8,$CDCD,$8CDB,$C9BD,
$8CDC,$8CDD,$8CDE,$8CDF,$8CE0,$8CE1,$8CE2,$D2D9,$E1A8,$8CE3,$8CE4,$8CE5,$8CE6,
$D3EC,$8CE7,$CBEA,$C6F1,$8CE8,$8CE9,$8CEA,$8CEB,$8CEC,$E1AC,$8CED,$8CEE,$8CEF,
$E1A7,$E1A9,$8CF0,$8CF1,$E1AA,$E1AF,$8CF2,$8CF3,$B2ED,$8CF4,$E1AB,$B8DA,$E1AD,
$E1AE,$E1B0,$B5BA,$E1B1,$8CF5,$8CF6,$8CF7,$8CF8,$8CF9,$E1B3,$E1B8,$8CFA,$8CFB,
$8CFC,$8CFD,$8CFE,$D1D2,$8D40,$E1B6,$E1B5,$C1EB,$8D41,$8D42,$8D43,$E1B7,$8D44,
$D4C0,$8D45,$E1B2,$8D46,$E1BA,$B0B6,$8D47,$8D48,$8D49,$8D4A,$E1B4,$8D4B,$BFF9,
$8D4C,$E1B9,$8D4D,$8D4E,$E1BB,$8D4F,$8D50,$8D51,$8D52,$8D53,$8D54,$E1BE,$8D55,
$8D56,$8D57,$8D58,$8D59,$8D5A,$E1BC,$8D5B,$8D5C,$8D5D,$8D5E,$8D5F,$8D60,$D6C5,
$8D61,$8D62,$8D63,$8D64,$8D65,$8D66,$8D67,$CFBF,$8D68,$8D69,$E1BD,$E1BF,$C2CD,
$8D6A,$B6EB,$8D6B,$D3F8,$8D6C,$8D6D,$C7CD,$8D6E,$8D6F,$B7E5,$8D70,$8D71,$8D72,
$8D73,$8D74,$8D75,$8D76,$8D77,$8D78,$8D79,$BEFE,$8D7A,$8D7B,$8D7C,$8D7D,$8D7E,
$8D80,$E1C0,$E1C1,$8D81,$8D82,$E1C7,$B3E7,$8D83,$8D84,$8D85,$8D86,$8D87,$8D88,
$C6E9,$8D89,$8D8A,$8D8B,$8D8C,$8D8D,$B4DE,$8D8E,$D1C2,$8D8F,$8D90,$8D91,$8D92,
$E1C8,$8D93,$8D94,$E1C6,$8D95,$8D96,$8D97,$8D98,$8D99,$E1C5,$8D9A,$E1C3,$E1C2,
$8D9B,$B1C0,$8D9C,$8D9D,$8D9E,$D5B8,$E1C4,$8D9F,$8DA0,$8DA1,$8DA2,$8DA3,$E1CB,
$8DA4,$8DA5,$8DA6,$8DA7,$8DA8,$8DA9,$8DAA,$8DAB,$E1CC,$E1CA,$8DAC,$8DAD,$8DAE,
$8DAF,$8DB0,$8DB1,$8DB2,$8DB3,$EFFA,$8DB4,$8DB5,$E1D3,$E1D2,$C7B6,$8DB6,$8DB7,
$8DB8,$8DB9,$8DBA,$8DBB,$8DBC,$8DBD,$8DBE,$8DBF,$8DC0,$E1C9,$8DC1,$8DC2,$E1CE,
$8DC3,$E1D0,$8DC4,$8DC5,$8DC6,$8DC7,$8DC8,$8DC9,$8DCA,$8DCB,$8DCC,$8DCD,$8DCE,
$E1D4,$8DCF,$E1D1,$E1CD,$8DD0,$8DD1,$E1CF,$8DD2,$8DD3,$8DD4,$8DD5,$E1D5,$8DD6,
$8DD7,$8DD8,$8DD9,$8DDA,$8DDB,$8DDC,$8DDD,$8DDE,$8DDF,$8DE0,$8DE1,$8DE2,$E1D6,
$8DE3,$8DE4,$8DE5,$8DE6,$8DE7,$8DE8,$8DE9,$8DEA,$8DEB,$8DEC,$8DED,$8DEE,$8DEF,
$8DF0,$8DF1,$8DF2,$8DF3,$8DF4,$8DF5,$8DF6,$8DF7,$8DF8,$E1D7,$8DF9,$8DFA,$8DFB,
$E1D8,$8DFC,$8DFD,$8DFE,$8E40,$8E41,$8E42,$8E43,$8E44,$8E45,$8E46,$8E47,$8E48,
$8E49,$8E4A,$8E4B,$8E4C,$8E4D,$8E4E,$8E4F,$8E50,$8E51,$8E52,$8E53,$8E54,$8E55,
$E1DA,$8E56,$8E57,$8E58,$8E59,$8E5A,$8E5B,$8E5C,$8E5D,$8E5E,$8E5F,$8E60,$8E61,
$8E62,$E1DB,$8E63,$8E64,$8E65,$8E66,$8E67,$8E68,$8E69,$CEA1,$8E6A,$8E6B,$8E6C,
$8E6D,$8E6E,$8E6F,$8E70,$8E71,$8E72,$8E73,$8E74,$8E75,$8E76,$E7DD,$8E77,$B4A8,
$D6DD,$8E78,$8E79,$D1B2,$B3B2,$8E7A,$8E7B,$B9A4,$D7F3,$C7C9,$BEDE,$B9AE,$8E7C,
$CED7,$8E7D,$8E7E,$B2EE,$DBCF,$8E80,$BCBA,$D2D1,$CBC8,$B0CD,$8E81,$8E82,$CFEF,
$8E83,$8E84,$8E85,$8E86,$8E87,$D9E3,$BDED,$8E88,$8E89,$B1D2,$CAD0,$B2BC,$8E8A,
$CBA7,$B7AB,$8E8B,$CAA6,$8E8C,$8E8D,$8E8E,$CFA3,$8E8F,$8E90,$E0F8,$D5CA,$E0FB,
$8E91,$8E92,$E0FA,$C5C1,$CCFB,$8E93,$C1B1,$E0F9,$D6E3,$B2AF,$D6C4,$B5DB,$8E94,
$8E95,$8E96,$8E97,$8E98,$8E99,$8E9A,$8E9B,$B4F8,$D6A1,$8E9C,$8E9D,$8E9E,$8E9F,
$8EA0,$CFAF,$B0EF,$8EA1,$8EA2,$E0FC,$8EA3,$8EA4,$8EA5,$8EA6,$8EA7,$E1A1,$B3A3,
$8EA8,$8EA9,$E0FD,$E0FE,$C3B1,$8EAA,$8EAB,$8EAC,$8EAD,$C3DD,$8EAE,$E1A2,$B7F9,
$8EAF,$8EB0,$8EB1,$8EB2,$8EB3,$8EB4,$BBCF,$8EB5,$8EB6,$8EB7,$8EB8,$8EB9,$8EBA,
$8EBB,$E1A3,$C4BB,$8EBC,$8EBD,$8EBE,$8EBF,$8EC0,$E1A4,$8EC1,$8EC2,$E1A5,$8EC3,
$8EC4,$E1A6,$B4B1,$8EC5,$8EC6,$8EC7,$8EC8,$8EC9,$8ECA,$8ECB,$8ECC,$8ECD,$8ECE,
$8ECF,$8ED0,$8ED1,$8ED2,$8ED3,$B8C9,$C6BD,$C4EA,$8ED4,$B2A2,$8ED5,$D0D2,$8ED6,
$E7DB,$BBC3,$D3D7,$D3C4,$8ED7,$B9E3,$E2CF,$8ED8,$8ED9,$8EDA,$D7AF,$8EDB,$C7EC,
$B1D3,$8EDC,$8EDD,$B4B2,$E2D1,$8EDE,$8EDF,$8EE0,$D0F2,$C2AE,$E2D0,$8EE1,$BFE2,
$D3A6,$B5D7,$E2D2,$B5EA,$8EE2,$C3ED,$B8FD,$8EE3,$B8AE,$8EE4,$C5D3,$B7CF,$E2D4,
$8EE5,$8EE6,$8EE7,$8EE8,$E2D3,$B6C8,$D7F9,$8EE9,$8EEA,$8EEB,$8EEC,$8EED,$CDA5,
$8EEE,$8EEF,$8EF0,$8EF1,$8EF2,$E2D8,$8EF3,$E2D6,$CAFC,$BFB5,$D3B9,$E2D5,$8EF4,
$8EF5,$8EF6,$8EF7,$E2D7,$8EF8,$8EF9,$8EFA,$8EFB,$8EFC,$8EFD,$8EFE,$8F40,$8F41,
$8F42,$C1AE,$C0C8,$8F43,$8F44,$8F45,$8F46,$8F47,$8F48,$E2DB,$E2DA,$C0AA,$8F49,
$8F4A,$C1CE,$8F4B,$8F4C,$8F4D,$8F4E,$E2DC,$8F4F,$8F50,$8F51,$8F52,$8F53,$8F54,
$8F55,$8F56,$8F57,$8F58,$8F59,$8F5A,$E2DD,$8F5B,$E2DE,$8F5C,$8F5D,$8F5E,$8F5F,
$8F60,$8F61,$8F62,$8F63,$8F64,$DBC8,$8F65,$D1D3,$CDA2,$8F66,$8F67,$BDA8,$8F68,
$8F69,$8F6A,$DEC3,$D8A5,$BFAA,$DBCD,$D2EC,$C6FA,$C5AA,$8F6B,$8F6C,$8F6D,$DEC4,
$8F6E,$B1D7,$DFAE,$8F6F,$8F70,$8F71,$CABD,$8F72,$DFB1,$8F73,$B9AD,$8F74,$D2FD,
$8F75,$B8A5,$BAEB,$8F76,$8F77,$B3DA,$8F78,$8F79,$8F7A,$B5DC,$D5C5,$8F7B,$8F7C,
$8F7D,$8F7E,$C3D6,$CFD2,$BBA1,$8F80,$E5F3,$E5F2,$8F81,$8F82,$E5F4,$8F83,$CDE4,
$8F84,$C8F5,$8F85,$8F86,$8F87,$8F88,$8F89,$8F8A,$8F8B,$B5AF,$C7BF,$8F8C,$E5F6,
$8F8D,$8F8E,$8F8F,$ECB0,$8F90,$8F91,$8F92,$8F93,$8F94,$8F95,$8F96,$8F97,$8F98,
$8F99,$8F9A,$8F9B,$8F9C,$8F9D,$8F9E,$E5E6,$8F9F,$B9E9,$B5B1,$8FA0,$C2BC,$E5E8,
$E5E7,$E5E9,$8FA1,$8FA2,$8FA3,$8FA4,$D2CD,$8FA5,$8FA6,$8FA7,$E1EA,$D0CE,$8FA8,
$CDAE,$8FA9,$D1E5,$8FAA,$8FAB,$B2CA,$B1EB,$8FAC,$B1F2,$C5ED,$8FAD,$8FAE,$D5C3,
$D3B0,$8FAF,$E1DC,$8FB0,$8FB1,$8FB2,$E1DD,$8FB3,$D2DB,$8FB4,$B3B9,$B1CB,$8FB5,
$8FB6,$8FB7,$CDF9,$D5F7,$E1DE,$8FB8,$BEB6,$B4FD,$8FB9,$E1DF,$BADC,$E1E0,$BBB2,
$C2C9,$E1E1,$8FBA,$8FBB,$8FBC,$D0EC,$8FBD,$CDBD,$8FBE,$8FBF,$E1E2,$8FC0,$B5C3,
$C5C7,$E1E3,$8FC1,$8FC2,$E1E4,$8FC3,$8FC4,$8FC5,$8FC6,$D3F9,$8FC7,$8FC8,$8FC9,
$8FCA,$8FCB,$8FCC,$E1E5,$8FCD,$D1AD,$8FCE,$8FCF,$E1E6,$CEA2,$8FD0,$8FD1,$8FD2,
$8FD3,$8FD4,$8FD5,$E1E7,$8FD6,$B5C2,$8FD7,$8FD8,$8FD9,$8FDA,$E1E8,$BBD5,$8FDB,
$8FDC,$8FDD,$8FDE,$8FDF,$D0C4,$E2E0,$B1D8,$D2E4,$8FE0,$8FE1,$E2E1,$8FE2,$8FE3,
$BCC9,$C8CC,$8FE4,$E2E3,$ECFE,$ECFD,$DFAF,$8FE5,$8FE6,$8FE7,$E2E2,$D6BE,$CDFC,
$C3A6,$8FE8,$8FE9,$8FEA,$E3C3,$8FEB,$8FEC,$D6D2,$E2E7,$8FED,$8FEE,$E2E8,$8FEF,
$8FF0,$D3C7,$8FF1,$8FF2,$E2EC,$BFEC,$8FF3,$E2ED,$E2E5,$8FF4,$8FF5,$B3C0,$8FF6,
$8FF7,$8FF8,$C4EE,$8FF9,$8FFA,$E2EE,$8FFB,$8FFC,$D0C3,$8FFD,$BAF6,$E2E9,$B7DE,
$BBB3,$CCAC,$CBCB,$E2E4,$E2E6,$E2EA,$E2EB,$8FFE,$9040,$9041,$E2F7,$9042,$9043,
$E2F4,$D4F5,$E2F3,$9044,$9045,$C5AD,$9046,$D5FA,$C5C2,$B2C0,$9047,$9048,$E2EF,
$9049,$E2F2,$C1AF,$CBBC,$904A,$904B,$B5A1,$E2F9,$904C,$904D,$904E,$BCB1,$E2F1,
$D0D4,$D4B9,$E2F5,$B9D6,$E2F6,$904F,$9050,$9051,$C7D3,$9052,$9053,$9054,$9055,
$9056,$E2F0,$9057,$9058,$9059,$905A,$905B,$D7DC,$EDA1,$905C,$905D,$E2F8,$905E,
$EDA5,$E2FE,$CAD1,$905F,$9060,$9061,$9062,$9063,$9064,$9065,$C1B5,$9066,$BBD0,
$9067,$9068,$BFD6,$9069,$BAE3,$906A,$906B,$CBA1,$906C,$906D,$906E,$EDA6,$EDA3,
$906F,$9070,$EDA2,$9071,$9072,$9073,$9074,$BBD6,$EDA7,$D0F4,$9075,$9076,$EDA4,
$BADE,$B6F7,$E3A1,$B6B2,$CCF1,$B9A7,$9077,$CFA2,$C7A1,$9078,$9079,$BFD2,$907A,
$907B,$B6F1,$907C,$E2FA,$E2FB,$E2FD,$E2FC,$C4D5,$E3A2,$907D,$D3C1,$907E,$9080,
$9081,$E3A7,$C7C4,$9082,$9083,$9084,$9085,$CFA4,$9086,$9087,$E3A9,$BAB7,$9088,
$9089,$908A,$908B,$E3A8,$908C,$BBDA,$908D,$E3A3,$908E,$908F,$9090,$E3A4,$E3AA,
$9091,$E3A6,$9092,$CEF2,$D3C6,$9093,$9094,$BBBC,$9095,$9096,$D4C3,$9097,$C4FA,
$9098,$9099,$EDA8,$D0FC,$E3A5,$909A,$C3F5,$909B,$E3AD,$B1AF,$909C,$E3B2,$909D,
$909E,$909F,$BCC2,$90A0,$90A1,$E3AC,$B5BF,$90A2,$90A3,$90A4,$90A5,$90A6,$90A7,
$90A8,$90A9,$C7E9,$E3B0,$90AA,$90AB,$90AC,$BEAA,$CDEF,$90AD,$90AE,$90AF,$90B0,
$90B1,$BBF3,$90B2,$90B3,$90B4,$CCE8,$90B5,$90B6,$E3AF,$90B7,$E3B1,$90B8,$CFA7,
$E3AE,$90B9,$CEA9,$BBDD,$90BA,$90BB,$90BC,$90BD,$90BE,$B5EB,$BEE5,$B2D2,$B3CD,
$90BF,$B1B9,$E3AB,$B2D1,$B5AC,$B9DF,$B6E8,$90C0,$90C1,$CFEB,$E3B7,$90C2,$BBCC,
$90C3,$90C4,$C8C7,$D0CA,$90C5,$90C6,$90C7,$90C8,$90C9,$E3B8,$B3EE,$90CA,$90CB,
$90CC,$90CD,$EDA9,$90CE,$D3FA,$D3E4,$90CF,$90D0,$90D1,$EDAA,$E3B9,$D2E2,$90D2,
$90D3,$90D4,$90D5,$90D6,$E3B5,$90D7,$90D8,$90D9,$90DA,$D3DE,$90DB,$90DC,$90DD,
$90DE,$B8D0,$E3B3,$90DF,$90E0,$E3B6,$B7DF,$90E1,$E3B4,$C0A2,$90E2,$90E3,$90E4,
$E3BA,$90E5,$90E6,$90E7,$90E8,$90E9,$90EA,$90EB,$90EC,$90ED,$90EE,$90EF,$90F0,
$90F1,$90F2,$90F3,$90F4,$90F5,$90F6,$90F7,$D4B8,$90F8,$90F9,$90FA,$90FB,$90FC,
$90FD,$90FE,$9140,$B4C8,$9141,$E3BB,$9142,$BBC5,$9143,$C9F7,$9144,$9145,$C9E5,
$9146,$9147,$9148,$C4BD,$9149,$914A,$914B,$914C,$914D,$914E,$914F,$EDAB,$9150,
$9151,$9152,$9153,$C2FD,$9154,$9155,$9156,$9157,$BBDB,$BFAE,$9158,$9159,$915A,
$915B,$915C,$915D,$915E,$CEBF,$915F,$9160,$9161,$9162,$E3BC,$9163,$BFB6,$9164,
$9165,$9166,$9167,$9168,$9169,$916A,$916B,$916C,$916D,$916E,$916F,$9170,$9171,
$9172,$9173,$9174,$9175,$9176,$B1EF,$9177,$9178,$D4F7,$9179,$917A,$917B,$917C,
$917D,$E3BE,$917E,$9180,$9181,$9182,$9183,$9184,$9185,$9186,$EDAD,$9187,$9188,
$9189,$918A,$918B,$918C,$918D,$918E,$918F,$E3BF,$BAA9,$EDAC,$9190,$9191,$E3BD,
$9192,$9193,$9194,$9195,$9196,$9197,$9198,$9199,$919A,$919B,$E3C0,$919C,$919D,
$919E,$919F,$91A0,$91A1,$BAB6,$91A2,$91A3,$91A4,$B6AE,$91A5,$91A6,$91A7,$91A8,
$91A9,$D0B8,$91AA,$B0C3,$EDAE,$91AB,$91AC,$91AD,$91AE,$91AF,$EDAF,$C0C1,$91B0,
$E3C1,$91B1,$91B2,$91B3,$91B4,$91B5,$91B6,$91B7,$91B8,$91B9,$91BA,$91BB,$91BC,
$91BD,$91BE,$91BF,$91C0,$91C1,$C5B3,$91C2,$91C3,$91C4,$91C5,$91C6,$91C7,$91C8,
$91C9,$91CA,$91CB,$91CC,$91CD,$91CE,$91CF,$E3C2,$91D0,$91D1,$91D2,$91D3,$91D4,
$91D5,$91D6,$91D7,$91D8,$DCB2,$91D9,$91DA,$91DB,$91DC,$91DD,$91DE,$EDB0,$91DF,
$B8EA,$91E0,$CEEC,$EAA7,$D0E7,$CAF9,$C8D6,$CFB7,$B3C9,$CED2,$BDE4,$91E1,$91E2,
$E3DE,$BBF2,$EAA8,$D5BD,$91E3,$C6DD,$EAA9,$91E4,$91E5,$91E6,$EAAA,$91E7,$EAAC,
$EAAB,$91E8,$EAAE,$EAAD,$91E9,$91EA,$91EB,$91EC,$BDD8,$91ED,$EAAF,$91EE,$C2BE,
$91EF,$91F0,$91F1,$91F2,$B4C1,$B4F7,$91F3,$91F4,$BBA7,$91F5,$91F6,$91F7,$91F8,
$91F9,$ECE6,$ECE5,$B7BF,$CBF9,$B1E2,$91FA,$ECE7,$91FB,$91FC,$91FD,$C9C8,$ECE8,
$ECE9,$91FE,$CAD6,$DED0,$B2C5,$D4FA,$9240,$9241,$C6CB,$B0C7,$B4F2,$C8D3,$9242,
$9243,$9244,$CDD0,$9245,$9246,$BFB8,$9247,$9248,$9249,$924A,$924B,$924C,$924D,
$BFDB,$924E,$924F,$C7A4,$D6B4,$9250,$C0A9,$DED1,$C9A8,$D1EF,$C5A4,$B0E7,$B3B6,
$C8C5,$9251,$9252,$B0E2,$9253,$9254,$B7F6,$9255,$9256,$C5FA,$9257,$9258,$B6F3,
$9259,$D5D2,$B3D0,$BCBC,$925A,$925B,$925C,$B3AD,$925D,$925E,$925F,$9260,$BEF1,
$B0D1,$9261,$9262,$9263,$9264,$9265,$9266,$D2D6,$CAE3,$D7A5,$9267,$CDB6,$B6B6,
$BFB9,$D5DB,$9268,$B8A7,$C5D7,$9269,$926A,$926B,$DED2,$BFD9,$C2D5,$C7C0,$926C,
$BBA4,$B1A8,$926D,$926E,$C5EA,$926F,$9270,$C5FB,$CCA7,$9271,$9272,$9273,$9274,
$B1A7,$9275,$9276,$9277,$B5D6,$9278,$9279,$927A,$C4A8,$927B,$DED3,$D1BA,$B3E9,
$927C,$C3F2,$927D,$927E,$B7F7,$9280,$D6F4,$B5A3,$B2F0,$C4B4,$C4E9,$C0AD,$DED4,
$9281,$B0E8,$C5C4,$C1E0,$9282,$B9D5,$9283,$BEDC,$CDD8,$B0CE,$9284,$CDCF,$DED6,
$BED0,$D7BE,$DED5,$D5D0,$B0DD,$9285,$9286,$C4E2,$9287,$9288,$C2A3,$BCF0,$9289,
$D3B5,$C0B9,$C5A1,$B2A6,$D4F1,$928A,$928B,$C0A8,$CAC3,$DED7,$D5FC,$928C,$B9B0,
$928D,$C8AD,$CBA9,$928E,$DED9,$BFBD,$928F,$9290,$9291,$9292,$C6B4,$D7A7,$CAB0,
$C4C3,$9293,$B3D6,$B9D2,$9294,$9295,$9296,$9297,$D6B8,$EAFC,$B0B4,$9298,$9299,
$929A,$929B,$BFE6,$929C,$929D,$CCF4,$929E,$929F,$92A0,$92A1,$CDDA,$92A2,$92A3,
$92A4,$D6BF,$C2CE,$92A5,$CECE,$CCA2,$D0AE,$C4D3,$B5B2,$DED8,$D5F5,$BCB7,$BBD3,
$92A6,$92A7,$B0A4,$92A8,$C5B2,$B4EC,$92A9,$92AA,$92AB,$D5F1,$92AC,$92AD,$EAFD,
$92AE,$92AF,$92B0,$92B1,$92B2,$92B3,$DEDA,$CDA6,$92B4,$92B5,$CDEC,$92B6,$92B7,
$92B8,$92B9,$CEE6,$DEDC,$92BA,$CDB1,$C0A6,$92BB,$92BC,$D7BD,$92BD,$DEDB,$B0C6,
$BAB4,$C9D3,$C4F3,$BEE8,$92BE,$92BF,$92C0,$92C1,$B2B6,$92C2,$92C3,$92C4,$92C5,
$92C6,$92C7,$92C8,$92C9,$C0CC,$CBF0,$92CA,$BCF1,$BBBB,$B5B7,$92CB,$92CC,$92CD,
$C5F5,$92CE,$DEE6,$92CF,$92D0,$92D1,$DEE3,$BEDD,$92D2,$92D3,$DEDF,$92D4,$92D5,
$92D6,$92D7,$B4B7,$BDDD,$92D8,$92D9,$DEE0,$C4ED,$92DA,$92DB,$92DC,$92DD,$CFC6,
$92DE,$B5E0,$92DF,$92E0,$92E1,$92E2,$B6DE,$CADA,$B5F4,$DEE5,$92E3,$D5C6,$92E4,
$DEE1,$CCCD,$C6FE,$92E5,$C5C5,$92E6,$92E7,$92E8,$D2B4,$92E9,$BEF2,$92EA,$92EB,
$92EC,$92ED,$92EE,$92EF,$92F0,$C2D3,$92F1,$CCBD,$B3B8,$92F2,$BDD3,$92F3,$BFD8,
$CDC6,$D1DA,$B4EB,$92F4,$DEE4,$DEDD,$DEE7,$92F5,$EAFE,$92F6,$92F7,$C2B0,$DEE2,
$92F8,$92F9,$D6C0,$B5A7,$92FA,$B2F4,$92FB,$DEE8,$92FC,$DEF2,$92FD,$92FE,$9340,
$9341,$9342,$DEED,$9343,$DEF1,$9344,$9345,$C8E0,$9346,$9347,$9348,$D7E1,$DEEF,
$C3E8,$CCE1,$9349,$B2E5,$934A,$934B,$934C,$D2BE,$934D,$934E,$934F,$9350,$9351,
$9352,$9353,$DEEE,$9354,$DEEB,$CED5,$9355,$B4A7,$9356,$9357,$9358,$9359,$935A,
$BFAB,$BEBE,$935B,$935C,$BDD2,$935D,$935E,$935F,$9360,$DEE9,$9361,$D4AE,$9362,
$DEDE,$9363,$DEEA,$9364,$9365,$9366,$9367,$C0BF,$9368,$DEEC,$B2F3,$B8E9,$C2A7,
$9369,$936A,$BDC1,$936B,$936C,$936D,$936E,$936F,$DEF5,$DEF8,$9370,$9371,$B2AB,
$B4A4,$9372,$9373,$B4EA,$C9A6,$9374,$9375,$9376,$9377,$9378,$9379,$DEF6,$CBD1,
$937A,$B8E3,$937B,$DEF7,$DEFA,$937C,$937D,$937E,$9380,$DEF9,$9381,$9382,$9383,
$CCC2,$9384,$B0E1,$B4EE,$9385,$9386,$9387,$9388,$9389,$938A,$E5BA,$938B,$938C,
$938D,$938E,$938F,$D0AF,$9390,$9391,$B2EB,$9392,$EBA1,$9393,$DEF4,$9394,$9395,
$C9E3,$DEF3,$B0DA,$D2A1,$B1F7,$9396,$CCAF,$9397,$9398,$9399,$939A,$939B,$939C,
$939D,$DEF0,$939E,$CBA4,$939F,$93A0,$93A1,$D5AA,$93A2,$93A3,$93A4,$93A5,$93A6,
$DEFB,$93A7,$93A8,$93A9,$93AA,$93AB,$93AC,$93AD,$93AE,$B4DD,$93AF,$C4A6,$93B0,
$93B1,$93B2,$DEFD,$93B3,$93B4,$93B5,$93B6,$93B7,$93B8,$93B9,$93BA,$93BB,$93BC,
$C3FE,$C4A1,$DFA1,$93BD,$93BE,$93BF,$93C0,$93C1,$93C2,$93C3,$C1CC,$93C4,$DEFC,
$BEEF,$93C5,$C6B2,$93C6,$93C7,$93C8,$93C9,$93CA,$93CB,$93CC,$93CD,$93CE,$B3C5,
$C8F6,$93CF,$93D0,$CBBA,$DEFE,$93D1,$93D2,$DFA4,$93D3,$93D4,$93D5,$93D6,$D7B2,
$93D7,$93D8,$93D9,$93DA,$93DB,$B3B7,$93DC,$93DD,$93DE,$93DF,$C1C3,$93E0,$93E1,
$C7CB,$B2A5,$B4E9,$93E2,$D7AB,$93E3,$93E4,$93E5,$93E6,$C4EC,$93E7,$DFA2,$DFA3,
$93E8,$DFA5,$93E9,$BAB3,$93EA,$93EB,$93EC,$DFA6,$93ED,$C0DE,$93EE,$93EF,$C9C3,
$93F0,$93F1,$93F2,$93F3,$93F4,$93F5,$93F6,$B2D9,$C7E6,$93F7,$DFA7,$93F8,$C7DC,
$93F9,$93FA,$93FB,$93FC,$DFA8,$EBA2,$93FD,$93FE,$9440,$9441,$9442,$CBD3,$9443,
$9444,$9445,$DFAA,$9446,$DFA9,$9447,$B2C1,$9448,$9449,$944A,$944B,$944C,$944D,
$944E,$944F,$9450,$9451,$9452,$9453,$9454,$9455,$9456,$9457,$9458,$9459,$945A,
$945B,$945C,$945D,$945E,$945F,$9460,$C5CA,$9461,$9462,$9463,$9464,$9465,$9466,
$9467,$9468,$DFAB,$9469,$946A,$946B,$946C,$946D,$946E,$946F,$9470,$D4DC,$9471,
$9472,$9473,$9474,$9475,$C8C1,$9476,$9477,$9478,$9479,$947A,$947B,$947C,$947D,
$947E,$9480,$9481,$9482,$DFAC,$9483,$9484,$9485,$9486,$9487,$BEF0,$9488,$9489,
$DFAD,$D6A7,$948A,$948B,$948C,$948D,$EAB7,$EBB6,$CAD5,$948E,$D8FC,$B8C4,$948F,
$B9A5,$9490,$9491,$B7C5,$D5FE,$9492,$9493,$9494,$9495,$9496,$B9CA,$9497,$9498,
$D0A7,$F4CD,$9499,$949A,$B5D0,$949B,$949C,$C3F4,$949D,$BEC8,$949E,$949F,$94A0,
$EBB7,$B0BD,$94A1,$94A2,$BDCC,$94A3,$C1B2,$94A4,$B1D6,$B3A8,$94A5,$94A6,$94A7,
$B8D2,$C9A2,$94A8,$94A9,$B6D8,$94AA,$94AB,$94AC,$94AD,$EBB8,$BEB4,$94AE,$94AF,
$94B0,$CAFD,$94B1,$C7C3,$94B2,$D5FB,$94B3,$94B4,$B7F3,$94B5,$94B6,$94B7,$94B8,
$94B9,$94BA,$94BB,$94BC,$94BD,$94BE,$94BF,$94C0,$94C1,$94C2,$94C3,$CEC4,$94C4,
$94C5,$94C6,$D5AB,$B1F3,$94C7,$94C8,$94C9,$ECB3,$B0DF,$94CA,$ECB5,$94CB,$94CC,
$94CD,$B6B7,$94CE,$C1CF,$94CF,$F5FA,$D0B1,$94D0,$94D1,$D5E5,$94D2,$CED3,$94D3,
$94D4,$BDEF,$B3E2,$94D5,$B8AB,$94D6,$D5B6,$94D7,$EDBD,$94D8,$B6CF,$94D9,$CBB9,
$D0C2,$94DA,$94DB,$94DC,$94DD,$94DE,$94DF,$94E0,$94E1,$B7BD,$94E2,$94E3,$ECB6,
$CAA9,$94E4,$94E5,$94E6,$C5D4,$94E7,$ECB9,$ECB8,$C2C3,$ECB7,$94E8,$94E9,$94EA,
$94EB,$D0FD,$ECBA,$94EC,$ECBB,$D7E5,$94ED,$94EE,$ECBC,$94EF,$94F0,$94F1,$ECBD,
$C6EC,$94F2,$94F3,$94F4,$94F5,$94F6,$94F7,$94F8,$94F9,$CEDE,$94FA,$BCC8,$94FB,
$94FC,$C8D5,$B5A9,$BEC9,$D6BC,$D4E7,$94FD,$94FE,$D1AE,$D0F1,$EAB8,$EAB9,$EABA,
$BAB5,$9540,$9541,$9542,$9543,$CAB1,$BFF5,$9544,$9545,$CDFA,$9546,$9547,$9548,
$9549,$954A,$EAC0,$954B,$B0BA,$EABE,$954C,$954D,$C0A5,$954E,$954F,$9550,$EABB,
$9551,$B2FD,$9552,$C3F7,$BBE8,$9553,$9554,$9555,$D2D7,$CEF4,$EABF,$9556,$9557,
$9558,$EABC,$9559,$955A,$955B,$EAC3,$955C,$D0C7,$D3B3,$955D,$955E,$955F,$9560,
$B4BA,$9561,$C3C1,$D7F2,$9562,$9563,$9564,$9565,$D5D1,$9566,$CAC7,$9567,$EAC5,
$9568,$9569,$EAC4,$EAC7,$EAC6,$956A,$956B,$956C,$956D,$956E,$D6E7,$956F,$CFD4,
$9570,$9571,$EACB,$9572,$BBCE,$9573,$9574,$9575,$9576,$9577,$9578,$9579,$BDFA,
$C9CE,$957A,$957B,$EACC,$957C,$957D,$C9B9,$CFFE,$EACA,$D4CE,$EACD,$EACF,$957E,
$9580,$CDED,$9581,$9582,$9583,$9584,$EAC9,$9585,$EACE,$9586,$9587,$CEEE,$9588,
$BBDE,$9589,$B3BF,$958A,$958B,$958C,$958D,$958E,$C6D5,$BEB0,$CEFA,$958F,$9590,
$9591,$C7E7,$9592,$BEA7,$EAD0,$9593,$9594,$D6C7,$9595,$9596,$9597,$C1C0,$9598,
$9599,$959A,$D4DD,$959B,$EAD1,$959C,$959D,$CFBE,$959E,$959F,$95A0,$95A1,$EAD2,
$95A2,$95A3,$95A4,$95A5,$CAEE,$95A6,$95A7,$95A8,$95A9,$C5AF,$B0B5,$95AA,$95AB,
$95AC,$95AD,$95AE,$EAD4,$95AF,$95B0,$95B1,$95B2,$95B3,$95B4,$95B5,$95B6,$95B7,
$EAD3,$F4DF,$95B8,$95B9,$95BA,$95BB,$95BC,$C4BA,$95BD,$95BE,$95BF,$95C0,$95C1,
$B1A9,$95C2,$95C3,$95C4,$95C5,$E5DF,$95C6,$95C7,$95C8,$95C9,$EAD5,$95CA,$95CB,
$95CC,$95CD,$95CE,$95CF,$95D0,$95D1,$95D2,$95D3,$95D4,$95D5,$95D6,$95D7,$95D8,
$95D9,$95DA,$95DB,$95DC,$95DD,$95DE,$95DF,$95E0,$95E1,$95E2,$95E3,$CAEF,$95E4,
$EAD6,$EAD7,$C6D8,$95E5,$95E6,$95E7,$95E8,$95E9,$95EA,$95EB,$95EC,$EAD8,$95ED,
$95EE,$EAD9,$95EF,$95F0,$95F1,$95F2,$95F3,$95F4,$D4BB,$95F5,$C7FA,$D2B7,$B8FC,
$95F6,$95F7,$EAC2,$95F8,$B2DC,$95F9,$95FA,$C2FC,$95FB,$D4F8,$CCE6,$D7EE,$95FC,
$95FD,$95FE,$9640,$9641,$9642,$9643,$D4C2,$D3D0,$EBC3,$C5F3,$9644,$B7FE,$9645,
$9646,$EBD4,$9647,$9648,$9649,$CBB7,$EBDE,$964A,$C0CA,$964B,$964C,$964D,$CDFB,
$964E,$B3AF,$964F,$C6DA,$9650,$9651,$9652,$9653,$9654,$9655,$EBFC,$9656,$C4BE,
$9657,$CEB4,$C4A9,$B1BE,$D4FD,$9658,$CAF5,$9659,$D6EC,$965A,$965B,$C6D3,$B6E4,
$965C,$965D,$965E,$965F,$BBFA,$9660,$9661,$D0E0,$9662,$9663,$C9B1,$9664,$D4D3,
$C8A8,$9665,$9666,$B8CB,$9667,$E8BE,$C9BC,$9668,$9669,$E8BB,$966A,$C0EE,$D0D3,
$B2C4,$B4E5,$966B,$E8BC,$966C,$966D,$D5C8,$966E,$966F,$9670,$9671,$9672,$B6C5,
$9673,$E8BD,$CAF8,$B8DC,$CCF5,$9674,$9675,$9676,$C0B4,$9677,$9678,$D1EE,$E8BF,
$E8C2,$9679,$967A,$BABC,$967B,$B1AD,$BDDC,$967C,$EABD,$E8C3,$967D,$E8C6,$967E,
$E8CB,$9680,$9681,$9682,$9683,$E8CC,$9684,$CBC9,$B0E5,$9685,$BCAB,$9686,$9687,
$B9B9,$9688,$9689,$E8C1,$968A,$CDF7,$968B,$E8CA,$968C,$968D,$968E,$968F,$CEF6,
$9690,$9691,$9692,$9693,$D5ED,$9694,$C1D6,$E8C4,$9695,$C3B6,$9696,$B9FB,$D6A6,
$E8C8,$9697,$9698,$9699,$CAE0,$D4E6,$969A,$E8C0,$969B,$E8C5,$E8C7,$969C,$C7B9,
$B7E3,$969D,$E8C9,$969E,$BFDD,$E8D2,$969F,$96A0,$E8D7,$96A1,$E8D5,$BCDC,$BCCF,
$E8DB,$96A2,$96A3,$96A4,$96A5,$96A6,$96A7,$96A8,$96A9,$E8DE,$96AA,$E8DA,$B1FA,
$96AB,$96AC,$96AD,$96AE,$96AF,$96B0,$96B1,$96B2,$96B3,$96B4,$B0D8,$C4B3,$B8CC,
$C6E2,$C8BE,$C8E1,$96B5,$96B6,$96B7,$E8CF,$E8D4,$E8D6,$96B8,$B9F1,$E8D8,$D7F5,
$96B9,$C4FB,$96BA,$E8DC,$96BB,$96BC,$B2E9,$96BD,$96BE,$96BF,$E8D1,$96C0,$96C1,
$BCED,$96C2,$96C3,$BFC2,$E8CD,$D6F9,$96C4,$C1F8,$B2F1,$96C5,$96C6,$96C7,$96C8,
$96C9,$96CA,$96CB,$96CC,$E8DF,$96CD,$CAC1,$E8D9,$96CE,$96CF,$96D0,$96D1,$D5A4,
$96D2,$B1EA,$D5BB,$E8CE,$E8D0,$B6B0,$E8D3,$96D3,$E8DD,$C0B8,$96D4,$CAF7,$96D5,
$CBA8,$96D6,$96D7,$C6DC,$C0F5,$96D8,$96D9,$96DA,$96DB,$96DC,$E8E9,$96DD,$96DE,
$96DF,$D0A3,$96E0,$96E1,$96E2,$96E3,$96E4,$96E5,$96E6,$E8F2,$D6EA,$96E7,$96E8,
$96E9,$96EA,$96EB,$96EC,$96ED,$E8E0,$E8E1,$96EE,$96EF,$96F0,$D1F9,$BACB,$B8F9,
$96F1,$96F2,$B8F1,$D4D4,$E8EF,$96F3,$E8EE,$E8EC,$B9F0,$CCD2,$E8E6,$CEA6,$BFF2,
$96F4,$B0B8,$E8F1,$E8F0,$96F5,$D7C0,$96F6,$E8E4,$96F7,$CDA9,$C9A3,$96F8,$BBB8,
$BDDB,$E8EA,$96F9,$96FA,$96FB,$96FC,$96FD,$96FE,$9740,$9741,$9742,$9743,$E8E2,
$E8E3,$E8E5,$B5B5,$E8E7,$C7C5,$E8EB,$E8ED,$BDB0,$D7AE,$9744,$E8F8,$9745,$9746,
$9747,$9748,$9749,$974A,$974B,$974C,$E8F5,$974D,$CDB0,$E8F6,$974E,$974F,$9750,
$9751,$9752,$9753,$9754,$9755,$9756,$C1BA,$9757,$E8E8,$9758,$C3B7,$B0F0,$9759,
$975A,$975B,$975C,$975D,$975E,$975F,$9760,$E8F4,$9761,$9762,$9763,$E8F7,$9764,
$9765,$9766,$B9A3,$9767,$9768,$9769,$976A,$976B,$976C,$976D,$976E,$976F,$9770,
$C9D2,$9771,$9772,$9773,$C3CE,$CEE0,$C0E6,$9774,$9775,$9776,$9777,$CBF3,$9778,
$CCDD,$D0B5,$9779,$977A,$CAE1,$977B,$E8F3,$977C,$977D,$977E,$9780,$9781,$9782,
$9783,$9784,$9785,$9786,$BCEC,$9787,$E8F9,$9788,$9789,$978A,$978B,$978C,$978D,
$C3DE,$978E,$C6E5,$978F,$B9F7,$9790,$9791,$9792,$9793,$B0F4,$9794,$9795,$D7D8,
$9796,$9797,$BCAC,$9798,$C5EF,$9799,$979A,$979B,$979C,$979D,$CCC4,$979E,$979F,
$E9A6,$97A0,$97A1,$97A2,$97A3,$97A4,$97A5,$97A6,$97A7,$97A8,$97A9,$C9AD,$97AA,
$E9A2,$C0E2,$97AB,$97AC,$97AD,$BFC3,$97AE,$97AF,$97B0,$E8FE,$B9D7,$97B1,$E8FB,
$97B2,$97B3,$97B4,$97B5,$E9A4,$97B6,$97B7,$97B8,$D2CE,$97B9,$97BA,$97BB,$97BC,
$97BD,$E9A3,$97BE,$D6B2,$D7B5,$97BF,$E9A7,$97C0,$BDB7,$97C1,$97C2,$97C3,$97C4,
$97C5,$97C6,$97C7,$97C8,$97C9,$97CA,$97CB,$97CC,$E8FC,$E8FD,$97CD,$97CE,$97CF,
$E9A1,$97D0,$97D1,$97D2,$97D3,$97D4,$97D5,$97D6,$97D7,$CDD6,$97D8,$97D9,$D2AC,
$97DA,$97DB,$97DC,$E9B2,$97DD,$97DE,$97DF,$97E0,$E9A9,$97E1,$97E2,$97E3,$B4AA,
$97E4,$B4BB,$97E5,$97E6,$E9AB,$97E7,$97E8,$97E9,$97EA,$97EB,$97EC,$97ED,$97EE,
$97EF,$97F0,$97F1,$97F2,$97F3,$97F4,$97F5,$97F6,$97F7,$D0A8,$97F8,$97F9,$E9A5,
$97FA,$97FB,$B3FE,$97FC,$97FD,$E9AC,$C0E3,$97FE,$E9AA,$9840,$9841,$E9B9,$9842,
$9843,$E9B8,$9844,$9845,$9846,$9847,$E9AE,$9848,$9849,$E8FA,$984A,$984B,$E9A8,
$984C,$984D,$984E,$984F,$9850,$BFAC,$E9B1,$E9BA,$9851,$9852,$C2A5,$9853,$9854,
$9855,$E9AF,$9856,$B8C5,$9857,$E9AD,$9858,$D3DC,$E9B4,$E9B5,$E9B7,$9859,$985A,
$985B,$E9C7,$985C,$985D,$985E,$985F,$9860,$9861,$C0C6,$E9C5,$9862,$9863,$E9B0,
$9864,$9865,$E9BB,$B0F1,$9866,$9867,$9868,$9869,$986A,$986B,$986C,$986D,$986E,
$986F,$E9BC,$D5A5,$9870,$9871,$E9BE,$9872,$E9BF,$9873,$9874,$9875,$E9C1,$9876,
$9877,$C1F1,$9878,$9879,$C8B6,$987A,$987B,$987C,$E9BD,$987D,$987E,$9880,$9881,
$9882,$E9C2,$9883,$9884,$9885,$9886,$9887,$9888,$9889,$988A,$E9C3,$988B,$E9B3,
$988C,$E9B6,$988D,$BBB1,$988E,$988F,$9890,$E9C0,$9891,$9892,$9893,$9894,$9895,
$9896,$BCF7,$9897,$9898,$9899,$E9C4,$E9C6,$989A,$989B,$989C,$989D,$989E,$989F,
$98A0,$98A1,$98A2,$98A3,$98A4,$98A5,$E9CA,$98A6,$98A7,$98A8,$98A9,$E9CE,$98AA,
$98AB,$98AC,$98AD,$98AE,$98AF,$98B0,$98B1,$98B2,$98B3,$B2DB,$98B4,$E9C8,$98B5,
$98B6,$98B7,$98B8,$98B9,$98BA,$98BB,$98BC,$98BD,$98BE,$B7AE,$98BF,$98C0,$98C1,
$98C2,$98C3,$98C4,$98C5,$98C6,$98C7,$98C8,$98C9,$98CA,$E9CB,$E9CC,$98CB,$98CC,
$98CD,$98CE,$98CF,$98D0,$D5C1,$98D1,$C4A3,$98D2,$98D3,$98D4,$98D5,$98D6,$98D7,
$E9D8,$98D8,$BAE1,$98D9,$98DA,$98DB,$98DC,$E9C9,$98DD,$D3A3,$98DE,$98DF,$98E0,
$E9D4,$98E1,$98E2,$98E3,$98E4,$98E5,$98E6,$98E7,$E9D7,$E9D0,$98E8,$98E9,$98EA,
$98EB,$98EC,$E9CF,$98ED,$98EE,$C7C1,$98EF,$98F0,$98F1,$98F2,$98F3,$98F4,$98F5,
$98F6,$E9D2,$98F7,$98F8,$98F9,$98FA,$98FB,$98FC,$98FD,$E9D9,$B3C8,$98FE,$E9D3,
$9940,$9941,$9942,$9943,$9944,$CFF0,$9945,$9946,$9947,$E9CD,$9948,$9949,$994A,
$994B,$994C,$994D,$994E,$994F,$9950,$9951,$9952,$B3F7,$9953,$9954,$9955,$9956,
$9957,$9958,$9959,$E9D6,$995A,$995B,$E9DA,$995C,$995D,$995E,$CCB4,$995F,$9960,
$9961,$CFAD,$9962,$9963,$9964,$9965,$9966,$9967,$9968,$9969,$996A,$E9D5,$996B,
$E9DC,$E9DB,$996C,$996D,$996E,$996F,$9970,$E9DE,$9971,$9972,$9973,$9974,$9975,
$9976,$9977,$9978,$E9D1,$9979,$997A,$997B,$997C,$997D,$997E,$9980,$9981,$E9DD,
$9982,$E9DF,$C3CA,$9983,$9984,$9985,$9986,$9987,$9988,$9989,$998A,$998B,$998C,
$998D,$998E,$998F,$9990,$9991,$9992,$9993,$9994,$9995,$9996,$9997,$9998,$9999,
$999A,$999B,$999C,$999D,$999E,$999F,$99A0,$99A1,$99A2,$99A3,$99A4,$99A5,$99A6,
$99A7,$99A8,$99A9,$99AA,$99AB,$99AC,$99AD,$99AE,$99AF,$99B0,$99B1,$99B2,$99B3,
$99B4,$99B5,$99B6,$99B7,$99B8,$99B9,$99BA,$99BB,$99BC,$99BD,$99BE,$99BF,$99C0,
$99C1,$99C2,$99C3,$99C4,$99C5,$99C6,$99C7,$99C8,$99C9,$99CA,$99CB,$99CC,$99CD,
$99CE,$99CF,$99D0,$99D1,$99D2,$99D3,$99D4,$99D5,$99D6,$99D7,$99D8,$99D9,$99DA,
$99DB,$99DC,$99DD,$99DE,$99DF,$99E0,$99E1,$99E2,$99E3,$99E4,$99E5,$99E6,$99E7,
$99E8,$99E9,$99EA,$99EB,$99EC,$99ED,$99EE,$99EF,$99F0,$99F1,$99F2,$99F3,$99F4,
$99F5,$C7B7,$B4CE,$BBB6,$D0C0,$ECA3,$99F6,$99F7,$C5B7,$99F8,$99F9,$99FA,$99FB,
$99FC,$99FD,$99FE,$9A40,$9A41,$9A42,$D3FB,$9A43,$9A44,$9A45,$9A46,$ECA4,$9A47,
$ECA5,$C6DB,$9A48,$9A49,$9A4A,$BFEE,$9A4B,$9A4C,$9A4D,$9A4E,$ECA6,$9A4F,$9A50,
$ECA7,$D0AA,$9A51,$C7B8,$9A52,$9A53,$B8E8,$9A54,$9A55,$9A56,$9A57,$9A58,$9A59,
$9A5A,$9A5B,$9A5C,$9A5D,$9A5E,$9A5F,$ECA8,$9A60,$9A61,$9A62,$9A63,$9A64,$9A65,
$9A66,$9A67,$D6B9,$D5FD,$B4CB,$B2BD,$CEE4,$C6E7,$9A68,$9A69,$CDE1,$9A6A,$9A6B,
$9A6C,$9A6D,$9A6E,$9A6F,$9A70,$9A71,$9A72,$9A73,$9A74,$9A75,$9A76,$9A77,$B4F5,
$9A78,$CBC0,$BCDF,$9A79,$9A7A,$9A7B,$9A7C,$E9E2,$E9E3,$D1EA,$E9E5,$9A7D,$B4F9,
$E9E4,$9A7E,$D1B3,$CAE2,$B2D0,$9A80,$E9E8,$9A81,$9A82,$9A83,$9A84,$E9E6,$E9E7,
$9A85,$9A86,$D6B3,$9A87,$9A88,$9A89,$E9E9,$E9EA,$9A8A,$9A8B,$9A8C,$9A8D,$9A8E,
$E9EB,$9A8F,$9A90,$9A91,$9A92,$9A93,$9A94,$9A95,$9A96,$E9EC,$9A97,$9A98,$9A99,
$9A9A,$9A9B,$9A9C,$9A9D,$9A9E,$ECAF,$C5B9,$B6CE,$9A9F,$D2F3,$9AA0,$9AA1,$9AA2,
$9AA3,$9AA4,$9AA5,$9AA6,$B5EE,$9AA7,$BBD9,$ECB1,$9AA8,$9AA9,$D2E3,$9AAA,$9AAB,
$9AAC,$9AAD,$9AAE,$CEE3,$9AAF,$C4B8,$9AB0,$C3BF,$9AB1,$9AB2,$B6BE,$D8B9,$B1C8,
$B1CF,$B1D1,$C5FE,$9AB3,$B1D0,$9AB4,$C3AB,$9AB5,$9AB6,$9AB7,$9AB8,$9AB9,$D5B1,
$9ABA,$9ABB,$9ABC,$9ABD,$9ABE,$9ABF,$9AC0,$9AC1,$EBA4,$BAC1,$9AC2,$9AC3,$9AC4,
$CCBA,$9AC5,$9AC6,$9AC7,$EBA5,$9AC8,$EBA7,$9AC9,$9ACA,$9ACB,$EBA8,$9ACC,$9ACD,
$9ACE,$EBA6,$9ACF,$9AD0,$9AD1,$9AD2,$9AD3,$9AD4,$9AD5,$EBA9,$EBAB,$EBAA,$9AD6,
$9AD7,$9AD8,$9AD9,$9ADA,$EBAC,$9ADB,$CACF,$D8B5,$C3F1,$9ADC,$C3A5,$C6F8,$EBAD,
$C4CA,$9ADD,$EBAE,$EBAF,$EBB0,$B7D5,$9ADE,$9ADF,$9AE0,$B7FA,$9AE1,$EBB1,$C7E2,
$9AE2,$EBB3,$9AE3,$BAA4,$D1F5,$B0B1,$EBB2,$EBB4,$9AE4,$9AE5,$9AE6,$B5AA,$C2C8,
$C7E8,$9AE7,$EBB5,$9AE8,$CBAE,$E3DF,$9AE9,$9AEA,$D3C0,$9AEB,$9AEC,$9AED,$9AEE,
$D9DB,$9AEF,$9AF0,$CDA1,$D6AD,$C7F3,$9AF1,$9AF2,$9AF3,$D9E0,$BBE3,$9AF4,$BABA,
$E3E2,$9AF5,$9AF6,$9AF7,$9AF8,$9AF9,$CFAB,$9AFA,$9AFB,$9AFC,$E3E0,$C9C7,$9AFD,
$BAB9,$9AFE,$9B40,$9B41,$D1B4,$E3E1,$C8EA,$B9AF,$BDAD,$B3D8,$CEDB,$9B42,$9B43,
$CCC0,$9B44,$9B45,$9B46,$E3E8,$E3E9,$CDF4,$9B47,$9B48,$9B49,$9B4A,$9B4B,$CCAD,
$9B4C,$BCB3,$9B4D,$E3EA,$9B4E,$E3EB,$9B4F,$9B50,$D0DA,$9B51,$9B52,$9B53,$C6FB,
$B7DA,$9B54,$9B55,$C7DF,$D2CA,$CED6,$9B56,$E3E4,$E3EC,$9B57,$C9F2,$B3C1,$9B58,
$9B59,$E3E7,$9B5A,$9B5B,$C6E3,$E3E5,$9B5C,$9B5D,$EDB3,$E3E6,$9B5E,$9B5F,$9B60,
$9B61,$C9B3,$9B62,$C5E6,$9B63,$9B64,$9B65,$B9B5,$9B66,$C3BB,$9B67,$E3E3,$C5BD,
$C1A4,$C2D9,$B2D7,$9B68,$E3ED,$BBA6,$C4AD,$9B69,$E3F0,$BEDA,$9B6A,$9B6B,$E3FB,
$E3F5,$BAD3,$9B6C,$9B6D,$9B6E,$9B6F,$B7D0,$D3CD,$9B70,$D6CE,$D5D3,$B9C1,$D5B4,
$D1D8,$9B71,$9B72,$9B73,$9B74,$D0B9,$C7F6,$9B75,$9B76,$9B77,$C8AA,$B2B4,$9B78,
$C3DA,$9B79,$9B7A,$9B7B,$E3EE,$9B7C,$9B7D,$E3FC,$E3EF,$B7A8,$E3F7,$E3F4,$9B7E,
$9B80,$9B81,$B7BA,$9B82,$9B83,$C5A2,$9B84,$E3F6,$C5DD,$B2A8,$C6FC,$9B85,$C4E0,
$9B86,$9B87,$D7A2,$9B88,$C0E1,$E3F9,$9B89,$9B8A,$E3FA,$E3FD,$CCA9,$E3F3,$9B8B,
$D3BE,$9B8C,$B1C3,$EDB4,$E3F1,$E3F2,$9B8D,$E3F8,$D0BA,$C6C3,$D4F3,$E3FE,$9B8E,
$9B8F,$BDE0,$9B90,$9B91,$E4A7,$9B92,$9B93,$E4A6,$9B94,$9B95,$9B96,$D1F3,$E4A3,
$9B97,$E4A9,$9B98,$9B99,$9B9A,$C8F7,$9B9B,$9B9C,$9B9D,$9B9E,$CFB4,$9B9F,$E4A8,
$E4AE,$C2E5,$9BA0,$9BA1,$B6B4,$9BA2,$9BA3,$9BA4,$9BA5,$9BA6,$9BA7,$BDF2,$9BA8,
$E4A2,$9BA9,$9BAA,$BAE9,$E4AA,$9BAB,$9BAC,$E4AC,$9BAD,$9BAE,$B6FD,$D6DE,$E4B2,
$9BAF,$E4AD,$9BB0,$9BB1,$9BB2,$E4A1,$9BB3,$BBEE,$CDDD,$C7A2,$C5C9,$9BB4,$9BB5,
$C1F7,$9BB6,$E4A4,$9BB7,$C7B3,$BDAC,$BDBD,$E4A5,$9BB8,$D7C7,$B2E2,$9BB9,$E4AB,
$BCC3,$E4AF,$9BBA,$BBEB,$E4B0,$C5A8,$E4B1,$9BBB,$9BBC,$9BBD,$9BBE,$D5E3,$BFA3,
$9BBF,$E4BA,$9BC0,$E4B7,$9BC1,$E4BB,$9BC2,$9BC3,$E4BD,$9BC4,$9BC5,$C6D6,$9BC6,
$9BC7,$BAC6,$C0CB,$9BC8,$9BC9,$9BCA,$B8A1,$E4B4,$9BCB,$9BCC,$9BCD,$9BCE,$D4A1,
$9BCF,$9BD0,$BAA3,$BDFE,$9BD1,$9BD2,$9BD3,$E4BC,$9BD4,$9BD5,$9BD6,$9BD7,$9BD8,
$CDBF,$9BD9,$9BDA,$C4F9,$9BDB,$9BDC,$CFFB,$C9E6,$9BDD,$9BDE,$D3BF,$9BDF,$CFD1,
$9BE0,$9BE1,$E4B3,$9BE2,$E4B8,$E4B9,$CCE9,$9BE3,$9BE4,$9BE5,$9BE6,$9BE7,$CCCE,
$9BE8,$C0D4,$E4B5,$C1B0,$E4B6,$CED0,$9BE9,$BBC1,$B5D3,$9BEA,$C8F3,$BDA7,$D5C7,
$C9AC,$B8A2,$E4CA,$9BEB,$9BEC,$E4CC,$D1C4,$9BED,$9BEE,$D2BA,$9BEF,$9BF0,$BAAD,
$9BF1,$9BF2,$BAD4,$9BF3,$9BF4,$9BF5,$9BF6,$9BF7,$9BF8,$E4C3,$B5ED,$9BF9,$9BFA,
$9BFB,$D7CD,$E4C0,$CFFD,$E4BF,$9BFC,$9BFD,$9BFE,$C1DC,$CCCA,$9C40,$9C41,$9C42,
$9C43,$CAE7,$9C44,$9C45,$9C46,$9C47,$C4D7,$9C48,$CCD4,$E4C8,$9C49,$9C4A,$9C4B,
$E4C7,$E4C1,$9C4C,$E4C4,$B5AD,$9C4D,$9C4E,$D3D9,$9C4F,$E4C6,$9C50,$9C51,$9C52,
$9C53,$D2F9,$B4E3,$9C54,$BBB4,$9C55,$9C56,$C9EE,$9C57,$B4BE,$9C58,$9C59,$9C5A,
$BBEC,$9C5B,$D1CD,$9C5C,$CCED,$EDB5,$9C5D,$9C5E,$9C5F,$9C60,$9C61,$9C62,$9C63,
$9C64,$C7E5,$9C65,$9C66,$9C67,$9C68,$D4A8,$9C69,$E4CB,$D7D5,$E4C2,$9C6A,$BDA5,
$E4C5,$9C6B,$9C6C,$D3E6,$9C6D,$E4C9,$C9F8,$9C6E,$9C6F,$E4BE,$9C70,$9C71,$D3E5,
$9C72,$9C73,$C7FE,$B6C9,$9C74,$D4FC,$B2B3,$E4D7,$9C75,$9C76,$9C77,$CEC2,$9C78,
$E4CD,$9C79,$CEBC,$9C7A,$B8DB,$9C7B,$9C7C,$E4D6,$9C7D,$BFCA,$9C7E,$9C80,$9C81,
$D3CE,$9C82,$C3EC,$9C83,$9C84,$9C85,$9C86,$9C87,$9C88,$9C89,$9C8A,$C5C8,$E4D8,
$9C8B,$9C8C,$9C8D,$9C8E,$9C8F,$9C90,$9C91,$9C92,$CDC4,$E4CF,$9C93,$9C94,$9C95,
$9C96,$E4D4,$E4D5,$9C97,$BAFE,$9C98,$CFE6,$9C99,$9C9A,$D5BF,$9C9B,$9C9C,$9C9D,
$E4D2,$9C9E,$9C9F,$9CA0,$9CA1,$9CA2,$9CA3,$9CA4,$9CA5,$9CA6,$9CA7,$9CA8,$E4D0,
$9CA9,$9CAA,$E4CE,$9CAB,$9CAC,$9CAD,$9CAE,$9CAF,$9CB0,$9CB1,$9CB2,$9CB3,$9CB4,
$9CB5,$9CB6,$9CB7,$9CB8,$9CB9,$CDE5,$CAAA,$9CBA,$9CBB,$9CBC,$C0A3,$9CBD,$BDA6,
$E4D3,$9CBE,$9CBF,$B8C8,$9CC0,$9CC1,$9CC2,$9CC3,$9CC4,$E4E7,$D4B4,$9CC5,$9CC6,
$9CC7,$9CC8,$9CC9,$9CCA,$9CCB,$E4DB,$9CCC,$9CCD,$9CCE,$C1EF,$9CCF,$9CD0,$E4E9,
$9CD1,$9CD2,$D2E7,$9CD3,$9CD4,$E4DF,$9CD5,$E4E0,$9CD6,$9CD7,$CFAA,$9CD8,$9CD9,
$9CDA,$9CDB,$CBDD,$9CDC,$E4DA,$E4D1,$9CDD,$E4E5,$9CDE,$C8DC,$E4E3,$9CDF,$9CE0,
$C4E7,$E4E2,$9CE1,$E4E1,$9CE2,$9CE3,$9CE4,$B3FC,$E4E8,$9CE5,$9CE6,$9CE7,$9CE8,
$B5E1,$9CE9,$9CEA,$9CEB,$D7CC,$9CEC,$9CED,$9CEE,$E4E6,$9CEF,$BBAC,$9CF0,$D7D2,
$CCCF,$EBF8,$9CF1,$E4E4,$9CF2,$9CF3,$B9F6,$9CF4,$9CF5,$9CF6,$D6CD,$E4D9,$E4DC,
$C2FA,$E4DE,$9CF7,$C2CB,$C0C4,$C2D0,$9CF8,$B1F5,$CCB2,$9CF9,$9CFA,$9CFB,$9CFC,
$9CFD,$9CFE,$9D40,$9D41,$9D42,$9D43,$B5CE,$9D44,$9D45,$9D46,$9D47,$E4EF,$9D48,
$9D49,$9D4A,$9D4B,$9D4C,$9D4D,$9D4E,$9D4F,$C6AF,$9D50,$9D51,$9D52,$C6E1,$9D53,
$9D54,$E4F5,$9D55,$9D56,$9D57,$9D58,$9D59,$C2A9,$9D5A,$9D5B,$9D5C,$C0EC,$D1DD,
$E4EE,$9D5D,$9D5E,$9D5F,$9D60,$9D61,$9D62,$9D63,$9D64,$9D65,$9D66,$C4AE,$9D67,
$9D68,$9D69,$E4ED,$9D6A,$9D6B,$9D6C,$9D6D,$E4F6,$E4F4,$C2FE,$9D6E,$E4DD,$9D6F,
$E4F0,$9D70,$CAFE,$9D71,$D5C4,$9D72,$9D73,$E4F1,$9D74,$9D75,$9D76,$9D77,$9D78,
$9D79,$9D7A,$D1FA,$9D7B,$9D7C,$9D7D,$9D7E,$9D80,$9D81,$9D82,$E4EB,$E4EC,$9D83,
$9D84,$9D85,$E4F2,$9D86,$CEAB,$9D87,$9D88,$9D89,$9D8A,$9D8B,$9D8C,$9D8D,$9D8E,
$9D8F,$9D90,$C5CB,$9D91,$9D92,$9D93,$C7B1,$9D94,$C2BA,$9D95,$9D96,$9D97,$E4EA,
$9D98,$9D99,$9D9A,$C1CA,$9D9B,$9D9C,$9D9D,$9D9E,$9D9F,$9DA0,$CCB6,$B3B1,$9DA1,
$9DA2,$9DA3,$E4FB,$9DA4,$E4F3,$9DA5,$9DA6,$9DA7,$E4FA,$9DA8,$E4FD,$9DA9,$E4FC,
$9DAA,$9DAB,$9DAC,$9DAD,$9DAE,$9DAF,$9DB0,$B3CE,$9DB1,$9DB2,$9DB3,$B3BA,$E4F7,
$9DB4,$9DB5,$E4F9,$E4F8,$C5EC,$9DB6,$9DB7,$9DB8,$9DB9,$9DBA,$9DBB,$9DBC,$9DBD,
$9DBE,$9DBF,$9DC0,$9DC1,$9DC2,$C0BD,$9DC3,$9DC4,$9DC5,$9DC6,$D4E8,$9DC7,$9DC8,
$9DC9,$9DCA,$9DCB,$E5A2,$9DCC,$9DCD,$9DCE,$9DCF,$9DD0,$9DD1,$9DD2,$9DD3,$9DD4,
$9DD5,$9DD6,$B0C4,$9DD7,$9DD8,$E5A4,$9DD9,$9DDA,$E5A3,$9DDB,$9DDC,$9DDD,$9DDE,
$9DDF,$9DE0,$BCA4,$9DE1,$E5A5,$9DE2,$9DE3,$9DE4,$9DE5,$9DE6,$9DE7,$E5A1,$9DE8,
$9DE9,$9DEA,$9DEB,$9DEC,$9DED,$9DEE,$E4FE,$B1F4,$9DEF,$9DF0,$9DF1,$9DF2,$9DF3,
$9DF4,$9DF5,$9DF6,$9DF7,$9DF8,$9DF9,$E5A8,$9DFA,$E5A9,$E5A6,$9DFB,$9DFC,$9DFD,
$9DFE,$9E40,$9E41,$9E42,$9E43,$9E44,$9E45,$9E46,$9E47,$E5A7,$E5AA,$9E48,$9E49,
$9E4A,$9E4B,$9E4C,$9E4D,$9E4E,$9E4F,$9E50,$9E51,$9E52,$9E53,$9E54,$9E55,$9E56,
$9E57,$9E58,$9E59,$9E5A,$9E5B,$9E5C,$9E5D,$9E5E,$9E5F,$9E60,$9E61,$9E62,$9E63,
$9E64,$9E65,$9E66,$9E67,$9E68,$C6D9,$9E69,$9E6A,$9E6B,$9E6C,$9E6D,$9E6E,$9E6F,
$9E70,$E5AB,$E5AD,$9E71,$9E72,$9E73,$9E74,$9E75,$9E76,$9E77,$E5AC,$9E78,$9E79,
$9E7A,$9E7B,$9E7C,$9E7D,$9E7E,$9E80,$9E81,$9E82,$9E83,$9E84,$9E85,$9E86,$9E87,
$9E88,$9E89,$E5AF,$9E8A,$9E8B,$9E8C,$E5AE,$9E8D,$9E8E,$9E8F,$9E90,$9E91,$9E92,
$9E93,$9E94,$9E95,$9E96,$9E97,$9E98,$9E99,$9E9A,$9E9B,$9E9C,$9E9D,$9E9E,$B9E0,
$9E9F,$9EA0,$E5B0,$9EA1,$9EA2,$9EA3,$9EA4,$9EA5,$9EA6,$9EA7,$9EA8,$9EA9,$9EAA,
$9EAB,$9EAC,$9EAD,$9EAE,$E5B1,$9EAF,$9EB0,$9EB1,$9EB2,$9EB3,$9EB4,$9EB5,$9EB6,
$9EB7,$9EB8,$9EB9,$9EBA,$BBF0,$ECE1,$C3F0,$9EBB,$B5C6,$BBD2,$9EBC,$9EBD,$9EBE,
$9EBF,$C1E9,$D4EE,$9EC0,$BEC4,$9EC1,$9EC2,$9EC3,$D7C6,$9EC4,$D4D6,$B2D3,$ECBE,
$9EC5,$9EC6,$9EC7,$9EC8,$EAC1,$9EC9,$9ECA,$9ECB,$C2AF,$B4B6,$9ECC,$9ECD,$9ECE,
$D1D7,$9ECF,$9ED0,$9ED1,$B3B4,$9ED2,$C8B2,$BFBB,$ECC0,$9ED3,$9ED4,$D6CB,$9ED5,
$9ED6,$ECBF,$ECC1,$9ED7,$9ED8,$9ED9,$9EDA,$9EDB,$9EDC,$9EDD,$9EDE,$9EDF,$9EE0,
$9EE1,$9EE2,$9EE3,$ECC5,$BEE6,$CCBF,$C5DA,$BEBC,$9EE4,$ECC6,$9EE5,$B1FE,$9EE6,
$9EE7,$9EE8,$ECC4,$D5A8,$B5E3,$9EE9,$ECC2,$C1B6,$B3E3,$9EEA,$9EEB,$ECC3,$CBB8,
$C0C3,$CCFE,$9EEC,$9EED,$9EEE,$9EEF,$C1D2,$9EF0,$ECC8,$9EF1,$9EF2,$9EF3,$9EF4,
$9EF5,$9EF6,$9EF7,$9EF8,$9EF9,$9EFA,$9EFB,$9EFC,$9EFD,$BAE6,$C0D3,$9EFE,$D6F2,
$9F40,$9F41,$9F42,$D1CC,$9F43,$9F44,$9F45,$9F46,$BFBE,$9F47,$B7B3,$C9D5,$ECC7,
$BBE2,$9F48,$CCCC,$BDFD,$C8C8,$9F49,$CFA9,$9F4A,$9F4B,$9F4C,$9F4D,$9F4E,$9F4F,
$9F50,$CDE9,$9F51,$C5EB,$9F52,$9F53,$9F54,$B7E9,$9F55,$9F56,$9F57,$9F58,$9F59,
$9F5A,$9F5B,$9F5C,$9F5D,$9F5E,$9F5F,$D1C9,$BAB8,$9F60,$9F61,$9F62,$9F63,$9F64,
$ECC9,$9F65,$9F66,$ECCA,$9F67,$BBC0,$ECCB,$9F68,$ECE2,$B1BA,$B7D9,$9F69,$9F6A,
$9F6B,$9F6C,$9F6D,$9F6E,$9F6F,$9F70,$9F71,$9F72,$9F73,$BDB9,$9F74,$9F75,$9F76,
$9F77,$9F78,$9F79,$9F7A,$9F7B,$ECCC,$D1E6,$ECCD,$9F7C,$9F7D,$9F7E,$9F80,$C8BB,
$9F81,$9F82,$9F83,$9F84,$9F85,$9F86,$9F87,$9F88,$9F89,$9F8A,$9F8B,$9F8C,$9F8D,
$9F8E,$ECD1,$9F8F,$9F90,$9F91,$9F92,$ECD3,$9F93,$BBCD,$9F94,$BCE5,$9F95,$9F96,
$9F97,$9F98,$9F99,$9F9A,$9F9B,$9F9C,$9F9D,$9F9E,$9F9F,$9FA0,$9FA1,$ECCF,$9FA2,
$C9B7,$9FA3,$9FA4,$9FA5,$9FA6,$9FA7,$C3BA,$9FA8,$ECE3,$D5D5,$ECD0,$9FA9,$9FAA,
$9FAB,$9FAC,$9FAD,$D6F3,$9FAE,$9FAF,$9FB0,$ECD2,$ECCE,$9FB1,$9FB2,$9FB3,$9FB4,
$ECD4,$9FB5,$ECD5,$9FB6,$9FB7,$C9BF,$9FB8,$9FB9,$9FBA,$9FBB,$9FBC,$9FBD,$CFA8,
$9FBE,$9FBF,$9FC0,$9FC1,$9FC2,$D0DC,$9FC3,$9FC4,$9FC5,$9FC6,$D1AC,$9FC7,$9FC8,
$9FC9,$9FCA,$C8DB,$9FCB,$9FCC,$9FCD,$ECD6,$CEF5,$9FCE,$9FCF,$9FD0,$9FD1,$9FD2,
$CAEC,$ECDA,$9FD3,$9FD4,$9FD5,$9FD6,$9FD7,$9FD8,$9FD9,$ECD9,$9FDA,$9FDB,$9FDC,
$B0BE,$9FDD,$9FDE,$9FDF,$9FE0,$9FE1,$9FE2,$ECD7,$9FE3,$ECD8,$9FE4,$9FE5,$9FE6,
$ECE4,$9FE7,$9FE8,$9FE9,$9FEA,$9FEB,$9FEC,$9FED,$9FEE,$9FEF,$C8BC,$9FF0,$9FF1,
$9FF2,$9FF3,$9FF4,$9FF5,$9FF6,$9FF7,$9FF8,$9FF9,$C1C7,$9FFA,$9FFB,$9FFC,$9FFD,
$9FFE,$ECDC,$D1E0,$A040,$A041,$A042,$A043,$A044,$A045,$A046,$A047,$A048,$A049,
$ECDB,$A04A,$A04B,$A04C,$A04D,$D4EF,$A04E,$ECDD,$A04F,$A050,$A051,$A052,$A053,
$A054,$DBC6,$A055,$A056,$A057,$A058,$A059,$A05A,$A05B,$A05C,$A05D,$A05E,$ECDE,
$A05F,$A060,$A061,$A062,$A063,$A064,$A065,$A066,$A067,$A068,$A069,$A06A,$B1AC,
$A06B,$A06C,$A06D,$A06E,$A06F,$A070,$A071,$A072,$A073,$A074,$A075,$A076,$A077,
$A078,$A079,$A07A,$A07B,$A07C,$A07D,$A07E,$A080,$A081,$ECDF,$A082,$A083,$A084,
$A085,$A086,$A087,$A088,$A089,$A08A,$A08B,$ECE0,$A08C,$D7A6,$A08D,$C5C0,$A08E,
$A08F,$A090,$EBBC,$B0AE,$A091,$A092,$A093,$BEF4,$B8B8,$D2AF,$B0D6,$B5F9,$A094,
$D8B3,$A095,$CBAC,$A096,$E3DD,$A097,$A098,$A099,$A09A,$A09B,$A09C,$A09D,$C6AC,
$B0E6,$A09E,$A09F,$A0A0,$C5C6,$EBB9,$A0A1,$A0A2,$A0A3,$A0A4,$EBBA,$A0A5,$A0A6,
$A0A7,$EBBB,$A0A8,$A0A9,$D1C0,$A0AA,$C5A3,$A0AB,$EAF2,$A0AC,$C4B2,$A0AD,$C4B5,
$C0CE,$A0AE,$A0AF,$A0B0,$EAF3,$C4C1,$A0B1,$CEEF,$A0B2,$A0B3,$A0B4,$A0B5,$EAF0,
$EAF4,$A0B6,$A0B7,$C9FC,$A0B8,$A0B9,$C7A3,$A0BA,$A0BB,$A0BC,$CCD8,$CEFE,$A0BD,
$A0BE,$A0BF,$EAF5,$EAF6,$CFAC,$C0E7,$A0C0,$A0C1,$EAF7,$A0C2,$A0C3,$A0C4,$A0C5,
$A0C6,$B6BF,$EAF8,$A0C7,$EAF9,$A0C8,$EAFA,$A0C9,$A0CA,$EAFB,$A0CB,$A0CC,$A0CD,
$A0CE,$A0CF,$A0D0,$A0D1,$A0D2,$A0D3,$A0D4,$A0D5,$A0D6,$EAF1,$A0D7,$A0D8,$A0D9,
$A0DA,$A0DB,$A0DC,$A0DD,$A0DE,$A0DF,$A0E0,$A0E1,$A0E2,$C8AE,$E1EB,$A0E3,$B7B8,
$E1EC,$A0E4,$A0E5,$A0E6,$E1ED,$A0E7,$D7B4,$E1EE,$E1EF,$D3CC,$A0E8,$A0E9,$A0EA,
$A0EB,$A0EC,$A0ED,$A0EE,$E1F1,$BFF1,$E1F0,$B5D2,$A0EF,$A0F0,$A0F1,$B1B7,$A0F2,
$A0F3,$A0F4,$A0F5,$E1F3,$E1F2,$A0F6,$BAFC,$A0F7,$E1F4,$A0F8,$A0F9,$A0FA,$A0FB,
$B9B7,$A0FC,$BED1,$A0FD,$A0FE,$AA40,$AA41,$C4FC,$AA42,$BADD,$BDC6,$AA43,$AA44,
$AA45,$AA46,$AA47,$AA48,$E1F5,$E1F7,$AA49,$AA4A,$B6C0,$CFC1,$CAA8,$E1F6,$D5F8,
$D3FC,$E1F8,$E1FC,$E1F9,$AA4B,$AA4C,$E1FA,$C0EA,$AA4D,$E1FE,$E2A1,$C0C7,$AA4E,
$AA4F,$AA50,$AA51,$E1FB,$AA52,$E1FD,$AA53,$AA54,$AA55,$AA56,$AA57,$AA58,$E2A5,
$AA59,$AA5A,$AA5B,$C1D4,$AA5C,$AA5D,$AA5E,$AA5F,$E2A3,$AA60,$E2A8,$B2FE,$E2A2,
$AA61,$AA62,$AA63,$C3CD,$B2C2,$E2A7,$E2A6,$AA64,$AA65,$E2A4,$E2A9,$AA66,$AA67,
$E2AB,$AA68,$AA69,$AA6A,$D0C9,$D6ED,$C3A8,$E2AC,$AA6B,$CFD7,$AA6C,$AA6D,$E2AE,
$AA6E,$AA6F,$BAEF,$AA70,$AA71,$E9E0,$E2AD,$E2AA,$AA72,$AA73,$AA74,$AA75,$BBAB,
$D4B3,$AA76,$AA77,$AA78,$AA79,$AA7A,$AA7B,$AA7C,$AA7D,$AA7E,$AA80,$AA81,$AA82,
$AA83,$E2B0,$AA84,$AA85,$E2AF,$AA86,$E9E1,$AA87,$AA88,$AA89,$AA8A,$E2B1,$AA8B,
$AA8C,$AA8D,$AA8E,$AA8F,$AA90,$AA91,$AA92,$E2B2,$AA93,$AA94,$AA95,$AA96,$AA97,
$AA98,$AA99,$AA9A,$AA9B,$AA9C,$AA9D,$E2B3,$CCA1,$AA9E,$E2B4,$AA9F,$AAA0,$AB40,
$AB41,$AB42,$AB43,$AB44,$AB45,$AB46,$AB47,$AB48,$AB49,$AB4A,$AB4B,$E2B5,$AB4C,
$AB4D,$AB4E,$AB4F,$AB50,$D0FE,$AB51,$AB52,$C2CA,$AB53,$D3F1,$AB54,$CDF5,$AB55,
$AB56,$E7E0,$AB57,$AB58,$E7E1,$AB59,$AB5A,$AB5B,$AB5C,$BEC1,$AB5D,$AB5E,$AB5F,
$AB60,$C2EA,$AB61,$AB62,$AB63,$E7E4,$AB64,$AB65,$E7E3,$AB66,$AB67,$AB68,$AB69,
$AB6A,$AB6B,$CDE6,$AB6C,$C3B5,$AB6D,$AB6E,$E7E2,$BBB7,$CFD6,$AB6F,$C1E1,$E7E9,
$AB70,$AB71,$AB72,$E7E8,$AB73,$AB74,$E7F4,$B2A3,$AB75,$AB76,$AB77,$AB78,$E7EA,
$AB79,$E7E6,$AB7A,$AB7B,$AB7C,$AB7D,$AB7E,$E7EC,$E7EB,$C9BA,$AB80,$AB81,$D5E4,
$AB82,$E7E5,$B7A9,$E7E7,$AB83,$AB84,$AB85,$AB86,$AB87,$AB88,$AB89,$E7EE,$AB8A,
$AB8B,$AB8C,$AB8D,$E7F3,$AB8E,$D6E9,$AB8F,$AB90,$AB91,$AB92,$E7ED,$AB93,$E7F2,
$AB94,$E7F1,$AB95,$AB96,$AB97,$B0E0,$AB98,$AB99,$AB9A,$AB9B,$E7F5,$AB9C,$AB9D,
$AB9E,$AB9F,$ABA0,$AC40,$AC41,$AC42,$AC43,$AC44,$AC45,$AC46,$AC47,$AC48,$AC49,
$AC4A,$C7F2,$AC4B,$C0C5,$C0ED,$AC4C,$AC4D,$C1F0,$E7F0,$AC4E,$AC4F,$AC50,$AC51,
$E7F6,$CBF6,$AC52,$AC53,$AC54,$AC55,$AC56,$AC57,$AC58,$AC59,$AC5A,$E8A2,$E8A1,
$AC5B,$AC5C,$AC5D,$AC5E,$AC5F,$AC60,$D7C1,$AC61,$AC62,$E7FA,$E7F9,$AC63,$E7FB,
$AC64,$E7F7,$AC65,$E7FE,$AC66,$E7FD,$AC67,$E7FC,$AC68,$AC69,$C1D5,$C7D9,$C5FD,
$C5C3,$AC6A,$AC6B,$AC6C,$AC6D,$AC6E,$C7ED,$AC6F,$AC70,$AC71,$AC72,$E8A3,$AC73,
$AC74,$AC75,$AC76,$AC77,$AC78,$AC79,$AC7A,$AC7B,$AC7C,$AC7D,$AC7E,$AC80,$AC81,
$AC82,$AC83,$AC84,$AC85,$AC86,$E8A6,$AC87,$E8A5,$AC88,$E8A7,$BAF7,$E7F8,$E8A4,
$AC89,$C8F0,$C9AA,$AC8A,$AC8B,$AC8C,$AC8D,$AC8E,$AC8F,$AC90,$AC91,$AC92,$AC93,
$AC94,$AC95,$AC96,$E8A9,$AC97,$AC98,$B9E5,$AC99,$AC9A,$AC9B,$AC9C,$AC9D,$D1FE,
$E8A8,$AC9E,$AC9F,$ACA0,$AD40,$AD41,$AD42,$E8AA,$AD43,$E8AD,$E8AE,$AD44,$C1A7,
$AD45,$AD46,$AD47,$E8AF,$AD48,$AD49,$AD4A,$E8B0,$AD4B,$AD4C,$E8AC,$AD4D,$E8B4,
$AD4E,$AD4F,$AD50,$AD51,$AD52,$AD53,$AD54,$AD55,$AD56,$AD57,$AD58,$E8AB,$AD59,
$E8B1,$AD5A,$AD5B,$AD5C,$AD5D,$AD5E,$AD5F,$AD60,$AD61,$E8B5,$E8B2,$E8B3,$AD62,
$AD63,$AD64,$AD65,$AD66,$AD67,$AD68,$AD69,$AD6A,$AD6B,$AD6C,$AD6D,$AD6E,$AD6F,
$AD70,$AD71,$E8B7,$AD72,$AD73,$AD74,$AD75,$AD76,$AD77,$AD78,$AD79,$AD7A,$AD7B,
$AD7C,$AD7D,$AD7E,$AD80,$AD81,$AD82,$AD83,$AD84,$AD85,$AD86,$AD87,$AD88,$AD89,
$E8B6,$AD8A,$AD8B,$AD8C,$AD8D,$AD8E,$AD8F,$AD90,$AD91,$AD92,$B9CF,$AD93,$F0AC,
$AD94,$F0AD,$AD95,$C6B0,$B0EA,$C8BF,$AD96,$CDDF,$AD97,$AD98,$AD99,$AD9A,$AD9B,
$AD9C,$AD9D,$CECD,$EAB1,$AD9E,$AD9F,$ADA0,$AE40,$EAB2,$AE41,$C6BF,$B4C9,$AE42,
$AE43,$AE44,$AE45,$AE46,$AE47,$AE48,$EAB3,$AE49,$AE4A,$AE4B,$AE4C,$D5E7,$AE4D,
$AE4E,$AE4F,$AE50,$AE51,$AE52,$AE53,$AE54,$DDF9,$AE55,$EAB4,$AE56,$EAB5,$AE57,
$EAB6,$AE58,$AE59,$AE5A,$AE5B,$B8CA,$DFB0,$C9F5,$AE5C,$CCF0,$AE5D,$AE5E,$C9FA,
$AE5F,$AE60,$AE61,$AE62,$AE63,$C9FB,$AE64,$AE65,$D3C3,$CBA6,$AE66,$B8A6,$F0AE,
$B1C2,$AE67,$E5B8,$CCEF,$D3C9,$BCD7,$C9EA,$AE68,$B5E7,$AE69,$C4D0,$B5E9,$AE6A,
$EEAE,$BBAD,$AE6B,$AE6C,$E7DE,$AE6D,$EEAF,$AE6E,$AE6F,$AE70,$AE71,$B3A9,$AE72,
$AE73,$EEB2,$AE74,$AE75,$EEB1,$BDE7,$AE76,$EEB0,$CEB7,$AE77,$AE78,$AE79,$AE7A,
$C5CF,$AE7B,$AE7C,$AE7D,$AE7E,$C1F4,$DBCE,$EEB3,$D0F3,$AE80,$AE81,$AE82,$AE83,
$AE84,$AE85,$AE86,$AE87,$C2D4,$C6E8,$AE88,$AE89,$AE8A,$B7AC,$AE8B,$AE8C,$AE8D,
$AE8E,$AE8F,$AE90,$AE91,$EEB4,$AE92,$B3EB,$AE93,$AE94,$AE95,$BBFB,$EEB5,$AE96,
$AE97,$AE98,$AE99,$AE9A,$E7DC,$AE9B,$AE9C,$AE9D,$EEB6,$AE9E,$AE9F,$BDAE,$AEA0,
$AF40,$AF41,$AF42,$F1E2,$AF43,$AF44,$AF45,$CAE8,$AF46,$D2C9,$F0DA,$AF47,$F0DB,
$AF48,$F0DC,$C1C6,$AF49,$B8ED,$BECE,$AF4A,$AF4B,$F0DE,$AF4C,$C5B1,$F0DD,$D1F1,
$AF4D,$F0E0,$B0CC,$BDEA,$AF4E,$AF4F,$AF50,$AF51,$AF52,$D2DF,$F0DF,$AF53,$B4AF,
$B7E8,$F0E6,$F0E5,$C6A3,$F0E1,$F0E2,$B4C3,$AF54,$AF55,$F0E3,$D5EE,$AF56,$AF57,
$CCDB,$BED2,$BCB2,$AF58,$AF59,$AF5A,$F0E8,$F0E7,$F0E4,$B2A1,$AF5B,$D6A2,$D3B8,
$BEB7,$C8AC,$AF5C,$AF5D,$F0EA,$AF5E,$AF5F,$AF60,$AF61,$D1F7,$AF62,$D6CC,$BADB,
$F0E9,$AF63,$B6BB,$AF64,$AF65,$CDB4,$AF66,$AF67,$C6A6,$AF68,$AF69,$AF6A,$C1A1,
$F0EB,$F0EE,$AF6B,$F0ED,$F0F0,$F0EC,$AF6C,$BBBE,$F0EF,$AF6D,$AF6E,$AF6F,$AF70,
$CCB5,$F0F2,$AF71,$AF72,$B3D5,$AF73,$AF74,$AF75,$AF76,$B1D4,$AF77,$AF78,$F0F3,
$AF79,$AF7A,$F0F4,$F0F6,$B4E1,$AF7B,$F0F1,$AF7C,$F0F7,$AF7D,$AF7E,$AF80,$AF81,
$F0FA,$AF82,$F0F8,$AF83,$AF84,$AF85,$F0F5,$AF86,$AF87,$AF88,$AF89,$F0FD,$AF8A,
$F0F9,$F0FC,$F0FE,$AF8B,$F1A1,$AF8C,$AF8D,$AF8E,$CEC1,$F1A4,$AF8F,$F1A3,$AF90,
$C1F6,$F0FB,$CADD,$AF91,$AF92,$B4F1,$B1F1,$CCB1,$AF93,$F1A6,$AF94,$AF95,$F1A7,
$AF96,$AF97,$F1AC,$D5CE,$F1A9,$AF98,$AF99,$C8B3,$AF9A,$AF9B,$AF9C,$F1A2,$AF9D,
$F1AB,$F1A8,$F1A5,$AF9E,$AF9F,$F1AA,$AFA0,$B040,$B041,$B042,$B043,$B044,$B045,
$B046,$B0A9,$F1AD,$B047,$B048,$B049,$B04A,$B04B,$B04C,$F1AF,$B04D,$F1B1,$B04E,
$B04F,$B050,$B051,$B052,$F1B0,$B053,$F1AE,$B054,$B055,$B056,$B057,$D1A2,$B058,
$B059,$B05A,$B05B,$B05C,$B05D,$B05E,$F1B2,$B05F,$B060,$B061,$F1B3,$B062,$B063,
$B064,$B065,$B066,$B067,$B068,$B069,$B9EF,$B06A,$B06B,$B5C7,$B06C,$B0D7,$B0D9,
$B06D,$B06E,$B06F,$D4ED,$B070,$B5C4,$B071,$BDD4,$BBCA,$F0A7,$B072,$B073,$B8DE,
$B074,$B075,$F0A8,$B076,$B077,$B0A8,$B078,$F0A9,$B079,$B07A,$CDEE,$B07B,$B07C,
$F0AA,$B07D,$B07E,$B080,$B081,$B082,$B083,$B084,$B085,$B086,$B087,$F0AB,$B088,
$B089,$B08A,$B08B,$B08C,$B08D,$B08E,$B08F,$B090,$C6A4,$B091,$B092,$D6E5,$F1E4,
$B093,$F1E5,$B094,$B095,$B096,$B097,$B098,$B099,$B09A,$B09B,$B09C,$B09D,$C3F3,
$B09E,$B09F,$D3DB,$B0A0,$B140,$D6D1,$C5E8,$B141,$D3AF,$B142,$D2E6,$B143,$B144,
$EEC1,$B0BB,$D5B5,$D1CE,$BCE0,$BAD0,$B145,$BFF8,$B146,$B8C7,$B5C1,$C5CC,$B147,
$B148,$CAA2,$B149,$B14A,$B14B,$C3CB,$B14C,$B14D,$B14E,$B14F,$B150,$EEC2,$B151,
$B152,$B153,$B154,$B155,$B156,$B157,$B158,$C4BF,$B6A2,$B159,$EDEC,$C3A4,$B15A,
$D6B1,$B15B,$B15C,$B15D,$CFE0,$EDEF,$B15E,$B15F,$C5CE,$B160,$B6DC,$B161,$B162,
$CAA1,$B163,$B164,$EDED,$B165,$B166,$EDF0,$EDF1,$C3BC,$B167,$BFB4,$B168,$EDEE,
$B169,$B16A,$B16B,$B16C,$B16D,$B16E,$B16F,$B170,$B171,$B172,$B173,$EDF4,$EDF2,
$B174,$B175,$B176,$B177,$D5E6,$C3DF,$B178,$EDF3,$B179,$B17A,$B17B,$EDF6,$B17C,
$D5A3,$D1A3,$B17D,$B17E,$B180,$EDF5,$B181,$C3D0,$B182,$B183,$B184,$B185,$B186,
$EDF7,$BFF4,$BEEC,$EDF8,$B187,$CCF7,$B188,$D1DB,$B189,$B18A,$B18B,$D7C5,$D5F6,
$B18C,$EDFC,$B18D,$B18E,$B18F,$EDFB,$B190,$B191,$B192,$B193,$B194,$B195,$B196,
$B197,$EDF9,$EDFA,$B198,$B199,$B19A,$B19B,$B19C,$B19D,$B19E,$B19F,$EDFD,$BEA6,
$B1A0,$B240,$B241,$B242,$B243,$CBAF,$EEA1,$B6BD,$B244,$EEA2,$C4C0,$B245,$EDFE,
$B246,$B247,$BDDE,$B2C7,$B248,$B249,$B24A,$B24B,$B24C,$B24D,$B24E,$B24F,$B250,
$B251,$B252,$B253,$B6C3,$B254,$B255,$B256,$EEA5,$D8BA,$EEA3,$EEA6,$B257,$B258,
$B259,$C3E9,$B3F2,$B25A,$B25B,$B25C,$B25D,$B25E,$B25F,$EEA7,$EEA4,$CFB9,$B260,
$B261,$EEA8,$C2F7,$B262,$B263,$B264,$B265,$B266,$B267,$B268,$B269,$B26A,$B26B,
$B26C,$B26D,$EEA9,$EEAA,$B26E,$DEAB,$B26F,$B270,$C6B3,$B271,$C7C6,$B272,$D6F5,
$B5C9,$B273,$CBB2,$B274,$B275,$B276,$EEAB,$B277,$B278,$CDAB,$B279,$EEAC,$B27A,
$B27B,$B27C,$B27D,$B27E,$D5B0,$B280,$EEAD,$B281,$F6C4,$B282,$B283,$B284,$B285,
$B286,$B287,$B288,$B289,$B28A,$B28B,$B28C,$B28D,$B28E,$DBC7,$B28F,$B290,$B291,
$B292,$B293,$B294,$B295,$B296,$B297,$B4A3,$B298,$B299,$B29A,$C3AC,$F1E6,$B29B,
$B29C,$B29D,$B29E,$B29F,$CAB8,$D2D3,$B2A0,$D6AA,$B340,$EFF2,$B341,$BED8,$B342,
$BDC3,$EFF3,$B6CC,$B0AB,$B343,$B344,$B345,$B346,$CAAF,$B347,$B348,$EDB6,$B349,
$EDB7,$B34A,$B34B,$B34C,$B34D,$CEF9,$B7AF,$BFF3,$EDB8,$C2EB,$C9B0,$B34E,$B34F,
$B350,$B351,$B352,$B353,$EDB9,$B354,$B355,$C6F6,$BFB3,$B356,$B357,$B358,$EDBC,
$C5F8,$B359,$D1D0,$B35A,$D7A9,$EDBA,$EDBB,$B35B,$D1E2,$B35C,$EDBF,$EDC0,$B35D,
$EDC4,$B35E,$B35F,$B360,$EDC8,$B361,$EDC6,$EDCE,$D5E8,$B362,$EDC9,$B363,$B364,
$EDC7,$EDBE,$B365,$B366,$C5E9,$B367,$B368,$B369,$C6C6,$B36A,$B36B,$C9E9,$D4D2,
$EDC1,$EDC2,$EDC3,$EDC5,$B36C,$C0F9,$B36D,$B4A1,$B36E,$B36F,$B370,$B371,$B9E8,
$B372,$EDD0,$B373,$B374,$B375,$B376,$EDD1,$B377,$EDCA,$B378,$EDCF,$B379,$CEF8,
$B37A,$B37B,$CBB6,$EDCC,$EDCD,$B37C,$B37D,$B37E,$B380,$B381,$CFF5,$B382,$B383,
$B384,$B385,$B386,$B387,$B388,$B389,$B38A,$B38B,$B38C,$B38D,$EDD2,$C1F2,$D3B2,
$EDCB,$C8B7,$B38E,$B38F,$B390,$B391,$B392,$B393,$B394,$B395,$BCEF,$B396,$B397,
$B398,$B399,$C5F0,$B39A,$B39B,$B39C,$B39D,$B39E,$B39F,$B3A0,$B440,$B441,$B442,
$EDD6,$B443,$B5EF,$B444,$B445,$C2B5,$B0AD,$CBE9,$B446,$B447,$B1AE,$B448,$EDD4,
$B449,$B44A,$B44B,$CDEB,$B5E2,$B44C,$EDD5,$EDD3,$EDD7,$B44D,$B44E,$B5FA,$B44F,
$EDD8,$B450,$EDD9,$B451,$EDDC,$B452,$B1CC,$B453,$B454,$B455,$B456,$B457,$B458,
$B459,$B45A,$C5F6,$BCEE,$EDDA,$CCBC,$B2EA,$B45B,$B45C,$B45D,$B45E,$EDDB,$B45F,
$B460,$B461,$B462,$C4EB,$B463,$B464,$B4C5,$B465,$B466,$B467,$B0F5,$B468,$B469,
$B46A,$EDDF,$C0DA,$B4E8,$B46B,$B46C,$B46D,$B46E,$C5CD,$B46F,$B470,$B471,$EDDD,
$BFC4,$B472,$B473,$B474,$EDDE,$B475,$B476,$B477,$B478,$B479,$B47A,$B47B,$B47C,
$B47D,$B47E,$B480,$B481,$B482,$B483,$C4A5,$B484,$B485,$B486,$EDE0,$B487,$B488,
$B489,$B48A,$B48B,$EDE1,$B48C,$EDE3,$B48D,$B48E,$C1D7,$B48F,$B490,$BBC7,$B491,
$B492,$B493,$B494,$B495,$B496,$BDB8,$B497,$B498,$B499,$EDE2,$B49A,$B49B,$B49C,
$B49D,$B49E,$B49F,$B4A0,$B540,$B541,$B542,$B543,$B544,$B545,$EDE4,$B546,$B547,
$B548,$B549,$B54A,$B54B,$B54C,$B54D,$B54E,$B54F,$EDE6,$B550,$B551,$B552,$B553,
$B554,$EDE5,$B555,$B556,$B557,$B558,$B559,$B55A,$B55B,$B55C,$B55D,$B55E,$B55F,
$B560,$B561,$B562,$B563,$EDE7,$B564,$B565,$B566,$B567,$B568,$CABE,$ECEA,$C0F1,
$B569,$C9E7,$B56A,$ECEB,$C6EE,$B56B,$B56C,$B56D,$B56E,$ECEC,$B56F,$C6ED,$ECED,
$B570,$B571,$B572,$B573,$B574,$B575,$B576,$B577,$B578,$ECF0,$B579,$B57A,$D7E6,
$ECF3,$B57B,$B57C,$ECF1,$ECEE,$ECEF,$D7A3,$C9F1,$CBEE,$ECF4,$B57D,$ECF2,$B57E,
$B580,$CFE9,$B581,$ECF6,$C6B1,$B582,$B583,$B584,$B585,$BCC0,$B586,$ECF5,$B587,
$B588,$B589,$B58A,$B58B,$B58C,$B58D,$B5BB,$BBF6,$B58E,$ECF7,$B58F,$B590,$B591,
$B592,$B593,$D9F7,$BDFB,$B594,$B595,$C2BB,$ECF8,$B596,$B597,$B598,$B599,$ECF9,
$B59A,$B59B,$B59C,$B59D,$B8A3,$B59E,$B59F,$B5A0,$B640,$B641,$B642,$B643,$B644,
$B645,$B646,$ECFA,$B647,$B648,$B649,$B64A,$B64B,$B64C,$B64D,$B64E,$B64F,$B650,
$B651,$B652,$ECFB,$B653,$B654,$B655,$B656,$B657,$B658,$B659,$B65A,$B65B,$B65C,
$B65D,$ECFC,$B65E,$B65F,$B660,$B661,$B662,$D3ED,$D8AE,$C0EB,$B663,$C7DD,$BACC,
$B664,$D0E3,$CBBD,$B665,$CDBA,$B666,$B667,$B8D1,$B668,$B669,$B1FC,$B66A,$C7EF,
$B66B,$D6D6,$B66C,$B66D,$B66E,$BFC6,$C3EB,$B66F,$B670,$EFF5,$B671,$B672,$C3D8,
$B673,$B674,$B675,$B676,$B677,$B678,$D7E2,$B679,$B67A,$B67B,$EFF7,$B3D3,$B67C,
$C7D8,$D1ED,$B67D,$D6C8,$B67E,$EFF8,$B680,$EFF6,$B681,$BBFD,$B3C6,$B682,$B683,
$B684,$B685,$B686,$B687,$B688,$BDD5,$B689,$B68A,$D2C6,$B68B,$BBE0,$B68C,$B68D,
$CFA1,$B68E,$EFFC,$EFFB,$B68F,$B690,$EFF9,$B691,$B692,$B693,$B694,$B3CC,$B695,
$C9D4,$CBB0,$B696,$B697,$B698,$B699,$B69A,$EFFE,$B69B,$B69C,$B0DE,$B69D,$B69E,
$D6C9,$B69F,$B6A0,$B740,$EFFD,$B741,$B3ED,$B742,$B743,$F6D5,$B744,$B745,$B746,
$B747,$B748,$B749,$B74A,$B74B,$B74C,$B74D,$B74E,$B74F,$B750,$B751,$B752,$CEC8,
$B753,$B754,$B755,$F0A2,$B756,$F0A1,$B757,$B5BE,$BCDA,$BBFC,$B758,$B8E5,$B759,
$B75A,$B75B,$B75C,$B75D,$B75E,$C4C2,$B75F,$B760,$B761,$B762,$B763,$B764,$B765,
$B766,$B767,$B768,$F0A3,$B769,$B76A,$B76B,$B76C,$B76D,$CBEB,$B76E,$B76F,$B770,
$B771,$B772,$B773,$B774,$B775,$B776,$B777,$B778,$B779,$B77A,$B77B,$B77C,$B77D,
$B77E,$B780,$B781,$B782,$B783,$B784,$B785,$B786,$F0A6,$B787,$B788,$B789,$D1A8,
$B78A,$BEBF,$C7EE,$F1B6,$F1B7,$BFD5,$B78B,$B78C,$B78D,$B78E,$B4A9,$F1B8,$CDBB,
$B78F,$C7D4,$D5AD,$B790,$F1B9,$B791,$F1BA,$B792,$B793,$B794,$B795,$C7CF,$B796,
$B797,$B798,$D2A4,$D6CF,$B799,$B79A,$F1BB,$BDD1,$B4B0,$BEBD,$B79B,$B79C,$B79D,
$B4DC,$CED1,$B79E,$BFDF,$F1BD,$B79F,$B7A0,$B840,$B841,$BFFA,$F1BC,$B842,$F1BF,
$B843,$B844,$B845,$F1BE,$F1C0,$B846,$B847,$B848,$B849,$B84A,$F1C1,$B84B,$B84C,
$B84D,$B84E,$B84F,$B850,$B851,$B852,$B853,$B854,$B855,$C1FE,$B856,$B857,$B858,
$B859,$B85A,$B85B,$B85C,$B85D,$B85E,$B85F,$B860,$C1A2,$B861,$B862,$B863,$B864,
$B865,$B866,$B867,$B868,$B869,$B86A,$CAFA,$B86B,$B86C,$D5BE,$B86D,$B86E,$B86F,
$B870,$BEBA,$BEB9,$D5C2,$B871,$B872,$BFA2,$B873,$CDAF,$F1B5,$B874,$B875,$B876,
$B877,$B878,$B879,$BDDF,$B87A,$B6CB,$B87B,$B87C,$B87D,$B87E,$B880,$B881,$B882,
$B883,$B884,$D6F1,$F3C3,$B885,$B886,$F3C4,$B887,$B8CD,$B888,$B889,$B88A,$F3C6,
$F3C7,$B88B,$B0CA,$B88C,$F3C5,$B88D,$F3C9,$CBF1,$B88E,$B88F,$B890,$F3CB,$B891,
$D0A6,$B892,$B893,$B1CA,$F3C8,$B894,$B895,$B896,$F3CF,$B897,$B5D1,$B898,$B899,
$F3D7,$B89A,$F3D2,$B89B,$B89C,$B89D,$F3D4,$F3D3,$B7FB,$B89E,$B1BF,$B89F,$F3CE,
$F3CA,$B5DA,$B8A0,$F3D0,$B940,$B941,$F3D1,$B942,$F3D5,$B943,$B944,$B945,$B946,
$F3CD,$B947,$BCE3,$B948,$C1FD,$B949,$F3D6,$B94A,$B94B,$B94C,$B94D,$B94E,$B94F,
$F3DA,$B950,$F3CC,$B951,$B5C8,$B952,$BDEE,$F3DC,$B953,$B954,$B7A4,$BFF0,$D6FE,
$CDB2,$B955,$B4F0,$B956,$B2DF,$B957,$F3D8,$B958,$F3D9,$C9B8,$B959,$F3DD,$B95A,
$B95B,$F3DE,$B95C,$F3E1,$B95D,$B95E,$B95F,$B960,$B961,$B962,$B963,$B964,$B965,
$B966,$B967,$F3DF,$B968,$B969,$F3E3,$F3E2,$B96A,$B96B,$F3DB,$B96C,$BFEA,$B96D,
$B3EF,$B96E,$F3E0,$B96F,$B970,$C7A9,$B971,$BCF2,$B972,$B973,$B974,$B975,$F3EB,
$B976,$B977,$B978,$B979,$B97A,$B97B,$B97C,$B9BF,$B97D,$B97E,$F3E4,$B980,$B981,
$B982,$B2AD,$BBFE,$B983,$CBE3,$B984,$B985,$B986,$B987,$F3ED,$F3E9,$B988,$B989,
$B98A,$B9DC,$F3EE,$B98B,$B98C,$B98D,$F3E5,$F3E6,$F3EA,$C2E1,$F3EC,$F3EF,$F3E8,
$BCFD,$B98E,$B98F,$B990,$CFE4,$B991,$B992,$F3F0,$B993,$B994,$B995,$F3E7,$B996,
$B997,$B998,$B999,$B99A,$B99B,$B99C,$B99D,$F3F2,$B99E,$B99F,$B9A0,$BA40,$D7AD,
$C6AA,$BA41,$BA42,$BA43,$BA44,$F3F3,$BA45,$BA46,$BA47,$BA48,$F3F1,$BA49,$C2A8,
$BA4A,$BA4B,$BA4C,$BA4D,$BA4E,$B8DD,$F3F5,$BA4F,$BA50,$F3F4,$BA51,$BA52,$BA53,
$B4DB,$BA54,$BA55,$BA56,$F3F6,$F3F7,$BA57,$BA58,$BA59,$F3F8,$BA5A,$BA5B,$BA5C,
$C0BA,$BA5D,$BA5E,$C0E9,$BA5F,$BA60,$BA61,$BA62,$BA63,$C5F1,$BA64,$BA65,$BA66,
$BA67,$F3FB,$BA68,$F3FA,$BA69,$BA6A,$BA6B,$BA6C,$BA6D,$BA6E,$BA6F,$BA70,$B4D8,
$BA71,$BA72,$BA73,$F3FE,$F3F9,$BA74,$BA75,$F3FC,$BA76,$BA77,$BA78,$BA79,$BA7A,
$BA7B,$F3FD,$BA7C,$BA7D,$BA7E,$BA80,$BA81,$BA82,$BA83,$BA84,$F4A1,$BA85,$BA86,
$BA87,$BA88,$BA89,$BA8A,$F4A3,$BBC9,$BA8B,$BA8C,$F4A2,$BA8D,$BA8E,$BA8F,$BA90,
$BA91,$BA92,$BA93,$BA94,$BA95,$BA96,$BA97,$BA98,$BA99,$F4A4,$BA9A,$BA9B,$BA9C,
$BA9D,$BA9E,$BA9F,$B2BE,$F4A6,$F4A5,$BAA0,$BB40,$BB41,$BB42,$BB43,$BB44,$BB45,
$BB46,$BB47,$BB48,$BB49,$BCAE,$BB4A,$BB4B,$BB4C,$BB4D,$BB4E,$BB4F,$BB50,$BB51,
$BB52,$BB53,$BB54,$BB55,$BB56,$BB57,$BB58,$BB59,$BB5A,$BB5B,$BB5C,$BB5D,$BB5E,
$BB5F,$BB60,$BB61,$BB62,$BB63,$BB64,$BB65,$BB66,$BB67,$BB68,$BB69,$BB6A,$BB6B,
$BB6C,$BB6D,$BB6E,$C3D7,$D9E1,$BB6F,$BB70,$BB71,$BB72,$BB73,$BB74,$C0E0,$F4CC,
$D7D1,$BB75,$BB76,$BB77,$BB78,$BB79,$BB7A,$BB7B,$BB7C,$BB7D,$BB7E,$BB80,$B7DB,
$BB81,$BB82,$BB83,$BB84,$BB85,$BB86,$BB87,$F4CE,$C1A3,$BB88,$BB89,$C6C9,$BB8A,
$B4D6,$D5B3,$BB8B,$BB8C,$BB8D,$F4D0,$F4CF,$F4D1,$CBDA,$BB8E,$BB8F,$F4D2,$BB90,
$D4C1,$D6E0,$BB91,$BB92,$BB93,$BB94,$B7E0,$BB95,$BB96,$BB97,$C1B8,$BB98,$BB99,
$C1BB,$F4D3,$BEAC,$BB9A,$BB9B,$BB9C,$BB9D,$BB9E,$B4E2,$BB9F,$BBA0,$F4D4,$F4D5,
$BEAB,$BC40,$BC41,$F4D6,$BC42,$BC43,$BC44,$F4DB,$BC45,$F4D7,$F4DA,$BC46,$BAFD,
$BC47,$F4D8,$F4D9,$BC48,$BC49,$BC4A,$BC4B,$BC4C,$BC4D,$BC4E,$B8E2,$CCC7,$F4DC,
$BC4F,$B2DA,$BC50,$BC51,$C3D3,$BC52,$BC53,$D4E3,$BFB7,$BC54,$BC55,$BC56,$BC57,
$BC58,$BC59,$BC5A,$F4DD,$BC5B,$BC5C,$BC5D,$BC5E,$BC5F,$BC60,$C5B4,$BC61,$BC62,
$BC63,$BC64,$BC65,$BC66,$BC67,$BC68,$F4E9,$BC69,$BC6A,$CFB5,$BC6B,$BC6C,$BC6D,
$BC6E,$BC6F,$BC70,$BC71,$BC72,$BC73,$BC74,$BC75,$BC76,$BC77,$BC78,$CEC9,$BC79,
$BC7A,$BC7B,$BC7C,$BC7D,$BC7E,$BC80,$BC81,$BC82,$BC83,$BC84,$BC85,$BC86,$BC87,
$BC88,$BC89,$BC8A,$BC8B,$BC8C,$BC8D,$BC8E,$CBD8,$BC8F,$CBF7,$BC90,$BC91,$BC92,
$BC93,$BDF4,$BC94,$BC95,$BC96,$D7CF,$BC97,$BC98,$BC99,$C0DB,$BC9A,$BC9B,$BC9C,
$BC9D,$BC9E,$BC9F,$BCA0,$BD40,$BD41,$BD42,$BD43,$BD44,$BD45,$BD46,$BD47,$BD48,
$BD49,$BD4A,$BD4B,$BD4C,$BD4D,$BD4E,$BD4F,$BD50,$BD51,$BD52,$BD53,$BD54,$BD55,
$BD56,$BD57,$BD58,$BD59,$BD5A,$BD5B,$BD5C,$BD5D,$BD5E,$BD5F,$BD60,$BD61,$BD62,
$BD63,$BD64,$BD65,$BD66,$BD67,$BD68,$BD69,$BD6A,$BD6B,$BD6C,$BD6D,$BD6E,$BD6F,
$BD70,$BD71,$BD72,$BD73,$BD74,$BD75,$BD76,$D0F5,$BD77,$BD78,$BD79,$BD7A,$BD7B,
$BD7C,$BD7D,$BD7E,$F4EA,$BD80,$BD81,$BD82,$BD83,$BD84,$BD85,$BD86,$BD87,$BD88,
$BD89,$BD8A,$BD8B,$BD8C,$BD8D,$BD8E,$BD8F,$BD90,$BD91,$BD92,$BD93,$BD94,$BD95,
$BD96,$BD97,$BD98,$BD99,$BD9A,$BD9B,$BD9C,$BD9D,$BD9E,$BD9F,$BDA0,$BE40,$BE41,
$BE42,$BE43,$BE44,$BE45,$BE46,$BE47,$BE48,$BE49,$BE4A,$BE4B,$BE4C,$F4EB,$BE4D,
$BE4E,$BE4F,$BE50,$BE51,$BE52,$BE53,$F4EC,$BE54,$BE55,$BE56,$BE57,$BE58,$BE59,
$BE5A,$BE5B,$BE5C,$BE5D,$BE5E,$BE5F,$BE60,$BE61,$BE62,$BE63,$BE64,$BE65,$BE66,
$BE67,$BE68,$BE69,$BE6A,$BE6B,$BE6C,$BE6D,$BE6E,$BE6F,$BE70,$BE71,$BE72,$BE73,
$BE74,$BE75,$BE76,$BE77,$BE78,$BE79,$BE7A,$BE7B,$BE7C,$BE7D,$BE7E,$BE80,$BE81,
$BE82,$BE83,$BE84,$BE85,$BE86,$BE87,$BE88,$BE89,$BE8A,$BE8B,$BE8C,$BE8D,$BE8E,
$BE8F,$BE90,$BE91,$BE92,$BE93,$BE94,$BE95,$BE96,$BE97,$BE98,$BE99,$BE9A,$BE9B,
$BE9C,$BE9D,$BE9E,$BE9F,$BEA0,$BF40,$BF41,$BF42,$BF43,$BF44,$BF45,$BF46,$BF47,
$BF48,$BF49,$BF4A,$BF4B,$BF4C,$BF4D,$BF4E,$BF4F,$BF50,$BF51,$BF52,$BF53,$BF54,
$BF55,$BF56,$BF57,$BF58,$BF59,$BF5A,$BF5B,$BF5C,$BF5D,$BF5E,$BF5F,$BF60,$BF61,
$BF62,$BF63,$BF64,$BF65,$BF66,$BF67,$BF68,$BF69,$BF6A,$BF6B,$BF6C,$BF6D,$BF6E,
$BF6F,$BF70,$BF71,$BF72,$BF73,$BF74,$BF75,$BF76,$BF77,$BF78,$BF79,$BF7A,$BF7B,
$BF7C,$BF7D,$BF7E,$BF80,$F7E3,$BF81,$BF82,$BF83,$BF84,$BF85,$B7B1,$BF86,$BF87,
$BF88,$BF89,$BF8A,$F4ED,$BF8B,$BF8C,$BF8D,$BF8E,$BF8F,$BF90,$BF91,$BF92,$BF93,
$BF94,$BF95,$BF96,$BF97,$BF98,$BF99,$BF9A,$BF9B,$BF9C,$BF9D,$BF9E,$BF9F,$BFA0,
$C040,$C041,$C042,$C043,$C044,$C045,$C046,$C047,$C048,$C049,$C04A,$C04B,$C04C,
$C04D,$C04E,$C04F,$C050,$C051,$C052,$C053,$C054,$C055,$C056,$C057,$C058,$C059,
$C05A,$C05B,$C05C,$C05D,$C05E,$C05F,$C060,$C061,$C062,$C063,$D7EB,$C064,$C065,
$C066,$C067,$C068,$C069,$C06A,$C06B,$C06C,$C06D,$C06E,$C06F,$C070,$C071,$C072,
$C073,$C074,$C075,$C076,$C077,$C078,$C079,$C07A,$C07B,$F4EE,$C07C,$C07D,$C07E,
$E6F9,$BEC0,$E6FA,$BAEC,$E6FB,$CFCB,$E6FC,$D4BC,$BCB6,$E6FD,$E6FE,$BCCD,$C8D2,
$CEB3,$E7A1,$C080,$B4BF,$E7A2,$C9B4,$B8D9,$C4C9,$C081,$D7DD,$C2DA,$B7D7,$D6BD,
$CEC6,$B7C4,$C082,$C083,$C5A6,$E7A3,$CFDF,$E7A4,$E7A5,$E7A6,$C1B7,$D7E9,$C9F0,
$CFB8,$D6AF,$D6D5,$E7A7,$B0ED,$E7A8,$E7A9,$C9DC,$D2EF,$BEAD,$E7AA,$B0F3,$C8DE,
$BDE1,$E7AB,$C8C6,$C084,$E7AC,$BBE6,$B8F8,$D1A4,$E7AD,$C2E7,$BEF8,$BDCA,$CDB3,
$E7AE,$E7AF,$BEEE,$D0E5,$C085,$CBE7,$CCD0,$BCCC,$E7B0,$BCA8,$D0F7,$E7B1,$C086,
$D0F8,$E7B2,$E7B3,$B4C2,$E7B4,$E7B5,$C9FE,$CEAC,$C3E0,$E7B7,$B1C1,$B3F1,$C087,
$E7B8,$E7B9,$D7DB,$D5C0,$E7BA,$C2CC,$D7BA,$E7BB,$E7BC,$E7BD,$BCEA,$C3E5,$C0C2,
$E7BE,$E7BF,$BCA9,$C088,$E7C0,$E7C1,$E7B6,$B6D0,$E7C2,$C089,$E7C3,$E7C4,$BBBA,
$B5DE,$C2C6,$B1E0,$E7C5,$D4B5,$E7C6,$B8BF,$E7C8,$E7C7,$B7EC,$C08A,$E7C9,$B2F8,
$E7CA,$E7CB,$E7CC,$E7CD,$E7CE,$E7CF,$E7D0,$D3A7,$CBF5,$E7D1,$E7D2,$E7D3,$E7D4,
$C9C9,$E7D5,$E7D6,$E7D7,$E7D8,$E7D9,$BDC9,$E7DA,$F3BE,$C08B,$B8D7,$C08C,$C8B1,
$C08D,$C08E,$C08F,$C090,$C091,$C092,$C093,$F3BF,$C094,$F3C0,$F3C1,$C095,$C096,
$C097,$C098,$C099,$C09A,$C09B,$C09C,$C09D,$C09E,$B9DE,$CDF8,$C09F,$C0A0,$D8E8,
$BAB1,$C140,$C2DE,$EEB7,$C141,$B7A3,$C142,$C143,$C144,$C145,$EEB9,$C146,$EEB8,
$B0D5,$C147,$C148,$C149,$C14A,$C14B,$EEBB,$D5D6,$D7EF,$C14C,$C14D,$C14E,$D6C3,
$C14F,$C150,$EEBD,$CAF0,$C151,$EEBC,$C152,$C153,$C154,$C155,$EEBE,$C156,$C157,
$C158,$C159,$EEC0,$C15A,$C15B,$EEBF,$C15C,$C15D,$C15E,$C15F,$C160,$C161,$C162,
$C163,$D1F2,$C164,$C7BC,$C165,$C3C0,$C166,$C167,$C168,$C169,$C16A,$B8E1,$C16B,
$C16C,$C16D,$C16E,$C16F,$C1E7,$C170,$C171,$F4C6,$D0DF,$F4C7,$C172,$CFDB,$C173,
$C174,$C8BA,$C175,$C176,$F4C8,$C177,$C178,$C179,$C17A,$C17B,$C17C,$C17D,$F4C9,
$F4CA,$C17E,$F4CB,$C180,$C181,$C182,$C183,$C184,$D9FA,$B8FE,$C185,$C186,$E5F1,
$D3F0,$C187,$F4E0,$C188,$CECC,$C189,$C18A,$C18B,$B3E1,$C18C,$C18D,$C18E,$C18F,
$F1B4,$C190,$D2EE,$C191,$F4E1,$C192,$C193,$C194,$C195,$C196,$CFE8,$F4E2,$C197,
$C198,$C7CC,$C199,$C19A,$C19B,$C19C,$C19D,$C19E,$B5D4,$B4E4,$F4E4,$C19F,$C1A0,
$C240,$F4E3,$F4E5,$C241,$C242,$F4E6,$C243,$C244,$C245,$C246,$F4E7,$C247,$BAB2,
$B0BF,$C248,$F4E8,$C249,$C24A,$C24B,$C24C,$C24D,$C24E,$C24F,$B7AD,$D2ED,$C250,
$C251,$C252,$D2AB,$C0CF,$C253,$BFBC,$EBA3,$D5DF,$EAC8,$C254,$C255,$C256,$C257,
$F1F3,$B6F8,$CBA3,$C258,$C259,$C4CD,$C25A,$F1E7,$C25B,$F1E8,$B8FB,$F1E9,$BAC4,
$D4C5,$B0D2,$C25C,$C25D,$F1EA,$C25E,$C25F,$C260,$F1EB,$C261,$F1EC,$C262,$C263,
$F1ED,$F1EE,$F1EF,$F1F1,$F1F0,$C5D5,$C264,$C265,$C266,$C267,$C268,$C269,$F1F2,
$C26A,$B6FA,$C26B,$F1F4,$D2AE,$DEC7,$CBCA,$C26C,$C26D,$B3DC,$C26E,$B5A2,$C26F,
$B9A2,$C270,$C271,$C4F4,$F1F5,$C272,$C273,$F1F6,$C274,$C275,$C276,$C1C4,$C1FB,
$D6B0,$F1F7,$C277,$C278,$C279,$C27A,$F1F8,$C27B,$C1AA,$C27C,$C27D,$C27E,$C6B8,
$C280,$BEDB,$C281,$C282,$C283,$C284,$C285,$C286,$C287,$C288,$C289,$C28A,$C28B,
$C28C,$C28D,$C28E,$F1F9,$B4CF,$C28F,$C290,$C291,$C292,$C293,$C294,$F1FA,$C295,
$C296,$C297,$C298,$C299,$C29A,$C29B,$C29C,$C29D,$C29E,$C29F,$C2A0,$C340,$EDB2,
$EDB1,$C341,$C342,$CBE0,$D2DE,$C343,$CBC1,$D5D8,$C344,$C8E2,$C345,$C0DF,$BCA1,
$C346,$C347,$C348,$C349,$C34A,$C34B,$EBC1,$C34C,$C34D,$D0A4,$C34E,$D6E2,$C34F,
$B6C7,$B8D8,$EBC0,$B8CE,$C350,$EBBF,$B3A6,$B9C9,$D6AB,$C351,$B7F4,$B7CA,$C352,
$C353,$C354,$BCE7,$B7BE,$EBC6,$C355,$EBC7,$B0B9,$BFCF,$C356,$EBC5,$D3FD,$C357,
$EBC8,$C358,$C359,$EBC9,$C35A,$C35B,$B7CE,$C35C,$EBC2,$EBC4,$C9F6,$D6D7,$D5CD,
$D0B2,$EBCF,$CEB8,$EBD0,$C35D,$B5A8,$C35E,$C35F,$C360,$C361,$C362,$B1B3,$EBD2,
$CCA5,$C363,$C364,$C365,$C366,$C367,$C368,$C369,$C5D6,$EBD3,$C36A,$EBD1,$C5DF,
$EBCE,$CAA4,$EBD5,$B0FB,$C36B,$C36C,$BAFA,$C36D,$C36E,$D8B7,$F1E3,$C36F,$EBCA,
$EBCB,$EBCC,$EBCD,$EBD6,$E6C0,$EBD9,$C370,$BFE8,$D2C8,$EBD7,$EBDC,$B8EC,$EBD8,
$C371,$BDBA,$C372,$D0D8,$C373,$B0B7,$C374,$EBDD,$C4DC,$C375,$C376,$C377,$C378,
$D6AC,$C379,$C37A,$C37B,$B4E0,$C37C,$C37D,$C2F6,$BCB9,$C37E,$C380,$EBDA,$EBDB,
$D4E0,$C6EA,$C4D4,$EBDF,$C5A7,$D9F5,$C381,$B2B1,$C382,$EBE4,$C383,$BDC5,$C384,
$C385,$C386,$EBE2,$C387,$C388,$C389,$C38A,$C38B,$C38C,$C38D,$C38E,$C38F,$C390,
$C391,$C392,$C393,$EBE3,$C394,$C395,$B8AC,$C396,$CDD1,$EBE5,$C397,$C398,$C399,
$EBE1,$C39A,$C1B3,$C39B,$C39C,$C39D,$C39E,$C39F,$C6A2,$C3A0,$C440,$C441,$C442,
$C443,$C444,$C445,$CCF3,$C446,$EBE6,$C447,$C0B0,$D2B8,$EBE7,$C448,$C449,$C44A,
$B8AF,$B8AD,$C44B,$EBE8,$C7BB,$CDF3,$C44C,$C44D,$C44E,$EBEA,$EBEB,$C44F,$C450,
$C451,$C452,$C453,$EBED,$C454,$C455,$C456,$C457,$D0C8,$C458,$EBF2,$C459,$EBEE,
$C45A,$C45B,$C45C,$EBF1,$C8F9,$C45D,$D1FC,$EBEC,$C45E,$C45F,$EBE9,$C460,$C461,
$C462,$C463,$B8B9,$CFD9,$C4E5,$EBEF,$EBF0,$CCDA,$CDC8,$B0F2,$C464,$EBF6,$C465,
$C466,$C467,$C468,$C469,$EBF5,$C46A,$B2B2,$C46B,$C46C,$C46D,$C46E,$B8E0,$C46F,
$EBF7,$C470,$C471,$C472,$C473,$C474,$C475,$B1EC,$C476,$C477,$CCC5,$C4A4,$CFA5,
$C478,$C479,$C47A,$C47B,$C47C,$EBF9,$C47D,$C47E,$ECA2,$C480,$C5F2,$C481,$EBFA,
$C482,$C483,$C484,$C485,$C486,$C487,$C488,$C489,$C9C5,$C48A,$C48B,$C48C,$C48D,
$C48E,$C48F,$E2DF,$EBFE,$C490,$C491,$C492,$C493,$CDCE,$ECA1,$B1DB,$D3B7,$C494,
$C495,$D2DC,$C496,$C497,$C498,$EBFD,$C499,$EBFB,$C49A,$C49B,$C49C,$C49D,$C49E,
$C49F,$C4A0,$C540,$C541,$C542,$C543,$C544,$C545,$C546,$C547,$C548,$C549,$C54A,
$C54B,$C54C,$C54D,$C54E,$B3BC,$C54F,$C550,$C551,$EAB0,$C552,$C553,$D7D4,$C554,
$F4AB,$B3F4,$C555,$C556,$C557,$C558,$C559,$D6C1,$D6C2,$C55A,$C55B,$C55C,$C55D,
$C55E,$C55F,$D5E9,$BECA,$C560,$F4A7,$C561,$D2A8,$F4A8,$F4A9,$C562,$F4AA,$BECB,
$D3DF,$C563,$C564,$C565,$C566,$C567,$C9E0,$C9E1,$C568,$C569,$F3C2,$C56A,$CAE6,
$C56B,$CCF2,$C56C,$C56D,$C56E,$C56F,$C570,$C571,$E2B6,$CBB4,$C572,$CEE8,$D6DB,
$C573,$F4AD,$F4AE,$F4AF,$C574,$C575,$C576,$C577,$F4B2,$C578,$BABD,$F4B3,$B0E3,
$F4B0,$C579,$F4B1,$BDA2,$B2D5,$C57A,$F4B6,$F4B7,$B6E6,$B2B0,$CFCF,$F4B4,$B4AC,
$C57B,$F4B5,$C57C,$C57D,$F4B8,$C57E,$C580,$C581,$C582,$C583,$F4B9,$C584,$C585,
$CDA7,$C586,$F4BA,$C587,$F4BB,$C588,$C589,$C58A,$F4BC,$C58B,$C58C,$C58D,$C58E,
$C58F,$C590,$C591,$C592,$CBD2,$C593,$F4BD,$C594,$C595,$C596,$C597,$F4BE,$C598,
$C599,$C59A,$C59B,$C59C,$C59D,$C59E,$C59F,$F4BF,$C5A0,$C640,$C641,$C642,$C643,
$F4DE,$C1BC,$BCE8,$C644,$C9AB,$D1DE,$E5F5,$C645,$C646,$C647,$C648,$DCB3,$D2D5,
$C649,$C64A,$DCB4,$B0AC,$DCB5,$C64B,$C64C,$BDDA,$C64D,$DCB9,$C64E,$C64F,$C650,
$D8C2,$C651,$DCB7,$D3F3,$C652,$C9D6,$DCBA,$DCB6,$C653,$DCBB,$C3A2,$C654,$C655,
$C656,$C657,$DCBC,$DCC5,$DCBD,$C658,$C659,$CEDF,$D6A5,$C65A,$DCCF,$C65B,$DCCD,
$C65C,$C65D,$DCD2,$BDE6,$C2AB,$C65E,$DCB8,$DCCB,$DCCE,$DCBE,$B7D2,$B0C5,$DCC7,
$D0BE,$DCC1,$BBA8,$C65F,$B7BC,$DCCC,$C660,$C661,$DCC6,$DCBF,$C7DB,$C662,$C663,
$C664,$D1BF,$DCC0,$C665,$C666,$DCCA,$C667,$C668,$DCD0,$C669,$C66A,$CEAD,$DCC2,
$C66B,$DCC3,$DCC8,$DCC9,$B2D4,$DCD1,$CBD5,$C66C,$D4B7,$DCDB,$DCDF,$CCA6,$DCE6,
$C66D,$C3E7,$DCDC,$C66E,$C66F,$BFC1,$DCD9,$C670,$B0FA,$B9B6,$DCE5,$DCD3,$C671,
$DCC4,$DCD6,$C8F4,$BFE0,$C672,$C673,$C674,$C675,$C9BB,$C676,$C677,$C678,$B1BD,
$C679,$D3A2,$C67A,$C67B,$DCDA,$C67C,$C67D,$DCD5,$C67E,$C6BB,$C680,$DCDE,$C681,
$C682,$C683,$C684,$C685,$D7C2,$C3AF,$B7B6,$C7D1,$C3A9,$DCE2,$DCD8,$DCEB,$DCD4,
$C686,$C687,$DCDD,$C688,$BEA5,$DCD7,$C689,$DCE0,$C68A,$C68B,$DCE3,$DCE4,$C68C,
$DCF8,$C68D,$C68E,$DCE1,$DDA2,$DCE7,$C68F,$C690,$C691,$C692,$C693,$C694,$C695,
$C696,$C697,$C698,$BCEB,$B4C4,$C699,$C69A,$C3A3,$B2E7,$DCFA,$C69B,$DCF2,$C69C,
$DCEF,$C69D,$DCFC,$DCEE,$D2F0,$B2E8,$C69E,$C8D7,$C8E3,$DCFB,$C69F,$DCED,$C6A0,
$C740,$C741,$DCF7,$C742,$C743,$DCF5,$C744,$C745,$BEA3,$DCF4,$C746,$B2DD,$C747,
$C748,$C749,$C74A,$C74B,$DCF3,$BCF6,$DCE8,$BBC4,$C74C,$C0F3,$C74D,$C74E,$C74F,
$C750,$C751,$BCD4,$DCE9,$DCEA,$C752,$DCF1,$DCF6,$DCF9,$B5B4,$C753,$C8D9,$BBE7,
$DCFE,$DCFD,$D3AB,$DDA1,$DDA3,$DDA5,$D2F1,$DDA4,$DDA6,$DDA7,$D2A9,$C754,$C755,
$C756,$C757,$C758,$C759,$C75A,$BAC9,$DDA9,$C75B,$C75C,$DDB6,$DDB1,$DDB4,$C75D,
$C75E,$C75F,$C760,$C761,$C762,$C763,$DDB0,$C6CE,$C764,$C765,$C0F2,$C766,$C767,
$C768,$C769,$C9AF,$C76A,$C76B,$C76C,$DCEC,$DDAE,$C76D,$C76E,$C76F,$C770,$DDB7,
$C771,$C772,$DCF0,$DDAF,$C773,$DDB8,$C774,$DDAC,$C775,$C776,$C777,$C778,$C779,
$C77A,$C77B,$DDB9,$DDB3,$DDAD,$C4AA,$C77C,$C77D,$C77E,$C780,$DDA8,$C0B3,$C1AB,
$DDAA,$DDAB,$C781,$DDB2,$BBF1,$DDB5,$D3A8,$DDBA,$C782,$DDBB,$C3A7,$C783,$C784,
$DDD2,$DDBC,$C785,$C786,$C787,$DDD1,$C788,$B9BD,$C789,$C78A,$BED5,$C78B,$BEFA,
$C78C,$C78D,$BACA,$C78E,$C78F,$C790,$C791,$DDCA,$C792,$DDC5,$C793,$DDBF,$C794,
$C795,$C796,$B2CB,$DDC3,$C797,$DDCB,$B2A4,$DDD5,$C798,$C799,$C79A,$DDBE,$C79B,
$C79C,$C79D,$C6D0,$DDD0,$C79E,$C79F,$C7A0,$C840,$C841,$DDD4,$C1E2,$B7C6,$C842,
$C843,$C844,$C845,$C846,$DDCE,$DDCF,$C847,$C848,$C849,$DDC4,$C84A,$C84B,$C84C,
$DDBD,$C84D,$DDCD,$CCD1,$C84E,$DDC9,$C84F,$C850,$C851,$C852,$DDC2,$C3C8,$C6BC,
$CEAE,$DDCC,$C853,$DDC8,$C854,$C855,$C856,$C857,$C858,$C859,$DDC1,$C85A,$C85B,
$C85C,$DDC6,$C2DC,$C85D,$C85E,$C85F,$C860,$C861,$C862,$D3A9,$D3AA,$DDD3,$CFF4,
$C8F8,$C863,$C864,$C865,$C866,$C867,$C868,$C869,$C86A,$DDE6,$C86B,$C86C,$C86D,
$C86E,$C86F,$C870,$DDC7,$C871,$C872,$C873,$DDE0,$C2E4,$C874,$C875,$C876,$C877,
$C878,$C879,$C87A,$C87B,$DDE1,$C87C,$C87D,$C87E,$C880,$C881,$C882,$C883,$C884,
$C885,$C886,$DDD7,$C887,$C888,$C889,$C88A,$C88B,$D6F8,$C88C,$DDD9,$DDD8,$B8F0,
$DDD6,$C88D,$C88E,$C88F,$C890,$C6CF,$C891,$B6AD,$C892,$C893,$C894,$C895,$C896,
$DDE2,$C897,$BAF9,$D4E1,$DDE7,$C898,$C899,$C89A,$B4D0,$C89B,$DDDA,$C89C,$BFFB,
$DDE3,$C89D,$DDDF,$C89E,$DDDD,$C89F,$C8A0,$C940,$C941,$C942,$C943,$C944,$B5D9,
$C945,$C946,$C947,$C948,$DDDB,$DDDC,$DDDE,$C949,$BDAF,$DDE4,$C94A,$DDE5,$C94B,
$C94C,$C94D,$C94E,$C94F,$C950,$C951,$C952,$DDF5,$C953,$C3C9,$C954,$C955,$CBE2,
$C956,$C957,$C958,$C959,$DDF2,$C95A,$C95B,$C95C,$C95D,$C95E,$C95F,$C960,$C961,
$C962,$C963,$C964,$C965,$C966,$D8E1,$C967,$C968,$C6D1,$C969,$DDF4,$C96A,$C96B,
$C96C,$D5F4,$DDF3,$DDF0,$C96D,$C96E,$DDEC,$C96F,$DDEF,$C970,$DDE8,$C971,$C972,
$D0EE,$C973,$C974,$C975,$C976,$C8D8,$DDEE,$C977,$C978,$DDE9,$C979,$C97A,$DDEA,
$CBF2,$C97B,$DDED,$C97C,$C97D,$B1CD,$C97E,$C980,$C981,$C982,$C983,$C984,$C0B6,
$C985,$BCBB,$DDF1,$C986,$C987,$DDF7,$C988,$DDF6,$DDEB,$C989,$C98A,$C98B,$C98C,
$C98D,$C5EE,$C98E,$C98F,$C990,$DDFB,$C991,$C992,$C993,$C994,$C995,$C996,$C997,
$C998,$C999,$C99A,$C99B,$DEA4,$C99C,$C99D,$DEA3,$C99E,$C99F,$C9A0,$CA40,$CA41,
$CA42,$CA43,$CA44,$CA45,$CA46,$CA47,$CA48,$DDF8,$CA49,$CA4A,$CA4B,$CA4C,$C3EF,
$CA4D,$C2FB,$CA4E,$CA4F,$CA50,$D5E1,$CA51,$CA52,$CEB5,$CA53,$CA54,$CA55,$CA56,
$DDFD,$CA57,$B2CC,$CA58,$CA59,$CA5A,$CA5B,$CA5C,$CA5D,$CA5E,$CA5F,$CA60,$C4E8,
$CADF,$CA61,$CA62,$CA63,$CA64,$CA65,$CA66,$CA67,$CA68,$CA69,$CA6A,$C7BE,$DDFA,
$DDFC,$DDFE,$DEA2,$B0AA,$B1CE,$CA6B,$CA6C,$CA6D,$CA6E,$CA6F,$DEAC,$CA70,$CA71,
$CA72,$CA73,$DEA6,$BDB6,$C8EF,$CA74,$CA75,$CA76,$CA77,$CA78,$CA79,$CA7A,$CA7B,
$CA7C,$CA7D,$CA7E,$DEA1,$CA80,$CA81,$DEA5,$CA82,$CA83,$CA84,$CA85,$DEA9,$CA86,
$CA87,$CA88,$CA89,$CA8A,$DEA8,$CA8B,$CA8C,$CA8D,$DEA7,$CA8E,$CA8F,$CA90,$CA91,
$CA92,$CA93,$CA94,$CA95,$CA96,$DEAD,$CA97,$D4CC,$CA98,$CA99,$CA9A,$CA9B,$DEB3,
$DEAA,$DEAE,$CA9C,$CA9D,$C0D9,$CA9E,$CA9F,$CAA0,$CB40,$CB41,$B1A1,$DEB6,$CB42,
$DEB1,$CB43,$CB44,$CB45,$CB46,$CB47,$CB48,$CB49,$DEB2,$CB4A,$CB4B,$CB4C,$CB4D,
$CB4E,$CB4F,$CB50,$CB51,$CB52,$CB53,$CB54,$D1A6,$DEB5,$CB55,$CB56,$CB57,$CB58,
$CB59,$CB5A,$CB5B,$DEAF,$CB5C,$CB5D,$CB5E,$DEB0,$CB5F,$D0BD,$CB60,$CB61,$CB62,
$DEB4,$CAED,$DEB9,$CB63,$CB64,$CB65,$CB66,$CB67,$CB68,$DEB8,$CB69,$DEB7,$CB6A,
$CB6B,$CB6C,$CB6D,$CB6E,$CB6F,$CB70,$DEBB,$CB71,$CB72,$CB73,$CB74,$CB75,$CB76,
$CB77,$BDE5,$CB78,$CB79,$CB7A,$CB7B,$CB7C,$B2D8,$C3EA,$CB7D,$CB7E,$DEBA,$CB80,
$C5BA,$CB81,$CB82,$CB83,$CB84,$CB85,$CB86,$DEBC,$CB87,$CB88,$CB89,$CB8A,$CB8B,
$CB8C,$CB8D,$CCD9,$CB8E,$CB8F,$CB90,$CB91,$B7AA,$CB92,$CB93,$CB94,$CB95,$CB96,
$CB97,$CB98,$CB99,$CB9A,$CB9B,$CB9C,$CB9D,$CB9E,$CB9F,$CBA0,$CC40,$CC41,$D4E5,
$CC42,$CC43,$CC44,$DEBD,$CC45,$CC46,$CC47,$CC48,$CC49,$DEBF,$CC4A,$CC4B,$CC4C,
$CC4D,$CC4E,$CC4F,$CC50,$CC51,$CC52,$CC53,$CC54,$C4A2,$CC55,$CC56,$CC57,$CC58,
$DEC1,$CC59,$CC5A,$CC5B,$CC5C,$CC5D,$CC5E,$CC5F,$CC60,$CC61,$CC62,$CC63,$CC64,
$CC65,$CC66,$CC67,$CC68,$DEBE,$CC69,$DEC0,$CC6A,$CC6B,$CC6C,$CC6D,$CC6E,$CC6F,
$CC70,$CC71,$CC72,$CC73,$CC74,$CC75,$CC76,$CC77,$D5BA,$CC78,$CC79,$CC7A,$DEC2,
$CC7B,$CC7C,$CC7D,$CC7E,$CC80,$CC81,$CC82,$CC83,$CC84,$CC85,$CC86,$CC87,$CC88,
$CC89,$CC8A,$CC8B,$F2AE,$BBA2,$C2B2,$C5B0,$C2C7,$CC8C,$CC8D,$F2AF,$CC8E,$CC8F,
$CC90,$CC91,$CC92,$D0E9,$CC93,$CC94,$CC95,$D3DD,$CC96,$CC97,$CC98,$EBBD,$CC99,
$CC9A,$CC9B,$CC9C,$CC9D,$CC9E,$CC9F,$CCA0,$B3E6,$F2B0,$CD40,$F2B1,$CD41,$CD42,
$CAAD,$CD43,$CD44,$CD45,$CD46,$CD47,$CD48,$CD49,$BAE7,$F2B3,$F2B5,$F2B4,$CBE4,
$CFBA,$F2B2,$CAB4,$D2CF,$C2EC,$CD4A,$CD4B,$CD4C,$CD4D,$CD4E,$CD4F,$CD50,$CEC3,
$F2B8,$B0F6,$F2B7,$CD51,$CD52,$CD53,$CD54,$CD55,$F2BE,$CD56,$B2CF,$CD57,$CD58,
$CD59,$CD5A,$CD5B,$CD5C,$D1C1,$F2BA,$CD5D,$CD5E,$CD5F,$CD60,$CD61,$F2BC,$D4E9,
$CD62,$CD63,$F2BB,$F2B6,$F2BF,$F2BD,$CD64,$F2B9,$CD65,$CD66,$F2C7,$F2C4,$F2C6,
$CD67,$CD68,$F2CA,$F2C2,$F2C0,$CD69,$CD6A,$CD6B,$F2C5,$CD6C,$CD6D,$CD6E,$CD6F,
$CD70,$D6FB,$CD71,$CD72,$CD73,$F2C1,$CD74,$C7F9,$C9DF,$CD75,$F2C8,$B9C6,$B5B0,
$CD76,$CD77,$F2C3,$F2C9,$F2D0,$F2D6,$CD78,$CD79,$BBD7,$CD7A,$CD7B,$CD7C,$F2D5,
$CDDC,$CD7D,$D6EB,$CD7E,$CD80,$F2D2,$F2D4,$CD81,$CD82,$CD83,$CD84,$B8F2,$CD85,
$CD86,$CD87,$CD88,$F2CB,$CD89,$CD8A,$CD8B,$F2CE,$C2F9,$CD8C,$D5DD,$F2CC,$F2CD,
$F2CF,$F2D3,$CD8D,$CD8E,$CD8F,$F2D9,$D3BC,$CD90,$CD91,$CD92,$CD93,$B6EA,$CD94,
$CAF1,$CD95,$B7E4,$F2D7,$CD96,$CD97,$CD98,$F2D8,$F2DA,$F2DD,$F2DB,$CD99,$CD9A,
$F2DC,$CD9B,$CD9C,$CD9D,$CD9E,$D1D1,$F2D1,$CD9F,$CDC9,$CDA0,$CECF,$D6A9,$CE40,
$F2E3,$CE41,$C3DB,$CE42,$F2E0,$CE43,$CE44,$C0AF,$F2EC,$F2DE,$CE45,$F2E1,$CE46,
$CE47,$CE48,$F2E8,$CE49,$CE4A,$CE4B,$CE4C,$F2E2,$CE4D,$CE4E,$F2E7,$CE4F,$CE50,
$F2E6,$CE51,$CE52,$F2E9,$CE53,$CE54,$CE55,$F2DF,$CE56,$CE57,$F2E4,$F2EA,$CE58,
$CE59,$CE5A,$CE5B,$CE5C,$CE5D,$CE5E,$D3AC,$F2E5,$B2F5,$CE5F,$CE60,$F2F2,$CE61,
$D0AB,$CE62,$CE63,$CE64,$CE65,$F2F5,$CE66,$CE67,$CE68,$BBC8,$CE69,$F2F9,$CE6A,
$CE6B,$CE6C,$CE6D,$CE6E,$CE6F,$F2F0,$CE70,$CE71,$F2F6,$F2F8,$F2FA,$CE72,$CE73,
$CE74,$CE75,$CE76,$CE77,$CE78,$CE79,$F2F3,$CE7A,$F2F1,$CE7B,$CE7C,$CE7D,$BAFB,
$CE7E,$B5FB,$CE80,$CE81,$CE82,$CE83,$F2EF,$F2F7,$F2ED,$F2EE,$CE84,$CE85,$CE86,
$F2EB,$F3A6,$CE87,$F3A3,$CE88,$CE89,$F3A2,$CE8A,$CE8B,$F2F4,$CE8C,$C8DA,$CE8D,
$CE8E,$CE8F,$CE90,$CE91,$F2FB,$CE92,$CE93,$CE94,$F3A5,$CE95,$CE96,$CE97,$CE98,
$CE99,$CE9A,$CE9B,$C3F8,$CE9C,$CE9D,$CE9E,$CE9F,$CEA0,$CF40,$CF41,$CF42,$F2FD,
$CF43,$CF44,$F3A7,$F3A9,$F3A4,$CF45,$F2FC,$CF46,$CF47,$CF48,$F3AB,$CF49,$F3AA,
$CF4A,$CF4B,$CF4C,$CF4D,$C2DD,$CF4E,$CF4F,$F3AE,$CF50,$CF51,$F3B0,$CF52,$CF53,
$CF54,$CF55,$CF56,$F3A1,$CF57,$CF58,$CF59,$F3B1,$F3AC,$CF5A,$CF5B,$CF5C,$CF5D,
$CF5E,$F3AF,$F2FE,$F3AD,$CF5F,$CF60,$CF61,$CF62,$CF63,$CF64,$CF65,$F3B2,$CF66,
$CF67,$CF68,$CF69,$F3B4,$CF6A,$CF6B,$CF6C,$CF6D,$F3A8,$CF6E,$CF6F,$CF70,$CF71,
$F3B3,$CF72,$CF73,$CF74,$F3B5,$CF75,$CF76,$CF77,$CF78,$CF79,$CF7A,$CF7B,$CF7C,
$CF7D,$CF7E,$D0B7,$CF80,$CF81,$CF82,$CF83,$F3B8,$CF84,$CF85,$CF86,$CF87,$D9F9,
$CF88,$CF89,$CF8A,$CF8B,$CF8C,$CF8D,$F3B9,$CF8E,$CF8F,$CF90,$CF91,$CF92,$CF93,
$CF94,$CF95,$F3B7,$CF96,$C8E4,$F3B6,$CF97,$CF98,$CF99,$CF9A,$F3BA,$CF9B,$CF9C,
$CF9D,$CF9E,$CF9F,$F3BB,$B4C0,$CFA0,$D040,$D041,$D042,$D043,$D044,$D045,$D046,
$D047,$D048,$D049,$D04A,$D04B,$D04C,$D04D,$EEC3,$D04E,$D04F,$D050,$D051,$D052,
$D053,$F3BC,$D054,$D055,$F3BD,$D056,$D057,$D058,$D1AA,$D059,$D05A,$D05B,$F4AC,
$D0C6,$D05C,$D05D,$D05E,$D05F,$D060,$D061,$D0D0,$D1DC,$D062,$D063,$D064,$D065,
$D066,$D067,$CFCE,$D068,$D069,$BDD6,$D06A,$D1C3,$D06B,$D06C,$D06D,$D06E,$D06F,
$D070,$D071,$BAE2,$E1E9,$D2C2,$F1C2,$B2B9,$D072,$D073,$B1ED,$F1C3,$D074,$C9C0,
$B3C4,$D075,$D9F2,$D076,$CBA5,$D077,$F1C4,$D078,$D079,$D07A,$D07B,$D6D4,$D07C,
$D07D,$D07E,$D080,$D081,$F1C5,$F4C0,$F1C6,$D082,$D4AC,$F1C7,$D083,$B0C0,$F4C1,
$D084,$D085,$F4C2,$D086,$D087,$B4FC,$D088,$C5DB,$D089,$D08A,$D08B,$D08C,$CCBB,
$D08D,$D08E,$D08F,$D0E4,$D090,$D091,$D092,$D093,$D094,$CDE0,$D095,$D096,$D097,
$D098,$D099,$F1C8,$D09A,$D9F3,$D09B,$D09C,$D09D,$D09E,$D09F,$D0A0,$B1BB,$D140,
$CFAE,$D141,$D142,$D143,$B8A4,$D144,$D145,$D146,$D147,$D148,$F1CA,$D149,$D14A,
$D14B,$D14C,$F1CB,$D14D,$D14E,$D14F,$D150,$B2C3,$C1D1,$D151,$D152,$D7B0,$F1C9,
$D153,$D154,$F1CC,$D155,$D156,$D157,$D158,$F1CE,$D159,$D15A,$D15B,$D9F6,$D15C,
$D2E1,$D4A3,$D15D,$D15E,$F4C3,$C8B9,$D15F,$D160,$D161,$D162,$D163,$F4C4,$D164,
$D165,$F1CD,$F1CF,$BFE3,$F1D0,$D166,$D167,$F1D4,$D168,$D169,$D16A,$D16B,$D16C,
$D16D,$D16E,$F1D6,$F1D1,$D16F,$C9D1,$C5E1,$D170,$D171,$D172,$C2E3,$B9FC,$D173,
$D174,$F1D3,$D175,$F1D5,$D176,$D177,$D178,$B9D3,$D179,$D17A,$D17B,$D17C,$D17D,
$D17E,$D180,$F1DB,$D181,$D182,$D183,$D184,$D185,$BAD6,$D186,$B0FD,$F1D9,$D187,
$D188,$D189,$D18A,$D18B,$F1D8,$F1D2,$F1DA,$D18C,$D18D,$D18E,$D18F,$D190,$F1D7,
$D191,$D192,$D193,$C8EC,$D194,$D195,$D196,$D197,$CDCA,$F1DD,$D198,$D199,$D19A,
$D19B,$E5BD,$D19C,$D19D,$D19E,$F1DC,$D19F,$F1DE,$D1A0,$D240,$D241,$D242,$D243,
$D244,$D245,$D246,$D247,$D248,$F1DF,$D249,$D24A,$CFE5,$D24B,$D24C,$D24D,$D24E,
$D24F,$D250,$D251,$D252,$D253,$D254,$D255,$D256,$D257,$D258,$D259,$D25A,$D25B,
$D25C,$D25D,$D25E,$D25F,$D260,$D261,$D262,$D263,$F4C5,$BDF3,$D264,$D265,$D266,
$D267,$D268,$D269,$F1E0,$D26A,$D26B,$D26C,$D26D,$D26E,$D26F,$D270,$D271,$D272,
$D273,$D274,$D275,$D276,$D277,$D278,$D279,$D27A,$D27B,$D27C,$D27D,$F1E1,$D27E,
$D280,$D281,$CEF7,$D282,$D2AA,$D283,$F1FB,$D284,$D285,$B8B2,$D286,$D287,$D288,
$D289,$D28A,$D28B,$D28C,$D28D,$D28E,$D28F,$D290,$D291,$D292,$D293,$D294,$D295,
$D296,$D297,$D298,$D299,$D29A,$D29B,$D29C,$D29D,$D29E,$D29F,$D2A0,$D340,$D341,
$D342,$D343,$D344,$D345,$D346,$D347,$D348,$D349,$D34A,$D34B,$D34C,$D34D,$D34E,
$D34F,$D350,$D351,$D352,$D353,$D354,$D355,$D356,$D357,$D358,$D359,$D35A,$D35B,
$D35C,$D35D,$D35E,$BCFB,$B9DB,$D35F,$B9E6,$C3D9,$CAD3,$EAE8,$C0C0,$BEF5,$EAE9,
$EAEA,$EAEB,$D360,$EAEC,$EAED,$EAEE,$EAEF,$BDC7,$D361,$D362,$D363,$F5FB,$D364,
$D365,$D366,$F5FD,$D367,$F5FE,$D368,$F5FC,$D369,$D36A,$D36B,$D36C,$BDE2,$D36D,
$F6A1,$B4A5,$D36E,$D36F,$D370,$D371,$F6A2,$D372,$D373,$D374,$F6A3,$D375,$D376,
$D377,$ECB2,$D378,$D379,$D37A,$D37B,$D37C,$D37D,$D37E,$D380,$D381,$D382,$D383,
$D384,$D1D4,$D385,$D386,$D387,$D388,$D389,$D38A,$D9EA,$D38B,$D38C,$D38D,$D38E,
$D38F,$D390,$D391,$D392,$D393,$D394,$D395,$D396,$D397,$D398,$D399,$D39A,$D39B,
$D39C,$D39D,$D39E,$D39F,$D3A0,$D440,$D441,$D442,$D443,$D444,$D445,$D446,$D447,
$D448,$D449,$D44A,$D44B,$D44C,$D44D,$D44E,$D44F,$D450,$D451,$D452,$D453,$D454,
$D455,$D456,$D457,$D458,$D459,$D45A,$D45B,$D45C,$D45D,$D45E,$D45F,$F6A4,$D460,
$D461,$D462,$D463,$D464,$D465,$D466,$D467,$D468,$EEBA,$D469,$D46A,$D46B,$D46C,
$D46D,$D46E,$D46F,$D470,$D471,$D472,$D473,$D474,$D475,$D476,$D477,$D478,$D479,
$D47A,$D47B,$D47C,$D47D,$D47E,$D480,$D481,$D482,$D483,$D484,$D485,$D486,$D487,
$D488,$D489,$D48A,$D48B,$D48C,$D48D,$D48E,$D48F,$D490,$D491,$D492,$D493,$D494,
$D495,$D496,$D497,$D498,$D499,$D5B2,$D49A,$D49B,$D49C,$D49D,$D49E,$D49F,$D4A0,
$D540,$D541,$D542,$D543,$D544,$D545,$D546,$D547,$D3FE,$CCDC,$D548,$D549,$D54A,
$D54B,$D54C,$D54D,$D54E,$D54F,$CAC4,$D550,$D551,$D552,$D553,$D554,$D555,$D556,
$D557,$D558,$D559,$D55A,$D55B,$D55C,$D55D,$D55E,$D55F,$D560,$D561,$D562,$D563,
$D564,$D565,$D566,$D567,$D568,$D569,$D56A,$D56B,$D56C,$D56D,$D56E,$D56F,$D570,
$D571,$D572,$D573,$D574,$D575,$D576,$D577,$D578,$D579,$D57A,$D57B,$D57C,$D57D,
$D57E,$D580,$D581,$D582,$D583,$D584,$D585,$D586,$D587,$D588,$D589,$D58A,$D58B,
$D58C,$D58D,$D58E,$D58F,$D590,$D591,$D592,$D593,$D594,$D595,$D596,$D597,$D598,
$D599,$D59A,$D59B,$D59C,$D59D,$D59E,$D59F,$D5A0,$D640,$D641,$D642,$D643,$D644,
$D645,$D646,$D647,$D648,$D649,$D64A,$D64B,$D64C,$D64D,$D64E,$D64F,$D650,$D651,
$D652,$D653,$D654,$D655,$D656,$D657,$D658,$D659,$D65A,$D65B,$D65C,$D65D,$D65E,
$D65F,$D660,$D661,$D662,$E5C0,$D663,$D664,$D665,$D666,$D667,$D668,$D669,$D66A,
$D66B,$D66C,$D66D,$D66E,$D66F,$D670,$D671,$D672,$D673,$D674,$D675,$D676,$D677,
$D678,$D679,$D67A,$D67B,$D67C,$D67D,$D67E,$D680,$D681,$F6A5,$D682,$D683,$D684,
$D685,$D686,$D687,$D688,$D689,$D68A,$D68B,$D68C,$D68D,$D68E,$D68F,$D690,$D691,
$D692,$D693,$D694,$D695,$D696,$D697,$D698,$D699,$D69A,$D69B,$D69C,$D69D,$D69E,
$D69F,$D6A0,$D740,$D741,$D742,$D743,$D744,$D745,$D746,$D747,$D748,$D749,$D74A,
$D74B,$D74C,$D74D,$D74E,$D74F,$D750,$D751,$D752,$D753,$D754,$D755,$D756,$D757,
$D758,$D759,$D75A,$D75B,$D75C,$D75D,$D75E,$D75F,$BEAF,$D760,$D761,$D762,$D763,
$D764,$C6A9,$D765,$D766,$D767,$D768,$D769,$D76A,$D76B,$D76C,$D76D,$D76E,$D76F,
$D770,$D771,$D772,$D773,$D774,$D775,$D776,$D777,$D778,$D779,$D77A,$D77B,$D77C,
$D77D,$D77E,$D780,$D781,$D782,$D783,$D784,$D785,$D786,$D787,$D788,$D789,$D78A,
$D78B,$D78C,$D78D,$D78E,$D78F,$D790,$D791,$D792,$D793,$D794,$D795,$D796,$D797,
$D798,$DAA5,$BCC6,$B6A9,$B8BC,$C8CF,$BCA5,$DAA6,$DAA7,$CCD6,$C8C3,$DAA8,$C6FD,
$D799,$D1B5,$D2E9,$D1B6,$BCC7,$D79A,$BDB2,$BBE4,$DAA9,$DAAA,$D1C8,$DAAB,$D0ED,
$B6EF,$C2DB,$D79B,$CBCF,$B7ED,$C9E8,$B7C3,$BEF7,$D6A4,$DAAC,$DAAD,$C6C0,$D7E7,
$CAB6,$D79C,$D5A9,$CBDF,$D5EF,$DAAE,$D6DF,$B4CA,$DAB0,$DAAF,$D79D,$D2EB,$DAB1,
$DAB2,$DAB3,$CAD4,$DAB4,$CAAB,$DAB5,$DAB6,$B3CF,$D6EF,$DAB7,$BBB0,$B5AE,$DAB8,
$DAB9,$B9EE,$D1AF,$D2E8,$DABA,$B8C3,$CFEA,$B2EF,$DABB,$DABC,$D79E,$BDEB,$CEDC,
$D3EF,$DABD,$CEF3,$DABE,$D3D5,$BBE5,$DABF,$CBB5,$CBD0,$DAC0,$C7EB,$D6EE,$DAC1,
$C5B5,$B6C1,$DAC2,$B7CC,$BFCE,$DAC3,$DAC4,$CBAD,$DAC5,$B5F7,$DAC6,$C1C2,$D7BB,
$DAC7,$CCB8,$D79F,$D2EA,$C4B1,$DAC8,$B5FD,$BBD1,$DAC9,$D0B3,$DACA,$DACB,$CEBD,
$DACC,$DACD,$DACE,$B2F7,$DAD1,$DACF,$D1E8,$DAD0,$C3D5,$DAD2,$D7A0,$DAD3,$DAD4,
$DAD5,$D0BB,$D2A5,$B0F9,$DAD6,$C7AB,$DAD7,$BDF7,$C3A1,$DAD8,$DAD9,$C3FD,$CCB7,
$DADA,$DADB,$C0BE,$C6D7,$DADC,$DADD,$C7B4,$DADE,$DADF,$B9C8,$D840,$D841,$D842,
$D843,$D844,$D845,$D846,$D847,$D848,$BBED,$D849,$D84A,$D84B,$D84C,$B6B9,$F4F8,
$D84D,$F4F9,$D84E,$D84F,$CDE3,$D850,$D851,$D852,$D853,$D854,$D855,$D856,$D857,
$F5B9,$D858,$D859,$D85A,$D85B,$EBE0,$D85C,$D85D,$D85E,$D85F,$D860,$D861,$CFF3,
$BBBF,$D862,$D863,$D864,$D865,$D866,$D867,$D868,$BAC0,$D4A5,$D869,$D86A,$D86B,
$D86C,$D86D,$D86E,$D86F,$E1D9,$D870,$D871,$D872,$D873,$F5F4,$B1AA,$B2F2,$D874,
$D875,$D876,$D877,$D878,$D879,$D87A,$F5F5,$D87B,$D87C,$F5F7,$D87D,$D87E,$D880,
$BAD1,$F5F6,$D881,$C3B2,$D882,$D883,$D884,$D885,$D886,$D887,$D888,$F5F9,$D889,
$D88A,$D88B,$F5F8,$D88C,$D88D,$D88E,$D88F,$D890,$D891,$D892,$D893,$D894,$D895,
$D896,$D897,$D898,$D899,$D89A,$D89B,$D89C,$D89D,$D89E,$D89F,$D8A0,$D940,$D941,
$D942,$D943,$D944,$D945,$D946,$D947,$D948,$D949,$D94A,$D94B,$D94C,$D94D,$D94E,
$D94F,$D950,$D951,$D952,$D953,$D954,$D955,$D956,$D957,$D958,$D959,$D95A,$D95B,
$D95C,$D95D,$D95E,$D95F,$D960,$D961,$D962,$D963,$D964,$D965,$D966,$D967,$D968,
$D969,$D96A,$D96B,$D96C,$D96D,$D96E,$D96F,$D970,$D971,$D972,$D973,$D974,$D975,
$D976,$D977,$D978,$D979,$D97A,$D97B,$D97C,$D97D,$D97E,$D980,$D981,$D982,$D983,
$D984,$D985,$D986,$D987,$D988,$D989,$D98A,$D98B,$D98C,$D98D,$D98E,$D98F,$D990,
$D991,$D992,$D993,$D994,$D995,$D996,$D997,$D998,$D999,$D99A,$D99B,$D99C,$D99D,
$D99E,$D99F,$D9A0,$DA40,$DA41,$DA42,$DA43,$DA44,$DA45,$DA46,$DA47,$DA48,$DA49,
$DA4A,$DA4B,$DA4C,$DA4D,$DA4E,$B1B4,$D5EA,$B8BA,$DA4F,$B9B1,$B2C6,$D4F0,$CFCD,
$B0DC,$D5CB,$BBF5,$D6CA,$B7B7,$CCB0,$C6B6,$B1E1,$B9BA,$D6FC,$B9E1,$B7A1,$BCFA,
$EADA,$EADB,$CCF9,$B9F3,$EADC,$B4FB,$C3B3,$B7D1,$BAD8,$EADD,$D4F4,$EADE,$BCD6,
$BBDF,$EADF,$C1DE,$C2B8,$D4DF,$D7CA,$EAE0,$EAE1,$EAE4,$EAE2,$EAE3,$C9DE,$B8B3,
$B6C4,$EAE5,$CAEA,$C9CD,$B4CD,$DA50,$DA51,$E2D9,$C5E2,$EAE6,$C0B5,$DA52,$D7B8,
$EAE7,$D7AC,$C8FC,$D8D3,$D8CD,$D4DE,$DA53,$D4F9,$C9C4,$D3AE,$B8D3,$B3E0,$DA54,
$C9E2,$F4F6,$DA55,$DA56,$DA57,$BAD5,$DA58,$F4F7,$DA59,$DA5A,$D7DF,$DA5B,$DA5C,
$F4F1,$B8B0,$D5D4,$B8CF,$C6F0,$DA5D,$DA5E,$DA5F,$DA60,$DA61,$DA62,$DA63,$DA64,
$DA65,$B3C3,$DA66,$DA67,$F4F2,$B3AC,$DA68,$DA69,$DA6A,$DA6B,$D4BD,$C7F7,$DA6C,
$DA6D,$DA6E,$DA6F,$DA70,$F4F4,$DA71,$DA72,$F4F3,$DA73,$DA74,$DA75,$DA76,$DA77,
$DA78,$DA79,$DA7A,$DA7B,$DA7C,$CCCB,$DA7D,$DA7E,$DA80,$C8A4,$DA81,$DA82,$DA83,
$DA84,$DA85,$DA86,$DA87,$DA88,$DA89,$DA8A,$DA8B,$DA8C,$DA8D,$F4F5,$DA8E,$D7E3,
$C5BF,$F5C0,$DA8F,$DA90,$F5BB,$DA91,$F5C3,$DA92,$F5C2,$DA93,$D6BA,$F5C1,$DA94,
$DA95,$DA96,$D4BE,$F5C4,$DA97,$F5CC,$DA98,$DA99,$DA9A,$DA9B,$B0CF,$B5F8,$DA9C,
$F5C9,$F5CA,$DA9D,$C5DC,$DA9E,$DA9F,$DAA0,$DB40,$F5C5,$F5C6,$DB41,$DB42,$F5C7,
$F5CB,$DB43,$BEE0,$F5C8,$B8FA,$DB44,$DB45,$DB46,$F5D0,$F5D3,$DB47,$DB48,$DB49,
$BFE7,$DB4A,$B9F2,$F5BC,$F5CD,$DB4B,$DB4C,$C2B7,$DB4D,$DB4E,$DB4F,$CCF8,$DB50,
$BCF9,$DB51,$F5CE,$F5CF,$F5D1,$B6E5,$F5D2,$DB52,$F5D5,$DB53,$DB54,$DB55,$DB56,
$DB57,$DB58,$DB59,$F5BD,$DB5A,$DB5B,$DB5C,$F5D4,$D3BB,$DB5D,$B3EC,$DB5E,$DB5F,
$CCA4,$DB60,$DB61,$DB62,$DB63,$F5D6,$DB64,$DB65,$DB66,$DB67,$DB68,$DB69,$DB6A,
$DB6B,$F5D7,$BEE1,$F5D8,$DB6C,$DB6D,$CCDF,$F5DB,$DB6E,$DB6F,$DB70,$DB71,$DB72,
$B2C8,$D7D9,$DB73,$F5D9,$DB74,$F5DA,$F5DC,$DB75,$F5E2,$DB76,$DB77,$DB78,$F5E0,
$DB79,$DB7A,$DB7B,$F5DF,$F5DD,$DB7C,$DB7D,$F5E1,$DB7E,$DB80,$F5DE,$F5E4,$F5E5,
$DB81,$CCE3,$DB82,$DB83,$E5BF,$B5B8,$F5E3,$F5E8,$CCA3,$DB84,$DB85,$DB86,$DB87,
$DB88,$F5E6,$F5E7,$DB89,$DB8A,$DB8B,$DB8C,$DB8D,$DB8E,$F5BE,$DB8F,$DB90,$DB91,
$DB92,$DB93,$DB94,$DB95,$DB96,$DB97,$DB98,$DB99,$DB9A,$B1C4,$DB9B,$DB9C,$F5BF,
$DB9D,$DB9E,$B5C5,$B2E4,$DB9F,$F5EC,$F5E9,$DBA0,$B6D7,$DC40,$F5ED,$DC41,$F5EA,
$DC42,$DC43,$DC44,$DC45,$DC46,$F5EB,$DC47,$DC48,$B4DA,$DC49,$D4EA,$DC4A,$DC4B,
$DC4C,$F5EE,$DC4D,$B3F9,$DC4E,$DC4F,$DC50,$DC51,$DC52,$DC53,$DC54,$F5EF,$F5F1,
$DC55,$DC56,$DC57,$F5F0,$DC58,$DC59,$DC5A,$DC5B,$DC5C,$DC5D,$DC5E,$F5F2,$DC5F,
$F5F3,$DC60,$DC61,$DC62,$DC63,$DC64,$DC65,$DC66,$DC67,$DC68,$DC69,$DC6A,$DC6B,
$C9ED,$B9AA,$DC6C,$DC6D,$C7FB,$DC6E,$DC6F,$B6E3,$DC70,$DC71,$DC72,$DC73,$DC74,
$DC75,$DC76,$CCC9,$DC77,$DC78,$DC79,$DC7A,$DC7B,$DC7C,$DC7D,$DC7E,$DC80,$DC81,
$DC82,$DC83,$DC84,$DC85,$DC86,$DC87,$DC88,$DC89,$DC8A,$EAA6,$DC8B,$DC8C,$DC8D,
$DC8E,$DC8F,$DC90,$DC91,$DC92,$DC93,$DC94,$DC95,$DC96,$DC97,$DC98,$DC99,$DC9A,
$DC9B,$DC9C,$DC9D,$DC9E,$DC9F,$DCA0,$DD40,$DD41,$DD42,$DD43,$DD44,$DD45,$DD46,
$DD47,$DD48,$DD49,$DD4A,$DD4B,$DD4C,$DD4D,$DD4E,$DD4F,$DD50,$DD51,$DD52,$DD53,
$DD54,$DD55,$DD56,$DD57,$DD58,$DD59,$DD5A,$DD5B,$DD5C,$DD5D,$DD5E,$DD5F,$DD60,
$DD61,$DD62,$DD63,$DD64,$DD65,$DD66,$DD67,$DD68,$DD69,$DD6A,$DD6B,$DD6C,$DD6D,
$DD6E,$DD6F,$DD70,$DD71,$DD72,$DD73,$DD74,$DD75,$DD76,$DD77,$DD78,$DD79,$DD7A,
$DD7B,$DD7C,$DD7D,$DD7E,$DD80,$DD81,$DD82,$DD83,$DD84,$DD85,$DD86,$DD87,$DD88,
$DD89,$DD8A,$DD8B,$DD8C,$DD8D,$DD8E,$DD8F,$DD90,$DD91,$DD92,$DD93,$DD94,$DD95,
$DD96,$DD97,$DD98,$DD99,$DD9A,$DD9B,$DD9C,$DD9D,$DD9E,$DD9F,$DDA0,$DE40,$DE41,
$DE42,$DE43,$DE44,$DE45,$DE46,$DE47,$DE48,$DE49,$DE4A,$DE4B,$DE4C,$DE4D,$DE4E,
$DE4F,$DE50,$DE51,$DE52,$DE53,$DE54,$DE55,$DE56,$DE57,$DE58,$DE59,$DE5A,$DE5B,
$DE5C,$DE5D,$DE5E,$DE5F,$DE60,$B3B5,$D4FE,$B9EC,$D0F9,$DE61,$E9ED,$D7AA,$E9EE,
$C2D6,$C8ED,$BAE4,$E9EF,$E9F0,$E9F1,$D6E1,$E9F2,$E9F3,$E9F5,$E9F4,$E9F6,$E9F7,
$C7E1,$E9F8,$D4D8,$E9F9,$BDCE,$DE62,$E9FA,$E9FB,$BDCF,$E9FC,$B8A8,$C1BE,$E9FD,
$B1B2,$BBD4,$B9F5,$E9FE,$DE63,$EAA1,$EAA2,$EAA3,$B7F8,$BCAD,$DE64,$CAE4,$E0CE,
$D4AF,$CFBD,$D5B7,$EAA4,$D5DE,$EAA5,$D0C1,$B9BC,$DE65,$B4C7,$B1D9,$DE66,$DE67,
$DE68,$C0B1,$DE69,$DE6A,$DE6B,$DE6C,$B1E6,$B1E7,$DE6D,$B1E8,$DE6E,$DE6F,$DE70,
$DE71,$B3BD,$C8E8,$DE72,$DE73,$DE74,$DE75,$E5C1,$DE76,$DE77,$B1DF,$DE78,$DE79,
$DE7A,$C1C9,$B4EF,$DE7B,$DE7C,$C7A8,$D3D8,$DE7D,$C6F9,$D1B8,$DE7E,$B9FD,$C2F5,
$DE80,$DE81,$DE82,$DE83,$DE84,$D3AD,$DE85,$D4CB,$BDFC,$DE86,$E5C2,$B7B5,$E5C3,
$DE87,$DE88,$BBB9,$D5E2,$DE89,$BDF8,$D4B6,$CEA5,$C1AC,$B3D9,$DE8A,$DE8B,$CCF6,
$DE8C,$E5C6,$E5C4,$E5C8,$DE8D,$E5CA,$E5C7,$B5CF,$C6C8,$DE8E,$B5FC,$E5C5,$DE8F,
$CAF6,$DE90,$DE91,$E5C9,$DE92,$DE93,$DE94,$C3D4,$B1C5,$BCA3,$DE95,$DE96,$DE97,
$D7B7,$DE98,$DE99,$CDCB,$CBCD,$CACA,$CCD3,$E5CC,$E5CB,$C4E6,$DE9A,$DE9B,$D1A1,
$D1B7,$E5CD,$DE9C,$E5D0,$DE9D,$CDB8,$D6F0,$E5CF,$B5DD,$DE9E,$CDBE,$DE9F,$E5D1,
$B6BA,$DEA0,$DF40,$CDA8,$B9E4,$DF41,$CAC5,$B3D1,$CBD9,$D4EC,$E5D2,$B7EA,$DF42,
$DF43,$DF44,$E5CE,$DF45,$DF46,$DF47,$DF48,$DF49,$DF4A,$E5D5,$B4FE,$E5D6,$DF4B,
$DF4C,$DF4D,$DF4E,$DF4F,$E5D3,$E5D4,$DF50,$D2DD,$DF51,$DF52,$C2DF,$B1C6,$DF53,
$D3E2,$DF54,$DF55,$B6DD,$CBEC,$DF56,$E5D7,$DF57,$DF58,$D3F6,$DF59,$DF5A,$DF5B,
$DF5C,$DF5D,$B1E9,$DF5E,$B6F4,$E5DA,$E5D8,$E5D9,$B5C0,$DF5F,$DF60,$DF61,$D2C5,
$E5DC,$DF62,$DF63,$E5DE,$DF64,$DF65,$DF66,$DF67,$DF68,$DF69,$E5DD,$C7B2,$DF6A,
$D2A3,$DF6B,$DF6C,$E5DB,$DF6D,$DF6E,$DF6F,$DF70,$D4E2,$D5DA,$DF71,$DF72,$DF73,
$DF74,$DF75,$E5E0,$D7F1,$DF76,$DF77,$DF78,$DF79,$DF7A,$DF7B,$DF7C,$E5E1,$DF7D,
$B1DC,$D1FB,$DF7E,$E5E2,$E5E4,$DF80,$DF81,$DF82,$DF83,$E5E3,$DF84,$DF85,$E5E5,
$DF86,$DF87,$DF88,$DF89,$DF8A,$D2D8,$DF8B,$B5CB,$DF8C,$E7DF,$DF8D,$DAF5,$DF8E,
$DAF8,$DF8F,$DAF6,$DF90,$DAF7,$DF91,$DF92,$DF93,$DAFA,$D0CF,$C4C7,$DF94,$DF95,
$B0EE,$DF96,$DF97,$DF98,$D0B0,$DF99,$DAF9,$DF9A,$D3CA,$BAAA,$DBA2,$C7F1,$DF9B,
$DAFC,$DAFB,$C9DB,$DAFD,$DF9C,$DBA1,$D7DE,$DAFE,$C1DA,$DF9D,$DF9E,$DBA5,$DF9F,
$DFA0,$D3F4,$E040,$E041,$DBA7,$DBA4,$E042,$DBA8,$E043,$E044,$BDBC,$E045,$E046,
$E047,$C0C9,$DBA3,$DBA6,$D6A3,$E048,$DBA9,$E049,$E04A,$E04B,$DBAD,$E04C,$E04D,
$E04E,$DBAE,$DBAC,$BAC2,$E04F,$E050,$E051,$BFA4,$DBAB,$E052,$E053,$E054,$DBAA,
$D4C7,$B2BF,$E055,$E056,$DBAF,$E057,$B9F9,$E058,$DBB0,$E059,$E05A,$E05B,$E05C,
$B3BB,$E05D,$E05E,$E05F,$B5A6,$E060,$E061,$E062,$E063,$B6BC,$DBB1,$E064,$E065,
$E066,$B6F5,$E067,$DBB2,$E068,$E069,$E06A,$E06B,$E06C,$E06D,$E06E,$E06F,$E070,
$E071,$E072,$E073,$E074,$E075,$E076,$E077,$E078,$E079,$E07A,$E07B,$B1C9,$E07C,
$E07D,$E07E,$E080,$DBB4,$E081,$E082,$E083,$DBB3,$DBB5,$E084,$E085,$E086,$E087,
$E088,$E089,$E08A,$E08B,$E08C,$E08D,$E08E,$DBB7,$E08F,$DBB6,$E090,$E091,$E092,
$E093,$E094,$E095,$E096,$DBB8,$E097,$E098,$E099,$E09A,$E09B,$E09C,$E09D,$E09E,
$E09F,$DBB9,$E0A0,$E140,$DBBA,$E141,$E142,$D3CF,$F4FA,$C7F5,$D7C3,$C5E4,$F4FC,
$F4FD,$F4FB,$E143,$BEC6,$E144,$E145,$E146,$E147,$D0EF,$E148,$E149,$B7D3,$E14A,
$E14B,$D4CD,$CCAA,$E14C,$E14D,$F5A2,$F5A1,$BAA8,$F4FE,$CBD6,$E14E,$E14F,$E150,
$F5A4,$C0D2,$E151,$B3EA,$E152,$CDAA,$F5A5,$F5A3,$BDB4,$F5A8,$E153,$F5A9,$BDCD,
$C3B8,$BFE1,$CBE1,$F5AA,$E154,$E155,$E156,$F5A6,$F5A7,$C4F0,$E157,$E158,$E159,
$E15A,$E15B,$F5AC,$E15C,$B4BC,$E15D,$D7ED,$E15E,$B4D7,$F5AB,$F5AE,$E15F,$E160,
$F5AD,$F5AF,$D0D1,$E161,$E162,$E163,$E164,$E165,$E166,$E167,$C3D1,$C8A9,$E168,
$E169,$E16A,$E16B,$E16C,$E16D,$F5B0,$F5B1,$E16E,$E16F,$E170,$E171,$E172,$E173,
$F5B2,$E174,$E175,$F5B3,$F5B4,$F5B5,$E176,$E177,$E178,$E179,$F5B7,$F5B6,$E17A,
$E17B,$E17C,$E17D,$F5B8,$E17E,$E180,$E181,$E182,$E183,$E184,$E185,$E186,$E187,
$E188,$E189,$E18A,$B2C9,$E18B,$D3D4,$CACD,$E18C,$C0EF,$D6D8,$D2B0,$C1BF,$E18D,
$BDF0,$E18E,$E18F,$E190,$E191,$E192,$E193,$E194,$E195,$E196,$E197,$B8AA,$E198,
$E199,$E19A,$E19B,$E19C,$E19D,$E19E,$E19F,$E1A0,$E240,$E241,$E242,$E243,$E244,
$E245,$E246,$E247,$E248,$E249,$E24A,$E24B,$E24C,$E24D,$E24E,$E24F,$E250,$E251,
$E252,$E253,$E254,$E255,$E256,$E257,$E258,$E259,$E25A,$E25B,$E25C,$E25D,$E25E,
$E25F,$E260,$E261,$E262,$E263,$E264,$E265,$E266,$E267,$E268,$E269,$E26A,$E26B,
$E26C,$E26D,$E26E,$E26F,$E270,$E271,$E272,$E273,$E274,$E275,$E276,$E277,$E278,
$E279,$E27A,$E27B,$E27C,$E27D,$E27E,$E280,$E281,$E282,$E283,$E284,$E285,$E286,
$E287,$E288,$E289,$E28A,$E28B,$E28C,$E28D,$E28E,$E28F,$E290,$E291,$E292,$E293,
$E294,$E295,$E296,$E297,$E298,$E299,$E29A,$E29B,$E29C,$E29D,$E29E,$E29F,$E2A0,
$E340,$E341,$E342,$E343,$E344,$E345,$E346,$E347,$E348,$E349,$E34A,$E34B,$E34C,
$E34D,$E34E,$E34F,$E350,$E351,$E352,$E353,$E354,$E355,$E356,$E357,$E358,$E359,
$E35A,$E35B,$E35C,$E35D,$E35E,$E35F,$E360,$E361,$E362,$E363,$E364,$E365,$E366,
$E367,$E368,$E369,$E36A,$E36B,$E36C,$E36D,$BCF8,$E36E,$E36F,$E370,$E371,$E372,
$E373,$E374,$E375,$E376,$E377,$E378,$E379,$E37A,$E37B,$E37C,$E37D,$E37E,$E380,
$E381,$E382,$E383,$E384,$E385,$E386,$E387,$F6C6,$E388,$E389,$E38A,$E38B,$E38C,
$E38D,$E38E,$E38F,$E390,$E391,$E392,$E393,$E394,$E395,$E396,$E397,$E398,$E399,
$E39A,$E39B,$E39C,$E39D,$E39E,$E39F,$E3A0,$E440,$E441,$E442,$E443,$E444,$E445,
$F6C7,$E446,$E447,$E448,$E449,$E44A,$E44B,$E44C,$E44D,$E44E,$E44F,$E450,$E451,
$E452,$E453,$E454,$E455,$E456,$E457,$E458,$E459,$E45A,$E45B,$E45C,$E45D,$E45E,
$F6C8,$E45F,$E460,$E461,$E462,$E463,$E464,$E465,$E466,$E467,$E468,$E469,$E46A,
$E46B,$E46C,$E46D,$E46E,$E46F,$E470,$E471,$E472,$E473,$E474,$E475,$E476,$E477,
$E478,$E479,$E47A,$E47B,$E47C,$E47D,$E47E,$E480,$E481,$E482,$E483,$E484,$E485,
$E486,$E487,$E488,$E489,$E48A,$E48B,$E48C,$E48D,$E48E,$E48F,$E490,$E491,$E492,
$E493,$E494,$E495,$E496,$E497,$E498,$E499,$E49A,$E49B,$E49C,$E49D,$E49E,$E49F,
$E4A0,$E540,$E541,$E542,$E543,$E544,$E545,$E546,$E547,$E548,$E549,$E54A,$E54B,
$E54C,$E54D,$E54E,$E54F,$E550,$E551,$E552,$E553,$E554,$E555,$E556,$E557,$E558,
$E559,$E55A,$E55B,$E55C,$E55D,$E55E,$E55F,$E560,$E561,$E562,$E563,$E564,$E565,
$E566,$E567,$E568,$E569,$E56A,$E56B,$E56C,$E56D,$E56E,$E56F,$E570,$E571,$E572,
$E573,$F6C9,$E574,$E575,$E576,$E577,$E578,$E579,$E57A,$E57B,$E57C,$E57D,$E57E,
$E580,$E581,$E582,$E583,$E584,$E585,$E586,$E587,$E588,$E589,$E58A,$E58B,$E58C,
$E58D,$E58E,$E58F,$E590,$E591,$E592,$E593,$E594,$E595,$E596,$E597,$E598,$E599,
$E59A,$E59B,$E59C,$E59D,$E59E,$E59F,$F6CA,$E5A0,$E640,$E641,$E642,$E643,$E644,
$E645,$E646,$E647,$E648,$E649,$E64A,$E64B,$E64C,$E64D,$E64E,$E64F,$E650,$E651,
$E652,$E653,$E654,$E655,$E656,$E657,$E658,$E659,$E65A,$E65B,$E65C,$E65D,$E65E,
$E65F,$E660,$E661,$E662,$F6CC,$E663,$E664,$E665,$E666,$E667,$E668,$E669,$E66A,
$E66B,$E66C,$E66D,$E66E,$E66F,$E670,$E671,$E672,$E673,$E674,$E675,$E676,$E677,
$E678,$E679,$E67A,$E67B,$E67C,$E67D,$E67E,$E680,$E681,$E682,$E683,$E684,$E685,
$E686,$E687,$E688,$E689,$E68A,$E68B,$E68C,$E68D,$E68E,$E68F,$E690,$E691,$E692,
$E693,$E694,$E695,$E696,$E697,$E698,$E699,$E69A,$E69B,$E69C,$E69D,$F6CB,$E69E,
$E69F,$E6A0,$E740,$E741,$E742,$E743,$E744,$E745,$E746,$E747,$F7E9,$E748,$E749,
$E74A,$E74B,$E74C,$E74D,$E74E,$E74F,$E750,$E751,$E752,$E753,$E754,$E755,$E756,
$E757,$E758,$E759,$E75A,$E75B,$E75C,$E75D,$E75E,$E75F,$E760,$E761,$E762,$E763,
$E764,$E765,$E766,$E767,$E768,$E769,$E76A,$E76B,$E76C,$E76D,$E76E,$E76F,$E770,
$E771,$E772,$E773,$E774,$E775,$E776,$E777,$E778,$E779,$E77A,$E77B,$E77C,$E77D,
$E77E,$E780,$E781,$E782,$E783,$E784,$E785,$E786,$E787,$E788,$E789,$E78A,$E78B,
$E78C,$E78D,$E78E,$E78F,$E790,$E791,$E792,$E793,$E794,$E795,$E796,$E797,$E798,
$E799,$E79A,$E79B,$E79C,$E79D,$E79E,$E79F,$E7A0,$E840,$E841,$E842,$E843,$E844,
$E845,$E846,$E847,$E848,$E849,$E84A,$E84B,$E84C,$E84D,$E84E,$F6CD,$E84F,$E850,
$E851,$E852,$E853,$E854,$E855,$E856,$E857,$E858,$E859,$E85A,$E85B,$E85C,$E85D,
$E85E,$E85F,$E860,$E861,$E862,$E863,$E864,$E865,$E866,$E867,$E868,$E869,$E86A,
$E86B,$E86C,$E86D,$E86E,$E86F,$E870,$E871,$E872,$E873,$E874,$E875,$E876,$E877,
$E878,$E879,$E87A,$F6CE,$E87B,$E87C,$E87D,$E87E,$E880,$E881,$E882,$E883,$E884,
$E885,$E886,$E887,$E888,$E889,$E88A,$E88B,$E88C,$E88D,$E88E,$E88F,$E890,$E891,
$E892,$E893,$E894,$EEC4,$EEC5,$EEC6,$D5EB,$B6A4,$EEC8,$EEC7,$EEC9,$EECA,$C7A5,
$EECB,$EECC,$E895,$B7B0,$B5F6,$EECD,$EECF,$E896,$EECE,$E897,$B8C6,$EED0,$EED1,
$EED2,$B6DB,$B3AE,$D6D3,$C4C6,$B1B5,$B8D6,$EED3,$EED4,$D4BF,$C7D5,$BEFB,$CED9,
$B9B3,$EED6,$EED5,$EED8,$EED7,$C5A5,$EED9,$EEDA,$C7AE,$EEDB,$C7AF,$EEDC,$B2A7,
$EEDD,$EEDE,$EEDF,$EEE0,$EEE1,$D7EA,$EEE2,$EEE3,$BCD8,$EEE4,$D3CB,$CCFA,$B2AC,
$C1E5,$EEE5,$C7A6,$C3AD,$E898,$EEE6,$EEE7,$EEE8,$EEE9,$EEEA,$EEEB,$EEEC,$E899,
$EEED,$EEEE,$EEEF,$E89A,$E89B,$EEF0,$EEF1,$EEF2,$EEF4,$EEF3,$E89C,$EEF5,$CDAD,
$C2C1,$EEF6,$EEF7,$EEF8,$D5A1,$EEF9,$CFB3,$EEFA,$EEFB,$E89D,$EEFC,$EEFD,$EFA1,
$EEFE,$EFA2,$B8F5,$C3FA,$EFA3,$EFA4,$BDC2,$D2BF,$B2F9,$EFA5,$EFA6,$EFA7,$D2F8,
$EFA8,$D6FD,$EFA9,$C6CC,$E89E,$EFAA,$EFAB,$C1B4,$EFAC,$CFFA,$CBF8,$EFAE,$EFAD,
$B3FA,$B9F8,$EFAF,$EFB0,$D0E2,$EFB1,$EFB2,$B7E6,$D0BF,$EFB3,$EFB4,$EFB5,$C8F1,
$CCE0,$EFB6,$EFB7,$EFB8,$EFB9,$EFBA,$D5E0,$EFBB,$B4ED,$C3AA,$EFBC,$E89F,$EFBD,
$EFBE,$EFBF,$E8A0,$CEFD,$EFC0,$C2E0,$B4B8,$D7B6,$BDF5,$E940,$CFC7,$EFC3,$EFC1,
$EFC2,$EFC4,$B6A7,$BCFC,$BEE2,$C3CC,$EFC5,$EFC6,$E941,$EFC7,$EFCF,$EFC8,$EFC9,
$EFCA,$C7C2,$EFF1,$B6CD,$EFCB,$E942,$EFCC,$EFCD,$B6C6,$C3BE,$EFCE,$E943,$EFD0,
$EFD1,$EFD2,$D5F2,$E944,$EFD3,$C4F7,$E945,$EFD4,$C4F8,$EFD5,$EFD6,$B8E4,$B0F7,
$EFD7,$EFD8,$EFD9,$E946,$EFDA,$EFDB,$EFDC,$EFDD,$E947,$EFDE,$BEB5,$EFE1,$EFDF,
$EFE0,$E948,$EFE2,$EFE3,$C1CD,$EFE4,$EFE5,$EFE6,$EFE7,$EFE8,$EFE9,$EFEA,$EFEB,
$EFEC,$C0D8,$E949,$EFED,$C1AD,$EFEE,$EFEF,$EFF0,$E94A,$E94B,$CFE2,$E94C,$E94D,
$E94E,$E94F,$E950,$E951,$E952,$E953,$B3A4,$E954,$E955,$E956,$E957,$E958,$E959,
$E95A,$E95B,$E95C,$E95D,$E95E,$E95F,$E960,$E961,$E962,$E963,$E964,$E965,$E966,
$E967,$E968,$E969,$E96A,$E96B,$E96C,$E96D,$E96E,$E96F,$E970,$E971,$E972,$E973,
$E974,$E975,$E976,$E977,$E978,$E979,$E97A,$E97B,$E97C,$E97D,$E97E,$E980,$E981,
$E982,$E983,$E984,$E985,$E986,$E987,$E988,$E989,$E98A,$E98B,$E98C,$E98D,$E98E,
$E98F,$E990,$E991,$E992,$E993,$E994,$E995,$E996,$E997,$E998,$E999,$E99A,$E99B,
$E99C,$E99D,$E99E,$E99F,$E9A0,$EA40,$EA41,$EA42,$EA43,$EA44,$EA45,$EA46,$EA47,
$EA48,$EA49,$EA4A,$EA4B,$EA4C,$EA4D,$EA4E,$EA4F,$EA50,$EA51,$EA52,$EA53,$EA54,
$EA55,$EA56,$EA57,$EA58,$EA59,$EA5A,$EA5B,$C3C5,$E3C5,$C9C1,$E3C6,$EA5C,$B1D5,
$CECA,$B4B3,$C8F2,$E3C7,$CFD0,$E3C8,$BCE4,$E3C9,$E3CA,$C3C6,$D5A2,$C4D6,$B9EB,
$CEC5,$E3CB,$C3F6,$E3CC,$EA5D,$B7A7,$B8F3,$BAD2,$E3CD,$E3CE,$D4C4,$E3CF,$EA5E,
$E3D0,$D1CB,$E3D1,$E3D2,$E3D3,$E3D4,$D1D6,$E3D5,$B2FB,$C0BB,$E3D6,$EA5F,$C0AB,
$E3D7,$E3D8,$E3D9,$EA60,$E3DA,$E3DB,$EA61,$B8B7,$DAE2,$EA62,$B6D3,$EA63,$DAE4,
$DAE3,$EA64,$EA65,$EA66,$EA67,$EA68,$EA69,$EA6A,$DAE6,$EA6B,$EA6C,$EA6D,$C8EE,
$EA6E,$EA6F,$DAE5,$B7C0,$D1F4,$D2F5,$D5F3,$BDD7,$EA70,$EA71,$EA72,$EA73,$D7E8,
$DAE8,$DAE7,$EA74,$B0A2,$CDD3,$EA75,$DAE9,$EA76,$B8BD,$BCCA,$C2BD,$C2A4,$B3C2,
$DAEA,$EA77,$C2AA,$C4B0,$BDB5,$EA78,$EA79,$CFDE,$EA7A,$EA7B,$EA7C,$DAEB,$C9C2,
$EA7D,$EA7E,$EA80,$EA81,$EA82,$B1DD,$EA83,$EA84,$EA85,$DAEC,$EA86,$B6B8,$D4BA,
$EA87,$B3FD,$EA88,$EA89,$DAED,$D4C9,$CFD5,$C5E3,$EA8A,$DAEE,$EA8B,$EA8C,$EA8D,
$EA8E,$EA8F,$DAEF,$EA90,$DAF0,$C1EA,$CCD5,$CFDD,$EA91,$EA92,$EA93,$EA94,$EA95,
$EA96,$EA97,$EA98,$EA99,$EA9A,$EA9B,$EA9C,$EA9D,$D3E7,$C2A1,$EA9E,$DAF1,$EA9F,
$EAA0,$CBE5,$EB40,$DAF2,$EB41,$CBE6,$D2FE,$EB42,$EB43,$EB44,$B8F4,$EB45,$EB46,
$DAF3,$B0AF,$CFB6,$EB47,$EB48,$D5CF,$EB49,$EB4A,$EB4B,$EB4C,$EB4D,$EB4E,$EB4F,
$EB50,$EB51,$EB52,$CBED,$EB53,$EB54,$EB55,$EB56,$EB57,$EB58,$EB59,$EB5A,$DAF4,
$EB5B,$EB5C,$E3C4,$EB5D,$EB5E,$C1A5,$EB5F,$EB60,$F6BF,$EB61,$EB62,$F6C0,$F6C1,
$C4D1,$EB63,$C8B8,$D1E3,$EB64,$EB65,$D0DB,$D1C5,$BCAF,$B9CD,$EB66,$EFF4,$EB67,
$EB68,$B4C6,$D3BA,$F6C2,$B3FB,$EB69,$EB6A,$F6C3,$EB6B,$EB6C,$B5F1,$EB6D,$EB6E,
$EB6F,$EB70,$EB71,$EB72,$EB73,$EB74,$EB75,$EB76,$F6C5,$EB77,$EB78,$EB79,$EB7A,
$EB7B,$EB7C,$EB7D,$D3EA,$F6A7,$D1A9,$EB7E,$EB80,$EB81,$EB82,$F6A9,$EB83,$EB84,
$EB85,$F6A8,$EB86,$EB87,$C1E3,$C0D7,$EB88,$B1A2,$EB89,$EB8A,$EB8B,$EB8C,$CEED,
$EB8D,$D0E8,$F6AB,$EB8E,$EB8F,$CFF6,$EB90,$F6AA,$D5F0,$F6AC,$C3B9,$EB91,$EB92,
$EB93,$BBF4,$F6AE,$F6AD,$EB94,$EB95,$EB96,$C4DE,$EB97,$EB98,$C1D8,$EB99,$EB9A,
$EB9B,$EB9C,$EB9D,$CBAA,$EB9E,$CFBC,$EB9F,$EBA0,$EC40,$EC41,$EC42,$EC43,$EC44,
$EC45,$EC46,$EC47,$EC48,$F6AF,$EC49,$EC4A,$F6B0,$EC4B,$EC4C,$F6B1,$EC4D,$C2B6,
$EC4E,$EC4F,$EC50,$EC51,$EC52,$B0D4,$C5F9,$EC53,$EC54,$EC55,$EC56,$F6B2,$EC57,
$EC58,$EC59,$EC5A,$EC5B,$EC5C,$EC5D,$EC5E,$EC5F,$EC60,$EC61,$EC62,$EC63,$EC64,
$EC65,$EC66,$EC67,$EC68,$EC69,$C7E0,$F6A6,$EC6A,$EC6B,$BEB8,$EC6C,$EC6D,$BEB2,
$EC6E,$B5E5,$EC6F,$EC70,$B7C7,$EC71,$BFBF,$C3D2,$C3E6,$EC72,$EC73,$D8CC,$EC74,
$EC75,$EC76,$B8EF,$EC77,$EC78,$EC79,$EC7A,$EC7B,$EC7C,$EC7D,$EC7E,$EC80,$BDF9,
$D1A5,$EC81,$B0D0,$EC82,$EC83,$EC84,$EC85,$EC86,$F7B0,$EC87,$EC88,$EC89,$EC8A,
$EC8B,$EC8C,$EC8D,$EC8E,$F7B1,$EC8F,$EC90,$EC91,$EC92,$EC93,$D0AC,$EC94,$B0B0,
$EC95,$EC96,$EC97,$F7B2,$F7B3,$EC98,$F7B4,$EC99,$EC9A,$EC9B,$C7CA,$EC9C,$EC9D,
$EC9E,$EC9F,$ECA0,$ED40,$ED41,$BECF,$ED42,$ED43,$F7B7,$ED44,$ED45,$ED46,$ED47,
$ED48,$ED49,$ED4A,$F7B6,$ED4B,$B1DE,$ED4C,$F7B5,$ED4D,$ED4E,$F7B8,$ED4F,$F7B9,
$ED50,$ED51,$ED52,$ED53,$ED54,$ED55,$ED56,$ED57,$ED58,$ED59,$ED5A,$ED5B,$ED5C,
$ED5D,$ED5E,$ED5F,$ED60,$ED61,$ED62,$ED63,$ED64,$ED65,$ED66,$ED67,$ED68,$ED69,
$ED6A,$ED6B,$ED6C,$ED6D,$ED6E,$ED6F,$ED70,$ED71,$ED72,$ED73,$ED74,$ED75,$ED76,
$ED77,$ED78,$ED79,$ED7A,$ED7B,$ED7C,$ED7D,$ED7E,$ED80,$ED81,$CEA4,$C8CD,$ED82,
$BAAB,$E8B8,$E8B9,$E8BA,$BEC2,$ED83,$ED84,$ED85,$ED86,$ED87,$D2F4,$ED88,$D4CF,
$C9D8,$ED89,$ED8A,$ED8B,$ED8C,$ED8D,$ED8E,$ED8F,$ED90,$ED91,$ED92,$ED93,$ED94,
$ED95,$ED96,$ED97,$ED98,$ED99,$ED9A,$ED9B,$ED9C,$ED9D,$ED9E,$ED9F,$EDA0,$EE40,
$EE41,$EE42,$EE43,$EE44,$EE45,$EE46,$EE47,$EE48,$EE49,$EE4A,$EE4B,$EE4C,$EE4D,
$EE4E,$EE4F,$EE50,$EE51,$EE52,$EE53,$EE54,$EE55,$EE56,$EE57,$EE58,$EE59,$EE5A,
$EE5B,$EE5C,$EE5D,$EE5E,$EE5F,$EE60,$EE61,$EE62,$EE63,$EE64,$EE65,$EE66,$EE67,
$EE68,$EE69,$EE6A,$EE6B,$EE6C,$EE6D,$EE6E,$EE6F,$EE70,$EE71,$EE72,$EE73,$EE74,
$EE75,$EE76,$EE77,$EE78,$EE79,$EE7A,$EE7B,$EE7C,$EE7D,$EE7E,$EE80,$EE81,$EE82,
$EE83,$EE84,$EE85,$EE86,$EE87,$EE88,$EE89,$EE8A,$EE8B,$EE8C,$EE8D,$EE8E,$EE8F,
$EE90,$EE91,$EE92,$EE93,$EE94,$EE95,$EE96,$EE97,$EE98,$EE99,$EE9A,$EE9B,$EE9C,
$EE9D,$EE9E,$EE9F,$EEA0,$EF40,$EF41,$EF42,$EF43,$EF44,$EF45,$D2B3,$B6A5,$C7EA,
$F1FC,$CFEE,$CBB3,$D0EB,$E7EF,$CDE7,$B9CB,$B6D9,$F1FD,$B0E4,$CBCC,$F1FE,$D4A4,
$C2AD,$C1EC,$C6C4,$BEB1,$F2A1,$BCD5,$EF46,$F2A2,$F2A3,$EF47,$F2A4,$D2C3,$C6B5,
$EF48,$CDC7,$F2A5,$EF49,$D3B1,$BFC5,$CCE2,$EF4A,$F2A6,$F2A7,$D1D5,$B6EE,$F2A8,
$F2A9,$B5DF,$F2AA,$F2AB,$EF4B,$B2FC,$F2AC,$F2AD,$C8A7,$EF4C,$EF4D,$EF4E,$EF4F,
$EF50,$EF51,$EF52,$EF53,$EF54,$EF55,$EF56,$EF57,$EF58,$EF59,$EF5A,$EF5B,$EF5C,
$EF5D,$EF5E,$EF5F,$EF60,$EF61,$EF62,$EF63,$EF64,$EF65,$EF66,$EF67,$EF68,$EF69,
$EF6A,$EF6B,$EF6C,$EF6D,$EF6E,$EF6F,$EF70,$EF71,$B7E7,$EF72,$EF73,$ECA9,$ECAA,
$ECAB,$EF74,$ECAC,$EF75,$EF76,$C6AE,$ECAD,$ECAE,$EF77,$EF78,$EF79,$B7C9,$CAB3,
$EF7A,$EF7B,$EF7C,$EF7D,$EF7E,$EF80,$EF81,$E2B8,$F7CF,$EF82,$EF83,$EF84,$EF85,
$EF86,$EF87,$EF88,$EF89,$EF8A,$EF8B,$EF8C,$EF8D,$EF8E,$EF8F,$EF90,$EF91,$EF92,
$EF93,$EF94,$EF95,$EF96,$EF97,$EF98,$EF99,$EF9A,$EF9B,$EF9C,$EF9D,$EF9E,$EF9F,
$EFA0,$F040,$F041,$F042,$F043,$F044,$F7D0,$F045,$F046,$B2CD,$F047,$F048,$F049,
$F04A,$F04B,$F04C,$F04D,$F04E,$F04F,$F050,$F051,$F052,$F053,$F054,$F055,$F056,
$F057,$F058,$F059,$F05A,$F05B,$F05C,$F05D,$F05E,$F05F,$F060,$F061,$F062,$F063,
$F7D1,$F064,$F065,$F066,$F067,$F068,$F069,$F06A,$F06B,$F06C,$F06D,$F06E,$F06F,
$F070,$F071,$F072,$F073,$F074,$F075,$F076,$F077,$F078,$F079,$F07A,$F07B,$F07C,
$F07D,$F07E,$F080,$F081,$F082,$F083,$F084,$F085,$F086,$F087,$F088,$F089,$F7D3,
$F7D2,$F08A,$F08B,$F08C,$F08D,$F08E,$F08F,$F090,$F091,$F092,$F093,$F094,$F095,
$F096,$E2BB,$F097,$BCA2,$F098,$E2BC,$E2BD,$E2BE,$E2BF,$E2C0,$E2C1,$B7B9,$D2FB,
$BDA4,$CACE,$B1A5,$CBC7,$F099,$E2C2,$B6FC,$C8C4,$E2C3,$F09A,$F09B,$BDC8,$F09C,
$B1FD,$E2C4,$F09D,$B6F6,$E2C5,$C4D9,$F09E,$F09F,$E2C6,$CFDA,$B9DD,$E2C7,$C0A1,
$F0A0,$E2C8,$B2F6,$F140,$E2C9,$F141,$C1F3,$E2CA,$E2CB,$C2F8,$E2CC,$E2CD,$E2CE,
$CAD7,$D8B8,$D9E5,$CFE3,$F142,$F143,$F144,$F145,$F146,$F147,$F148,$F149,$F14A,
$F14B,$F14C,$F0A5,$F14D,$F14E,$DCB0,$F14F,$F150,$F151,$F152,$F153,$F154,$F155,
$F156,$F157,$F158,$F159,$F15A,$F15B,$F15C,$F15D,$F15E,$F15F,$F160,$F161,$F162,
$F163,$F164,$F165,$F166,$F167,$F168,$F169,$F16A,$F16B,$F16C,$F16D,$F16E,$F16F,
$F170,$F171,$F172,$F173,$F174,$F175,$F176,$F177,$F178,$F179,$F17A,$F17B,$F17C,
$F17D,$F17E,$F180,$F181,$F182,$F183,$F184,$F185,$F186,$F187,$F188,$F189,$F18A,
$F18B,$F18C,$F18D,$F18E,$F18F,$F190,$F191,$F192,$F193,$F194,$F195,$F196,$F197,
$F198,$F199,$F19A,$F19B,$F19C,$F19D,$F19E,$F19F,$F1A0,$F240,$F241,$F242,$F243,
$F244,$F245,$F246,$F247,$F248,$F249,$F24A,$F24B,$F24C,$F24D,$F24E,$F24F,$F250,
$F251,$F252,$F253,$F254,$F255,$F256,$F257,$F258,$F259,$F25A,$F25B,$F25C,$F25D,
$F25E,$F25F,$F260,$F261,$F262,$F263,$F264,$F265,$F266,$F267,$F268,$F269,$F26A,
$F26B,$F26C,$F26D,$F26E,$F26F,$F270,$F271,$F272,$F273,$F274,$F275,$F276,$F277,
$F278,$F279,$F27A,$F27B,$F27C,$F27D,$F27E,$F280,$F281,$F282,$F283,$F284,$F285,
$F286,$F287,$F288,$F289,$F28A,$F28B,$F28C,$F28D,$F28E,$F28F,$F290,$F291,$F292,
$F293,$F294,$F295,$F296,$F297,$F298,$F299,$F29A,$F29B,$F29C,$F29D,$F29E,$F29F,
$F2A0,$F340,$F341,$F342,$F343,$F344,$F345,$F346,$F347,$F348,$F349,$F34A,$F34B,
$F34C,$F34D,$F34E,$F34F,$F350,$F351,$C2ED,$D4A6,$CDD4,$D1B1,$B3DB,$C7FD,$F352,
$B2B5,$C2BF,$E6E0,$CABB,$E6E1,$E6E2,$BED4,$E6E3,$D7A4,$CDD5,$E6E5,$BCDD,$E6E4,
$E6E6,$E6E7,$C2EE,$F353,$BDBE,$E6E8,$C2E6,$BAA7,$E6E9,$F354,$E6EA,$B3D2,$D1E9,
$F355,$F356,$BFA5,$E6EB,$C6EF,$E6EC,$E6ED,$F357,$F358,$E6EE,$C6AD,$E6EF,$F359,
$C9A7,$E6F0,$E6F1,$E6F2,$E5B9,$E6F3,$E6F4,$C2E2,$E6F5,$E6F6,$D6E8,$E6F7,$F35A,
$E6F8,$B9C7,$F35B,$F35C,$F35D,$F35E,$F35F,$F360,$F361,$F7BB,$F7BA,$F362,$F363,
$F364,$F365,$F7BE,$F7BC,$BAA1,$F366,$F7BF,$F367,$F7C0,$F368,$F369,$F36A,$F7C2,
$F7C1,$F7C4,$F36B,$F36C,$F7C3,$F36D,$F36E,$F36F,$F370,$F371,$F7C5,$F7C6,$F372,
$F373,$F374,$F375,$F7C7,$F376,$CBE8,$F377,$F378,$F379,$F37A,$B8DF,$F37B,$F37C,
$F37D,$F37E,$F380,$F381,$F7D4,$F382,$F7D5,$F383,$F384,$F385,$F386,$F7D6,$F387,
$F388,$F389,$F38A,$F7D8,$F38B,$F7DA,$F38C,$F7D7,$F38D,$F38E,$F38F,$F390,$F391,
$F392,$F393,$F394,$F395,$F7DB,$F396,$F7D9,$F397,$F398,$F399,$F39A,$F39B,$F39C,
$F39D,$D7D7,$F39E,$F39F,$F3A0,$F440,$F7DC,$F441,$F442,$F443,$F444,$F445,$F446,
$F7DD,$F447,$F448,$F449,$F7DE,$F44A,$F44B,$F44C,$F44D,$F44E,$F44F,$F450,$F451,
$F452,$F453,$F454,$F7DF,$F455,$F456,$F457,$F7E0,$F458,$F459,$F45A,$F45B,$F45C,
$F45D,$F45E,$F45F,$F460,$F461,$F462,$DBCB,$F463,$F464,$D8AA,$F465,$F466,$F467,
$F468,$F469,$F46A,$F46B,$F46C,$E5F7,$B9ED,$F46D,$F46E,$F46F,$F470,$BFFD,$BBEA,
$F7C9,$C6C7,$F7C8,$F471,$F7CA,$F7CC,$F7CB,$F472,$F473,$F474,$F7CD,$F475,$CEBA,
$F476,$F7CE,$F477,$F478,$C4A7,$F479,$F47A,$F47B,$F47C,$F47D,$F47E,$F480,$F481,
$F482,$F483,$F484,$F485,$F486,$F487,$F488,$F489,$F48A,$F48B,$F48C,$F48D,$F48E,
$F48F,$F490,$F491,$F492,$F493,$F494,$F495,$F496,$F497,$F498,$F499,$F49A,$F49B,
$F49C,$F49D,$F49E,$F49F,$F4A0,$F540,$F541,$F542,$F543,$F544,$F545,$F546,$F547,
$F548,$F549,$F54A,$F54B,$F54C,$F54D,$F54E,$F54F,$F550,$F551,$F552,$F553,$F554,
$F555,$F556,$F557,$F558,$F559,$F55A,$F55B,$F55C,$F55D,$F55E,$F55F,$F560,$F561,
$F562,$F563,$F564,$F565,$F566,$F567,$F568,$F569,$F56A,$F56B,$F56C,$F56D,$F56E,
$F56F,$F570,$F571,$F572,$F573,$F574,$F575,$F576,$F577,$F578,$F579,$F57A,$F57B,
$F57C,$F57D,$F57E,$F580,$F581,$F582,$F583,$F584,$F585,$F586,$F587,$F588,$F589,
$F58A,$F58B,$F58C,$F58D,$F58E,$F58F,$F590,$F591,$F592,$F593,$F594,$F595,$F596,
$F597,$F598,$F599,$F59A,$F59B,$F59C,$F59D,$F59E,$F59F,$F5A0,$F640,$F641,$F642,
$F643,$F644,$F645,$F646,$F647,$F648,$F649,$F64A,$F64B,$F64C,$F64D,$F64E,$F64F,
$F650,$F651,$F652,$F653,$F654,$F655,$F656,$F657,$F658,$F659,$F65A,$F65B,$F65C,
$F65D,$F65E,$F65F,$F660,$F661,$F662,$F663,$F664,$F665,$F666,$F667,$F668,$F669,
$F66A,$F66B,$F66C,$F66D,$F66E,$F66F,$F670,$F671,$F672,$F673,$F674,$F675,$F676,
$F677,$F678,$F679,$F67A,$F67B,$F67C,$F67D,$F67E,$F680,$F681,$F682,$F683,$F684,
$F685,$F686,$F687,$F688,$F689,$F68A,$F68B,$F68C,$F68D,$F68E,$F68F,$F690,$F691,
$F692,$F693,$F694,$F695,$F696,$F697,$F698,$F699,$F69A,$F69B,$F69C,$F69D,$F69E,
$F69F,$F6A0,$F740,$F741,$F742,$F743,$F744,$F745,$F746,$F747,$F748,$F749,$F74A,
$F74B,$F74C,$F74D,$F74E,$F74F,$F750,$F751,$F752,$F753,$F754,$F755,$F756,$F757,
$F758,$F759,$F75A,$F75B,$F75C,$F75D,$F75E,$F75F,$F760,$F761,$F762,$F763,$F764,
$F765,$F766,$F767,$F768,$F769,$F76A,$F76B,$F76C,$F76D,$F76E,$F76F,$F770,$F771,
$F772,$F773,$F774,$F775,$F776,$F777,$F778,$F779,$F77A,$F77B,$F77C,$F77D,$F77E,
$F780,$D3E3,$F781,$F782,$F6CF,$F783,$C2B3,$F6D0,$F784,$F785,$F6D1,$F6D2,$F6D3,
$F6D4,$F786,$F787,$F6D6,$F788,$B1AB,$F6D7,$F789,$F6D8,$F6D9,$F6DA,$F78A,$F6DB,
$F6DC,$F78B,$F78C,$F78D,$F78E,$F6DD,$F6DE,$CFCA,$F78F,$F6DF,$F6E0,$F6E1,$F6E2,
$F6E3,$F6E4,$C0F0,$F6E5,$F6E6,$F6E7,$F6E8,$F6E9,$F790,$F6EA,$F791,$F6EB,$F6EC,
$F792,$F6ED,$F6EE,$F6EF,$F6F0,$F6F1,$F6F2,$F6F3,$F6F4,$BEA8,$F793,$F6F5,$F6F6,
$F6F7,$F6F8,$F794,$F795,$F796,$F797,$F798,$C8FA,$F6F9,$F6FA,$F6FB,$F6FC,$F799,
$F79A,$F6FD,$F6FE,$F7A1,$F7A2,$F7A3,$F7A4,$F7A5,$F79B,$F79C,$F7A6,$F7A7,$F7A8,
$B1EE,$F7A9,$F7AA,$F7AB,$F79D,$F79E,$F7AC,$F7AD,$C1DB,$F7AE,$F79F,$F7A0,$F7AF,
$F840,$F841,$F842,$F843,$F844,$F845,$F846,$F847,$F848,$F849,$F84A,$F84B,$F84C,
$F84D,$F84E,$F84F,$F850,$F851,$F852,$F853,$F854,$F855,$F856,$F857,$F858,$F859,
$F85A,$F85B,$F85C,$F85D,$F85E,$F85F,$F860,$F861,$F862,$F863,$F864,$F865,$F866,
$F867,$F868,$F869,$F86A,$F86B,$F86C,$F86D,$F86E,$F86F,$F870,$F871,$F872,$F873,
$F874,$F875,$F876,$F877,$F878,$F879,$F87A,$F87B,$F87C,$F87D,$F87E,$F880,$F881,
$F882,$F883,$F884,$F885,$F886,$F887,$F888,$F889,$F88A,$F88B,$F88C,$F88D,$F88E,
$F88F,$F890,$F891,$F892,$F893,$F894,$F895,$F896,$F897,$F898,$F899,$F89A,$F89B,
$F89C,$F89D,$F89E,$F89F,$F8A0,$F940,$F941,$F942,$F943,$F944,$F945,$F946,$F947,
$F948,$F949,$F94A,$F94B,$F94C,$F94D,$F94E,$F94F,$F950,$F951,$F952,$F953,$F954,
$F955,$F956,$F957,$F958,$F959,$F95A,$F95B,$F95C,$F95D,$F95E,$F95F,$F960,$F961,
$F962,$F963,$F964,$F965,$F966,$F967,$F968,$F969,$F96A,$F96B,$F96C,$F96D,$F96E,
$F96F,$F970,$F971,$F972,$F973,$F974,$F975,$F976,$F977,$F978,$F979,$F97A,$F97B,
$F97C,$F97D,$F97E,$F980,$F981,$F982,$F983,$F984,$F985,$F986,$F987,$F988,$F989,
$F98A,$F98B,$F98C,$F98D,$F98E,$F98F,$F990,$F991,$F992,$F993,$F994,$F995,$F996,
$F997,$F998,$F999,$F99A,$F99B,$F99C,$F99D,$F99E,$F99F,$F9A0,$FA40,$FA41,$FA42,
$FA43,$FA44,$FA45,$FA46,$FA47,$FA48,$FA49,$FA4A,$FA4B,$FA4C,$FA4D,$FA4E,$FA4F,
$FA50,$FA51,$FA52,$FA53,$FA54,$FA55,$FA56,$FA57,$FA58,$FA59,$FA5A,$FA5B,$FA5C,
$FA5D,$FA5E,$FA5F,$FA60,$FA61,$FA62,$FA63,$FA64,$FA65,$FA66,$FA67,$FA68,$FA69,
$FA6A,$FA6B,$FA6C,$FA6D,$FA6E,$FA6F,$FA70,$FA71,$FA72,$FA73,$FA74,$FA75,$FA76,
$FA77,$FA78,$FA79,$FA7A,$FA7B,$FA7C,$FA7D,$FA7E,$FA80,$FA81,$FA82,$FA83,$FA84,
$FA85,$FA86,$FA87,$FA88,$FA89,$FA8A,$FA8B,$FA8C,$FA8D,$FA8E,$FA8F,$FA90,$FA91,
$FA92,$FA93,$FA94,$FA95,$FA96,$FA97,$FA98,$FA99,$FA9A,$FA9B,$FA9C,$FA9D,$FA9E,
$FA9F,$FAA0,$FB40,$FB41,$FB42,$FB43,$FB44,$FB45,$FB46,$FB47,$FB48,$FB49,$FB4A,
$FB4B,$FB4C,$FB4D,$FB4E,$FB4F,$FB50,$FB51,$FB52,$FB53,$FB54,$FB55,$FB56,$FB57,
$FB58,$FB59,$FB5A,$FB5B,$C4F1,$F0AF,$BCA6,$F0B0,$C3F9,$FB5C,$C5B8,$D1BB,$FB5D,
$F0B1,$F0B2,$F0B3,$F0B4,$F0B5,$D1BC,$FB5E,$D1EC,$FB5F,$F0B7,$F0B6,$D4A7,$FB60,
$CDD2,$F0B8,$F0BA,$F0B9,$F0BB,$F0BC,$FB61,$FB62,$B8EB,$F0BD,$BAE8,$FB63,$F0BE,
$F0BF,$BEE9,$F0C0,$B6EC,$F0C1,$F0C2,$F0C3,$F0C4,$C8B5,$F0C5,$F0C6,$FB64,$F0C7,
$C5F4,$FB65,$F0C8,$FB66,$FB67,$FB68,$F0C9,$FB69,$F0CA,$F7BD,$FB6A,$F0CB,$F0CC,
$F0CD,$FB6B,$F0CE,$FB6C,$FB6D,$FB6E,$FB6F,$F0CF,$BAD7,$FB70,$F0D0,$F0D1,$F0D2,
$F0D3,$F0D4,$F0D5,$F0D6,$F0D8,$FB71,$FB72,$D3A5,$F0D7,$FB73,$F0D9,$FB74,$FB75,
$FB76,$FB77,$FB78,$FB79,$FB7A,$FB7B,$FB7C,$FB7D,$F5BA,$C2B9,$FB7E,$FB80,$F7E4,
$FB81,$FB82,$FB83,$FB84,$F7E5,$F7E6,$FB85,$FB86,$F7E7,$FB87,$FB88,$FB89,$FB8A,
$FB8B,$FB8C,$F7E8,$C2B4,$FB8D,$FB8E,$FB8F,$FB90,$FB91,$FB92,$FB93,$FB94,$FB95,
$F7EA,$FB96,$F7EB,$FB97,$FB98,$FB99,$FB9A,$FB9B,$FB9C,$C2F3,$FB9D,$FB9E,$FB9F,
$FBA0,$FC40,$FC41,$FC42,$FC43,$FC44,$FC45,$FC46,$FC47,$FC48,$F4F0,$FC49,$FC4A,
$FC4B,$F4EF,$FC4C,$FC4D,$C2E9,$FC4E,$F7E1,$F7E2,$FC4F,$FC50,$FC51,$FC52,$FC53,
$BBC6,$FC54,$FC55,$FC56,$FC57,$D9E4,$FC58,$FC59,$FC5A,$CAF2,$C0E8,$F0A4,$FC5B,
$BADA,$FC5C,$FC5D,$C7AD,$FC5E,$FC5F,$FC60,$C4AC,$FC61,$FC62,$F7EC,$F7ED,$F7EE,
$FC63,$F7F0,$F7EF,$FC64,$F7F1,$FC65,$FC66,$F7F4,$FC67,$F7F3,$FC68,$F7F2,$F7F5,
$FC69,$FC6A,$FC6B,$FC6C,$F7F6,$FC6D,$FC6E,$FC6F,$FC70,$FC71,$FC72,$FC73,$FC74,
$FC75,$EDE9,$FC76,$EDEA,$EDEB,$FC77,$F6BC,$FC78,$FC79,$FC7A,$FC7B,$FC7C,$FC7D,
$FC7E,$FC80,$FC81,$FC82,$FC83,$FC84,$F6BD,$FC85,$F6BE,$B6A6,$FC86,$D8BE,$FC87,
$FC88,$B9C4,$FC89,$FC8A,$FC8B,$D8BB,$FC8C,$DCB1,$FC8D,$FC8E,$FC8F,$FC90,$FC91,
$FC92,$CAF3,$FC93,$F7F7,$FC94,$FC95,$FC96,$FC97,$FC98,$FC99,$FC9A,$FC9B,$FC9C,
$F7F8,$FC9D,$FC9E,$F7F9,$FC9F,$FCA0,$FD40,$FD41,$FD42,$FD43,$FD44,$F7FB,$FD45,
$F7FA,$FD46,$B1C7,$FD47,$F7FC,$F7FD,$FD48,$FD49,$FD4A,$FD4B,$FD4C,$F7FE,$FD4D,
$FD4E,$FD4F,$FD50,$FD51,$FD52,$FD53,$FD54,$FD55,$FD56,$FD57,$C6EB,$ECB4,$FD58,
$FD59,$FD5A,$FD5B,$FD5C,$FD5D,$FD5E,$FD5F,$FD60,$FD61,$FD62,$FD63,$FD64,$FD65,
$FD66,$FD67,$FD68,$FD69,$FD6A,$FD6B,$FD6C,$FD6D,$FD6E,$FD6F,$FD70,$FD71,$FD72,
$FD73,$FD74,$FD75,$FD76,$FD77,$FD78,$FD79,$FD7A,$FD7B,$FD7C,$FD7D,$FD7E,$FD80,
$FD81,$FD82,$FD83,$FD84,$FD85,$B3DD,$F6B3,$FD86,$FD87,$F6B4,$C1E4,$F6B5,$F6B6,
$F6B7,$F6B8,$F6B9,$F6BA,$C8A3,$F6BB,$FD88,$FD89,$FD8A,$FD8B,$FD8C,$FD8D,$FD8E,
$FD8F,$FD90,$FD91,$FD92,$FD93,$C1FA,$B9A8,$EDE8,$FD94,$FD95,$FD96,$B9EA,$D9DF,
$FD97,$FD98,$FD99,$FD9A,$FD9B,$FD9C,$FD9D,$FD9E,$FD9F,$FDA0,$FE40,$FE41,$FE42,
$FE43,$FE44,$FE45,$FE46,$FE47,$FE48,$FE49,$FE4A,$FE4B,$FE4C,$FE4D,$FE4E,$FE4F,
$A955,$A6F2,$A6F4,$A6F5,$A6E0,$A6E1,$A6F0,$A6F1,$A6E2,$A6E3,$A6EE,$A6EF,$A6E6,
$A6E7,$A6E4,$A6E5,$A6E8,$A6E9,$A6EA,$A6EB,$A968,$A969,$A96A,$A96B,$A96C,$A96D,
$A96E,$A96F,$A970,$A971,$A972,$A973,$A974,$A975,$A976,$A977,$A978,$A979,$A97A,
$A97B,$A97C,$A97D,$A97E,$A980,$A981,$A982,$A983,$A984,$A985,$A986,$A987,$A988,
$A3A1,$A3A2,$A3A3,$A1E7,$A3A5,$A3A6,$A3A7,$A3A8,$A3A9,$A3AA,$A3AB,$A3AC,$A3AD,
$A3AE,$A3AF,$A3B0,$A3B1,$A3B2,$A3B3,$A3B4,$A3B5,$A3B6,$A3B7,$A3B8,$A3B9,$A3BA,
$A3BB,$A3BC,$A3BD,$A3BE,$A3BF,$A3C0,$A3C1,$A3C2,$A3C3,$A3C4,$A3C5,$A3C6,$A3C7,
$A3C8,$A3C9,$A3CA,$A3CB,$A3CC,$A3CD,$A3CE,$A3CF,$A3D0,$A3D1,$A3D2,$A3D3,$A3D4,
$A3D5,$A3D6,$A3D7,$A3D8,$A3D9,$A3DA,$A3DB,$A3DC,$A3DD,$A3DE,$A3DF,$A3E0,$A3E1,
$A3E2,$A3E3,$A3E4,$A3E5,$A3E6,$A3E7,$A3E8,$A3E9,$A3EA,$A3EB,$A3EC,$A3ED,$A3EE,
$A3EF,$A3F0,$A3F1,$A3F2,$A3F3,$A3F4,$A3F5,$A3F6,$A3F7,$A3F8,$A3F9,$A3FA,$A3FB,
$A3FC,$A3FD,$A1AB,$A1E9,$A1EA,$A956,$A3FE,$A957,$A3A4);

const Uni936U: CP936Arr =
(0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,$0000,$0001,$0002,$0003,$0004,$0005,$0006,$0007,$0008,$0009,$000A,$000B,
$000C,$000D,$000E,$000F,$0010,$0011,$0012,$0013,$0014,$0015,$0016,$0017,$0018,
$0019,$001A,$001B,$001C,$001D,$001E,$001F,$0020,$0021,$0022,$0023,$0024,$0025,
$0026,$0027,$0028,$0029,$002A,$002B,$002C,$002D,$002E,$002F,$0030,$0031,$0032,
$0033,$0034,$0035,$0036,$0037,$0038,$0039,$003A,$003B,$003C,$003D,$003E,$003F,
$0040,$0041,$0042,$0043,$0044,$0045,$0046,$0047,$0048,$0049,$004A,$004B,$004C,
$004D,$004E,$004F,$0050,$0051,$0052,$0053,$0054,$0055,$0056,$0057,$0058,$0059,
$005A,$005B,$005C,$005D,$005E,$005F,$0060,$0061,$0062,$0063,$0064,$0065,$0066,
$0067,$0068,$0069,$006A,$006B,$006C,$006D,$006E,$006F,$0070,$0071,$0072,$0073,
$0074,$0075,$0076,$0077,$0078,$0079,$007A,$007B,$007C,$007D,$007E,$007F,$00A4,
$00A7,$00A8,$00B0,$00B1,$00B7,$00D7,$00E0,$00E1,$00E8,$00E9,$00EA,$00EC,$00ED,
$00F2,$00F3,$00F7,$00F9,$00FA,$00FC,$0101,$0113,$011B,$012B,$0144,$0148,$014D,
$016B,$01CE,$01D0,$01D2,$01D4,$01D6,$01D8,$01DA,$01DC,$0251,$0261,$02C7,$02C9,
$02CA,$02CB,$02D9,$0391,$0392,$0393,$0394,$0395,$0396,$0397,$0398,$0399,$039A,
$039B,$039C,$039D,$039E,$039F,$03A0,$03A1,$03A3,$03A4,$03A5,$03A6,$03A7,$03A8,
$03A9,$03B1,$03B2,$03B3,$03B4,$03B5,$03B6,$03B7,$03B8,$03B9,$03BA,$03BB,$03BC,
$03BD,$03BE,$03BF,$03C0,$03C1,$03C3,$03C4,$03C5,$03C6,$03C7,$03C8,$03C9,$0401,
$0410,$0411,$0412,$0413,$0414,$0415,$0416,$0417,$0418,$0419,$041A,$041B,$041C,
$041D,$041E,$041F,$0420,$0421,$0422,$0423,$0424,$0425,$0426,$0427,$0428,$0429,
$042A,$042B,$042C,$042D,$042E,$042F,$0430,$0431,$0432,$0433,$0434,$0435,$0436,
$0437,$0438,$0439,$043A,$043B,$043C,$043D,$043E,$043F,$0440,$0441,$0442,$0443,
$0444,$0445,$0446,$0447,$0448,$0449,$044A,$044B,$044C,$044D,$044E,$044F,$0451,
$2010,$2013,$2014,$2015,$2016,$2018,$2019,$201C,$201D,$2025,$2026,$2030,$2032,
$2033,$2035,$203B,$20AC,$2103,$2105,$2109,$2116,$2121,$2160,$2161,$2162,$2163,
$2164,$2165,$2166,$2167,$2168,$2169,$216A,$216B,$2170,$2171,$2172,$2173,$2174,
$2175,$2176,$2177,$2178,$2179,$2190,$2191,$2192,$2193,$2196,$2197,$2198,$2199,
$2208,$220F,$2211,$2215,$221A,$221D,$221E,$221F,$2220,$2223,$2225,$2227,$2228,
$2229,$222A,$222B,$222E,$2234,$2235,$2236,$2237,$223D,$2248,$224C,$2252,$2260,
$2261,$2264,$2265,$2266,$2267,$226E,$226F,$2295,$2299,$22A5,$22BF,$2312,$2460,
$2461,$2462,$2463,$2464,$2465,$2466,$2467,$2468,$2469,$2474,$2475,$2476,$2477,
$2478,$2479,$247A,$247B,$247C,$247D,$247E,$247F,$2480,$2481,$2482,$2483,$2484,
$2485,$2486,$2487,$2488,$2489,$248A,$248B,$248C,$248D,$248E,$248F,$2490,$2491,
$2492,$2493,$2494,$2495,$2496,$2497,$2498,$2499,$249A,$249B,$2500,$2501,$2502,
$2503,$2504,$2505,$2506,$2507,$2508,$2509,$250A,$250B,$250C,$250D,$250E,$250F,
$2510,$2511,$2512,$2513,$2514,$2515,$2516,$2517,$2518,$2519,$251A,$251B,$251C,
$251D,$251E,$251F,$2520,$2521,$2522,$2523,$2524,$2525,$2526,$2527,$2528,$2529,
$252A,$252B,$252C,$252D,$252E,$252F,$2530,$2531,$2532,$2533,$2534,$2535,$2536,
$2537,$2538,$2539,$253A,$253B,$253C,$253D,$253E,$253F,$2540,$2541,$2542,$2543,
$2544,$2545,$2546,$2547,$2548,$2549,$254A,$254B,$2550,$2551,$2552,$2553,$2554,
$2555,$2556,$2557,$2558,$2559,$255A,$255B,$255C,$255D,$255E,$255F,$2560,$2561,
$2562,$2563,$2564,$2565,$2566,$2567,$2568,$2569,$256A,$256B,$256C,$256D,$256E,
$256F,$2570,$2571,$2572,$2573,$2581,$2582,$2583,$2584,$2585,$2586,$2587,$2588,
$2589,$258A,$258B,$258C,$258D,$258E,$258F,$2593,$2594,$2595,$25A0,$25A1,$25B2,
$25B3,$25BC,$25BD,$25C6,$25C7,$25CB,$25CE,$25CF,$25E2,$25E3,$25E4,$25E5,$2605,
$2606,$2609,$2640,$2642,$3000,$3001,$3002,$3003,$3005,$3006,$3007,$3008,$3009,
$300A,$300B,$300C,$300D,$300E,$300F,$3010,$3011,$3012,$3013,$3014,$3015,$3016,
$3017,$301D,$301E,$3021,$3022,$3023,$3024,$3025,$3026,$3027,$3028,$3029,$3041,
$3042,$3043,$3044,$3045,$3046,$3047,$3048,$3049,$304A,$304B,$304C,$304D,$304E,
$304F,$3050,$3051,$3052,$3053,$3054,$3055,$3056,$3057,$3058,$3059,$305A,$305B,
$305C,$305D,$305E,$305F,$3060,$3061,$3062,$3063,$3064,$3065,$3066,$3067,$3068,
$3069,$306A,$306B,$306C,$306D,$306E,$306F,$3070,$3071,$3072,$3073,$3074,$3075,
$3076,$3077,$3078,$3079,$307A,$307B,$307C,$307D,$307E,$307F,$3080,$3081,$3082,
$3083,$3084,$3085,$3086,$3087,$3088,$3089,$308A,$308B,$308C,$308D,$308E,$308F,
$3090,$3091,$3092,$3093,$309B,$309C,$309D,$309E,$30A1,$30A2,$30A3,$30A4,$30A5,
$30A6,$30A7,$30A8,$30A9,$30AA,$30AB,$30AC,$30AD,$30AE,$30AF,$30B0,$30B1,$30B2,
$30B3,$30B4,$30B5,$30B6,$30B7,$30B8,$30B9,$30BA,$30BB,$30BC,$30BD,$30BE,$30BF,
$30C0,$30C1,$30C2,$30C3,$30C4,$30C5,$30C6,$30C7,$30C8,$30C9,$30CA,$30CB,$30CC,
$30CD,$30CE,$30CF,$30D0,$30D1,$30D2,$30D3,$30D4,$30D5,$30D6,$30D7,$30D8,$30D9,
$30DA,$30DB,$30DC,$30DD,$30DE,$30DF,$30E0,$30E1,$30E2,$30E3,$30E4,$30E5,$30E6,
$30E7,$30E8,$30E9,$30EA,$30EB,$30EC,$30ED,$30EE,$30EF,$30F0,$30F1,$30F2,$30F3,
$30F4,$30F5,$30F6,$30FC,$30FD,$30FE,$3105,$3106,$3107,$3108,$3109,$310A,$310B,
$310C,$310D,$310E,$310F,$3110,$3111,$3112,$3113,$3114,$3115,$3116,$3117,$3118,
$3119,$311A,$311B,$311C,$311D,$311E,$311F,$3120,$3121,$3122,$3123,$3124,$3125,
$3126,$3127,$3128,$3129,$3220,$3221,$3222,$3223,$3224,$3225,$3226,$3227,$3228,
$3229,$3231,$32A3,$338E,$338F,$339C,$339D,$339E,$33A1,$33C4,$33CE,$33D1,$33D2,
$33D5,$4E00,$4E01,$4E02,$4E03,$4E04,$4E05,$4E06,$4E07,$4E08,$4E09,$4E0A,$4E0B,
$4E0C,$4E0D,$4E0E,$4E0F,$4E10,$4E11,$4E12,$4E13,$4E14,$4E15,$4E16,$4E17,$4E18,
$4E19,$4E1A,$4E1B,$4E1C,$4E1D,$4E1E,$4E1F,$4E20,$4E21,$4E22,$4E23,$4E24,$4E25,
$4E26,$4E27,$4E28,$4E29,$4E2A,$4E2B,$4E2C,$4E2D,$4E2E,$4E2F,$4E30,$4E31,$4E32,
$4E33,$4E34,$4E35,$4E36,$4E37,$4E38,$4E39,$4E3A,$4E3B,$4E3C,$4E3D,$4E3E,$4E3F,
$4E40,$4E41,$4E42,$4E43,$4E44,$4E45,$4E46,$4E47,$4E48,$4E49,$4E4A,$4E4B,$4E4C,
$4E4D,$4E4E,$4E4F,$4E50,$4E51,$4E52,$4E53,$4E54,$4E55,$4E56,$4E57,$4E58,$4E59,
$4E5A,$4E5B,$4E5C,$4E5D,$4E5E,$4E5F,$4E60,$4E61,$4E62,$4E63,$4E64,$4E65,$4E66,
$4E67,$4E68,$4E69,$4E6A,$4E6B,$4E6C,$4E6D,$4E6E,$4E6F,$4E70,$4E71,$4E72,$4E73,
$4E74,$4E75,$4E76,$4E77,$4E78,$4E79,$4E7A,$4E7B,$4E7C,$4E7D,$4E7E,$4E7F,$4E80,
$4E81,$4E82,$4E83,$4E84,$4E85,$4E86,$4E87,$4E88,$4E89,$4E8A,$4E8B,$4E8C,$4E8D,
$4E8E,$4E8F,$4E90,$4E91,$4E92,$4E93,$4E94,$4E95,$4E96,$4E97,$4E98,$4E99,$4E9A,
$4E9B,$4E9C,$4E9D,$4E9E,$4E9F,$4EA0,$4EA1,$4EA2,$4EA3,$4EA4,$4EA5,$4EA6,$4EA7,
$4EA8,$4EA9,$4EAA,$4EAB,$4EAC,$4EAD,$4EAE,$4EAF,$4EB0,$4EB1,$4EB2,$4EB3,$4EB4,
$4EB5,$4EB6,$4EB7,$4EB8,$4EB9,$4EBA,$4EBB,$4EBC,$4EBD,$4EBE,$4EBF,$4EC0,$4EC1,
$4EC2,$4EC3,$4EC4,$4EC5,$4EC6,$4EC7,$4EC8,$4EC9,$4ECA,$4ECB,$4ECC,$4ECD,$4ECE,
$4ECF,$4ED0,$4ED1,$4ED2,$4ED3,$4ED4,$4ED5,$4ED6,$4ED7,$4ED8,$4ED9,$4EDA,$4EDB,
$4EDC,$4EDD,$4EDE,$4EDF,$4EE0,$4EE1,$4EE2,$4EE3,$4EE4,$4EE5,$4EE6,$4EE7,$4EE8,
$4EE9,$4EEA,$4EEB,$4EEC,$4EED,$4EEE,$4EEF,$4EF0,$4EF1,$4EF2,$4EF3,$4EF4,$4EF5,
$4EF6,$4EF7,$4EF8,$4EF9,$4EFA,$4EFB,$4EFC,$4EFD,$4EFE,$4EFF,$4F00,$4F01,$4F02,
$4F03,$4F04,$4F05,$4F06,$4F07,$4F08,$4F09,$4F0A,$4F0B,$4F0C,$4F0D,$4F0E,$4F0F,
$4F10,$4F11,$4F12,$4F13,$4F14,$4F15,$4F16,$4F17,$4F18,$4F19,$4F1A,$4F1B,$4F1C,
$4F1D,$4F1E,$4F1F,$4F20,$4F21,$4F22,$4F23,$4F24,$4F25,$4F26,$4F27,$4F28,$4F29,
$4F2A,$4F2B,$4F2C,$4F2D,$4F2E,$4F2F,$4F30,$4F31,$4F32,$4F33,$4F34,$4F35,$4F36,
$4F37,$4F38,$4F39,$4F3A,$4F3B,$4F3C,$4F3D,$4F3E,$4F3F,$4F40,$4F41,$4F42,$4F43,
$4F44,$4F45,$4F46,$4F47,$4F48,$4F49,$4F4A,$4F4B,$4F4C,$4F4D,$4F4E,$4F4F,$4F50,
$4F51,$4F52,$4F53,$4F54,$4F55,$4F56,$4F57,$4F58,$4F59,$4F5A,$4F5B,$4F5C,$4F5D,
$4F5E,$4F5F,$4F60,$4F61,$4F62,$4F63,$4F64,$4F65,$4F66,$4F67,$4F68,$4F69,$4F6A,
$4F6B,$4F6C,$4F6D,$4F6E,$4F6F,$4F70,$4F71,$4F72,$4F73,$4F74,$4F75,$4F76,$4F77,
$4F78,$4F79,$4F7A,$4F7B,$4F7C,$4F7D,$4F7E,$4F7F,$4F80,$4F81,$4F82,$4F83,$4F84,
$4F85,$4F86,$4F87,$4F88,$4F89,$4F8A,$4F8B,$4F8C,$4F8D,$4F8E,$4F8F,$4F90,$4F91,
$4F92,$4F93,$4F94,$4F95,$4F96,$4F97,$4F98,$4F99,$4F9A,$4F9B,$4F9C,$4F9D,$4F9E,
$4F9F,$4FA0,$4FA1,$4FA2,$4FA3,$4FA4,$4FA5,$4FA6,$4FA7,$4FA8,$4FA9,$4FAA,$4FAB,
$4FAC,$4FAD,$4FAE,$4FAF,$4FB0,$4FB1,$4FB2,$4FB3,$4FB4,$4FB5,$4FB6,$4FB7,$4FB8,
$4FB9,$4FBA,$4FBB,$4FBC,$4FBD,$4FBE,$4FBF,$4FC0,$4FC1,$4FC2,$4FC3,$4FC4,$4FC5,
$4FC6,$4FC7,$4FC8,$4FC9,$4FCA,$4FCB,$4FCC,$4FCD,$4FCE,$4FCF,$4FD0,$4FD1,$4FD2,
$4FD3,$4FD4,$4FD5,$4FD6,$4FD7,$4FD8,$4FD9,$4FDA,$4FDB,$4FDC,$4FDD,$4FDE,$4FDF,
$4FE0,$4FE1,$4FE2,$4FE3,$4FE4,$4FE5,$4FE6,$4FE7,$4FE8,$4FE9,$4FEA,$4FEB,$4FEC,
$4FED,$4FEE,$4FEF,$4FF0,$4FF1,$4FF2,$4FF3,$4FF4,$4FF5,$4FF6,$4FF7,$4FF8,$4FF9,
$4FFA,$4FFB,$4FFC,$4FFD,$4FFE,$4FFF,$5000,$5001,$5002,$5003,$5004,$5005,$5006,
$5007,$5008,$5009,$500A,$500B,$500C,$500D,$500E,$500F,$5010,$5011,$5012,$5013,
$5014,$5015,$5016,$5017,$5018,$5019,$501A,$501B,$501C,$501D,$501E,$501F,$5020,
$5021,$5022,$5023,$5024,$5025,$5026,$5027,$5028,$5029,$502A,$502B,$502C,$502D,
$502E,$502F,$5030,$5031,$5032,$5033,$5034,$5035,$5036,$5037,$5038,$5039,$503A,
$503B,$503C,$503D,$503E,$503F,$5040,$5041,$5042,$5043,$5044,$5045,$5046,$5047,
$5048,$5049,$504A,$504B,$504C,$504D,$504E,$504F,$5050,$5051,$5052,$5053,$5054,
$5055,$5056,$5057,$5058,$5059,$505A,$505B,$505C,$505D,$505E,$505F,$5060,$5061,
$5062,$5063,$5064,$5065,$5066,$5067,$5068,$5069,$506A,$506B,$506C,$506D,$506E,
$506F,$5070,$5071,$5072,$5073,$5074,$5075,$5076,$5077,$5078,$5079,$507A,$507B,
$507C,$507D,$507E,$507F,$5080,$5081,$5082,$5083,$5084,$5085,$5086,$5087,$5088,
$5089,$508A,$508B,$508C,$508D,$508E,$508F,$5090,$5091,$5092,$5093,$5094,$5095,
$5096,$5097,$5098,$5099,$509A,$509B,$509C,$509D,$509E,$509F,$50A0,$50A1,$50A2,
$50A3,$50A4,$50A5,$50A6,$50A7,$50A8,$50A9,$50AA,$50AB,$50AC,$50AD,$50AE,$50AF,
$50B0,$50B1,$50B2,$50B3,$50B4,$50B5,$50B6,$50B7,$50B8,$50B9,$50BA,$50BB,$50BC,
$50BD,$50BE,$50BF,$50C0,$50C1,$50C2,$50C3,$50C4,$50C5,$50C6,$50C7,$50C8,$50C9,
$50CA,$50CB,$50CC,$50CD,$50CE,$50CF,$50D0,$50D1,$50D2,$50D3,$50D4,$50D5,$50D6,
$50D7,$50D8,$50D9,$50DA,$50DB,$50DC,$50DD,$50DE,$50DF,$50E0,$50E1,$50E2,$50E3,
$50E4,$50E5,$50E6,$50E7,$50E8,$50E9,$50EA,$50EB,$50EC,$50ED,$50EE,$50EF,$50F0,
$50F1,$50F2,$50F3,$50F4,$50F5,$50F6,$50F7,$50F8,$50F9,$50FA,$50FB,$50FC,$50FD,
$50FE,$50FF,$5100,$5101,$5102,$5103,$5104,$5105,$5106,$5107,$5108,$5109,$510A,
$510B,$510C,$510D,$510E,$510F,$5110,$5111,$5112,$5113,$5114,$5115,$5116,$5117,
$5118,$5119,$511A,$511B,$511C,$511D,$511E,$511F,$5120,$5121,$5122,$5123,$5124,
$5125,$5126,$5127,$5128,$5129,$512A,$512B,$512C,$512D,$512E,$512F,$5130,$5131,
$5132,$5133,$5134,$5135,$5136,$5137,$5138,$5139,$513A,$513B,$513C,$513D,$513E,
$513F,$5140,$5141,$5142,$5143,$5144,$5145,$5146,$5147,$5148,$5149,$514A,$514B,
$514C,$514D,$514E,$514F,$5150,$5151,$5152,$5153,$5154,$5155,$5156,$5157,$5158,
$5159,$515A,$515B,$515C,$515D,$515E,$515F,$5160,$5161,$5162,$5163,$5164,$5165,
$5166,$5167,$5168,$5169,$516A,$516B,$516C,$516D,$516E,$516F,$5170,$5171,$5172,
$5173,$5174,$5175,$5176,$5177,$5178,$5179,$517A,$517B,$517C,$517D,$517E,$517F,
$5180,$5181,$5182,$5183,$5184,$5185,$5186,$5187,$5188,$5189,$518A,$518B,$518C,
$518D,$518E,$518F,$5190,$5191,$5192,$5193,$5194,$5195,$5196,$5197,$5198,$5199,
$519A,$519B,$519C,$519D,$519E,$519F,$51A0,$51A1,$51A2,$51A3,$51A4,$51A5,$51A6,
$51A7,$51A8,$51A9,$51AA,$51AB,$51AC,$51AD,$51AE,$51AF,$51B0,$51B1,$51B2,$51B3,
$51B4,$51B5,$51B6,$51B7,$51B8,$51B9,$51BA,$51BB,$51BC,$51BD,$51BE,$51BF,$51C0,
$51C1,$51C2,$51C3,$51C4,$51C5,$51C6,$51C7,$51C8,$51C9,$51CA,$51CB,$51CC,$51CD,
$51CE,$51CF,$51D0,$51D1,$51D2,$51D3,$51D4,$51D5,$51D6,$51D7,$51D8,$51D9,$51DA,
$51DB,$51DC,$51DD,$51DE,$51DF,$51E0,$51E1,$51E2,$51E3,$51E4,$51E5,$51E6,$51E7,
$51E8,$51E9,$51EA,$51EB,$51EC,$51ED,$51EE,$51EF,$51F0,$51F1,$51F2,$51F3,$51F4,
$51F5,$51F6,$51F7,$51F8,$51F9,$51FA,$51FB,$51FC,$51FD,$51FE,$51FF,$5200,$5201,
$5202,$5203,$5204,$5205,$5206,$5207,$5208,$5209,$520A,$520B,$520C,$520D,$520E,
$520F,$5210,$5211,$5212,$5213,$5214,$5215,$5216,$5217,$5218,$5219,$521A,$521B,
$521C,$521D,$521E,$521F,$5220,$5221,$5222,$5223,$5224,$5225,$5226,$5227,$5228,
$5229,$522A,$522B,$522C,$522D,$522E,$522F,$5230,$5231,$5232,$5233,$5234,$5235,
$5236,$5237,$5238,$5239,$523A,$523B,$523C,$523D,$523E,$523F,$5240,$5241,$5242,
$5243,$5244,$5245,$5246,$5247,$5248,$5249,$524A,$524B,$524C,$524D,$524E,$524F,
$5250,$5251,$5252,$5253,$5254,$5255,$5256,$5257,$5258,$5259,$525A,$525B,$525C,
$525D,$525E,$525F,$5260,$5261,$5262,$5263,$5264,$5265,$5266,$5267,$5268,$5269,
$526A,$526B,$526C,$526D,$526E,$526F,$5270,$5271,$5272,$5273,$5274,$5275,$5276,
$5277,$5278,$5279,$527A,$527B,$527C,$527D,$527E,$527F,$5280,$5281,$5282,$5283,
$5284,$5285,$5286,$5287,$5288,$5289,$528A,$528B,$528C,$528D,$528E,$528F,$5290,
$5291,$5292,$5293,$5294,$5295,$5296,$5297,$5298,$5299,$529A,$529B,$529C,$529D,
$529E,$529F,$52A0,$52A1,$52A2,$52A3,$52A4,$52A5,$52A6,$52A7,$52A8,$52A9,$52AA,
$52AB,$52AC,$52AD,$52AE,$52AF,$52B0,$52B1,$52B2,$52B3,$52B4,$52B5,$52B6,$52B7,
$52B8,$52B9,$52BA,$52BB,$52BC,$52BD,$52BE,$52BF,$52C0,$52C1,$52C2,$52C3,$52C4,
$52C5,$52C6,$52C7,$52C8,$52C9,$52CA,$52CB,$52CC,$52CD,$52CE,$52CF,$52D0,$52D1,
$52D2,$52D3,$52D4,$52D5,$52D6,$52D7,$52D8,$52D9,$52DA,$52DB,$52DC,$52DD,$52DE,
$52DF,$52E0,$52E1,$52E2,$52E3,$52E4,$52E5,$52E6,$52E7,$52E8,$52E9,$52EA,$52EB,
$52EC,$52ED,$52EE,$52EF,$52F0,$52F1,$52F2,$52F3,$52F4,$52F5,$52F6,$52F7,$52F8,
$52F9,$52FA,$52FB,$52FC,$52FD,$52FE,$52FF,$5300,$5301,$5302,$5303,$5304,$5305,
$5306,$5307,$5308,$5309,$530A,$530B,$530C,$530D,$530E,$530F,$5310,$5311,$5312,
$5313,$5314,$5315,$5316,$5317,$5318,$5319,$531A,$531B,$531C,$531D,$531E,$531F,
$5320,$5321,$5322,$5323,$5324,$5325,$5326,$5327,$5328,$5329,$532A,$532B,$532C,
$532D,$532E,$532F,$5330,$5331,$5332,$5333,$5334,$5335,$5336,$5337,$5338,$5339,
$533A,$533B,$533C,$533D,$533E,$533F,$5340,$5341,$5342,$5343,$5344,$5345,$5346,
$5347,$5348,$5349,$534A,$534B,$534C,$534D,$534E,$534F,$5350,$5351,$5352,$5353,
$5354,$5355,$5356,$5357,$5358,$5359,$535A,$535B,$535C,$535D,$535E,$535F,$5360,
$5361,$5362,$5363,$5364,$5365,$5366,$5367,$5368,$5369,$536A,$536B,$536C,$536D,
$536E,$536F,$5370,$5371,$5372,$5373,$5374,$5375,$5376,$5377,$5378,$5379,$537A,
$537B,$537C,$537D,$537E,$537F,$5380,$5381,$5382,$5383,$5384,$5385,$5386,$5387,
$5388,$5389,$538A,$538B,$538C,$538D,$538E,$538F,$5390,$5391,$5392,$5393,$5394,
$5395,$5396,$5397,$5398,$5399,$539A,$539B,$539C,$539D,$539E,$539F,$53A0,$53A1,
$53A2,$53A3,$53A4,$53A5,$53A6,$53A7,$53A8,$53A9,$53AA,$53AB,$53AC,$53AD,$53AE,
$53AF,$53B0,$53B1,$53B2,$53B3,$53B4,$53B5,$53B6,$53B7,$53B8,$53B9,$53BA,$53BB,
$53BC,$53BD,$53BE,$53BF,$53C0,$53C1,$53C2,$53C3,$53C4,$53C5,$53C6,$53C7,$53C8,
$53C9,$53CA,$53CB,$53CC,$53CD,$53CE,$53CF,$53D0,$53D1,$53D2,$53D3,$53D4,$53D5,
$53D6,$53D7,$53D8,$53D9,$53DA,$53DB,$53DC,$53DD,$53DE,$53DF,$53E0,$53E1,$53E2,
$53E3,$53E4,$53E5,$53E6,$53E7,$53E8,$53E9,$53EA,$53EB,$53EC,$53ED,$53EE,$53EF,
$53F0,$53F1,$53F2,$53F3,$53F4,$53F5,$53F6,$53F7,$53F8,$53F9,$53FA,$53FB,$53FC,
$53FD,$53FE,$53FF,$5400,$5401,$5402,$5403,$5404,$5405,$5406,$5407,$5408,$5409,
$540A,$540B,$540C,$540D,$540E,$540F,$5410,$5411,$5412,$5413,$5414,$5415,$5416,
$5417,$5418,$5419,$541A,$541B,$541C,$541D,$541E,$541F,$5420,$5421,$5422,$5423,
$5424,$5425,$5426,$5427,$5428,$5429,$542A,$542B,$542C,$542D,$542E,$542F,$5430,
$5431,$5432,$5433,$5434,$5435,$5436,$5437,$5438,$5439,$543A,$543B,$543C,$543D,
$543E,$543F,$5440,$5441,$5442,$5443,$5444,$5445,$5446,$5447,$5448,$5449,$544A,
$544B,$544C,$544D,$544E,$544F,$5450,$5451,$5452,$5453,$5454,$5455,$5456,$5457,
$5458,$5459,$545A,$545B,$545C,$545D,$545E,$545F,$5460,$5461,$5462,$5463,$5464,
$5465,$5466,$5467,$5468,$5469,$546A,$546B,$546C,$546D,$546E,$546F,$5470,$5471,
$5472,$5473,$5474,$5475,$5476,$5477,$5478,$5479,$547A,$547B,$547C,$547D,$547E,
$547F,$5480,$5481,$5482,$5483,$5484,$5485,$5486,$5487,$5488,$5489,$548A,$548B,
$548C,$548D,$548E,$548F,$5490,$5491,$5492,$5493,$5494,$5495,$5496,$5497,$5498,
$5499,$549A,$549B,$549C,$549D,$549E,$549F,$54A0,$54A1,$54A2,$54A3,$54A4,$54A5,
$54A6,$54A7,$54A8,$54A9,$54AA,$54AB,$54AC,$54AD,$54AE,$54AF,$54B0,$54B1,$54B2,
$54B3,$54B4,$54B5,$54B6,$54B7,$54B8,$54B9,$54BA,$54BB,$54BC,$54BD,$54BE,$54BF,
$54C0,$54C1,$54C2,$54C3,$54C4,$54C5,$54C6,$54C7,$54C8,$54C9,$54CA,$54CB,$54CC,
$54CD,$54CE,$54CF,$54D0,$54D1,$54D2,$54D3,$54D4,$54D5,$54D6,$54D7,$54D8,$54D9,
$54DA,$54DB,$54DC,$54DD,$54DE,$54DF,$54E0,$54E1,$54E2,$54E3,$54E4,$54E5,$54E6,
$54E7,$54E8,$54E9,$54EA,$54EB,$54EC,$54ED,$54EE,$54EF,$54F0,$54F1,$54F2,$54F3,
$54F4,$54F5,$54F6,$54F7,$54F8,$54F9,$54FA,$54FB,$54FC,$54FD,$54FE,$54FF,$5500,
$5501,$5502,$5503,$5504,$5505,$5506,$5507,$5508,$5509,$550A,$550B,$550C,$550D,
$550E,$550F,$5510,$5511,$5512,$5513,$5514,$5515,$5516,$5517,$5518,$5519,$551A,
$551B,$551C,$551D,$551E,$551F,$5520,$5521,$5522,$5523,$5524,$5525,$5526,$5527,
$5528,$5529,$552A,$552B,$552C,$552D,$552E,$552F,$5530,$5531,$5532,$5533,$5534,
$5535,$5536,$5537,$5538,$5539,$553A,$553B,$553C,$553D,$553E,$553F,$5540,$5541,
$5542,$5543,$5544,$5545,$5546,$5547,$5548,$5549,$554A,$554B,$554C,$554D,$554E,
$554F,$5550,$5551,$5552,$5553,$5554,$5555,$5556,$5557,$5558,$5559,$555A,$555B,
$555C,$555D,$555E,$555F,$5560,$5561,$5562,$5563,$5564,$5565,$5566,$5567,$5568,
$5569,$556A,$556B,$556C,$556D,$556E,$556F,$5570,$5571,$5572,$5573,$5574,$5575,
$5576,$5577,$5578,$5579,$557A,$557B,$557C,$557D,$557E,$557F,$5580,$5581,$5582,
$5583,$5584,$5585,$5586,$5587,$5588,$5589,$558A,$558B,$558C,$558D,$558E,$558F,
$5590,$5591,$5592,$5593,$5594,$5595,$5596,$5597,$5598,$5599,$559A,$559B,$559C,
$559D,$559E,$559F,$55A0,$55A1,$55A2,$55A3,$55A4,$55A5,$55A6,$55A7,$55A8,$55A9,
$55AA,$55AB,$55AC,$55AD,$55AE,$55AF,$55B0,$55B1,$55B2,$55B3,$55B4,$55B5,$55B6,
$55B7,$55B8,$55B9,$55BA,$55BB,$55BC,$55BD,$55BE,$55BF,$55C0,$55C1,$55C2,$55C3,
$55C4,$55C5,$55C6,$55C7,$55C8,$55C9,$55CA,$55CB,$55CC,$55CD,$55CE,$55CF,$55D0,
$55D1,$55D2,$55D3,$55D4,$55D5,$55D6,$55D7,$55D8,$55D9,$55DA,$55DB,$55DC,$55DD,
$55DE,$55DF,$55E0,$55E1,$55E2,$55E3,$55E4,$55E5,$55E6,$55E7,$55E8,$55E9,$55EA,
$55EB,$55EC,$55ED,$55EE,$55EF,$55F0,$55F1,$55F2,$55F3,$55F4,$55F5,$55F6,$55F7,
$55F8,$55F9,$55FA,$55FB,$55FC,$55FD,$55FE,$55FF,$5600,$5601,$5602,$5603,$5604,
$5605,$5606,$5607,$5608,$5609,$560A,$560B,$560C,$560D,$560E,$560F,$5610,$5611,
$5612,$5613,$5614,$5615,$5616,$5617,$5618,$5619,$561A,$561B,$561C,$561D,$561E,
$561F,$5620,$5621,$5622,$5623,$5624,$5625,$5626,$5627,$5628,$5629,$562A,$562B,
$562C,$562D,$562E,$562F,$5630,$5631,$5632,$5633,$5634,$5635,$5636,$5637,$5638,
$5639,$563A,$563B,$563C,$563D,$563E,$563F,$5640,$5641,$5642,$5643,$5644,$5645,
$5646,$5647,$5648,$5649,$564A,$564B,$564C,$564D,$564E,$564F,$5650,$5651,$5652,
$5653,$5654,$5655,$5656,$5657,$5658,$5659,$565A,$565B,$565C,$565D,$565E,$565F,
$5660,$5661,$5662,$5663,$5664,$5665,$5666,$5667,$5668,$5669,$566A,$566B,$566C,
$566D,$566E,$566F,$5670,$5671,$5672,$5673,$5674,$5675,$5676,$5677,$5678,$5679,
$567A,$567B,$567C,$567D,$567E,$567F,$5680,$5681,$5682,$5683,$5684,$5685,$5686,
$5687,$5688,$5689,$568A,$568B,$568C,$568D,$568E,$568F,$5690,$5691,$5692,$5693,
$5694,$5695,$5696,$5697,$5698,$5699,$569A,$569B,$569C,$569D,$569E,$569F,$56A0,
$56A1,$56A2,$56A3,$56A4,$56A5,$56A6,$56A7,$56A8,$56A9,$56AA,$56AB,$56AC,$56AD,
$56AE,$56AF,$56B0,$56B1,$56B2,$56B3,$56B4,$56B5,$56B6,$56B7,$56B8,$56B9,$56BA,
$56BB,$56BC,$56BD,$56BE,$56BF,$56C0,$56C1,$56C2,$56C3,$56C4,$56C5,$56C6,$56C7,
$56C8,$56C9,$56CA,$56CB,$56CC,$56CD,$56CE,$56CF,$56D0,$56D1,$56D2,$56D3,$56D4,
$56D5,$56D6,$56D7,$56D8,$56D9,$56DA,$56DB,$56DC,$56DD,$56DE,$56DF,$56E0,$56E1,
$56E2,$56E3,$56E4,$56E5,$56E6,$56E7,$56E8,$56E9,$56EA,$56EB,$56EC,$56ED,$56EE,
$56EF,$56F0,$56F1,$56F2,$56F3,$56F4,$56F5,$56F6,$56F7,$56F8,$56F9,$56FA,$56FB,
$56FC,$56FD,$56FE,$56FF,$5700,$5701,$5702,$5703,$5704,$5705,$5706,$5707,$5708,
$5709,$570A,$570B,$570C,$570D,$570E,$570F,$5710,$5711,$5712,$5713,$5714,$5715,
$5716,$5717,$5718,$5719,$571A,$571B,$571C,$571D,$571E,$571F,$5720,$5721,$5722,
$5723,$5724,$5725,$5726,$5727,$5728,$5729,$572A,$572B,$572C,$572D,$572E,$572F,
$5730,$5731,$5732,$5733,$5734,$5735,$5736,$5737,$5738,$5739,$573A,$573B,$573C,
$573D,$573E,$573F,$5740,$5741,$5742,$5743,$5744,$5745,$5746,$5747,$5748,$5749,
$574A,$574B,$574C,$574D,$574E,$574F,$5750,$5751,$5752,$5753,$5754,$5755,$5756,
$5757,$5758,$5759,$575A,$575B,$575C,$575D,$575E,$575F,$5760,$5761,$5762,$5763,
$5764,$5765,$5766,$5767,$5768,$5769,$576A,$576B,$576C,$576D,$576E,$576F,$5770,
$5771,$5772,$5773,$5774,$5775,$5776,$5777,$5778,$5779,$577A,$577B,$577C,$577D,
$577E,$577F,$5780,$5781,$5782,$5783,$5784,$5785,$5786,$5787,$5788,$5789,$578A,
$578B,$578C,$578D,$578E,$578F,$5790,$5791,$5792,$5793,$5794,$5795,$5796,$5797,
$5798,$5799,$579A,$579B,$579C,$579D,$579E,$579F,$57A0,$57A1,$57A2,$57A3,$57A4,
$57A5,$57A6,$57A7,$57A8,$57A9,$57AA,$57AB,$57AC,$57AD,$57AE,$57AF,$57B0,$57B1,
$57B2,$57B3,$57B4,$57B5,$57B6,$57B7,$57B8,$57B9,$57BA,$57BB,$57BC,$57BD,$57BE,
$57BF,$57C0,$57C1,$57C2,$57C3,$57C4,$57C5,$57C6,$57C7,$57C8,$57C9,$57CA,$57CB,
$57CC,$57CD,$57CE,$57CF,$57D0,$57D1,$57D2,$57D3,$57D4,$57D5,$57D6,$57D7,$57D8,
$57D9,$57DA,$57DB,$57DC,$57DD,$57DE,$57DF,$57E0,$57E1,$57E2,$57E3,$57E4,$57E5,
$57E6,$57E7,$57E8,$57E9,$57EA,$57EB,$57EC,$57ED,$57EE,$57EF,$57F0,$57F1,$57F2,
$57F3,$57F4,$57F5,$57F6,$57F7,$57F8,$57F9,$57FA,$57FB,$57FC,$57FD,$57FE,$57FF,
$5800,$5801,$5802,$5803,$5804,$5805,$5806,$5807,$5808,$5809,$580A,$580B,$580C,
$580D,$580E,$580F,$5810,$5811,$5812,$5813,$5814,$5815,$5816,$5817,$5818,$5819,
$581A,$581B,$581C,$581D,$581E,$581F,$5820,$5821,$5822,$5823,$5824,$5825,$5826,
$5827,$5828,$5829,$582A,$582B,$582C,$582D,$582E,$582F,$5830,$5831,$5832,$5833,
$5834,$5835,$5836,$5837,$5838,$5839,$583A,$583B,$583C,$583D,$583E,$583F,$5840,
$5841,$5842,$5843,$5844,$5845,$5846,$5847,$5848,$5849,$584A,$584B,$584C,$584D,
$584E,$584F,$5850,$5851,$5852,$5853,$5854,$5855,$5856,$5857,$5858,$5859,$585A,
$585B,$585C,$585D,$585E,$585F,$5860,$5861,$5862,$5863,$5864,$5865,$5866,$5867,
$5868,$5869,$586A,$586B,$586C,$586D,$586E,$586F,$5870,$5871,$5872,$5873,$5874,
$5875,$5876,$5877,$5878,$5879,$587A,$587B,$587C,$587D,$587E,$587F,$5880,$5881,
$5882,$5883,$5884,$5885,$5886,$5887,$5888,$5889,$588A,$588B,$588C,$588D,$588E,
$588F,$5890,$5891,$5892,$5893,$5894,$5895,$5896,$5897,$5898,$5899,$589A,$589B,
$589C,$589D,$589E,$589F,$58A0,$58A1,$58A2,$58A3,$58A4,$58A5,$58A6,$58A7,$58A8,
$58A9,$58AA,$58AB,$58AC,$58AD,$58AE,$58AF,$58B0,$58B1,$58B2,$58B3,$58B4,$58B5,
$58B6,$58B7,$58B8,$58B9,$58BA,$58BB,$58BC,$58BD,$58BE,$58BF,$58C0,$58C1,$58C2,
$58C3,$58C4,$58C5,$58C6,$58C7,$58C8,$58C9,$58CA,$58CB,$58CC,$58CD,$58CE,$58CF,
$58D0,$58D1,$58D2,$58D3,$58D4,$58D5,$58D6,$58D7,$58D8,$58D9,$58DA,$58DB,$58DC,
$58DD,$58DE,$58DF,$58E0,$58E1,$58E2,$58E3,$58E4,$58E5,$58E6,$58E7,$58E8,$58E9,
$58EA,$58EB,$58EC,$58ED,$58EE,$58EF,$58F0,$58F1,$58F2,$58F3,$58F4,$58F5,$58F6,
$58F7,$58F8,$58F9,$58FA,$58FB,$58FC,$58FD,$58FE,$58FF,$5900,$5901,$5902,$5903,
$5904,$5905,$5906,$5907,$5908,$5909,$590A,$590B,$590C,$590D,$590E,$590F,$5910,
$5911,$5912,$5913,$5914,$5915,$5916,$5917,$5918,$5919,$591A,$591B,$591C,$591D,
$591E,$591F,$5920,$5921,$5922,$5923,$5924,$5925,$5926,$5927,$5928,$5929,$592A,
$592B,$592C,$592D,$592E,$592F,$5930,$5931,$5932,$5933,$5934,$5935,$5936,$5937,
$5938,$5939,$593A,$593B,$593C,$593D,$593E,$593F,$5940,$5941,$5942,$5943,$5944,
$5945,$5946,$5947,$5948,$5949,$594A,$594B,$594C,$594D,$594E,$594F,$5950,$5951,
$5952,$5953,$5954,$5955,$5956,$5957,$5958,$5959,$595A,$595B,$595C,$595D,$595E,
$595F,$5960,$5961,$5962,$5963,$5964,$5965,$5966,$5967,$5968,$5969,$596A,$596B,
$596C,$596D,$596E,$596F,$5970,$5971,$5972,$5973,$5974,$5975,$5976,$5977,$5978,
$5979,$597A,$597B,$597C,$597D,$597E,$597F,$5980,$5981,$5982,$5983,$5984,$5985,
$5986,$5987,$5988,$5989,$598A,$598B,$598C,$598D,$598E,$598F,$5990,$5991,$5992,
$5993,$5994,$5995,$5996,$5997,$5998,$5999,$599A,$599B,$599C,$599D,$599E,$599F,
$59A0,$59A1,$59A2,$59A3,$59A4,$59A5,$59A6,$59A7,$59A8,$59A9,$59AA,$59AB,$59AC,
$59AD,$59AE,$59AF,$59B0,$59B1,$59B2,$59B3,$59B4,$59B5,$59B6,$59B7,$59B8,$59B9,
$59BA,$59BB,$59BC,$59BD,$59BE,$59BF,$59C0,$59C1,$59C2,$59C3,$59C4,$59C5,$59C6,
$59C7,$59C8,$59C9,$59CA,$59CB,$59CC,$59CD,$59CE,$59CF,$59D0,$59D1,$59D2,$59D3,
$59D4,$59D5,$59D6,$59D7,$59D8,$59D9,$59DA,$59DB,$59DC,$59DD,$59DE,$59DF,$59E0,
$59E1,$59E2,$59E3,$59E4,$59E5,$59E6,$59E7,$59E8,$59E9,$59EA,$59EB,$59EC,$59ED,
$59EE,$59EF,$59F0,$59F1,$59F2,$59F3,$59F4,$59F5,$59F6,$59F7,$59F8,$59F9,$59FA,
$59FB,$59FC,$59FD,$59FE,$59FF,$5A00,$5A01,$5A02,$5A03,$5A04,$5A05,$5A06,$5A07,
$5A08,$5A09,$5A0A,$5A0B,$5A0C,$5A0D,$5A0E,$5A0F,$5A10,$5A11,$5A12,$5A13,$5A14,
$5A15,$5A16,$5A17,$5A18,$5A19,$5A1A,$5A1B,$5A1C,$5A1D,$5A1E,$5A1F,$5A20,$5A21,
$5A22,$5A23,$5A24,$5A25,$5A26,$5A27,$5A28,$5A29,$5A2A,$5A2B,$5A2C,$5A2D,$5A2E,
$5A2F,$5A30,$5A31,$5A32,$5A33,$5A34,$5A35,$5A36,$5A37,$5A38,$5A39,$5A3A,$5A3B,
$5A3C,$5A3D,$5A3E,$5A3F,$5A40,$5A41,$5A42,$5A43,$5A44,$5A45,$5A46,$5A47,$5A48,
$5A49,$5A4A,$5A4B,$5A4C,$5A4D,$5A4E,$5A4F,$5A50,$5A51,$5A52,$5A53,$5A54,$5A55,
$5A56,$5A57,$5A58,$5A59,$5A5A,$5A5B,$5A5C,$5A5D,$5A5E,$5A5F,$5A60,$5A61,$5A62,
$5A63,$5A64,$5A65,$5A66,$5A67,$5A68,$5A69,$5A6A,$5A6B,$5A6C,$5A6D,$5A6E,$5A6F,
$5A70,$5A71,$5A72,$5A73,$5A74,$5A75,$5A76,$5A77,$5A78,$5A79,$5A7A,$5A7B,$5A7C,
$5A7D,$5A7E,$5A7F,$5A80,$5A81,$5A82,$5A83,$5A84,$5A85,$5A86,$5A87,$5A88,$5A89,
$5A8A,$5A8B,$5A8C,$5A8D,$5A8E,$5A8F,$5A90,$5A91,$5A92,$5A93,$5A94,$5A95,$5A96,
$5A97,$5A98,$5A99,$5A9A,$5A9B,$5A9C,$5A9D,$5A9E,$5A9F,$5AA0,$5AA1,$5AA2,$5AA3,
$5AA4,$5AA5,$5AA6,$5AA7,$5AA8,$5AA9,$5AAA,$5AAB,$5AAC,$5AAD,$5AAE,$5AAF,$5AB0,
$5AB1,$5AB2,$5AB3,$5AB4,$5AB5,$5AB6,$5AB7,$5AB8,$5AB9,$5ABA,$5ABB,$5ABC,$5ABD,
$5ABE,$5ABF,$5AC0,$5AC1,$5AC2,$5AC3,$5AC4,$5AC5,$5AC6,$5AC7,$5AC8,$5AC9,$5ACA,
$5ACB,$5ACC,$5ACD,$5ACE,$5ACF,$5AD0,$5AD1,$5AD2,$5AD3,$5AD4,$5AD5,$5AD6,$5AD7,
$5AD8,$5AD9,$5ADA,$5ADB,$5ADC,$5ADD,$5ADE,$5ADF,$5AE0,$5AE1,$5AE2,$5AE3,$5AE4,
$5AE5,$5AE6,$5AE7,$5AE8,$5AE9,$5AEA,$5AEB,$5AEC,$5AED,$5AEE,$5AEF,$5AF0,$5AF1,
$5AF2,$5AF3,$5AF4,$5AF5,$5AF6,$5AF7,$5AF8,$5AF9,$5AFA,$5AFB,$5AFC,$5AFD,$5AFE,
$5AFF,$5B00,$5B01,$5B02,$5B03,$5B04,$5B05,$5B06,$5B07,$5B08,$5B09,$5B0A,$5B0B,
$5B0C,$5B0D,$5B0E,$5B0F,$5B10,$5B11,$5B12,$5B13,$5B14,$5B15,$5B16,$5B17,$5B18,
$5B19,$5B1A,$5B1B,$5B1C,$5B1D,$5B1E,$5B1F,$5B20,$5B21,$5B22,$5B23,$5B24,$5B25,
$5B26,$5B27,$5B28,$5B29,$5B2A,$5B2B,$5B2C,$5B2D,$5B2E,$5B2F,$5B30,$5B31,$5B32,
$5B33,$5B34,$5B35,$5B36,$5B37,$5B38,$5B39,$5B3A,$5B3B,$5B3C,$5B3D,$5B3E,$5B3F,
$5B40,$5B41,$5B42,$5B43,$5B44,$5B45,$5B46,$5B47,$5B48,$5B49,$5B4A,$5B4B,$5B4C,
$5B4D,$5B4E,$5B4F,$5B50,$5B51,$5B52,$5B53,$5B54,$5B55,$5B56,$5B57,$5B58,$5B59,
$5B5A,$5B5B,$5B5C,$5B5D,$5B5E,$5B5F,$5B60,$5B61,$5B62,$5B63,$5B64,$5B65,$5B66,
$5B67,$5B68,$5B69,$5B6A,$5B6B,$5B6C,$5B6D,$5B6E,$5B6F,$5B70,$5B71,$5B72,$5B73,
$5B74,$5B75,$5B76,$5B77,$5B78,$5B79,$5B7A,$5B7B,$5B7C,$5B7D,$5B7E,$5B7F,$5B80,
$5B81,$5B82,$5B83,$5B84,$5B85,$5B86,$5B87,$5B88,$5B89,$5B8A,$5B8B,$5B8C,$5B8D,
$5B8E,$5B8F,$5B90,$5B91,$5B92,$5B93,$5B94,$5B95,$5B96,$5B97,$5B98,$5B99,$5B9A,
$5B9B,$5B9C,$5B9D,$5B9E,$5B9F,$5BA0,$5BA1,$5BA2,$5BA3,$5BA4,$5BA5,$5BA6,$5BA7,
$5BA8,$5BA9,$5BAA,$5BAB,$5BAC,$5BAD,$5BAE,$5BAF,$5BB0,$5BB1,$5BB2,$5BB3,$5BB4,
$5BB5,$5BB6,$5BB7,$5BB8,$5BB9,$5BBA,$5BBB,$5BBC,$5BBD,$5BBE,$5BBF,$5BC0,$5BC1,
$5BC2,$5BC3,$5BC4,$5BC5,$5BC6,$5BC7,$5BC8,$5BC9,$5BCA,$5BCB,$5BCC,$5BCD,$5BCE,
$5BCF,$5BD0,$5BD1,$5BD2,$5BD3,$5BD4,$5BD5,$5BD6,$5BD7,$5BD8,$5BD9,$5BDA,$5BDB,
$5BDC,$5BDD,$5BDE,$5BDF,$5BE0,$5BE1,$5BE2,$5BE3,$5BE4,$5BE5,$5BE6,$5BE7,$5BE8,
$5BE9,$5BEA,$5BEB,$5BEC,$5BED,$5BEE,$5BEF,$5BF0,$5BF1,$5BF2,$5BF3,$5BF4,$5BF5,
$5BF6,$5BF7,$5BF8,$5BF9,$5BFA,$5BFB,$5BFC,$5BFD,$5BFE,$5BFF,$5C00,$5C01,$5C02,
$5C03,$5C04,$5C05,$5C06,$5C07,$5C08,$5C09,$5C0A,$5C0B,$5C0C,$5C0D,$5C0E,$5C0F,
$5C10,$5C11,$5C12,$5C13,$5C14,$5C15,$5C16,$5C17,$5C18,$5C19,$5C1A,$5C1B,$5C1C,
$5C1D,$5C1E,$5C1F,$5C20,$5C21,$5C22,$5C23,$5C24,$5C25,$5C26,$5C27,$5C28,$5C29,
$5C2A,$5C2B,$5C2C,$5C2D,$5C2E,$5C2F,$5C30,$5C31,$5C32,$5C33,$5C34,$5C35,$5C36,
$5C37,$5C38,$5C39,$5C3A,$5C3B,$5C3C,$5C3D,$5C3E,$5C3F,$5C40,$5C41,$5C42,$5C43,
$5C44,$5C45,$5C46,$5C47,$5C48,$5C49,$5C4A,$5C4B,$5C4C,$5C4D,$5C4E,$5C4F,$5C50,
$5C51,$5C52,$5C53,$5C54,$5C55,$5C56,$5C57,$5C58,$5C59,$5C5A,$5C5B,$5C5C,$5C5D,
$5C5E,$5C5F,$5C60,$5C61,$5C62,$5C63,$5C64,$5C65,$5C66,$5C67,$5C68,$5C69,$5C6A,
$5C6B,$5C6C,$5C6D,$5C6E,$5C6F,$5C70,$5C71,$5C72,$5C73,$5C74,$5C75,$5C76,$5C77,
$5C78,$5C79,$5C7A,$5C7B,$5C7C,$5C7D,$5C7E,$5C7F,$5C80,$5C81,$5C82,$5C83,$5C84,
$5C85,$5C86,$5C87,$5C88,$5C89,$5C8A,$5C8B,$5C8C,$5C8D,$5C8E,$5C8F,$5C90,$5C91,
$5C92,$5C93,$5C94,$5C95,$5C96,$5C97,$5C98,$5C99,$5C9A,$5C9B,$5C9C,$5C9D,$5C9E,
$5C9F,$5CA0,$5CA1,$5CA2,$5CA3,$5CA4,$5CA5,$5CA6,$5CA7,$5CA8,$5CA9,$5CAA,$5CAB,
$5CAC,$5CAD,$5CAE,$5CAF,$5CB0,$5CB1,$5CB2,$5CB3,$5CB4,$5CB5,$5CB6,$5CB7,$5CB8,
$5CB9,$5CBA,$5CBB,$5CBC,$5CBD,$5CBE,$5CBF,$5CC0,$5CC1,$5CC2,$5CC3,$5CC4,$5CC5,
$5CC6,$5CC7,$5CC8,$5CC9,$5CCA,$5CCB,$5CCC,$5CCD,$5CCE,$5CCF,$5CD0,$5CD1,$5CD2,
$5CD3,$5CD4,$5CD5,$5CD6,$5CD7,$5CD8,$5CD9,$5CDA,$5CDB,$5CDC,$5CDD,$5CDE,$5CDF,
$5CE0,$5CE1,$5CE2,$5CE3,$5CE4,$5CE5,$5CE6,$5CE7,$5CE8,$5CE9,$5CEA,$5CEB,$5CEC,
$5CED,$5CEE,$5CEF,$5CF0,$5CF1,$5CF2,$5CF3,$5CF4,$5CF5,$5CF6,$5CF7,$5CF8,$5CF9,
$5CFA,$5CFB,$5CFC,$5CFD,$5CFE,$5CFF,$5D00,$5D01,$5D02,$5D03,$5D04,$5D05,$5D06,
$5D07,$5D08,$5D09,$5D0A,$5D0B,$5D0C,$5D0D,$5D0E,$5D0F,$5D10,$5D11,$5D12,$5D13,
$5D14,$5D15,$5D16,$5D17,$5D18,$5D19,$5D1A,$5D1B,$5D1C,$5D1D,$5D1E,$5D1F,$5D20,
$5D21,$5D22,$5D23,$5D24,$5D25,$5D26,$5D27,$5D28,$5D29,$5D2A,$5D2B,$5D2C,$5D2D,
$5D2E,$5D2F,$5D30,$5D31,$5D32,$5D33,$5D34,$5D35,$5D36,$5D37,$5D38,$5D39,$5D3A,
$5D3B,$5D3C,$5D3D,$5D3E,$5D3F,$5D40,$5D41,$5D42,$5D43,$5D44,$5D45,$5D46,$5D47,
$5D48,$5D49,$5D4A,$5D4B,$5D4C,$5D4D,$5D4E,$5D4F,$5D50,$5D51,$5D52,$5D53,$5D54,
$5D55,$5D56,$5D57,$5D58,$5D59,$5D5A,$5D5B,$5D5C,$5D5D,$5D5E,$5D5F,$5D60,$5D61,
$5D62,$5D63,$5D64,$5D65,$5D66,$5D67,$5D68,$5D69,$5D6A,$5D6B,$5D6C,$5D6D,$5D6E,
$5D6F,$5D70,$5D71,$5D72,$5D73,$5D74,$5D75,$5D76,$5D77,$5D78,$5D79,$5D7A,$5D7B,
$5D7C,$5D7D,$5D7E,$5D7F,$5D80,$5D81,$5D82,$5D83,$5D84,$5D85,$5D86,$5D87,$5D88,
$5D89,$5D8A,$5D8B,$5D8C,$5D8D,$5D8E,$5D8F,$5D90,$5D91,$5D92,$5D93,$5D94,$5D95,
$5D96,$5D97,$5D98,$5D99,$5D9A,$5D9B,$5D9C,$5D9D,$5D9E,$5D9F,$5DA0,$5DA1,$5DA2,
$5DA3,$5DA4,$5DA5,$5DA6,$5DA7,$5DA8,$5DA9,$5DAA,$5DAB,$5DAC,$5DAD,$5DAE,$5DAF,
$5DB0,$5DB1,$5DB2,$5DB3,$5DB4,$5DB5,$5DB6,$5DB7,$5DB8,$5DB9,$5DBA,$5DBB,$5DBC,
$5DBD,$5DBE,$5DBF,$5DC0,$5DC1,$5DC2,$5DC3,$5DC4,$5DC5,$5DC6,$5DC7,$5DC8,$5DC9,
$5DCA,$5DCB,$5DCC,$5DCD,$5DCE,$5DCF,$5DD0,$5DD1,$5DD2,$5DD3,$5DD4,$5DD5,$5DD6,
$5DD7,$5DD8,$5DD9,$5DDA,$5DDB,$5DDC,$5DDD,$5DDE,$5DDF,$5DE0,$5DE1,$5DE2,$5DE3,
$5DE4,$5DE5,$5DE6,$5DE7,$5DE8,$5DE9,$5DEA,$5DEB,$5DEC,$5DED,$5DEE,$5DEF,$5DF0,
$5DF1,$5DF2,$5DF3,$5DF4,$5DF5,$5DF6,$5DF7,$5DF8,$5DF9,$5DFA,$5DFB,$5DFC,$5DFD,
$5DFE,$5DFF,$5E00,$5E01,$5E02,$5E03,$5E04,$5E05,$5E06,$5E07,$5E08,$5E09,$5E0A,
$5E0B,$5E0C,$5E0D,$5E0E,$5E0F,$5E10,$5E11,$5E12,$5E13,$5E14,$5E15,$5E16,$5E17,
$5E18,$5E19,$5E1A,$5E1B,$5E1C,$5E1D,$5E1E,$5E1F,$5E20,$5E21,$5E22,$5E23,$5E24,
$5E25,$5E26,$5E27,$5E28,$5E29,$5E2A,$5E2B,$5E2C,$5E2D,$5E2E,$5E2F,$5E30,$5E31,
$5E32,$5E33,$5E34,$5E35,$5E36,$5E37,$5E38,$5E39,$5E3A,$5E3B,$5E3C,$5E3D,$5E3E,
$5E3F,$5E40,$5E41,$5E42,$5E43,$5E44,$5E45,$5E46,$5E47,$5E48,$5E49,$5E4A,$5E4B,
$5E4C,$5E4D,$5E4E,$5E4F,$5E50,$5E51,$5E52,$5E53,$5E54,$5E55,$5E56,$5E57,$5E58,
$5E59,$5E5A,$5E5B,$5E5C,$5E5D,$5E5E,$5E5F,$5E60,$5E61,$5E62,$5E63,$5E64,$5E65,
$5E66,$5E67,$5E68,$5E69,$5E6A,$5E6B,$5E6C,$5E6D,$5E6E,$5E6F,$5E70,$5E71,$5E72,
$5E73,$5E74,$5E75,$5E76,$5E77,$5E78,$5E79,$5E7A,$5E7B,$5E7C,$5E7D,$5E7E,$5E7F,
$5E80,$5E81,$5E82,$5E83,$5E84,$5E85,$5E86,$5E87,$5E88,$5E89,$5E8A,$5E8B,$5E8C,
$5E8D,$5E8E,$5E8F,$5E90,$5E91,$5E92,$5E93,$5E94,$5E95,$5E96,$5E97,$5E98,$5E99,
$5E9A,$5E9B,$5E9C,$5E9D,$5E9E,$5E9F,$5EA0,$5EA1,$5EA2,$5EA3,$5EA4,$5EA5,$5EA6,
$5EA7,$5EA8,$5EA9,$5EAA,$5EAB,$5EAC,$5EAD,$5EAE,$5EAF,$5EB0,$5EB1,$5EB2,$5EB3,
$5EB4,$5EB5,$5EB6,$5EB7,$5EB8,$5EB9,$5EBA,$5EBB,$5EBC,$5EBD,$5EBE,$5EBF,$5EC0,
$5EC1,$5EC2,$5EC3,$5EC4,$5EC5,$5EC6,$5EC7,$5EC8,$5EC9,$5ECA,$5ECB,$5ECC,$5ECD,
$5ECE,$5ECF,$5ED0,$5ED1,$5ED2,$5ED3,$5ED4,$5ED5,$5ED6,$5ED7,$5ED8,$5ED9,$5EDA,
$5EDB,$5EDC,$5EDD,$5EDE,$5EDF,$5EE0,$5EE1,$5EE2,$5EE3,$5EE4,$5EE5,$5EE6,$5EE7,
$5EE8,$5EE9,$5EEA,$5EEB,$5EEC,$5EED,$5EEE,$5EEF,$5EF0,$5EF1,$5EF2,$5EF3,$5EF4,
$5EF5,$5EF6,$5EF7,$5EF8,$5EF9,$5EFA,$5EFB,$5EFC,$5EFD,$5EFE,$5EFF,$5F00,$5F01,
$5F02,$5F03,$5F04,$5F05,$5F06,$5F07,$5F08,$5F09,$5F0A,$5F0B,$5F0C,$5F0D,$5F0E,
$5F0F,$5F10,$5F11,$5F12,$5F13,$5F14,$5F15,$5F16,$5F17,$5F18,$5F19,$5F1A,$5F1B,
$5F1C,$5F1D,$5F1E,$5F1F,$5F20,$5F21,$5F22,$5F23,$5F24,$5F25,$5F26,$5F27,$5F28,
$5F29,$5F2A,$5F2B,$5F2C,$5F2D,$5F2E,$5F2F,$5F30,$5F31,$5F32,$5F33,$5F34,$5F35,
$5F36,$5F37,$5F38,$5F39,$5F3A,$5F3B,$5F3C,$5F3D,$5F3E,$5F3F,$5F40,$5F41,$5F42,
$5F43,$5F44,$5F45,$5F46,$5F47,$5F48,$5F49,$5F4A,$5F4B,$5F4C,$5F4D,$5F4E,$5F4F,
$5F50,$5F51,$5F52,$5F53,$5F54,$5F55,$5F56,$5F57,$5F58,$5F59,$5F5A,$5F5B,$5F5C,
$5F5D,$5F5E,$5F5F,$5F60,$5F61,$5F62,$5F63,$5F64,$5F65,$5F66,$5F67,$5F68,$5F69,
$5F6A,$5F6B,$5F6C,$5F6D,$5F6E,$5F6F,$5F70,$5F71,$5F72,$5F73,$5F74,$5F75,$5F76,
$5F77,$5F78,$5F79,$5F7A,$5F7B,$5F7C,$5F7D,$5F7E,$5F7F,$5F80,$5F81,$5F82,$5F83,
$5F84,$5F85,$5F86,$5F87,$5F88,$5F89,$5F8A,$5F8B,$5F8C,$5F8D,$5F8E,$5F8F,$5F90,
$5F91,$5F92,$5F93,$5F94,$5F95,$5F96,$5F97,$5F98,$5F99,$5F9A,$5F9B,$5F9C,$5F9D,
$5F9E,$5F9F,$5FA0,$5FA1,$5FA2,$5FA3,$5FA4,$5FA5,$5FA6,$5FA7,$5FA8,$5FA9,$5FAA,
$5FAB,$5FAC,$5FAD,$5FAE,$5FAF,$5FB0,$5FB1,$5FB2,$5FB3,$5FB4,$5FB5,$5FB6,$5FB7,
$5FB8,$5FB9,$5FBA,$5FBB,$5FBC,$5FBD,$5FBE,$5FBF,$5FC0,$5FC1,$5FC2,$5FC3,$5FC4,
$5FC5,$5FC6,$5FC7,$5FC8,$5FC9,$5FCA,$5FCB,$5FCC,$5FCD,$5FCE,$5FCF,$5FD0,$5FD1,
$5FD2,$5FD3,$5FD4,$5FD5,$5FD6,$5FD7,$5FD8,$5FD9,$5FDA,$5FDB,$5FDC,$5FDD,$5FDE,
$5FDF,$5FE0,$5FE1,$5FE2,$5FE3,$5FE4,$5FE5,$5FE6,$5FE7,$5FE8,$5FE9,$5FEA,$5FEB,
$5FEC,$5FED,$5FEE,$5FEF,$5FF0,$5FF1,$5FF2,$5FF3,$5FF4,$5FF5,$5FF6,$5FF7,$5FF8,
$5FF9,$5FFA,$5FFB,$5FFC,$5FFD,$5FFE,$5FFF,$6000,$6001,$6002,$6003,$6004,$6005,
$6006,$6007,$6008,$6009,$600A,$600B,$600C,$600D,$600E,$600F,$6010,$6011,$6012,
$6013,$6014,$6015,$6016,$6017,$6018,$6019,$601A,$601B,$601C,$601D,$601E,$601F,
$6020,$6021,$6022,$6023,$6024,$6025,$6026,$6027,$6028,$6029,$602A,$602B,$602C,
$602D,$602E,$602F,$6030,$6031,$6032,$6033,$6034,$6035,$6036,$6037,$6038,$6039,
$603A,$603B,$603C,$603D,$603E,$603F,$6040,$6041,$6042,$6043,$6044,$6045,$6046,
$6047,$6048,$6049,$604A,$604B,$604C,$604D,$604E,$604F,$6050,$6051,$6052,$6053,
$6054,$6055,$6056,$6057,$6058,$6059,$605A,$605B,$605C,$605D,$605E,$605F,$6060,
$6061,$6062,$6063,$6064,$6065,$6066,$6067,$6068,$6069,$606A,$606B,$606C,$606D,
$606E,$606F,$6070,$6071,$6072,$6073,$6074,$6075,$6076,$6077,$6078,$6079,$607A,
$607B,$607C,$607D,$607E,$607F,$6080,$6081,$6082,$6083,$6084,$6085,$6086,$6087,
$6088,$6089,$608A,$608B,$608C,$608D,$608E,$608F,$6090,$6091,$6092,$6093,$6094,
$6095,$6096,$6097,$6098,$6099,$609A,$609B,$609C,$609D,$609E,$609F,$60A0,$60A1,
$60A2,$60A3,$60A4,$60A5,$60A6,$60A7,$60A8,$60A9,$60AA,$60AB,$60AC,$60AD,$60AE,
$60AF,$60B0,$60B1,$60B2,$60B3,$60B4,$60B5,$60B6,$60B7,$60B8,$60B9,$60BA,$60BB,
$60BC,$60BD,$60BE,$60BF,$60C0,$60C1,$60C2,$60C3,$60C4,$60C5,$60C6,$60C7,$60C8,
$60C9,$60CA,$60CB,$60CC,$60CD,$60CE,$60CF,$60D0,$60D1,$60D2,$60D3,$60D4,$60D5,
$60D6,$60D7,$60D8,$60D9,$60DA,$60DB,$60DC,$60DD,$60DE,$60DF,$60E0,$60E1,$60E2,
$60E3,$60E4,$60E5,$60E6,$60E7,$60E8,$60E9,$60EA,$60EB,$60EC,$60ED,$60EE,$60EF,
$60F0,$60F1,$60F2,$60F3,$60F4,$60F5,$60F6,$60F7,$60F8,$60F9,$60FA,$60FB,$60FC,
$60FD,$60FE,$60FF,$6100,$6101,$6102,$6103,$6104,$6105,$6106,$6107,$6108,$6109,
$610A,$610B,$610C,$610D,$610E,$610F,$6110,$6111,$6112,$6113,$6114,$6115,$6116,
$6117,$6118,$6119,$611A,$611B,$611C,$611D,$611E,$611F,$6120,$6121,$6122,$6123,
$6124,$6125,$6126,$6127,$6128,$6129,$612A,$612B,$612C,$612D,$612E,$612F,$6130,
$6131,$6132,$6133,$6134,$6135,$6136,$6137,$6138,$6139,$613A,$613B,$613C,$613D,
$613E,$613F,$6140,$6141,$6142,$6143,$6144,$6145,$6146,$6147,$6148,$6149,$614A,
$614B,$614C,$614D,$614E,$614F,$6150,$6151,$6152,$6153,$6154,$6155,$6156,$6157,
$6158,$6159,$615A,$615B,$615C,$615D,$615E,$615F,$6160,$6161,$6162,$6163,$6164,
$6165,$6166,$6167,$6168,$6169,$616A,$616B,$616C,$616D,$616E,$616F,$6170,$6171,
$6172,$6173,$6174,$6175,$6176,$6177,$6178,$6179,$617A,$617B,$617C,$617D,$617E,
$617F,$6180,$6181,$6182,$6183,$6184,$6185,$6186,$6187,$6188,$6189,$618A,$618B,
$618C,$618D,$618E,$618F,$6190,$6191,$6192,$6193,$6194,$6195,$6196,$6197,$6198,
$6199,$619A,$619B,$619C,$619D,$619E,$619F,$61A0,$61A1,$61A2,$61A3,$61A4,$61A5,
$61A6,$61A7,$61A8,$61A9,$61AA,$61AB,$61AC,$61AD,$61AE,$61AF,$61B0,$61B1,$61B2,
$61B3,$61B4,$61B5,$61B6,$61B7,$61B8,$61B9,$61BA,$61BB,$61BC,$61BD,$61BE,$61BF,
$61C0,$61C1,$61C2,$61C3,$61C4,$61C5,$61C6,$61C7,$61C8,$61C9,$61CA,$61CB,$61CC,
$61CD,$61CE,$61CF,$61D0,$61D1,$61D2,$61D3,$61D4,$61D5,$61D6,$61D7,$61D8,$61D9,
$61DA,$61DB,$61DC,$61DD,$61DE,$61DF,$61E0,$61E1,$61E2,$61E3,$61E4,$61E5,$61E6,
$61E7,$61E8,$61E9,$61EA,$61EB,$61EC,$61ED,$61EE,$61EF,$61F0,$61F1,$61F2,$61F3,
$61F4,$61F5,$61F6,$61F7,$61F8,$61F9,$61FA,$61FB,$61FC,$61FD,$61FE,$61FF,$6200,
$6201,$6202,$6203,$6204,$6205,$6206,$6207,$6208,$6209,$620A,$620B,$620C,$620D,
$620E,$620F,$6210,$6211,$6212,$6213,$6214,$6215,$6216,$6217,$6218,$6219,$621A,
$621B,$621C,$621D,$621E,$621F,$6220,$6221,$6222,$6223,$6224,$6225,$6226,$6227,
$6228,$6229,$622A,$622B,$622C,$622D,$622E,$622F,$6230,$6231,$6232,$6233,$6234,
$6235,$6236,$6237,$6238,$6239,$623A,$623B,$623C,$623D,$623E,$623F,$6240,$6241,
$6242,$6243,$6244,$6245,$6246,$6247,$6248,$6249,$624A,$624B,$624C,$624D,$624E,
$624F,$6250,$6251,$6252,$6253,$6254,$6255,$6256,$6257,$6258,$6259,$625A,$625B,
$625C,$625D,$625E,$625F,$6260,$6261,$6262,$6263,$6264,$6265,$6266,$6267,$6268,
$6269,$626A,$626B,$626C,$626D,$626E,$626F,$6270,$6271,$6272,$6273,$6274,$6275,
$6276,$6277,$6278,$6279,$627A,$627B,$627C,$627D,$627E,$627F,$6280,$6281,$6282,
$6283,$6284,$6285,$6286,$6287,$6288,$6289,$628A,$628B,$628C,$628D,$628E,$628F,
$6290,$6291,$6292,$6293,$6294,$6295,$6296,$6297,$6298,$6299,$629A,$629B,$629C,
$629D,$629E,$629F,$62A0,$62A1,$62A2,$62A3,$62A4,$62A5,$62A6,$62A7,$62A8,$62A9,
$62AA,$62AB,$62AC,$62AD,$62AE,$62AF,$62B0,$62B1,$62B2,$62B3,$62B4,$62B5,$62B6,
$62B7,$62B8,$62B9,$62BA,$62BB,$62BC,$62BD,$62BE,$62BF,$62C0,$62C1,$62C2,$62C3,
$62C4,$62C5,$62C6,$62C7,$62C8,$62C9,$62CA,$62CB,$62CC,$62CD,$62CE,$62CF,$62D0,
$62D1,$62D2,$62D3,$62D4,$62D5,$62D6,$62D7,$62D8,$62D9,$62DA,$62DB,$62DC,$62DD,
$62DE,$62DF,$62E0,$62E1,$62E2,$62E3,$62E4,$62E5,$62E6,$62E7,$62E8,$62E9,$62EA,
$62EB,$62EC,$62ED,$62EE,$62EF,$62F0,$62F1,$62F2,$62F3,$62F4,$62F5,$62F6,$62F7,
$62F8,$62F9,$62FA,$62FB,$62FC,$62FD,$62FE,$62FF,$6300,$6301,$6302,$6303,$6304,
$6305,$6306,$6307,$6308,$6309,$630A,$630B,$630C,$630D,$630E,$630F,$6310,$6311,
$6312,$6313,$6314,$6315,$6316,$6317,$6318,$6319,$631A,$631B,$631C,$631D,$631E,
$631F,$6320,$6321,$6322,$6323,$6324,$6325,$6326,$6327,$6328,$6329,$632A,$632B,
$632C,$632D,$632E,$632F,$6330,$6331,$6332,$6333,$6334,$6335,$6336,$6337,$6338,
$6339,$633A,$633B,$633C,$633D,$633E,$633F,$6340,$6341,$6342,$6343,$6344,$6345,
$6346,$6347,$6348,$6349,$634A,$634B,$634C,$634D,$634E,$634F,$6350,$6351,$6352,
$6353,$6354,$6355,$6356,$6357,$6358,$6359,$635A,$635B,$635C,$635D,$635E,$635F,
$6360,$6361,$6362,$6363,$6364,$6365,$6366,$6367,$6368,$6369,$636A,$636B,$636C,
$636D,$636E,$636F,$6370,$6371,$6372,$6373,$6374,$6375,$6376,$6377,$6378,$6379,
$637A,$637B,$637C,$637D,$637E,$637F,$6380,$6381,$6382,$6383,$6384,$6385,$6386,
$6387,$6388,$6389,$638A,$638B,$638C,$638D,$638E,$638F,$6390,$6391,$6392,$6393,
$6394,$6395,$6396,$6397,$6398,$6399,$639A,$639B,$639C,$639D,$639E,$639F,$63A0,
$63A1,$63A2,$63A3,$63A4,$63A5,$63A6,$63A7,$63A8,$63A9,$63AA,$63AB,$63AC,$63AD,
$63AE,$63AF,$63B0,$63B1,$63B2,$63B3,$63B4,$63B5,$63B6,$63B7,$63B8,$63B9,$63BA,
$63BB,$63BC,$63BD,$63BE,$63BF,$63C0,$63C1,$63C2,$63C3,$63C4,$63C5,$63C6,$63C7,
$63C8,$63C9,$63CA,$63CB,$63CC,$63CD,$63CE,$63CF,$63D0,$63D1,$63D2,$63D3,$63D4,
$63D5,$63D6,$63D7,$63D8,$63D9,$63DA,$63DB,$63DC,$63DD,$63DE,$63DF,$63E0,$63E1,
$63E2,$63E3,$63E4,$63E5,$63E6,$63E7,$63E8,$63E9,$63EA,$63EB,$63EC,$63ED,$63EE,
$63EF,$63F0,$63F1,$63F2,$63F3,$63F4,$63F5,$63F6,$63F7,$63F8,$63F9,$63FA,$63FB,
$63FC,$63FD,$63FE,$63FF,$6400,$6401,$6402,$6403,$6404,$6405,$6406,$6407,$6408,
$6409,$640A,$640B,$640C,$640D,$640E,$640F,$6410,$6411,$6412,$6413,$6414,$6415,
$6416,$6417,$6418,$6419,$641A,$641B,$641C,$641D,$641E,$641F,$6420,$6421,$6422,
$6423,$6424,$6425,$6426,$6427,$6428,$6429,$642A,$642B,$642C,$642D,$642E,$642F,
$6430,$6431,$6432,$6433,$6434,$6435,$6436,$6437,$6438,$6439,$643A,$643B,$643C,
$643D,$643E,$643F,$6440,$6441,$6442,$6443,$6444,$6445,$6446,$6447,$6448,$6449,
$644A,$644B,$644C,$644D,$644E,$644F,$6450,$6451,$6452,$6453,$6454,$6455,$6456,
$6457,$6458,$6459,$645A,$645B,$645C,$645D,$645E,$645F,$6460,$6461,$6462,$6463,
$6464,$6465,$6466,$6467,$6468,$6469,$646A,$646B,$646C,$646D,$646E,$646F,$6470,
$6471,$6472,$6473,$6474,$6475,$6476,$6477,$6478,$6479,$647A,$647B,$647C,$647D,
$647E,$647F,$6480,$6481,$6482,$6483,$6484,$6485,$6486,$6487,$6488,$6489,$648A,
$648B,$648C,$648D,$648E,$648F,$6490,$6491,$6492,$6493,$6494,$6495,$6496,$6497,
$6498,$6499,$649A,$649B,$649C,$649D,$649E,$649F,$64A0,$64A1,$64A2,$64A3,$64A4,
$64A5,$64A6,$64A7,$64A8,$64A9,$64AA,$64AB,$64AC,$64AD,$64AE,$64AF,$64B0,$64B1,
$64B2,$64B3,$64B4,$64B5,$64B6,$64B7,$64B8,$64B9,$64BA,$64BB,$64BC,$64BD,$64BE,
$64BF,$64C0,$64C1,$64C2,$64C3,$64C4,$64C5,$64C6,$64C7,$64C8,$64C9,$64CA,$64CB,
$64CC,$64CD,$64CE,$64CF,$64D0,$64D1,$64D2,$64D3,$64D4,$64D5,$64D6,$64D7,$64D8,
$64D9,$64DA,$64DB,$64DC,$64DD,$64DE,$64DF,$64E0,$64E1,$64E2,$64E3,$64E4,$64E5,
$64E6,$64E7,$64E8,$64E9,$64EA,$64EB,$64EC,$64ED,$64EE,$64EF,$64F0,$64F1,$64F2,
$64F3,$64F4,$64F5,$64F6,$64F7,$64F8,$64F9,$64FA,$64FB,$64FC,$64FD,$64FE,$64FF,
$6500,$6501,$6502,$6503,$6504,$6505,$6506,$6507,$6508,$6509,$650A,$650B,$650C,
$650D,$650E,$650F,$6510,$6511,$6512,$6513,$6514,$6515,$6516,$6517,$6518,$6519,
$651A,$651B,$651C,$651D,$651E,$651F,$6520,$6521,$6522,$6523,$6524,$6525,$6526,
$6527,$6528,$6529,$652A,$652B,$652C,$652D,$652E,$652F,$6530,$6531,$6532,$6533,
$6534,$6535,$6536,$6537,$6538,$6539,$653A,$653B,$653C,$653D,$653E,$653F,$6540,
$6541,$6542,$6543,$6544,$6545,$6546,$6547,$6548,$6549,$654A,$654B,$654C,$654D,
$654E,$654F,$6550,$6551,$6552,$6553,$6554,$6555,$6556,$6557,$6558,$6559,$655A,
$655B,$655C,$655D,$655E,$655F,$6560,$6561,$6562,$6563,$6564,$6565,$6566,$6567,
$6568,$6569,$656A,$656B,$656C,$656D,$656E,$656F,$6570,$6571,$6572,$6573,$6574,
$6575,$6576,$6577,$6578,$6579,$657A,$657B,$657C,$657D,$657E,$657F,$6580,$6581,
$6582,$6583,$6584,$6585,$6586,$6587,$6588,$6589,$658A,$658B,$658C,$658D,$658E,
$658F,$6590,$6591,$6592,$6593,$6594,$6595,$6596,$6597,$6598,$6599,$659A,$659B,
$659C,$659D,$659E,$659F,$65A0,$65A1,$65A2,$65A3,$65A4,$65A5,$65A6,$65A7,$65A8,
$65A9,$65AA,$65AB,$65AC,$65AD,$65AE,$65AF,$65B0,$65B1,$65B2,$65B3,$65B4,$65B5,
$65B6,$65B7,$65B8,$65B9,$65BA,$65BB,$65BC,$65BD,$65BE,$65BF,$65C0,$65C1,$65C2,
$65C3,$65C4,$65C5,$65C6,$65C7,$65C8,$65C9,$65CA,$65CB,$65CC,$65CD,$65CE,$65CF,
$65D0,$65D1,$65D2,$65D3,$65D4,$65D5,$65D6,$65D7,$65D8,$65D9,$65DA,$65DB,$65DC,
$65DD,$65DE,$65DF,$65E0,$65E1,$65E2,$65E3,$65E4,$65E5,$65E6,$65E7,$65E8,$65E9,
$65EA,$65EB,$65EC,$65ED,$65EE,$65EF,$65F0,$65F1,$65F2,$65F3,$65F4,$65F5,$65F6,
$65F7,$65F8,$65F9,$65FA,$65FB,$65FC,$65FD,$65FE,$65FF,$6600,$6601,$6602,$6603,
$6604,$6605,$6606,$6607,$6608,$6609,$660A,$660B,$660C,$660D,$660E,$660F,$6610,
$6611,$6612,$6613,$6614,$6615,$6616,$6617,$6618,$6619,$661A,$661B,$661C,$661D,
$661E,$661F,$6620,$6621,$6622,$6623,$6624,$6625,$6626,$6627,$6628,$6629,$662A,
$662B,$662C,$662D,$662E,$662F,$6630,$6631,$6632,$6633,$6634,$6635,$6636,$6637,
$6638,$6639,$663A,$663B,$663C,$663D,$663E,$663F,$6640,$6641,$6642,$6643,$6644,
$6645,$6646,$6647,$6648,$6649,$664A,$664B,$664C,$664D,$664E,$664F,$6650,$6651,
$6652,$6653,$6654,$6655,$6656,$6657,$6658,$6659,$665A,$665B,$665C,$665D,$665E,
$665F,$6660,$6661,$6662,$6663,$6664,$6665,$6666,$6667,$6668,$6669,$666A,$666B,
$666C,$666D,$666E,$666F,$6670,$6671,$6672,$6673,$6674,$6675,$6676,$6677,$6678,
$6679,$667A,$667B,$667C,$667D,$667E,$667F,$6680,$6681,$6682,$6683,$6684,$6685,
$6686,$6687,$6688,$6689,$668A,$668B,$668C,$668D,$668E,$668F,$6690,$6691,$6692,
$6693,$6694,$6695,$6696,$6697,$6698,$6699,$669A,$669B,$669C,$669D,$669E,$669F,
$66A0,$66A1,$66A2,$66A3,$66A4,$66A5,$66A6,$66A7,$66A8,$66A9,$66AA,$66AB,$66AC,
$66AD,$66AE,$66AF,$66B0,$66B1,$66B2,$66B3,$66B4,$66B5,$66B6,$66B7,$66B8,$66B9,
$66BA,$66BB,$66BC,$66BD,$66BE,$66BF,$66C0,$66C1,$66C2,$66C3,$66C4,$66C5,$66C6,
$66C7,$66C8,$66C9,$66CA,$66CB,$66CC,$66CD,$66CE,$66CF,$66D0,$66D1,$66D2,$66D3,
$66D4,$66D5,$66D6,$66D7,$66D8,$66D9,$66DA,$66DB,$66DC,$66DD,$66DE,$66DF,$66E0,
$66E1,$66E2,$66E3,$66E4,$66E5,$66E6,$66E7,$66E8,$66E9,$66EA,$66EB,$66EC,$66ED,
$66EE,$66EF,$66F0,$66F1,$66F2,$66F3,$66F4,$66F5,$66F6,$66F7,$66F8,$66F9,$66FA,
$66FB,$66FC,$66FD,$66FE,$66FF,$6700,$6701,$6702,$6703,$6704,$6705,$6706,$6707,
$6708,$6709,$670A,$670B,$670C,$670D,$670E,$670F,$6710,$6711,$6712,$6713,$6714,
$6715,$6716,$6717,$6718,$6719,$671A,$671B,$671C,$671D,$671E,$671F,$6720,$6721,
$6722,$6723,$6724,$6725,$6726,$6727,$6728,$6729,$672A,$672B,$672C,$672D,$672E,
$672F,$6730,$6731,$6732,$6733,$6734,$6735,$6736,$6737,$6738,$6739,$673A,$673B,
$673C,$673D,$673E,$673F,$6740,$6741,$6742,$6743,$6744,$6745,$6746,$6747,$6748,
$6749,$674A,$674B,$674C,$674D,$674E,$674F,$6750,$6751,$6752,$6753,$6754,$6755,
$6756,$6757,$6758,$6759,$675A,$675B,$675C,$675D,$675E,$675F,$6760,$6761,$6762,
$6763,$6764,$6765,$6766,$6767,$6768,$6769,$676A,$676B,$676C,$676D,$676E,$676F,
$6770,$6771,$6772,$6773,$6774,$6775,$6776,$6777,$6778,$6779,$677A,$677B,$677C,
$677D,$677E,$677F,$6780,$6781,$6782,$6783,$6784,$6785,$6786,$6787,$6788,$6789,
$678A,$678B,$678C,$678D,$678E,$678F,$6790,$6791,$6792,$6793,$6794,$6795,$6796,
$6797,$6798,$6799,$679A,$679B,$679C,$679D,$679E,$679F,$67A0,$67A1,$67A2,$67A3,
$67A4,$67A5,$67A6,$67A7,$67A8,$67A9,$67AA,$67AB,$67AC,$67AD,$67AE,$67AF,$67B0,
$67B1,$67B2,$67B3,$67B4,$67B5,$67B6,$67B7,$67B8,$67B9,$67BA,$67BB,$67BC,$67BD,
$67BE,$67BF,$67C0,$67C1,$67C2,$67C3,$67C4,$67C5,$67C6,$67C7,$67C8,$67C9,$67CA,
$67CB,$67CC,$67CD,$67CE,$67CF,$67D0,$67D1,$67D2,$67D3,$67D4,$67D5,$67D6,$67D7,
$67D8,$67D9,$67DA,$67DB,$67DC,$67DD,$67DE,$67DF,$67E0,$67E1,$67E2,$67E3,$67E4,
$67E5,$67E6,$67E7,$67E8,$67E9,$67EA,$67EB,$67EC,$67ED,$67EE,$67EF,$67F0,$67F1,
$67F2,$67F3,$67F4,$67F5,$67F6,$67F7,$67F8,$67F9,$67FA,$67FB,$67FC,$67FD,$67FE,
$67FF,$6800,$6801,$6802,$6803,$6804,$6805,$6806,$6807,$6808,$6809,$680A,$680B,
$680C,$680D,$680E,$680F,$6810,$6811,$6812,$6813,$6814,$6815,$6816,$6817,$6818,
$6819,$681A,$681B,$681C,$681D,$681E,$681F,$6820,$6821,$6822,$6823,$6824,$6825,
$6826,$6827,$6828,$6829,$682A,$682B,$682C,$682D,$682E,$682F,$6830,$6831,$6832,
$6833,$6834,$6835,$6836,$6837,$6838,$6839,$683A,$683B,$683C,$683D,$683E,$683F,
$6840,$6841,$6842,$6843,$6844,$6845,$6846,$6847,$6848,$6849,$684A,$684B,$684C,
$684D,$684E,$684F,$6850,$6851,$6852,$6853,$6854,$6855,$6856,$6857,$6858,$6859,
$685A,$685B,$685C,$685D,$685E,$685F,$6860,$6861,$6862,$6863,$6864,$6865,$6866,
$6867,$6868,$6869,$686A,$686B,$686C,$686D,$686E,$686F,$6870,$6871,$6872,$6873,
$6874,$6875,$6876,$6877,$6878,$6879,$687A,$687B,$687C,$687D,$687E,$687F,$6880,
$6881,$6882,$6883,$6884,$6885,$6886,$6887,$6888,$6889,$688A,$688B,$688C,$688D,
$688E,$688F,$6890,$6891,$6892,$6893,$6894,$6895,$6896,$6897,$6898,$6899,$689A,
$689B,$689C,$689D,$689E,$689F,$68A0,$68A1,$68A2,$68A3,$68A4,$68A5,$68A6,$68A7,
$68A8,$68A9,$68AA,$68AB,$68AC,$68AD,$68AE,$68AF,$68B0,$68B1,$68B2,$68B3,$68B4,
$68B5,$68B6,$68B7,$68B8,$68B9,$68BA,$68BB,$68BC,$68BD,$68BE,$68BF,$68C0,$68C1,
$68C2,$68C3,$68C4,$68C5,$68C6,$68C7,$68C8,$68C9,$68CA,$68CB,$68CC,$68CD,$68CE,
$68CF,$68D0,$68D1,$68D2,$68D3,$68D4,$68D5,$68D6,$68D7,$68D8,$68D9,$68DA,$68DB,
$68DC,$68DD,$68DE,$68DF,$68E0,$68E1,$68E2,$68E3,$68E4,$68E5,$68E6,$68E7,$68E8,
$68E9,$68EA,$68EB,$68EC,$68ED,$68EE,$68EF,$68F0,$68F1,$68F2,$68F3,$68F4,$68F5,
$68F6,$68F7,$68F8,$68F9,$68FA,$68FB,$68FC,$68FD,$68FE,$68FF,$6900,$6901,$6902,
$6903,$6904,$6905,$6906,$6907,$6908,$6909,$690A,$690B,$690C,$690D,$690E,$690F,
$6910,$6911,$6912,$6913,$6914,$6915,$6916,$6917,$6918,$6919,$691A,$691B,$691C,
$691D,$691E,$691F,$6920,$6921,$6922,$6923,$6924,$6925,$6926,$6927,$6928,$6929,
$692A,$692B,$692C,$692D,$692E,$692F,$6930,$6931,$6932,$6933,$6934,$6935,$6936,
$6937,$6938,$6939,$693A,$693B,$693C,$693D,$693E,$693F,$6940,$6941,$6942,$6943,
$6944,$6945,$6946,$6947,$6948,$6949,$694A,$694B,$694C,$694D,$694E,$694F,$6950,
$6951,$6952,$6953,$6954,$6955,$6956,$6957,$6958,$6959,$695A,$695B,$695C,$695D,
$695E,$695F,$6960,$6961,$6962,$6963,$6964,$6965,$6966,$6967,$6968,$6969,$696A,
$696B,$696C,$696D,$696E,$696F,$6970,$6971,$6972,$6973,$6974,$6975,$6976,$6977,
$6978,$6979,$697A,$697B,$697C,$697D,$697E,$697F,$6980,$6981,$6982,$6983,$6984,
$6985,$6986,$6987,$6988,$6989,$698A,$698B,$698C,$698D,$698E,$698F,$6990,$6991,
$6992,$6993,$6994,$6995,$6996,$6997,$6998,$6999,$699A,$699B,$699C,$699D,$699E,
$699F,$69A0,$69A1,$69A2,$69A3,$69A4,$69A5,$69A6,$69A7,$69A8,$69A9,$69AA,$69AB,
$69AC,$69AD,$69AE,$69AF,$69B0,$69B1,$69B2,$69B3,$69B4,$69B5,$69B6,$69B7,$69B8,
$69B9,$69BA,$69BB,$69BC,$69BD,$69BE,$69BF,$69C0,$69C1,$69C2,$69C3,$69C4,$69C5,
$69C6,$69C7,$69C8,$69C9,$69CA,$69CB,$69CC,$69CD,$69CE,$69CF,$69D0,$69D1,$69D2,
$69D3,$69D4,$69D5,$69D6,$69D7,$69D8,$69D9,$69DA,$69DB,$69DC,$69DD,$69DE,$69DF,
$69E0,$69E1,$69E2,$69E3,$69E4,$69E5,$69E6,$69E7,$69E8,$69E9,$69EA,$69EB,$69EC,
$69ED,$69EE,$69EF,$69F0,$69F1,$69F2,$69F3,$69F4,$69F5,$69F6,$69F7,$69F8,$69F9,
$69FA,$69FB,$69FC,$69FD,$69FE,$69FF,$6A00,$6A01,$6A02,$6A03,$6A04,$6A05,$6A06,
$6A07,$6A08,$6A09,$6A0A,$6A0B,$6A0C,$6A0D,$6A0E,$6A0F,$6A10,$6A11,$6A12,$6A13,
$6A14,$6A15,$6A16,$6A17,$6A18,$6A19,$6A1A,$6A1B,$6A1C,$6A1D,$6A1E,$6A1F,$6A20,
$6A21,$6A22,$6A23,$6A24,$6A25,$6A26,$6A27,$6A28,$6A29,$6A2A,$6A2B,$6A2C,$6A2D,
$6A2E,$6A2F,$6A30,$6A31,$6A32,$6A33,$6A34,$6A35,$6A36,$6A37,$6A38,$6A39,$6A3A,
$6A3B,$6A3C,$6A3D,$6A3E,$6A3F,$6A40,$6A41,$6A42,$6A43,$6A44,$6A45,$6A46,$6A47,
$6A48,$6A49,$6A4A,$6A4B,$6A4C,$6A4D,$6A4E,$6A4F,$6A50,$6A51,$6A52,$6A53,$6A54,
$6A55,$6A56,$6A57,$6A58,$6A59,$6A5A,$6A5B,$6A5C,$6A5D,$6A5E,$6A5F,$6A60,$6A61,
$6A62,$6A63,$6A64,$6A65,$6A66,$6A67,$6A68,$6A69,$6A6A,$6A6B,$6A6C,$6A6D,$6A6E,
$6A6F,$6A70,$6A71,$6A72,$6A73,$6A74,$6A75,$6A76,$6A77,$6A78,$6A79,$6A7A,$6A7B,
$6A7C,$6A7D,$6A7E,$6A7F,$6A80,$6A81,$6A82,$6A83,$6A84,$6A85,$6A86,$6A87,$6A88,
$6A89,$6A8A,$6A8B,$6A8C,$6A8D,$6A8E,$6A8F,$6A90,$6A91,$6A92,$6A93,$6A94,$6A95,
$6A96,$6A97,$6A98,$6A99,$6A9A,$6A9B,$6A9C,$6A9D,$6A9E,$6A9F,$6AA0,$6AA1,$6AA2,
$6AA3,$6AA4,$6AA5,$6AA6,$6AA7,$6AA8,$6AA9,$6AAA,$6AAB,$6AAC,$6AAD,$6AAE,$6AAF,
$6AB0,$6AB1,$6AB2,$6AB3,$6AB4,$6AB5,$6AB6,$6AB7,$6AB8,$6AB9,$6ABA,$6ABB,$6ABC,
$6ABD,$6ABE,$6ABF,$6AC0,$6AC1,$6AC2,$6AC3,$6AC4,$6AC5,$6AC6,$6AC7,$6AC8,$6AC9,
$6ACA,$6ACB,$6ACC,$6ACD,$6ACE,$6ACF,$6AD0,$6AD1,$6AD2,$6AD3,$6AD4,$6AD5,$6AD6,
$6AD7,$6AD8,$6AD9,$6ADA,$6ADB,$6ADC,$6ADD,$6ADE,$6ADF,$6AE0,$6AE1,$6AE2,$6AE3,
$6AE4,$6AE5,$6AE6,$6AE7,$6AE8,$6AE9,$6AEA,$6AEB,$6AEC,$6AED,$6AEE,$6AEF,$6AF0,
$6AF1,$6AF2,$6AF3,$6AF4,$6AF5,$6AF6,$6AF7,$6AF8,$6AF9,$6AFA,$6AFB,$6AFC,$6AFD,
$6AFE,$6AFF,$6B00,$6B01,$6B02,$6B03,$6B04,$6B05,$6B06,$6B07,$6B08,$6B09,$6B0A,
$6B0B,$6B0C,$6B0D,$6B0E,$6B0F,$6B10,$6B11,$6B12,$6B13,$6B14,$6B15,$6B16,$6B17,
$6B18,$6B19,$6B1A,$6B1B,$6B1C,$6B1D,$6B1E,$6B1F,$6B20,$6B21,$6B22,$6B23,$6B24,
$6B25,$6B26,$6B27,$6B28,$6B29,$6B2A,$6B2B,$6B2C,$6B2D,$6B2E,$6B2F,$6B30,$6B31,
$6B32,$6B33,$6B34,$6B35,$6B36,$6B37,$6B38,$6B39,$6B3A,$6B3B,$6B3C,$6B3D,$6B3E,
$6B3F,$6B40,$6B41,$6B42,$6B43,$6B44,$6B45,$6B46,$6B47,$6B48,$6B49,$6B4A,$6B4B,
$6B4C,$6B4D,$6B4E,$6B4F,$6B50,$6B51,$6B52,$6B53,$6B54,$6B55,$6B56,$6B57,$6B58,
$6B59,$6B5A,$6B5B,$6B5C,$6B5D,$6B5E,$6B5F,$6B60,$6B61,$6B62,$6B63,$6B64,$6B65,
$6B66,$6B67,$6B68,$6B69,$6B6A,$6B6B,$6B6C,$6B6D,$6B6E,$6B6F,$6B70,$6B71,$6B72,
$6B73,$6B74,$6B75,$6B76,$6B77,$6B78,$6B79,$6B7A,$6B7B,$6B7C,$6B7D,$6B7E,$6B7F,
$6B80,$6B81,$6B82,$6B83,$6B84,$6B85,$6B86,$6B87,$6B88,$6B89,$6B8A,$6B8B,$6B8C,
$6B8D,$6B8E,$6B8F,$6B90,$6B91,$6B92,$6B93,$6B94,$6B95,$6B96,$6B97,$6B98,$6B99,
$6B9A,$6B9B,$6B9C,$6B9D,$6B9E,$6B9F,$6BA0,$6BA1,$6BA2,$6BA3,$6BA4,$6BA5,$6BA6,
$6BA7,$6BA8,$6BA9,$6BAA,$6BAB,$6BAC,$6BAD,$6BAE,$6BAF,$6BB0,$6BB1,$6BB2,$6BB3,
$6BB4,$6BB5,$6BB6,$6BB7,$6BB8,$6BB9,$6BBA,$6BBB,$6BBC,$6BBD,$6BBE,$6BBF,$6BC0,
$6BC1,$6BC2,$6BC3,$6BC4,$6BC5,$6BC6,$6BC7,$6BC8,$6BC9,$6BCA,$6BCB,$6BCC,$6BCD,
$6BCE,$6BCF,$6BD0,$6BD1,$6BD2,$6BD3,$6BD4,$6BD5,$6BD6,$6BD7,$6BD8,$6BD9,$6BDA,
$6BDB,$6BDC,$6BDD,$6BDE,$6BDF,$6BE0,$6BE1,$6BE2,$6BE3,$6BE4,$6BE5,$6BE6,$6BE7,
$6BE8,$6BE9,$6BEA,$6BEB,$6BEC,$6BED,$6BEE,$6BEF,$6BF0,$6BF1,$6BF2,$6BF3,$6BF4,
$6BF5,$6BF6,$6BF7,$6BF8,$6BF9,$6BFA,$6BFB,$6BFC,$6BFD,$6BFE,$6BFF,$6C00,$6C01,
$6C02,$6C03,$6C04,$6C05,$6C06,$6C07,$6C08,$6C09,$6C0A,$6C0B,$6C0C,$6C0D,$6C0E,
$6C0F,$6C10,$6C11,$6C12,$6C13,$6C14,$6C15,$6C16,$6C17,$6C18,$6C19,$6C1A,$6C1B,
$6C1C,$6C1D,$6C1E,$6C1F,$6C20,$6C21,$6C22,$6C23,$6C24,$6C25,$6C26,$6C27,$6C28,
$6C29,$6C2A,$6C2B,$6C2C,$6C2D,$6C2E,$6C2F,$6C30,$6C31,$6C32,$6C33,$6C34,$6C35,
$6C36,$6C37,$6C38,$6C39,$6C3A,$6C3B,$6C3C,$6C3D,$6C3E,$6C3F,$6C40,$6C41,$6C42,
$6C43,$6C44,$6C45,$6C46,$6C47,$6C48,$6C49,$6C4A,$6C4B,$6C4C,$6C4D,$6C4E,$6C4F,
$6C50,$6C51,$6C52,$6C53,$6C54,$6C55,$6C56,$6C57,$6C58,$6C59,$6C5A,$6C5B,$6C5C,
$6C5D,$6C5E,$6C5F,$6C60,$6C61,$6C62,$6C63,$6C64,$6C65,$6C66,$6C67,$6C68,$6C69,
$6C6A,$6C6B,$6C6C,$6C6D,$6C6E,$6C6F,$6C70,$6C71,$6C72,$6C73,$6C74,$6C75,$6C76,
$6C77,$6C78,$6C79,$6C7A,$6C7B,$6C7C,$6C7D,$6C7E,$6C7F,$6C80,$6C81,$6C82,$6C83,
$6C84,$6C85,$6C86,$6C87,$6C88,$6C89,$6C8A,$6C8B,$6C8C,$6C8D,$6C8E,$6C8F,$6C90,
$6C91,$6C92,$6C93,$6C94,$6C95,$6C96,$6C97,$6C98,$6C99,$6C9A,$6C9B,$6C9C,$6C9D,
$6C9E,$6C9F,$6CA0,$6CA1,$6CA2,$6CA3,$6CA4,$6CA5,$6CA6,$6CA7,$6CA8,$6CA9,$6CAA,
$6CAB,$6CAC,$6CAD,$6CAE,$6CAF,$6CB0,$6CB1,$6CB2,$6CB3,$6CB4,$6CB5,$6CB6,$6CB7,
$6CB8,$6CB9,$6CBA,$6CBB,$6CBC,$6CBD,$6CBE,$6CBF,$6CC0,$6CC1,$6CC2,$6CC3,$6CC4,
$6CC5,$6CC6,$6CC7,$6CC8,$6CC9,$6CCA,$6CCB,$6CCC,$6CCD,$6CCE,$6CCF,$6CD0,$6CD1,
$6CD2,$6CD3,$6CD4,$6CD5,$6CD6,$6CD7,$6CD8,$6CD9,$6CDA,$6CDB,$6CDC,$6CDD,$6CDE,
$6CDF,$6CE0,$6CE1,$6CE2,$6CE3,$6CE4,$6CE5,$6CE6,$6CE7,$6CE8,$6CE9,$6CEA,$6CEB,
$6CEC,$6CED,$6CEE,$6CEF,$6CF0,$6CF1,$6CF2,$6CF3,$6CF4,$6CF5,$6CF6,$6CF7,$6CF8,
$6CF9,$6CFA,$6CFB,$6CFC,$6CFD,$6CFE,$6CFF,$6D00,$6D01,$6D02,$6D03,$6D04,$6D05,
$6D06,$6D07,$6D08,$6D09,$6D0A,$6D0B,$6D0C,$6D0D,$6D0E,$6D0F,$6D10,$6D11,$6D12,
$6D13,$6D14,$6D15,$6D16,$6D17,$6D18,$6D19,$6D1A,$6D1B,$6D1C,$6D1D,$6D1E,$6D1F,
$6D20,$6D21,$6D22,$6D23,$6D24,$6D25,$6D26,$6D27,$6D28,$6D29,$6D2A,$6D2B,$6D2C,
$6D2D,$6D2E,$6D2F,$6D30,$6D31,$6D32,$6D33,$6D34,$6D35,$6D36,$6D37,$6D38,$6D39,
$6D3A,$6D3B,$6D3C,$6D3D,$6D3E,$6D3F,$6D40,$6D41,$6D42,$6D43,$6D44,$6D45,$6D46,
$6D47,$6D48,$6D49,$6D4A,$6D4B,$6D4C,$6D4D,$6D4E,$6D4F,$6D50,$6D51,$6D52,$6D53,
$6D54,$6D55,$6D56,$6D57,$6D58,$6D59,$6D5A,$6D5B,$6D5C,$6D5D,$6D5E,$6D5F,$6D60,
$6D61,$6D62,$6D63,$6D64,$6D65,$6D66,$6D67,$6D68,$6D69,$6D6A,$6D6B,$6D6C,$6D6D,
$6D6E,$6D6F,$6D70,$6D71,$6D72,$6D73,$6D74,$6D75,$6D76,$6D77,$6D78,$6D79,$6D7A,
$6D7B,$6D7C,$6D7D,$6D7E,$6D7F,$6D80,$6D81,$6D82,$6D83,$6D84,$6D85,$6D86,$6D87,
$6D88,$6D89,$6D8A,$6D8B,$6D8C,$6D8D,$6D8E,$6D8F,$6D90,$6D91,$6D92,$6D93,$6D94,
$6D95,$6D96,$6D97,$6D98,$6D99,$6D9A,$6D9B,$6D9C,$6D9D,$6D9E,$6D9F,$6DA0,$6DA1,
$6DA2,$6DA3,$6DA4,$6DA5,$6DA6,$6DA7,$6DA8,$6DA9,$6DAA,$6DAB,$6DAC,$6DAD,$6DAE,
$6DAF,$6DB0,$6DB1,$6DB2,$6DB3,$6DB4,$6DB5,$6DB6,$6DB7,$6DB8,$6DB9,$6DBA,$6DBB,
$6DBC,$6DBD,$6DBE,$6DBF,$6DC0,$6DC1,$6DC2,$6DC3,$6DC4,$6DC5,$6DC6,$6DC7,$6DC8,
$6DC9,$6DCA,$6DCB,$6DCC,$6DCD,$6DCE,$6DCF,$6DD0,$6DD1,$6DD2,$6DD3,$6DD4,$6DD5,
$6DD6,$6DD7,$6DD8,$6DD9,$6DDA,$6DDB,$6DDC,$6DDD,$6DDE,$6DDF,$6DE0,$6DE1,$6DE2,
$6DE3,$6DE4,$6DE5,$6DE6,$6DE7,$6DE8,$6DE9,$6DEA,$6DEB,$6DEC,$6DED,$6DEE,$6DEF,
$6DF0,$6DF1,$6DF2,$6DF3,$6DF4,$6DF5,$6DF6,$6DF7,$6DF8,$6DF9,$6DFA,$6DFB,$6DFC,
$6DFD,$6DFE,$6DFF,$6E00,$6E01,$6E02,$6E03,$6E04,$6E05,$6E06,$6E07,$6E08,$6E09,
$6E0A,$6E0B,$6E0C,$6E0D,$6E0E,$6E0F,$6E10,$6E11,$6E12,$6E13,$6E14,$6E15,$6E16,
$6E17,$6E18,$6E19,$6E1A,$6E1B,$6E1C,$6E1D,$6E1E,$6E1F,$6E20,$6E21,$6E22,$6E23,
$6E24,$6E25,$6E26,$6E27,$6E28,$6E29,$6E2A,$6E2B,$6E2C,$6E2D,$6E2E,$6E2F,$6E30,
$6E31,$6E32,$6E33,$6E34,$6E35,$6E36,$6E37,$6E38,$6E39,$6E3A,$6E3B,$6E3C,$6E3D,
$6E3E,$6E3F,$6E40,$6E41,$6E42,$6E43,$6E44,$6E45,$6E46,$6E47,$6E48,$6E49,$6E4A,
$6E4B,$6E4C,$6E4D,$6E4E,$6E4F,$6E50,$6E51,$6E52,$6E53,$6E54,$6E55,$6E56,$6E57,
$6E58,$6E59,$6E5A,$6E5B,$6E5C,$6E5D,$6E5E,$6E5F,$6E60,$6E61,$6E62,$6E63,$6E64,
$6E65,$6E66,$6E67,$6E68,$6E69,$6E6A,$6E6B,$6E6C,$6E6D,$6E6E,$6E6F,$6E70,$6E71,
$6E72,$6E73,$6E74,$6E75,$6E76,$6E77,$6E78,$6E79,$6E7A,$6E7B,$6E7C,$6E7D,$6E7E,
$6E7F,$6E80,$6E81,$6E82,$6E83,$6E84,$6E85,$6E86,$6E87,$6E88,$6E89,$6E8A,$6E8B,
$6E8C,$6E8D,$6E8E,$6E8F,$6E90,$6E91,$6E92,$6E93,$6E94,$6E95,$6E96,$6E97,$6E98,
$6E99,$6E9A,$6E9B,$6E9C,$6E9D,$6E9E,$6E9F,$6EA0,$6EA1,$6EA2,$6EA3,$6EA4,$6EA5,
$6EA6,$6EA7,$6EA8,$6EA9,$6EAA,$6EAB,$6EAC,$6EAD,$6EAE,$6EAF,$6EB0,$6EB1,$6EB2,
$6EB3,$6EB4,$6EB5,$6EB6,$6EB7,$6EB8,$6EB9,$6EBA,$6EBB,$6EBC,$6EBD,$6EBE,$6EBF,
$6EC0,$6EC1,$6EC2,$6EC3,$6EC4,$6EC5,$6EC6,$6EC7,$6EC8,$6EC9,$6ECA,$6ECB,$6ECC,
$6ECD,$6ECE,$6ECF,$6ED0,$6ED1,$6ED2,$6ED3,$6ED4,$6ED5,$6ED6,$6ED7,$6ED8,$6ED9,
$6EDA,$6EDB,$6EDC,$6EDD,$6EDE,$6EDF,$6EE0,$6EE1,$6EE2,$6EE3,$6EE4,$6EE5,$6EE6,
$6EE7,$6EE8,$6EE9,$6EEA,$6EEB,$6EEC,$6EED,$6EEE,$6EEF,$6EF0,$6EF1,$6EF2,$6EF3,
$6EF4,$6EF5,$6EF6,$6EF7,$6EF8,$6EF9,$6EFA,$6EFB,$6EFC,$6EFD,$6EFE,$6EFF,$6F00,
$6F01,$6F02,$6F03,$6F04,$6F05,$6F06,$6F07,$6F08,$6F09,$6F0A,$6F0B,$6F0C,$6F0D,
$6F0E,$6F0F,$6F10,$6F11,$6F12,$6F13,$6F14,$6F15,$6F16,$6F17,$6F18,$6F19,$6F1A,
$6F1B,$6F1C,$6F1D,$6F1E,$6F1F,$6F20,$6F21,$6F22,$6F23,$6F24,$6F25,$6F26,$6F27,
$6F28,$6F29,$6F2A,$6F2B,$6F2C,$6F2D,$6F2E,$6F2F,$6F30,$6F31,$6F32,$6F33,$6F34,
$6F35,$6F36,$6F37,$6F38,$6F39,$6F3A,$6F3B,$6F3C,$6F3D,$6F3E,$6F3F,$6F40,$6F41,
$6F42,$6F43,$6F44,$6F45,$6F46,$6F47,$6F48,$6F49,$6F4A,$6F4B,$6F4C,$6F4D,$6F4E,
$6F4F,$6F50,$6F51,$6F52,$6F53,$6F54,$6F55,$6F56,$6F57,$6F58,$6F59,$6F5A,$6F5B,
$6F5C,$6F5D,$6F5E,$6F5F,$6F60,$6F61,$6F62,$6F63,$6F64,$6F65,$6F66,$6F67,$6F68,
$6F69,$6F6A,$6F6B,$6F6C,$6F6D,$6F6E,$6F6F,$6F70,$6F71,$6F72,$6F73,$6F74,$6F75,
$6F76,$6F77,$6F78,$6F79,$6F7A,$6F7B,$6F7C,$6F7D,$6F7E,$6F7F,$6F80,$6F81,$6F82,
$6F83,$6F84,$6F85,$6F86,$6F87,$6F88,$6F89,$6F8A,$6F8B,$6F8C,$6F8D,$6F8E,$6F8F,
$6F90,$6F91,$6F92,$6F93,$6F94,$6F95,$6F96,$6F97,$6F98,$6F99,$6F9A,$6F9B,$6F9C,
$6F9D,$6F9E,$6F9F,$6FA0,$6FA1,$6FA2,$6FA3,$6FA4,$6FA5,$6FA6,$6FA7,$6FA8,$6FA9,
$6FAA,$6FAB,$6FAC,$6FAD,$6FAE,$6FAF,$6FB0,$6FB1,$6FB2,$6FB3,$6FB4,$6FB5,$6FB6,
$6FB7,$6FB8,$6FB9,$6FBA,$6FBB,$6FBC,$6FBD,$6FBE,$6FBF,$6FC0,$6FC1,$6FC2,$6FC3,
$6FC4,$6FC5,$6FC6,$6FC7,$6FC8,$6FC9,$6FCA,$6FCB,$6FCC,$6FCD,$6FCE,$6FCF,$6FD0,
$6FD1,$6FD2,$6FD3,$6FD4,$6FD5,$6FD6,$6FD7,$6FD8,$6FD9,$6FDA,$6FDB,$6FDC,$6FDD,
$6FDE,$6FDF,$6FE0,$6FE1,$6FE2,$6FE3,$6FE4,$6FE5,$6FE6,$6FE7,$6FE8,$6FE9,$6FEA,
$6FEB,$6FEC,$6FED,$6FEE,$6FEF,$6FF0,$6FF1,$6FF2,$6FF3,$6FF4,$6FF5,$6FF6,$6FF7,
$6FF8,$6FF9,$6FFA,$6FFB,$6FFC,$6FFD,$6FFE,$6FFF,$7000,$7001,$7002,$7003,$7004,
$7005,$7006,$7007,$7008,$7009,$700A,$700B,$700C,$700D,$700E,$700F,$7010,$7011,
$7012,$7013,$7014,$7015,$7016,$7017,$7018,$7019,$701A,$701B,$701C,$701D,$701E,
$701F,$7020,$7021,$7022,$7023,$7024,$7025,$7026,$7027,$7028,$7029,$702A,$702B,
$702C,$702D,$702E,$702F,$7030,$7031,$7032,$7033,$7034,$7035,$7036,$7037,$7038,
$7039,$703A,$703B,$703C,$703D,$703E,$703F,$7040,$7041,$7042,$7043,$7044,$7045,
$7046,$7047,$7048,$7049,$704A,$704B,$704C,$704D,$704E,$704F,$7050,$7051,$7052,
$7053,$7054,$7055,$7056,$7057,$7058,$7059,$705A,$705B,$705C,$705D,$705E,$705F,
$7060,$7061,$7062,$7063,$7064,$7065,$7066,$7067,$7068,$7069,$706A,$706B,$706C,
$706D,$706E,$706F,$7070,$7071,$7072,$7073,$7074,$7075,$7076,$7077,$7078,$7079,
$707A,$707B,$707C,$707D,$707E,$707F,$7080,$7081,$7082,$7083,$7084,$7085,$7086,
$7087,$7088,$7089,$708A,$708B,$708C,$708D,$708E,$708F,$7090,$7091,$7092,$7093,
$7094,$7095,$7096,$7097,$7098,$7099,$709A,$709B,$709C,$709D,$709E,$709F,$70A0,
$70A1,$70A2,$70A3,$70A4,$70A5,$70A6,$70A7,$70A8,$70A9,$70AA,$70AB,$70AC,$70AD,
$70AE,$70AF,$70B0,$70B1,$70B2,$70B3,$70B4,$70B5,$70B6,$70B7,$70B8,$70B9,$70BA,
$70BB,$70BC,$70BD,$70BE,$70BF,$70C0,$70C1,$70C2,$70C3,$70C4,$70C5,$70C6,$70C7,
$70C8,$70C9,$70CA,$70CB,$70CC,$70CD,$70CE,$70CF,$70D0,$70D1,$70D2,$70D3,$70D4,
$70D5,$70D6,$70D7,$70D8,$70D9,$70DA,$70DB,$70DC,$70DD,$70DE,$70DF,$70E0,$70E1,
$70E2,$70E3,$70E4,$70E5,$70E6,$70E7,$70E8,$70E9,$70EA,$70EB,$70EC,$70ED,$70EE,
$70EF,$70F0,$70F1,$70F2,$70F3,$70F4,$70F5,$70F6,$70F7,$70F8,$70F9,$70FA,$70FB,
$70FC,$70FD,$70FE,$70FF,$7100,$7101,$7102,$7103,$7104,$7105,$7106,$7107,$7108,
$7109,$710A,$710B,$710C,$710D,$710E,$710F,$7110,$7111,$7112,$7113,$7114,$7115,
$7116,$7117,$7118,$7119,$711A,$711B,$711C,$711D,$711E,$711F,$7120,$7121,$7122,
$7123,$7124,$7125,$7126,$7127,$7128,$7129,$712A,$712B,$712C,$712D,$712E,$712F,
$7130,$7131,$7132,$7133,$7134,$7135,$7136,$7137,$7138,$7139,$713A,$713B,$713C,
$713D,$713E,$713F,$7140,$7141,$7142,$7143,$7144,$7145,$7146,$7147,$7148,$7149,
$714A,$714B,$714C,$714D,$714E,$714F,$7150,$7151,$7152,$7153,$7154,$7155,$7156,
$7157,$7158,$7159,$715A,$715B,$715C,$715D,$715E,$715F,$7160,$7161,$7162,$7163,
$7164,$7165,$7166,$7167,$7168,$7169,$716A,$716B,$716C,$716D,$716E,$716F,$7170,
$7171,$7172,$7173,$7174,$7175,$7176,$7177,$7178,$7179,$717A,$717B,$717C,$717D,
$717E,$717F,$7180,$7181,$7182,$7183,$7184,$7185,$7186,$7187,$7188,$7189,$718A,
$718B,$718C,$718D,$718E,$718F,$7190,$7191,$7192,$7193,$7194,$7195,$7196,$7197,
$7198,$7199,$719A,$719B,$719C,$719D,$719E,$719F,$71A0,$71A1,$71A2,$71A3,$71A4,
$71A5,$71A6,$71A7,$71A8,$71A9,$71AA,$71AB,$71AC,$71AD,$71AE,$71AF,$71B0,$71B1,
$71B2,$71B3,$71B4,$71B5,$71B6,$71B7,$71B8,$71B9,$71BA,$71BB,$71BC,$71BD,$71BE,
$71BF,$71C0,$71C1,$71C2,$71C3,$71C4,$71C5,$71C6,$71C7,$71C8,$71C9,$71CA,$71CB,
$71CC,$71CD,$71CE,$71CF,$71D0,$71D1,$71D2,$71D3,$71D4,$71D5,$71D6,$71D7,$71D8,
$71D9,$71DA,$71DB,$71DC,$71DD,$71DE,$71DF,$71E0,$71E1,$71E2,$71E3,$71E4,$71E5,
$71E6,$71E7,$71E8,$71E9,$71EA,$71EB,$71EC,$71ED,$71EE,$71EF,$71F0,$71F1,$71F2,
$71F3,$71F4,$71F5,$71F6,$71F7,$71F8,$71F9,$71FA,$71FB,$71FC,$71FD,$71FE,$71FF,
$7200,$7201,$7202,$7203,$7204,$7205,$7206,$7207,$7208,$7209,$720A,$720B,$720C,
$720D,$720E,$720F,$7210,$7211,$7212,$7213,$7214,$7215,$7216,$7217,$7218,$7219,
$721A,$721B,$721C,$721D,$721E,$721F,$7220,$7221,$7222,$7223,$7224,$7225,$7226,
$7227,$7228,$7229,$722A,$722B,$722C,$722D,$722E,$722F,$7230,$7231,$7232,$7233,
$7234,$7235,$7236,$7237,$7238,$7239,$723A,$723B,$723C,$723D,$723E,$723F,$7240,
$7241,$7242,$7243,$7244,$7245,$7246,$7247,$7248,$7249,$724A,$724B,$724C,$724D,
$724E,$724F,$7250,$7251,$7252,$7253,$7254,$7255,$7256,$7257,$7258,$7259,$725A,
$725B,$725C,$725D,$725E,$725F,$7260,$7261,$7262,$7263,$7264,$7265,$7266,$7267,
$7268,$7269,$726A,$726B,$726C,$726D,$726E,$726F,$7270,$7271,$7272,$7273,$7274,
$7275,$7276,$7277,$7278,$7279,$727A,$727B,$727C,$727D,$727E,$727F,$7280,$7281,
$7282,$7283,$7284,$7285,$7286,$7287,$7288,$7289,$728A,$728B,$728C,$728D,$728E,
$728F,$7290,$7291,$7292,$7293,$7294,$7295,$7296,$7297,$7298,$7299,$729A,$729B,
$729C,$729D,$729E,$729F,$72A0,$72A1,$72A2,$72A3,$72A4,$72A5,$72A6,$72A7,$72A8,
$72A9,$72AA,$72AB,$72AC,$72AD,$72AE,$72AF,$72B0,$72B1,$72B2,$72B3,$72B4,$72B5,
$72B6,$72B7,$72B8,$72B9,$72BA,$72BB,$72BC,$72BD,$72BE,$72BF,$72C0,$72C1,$72C2,
$72C3,$72C4,$72C5,$72C6,$72C7,$72C8,$72C9,$72CA,$72CB,$72CC,$72CD,$72CE,$72CF,
$72D0,$72D1,$72D2,$72D3,$72D4,$72D5,$72D6,$72D7,$72D8,$72D9,$72DA,$72DB,$72DC,
$72DD,$72DE,$72DF,$72E0,$72E1,$72E2,$72E3,$72E4,$72E5,$72E6,$72E7,$72E8,$72E9,
$72EA,$72EB,$72EC,$72ED,$72EE,$72EF,$72F0,$72F1,$72F2,$72F3,$72F4,$72F5,$72F6,
$72F7,$72F8,$72F9,$72FA,$72FB,$72FC,$72FD,$72FE,$72FF,$7300,$7301,$7302,$7303,
$7304,$7305,$7306,$7307,$7308,$7309,$730A,$730B,$730C,$730D,$730E,$730F,$7310,
$7311,$7312,$7313,$7314,$7315,$7316,$7317,$7318,$7319,$731A,$731B,$731C,$731D,
$731E,$731F,$7320,$7321,$7322,$7323,$7324,$7325,$7326,$7327,$7328,$7329,$732A,
$732B,$732C,$732D,$732E,$732F,$7330,$7331,$7332,$7333,$7334,$7335,$7336,$7337,
$7338,$7339,$733A,$733B,$733C,$733D,$733E,$733F,$7340,$7341,$7342,$7343,$7344,
$7345,$7346,$7347,$7348,$7349,$734A,$734B,$734C,$734D,$734E,$734F,$7350,$7351,
$7352,$7353,$7354,$7355,$7356,$7357,$7358,$7359,$735A,$735B,$735C,$735D,$735E,
$735F,$7360,$7361,$7362,$7363,$7364,$7365,$7366,$7367,$7368,$7369,$736A,$736B,
$736C,$736D,$736E,$736F,$7370,$7371,$7372,$7373,$7374,$7375,$7376,$7377,$7378,
$7379,$737A,$737B,$737C,$737D,$737E,$737F,$7380,$7381,$7382,$7383,$7384,$7385,
$7386,$7387,$7388,$7389,$738A,$738B,$738C,$738D,$738E,$738F,$7390,$7391,$7392,
$7393,$7394,$7395,$7396,$7397,$7398,$7399,$739A,$739B,$739C,$739D,$739E,$739F,
$73A0,$73A1,$73A2,$73A3,$73A4,$73A5,$73A6,$73A7,$73A8,$73A9,$73AA,$73AB,$73AC,
$73AD,$73AE,$73AF,$73B0,$73B1,$73B2,$73B3,$73B4,$73B5,$73B6,$73B7,$73B8,$73B9,
$73BA,$73BB,$73BC,$73BD,$73BE,$73BF,$73C0,$73C1,$73C2,$73C3,$73C4,$73C5,$73C6,
$73C7,$73C8,$73C9,$73CA,$73CB,$73CC,$73CD,$73CE,$73CF,$73D0,$73D1,$73D2,$73D3,
$73D4,$73D5,$73D6,$73D7,$73D8,$73D9,$73DA,$73DB,$73DC,$73DD,$73DE,$73DF,$73E0,
$73E1,$73E2,$73E3,$73E4,$73E5,$73E6,$73E7,$73E8,$73E9,$73EA,$73EB,$73EC,$73ED,
$73EE,$73EF,$73F0,$73F1,$73F2,$73F3,$73F4,$73F5,$73F6,$73F7,$73F8,$73F9,$73FA,
$73FB,$73FC,$73FD,$73FE,$73FF,$7400,$7401,$7402,$7403,$7404,$7405,$7406,$7407,
$7408,$7409,$740A,$740B,$740C,$740D,$740E,$740F,$7410,$7411,$7412,$7413,$7414,
$7415,$7416,$7417,$7418,$7419,$741A,$741B,$741C,$741D,$741E,$741F,$7420,$7421,
$7422,$7423,$7424,$7425,$7426,$7427,$7428,$7429,$742A,$742B,$742C,$742D,$742E,
$742F,$7430,$7431,$7432,$7433,$7434,$7435,$7436,$7437,$7438,$7439,$743A,$743B,
$743C,$743D,$743E,$743F,$7440,$7441,$7442,$7443,$7444,$7445,$7446,$7447,$7448,
$7449,$744A,$744B,$744C,$744D,$744E,$744F,$7450,$7451,$7452,$7453,$7454,$7455,
$7456,$7457,$7458,$7459,$745A,$745B,$745C,$745D,$745E,$745F,$7460,$7461,$7462,
$7463,$7464,$7465,$7466,$7467,$7468,$7469,$746A,$746B,$746C,$746D,$746E,$746F,
$7470,$7471,$7472,$7473,$7474,$7475,$7476,$7477,$7478,$7479,$747A,$747B,$747C,
$747D,$747E,$747F,$7480,$7481,$7482,$7483,$7484,$7485,$7486,$7487,$7488,$7489,
$748A,$748B,$748C,$748D,$748E,$748F,$7490,$7491,$7492,$7493,$7494,$7495,$7496,
$7497,$7498,$7499,$749A,$749B,$749C,$749D,$749E,$749F,$74A0,$74A1,$74A2,$74A3,
$74A4,$74A5,$74A6,$74A7,$74A8,$74A9,$74AA,$74AB,$74AC,$74AD,$74AE,$74AF,$74B0,
$74B1,$74B2,$74B3,$74B4,$74B5,$74B6,$74B7,$74B8,$74B9,$74BA,$74BB,$74BC,$74BD,
$74BE,$74BF,$74C0,$74C1,$74C2,$74C3,$74C4,$74C5,$74C6,$74C7,$74C8,$74C9,$74CA,
$74CB,$74CC,$74CD,$74CE,$74CF,$74D0,$74D1,$74D2,$74D3,$74D4,$74D5,$74D6,$74D7,
$74D8,$74D9,$74DA,$74DB,$74DC,$74DD,$74DE,$74DF,$74E0,$74E1,$74E2,$74E3,$74E4,
$74E5,$74E6,$74E7,$74E8,$74E9,$74EA,$74EB,$74EC,$74ED,$74EE,$74EF,$74F0,$74F1,
$74F2,$74F3,$74F4,$74F5,$74F6,$74F7,$74F8,$74F9,$74FA,$74FB,$74FC,$74FD,$74FE,
$74FF,$7500,$7501,$7502,$7503,$7504,$7505,$7506,$7507,$7508,$7509,$750A,$750B,
$750C,$750D,$750E,$750F,$7510,$7511,$7512,$7513,$7514,$7515,$7516,$7517,$7518,
$7519,$751A,$751B,$751C,$751D,$751E,$751F,$7520,$7521,$7522,$7523,$7524,$7525,
$7526,$7527,$7528,$7529,$752A,$752B,$752C,$752D,$752E,$752F,$7530,$7531,$7532,
$7533,$7534,$7535,$7536,$7537,$7538,$7539,$753A,$753B,$753C,$753D,$753E,$753F,
$7540,$7541,$7542,$7543,$7544,$7545,$7546,$7547,$7548,$7549,$754A,$754B,$754C,
$754D,$754E,$754F,$7550,$7551,$7552,$7553,$7554,$7555,$7556,$7557,$7558,$7559,
$755A,$755B,$755C,$755D,$755E,$755F,$7560,$7561,$7562,$7563,$7564,$7565,$7566,
$7567,$7568,$7569,$756A,$756B,$756C,$756D,$756E,$756F,$7570,$7571,$7572,$7573,
$7574,$7575,$7576,$7577,$7578,$7579,$757A,$757B,$757C,$757D,$757E,$757F,$7580,
$7581,$7582,$7583,$7584,$7585,$7586,$7587,$7588,$7589,$758A,$758B,$758C,$758D,
$758E,$758F,$7590,$7591,$7592,$7593,$7594,$7595,$7596,$7597,$7598,$7599,$759A,
$759B,$759C,$759D,$759E,$759F,$75A0,$75A1,$75A2,$75A3,$75A4,$75A5,$75A6,$75A7,
$75A8,$75A9,$75AA,$75AB,$75AC,$75AD,$75AE,$75AF,$75B0,$75B1,$75B2,$75B3,$75B4,
$75B5,$75B6,$75B7,$75B8,$75B9,$75BA,$75BB,$75BC,$75BD,$75BE,$75BF,$75C0,$75C1,
$75C2,$75C3,$75C4,$75C5,$75C6,$75C7,$75C8,$75C9,$75CA,$75CB,$75CC,$75CD,$75CE,
$75CF,$75D0,$75D1,$75D2,$75D3,$75D4,$75D5,$75D6,$75D7,$75D8,$75D9,$75DA,$75DB,
$75DC,$75DD,$75DE,$75DF,$75E0,$75E1,$75E2,$75E3,$75E4,$75E5,$75E6,$75E7,$75E8,
$75E9,$75EA,$75EB,$75EC,$75ED,$75EE,$75EF,$75F0,$75F1,$75F2,$75F3,$75F4,$75F5,
$75F6,$75F7,$75F8,$75F9,$75FA,$75FB,$75FC,$75FD,$75FE,$75FF,$7600,$7601,$7602,
$7603,$7604,$7605,$7606,$7607,$7608,$7609,$760A,$760B,$760C,$760D,$760E,$760F,
$7610,$7611,$7612,$7613,$7614,$7615,$7616,$7617,$7618,$7619,$761A,$761B,$761C,
$761D,$761E,$761F,$7620,$7621,$7622,$7623,$7624,$7625,$7626,$7627,$7628,$7629,
$762A,$762B,$762C,$762D,$762E,$762F,$7630,$7631,$7632,$7633,$7634,$7635,$7636,
$7637,$7638,$7639,$763A,$763B,$763C,$763D,$763E,$763F,$7640,$7641,$7642,$7643,
$7644,$7645,$7646,$7647,$7648,$7649,$764A,$764B,$764C,$764D,$764E,$764F,$7650,
$7651,$7652,$7653,$7654,$7655,$7656,$7657,$7658,$7659,$765A,$765B,$765C,$765D,
$765E,$765F,$7660,$7661,$7662,$7663,$7664,$7665,$7666,$7667,$7668,$7669,$766A,
$766B,$766C,$766D,$766E,$766F,$7670,$7671,$7672,$7673,$7674,$7675,$7676,$7677,
$7678,$7679,$767A,$767B,$767C,$767D,$767E,$767F,$7680,$7681,$7682,$7683,$7684,
$7685,$7686,$7687,$7688,$7689,$768A,$768B,$768C,$768D,$768E,$768F,$7690,$7691,
$7692,$7693,$7694,$7695,$7696,$7697,$7698,$7699,$769A,$769B,$769C,$769D,$769E,
$769F,$76A0,$76A1,$76A2,$76A3,$76A4,$76A5,$76A6,$76A7,$76A8,$76A9,$76AA,$76AB,
$76AC,$76AD,$76AE,$76AF,$76B0,$76B1,$76B2,$76B3,$76B4,$76B5,$76B6,$76B7,$76B8,
$76B9,$76BA,$76BB,$76BC,$76BD,$76BE,$76BF,$76C0,$76C1,$76C2,$76C3,$76C4,$76C5,
$76C6,$76C7,$76C8,$76C9,$76CA,$76CB,$76CC,$76CD,$76CE,$76CF,$76D0,$76D1,$76D2,
$76D3,$76D4,$76D5,$76D6,$76D7,$76D8,$76D9,$76DA,$76DB,$76DC,$76DD,$76DE,$76DF,
$76E0,$76E1,$76E2,$76E3,$76E4,$76E5,$76E6,$76E7,$76E8,$76E9,$76EA,$76EB,$76EC,
$76ED,$76EE,$76EF,$76F0,$76F1,$76F2,$76F3,$76F4,$76F5,$76F6,$76F7,$76F8,$76F9,
$76FA,$76FB,$76FC,$76FD,$76FE,$76FF,$7700,$7701,$7702,$7703,$7704,$7705,$7706,
$7707,$7708,$7709,$770A,$770B,$770C,$770D,$770E,$770F,$7710,$7711,$7712,$7713,
$7714,$7715,$7716,$7717,$7718,$7719,$771A,$771B,$771C,$771D,$771E,$771F,$7720,
$7721,$7722,$7723,$7724,$7725,$7726,$7727,$7728,$7729,$772A,$772B,$772C,$772D,
$772E,$772F,$7730,$7731,$7732,$7733,$7734,$7735,$7736,$7737,$7738,$7739,$773A,
$773B,$773C,$773D,$773E,$773F,$7740,$7741,$7742,$7743,$7744,$7745,$7746,$7747,
$7748,$7749,$774A,$774B,$774C,$774D,$774E,$774F,$7750,$7751,$7752,$7753,$7754,
$7755,$7756,$7757,$7758,$7759,$775A,$775B,$775C,$775D,$775E,$775F,$7760,$7761,
$7762,$7763,$7764,$7765,$7766,$7767,$7768,$7769,$776A,$776B,$776C,$776D,$776E,
$776F,$7770,$7771,$7772,$7773,$7774,$7775,$7776,$7777,$7778,$7779,$777A,$777B,
$777C,$777D,$777E,$777F,$7780,$7781,$7782,$7783,$7784,$7785,$7786,$7787,$7788,
$7789,$778A,$778B,$778C,$778D,$778E,$778F,$7790,$7791,$7792,$7793,$7794,$7795,
$7796,$7797,$7798,$7799,$779A,$779B,$779C,$779D,$779E,$779F,$77A0,$77A1,$77A2,
$77A3,$77A4,$77A5,$77A6,$77A7,$77A8,$77A9,$77AA,$77AB,$77AC,$77AD,$77AE,$77AF,
$77B0,$77B1,$77B2,$77B3,$77B4,$77B5,$77B6,$77B7,$77B8,$77B9,$77BA,$77BB,$77BC,
$77BD,$77BE,$77BF,$77C0,$77C1,$77C2,$77C3,$77C4,$77C5,$77C6,$77C7,$77C8,$77C9,
$77CA,$77CB,$77CC,$77CD,$77CE,$77CF,$77D0,$77D1,$77D2,$77D3,$77D4,$77D5,$77D6,
$77D7,$77D8,$77D9,$77DA,$77DB,$77DC,$77DD,$77DE,$77DF,$77E0,$77E1,$77E2,$77E3,
$77E4,$77E5,$77E6,$77E7,$77E8,$77E9,$77EA,$77EB,$77EC,$77ED,$77EE,$77EF,$77F0,
$77F1,$77F2,$77F3,$77F4,$77F5,$77F6,$77F7,$77F8,$77F9,$77FA,$77FB,$77FC,$77FD,
$77FE,$77FF,$7800,$7801,$7802,$7803,$7804,$7805,$7806,$7807,$7808,$7809,$780A,
$780B,$780C,$780D,$780E,$780F,$7810,$7811,$7812,$7813,$7814,$7815,$7816,$7817,
$7818,$7819,$781A,$781B,$781C,$781D,$781E,$781F,$7820,$7821,$7822,$7823,$7824,
$7825,$7826,$7827,$7828,$7829,$782A,$782B,$782C,$782D,$782E,$782F,$7830,$7831,
$7832,$7833,$7834,$7835,$7836,$7837,$7838,$7839,$783A,$783B,$783C,$783D,$783E,
$783F,$7840,$7841,$7842,$7843,$7844,$7845,$7846,$7847,$7848,$7849,$784A,$784B,
$784C,$784D,$784E,$784F,$7850,$7851,$7852,$7853,$7854,$7855,$7856,$7857,$7858,
$7859,$785A,$785B,$785C,$785D,$785E,$785F,$7860,$7861,$7862,$7863,$7864,$7865,
$7866,$7867,$7868,$7869,$786A,$786B,$786C,$786D,$786E,$786F,$7870,$7871,$7872,
$7873,$7874,$7875,$7876,$7877,$7878,$7879,$787A,$787B,$787C,$787D,$787E,$787F,
$7880,$7881,$7882,$7883,$7884,$7885,$7886,$7887,$7888,$7889,$788A,$788B,$788C,
$788D,$788E,$788F,$7890,$7891,$7892,$7893,$7894,$7895,$7896,$7897,$7898,$7899,
$789A,$789B,$789C,$789D,$789E,$789F,$78A0,$78A1,$78A2,$78A3,$78A4,$78A5,$78A6,
$78A7,$78A8,$78A9,$78AA,$78AB,$78AC,$78AD,$78AE,$78AF,$78B0,$78B1,$78B2,$78B3,
$78B4,$78B5,$78B6,$78B7,$78B8,$78B9,$78BA,$78BB,$78BC,$78BD,$78BE,$78BF,$78C0,
$78C1,$78C2,$78C3,$78C4,$78C5,$78C6,$78C7,$78C8,$78C9,$78CA,$78CB,$78CC,$78CD,
$78CE,$78CF,$78D0,$78D1,$78D2,$78D3,$78D4,$78D5,$78D6,$78D7,$78D8,$78D9,$78DA,
$78DB,$78DC,$78DD,$78DE,$78DF,$78E0,$78E1,$78E2,$78E3,$78E4,$78E5,$78E6,$78E7,
$78E8,$78E9,$78EA,$78EB,$78EC,$78ED,$78EE,$78EF,$78F0,$78F1,$78F2,$78F3,$78F4,
$78F5,$78F6,$78F7,$78F8,$78F9,$78FA,$78FB,$78FC,$78FD,$78FE,$78FF,$7900,$7901,
$7902,$7903,$7904,$7905,$7906,$7907,$7908,$7909,$790A,$790B,$790C,$790D,$790E,
$790F,$7910,$7911,$7912,$7913,$7914,$7915,$7916,$7917,$7918,$7919,$791A,$791B,
$791C,$791D,$791E,$791F,$7920,$7921,$7922,$7923,$7924,$7925,$7926,$7927,$7928,
$7929,$792A,$792B,$792C,$792D,$792E,$792F,$7930,$7931,$7932,$7933,$7934,$7935,
$7936,$7937,$7938,$7939,$793A,$793B,$793C,$793D,$793E,$793F,$7940,$7941,$7942,
$7943,$7944,$7945,$7946,$7947,$7948,$7949,$794A,$794B,$794C,$794D,$794E,$794F,
$7950,$7951,$7952,$7953,$7954,$7955,$7956,$7957,$7958,$7959,$795A,$795B,$795C,
$795D,$795E,$795F,$7960,$7961,$7962,$7963,$7964,$7965,$7966,$7967,$7968,$7969,
$796A,$796B,$796C,$796D,$796E,$796F,$7970,$7971,$7972,$7973,$7974,$7975,$7976,
$7977,$7978,$7979,$797A,$797B,$797C,$797D,$797E,$797F,$7980,$7981,$7982,$7983,
$7984,$7985,$7986,$7987,$7988,$7989,$798A,$798B,$798C,$798D,$798E,$798F,$7990,
$7991,$7992,$7993,$7994,$7995,$7996,$7997,$7998,$7999,$799A,$799B,$799C,$799D,
$799E,$799F,$79A0,$79A1,$79A2,$79A3,$79A4,$79A5,$79A6,$79A7,$79A8,$79A9,$79AA,
$79AB,$79AC,$79AD,$79AE,$79AF,$79B0,$79B1,$79B2,$79B3,$79B4,$79B5,$79B6,$79B7,
$79B8,$79B9,$79BA,$79BB,$79BC,$79BD,$79BE,$79BF,$79C0,$79C1,$79C2,$79C3,$79C4,
$79C5,$79C6,$79C7,$79C8,$79C9,$79CA,$79CB,$79CC,$79CD,$79CE,$79CF,$79D0,$79D1,
$79D2,$79D3,$79D4,$79D5,$79D6,$79D7,$79D8,$79D9,$79DA,$79DB,$79DC,$79DD,$79DE,
$79DF,$79E0,$79E1,$79E2,$79E3,$79E4,$79E5,$79E6,$79E7,$79E8,$79E9,$79EA,$79EB,
$79EC,$79ED,$79EE,$79EF,$79F0,$79F1,$79F2,$79F3,$79F4,$79F5,$79F6,$79F7,$79F8,
$79F9,$79FA,$79FB,$79FC,$79FD,$79FE,$79FF,$7A00,$7A01,$7A02,$7A03,$7A04,$7A05,
$7A06,$7A07,$7A08,$7A09,$7A0A,$7A0B,$7A0C,$7A0D,$7A0E,$7A0F,$7A10,$7A11,$7A12,
$7A13,$7A14,$7A15,$7A16,$7A17,$7A18,$7A19,$7A1A,$7A1B,$7A1C,$7A1D,$7A1E,$7A1F,
$7A20,$7A21,$7A22,$7A23,$7A24,$7A25,$7A26,$7A27,$7A28,$7A29,$7A2A,$7A2B,$7A2C,
$7A2D,$7A2E,$7A2F,$7A30,$7A31,$7A32,$7A33,$7A34,$7A35,$7A36,$7A37,$7A38,$7A39,
$7A3A,$7A3B,$7A3C,$7A3D,$7A3E,$7A3F,$7A40,$7A41,$7A42,$7A43,$7A44,$7A45,$7A46,
$7A47,$7A48,$7A49,$7A4A,$7A4B,$7A4C,$7A4D,$7A4E,$7A4F,$7A50,$7A51,$7A52,$7A53,
$7A54,$7A55,$7A56,$7A57,$7A58,$7A59,$7A5A,$7A5B,$7A5C,$7A5D,$7A5E,$7A5F,$7A60,
$7A61,$7A62,$7A63,$7A64,$7A65,$7A66,$7A67,$7A68,$7A69,$7A6A,$7A6B,$7A6C,$7A6D,
$7A6E,$7A6F,$7A70,$7A71,$7A72,$7A73,$7A74,$7A75,$7A76,$7A77,$7A78,$7A79,$7A7A,
$7A7B,$7A7C,$7A7D,$7A7E,$7A7F,$7A80,$7A81,$7A82,$7A83,$7A84,$7A85,$7A86,$7A87,
$7A88,$7A89,$7A8A,$7A8B,$7A8C,$7A8D,$7A8E,$7A8F,$7A90,$7A91,$7A92,$7A93,$7A94,
$7A95,$7A96,$7A97,$7A98,$7A99,$7A9A,$7A9B,$7A9C,$7A9D,$7A9E,$7A9F,$7AA0,$7AA1,
$7AA2,$7AA3,$7AA4,$7AA5,$7AA6,$7AA7,$7AA8,$7AA9,$7AAA,$7AAB,$7AAC,$7AAD,$7AAE,
$7AAF,$7AB0,$7AB1,$7AB2,$7AB3,$7AB4,$7AB5,$7AB6,$7AB7,$7AB8,$7AB9,$7ABA,$7ABB,
$7ABC,$7ABD,$7ABE,$7ABF,$7AC0,$7AC1,$7AC2,$7AC3,$7AC4,$7AC5,$7AC6,$7AC7,$7AC8,
$7AC9,$7ACA,$7ACB,$7ACC,$7ACD,$7ACE,$7ACF,$7AD0,$7AD1,$7AD2,$7AD3,$7AD4,$7AD5,
$7AD6,$7AD7,$7AD8,$7AD9,$7ADA,$7ADB,$7ADC,$7ADD,$7ADE,$7ADF,$7AE0,$7AE1,$7AE2,
$7AE3,$7AE4,$7AE5,$7AE6,$7AE7,$7AE8,$7AE9,$7AEA,$7AEB,$7AEC,$7AED,$7AEE,$7AEF,
$7AF0,$7AF1,$7AF2,$7AF3,$7AF4,$7AF5,$7AF6,$7AF7,$7AF8,$7AF9,$7AFA,$7AFB,$7AFC,
$7AFD,$7AFE,$7AFF,$7B00,$7B01,$7B02,$7B03,$7B04,$7B05,$7B06,$7B07,$7B08,$7B09,
$7B0A,$7B0B,$7B0C,$7B0D,$7B0E,$7B0F,$7B10,$7B11,$7B12,$7B13,$7B14,$7B15,$7B16,
$7B17,$7B18,$7B19,$7B1A,$7B1B,$7B1C,$7B1D,$7B1E,$7B1F,$7B20,$7B21,$7B22,$7B23,
$7B24,$7B25,$7B26,$7B27,$7B28,$7B29,$7B2A,$7B2B,$7B2C,$7B2D,$7B2E,$7B2F,$7B30,
$7B31,$7B32,$7B33,$7B34,$7B35,$7B36,$7B37,$7B38,$7B39,$7B3A,$7B3B,$7B3C,$7B3D,
$7B3E,$7B3F,$7B40,$7B41,$7B42,$7B43,$7B44,$7B45,$7B46,$7B47,$7B48,$7B49,$7B4A,
$7B4B,$7B4C,$7B4D,$7B4E,$7B4F,$7B50,$7B51,$7B52,$7B53,$7B54,$7B55,$7B56,$7B57,
$7B58,$7B59,$7B5A,$7B5B,$7B5C,$7B5D,$7B5E,$7B5F,$7B60,$7B61,$7B62,$7B63,$7B64,
$7B65,$7B66,$7B67,$7B68,$7B69,$7B6A,$7B6B,$7B6C,$7B6D,$7B6E,$7B6F,$7B70,$7B71,
$7B72,$7B73,$7B74,$7B75,$7B76,$7B77,$7B78,$7B79,$7B7A,$7B7B,$7B7C,$7B7D,$7B7E,
$7B7F,$7B80,$7B81,$7B82,$7B83,$7B84,$7B85,$7B86,$7B87,$7B88,$7B89,$7B8A,$7B8B,
$7B8C,$7B8D,$7B8E,$7B8F,$7B90,$7B91,$7B92,$7B93,$7B94,$7B95,$7B96,$7B97,$7B98,
$7B99,$7B9A,$7B9B,$7B9C,$7B9D,$7B9E,$7B9F,$7BA0,$7BA1,$7BA2,$7BA3,$7BA4,$7BA5,
$7BA6,$7BA7,$7BA8,$7BA9,$7BAA,$7BAB,$7BAC,$7BAD,$7BAE,$7BAF,$7BB0,$7BB1,$7BB2,
$7BB3,$7BB4,$7BB5,$7BB6,$7BB7,$7BB8,$7BB9,$7BBA,$7BBB,$7BBC,$7BBD,$7BBE,$7BBF,
$7BC0,$7BC1,$7BC2,$7BC3,$7BC4,$7BC5,$7BC6,$7BC7,$7BC8,$7BC9,$7BCA,$7BCB,$7BCC,
$7BCD,$7BCE,$7BCF,$7BD0,$7BD1,$7BD2,$7BD3,$7BD4,$7BD5,$7BD6,$7BD7,$7BD8,$7BD9,
$7BDA,$7BDB,$7BDC,$7BDD,$7BDE,$7BDF,$7BE0,$7BE1,$7BE2,$7BE3,$7BE4,$7BE5,$7BE6,
$7BE7,$7BE8,$7BE9,$7BEA,$7BEB,$7BEC,$7BED,$7BEE,$7BEF,$7BF0,$7BF1,$7BF2,$7BF3,
$7BF4,$7BF5,$7BF6,$7BF7,$7BF8,$7BF9,$7BFA,$7BFB,$7BFC,$7BFD,$7BFE,$7BFF,$7C00,
$7C01,$7C02,$7C03,$7C04,$7C05,$7C06,$7C07,$7C08,$7C09,$7C0A,$7C0B,$7C0C,$7C0D,
$7C0E,$7C0F,$7C10,$7C11,$7C12,$7C13,$7C14,$7C15,$7C16,$7C17,$7C18,$7C19,$7C1A,
$7C1B,$7C1C,$7C1D,$7C1E,$7C1F,$7C20,$7C21,$7C22,$7C23,$7C24,$7C25,$7C26,$7C27,
$7C28,$7C29,$7C2A,$7C2B,$7C2C,$7C2D,$7C2E,$7C2F,$7C30,$7C31,$7C32,$7C33,$7C34,
$7C35,$7C36,$7C37,$7C38,$7C39,$7C3A,$7C3B,$7C3C,$7C3D,$7C3E,$7C3F,$7C40,$7C41,
$7C42,$7C43,$7C44,$7C45,$7C46,$7C47,$7C48,$7C49,$7C4A,$7C4B,$7C4C,$7C4D,$7C4E,
$7C4F,$7C50,$7C51,$7C52,$7C53,$7C54,$7C55,$7C56,$7C57,$7C58,$7C59,$7C5A,$7C5B,
$7C5C,$7C5D,$7C5E,$7C5F,$7C60,$7C61,$7C62,$7C63,$7C64,$7C65,$7C66,$7C67,$7C68,
$7C69,$7C6A,$7C6B,$7C6C,$7C6D,$7C6E,$7C6F,$7C70,$7C71,$7C72,$7C73,$7C74,$7C75,
$7C76,$7C77,$7C78,$7C79,$7C7A,$7C7B,$7C7C,$7C7D,$7C7E,$7C7F,$7C80,$7C81,$7C82,
$7C83,$7C84,$7C85,$7C86,$7C87,$7C88,$7C89,$7C8A,$7C8B,$7C8C,$7C8D,$7C8E,$7C8F,
$7C90,$7C91,$7C92,$7C93,$7C94,$7C95,$7C96,$7C97,$7C98,$7C99,$7C9A,$7C9B,$7C9C,
$7C9D,$7C9E,$7C9F,$7CA0,$7CA1,$7CA2,$7CA3,$7CA4,$7CA5,$7CA6,$7CA7,$7CA8,$7CA9,
$7CAA,$7CAB,$7CAC,$7CAD,$7CAE,$7CAF,$7CB0,$7CB1,$7CB2,$7CB3,$7CB4,$7CB5,$7CB6,
$7CB7,$7CB8,$7CB9,$7CBA,$7CBB,$7CBC,$7CBD,$7CBE,$7CBF,$7CC0,$7CC1,$7CC2,$7CC3,
$7CC4,$7CC5,$7CC6,$7CC7,$7CC8,$7CC9,$7CCA,$7CCB,$7CCC,$7CCD,$7CCE,$7CCF,$7CD0,
$7CD1,$7CD2,$7CD3,$7CD4,$7CD5,$7CD6,$7CD7,$7CD8,$7CD9,$7CDA,$7CDB,$7CDC,$7CDD,
$7CDE,$7CDF,$7CE0,$7CE1,$7CE2,$7CE3,$7CE4,$7CE5,$7CE6,$7CE7,$7CE8,$7CE9,$7CEA,
$7CEB,$7CEC,$7CED,$7CEE,$7CEF,$7CF0,$7CF1,$7CF2,$7CF3,$7CF4,$7CF5,$7CF6,$7CF7,
$7CF8,$7CF9,$7CFA,$7CFB,$7CFC,$7CFD,$7CFE,$7CFF,$7D00,$7D01,$7D02,$7D03,$7D04,
$7D05,$7D06,$7D07,$7D08,$7D09,$7D0A,$7D0B,$7D0C,$7D0D,$7D0E,$7D0F,$7D10,$7D11,
$7D12,$7D13,$7D14,$7D15,$7D16,$7D17,$7D18,$7D19,$7D1A,$7D1B,$7D1C,$7D1D,$7D1E,
$7D1F,$7D20,$7D21,$7D22,$7D23,$7D24,$7D25,$7D26,$7D27,$7D28,$7D29,$7D2A,$7D2B,
$7D2C,$7D2D,$7D2E,$7D2F,$7D30,$7D31,$7D32,$7D33,$7D34,$7D35,$7D36,$7D37,$7D38,
$7D39,$7D3A,$7D3B,$7D3C,$7D3D,$7D3E,$7D3F,$7D40,$7D41,$7D42,$7D43,$7D44,$7D45,
$7D46,$7D47,$7D48,$7D49,$7D4A,$7D4B,$7D4C,$7D4D,$7D4E,$7D4F,$7D50,$7D51,$7D52,
$7D53,$7D54,$7D55,$7D56,$7D57,$7D58,$7D59,$7D5A,$7D5B,$7D5C,$7D5D,$7D5E,$7D5F,
$7D60,$7D61,$7D62,$7D63,$7D64,$7D65,$7D66,$7D67,$7D68,$7D69,$7D6A,$7D6B,$7D6C,
$7D6D,$7D6E,$7D6F,$7D70,$7D71,$7D72,$7D73,$7D74,$7D75,$7D76,$7D77,$7D78,$7D79,
$7D7A,$7D7B,$7D7C,$7D7D,$7D7E,$7D7F,$7D80,$7D81,$7D82,$7D83,$7D84,$7D85,$7D86,
$7D87,$7D88,$7D89,$7D8A,$7D8B,$7D8C,$7D8D,$7D8E,$7D8F,$7D90,$7D91,$7D92,$7D93,
$7D94,$7D95,$7D96,$7D97,$7D98,$7D99,$7D9A,$7D9B,$7D9C,$7D9D,$7D9E,$7D9F,$7DA0,
$7DA1,$7DA2,$7DA3,$7DA4,$7DA5,$7DA6,$7DA7,$7DA8,$7DA9,$7DAA,$7DAB,$7DAC,$7DAD,
$7DAE,$7DAF,$7DB0,$7DB1,$7DB2,$7DB3,$7DB4,$7DB5,$7DB6,$7DB7,$7DB8,$7DB9,$7DBA,
$7DBB,$7DBC,$7DBD,$7DBE,$7DBF,$7DC0,$7DC1,$7DC2,$7DC3,$7DC4,$7DC5,$7DC6,$7DC7,
$7DC8,$7DC9,$7DCA,$7DCB,$7DCC,$7DCD,$7DCE,$7DCF,$7DD0,$7DD1,$7DD2,$7DD3,$7DD4,
$7DD5,$7DD6,$7DD7,$7DD8,$7DD9,$7DDA,$7DDB,$7DDC,$7DDD,$7DDE,$7DDF,$7DE0,$7DE1,
$7DE2,$7DE3,$7DE4,$7DE5,$7DE6,$7DE7,$7DE8,$7DE9,$7DEA,$7DEB,$7DEC,$7DED,$7DEE,
$7DEF,$7DF0,$7DF1,$7DF2,$7DF3,$7DF4,$7DF5,$7DF6,$7DF7,$7DF8,$7DF9,$7DFA,$7DFB,
$7DFC,$7DFD,$7DFE,$7DFF,$7E00,$7E01,$7E02,$7E03,$7E04,$7E05,$7E06,$7E07,$7E08,
$7E09,$7E0A,$7E0B,$7E0C,$7E0D,$7E0E,$7E0F,$7E10,$7E11,$7E12,$7E13,$7E14,$7E15,
$7E16,$7E17,$7E18,$7E19,$7E1A,$7E1B,$7E1C,$7E1D,$7E1E,$7E1F,$7E20,$7E21,$7E22,
$7E23,$7E24,$7E25,$7E26,$7E27,$7E28,$7E29,$7E2A,$7E2B,$7E2C,$7E2D,$7E2E,$7E2F,
$7E30,$7E31,$7E32,$7E33,$7E34,$7E35,$7E36,$7E37,$7E38,$7E39,$7E3A,$7E3B,$7E3C,
$7E3D,$7E3E,$7E3F,$7E40,$7E41,$7E42,$7E43,$7E44,$7E45,$7E46,$7E47,$7E48,$7E49,
$7E4A,$7E4B,$7E4C,$7E4D,$7E4E,$7E4F,$7E50,$7E51,$7E52,$7E53,$7E54,$7E55,$7E56,
$7E57,$7E58,$7E59,$7E5A,$7E5B,$7E5C,$7E5D,$7E5E,$7E5F,$7E60,$7E61,$7E62,$7E63,
$7E64,$7E65,$7E66,$7E67,$7E68,$7E69,$7E6A,$7E6B,$7E6C,$7E6D,$7E6E,$7E6F,$7E70,
$7E71,$7E72,$7E73,$7E74,$7E75,$7E76,$7E77,$7E78,$7E79,$7E7A,$7E7B,$7E7C,$7E7D,
$7E7E,$7E7F,$7E80,$7E81,$7E82,$7E83,$7E84,$7E85,$7E86,$7E87,$7E88,$7E89,$7E8A,
$7E8B,$7E8C,$7E8D,$7E8E,$7E8F,$7E90,$7E91,$7E92,$7E93,$7E94,$7E95,$7E96,$7E97,
$7E98,$7E99,$7E9A,$7E9B,$7E9C,$7E9D,$7E9E,$7E9F,$7EA0,$7EA1,$7EA2,$7EA3,$7EA4,
$7EA5,$7EA6,$7EA7,$7EA8,$7EA9,$7EAA,$7EAB,$7EAC,$7EAD,$7EAE,$7EAF,$7EB0,$7EB1,
$7EB2,$7EB3,$7EB4,$7EB5,$7EB6,$7EB7,$7EB8,$7EB9,$7EBA,$7EBB,$7EBC,$7EBD,$7EBE,
$7EBF,$7EC0,$7EC1,$7EC2,$7EC3,$7EC4,$7EC5,$7EC6,$7EC7,$7EC8,$7EC9,$7ECA,$7ECB,
$7ECC,$7ECD,$7ECE,$7ECF,$7ED0,$7ED1,$7ED2,$7ED3,$7ED4,$7ED5,$7ED6,$7ED7,$7ED8,
$7ED9,$7EDA,$7EDB,$7EDC,$7EDD,$7EDE,$7EDF,$7EE0,$7EE1,$7EE2,$7EE3,$7EE4,$7EE5,
$7EE6,$7EE7,$7EE8,$7EE9,$7EEA,$7EEB,$7EEC,$7EED,$7EEE,$7EEF,$7EF0,$7EF1,$7EF2,
$7EF3,$7EF4,$7EF5,$7EF6,$7EF7,$7EF8,$7EF9,$7EFA,$7EFB,$7EFC,$7EFD,$7EFE,$7EFF,
$7F00,$7F01,$7F02,$7F03,$7F04,$7F05,$7F06,$7F07,$7F08,$7F09,$7F0A,$7F0B,$7F0C,
$7F0D,$7F0E,$7F0F,$7F10,$7F11,$7F12,$7F13,$7F14,$7F15,$7F16,$7F17,$7F18,$7F19,
$7F1A,$7F1B,$7F1C,$7F1D,$7F1E,$7F1F,$7F20,$7F21,$7F22,$7F23,$7F24,$7F25,$7F26,
$7F27,$7F28,$7F29,$7F2A,$7F2B,$7F2C,$7F2D,$7F2E,$7F2F,$7F30,$7F31,$7F32,$7F33,
$7F34,$7F35,$7F36,$7F37,$7F38,$7F39,$7F3A,$7F3B,$7F3C,$7F3D,$7F3E,$7F3F,$7F40,
$7F41,$7F42,$7F43,$7F44,$7F45,$7F46,$7F47,$7F48,$7F49,$7F4A,$7F4B,$7F4C,$7F4D,
$7F4E,$7F4F,$7F50,$7F51,$7F52,$7F53,$7F54,$7F55,$7F56,$7F57,$7F58,$7F59,$7F5A,
$7F5B,$7F5C,$7F5D,$7F5E,$7F5F,$7F60,$7F61,$7F62,$7F63,$7F64,$7F65,$7F66,$7F67,
$7F68,$7F69,$7F6A,$7F6B,$7F6C,$7F6D,$7F6E,$7F6F,$7F70,$7F71,$7F72,$7F73,$7F74,
$7F75,$7F76,$7F77,$7F78,$7F79,$7F7A,$7F7B,$7F7C,$7F7D,$7F7E,$7F7F,$7F80,$7F81,
$7F82,$7F83,$7F84,$7F85,$7F86,$7F87,$7F88,$7F89,$7F8A,$7F8B,$7F8C,$7F8D,$7F8E,
$7F8F,$7F90,$7F91,$7F92,$7F93,$7F94,$7F95,$7F96,$7F97,$7F98,$7F99,$7F9A,$7F9B,
$7F9C,$7F9D,$7F9E,$7F9F,$7FA0,$7FA1,$7FA2,$7FA3,$7FA4,$7FA5,$7FA6,$7FA7,$7FA8,
$7FA9,$7FAA,$7FAB,$7FAC,$7FAD,$7FAE,$7FAF,$7FB0,$7FB1,$7FB2,$7FB3,$7FB4,$7FB5,
$7FB6,$7FB7,$7FB8,$7FB9,$7FBA,$7FBB,$7FBC,$7FBD,$7FBE,$7FBF,$7FC0,$7FC1,$7FC2,
$7FC3,$7FC4,$7FC5,$7FC6,$7FC7,$7FC8,$7FC9,$7FCA,$7FCB,$7FCC,$7FCD,$7FCE,$7FCF,
$7FD0,$7FD1,$7FD2,$7FD3,$7FD4,$7FD5,$7FD6,$7FD7,$7FD8,$7FD9,$7FDA,$7FDB,$7FDC,
$7FDD,$7FDE,$7FDF,$7FE0,$7FE1,$7FE2,$7FE3,$7FE4,$7FE5,$7FE6,$7FE7,$7FE8,$7FE9,
$7FEA,$7FEB,$7FEC,$7FED,$7FEE,$7FEF,$7FF0,$7FF1,$7FF2,$7FF3,$7FF4,$7FF5,$7FF6,
$7FF7,$7FF8,$7FF9,$7FFA,$7FFB,$7FFC,$7FFD,$7FFE,$7FFF,$8000,$8001,$8002,$8003,
$8004,$8005,$8006,$8007,$8008,$8009,$800A,$800B,$800C,$800D,$800E,$800F,$8010,
$8011,$8012,$8013,$8014,$8015,$8016,$8017,$8018,$8019,$801A,$801B,$801C,$801D,
$801E,$801F,$8020,$8021,$8022,$8023,$8024,$8025,$8026,$8027,$8028,$8029,$802A,
$802B,$802C,$802D,$802E,$802F,$8030,$8031,$8032,$8033,$8034,$8035,$8036,$8037,
$8038,$8039,$803A,$803B,$803C,$803D,$803E,$803F,$8040,$8041,$8042,$8043,$8044,
$8045,$8046,$8047,$8048,$8049,$804A,$804B,$804C,$804D,$804E,$804F,$8050,$8051,
$8052,$8053,$8054,$8055,$8056,$8057,$8058,$8059,$805A,$805B,$805C,$805D,$805E,
$805F,$8060,$8061,$8062,$8063,$8064,$8065,$8066,$8067,$8068,$8069,$806A,$806B,
$806C,$806D,$806E,$806F,$8070,$8071,$8072,$8073,$8074,$8075,$8076,$8077,$8078,
$8079,$807A,$807B,$807C,$807D,$807E,$807F,$8080,$8081,$8082,$8083,$8084,$8085,
$8086,$8087,$8088,$8089,$808A,$808B,$808C,$808D,$808E,$808F,$8090,$8091,$8092,
$8093,$8094,$8095,$8096,$8097,$8098,$8099,$809A,$809B,$809C,$809D,$809E,$809F,
$80A0,$80A1,$80A2,$80A3,$80A4,$80A5,$80A6,$80A7,$80A8,$80A9,$80AA,$80AB,$80AC,
$80AD,$80AE,$80AF,$80B0,$80B1,$80B2,$80B3,$80B4,$80B5,$80B6,$80B7,$80B8,$80B9,
$80BA,$80BB,$80BC,$80BD,$80BE,$80BF,$80C0,$80C1,$80C2,$80C3,$80C4,$80C5,$80C6,
$80C7,$80C8,$80C9,$80CA,$80CB,$80CC,$80CD,$80CE,$80CF,$80D0,$80D1,$80D2,$80D3,
$80D4,$80D5,$80D6,$80D7,$80D8,$80D9,$80DA,$80DB,$80DC,$80DD,$80DE,$80DF,$80E0,
$80E1,$80E2,$80E3,$80E4,$80E5,$80E6,$80E7,$80E8,$80E9,$80EA,$80EB,$80EC,$80ED,
$80EE,$80EF,$80F0,$80F1,$80F2,$80F3,$80F4,$80F5,$80F6,$80F7,$80F8,$80F9,$80FA,
$80FB,$80FC,$80FD,$80FE,$80FF,$8100,$8101,$8102,$8103,$8104,$8105,$8106,$8107,
$8108,$8109,$810A,$810B,$810C,$810D,$810E,$810F,$8110,$8111,$8112,$8113,$8114,
$8115,$8116,$8117,$8118,$8119,$811A,$811B,$811C,$811D,$811E,$811F,$8120,$8121,
$8122,$8123,$8124,$8125,$8126,$8127,$8128,$8129,$812A,$812B,$812C,$812D,$812E,
$812F,$8130,$8131,$8132,$8133,$8134,$8135,$8136,$8137,$8138,$8139,$813A,$813B,
$813C,$813D,$813E,$813F,$8140,$8141,$8142,$8143,$8144,$8145,$8146,$8147,$8148,
$8149,$814A,$814B,$814C,$814D,$814E,$814F,$8150,$8151,$8152,$8153,$8154,$8155,
$8156,$8157,$8158,$8159,$815A,$815B,$815C,$815D,$815E,$815F,$8160,$8161,$8162,
$8163,$8164,$8165,$8166,$8167,$8168,$8169,$816A,$816B,$816C,$816D,$816E,$816F,
$8170,$8171,$8172,$8173,$8174,$8175,$8176,$8177,$8178,$8179,$817A,$817B,$817C,
$817D,$817E,$817F,$8180,$8181,$8182,$8183,$8184,$8185,$8186,$8187,$8188,$8189,
$818A,$818B,$818C,$818D,$818E,$818F,$8190,$8191,$8192,$8193,$8194,$8195,$8196,
$8197,$8198,$8199,$819A,$819B,$819C,$819D,$819E,$819F,$81A0,$81A1,$81A2,$81A3,
$81A4,$81A5,$81A6,$81A7,$81A8,$81A9,$81AA,$81AB,$81AC,$81AD,$81AE,$81AF,$81B0,
$81B1,$81B2,$81B3,$81B4,$81B5,$81B6,$81B7,$81B8,$81B9,$81BA,$81BB,$81BC,$81BD,
$81BE,$81BF,$81C0,$81C1,$81C2,$81C3,$81C4,$81C5,$81C6,$81C7,$81C8,$81C9,$81CA,
$81CB,$81CC,$81CD,$81CE,$81CF,$81D0,$81D1,$81D2,$81D3,$81D4,$81D5,$81D6,$81D7,
$81D8,$81D9,$81DA,$81DB,$81DC,$81DD,$81DE,$81DF,$81E0,$81E1,$81E2,$81E3,$81E4,
$81E5,$81E6,$81E7,$81E8,$81E9,$81EA,$81EB,$81EC,$81ED,$81EE,$81EF,$81F0,$81F1,
$81F2,$81F3,$81F4,$81F5,$81F6,$81F7,$81F8,$81F9,$81FA,$81FB,$81FC,$81FD,$81FE,
$81FF,$8200,$8201,$8202,$8203,$8204,$8205,$8206,$8207,$8208,$8209,$820A,$820B,
$820C,$820D,$820E,$820F,$8210,$8211,$8212,$8213,$8214,$8215,$8216,$8217,$8218,
$8219,$821A,$821B,$821C,$821D,$821E,$821F,$8220,$8221,$8222,$8223,$8224,$8225,
$8226,$8227,$8228,$8229,$822A,$822B,$822C,$822D,$822E,$822F,$8230,$8231,$8232,
$8233,$8234,$8235,$8236,$8237,$8238,$8239,$823A,$823B,$823C,$823D,$823E,$823F,
$8240,$8241,$8242,$8243,$8244,$8245,$8246,$8247,$8248,$8249,$824A,$824B,$824C,
$824D,$824E,$824F,$8250,$8251,$8252,$8253,$8254,$8255,$8256,$8257,$8258,$8259,
$825A,$825B,$825C,$825D,$825E,$825F,$8260,$8261,$8262,$8263,$8264,$8265,$8266,
$8267,$8268,$8269,$826A,$826B,$826C,$826D,$826E,$826F,$8270,$8271,$8272,$8273,
$8274,$8275,$8276,$8277,$8278,$8279,$827A,$827B,$827C,$827D,$827E,$827F,$8280,
$8281,$8282,$8283,$8284,$8285,$8286,$8287,$8288,$8289,$828A,$828B,$828C,$828D,
$828E,$828F,$8290,$8291,$8292,$8293,$8294,$8295,$8296,$8297,$8298,$8299,$829A,
$829B,$829C,$829D,$829E,$829F,$82A0,$82A1,$82A2,$82A3,$82A4,$82A5,$82A6,$82A7,
$82A8,$82A9,$82AA,$82AB,$82AC,$82AD,$82AE,$82AF,$82B0,$82B1,$82B2,$82B3,$82B4,
$82B5,$82B6,$82B7,$82B8,$82B9,$82BA,$82BB,$82BC,$82BD,$82BE,$82BF,$82C0,$82C1,
$82C2,$82C3,$82C4,$82C5,$82C6,$82C7,$82C8,$82C9,$82CA,$82CB,$82CC,$82CD,$82CE,
$82CF,$82D0,$82D1,$82D2,$82D3,$82D4,$82D5,$82D6,$82D7,$82D8,$82D9,$82DA,$82DB,
$82DC,$82DD,$82DE,$82DF,$82E0,$82E1,$82E2,$82E3,$82E4,$82E5,$82E6,$82E7,$82E8,
$82E9,$82EA,$82EB,$82EC,$82ED,$82EE,$82EF,$82F0,$82F1,$82F2,$82F3,$82F4,$82F5,
$82F6,$82F7,$82F8,$82F9,$82FA,$82FB,$82FC,$82FD,$82FE,$82FF,$8300,$8301,$8302,
$8303,$8304,$8305,$8306,$8307,$8308,$8309,$830A,$830B,$830C,$830D,$830E,$830F,
$8310,$8311,$8312,$8313,$8314,$8315,$8316,$8317,$8318,$8319,$831A,$831B,$831C,
$831D,$831E,$831F,$8320,$8321,$8322,$8323,$8324,$8325,$8326,$8327,$8328,$8329,
$832A,$832B,$832C,$832D,$832E,$832F,$8330,$8331,$8332,$8333,$8334,$8335,$8336,
$8337,$8338,$8339,$833A,$833B,$833C,$833D,$833E,$833F,$8340,$8341,$8342,$8343,
$8344,$8345,$8346,$8347,$8348,$8349,$834A,$834B,$834C,$834D,$834E,$834F,$8350,
$8351,$8352,$8353,$8354,$8355,$8356,$8357,$8358,$8359,$835A,$835B,$835C,$835D,
$835E,$835F,$8360,$8361,$8362,$8363,$8364,$8365,$8366,$8367,$8368,$8369,$836A,
$836B,$836C,$836D,$836E,$836F,$8370,$8371,$8372,$8373,$8374,$8375,$8376,$8377,
$8378,$8379,$837A,$837B,$837C,$837D,$837E,$837F,$8380,$8381,$8382,$8383,$8384,
$8385,$8386,$8387,$8388,$8389,$838A,$838B,$838C,$838D,$838E,$838F,$8390,$8391,
$8392,$8393,$8394,$8395,$8396,$8397,$8398,$8399,$839A,$839B,$839C,$839D,$839E,
$839F,$83A0,$83A1,$83A2,$83A3,$83A4,$83A5,$83A6,$83A7,$83A8,$83A9,$83AA,$83AB,
$83AC,$83AD,$83AE,$83AF,$83B0,$83B1,$83B2,$83B3,$83B4,$83B5,$83B6,$83B7,$83B8,
$83B9,$83BA,$83BB,$83BC,$83BD,$83BE,$83BF,$83C0,$83C1,$83C2,$83C3,$83C4,$83C5,
$83C6,$83C7,$83C8,$83C9,$83CA,$83CB,$83CC,$83CD,$83CE,$83CF,$83D0,$83D1,$83D2,
$83D3,$83D4,$83D5,$83D6,$83D7,$83D8,$83D9,$83DA,$83DB,$83DC,$83DD,$83DE,$83DF,
$83E0,$83E1,$83E2,$83E3,$83E4,$83E5,$83E6,$83E7,$83E8,$83E9,$83EA,$83EB,$83EC,
$83ED,$83EE,$83EF,$83F0,$83F1,$83F2,$83F3,$83F4,$83F5,$83F6,$83F7,$83F8,$83F9,
$83FA,$83FB,$83FC,$83FD,$83FE,$83FF,$8400,$8401,$8402,$8403,$8404,$8405,$8406,
$8407,$8408,$8409,$840A,$840B,$840C,$840D,$840E,$840F,$8410,$8411,$8412,$8413,
$8414,$8415,$8416,$8417,$8418,$8419,$841A,$841B,$841C,$841D,$841E,$841F,$8420,
$8421,$8422,$8423,$8424,$8425,$8426,$8427,$8428,$8429,$842A,$842B,$842C,$842D,
$842E,$842F,$8430,$8431,$8432,$8433,$8434,$8435,$8436,$8437,$8438,$8439,$843A,
$843B,$843C,$843D,$843E,$843F,$8440,$8441,$8442,$8443,$8444,$8445,$8446,$8447,
$8448,$8449,$844A,$844B,$844C,$844D,$844E,$844F,$8450,$8451,$8452,$8453,$8454,
$8455,$8456,$8457,$8458,$8459,$845A,$845B,$845C,$845D,$845E,$845F,$8460,$8461,
$8462,$8463,$8464,$8465,$8466,$8467,$8468,$8469,$846A,$846B,$846C,$846D,$846E,
$846F,$8470,$8471,$8472,$8473,$8474,$8475,$8476,$8477,$8478,$8479,$847A,$847B,
$847C,$847D,$847E,$847F,$8480,$8481,$8482,$8483,$8484,$8485,$8486,$8487,$8488,
$8489,$848A,$848B,$848C,$848D,$848E,$848F,$8490,$8491,$8492,$8493,$8494,$8495,
$8496,$8497,$8498,$8499,$849A,$849B,$849C,$849D,$849E,$849F,$84A0,$84A1,$84A2,
$84A3,$84A4,$84A5,$84A6,$84A7,$84A8,$84A9,$84AA,$84AB,$84AC,$84AD,$84AE,$84AF,
$84B0,$84B1,$84B2,$84B3,$84B4,$84B5,$84B6,$84B7,$84B8,$84B9,$84BA,$84BB,$84BC,
$84BD,$84BE,$84BF,$84C0,$84C1,$84C2,$84C3,$84C4,$84C5,$84C6,$84C7,$84C8,$84C9,
$84CA,$84CB,$84CC,$84CD,$84CE,$84CF,$84D0,$84D1,$84D2,$84D3,$84D4,$84D5,$84D6,
$84D7,$84D8,$84D9,$84DA,$84DB,$84DC,$84DD,$84DE,$84DF,$84E0,$84E1,$84E2,$84E3,
$84E4,$84E5,$84E6,$84E7,$84E8,$84E9,$84EA,$84EB,$84EC,$84ED,$84EE,$84EF,$84F0,
$84F1,$84F2,$84F3,$84F4,$84F5,$84F6,$84F7,$84F8,$84F9,$84FA,$84FB,$84FC,$84FD,
$84FE,$84FF,$8500,$8501,$8502,$8503,$8504,$8505,$8506,$8507,$8508,$8509,$850A,
$850B,$850C,$850D,$850E,$850F,$8510,$8511,$8512,$8513,$8514,$8515,$8516,$8517,
$8518,$8519,$851A,$851B,$851C,$851D,$851E,$851F,$8520,$8521,$8522,$8523,$8524,
$8525,$8526,$8527,$8528,$8529,$852A,$852B,$852C,$852D,$852E,$852F,$8530,$8531,
$8532,$8533,$8534,$8535,$8536,$8537,$8538,$8539,$853A,$853B,$853C,$853D,$853E,
$853F,$8540,$8541,$8542,$8543,$8544,$8545,$8546,$8547,$8548,$8549,$854A,$854B,
$854C,$854D,$854E,$854F,$8550,$8551,$8552,$8553,$8554,$8555,$8556,$8557,$8558,
$8559,$855A,$855B,$855C,$855D,$855E,$855F,$8560,$8561,$8562,$8563,$8564,$8565,
$8566,$8567,$8568,$8569,$856A,$856B,$856C,$856D,$856E,$856F,$8570,$8571,$8572,
$8573,$8574,$8575,$8576,$8577,$8578,$8579,$857A,$857B,$857C,$857D,$857E,$857F,
$8580,$8581,$8582,$8583,$8584,$8585,$8586,$8587,$8588,$8589,$858A,$858B,$858C,
$858D,$858E,$858F,$8590,$8591,$8592,$8593,$8594,$8595,$8596,$8597,$8598,$8599,
$859A,$859B,$859C,$859D,$859E,$859F,$85A0,$85A1,$85A2,$85A3,$85A4,$85A5,$85A6,
$85A7,$85A8,$85A9,$85AA,$85AB,$85AC,$85AD,$85AE,$85AF,$85B0,$85B1,$85B2,$85B3,
$85B4,$85B5,$85B6,$85B7,$85B8,$85B9,$85BA,$85BB,$85BC,$85BD,$85BE,$85BF,$85C0,
$85C1,$85C2,$85C3,$85C4,$85C5,$85C6,$85C7,$85C8,$85C9,$85CA,$85CB,$85CC,$85CD,
$85CE,$85CF,$85D0,$85D1,$85D2,$85D3,$85D4,$85D5,$85D6,$85D7,$85D8,$85D9,$85DA,
$85DB,$85DC,$85DD,$85DE,$85DF,$85E0,$85E1,$85E2,$85E3,$85E4,$85E5,$85E6,$85E7,
$85E8,$85E9,$85EA,$85EB,$85EC,$85ED,$85EE,$85EF,$85F0,$85F1,$85F2,$85F3,$85F4,
$85F5,$85F6,$85F7,$85F8,$85F9,$85FA,$85FB,$85FC,$85FD,$85FE,$85FF,$8600,$8601,
$8602,$8603,$8604,$8605,$8606,$8607,$8608,$8609,$860A,$860B,$860C,$860D,$860E,
$860F,$8610,$8611,$8612,$8613,$8614,$8615,$8616,$8617,$8618,$8619,$861A,$861B,
$861C,$861D,$861E,$861F,$8620,$8621,$8622,$8623,$8624,$8625,$8626,$8627,$8628,
$8629,$862A,$862B,$862C,$862D,$862E,$862F,$8630,$8631,$8632,$8633,$8634,$8635,
$8636,$8637,$8638,$8639,$863A,$863B,$863C,$863D,$863E,$863F,$8640,$8641,$8642,
$8643,$8644,$8645,$8646,$8647,$8648,$8649,$864A,$864B,$864C,$864D,$864E,$864F,
$8650,$8651,$8652,$8653,$8654,$8655,$8656,$8657,$8658,$8659,$865A,$865B,$865C,
$865D,$865E,$865F,$8660,$8661,$8662,$8663,$8664,$8665,$8666,$8667,$8668,$8669,
$866A,$866B,$866C,$866D,$866E,$866F,$8670,$8671,$8672,$8673,$8674,$8675,$8676,
$8677,$8678,$8679,$867A,$867B,$867C,$867D,$867E,$867F,$8680,$8681,$8682,$8683,
$8684,$8685,$8686,$8687,$8688,$8689,$868A,$868B,$868C,$868D,$868E,$868F,$8690,
$8691,$8692,$8693,$8694,$8695,$8696,$8697,$8698,$8699,$869A,$869B,$869C,$869D,
$869E,$869F,$86A0,$86A1,$86A2,$86A3,$86A4,$86A5,$86A6,$86A7,$86A8,$86A9,$86AA,
$86AB,$86AC,$86AD,$86AE,$86AF,$86B0,$86B1,$86B2,$86B3,$86B4,$86B5,$86B6,$86B7,
$86B8,$86B9,$86BA,$86BB,$86BC,$86BD,$86BE,$86BF,$86C0,$86C1,$86C2,$86C3,$86C4,
$86C5,$86C6,$86C7,$86C8,$86C9,$86CA,$86CB,$86CC,$86CD,$86CE,$86CF,$86D0,$86D1,
$86D2,$86D3,$86D4,$86D5,$86D6,$86D7,$86D8,$86D9,$86DA,$86DB,$86DC,$86DD,$86DE,
$86DF,$86E0,$86E1,$86E2,$86E3,$86E4,$86E5,$86E6,$86E7,$86E8,$86E9,$86EA,$86EB,
$86EC,$86ED,$86EE,$86EF,$86F0,$86F1,$86F2,$86F3,$86F4,$86F5,$86F6,$86F7,$86F8,
$86F9,$86FA,$86FB,$86FC,$86FD,$86FE,$86FF,$8700,$8701,$8702,$8703,$8704,$8705,
$8706,$8707,$8708,$8709,$870A,$870B,$870C,$870D,$870E,$870F,$8710,$8711,$8712,
$8713,$8714,$8715,$8716,$8717,$8718,$8719,$871A,$871B,$871C,$871D,$871E,$871F,
$8720,$8721,$8722,$8723,$8724,$8725,$8726,$8727,$8728,$8729,$872A,$872B,$872C,
$872D,$872E,$872F,$8730,$8731,$8732,$8733,$8734,$8735,$8736,$8737,$8738,$8739,
$873A,$873B,$873C,$873D,$873E,$873F,$8740,$8741,$8742,$8743,$8744,$8745,$8746,
$8747,$8748,$8749,$874A,$874B,$874C,$874D,$874E,$874F,$8750,$8751,$8752,$8753,
$8754,$8755,$8756,$8757,$8758,$8759,$875A,$875B,$875C,$875D,$875E,$875F,$8760,
$8761,$8762,$8763,$8764,$8765,$8766,$8767,$8768,$8769,$876A,$876B,$876C,$876D,
$876E,$876F,$8770,$8771,$8772,$8773,$8774,$8775,$8776,$8777,$8778,$8779,$877A,
$877B,$877C,$877D,$877E,$877F,$8780,$8781,$8782,$8783,$8784,$8785,$8786,$8787,
$8788,$8789,$878A,$878B,$878C,$878D,$878E,$878F,$8790,$8791,$8792,$8793,$8794,
$8795,$8796,$8797,$8798,$8799,$879A,$879B,$879C,$879D,$879E,$879F,$87A0,$87A1,
$87A2,$87A3,$87A4,$87A5,$87A6,$87A7,$87A8,$87A9,$87AA,$87AB,$87AC,$87AD,$87AE,
$87AF,$87B0,$87B1,$87B2,$87B3,$87B4,$87B5,$87B6,$87B7,$87B8,$87B9,$87BA,$87BB,
$87BC,$87BD,$87BE,$87BF,$87C0,$87C1,$87C2,$87C3,$87C4,$87C5,$87C6,$87C7,$87C8,
$87C9,$87CA,$87CB,$87CC,$87CD,$87CE,$87CF,$87D0,$87D1,$87D2,$87D3,$87D4,$87D5,
$87D6,$87D7,$87D8,$87D9,$87DA,$87DB,$87DC,$87DD,$87DE,$87DF,$87E0,$87E1,$87E2,
$87E3,$87E4,$87E5,$87E6,$87E7,$87E8,$87E9,$87EA,$87EB,$87EC,$87ED,$87EE,$87EF,
$87F0,$87F1,$87F2,$87F3,$87F4,$87F5,$87F6,$87F7,$87F8,$87F9,$87FA,$87FB,$87FC,
$87FD,$87FE,$87FF,$8800,$8801,$8802,$8803,$8804,$8805,$8806,$8807,$8808,$8809,
$880A,$880B,$880C,$880D,$880E,$880F,$8810,$8811,$8812,$8813,$8814,$8815,$8816,
$8817,$8818,$8819,$881A,$881B,$881C,$881D,$881E,$881F,$8820,$8821,$8822,$8823,
$8824,$8825,$8826,$8827,$8828,$8829,$882A,$882B,$882C,$882D,$882E,$882F,$8830,
$8831,$8832,$8833,$8834,$8835,$8836,$8837,$8838,$8839,$883A,$883B,$883C,$883D,
$883E,$883F,$8840,$8841,$8842,$8843,$8844,$8845,$8846,$8847,$8848,$8849,$884A,
$884B,$884C,$884D,$884E,$884F,$8850,$8851,$8852,$8853,$8854,$8855,$8856,$8857,
$8858,$8859,$885A,$885B,$885C,$885D,$885E,$885F,$8860,$8861,$8862,$8863,$8864,
$8865,$8866,$8867,$8868,$8869,$886A,$886B,$886C,$886D,$886E,$886F,$8870,$8871,
$8872,$8873,$8874,$8875,$8876,$8877,$8878,$8879,$887A,$887B,$887C,$887D,$887E,
$887F,$8880,$8881,$8882,$8883,$8884,$8885,$8886,$8887,$8888,$8889,$888A,$888B,
$888C,$888D,$888E,$888F,$8890,$8891,$8892,$8893,$8894,$8895,$8896,$8897,$8898,
$8899,$889A,$889B,$889C,$889D,$889E,$889F,$88A0,$88A1,$88A2,$88A3,$88A4,$88A5,
$88A6,$88A7,$88A8,$88A9,$88AA,$88AB,$88AC,$88AD,$88AE,$88AF,$88B0,$88B1,$88B2,
$88B3,$88B4,$88B5,$88B6,$88B7,$88B8,$88B9,$88BA,$88BB,$88BC,$88BD,$88BE,$88BF,
$88C0,$88C1,$88C2,$88C3,$88C4,$88C5,$88C6,$88C7,$88C8,$88C9,$88CA,$88CB,$88CC,
$88CD,$88CE,$88CF,$88D0,$88D1,$88D2,$88D3,$88D4,$88D5,$88D6,$88D7,$88D8,$88D9,
$88DA,$88DB,$88DC,$88DD,$88DE,$88DF,$88E0,$88E1,$88E2,$88E3,$88E4,$88E5,$88E6,
$88E7,$88E8,$88E9,$88EA,$88EB,$88EC,$88ED,$88EE,$88EF,$88F0,$88F1,$88F2,$88F3,
$88F4,$88F5,$88F6,$88F7,$88F8,$88F9,$88FA,$88FB,$88FC,$88FD,$88FE,$88FF,$8900,
$8901,$8902,$8903,$8904,$8905,$8906,$8907,$8908,$8909,$890A,$890B,$890C,$890D,
$890E,$890F,$8910,$8911,$8912,$8913,$8914,$8915,$8916,$8917,$8918,$8919,$891A,
$891B,$891C,$891D,$891E,$891F,$8920,$8921,$8922,$8923,$8924,$8925,$8926,$8927,
$8928,$8929,$892A,$892B,$892C,$892D,$892E,$892F,$8930,$8931,$8932,$8933,$8934,
$8935,$8936,$8937,$8938,$8939,$893A,$893B,$893C,$893D,$893E,$893F,$8940,$8941,
$8942,$8943,$8944,$8945,$8946,$8947,$8948,$8949,$894A,$894B,$894C,$894D,$894E,
$894F,$8950,$8951,$8952,$8953,$8954,$8955,$8956,$8957,$8958,$8959,$895A,$895B,
$895C,$895D,$895E,$895F,$8960,$8961,$8962,$8963,$8964,$8965,$8966,$8967,$8968,
$8969,$896A,$896B,$896C,$896D,$896E,$896F,$8970,$8971,$8972,$8973,$8974,$8975,
$8976,$8977,$8978,$8979,$897A,$897B,$897C,$897D,$897E,$897F,$8980,$8981,$8982,
$8983,$8984,$8985,$8986,$8987,$8988,$8989,$898A,$898B,$898C,$898D,$898E,$898F,
$8990,$8991,$8992,$8993,$8994,$8995,$8996,$8997,$8998,$8999,$899A,$899B,$899C,
$899D,$899E,$899F,$89A0,$89A1,$89A2,$89A3,$89A4,$89A5,$89A6,$89A7,$89A8,$89A9,
$89AA,$89AB,$89AC,$89AD,$89AE,$89AF,$89B0,$89B1,$89B2,$89B3,$89B4,$89B5,$89B6,
$89B7,$89B8,$89B9,$89BA,$89BB,$89BC,$89BD,$89BE,$89BF,$89C0,$89C1,$89C2,$89C3,
$89C4,$89C5,$89C6,$89C7,$89C8,$89C9,$89CA,$89CB,$89CC,$89CD,$89CE,$89CF,$89D0,
$89D1,$89D2,$89D3,$89D4,$89D5,$89D6,$89D7,$89D8,$89D9,$89DA,$89DB,$89DC,$89DD,
$89DE,$89DF,$89E0,$89E1,$89E2,$89E3,$89E4,$89E5,$89E6,$89E7,$89E8,$89E9,$89EA,
$89EB,$89EC,$89ED,$89EE,$89EF,$89F0,$89F1,$89F2,$89F3,$89F4,$89F5,$89F6,$89F7,
$89F8,$89F9,$89FA,$89FB,$89FC,$89FD,$89FE,$89FF,$8A00,$8A01,$8A02,$8A03,$8A04,
$8A05,$8A06,$8A07,$8A08,$8A09,$8A0A,$8A0B,$8A0C,$8A0D,$8A0E,$8A0F,$8A10,$8A11,
$8A12,$8A13,$8A14,$8A15,$8A16,$8A17,$8A18,$8A19,$8A1A,$8A1B,$8A1C,$8A1D,$8A1E,
$8A1F,$8A20,$8A21,$8A22,$8A23,$8A24,$8A25,$8A26,$8A27,$8A28,$8A29,$8A2A,$8A2B,
$8A2C,$8A2D,$8A2E,$8A2F,$8A30,$8A31,$8A32,$8A33,$8A34,$8A35,$8A36,$8A37,$8A38,
$8A39,$8A3A,$8A3B,$8A3C,$8A3D,$8A3E,$8A3F,$8A40,$8A41,$8A42,$8A43,$8A44,$8A45,
$8A46,$8A47,$8A48,$8A49,$8A4A,$8A4B,$8A4C,$8A4D,$8A4E,$8A4F,$8A50,$8A51,$8A52,
$8A53,$8A54,$8A55,$8A56,$8A57,$8A58,$8A59,$8A5A,$8A5B,$8A5C,$8A5D,$8A5E,$8A5F,
$8A60,$8A61,$8A62,$8A63,$8A64,$8A65,$8A66,$8A67,$8A68,$8A69,$8A6A,$8A6B,$8A6C,
$8A6D,$8A6E,$8A6F,$8A70,$8A71,$8A72,$8A73,$8A74,$8A75,$8A76,$8A77,$8A78,$8A79,
$8A7A,$8A7B,$8A7C,$8A7D,$8A7E,$8A7F,$8A80,$8A81,$8A82,$8A83,$8A84,$8A85,$8A86,
$8A87,$8A88,$8A89,$8A8A,$8A8B,$8A8C,$8A8D,$8A8E,$8A8F,$8A90,$8A91,$8A92,$8A93,
$8A94,$8A95,$8A96,$8A97,$8A98,$8A99,$8A9A,$8A9B,$8A9C,$8A9D,$8A9E,$8A9F,$8AA0,
$8AA1,$8AA2,$8AA3,$8AA4,$8AA5,$8AA6,$8AA7,$8AA8,$8AA9,$8AAA,$8AAB,$8AAC,$8AAD,
$8AAE,$8AAF,$8AB0,$8AB1,$8AB2,$8AB3,$8AB4,$8AB5,$8AB6,$8AB7,$8AB8,$8AB9,$8ABA,
$8ABB,$8ABC,$8ABD,$8ABE,$8ABF,$8AC0,$8AC1,$8AC2,$8AC3,$8AC4,$8AC5,$8AC6,$8AC7,
$8AC8,$8AC9,$8ACA,$8ACB,$8ACC,$8ACD,$8ACE,$8ACF,$8AD0,$8AD1,$8AD2,$8AD3,$8AD4,
$8AD5,$8AD6,$8AD7,$8AD8,$8AD9,$8ADA,$8ADB,$8ADC,$8ADD,$8ADE,$8ADF,$8AE0,$8AE1,
$8AE2,$8AE3,$8AE4,$8AE5,$8AE6,$8AE7,$8AE8,$8AE9,$8AEA,$8AEB,$8AEC,$8AED,$8AEE,
$8AEF,$8AF0,$8AF1,$8AF2,$8AF3,$8AF4,$8AF5,$8AF6,$8AF7,$8AF8,$8AF9,$8AFA,$8AFB,
$8AFC,$8AFD,$8AFE,$8AFF,$8B00,$8B01,$8B02,$8B03,$8B04,$8B05,$8B06,$8B07,$8B08,
$8B09,$8B0A,$8B0B,$8B0C,$8B0D,$8B0E,$8B0F,$8B10,$8B11,$8B12,$8B13,$8B14,$8B15,
$8B16,$8B17,$8B18,$8B19,$8B1A,$8B1B,$8B1C,$8B1D,$8B1E,$8B1F,$8B20,$8B21,$8B22,
$8B23,$8B24,$8B25,$8B26,$8B27,$8B28,$8B29,$8B2A,$8B2B,$8B2C,$8B2D,$8B2E,$8B2F,
$8B30,$8B31,$8B32,$8B33,$8B34,$8B35,$8B36,$8B37,$8B38,$8B39,$8B3A,$8B3B,$8B3C,
$8B3D,$8B3E,$8B3F,$8B40,$8B41,$8B42,$8B43,$8B44,$8B45,$8B46,$8B47,$8B48,$8B49,
$8B4A,$8B4B,$8B4C,$8B4D,$8B4E,$8B4F,$8B50,$8B51,$8B52,$8B53,$8B54,$8B55,$8B56,
$8B57,$8B58,$8B59,$8B5A,$8B5B,$8B5C,$8B5D,$8B5E,$8B5F,$8B60,$8B61,$8B62,$8B63,
$8B64,$8B65,$8B66,$8B67,$8B68,$8B69,$8B6A,$8B6B,$8B6C,$8B6D,$8B6E,$8B6F,$8B70,
$8B71,$8B72,$8B73,$8B74,$8B75,$8B76,$8B77,$8B78,$8B79,$8B7A,$8B7B,$8B7C,$8B7D,
$8B7E,$8B7F,$8B80,$8B81,$8B82,$8B83,$8B84,$8B85,$8B86,$8B87,$8B88,$8B89,$8B8A,
$8B8B,$8B8C,$8B8D,$8B8E,$8B8F,$8B90,$8B91,$8B92,$8B93,$8B94,$8B95,$8B96,$8B97,
$8B98,$8B99,$8B9A,$8B9B,$8B9C,$8B9D,$8B9E,$8B9F,$8BA0,$8BA1,$8BA2,$8BA3,$8BA4,
$8BA5,$8BA6,$8BA7,$8BA8,$8BA9,$8BAA,$8BAB,$8BAC,$8BAD,$8BAE,$8BAF,$8BB0,$8BB1,
$8BB2,$8BB3,$8BB4,$8BB5,$8BB6,$8BB7,$8BB8,$8BB9,$8BBA,$8BBB,$8BBC,$8BBD,$8BBE,
$8BBF,$8BC0,$8BC1,$8BC2,$8BC3,$8BC4,$8BC5,$8BC6,$8BC7,$8BC8,$8BC9,$8BCA,$8BCB,
$8BCC,$8BCD,$8BCE,$8BCF,$8BD0,$8BD1,$8BD2,$8BD3,$8BD4,$8BD5,$8BD6,$8BD7,$8BD8,
$8BD9,$8BDA,$8BDB,$8BDC,$8BDD,$8BDE,$8BDF,$8BE0,$8BE1,$8BE2,$8BE3,$8BE4,$8BE5,
$8BE6,$8BE7,$8BE8,$8BE9,$8BEA,$8BEB,$8BEC,$8BED,$8BEE,$8BEF,$8BF0,$8BF1,$8BF2,
$8BF3,$8BF4,$8BF5,$8BF6,$8BF7,$8BF8,$8BF9,$8BFA,$8BFB,$8BFC,$8BFD,$8BFE,$8BFF,
$8C00,$8C01,$8C02,$8C03,$8C04,$8C05,$8C06,$8C07,$8C08,$8C09,$8C0A,$8C0B,$8C0C,
$8C0D,$8C0E,$8C0F,$8C10,$8C11,$8C12,$8C13,$8C14,$8C15,$8C16,$8C17,$8C18,$8C19,
$8C1A,$8C1B,$8C1C,$8C1D,$8C1E,$8C1F,$8C20,$8C21,$8C22,$8C23,$8C24,$8C25,$8C26,
$8C27,$8C28,$8C29,$8C2A,$8C2B,$8C2C,$8C2D,$8C2E,$8C2F,$8C30,$8C31,$8C32,$8C33,
$8C34,$8C35,$8C36,$8C37,$8C38,$8C39,$8C3A,$8C3B,$8C3C,$8C3D,$8C3E,$8C3F,$8C40,
$8C41,$8C42,$8C43,$8C44,$8C45,$8C46,$8C47,$8C48,$8C49,$8C4A,$8C4B,$8C4C,$8C4D,
$8C4E,$8C4F,$8C50,$8C51,$8C52,$8C53,$8C54,$8C55,$8C56,$8C57,$8C58,$8C59,$8C5A,
$8C5B,$8C5C,$8C5D,$8C5E,$8C5F,$8C60,$8C61,$8C62,$8C63,$8C64,$8C65,$8C66,$8C67,
$8C68,$8C69,$8C6A,$8C6B,$8C6C,$8C6D,$8C6E,$8C6F,$8C70,$8C71,$8C72,$8C73,$8C74,
$8C75,$8C76,$8C77,$8C78,$8C79,$8C7A,$8C7B,$8C7C,$8C7D,$8C7E,$8C7F,$8C80,$8C81,
$8C82,$8C83,$8C84,$8C85,$8C86,$8C87,$8C88,$8C89,$8C8A,$8C8B,$8C8C,$8C8D,$8C8E,
$8C8F,$8C90,$8C91,$8C92,$8C93,$8C94,$8C95,$8C96,$8C97,$8C98,$8C99,$8C9A,$8C9B,
$8C9C,$8C9D,$8C9E,$8C9F,$8CA0,$8CA1,$8CA2,$8CA3,$8CA4,$8CA5,$8CA6,$8CA7,$8CA8,
$8CA9,$8CAA,$8CAB,$8CAC,$8CAD,$8CAE,$8CAF,$8CB0,$8CB1,$8CB2,$8CB3,$8CB4,$8CB5,
$8CB6,$8CB7,$8CB8,$8CB9,$8CBA,$8CBB,$8CBC,$8CBD,$8CBE,$8CBF,$8CC0,$8CC1,$8CC2,
$8CC3,$8CC4,$8CC5,$8CC6,$8CC7,$8CC8,$8CC9,$8CCA,$8CCB,$8CCC,$8CCD,$8CCE,$8CCF,
$8CD0,$8CD1,$8CD2,$8CD3,$8CD4,$8CD5,$8CD6,$8CD7,$8CD8,$8CD9,$8CDA,$8CDB,$8CDC,
$8CDD,$8CDE,$8CDF,$8CE0,$8CE1,$8CE2,$8CE3,$8CE4,$8CE5,$8CE6,$8CE7,$8CE8,$8CE9,
$8CEA,$8CEB,$8CEC,$8CED,$8CEE,$8CEF,$8CF0,$8CF1,$8CF2,$8CF3,$8CF4,$8CF5,$8CF6,
$8CF7,$8CF8,$8CF9,$8CFA,$8CFB,$8CFC,$8CFD,$8CFE,$8CFF,$8D00,$8D01,$8D02,$8D03,
$8D04,$8D05,$8D06,$8D07,$8D08,$8D09,$8D0A,$8D0B,$8D0C,$8D0D,$8D0E,$8D0F,$8D10,
$8D11,$8D12,$8D13,$8D14,$8D15,$8D16,$8D17,$8D18,$8D19,$8D1A,$8D1B,$8D1C,$8D1D,
$8D1E,$8D1F,$8D20,$8D21,$8D22,$8D23,$8D24,$8D25,$8D26,$8D27,$8D28,$8D29,$8D2A,
$8D2B,$8D2C,$8D2D,$8D2E,$8D2F,$8D30,$8D31,$8D32,$8D33,$8D34,$8D35,$8D36,$8D37,
$8D38,$8D39,$8D3A,$8D3B,$8D3C,$8D3D,$8D3E,$8D3F,$8D40,$8D41,$8D42,$8D43,$8D44,
$8D45,$8D46,$8D47,$8D48,$8D49,$8D4A,$8D4B,$8D4C,$8D4D,$8D4E,$8D4F,$8D50,$8D51,
$8D52,$8D53,$8D54,$8D55,$8D56,$8D57,$8D58,$8D59,$8D5A,$8D5B,$8D5C,$8D5D,$8D5E,
$8D5F,$8D60,$8D61,$8D62,$8D63,$8D64,$8D65,$8D66,$8D67,$8D68,$8D69,$8D6A,$8D6B,
$8D6C,$8D6D,$8D6E,$8D6F,$8D70,$8D71,$8D72,$8D73,$8D74,$8D75,$8D76,$8D77,$8D78,
$8D79,$8D7A,$8D7B,$8D7C,$8D7D,$8D7E,$8D7F,$8D80,$8D81,$8D82,$8D83,$8D84,$8D85,
$8D86,$8D87,$8D88,$8D89,$8D8A,$8D8B,$8D8C,$8D8D,$8D8E,$8D8F,$8D90,$8D91,$8D92,
$8D93,$8D94,$8D95,$8D96,$8D97,$8D98,$8D99,$8D9A,$8D9B,$8D9C,$8D9D,$8D9E,$8D9F,
$8DA0,$8DA1,$8DA2,$8DA3,$8DA4,$8DA5,$8DA6,$8DA7,$8DA8,$8DA9,$8DAA,$8DAB,$8DAC,
$8DAD,$8DAE,$8DAF,$8DB0,$8DB1,$8DB2,$8DB3,$8DB4,$8DB5,$8DB6,$8DB7,$8DB8,$8DB9,
$8DBA,$8DBB,$8DBC,$8DBD,$8DBE,$8DBF,$8DC0,$8DC1,$8DC2,$8DC3,$8DC4,$8DC5,$8DC6,
$8DC7,$8DC8,$8DC9,$8DCA,$8DCB,$8DCC,$8DCD,$8DCE,$8DCF,$8DD0,$8DD1,$8DD2,$8DD3,
$8DD4,$8DD5,$8DD6,$8DD7,$8DD8,$8DD9,$8DDA,$8DDB,$8DDC,$8DDD,$8DDE,$8DDF,$8DE0,
$8DE1,$8DE2,$8DE3,$8DE4,$8DE5,$8DE6,$8DE7,$8DE8,$8DE9,$8DEA,$8DEB,$8DEC,$8DED,
$8DEE,$8DEF,$8DF0,$8DF1,$8DF2,$8DF3,$8DF4,$8DF5,$8DF6,$8DF7,$8DF8,$8DF9,$8DFA,
$8DFB,$8DFC,$8DFD,$8DFE,$8DFF,$8E00,$8E01,$8E02,$8E03,$8E04,$8E05,$8E06,$8E07,
$8E08,$8E09,$8E0A,$8E0B,$8E0C,$8E0D,$8E0E,$8E0F,$8E10,$8E11,$8E12,$8E13,$8E14,
$8E15,$8E16,$8E17,$8E18,$8E19,$8E1A,$8E1B,$8E1C,$8E1D,$8E1E,$8E1F,$8E20,$8E21,
$8E22,$8E23,$8E24,$8E25,$8E26,$8E27,$8E28,$8E29,$8E2A,$8E2B,$8E2C,$8E2D,$8E2E,
$8E2F,$8E30,$8E31,$8E32,$8E33,$8E34,$8E35,$8E36,$8E37,$8E38,$8E39,$8E3A,$8E3B,
$8E3C,$8E3D,$8E3E,$8E3F,$8E40,$8E41,$8E42,$8E43,$8E44,$8E45,$8E46,$8E47,$8E48,
$8E49,$8E4A,$8E4B,$8E4C,$8E4D,$8E4E,$8E4F,$8E50,$8E51,$8E52,$8E53,$8E54,$8E55,
$8E56,$8E57,$8E58,$8E59,$8E5A,$8E5B,$8E5C,$8E5D,$8E5E,$8E5F,$8E60,$8E61,$8E62,
$8E63,$8E64,$8E65,$8E66,$8E67,$8E68,$8E69,$8E6A,$8E6B,$8E6C,$8E6D,$8E6E,$8E6F,
$8E70,$8E71,$8E72,$8E73,$8E74,$8E75,$8E76,$8E77,$8E78,$8E79,$8E7A,$8E7B,$8E7C,
$8E7D,$8E7E,$8E7F,$8E80,$8E81,$8E82,$8E83,$8E84,$8E85,$8E86,$8E87,$8E88,$8E89,
$8E8A,$8E8B,$8E8C,$8E8D,$8E8E,$8E8F,$8E90,$8E91,$8E92,$8E93,$8E94,$8E95,$8E96,
$8E97,$8E98,$8E99,$8E9A,$8E9B,$8E9C,$8E9D,$8E9E,$8E9F,$8EA0,$8EA1,$8EA2,$8EA3,
$8EA4,$8EA5,$8EA6,$8EA7,$8EA8,$8EA9,$8EAA,$8EAB,$8EAC,$8EAD,$8EAE,$8EAF,$8EB0,
$8EB1,$8EB2,$8EB3,$8EB4,$8EB5,$8EB6,$8EB7,$8EB8,$8EB9,$8EBA,$8EBB,$8EBC,$8EBD,
$8EBE,$8EBF,$8EC0,$8EC1,$8EC2,$8EC3,$8EC4,$8EC5,$8EC6,$8EC7,$8EC8,$8EC9,$8ECA,
$8ECB,$8ECC,$8ECD,$8ECE,$8ECF,$8ED0,$8ED1,$8ED2,$8ED3,$8ED4,$8ED5,$8ED6,$8ED7,
$8ED8,$8ED9,$8EDA,$8EDB,$8EDC,$8EDD,$8EDE,$8EDF,$8EE0,$8EE1,$8EE2,$8EE3,$8EE4,
$8EE5,$8EE6,$8EE7,$8EE8,$8EE9,$8EEA,$8EEB,$8EEC,$8EED,$8EEE,$8EEF,$8EF0,$8EF1,
$8EF2,$8EF3,$8EF4,$8EF5,$8EF6,$8EF7,$8EF8,$8EF9,$8EFA,$8EFB,$8EFC,$8EFD,$8EFE,
$8EFF,$8F00,$8F01,$8F02,$8F03,$8F04,$8F05,$8F06,$8F07,$8F08,$8F09,$8F0A,$8F0B,
$8F0C,$8F0D,$8F0E,$8F0F,$8F10,$8F11,$8F12,$8F13,$8F14,$8F15,$8F16,$8F17,$8F18,
$8F19,$8F1A,$8F1B,$8F1C,$8F1D,$8F1E,$8F1F,$8F20,$8F21,$8F22,$8F23,$8F24,$8F25,
$8F26,$8F27,$8F28,$8F29,$8F2A,$8F2B,$8F2C,$8F2D,$8F2E,$8F2F,$8F30,$8F31,$8F32,
$8F33,$8F34,$8F35,$8F36,$8F37,$8F38,$8F39,$8F3A,$8F3B,$8F3C,$8F3D,$8F3E,$8F3F,
$8F40,$8F41,$8F42,$8F43,$8F44,$8F45,$8F46,$8F47,$8F48,$8F49,$8F4A,$8F4B,$8F4C,
$8F4D,$8F4E,$8F4F,$8F50,$8F51,$8F52,$8F53,$8F54,$8F55,$8F56,$8F57,$8F58,$8F59,
$8F5A,$8F5B,$8F5C,$8F5D,$8F5E,$8F5F,$8F60,$8F61,$8F62,$8F63,$8F64,$8F65,$8F66,
$8F67,$8F68,$8F69,$8F6A,$8F6B,$8F6C,$8F6D,$8F6E,$8F6F,$8F70,$8F71,$8F72,$8F73,
$8F74,$8F75,$8F76,$8F77,$8F78,$8F79,$8F7A,$8F7B,$8F7C,$8F7D,$8F7E,$8F7F,$8F80,
$8F81,$8F82,$8F83,$8F84,$8F85,$8F86,$8F87,$8F88,$8F89,$8F8A,$8F8B,$8F8C,$8F8D,
$8F8E,$8F8F,$8F90,$8F91,$8F92,$8F93,$8F94,$8F95,$8F96,$8F97,$8F98,$8F99,$8F9A,
$8F9B,$8F9C,$8F9D,$8F9E,$8F9F,$8FA0,$8FA1,$8FA2,$8FA3,$8FA4,$8FA5,$8FA6,$8FA7,
$8FA8,$8FA9,$8FAA,$8FAB,$8FAC,$8FAD,$8FAE,$8FAF,$8FB0,$8FB1,$8FB2,$8FB3,$8FB4,
$8FB5,$8FB6,$8FB7,$8FB8,$8FB9,$8FBA,$8FBB,$8FBC,$8FBD,$8FBE,$8FBF,$8FC0,$8FC1,
$8FC2,$8FC3,$8FC4,$8FC5,$8FC6,$8FC7,$8FC8,$8FC9,$8FCA,$8FCB,$8FCC,$8FCD,$8FCE,
$8FCF,$8FD0,$8FD1,$8FD2,$8FD3,$8FD4,$8FD5,$8FD6,$8FD7,$8FD8,$8FD9,$8FDA,$8FDB,
$8FDC,$8FDD,$8FDE,$8FDF,$8FE0,$8FE1,$8FE2,$8FE3,$8FE4,$8FE5,$8FE6,$8FE7,$8FE8,
$8FE9,$8FEA,$8FEB,$8FEC,$8FED,$8FEE,$8FEF,$8FF0,$8FF1,$8FF2,$8FF3,$8FF4,$8FF5,
$8FF6,$8FF7,$8FF8,$8FF9,$8FFA,$8FFB,$8FFC,$8FFD,$8FFE,$8FFF,$9000,$9001,$9002,
$9003,$9004,$9005,$9006,$9007,$9008,$9009,$900A,$900B,$900C,$900D,$900E,$900F,
$9010,$9011,$9012,$9013,$9014,$9015,$9016,$9017,$9018,$9019,$901A,$901B,$901C,
$901D,$901E,$901F,$9020,$9021,$9022,$9023,$9024,$9025,$9026,$9027,$9028,$9029,
$902A,$902B,$902C,$902D,$902E,$902F,$9030,$9031,$9032,$9033,$9034,$9035,$9036,
$9037,$9038,$9039,$903A,$903B,$903C,$903D,$903E,$903F,$9040,$9041,$9042,$9043,
$9044,$9045,$9046,$9047,$9048,$9049,$904A,$904B,$904C,$904D,$904E,$904F,$9050,
$9051,$9052,$9053,$9054,$9055,$9056,$9057,$9058,$9059,$905A,$905B,$905C,$905D,
$905E,$905F,$9060,$9061,$9062,$9063,$9064,$9065,$9066,$9067,$9068,$9069,$906A,
$906B,$906C,$906D,$906E,$906F,$9070,$9071,$9072,$9073,$9074,$9075,$9076,$9077,
$9078,$9079,$907A,$907B,$907C,$907D,$907E,$907F,$9080,$9081,$9082,$9083,$9084,
$9085,$9086,$9087,$9088,$9089,$908A,$908B,$908C,$908D,$908E,$908F,$9090,$9091,
$9092,$9093,$9094,$9095,$9096,$9097,$9098,$9099,$909A,$909B,$909C,$909D,$909E,
$909F,$90A0,$90A1,$90A2,$90A3,$90A4,$90A5,$90A6,$90A7,$90A8,$90A9,$90AA,$90AB,
$90AC,$90AD,$90AE,$90AF,$90B0,$90B1,$90B2,$90B3,$90B4,$90B5,$90B6,$90B7,$90B8,
$90B9,$90BA,$90BB,$90BC,$90BD,$90BE,$90BF,$90C0,$90C1,$90C2,$90C3,$90C4,$90C5,
$90C6,$90C7,$90C8,$90C9,$90CA,$90CB,$90CC,$90CD,$90CE,$90CF,$90D0,$90D1,$90D2,
$90D3,$90D4,$90D5,$90D6,$90D7,$90D8,$90D9,$90DA,$90DB,$90DC,$90DD,$90DE,$90DF,
$90E0,$90E1,$90E2,$90E3,$90E4,$90E5,$90E6,$90E7,$90E8,$90E9,$90EA,$90EB,$90EC,
$90ED,$90EE,$90EF,$90F0,$90F1,$90F2,$90F3,$90F4,$90F5,$90F6,$90F7,$90F8,$90F9,
$90FA,$90FB,$90FC,$90FD,$90FE,$90FF,$9100,$9101,$9102,$9103,$9104,$9105,$9106,
$9107,$9108,$9109,$910A,$910B,$910C,$910D,$910E,$910F,$9110,$9111,$9112,$9113,
$9114,$9115,$9116,$9117,$9118,$9119,$911A,$911B,$911C,$911D,$911E,$911F,$9120,
$9121,$9122,$9123,$9124,$9125,$9126,$9127,$9128,$9129,$912A,$912B,$912C,$912D,
$912E,$912F,$9130,$9131,$9132,$9133,$9134,$9135,$9136,$9137,$9138,$9139,$913A,
$913B,$913C,$913D,$913E,$913F,$9140,$9141,$9142,$9143,$9144,$9145,$9146,$9147,
$9148,$9149,$914A,$914B,$914C,$914D,$914E,$914F,$9150,$9151,$9152,$9153,$9154,
$9155,$9156,$9157,$9158,$9159,$915A,$915B,$915C,$915D,$915E,$915F,$9160,$9161,
$9162,$9163,$9164,$9165,$9166,$9167,$9168,$9169,$916A,$916B,$916C,$916D,$916E,
$916F,$9170,$9171,$9172,$9173,$9174,$9175,$9176,$9177,$9178,$9179,$917A,$917B,
$917C,$917D,$917E,$917F,$9180,$9181,$9182,$9183,$9184,$9185,$9186,$9187,$9188,
$9189,$918A,$918B,$918C,$918D,$918E,$918F,$9190,$9191,$9192,$9193,$9194,$9195,
$9196,$9197,$9198,$9199,$919A,$919B,$919C,$919D,$919E,$919F,$91A0,$91A1,$91A2,
$91A3,$91A4,$91A5,$91A6,$91A7,$91A8,$91A9,$91AA,$91AB,$91AC,$91AD,$91AE,$91AF,
$91B0,$91B1,$91B2,$91B3,$91B4,$91B5,$91B6,$91B7,$91B8,$91B9,$91BA,$91BB,$91BC,
$91BD,$91BE,$91BF,$91C0,$91C1,$91C2,$91C3,$91C4,$91C5,$91C6,$91C7,$91C8,$91C9,
$91CA,$91CB,$91CC,$91CD,$91CE,$91CF,$91D0,$91D1,$91D2,$91D3,$91D4,$91D5,$91D6,
$91D7,$91D8,$91D9,$91DA,$91DB,$91DC,$91DD,$91DE,$91DF,$91E0,$91E1,$91E2,$91E3,
$91E4,$91E5,$91E6,$91E7,$91E8,$91E9,$91EA,$91EB,$91EC,$91ED,$91EE,$91EF,$91F0,
$91F1,$91F2,$91F3,$91F4,$91F5,$91F6,$91F7,$91F8,$91F9,$91FA,$91FB,$91FC,$91FD,
$91FE,$91FF,$9200,$9201,$9202,$9203,$9204,$9205,$9206,$9207,$9208,$9209,$920A,
$920B,$920C,$920D,$920E,$920F,$9210,$9211,$9212,$9213,$9214,$9215,$9216,$9217,
$9218,$9219,$921A,$921B,$921C,$921D,$921E,$921F,$9220,$9221,$9222,$9223,$9224,
$9225,$9226,$9227,$9228,$9229,$922A,$922B,$922C,$922D,$922E,$922F,$9230,$9231,
$9232,$9233,$9234,$9235,$9236,$9237,$9238,$9239,$923A,$923B,$923C,$923D,$923E,
$923F,$9240,$9241,$9242,$9243,$9244,$9245,$9246,$9247,$9248,$9249,$924A,$924B,
$924C,$924D,$924E,$924F,$9250,$9251,$9252,$9253,$9254,$9255,$9256,$9257,$9258,
$9259,$925A,$925B,$925C,$925D,$925E,$925F,$9260,$9261,$9262,$9263,$9264,$9265,
$9266,$9267,$9268,$9269,$926A,$926B,$926C,$926D,$926E,$926F,$9270,$9271,$9272,
$9273,$9274,$9275,$9276,$9277,$9278,$9279,$927A,$927B,$927C,$927D,$927E,$927F,
$9280,$9281,$9282,$9283,$9284,$9285,$9286,$9287,$9288,$9289,$928A,$928B,$928C,
$928D,$928E,$928F,$9290,$9291,$9292,$9293,$9294,$9295,$9296,$9297,$9298,$9299,
$929A,$929B,$929C,$929D,$929E,$929F,$92A0,$92A1,$92A2,$92A3,$92A4,$92A5,$92A6,
$92A7,$92A8,$92A9,$92AA,$92AB,$92AC,$92AD,$92AE,$92AF,$92B0,$92B1,$92B2,$92B3,
$92B4,$92B5,$92B6,$92B7,$92B8,$92B9,$92BA,$92BB,$92BC,$92BD,$92BE,$92BF,$92C0,
$92C1,$92C2,$92C3,$92C4,$92C5,$92C6,$92C7,$92C8,$92C9,$92CA,$92CB,$92CC,$92CD,
$92CE,$92CF,$92D0,$92D1,$92D2,$92D3,$92D4,$92D5,$92D6,$92D7,$92D8,$92D9,$92DA,
$92DB,$92DC,$92DD,$92DE,$92DF,$92E0,$92E1,$92E2,$92E3,$92E4,$92E5,$92E6,$92E7,
$92E8,$92E9,$92EA,$92EB,$92EC,$92ED,$92EE,$92EF,$92F0,$92F1,$92F2,$92F3,$92F4,
$92F5,$92F6,$92F7,$92F8,$92F9,$92FA,$92FB,$92FC,$92FD,$92FE,$92FF,$9300,$9301,
$9302,$9303,$9304,$9305,$9306,$9307,$9308,$9309,$930A,$930B,$930C,$930D,$930E,
$930F,$9310,$9311,$9312,$9313,$9314,$9315,$9316,$9317,$9318,$9319,$931A,$931B,
$931C,$931D,$931E,$931F,$9320,$9321,$9322,$9323,$9324,$9325,$9326,$9327,$9328,
$9329,$932A,$932B,$932C,$932D,$932E,$932F,$9330,$9331,$9332,$9333,$9334,$9335,
$9336,$9337,$9338,$9339,$933A,$933B,$933C,$933D,$933E,$933F,$9340,$9341,$9342,
$9343,$9344,$9345,$9346,$9347,$9348,$9349,$934A,$934B,$934C,$934D,$934E,$934F,
$9350,$9351,$9352,$9353,$9354,$9355,$9356,$9357,$9358,$9359,$935A,$935B,$935C,
$935D,$935E,$935F,$9360,$9361,$9362,$9363,$9364,$9365,$9366,$9367,$9368,$9369,
$936A,$936B,$936C,$936D,$936E,$936F,$9370,$9371,$9372,$9373,$9374,$9375,$9376,
$9377,$9378,$9379,$937A,$937B,$937C,$937D,$937E,$937F,$9380,$9381,$9382,$9383,
$9384,$9385,$9386,$9387,$9388,$9389,$938A,$938B,$938C,$938D,$938E,$938F,$9390,
$9391,$9392,$9393,$9394,$9395,$9396,$9397,$9398,$9399,$939A,$939B,$939C,$939D,
$939E,$939F,$93A0,$93A1,$93A2,$93A3,$93A4,$93A5,$93A6,$93A7,$93A8,$93A9,$93AA,
$93AB,$93AC,$93AD,$93AE,$93AF,$93B0,$93B1,$93B2,$93B3,$93B4,$93B5,$93B6,$93B7,
$93B8,$93B9,$93BA,$93BB,$93BC,$93BD,$93BE,$93BF,$93C0,$93C1,$93C2,$93C3,$93C4,
$93C5,$93C6,$93C7,$93C8,$93C9,$93CA,$93CB,$93CC,$93CD,$93CE,$93CF,$93D0,$93D1,
$93D2,$93D3,$93D4,$93D5,$93D6,$93D7,$93D8,$93D9,$93DA,$93DB,$93DC,$93DD,$93DE,
$93DF,$93E0,$93E1,$93E2,$93E3,$93E4,$93E5,$93E6,$93E7,$93E8,$93E9,$93EA,$93EB,
$93EC,$93ED,$93EE,$93EF,$93F0,$93F1,$93F2,$93F3,$93F4,$93F5,$93F6,$93F7,$93F8,
$93F9,$93FA,$93FB,$93FC,$93FD,$93FE,$93FF,$9400,$9401,$9402,$9403,$9404,$9405,
$9406,$9407,$9408,$9409,$940A,$940B,$940C,$940D,$940E,$940F,$9410,$9411,$9412,
$9413,$9414,$9415,$9416,$9417,$9418,$9419,$941A,$941B,$941C,$941D,$941E,$941F,
$9420,$9421,$9422,$9423,$9424,$9425,$9426,$9427,$9428,$9429,$942A,$942B,$942C,
$942D,$942E,$942F,$9430,$9431,$9432,$9433,$9434,$9435,$9436,$9437,$9438,$9439,
$943A,$943B,$943C,$943D,$943E,$943F,$9440,$9441,$9442,$9443,$9444,$9445,$9446,
$9447,$9448,$9449,$944A,$944B,$944C,$944D,$944E,$944F,$9450,$9451,$9452,$9453,
$9454,$9455,$9456,$9457,$9458,$9459,$945A,$945B,$945C,$945D,$945E,$945F,$9460,
$9461,$9462,$9463,$9464,$9465,$9466,$9467,$9468,$9469,$946A,$946B,$946C,$946D,
$946E,$946F,$9470,$9471,$9472,$9473,$9474,$9475,$9476,$9477,$9478,$9479,$947A,
$947B,$947C,$947D,$947E,$947F,$9480,$9481,$9482,$9483,$9484,$9485,$9486,$9487,
$9488,$9489,$948A,$948B,$948C,$948D,$948E,$948F,$9490,$9491,$9492,$9493,$9494,
$9495,$9496,$9497,$9498,$9499,$949A,$949B,$949C,$949D,$949E,$949F,$94A0,$94A1,
$94A2,$94A3,$94A4,$94A5,$94A6,$94A7,$94A8,$94A9,$94AA,$94AB,$94AC,$94AD,$94AE,
$94AF,$94B0,$94B1,$94B2,$94B3,$94B4,$94B5,$94B6,$94B7,$94B8,$94B9,$94BA,$94BB,
$94BC,$94BD,$94BE,$94BF,$94C0,$94C1,$94C2,$94C3,$94C4,$94C5,$94C6,$94C7,$94C8,
$94C9,$94CA,$94CB,$94CC,$94CD,$94CE,$94CF,$94D0,$94D1,$94D2,$94D3,$94D4,$94D5,
$94D6,$94D7,$94D8,$94D9,$94DA,$94DB,$94DC,$94DD,$94DE,$94DF,$94E0,$94E1,$94E2,
$94E3,$94E4,$94E5,$94E6,$94E7,$94E8,$94E9,$94EA,$94EB,$94EC,$94ED,$94EE,$94EF,
$94F0,$94F1,$94F2,$94F3,$94F4,$94F5,$94F6,$94F7,$94F8,$94F9,$94FA,$94FB,$94FC,
$94FD,$94FE,$94FF,$9500,$9501,$9502,$9503,$9504,$9505,$9506,$9507,$9508,$9509,
$950A,$950B,$950C,$950D,$950E,$950F,$9510,$9511,$9512,$9513,$9514,$9515,$9516,
$9517,$9518,$9519,$951A,$951B,$951C,$951D,$951E,$951F,$9520,$9521,$9522,$9523,
$9524,$9525,$9526,$9527,$9528,$9529,$952A,$952B,$952C,$952D,$952E,$952F,$9530,
$9531,$9532,$9533,$9534,$9535,$9536,$9537,$9538,$9539,$953A,$953B,$953C,$953D,
$953E,$953F,$9540,$9541,$9542,$9543,$9544,$9545,$9546,$9547,$9548,$9549,$954A,
$954B,$954C,$954D,$954E,$954F,$9550,$9551,$9552,$9553,$9554,$9555,$9556,$9557,
$9558,$9559,$955A,$955B,$955C,$955D,$955E,$955F,$9560,$9561,$9562,$9563,$9564,
$9565,$9566,$9567,$9568,$9569,$956A,$956B,$956C,$956D,$956E,$956F,$9570,$9571,
$9572,$9573,$9574,$9575,$9576,$9577,$9578,$9579,$957A,$957B,$957C,$957D,$957E,
$957F,$9580,$9581,$9582,$9583,$9584,$9585,$9586,$9587,$9588,$9589,$958A,$958B,
$958C,$958D,$958E,$958F,$9590,$9591,$9592,$9593,$9594,$9595,$9596,$9597,$9598,
$9599,$959A,$959B,$959C,$959D,$959E,$959F,$95A0,$95A1,$95A2,$95A3,$95A4,$95A5,
$95A6,$95A7,$95A8,$95A9,$95AA,$95AB,$95AC,$95AD,$95AE,$95AF,$95B0,$95B1,$95B2,
$95B3,$95B4,$95B5,$95B6,$95B7,$95B8,$95B9,$95BA,$95BB,$95BC,$95BD,$95BE,$95BF,
$95C0,$95C1,$95C2,$95C3,$95C4,$95C5,$95C6,$95C7,$95C8,$95C9,$95CA,$95CB,$95CC,
$95CD,$95CE,$95CF,$95D0,$95D1,$95D2,$95D3,$95D4,$95D5,$95D6,$95D7,$95D8,$95D9,
$95DA,$95DB,$95DC,$95DD,$95DE,$95DF,$95E0,$95E1,$95E2,$95E3,$95E4,$95E5,$95E6,
$95E7,$95E8,$95E9,$95EA,$95EB,$95EC,$95ED,$95EE,$95EF,$95F0,$95F1,$95F2,$95F3,
$95F4,$95F5,$95F6,$95F7,$95F8,$95F9,$95FA,$95FB,$95FC,$95FD,$95FE,$95FF,$9600,
$9601,$9602,$9603,$9604,$9605,$9606,$9607,$9608,$9609,$960A,$960B,$960C,$960D,
$960E,$960F,$9610,$9611,$9612,$9613,$9614,$9615,$9616,$9617,$9618,$9619,$961A,
$961B,$961C,$961D,$961E,$961F,$9620,$9621,$9622,$9623,$9624,$9625,$9626,$9627,
$9628,$9629,$962A,$962B,$962C,$962D,$962E,$962F,$9630,$9631,$9632,$9633,$9634,
$9635,$9636,$9637,$9638,$9639,$963A,$963B,$963C,$963D,$963E,$963F,$9640,$9641,
$9642,$9643,$9644,$9645,$9646,$9647,$9648,$9649,$964A,$964B,$964C,$964D,$964E,
$964F,$9650,$9651,$9652,$9653,$9654,$9655,$9656,$9657,$9658,$9659,$965A,$965B,
$965C,$965D,$965E,$965F,$9660,$9661,$9662,$9663,$9664,$9665,$9666,$9667,$9668,
$9669,$966A,$966B,$966C,$966D,$966E,$966F,$9670,$9671,$9672,$9673,$9674,$9675,
$9676,$9677,$9678,$9679,$967A,$967B,$967C,$967D,$967E,$967F,$9680,$9681,$9682,
$9683,$9684,$9685,$9686,$9687,$9688,$9689,$968A,$968B,$968C,$968D,$968E,$968F,
$9690,$9691,$9692,$9693,$9694,$9695,$9696,$9697,$9698,$9699,$969A,$969B,$969C,
$969D,$969E,$969F,$96A0,$96A1,$96A2,$96A3,$96A4,$96A5,$96A6,$96A7,$96A8,$96A9,
$96AA,$96AB,$96AC,$96AD,$96AE,$96AF,$96B0,$96B1,$96B2,$96B3,$96B4,$96B5,$96B6,
$96B7,$96B8,$96B9,$96BA,$96BB,$96BC,$96BD,$96BE,$96BF,$96C0,$96C1,$96C2,$96C3,
$96C4,$96C5,$96C6,$96C7,$96C8,$96C9,$96CA,$96CB,$96CC,$96CD,$96CE,$96CF,$96D0,
$96D1,$96D2,$96D3,$96D4,$96D5,$96D6,$96D7,$96D8,$96D9,$96DA,$96DB,$96DC,$96DD,
$96DE,$96DF,$96E0,$96E1,$96E2,$96E3,$96E4,$96E5,$96E6,$96E7,$96E8,$96E9,$96EA,
$96EB,$96EC,$96ED,$96EE,$96EF,$96F0,$96F1,$96F2,$96F3,$96F4,$96F5,$96F6,$96F7,
$96F8,$96F9,$96FA,$96FB,$96FC,$96FD,$96FE,$96FF,$9700,$9701,$9702,$9703,$9704,
$9705,$9706,$9707,$9708,$9709,$970A,$970B,$970C,$970D,$970E,$970F,$9710,$9711,
$9712,$9713,$9714,$9715,$9716,$9717,$9718,$9719,$971A,$971B,$971C,$971D,$971E,
$971F,$9720,$9721,$9722,$9723,$9724,$9725,$9726,$9727,$9728,$9729,$972A,$972B,
$972C,$972D,$972E,$972F,$9730,$9731,$9732,$9733,$9734,$9735,$9736,$9737,$9738,
$9739,$973A,$973B,$973C,$973D,$973E,$973F,$9740,$9741,$9742,$9743,$9744,$9745,
$9746,$9747,$9748,$9749,$974A,$974B,$974C,$974D,$974E,$974F,$9750,$9751,$9752,
$9753,$9754,$9755,$9756,$9757,$9758,$9759,$975A,$975B,$975C,$975D,$975E,$975F,
$9760,$9761,$9762,$9763,$9764,$9765,$9766,$9767,$9768,$9769,$976A,$976B,$976C,
$976D,$976E,$976F,$9770,$9771,$9772,$9773,$9774,$9775,$9776,$9777,$9778,$9779,
$977A,$977B,$977C,$977D,$977E,$977F,$9780,$9781,$9782,$9783,$9784,$9785,$9786,
$9787,$9788,$9789,$978A,$978B,$978C,$978D,$978E,$978F,$9790,$9791,$9792,$9793,
$9794,$9795,$9796,$9797,$9798,$9799,$979A,$979B,$979C,$979D,$979E,$979F,$97A0,
$97A1,$97A2,$97A3,$97A4,$97A5,$97A6,$97A7,$97A8,$97A9,$97AA,$97AB,$97AC,$97AD,
$97AE,$97AF,$97B0,$97B1,$97B2,$97B3,$97B4,$97B5,$97B6,$97B7,$97B8,$97B9,$97BA,
$97BB,$97BC,$97BD,$97BE,$97BF,$97C0,$97C1,$97C2,$97C3,$97C4,$97C5,$97C6,$97C7,
$97C8,$97C9,$97CA,$97CB,$97CC,$97CD,$97CE,$97CF,$97D0,$97D1,$97D2,$97D3,$97D4,
$97D5,$97D6,$97D7,$97D8,$97D9,$97DA,$97DB,$97DC,$97DD,$97DE,$97DF,$97E0,$97E1,
$97E2,$97E3,$97E4,$97E5,$97E6,$97E7,$97E8,$97E9,$97EA,$97EB,$97EC,$97ED,$97EE,
$97EF,$97F0,$97F1,$97F2,$97F3,$97F4,$97F5,$97F6,$97F7,$97F8,$97F9,$97FA,$97FB,
$97FC,$97FD,$97FE,$97FF,$9800,$9801,$9802,$9803,$9804,$9805,$9806,$9807,$9808,
$9809,$980A,$980B,$980C,$980D,$980E,$980F,$9810,$9811,$9812,$9813,$9814,$9815,
$9816,$9817,$9818,$9819,$981A,$981B,$981C,$981D,$981E,$981F,$9820,$9821,$9822,
$9823,$9824,$9825,$9826,$9827,$9828,$9829,$982A,$982B,$982C,$982D,$982E,$982F,
$9830,$9831,$9832,$9833,$9834,$9835,$9836,$9837,$9838,$9839,$983A,$983B,$983C,
$983D,$983E,$983F,$9840,$9841,$9842,$9843,$9844,$9845,$9846,$9847,$9848,$9849,
$984A,$984B,$984C,$984D,$984E,$984F,$9850,$9851,$9852,$9853,$9854,$9855,$9856,
$9857,$9858,$9859,$985A,$985B,$985C,$985D,$985E,$985F,$9860,$9861,$9862,$9863,
$9864,$9865,$9866,$9867,$9868,$9869,$986A,$986B,$986C,$986D,$986E,$986F,$9870,
$9871,$9872,$9873,$9874,$9875,$9876,$9877,$9878,$9879,$987A,$987B,$987C,$987D,
$987E,$987F,$9880,$9881,$9882,$9883,$9884,$9885,$9886,$9887,$9888,$9889,$988A,
$988B,$988C,$988D,$988E,$988F,$9890,$9891,$9892,$9893,$9894,$9895,$9896,$9897,
$9898,$9899,$989A,$989B,$989C,$989D,$989E,$989F,$98A0,$98A1,$98A2,$98A3,$98A4,
$98A5,$98A6,$98A7,$98A8,$98A9,$98AA,$98AB,$98AC,$98AD,$98AE,$98AF,$98B0,$98B1,
$98B2,$98B3,$98B4,$98B5,$98B6,$98B7,$98B8,$98B9,$98BA,$98BB,$98BC,$98BD,$98BE,
$98BF,$98C0,$98C1,$98C2,$98C3,$98C4,$98C5,$98C6,$98C7,$98C8,$98C9,$98CA,$98CB,
$98CC,$98CD,$98CE,$98CF,$98D0,$98D1,$98D2,$98D3,$98D4,$98D5,$98D6,$98D7,$98D8,
$98D9,$98DA,$98DB,$98DC,$98DD,$98DE,$98DF,$98E0,$98E1,$98E2,$98E3,$98E4,$98E5,
$98E6,$98E7,$98E8,$98E9,$98EA,$98EB,$98EC,$98ED,$98EE,$98EF,$98F0,$98F1,$98F2,
$98F3,$98F4,$98F5,$98F6,$98F7,$98F8,$98F9,$98FA,$98FB,$98FC,$98FD,$98FE,$98FF,
$9900,$9901,$9902,$9903,$9904,$9905,$9906,$9907,$9908,$9909,$990A,$990B,$990C,
$990D,$990E,$990F,$9910,$9911,$9912,$9913,$9914,$9915,$9916,$9917,$9918,$9919,
$991A,$991B,$991C,$991D,$991E,$991F,$9920,$9921,$9922,$9923,$9924,$9925,$9926,
$9927,$9928,$9929,$992A,$992B,$992C,$992D,$992E,$992F,$9930,$9931,$9932,$9933,
$9934,$9935,$9936,$9937,$9938,$9939,$993A,$993B,$993C,$993D,$993E,$993F,$9940,
$9941,$9942,$9943,$9944,$9945,$9946,$9947,$9948,$9949,$994A,$994B,$994C,$994D,
$994E,$994F,$9950,$9951,$9952,$9953,$9954,$9955,$9956,$9957,$9958,$9959,$995A,
$995B,$995C,$995D,$995E,$995F,$9960,$9961,$9962,$9963,$9964,$9965,$9966,$9967,
$9968,$9969,$996A,$996B,$996C,$996D,$996E,$996F,$9970,$9971,$9972,$9973,$9974,
$9975,$9976,$9977,$9978,$9979,$997A,$997B,$997C,$997D,$997E,$997F,$9980,$9981,
$9982,$9983,$9984,$9985,$9986,$9987,$9988,$9989,$998A,$998B,$998C,$998D,$998E,
$998F,$9990,$9991,$9992,$9993,$9994,$9995,$9996,$9997,$9998,$9999,$999A,$999B,
$999C,$999D,$999E,$999F,$99A0,$99A1,$99A2,$99A3,$99A4,$99A5,$99A6,$99A7,$99A8,
$99A9,$99AA,$99AB,$99AC,$99AD,$99AE,$99AF,$99B0,$99B1,$99B2,$99B3,$99B4,$99B5,
$99B6,$99B7,$99B8,$99B9,$99BA,$99BB,$99BC,$99BD,$99BE,$99BF,$99C0,$99C1,$99C2,
$99C3,$99C4,$99C5,$99C6,$99C7,$99C8,$99C9,$99CA,$99CB,$99CC,$99CD,$99CE,$99CF,
$99D0,$99D1,$99D2,$99D3,$99D4,$99D5,$99D6,$99D7,$99D8,$99D9,$99DA,$99DB,$99DC,
$99DD,$99DE,$99DF,$99E0,$99E1,$99E2,$99E3,$99E4,$99E5,$99E6,$99E7,$99E8,$99E9,
$99EA,$99EB,$99EC,$99ED,$99EE,$99EF,$99F0,$99F1,$99F2,$99F3,$99F4,$99F5,$99F6,
$99F7,$99F8,$99F9,$99FA,$99FB,$99FC,$99FD,$99FE,$99FF,$9A00,$9A01,$9A02,$9A03,
$9A04,$9A05,$9A06,$9A07,$9A08,$9A09,$9A0A,$9A0B,$9A0C,$9A0D,$9A0E,$9A0F,$9A10,
$9A11,$9A12,$9A13,$9A14,$9A15,$9A16,$9A17,$9A18,$9A19,$9A1A,$9A1B,$9A1C,$9A1D,
$9A1E,$9A1F,$9A20,$9A21,$9A22,$9A23,$9A24,$9A25,$9A26,$9A27,$9A28,$9A29,$9A2A,
$9A2B,$9A2C,$9A2D,$9A2E,$9A2F,$9A30,$9A31,$9A32,$9A33,$9A34,$9A35,$9A36,$9A37,
$9A38,$9A39,$9A3A,$9A3B,$9A3C,$9A3D,$9A3E,$9A3F,$9A40,$9A41,$9A42,$9A43,$9A44,
$9A45,$9A46,$9A47,$9A48,$9A49,$9A4A,$9A4B,$9A4C,$9A4D,$9A4E,$9A4F,$9A50,$9A51,
$9A52,$9A53,$9A54,$9A55,$9A56,$9A57,$9A58,$9A59,$9A5A,$9A5B,$9A5C,$9A5D,$9A5E,
$9A5F,$9A60,$9A61,$9A62,$9A63,$9A64,$9A65,$9A66,$9A67,$9A68,$9A69,$9A6A,$9A6B,
$9A6C,$9A6D,$9A6E,$9A6F,$9A70,$9A71,$9A72,$9A73,$9A74,$9A75,$9A76,$9A77,$9A78,
$9A79,$9A7A,$9A7B,$9A7C,$9A7D,$9A7E,$9A7F,$9A80,$9A81,$9A82,$9A83,$9A84,$9A85,
$9A86,$9A87,$9A88,$9A89,$9A8A,$9A8B,$9A8C,$9A8D,$9A8E,$9A8F,$9A90,$9A91,$9A92,
$9A93,$9A94,$9A95,$9A96,$9A97,$9A98,$9A99,$9A9A,$9A9B,$9A9C,$9A9D,$9A9E,$9A9F,
$9AA0,$9AA1,$9AA2,$9AA3,$9AA4,$9AA5,$9AA6,$9AA7,$9AA8,$9AA9,$9AAA,$9AAB,$9AAC,
$9AAD,$9AAE,$9AAF,$9AB0,$9AB1,$9AB2,$9AB3,$9AB4,$9AB5,$9AB6,$9AB7,$9AB8,$9AB9,
$9ABA,$9ABB,$9ABC,$9ABD,$9ABE,$9ABF,$9AC0,$9AC1,$9AC2,$9AC3,$9AC4,$9AC5,$9AC6,
$9AC7,$9AC8,$9AC9,$9ACA,$9ACB,$9ACC,$9ACD,$9ACE,$9ACF,$9AD0,$9AD1,$9AD2,$9AD3,
$9AD4,$9AD5,$9AD6,$9AD7,$9AD8,$9AD9,$9ADA,$9ADB,$9ADC,$9ADD,$9ADE,$9ADF,$9AE0,
$9AE1,$9AE2,$9AE3,$9AE4,$9AE5,$9AE6,$9AE7,$9AE8,$9AE9,$9AEA,$9AEB,$9AEC,$9AED,
$9AEE,$9AEF,$9AF0,$9AF1,$9AF2,$9AF3,$9AF4,$9AF5,$9AF6,$9AF7,$9AF8,$9AF9,$9AFA,
$9AFB,$9AFC,$9AFD,$9AFE,$9AFF,$9B00,$9B01,$9B02,$9B03,$9B04,$9B05,$9B06,$9B07,
$9B08,$9B09,$9B0A,$9B0B,$9B0C,$9B0D,$9B0E,$9B0F,$9B10,$9B11,$9B12,$9B13,$9B14,
$9B15,$9B16,$9B17,$9B18,$9B19,$9B1A,$9B1B,$9B1C,$9B1D,$9B1E,$9B1F,$9B20,$9B21,
$9B22,$9B23,$9B24,$9B25,$9B26,$9B27,$9B28,$9B29,$9B2A,$9B2B,$9B2C,$9B2D,$9B2E,
$9B2F,$9B30,$9B31,$9B32,$9B33,$9B34,$9B35,$9B36,$9B37,$9B38,$9B39,$9B3A,$9B3B,
$9B3C,$9B3D,$9B3E,$9B3F,$9B40,$9B41,$9B42,$9B43,$9B44,$9B45,$9B46,$9B47,$9B48,
$9B49,$9B4A,$9B4B,$9B4C,$9B4D,$9B4E,$9B4F,$9B50,$9B51,$9B52,$9B53,$9B54,$9B55,
$9B56,$9B57,$9B58,$9B59,$9B5A,$9B5B,$9B5C,$9B5D,$9B5E,$9B5F,$9B60,$9B61,$9B62,
$9B63,$9B64,$9B65,$9B66,$9B67,$9B68,$9B69,$9B6A,$9B6B,$9B6C,$9B6D,$9B6E,$9B6F,
$9B70,$9B71,$9B72,$9B73,$9B74,$9B75,$9B76,$9B77,$9B78,$9B79,$9B7A,$9B7B,$9B7C,
$9B7D,$9B7E,$9B7F,$9B80,$9B81,$9B82,$9B83,$9B84,$9B85,$9B86,$9B87,$9B88,$9B89,
$9B8A,$9B8B,$9B8C,$9B8D,$9B8E,$9B8F,$9B90,$9B91,$9B92,$9B93,$9B94,$9B95,$9B96,
$9B97,$9B98,$9B99,$9B9A,$9B9B,$9B9C,$9B9D,$9B9E,$9B9F,$9BA0,$9BA1,$9BA2,$9BA3,
$9BA4,$9BA5,$9BA6,$9BA7,$9BA8,$9BA9,$9BAA,$9BAB,$9BAC,$9BAD,$9BAE,$9BAF,$9BB0,
$9BB1,$9BB2,$9BB3,$9BB4,$9BB5,$9BB6,$9BB7,$9BB8,$9BB9,$9BBA,$9BBB,$9BBC,$9BBD,
$9BBE,$9BBF,$9BC0,$9BC1,$9BC2,$9BC3,$9BC4,$9BC5,$9BC6,$9BC7,$9BC8,$9BC9,$9BCA,
$9BCB,$9BCC,$9BCD,$9BCE,$9BCF,$9BD0,$9BD1,$9BD2,$9BD3,$9BD4,$9BD5,$9BD6,$9BD7,
$9BD8,$9BD9,$9BDA,$9BDB,$9BDC,$9BDD,$9BDE,$9BDF,$9BE0,$9BE1,$9BE2,$9BE3,$9BE4,
$9BE5,$9BE6,$9BE7,$9BE8,$9BE9,$9BEA,$9BEB,$9BEC,$9BED,$9BEE,$9BEF,$9BF0,$9BF1,
$9BF2,$9BF3,$9BF4,$9BF5,$9BF6,$9BF7,$9BF8,$9BF9,$9BFA,$9BFB,$9BFC,$9BFD,$9BFE,
$9BFF,$9C00,$9C01,$9C02,$9C03,$9C04,$9C05,$9C06,$9C07,$9C08,$9C09,$9C0A,$9C0B,
$9C0C,$9C0D,$9C0E,$9C0F,$9C10,$9C11,$9C12,$9C13,$9C14,$9C15,$9C16,$9C17,$9C18,
$9C19,$9C1A,$9C1B,$9C1C,$9C1D,$9C1E,$9C1F,$9C20,$9C21,$9C22,$9C23,$9C24,$9C25,
$9C26,$9C27,$9C28,$9C29,$9C2A,$9C2B,$9C2C,$9C2D,$9C2E,$9C2F,$9C30,$9C31,$9C32,
$9C33,$9C34,$9C35,$9C36,$9C37,$9C38,$9C39,$9C3A,$9C3B,$9C3C,$9C3D,$9C3E,$9C3F,
$9C40,$9C41,$9C42,$9C43,$9C44,$9C45,$9C46,$9C47,$9C48,$9C49,$9C4A,$9C4B,$9C4C,
$9C4D,$9C4E,$9C4F,$9C50,$9C51,$9C52,$9C53,$9C54,$9C55,$9C56,$9C57,$9C58,$9C59,
$9C5A,$9C5B,$9C5C,$9C5D,$9C5E,$9C5F,$9C60,$9C61,$9C62,$9C63,$9C64,$9C65,$9C66,
$9C67,$9C68,$9C69,$9C6A,$9C6B,$9C6C,$9C6D,$9C6E,$9C6F,$9C70,$9C71,$9C72,$9C73,
$9C74,$9C75,$9C76,$9C77,$9C78,$9C79,$9C7A,$9C7B,$9C7C,$9C7D,$9C7E,$9C7F,$9C80,
$9C81,$9C82,$9C83,$9C84,$9C85,$9C86,$9C87,$9C88,$9C89,$9C8A,$9C8B,$9C8C,$9C8D,
$9C8E,$9C8F,$9C90,$9C91,$9C92,$9C93,$9C94,$9C95,$9C96,$9C97,$9C98,$9C99,$9C9A,
$9C9B,$9C9C,$9C9D,$9C9E,$9C9F,$9CA0,$9CA1,$9CA2,$9CA3,$9CA4,$9CA5,$9CA6,$9CA7,
$9CA8,$9CA9,$9CAA,$9CAB,$9CAC,$9CAD,$9CAE,$9CAF,$9CB0,$9CB1,$9CB2,$9CB3,$9CB4,
$9CB5,$9CB6,$9CB7,$9CB8,$9CB9,$9CBA,$9CBB,$9CBC,$9CBD,$9CBE,$9CBF,$9CC0,$9CC1,
$9CC2,$9CC3,$9CC4,$9CC5,$9CC6,$9CC7,$9CC8,$9CC9,$9CCA,$9CCB,$9CCC,$9CCD,$9CCE,
$9CCF,$9CD0,$9CD1,$9CD2,$9CD3,$9CD4,$9CD5,$9CD6,$9CD7,$9CD8,$9CD9,$9CDA,$9CDB,
$9CDC,$9CDD,$9CDE,$9CDF,$9CE0,$9CE1,$9CE2,$9CE3,$9CE4,$9CE5,$9CE6,$9CE7,$9CE8,
$9CE9,$9CEA,$9CEB,$9CEC,$9CED,$9CEE,$9CEF,$9CF0,$9CF1,$9CF2,$9CF3,$9CF4,$9CF5,
$9CF6,$9CF7,$9CF8,$9CF9,$9CFA,$9CFB,$9CFC,$9CFD,$9CFE,$9CFF,$9D00,$9D01,$9D02,
$9D03,$9D04,$9D05,$9D06,$9D07,$9D08,$9D09,$9D0A,$9D0B,$9D0C,$9D0D,$9D0E,$9D0F,
$9D10,$9D11,$9D12,$9D13,$9D14,$9D15,$9D16,$9D17,$9D18,$9D19,$9D1A,$9D1B,$9D1C,
$9D1D,$9D1E,$9D1F,$9D20,$9D21,$9D22,$9D23,$9D24,$9D25,$9D26,$9D27,$9D28,$9D29,
$9D2A,$9D2B,$9D2C,$9D2D,$9D2E,$9D2F,$9D30,$9D31,$9D32,$9D33,$9D34,$9D35,$9D36,
$9D37,$9D38,$9D39,$9D3A,$9D3B,$9D3C,$9D3D,$9D3E,$9D3F,$9D40,$9D41,$9D42,$9D43,
$9D44,$9D45,$9D46,$9D47,$9D48,$9D49,$9D4A,$9D4B,$9D4C,$9D4D,$9D4E,$9D4F,$9D50,
$9D51,$9D52,$9D53,$9D54,$9D55,$9D56,$9D57,$9D58,$9D59,$9D5A,$9D5B,$9D5C,$9D5D,
$9D5E,$9D5F,$9D60,$9D61,$9D62,$9D63,$9D64,$9D65,$9D66,$9D67,$9D68,$9D69,$9D6A,
$9D6B,$9D6C,$9D6D,$9D6E,$9D6F,$9D70,$9D71,$9D72,$9D73,$9D74,$9D75,$9D76,$9D77,
$9D78,$9D79,$9D7A,$9D7B,$9D7C,$9D7D,$9D7E,$9D7F,$9D80,$9D81,$9D82,$9D83,$9D84,
$9D85,$9D86,$9D87,$9D88,$9D89,$9D8A,$9D8B,$9D8C,$9D8D,$9D8E,$9D8F,$9D90,$9D91,
$9D92,$9D93,$9D94,$9D95,$9D96,$9D97,$9D98,$9D99,$9D9A,$9D9B,$9D9C,$9D9D,$9D9E,
$9D9F,$9DA0,$9DA1,$9DA2,$9DA3,$9DA4,$9DA5,$9DA6,$9DA7,$9DA8,$9DA9,$9DAA,$9DAB,
$9DAC,$9DAD,$9DAE,$9DAF,$9DB0,$9DB1,$9DB2,$9DB3,$9DB4,$9DB5,$9DB6,$9DB7,$9DB8,
$9DB9,$9DBA,$9DBB,$9DBC,$9DBD,$9DBE,$9DBF,$9DC0,$9DC1,$9DC2,$9DC3,$9DC4,$9DC5,
$9DC6,$9DC7,$9DC8,$9DC9,$9DCA,$9DCB,$9DCC,$9DCD,$9DCE,$9DCF,$9DD0,$9DD1,$9DD2,
$9DD3,$9DD4,$9DD5,$9DD6,$9DD7,$9DD8,$9DD9,$9DDA,$9DDB,$9DDC,$9DDD,$9DDE,$9DDF,
$9DE0,$9DE1,$9DE2,$9DE3,$9DE4,$9DE5,$9DE6,$9DE7,$9DE8,$9DE9,$9DEA,$9DEB,$9DEC,
$9DED,$9DEE,$9DEF,$9DF0,$9DF1,$9DF2,$9DF3,$9DF4,$9DF5,$9DF6,$9DF7,$9DF8,$9DF9,
$9DFA,$9DFB,$9DFC,$9DFD,$9DFE,$9DFF,$9E00,$9E01,$9E02,$9E03,$9E04,$9E05,$9E06,
$9E07,$9E08,$9E09,$9E0A,$9E0B,$9E0C,$9E0D,$9E0E,$9E0F,$9E10,$9E11,$9E12,$9E13,
$9E14,$9E15,$9E16,$9E17,$9E18,$9E19,$9E1A,$9E1B,$9E1C,$9E1D,$9E1E,$9E1F,$9E20,
$9E21,$9E22,$9E23,$9E24,$9E25,$9E26,$9E27,$9E28,$9E29,$9E2A,$9E2B,$9E2C,$9E2D,
$9E2E,$9E2F,$9E30,$9E31,$9E32,$9E33,$9E34,$9E35,$9E36,$9E37,$9E38,$9E39,$9E3A,
$9E3B,$9E3C,$9E3D,$9E3E,$9E3F,$9E40,$9E41,$9E42,$9E43,$9E44,$9E45,$9E46,$9E47,
$9E48,$9E49,$9E4A,$9E4B,$9E4C,$9E4D,$9E4E,$9E4F,$9E50,$9E51,$9E52,$9E53,$9E54,
$9E55,$9E56,$9E57,$9E58,$9E59,$9E5A,$9E5B,$9E5C,$9E5D,$9E5E,$9E5F,$9E60,$9E61,
$9E62,$9E63,$9E64,$9E65,$9E66,$9E67,$9E68,$9E69,$9E6A,$9E6B,$9E6C,$9E6D,$9E6E,
$9E6F,$9E70,$9E71,$9E72,$9E73,$9E74,$9E75,$9E76,$9E77,$9E78,$9E79,$9E7A,$9E7B,
$9E7C,$9E7D,$9E7E,$9E7F,$9E80,$9E81,$9E82,$9E83,$9E84,$9E85,$9E86,$9E87,$9E88,
$9E89,$9E8A,$9E8B,$9E8C,$9E8D,$9E8E,$9E8F,$9E90,$9E91,$9E92,$9E93,$9E94,$9E95,
$9E96,$9E97,$9E98,$9E99,$9E9A,$9E9B,$9E9C,$9E9D,$9E9E,$9E9F,$9EA0,$9EA1,$9EA2,
$9EA3,$9EA4,$9EA5,$9EA6,$9EA7,$9EA8,$9EA9,$9EAA,$9EAB,$9EAC,$9EAD,$9EAE,$9EAF,
$9EB0,$9EB1,$9EB2,$9EB3,$9EB4,$9EB5,$9EB6,$9EB7,$9EB8,$9EB9,$9EBA,$9EBB,$9EBC,
$9EBD,$9EBE,$9EBF,$9EC0,$9EC1,$9EC2,$9EC3,$9EC4,$9EC5,$9EC6,$9EC7,$9EC8,$9EC9,
$9ECA,$9ECB,$9ECC,$9ECD,$9ECE,$9ECF,$9ED0,$9ED1,$9ED2,$9ED3,$9ED4,$9ED5,$9ED6,
$9ED7,$9ED8,$9ED9,$9EDA,$9EDB,$9EDC,$9EDD,$9EDE,$9EDF,$9EE0,$9EE1,$9EE2,$9EE3,
$9EE4,$9EE5,$9EE6,$9EE7,$9EE8,$9EE9,$9EEA,$9EEB,$9EEC,$9EED,$9EEE,$9EEF,$9EF0,
$9EF1,$9EF2,$9EF3,$9EF4,$9EF5,$9EF6,$9EF7,$9EF8,$9EF9,$9EFA,$9EFB,$9EFC,$9EFD,
$9EFE,$9EFF,$9F00,$9F01,$9F02,$9F03,$9F04,$9F05,$9F06,$9F07,$9F08,$9F09,$9F0A,
$9F0B,$9F0C,$9F0D,$9F0E,$9F0F,$9F10,$9F11,$9F12,$9F13,$9F14,$9F15,$9F16,$9F17,
$9F18,$9F19,$9F1A,$9F1B,$9F1C,$9F1D,$9F1E,$9F1F,$9F20,$9F21,$9F22,$9F23,$9F24,
$9F25,$9F26,$9F27,$9F28,$9F29,$9F2A,$9F2B,$9F2C,$9F2D,$9F2E,$9F2F,$9F30,$9F31,
$9F32,$9F33,$9F34,$9F35,$9F36,$9F37,$9F38,$9F39,$9F3A,$9F3B,$9F3C,$9F3D,$9F3E,
$9F3F,$9F40,$9F41,$9F42,$9F43,$9F44,$9F45,$9F46,$9F47,$9F48,$9F49,$9F4A,$9F4B,
$9F4C,$9F4D,$9F4E,$9F4F,$9F50,$9F51,$9F52,$9F53,$9F54,$9F55,$9F56,$9F57,$9F58,
$9F59,$9F5A,$9F5B,$9F5C,$9F5D,$9F5E,$9F5F,$9F60,$9F61,$9F62,$9F63,$9F64,$9F65,
$9F66,$9F67,$9F68,$9F69,$9F6A,$9F6B,$9F6C,$9F6D,$9F6E,$9F6F,$9F70,$9F71,$9F72,
$9F73,$9F74,$9F75,$9F76,$9F77,$9F78,$9F79,$9F7A,$9F7B,$9F7C,$9F7D,$9F7E,$9F7F,
$9F80,$9F81,$9F82,$9F83,$9F84,$9F85,$9F86,$9F87,$9F88,$9F89,$9F8A,$9F8B,$9F8C,
$9F8D,$9F8E,$9F8F,$9F90,$9F91,$9F92,$9F93,$9F94,$9F95,$9F96,$9F97,$9F98,$9F99,
$9F9A,$9F9B,$9F9C,$9F9D,$9F9E,$9F9F,$9FA0,$9FA1,$9FA2,$9FA3,$9FA4,$9FA5,$F92C,
$F979,$F995,$F9E7,$F9F1,$FA0C,$FA0D,$FA0E,$FA0F,$FA11,$FA13,$FA14,$FA18,$FA1F,
$FA20,$FA21,$FA23,$FA24,$FA27,$FA28,$FA29,$FE30,$FE31,$FE33,$FE34,$FE35,$FE36,
$FE37,$FE38,$FE39,$FE3A,$FE3B,$FE3C,$FE3D,$FE3E,$FE3F,$FE40,$FE41,$FE42,$FE43,
$FE44,$FE49,$FE4A,$FE4B,$FE4C,$FE4D,$FE4E,$FE4F,$FE50,$FE51,$FE52,$FE54,$FE55,
$FE56,$FE57,$FE59,$FE5A,$FE5B,$FE5C,$FE5D,$FE5E,$FE5F,$FE60,$FE61,$FE62,$FE63,
$FE64,$FE65,$FE66,$FE68,$FE69,$FE6A,$FE6B,$FF01,$FF02,$FF03,$FF04,$FF05,$FF06,
$FF07,$FF08,$FF09,$FF0A,$FF0B,$FF0C,$FF0D,$FF0E,$FF0F,$FF10,$FF11,$FF12,$FF13,
$FF14,$FF15,$FF16,$FF17,$FF18,$FF19,$FF1A,$FF1B,$FF1C,$FF1D,$FF1E,$FF1F,$FF20,
$FF21,$FF22,$FF23,$FF24,$FF25,$FF26,$FF27,$FF28,$FF29,$FF2A,$FF2B,$FF2C,$FF2D,
$FF2E,$FF2F,$FF30,$FF31,$FF32,$FF33,$FF34,$FF35,$FF36,$FF37,$FF38,$FF39,$FF3A,
$FF3B,$FF3C,$FF3D,$FF3E,$FF3F,$FF40,$FF41,$FF42,$FF43,$FF44,$FF45,$FF46,$FF47,
$FF48,$FF49,$FF4A,$FF4B,$FF4C,$FF4D,$FF4E,$FF4F,$FF50,$FF51,$FF52,$FF53,$FF54,
$FF55,$FF56,$FF57,$FF58,$FF59,$FF5A,$FF5B,$FF5C,$FF5D,$FF5E,$FFE0,$FFE1,$FFE2,
$FFE3,$FFE4,$FFE5);
{$endif}

const CP950CC: CP950Arr =
($00,$01,$02,$03,$04,$05,$06,$07,$08,$09,$0A,$0B,$0C,$0D,$0E,$0F,$10,$11,$12,
$13,$14,$15,$16,$17,$18,$19,$1A,$1B,$1C,$1D,$1E,$1F,$20,$21,$22,$23,$24,$25,
$26,$27,$28,$29,$2A,$2B,$2C,$2D,$2E,$2F,$30,$31,$32,$33,$34,$35,$36,$37,$38,
$39,$3A,$3B,$3C,$3D,$3E,$3F,$40,$41,$42,$43,$44,$45,$46,$47,$48,$49,$4A,$4B,
$4C,$4D,$4E,$4F,$50,$51,$52,$53,$54,$55,$56,$57,$58,$59,$5A,$5B,$5C,$5D,$5E,
$5F,$60,$61,$62,$63,$64,$65,$66,$67,$68,$69,$6A,$6B,$6C,$6D,$6E,$6F,$70,$71,
$72,$73,$74,$75,$76,$77,$78,$79,$7A,$7B,$7C,$7D,$7E,$7F,$80,$81,$82,$83,$84,
$85,$86,$87,$88,$89,$8A,$8B,$8C,$8D,$8E,$8F,$90,$91,$92,$93,$94,$95,$96,$97,
$98,$99,$9A,$9B,$9C,$9D,$9E,$9F,$A0,$A1,$A2,$A3,$A4,$A5,$A6,$A7,$A8,$A9,$AA,
$AB,$AC,$AD,$AE,$AF,$B0,$B1,$B2,$B3,$B4,$B5,$B6,$B7,$B8,$B9,$BA,$BB,$BC,$BD,
$BE,$BF,$C0,$C1,$C2,$C3,$C4,$C5,$C6,$C7,$C8,$C9,$CA,$CB,$CC,$CD,$CE,$CF,$D0,
$D1,$D2,$D3,$D4,$D5,$D6,$D7,$D8,$D9,$DA,$DB,$DC,$DD,$DE,$DF,$E0,$E1,$E2,$E3,
$E4,$E5,$E6,$E7,$E8,$E9,$EA,$EB,$EC,$ED,$EE,$EF,$F0,$F1,$F2,$F3,$F4,$F5,$F6,
$F7,$F8,$F9,$FA,$FB,$FC,$FD,$FE,$FF,$A140,$A141,$A142,$A143,$A144,$A145,$A146,
$A147,$A148,$A149,$A14A,$A14B,$A14C,$A14D,$A14E,$A14F,$A150,$A151,$A152,$A153,
$A154,$A155,$A156,$A157,$A158,$A159,$A15A,$A15B,$A15C,$A15D,$A15E,$A15F,$A160,
$A161,$A162,$A163,$A164,$A165,$A166,$A167,$A168,$A169,$A16A,$A16B,$A16C,$A16D,
$A16E,$A16F,$A170,$A171,$A172,$A173,$A174,$A175,$A176,$A177,$A178,$A179,$A17A,
$A17B,$A17C,$A17D,$A17E,$A1A1,$A1A2,$A1A3,$A1A4,$A1A5,$A1A6,$A1A7,$A1A8,$A1A9,
$A1AA,$A1AB,$A1AC,$A1AD,$A1AE,$A1AF,$A1B0,$A1B1,$A1B2,$A1B3,$A1B4,$A1B5,$A1B6,
$A1B7,$A1B8,$A1B9,$A1BA,$A1BB,$A1BC,$A1BD,$A1BE,$A1BF,$A1C0,$A1C1,$A1C2,$A1C3,
$A1C4,$A1C5,$A1C6,$A1C7,$A1C8,$A1C9,$A1CA,$A1CB,$A1CC,$A1CD,$A1CE,$A1CF,$A1D0,
$A1D1,$A1D2,$A1D3,$A1D4,$A1D5,$A1D6,$A1D7,$A1D8,$A1D9,$A1DA,$A1DB,$A1DC,$A1DD,
$A1DE,$A1DF,$A1E0,$A1E1,$A1E2,$A1E3,$A1E4,$A1E5,$A1E6,$A1E7,$A1E8,$A1E9,$A1EA,
$A1EB,$A1EC,$A1ED,$A1EE,$A1EF,$A1F0,$A1F1,$A1F2,$A1F3,$A1F4,$A1F5,$A1F6,$A1F7,
$A1F8,$A1F9,$A1FA,$A1FB,$A1FC,$A1FD,$A1FE,$A240,$A241,$A242,$A243,$A244,$A245,
$A246,$A247,$A248,$A249,$A24A,$A24B,$A24C,$A24D,$A24E,$A24F,$A250,$A251,$A252,
$A253,$A254,$A255,$A256,$A257,$A258,$A259,$A25A,$A25B,$A25C,$A25D,$A25E,$A25F,
$A260,$A261,$A262,$A263,$A264,$A265,$A266,$A267,$A268,$A269,$A26A,$A26B,$A26C,
$A26D,$A26E,$A26F,$A270,$A271,$A272,$A273,$A274,$A275,$A276,$A277,$A278,$A279,
$A27A,$A27B,$A27C,$A27D,$A27E,$A2A1,$A2A2,$A2A3,$A2A4,$A2A5,$A2A6,$A2A7,$A2A8,
$A2A9,$A2AA,$A2AB,$A2AC,$A2AD,$A2AE,$A2AF,$A2B0,$A2B1,$A2B2,$A2B3,$A2B4,$A2B5,
$A2B6,$A2B7,$A2B8,$A2B9,$A2BA,$A2BB,$A2BC,$A2BD,$A2BE,$A2BF,$A2C0,$A2C1,$A2C2,
$A2C3,$A2C4,$A2C5,$A2C6,$A2C7,$A2C8,$A2C9,$A2CA,$A2CB,$A2CC,$A2CD,$A2CE,$A2CF,
$A2D0,$A2D1,$A2D2,$A2D3,$A2D4,$A2D5,$A2D6,$A2D7,$A2D8,$A2D9,$A2DA,$A2DB,$A2DC,
$A2DD,$A2DE,$A2DF,$A2E0,$A2E1,$A2E2,$A2E3,$A2E4,$A2E5,$A2E6,$A2E7,$A2E8,$A2E9,
$A2EA,$A2EB,$A2EC,$A2ED,$A2EE,$A2EF,$A2F0,$A2F1,$A2F2,$A2F3,$A2F4,$A2F5,$A2F6,
$A2F7,$A2F8,$A2F9,$A2FA,$A2FB,$A2FC,$A2FD,$A2FE,$A340,$A341,$A342,$A343,$A344,
$A345,$A346,$A347,$A348,$A349,$A34A,$A34B,$A34C,$A34D,$A34E,$A34F,$A350,$A351,
$A352,$A353,$A354,$A355,$A356,$A357,$A358,$A359,$A35A,$A35B,$A35C,$A35D,$A35E,
$A35F,$A360,$A361,$A362,$A363,$A364,$A365,$A366,$A367,$A368,$A369,$A36A,$A36B,
$A36C,$A36D,$A36E,$A36F,$A370,$A371,$A372,$A373,$A374,$A375,$A376,$A377,$A378,
$A379,$A37A,$A37B,$A37C,$A37D,$A37E,$A3A1,$A3A2,$A3A3,$A3A4,$A3A5,$A3A6,$A3A7,
$A3A8,$A3A9,$A3AA,$A3AB,$A3AC,$A3AD,$A3AE,$A3AF,$A3B0,$A3B1,$A3B2,$A3B3,$A3B4,
$A3B5,$A3B6,$A3B7,$A3B8,$A3B9,$A3BA,$A3BB,$A3BC,$A3BD,$A3BE,$A3BF,$A3E1,$A440,
$A441,$A442,$A443,$A444,$A445,$A446,$A447,$A448,$A449,$A44A,$A44B,$A44C,$A44D,
$A44E,$A44F,$A450,$A451,$A452,$A453,$A454,$A455,$A456,$A457,$A458,$A459,$A45A,
$A45B,$A45C,$A45D,$A45E,$A45F,$A460,$A461,$A462,$A463,$A464,$A465,$A466,$A467,
$A468,$A469,$A46A,$A46B,$A46C,$A46D,$A46E,$A46F,$A470,$A471,$A472,$A473,$A474,
$A475,$A476,$A477,$A478,$A479,$A47A,$A47B,$A47C,$A47D,$A47E,$A4A1,$A4A2,$A4A3,
$A4A4,$A4A5,$A4A6,$A4A7,$A4A8,$A4A9,$A4AA,$A4AB,$A4AC,$A4AD,$A4AE,$A4AF,$A4B0,
$A4B1,$A4B2,$A4B3,$A4B4,$A4B5,$A4B6,$A4B7,$A4B8,$A4B9,$A4BA,$A4BB,$A4BC,$A4BD,
$A4BE,$A4BF,$A4C0,$A4C1,$A4C2,$A4C3,$A4C4,$A4C5,$A4C6,$A4C7,$A4C8,$A4C9,$A4CA,
$A4CB,$A4CC,$A4CD,$A4CE,$A4CF,$A4D0,$A4D1,$A4D2,$A4D3,$A4D4,$A4D5,$A4D6,$A4D7,
$A4D8,$A4D9,$A4DA,$A4DB,$A4DC,$A4DD,$A4DE,$A4DF,$A4E0,$A4E1,$A4E2,$A4E3,$A4E4,
$A4E5,$A4E6,$A4E7,$A4E8,$A4E9,$A4EA,$A4EB,$A4EC,$A4ED,$A4EE,$A4EF,$A4F0,$A4F1,
$A4F2,$A4F3,$A4F4,$A4F5,$A4F6,$A4F7,$A4F8,$A4F9,$A4FA,$A4FB,$A4FC,$A4FD,$A4FE,
$A540,$A541,$A542,$A543,$A544,$A545,$A546,$A547,$A548,$A549,$A54A,$A54B,$A54C,
$A54D,$A54E,$A54F,$A550,$A551,$A552,$A553,$A554,$A555,$A556,$A557,$A558,$A559,
$A55A,$A55B,$A55C,$A55D,$A55E,$A55F,$A560,$A561,$A562,$A563,$A564,$A565,$A566,
$A567,$A568,$A569,$A56A,$A56B,$A56C,$A56D,$A56E,$A56F,$A570,$A571,$A572,$A573,
$A574,$A575,$A576,$A577,$A578,$A579,$A57A,$A57B,$A57C,$A57D,$A57E,$A5A1,$A5A2,
$A5A3,$A5A4,$A5A5,$A5A6,$A5A7,$A5A8,$A5A9,$A5AA,$A5AB,$A5AC,$A5AD,$A5AE,$A5AF,
$A5B0,$A5B1,$A5B2,$A5B3,$A5B4,$A5B5,$A5B6,$A5B7,$A5B8,$A5B9,$A5BA,$A5BB,$A5BC,
$A5BD,$A5BE,$A5BF,$A5C0,$A5C1,$A5C2,$A5C3,$A5C4,$A5C5,$A5C6,$A5C7,$A5C8,$A5C9,
$A5CA,$A5CB,$A5CC,$A5CD,$A5CE,$A5CF,$A5D0,$A5D1,$A5D2,$A5D3,$A5D4,$A5D5,$A5D6,
$A5D7,$A5D8,$A5D9,$A5DA,$A5DB,$A5DC,$A5DD,$A5DE,$A5DF,$A5E0,$A5E1,$A5E2,$A5E3,
$A5E4,$A5E5,$A5E6,$A5E7,$A5E8,$A5E9,$A5EA,$A5EB,$A5EC,$A5ED,$A5EE,$A5EF,$A5F0,
$A5F1,$A5F2,$A5F3,$A5F4,$A5F5,$A5F6,$A5F7,$A5F8,$A5F9,$A5FA,$A5FB,$A5FC,$A5FD,
$A5FE,$A640,$A641,$A642,$A643,$A644,$A645,$A646,$A647,$A648,$A649,$A64A,$A64B,
$A64C,$A64D,$A64E,$A64F,$A650,$A651,$A652,$A653,$A654,$A655,$A656,$A657,$A658,
$A659,$A65A,$A65B,$A65C,$A65D,$A65E,$A65F,$A660,$A661,$A662,$A663,$A664,$A665,
$A666,$A667,$A668,$A669,$A66A,$A66B,$A66C,$A66D,$A66E,$A66F,$A670,$A671,$A672,
$A673,$A674,$A675,$A676,$A677,$A678,$A679,$A67A,$A67B,$A67C,$A67D,$A67E,$A6A1,
$A6A2,$A6A3,$A6A4,$A6A5,$A6A6,$A6A7,$A6A8,$A6A9,$A6AA,$A6AB,$A6AC,$A6AD,$A6AE,
$A6AF,$A6B0,$A6B1,$A6B2,$A6B3,$A6B4,$A6B5,$A6B6,$A6B7,$A6B8,$A6B9,$A6BA,$A6BB,
$A6BC,$A6BD,$A6BE,$A6BF,$A6C0,$A6C1,$A6C2,$A6C3,$A6C4,$A6C5,$A6C6,$A6C7,$A6C8,
$A6C9,$A6CA,$A6CB,$A6CC,$A6CD,$A6CE,$A6CF,$A6D0,$A6D1,$A6D2,$A6D3,$A6D4,$A6D5,
$A6D6,$A6D7,$A6D8,$A6D9,$A6DA,$A6DB,$A6DC,$A6DD,$A6DE,$A6DF,$A6E0,$A6E1,$A6E2,
$A6E3,$A6E4,$A6E5,$A6E6,$A6E7,$A6E8,$A6E9,$A6EA,$A6EB,$A6EC,$A6ED,$A6EE,$A6EF,
$A6F0,$A6F1,$A6F2,$A6F3,$A6F4,$A6F5,$A6F6,$A6F7,$A6F8,$A6F9,$A6FA,$A6FB,$A6FC,
$A6FD,$A6FE,$A740,$A741,$A742,$A743,$A744,$A745,$A746,$A747,$A748,$A749,$A74A,
$A74B,$A74C,$A74D,$A74E,$A74F,$A750,$A751,$A752,$A753,$A754,$A755,$A756,$A757,
$A758,$A759,$A75A,$A75B,$A75C,$A75D,$A75E,$A75F,$A760,$A761,$A762,$A763,$A764,
$A765,$A766,$A767,$A768,$A769,$A76A,$A76B,$A76C,$A76D,$A76E,$A76F,$A770,$A771,
$A772,$A773,$A774,$A775,$A776,$A777,$A778,$A779,$A77A,$A77B,$A77C,$A77D,$A77E,
$A7A1,$A7A2,$A7A3,$A7A4,$A7A5,$A7A6,$A7A7,$A7A8,$A7A9,$A7AA,$A7AB,$A7AC,$A7AD,
$A7AE,$A7AF,$A7B0,$A7B1,$A7B2,$A7B3,$A7B4,$A7B5,$A7B6,$A7B7,$A7B8,$A7B9,$A7BA,
$A7BB,$A7BC,$A7BD,$A7BE,$A7BF,$A7C0,$A7C1,$A7C2,$A7C3,$A7C4,$A7C5,$A7C6,$A7C7,
$A7C8,$A7C9,$A7CA,$A7CB,$A7CC,$A7CD,$A7CE,$A7CF,$A7D0,$A7D1,$A7D2,$A7D3,$A7D4,
$A7D5,$A7D6,$A7D7,$A7D8,$A7D9,$A7DA,$A7DB,$A7DC,$A7DD,$A7DE,$A7DF,$A7E0,$A7E1,
$A7E2,$A7E3,$A7E4,$A7E5,$A7E6,$A7E7,$A7E8,$A7E9,$A7EA,$A7EB,$A7EC,$A7ED,$A7EE,
$A7EF,$A7F0,$A7F1,$A7F2,$A7F3,$A7F4,$A7F5,$A7F6,$A7F7,$A7F8,$A7F9,$A7FA,$A7FB,
$A7FC,$A7FD,$A7FE,$A840,$A841,$A842,$A843,$A844,$A845,$A846,$A847,$A848,$A849,
$A84A,$A84B,$A84C,$A84D,$A84E,$A84F,$A850,$A851,$A852,$A853,$A854,$A855,$A856,
$A857,$A858,$A859,$A85A,$A85B,$A85C,$A85D,$A85E,$A85F,$A860,$A861,$A862,$A863,
$A864,$A865,$A866,$A867,$A868,$A869,$A86A,$A86B,$A86C,$A86D,$A86E,$A86F,$A870,
$A871,$A872,$A873,$A874,$A875,$A876,$A877,$A878,$A879,$A87A,$A87B,$A87C,$A87D,
$A87E,$A8A1,$A8A2,$A8A3,$A8A4,$A8A5,$A8A6,$A8A7,$A8A8,$A8A9,$A8AA,$A8AB,$A8AC,
$A8AD,$A8AE,$A8AF,$A8B0,$A8B1,$A8B2,$A8B3,$A8B4,$A8B5,$A8B6,$A8B7,$A8B8,$A8B9,
$A8BA,$A8BB,$A8BC,$A8BD,$A8BE,$A8BF,$A8C0,$A8C1,$A8C2,$A8C3,$A8C4,$A8C5,$A8C6,
$A8C7,$A8C8,$A8C9,$A8CA,$A8CB,$A8CC,$A8CD,$A8CE,$A8CF,$A8D0,$A8D1,$A8D2,$A8D3,
$A8D4,$A8D5,$A8D6,$A8D7,$A8D8,$A8D9,$A8DA,$A8DB,$A8DC,$A8DD,$A8DE,$A8DF,$A8E0,
$A8E1,$A8E2,$A8E3,$A8E4,$A8E5,$A8E6,$A8E7,$A8E8,$A8E9,$A8EA,$A8EB,$A8EC,$A8ED,
$A8EE,$A8EF,$A8F0,$A8F1,$A8F2,$A8F3,$A8F4,$A8F5,$A8F6,$A8F7,$A8F8,$A8F9,$A8FA,
$A8FB,$A8FC,$A8FD,$A8FE,$A940,$A941,$A942,$A943,$A944,$A945,$A946,$A947,$A948,
$A949,$A94A,$A94B,$A94C,$A94D,$A94E,$A94F,$A950,$A951,$A952,$A953,$A954,$A955,
$A956,$A957,$A958,$A959,$A95A,$A95B,$A95C,$A95D,$A95E,$A95F,$A960,$A961,$A962,
$A963,$A964,$A965,$A966,$A967,$A968,$A969,$A96A,$A96B,$A96C,$A96D,$A96E,$A96F,
$A970,$A971,$A972,$A973,$A974,$A975,$A976,$A977,$A978,$A979,$A97A,$A97B,$A97C,
$A97D,$A97E,$A9A1,$A9A2,$A9A3,$A9A4,$A9A5,$A9A6,$A9A7,$A9A8,$A9A9,$A9AA,$A9AB,
$A9AC,$A9AD,$A9AE,$A9AF,$A9B0,$A9B1,$A9B2,$A9B3,$A9B4,$A9B5,$A9B6,$A9B7,$A9B8,
$A9B9,$A9BA,$A9BB,$A9BC,$A9BD,$A9BE,$A9BF,$A9C0,$A9C1,$A9C2,$A9C3,$A9C4,$A9C5,
$A9C6,$A9C7,$A9C8,$A9C9,$A9CA,$A9CB,$A9CC,$A9CD,$A9CE,$A9CF,$A9D0,$A9D1,$A9D2,
$A9D3,$A9D4,$A9D5,$A9D6,$A9D7,$A9D8,$A9D9,$A9DA,$A9DB,$A9DC,$A9DD,$A9DE,$A9DF,
$A9E0,$A9E1,$A9E2,$A9E3,$A9E4,$A9E5,$A9E6,$A9E7,$A9E8,$A9E9,$A9EA,$A9EB,$A9EC,
$A9ED,$A9EE,$A9EF,$A9F0,$A9F1,$A9F2,$A9F3,$A9F4,$A9F5,$A9F6,$A9F7,$A9F8,$A9F9,
$A9FA,$A9FB,$A9FC,$A9FD,$A9FE,$AA40,$AA41,$AA42,$AA43,$AA44,$AA45,$AA46,$AA47,
$AA48,$AA49,$AA4A,$AA4B,$AA4C,$AA4D,$AA4E,$AA4F,$AA50,$AA51,$AA52,$AA53,$AA54,
$AA55,$AA56,$AA57,$AA58,$AA59,$AA5A,$AA5B,$AA5C,$AA5D,$AA5E,$AA5F,$AA60,$AA61,
$AA62,$AA63,$AA64,$AA65,$AA66,$AA67,$AA68,$AA69,$AA6A,$AA6B,$AA6C,$AA6D,$AA6E,
$AA6F,$AA70,$AA71,$AA72,$AA73,$AA74,$AA75,$AA76,$AA77,$AA78,$AA79,$AA7A,$AA7B,
$AA7C,$AA7D,$AA7E,$AAA1,$AAA2,$AAA3,$AAA4,$AAA5,$AAA6,$AAA7,$AAA8,$AAA9,$AAAA,
$AAAB,$AAAC,$AAAD,$AAAE,$AAAF,$AAB0,$AAB1,$AAB2,$AAB3,$AAB4,$AAB5,$AAB6,$AAB7,
$AAB8,$AAB9,$AABA,$AABB,$AABC,$AABD,$AABE,$AABF,$AAC0,$AAC1,$AAC2,$AAC3,$AAC4,
$AAC5,$AAC6,$AAC7,$AAC8,$AAC9,$AACA,$AACB,$AACC,$AACD,$AACE,$AACF,$AAD0,$AAD1,
$AAD2,$AAD3,$AAD4,$AAD5,$AAD6,$AAD7,$AAD8,$AAD9,$AADA,$AADB,$AADC,$AADD,$AADE,
$AADF,$AAE0,$AAE1,$AAE2,$AAE3,$AAE4,$AAE5,$AAE6,$AAE7,$AAE8,$AAE9,$AAEA,$AAEB,
$AAEC,$AAED,$AAEE,$AAEF,$AAF0,$AAF1,$AAF2,$AAF3,$AAF4,$AAF5,$AAF6,$AAF7,$AAF8,
$AAF9,$AAFA,$AAFB,$AAFC,$AAFD,$AAFE,$AB40,$AB41,$AB42,$AB43,$AB44,$AB45,$AB46,
$AB47,$AB48,$AB49,$AB4A,$AB4B,$AB4C,$AB4D,$AB4E,$AB4F,$AB50,$AB51,$AB52,$AB53,
$AB54,$AB55,$AB56,$AB57,$AB58,$AB59,$AB5A,$AB5B,$AB5C,$AB5D,$AB5E,$AB5F,$AB60,
$AB61,$AB62,$AB63,$AB64,$AB65,$AB66,$AB67,$AB68,$AB69,$AB6A,$AB6B,$AB6C,$AB6D,
$AB6E,$AB6F,$AB70,$AB71,$AB72,$AB73,$AB74,$AB75,$AB76,$AB77,$AB78,$AB79,$AB7A,
$AB7B,$AB7C,$AB7D,$AB7E,$ABA1,$ABA2,$ABA3,$ABA4,$ABA5,$ABA6,$ABA7,$ABA8,$ABA9,
$ABAA,$ABAB,$ABAC,$ABAD,$ABAE,$ABAF,$ABB0,$ABB1,$ABB2,$ABB3,$ABB4,$ABB5,$ABB6,
$ABB7,$ABB8,$ABB9,$ABBA,$ABBB,$ABBC,$ABBD,$ABBE,$ABBF,$ABC0,$ABC1,$ABC2,$ABC3,
$ABC4,$ABC5,$ABC6,$ABC7,$ABC8,$ABC9,$ABCA,$ABCB,$ABCC,$ABCD,$ABCE,$ABCF,$ABD0,
$ABD1,$ABD2,$ABD3,$ABD4,$ABD5,$ABD6,$ABD7,$ABD8,$ABD9,$ABDA,$ABDB,$ABDC,$ABDD,
$ABDE,$ABDF,$ABE0,$ABE1,$ABE2,$ABE3,$ABE4,$ABE5,$ABE6,$ABE7,$ABE8,$ABE9,$ABEA,
$ABEB,$ABEC,$ABED,$ABEE,$ABEF,$ABF0,$ABF1,$ABF2,$ABF3,$ABF4,$ABF5,$ABF6,$ABF7,
$ABF8,$ABF9,$ABFA,$ABFB,$ABFC,$ABFD,$ABFE,$AC40,$AC41,$AC42,$AC43,$AC44,$AC45,
$AC46,$AC47,$AC48,$AC49,$AC4A,$AC4B,$AC4C,$AC4D,$AC4E,$AC4F,$AC50,$AC51,$AC52,
$AC53,$AC54,$AC55,$AC56,$AC57,$AC58,$AC59,$AC5A,$AC5B,$AC5C,$AC5D,$AC5E,$AC5F,
$AC60,$AC61,$AC62,$AC63,$AC64,$AC65,$AC66,$AC67,$AC68,$AC69,$AC6A,$AC6B,$AC6C,
$AC6D,$AC6E,$AC6F,$AC70,$AC71,$AC72,$AC73,$AC74,$AC75,$AC76,$AC77,$AC78,$AC79,
$AC7A,$AC7B,$AC7C,$AC7D,$AC7E,$ACA1,$ACA2,$ACA3,$ACA4,$ACA5,$ACA6,$ACA7,$ACA8,
$ACA9,$ACAA,$ACAB,$ACAC,$ACAD,$ACAE,$ACAF,$ACB0,$ACB1,$ACB2,$ACB3,$ACB4,$ACB5,
$ACB6,$ACB7,$ACB8,$ACB9,$ACBA,$ACBB,$ACBC,$ACBD,$ACBE,$ACBF,$ACC0,$ACC1,$ACC2,
$ACC3,$ACC4,$ACC5,$ACC6,$ACC7,$ACC8,$ACC9,$ACCA,$ACCB,$ACCC,$ACCD,$ACCE,$ACCF,
$ACD0,$ACD1,$ACD2,$ACD3,$ACD4,$ACD5,$ACD6,$ACD7,$ACD8,$ACD9,$ACDA,$ACDB,$ACDC,
$ACDD,$ACDE,$ACDF,$ACE0,$ACE1,$ACE2,$ACE3,$ACE4,$ACE5,$ACE6,$ACE7,$ACE8,$ACE9,
$ACEA,$ACEB,$ACEC,$ACED,$ACEE,$ACEF,$ACF0,$ACF1,$ACF2,$ACF3,$ACF4,$ACF5,$ACF6,
$ACF7,$ACF8,$ACF9,$ACFA,$ACFB,$ACFC,$ACFD,$ACFE,$AD40,$AD41,$AD42,$AD43,$AD44,
$AD45,$AD46,$AD47,$AD48,$AD49,$AD4A,$AD4B,$AD4C,$AD4D,$AD4E,$AD4F,$AD50,$AD51,
$AD52,$AD53,$AD54,$AD55,$AD56,$AD57,$AD58,$AD59,$AD5A,$AD5B,$AD5C,$AD5D,$AD5E,
$AD5F,$AD60,$AD61,$AD62,$AD63,$AD64,$AD65,$AD66,$AD67,$AD68,$AD69,$AD6A,$AD6B,
$AD6C,$AD6D,$AD6E,$AD6F,$AD70,$AD71,$AD72,$AD73,$AD74,$AD75,$AD76,$AD77,$AD78,
$AD79,$AD7A,$AD7B,$AD7C,$AD7D,$AD7E,$ADA1,$ADA2,$ADA3,$ADA4,$ADA5,$ADA6,$ADA7,
$ADA8,$ADA9,$ADAA,$ADAB,$ADAC,$ADAD,$ADAE,$ADAF,$ADB0,$ADB1,$ADB2,$ADB3,$ADB4,
$ADB5,$ADB6,$ADB7,$ADB8,$ADB9,$ADBA,$ADBB,$ADBC,$ADBD,$ADBE,$ADBF,$ADC0,$ADC1,
$ADC2,$ADC3,$ADC4,$ADC5,$ADC6,$ADC7,$ADC8,$ADC9,$ADCA,$ADCB,$ADCC,$ADCD,$ADCE,
$ADCF,$ADD0,$ADD1,$ADD2,$ADD3,$ADD4,$ADD5,$ADD6,$ADD7,$ADD8,$ADD9,$ADDA,$ADDB,
$ADDC,$ADDD,$ADDE,$ADDF,$ADE0,$ADE1,$ADE2,$ADE3,$ADE4,$ADE5,$ADE6,$ADE7,$ADE8,
$ADE9,$ADEA,$ADEB,$ADEC,$ADED,$ADEE,$ADEF,$ADF0,$ADF1,$ADF2,$ADF3,$ADF4,$ADF5,
$ADF6,$ADF7,$ADF8,$ADF9,$ADFA,$ADFB,$ADFC,$ADFD,$ADFE,$AE40,$AE41,$AE42,$AE43,
$AE44,$AE45,$AE46,$AE47,$AE48,$AE49,$AE4A,$AE4B,$AE4C,$AE4D,$AE4E,$AE4F,$AE50,
$AE51,$AE52,$AE53,$AE54,$AE55,$AE56,$AE57,$AE58,$AE59,$AE5A,$AE5B,$AE5C,$AE5D,
$AE5E,$AE5F,$AE60,$AE61,$AE62,$AE63,$AE64,$AE65,$AE66,$AE67,$AE68,$AE69,$AE6A,
$AE6B,$AE6C,$AE6D,$AE6E,$AE6F,$AE70,$AE71,$AE72,$AE73,$AE74,$AE75,$AE76,$AE77,
$AE78,$AE79,$AE7A,$AE7B,$AE7C,$AE7D,$AE7E,$AEA1,$AEA2,$AEA3,$AEA4,$AEA5,$AEA6,
$AEA7,$AEA8,$AEA9,$AEAA,$AEAB,$AEAC,$AEAD,$AEAE,$AEAF,$AEB0,$AEB1,$AEB2,$AEB3,
$AEB4,$AEB5,$AEB6,$AEB7,$AEB8,$AEB9,$AEBA,$AEBB,$AEBC,$AEBD,$AEBE,$AEBF,$AEC0,
$AEC1,$AEC2,$AEC3,$AEC4,$AEC5,$AEC6,$AEC7,$AEC8,$AEC9,$AECA,$AECB,$AECC,$AECD,
$AECE,$AECF,$AED0,$AED1,$AED2,$AED3,$AED4,$AED5,$AED6,$AED7,$AED8,$AED9,$AEDA,
$AEDB,$AEDC,$AEDD,$AEDE,$AEDF,$AEE0,$AEE1,$AEE2,$AEE3,$AEE4,$AEE5,$AEE6,$AEE7,
$AEE8,$AEE9,$AEEA,$AEEB,$AEEC,$AEED,$AEEE,$AEEF,$AEF0,$AEF1,$AEF2,$AEF3,$AEF4,
$AEF5,$AEF6,$AEF7,$AEF8,$AEF9,$AEFA,$AEFB,$AEFC,$AEFD,$AEFE,$AF40,$AF41,$AF42,
$AF43,$AF44,$AF45,$AF46,$AF47,$AF48,$AF49,$AF4A,$AF4B,$AF4C,$AF4D,$AF4E,$AF4F,
$AF50,$AF51,$AF52,$AF53,$AF54,$AF55,$AF56,$AF57,$AF58,$AF59,$AF5A,$AF5B,$AF5C,
$AF5D,$AF5E,$AF5F,$AF60,$AF61,$AF62,$AF63,$AF64,$AF65,$AF66,$AF67,$AF68,$AF69,
$AF6A,$AF6B,$AF6C,$AF6D,$AF6E,$AF6F,$AF70,$AF71,$AF72,$AF73,$AF74,$AF75,$AF76,
$AF77,$AF78,$AF79,$AF7A,$AF7B,$AF7C,$AF7D,$AF7E,$AFA1,$AFA2,$AFA3,$AFA4,$AFA5,
$AFA6,$AFA7,$AFA8,$AFA9,$AFAA,$AFAB,$AFAC,$AFAD,$AFAE,$AFAF,$AFB0,$AFB1,$AFB2,
$AFB3,$AFB4,$AFB5,$AFB6,$AFB7,$AFB8,$AFB9,$AFBA,$AFBB,$AFBC,$AFBD,$AFBE,$AFBF,
$AFC0,$AFC1,$AFC2,$AFC3,$AFC4,$AFC5,$AFC6,$AFC7,$AFC8,$AFC9,$AFCA,$AFCB,$AFCC,
$AFCD,$AFCE,$AFCF,$AFD0,$AFD1,$AFD2,$AFD3,$AFD4,$AFD5,$AFD6,$AFD7,$AFD8,$AFD9,
$AFDA,$AFDB,$AFDC,$AFDD,$AFDE,$AFDF,$AFE0,$AFE1,$AFE2,$AFE3,$AFE4,$AFE5,$AFE6,
$AFE7,$AFE8,$AFE9,$AFEA,$AFEB,$AFEC,$AFED,$AFEE,$AFEF,$AFF0,$AFF1,$AFF2,$AFF3,
$AFF4,$AFF5,$AFF6,$AFF7,$AFF8,$AFF9,$AFFA,$AFFB,$AFFC,$AFFD,$AFFE,$B040,$B041,
$B042,$B043,$B044,$B045,$B046,$B047,$B048,$B049,$B04A,$B04B,$B04C,$B04D,$B04E,
$B04F,$B050,$B051,$B052,$B053,$B054,$B055,$B056,$B057,$B058,$B059,$B05A,$B05B,
$B05C,$B05D,$B05E,$B05F,$B060,$B061,$B062,$B063,$B064,$B065,$B066,$B067,$B068,
$B069,$B06A,$B06B,$B06C,$B06D,$B06E,$B06F,$B070,$B071,$B072,$B073,$B074,$B075,
$B076,$B077,$B078,$B079,$B07A,$B07B,$B07C,$B07D,$B07E,$B0A1,$B0A2,$B0A3,$B0A4,
$B0A5,$B0A6,$B0A7,$B0A8,$B0A9,$B0AA,$B0AB,$B0AC,$B0AD,$B0AE,$B0AF,$B0B0,$B0B1,
$B0B2,$B0B3,$B0B4,$B0B5,$B0B6,$B0B7,$B0B8,$B0B9,$B0BA,$B0BB,$B0BC,$B0BD,$B0BE,
$B0BF,$B0C0,$B0C1,$B0C2,$B0C3,$B0C4,$B0C5,$B0C6,$B0C7,$B0C8,$B0C9,$B0CA,$B0CB,
$B0CC,$B0CD,$B0CE,$B0CF,$B0D0,$B0D1,$B0D2,$B0D3,$B0D4,$B0D5,$B0D6,$B0D7,$B0D8,
$B0D9,$B0DA,$B0DB,$B0DC,$B0DD,$B0DE,$B0DF,$B0E0,$B0E1,$B0E2,$B0E3,$B0E4,$B0E5,
$B0E6,$B0E7,$B0E8,$B0E9,$B0EA,$B0EB,$B0EC,$B0ED,$B0EE,$B0EF,$B0F0,$B0F1,$B0F2,
$B0F3,$B0F4,$B0F5,$B0F6,$B0F7,$B0F8,$B0F9,$B0FA,$B0FB,$B0FC,$B0FD,$B0FE,$B140,
$B141,$B142,$B143,$B144,$B145,$B146,$B147,$B148,$B149,$B14A,$B14B,$B14C,$B14D,
$B14E,$B14F,$B150,$B151,$B152,$B153,$B154,$B155,$B156,$B157,$B158,$B159,$B15A,
$B15B,$B15C,$B15D,$B15E,$B15F,$B160,$B161,$B162,$B163,$B164,$B165,$B166,$B167,
$B168,$B169,$B16A,$B16B,$B16C,$B16D,$B16E,$B16F,$B170,$B171,$B172,$B173,$B174,
$B175,$B176,$B177,$B178,$B179,$B17A,$B17B,$B17C,$B17D,$B17E,$B1A1,$B1A2,$B1A3,
$B1A4,$B1A5,$B1A6,$B1A7,$B1A8,$B1A9,$B1AA,$B1AB,$B1AC,$B1AD,$B1AE,$B1AF,$B1B0,
$B1B1,$B1B2,$B1B3,$B1B4,$B1B5,$B1B6,$B1B7,$B1B8,$B1B9,$B1BA,$B1BB,$B1BC,$B1BD,
$B1BE,$B1BF,$B1C0,$B1C1,$B1C2,$B1C3,$B1C4,$B1C5,$B1C6,$B1C7,$B1C8,$B1C9,$B1CA,
$B1CB,$B1CC,$B1CD,$B1CE,$B1CF,$B1D0,$B1D1,$B1D2,$B1D3,$B1D4,$B1D5,$B1D6,$B1D7,
$B1D8,$B1D9,$B1DA,$B1DB,$B1DC,$B1DD,$B1DE,$B1DF,$B1E0,$B1E1,$B1E2,$B1E3,$B1E4,
$B1E5,$B1E6,$B1E7,$B1E8,$B1E9,$B1EA,$B1EB,$B1EC,$B1ED,$B1EE,$B1EF,$B1F0,$B1F1,
$B1F2,$B1F3,$B1F4,$B1F5,$B1F6,$B1F7,$B1F8,$B1F9,$B1FA,$B1FB,$B1FC,$B1FD,$B1FE,
$B240,$B241,$B242,$B243,$B244,$B245,$B246,$B247,$B248,$B249,$B24A,$B24B,$B24C,
$B24D,$B24E,$B24F,$B250,$B251,$B252,$B253,$B254,$B255,$B256,$B257,$B258,$B259,
$B25A,$B25B,$B25C,$B25D,$B25E,$B25F,$B260,$B261,$B262,$B263,$B264,$B265,$B266,
$B267,$B268,$B269,$B26A,$B26B,$B26C,$B26D,$B26E,$B26F,$B270,$B271,$B272,$B273,
$B274,$B275,$B276,$B277,$B278,$B279,$B27A,$B27B,$B27C,$B27D,$B27E,$B2A1,$B2A2,
$B2A3,$B2A4,$B2A5,$B2A6,$B2A7,$B2A8,$B2A9,$B2AA,$B2AB,$B2AC,$B2AD,$B2AE,$B2AF,
$B2B0,$B2B1,$B2B2,$B2B3,$B2B4,$B2B5,$B2B6,$B2B7,$B2B8,$B2B9,$B2BA,$B2BB,$B2BC,
$B2BD,$B2BE,$B2BF,$B2C0,$B2C1,$B2C2,$B2C3,$B2C4,$B2C5,$B2C6,$B2C7,$B2C8,$B2C9,
$B2CA,$B2CB,$B2CC,$B2CD,$B2CE,$B2CF,$B2D0,$B2D1,$B2D2,$B2D3,$B2D4,$B2D5,$B2D6,
$B2D7,$B2D8,$B2D9,$B2DA,$B2DB,$B2DC,$B2DD,$B2DE,$B2DF,$B2E0,$B2E1,$B2E2,$B2E3,
$B2E4,$B2E5,$B2E6,$B2E7,$B2E8,$B2E9,$B2EA,$B2EB,$B2EC,$B2ED,$B2EE,$B2EF,$B2F0,
$B2F1,$B2F2,$B2F3,$B2F4,$B2F5,$B2F6,$B2F7,$B2F8,$B2F9,$B2FA,$B2FB,$B2FC,$B2FD,
$B2FE,$B340,$B341,$B342,$B343,$B344,$B345,$B346,$B347,$B348,$B349,$B34A,$B34B,
$B34C,$B34D,$B34E,$B34F,$B350,$B351,$B352,$B353,$B354,$B355,$B356,$B357,$B358,
$B359,$B35A,$B35B,$B35C,$B35D,$B35E,$B35F,$B360,$B361,$B362,$B363,$B364,$B365,
$B366,$B367,$B368,$B369,$B36A,$B36B,$B36C,$B36D,$B36E,$B36F,$B370,$B371,$B372,
$B373,$B374,$B375,$B376,$B377,$B378,$B379,$B37A,$B37B,$B37C,$B37D,$B37E,$B3A1,
$B3A2,$B3A3,$B3A4,$B3A5,$B3A6,$B3A7,$B3A8,$B3A9,$B3AA,$B3AB,$B3AC,$B3AD,$B3AE,
$B3AF,$B3B0,$B3B1,$B3B2,$B3B3,$B3B4,$B3B5,$B3B6,$B3B7,$B3B8,$B3B9,$B3BA,$B3BB,
$B3BC,$B3BD,$B3BE,$B3BF,$B3C0,$B3C1,$B3C2,$B3C3,$B3C4,$B3C5,$B3C6,$B3C7,$B3C8,
$B3C9,$B3CA,$B3CB,$B3CC,$B3CD,$B3CE,$B3CF,$B3D0,$B3D1,$B3D2,$B3D3,$B3D4,$B3D5,
$B3D6,$B3D7,$B3D8,$B3D9,$B3DA,$B3DB,$B3DC,$B3DD,$B3DE,$B3DF,$B3E0,$B3E1,$B3E2,
$B3E3,$B3E4,$B3E5,$B3E6,$B3E7,$B3E8,$B3E9,$B3EA,$B3EB,$B3EC,$B3ED,$B3EE,$B3EF,
$B3F0,$B3F1,$B3F2,$B3F3,$B3F4,$B3F5,$B3F6,$B3F7,$B3F8,$B3F9,$B3FA,$B3FB,$B3FC,
$B3FD,$B3FE,$B440,$B441,$B442,$B443,$B444,$B445,$B446,$B447,$B448,$B449,$B44A,
$B44B,$B44C,$B44D,$B44E,$B44F,$B450,$B451,$B452,$B453,$B454,$B455,$B456,$B457,
$B458,$B459,$B45A,$B45B,$B45C,$B45D,$B45E,$B45F,$B460,$B461,$B462,$B463,$B464,
$B465,$B466,$B467,$B468,$B469,$B46A,$B46B,$B46C,$B46D,$B46E,$B46F,$B470,$B471,
$B472,$B473,$B474,$B475,$B476,$B477,$B478,$B479,$B47A,$B47B,$B47C,$B47D,$B47E,
$B4A1,$B4A2,$B4A3,$B4A4,$B4A5,$B4A6,$B4A7,$B4A8,$B4A9,$B4AA,$B4AB,$B4AC,$B4AD,
$B4AE,$B4AF,$B4B0,$B4B1,$B4B2,$B4B3,$B4B4,$B4B5,$B4B6,$B4B7,$B4B8,$B4B9,$B4BA,
$B4BB,$B4BC,$B4BD,$B4BE,$B4BF,$B4C0,$B4C1,$B4C2,$B4C3,$B4C4,$B4C5,$B4C6,$B4C7,
$B4C8,$B4C9,$B4CA,$B4CB,$B4CC,$B4CD,$B4CE,$B4CF,$B4D0,$B4D1,$B4D2,$B4D3,$B4D4,
$B4D5,$B4D6,$B4D7,$B4D8,$B4D9,$B4DA,$B4DB,$B4DC,$B4DD,$B4DE,$B4DF,$B4E0,$B4E1,
$B4E2,$B4E3,$B4E4,$B4E5,$B4E6,$B4E7,$B4E8,$B4E9,$B4EA,$B4EB,$B4EC,$B4ED,$B4EE,
$B4EF,$B4F0,$B4F1,$B4F2,$B4F3,$B4F4,$B4F5,$B4F6,$B4F7,$B4F8,$B4F9,$B4FA,$B4FB,
$B4FC,$B4FD,$B4FE,$B540,$B541,$B542,$B543,$B544,$B545,$B546,$B547,$B548,$B549,
$B54A,$B54B,$B54C,$B54D,$B54E,$B54F,$B550,$B551,$B552,$B553,$B554,$B555,$B556,
$B557,$B558,$B559,$B55A,$B55B,$B55C,$B55D,$B55E,$B55F,$B560,$B561,$B562,$B563,
$B564,$B565,$B566,$B567,$B568,$B569,$B56A,$B56B,$B56C,$B56D,$B56E,$B56F,$B570,
$B571,$B572,$B573,$B574,$B575,$B576,$B577,$B578,$B579,$B57A,$B57B,$B57C,$B57D,
$B57E,$B5A1,$B5A2,$B5A3,$B5A4,$B5A5,$B5A6,$B5A7,$B5A8,$B5A9,$B5AA,$B5AB,$B5AC,
$B5AD,$B5AE,$B5AF,$B5B0,$B5B1,$B5B2,$B5B3,$B5B4,$B5B5,$B5B6,$B5B7,$B5B8,$B5B9,
$B5BA,$B5BB,$B5BC,$B5BD,$B5BE,$B5BF,$B5C0,$B5C1,$B5C2,$B5C3,$B5C4,$B5C5,$B5C6,
$B5C7,$B5C8,$B5C9,$B5CA,$B5CB,$B5CC,$B5CD,$B5CE,$B5CF,$B5D0,$B5D1,$B5D2,$B5D3,
$B5D4,$B5D5,$B5D6,$B5D7,$B5D8,$B5D9,$B5DA,$B5DB,$B5DC,$B5DD,$B5DE,$B5DF,$B5E0,
$B5E1,$B5E2,$B5E3,$B5E4,$B5E5,$B5E6,$B5E7,$B5E8,$B5E9,$B5EA,$B5EB,$B5EC,$B5ED,
$B5EE,$B5EF,$B5F0,$B5F1,$B5F2,$B5F3,$B5F4,$B5F5,$B5F6,$B5F7,$B5F8,$B5F9,$B5FA,
$B5FB,$B5FC,$B5FD,$B5FE,$B640,$B641,$B642,$B643,$B644,$B645,$B646,$B647,$B648,
$B649,$B64A,$B64B,$B64C,$B64D,$B64E,$B64F,$B650,$B651,$B652,$B653,$B654,$B655,
$B656,$B657,$B658,$B659,$B65A,$B65B,$B65C,$B65D,$B65E,$B65F,$B660,$B661,$B662,
$B663,$B664,$B665,$B666,$B667,$B668,$B669,$B66A,$B66B,$B66C,$B66D,$B66E,$B66F,
$B670,$B671,$B672,$B673,$B674,$B675,$B676,$B677,$B678,$B679,$B67A,$B67B,$B67C,
$B67D,$B67E,$B6A1,$B6A2,$B6A3,$B6A4,$B6A5,$B6A6,$B6A7,$B6A8,$B6A9,$B6AA,$B6AB,
$B6AC,$B6AD,$B6AE,$B6AF,$B6B0,$B6B1,$B6B2,$B6B3,$B6B4,$B6B5,$B6B6,$B6B7,$B6B8,
$B6B9,$B6BA,$B6BB,$B6BC,$B6BD,$B6BE,$B6BF,$B6C0,$B6C1,$B6C2,$B6C3,$B6C4,$B6C5,
$B6C6,$B6C7,$B6C8,$B6C9,$B6CA,$B6CB,$B6CC,$B6CD,$B6CE,$B6CF,$B6D0,$B6D1,$B6D2,
$B6D3,$B6D4,$B6D5,$B6D6,$B6D7,$B6D8,$B6D9,$B6DA,$B6DB,$B6DC,$B6DD,$B6DE,$B6DF,
$B6E0,$B6E1,$B6E2,$B6E3,$B6E4,$B6E5,$B6E6,$B6E7,$B6E8,$B6E9,$B6EA,$B6EB,$B6EC,
$B6ED,$B6EE,$B6EF,$B6F0,$B6F1,$B6F2,$B6F3,$B6F4,$B6F5,$B6F6,$B6F7,$B6F8,$B6F9,
$B6FA,$B6FB,$B6FC,$B6FD,$B6FE,$B740,$B741,$B742,$B743,$B744,$B745,$B746,$B747,
$B748,$B749,$B74A,$B74B,$B74C,$B74D,$B74E,$B74F,$B750,$B751,$B752,$B753,$B754,
$B755,$B756,$B757,$B758,$B759,$B75A,$B75B,$B75C,$B75D,$B75E,$B75F,$B760,$B761,
$B762,$B763,$B764,$B765,$B766,$B767,$B768,$B769,$B76A,$B76B,$B76C,$B76D,$B76E,
$B76F,$B770,$B771,$B772,$B773,$B774,$B775,$B776,$B777,$B778,$B779,$B77A,$B77B,
$B77C,$B77D,$B77E,$B7A1,$B7A2,$B7A3,$B7A4,$B7A5,$B7A6,$B7A7,$B7A8,$B7A9,$B7AA,
$B7AB,$B7AC,$B7AD,$B7AE,$B7AF,$B7B0,$B7B1,$B7B2,$B7B3,$B7B4,$B7B5,$B7B6,$B7B7,
$B7B8,$B7B9,$B7BA,$B7BB,$B7BC,$B7BD,$B7BE,$B7BF,$B7C0,$B7C1,$B7C2,$B7C3,$B7C4,
$B7C5,$B7C6,$B7C7,$B7C8,$B7C9,$B7CA,$B7CB,$B7CC,$B7CD,$B7CE,$B7CF,$B7D0,$B7D1,
$B7D2,$B7D3,$B7D4,$B7D5,$B7D6,$B7D7,$B7D8,$B7D9,$B7DA,$B7DB,$B7DC,$B7DD,$B7DE,
$B7DF,$B7E0,$B7E1,$B7E2,$B7E3,$B7E4,$B7E5,$B7E6,$B7E7,$B7E8,$B7E9,$B7EA,$B7EB,
$B7EC,$B7ED,$B7EE,$B7EF,$B7F0,$B7F1,$B7F2,$B7F3,$B7F4,$B7F5,$B7F6,$B7F7,$B7F8,
$B7F9,$B7FA,$B7FB,$B7FC,$B7FD,$B7FE,$B840,$B841,$B842,$B843,$B844,$B845,$B846,
$B847,$B848,$B849,$B84A,$B84B,$B84C,$B84D,$B84E,$B84F,$B850,$B851,$B852,$B853,
$B854,$B855,$B856,$B857,$B858,$B859,$B85A,$B85B,$B85C,$B85D,$B85E,$B85F,$B860,
$B861,$B862,$B863,$B864,$B865,$B866,$B867,$B868,$B869,$B86A,$B86B,$B86C,$B86D,
$B86E,$B86F,$B870,$B871,$B872,$B873,$B874,$B875,$B876,$B877,$B878,$B879,$B87A,
$B87B,$B87C,$B87D,$B87E,$B8A1,$B8A2,$B8A3,$B8A4,$B8A5,$B8A6,$B8A7,$B8A8,$B8A9,
$B8AA,$B8AB,$B8AC,$B8AD,$B8AE,$B8AF,$B8B0,$B8B1,$B8B2,$B8B3,$B8B4,$B8B5,$B8B6,
$B8B7,$B8B8,$B8B9,$B8BA,$B8BB,$B8BC,$B8BD,$B8BE,$B8BF,$B8C0,$B8C1,$B8C2,$B8C3,
$B8C4,$B8C5,$B8C6,$B8C7,$B8C8,$B8C9,$B8CA,$B8CB,$B8CC,$B8CD,$B8CE,$B8CF,$B8D0,
$B8D1,$B8D2,$B8D3,$B8D4,$B8D5,$B8D6,$B8D7,$B8D8,$B8D9,$B8DA,$B8DB,$B8DC,$B8DD,
$B8DE,$B8DF,$B8E0,$B8E1,$B8E2,$B8E3,$B8E4,$B8E5,$B8E6,$B8E7,$B8E8,$B8E9,$B8EA,
$B8EB,$B8EC,$B8ED,$B8EE,$B8EF,$B8F0,$B8F1,$B8F2,$B8F3,$B8F4,$B8F5,$B8F6,$B8F7,
$B8F8,$B8F9,$B8FA,$B8FB,$B8FC,$B8FD,$B8FE,$B940,$B941,$B942,$B943,$B944,$B945,
$B946,$B947,$B948,$B949,$B94A,$B94B,$B94C,$B94D,$B94E,$B94F,$B950,$B951,$B952,
$B953,$B954,$B955,$B956,$B957,$B958,$B959,$B95A,$B95B,$B95C,$B95D,$B95E,$B95F,
$B960,$B961,$B962,$B963,$B964,$B965,$B966,$B967,$B968,$B969,$B96A,$B96B,$B96C,
$B96D,$B96E,$B96F,$B970,$B971,$B972,$B973,$B974,$B975,$B976,$B977,$B978,$B979,
$B97A,$B97B,$B97C,$B97D,$B97E,$B9A1,$B9A2,$B9A3,$B9A4,$B9A5,$B9A6,$B9A7,$B9A8,
$B9A9,$B9AA,$B9AB,$B9AC,$B9AD,$B9AE,$B9AF,$B9B0,$B9B1,$B9B2,$B9B3,$B9B4,$B9B5,
$B9B6,$B9B7,$B9B8,$B9B9,$B9BA,$B9BB,$B9BC,$B9BD,$B9BE,$B9BF,$B9C0,$B9C1,$B9C2,
$B9C3,$B9C4,$B9C5,$B9C6,$B9C7,$B9C8,$B9C9,$B9CA,$B9CB,$B9CC,$B9CD,$B9CE,$B9CF,
$B9D0,$B9D1,$B9D2,$B9D3,$B9D4,$B9D5,$B9D6,$B9D7,$B9D8,$B9D9,$B9DA,$B9DB,$B9DC,
$B9DD,$B9DE,$B9DF,$B9E0,$B9E1,$B9E2,$B9E3,$B9E4,$B9E5,$B9E6,$B9E7,$B9E8,$B9E9,
$B9EA,$B9EB,$B9EC,$B9ED,$B9EE,$B9EF,$B9F0,$B9F1,$B9F2,$B9F3,$B9F4,$B9F5,$B9F6,
$B9F7,$B9F8,$B9F9,$B9FA,$B9FB,$B9FC,$B9FD,$B9FE,$BA40,$BA41,$BA42,$BA43,$BA44,
$BA45,$BA46,$BA47,$BA48,$BA49,$BA4A,$BA4B,$BA4C,$BA4D,$BA4E,$BA4F,$BA50,$BA51,
$BA52,$BA53,$BA54,$BA55,$BA56,$BA57,$BA58,$BA59,$BA5A,$BA5B,$BA5C,$BA5D,$BA5E,
$BA5F,$BA60,$BA61,$BA62,$BA63,$BA64,$BA65,$BA66,$BA67,$BA68,$BA69,$BA6A,$BA6B,
$BA6C,$BA6D,$BA6E,$BA6F,$BA70,$BA71,$BA72,$BA73,$BA74,$BA75,$BA76,$BA77,$BA78,
$BA79,$BA7A,$BA7B,$BA7C,$BA7D,$BA7E,$BAA1,$BAA2,$BAA3,$BAA4,$BAA5,$BAA6,$BAA7,
$BAA8,$BAA9,$BAAA,$BAAB,$BAAC,$BAAD,$BAAE,$BAAF,$BAB0,$BAB1,$BAB2,$BAB3,$BAB4,
$BAB5,$BAB6,$BAB7,$BAB8,$BAB9,$BABA,$BABB,$BABC,$BABD,$BABE,$BABF,$BAC0,$BAC1,
$BAC2,$BAC3,$BAC4,$BAC5,$BAC6,$BAC7,$BAC8,$BAC9,$BACA,$BACB,$BACC,$BACD,$BACE,
$BACF,$BAD0,$BAD1,$BAD2,$BAD3,$BAD4,$BAD5,$BAD6,$BAD7,$BAD8,$BAD9,$BADA,$BADB,
$BADC,$BADD,$BADE,$BADF,$BAE0,$BAE1,$BAE2,$BAE3,$BAE4,$BAE5,$BAE6,$BAE7,$BAE8,
$BAE9,$BAEA,$BAEB,$BAEC,$BAED,$BAEE,$BAEF,$BAF0,$BAF1,$BAF2,$BAF3,$BAF4,$BAF5,
$BAF6,$BAF7,$BAF8,$BAF9,$BAFA,$BAFB,$BAFC,$BAFD,$BAFE,$BB40,$BB41,$BB42,$BB43,
$BB44,$BB45,$BB46,$BB47,$BB48,$BB49,$BB4A,$BB4B,$BB4C,$BB4D,$BB4E,$BB4F,$BB50,
$BB51,$BB52,$BB53,$BB54,$BB55,$BB56,$BB57,$BB58,$BB59,$BB5A,$BB5B,$BB5C,$BB5D,
$BB5E,$BB5F,$BB60,$BB61,$BB62,$BB63,$BB64,$BB65,$BB66,$BB67,$BB68,$BB69,$BB6A,
$BB6B,$BB6C,$BB6D,$BB6E,$BB6F,$BB70,$BB71,$BB72,$BB73,$BB74,$BB75,$BB76,$BB77,
$BB78,$BB79,$BB7A,$BB7B,$BB7C,$BB7D,$BB7E,$BBA1,$BBA2,$BBA3,$BBA4,$BBA5,$BBA6,
$BBA7,$BBA8,$BBA9,$BBAA,$BBAB,$BBAC,$BBAD,$BBAE,$BBAF,$BBB0,$BBB1,$BBB2,$BBB3,
$BBB4,$BBB5,$BBB6,$BBB7,$BBB8,$BBB9,$BBBA,$BBBB,$BBBC,$BBBD,$BBBE,$BBBF,$BBC0,
$BBC1,$BBC2,$BBC3,$BBC4,$BBC5,$BBC6,$BBC7,$BBC8,$BBC9,$BBCA,$BBCB,$BBCC,$BBCD,
$BBCE,$BBCF,$BBD0,$BBD1,$BBD2,$BBD3,$BBD4,$BBD5,$BBD6,$BBD7,$BBD8,$BBD9,$BBDA,
$BBDB,$BBDC,$BBDD,$BBDE,$BBDF,$BBE0,$BBE1,$BBE2,$BBE3,$BBE4,$BBE5,$BBE6,$BBE7,
$BBE8,$BBE9,$BBEA,$BBEB,$BBEC,$BBED,$BBEE,$BBEF,$BBF0,$BBF1,$BBF2,$BBF3,$BBF4,
$BBF5,$BBF6,$BBF7,$BBF8,$BBF9,$BBFA,$BBFB,$BBFC,$BBFD,$BBFE,$BC40,$BC41,$BC42,
$BC43,$BC44,$BC45,$BC46,$BC47,$BC48,$BC49,$BC4A,$BC4B,$BC4C,$BC4D,$BC4E,$BC4F,
$BC50,$BC51,$BC52,$BC53,$BC54,$BC55,$BC56,$BC57,$BC58,$BC59,$BC5A,$BC5B,$BC5C,
$BC5D,$BC5E,$BC5F,$BC60,$BC61,$BC62,$BC63,$BC64,$BC65,$BC66,$BC67,$BC68,$BC69,
$BC6A,$BC6B,$BC6C,$BC6D,$BC6E,$BC6F,$BC70,$BC71,$BC72,$BC73,$BC74,$BC75,$BC76,
$BC77,$BC78,$BC79,$BC7A,$BC7B,$BC7C,$BC7D,$BC7E,$BCA1,$BCA2,$BCA3,$BCA4,$BCA5,
$BCA6,$BCA7,$BCA8,$BCA9,$BCAA,$BCAB,$BCAC,$BCAD,$BCAE,$BCAF,$BCB0,$BCB1,$BCB2,
$BCB3,$BCB4,$BCB5,$BCB6,$BCB7,$BCB8,$BCB9,$BCBA,$BCBB,$BCBC,$BCBD,$BCBE,$BCBF,
$BCC0,$BCC1,$BCC2,$BCC3,$BCC4,$BCC5,$BCC6,$BCC7,$BCC8,$BCC9,$BCCA,$BCCB,$BCCC,
$BCCD,$BCCE,$BCCF,$BCD0,$BCD1,$BCD2,$BCD3,$BCD4,$BCD5,$BCD6,$BCD7,$BCD8,$BCD9,
$BCDA,$BCDB,$BCDC,$BCDD,$BCDE,$BCDF,$BCE0,$BCE1,$BCE2,$BCE3,$BCE4,$BCE5,$BCE6,
$BCE7,$BCE8,$BCE9,$BCEA,$BCEB,$BCEC,$BCED,$BCEE,$BCEF,$BCF0,$BCF1,$BCF2,$BCF3,
$BCF4,$BCF5,$BCF6,$BCF7,$BCF8,$BCF9,$BCFA,$BCFB,$BCFC,$BCFD,$BCFE,$BD40,$BD41,
$BD42,$BD43,$BD44,$BD45,$BD46,$BD47,$BD48,$BD49,$BD4A,$BD4B,$BD4C,$BD4D,$BD4E,
$BD4F,$BD50,$BD51,$BD52,$BD53,$BD54,$BD55,$BD56,$BD57,$BD58,$BD59,$BD5A,$BD5B,
$BD5C,$BD5D,$BD5E,$BD5F,$BD60,$BD61,$BD62,$BD63,$BD64,$BD65,$BD66,$BD67,$BD68,
$BD69,$BD6A,$BD6B,$BD6C,$BD6D,$BD6E,$BD6F,$BD70,$BD71,$BD72,$BD73,$BD74,$BD75,
$BD76,$BD77,$BD78,$BD79,$BD7A,$BD7B,$BD7C,$BD7D,$BD7E,$BDA1,$BDA2,$BDA3,$BDA4,
$BDA5,$BDA6,$BDA7,$BDA8,$BDA9,$BDAA,$BDAB,$BDAC,$BDAD,$BDAE,$BDAF,$BDB0,$BDB1,
$BDB2,$BDB3,$BDB4,$BDB5,$BDB6,$BDB7,$BDB8,$BDB9,$BDBA,$BDBB,$BDBC,$BDBD,$BDBE,
$BDBF,$BDC0,$BDC1,$BDC2,$BDC3,$BDC4,$BDC5,$BDC6,$BDC7,$BDC8,$BDC9,$BDCA,$BDCB,
$BDCC,$BDCD,$BDCE,$BDCF,$BDD0,$BDD1,$BDD2,$BDD3,$BDD4,$BDD5,$BDD6,$BDD7,$BDD8,
$BDD9,$BDDA,$BDDB,$BDDC,$BDDD,$BDDE,$BDDF,$BDE0,$BDE1,$BDE2,$BDE3,$BDE4,$BDE5,
$BDE6,$BDE7,$BDE8,$BDE9,$BDEA,$BDEB,$BDEC,$BDED,$BDEE,$BDEF,$BDF0,$BDF1,$BDF2,
$BDF3,$BDF4,$BDF5,$BDF6,$BDF7,$BDF8,$BDF9,$BDFA,$BDFB,$BDFC,$BDFD,$BDFE,$BE40,
$BE41,$BE42,$BE43,$BE44,$BE45,$BE46,$BE47,$BE48,$BE49,$BE4A,$BE4B,$BE4C,$BE4D,
$BE4E,$BE4F,$BE50,$BE51,$BE52,$BE53,$BE54,$BE55,$BE56,$BE57,$BE58,$BE59,$BE5A,
$BE5B,$BE5C,$BE5D,$BE5E,$BE5F,$BE60,$BE61,$BE62,$BE63,$BE64,$BE65,$BE66,$BE67,
$BE68,$BE69,$BE6A,$BE6B,$BE6C,$BE6D,$BE6E,$BE6F,$BE70,$BE71,$BE72,$BE73,$BE74,
$BE75,$BE76,$BE77,$BE78,$BE79,$BE7A,$BE7B,$BE7C,$BE7D,$BE7E,$BEA1,$BEA2,$BEA3,
$BEA4,$BEA5,$BEA6,$BEA7,$BEA8,$BEA9,$BEAA,$BEAB,$BEAC,$BEAD,$BEAE,$BEAF,$BEB0,
$BEB1,$BEB2,$BEB3,$BEB4,$BEB5,$BEB6,$BEB7,$BEB8,$BEB9,$BEBA,$BEBB,$BEBC,$BEBD,
$BEBE,$BEBF,$BEC0,$BEC1,$BEC2,$BEC3,$BEC4,$BEC5,$BEC6,$BEC7,$BEC8,$BEC9,$BECA,
$BECB,$BECC,$BECD,$BECE,$BECF,$BED0,$BED1,$BED2,$BED3,$BED4,$BED5,$BED6,$BED7,
$BED8,$BED9,$BEDA,$BEDB,$BEDC,$BEDD,$BEDE,$BEDF,$BEE0,$BEE1,$BEE2,$BEE3,$BEE4,
$BEE5,$BEE6,$BEE7,$BEE8,$BEE9,$BEEA,$BEEB,$BEEC,$BEED,$BEEE,$BEEF,$BEF0,$BEF1,
$BEF2,$BEF3,$BEF4,$BEF5,$BEF6,$BEF7,$BEF8,$BEF9,$BEFA,$BEFB,$BEFC,$BEFD,$BEFE,
$BF40,$BF41,$BF42,$BF43,$BF44,$BF45,$BF46,$BF47,$BF48,$BF49,$BF4A,$BF4B,$BF4C,
$BF4D,$BF4E,$BF4F,$BF50,$BF51,$BF52,$BF53,$BF54,$BF55,$BF56,$BF57,$BF58,$BF59,
$BF5A,$BF5B,$BF5C,$BF5D,$BF5E,$BF5F,$BF60,$BF61,$BF62,$BF63,$BF64,$BF65,$BF66,
$BF67,$BF68,$BF69,$BF6A,$BF6B,$BF6C,$BF6D,$BF6E,$BF6F,$BF70,$BF71,$BF72,$BF73,
$BF74,$BF75,$BF76,$BF77,$BF78,$BF79,$BF7A,$BF7B,$BF7C,$BF7D,$BF7E,$BFA1,$BFA2,
$BFA3,$BFA4,$BFA5,$BFA6,$BFA7,$BFA8,$BFA9,$BFAA,$BFAB,$BFAC,$BFAD,$BFAE,$BFAF,
$BFB0,$BFB1,$BFB2,$BFB3,$BFB4,$BFB5,$BFB6,$BFB7,$BFB8,$BFB9,$BFBA,$BFBB,$BFBC,
$BFBD,$BFBE,$BFBF,$BFC0,$BFC1,$BFC2,$BFC3,$BFC4,$BFC5,$BFC6,$BFC7,$BFC8,$BFC9,
$BFCA,$BFCB,$BFCC,$BFCD,$BFCE,$BFCF,$BFD0,$BFD1,$BFD2,$BFD3,$BFD4,$BFD5,$BFD6,
$BFD7,$BFD8,$BFD9,$BFDA,$BFDB,$BFDC,$BFDD,$BFDE,$BFDF,$BFE0,$BFE1,$BFE2,$BFE3,
$BFE4,$BFE5,$BFE6,$BFE7,$BFE8,$BFE9,$BFEA,$BFEB,$BFEC,$BFED,$BFEE,$BFEF,$BFF0,
$BFF1,$BFF2,$BFF3,$BFF4,$BFF5,$BFF6,$BFF7,$BFF8,$BFF9,$BFFA,$BFFB,$BFFC,$BFFD,
$BFFE,$C040,$C041,$C042,$C043,$C044,$C045,$C046,$C047,$C048,$C049,$C04A,$C04B,
$C04C,$C04D,$C04E,$C04F,$C050,$C051,$C052,$C053,$C054,$C055,$C056,$C057,$C058,
$C059,$C05A,$C05B,$C05C,$C05D,$C05E,$C05F,$C060,$C061,$C062,$C063,$C064,$C065,
$C066,$C067,$C068,$C069,$C06A,$C06B,$C06C,$C06D,$C06E,$C06F,$C070,$C071,$C072,
$C073,$C074,$C075,$C076,$C077,$C078,$C079,$C07A,$C07B,$C07C,$C07D,$C07E,$C0A1,
$C0A2,$C0A3,$C0A4,$C0A5,$C0A6,$C0A7,$C0A8,$C0A9,$C0AA,$C0AB,$C0AC,$C0AD,$C0AE,
$C0AF,$C0B0,$C0B1,$C0B2,$C0B3,$C0B4,$C0B5,$C0B6,$C0B7,$C0B8,$C0B9,$C0BA,$C0BB,
$C0BC,$C0BD,$C0BE,$C0BF,$C0C0,$C0C1,$C0C2,$C0C3,$C0C4,$C0C5,$C0C6,$C0C7,$C0C8,
$C0C9,$C0CA,$C0CB,$C0CC,$C0CD,$C0CE,$C0CF,$C0D0,$C0D1,$C0D2,$C0D3,$C0D4,$C0D5,
$C0D6,$C0D7,$C0D8,$C0D9,$C0DA,$C0DB,$C0DC,$C0DD,$C0DE,$C0DF,$C0E0,$C0E1,$C0E2,
$C0E3,$C0E4,$C0E5,$C0E6,$C0E7,$C0E8,$C0E9,$C0EA,$C0EB,$C0EC,$C0ED,$C0EE,$C0EF,
$C0F0,$C0F1,$C0F2,$C0F3,$C0F4,$C0F5,$C0F6,$C0F7,$C0F8,$C0F9,$C0FA,$C0FB,$C0FC,
$C0FD,$C0FE,$C140,$C141,$C142,$C143,$C144,$C145,$C146,$C147,$C148,$C149,$C14A,
$C14B,$C14C,$C14D,$C14E,$C14F,$C150,$C151,$C152,$C153,$C154,$C155,$C156,$C157,
$C158,$C159,$C15A,$C15B,$C15C,$C15D,$C15E,$C15F,$C160,$C161,$C162,$C163,$C164,
$C165,$C166,$C167,$C168,$C169,$C16A,$C16B,$C16C,$C16D,$C16E,$C16F,$C170,$C171,
$C172,$C173,$C174,$C175,$C176,$C177,$C178,$C179,$C17A,$C17B,$C17C,$C17D,$C17E,
$C1A1,$C1A2,$C1A3,$C1A4,$C1A5,$C1A6,$C1A7,$C1A8,$C1A9,$C1AA,$C1AB,$C1AC,$C1AD,
$C1AE,$C1AF,$C1B0,$C1B1,$C1B2,$C1B3,$C1B4,$C1B5,$C1B6,$C1B7,$C1B8,$C1B9,$C1BA,
$C1BB,$C1BC,$C1BD,$C1BE,$C1BF,$C1C0,$C1C1,$C1C2,$C1C3,$C1C4,$C1C5,$C1C6,$C1C7,
$C1C8,$C1C9,$C1CA,$C1CB,$C1CC,$C1CD,$C1CE,$C1CF,$C1D0,$C1D1,$C1D2,$C1D3,$C1D4,
$C1D5,$C1D6,$C1D7,$C1D8,$C1D9,$C1DA,$C1DB,$C1DC,$C1DD,$C1DE,$C1DF,$C1E0,$C1E1,
$C1E2,$C1E3,$C1E4,$C1E5,$C1E6,$C1E7,$C1E8,$C1E9,$C1EA,$C1EB,$C1EC,$C1ED,$C1EE,
$C1EF,$C1F0,$C1F1,$C1F2,$C1F3,$C1F4,$C1F5,$C1F6,$C1F7,$C1F8,$C1F9,$C1FA,$C1FB,
$C1FC,$C1FD,$C1FE,$C240,$C241,$C242,$C243,$C244,$C245,$C246,$C247,$C248,$C249,
$C24A,$C24B,$C24C,$C24D,$C24E,$C24F,$C250,$C251,$C252,$C253,$C254,$C255,$C256,
$C257,$C258,$C259,$C25A,$C25B,$C25C,$C25D,$C25E,$C25F,$C260,$C261,$C262,$C263,
$C264,$C265,$C266,$C267,$C268,$C269,$C26A,$C26B,$C26C,$C26D,$C26E,$C26F,$C270,
$C271,$C272,$C273,$C274,$C275,$C276,$C277,$C278,$C279,$C27A,$C27B,$C27C,$C27D,
$C27E,$C2A1,$C2A2,$C2A3,$C2A4,$C2A5,$C2A6,$C2A7,$C2A8,$C2A9,$C2AA,$C2AB,$C2AC,
$C2AD,$C2AE,$C2AF,$C2B0,$C2B1,$C2B2,$C2B3,$C2B4,$C2B5,$C2B6,$C2B7,$C2B8,$C2B9,
$C2BA,$C2BB,$C2BC,$C2BD,$C2BE,$C2BF,$C2C0,$C2C1,$C2C2,$C2C3,$C2C4,$C2C5,$C2C6,
$C2C7,$C2C8,$C2C9,$C2CA,$C2CB,$C2CC,$C2CD,$C2CE,$C2CF,$C2D0,$C2D1,$C2D2,$C2D3,
$C2D4,$C2D5,$C2D6,$C2D7,$C2D8,$C2D9,$C2DA,$C2DB,$C2DC,$C2DD,$C2DE,$C2DF,$C2E0,
$C2E1,$C2E2,$C2E3,$C2E4,$C2E5,$C2E6,$C2E7,$C2E8,$C2E9,$C2EA,$C2EB,$C2EC,$C2ED,
$C2EE,$C2EF,$C2F0,$C2F1,$C2F2,$C2F3,$C2F4,$C2F5,$C2F6,$C2F7,$C2F8,$C2F9,$C2FA,
$C2FB,$C2FC,$C2FD,$C2FE,$C340,$C341,$C342,$C343,$C344,$C345,$C346,$C347,$C348,
$C349,$C34A,$C34B,$C34C,$C34D,$C34E,$C34F,$C350,$C351,$C352,$C353,$C354,$C355,
$C356,$C357,$C358,$C359,$C35A,$C35B,$C35C,$C35D,$C35E,$C35F,$C360,$C361,$C362,
$C363,$C364,$C365,$C366,$C367,$C368,$C369,$C36A,$C36B,$C36C,$C36D,$C36E,$C36F,
$C370,$C371,$C372,$C373,$C374,$C375,$C376,$C377,$C378,$C379,$C37A,$C37B,$C37C,
$C37D,$C37E,$C3A1,$C3A2,$C3A3,$C3A4,$C3A5,$C3A6,$C3A7,$C3A8,$C3A9,$C3AA,$C3AB,
$C3AC,$C3AD,$C3AE,$C3AF,$C3B0,$C3B1,$C3B2,$C3B3,$C3B4,$C3B5,$C3B6,$C3B7,$C3B8,
$C3B9,$C3BA,$C3BB,$C3BC,$C3BD,$C3BE,$C3BF,$C3C0,$C3C1,$C3C2,$C3C3,$C3C4,$C3C5,
$C3C6,$C3C7,$C3C8,$C3C9,$C3CA,$C3CB,$C3CC,$C3CD,$C3CE,$C3CF,$C3D0,$C3D1,$C3D2,
$C3D3,$C3D4,$C3D5,$C3D6,$C3D7,$C3D8,$C3D9,$C3DA,$C3DB,$C3DC,$C3DD,$C3DE,$C3DF,
$C3E0,$C3E1,$C3E2,$C3E3,$C3E4,$C3E5,$C3E6,$C3E7,$C3E8,$C3E9,$C3EA,$C3EB,$C3EC,
$C3ED,$C3EE,$C3EF,$C3F0,$C3F1,$C3F2,$C3F3,$C3F4,$C3F5,$C3F6,$C3F7,$C3F8,$C3F9,
$C3FA,$C3FB,$C3FC,$C3FD,$C3FE,$C440,$C441,$C442,$C443,$C444,$C445,$C446,$C447,
$C448,$C449,$C44A,$C44B,$C44C,$C44D,$C44E,$C44F,$C450,$C451,$C452,$C453,$C454,
$C455,$C456,$C457,$C458,$C459,$C45A,$C45B,$C45C,$C45D,$C45E,$C45F,$C460,$C461,
$C462,$C463,$C464,$C465,$C466,$C467,$C468,$C469,$C46A,$C46B,$C46C,$C46D,$C46E,
$C46F,$C470,$C471,$C472,$C473,$C474,$C475,$C476,$C477,$C478,$C479,$C47A,$C47B,
$C47C,$C47D,$C47E,$C4A1,$C4A2,$C4A3,$C4A4,$C4A5,$C4A6,$C4A7,$C4A8,$C4A9,$C4AA,
$C4AB,$C4AC,$C4AD,$C4AE,$C4AF,$C4B0,$C4B1,$C4B2,$C4B3,$C4B4,$C4B5,$C4B6,$C4B7,
$C4B8,$C4B9,$C4BA,$C4BB,$C4BC,$C4BD,$C4BE,$C4BF,$C4C0,$C4C1,$C4C2,$C4C3,$C4C4,
$C4C5,$C4C6,$C4C7,$C4C8,$C4C9,$C4CA,$C4CB,$C4CC,$C4CD,$C4CE,$C4CF,$C4D0,$C4D1,
$C4D2,$C4D3,$C4D4,$C4D5,$C4D6,$C4D7,$C4D8,$C4D9,$C4DA,$C4DB,$C4DC,$C4DD,$C4DE,
$C4DF,$C4E0,$C4E1,$C4E2,$C4E3,$C4E4,$C4E5,$C4E6,$C4E7,$C4E8,$C4E9,$C4EA,$C4EB,
$C4EC,$C4ED,$C4EE,$C4EF,$C4F0,$C4F1,$C4F2,$C4F3,$C4F4,$C4F5,$C4F6,$C4F7,$C4F8,
$C4F9,$C4FA,$C4FB,$C4FC,$C4FD,$C4FE,$C540,$C541,$C542,$C543,$C544,$C545,$C546,
$C547,$C548,$C549,$C54A,$C54B,$C54C,$C54D,$C54E,$C54F,$C550,$C551,$C552,$C553,
$C554,$C555,$C556,$C557,$C558,$C559,$C55A,$C55B,$C55C,$C55D,$C55E,$C55F,$C560,
$C561,$C562,$C563,$C564,$C565,$C566,$C567,$C568,$C569,$C56A,$C56B,$C56C,$C56D,
$C56E,$C56F,$C570,$C571,$C572,$C573,$C574,$C575,$C576,$C577,$C578,$C579,$C57A,
$C57B,$C57C,$C57D,$C57E,$C5A1,$C5A2,$C5A3,$C5A4,$C5A5,$C5A6,$C5A7,$C5A8,$C5A9,
$C5AA,$C5AB,$C5AC,$C5AD,$C5AE,$C5AF,$C5B0,$C5B1,$C5B2,$C5B3,$C5B4,$C5B5,$C5B6,
$C5B7,$C5B8,$C5B9,$C5BA,$C5BB,$C5BC,$C5BD,$C5BE,$C5BF,$C5C0,$C5C1,$C5C2,$C5C3,
$C5C4,$C5C5,$C5C6,$C5C7,$C5C8,$C5C9,$C5CA,$C5CB,$C5CC,$C5CD,$C5CE,$C5CF,$C5D0,
$C5D1,$C5D2,$C5D3,$C5D4,$C5D5,$C5D6,$C5D7,$C5D8,$C5D9,$C5DA,$C5DB,$C5DC,$C5DD,
$C5DE,$C5DF,$C5E0,$C5E1,$C5E2,$C5E3,$C5E4,$C5E5,$C5E6,$C5E7,$C5E8,$C5E9,$C5EA,
$C5EB,$C5EC,$C5ED,$C5EE,$C5EF,$C5F0,$C5F1,$C5F2,$C5F3,$C5F4,$C5F5,$C5F6,$C5F7,
$C5F8,$C5F9,$C5FA,$C5FB,$C5FC,$C5FD,$C5FE,$C640,$C641,$C642,$C643,$C644,$C645,
$C646,$C647,$C648,$C649,$C64A,$C64B,$C64C,$C64D,$C64E,$C64F,$C650,$C651,$C652,
$C653,$C654,$C655,$C656,$C657,$C658,$C659,$C65A,$C65B,$C65C,$C65D,$C65E,$C65F,
$C660,$C661,$C662,$C663,$C664,$C665,$C666,$C667,$C668,$C669,$C66A,$C66B,$C66C,
$C66D,$C66E,$C66F,$C670,$C671,$C672,$C673,$C674,$C675,$C676,$C677,$C678,$C679,
$C67A,$C67B,$C67C,$C67D,$C67E,$C940,$C941,$C942,$C943,$C944,$C945,$C946,$C947,
$C948,$C949,$C94A,$C94B,$C94C,$C94D,$C94E,$C94F,$C950,$C951,$C952,$C953,$C954,
$C955,$C956,$C957,$C958,$C959,$C95A,$C95B,$C95C,$C95D,$C95E,$C95F,$C960,$C961,
$C962,$C963,$C964,$C965,$C966,$C967,$C968,$C969,$C96A,$C96B,$C96C,$C96D,$C96E,
$C96F,$C970,$C971,$C972,$C973,$C974,$C975,$C976,$C977,$C978,$C979,$C97A,$C97B,
$C97C,$C97D,$C97E,$C9A1,$C9A2,$C9A3,$C9A4,$C9A5,$C9A6,$C9A7,$C9A8,$C9A9,$C9AA,
$C9AB,$C9AC,$C9AD,$C9AE,$C9AF,$C9B0,$C9B1,$C9B2,$C9B3,$C9B4,$C9B5,$C9B6,$C9B7,
$C9B8,$C9B9,$C9BA,$C9BB,$C9BC,$C9BD,$C9BE,$C9BF,$C9C0,$C9C1,$C9C2,$C9C3,$C9C4,
$C9C5,$C9C6,$C9C7,$C9C8,$C9C9,$C9CA,$C9CB,$C9CC,$C9CD,$C9CE,$C9CF,$C9D0,$C9D1,
$C9D2,$C9D3,$C9D4,$C9D5,$C9D6,$C9D7,$C9D8,$C9D9,$C9DA,$C9DB,$C9DC,$C9DD,$C9DE,
$C9DF,$C9E0,$C9E1,$C9E2,$C9E3,$C9E4,$C9E5,$C9E6,$C9E7,$C9E8,$C9E9,$C9EA,$C9EB,
$C9EC,$C9ED,$C9EE,$C9EF,$C9F0,$C9F1,$C9F2,$C9F3,$C9F4,$C9F5,$C9F6,$C9F7,$C9F8,
$C9F9,$C9FA,$C9FB,$C9FC,$C9FD,$C9FE,$CA40,$CA41,$CA42,$CA43,$CA44,$CA45,$CA46,
$CA47,$CA48,$CA49,$CA4A,$CA4B,$CA4C,$CA4D,$CA4E,$CA4F,$CA50,$CA51,$CA52,$CA53,
$CA54,$CA55,$CA56,$CA57,$CA58,$CA59,$CA5A,$CA5B,$CA5C,$CA5D,$CA5E,$CA5F,$CA60,
$CA61,$CA62,$CA63,$CA64,$CA65,$CA66,$CA67,$CA68,$CA69,$CA6A,$CA6B,$CA6C,$CA6D,
$CA6E,$CA6F,$CA70,$CA71,$CA72,$CA73,$CA74,$CA75,$CA76,$CA77,$CA78,$CA79,$CA7A,
$CA7B,$CA7C,$CA7D,$CA7E,$CAA1,$CAA2,$CAA3,$CAA4,$CAA5,$CAA6,$CAA7,$CAA8,$CAA9,
$CAAA,$CAAB,$CAAC,$CAAD,$CAAE,$CAAF,$CAB0,$CAB1,$CAB2,$CAB3,$CAB4,$CAB5,$CAB6,
$CAB7,$CAB8,$CAB9,$CABA,$CABB,$CABC,$CABD,$CABE,$CABF,$CAC0,$CAC1,$CAC2,$CAC3,
$CAC4,$CAC5,$CAC6,$CAC7,$CAC8,$CAC9,$CACA,$CACB,$CACC,$CACD,$CACE,$CACF,$CAD0,
$CAD1,$CAD2,$CAD3,$CAD4,$CAD5,$CAD6,$CAD7,$CAD8,$CAD9,$CADA,$CADB,$CADC,$CADD,
$CADE,$CADF,$CAE0,$CAE1,$CAE2,$CAE3,$CAE4,$CAE5,$CAE6,$CAE7,$CAE8,$CAE9,$CAEA,
$CAEB,$CAEC,$CAED,$CAEE,$CAEF,$CAF0,$CAF1,$CAF2,$CAF3,$CAF4,$CAF5,$CAF6,$CAF7,
$CAF8,$CAF9,$CAFA,$CAFB,$CAFC,$CAFD,$CAFE,$CB40,$CB41,$CB42,$CB43,$CB44,$CB45,
$CB46,$CB47,$CB48,$CB49,$CB4A,$CB4B,$CB4C,$CB4D,$CB4E,$CB4F,$CB50,$CB51,$CB52,
$CB53,$CB54,$CB55,$CB56,$CB57,$CB58,$CB59,$CB5A,$CB5B,$CB5C,$CB5D,$CB5E,$CB5F,
$CB60,$CB61,$CB62,$CB63,$CB64,$CB65,$CB66,$CB67,$CB68,$CB69,$CB6A,$CB6B,$CB6C,
$CB6D,$CB6E,$CB6F,$CB70,$CB71,$CB72,$CB73,$CB74,$CB75,$CB76,$CB77,$CB78,$CB79,
$CB7A,$CB7B,$CB7C,$CB7D,$CB7E,$CBA1,$CBA2,$CBA3,$CBA4,$CBA5,$CBA6,$CBA7,$CBA8,
$CBA9,$CBAA,$CBAB,$CBAC,$CBAD,$CBAE,$CBAF,$CBB0,$CBB1,$CBB2,$CBB3,$CBB4,$CBB5,
$CBB6,$CBB7,$CBB8,$CBB9,$CBBA,$CBBB,$CBBC,$CBBD,$CBBE,$CBBF,$CBC0,$CBC1,$CBC2,
$CBC3,$CBC4,$CBC5,$CBC6,$CBC7,$CBC8,$CBC9,$CBCA,$CBCB,$CBCC,$CBCD,$CBCE,$CBCF,
$CBD0,$CBD1,$CBD2,$CBD3,$CBD4,$CBD5,$CBD6,$CBD7,$CBD8,$CBD9,$CBDA,$CBDB,$CBDC,
$CBDD,$CBDE,$CBDF,$CBE0,$CBE1,$CBE2,$CBE3,$CBE4,$CBE5,$CBE6,$CBE7,$CBE8,$CBE9,
$CBEA,$CBEB,$CBEC,$CBED,$CBEE,$CBEF,$CBF0,$CBF1,$CBF2,$CBF3,$CBF4,$CBF5,$CBF6,
$CBF7,$CBF8,$CBF9,$CBFA,$CBFB,$CBFC,$CBFD,$CBFE,$CC40,$CC41,$CC42,$CC43,$CC44,
$CC45,$CC46,$CC47,$CC48,$CC49,$CC4A,$CC4B,$CC4C,$CC4D,$CC4E,$CC4F,$CC50,$CC51,
$CC52,$CC53,$CC54,$CC55,$CC56,$CC57,$CC58,$CC59,$CC5A,$CC5B,$CC5C,$CC5D,$CC5E,
$CC5F,$CC60,$CC61,$CC62,$CC63,$CC64,$CC65,$CC66,$CC67,$CC68,$CC69,$CC6A,$CC6B,
$CC6C,$CC6D,$CC6E,$CC6F,$CC70,$CC71,$CC72,$CC73,$CC74,$CC75,$CC76,$CC77,$CC78,
$CC79,$CC7A,$CC7B,$CC7C,$CC7D,$CC7E,$CCA1,$CCA2,$CCA3,$CCA4,$CCA5,$CCA6,$CCA7,
$CCA8,$CCA9,$CCAA,$CCAB,$CCAC,$CCAD,$CCAE,$CCAF,$CCB0,$CCB1,$CCB2,$CCB3,$CCB4,
$CCB5,$CCB6,$CCB7,$CCB8,$CCB9,$CCBA,$CCBB,$CCBC,$CCBD,$CCBE,$CCBF,$CCC0,$CCC1,
$CCC2,$CCC3,$CCC4,$CCC5,$CCC6,$CCC7,$CCC8,$CCC9,$CCCA,$CCCB,$CCCC,$CCCD,$CCCE,
$CCCF,$CCD0,$CCD1,$CCD2,$CCD3,$CCD4,$CCD5,$CCD6,$CCD7,$CCD8,$CCD9,$CCDA,$CCDB,
$CCDC,$CCDD,$CCDE,$CCDF,$CCE0,$CCE1,$CCE2,$CCE3,$CCE4,$CCE5,$CCE6,$CCE7,$CCE8,
$CCE9,$CCEA,$CCEB,$CCEC,$CCED,$CCEE,$CCEF,$CCF0,$CCF1,$CCF2,$CCF3,$CCF4,$CCF5,
$CCF6,$CCF7,$CCF8,$CCF9,$CCFA,$CCFB,$CCFC,$CCFD,$CCFE,$CD40,$CD41,$CD42,$CD43,
$CD44,$CD45,$CD46,$CD47,$CD48,$CD49,$CD4A,$CD4B,$CD4C,$CD4D,$CD4E,$CD4F,$CD50,
$CD51,$CD52,$CD53,$CD54,$CD55,$CD56,$CD57,$CD58,$CD59,$CD5A,$CD5B,$CD5C,$CD5D,
$CD5E,$CD5F,$CD60,$CD61,$CD62,$CD63,$CD64,$CD65,$CD66,$CD67,$CD68,$CD69,$CD6A,
$CD6B,$CD6C,$CD6D,$CD6E,$CD6F,$CD70,$CD71,$CD72,$CD73,$CD74,$CD75,$CD76,$CD77,
$CD78,$CD79,$CD7A,$CD7B,$CD7C,$CD7D,$CD7E,$CDA1,$CDA2,$CDA3,$CDA4,$CDA5,$CDA6,
$CDA7,$CDA8,$CDA9,$CDAA,$CDAB,$CDAC,$CDAD,$CDAE,$CDAF,$CDB0,$CDB1,$CDB2,$CDB3,
$CDB4,$CDB5,$CDB6,$CDB7,$CDB8,$CDB9,$CDBA,$CDBB,$CDBC,$CDBD,$CDBE,$CDBF,$CDC0,
$CDC1,$CDC2,$CDC3,$CDC4,$CDC5,$CDC6,$CDC7,$CDC8,$CDC9,$CDCA,$CDCB,$CDCC,$CDCD,
$CDCE,$CDCF,$CDD0,$CDD1,$CDD2,$CDD3,$CDD4,$CDD5,$CDD6,$CDD7,$CDD8,$CDD9,$CDDA,
$CDDB,$CDDC,$CDDD,$CDDE,$CDDF,$CDE0,$CDE1,$CDE2,$CDE3,$CDE4,$CDE5,$CDE6,$CDE7,
$CDE8,$CDE9,$CDEA,$CDEB,$CDEC,$CDED,$CDEE,$CDEF,$CDF0,$CDF1,$CDF2,$CDF3,$CDF4,
$CDF5,$CDF6,$CDF7,$CDF8,$CDF9,$CDFA,$CDFB,$CDFC,$CDFD,$CDFE,$CE40,$CE41,$CE42,
$CE43,$CE44,$CE45,$CE46,$CE47,$CE48,$CE49,$CE4A,$CE4B,$CE4C,$CE4D,$CE4E,$CE4F,
$CE50,$CE51,$CE52,$CE53,$CE54,$CE55,$CE56,$CE57,$CE58,$CE59,$CE5A,$CE5B,$CE5C,
$CE5D,$CE5E,$CE5F,$CE60,$CE61,$CE62,$CE63,$CE64,$CE65,$CE66,$CE67,$CE68,$CE69,
$CE6A,$CE6B,$CE6C,$CE6D,$CE6E,$CE6F,$CE70,$CE71,$CE72,$CE73,$CE74,$CE75,$CE76,
$CE77,$CE78,$CE79,$CE7A,$CE7B,$CE7C,$CE7D,$CE7E,$CEA1,$CEA2,$CEA3,$CEA4,$CEA5,
$CEA6,$CEA7,$CEA8,$CEA9,$CEAA,$CEAB,$CEAC,$CEAD,$CEAE,$CEAF,$CEB0,$CEB1,$CEB2,
$CEB3,$CEB4,$CEB5,$CEB6,$CEB7,$CEB8,$CEB9,$CEBA,$CEBB,$CEBC,$CEBD,$CEBE,$CEBF,
$CEC0,$CEC1,$CEC2,$CEC3,$CEC4,$CEC5,$CEC6,$CEC7,$CEC8,$CEC9,$CECA,$CECB,$CECC,
$CECD,$CECE,$CECF,$CED0,$CED1,$CED2,$CED3,$CED4,$CED5,$CED6,$CED7,$CED8,$CED9,
$CEDA,$CEDB,$CEDC,$CEDD,$CEDE,$CEDF,$CEE0,$CEE1,$CEE2,$CEE3,$CEE4,$CEE5,$CEE6,
$CEE7,$CEE8,$CEE9,$CEEA,$CEEB,$CEEC,$CEED,$CEEE,$CEEF,$CEF0,$CEF1,$CEF2,$CEF3,
$CEF4,$CEF5,$CEF6,$CEF7,$CEF8,$CEF9,$CEFA,$CEFB,$CEFC,$CEFD,$CEFE,$CF40,$CF41,
$CF42,$CF43,$CF44,$CF45,$CF46,$CF47,$CF48,$CF49,$CF4A,$CF4B,$CF4C,$CF4D,$CF4E,
$CF4F,$CF50,$CF51,$CF52,$CF53,$CF54,$CF55,$CF56,$CF57,$CF58,$CF59,$CF5A,$CF5B,
$CF5C,$CF5D,$CF5E,$CF5F,$CF60,$CF61,$CF62,$CF63,$CF64,$CF65,$CF66,$CF67,$CF68,
$CF69,$CF6A,$CF6B,$CF6C,$CF6D,$CF6E,$CF6F,$CF70,$CF71,$CF72,$CF73,$CF74,$CF75,
$CF76,$CF77,$CF78,$CF79,$CF7A,$CF7B,$CF7C,$CF7D,$CF7E,$CFA1,$CFA2,$CFA3,$CFA4,
$CFA5,$CFA6,$CFA7,$CFA8,$CFA9,$CFAA,$CFAB,$CFAC,$CFAD,$CFAE,$CFAF,$CFB0,$CFB1,
$CFB2,$CFB3,$CFB4,$CFB5,$CFB6,$CFB7,$CFB8,$CFB9,$CFBA,$CFBB,$CFBC,$CFBD,$CFBE,
$CFBF,$CFC0,$CFC1,$CFC2,$CFC3,$CFC4,$CFC5,$CFC6,$CFC7,$CFC8,$CFC9,$CFCA,$CFCB,
$CFCC,$CFCD,$CFCE,$CFCF,$CFD0,$CFD1,$CFD2,$CFD3,$CFD4,$CFD5,$CFD6,$CFD7,$CFD8,
$CFD9,$CFDA,$CFDB,$CFDC,$CFDD,$CFDE,$CFDF,$CFE0,$CFE1,$CFE2,$CFE3,$CFE4,$CFE5,
$CFE6,$CFE7,$CFE8,$CFE9,$CFEA,$CFEB,$CFEC,$CFED,$CFEE,$CFEF,$CFF0,$CFF1,$CFF2,
$CFF3,$CFF4,$CFF5,$CFF6,$CFF7,$CFF8,$CFF9,$CFFA,$CFFB,$CFFC,$CFFD,$CFFE,$D040,
$D041,$D042,$D043,$D044,$D045,$D046,$D047,$D048,$D049,$D04A,$D04B,$D04C,$D04D,
$D04E,$D04F,$D050,$D051,$D052,$D053,$D054,$D055,$D056,$D057,$D058,$D059,$D05A,
$D05B,$D05C,$D05D,$D05E,$D05F,$D060,$D061,$D062,$D063,$D064,$D065,$D066,$D067,
$D068,$D069,$D06A,$D06B,$D06C,$D06D,$D06E,$D06F,$D070,$D071,$D072,$D073,$D074,
$D075,$D076,$D077,$D078,$D079,$D07A,$D07B,$D07C,$D07D,$D07E,$D0A1,$D0A2,$D0A3,
$D0A4,$D0A5,$D0A6,$D0A7,$D0A8,$D0A9,$D0AA,$D0AB,$D0AC,$D0AD,$D0AE,$D0AF,$D0B0,
$D0B1,$D0B2,$D0B3,$D0B4,$D0B5,$D0B6,$D0B7,$D0B8,$D0B9,$D0BA,$D0BB,$D0BC,$D0BD,
$D0BE,$D0BF,$D0C0,$D0C1,$D0C2,$D0C3,$D0C4,$D0C5,$D0C6,$D0C7,$D0C8,$D0C9,$D0CA,
$D0CB,$D0CC,$D0CD,$D0CE,$D0CF,$D0D0,$D0D1,$D0D2,$D0D3,$D0D4,$D0D5,$D0D6,$D0D7,
$D0D8,$D0D9,$D0DA,$D0DB,$D0DC,$D0DD,$D0DE,$D0DF,$D0E0,$D0E1,$D0E2,$D0E3,$D0E4,
$D0E5,$D0E6,$D0E7,$D0E8,$D0E9,$D0EA,$D0EB,$D0EC,$D0ED,$D0EE,$D0EF,$D0F0,$D0F1,
$D0F2,$D0F3,$D0F4,$D0F5,$D0F6,$D0F7,$D0F8,$D0F9,$D0FA,$D0FB,$D0FC,$D0FD,$D0FE,
$D140,$D141,$D142,$D143,$D144,$D145,$D146,$D147,$D148,$D149,$D14A,$D14B,$D14C,
$D14D,$D14E,$D14F,$D150,$D151,$D152,$D153,$D154,$D155,$D156,$D157,$D158,$D159,
$D15A,$D15B,$D15C,$D15D,$D15E,$D15F,$D160,$D161,$D162,$D163,$D164,$D165,$D166,
$D167,$D168,$D169,$D16A,$D16B,$D16C,$D16D,$D16E,$D16F,$D170,$D171,$D172,$D173,
$D174,$D175,$D176,$D177,$D178,$D179,$D17A,$D17B,$D17C,$D17D,$D17E,$D1A1,$D1A2,
$D1A3,$D1A4,$D1A5,$D1A6,$D1A7,$D1A8,$D1A9,$D1AA,$D1AB,$D1AC,$D1AD,$D1AE,$D1AF,
$D1B0,$D1B1,$D1B2,$D1B3,$D1B4,$D1B5,$D1B6,$D1B7,$D1B8,$D1B9,$D1BA,$D1BB,$D1BC,
$D1BD,$D1BE,$D1BF,$D1C0,$D1C1,$D1C2,$D1C3,$D1C4,$D1C5,$D1C6,$D1C7,$D1C8,$D1C9,
$D1CA,$D1CB,$D1CC,$D1CD,$D1CE,$D1CF,$D1D0,$D1D1,$D1D2,$D1D3,$D1D4,$D1D5,$D1D6,
$D1D7,$D1D8,$D1D9,$D1DA,$D1DB,$D1DC,$D1DD,$D1DE,$D1DF,$D1E0,$D1E1,$D1E2,$D1E3,
$D1E4,$D1E5,$D1E6,$D1E7,$D1E8,$D1E9,$D1EA,$D1EB,$D1EC,$D1ED,$D1EE,$D1EF,$D1F0,
$D1F1,$D1F2,$D1F3,$D1F4,$D1F5,$D1F6,$D1F7,$D1F8,$D1F9,$D1FA,$D1FB,$D1FC,$D1FD,
$D1FE,$D240,$D241,$D242,$D243,$D244,$D245,$D246,$D247,$D248,$D249,$D24A,$D24B,
$D24C,$D24D,$D24E,$D24F,$D250,$D251,$D252,$D253,$D254,$D255,$D256,$D257,$D258,
$D259,$D25A,$D25B,$D25C,$D25D,$D25E,$D25F,$D260,$D261,$D262,$D263,$D264,$D265,
$D266,$D267,$D268,$D269,$D26A,$D26B,$D26C,$D26D,$D26E,$D26F,$D270,$D271,$D272,
$D273,$D274,$D275,$D276,$D277,$D278,$D279,$D27A,$D27B,$D27C,$D27D,$D27E,$D2A1,
$D2A2,$D2A3,$D2A4,$D2A5,$D2A6,$D2A7,$D2A8,$D2A9,$D2AA,$D2AB,$D2AC,$D2AD,$D2AE,
$D2AF,$D2B0,$D2B1,$D2B2,$D2B3,$D2B4,$D2B5,$D2B6,$D2B7,$D2B8,$D2B9,$D2BA,$D2BB,
$D2BC,$D2BD,$D2BE,$D2BF,$D2C0,$D2C1,$D2C2,$D2C3,$D2C4,$D2C5,$D2C6,$D2C7,$D2C8,
$D2C9,$D2CA,$D2CB,$D2CC,$D2CD,$D2CE,$D2CF,$D2D0,$D2D1,$D2D2,$D2D3,$D2D4,$D2D5,
$D2D6,$D2D7,$D2D8,$D2D9,$D2DA,$D2DB,$D2DC,$D2DD,$D2DE,$D2DF,$D2E0,$D2E1,$D2E2,
$D2E3,$D2E4,$D2E5,$D2E6,$D2E7,$D2E8,$D2E9,$D2EA,$D2EB,$D2EC,$D2ED,$D2EE,$D2EF,
$D2F0,$D2F1,$D2F2,$D2F3,$D2F4,$D2F5,$D2F6,$D2F7,$D2F8,$D2F9,$D2FA,$D2FB,$D2FC,
$D2FD,$D2FE,$D340,$D341,$D342,$D343,$D344,$D345,$D346,$D347,$D348,$D349,$D34A,
$D34B,$D34C,$D34D,$D34E,$D34F,$D350,$D351,$D352,$D353,$D354,$D355,$D356,$D357,
$D358,$D359,$D35A,$D35B,$D35C,$D35D,$D35E,$D35F,$D360,$D361,$D362,$D363,$D364,
$D365,$D366,$D367,$D368,$D369,$D36A,$D36B,$D36C,$D36D,$D36E,$D36F,$D370,$D371,
$D372,$D373,$D374,$D375,$D376,$D377,$D378,$D379,$D37A,$D37B,$D37C,$D37D,$D37E,
$D3A1,$D3A2,$D3A3,$D3A4,$D3A5,$D3A6,$D3A7,$D3A8,$D3A9,$D3AA,$D3AB,$D3AC,$D3AD,
$D3AE,$D3AF,$D3B0,$D3B1,$D3B2,$D3B3,$D3B4,$D3B5,$D3B6,$D3B7,$D3B8,$D3B9,$D3BA,
$D3BB,$D3BC,$D3BD,$D3BE,$D3BF,$D3C0,$D3C1,$D3C2,$D3C3,$D3C4,$D3C5,$D3C6,$D3C7,
$D3C8,$D3C9,$D3CA,$D3CB,$D3CC,$D3CD,$D3CE,$D3CF,$D3D0,$D3D1,$D3D2,$D3D3,$D3D4,
$D3D5,$D3D6,$D3D7,$D3D8,$D3D9,$D3DA,$D3DB,$D3DC,$D3DD,$D3DE,$D3DF,$D3E0,$D3E1,
$D3E2,$D3E3,$D3E4,$D3E5,$D3E6,$D3E7,$D3E8,$D3E9,$D3EA,$D3EB,$D3EC,$D3ED,$D3EE,
$D3EF,$D3F0,$D3F1,$D3F2,$D3F3,$D3F4,$D3F5,$D3F6,$D3F7,$D3F8,$D3F9,$D3FA,$D3FB,
$D3FC,$D3FD,$D3FE,$D440,$D441,$D442,$D443,$D444,$D445,$D446,$D447,$D448,$D449,
$D44A,$D44B,$D44C,$D44D,$D44E,$D44F,$D450,$D451,$D452,$D453,$D454,$D455,$D456,
$D457,$D458,$D459,$D45A,$D45B,$D45C,$D45D,$D45E,$D45F,$D460,$D461,$D462,$D463,
$D464,$D465,$D466,$D467,$D468,$D469,$D46A,$D46B,$D46C,$D46D,$D46E,$D46F,$D470,
$D471,$D472,$D473,$D474,$D475,$D476,$D477,$D478,$D479,$D47A,$D47B,$D47C,$D47D,
$D47E,$D4A1,$D4A2,$D4A3,$D4A4,$D4A5,$D4A6,$D4A7,$D4A8,$D4A9,$D4AA,$D4AB,$D4AC,
$D4AD,$D4AE,$D4AF,$D4B0,$D4B1,$D4B2,$D4B3,$D4B4,$D4B5,$D4B6,$D4B7,$D4B8,$D4B9,
$D4BA,$D4BB,$D4BC,$D4BD,$D4BE,$D4BF,$D4C0,$D4C1,$D4C2,$D4C3,$D4C4,$D4C5,$D4C6,
$D4C7,$D4C8,$D4C9,$D4CA,$D4CB,$D4CC,$D4CD,$D4CE,$D4CF,$D4D0,$D4D1,$D4D2,$D4D3,
$D4D4,$D4D5,$D4D6,$D4D7,$D4D8,$D4D9,$D4DA,$D4DB,$D4DC,$D4DD,$D4DE,$D4DF,$D4E0,
$D4E1,$D4E2,$D4E3,$D4E4,$D4E5,$D4E6,$D4E7,$D4E8,$D4E9,$D4EA,$D4EB,$D4EC,$D4ED,
$D4EE,$D4EF,$D4F0,$D4F1,$D4F2,$D4F3,$D4F4,$D4F5,$D4F6,$D4F7,$D4F8,$D4F9,$D4FA,
$D4FB,$D4FC,$D4FD,$D4FE,$D540,$D541,$D542,$D543,$D544,$D545,$D546,$D547,$D548,
$D549,$D54A,$D54B,$D54C,$D54D,$D54E,$D54F,$D550,$D551,$D552,$D553,$D554,$D555,
$D556,$D557,$D558,$D559,$D55A,$D55B,$D55C,$D55D,$D55E,$D55F,$D560,$D561,$D562,
$D563,$D564,$D565,$D566,$D567,$D568,$D569,$D56A,$D56B,$D56C,$D56D,$D56E,$D56F,
$D570,$D571,$D572,$D573,$D574,$D575,$D576,$D577,$D578,$D579,$D57A,$D57B,$D57C,
$D57D,$D57E,$D5A1,$D5A2,$D5A3,$D5A4,$D5A5,$D5A6,$D5A7,$D5A8,$D5A9,$D5AA,$D5AB,
$D5AC,$D5AD,$D5AE,$D5AF,$D5B0,$D5B1,$D5B2,$D5B3,$D5B4,$D5B5,$D5B6,$D5B7,$D5B8,
$D5B9,$D5BA,$D5BB,$D5BC,$D5BD,$D5BE,$D5BF,$D5C0,$D5C1,$D5C2,$D5C3,$D5C4,$D5C5,
$D5C6,$D5C7,$D5C8,$D5C9,$D5CA,$D5CB,$D5CC,$D5CD,$D5CE,$D5CF,$D5D0,$D5D1,$D5D2,
$D5D3,$D5D4,$D5D5,$D5D6,$D5D7,$D5D8,$D5D9,$D5DA,$D5DB,$D5DC,$D5DD,$D5DE,$D5DF,
$D5E0,$D5E1,$D5E2,$D5E3,$D5E4,$D5E5,$D5E6,$D5E7,$D5E8,$D5E9,$D5EA,$D5EB,$D5EC,
$D5ED,$D5EE,$D5EF,$D5F0,$D5F1,$D5F2,$D5F3,$D5F4,$D5F5,$D5F6,$D5F7,$D5F8,$D5F9,
$D5FA,$D5FB,$D5FC,$D5FD,$D5FE,$D640,$D641,$D642,$D643,$D644,$D645,$D646,$D647,
$D648,$D649,$D64A,$D64B,$D64C,$D64D,$D64E,$D64F,$D650,$D651,$D652,$D653,$D654,
$D655,$D656,$D657,$D658,$D659,$D65A,$D65B,$D65C,$D65D,$D65E,$D65F,$D660,$D661,
$D662,$D663,$D664,$D665,$D666,$D667,$D668,$D669,$D66A,$D66B,$D66C,$D66D,$D66E,
$D66F,$D670,$D671,$D672,$D673,$D674,$D675,$D676,$D677,$D678,$D679,$D67A,$D67B,
$D67C,$D67D,$D67E,$D6A1,$D6A2,$D6A3,$D6A4,$D6A5,$D6A6,$D6A7,$D6A8,$D6A9,$D6AA,
$D6AB,$D6AC,$D6AD,$D6AE,$D6AF,$D6B0,$D6B1,$D6B2,$D6B3,$D6B4,$D6B5,$D6B6,$D6B7,
$D6B8,$D6B9,$D6BA,$D6BB,$D6BC,$D6BD,$D6BE,$D6BF,$D6C0,$D6C1,$D6C2,$D6C3,$D6C4,
$D6C5,$D6C6,$D6C7,$D6C8,$D6C9,$D6CA,$D6CB,$D6CC,$D6CD,$D6CE,$D6CF,$D6D0,$D6D1,
$D6D2,$D6D3,$D6D4,$D6D5,$D6D6,$D6D7,$D6D8,$D6D9,$D6DA,$D6DB,$D6DC,$D6DD,$D6DE,
$D6DF,$D6E0,$D6E1,$D6E2,$D6E3,$D6E4,$D6E5,$D6E6,$D6E7,$D6E8,$D6E9,$D6EA,$D6EB,
$D6EC,$D6ED,$D6EE,$D6EF,$D6F0,$D6F1,$D6F2,$D6F3,$D6F4,$D6F5,$D6F6,$D6F7,$D6F8,
$D6F9,$D6FA,$D6FB,$D6FC,$D6FD,$D6FE,$D740,$D741,$D742,$D743,$D744,$D745,$D746,
$D747,$D748,$D749,$D74A,$D74B,$D74C,$D74D,$D74E,$D74F,$D750,$D751,$D752,$D753,
$D754,$D755,$D756,$D757,$D758,$D759,$D75A,$D75B,$D75C,$D75D,$D75E,$D75F,$D760,
$D761,$D762,$D763,$D764,$D765,$D766,$D767,$D768,$D769,$D76A,$D76B,$D76C,$D76D,
$D76E,$D76F,$D770,$D771,$D772,$D773,$D774,$D775,$D776,$D777,$D778,$D779,$D77A,
$D77B,$D77C,$D77D,$D77E,$D7A1,$D7A2,$D7A3,$D7A4,$D7A5,$D7A6,$D7A7,$D7A8,$D7A9,
$D7AA,$D7AB,$D7AC,$D7AD,$D7AE,$D7AF,$D7B0,$D7B1,$D7B2,$D7B3,$D7B4,$D7B5,$D7B6,
$D7B7,$D7B8,$D7B9,$D7BA,$D7BB,$D7BC,$D7BD,$D7BE,$D7BF,$D7C0,$D7C1,$D7C2,$D7C3,
$D7C4,$D7C5,$D7C6,$D7C7,$D7C8,$D7C9,$D7CA,$D7CB,$D7CC,$D7CD,$D7CE,$D7CF,$D7D0,
$D7D1,$D7D2,$D7D3,$D7D4,$D7D5,$D7D6,$D7D7,$D7D8,$D7D9,$D7DA,$D7DB,$D7DC,$D7DD,
$D7DE,$D7DF,$D7E0,$D7E1,$D7E2,$D7E3,$D7E4,$D7E5,$D7E6,$D7E7,$D7E8,$D7E9,$D7EA,
$D7EB,$D7EC,$D7ED,$D7EE,$D7EF,$D7F0,$D7F1,$D7F2,$D7F3,$D7F4,$D7F5,$D7F6,$D7F7,
$D7F8,$D7F9,$D7FA,$D7FB,$D7FC,$D7FD,$D7FE,$D840,$D841,$D842,$D843,$D844,$D845,
$D846,$D847,$D848,$D849,$D84A,$D84B,$D84C,$D84D,$D84E,$D84F,$D850,$D851,$D852,
$D853,$D854,$D855,$D856,$D857,$D858,$D859,$D85A,$D85B,$D85C,$D85D,$D85E,$D85F,
$D860,$D861,$D862,$D863,$D864,$D865,$D866,$D867,$D868,$D869,$D86A,$D86B,$D86C,
$D86D,$D86E,$D86F,$D870,$D871,$D872,$D873,$D874,$D875,$D876,$D877,$D878,$D879,
$D87A,$D87B,$D87C,$D87D,$D87E,$D8A1,$D8A2,$D8A3,$D8A4,$D8A5,$D8A6,$D8A7,$D8A8,
$D8A9,$D8AA,$D8AB,$D8AC,$D8AD,$D8AE,$D8AF,$D8B0,$D8B1,$D8B2,$D8B3,$D8B4,$D8B5,
$D8B6,$D8B7,$D8B8,$D8B9,$D8BA,$D8BB,$D8BC,$D8BD,$D8BE,$D8BF,$D8C0,$D8C1,$D8C2,
$D8C3,$D8C4,$D8C5,$D8C6,$D8C7,$D8C8,$D8C9,$D8CA,$D8CB,$D8CC,$D8CD,$D8CE,$D8CF,
$D8D0,$D8D1,$D8D2,$D8D3,$D8D4,$D8D5,$D8D6,$D8D7,$D8D8,$D8D9,$D8DA,$D8DB,$D8DC,
$D8DD,$D8DE,$D8DF,$D8E0,$D8E1,$D8E2,$D8E3,$D8E4,$D8E5,$D8E6,$D8E7,$D8E8,$D8E9,
$D8EA,$D8EB,$D8EC,$D8ED,$D8EE,$D8EF,$D8F0,$D8F1,$D8F2,$D8F3,$D8F4,$D8F5,$D8F6,
$D8F7,$D8F8,$D8F9,$D8FA,$D8FB,$D8FC,$D8FD,$D8FE,$D940,$D941,$D942,$D943,$D944,
$D945,$D946,$D947,$D948,$D949,$D94A,$D94B,$D94C,$D94D,$D94E,$D94F,$D950,$D951,
$D952,$D953,$D954,$D955,$D956,$D957,$D958,$D959,$D95A,$D95B,$D95C,$D95D,$D95E,
$D95F,$D960,$D961,$D962,$D963,$D964,$D965,$D966,$D967,$D968,$D969,$D96A,$D96B,
$D96C,$D96D,$D96E,$D96F,$D970,$D971,$D972,$D973,$D974,$D975,$D976,$D977,$D978,
$D979,$D97A,$D97B,$D97C,$D97D,$D97E,$D9A1,$D9A2,$D9A3,$D9A4,$D9A5,$D9A6,$D9A7,
$D9A8,$D9A9,$D9AA,$D9AB,$D9AC,$D9AD,$D9AE,$D9AF,$D9B0,$D9B1,$D9B2,$D9B3,$D9B4,
$D9B5,$D9B6,$D9B7,$D9B8,$D9B9,$D9BA,$D9BB,$D9BC,$D9BD,$D9BE,$D9BF,$D9C0,$D9C1,
$D9C2,$D9C3,$D9C4,$D9C5,$D9C6,$D9C7,$D9C8,$D9C9,$D9CA,$D9CB,$D9CC,$D9CD,$D9CE,
$D9CF,$D9D0,$D9D1,$D9D2,$D9D3,$D9D4,$D9D5,$D9D6,$D9D7,$D9D8,$D9D9,$D9DA,$D9DB,
$D9DC,$D9DD,$D9DE,$D9DF,$D9E0,$D9E1,$D9E2,$D9E3,$D9E4,$D9E5,$D9E6,$D9E7,$D9E8,
$D9E9,$D9EA,$D9EB,$D9EC,$D9ED,$D9EE,$D9EF,$D9F0,$D9F1,$D9F2,$D9F3,$D9F4,$D9F5,
$D9F6,$D9F7,$D9F8,$D9F9,$D9FA,$D9FB,$D9FC,$D9FD,$D9FE,$DA40,$DA41,$DA42,$DA43,
$DA44,$DA45,$DA46,$DA47,$DA48,$DA49,$DA4A,$DA4B,$DA4C,$DA4D,$DA4E,$DA4F,$DA50,
$DA51,$DA52,$DA53,$DA54,$DA55,$DA56,$DA57,$DA58,$DA59,$DA5A,$DA5B,$DA5C,$DA5D,
$DA5E,$DA5F,$DA60,$DA61,$DA62,$DA63,$DA64,$DA65,$DA66,$DA67,$DA68,$DA69,$DA6A,
$DA6B,$DA6C,$DA6D,$DA6E,$DA6F,$DA70,$DA71,$DA72,$DA73,$DA74,$DA75,$DA76,$DA77,
$DA78,$DA79,$DA7A,$DA7B,$DA7C,$DA7D,$DA7E,$DAA1,$DAA2,$DAA3,$DAA4,$DAA5,$DAA6,
$DAA7,$DAA8,$DAA9,$DAAA,$DAAB,$DAAC,$DAAD,$DAAE,$DAAF,$DAB0,$DAB1,$DAB2,$DAB3,
$DAB4,$DAB5,$DAB6,$DAB7,$DAB8,$DAB9,$DABA,$DABB,$DABC,$DABD,$DABE,$DABF,$DAC0,
$DAC1,$DAC2,$DAC3,$DAC4,$DAC5,$DAC6,$DAC7,$DAC8,$DAC9,$DACA,$DACB,$DACC,$DACD,
$DACE,$DACF,$DAD0,$DAD1,$DAD2,$DAD3,$DAD4,$DAD5,$DAD6,$DAD7,$DAD8,$DAD9,$DADA,
$DADB,$DADC,$DADD,$DADE,$DADF,$DAE0,$DAE1,$DAE2,$DAE3,$DAE4,$DAE5,$DAE6,$DAE7,
$DAE8,$DAE9,$DAEA,$DAEB,$DAEC,$DAED,$DAEE,$DAEF,$DAF0,$DAF1,$DAF2,$DAF3,$DAF4,
$DAF5,$DAF6,$DAF7,$DAF8,$DAF9,$DAFA,$DAFB,$DAFC,$DAFD,$DAFE,$DB40,$DB41,$DB42,
$DB43,$DB44,$DB45,$DB46,$DB47,$DB48,$DB49,$DB4A,$DB4B,$DB4C,$DB4D,$DB4E,$DB4F,
$DB50,$DB51,$DB52,$DB53,$DB54,$DB55,$DB56,$DB57,$DB58,$DB59,$DB5A,$DB5B,$DB5C,
$DB5D,$DB5E,$DB5F,$DB60,$DB61,$DB62,$DB63,$DB64,$DB65,$DB66,$DB67,$DB68,$DB69,
$DB6A,$DB6B,$DB6C,$DB6D,$DB6E,$DB6F,$DB70,$DB71,$DB72,$DB73,$DB74,$DB75,$DB76,
$DB77,$DB78,$DB79,$DB7A,$DB7B,$DB7C,$DB7D,$DB7E,$DBA1,$DBA2,$DBA3,$DBA4,$DBA5,
$DBA6,$DBA7,$DBA8,$DBA9,$DBAA,$DBAB,$DBAC,$DBAD,$DBAE,$DBAF,$DBB0,$DBB1,$DBB2,
$DBB3,$DBB4,$DBB5,$DBB6,$DBB7,$DBB8,$DBB9,$DBBA,$DBBB,$DBBC,$DBBD,$DBBE,$DBBF,
$DBC0,$DBC1,$DBC2,$DBC3,$DBC4,$DBC5,$DBC6,$DBC7,$DBC8,$DBC9,$DBCA,$DBCB,$DBCC,
$DBCD,$DBCE,$DBCF,$DBD0,$DBD1,$DBD2,$DBD3,$DBD4,$DBD5,$DBD6,$DBD7,$DBD8,$DBD9,
$DBDA,$DBDB,$DBDC,$DBDD,$DBDE,$DBDF,$DBE0,$DBE1,$DBE2,$DBE3,$DBE4,$DBE5,$DBE6,
$DBE7,$DBE8,$DBE9,$DBEA,$DBEB,$DBEC,$DBED,$DBEE,$DBEF,$DBF0,$DBF1,$DBF2,$DBF3,
$DBF4,$DBF5,$DBF6,$DBF7,$DBF8,$DBF9,$DBFA,$DBFB,$DBFC,$DBFD,$DBFE,$DC40,$DC41,
$DC42,$DC43,$DC44,$DC45,$DC46,$DC47,$DC48,$DC49,$DC4A,$DC4B,$DC4C,$DC4D,$DC4E,
$DC4F,$DC50,$DC51,$DC52,$DC53,$DC54,$DC55,$DC56,$DC57,$DC58,$DC59,$DC5A,$DC5B,
$DC5C,$DC5D,$DC5E,$DC5F,$DC60,$DC61,$DC62,$DC63,$DC64,$DC65,$DC66,$DC67,$DC68,
$DC69,$DC6A,$DC6B,$DC6C,$DC6D,$DC6E,$DC6F,$DC70,$DC71,$DC72,$DC73,$DC74,$DC75,
$DC76,$DC77,$DC78,$DC79,$DC7A,$DC7B,$DC7C,$DC7D,$DC7E,$DCA1,$DCA2,$DCA3,$DCA4,
$DCA5,$DCA6,$DCA7,$DCA8,$DCA9,$DCAA,$DCAB,$DCAC,$DCAD,$DCAE,$DCAF,$DCB0,$DCB1,
$DCB2,$DCB3,$DCB4,$DCB5,$DCB6,$DCB7,$DCB8,$DCB9,$DCBA,$DCBB,$DCBC,$DCBD,$DCBE,
$DCBF,$DCC0,$DCC1,$DCC2,$DCC3,$DCC4,$DCC5,$DCC6,$DCC7,$DCC8,$DCC9,$DCCA,$DCCB,
$DCCC,$DCCD,$DCCE,$DCCF,$DCD0,$DCD1,$DCD2,$DCD3,$DCD4,$DCD5,$DCD6,$DCD7,$DCD8,
$DCD9,$DCDA,$DCDB,$DCDC,$DCDD,$DCDE,$DCDF,$DCE0,$DCE1,$DCE2,$DCE3,$DCE4,$DCE5,
$DCE6,$DCE7,$DCE8,$DCE9,$DCEA,$DCEB,$DCEC,$DCED,$DCEE,$DCEF,$DCF0,$DCF1,$DCF2,
$DCF3,$DCF4,$DCF5,$DCF6,$DCF7,$DCF8,$DCF9,$DCFA,$DCFB,$DCFC,$DCFD,$DCFE,$DD40,
$DD41,$DD42,$DD43,$DD44,$DD45,$DD46,$DD47,$DD48,$DD49,$DD4A,$DD4B,$DD4C,$DD4D,
$DD4E,$DD4F,$DD50,$DD51,$DD52,$DD53,$DD54,$DD55,$DD56,$DD57,$DD58,$DD59,$DD5A,
$DD5B,$DD5C,$DD5D,$DD5E,$DD5F,$DD60,$DD61,$DD62,$DD63,$DD64,$DD65,$DD66,$DD67,
$DD68,$DD69,$DD6A,$DD6B,$DD6C,$DD6D,$DD6E,$DD6F,$DD70,$DD71,$DD72,$DD73,$DD74,
$DD75,$DD76,$DD77,$DD78,$DD79,$DD7A,$DD7B,$DD7C,$DD7D,$DD7E,$DDA1,$DDA2,$DDA3,
$DDA4,$DDA5,$DDA6,$DDA7,$DDA8,$DDA9,$DDAA,$DDAB,$DDAC,$DDAD,$DDAE,$DDAF,$DDB0,
$DDB1,$DDB2,$DDB3,$DDB4,$DDB5,$DDB6,$DDB7,$DDB8,$DDB9,$DDBA,$DDBB,$DDBC,$DDBD,
$DDBE,$DDBF,$DDC0,$DDC1,$DDC2,$DDC3,$DDC4,$DDC5,$DDC6,$DDC7,$DDC8,$DDC9,$DDCA,
$DDCB,$DDCC,$DDCD,$DDCE,$DDCF,$DDD0,$DDD1,$DDD2,$DDD3,$DDD4,$DDD5,$DDD6,$DDD7,
$DDD8,$DDD9,$DDDA,$DDDB,$DDDC,$DDDD,$DDDE,$DDDF,$DDE0,$DDE1,$DDE2,$DDE3,$DDE4,
$DDE5,$DDE6,$DDE7,$DDE8,$DDE9,$DDEA,$DDEB,$DDEC,$DDED,$DDEE,$DDEF,$DDF0,$DDF1,
$DDF2,$DDF3,$DDF4,$DDF5,$DDF6,$DDF7,$DDF8,$DDF9,$DDFA,$DDFB,$DDFC,$DDFD,$DDFE,
$DE40,$DE41,$DE42,$DE43,$DE44,$DE45,$DE46,$DE47,$DE48,$DE49,$DE4A,$DE4B,$DE4C,
$DE4D,$DE4E,$DE4F,$DE50,$DE51,$DE52,$DE53,$DE54,$DE55,$DE56,$DE57,$DE58,$DE59,
$DE5A,$DE5B,$DE5C,$DE5D,$DE5E,$DE5F,$DE60,$DE61,$DE62,$DE63,$DE64,$DE65,$DE66,
$DE67,$DE68,$DE69,$DE6A,$DE6B,$DE6C,$DE6D,$DE6E,$DE6F,$DE70,$DE71,$DE72,$DE73,
$DE74,$DE75,$DE76,$DE77,$DE78,$DE79,$DE7A,$DE7B,$DE7C,$DE7D,$DE7E,$DEA1,$DEA2,
$DEA3,$DEA4,$DEA5,$DEA6,$DEA7,$DEA8,$DEA9,$DEAA,$DEAB,$DEAC,$DEAD,$DEAE,$DEAF,
$DEB0,$DEB1,$DEB2,$DEB3,$DEB4,$DEB5,$DEB6,$DEB7,$DEB8,$DEB9,$DEBA,$DEBB,$DEBC,
$DEBD,$DEBE,$DEBF,$DEC0,$DEC1,$DEC2,$DEC3,$DEC4,$DEC5,$DEC6,$DEC7,$DEC8,$DEC9,
$DECA,$DECB,$DECC,$DECD,$DECE,$DECF,$DED0,$DED1,$DED2,$DED3,$DED4,$DED5,$DED6,
$DED7,$DED8,$DED9,$DEDA,$DEDB,$DEDC,$DEDD,$DEDE,$DEDF,$DEE0,$DEE1,$DEE2,$DEE3,
$DEE4,$DEE5,$DEE6,$DEE7,$DEE8,$DEE9,$DEEA,$DEEB,$DEEC,$DEED,$DEEE,$DEEF,$DEF0,
$DEF1,$DEF2,$DEF3,$DEF4,$DEF5,$DEF6,$DEF7,$DEF8,$DEF9,$DEFA,$DEFB,$DEFC,$DEFD,
$DEFE,$DF40,$DF41,$DF42,$DF43,$DF44,$DF45,$DF46,$DF47,$DF48,$DF49,$DF4A,$DF4B,
$DF4C,$DF4D,$DF4E,$DF4F,$DF50,$DF51,$DF52,$DF53,$DF54,$DF55,$DF56,$DF57,$DF58,
$DF59,$DF5A,$DF5B,$DF5C,$DF5D,$DF5E,$DF5F,$DF60,$DF61,$DF62,$DF63,$DF64,$DF65,
$DF66,$DF67,$DF68,$DF69,$DF6A,$DF6B,$DF6C,$DF6D,$DF6E,$DF6F,$DF70,$DF71,$DF72,
$DF73,$DF74,$DF75,$DF76,$DF77,$DF78,$DF79,$DF7A,$DF7B,$DF7C,$DF7D,$DF7E,$DFA1,
$DFA2,$DFA3,$DFA4,$DFA5,$DFA6,$DFA7,$DFA8,$DFA9,$DFAA,$DFAB,$DFAC,$DFAD,$DFAE,
$DFAF,$DFB0,$DFB1,$DFB2,$DFB3,$DFB4,$DFB5,$DFB6,$DFB7,$DFB8,$DFB9,$DFBA,$DFBB,
$DFBC,$DFBD,$DFBE,$DFBF,$DFC0,$DFC1,$DFC2,$DFC3,$DFC4,$DFC5,$DFC6,$DFC7,$DFC8,
$DFC9,$DFCA,$DFCB,$DFCC,$DFCD,$DFCE,$DFCF,$DFD0,$DFD1,$DFD2,$DFD3,$DFD4,$DFD5,
$DFD6,$DFD7,$DFD8,$DFD9,$DFDA,$DFDB,$DFDC,$DFDD,$DFDE,$DFDF,$DFE0,$DFE1,$DFE2,
$DFE3,$DFE4,$DFE5,$DFE6,$DFE7,$DFE8,$DFE9,$DFEA,$DFEB,$DFEC,$DFED,$DFEE,$DFEF,
$DFF0,$DFF1,$DFF2,$DFF3,$DFF4,$DFF5,$DFF6,$DFF7,$DFF8,$DFF9,$DFFA,$DFFB,$DFFC,
$DFFD,$DFFE,$E040,$E041,$E042,$E043,$E044,$E045,$E046,$E047,$E048,$E049,$E04A,
$E04B,$E04C,$E04D,$E04E,$E04F,$E050,$E051,$E052,$E053,$E054,$E055,$E056,$E057,
$E058,$E059,$E05A,$E05B,$E05C,$E05D,$E05E,$E05F,$E060,$E061,$E062,$E063,$E064,
$E065,$E066,$E067,$E068,$E069,$E06A,$E06B,$E06C,$E06D,$E06E,$E06F,$E070,$E071,
$E072,$E073,$E074,$E075,$E076,$E077,$E078,$E079,$E07A,$E07B,$E07C,$E07D,$E07E,
$E0A1,$E0A2,$E0A3,$E0A4,$E0A5,$E0A6,$E0A7,$E0A8,$E0A9,$E0AA,$E0AB,$E0AC,$E0AD,
$E0AE,$E0AF,$E0B0,$E0B1,$E0B2,$E0B3,$E0B4,$E0B5,$E0B6,$E0B7,$E0B8,$E0B9,$E0BA,
$E0BB,$E0BC,$E0BD,$E0BE,$E0BF,$E0C0,$E0C1,$E0C2,$E0C3,$E0C4,$E0C5,$E0C6,$E0C7,
$E0C8,$E0C9,$E0CA,$E0CB,$E0CC,$E0CD,$E0CE,$E0CF,$E0D0,$E0D1,$E0D2,$E0D3,$E0D4,
$E0D5,$E0D6,$E0D7,$E0D8,$E0D9,$E0DA,$E0DB,$E0DC,$E0DD,$E0DE,$E0DF,$E0E0,$E0E1,
$E0E2,$E0E3,$E0E4,$E0E5,$E0E6,$E0E7,$E0E8,$E0E9,$E0EA,$E0EB,$E0EC,$E0ED,$E0EE,
$E0EF,$E0F0,$E0F1,$E0F2,$E0F3,$E0F4,$E0F5,$E0F6,$E0F7,$E0F8,$E0F9,$E0FA,$E0FB,
$E0FC,$E0FD,$E0FE,$E140,$E141,$E142,$E143,$E144,$E145,$E146,$E147,$E148,$E149,
$E14A,$E14B,$E14C,$E14D,$E14E,$E14F,$E150,$E151,$E152,$E153,$E154,$E155,$E156,
$E157,$E158,$E159,$E15A,$E15B,$E15C,$E15D,$E15E,$E15F,$E160,$E161,$E162,$E163,
$E164,$E165,$E166,$E167,$E168,$E169,$E16A,$E16B,$E16C,$E16D,$E16E,$E16F,$E170,
$E171,$E172,$E173,$E174,$E175,$E176,$E177,$E178,$E179,$E17A,$E17B,$E17C,$E17D,
$E17E,$E1A1,$E1A2,$E1A3,$E1A4,$E1A5,$E1A6,$E1A7,$E1A8,$E1A9,$E1AA,$E1AB,$E1AC,
$E1AD,$E1AE,$E1AF,$E1B0,$E1B1,$E1B2,$E1B3,$E1B4,$E1B5,$E1B6,$E1B7,$E1B8,$E1B9,
$E1BA,$E1BB,$E1BC,$E1BD,$E1BE,$E1BF,$E1C0,$E1C1,$E1C2,$E1C3,$E1C4,$E1C5,$E1C6,
$E1C7,$E1C8,$E1C9,$E1CA,$E1CB,$E1CC,$E1CD,$E1CE,$E1CF,$E1D0,$E1D1,$E1D2,$E1D3,
$E1D4,$E1D5,$E1D6,$E1D7,$E1D8,$E1D9,$E1DA,$E1DB,$E1DC,$E1DD,$E1DE,$E1DF,$E1E0,
$E1E1,$E1E2,$E1E3,$E1E4,$E1E5,$E1E6,$E1E7,$E1E8,$E1E9,$E1EA,$E1EB,$E1EC,$E1ED,
$E1EE,$E1EF,$E1F0,$E1F1,$E1F2,$E1F3,$E1F4,$E1F5,$E1F6,$E1F7,$E1F8,$E1F9,$E1FA,
$E1FB,$E1FC,$E1FD,$E1FE,$E240,$E241,$E242,$E243,$E244,$E245,$E246,$E247,$E248,
$E249,$E24A,$E24B,$E24C,$E24D,$E24E,$E24F,$E250,$E251,$E252,$E253,$E254,$E255,
$E256,$E257,$E258,$E259,$E25A,$E25B,$E25C,$E25D,$E25E,$E25F,$E260,$E261,$E262,
$E263,$E264,$E265,$E266,$E267,$E268,$E269,$E26A,$E26B,$E26C,$E26D,$E26E,$E26F,
$E270,$E271,$E272,$E273,$E274,$E275,$E276,$E277,$E278,$E279,$E27A,$E27B,$E27C,
$E27D,$E27E,$E2A1,$E2A2,$E2A3,$E2A4,$E2A5,$E2A6,$E2A7,$E2A8,$E2A9,$E2AA,$E2AB,
$E2AC,$E2AD,$E2AE,$E2AF,$E2B0,$E2B1,$E2B2,$E2B3,$E2B4,$E2B5,$E2B6,$E2B7,$E2B8,
$E2B9,$E2BA,$E2BB,$E2BC,$E2BD,$E2BE,$E2BF,$E2C0,$E2C1,$E2C2,$E2C3,$E2C4,$E2C5,
$E2C6,$E2C7,$E2C8,$E2C9,$E2CA,$E2CB,$E2CC,$E2CD,$E2CE,$E2CF,$E2D0,$E2D1,$E2D2,
$E2D3,$E2D4,$E2D5,$E2D6,$E2D7,$E2D8,$E2D9,$E2DA,$E2DB,$E2DC,$E2DD,$E2DE,$E2DF,
$E2E0,$E2E1,$E2E2,$E2E3,$E2E4,$E2E5,$E2E6,$E2E7,$E2E8,$E2E9,$E2EA,$E2EB,$E2EC,
$E2ED,$E2EE,$E2EF,$E2F0,$E2F1,$E2F2,$E2F3,$E2F4,$E2F5,$E2F6,$E2F7,$E2F8,$E2F9,
$E2FA,$E2FB,$E2FC,$E2FD,$E2FE,$E340,$E341,$E342,$E343,$E344,$E345,$E346,$E347,
$E348,$E349,$E34A,$E34B,$E34C,$E34D,$E34E,$E34F,$E350,$E351,$E352,$E353,$E354,
$E355,$E356,$E357,$E358,$E359,$E35A,$E35B,$E35C,$E35D,$E35E,$E35F,$E360,$E361,
$E362,$E363,$E364,$E365,$E366,$E367,$E368,$E369,$E36A,$E36B,$E36C,$E36D,$E36E,
$E36F,$E370,$E371,$E372,$E373,$E374,$E375,$E376,$E377,$E378,$E379,$E37A,$E37B,
$E37C,$E37D,$E37E,$E3A1,$E3A2,$E3A3,$E3A4,$E3A5,$E3A6,$E3A7,$E3A8,$E3A9,$E3AA,
$E3AB,$E3AC,$E3AD,$E3AE,$E3AF,$E3B0,$E3B1,$E3B2,$E3B3,$E3B4,$E3B5,$E3B6,$E3B7,
$E3B8,$E3B9,$E3BA,$E3BB,$E3BC,$E3BD,$E3BE,$E3BF,$E3C0,$E3C1,$E3C2,$E3C3,$E3C4,
$E3C5,$E3C6,$E3C7,$E3C8,$E3C9,$E3CA,$E3CB,$E3CC,$E3CD,$E3CE,$E3CF,$E3D0,$E3D1,
$E3D2,$E3D3,$E3D4,$E3D5,$E3D6,$E3D7,$E3D8,$E3D9,$E3DA,$E3DB,$E3DC,$E3DD,$E3DE,
$E3DF,$E3E0,$E3E1,$E3E2,$E3E3,$E3E4,$E3E5,$E3E6,$E3E7,$E3E8,$E3E9,$E3EA,$E3EB,
$E3EC,$E3ED,$E3EE,$E3EF,$E3F0,$E3F1,$E3F2,$E3F3,$E3F4,$E3F5,$E3F6,$E3F7,$E3F8,
$E3F9,$E3FA,$E3FB,$E3FC,$E3FD,$E3FE,$E440,$E441,$E442,$E443,$E444,$E445,$E446,
$E447,$E448,$E449,$E44A,$E44B,$E44C,$E44D,$E44E,$E44F,$E450,$E451,$E452,$E453,
$E454,$E455,$E456,$E457,$E458,$E459,$E45A,$E45B,$E45C,$E45D,$E45E,$E45F,$E460,
$E461,$E462,$E463,$E464,$E465,$E466,$E467,$E468,$E469,$E46A,$E46B,$E46C,$E46D,
$E46E,$E46F,$E470,$E471,$E472,$E473,$E474,$E475,$E476,$E477,$E478,$E479,$E47A,
$E47B,$E47C,$E47D,$E47E,$E4A1,$E4A2,$E4A3,$E4A4,$E4A5,$E4A6,$E4A7,$E4A8,$E4A9,
$E4AA,$E4AB,$E4AC,$E4AD,$E4AE,$E4AF,$E4B0,$E4B1,$E4B2,$E4B3,$E4B4,$E4B5,$E4B6,
$E4B7,$E4B8,$E4B9,$E4BA,$E4BB,$E4BC,$E4BD,$E4BE,$E4BF,$E4C0,$E4C1,$E4C2,$E4C3,
$E4C4,$E4C5,$E4C6,$E4C7,$E4C8,$E4C9,$E4CA,$E4CB,$E4CC,$E4CD,$E4CE,$E4CF,$E4D0,
$E4D1,$E4D2,$E4D3,$E4D4,$E4D5,$E4D6,$E4D7,$E4D8,$E4D9,$E4DA,$E4DB,$E4DC,$E4DD,
$E4DE,$E4DF,$E4E0,$E4E1,$E4E2,$E4E3,$E4E4,$E4E5,$E4E6,$E4E7,$E4E8,$E4E9,$E4EA,
$E4EB,$E4EC,$E4ED,$E4EE,$E4EF,$E4F0,$E4F1,$E4F2,$E4F3,$E4F4,$E4F5,$E4F6,$E4F7,
$E4F8,$E4F9,$E4FA,$E4FB,$E4FC,$E4FD,$E4FE,$E540,$E541,$E542,$E543,$E544,$E545,
$E546,$E547,$E548,$E549,$E54A,$E54B,$E54C,$E54D,$E54E,$E54F,$E550,$E551,$E552,
$E553,$E554,$E555,$E556,$E557,$E558,$E559,$E55A,$E55B,$E55C,$E55D,$E55E,$E55F,
$E560,$E561,$E562,$E563,$E564,$E565,$E566,$E567,$E568,$E569,$E56A,$E56B,$E56C,
$E56D,$E56E,$E56F,$E570,$E571,$E572,$E573,$E574,$E575,$E576,$E577,$E578,$E579,
$E57A,$E57B,$E57C,$E57D,$E57E,$E5A1,$E5A2,$E5A3,$E5A4,$E5A5,$E5A6,$E5A7,$E5A8,
$E5A9,$E5AA,$E5AB,$E5AC,$E5AD,$E5AE,$E5AF,$E5B0,$E5B1,$E5B2,$E5B3,$E5B4,$E5B5,
$E5B6,$E5B7,$E5B8,$E5B9,$E5BA,$E5BB,$E5BC,$E5BD,$E5BE,$E5BF,$E5C0,$E5C1,$E5C2,
$E5C3,$E5C4,$E5C5,$E5C6,$E5C7,$E5C8,$E5C9,$E5CA,$E5CB,$E5CC,$E5CD,$E5CE,$E5CF,
$E5D0,$E5D1,$E5D2,$E5D3,$E5D4,$E5D5,$E5D6,$E5D7,$E5D8,$E5D9,$E5DA,$E5DB,$E5DC,
$E5DD,$E5DE,$E5DF,$E5E0,$E5E1,$E5E2,$E5E3,$E5E4,$E5E5,$E5E6,$E5E7,$E5E8,$E5E9,
$E5EA,$E5EB,$E5EC,$E5ED,$E5EE,$E5EF,$E5F0,$E5F1,$E5F2,$E5F3,$E5F4,$E5F5,$E5F6,
$E5F7,$E5F8,$E5F9,$E5FA,$E5FB,$E5FC,$E5FD,$E5FE,$E640,$E641,$E642,$E643,$E644,
$E645,$E646,$E647,$E648,$E649,$E64A,$E64B,$E64C,$E64D,$E64E,$E64F,$E650,$E651,
$E652,$E653,$E654,$E655,$E656,$E657,$E658,$E659,$E65A,$E65B,$E65C,$E65D,$E65E,
$E65F,$E660,$E661,$E662,$E663,$E664,$E665,$E666,$E667,$E668,$E669,$E66A,$E66B,
$E66C,$E66D,$E66E,$E66F,$E670,$E671,$E672,$E673,$E674,$E675,$E676,$E677,$E678,
$E679,$E67A,$E67B,$E67C,$E67D,$E67E,$E6A1,$E6A2,$E6A3,$E6A4,$E6A5,$E6A6,$E6A7,
$E6A8,$E6A9,$E6AA,$E6AB,$E6AC,$E6AD,$E6AE,$E6AF,$E6B0,$E6B1,$E6B2,$E6B3,$E6B4,
$E6B5,$E6B6,$E6B7,$E6B8,$E6B9,$E6BA,$E6BB,$E6BC,$E6BD,$E6BE,$E6BF,$E6C0,$E6C1,
$E6C2,$E6C3,$E6C4,$E6C5,$E6C6,$E6C7,$E6C8,$E6C9,$E6CA,$E6CB,$E6CC,$E6CD,$E6CE,
$E6CF,$E6D0,$E6D1,$E6D2,$E6D3,$E6D4,$E6D5,$E6D6,$E6D7,$E6D8,$E6D9,$E6DA,$E6DB,
$E6DC,$E6DD,$E6DE,$E6DF,$E6E0,$E6E1,$E6E2,$E6E3,$E6E4,$E6E5,$E6E6,$E6E7,$E6E8,
$E6E9,$E6EA,$E6EB,$E6EC,$E6ED,$E6EE,$E6EF,$E6F0,$E6F1,$E6F2,$E6F3,$E6F4,$E6F5,
$E6F6,$E6F7,$E6F8,$E6F9,$E6FA,$E6FB,$E6FC,$E6FD,$E6FE,$E740,$E741,$E742,$E743,
$E744,$E745,$E746,$E747,$E748,$E749,$E74A,$E74B,$E74C,$E74D,$E74E,$E74F,$E750,
$E751,$E752,$E753,$E754,$E755,$E756,$E757,$E758,$E759,$E75A,$E75B,$E75C,$E75D,
$E75E,$E75F,$E760,$E761,$E762,$E763,$E764,$E765,$E766,$E767,$E768,$E769,$E76A,
$E76B,$E76C,$E76D,$E76E,$E76F,$E770,$E771,$E772,$E773,$E774,$E775,$E776,$E777,
$E778,$E779,$E77A,$E77B,$E77C,$E77D,$E77E,$E7A1,$E7A2,$E7A3,$E7A4,$E7A5,$E7A6,
$E7A7,$E7A8,$E7A9,$E7AA,$E7AB,$E7AC,$E7AD,$E7AE,$E7AF,$E7B0,$E7B1,$E7B2,$E7B3,
$E7B4,$E7B5,$E7B6,$E7B7,$E7B8,$E7B9,$E7BA,$E7BB,$E7BC,$E7BD,$E7BE,$E7BF,$E7C0,
$E7C1,$E7C2,$E7C3,$E7C4,$E7C5,$E7C6,$E7C7,$E7C8,$E7C9,$E7CA,$E7CB,$E7CC,$E7CD,
$E7CE,$E7CF,$E7D0,$E7D1,$E7D2,$E7D3,$E7D4,$E7D5,$E7D6,$E7D7,$E7D8,$E7D9,$E7DA,
$E7DB,$E7DC,$E7DD,$E7DE,$E7DF,$E7E0,$E7E1,$E7E2,$E7E3,$E7E4,$E7E5,$E7E6,$E7E7,
$E7E8,$E7E9,$E7EA,$E7EB,$E7EC,$E7ED,$E7EE,$E7EF,$E7F0,$E7F1,$E7F2,$E7F3,$E7F4,
$E7F5,$E7F6,$E7F7,$E7F8,$E7F9,$E7FA,$E7FB,$E7FC,$E7FD,$E7FE,$E840,$E841,$E842,
$E843,$E844,$E845,$E846,$E847,$E848,$E849,$E84A,$E84B,$E84C,$E84D,$E84E,$E84F,
$E850,$E851,$E852,$E853,$E854,$E855,$E856,$E857,$E858,$E859,$E85A,$E85B,$E85C,
$E85D,$E85E,$E85F,$E860,$E861,$E862,$E863,$E864,$E865,$E866,$E867,$E868,$E869,
$E86A,$E86B,$E86C,$E86D,$E86E,$E86F,$E870,$E871,$E872,$E873,$E874,$E875,$E876,
$E877,$E878,$E879,$E87A,$E87B,$E87C,$E87D,$E87E,$E8A1,$E8A2,$E8A3,$E8A4,$E8A5,
$E8A6,$E8A7,$E8A8,$E8A9,$E8AA,$E8AB,$E8AC,$E8AD,$E8AE,$E8AF,$E8B0,$E8B1,$E8B2,
$E8B3,$E8B4,$E8B5,$E8B6,$E8B7,$E8B8,$E8B9,$E8BA,$E8BB,$E8BC,$E8BD,$E8BE,$E8BF,
$E8C0,$E8C1,$E8C2,$E8C3,$E8C4,$E8C5,$E8C6,$E8C7,$E8C8,$E8C9,$E8CA,$E8CB,$E8CC,
$E8CD,$E8CE,$E8CF,$E8D0,$E8D1,$E8D2,$E8D3,$E8D4,$E8D5,$E8D6,$E8D7,$E8D8,$E8D9,
$E8DA,$E8DB,$E8DC,$E8DD,$E8DE,$E8DF,$E8E0,$E8E1,$E8E2,$E8E3,$E8E4,$E8E5,$E8E6,
$E8E7,$E8E8,$E8E9,$E8EA,$E8EB,$E8EC,$E8ED,$E8EE,$E8EF,$E8F0,$E8F1,$E8F2,$E8F3,
$E8F4,$E8F5,$E8F6,$E8F7,$E8F8,$E8F9,$E8FA,$E8FB,$E8FC,$E8FD,$E8FE,$E940,$E941,
$E942,$E943,$E944,$E945,$E946,$E947,$E948,$E949,$E94A,$E94B,$E94C,$E94D,$E94E,
$E94F,$E950,$E951,$E952,$E953,$E954,$E955,$E956,$E957,$E958,$E959,$E95A,$E95B,
$E95C,$E95D,$E95E,$E95F,$E960,$E961,$E962,$E963,$E964,$E965,$E966,$E967,$E968,
$E969,$E96A,$E96B,$E96C,$E96D,$E96E,$E96F,$E970,$E971,$E972,$E973,$E974,$E975,
$E976,$E977,$E978,$E979,$E97A,$E97B,$E97C,$E97D,$E97E,$E9A1,$E9A2,$E9A3,$E9A4,
$E9A5,$E9A6,$E9A7,$E9A8,$E9A9,$E9AA,$E9AB,$E9AC,$E9AD,$E9AE,$E9AF,$E9B0,$E9B1,
$E9B2,$E9B3,$E9B4,$E9B5,$E9B6,$E9B7,$E9B8,$E9B9,$E9BA,$E9BB,$E9BC,$E9BD,$E9BE,
$E9BF,$E9C0,$E9C1,$E9C2,$E9C3,$E9C4,$E9C5,$E9C6,$E9C7,$E9C8,$E9C9,$E9CA,$E9CB,
$E9CC,$E9CD,$E9CE,$E9CF,$E9D0,$E9D1,$E9D2,$E9D3,$E9D4,$E9D5,$E9D6,$E9D7,$E9D8,
$E9D9,$E9DA,$E9DB,$E9DC,$E9DD,$E9DE,$E9DF,$E9E0,$E9E1,$E9E2,$E9E3,$E9E4,$E9E5,
$E9E6,$E9E7,$E9E8,$E9E9,$E9EA,$E9EB,$E9EC,$E9ED,$E9EE,$E9EF,$E9F0,$E9F1,$E9F2,
$E9F3,$E9F4,$E9F5,$E9F6,$E9F7,$E9F8,$E9F9,$E9FA,$E9FB,$E9FC,$E9FD,$E9FE,$EA40,
$EA41,$EA42,$EA43,$EA44,$EA45,$EA46,$EA47,$EA48,$EA49,$EA4A,$EA4B,$EA4C,$EA4D,
$EA4E,$EA4F,$EA50,$EA51,$EA52,$EA53,$EA54,$EA55,$EA56,$EA57,$EA58,$EA59,$EA5A,
$EA5B,$EA5C,$EA5D,$EA5E,$EA5F,$EA60,$EA61,$EA62,$EA63,$EA64,$EA65,$EA66,$EA67,
$EA68,$EA69,$EA6A,$EA6B,$EA6C,$EA6D,$EA6E,$EA6F,$EA70,$EA71,$EA72,$EA73,$EA74,
$EA75,$EA76,$EA77,$EA78,$EA79,$EA7A,$EA7B,$EA7C,$EA7D,$EA7E,$EAA1,$EAA2,$EAA3,
$EAA4,$EAA5,$EAA6,$EAA7,$EAA8,$EAA9,$EAAA,$EAAB,$EAAC,$EAAD,$EAAE,$EAAF,$EAB0,
$EAB1,$EAB2,$EAB3,$EAB4,$EAB5,$EAB6,$EAB7,$EAB8,$EAB9,$EABA,$EABB,$EABC,$EABD,
$EABE,$EABF,$EAC0,$EAC1,$EAC2,$EAC3,$EAC4,$EAC5,$EAC6,$EAC7,$EAC8,$EAC9,$EACA,
$EACB,$EACC,$EACD,$EACE,$EACF,$EAD0,$EAD1,$EAD2,$EAD3,$EAD4,$EAD5,$EAD6,$EAD7,
$EAD8,$EAD9,$EADA,$EADB,$EADC,$EADD,$EADE,$EADF,$EAE0,$EAE1,$EAE2,$EAE3,$EAE4,
$EAE5,$EAE6,$EAE7,$EAE8,$EAE9,$EAEA,$EAEB,$EAEC,$EAED,$EAEE,$EAEF,$EAF0,$EAF1,
$EAF2,$EAF3,$EAF4,$EAF5,$EAF6,$EAF7,$EAF8,$EAF9,$EAFA,$EAFB,$EAFC,$EAFD,$EAFE,
$EB40,$EB41,$EB42,$EB43,$EB44,$EB45,$EB46,$EB47,$EB48,$EB49,$EB4A,$EB4B,$EB4C,
$EB4D,$EB4E,$EB4F,$EB50,$EB51,$EB52,$EB53,$EB54,$EB55,$EB56,$EB57,$EB58,$EB59,
$EB5A,$EB5B,$EB5C,$EB5D,$EB5E,$EB5F,$EB60,$EB61,$EB62,$EB63,$EB64,$EB65,$EB66,
$EB67,$EB68,$EB69,$EB6A,$EB6B,$EB6C,$EB6D,$EB6E,$EB6F,$EB70,$EB71,$EB72,$EB73,
$EB74,$EB75,$EB76,$EB77,$EB78,$EB79,$EB7A,$EB7B,$EB7C,$EB7D,$EB7E,$EBA1,$EBA2,
$EBA3,$EBA4,$EBA5,$EBA6,$EBA7,$EBA8,$EBA9,$EBAA,$EBAB,$EBAC,$EBAD,$EBAE,$EBAF,
$EBB0,$EBB1,$EBB2,$EBB3,$EBB4,$EBB5,$EBB6,$EBB7,$EBB8,$EBB9,$EBBA,$EBBB,$EBBC,
$EBBD,$EBBE,$EBBF,$EBC0,$EBC1,$EBC2,$EBC3,$EBC4,$EBC5,$EBC6,$EBC7,$EBC8,$EBC9,
$EBCA,$EBCB,$EBCC,$EBCD,$EBCE,$EBCF,$EBD0,$EBD1,$EBD2,$EBD3,$EBD4,$EBD5,$EBD6,
$EBD7,$EBD8,$EBD9,$EBDA,$EBDB,$EBDC,$EBDD,$EBDE,$EBDF,$EBE0,$EBE1,$EBE2,$EBE3,
$EBE4,$EBE5,$EBE6,$EBE7,$EBE8,$EBE9,$EBEA,$EBEB,$EBEC,$EBED,$EBEE,$EBEF,$EBF0,
$EBF1,$EBF2,$EBF3,$EBF4,$EBF5,$EBF6,$EBF7,$EBF8,$EBF9,$EBFA,$EBFB,$EBFC,$EBFD,
$EBFE,$EC40,$EC41,$EC42,$EC43,$EC44,$EC45,$EC46,$EC47,$EC48,$EC49,$EC4A,$EC4B,
$EC4C,$EC4D,$EC4E,$EC4F,$EC50,$EC51,$EC52,$EC53,$EC54,$EC55,$EC56,$EC57,$EC58,
$EC59,$EC5A,$EC5B,$EC5C,$EC5D,$EC5E,$EC5F,$EC60,$EC61,$EC62,$EC63,$EC64,$EC65,
$EC66,$EC67,$EC68,$EC69,$EC6A,$EC6B,$EC6C,$EC6D,$EC6E,$EC6F,$EC70,$EC71,$EC72,
$EC73,$EC74,$EC75,$EC76,$EC77,$EC78,$EC79,$EC7A,$EC7B,$EC7C,$EC7D,$EC7E,$ECA1,
$ECA2,$ECA3,$ECA4,$ECA5,$ECA6,$ECA7,$ECA8,$ECA9,$ECAA,$ECAB,$ECAC,$ECAD,$ECAE,
$ECAF,$ECB0,$ECB1,$ECB2,$ECB3,$ECB4,$ECB5,$ECB6,$ECB7,$ECB8,$ECB9,$ECBA,$ECBB,
$ECBC,$ECBD,$ECBE,$ECBF,$ECC0,$ECC1,$ECC2,$ECC3,$ECC4,$ECC5,$ECC6,$ECC7,$ECC8,
$ECC9,$ECCA,$ECCB,$ECCC,$ECCD,$ECCE,$ECCF,$ECD0,$ECD1,$ECD2,$ECD3,$ECD4,$ECD5,
$ECD6,$ECD7,$ECD8,$ECD9,$ECDA,$ECDB,$ECDC,$ECDD,$ECDE,$ECDF,$ECE0,$ECE1,$ECE2,
$ECE3,$ECE4,$ECE5,$ECE6,$ECE7,$ECE8,$ECE9,$ECEA,$ECEB,$ECEC,$ECED,$ECEE,$ECEF,
$ECF0,$ECF1,$ECF2,$ECF3,$ECF4,$ECF5,$ECF6,$ECF7,$ECF8,$ECF9,$ECFA,$ECFB,$ECFC,
$ECFD,$ECFE,$ED40,$ED41,$ED42,$ED43,$ED44,$ED45,$ED46,$ED47,$ED48,$ED49,$ED4A,
$ED4B,$ED4C,$ED4D,$ED4E,$ED4F,$ED50,$ED51,$ED52,$ED53,$ED54,$ED55,$ED56,$ED57,
$ED58,$ED59,$ED5A,$ED5B,$ED5C,$ED5D,$ED5E,$ED5F,$ED60,$ED61,$ED62,$ED63,$ED64,
$ED65,$ED66,$ED67,$ED68,$ED69,$ED6A,$ED6B,$ED6C,$ED6D,$ED6E,$ED6F,$ED70,$ED71,
$ED72,$ED73,$ED74,$ED75,$ED76,$ED77,$ED78,$ED79,$ED7A,$ED7B,$ED7C,$ED7D,$ED7E,
$EDA1,$EDA2,$EDA3,$EDA4,$EDA5,$EDA6,$EDA7,$EDA8,$EDA9,$EDAA,$EDAB,$EDAC,$EDAD,
$EDAE,$EDAF,$EDB0,$EDB1,$EDB2,$EDB3,$EDB4,$EDB5,$EDB6,$EDB7,$EDB8,$EDB9,$EDBA,
$EDBB,$EDBC,$EDBD,$EDBE,$EDBF,$EDC0,$EDC1,$EDC2,$EDC3,$EDC4,$EDC5,$EDC6,$EDC7,
$EDC8,$EDC9,$EDCA,$EDCB,$EDCC,$EDCD,$EDCE,$EDCF,$EDD0,$EDD1,$EDD2,$EDD3,$EDD4,
$EDD5,$EDD6,$EDD7,$EDD8,$EDD9,$EDDA,$EDDB,$EDDC,$EDDD,$EDDE,$EDDF,$EDE0,$EDE1,
$EDE2,$EDE3,$EDE4,$EDE5,$EDE6,$EDE7,$EDE8,$EDE9,$EDEA,$EDEB,$EDEC,$EDED,$EDEE,
$EDEF,$EDF0,$EDF1,$EDF2,$EDF3,$EDF4,$EDF5,$EDF6,$EDF7,$EDF8,$EDF9,$EDFA,$EDFB,
$EDFC,$EDFD,$EDFE,$EE40,$EE41,$EE42,$EE43,$EE44,$EE45,$EE46,$EE47,$EE48,$EE49,
$EE4A,$EE4B,$EE4C,$EE4D,$EE4E,$EE4F,$EE50,$EE51,$EE52,$EE53,$EE54,$EE55,$EE56,
$EE57,$EE58,$EE59,$EE5A,$EE5B,$EE5C,$EE5D,$EE5E,$EE5F,$EE60,$EE61,$EE62,$EE63,
$EE64,$EE65,$EE66,$EE67,$EE68,$EE69,$EE6A,$EE6B,$EE6C,$EE6D,$EE6E,$EE6F,$EE70,
$EE71,$EE72,$EE73,$EE74,$EE75,$EE76,$EE77,$EE78,$EE79,$EE7A,$EE7B,$EE7C,$EE7D,
$EE7E,$EEA1,$EEA2,$EEA3,$EEA4,$EEA5,$EEA6,$EEA7,$EEA8,$EEA9,$EEAA,$EEAB,$EEAC,
$EEAD,$EEAE,$EEAF,$EEB0,$EEB1,$EEB2,$EEB3,$EEB4,$EEB5,$EEB6,$EEB7,$EEB8,$EEB9,
$EEBA,$EEBB,$EEBC,$EEBD,$EEBE,$EEBF,$EEC0,$EEC1,$EEC2,$EEC3,$EEC4,$EEC5,$EEC6,
$EEC7,$EEC8,$EEC9,$EECA,$EECB,$EECC,$EECD,$EECE,$EECF,$EED0,$EED1,$EED2,$EED3,
$EED4,$EED5,$EED6,$EED7,$EED8,$EED9,$EEDA,$EEDB,$EEDC,$EEDD,$EEDE,$EEDF,$EEE0,
$EEE1,$EEE2,$EEE3,$EEE4,$EEE5,$EEE6,$EEE7,$EEE8,$EEE9,$EEEA,$EEEB,$EEEC,$EEED,
$EEEE,$EEEF,$EEF0,$EEF1,$EEF2,$EEF3,$EEF4,$EEF5,$EEF6,$EEF7,$EEF8,$EEF9,$EEFA,
$EEFB,$EEFC,$EEFD,$EEFE,$EF40,$EF41,$EF42,$EF43,$EF44,$EF45,$EF46,$EF47,$EF48,
$EF49,$EF4A,$EF4B,$EF4C,$EF4D,$EF4E,$EF4F,$EF50,$EF51,$EF52,$EF53,$EF54,$EF55,
$EF56,$EF57,$EF58,$EF59,$EF5A,$EF5B,$EF5C,$EF5D,$EF5E,$EF5F,$EF60,$EF61,$EF62,
$EF63,$EF64,$EF65,$EF66,$EF67,$EF68,$EF69,$EF6A,$EF6B,$EF6C,$EF6D,$EF6E,$EF6F,
$EF70,$EF71,$EF72,$EF73,$EF74,$EF75,$EF76,$EF77,$EF78,$EF79,$EF7A,$EF7B,$EF7C,
$EF7D,$EF7E,$EFA1,$EFA2,$EFA3,$EFA4,$EFA5,$EFA6,$EFA7,$EFA8,$EFA9,$EFAA,$EFAB,
$EFAC,$EFAD,$EFAE,$EFAF,$EFB0,$EFB1,$EFB2,$EFB3,$EFB4,$EFB5,$EFB6,$EFB7,$EFB8,
$EFB9,$EFBA,$EFBB,$EFBC,$EFBD,$EFBE,$EFBF,$EFC0,$EFC1,$EFC2,$EFC3,$EFC4,$EFC5,
$EFC6,$EFC7,$EFC8,$EFC9,$EFCA,$EFCB,$EFCC,$EFCD,$EFCE,$EFCF,$EFD0,$EFD1,$EFD2,
$EFD3,$EFD4,$EFD5,$EFD6,$EFD7,$EFD8,$EFD9,$EFDA,$EFDB,$EFDC,$EFDD,$EFDE,$EFDF,
$EFE0,$EFE1,$EFE2,$EFE3,$EFE4,$EFE5,$EFE6,$EFE7,$EFE8,$EFE9,$EFEA,$EFEB,$EFEC,
$EFED,$EFEE,$EFEF,$EFF0,$EFF1,$EFF2,$EFF3,$EFF4,$EFF5,$EFF6,$EFF7,$EFF8,$EFF9,
$EFFA,$EFFB,$EFFC,$EFFD,$EFFE,$F040,$F041,$F042,$F043,$F044,$F045,$F046,$F047,
$F048,$F049,$F04A,$F04B,$F04C,$F04D,$F04E,$F04F,$F050,$F051,$F052,$F053,$F054,
$F055,$F056,$F057,$F058,$F059,$F05A,$F05B,$F05C,$F05D,$F05E,$F05F,$F060,$F061,
$F062,$F063,$F064,$F065,$F066,$F067,$F068,$F069,$F06A,$F06B,$F06C,$F06D,$F06E,
$F06F,$F070,$F071,$F072,$F073,$F074,$F075,$F076,$F077,$F078,$F079,$F07A,$F07B,
$F07C,$F07D,$F07E,$F0A1,$F0A2,$F0A3,$F0A4,$F0A5,$F0A6,$F0A7,$F0A8,$F0A9,$F0AA,
$F0AB,$F0AC,$F0AD,$F0AE,$F0AF,$F0B0,$F0B1,$F0B2,$F0B3,$F0B4,$F0B5,$F0B6,$F0B7,
$F0B8,$F0B9,$F0BA,$F0BB,$F0BC,$F0BD,$F0BE,$F0BF,$F0C0,$F0C1,$F0C2,$F0C3,$F0C4,
$F0C5,$F0C6,$F0C7,$F0C8,$F0C9,$F0CA,$F0CB,$F0CC,$F0CD,$F0CE,$F0CF,$F0D0,$F0D1,
$F0D2,$F0D3,$F0D4,$F0D5,$F0D6,$F0D7,$F0D8,$F0D9,$F0DA,$F0DB,$F0DC,$F0DD,$F0DE,
$F0DF,$F0E0,$F0E1,$F0E2,$F0E3,$F0E4,$F0E5,$F0E6,$F0E7,$F0E8,$F0E9,$F0EA,$F0EB,
$F0EC,$F0ED,$F0EE,$F0EF,$F0F0,$F0F1,$F0F2,$F0F3,$F0F4,$F0F5,$F0F6,$F0F7,$F0F8,
$F0F9,$F0FA,$F0FB,$F0FC,$F0FD,$F0FE,$F140,$F141,$F142,$F143,$F144,$F145,$F146,
$F147,$F148,$F149,$F14A,$F14B,$F14C,$F14D,$F14E,$F14F,$F150,$F151,$F152,$F153,
$F154,$F155,$F156,$F157,$F158,$F159,$F15A,$F15B,$F15C,$F15D,$F15E,$F15F,$F160,
$F161,$F162,$F163,$F164,$F165,$F166,$F167,$F168,$F169,$F16A,$F16B,$F16C,$F16D,
$F16E,$F16F,$F170,$F171,$F172,$F173,$F174,$F175,$F176,$F177,$F178,$F179,$F17A,
$F17B,$F17C,$F17D,$F17E,$F1A1,$F1A2,$F1A3,$F1A4,$F1A5,$F1A6,$F1A7,$F1A8,$F1A9,
$F1AA,$F1AB,$F1AC,$F1AD,$F1AE,$F1AF,$F1B0,$F1B1,$F1B2,$F1B3,$F1B4,$F1B5,$F1B6,
$F1B7,$F1B8,$F1B9,$F1BA,$F1BB,$F1BC,$F1BD,$F1BE,$F1BF,$F1C0,$F1C1,$F1C2,$F1C3,
$F1C4,$F1C5,$F1C6,$F1C7,$F1C8,$F1C9,$F1CA,$F1CB,$F1CC,$F1CD,$F1CE,$F1CF,$F1D0,
$F1D1,$F1D2,$F1D3,$F1D4,$F1D5,$F1D6,$F1D7,$F1D8,$F1D9,$F1DA,$F1DB,$F1DC,$F1DD,
$F1DE,$F1DF,$F1E0,$F1E1,$F1E2,$F1E3,$F1E4,$F1E5,$F1E6,$F1E7,$F1E8,$F1E9,$F1EA,
$F1EB,$F1EC,$F1ED,$F1EE,$F1EF,$F1F0,$F1F1,$F1F2,$F1F3,$F1F4,$F1F5,$F1F6,$F1F7,
$F1F8,$F1F9,$F1FA,$F1FB,$F1FC,$F1FD,$F1FE,$F240,$F241,$F242,$F243,$F244,$F245,
$F246,$F247,$F248,$F249,$F24A,$F24B,$F24C,$F24D,$F24E,$F24F,$F250,$F251,$F252,
$F253,$F254,$F255,$F256,$F257,$F258,$F259,$F25A,$F25B,$F25C,$F25D,$F25E,$F25F,
$F260,$F261,$F262,$F263,$F264,$F265,$F266,$F267,$F268,$F269,$F26A,$F26B,$F26C,
$F26D,$F26E,$F26F,$F270,$F271,$F272,$F273,$F274,$F275,$F276,$F277,$F278,$F279,
$F27A,$F27B,$F27C,$F27D,$F27E,$F2A1,$F2A2,$F2A3,$F2A4,$F2A5,$F2A6,$F2A7,$F2A8,
$F2A9,$F2AA,$F2AB,$F2AC,$F2AD,$F2AE,$F2AF,$F2B0,$F2B1,$F2B2,$F2B3,$F2B4,$F2B5,
$F2B6,$F2B7,$F2B8,$F2B9,$F2BA,$F2BB,$F2BC,$F2BD,$F2BE,$F2BF,$F2C0,$F2C1,$F2C2,
$F2C3,$F2C4,$F2C5,$F2C6,$F2C7,$F2C8,$F2C9,$F2CA,$F2CB,$F2CC,$F2CD,$F2CE,$F2CF,
$F2D0,$F2D1,$F2D2,$F2D3,$F2D4,$F2D5,$F2D6,$F2D7,$F2D8,$F2D9,$F2DA,$F2DB,$F2DC,
$F2DD,$F2DE,$F2DF,$F2E0,$F2E1,$F2E2,$F2E3,$F2E4,$F2E5,$F2E6,$F2E7,$F2E8,$F2E9,
$F2EA,$F2EB,$F2EC,$F2ED,$F2EE,$F2EF,$F2F0,$F2F1,$F2F2,$F2F3,$F2F4,$F2F5,$F2F6,
$F2F7,$F2F8,$F2F9,$F2FA,$F2FB,$F2FC,$F2FD,$F2FE,$F340,$F341,$F342,$F343,$F344,
$F345,$F346,$F347,$F348,$F349,$F34A,$F34B,$F34C,$F34D,$F34E,$F34F,$F350,$F351,
$F352,$F353,$F354,$F355,$F356,$F357,$F358,$F359,$F35A,$F35B,$F35C,$F35D,$F35E,
$F35F,$F360,$F361,$F362,$F363,$F364,$F365,$F366,$F367,$F368,$F369,$F36A,$F36B,
$F36C,$F36D,$F36E,$F36F,$F370,$F371,$F372,$F373,$F374,$F375,$F376,$F377,$F378,
$F379,$F37A,$F37B,$F37C,$F37D,$F37E,$F3A1,$F3A2,$F3A3,$F3A4,$F3A5,$F3A6,$F3A7,
$F3A8,$F3A9,$F3AA,$F3AB,$F3AC,$F3AD,$F3AE,$F3AF,$F3B0,$F3B1,$F3B2,$F3B3,$F3B4,
$F3B5,$F3B6,$F3B7,$F3B8,$F3B9,$F3BA,$F3BB,$F3BC,$F3BD,$F3BE,$F3BF,$F3C0,$F3C1,
$F3C2,$F3C3,$F3C4,$F3C5,$F3C6,$F3C7,$F3C8,$F3C9,$F3CA,$F3CB,$F3CC,$F3CD,$F3CE,
$F3CF,$F3D0,$F3D1,$F3D2,$F3D3,$F3D4,$F3D5,$F3D6,$F3D7,$F3D8,$F3D9,$F3DA,$F3DB,
$F3DC,$F3DD,$F3DE,$F3DF,$F3E0,$F3E1,$F3E2,$F3E3,$F3E4,$F3E5,$F3E6,$F3E7,$F3E8,
$F3E9,$F3EA,$F3EB,$F3EC,$F3ED,$F3EE,$F3EF,$F3F0,$F3F1,$F3F2,$F3F3,$F3F4,$F3F5,
$F3F6,$F3F7,$F3F8,$F3F9,$F3FA,$F3FB,$F3FC,$F3FD,$F3FE,$F440,$F441,$F442,$F443,
$F444,$F445,$F446,$F447,$F448,$F449,$F44A,$F44B,$F44C,$F44D,$F44E,$F44F,$F450,
$F451,$F452,$F453,$F454,$F455,$F456,$F457,$F458,$F459,$F45A,$F45B,$F45C,$F45D,
$F45E,$F45F,$F460,$F461,$F462,$F463,$F464,$F465,$F466,$F467,$F468,$F469,$F46A,
$F46B,$F46C,$F46D,$F46E,$F46F,$F470,$F471,$F472,$F473,$F474,$F475,$F476,$F477,
$F478,$F479,$F47A,$F47B,$F47C,$F47D,$F47E,$F4A1,$F4A2,$F4A3,$F4A4,$F4A5,$F4A6,
$F4A7,$F4A8,$F4A9,$F4AA,$F4AB,$F4AC,$F4AD,$F4AE,$F4AF,$F4B0,$F4B1,$F4B2,$F4B3,
$F4B4,$F4B5,$F4B6,$F4B7,$F4B8,$F4B9,$F4BA,$F4BB,$F4BC,$F4BD,$F4BE,$F4BF,$F4C0,
$F4C1,$F4C2,$F4C3,$F4C4,$F4C5,$F4C6,$F4C7,$F4C8,$F4C9,$F4CA,$F4CB,$F4CC,$F4CD,
$F4CE,$F4CF,$F4D0,$F4D1,$F4D2,$F4D3,$F4D4,$F4D5,$F4D6,$F4D7,$F4D8,$F4D9,$F4DA,
$F4DB,$F4DC,$F4DD,$F4DE,$F4DF,$F4E0,$F4E1,$F4E2,$F4E3,$F4E4,$F4E5,$F4E6,$F4E7,
$F4E8,$F4E9,$F4EA,$F4EB,$F4EC,$F4ED,$F4EE,$F4EF,$F4F0,$F4F1,$F4F2,$F4F3,$F4F4,
$F4F5,$F4F6,$F4F7,$F4F8,$F4F9,$F4FA,$F4FB,$F4FC,$F4FD,$F4FE,$F540,$F541,$F542,
$F543,$F544,$F545,$F546,$F547,$F548,$F549,$F54A,$F54B,$F54C,$F54D,$F54E,$F54F,
$F550,$F551,$F552,$F553,$F554,$F555,$F556,$F557,$F558,$F559,$F55A,$F55B,$F55C,
$F55D,$F55E,$F55F,$F560,$F561,$F562,$F563,$F564,$F565,$F566,$F567,$F568,$F569,
$F56A,$F56B,$F56C,$F56D,$F56E,$F56F,$F570,$F571,$F572,$F573,$F574,$F575,$F576,
$F577,$F578,$F579,$F57A,$F57B,$F57C,$F57D,$F57E,$F5A1,$F5A2,$F5A3,$F5A4,$F5A5,
$F5A6,$F5A7,$F5A8,$F5A9,$F5AA,$F5AB,$F5AC,$F5AD,$F5AE,$F5AF,$F5B0,$F5B1,$F5B2,
$F5B3,$F5B4,$F5B5,$F5B6,$F5B7,$F5B8,$F5B9,$F5BA,$F5BB,$F5BC,$F5BD,$F5BE,$F5BF,
$F5C0,$F5C1,$F5C2,$F5C3,$F5C4,$F5C5,$F5C6,$F5C7,$F5C8,$F5C9,$F5CA,$F5CB,$F5CC,
$F5CD,$F5CE,$F5CF,$F5D0,$F5D1,$F5D2,$F5D3,$F5D4,$F5D5,$F5D6,$F5D7,$F5D8,$F5D9,
$F5DA,$F5DB,$F5DC,$F5DD,$F5DE,$F5DF,$F5E0,$F5E1,$F5E2,$F5E3,$F5E4,$F5E5,$F5E6,
$F5E7,$F5E8,$F5E9,$F5EA,$F5EB,$F5EC,$F5ED,$F5EE,$F5EF,$F5F0,$F5F1,$F5F2,$F5F3,
$F5F4,$F5F5,$F5F6,$F5F7,$F5F8,$F5F9,$F5FA,$F5FB,$F5FC,$F5FD,$F5FE,$F640,$F641,
$F642,$F643,$F644,$F645,$F646,$F647,$F648,$F649,$F64A,$F64B,$F64C,$F64D,$F64E,
$F64F,$F650,$F651,$F652,$F653,$F654,$F655,$F656,$F657,$F658,$F659,$F65A,$F65B,
$F65C,$F65D,$F65E,$F65F,$F660,$F661,$F662,$F663,$F664,$F665,$F666,$F667,$F668,
$F669,$F66A,$F66B,$F66C,$F66D,$F66E,$F66F,$F670,$F671,$F672,$F673,$F674,$F675,
$F676,$F677,$F678,$F679,$F67A,$F67B,$F67C,$F67D,$F67E,$F6A1,$F6A2,$F6A3,$F6A4,
$F6A5,$F6A6,$F6A7,$F6A8,$F6A9,$F6AA,$F6AB,$F6AC,$F6AD,$F6AE,$F6AF,$F6B0,$F6B1,
$F6B2,$F6B3,$F6B4,$F6B5,$F6B6,$F6B7,$F6B8,$F6B9,$F6BA,$F6BB,$F6BC,$F6BD,$F6BE,
$F6BF,$F6C0,$F6C1,$F6C2,$F6C3,$F6C4,$F6C5,$F6C6,$F6C7,$F6C8,$F6C9,$F6CA,$F6CB,
$F6CC,$F6CD,$F6CE,$F6CF,$F6D0,$F6D1,$F6D2,$F6D3,$F6D4,$F6D5,$F6D6,$F6D7,$F6D8,
$F6D9,$F6DA,$F6DB,$F6DC,$F6DD,$F6DE,$F6DF,$F6E0,$F6E1,$F6E2,$F6E3,$F6E4,$F6E5,
$F6E6,$F6E7,$F6E8,$F6E9,$F6EA,$F6EB,$F6EC,$F6ED,$F6EE,$F6EF,$F6F0,$F6F1,$F6F2,
$F6F3,$F6F4,$F6F5,$F6F6,$F6F7,$F6F8,$F6F9,$F6FA,$F6FB,$F6FC,$F6FD,$F6FE,$F740,
$F741,$F742,$F743,$F744,$F745,$F746,$F747,$F748,$F749,$F74A,$F74B,$F74C,$F74D,
$F74E,$F74F,$F750,$F751,$F752,$F753,$F754,$F755,$F756,$F757,$F758,$F759,$F75A,
$F75B,$F75C,$F75D,$F75E,$F75F,$F760,$F761,$F762,$F763,$F764,$F765,$F766,$F767,
$F768,$F769,$F76A,$F76B,$F76C,$F76D,$F76E,$F76F,$F770,$F771,$F772,$F773,$F774,
$F775,$F776,$F777,$F778,$F779,$F77A,$F77B,$F77C,$F77D,$F77E,$F7A1,$F7A2,$F7A3,
$F7A4,$F7A5,$F7A6,$F7A7,$F7A8,$F7A9,$F7AA,$F7AB,$F7AC,$F7AD,$F7AE,$F7AF,$F7B0,
$F7B1,$F7B2,$F7B3,$F7B4,$F7B5,$F7B6,$F7B7,$F7B8,$F7B9,$F7BA,$F7BB,$F7BC,$F7BD,
$F7BE,$F7BF,$F7C0,$F7C1,$F7C2,$F7C3,$F7C4,$F7C5,$F7C6,$F7C7,$F7C8,$F7C9,$F7CA,
$F7CB,$F7CC,$F7CD,$F7CE,$F7CF,$F7D0,$F7D1,$F7D2,$F7D3,$F7D4,$F7D5,$F7D6,$F7D7,
$F7D8,$F7D9,$F7DA,$F7DB,$F7DC,$F7DD,$F7DE,$F7DF,$F7E0,$F7E1,$F7E2,$F7E3,$F7E4,
$F7E5,$F7E6,$F7E7,$F7E8,$F7E9,$F7EA,$F7EB,$F7EC,$F7ED,$F7EE,$F7EF,$F7F0,$F7F1,
$F7F2,$F7F3,$F7F4,$F7F5,$F7F6,$F7F7,$F7F8,$F7F9,$F7FA,$F7FB,$F7FC,$F7FD,$F7FE,
$F840,$F841,$F842,$F843,$F844,$F845,$F846,$F847,$F848,$F849,$F84A,$F84B,$F84C,
$F84D,$F84E,$F84F,$F850,$F851,$F852,$F853,$F854,$F855,$F856,$F857,$F858,$F859,
$F85A,$F85B,$F85C,$F85D,$F85E,$F85F,$F860,$F861,$F862,$F863,$F864,$F865,$F866,
$F867,$F868,$F869,$F86A,$F86B,$F86C,$F86D,$F86E,$F86F,$F870,$F871,$F872,$F873,
$F874,$F875,$F876,$F877,$F878,$F879,$F87A,$F87B,$F87C,$F87D,$F87E,$F8A1,$F8A2,
$F8A3,$F8A4,$F8A5,$F8A6,$F8A7,$F8A8,$F8A9,$F8AA,$F8AB,$F8AC,$F8AD,$F8AE,$F8AF,
$F8B0,$F8B1,$F8B2,$F8B3,$F8B4,$F8B5,$F8B6,$F8B7,$F8B8,$F8B9,$F8BA,$F8BB,$F8BC,
$F8BD,$F8BE,$F8BF,$F8C0,$F8C1,$F8C2,$F8C3,$F8C4,$F8C5,$F8C6,$F8C7,$F8C8,$F8C9,
$F8CA,$F8CB,$F8CC,$F8CD,$F8CE,$F8CF,$F8D0,$F8D1,$F8D2,$F8D3,$F8D4,$F8D5,$F8D6,
$F8D7,$F8D8,$F8D9,$F8DA,$F8DB,$F8DC,$F8DD,$F8DE,$F8DF,$F8E0,$F8E1,$F8E2,$F8E3,
$F8E4,$F8E5,$F8E6,$F8E7,$F8E8,$F8E9,$F8EA,$F8EB,$F8EC,$F8ED,$F8EE,$F8EF,$F8F0,
$F8F1,$F8F2,$F8F3,$F8F4,$F8F5,$F8F6,$F8F7,$F8F8,$F8F9,$F8FA,$F8FB,$F8FC,$F8FD,
$F8FE,$F940,$F941,$F942,$F943,$F944,$F945,$F946,$F947,$F948,$F949,$F94A,$F94B,
$F94C,$F94D,$F94E,$F94F,$F950,$F951,$F952,$F953,$F954,$F955,$F956,$F957,$F958,
$F959,$F95A,$F95B,$F95C,$F95D,$F95E,$F95F,$F960,$F961,$F962,$F963,$F964,$F965,
$F966,$F967,$F968,$F969,$F96A,$F96B,$F96C,$F96D,$F96E,$F96F,$F970,$F971,$F972,
$F973,$F974,$F975,$F976,$F977,$F978,$F979,$F97A,$F97B,$F97C,$F97D,$F97E,$F9A1,
$F9A2,$F9A3,$F9A4,$F9A5,$F9A6,$F9A7,$F9A8,$F9A9,$F9AA,$F9AB,$F9AC,$F9AD,$F9AE,
$F9AF,$F9B0,$F9B1,$F9B2,$F9B3,$F9B4,$F9B5,$F9B6,$F9B7,$F9B8,$F9B9,$F9BA,$F9BB,
$F9BC,$F9BD,$F9BE,$F9BF,$F9C0,$F9C1,$F9C2,$F9C3,$F9C4,$F9C5,$F9C6,$F9C7,$F9C8,
$F9C9,$F9CA,$F9CB,$F9CC,$F9CD,$F9CE,$F9CF,$F9D0,$F9D1,$F9D2,$F9D3,$F9D4,$F9D5,
$F9D6,$F9D7,$F9D8,$F9D9,$F9DA,$F9DB,$F9DC,$F9DD,$F9DE,$F9DF,$F9E0,$F9E1,$F9E2,
$F9E3,$F9E4,$F9E5,$F9E6,$F9E7,$F9E8,$F9E9,$F9EA,$F9EB,$F9EC,$F9ED,$F9EE,$F9EF,
$F9F0,$F9F1,$F9F2,$F9F3,$F9F4,$F9F5,$F9F6,$F9F7,$F9F8,$F9F9,$F9FA,$F9FB,$F9FC,
$F9FD,$F9FE);

const Uni950C: CP950Arr =
($0000,$0001,$0002,$0003,$0004,$0005,$0006,$0007,$0008,$0009,$000A,$000B,$000C,
$000D,$000E,$000F,$0010,$0011,$0012,$0013,$0014,$0015,$0016,$0017,$0018,$0019,
$001A,$001B,$001C,$001D,$001E,$001F,$0020,$0021,$0022,$0023,$0024,$0025,$0026,
$0027,$0028,$0029,$002A,$002B,$002C,$002D,$002E,$002F,$0030,$0031,$0032,$0033,
$0034,$0035,$0036,$0037,$0038,$0039,$003A,$003B,$003C,$003D,$003E,$003F,$0040,
$0041,$0042,$0043,$0044,$0045,$0046,$0047,$0048,$0049,$004A,$004B,$004C,$004D,
$004E,$004F,$0050,$0051,$0052,$0053,$0054,$0055,$0056,$0057,$0058,$0059,$005A,
$005B,$005C,$005D,$005E,$005F,$0060,$0061,$0062,$0063,$0064,$0065,$0066,$0067,
$0068,$0069,$006A,$006B,$006C,$006D,$006E,$006F,$0070,$0071,$0072,$0073,$0074,
$0075,$0076,$0077,$0078,$0079,$007A,$007B,$007C,$007D,$007E,$007F,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
$3000,$FF0C,$3001,$3002,$FF0E,$2027,$FF1B,$FF1A,$FF1F,$FF01,$FE30,$2026,$2025,
$FE50,$FE51,$FE52,$00B7,$FE54,$FE55,$FE56,$FE57,$FF5C,$2013,$FE31,$2014,$FE33,
$2574,$FE34,$FE4F,$FF08,$FF09,$FE35,$FE36,$FF5B,$FF5D,$FE37,$FE38,$3014,$3015,
$FE39,$FE3A,$3010,$3011,$FE3B,$FE3C,$300A,$300B,$FE3D,$FE3E,$3008,$3009,$FE3F,
$FE40,$300C,$300D,$FE41,$FE42,$300E,$300F,$FE43,$FE44,$FE59,$FE5A,$FE5B,$FE5C,
$FE5D,$FE5E,$2018,$2019,$201C,$201D,$301D,$301E,$2035,$2032,$FF03,$FF06,$FF0A,
$203B,$00A7,$3003,$25CB,$25CF,$25B3,$25B2,$25CE,$2606,$2605,$25C7,$25C6,$25A1,
$25A0,$25BD,$25BC,$32A3,$2105,$00AF,$FFE3,$FF3F,$02CD,$FE49,$FE4A,$FE4D,$FE4E,
$FE4B,$FE4C,$FE5F,$FE60,$FE61,$FF0B,$FF0D,$00D7,$00F7,$00B1,$221A,$FF1C,$FF1E,
$FF1D,$2266,$2267,$2260,$221E,$2252,$2261,$FE62,$FE63,$FE64,$FE65,$FE66,$FF5E,
$2229,$222A,$22A5,$2220,$221F,$22BF,$33D2,$33D1,$222B,$222E,$2235,$2234,$2640,
$2642,$2295,$2299,$2191,$2193,$2190,$2192,$2196,$2197,$2199,$2198,$2225,$2223,
$FF0F,$FF3C,$2215,$FE68,$FF04,$FFE5,$3012,$FFE0,$FFE1,$FF05,$FF20,$2103,$2109,
$FE69,$FE6A,$FE6B,$33D5,$339C,$339D,$339E,$33CE,$33A1,$338E,$338F,$33C4,$00B0,
$5159,$515B,$515E,$515D,$5161,$5163,$55E7,$74E9,$7CCE,$2581,$2582,$2583,$2584,
$2585,$2586,$2587,$2588,$258F,$258E,$258D,$258C,$258B,$258A,$2589,$253C,$2534,
$252C,$2524,$251C,$2594,$2500,$2502,$2595,$250C,$2510,$2514,$2518,$256D,$256E,
$2570,$256F,$2550,$255E,$256A,$2561,$25E2,$25E3,$25E5,$25E4,$2571,$2572,$2573,
$FF10,$FF11,$FF12,$FF13,$FF14,$FF15,$FF16,$FF17,$FF18,$FF19,$2160,$2161,$2162,
$2163,$2164,$2165,$2166,$2167,$2168,$2169,$3021,$3022,$3023,$3024,$3025,$3026,
$3027,$3028,$3029,$5341,$5344,$5345,$FF21,$FF22,$FF23,$FF24,$FF25,$FF26,$FF27,
$FF28,$FF29,$FF2A,$FF2B,$FF2C,$FF2D,$FF2E,$FF2F,$FF30,$FF31,$FF32,$FF33,$FF34,
$FF35,$FF36,$FF37,$FF38,$FF39,$FF3A,$FF41,$FF42,$FF43,$FF44,$FF45,$FF46,$FF47,
$FF48,$FF49,$FF4A,$FF4B,$FF4C,$FF4D,$FF4E,$FF4F,$FF50,$FF51,$FF52,$FF53,$FF54,
$FF55,$FF56,$FF57,$FF58,$FF59,$FF5A,$0391,$0392,$0393,$0394,$0395,$0396,$0397,
$0398,$0399,$039A,$039B,$039C,$039D,$039E,$039F,$03A0,$03A1,$03A3,$03A4,$03A5,
$03A6,$03A7,$03A8,$03A9,$03B1,$03B2,$03B3,$03B4,$03B5,$03B6,$03B7,$03B8,$03B9,
$03BA,$03BB,$03BC,$03BD,$03BE,$03BF,$03C0,$03C1,$03C3,$03C4,$03C5,$03C6,$03C7,
$03C8,$03C9,$3105,$3106,$3107,$3108,$3109,$310A,$310B,$310C,$310D,$310E,$310F,
$3110,$3111,$3112,$3113,$3114,$3115,$3116,$3117,$3118,$3119,$311A,$311B,$311C,
$311D,$311E,$311F,$3120,$3121,$3122,$3123,$3124,$3125,$3126,$3127,$3128,$3129,
$02D9,$02C9,$02CA,$02C7,$02CB,$20AC,$4E00,$4E59,$4E01,$4E03,$4E43,$4E5D,$4E86,
$4E8C,$4EBA,$513F,$5165,$516B,$51E0,$5200,$5201,$529B,$5315,$5341,$535C,$53C8,
$4E09,$4E0B,$4E08,$4E0A,$4E2B,$4E38,$51E1,$4E45,$4E48,$4E5F,$4E5E,$4E8E,$4EA1,
$5140,$5203,$52FA,$5343,$53C9,$53E3,$571F,$58EB,$5915,$5927,$5973,$5B50,$5B51,
$5B53,$5BF8,$5C0F,$5C22,$5C38,$5C71,$5DDD,$5DE5,$5DF1,$5DF2,$5DF3,$5DFE,$5E72,
$5EFE,$5F0B,$5F13,$624D,$4E11,$4E10,$4E0D,$4E2D,$4E30,$4E39,$4E4B,$5C39,$4E88,
$4E91,$4E95,$4E92,$4E94,$4EA2,$4EC1,$4EC0,$4EC3,$4EC6,$4EC7,$4ECD,$4ECA,$4ECB,
$4EC4,$5143,$5141,$5167,$516D,$516E,$516C,$5197,$51F6,$5206,$5207,$5208,$52FB,
$52FE,$52FF,$5316,$5339,$5348,$5347,$5345,$535E,$5384,$53CB,$53CA,$53CD,$58EC,
$5929,$592B,$592A,$592D,$5B54,$5C11,$5C24,$5C3A,$5C6F,$5DF4,$5E7B,$5EFF,$5F14,
$5F15,$5FC3,$6208,$6236,$624B,$624E,$652F,$6587,$6597,$65A4,$65B9,$65E5,$66F0,
$6708,$6728,$6B20,$6B62,$6B79,$6BCB,$6BD4,$6BDB,$6C0F,$6C34,$706B,$722A,$7236,
$723B,$7247,$7259,$725B,$72AC,$738B,$4E19,$4E16,$4E15,$4E14,$4E18,$4E3B,$4E4D,
$4E4F,$4E4E,$4EE5,$4ED8,$4ED4,$4ED5,$4ED6,$4ED7,$4EE3,$4EE4,$4ED9,$4EDE,$5145,
$5144,$5189,$518A,$51AC,$51F9,$51FA,$51F8,$520A,$52A0,$529F,$5305,$5306,$5317,
$531D,$4EDF,$534A,$5349,$5361,$5360,$536F,$536E,$53BB,$53EF,$53E4,$53F3,$53EC,
$53EE,$53E9,$53E8,$53FC,$53F8,$53F5,$53EB,$53E6,$53EA,$53F2,$53F1,$53F0,$53E5,
$53ED,$53FB,$56DB,$56DA,$5916,$592E,$5931,$5974,$5976,$5B55,$5B83,$5C3C,$5DE8,
$5DE7,$5DE6,$5E02,$5E03,$5E73,$5E7C,$5F01,$5F18,$5F17,$5FC5,$620A,$6253,$6254,
$6252,$6251,$65A5,$65E6,$672E,$672C,$672A,$672B,$672D,$6B63,$6BCD,$6C11,$6C10,
$6C38,$6C41,$6C40,$6C3E,$72AF,$7384,$7389,$74DC,$74E6,$7518,$751F,$7528,$7529,
$7530,$7531,$7532,$7533,$758B,$767D,$76AE,$76BF,$76EE,$77DB,$77E2,$77F3,$793A,
$79BE,$7A74,$7ACB,$4E1E,$4E1F,$4E52,$4E53,$4E69,$4E99,$4EA4,$4EA6,$4EA5,$4EFF,
$4F09,$4F19,$4F0A,$4F15,$4F0D,$4F10,$4F11,$4F0F,$4EF2,$4EF6,$4EFB,$4EF0,$4EF3,
$4EFD,$4F01,$4F0B,$5149,$5147,$5146,$5148,$5168,$5171,$518D,$51B0,$5217,$5211,
$5212,$520E,$5216,$52A3,$5308,$5321,$5320,$5370,$5371,$5409,$540F,$540C,$540A,
$5410,$5401,$540B,$5404,$5411,$540D,$5408,$5403,$540E,$5406,$5412,$56E0,$56DE,
$56DD,$5733,$5730,$5728,$572D,$572C,$572F,$5729,$5919,$591A,$5937,$5938,$5984,
$5978,$5983,$597D,$5979,$5982,$5981,$5B57,$5B58,$5B87,$5B88,$5B85,$5B89,$5BFA,
$5C16,$5C79,$5DDE,$5E06,$5E76,$5E74,$5F0F,$5F1B,$5FD9,$5FD6,$620E,$620C,$620D,
$6210,$6263,$625B,$6258,$6536,$65E9,$65E8,$65EC,$65ED,$66F2,$66F3,$6709,$673D,
$6734,$6731,$6735,$6B21,$6B64,$6B7B,$6C16,$6C5D,$6C57,$6C59,$6C5F,$6C60,$6C50,
$6C55,$6C61,$6C5B,$6C4D,$6C4E,$7070,$725F,$725D,$767E,$7AF9,$7C73,$7CF8,$7F36,
$7F8A,$7FBD,$8001,$8003,$800C,$8012,$8033,$807F,$8089,$808B,$808C,$81E3,$81EA,
$81F3,$81FC,$820C,$821B,$821F,$826E,$8272,$827E,$866B,$8840,$884C,$8863,$897F,
$9621,$4E32,$4EA8,$4F4D,$4F4F,$4F47,$4F57,$4F5E,$4F34,$4F5B,$4F55,$4F30,$4F50,
$4F51,$4F3D,$4F3A,$4F38,$4F43,$4F54,$4F3C,$4F46,$4F63,$4F5C,$4F60,$4F2F,$4F4E,
$4F36,$4F59,$4F5D,$4F48,$4F5A,$514C,$514B,$514D,$5175,$51B6,$51B7,$5225,$5224,
$5229,$522A,$5228,$52AB,$52A9,$52AA,$52AC,$5323,$5373,$5375,$541D,$542D,$541E,
$543E,$5426,$544E,$5427,$5446,$5443,$5433,$5448,$5442,$541B,$5429,$544A,$5439,
$543B,$5438,$542E,$5435,$5436,$5420,$543C,$5440,$5431,$542B,$541F,$542C,$56EA,
$56F0,$56E4,$56EB,$574A,$5751,$5740,$574D,$5747,$574E,$573E,$5750,$574F,$573B,
$58EF,$593E,$599D,$5992,$59A8,$599E,$59A3,$5999,$5996,$598D,$59A4,$5993,$598A,
$59A5,$5B5D,$5B5C,$5B5A,$5B5B,$5B8C,$5B8B,$5B8F,$5C2C,$5C40,$5C41,$5C3F,$5C3E,
$5C90,$5C91,$5C94,$5C8C,$5DEB,$5E0C,$5E8F,$5E87,$5E8A,$5EF7,$5F04,$5F1F,$5F64,
$5F62,$5F77,$5F79,$5FD8,$5FCC,$5FD7,$5FCD,$5FF1,$5FEB,$5FF8,$5FEA,$6212,$6211,
$6284,$6297,$6296,$6280,$6276,$6289,$626D,$628A,$627C,$627E,$6279,$6273,$6292,
$626F,$6298,$626E,$6295,$6293,$6291,$6286,$6539,$653B,$6538,$65F1,$66F4,$675F,
$674E,$674F,$6750,$6751,$675C,$6756,$675E,$6749,$6746,$6760,$6753,$6757,$6B65,
$6BCF,$6C42,$6C5E,$6C99,$6C81,$6C88,$6C89,$6C85,$6C9B,$6C6A,$6C7A,$6C90,$6C70,
$6C8C,$6C68,$6C96,$6C92,$6C7D,$6C83,$6C72,$6C7E,$6C74,$6C86,$6C76,$6C8D,$6C94,
$6C98,$6C82,$7076,$707C,$707D,$7078,$7262,$7261,$7260,$72C4,$72C2,$7396,$752C,
$752B,$7537,$7538,$7682,$76EF,$77E3,$79C1,$79C0,$79BF,$7A76,$7CFB,$7F55,$8096,
$8093,$809D,$8098,$809B,$809A,$80B2,$826F,$8292,$828B,$828D,$898B,$89D2,$8A00,
$8C37,$8C46,$8C55,$8C9D,$8D64,$8D70,$8DB3,$8EAB,$8ECA,$8F9B,$8FB0,$8FC2,$8FC6,
$8FC5,$8FC4,$5DE1,$9091,$90A2,$90AA,$90A6,$90A3,$9149,$91C6,$91CC,$9632,$962E,
$9631,$962A,$962C,$4E26,$4E56,$4E73,$4E8B,$4E9B,$4E9E,$4EAB,$4EAC,$4F6F,$4F9D,
$4F8D,$4F73,$4F7F,$4F6C,$4F9B,$4F8B,$4F86,$4F83,$4F70,$4F75,$4F88,$4F69,$4F7B,
$4F96,$4F7E,$4F8F,$4F91,$4F7A,$5154,$5152,$5155,$5169,$5177,$5176,$5178,$51BD,
$51FD,$523B,$5238,$5237,$523A,$5230,$522E,$5236,$5241,$52BE,$52BB,$5352,$5354,
$5353,$5351,$5366,$5377,$5378,$5379,$53D6,$53D4,$53D7,$5473,$5475,$5496,$5478,
$5495,$5480,$547B,$5477,$5484,$5492,$5486,$547C,$5490,$5471,$5476,$548C,$549A,
$5462,$5468,$548B,$547D,$548E,$56FA,$5783,$5777,$576A,$5769,$5761,$5766,$5764,
$577C,$591C,$5949,$5947,$5948,$5944,$5954,$59BE,$59BB,$59D4,$59B9,$59AE,$59D1,
$59C6,$59D0,$59CD,$59CB,$59D3,$59CA,$59AF,$59B3,$59D2,$59C5,$5B5F,$5B64,$5B63,
$5B97,$5B9A,$5B98,$5B9C,$5B99,$5B9B,$5C1A,$5C48,$5C45,$5C46,$5CB7,$5CA1,$5CB8,
$5CA9,$5CAB,$5CB1,$5CB3,$5E18,$5E1A,$5E16,$5E15,$5E1B,$5E11,$5E78,$5E9A,$5E97,
$5E9C,$5E95,$5E96,$5EF6,$5F26,$5F27,$5F29,$5F80,$5F81,$5F7F,$5F7C,$5FDD,$5FE0,
$5FFD,$5FF5,$5FFF,$600F,$6014,$602F,$6035,$6016,$602A,$6015,$6021,$6027,$6029,
$602B,$601B,$6216,$6215,$623F,$623E,$6240,$627F,$62C9,$62CC,$62C4,$62BF,$62C2,
$62B9,$62D2,$62DB,$62AB,$62D3,$62D4,$62CB,$62C8,$62A8,$62BD,$62BC,$62D0,$62D9,
$62C7,$62CD,$62B5,$62DA,$62B1,$62D8,$62D6,$62D7,$62C6,$62AC,$62CE,$653E,$65A7,
$65BC,$65FA,$6614,$6613,$660C,$6606,$6602,$660E,$6600,$660F,$6615,$660A,$6607,
$670D,$670B,$676D,$678B,$6795,$6771,$679C,$6773,$6777,$6787,$679D,$6797,$676F,
$6770,$677F,$6789,$677E,$6790,$6775,$679A,$6793,$677C,$676A,$6772,$6B23,$6B66,
$6B67,$6B7F,$6C13,$6C1B,$6CE3,$6CE8,$6CF3,$6CB1,$6CCC,$6CE5,$6CB3,$6CBD,$6CBE,
$6CBC,$6CE2,$6CAB,$6CD5,$6CD3,$6CB8,$6CC4,$6CB9,$6CC1,$6CAE,$6CD7,$6CC5,$6CF1,
$6CBF,$6CBB,$6CE1,$6CDB,$6CCA,$6CAC,$6CEF,$6CDC,$6CD6,$6CE0,$7095,$708E,$7092,
$708A,$7099,$722C,$722D,$7238,$7248,$7267,$7269,$72C0,$72CE,$72D9,$72D7,$72D0,
$73A9,$73A8,$739F,$73AB,$73A5,$753D,$759D,$7599,$759A,$7684,$76C2,$76F2,$76F4,
$77E5,$77FD,$793E,$7940,$7941,$79C9,$79C8,$7A7A,$7A79,$7AFA,$7CFE,$7F54,$7F8C,
$7F8B,$8005,$80BA,$80A5,$80A2,$80B1,$80A1,$80AB,$80A9,$80B4,$80AA,$80AF,$81E5,
$81FE,$820D,$82B3,$829D,$8299,$82AD,$82BD,$829F,$82B9,$82B1,$82AC,$82A5,$82AF,
$82B8,$82A3,$82B0,$82BE,$82B7,$864E,$8671,$521D,$8868,$8ECB,$8FCE,$8FD4,$8FD1,
$90B5,$90B8,$90B1,$90B6,$91C7,$91D1,$9577,$9580,$961C,$9640,$963F,$963B,$9644,
$9642,$96B9,$96E8,$9752,$975E,$4E9F,$4EAD,$4EAE,$4FE1,$4FB5,$4FAF,$4FBF,$4FE0,
$4FD1,$4FCF,$4FDD,$4FC3,$4FB6,$4FD8,$4FDF,$4FCA,$4FD7,$4FAE,$4FD0,$4FC4,$4FC2,
$4FDA,$4FCE,$4FDE,$4FB7,$5157,$5192,$5191,$51A0,$524E,$5243,$524A,$524D,$524C,
$524B,$5247,$52C7,$52C9,$52C3,$52C1,$530D,$5357,$537B,$539A,$53DB,$54AC,$54C0,
$54A8,$54CE,$54C9,$54B8,$54A6,$54B3,$54C7,$54C2,$54BD,$54AA,$54C1,$54C4,$54C8,
$54AF,$54AB,$54B1,$54BB,$54A9,$54A7,$54BF,$56FF,$5782,$578B,$57A0,$57A3,$57A2,
$57CE,$57AE,$5793,$5955,$5951,$594F,$594E,$5950,$59DC,$59D8,$59FF,$59E3,$59E8,
$5A03,$59E5,$59EA,$59DA,$59E6,$5A01,$59FB,$5B69,$5BA3,$5BA6,$5BA4,$5BA2,$5BA5,
$5C01,$5C4E,$5C4F,$5C4D,$5C4B,$5CD9,$5CD2,$5DF7,$5E1D,$5E25,$5E1F,$5E7D,$5EA0,
$5EA6,$5EFA,$5F08,$5F2D,$5F65,$5F88,$5F85,$5F8A,$5F8B,$5F87,$5F8C,$5F89,$6012,
$601D,$6020,$6025,$600E,$6028,$604D,$6070,$6068,$6062,$6046,$6043,$606C,$606B,
$606A,$6064,$6241,$62DC,$6316,$6309,$62FC,$62ED,$6301,$62EE,$62FD,$6307,$62F1,
$62F7,$62EF,$62EC,$62FE,$62F4,$6311,$6302,$653F,$6545,$65AB,$65BD,$65E2,$6625,
$662D,$6620,$6627,$662F,$661F,$6628,$6631,$6624,$66F7,$67FF,$67D3,$67F1,$67D4,
$67D0,$67EC,$67B6,$67AF,$67F5,$67E9,$67EF,$67C4,$67D1,$67B4,$67DA,$67E5,$67B8,
$67CF,$67DE,$67F3,$67B0,$67D9,$67E2,$67DD,$67D2,$6B6A,$6B83,$6B86,$6BB5,$6BD2,
$6BD7,$6C1F,$6CC9,$6D0B,$6D32,$6D2A,$6D41,$6D25,$6D0C,$6D31,$6D1E,$6D17,$6D3B,
$6D3D,$6D3E,$6D36,$6D1B,$6CF5,$6D39,$6D27,$6D38,$6D29,$6D2E,$6D35,$6D0E,$6D2B,
$70AB,$70BA,$70B3,$70AC,$70AF,$70AD,$70B8,$70AE,$70A4,$7230,$7272,$726F,$7274,
$72E9,$72E0,$72E1,$73B7,$73CA,$73BB,$73B2,$73CD,$73C0,$73B3,$751A,$752D,$754F,
$754C,$754E,$754B,$75AB,$75A4,$75A5,$75A2,$75A3,$7678,$7686,$7687,$7688,$76C8,
$76C6,$76C3,$76C5,$7701,$76F9,$76F8,$7709,$770B,$76FE,$76FC,$7707,$77DC,$7802,
$7814,$780C,$780D,$7946,$7949,$7948,$7947,$79B9,$79BA,$79D1,$79D2,$79CB,$7A7F,
$7A81,$7AFF,$7AFD,$7C7D,$7D02,$7D05,$7D00,$7D09,$7D07,$7D04,$7D06,$7F38,$7F8E,
$7FBF,$8004,$8010,$800D,$8011,$8036,$80D6,$80E5,$80DA,$80C3,$80C4,$80CC,$80E1,
$80DB,$80CE,$80DE,$80E4,$80DD,$81F4,$8222,$82E7,$8303,$8305,$82E3,$82DB,$82E6,
$8304,$82E5,$8302,$8309,$82D2,$82D7,$82F1,$8301,$82DC,$82D4,$82D1,$82DE,$82D3,
$82DF,$82EF,$8306,$8650,$8679,$867B,$867A,$884D,$886B,$8981,$89D4,$8A08,$8A02,
$8A03,$8C9E,$8CA0,$8D74,$8D73,$8DB4,$8ECD,$8ECC,$8FF0,$8FE6,$8FE2,$8FEA,$8FE5,
$8FED,$8FEB,$8FE4,$8FE8,$90CA,$90CE,$90C1,$90C3,$914B,$914A,$91CD,$9582,$9650,
$964B,$964C,$964D,$9762,$9769,$97CB,$97ED,$97F3,$9801,$98A8,$98DB,$98DF,$9996,
$9999,$4E58,$4EB3,$500C,$500D,$5023,$4FEF,$5026,$5025,$4FF8,$5029,$5016,$5006,
$503C,$501F,$501A,$5012,$5011,$4FFA,$5000,$5014,$5028,$4FF1,$5021,$500B,$5019,
$5018,$4FF3,$4FEE,$502D,$502A,$4FFE,$502B,$5009,$517C,$51A4,$51A5,$51A2,$51CD,
$51CC,$51C6,$51CB,$5256,$525C,$5254,$525B,$525D,$532A,$537F,$539F,$539D,$53DF,
$54E8,$5510,$5501,$5537,$54FC,$54E5,$54F2,$5506,$54FA,$5514,$54E9,$54ED,$54E1,
$5509,$54EE,$54EA,$54E6,$5527,$5507,$54FD,$550F,$5703,$5704,$57C2,$57D4,$57CB,
$57C3,$5809,$590F,$5957,$5958,$595A,$5A11,$5A18,$5A1C,$5A1F,$5A1B,$5A13,$59EC,
$5A20,$5A23,$5A29,$5A25,$5A0C,$5A09,$5B6B,$5C58,$5BB0,$5BB3,$5BB6,$5BB4,$5BAE,
$5BB5,$5BB9,$5BB8,$5C04,$5C51,$5C55,$5C50,$5CED,$5CFD,$5CFB,$5CEA,$5CE8,$5CF0,
$5CF6,$5D01,$5CF4,$5DEE,$5E2D,$5E2B,$5EAB,$5EAD,$5EA7,$5F31,$5F92,$5F91,$5F90,
$6059,$6063,$6065,$6050,$6055,$606D,$6069,$606F,$6084,$609F,$609A,$608D,$6094,
$608C,$6085,$6096,$6247,$62F3,$6308,$62FF,$634E,$633E,$632F,$6355,$6342,$6346,
$634F,$6349,$633A,$6350,$633D,$632A,$632B,$6328,$634D,$634C,$6548,$6549,$6599,
$65C1,$65C5,$6642,$6649,$664F,$6643,$6652,$664C,$6645,$6641,$66F8,$6714,$6715,
$6717,$6821,$6838,$6848,$6846,$6853,$6839,$6842,$6854,$6829,$68B3,$6817,$684C,
$6851,$683D,$67F4,$6850,$6840,$683C,$6843,$682A,$6845,$6813,$6818,$6841,$6B8A,
$6B89,$6BB7,$6C23,$6C27,$6C28,$6C26,$6C24,$6CF0,$6D6A,$6D95,$6D88,$6D87,$6D66,
$6D78,$6D77,$6D59,$6D93,$6D6C,$6D89,$6D6E,$6D5A,$6D74,$6D69,$6D8C,$6D8A,$6D79,
$6D85,$6D65,$6D94,$70CA,$70D8,$70E4,$70D9,$70C8,$70CF,$7239,$7279,$72FC,$72F9,
$72FD,$72F8,$72F7,$7386,$73ED,$7409,$73EE,$73E0,$73EA,$73DE,$7554,$755D,$755C,
$755A,$7559,$75BE,$75C5,$75C7,$75B2,$75B3,$75BD,$75BC,$75B9,$75C2,$75B8,$768B,
$76B0,$76CA,$76CD,$76CE,$7729,$771F,$7720,$7728,$77E9,$7830,$7827,$7838,$781D,
$7834,$7837,$7825,$782D,$7820,$781F,$7832,$7955,$7950,$7960,$795F,$7956,$795E,
$795D,$7957,$795A,$79E4,$79E3,$79E7,$79DF,$79E6,$79E9,$79D8,$7A84,$7A88,$7AD9,
$7B06,$7B11,$7C89,$7D21,$7D17,$7D0B,$7D0A,$7D20,$7D22,$7D14, $7D10,$7D15,$7D1A,
$7D1C,$7D0D,$7D19,$7D1B,$7F3A,$7F5F,$7F94,$7FC5,$7FC1,$8006,$8018,$8015,$8019,
$8017,$803D,$803F,$80F1,$8102,$80F0,$8105,$80ED,$80F4,$8106,$80F8,$80F3,$8108,
$80FD,$810A,$80FC,$80EF,$81ED,$81EC,$8200,$8210,$822A,$822B,$8228,$822C,$82BB,
$832B,$8352,$8354,$834A,$8338,$8350,$8349,$8335,$8334,$834F,$8332,$8339,$8336,
$8317,$8340,$8331,$8328,$8343,$8654,$868A,$86AA,$8693,$86A4,$86A9,$868C,$86A3,
$869C,$8870,$8877,$8881,$8882,$887D,$8879,$8A18,$8A10,$8A0E,$8A0C,$8A15,$8A0A,
$8A17,$8A13,$8A16,$8A0F,$8A11,$8C48,$8C7A,$8C79,$8CA1,$8CA2,$8D77,$8EAC,$8ED2,
$8ED4,$8ECF,$8FB1,$9001,$9006,$8FF7,$9000,$8FFA,$8FF4,$9003,$8FFD,$9005,$8FF8,
$9095,$90E1,$90DD,$90E2,$9152,$914D,$914C,$91D8,$91DD,$91D7,$91DC,$91D9,$9583,
$9662,$9663,$9661,$965B,$965D,$9664,$9658,$965E,$96BB,$98E2,$99AC,$9AA8,$9AD8,
$9B25,$9B32,$9B3C,$4E7E,$507A,$507D,$505C,$5047,$5043,$504C,$505A,$5049,$5065,
$5076,$504E,$5055,$5075,$5074,$5077,$504F,$500F,$506F,$506D,$515C,$5195,$51F0,
$526A,$526F,$52D2,$52D9,$52D8,$52D5,$5310,$530F,$5319,$533F,$5340,$533E,$53C3,
$66FC,$5546,$556A,$5566,$5544,$555E,$5561,$5543,$554A,$5531,$5556,$554F,$5555,
$552F,$5564,$5538,$552E,$555C,$552C,$5563,$5533,$5541,$5557,$5708,$570B,$5709,
$57DF,$5805,$580A,$5806,$57E0,$57E4,$57FA,$5802,$5835,$57F7,$57F9,$5920,$5962,
$5A36,$5A41,$5A49,$5A66,$5A6A,$5A40,$5A3C,$5A62,$5A5A,$5A46,$5A4A,$5B70,$5BC7,
$5BC5,$5BC4,$5BC2,$5BBF,$5BC6,$5C09,$5C08,$5C07,$5C60,$5C5C,$5C5D,$5D07,$5D06,
$5D0E,$5D1B,$5D16,$5D22,$5D11,$5D29,$5D14,$5D19,$5D24,$5D27,$5D17,$5DE2,$5E38,
$5E36,$5E33,$5E37,$5EB7,$5EB8,$5EB6,$5EB5,$5EBE,$5F35,$5F37,$5F57,$5F6C,$5F69,
$5F6B,$5F97,$5F99,$5F9E,$5F98,$5FA1,$5FA0,$5F9C,$607F,$60A3,$6089,$60A0,$60A8,
$60CB,$60B4,$60E6,$60BD,$60C5,$60BB,$60B5,$60DC,$60BC,$60D8,$60D5,$60C6,$60DF,
$60B8,$60DA,$60C7,$621A,$621B,$6248,$63A0,$63A7,$6372,$6396,$63A2,$63A5,$6377,
$6367,$6398,$63AA,$6371,$63A9,$6389,$6383,$639B,$636B,$63A8,$6384,$6388,$6399,
$63A1,$63AC,$6392,$638F,$6380,$637B,$6369,$6368,$637A,$655D,$6556,$6551,$6559,
$6557,$555F,$654F,$6558,$6555,$6554,$659C,$659B,$65AC,$65CF,$65CB,$65CC,$65CE,
$665D,$665A,$6664,$6668,$6666,$665E,$66F9,$52D7,$671B,$6881,$68AF,$68A2,$6893,
$68B5,$687F,$6876,$68B1,$68A7,$6897,$68B0,$6883,$68C4,$68AD,$6886,$6885,$6894,
$689D,$68A8,$689F,$68A1,$6882,$6B32,$6BBA,$6BEB,$6BEC,$6C2B,$6D8E,$6DBC,$6DF3,
$6DD9,$6DB2,$6DE1,$6DCC,$6DE4,$6DFB,$6DFA,$6E05,$6DC7,$6DCB,$6DAF,$6DD1,$6DAE,
$6DDE,$6DF9,$6DB8,$6DF7,$6DF5,$6DC5,$6DD2,$6E1A,$6DB5,$6DDA,$6DEB,$6DD8,$6DEA,
$6DF1,$6DEE,$6DE8,$6DC6,$6DC4,$6DAA,$6DEC,$6DBF,$6DE6,$70F9,$7109,$710A,$70FD,
$70EF,$723D,$727D,$7281,$731C,$731B,$7316,$7313,$7319,$7387,$7405,$740A,$7403,
$7406,$73FE,$740D,$74E0,$74F6,$74F7,$751C,$7522,$7565,$7566,$7562,$7570,$758F,
$75D4,$75D5,$75B5,$75CA,$75CD,$768E,$76D4,$76D2,$76DB,$7737,$773E,$773C,$7736,
$7738,$773A,$786B,$7843,$784E,$7965,$7968,$796D,$79FB,$7A92,$7A95,$7B20,$7B28,
$7B1B,$7B2C,$7B26,$7B19,$7B1E,$7B2E,$7C92,$7C97,$7C95,$7D46,$7D43,$7D71,$7D2E,
$7D39,$7D3C,$7D40,$7D30,$7D33,$7D44,$7D2F,$7D42,$7D32,$7D31,$7F3D,$7F9E,$7F9A,
$7FCC,$7FCE,$7FD2,$801C,$804A,$8046,$812F,$8116,$8123,$812B,$8129,$8130,$8124,
$8202,$8235,$8237,$8236,$8239,$838E,$839E,$8398,$8378,$83A2,$8396,$83BD,$83AB,
$8392,$838A,$8393,$8389,$83A0,$8377,$837B,$837C,$8386,$83A7,$8655,$5F6A,$86C7,
$86C0,$86B6,$86C4,$86B5,$86C6,$86CB,$86B1,$86AF,$86C9,$8853,$889E,$8888,$88AB,
$8892,$8896,$888D,$888B,$8993,$898F,$8A2A,$8A1D,$8A23,$8A25,$8A31,$8A2D,$8A1F,
$8A1B,$8A22,$8C49,$8C5A,$8CA9,$8CAC,$8CAB,$8CA8,$8CAA,$8CA7,$8D67,$8D66,$8DBE,
$8DBA,$8EDB,$8EDF,$9019,$900D,$901A,$9017,$9023,$901F,$901D,$9010,$9015,$901E,
$9020,$900F,$9022,$9016,$901B,$9014,$90E8,$90ED,$90FD,$9157,$91CE,$91F5,$91E6,
$91E3,$91E7,$91ED,$91E9,$9589,$966A,$9675,$9673,$9678,$9670,$9674,$9676,$9677,
$966C,$96C0,$96EA,$96E9,$7AE0,$7ADF,$9802,$9803,$9B5A,$9CE5,$9E75,$9E7F,$9EA5,
$9EBB,$50A2,$508D,$5085,$5099,$5091,$5080,$5096,$5098,$509A,$6700,$51F1,$5272,
$5274,$5275,$5269,$52DE,$52DD,$52DB,$535A,$53A5,$557B,$5580,$55A7,$557C,$558A,
$559D,$5598,$5582,$559C,$55AA,$5594,$5587,$558B,$5583,$55B3,$55AE,$559F,$553E,
$55B2,$559A,$55BB,$55AC,$55B1,$557E,$5589,$55AB,$5599,$570D,$582F,$582A,$5834,
$5824,$5830,$5831,$5821,$581D,$5820,$58F9,$58FA,$5960,$5A77,$5A9A,$5A7F,$5A92,
$5A9B,$5AA7,$5B73,$5B71,$5BD2,$5BCC,$5BD3,$5BD0,$5C0A,$5C0B,$5C31,$5D4C,$5D50,
$5D34,$5D47,$5DFD,$5E45,$5E3D,$5E40,$5E43,$5E7E,$5ECA,$5EC1,$5EC2,$5EC4,$5F3C,
$5F6D,$5FA9,$5FAA,$5FA8,$60D1,$60E1,$60B2,$60B6,$60E0,$611C,$6123,$60FA,$6115,
$60F0,$60FB,$60F4,$6168,$60F1,$610E,$60F6,$6109,$6100,$6112,$621F,$6249,$63A3,
$638C,$63CF,$63C0,$63E9,$63C9,$63C6,$63CD,$63D2,$63E3,$63D0,$63E1,$63D6,$63ED,
$63EE,$6376,$63F4,$63EA,$63DB,$6452,$63DA,$63F9,$655E,$6566,$6562,$6563,$6591,
$6590,$65AF,$666E,$6670,$6674,$6676,$666F,$6691,$667A,$667E,$6677,$66FE,$66FF,
$671F,$671D,$68FA,$68D5,$68E0,$68D8,$68D7,$6905,$68DF,$68F5,$68EE,$68E7,$68F9,
$68D2,$68F2,$68E3,$68CB,$68CD,$690D,$6912,$690E,$68C9,$68DA,$696E,$68FB,$6B3E,
$6B3A,$6B3D,$6B98,$6B96,$6BBC,$6BEF,$6C2E,$6C2F,$6C2C,$6E2F,$6E38,$6E54,$6E21,
$6E32,$6E67,$6E4A,$6E20,$6E25,$6E23,$6E1B,$6E5B,$6E58,$6E24,$6E56,$6E6E,$6E2D,
$6E26,$6E6F,$6E34,$6E4D,$6E3A,$6E2C,$6E43,$6E1D,$6E3E,$6ECB,$6E89,$6E19,$6E4E,
$6E63,$6E44,$6E72,$6E69,$6E5F,$7119,$711A,$7126,$7130,$7121,$7136,$716E,$711C,
$724C,$7284,$7280,$7336,$7325,$7334,$7329,$743A,$742A,$7433,$7422,$7425,$7435,
$7436,$7434,$742F,$741B,$7426,$7428,$7525,$7526,$756B,$756A,$75E2,$75DB,$75E3,
$75D9,$75D8,$75DE,$75E0,$767B,$767C,$7696,$7693,$76B4,$76DC,$774F,$77ED,$785D,
$786C,$786F,$7A0D,$7A08,$7A0B,$7A05,$7A00,$7A98,$7A97,$7A96,$7AE5,$7AE3,$7B49,
$7B56,$7B46,$7B50,$7B52,$7B54,$7B4D,$7B4B,$7B4F,$7B51,$7C9F,$7CA5,$7D5E,$7D50,
$7D68,$7D55,$7D2B,$7D6E,$7D72,$7D61,$7D66,$7D62,$7D70,$7D73,$5584,$7FD4,$7FD5,
$800B,$8052,$8085,$8155,$8154,$814B,$8151,$814E,$8139,$8146,$813E,$814C,$8153,
$8174,$8212,$821C,$83E9,$8403,$83F8,$840D,$83E0,$83C5,$840B,$83C1,$83EF,$83F1,
$83F4,$8457,$840A,$83F0,$840C,$83CC,$83FD,$83F2,$83CA,$8438,$840E,$8404,$83DC,
$8407,$83D4,$83DF,$865B,$86DF,$86D9,$86ED,$86D4,$86DB,$86E4,$86D0,$86DE,$8857,
$88C1,$88C2,$88B1,$8983,$8996,$8A3B,$8A60,$8A55,$8A5E,$8A3C,$8A41,$8A54,$8A5B,
$8A50,$8A46,$8A34,$8A3A,$8A36,$8A56,$8C61,$8C82,$8CAF,$8CBC,$8CB3,$8CBD,$8CC1,
$8CBB,$8CC0,$8CB4,$8CB7,$8CB6,$8CBF,$8CB8,$8D8A,$8D85,$8D81,$8DCE,$8DDD,$8DCB,
$8DDA,$8DD1,$8DCC,$8DDB,$8DC6,$8EFB,$8EF8,$8EFC,$8F9C,$902E,$9035,$9031,$9038,
$9032,$9036,$9102,$90F5,$9109,$90FE,$9163,$9165,$91CF,$9214,$9215,$9223,$9209,
$921E,$920D,$9210,$9207,$9211,$9594,$958F,$958B,$9591,$9593,$9592,$958E,$968A,
$968E,$968B,$967D,$9685,$9686,$968D,$9672,$9684,$96C1,$96C5,$96C4,$96C6,$96C7,
$96EF,$96F2,$97CC,$9805,$9806,$9808,$98E7,$98EA,$98EF,$98E9,$98F2,$98ED,$99AE,
$99AD,$9EC3,$9ECD,$9ED1,$4E82,$50AD,$50B5,$50B2,$50B3,$50C5,$50BE,$50AC,$50B7,
$50BB,$50AF,$50C7,$527F,$5277,$527D,$52DF,$52E6,$52E4,$52E2,$52E3,$532F,$55DF,
$55E8,$55D3,$55E6,$55CE,$55DC,$55C7,$55D1,$55E3,$55E4,$55EF,$55DA,$55E1,$55C5,
$55C6,$55E5,$55C9,$5712,$5713,$585E,$5851,$5858,$5857,$585A,$5854,$586B,$584C,
$586D,$584A,$5862,$5852,$584B,$5967,$5AC1,$5AC9,$5ACC,$5ABE,$5ABD,$5ABC,$5AB3,
$5AC2,$5AB2,$5D69,$5D6F,$5E4C,$5E79,$5EC9,$5EC8,$5F12,$5F59,$5FAC,$5FAE,$611A,
$610F,$6148,$611F,$60F3,$611B,$60F9,$6101,$6108,$614E,$614C,$6144,$614D,$613E,
$6134,$6127,$610D,$6106,$6137,$6221,$6222,$6413,$643E,$641E,$642A,$642D,$643D,
$642C,$640F,$641C,$6414,$640D,$6436,$6416,$6417,$6406,$656C,$659F,$65B0,$6697,
$6689,$6687,$6688,$6696,$6684,$6698,$668D,$6703,$6994,$696D,$695A,$6977,$6960,
$6954,$6975,$6930,$6982,$694A,$6968,$696B,$695E,$6953,$6979,$6986,$695D,$6963,
$695B,$6B47,$6B72,$6BC0,$6BBF,$6BD3,$6BFD,$6EA2,$6EAF,$6ED3,$6EB6,$6EC2,$6E90,
$6E9D,$6EC7,$6EC5,$6EA5,$6E98,$6EBC,$6EBA,$6EAB,$6ED1,$6E96,$6E9C,$6EC4,$6ED4,
$6EAA,$6EA7,$6EB4,$714E,$7159,$7169,$7164,$7149,$7167,$715C,$716C,$7166,$714C,
$7165,$715E,$7146,$7168,$7156,$723A,$7252,$7337,$7345,$733F,$733E,$746F,$745A,
$7455,$745F,$745E,$7441,$743F,$7459,$745B,$745C,$7576,$7578,$7600,$75F0,$7601,
$75F2,$75F1,$75FA,$75FF,$75F4,$75F3,$76DE,$76DF,$775B,$776B,$7766,$775E,$7763,
$7779,$776A,$776C,$775C,$7765,$7768,$7762,$77EE,$788E,$78B0,$7897,$7898,$788C,
$7889,$787C,$7891,$7893,$787F,$797A,$797F,$7981,$842C,$79BD,$7A1C,$7A1A,$7A20,
$7A14,$7A1F,$7A1E,$7A9F,$7AA0,$7B77,$7BC0,$7B60,$7B6E,$7B67,$7CB1,$7CB3,$7CB5,
$7D93,$7D79,$7D91,$7D81,$7D8F,$7D5B,$7F6E,$7F69,$7F6A,$7F72,$7FA9,$7FA8,$7FA4,
$8056,$8058,$8086,$8084,$8171,$8170,$8178,$8165,$816E,$8173,$816B,$8179,$817A,
$8166,$8205,$8247,$8482,$8477,$843D,$8431,$8475,$8466,$846B,$8449,$846C,$845B,
$843C,$8435,$8461,$8463,$8469,$846D,$8446,$865E,$865C,$865F,$86F9,$8713,$8708,
$8707,$8700,$86FE,$86FB,$8702,$8703,$8706,$870A,$8859,$88DF,$88D4,$88D9,$88DC,
$88D8,$88DD,$88E1,$88CA,$88D5,$88D2,$899C,$89E3,$8A6B,$8A72,$8A73,$8A66,$8A69,
$8A70,$8A87,$8A7C,$8A63,$8AA0,$8A71,$8A85,$8A6D,$8A62,$8A6E,$8A6C,$8A79,$8A7B,
$8A3E,$8A68,$8C62,$8C8A,$8C89,$8CCA,$8CC7,$8CC8,$8CC4,$8CB2,$8CC3,$8CC2,$8CC5,
$8DE1,$8DDF,$8DE8,$8DEF,$8DF3,$8DFA,$8DEA,$8DE4,$8DE6,$8EB2,$8F03,$8F09,$8EFE,
$8F0A,$8F9F,$8FB2,$904B,$904A,$9053,$9042,$9054,$903C,$9055,$9050,$9047,$904F,
$904E,$904D,$9051,$903E,$9041,$9112,$9117,$916C,$916A,$9169,$91C9,$9237,$9257,
$9238,$923D,$9240,$923E,$925B,$924B,$9264,$9251,$9234,$9249,$924D,$9245,$9239,
$923F,$925A,$9598,$9698,$9694,$9695,$96CD,$96CB,$96C9,$96CA,$96F7,$96FB,$96F9,
$96F6,$9756,$9774,$9776,$9810,$9811,$9813,$980A,$9812,$980C,$98FC,$98F4,$98FD,
$98FE,$99B3,$99B1,$99B4,$9AE1,$9CE9,$9E82,$9F0E,$9F13,$9F20,$50E7,$50EE,$50E5,
$50D6,$50ED,$50DA,$50D5,$50CF,$50D1,$50F1,$50CE,$50E9,$5162,$51F3,$5283,$5282,
$5331,$53AD,$55FE,$5600,$561B,$5617,$55FD,$5614,$5606,$5609,$560D,$560E,$55F7,
$5616,$561F,$5608,$5610,$55F6,$5718,$5716,$5875,$587E,$5883,$5893,$588A,$5879,
$5885,$587D,$58FD,$5925,$5922,$5924,$596A,$5969,$5AE1,$5AE6,$5AE9,$5AD7,$5AD6,
$5AD8,$5AE3,$5B75,$5BDE,$5BE7,$5BE1,$5BE5,$5BE6,$5BE8,$5BE2,$5BE4,$5BDF,$5C0D,
$5C62,$5D84,$5D87,$5E5B,$5E63,$5E55,$5E57,$5E54,$5ED3,$5ED6,$5F0A,$5F46,$5F70,
$5FB9,$6147,$613F,$614B,$6177,$6162,$6163,$615F,$615A,$6158,$6175,$622A,$6487,
$6458,$6454,$64A4,$6478,$645F,$647A,$6451,$6467,$6434,$646D,$647B,$6572,$65A1,
$65D7,$65D6,$66A2,$66A8,$669D,$699C,$69A8,$6995,$69C1,$69AE,$69D3,$69CB,$699B,
$69B7,$69BB,$69AB,$69B4,$69D0,$69CD,$69AD,$69CC,$69A6,$69C3,$69A3,$6B49,$6B4C,
$6C33,$6F33,$6F14,$6EFE,$6F13,$6EF4,$6F29,$6F3E,$6F20,$6F2C,$6F0F,$6F02,$6F22,
$6EFF,$6EEF,$6F06,$6F31,$6F38,$6F32,$6F23,$6F15,$6F2B,$6F2F,$6F88,$6F2A,$6EEC,
$6F01,$6EF2,$6ECC,$6EF7,$7194,$7199,$717D,$718A,$7184,$7192,$723E,$7292,$7296,
$7344,$7350,$7464,$7463,$746A,$7470,$746D,$7504,$7591,$7627,$760D,$760B,$7609,
$7613,$76E1,$76E3,$7784,$777D,$777F,$7761,$78C1,$789F,$78A7,$78B3,$78A9,$78A3,
$798E,$798F,$798D,$7A2E,$7A31,$7AAA,$7AA9,$7AED,$7AEF,$7BA1,$7B95,$7B8B,$7B75,
$7B97,$7B9D,$7B94,$7B8F,$7BB8,$7B87,$7B84,$7CB9,$7CBD,$7CBE,$7DBB,$7DB0,$7D9C,
$7DBD,$7DBE,$7DA0,$7DCA,$7DB4,$7DB2,$7DB1,$7DBA,$7DA2,$7DBF,$7DB5,$7DB8,$7DAD,
$7DD2,$7DC7,$7DAC,$7F70,$7FE0,$7FE1,$7FDF,$805E,$805A,$8087,$8150,$8180,$818F,
$8188,$818A,$817F,$8182,$81E7,$81FA,$8207,$8214,$821E,$824B,$84C9,$84BF,$84C6,
$84C4,$8499,$849E,$84B2,$849C,$84CB,$84B8,$84C0,$84D3,$8490,$84BC,$84D1,$84CA,
$873F,$871C,$873B,$8722,$8725,$8734,$8718,$8755,$8737,$8729,$88F3,$8902,$88F4,
$88F9,$88F8,$88FD,$88E8,$891A,$88EF,$8AA6,$8A8C,$8A9E,$8AA3,$8A8D,$8AA1,$8A93,
$8AA4,$8AAA,$8AA5,$8AA8,$8A98,$8A91,$8A9A,$8AA7,$8C6A,$8C8D,$8C8C,$8CD3,$8CD1,
$8CD2,$8D6B,$8D99,$8D95,$8DFC,$8F14,$8F12,$8F15,$8F13,$8FA3,$9060,$9058,$905C,
$9063,$9059,$905E,$9062,$905D,$905B,$9119,$9118,$911E,$9175,$9178,$9177,$9174,
$9278,$9280,$9285,$9298,$9296,$927B,$9293,$929C,$92A8,$927C,$9291,$95A1,$95A8,
$95A9,$95A3,$95A5,$95A4,$9699,$969C,$969B,$96CC,$96D2,$9700,$977C,$9785,$97F6,
$9817,$9818,$98AF,$98B1,$9903,$9905,$990C,$9909,$99C1,$9AAF,$9AB0,$9AE6,$9B41,
$9B42,$9CF4,$9CF6,$9CF3,$9EBC,$9F3B,$9F4A,$5104,$5100,$50FB,$50F5,$50F9,$5102,
$5108,$5109,$5105,$51DC,$5287,$5288,$5289,$528D,$528A,$52F0,$53B2,$562E,$563B,
$5639,$5632,$563F,$5634,$5629,$5653,$564E,$5657,$5674,$5636,$562F,$5630,$5880,
$589F,$589E,$58B3,$589C,$58AE,$58A9,$58A6,$596D,$5B09,$5AFB,$5B0B,$5AF5,$5B0C,
$5B08,$5BEE,$5BEC,$5BE9,$5BEB,$5C64,$5C65,$5D9D,$5D94,$5E62,$5E5F,$5E61,$5EE2,
$5EDA,$5EDF,$5EDD,$5EE3,$5EE0,$5F48,$5F71,$5FB7,$5FB5,$6176,$6167,$616E,$615D,
$6155,$6182,$617C,$6170,$616B,$617E,$61A7,$6190,$61AB,$618E,$61AC,$619A,$61A4,
$6194,$61AE,$622E,$6469,$646F,$6479,$649E,$64B2,$6488,$6490,$64B0,$64A5,$6493,
$6495,$64A9,$6492,$64AE,$64AD,$64AB,$649A,$64AC,$6499,$64A2,$64B3,$6575,$6577,
$6578,$66AE,$66AB,$66B4,$66B1,$6A23,$6A1F,$69E8,$6A01,$6A1E,$6A19,$69FD,$6A21,
$6A13,$6A0A,$69F3,$6A02,$6A05,$69ED,$6A11,$6B50,$6B4E,$6BA4,$6BC5,$6BC6,$6F3F,
$6F7C,$6F84,$6F51,$6F66,$6F54,$6F86,$6F6D,$6F5B,$6F78,$6F6E,$6F8E,$6F7A,$6F70,
$6F64,$6F97,$6F58,$6ED5,$6F6F,$6F60,$6F5F,$719F,$71AC,$71B1,$71A8,$7256,$729B,
$734E,$7357,$7469,$748B,$7483,$747E,$7480,$757F,$7620,$7629,$761F,$7624,$7626,
$7621,$7622,$769A,$76BA,$76E4,$778E,$7787,$778C,$7791,$778B,$78CB,$78C5,$78BA,
$78CA,$78BE,$78D5,$78BC,$78D0,$7A3F,$7A3C,$7A40,$7A3D,$7A37,$7A3B,$7AAF,$7AAE,
$7BAD,$7BB1,$7BC4,$7BB4,$7BC6,$7BC7,$7BC1,$7BA0,$7BCC,$7CCA,$7DE0,$7DF4,$7DEF,
$7DFB,$7DD8,$7DEC,$7DDD,$7DE8,$7DE3,$7DDA,$7DDE,$7DE9,$7D9E,$7DD9,$7DF2,$7DF9,
$7F75,$7F77,$7FAF,$7FE9,$8026,$819B,$819C,$819D,$81A0,$819A,$8198,$8517,$853D,
$851A,$84EE,$852C,$852D,$8513,$8511,$8523,$8521,$8514,$84EC,$8525,$84FF,$8506,
$8782,$8774,$8776,$8760,$8766,$8778,$8768,$8759,$8757,$874C,$8753,$885B,$885D,
$8910,$8907,$8912,$8913,$8915,$890A,$8ABC,$8AD2,$8AC7,$8AC4,$8A95,$8ACB,$8AF8,
$8AB2,$8AC9,$8AC2,$8ABF,$8AB0,$8AD6,$8ACD,$8AB6,$8AB9,$8ADB,$8C4C,$8C4E,$8C6C,
$8CE0,$8CDE,$8CE6,$8CE4,$8CEC,$8CED,$8CE2,$8CE3,$8CDC,$8CEA,$8CE1,$8D6D,$8D9F,
$8DA3,$8E2B,$8E10,$8E1D,$8E22,$8E0F,$8E29,$8E1F,$8E21,$8E1E,$8EBA,$8F1D,$8F1B,
$8F1F,$8F29,$8F26,$8F2A,$8F1C,$8F1E,$8F25,$9069,$906E,$9068,$906D,$9077,$9130,
$912D,$9127,$9131,$9187,$9189,$918B,$9183,$92C5,$92BB,$92B7,$92EA,$92AC,$92E4,
$92C1,$92B3,$92BC,$92D2,$92C7,$92F0,$92B2,$95AD,$95B1,$9704,$9706,$9707,$9709,
$9760,$978D,$978B,$978F,$9821,$982B,$981C,$98B3,$990A,$9913,$9912,$9918,$99DD,
$99D0,$99DF,$99DB,$99D1,$99D5,$99D2,$99D9,$9AB7,$9AEE,$9AEF,$9B27,$9B45,$9B44,
$9B77,$9B6F,$9D06,$9D09,$9D03,$9EA9,$9EBE,$9ECE,$58A8,$9F52,$5112,$5118,$5114,
$5110,$5115,$5180,$51AA,$51DD,$5291,$5293,$52F3,$5659,$566B,$5679,$5669,$5664,
$5678,$566A,$5668,$5665,$5671,$566F,$566C,$5662,$5676,$58C1,$58BE,$58C7,$58C5,
$596E,$5B1D,$5B34,$5B78,$5BF0,$5C0E,$5F4A,$61B2,$6191,$61A9,$618A,$61CD,$61B6,
$61BE,$61CA,$61C8,$6230,$64C5,$64C1,$64CB,$64BB,$64BC,$64DA,$64C4,$64C7,$64C2,
$64CD,$64BF,$64D2,$64D4,$64BE,$6574,$66C6,$66C9,$66B9,$66C4,$66C7,$66B8,$6A3D,
$6A38,$6A3A,$6A59,$6A6B,$6A58,$6A39,$6A44,$6A62,$6A61,$6A4B,$6A47,$6A35,$6A5F,
$6A48,$6B59,$6B77,$6C05,$6FC2,$6FB1,$6FA1,$6FC3,$6FA4,$6FC1,$6FA7,$6FB3,$6FC0,
$6FB9,$6FB6,$6FA6,$6FA0,$6FB4,$71BE,$71C9,$71D0,$71D2,$71C8,$71D5,$71B9,$71CE,
$71D9,$71DC,$71C3,$71C4,$7368,$749C,$74A3,$7498,$749F,$749E,$74E2,$750C,$750D,
$7634,$7638,$763A,$76E7,$76E5,$77A0,$779E,$779F,$77A5,$78E8, $78DA,$78EC,$78E7,
$79A6,$7A4D,$7A4E,$7A46,$7A4C,$7A4B,$7ABA,$7BD9,$7C11,$7BC9,$7BE4,$7BDB,$7BE1,
$7BE9,$7BE6,$7CD5,$7CD6,$7E0A,$7E11,$7E08,$7E1B,$7E23,$7E1E,$7E1D,$7E09,$7E10,
$7F79,$7FB2,$7FF0,$7FF1,$7FEE,$8028,$81B3,$81A9,$81A8,$81FB,$8208,$8258,$8259,
$854A,$8559,$8548,$8568,$8569,$8543,$8549,$856D,$856A,$855E,$8783,$879F,$879E,
$87A2,$878D,$8861,$892A,$8932,$8925,$892B,$8921,$89AA,$89A6,$8AE6,$8AFA,$8AEB,
$8AF1,$8B00,$8ADC,$8AE7,$8AEE,$8AFE,$8B01,$8B02,$8AF7,$8AED,$8AF3,$8AF6,$8AFC,
$8C6B,$8C6D,$8C93,$8CF4,$8E44,$8E31,$8E34,$8E42,$8E39,$8E35,$8F3B,$8F2F,$8F38,
$8F33,$8FA8,$8FA6,$9075,$9074,$9078,$9072,$907C,$907A,$9134,$9192,$9320,$9336,
$92F8,$9333,$932F,$9322,$92FC,$932B,$9304,$931A,$9310,$9326,$9321,$9315,$932E,
$9319,$95BB,$96A7,$96A8,$96AA,$96D5,$970E,$9711,$9716,$970D,$9713,$970F,$975B,
$975C,$9766,$9798,$9830,$9838,$983B,$9837,$982D,$9839,$9824,$9910,$9928,$991E,
$991B,$9921,$991A,$99ED,$99E2,$99F1,$9AB8,$9ABC,$9AFB,$9AED,$9B28,$9B91,$9D15,
$9D23,$9D26,$9D28,$9D12,$9D1B,$9ED8,$9ED4,$9F8D,$9F9C,$512A,$511F,$5121,$5132,
$52F5,$568E,$5680,$5690,$5685,$5687,$568F,$58D5,$58D3,$58D1,$58CE,$5B30,$5B2A,
$5B24,$5B7A,$5C37,$5C68,$5DBC,$5DBA,$5DBD,$5DB8,$5E6B,$5F4C,$5FBD,$61C9,$61C2,
$61C7,$61E6,$61CB,$6232,$6234,$64CE,$64CA,$64D8,$64E0,$64F0,$64E6,$64EC,$64F1,
$64E2,$64ED,$6582,$6583,$66D9,$66D6,$6A80,$6A94,$6A84,$6AA2,$6A9C,$6ADB,$6AA3,
$6A7E,$6A97,$6A90,$6AA0,$6B5C,$6BAE,$6BDA,$6C08,$6FD8,$6FF1,$6FDF,$6FE0,$6FDB,
$6FE4,$6FEB,$6FEF,$6F80,$6FEC,$6FE1,$6FE9,$6FD5,$6FEE,$6FF0,$71E7,$71DF,$71EE,
$71E6,$71E5,$71ED,$71EC,$71F4,$71E0,$7235,$7246,$7370,$7372,$74A9,$74B0,$74A6,
$74A8,$7646,$7642,$764C,$76EA,$77B3,$77AA,$77B0,$77AC,$77A7,$77AD,$77EF,$78F7,
$78FA,$78F4,$78EF,$7901,$79A7,$79AA,$7A57,$7ABF,$7C07,$7C0D,$7BFE,$7BF7,$7C0C,
$7BE0,$7CE0,$7CDC,$7CDE,$7CE2,$7CDF,$7CD9,$7CDD,$7E2E,$7E3E,$7E46,$7E37,$7E32,
$7E43,$7E2B,$7E3D,$7E31,$7E45,$7E41,$7E34,$7E39,$7E48,$7E35,$7E3F,$7E2F,$7F44,
$7FF3,$7FFC,$8071,$8072,$8070,$806F,$8073,$81C6,$81C3,$81BA,$81C2,$81C0,$81BF,
$81BD,$81C9,$81BE,$81E8,$8209,$8271,$85AA,$8584,$857E,$859C,$8591,$8594,$85AF,
$859B,$8587,$85A8,$858A,$8667,$87C0,$87D1,$87B3,$87D2,$87C6,$87AB,$87BB,$87BA,
$87C8,$87CB,$893B,$8936,$8944,$8938,$893D,$89AC,$8B0E,$8B17,$8B19,$8B1B,$8B0A,
$8B20,$8B1D,$8B04,$8B10,$8C41,$8C3F,$8C73,$8CFA,$8CFD,$8CFC,$8CF8,$8CFB,$8DA8,
$8E49,$8E4B,$8E48,$8E4A,$8F44,$8F3E,$8F42,$8F45,$8F3F,$907F,$907D,$9084,$9081,
$9082,$9080,$9139,$91A3,$919E,$919C,$934D,$9382,$9328,$9375,$934A,$9365,$934B,
$9318,$937E,$936C,$935B,$9370,$935A,$9354,$95CA,$95CB,$95CC,$95C8,$95C6,$96B1,
$96B8,$96D6,$971C,$971E,$97A0,$97D3,$9846,$98B6,$9935,$9A01,$99FF,$9BAE,$9BAB,
$9BAA,$9BAD,$9D3B,$9D3F,$9E8B,$9ECF,$9EDE,$9EDC,$9EDD,$9EDB,$9F3E,$9F4B,$53E2,
$5695,$56AE,$58D9,$58D8,$5B38,$5F5D,$61E3,$6233,$64F4,$64F2,$64FE,$6506,$64FA,
$64FB,$64F7,$65B7,$66DC,$6726,$6AB3,$6AAC,$6AC3,$6ABB,$6AB8,$6AC2,$6AAE,$6AAF,
$6B5F,$6B78,$6BAF,$7009,$700B,$6FFE,$7006,$6FFA,$7011,$700F,$71FB,$71FC,$71FE,
$71F8,$7377,$7375,$74A7,$74BF,$7515,$7656,$7658,$7652,$77BD,$77BF,$77BB,$77BC,
$790E,$79AE,$7A61,$7A62,$7A60,$7AC4,$7AC5,$7C2B,$7C27,$7C2A,$7C1E,$7C23,$7C21,
$7CE7,$7E54,$7E55,$7E5E,$7E5A,$7E61,$7E52,$7E59,$7F48,$7FF9,$7FFB,$8077,$8076,
$81CD,$81CF,$820A,$85CF,$85A9,$85CD,$85D0,$85C9,$85B0,$85BA,$85B9,$85A6,$87EF,
$87EC,$87F2,$87E0,$8986,$89B2,$89F4,$8B28,$8B39,$8B2C,$8B2B,$8C50,$8D05,$8E59,
$8E63,$8E66,$8E64,$8E5F,$8E55,$8EC0,$8F49,$8F4D,$9087,$9083,$9088,$91AB,$91AC,
$91D0,$9394,$938A,$9396,$93A2,$93B3,$93AE,$93AC,$93B0,$9398,$939A,$9397,$95D4,
$95D6,$95D0,$95D5,$96E2,$96DC,$96D9,$96DB,$96DE,$9724,$97A3,$97A6,$97AD,$97F9,
$984D,$984F,$984C,$984E,$9853,$98BA,$993E,$993F,$993D,$992E,$99A5,$9A0E,$9AC1,
$9B03,$9B06,$9B4F,$9B4E,$9B4D,$9BCA,$9BC9,$9BFD,$9BC8,$9BC0,$9D51,$9D5D,$9D60,
$9EE0,$9F15,$9F2C,$5133,$56A5,$58DE,$58DF,$58E2,$5BF5,$9F90,$5EEC,$61F2,$61F7,
$61F6,$61F5,$6500,$650F,$66E0,$66DD,$6AE5,$6ADD,$6ADA,$6AD3,$701B,$701F,$7028,
$701A,$701D,$7015,$7018,$7206,$720D,$7258,$72A2,$7378,$737A,$74BD,$74CA,$74E3,
$7587,$7586,$765F,$7661,$77C7,$7919,$79B1,$7A6B,$7A69,$7C3E,$7C3F,$7C38,$7C3D,
$7C37,$7C40,$7E6B,$7E6D,$7E79,$7E69,$7E6A,$7F85,$7E73,$7FB6,$7FB9,$7FB8,$81D8,
$85E9,$85DD,$85EA,$85D5,$85E4,$85E5,$85F7,$87FB,$8805,$880D,$87F9,$87FE,$8960,
$895F,$8956,$895E,$8B41,$8B5C,$8B58,$8B49,$8B5A,$8B4E,$8B4F,$8B46,$8B59,$8D08,
$8D0A,$8E7C,$8E72,$8E87,$8E76,$8E6C,$8E7A,$8E74,$8F54,$8F4E,$8FAD,$908A,$908B,
$91B1,$91AE,$93E1,$93D1,$93DF,$93C3,$93C8,$93DC,$93DD,$93D6,$93E2,$93CD,$93D8,
$93E4,$93D7,$93E8,$95DC,$96B4,$96E3,$972A,$9727,$9761,$97DC,$97FB,$985E,$9858,
$985B,$98BC,$9945,$9949,$9A16,$9A19,$9B0D,$9BE8,$9BE7,$9BD6,$9BDB,$9D89,$9D61,
$9D72,$9D6A,$9D6C,$9E92,$9E97,$9E93,$9EB4,$52F8,$56A8,$56B7,$56B6,$56B4,$56BC,
$58E4,$5B40,$5B43,$5B7D,$5BF6,$5DC9,$61F8,$61FA,$6518,$6514,$6519,$66E6,$6727,
$6AEC,$703E,$7030,$7032,$7210,$737B,$74CF,$7662,$7665,$7926,$792A,$792C,$792B,
$7AC7,$7AF6,$7C4C,$7C43,$7C4D,$7CEF,$7CF0,$8FAE,$7E7D,$7E7C,$7E82,$7F4C,$8000,
$81DA,$8266,$85FB,$85F9,$8611,$85FA,$8606,$860B,$8607,$860A,$8814,$8815,$8964,
$89BA,$89F8,$8B70,$8B6C,$8B66,$8B6F,$8B5F,$8B6B,$8D0F,$8D0D,$8E89,$8E81,$8E85,
$8E82,$91B4,$91CB,$9418,$9403,$93FD,$95E1,$9730,$98C4,$9952,$9951,$99A8,$9A2B,
$9A30,$9A37,$9A35,$9C13,$9C0D,$9E79,$9EB5,$9EE8,$9F2F,$9F5F,$9F63,$9F61,$5137,
$5138,$56C1,$56C0,$56C2,$5914,$5C6C,$5DCD,$61FC,$61FE,$651D,$651C,$6595,$66E9,
$6AFB,$6B04,$6AFA,$6BB2,$704C,$721B,$72A7,$74D6,$74D4,$7669,$77D3,$7C50,$7E8F,
$7E8C,$7FBC,$8617,$862D,$861A,$8823,$8822,$8821,$881F,$896A,$896C,$89BD,$8B74,
$8B77,$8B7D,$8D13,$8E8A,$8E8D,$8E8B,$8F5F,$8FAF,$91BA,$942E,$9433,$9435,$943A,
$9438,$9432,$942B,$95E2,$9738,$9739,$9732,$97FF,$9867,$9865,$9957,$9A45,$9A43,
$9A40,$9A3E,$9ACF,$9B54,$9B51,$9C2D,$9C25,$9DAF,$9DB4,$9DC2,$9DB8,$9E9D,$9EEF,
$9F19,$9F5C,$9F66,$9F67,$513C,$513B,$56C8,$56CA,$56C9,$5B7F,$5DD4,$5DD2,$5F4E,
$61FF,$6524,$6B0A,$6B61,$7051,$7058,$7380,$74E4,$758A,$766E,$766C,$79B3,$7C60,
$7C5F,$807E,$807D,$81DF,$8972,$896F,$89FC,$8B80,$8D16,$8D17,$8E91,$8E93,$8F61,
$9148,$9444,$9451,$9452,$973D,$973E,$97C3,$97C1,$986B,$9955,$9A55,$9A4D,$9AD2,
$9B1A,$9C49,$9C31,$9C3E,$9C3B,$9DD3,$9DD7,$9F34,$9F6C,$9F6A,$9F94,$56CC,$5DD6,
$6200,$6523,$652B,$652A,$66EC,$6B10,$74DA,$7ACA,$7C64,$7C63,$7C65,$7E93,$7E96,
$7E94,$81E2,$8638,$863F,$8831,$8B8A,$9090,$908F,$9463,$9460,$9464,$9768,$986F,
$995C,$9A5A,$9A5B,$9A57,$9AD3,$9AD4,$9AD1,$9C54,$9C57,$9C56,$9DE5,$9E9F,$9EF4,
$56D1,$58E9,$652C,$705E,$7671,$7672,$77D7,$7F50,$7F88,$8836,$8839,$8862,$8B93,
$8B92,$8B96,$8277,$8D1B,$91C0,$946A,$9742,$9748,$9744,$97C6,$9870,$9A5F,$9B22,
$9B58,$9C5F,$9DF9,$9DFA,$9E7C,$9E7D,$9F07,$9F77,$9F72,$5EF3,$6B16,$7063,$7C6C,
$7C6E,$883B,$89C0,$8EA1,$91C1,$9472,$9470,$9871,$995E,$9AD6,$9B23,$9ECC,$7064,
$77DA,$8B9A,$9477,$97C9,$9A62,$9A65,$7E9C,$8B9C,$8EAA,$91C5,$947D,$947E,$947C,
$9C77,$9C78,$9EF7,$8C54,$947F,$9E1A,$7228,$9A6A,$9B31,$9E1B,$9E1E,$7C72,$4E42,
$4E5C,$51F5,$531A,$5382,$4E07,$4E0C,$4E47,$4E8D,$56D7,$FA0C,$5C6E,$5F73,$4E0F,
$5187,$4E0E,$4E2E,$4E93,$4EC2,$4EC9,$4EC8,$5198,$52FC,$536C,$53B9,$5720,$5903,
$592C,$5C10,$5DFF,$65E1,$6BB3,$6BCC,$6C14,$723F,$4E31,$4E3C,$4EE8,$4EDC,$4EE9,
$4EE1,$4EDD,$4EDA,$520C,$531C,$534C,$5722,$5723,$5917,$592F,$5B81,$5B84,$5C12,
$5C3B,$5C74,$5C73,$5E04,$5E80,$5E82,$5FC9,$6209,$6250,$6C15,$6C36,$6C43,$6C3F,
$6C3B,$72AE,$72B0,$738A,$79B8,$808A,$961E,$4F0E,$4F18,$4F2C,$4EF5,$4F14,$4EF1,
$4F00,$4EF7,$4F08,$4F1D,$4F02,$4F05,$4F22,$4F13,$4F04,$4EF4,$4F12,$51B1,$5213,
$5209,$5210,$52A6,$5322,$531F,$534D,$538A,$5407,$56E1,$56DF,$572E,$572A,$5734,
$593C,$5980,$597C,$5985,$597B,$597E,$5977,$597F,$5B56,$5C15,$5C25,$5C7C,$5C7A,
$5C7B,$5C7E,$5DDF,$5E75,$5E84,$5F02,$5F1A,$5F74,$5FD5,$5FD4,$5FCF,$625C,$625E,
$6264,$6261,$6266,$6262,$6259,$6260,$625A,$6265,$65EF,$65EE,$673E,$6739,$6738,
$673B,$673A,$673F,$673C,$6733,$6C18,$6C46,$6C52,$6C5C,$6C4F,$6C4A,$6C54,$6C4B,
$6C4C,$7071,$725E,$72B4,$72B5,$738E,$752A,$767F,$7A75,$7F51,$8278,$827C,$8280,
$827D,$827F,$864D,$897E,$9099,$9097,$9098,$909B,$9094,$9622,$9624,$9620,$9623,
$4F56,$4F3B,$4F62,$4F49,$4F53,$4F64,$4F3E,$4F67,$4F52,$4F5F,$4F41,$4F58,$4F2D,
$4F33,$4F3F,$4F61,$518F,$51B9,$521C,$521E,$5221,$52AD,$52AE,$5309,$5363,$5372,
$538E,$538F,$5430,$5437,$542A,$5454,$5445,$5419,$541C,$5425,$5418,$543D,$544F,
$5441,$5428,$5424,$5447,$56EE,$56E7,$56E5,$5741,$5745,$574C,$5749,$574B,$5752,
$5906,$5940,$59A6,$5998,$59A0,$5997,$598E,$59A2,$5990,$598F,$59A7,$59A1,$5B8E,
$5B92,$5C28,$5C2A,$5C8D,$5C8F,$5C88,$5C8B,$5C89,$5C92,$5C8A,$5C86,$5C93,$5C95,
$5DE0,$5E0A,$5E0E,$5E8B,$5E89,$5E8C,$5E88,$5E8D,$5F05,$5F1D,$5F78,$5F76,$5FD2,
$5FD1,$5FD0,$5FED,$5FE8,$5FEE,$5FF3,$5FE1,$5FE4,$5FE3,$5FFA,$5FEF,$5FF7,$5FFB,
$6000,$5FF4,$623A,$6283,$628C,$628E,$628F,$6294,$6287,$6271,$627B,$627A,$6270,
$6281,$6288,$6277,$627D,$6272,$6274,$6537,$65F0,$65F4,$65F3,$65F2,$65F5,$6745,
$6747,$6759,$6755,$674C,$6748,$675D,$674D,$675A,$674B,$6BD0,$6C19,$6C1A,$6C78,
$6C67,$6C6B,$6C84,$6C8B,$6C8F,$6C71,$6C6F,$6C69,$6C9A,$6C6D,$6C87,$6C95,$6C9C,
$6C66,$6C73,$6C65,$6C7B,$6C8E,$7074,$707A,$7263,$72BF,$72BD,$72C3,$72C6,$72C1,
$72BA,$72C5,$7395,$7397,$7393,$7394,$7392,$753A,$7539,$7594,$7595,$7681,$793D,
$8034,$8095,$8099,$8090,$8092,$809C,$8290,$828F,$8285,$828E,$8291,$8293,$828A,
$8283,$8284,$8C78,$8FC9,$8FBF,$909F,$90A1,$90A5,$909E,$90A7,$90A0,$9630,$9628,
$962F,$962D,$4E33,$4F98,$4F7C,$4F85,$4F7D,$4F80,$4F87,$4F76,$4F74,$4F89,$4F84,
$4F77,$4F4C,$4F97,$4F6A,$4F9A,$4F79,$4F81,$4F78,$4F90,$4F9C,$4F94,$4F9E,$4F92,
$4F82,$4F95,$4F6B,$4F6E,$519E,$51BC,$51BE,$5235,$5232,$5233,$5246,$5231,$52BC,
$530A,$530B,$533C,$5392,$5394,$5487,$547F,$5481,$5491,$5482,$5488,$546B,$547A,
$547E,$5465,$546C,$5474,$5466,$548D,$546F,$5461,$5460,$5498,$5463,$5467,$5464,
$56F7,$56F9,$576F,$5772,$576D,$576B,$5771,$5770,$5776,$5780,$5775,$577B,$5773,
$5774,$5762,$5768,$577D,$590C,$5945,$59B5,$59BA,$59CF,$59CE,$59B2,$59CC,$59C1,
$59B6,$59BC,$59C3,$59D6,$59B1,$59BD,$59C0,$59C8,$59B4,$59C7,$5B62,$5B65,$5B93,
$5B95,$5C44,$5C47,$5CAE,$5CA4,$5CA0,$5CB5,$5CAF,$5CA8,$5CAC,$5C9F,$5CA3,$5CAD,
$5CA2,$5CAA,$5CA7,$5C9D,$5CA5,$5CB6,$5CB0,$5CA6,$5E17,$5E14,$5E19,$5F28,$5F22,
$5F23,$5F24,$5F54,$5F82,$5F7E,$5F7D,$5FDE,$5FE5,$602D,$6026,$6019,$6032,$600B,
$6034,$600A,$6017,$6033,$601A,$601E,$602C,$6022,$600D,$6010,$602E,$6013,$6011,
$600C,$6009,$601C,$6214,$623D,$62AD,$62B4,$62D1,$62BE,$62AA,$62B6,$62CA,$62AE,
$62B3,$62AF,$62BB,$62A9,$62B0,$62B8,$653D,$65A8,$65BB,$6609,$65FC,$6604,$6612,
$6608,$65FB,$6603,$660B,$660D,$6605,$65FD,$6611,$6610,$66F6,$670A,$6785,$676C,
$678E,$6792,$6776,$677B,$6798,$6786,$6784,$6774,$678D,$678C,$677A,$679F,$6791,
$6799,$6783,$677D,$6781,$6778,$6779,$6794,$6B25,$6B80,$6B7E,$6BDE,$6C1D,$6C93,
$6CEC,$6CEB,$6CEE,$6CD9,$6CB6,$6CD4,$6CAD,$6CE7,$6CB7,$6CD0,$6CC2,$6CBA,$6CC3,
$6CC6,$6CED,$6CF2,$6CD2,$6CDD,$6CB4,$6C8A,$6C9D,$6C80,$6CDE,$6CC0,$6D30,$6CCD,
$6CC7,$6CB0,$6CF9,$6CCF,$6CE9,$6CD1,$7094,$7098,$7085,$7093,$7086,$7084,$7091,
$7096,$7082,$709A,$7083,$726A,$72D6,$72CB,$72D8,$72C9,$72DC,$72D2,$72D4,$72DA,
$72CC,$72D1,$73A4,$73A1,$73AD,$73A6,$73A2,$73A0,$73AC,$739D,$74DD,$74E8,$753F,
$7540,$753E,$758C,$7598,$76AF,$76F3,$76F1,$76F0,$76F5,$77F8,$77FC,$77F9,$77FB,
$77FA,$77F7,$7942,$793F,$79C5,$7A78,$7A7B,$7AFB,$7C75,$7CFD,$8035,$808F,$80AE,
$80A3,$80B8,$80B5,$80AD,$8220,$82A0,$82C0,$82AB,$829A,$8298,$829B,$82B5,$82A7,
$82AE,$82BC,$829E,$82BA,$82B4,$82A8,$82A1,$82A9,$82C2,$82A4,$82C3,$82B6,$82A2,
$8670,$866F,$866D,$866E,$8C56,$8FD2,$8FCB,$8FD3,$8FCD,$8FD6,$8FD5,$8FD7,$90B2,
$90B4,$90AF,$90B3,$90B0,$9639,$963D,$963C,$963A,$9643,$4FCD,$4FC5,$4FD3,$4FB2,
$4FC9,$4FCB,$4FC1,$4FD4,$4FDC,$4FD9,$4FBB,$4FB3,$4FDB,$4FC7,$4FD6,$4FBA,$4FC0,
$4FB9,$4FEC,$5244,$5249,$52C0,$52C2,$533D,$537C,$5397,$5396,$5399,$5398,$54BA,
$54A1,$54AD,$54A5,$54CF,$54C3,$830D,$54B7,$54AE,$54D6,$54B6,$54C5,$54C6,$54A0,
$5470,$54BC,$54A2,$54BE,$5472,$54DE,$54B0,$57B5,$579E,$579F,$57A4,$578C,$5797,
$579D,$579B,$5794,$5798,$578F,$5799,$57A5,$579A,$5795,$58F4,$590D,$5953,$59E1,
$59DE,$59EE,$5A00,$59F1,$59DD,$59FA,$59FD,$59FC,$59F6,$59E4,$59F2,$59F7,$59DB,
$59E9,$59F3,$59F5,$59E0,$59FE,$59F4,$59ED,$5BA8,$5C4C,$5CD0,$5CD8,$5CCC,$5CD7,
$5CCB,$5CDB,$5CDE,$5CDA,$5CC9,$5CC7,$5CCA,$5CD6,$5CD3,$5CD4,$5CCF,$5CC8,$5CC6,
$5CCE,$5CDF,$5CF8,$5DF9,$5E21,$5E22,$5E23,$5E20,$5E24,$5EB0,$5EA4,$5EA2,$5E9B,
$5EA3,$5EA5,$5F07,$5F2E,$5F56,$5F86,$6037,$6039,$6054,$6072,$605E,$6045,$6053,
$6047,$6049,$605B,$604C,$6040,$6042,$605F,$6024,$6044,$6058,$6066,$606E,$6242,
$6243,$62CF,$630D,$630B,$62F5,$630E,$6303,$62EB,$62F9,$630F,$630C,$62F8,$62F6,
$6300,$6313,$6314,$62FA,$6315,$62FB,$62F0,$6541,$6543,$65AA,$65BF,$6636,$6621,
$6632,$6635,$661C,$6626,$6622,$6633,$662B,$663A,$661D,$6634,$6639,$662E,$670F,
$6710,$67C1,$67F2,$67C8,$67BA,$67DC,$67BB,$67F8,$67D8,$67C0,$67B7,$67C5,$67EB,
$67E4,$67DF,$67B5,$67CD,$67B3,$67F7,$67F6,$67EE,$67E3,$67C2,$67B9,$67CE,$67E7,
$67F0,$67B2,$67FC,$67C6,$67ED,$67CC,$67AE,$67E6,$67DB,$67FA,$67C9,$67CA,$67C3,
$67EA,$67CB,$6B28,$6B82,$6B84,$6BB6,$6BD6,$6BD8,$6BE0,$6C20,$6C21,$6D28,$6D34,
$6D2D,$6D1F,$6D3C,$6D3F,$6D12,$6D0A,$6CDA,$6D33,$6D04,$6D19,$6D3A,$6D1A,$6D11,
$6D00,$6D1D,$6D42,$6D01,$6D18,$6D37,$6D03,$6D0F,$6D40,$6D07,$6D20,$6D2C,$6D08,
$6D22,$6D09,$6D10,$70B7,$709F,$70BE,$70B1,$70B0,$70A1,$70B4,$70B5,$70A9,$7241,
$7249,$724A,$726C,$7270,$7273,$726E,$72CA,$72E4,$72E8,$72EB,$72DF,$72EA,$72E6,
$72E3,$7385,$73CC,$73C2,$73C8,$73C5,$73B9,$73B6,$73B5,$73B4,$73EB,$73BF,$73C7,
$73BE,$73C3,$73C6,$73B8,$73CB,$74EC,$74EE,$752E,$7547,$7548,$75A7,$75AA,$7679,
$76C4,$7708,$7703,$7704,$7705,$770A,$76F7,$76FB,$76FA,$77E7,$77E8,$7806,$7811,
$7812,$7805,$7810,$780F,$780E,$7809,$7803,$7813,$794A,$794C,$794B,$7945,$7944,
$79D5,$79CD,$79CF,$79D6,$79CE,$7A80,$7A7E,$7AD1,$7B00,$7B01,$7C7A,$7C78,$7C79,
$7C7F,$7C80,$7C81,$7D03,$7D08,$7D01,$7F58,$7F91,$7F8D,$7FBE,$8007,$800E,$800F,
$8014,$8037,$80D8,$80C7,$80E0,$80D1,$80C8,$80C2,$80D0,$80C5,$80E3,$80D9,$80DC,
$80CA,$80D5,$80C9,$80CF,$80D7,$80E6,$80CD,$81FF,$8221,$8294,$82D9,$82FE,$82F9,
$8307,$82E8,$8300,$82D5,$833A,$82EB,$82D6,$82F4,$82EC,$82E1,$82F2,$82F5,$830C,
$82FB,$82F6,$82F0,$82EA,$82E4,$82E0,$82FA,$82F3,$82ED,$8677,$8674,$867C,$8673,
$8841,$884E,$8867,$886A,$8869,$89D3,$8A04,$8A07,$8D72,$8FE3,$8FE1,$8FEE,$8FE0,
$90F1,$90BD,$90BF,$90D5,$90C5,$90BE,$90C7,$90CB,$90C8,$91D4,$91D3,$9654,$964F,
$9651,$9653,$964A,$964E,$501E,$5005,$5007,$5013,$5022,$5030,$501B,$4FF5,$4FF4,
$5033,$5037,$502C,$4FF6,$4FF7,$5017,$501C,$5020,$5027,$5035,$502F,$5031,$500E,
$515A,$5194,$5193,$51CA,$51C4,$51C5,$51C8,$51CE,$5261,$525A,$5252,$525E,$525F,
$5255,$5262,$52CD,$530E,$539E,$5526,$54E2,$5517,$5512,$54E7,$54F3,$54E4,$551A,
$54FF,$5504,$5508,$54EB,$5511,$5505,$54F1,$550A,$54FB,$54F7,$54F8,$54E0,$550E,
$5503,$550B,$5701,$5702,$57CC,$5832,$57D5,$57D2,$57BA,$57C6,$57BD,$57BC,$57B8,
$57B6,$57BF,$57C7,$57D0,$57B9,$57C1,$590E,$594A,$5A19,$5A16,$5A2D,$5A2E,$5A15,
$5A0F,$5A17,$5A0A,$5A1E,$5A33,$5B6C,$5BA7,$5BAD,$5BAC,$5C03,$5C56,$5C54,$5CEC,
$5CFF,$5CEE,$5CF1,$5CF7,$5D00,$5CF9,$5E29,$5E28,$5EA8,$5EAE,$5EAA,$5EAC,$5F33,
$5F30,$5F67,$605D,$605A,$6067,$6041,$60A2,$6088,$6080,$6092,$6081,$609D,$6083,
$6095,$609B,$6097,$6087,$609C,$608E,$6219,$6246,$62F2,$6310, $6356,$632C,$6344,
$6345,$6336,$6343,$63E4,$6339,$634B,$634A,$633C,$6329,$6341,$6334,$6358,$6354,
$6359,$632D,$6347,$6333,$635A,$6351,$6338,$6357,$6340,$6348,$654A,$6546,$65C6,
$65C3,$65C4,$65C2,$664A,$665F,$6647,$6651,$6712,$6713,$681F,$681A,$6849,$6832,
$6833,$683B,$684B,$684F,$6816,$6831,$681C,$6835,$682B,$682D,$682F,$684E,$6844,
$6834,$681D,$6812,$6814,$6826,$6828,$682E,$684D,$683A,$6825,$6820,$6B2C,$6B2F,
$6B2D,$6B31,$6B34,$6B6D,$8082,$6B88,$6BE6,$6BE4,$6BE8,$6BE3,$6BE2,$6BE7,$6C25,
$6D7A,$6D63,$6D64,$6D76,$6D0D,$6D61,$6D92,$6D58,$6D62,$6D6D,$6D6F,$6D91,$6D8D,
$6DEF,$6D7F,$6D86,$6D5E,$6D67,$6D60,$6D97,$6D70,$6D7C,$6D5F,$6D82,$6D98,$6D2F,
$6D68,$6D8B,$6D7E,$6D80,$6D84,$6D16,$6D83,$6D7B,$6D7D,$6D75,$6D90,$70DC,$70D3,
$70D1,$70DD,$70CB,$7F39,$70E2,$70D7,$70D2,$70DE,$70E0,$70D4,$70CD,$70C5,$70C6,
$70C7,$70DA,$70CE,$70E1,$7242,$7278,$7277,$7276,$7300,$72FA,$72F4,$72FE,$72F6,
$72F3,$72FB,$7301,$73D3,$73D9,$73E5,$73D6,$73BC,$73E7,$73E3,$73E9,$73DC,$73D2,
$73DB,$73D4,$73DD,$73DA,$73D7,$73D8,$73E8,$74DE,$74DF,$74F4,$74F5,$7521,$755B,
$755F,$75B0,$75C1,$75BB,$75C4,$75C0,$75BF,$75B6,$75BA,$768A,$76C9,$771D,$771B,
$7710,$7713,$7712,$7723,$7711,$7715,$7719,$771A,$7722,$7727,$7823,$782C,$7822,
$7835,$782F,$7828,$782E,$782B,$7821,$7829,$7833,$782A,$7831,$7954,$795B,$794F,
$795C,$7953,$7952,$7951,$79EB,$79EC,$79E0,$79EE,$79ED,$79EA,$79DC,$79DE,$79DD,
$7A86,$7A89,$7A85,$7A8B,$7A8C,$7A8A,$7A87,$7AD8,$7B10,$7B04,$7B13,$7B05,$7B0F,
$7B08,$7B0A,$7B0E,$7B09,$7B12,$7C84,$7C91,$7C8A,$7C8C,$7C88,$7C8D,$7C85,$7D1E,
$7D1D,$7D11,$7D0E,$7D18,$7D16,$7D13,$7D1F,$7D12,$7D0F,$7D0C,$7F5C,$7F61,$7F5E,
$7F60,$7F5D,$7F5B,$7F96,$7F92,$7FC3,$7FC2,$7FC0,$8016,$803E,$8039,$80FA,$80F2,
$80F9,$80F5,$8101,$80FB,$8100,$8201,$822F,$8225,$8333,$832D,$8344,$8319,$8351,
$8325,$8356,$833F,$8341,$8326,$831C,$8322,$8342,$834E,$831B,$832A,$8308,$833C,
$834D,$8316,$8324,$8320,$8337,$832F,$8329,$8347,$8345,$834C,$8353,$831E,$832C,
$834B,$8327,$8348,$8653,$8652,$86A2,$86A8,$8696,$868D,$8691,$869E,$8687,$8697,
$8686,$868B,$869A,$8685,$86A5,$8699,$86A1,$86A7,$8695,$8698,$868E,$869D,$8690,
$8694,$8843,$8844,$886D,$8875,$8876,$8872,$8880,$8871,$887F,$886F,$8883,$887E,
$8874,$887C,$8A12,$8C47,$8C57,$8C7B,$8CA4,$8CA3,$8D76,$8D78,$8DB5,$8DB7,$8DB6,
$8ED1,$8ED3,$8FFE,$8FF5,$9002,$8FFF,$8FFB,$9004,$8FFC,$8FF6,$90D6,$90E0,$90D9,
$90DA,$90E3,$90DF,$90E5,$90D8,$90DB,$90D7,$90DC,$90E4,$9150,$914E,$914F,$91D5,
$91E2,$91DA,$965C,$965F,$96BC,$98E3,$9ADF,$9B2F,$4E7F,$5070,$506A,$5061,$505E,
$5060,$5053,$504B,$505D,$5072,$5048,$504D,$5041,$505B,$504A,$5062,$5015,$5045,
$505F,$5069,$506B,$5063,$5064,$5046,$5040,$506E,$5073,$5057,$5051,$51D0,$526B,
$526D,$526C,$526E,$52D6,$52D3,$532D,$539C,$5575,$5576,$553C,$554D,$5550,$5534,
$552A,$5551,$5562,$5536,$5535,$5530,$5552,$5545,$550C,$5532,$5565,$554E,$5539,
$5548,$552D,$553B,$5540,$554B,$570A,$5707,$57FB,$5814,$57E2,$57F6,$57DC,$57F4,
$5800,$57ED,$57FD,$5808,$57F8,$580B,$57F3,$57CF,$5807,$57EE,$57E3,$57F2,$57E5,
$57EC,$57E1,$580E,$57FC,$5810,$57E7,$5801,$580C,$57F1,$57E9,$57F0,$580D,$5804,
$595C,$5A60,$5A58,$5A55,$5A67,$5A5E,$5A38,$5A35,$5A6D,$5A50,$5A5F,$5A65,$5A6C,
$5A53,$5A64,$5A57,$5A43,$5A5D,$5A52,$5A44,$5A5B,$5A48,$5A8E,$5A3E,$5A4D,$5A39,
$5A4C,$5A70,$5A69,$5A47,$5A51,$5A56,$5A42,$5A5C,$5B72,$5B6E,$5BC1,$5BC0,$5C59,
$5D1E,$5D0B,$5D1D,$5D1A,$5D20,$5D0C,$5D28,$5D0D,$5D26,$5D25,$5D0F,$5D30,$5D12,
$5D23,$5D1F,$5D2E,$5E3E,$5E34,$5EB1,$5EB4,$5EB9,$5EB2,$5EB3,$5F36,$5F38,$5F9B,
$5F96,$5F9F,$608A,$6090,$6086,$60BE,$60B0,$60BA,$60D3,$60D4,$60CF,$60E4,$60D9,
$60DD,$60C8,$60B1,$60DB,$60B7,$60CA,$60BF,$60C3,$60CD,$60C0,$6332,$6365,$638A,
$6382,$637D,$63BD,$639E,$63AD,$639D,$6397,$63AB,$638E,$636F,$6387,$6390,$636E,
$63AF,$6375,$639C,$636D,$63AE,$637C,$63A4,$633B,$639F,$6378,$6385,$6381,$6391,
$638D,$6370,$6553,$65CD,$6665,$6661,$665B,$6659,$665C,$6662,$6718,$6879,$6887,
$6890,$689C,$686D,$686E,$68AE,$68AB,$6956,$686F,$68A3,$68AC,$68A9,$6875,$6874,
$68B2,$688F,$6877,$6892,$687C,$686B,$6872,$68AA,$6880,$6871,$687E,$689B,$6896,
$688B,$68A0,$6889,$68A4,$6878,$687B,$6891,$688C,$688A,$687D,$6B36,$6B33,$6B37,
$6B38,$6B91,$6B8F,$6B8D,$6B8E,$6B8C,$6C2A,$6DC0,$6DAB,$6DB4,$6DB3,$6E74,$6DAC,
$6DE9,$6DE2,$6DB7,$6DF6,$6DD4,$6E00,$6DC8,$6DE0,$6DDF,$6DD6,$6DBE,$6DE5,$6DDC,
$6DDD,$6DDB,$6DF4,$6DCA,$6DBD,$6DED,$6DF0,$6DBA,$6DD5,$6DC2,$6DCF,$6DC9,$6DD0,
$6DF2,$6DD3,$6DFD,$6DD7,$6DCD,$6DE3,$6DBB,$70FA,$710D,$70F7,$7117,$70F4,$710C,
$70F0,$7104,$70F3,$7110,$70FC,$70FF,$7106,$7113,$7100,$70F8,$70F6,$710B,$7102,
$710E,$727E,$727B,$727C,$727F,$731D,$7317,$7307,$7311,$7318,$730A,$7308,$72FF,
$730F,$731E,$7388,$73F6,$73F8,$73F5,$7404,$7401,$73FD,$7407,$7400,$73FA,$73FC,
$73FF,$740C,$740B,$73F4,$7408,$7564,$7563,$75CE,$75D2,$75CF,$75CB,$75CC,$75D1,
$75D0,$768F,$7689,$76D3,$7739,$772F,$772D,$7731,$7732,$7734,$7733,$773D,$7725,
$773B,$7735,$7848,$7852,$7849,$784D,$784A,$784C,$7826,$7845,$7850,$7964,$7967,
$7969,$796A,$7963,$796B,$7961,$79BB,$79FA,$79F8,$79F6,$79F7,$7A8F,$7A94,$7A90,
$7B35,$7B47,$7B34,$7B25,$7B30,$7B22,$7B24,$7B33,$7B18,$7B2A,$7B1D,$7B31,$7B2B,
$7B2D,$7B2F,$7B32,$7B38,$7B1A,$7B23,$7C94,$7C98,$7C96,$7CA3,$7D35,$7D3D,$7D38,
$7D36,$7D3A,$7D45,$7D2C,$7D29,$7D41,$7D47,$7D3E,$7D3F,$7D4A,$7D3B,$7D28,$7F63,
$7F95,$7F9C,$7F9D,$7F9B,$7FCA,$7FCB,$7FCD,$7FD0,$7FD1,$7FC7,$7FCF,$7FC9,$801F,
$801E,$801B,$8047,$8043,$8048,$8118,$8125,$8119,$811B,$812D,$811F,$812C,$811E,
$8121,$8115,$8127,$811D,$8122,$8211,$8238,$8233,$823A,$8234,$8232,$8274,$8390,
$83A3,$83A8,$838D,$837A,$8373,$83A4,$8374,$838F,$8381,$8395,$8399,$8375,$8394,
$83A9,$837D,$8383,$838C,$839D,$839B,$83AA,$838B,$837E,$83A5,$83AF,$8388,$8397,
$83B0,$837F,$83A6,$8387,$83AE,$8376,$839A,$8659,$8656,$86BF,$86B7,$86C2,$86C1,
$86C5,$86BA,$86B0,$86C8,$86B9,$86B3,$86B8,$86CC,$86B4,$86BB,$86BC,$86C3,$86BD,
$86BE,$8852,$8889,$8895,$88A8,$88A2,$88AA,$889A,$8891,$88A1,$889F,$8898,$88A7,
$8899,$889B,$8897,$88A4,$88AC,$888C,$8893,$888E,$8982,$89D6,$89D9,$89D5,$8A30,
$8A27,$8A2C,$8A1E,$8C39,$8C3B,$8C5C,$8C5D,$8C7D,$8CA5,$8D7D,$8D7B,$8D79,$8DBC,
$8DC2,$8DB9,$8DBF,$8DC1,$8ED8,$8EDE,$8EDD,$8EDC,$8ED7,$8EE0,$8EE1,$9024,$900B,
$9011,$901C,$900C,$9021,$90EF,$90EA,$90F0,$90F4,$90F2,$90F3,$90D4,$90EB,$90EC,
$90E9,$9156,$9158,$915A,$9153,$9155,$91EC,$91F4,$91F1,$91F3,$91F8,$91E4,$91F9,
$91EA,$91EB,$91F7,$91E8,$91EE,$957A,$9586,$9588,$967C,$966D,$966B,$9671,$966F,
$96BF,$976A,$9804,$98E5,$9997,$509B,$5095,$5094,$509E,$508B,$50A3,$5083,$508C,
$508E,$509D,$5068,$509C,$5092,$5082,$5087,$515F,$51D4,$5312,$5311,$53A4,$53A7,
$5591,$55A8,$55A5,$55AD,$5577,$5645,$55A2,$5593,$5588,$558F,$55B5,$5581,$55A3,
$5592,$55A4,$557D,$558C,$55A6,$557F,$5595,$55A1,$558E,$570C,$5829,$5837,$5819,
$581E,$5827,$5823,$5828,$57F5,$5848,$5825,$581C,$581B,$5833,$583F,$5836,$582E,
$5839,$5838,$582D,$582C,$583B,$5961,$5AAF,$5A94,$5A9F,$5A7A,$5AA2,$5A9E,$5A78,
$5AA6,$5A7C,$5AA5,$5AAC,$5A95,$5AAE,$5A37,$5A84,$5A8A,$5A97,$5A83,$5A8B,$5AA9,
$5A7B,$5A7D,$5A8C,$5A9C,$5A8F,$5A93,$5A9D,$5BEA,$5BCD,$5BCB,$5BD4,$5BD1,$5BCA,
$5BCE,$5C0C,$5C30,$5D37,$5D43,$5D6B,$5D41,$5D4B,$5D3F,$5D35,$5D51,$5D4E,$5D55,
$5D33,$5D3A,$5D52,$5D3D,$5D31,$5D59,$5D42,$5D39,$5D49,$5D38,$5D3C,$5D32,$5D36,
$5D40,$5D45,$5E44,$5E41,$5F58,$5FA6,$5FA5,$5FAB,$60C9,$60B9,$60CC,$60E2,$60CE,
$60C4,$6114,$60F2,$610A,$6116,$6105,$60F5,$6113,$60F8,$60FC,$60FE,$60C1,$6103,
$6118,$611D,$6110,$60FF,$6104,$610B,$624A,$6394,$63B1,$63B0,$63CE,$63E5,$63E8,
$63EF,$63C3,$649D,$63F3,$63CA,$63E0,$63F6,$63D5,$63F2,$63F5,$6461,$63DF,$63BE,
$63DD,$63DC,$63C4,$63D8,$63D3,$63C2,$63C7,$63CC,$63CB,$63C8,$63F0,$63D7,$63D9,
$6532,$6567,$656A,$6564,$655C,$6568,$6565,$658C,$659D,$659E,$65AE,$65D0,$65D2,
$667C,$666C,$667B,$6680,$6671,$6679,$666A,$6672,$6701,$690C,$68D3,$6904,$68DC,
$692A,$68EC,$68EA,$68F1,$690F,$68D6,$68F7,$68EB,$68E4,$68F6,$6913,$6910,$68F3,
$68E1,$6907,$68CC,$6908,$6970,$68B4,$6911,$68EF,$68C6,$6914,$68F8,$68D0,$68FD,
$68FC,$68E8,$690B,$690A,$6917,$68CE,$68C8,$68DD,$68DE,$68E6,$68F4,$68D1,$6906,
$68D4,$68E9,$6915,$6925,$68C7,$6B39,$6B3B,$6B3F,$6B3C,$6B94,$6B97,$6B99,$6B95,
$6BBD,$6BF0,$6BF2,$6BF3,$6C30,$6DFC,$6E46,$6E47,$6E1F,$6E49,$6E88,$6E3C,$6E3D,
$6E45,$6E62,$6E2B,$6E3F,$6E41,$6E5D,$6E73,$6E1C,$6E33,$6E4B,$6E40,$6E51,$6E3B,
$6E03,$6E2E,$6E5E,$6E68,$6E5C,$6E61,$6E31,$6E28,$6E60,$6E71,$6E6B,$6E39,$6E22,
$6E30,$6E53,$6E65,$6E27,$6E78,$6E64,$6E77,$6E55,$6E79,$6E52,$6E66,$6E35,$6E36,
$6E5A,$7120,$711E,$712F,$70FB,$712E,$7131,$7123,$7125,$7122,$7132,$711F,$7128,
$713A,$711B,$724B,$725A,$7288,$7289,$7286,$7285,$728B,$7312,$730B,$7330,$7322,
$7331,$7333,$7327,$7332,$732D,$7326,$7323,$7335,$730C,$742E,$742C,$7430,$742B,
$7416,$741A,$7421,$742D,$7431,$7424,$7423,$741D,$7429,$7420,$7432,$74FB,$752F,
$756F,$756C,$75E7,$75DA,$75E1,$75E6,$75DD,$75DF,$75E4,$75D7,$7695,$7692,$76DA,
$7746,$7747,$7744,$774D,$7745,$774A,$774E,$774B,$774C,$77DE,$77EC,$7860,$7864,
$7865,$785C,$786D,$7871,$786A,$786E,$7870,$7869,$7868,$785E,$7862,$7974,$7973,
$7972,$7970,$7A02,$7A0A,$7A03,$7A0C,$7A04,$7A99,$7AE6,$7AE4,$7B4A,$7B3B,$7B44,
$7B48,$7B4C,$7B4E,$7B40,$7B58,$7B45,$7CA2,$7C9E,$7CA8,$7CA1,$7D58,$7D6F,$7D63,
$7D53,$7D56,$7D67,$7D6A,$7D4F,$7D6D,$7D5C,$7D6B,$7D52,$7D54,$7D69,$7D51,$7D5F,
$7D4E,$7F3E,$7F3F,$7F65,$7F66,$7FA2,$7FA0,$7FA1,$7FD7,$8051,$804F,$8050,$80FE,
$80D4,$8143,$814A,$8152,$814F,$8147,$813D,$814D,$813A,$81E6,$81EE,$81F7,$81F8,
$81F9,$8204,$823C,$823D,$823F,$8275,$833B,$83CF,$83F9,$8423,$83C0,$83E8,$8412,
$83E7,$83E4,$83FC,$83F6,$8410,$83C6,$83C8,$83EB,$83E3,$83BF,$8401,$83DD,$83E5,
$83D8,$83FF,$83E1,$83CB,$83CE,$83D6,$83F5,$83C9,$8409,$840F,$83DE,$8411,$8406,
$83C2,$83F3,$83D5,$83FA,$83C7,$83D1,$83EA,$8413,$83C3,$83EC,$83EE,$83C4,$83FB,
$83D7,$83E2,$841B,$83DB,$83FE,$86D8,$86E2,$86E6,$86D3,$86E3,$86DA,$86EA,$86DD,
$86EB,$86DC,$86EC,$86E9,$86D7,$86E8,$86D1,$8848,$8856,$8855,$88BA,$88D7,$88B9,
$88B8,$88C0,$88BE,$88B6,$88BC,$88B7,$88BD,$88B2,$8901,$88C9,$8995,$8998,$8997,
$89DD,$89DA,$89DB,$8A4E,$8A4D,$8A39,$8A59,$8A40,$8A57,$8A58,$8A44,$8A45,$8A52,
$8A48,$8A51,$8A4A,$8A4C,$8A4F,$8C5F,$8C81,$8C80,$8CBA,$8CBE,$8CB0,$8CB9,$8CB5,
$8D84,$8D80,$8D89,$8DD8,$8DD3,$8DCD,$8DC7,$8DD6,$8DDC,$8DCF,$8DD5,$8DD9,$8DC8,
$8DD7,$8DC5,$8EEF,$8EF7,$8EFA,$8EF9,$8EE6,$8EEE,$8EE5,$8EF5,$8EE7,$8EE8,$8EF6,
$8EEB,$8EF1,$8EEC,$8EF4,$8EE9,$902D,$9034,$902F,$9106,$912C,$9104,$90FF,$90FC,
$9108,$90F9,$90FB,$9101,$9100,$9107,$9105,$9103,$9161,$9164,$915F,$9162,$9160,
$9201,$920A,$9225,$9203,$921A,$9226,$920F,$920C,$9200,$9212,$91FF,$91FD,$9206,
$9204,$9227,$9202,$921C,$9224,$9219,$9217,$9205,$9216,$957B,$958D,$958C,$9590,
$9687,$967E,$9688,$9689,$9683,$9680,$96C2,$96C8,$96C3,$96F1,$96F0,$976C,$9770,
$976E,$9807,$98A9,$98EB,$9CE6,$9EF9,$4E83,$4E84,$4EB6,$50BD,$50BF,$50C6,$50AE,
$50C4,$50CA,$50B4,$50C8,$50C2,$50B0,$50C1,$50BA,$50B1,$50CB,$50C9,$50B6,$50B8,
$51D7,$527A,$5278,$527B,$527C,$55C3,$55DB,$55CC,$55D0,$55CB,$55CA,$55DD,$55C0,
$55D4,$55C4,$55E9,$55BF,$55D2,$558D,$55CF,$55D5,$55E2,$55D6,$55C8,$55F2,$55CD,
$55D9,$55C2,$5714,$5853,$5868,$5864,$584F,$584D,$5849,$586F,$5855,$584E,$585D,
$5859,$5865,$585B,$583D,$5863,$5871,$58FC,$5AC7,$5AC4,$5ACB,$5ABA,$5AB8,$5AB1,
$5AB5,$5AB0,$5ABF,$5AC8,$5ABB,$5AC6,$5AB7,$5AC0,$5ACA,$5AB4,$5AB6,$5ACD,$5AB9,
$5A90,$5BD6,$5BD8,$5BD9,$5C1F,$5C33,$5D71,$5D63,$5D4A,$5D65,$5D72,$5D6C,$5D5E,
$5D68,$5D67,$5D62,$5DF0,$5E4F,$5E4E,$5E4A,$5E4D,$5E4B,$5EC5,$5ECC,$5EC6,$5ECB,
$5EC7,$5F40,$5FAF,$5FAD,$60F7,$6149,$614A,$612B,$6145,$6136,$6132,$612E,$6146,
$612F,$614F,$6129,$6140,$6220,$9168,$6223,$6225,$6224,$63C5,$63F1,$63EB,$6410,
$6412,$6409,$6420,$6424,$6433,$6443,$641F,$6415,$6418,$6439,$6437,$6422,$6423,
$640C,$6426,$6430,$6428,$6441,$6435,$642F,$640A,$641A,$6440,$6425,$6427,$640B,
$63E7,$641B,$642E,$6421,$640E,$656F,$6592,$65D3,$6686,$668C,$6695,$6690,$668B,
$668A,$6699,$6694,$6678,$6720,$6966,$695F,$6938,$694E,$6962,$6971,$693F,$6945,
$696A,$6939,$6942,$6957,$6959,$697A,$6948,$6949,$6935,$696C,$6933,$693D,$6965,
$68F0,$6978,$6934,$6969,$6940,$696F,$6944,$6976,$6958,$6941,$6974,$694C,$693B,
$694B,$6937,$695C,$694F,$6951,$6932,$6952,$692F,$697B,$693C,$6B46,$6B45,$6B43,
$6B42,$6B48,$6B41,$6B9B,$FA0D,$6BFB,$6BFC,$6BF9,$6BF7,$6BF8,$6E9B,$6ED6,$6EC8,
$6E8F,$6EC0,$6E9F,$6E93,$6E94,$6EA0,$6EB1,$6EB9,$6EC6,$6ED2,$6EBD,$6EC1,$6E9E,
$6EC9,$6EB7,$6EB0,$6ECD,$6EA6,$6ECF,$6EB2,$6EBE,$6EC3,$6EDC,$6ED8,$6E99,$6E92,
$6E8E,$6E8D,$6EA4,$6EA1,$6EBF,$6EB3,$6ED0,$6ECA,$6E97,$6EAE,$6EA3,$7147,$7154,
$7152,$7163,$7160,$7141,$715D,$7162,$7172,$7178,$716A,$7161,$7142,$7158,$7143,
$714B,$7170,$715F,$7150,$7153,$7144,$714D,$715A,$724F,$728D,$728C,$7291,$7290,
$728E,$733C,$7342,$733B,$733A,$7340,$734A,$7349,$7444,$744A,$744B,$7452,$7451,
$7457,$7440,$744F,$7450,$744E,$7442,$7446,$744D,$7454,$74E1,$74FF,$74FE,$74FD,
$751D,$7579,$7577,$6983,$75EF,$760F,$7603,$75F7,$75FE,$75FC,$75F9,$75F8,$7610,
$75FB,$75F6,$75ED,$75F5,$75FD,$7699,$76B5,$76DD,$7755,$775F,$7760,$7752,$7756,
$775A,$7769,$7767,$7754,$7759,$776D,$77E0,$7887,$789A,$7894,$788F,$7884,$7895,
$7885,$7886,$78A1,$7883,$7879,$7899,$7880,$7896,$787B,$797C,$7982,$797D,$7979,
$7A11,$7A18,$7A19,$7A12,$7A17,$7A15,$7A22,$7A13,$7A1B,$7A10,$7AA3,$7AA2,$7A9E,
$7AEB,$7B66,$7B64,$7B6D,$7B74,$7B69,$7B72,$7B65,$7B73,$7B71,$7B70,$7B61,$7B78,
$7B76,$7B63,$7CB2,$7CB4,$7CAF,$7D88,$7D86,$7D80,$7D8D,$7D7F,$7D85,$7D7A,$7D8E,
$7D7B,$7D83,$7D7C,$7D8C,$7D94,$7D84,$7D7D,$7D92,$7F6D,$7F6B,$7F67,$7F68,$7F6C,
$7FA6,$7FA5,$7FA7,$7FDB,$7FDC,$8021,$8164,$8160,$8177,$815C,$8169,$815B,$8162,
$8172,$6721,$815E,$8176,$8167,$816F,$8144,$8161,$821D,$8249,$8244,$8240,$8242,
$8245,$84F1,$843F,$8456,$8476,$8479,$848F,$848D,$8465,$8451,$8440,$8486,$8467,
$8430,$844D,$847D,$845A,$8459,$8474,$8473,$845D,$8507,$845E,$8437,$843A,$8434,
$847A,$8443,$8478,$8432,$8445,$8429,$83D9,$844B,$842F,$8442,$842D,$845F,$8470,
$8439,$844E,$844C,$8452,$846F,$84C5,$848E,$843B,$8447,$8436,$8433,$8468,$847E,
$8444,$842B,$8460,$8454,$846E,$8450,$870B,$8704,$86F7,$870C,$86FA,$86D6,$86F5,
$874D,$86F8,$870E,$8709,$8701,$86F6,$870D,$8705,$88D6,$88CB,$88CD,$88CE,$88DE,
$88DB,$88DA,$88CC,$88D0,$8985,$899B,$89DF,$89E5,$89E4,$89E1,$89E0,$89E2,$89DC,
$89E6,$8A76,$8A86,$8A7F,$8A61,$8A3F,$8A77,$8A82,$8A84,$8A75,$8A83,$8A81,$8A74,
$8A7A,$8C3C,$8C4B,$8C4A,$8C65,$8C64,$8C66,$8C86,$8C84,$8C85,$8CCC,$8D68,$8D69,
$8D91,$8D8C,$8D8E,$8D8F,$8D8D,$8D93,$8D94,$8D90,$8D92,$8DF0,$8DE0,$8DEC,$8DF1,
$8DEE,$8DD0,$8DE9,$8DE3,$8DE2,$8DE7,$8DF2,$8DEB,$8DF4,$8F06,$8EFF,$8F01,$8F00,
$8F05,$8F07,$8F08,$8F02,$8F0B,$9052,$903F,$9044,$9049,$903D,$9110,$910D,$910F,
$9111,$9116,$9114,$910B,$910E,$916E,$916F,$9248,$9252,$9230,$923A,$9266,$9233,
$9265,$925E,$9283,$922E,$924A,$9246,$926D,$926C,$924F,$9260,$9267,$926F,$9236,
$9261,$9270,$9231,$9254,$9263,$9250,$9272,$924E,$9253,$924C,$9256,$9232,$959F,
$959C,$959E,$959B,$9692,$9693,$9691,$9697,$96CE,$96FA,$96FD,$96F8,$96F5,$9773,
$9777,$9778,$9772,$980F,$980D,$980E,$98AC,$98F6,$98F9,$99AF,$99B2,$99B0,$99B5,
$9AAD,$9AAB,$9B5B,$9CEA,$9CED,$9CE7,$9E80,$9EFD,$50E6,$50D4,$50D7,$50E8,$50F3,
$50DB,$50EA,$50DD,$50E4,$50D3,$50EC,$50F0,$50EF,$50E3,$50E0,$51D8,$5280,$5281,
$52E9,$52EB,$5330,$53AC,$5627,$5615,$560C,$5612,$55FC,$560F,$561C,$5601,$5613,
$5602,$55FA,$561D,$5604,$55FF,$55F9,$5889,$587C,$5890,$5898, $5886,$5881,$587F,
$5874,$588B,$587A,$5887,$5891,$588E,$5876,$5882,$5888,$587B,$5894,$588F,$58FE,
$596B,$5ADC,$5AEE,$5AE5,$5AD5,$5AEA,$5ADA,$5AED,$5AEB,$5AF3,$5AE2,$5AE0,$5ADB,
$5AEC,$5ADE,$5ADD,$5AD9,$5AE8,$5ADF,$5B77,$5BE0,$5BE3,$5C63,$5D82,$5D80,$5D7D,
$5D86,$5D7A,$5D81,$5D77,$5D8A,$5D89,$5D88,$5D7E,$5D7C,$5D8D,$5D79,$5D7F,$5E58,
$5E59,$5E53,$5ED8,$5ED1,$5ED7,$5ECE,$5EDC,$5ED5,$5ED9,$5ED2,$5ED4,$5F44,$5F43,
$5F6F,$5FB6,$612C,$6128,$6141,$615E,$6171,$6173,$6152,$6153,$6172,$616C,$6180,
$6174,$6154,$617A,$615B,$6165,$613B,$616A,$6161,$6156,$6229,$6227,$622B,$642B,
$644D,$645B,$645D,$6474,$6476,$6472,$6473,$647D,$6475,$6466,$64A6,$644E,$6482,
$645E,$645C,$644B,$6453,$6460,$6450,$647F,$643F,$646C,$646B,$6459,$6465,$6477,
$6573,$65A0,$66A1,$66A0,$669F,$6705,$6704,$6722,$69B1,$69B6,$69C9,$69A0,$69CE,
$6996,$69B0,$69AC,$69BC,$6991,$6999,$698E,$69A7,$698D,$69A9,$69BE,$69AF,$69BF,
$69C4,$69BD,$69A4,$69D4,$69B9,$69CA,$699A,$69CF,$69B3,$6993,$69AA,$69A1,$699E,
$69D9,$6997,$6990,$69C2,$69B5,$69A5,$69C6,$6B4A,$6B4D,$6B4B,$6B9E,$6B9F,$6BA0,
$6BC3,$6BC4,$6BFE,$6ECE,$6EF5,$6EF1,$6F03,$6F25,$6EF8,$6F37,$6EFB,$6F2E,$6F09,
$6F4E,$6F19,$6F1A,$6F27,$6F18,$6F3B,$6F12,$6EED,$6F0A,$6F36,$6F73,$6EF9,$6EEE,
$6F2D,$6F40,$6F30,$6F3C,$6F35,$6EEB,$6F07,$6F0E,$6F43,$6F05,$6EFD,$6EF6,$6F39,
$6F1C,$6EFC,$6F3A,$6F1F,$6F0D,$6F1E,$6F08,$6F21,$7187,$7190,$7189,$7180,$7185,
$7182,$718F,$717B,$7186,$7181,$7197,$7244,$7253,$7297,$7295,$7293,$7343,$734D,
$7351,$734C,$7462,$7473,$7471,$7475,$7472,$7467,$746E,$7500,$7502,$7503,$757D,
$7590,$7616,$7608,$760C,$7615,$7611,$760A,$7614,$76B8,$7781,$777C,$7785,$7782,
$776E,$7780,$776F,$777E,$7783,$78B2,$78AA,$78B4,$78AD,$78A8,$787E,$78AB,$789E,
$78A5,$78A0,$78AC,$78A2,$78A4,$7998,$798A,$798B,$7996,$7995,$7994,$7993,$7997,
$7988,$7992,$7990,$7A2B,$7A4A,$7A30,$7A2F,$7A28,$7A26,$7AA8,$7AAB,$7AAC,$7AEE,
$7B88,$7B9C,$7B8A,$7B91,$7B90,$7B96,$7B8D,$7B8C,$7B9B,$7B8E,$7B85,$7B98,$5284,
$7B99,$7BA4,$7B82,$7CBB,$7CBF,$7CBC,$7CBA,$7DA7,$7DB7,$7DC2,$7DA3,$7DAA,$7DC1,
$7DC0,$7DC5,$7D9D,$7DCE,$7DC4,$7DC6,$7DCB,$7DCC,$7DAF,$7DB9,$7D96,$7DBC,$7D9F,
$7DA6,$7DAE,$7DA9,$7DA1,$7DC9,$7F73,$7FE2,$7FE3,$7FE5,$7FDE,$8024,$805D,$805C,
$8189,$8186,$8183,$8187,$818D,$818C,$818B,$8215,$8497,$84A4,$84A1,$849F,$84BA,
$84CE,$84C2,$84AC,$84AE,$84AB,$84B9,$84B4,$84C1,$84CD,$84AA,$849A,$84B1,$84D0,
$849D,$84A7,$84BB,$84A2,$8494,$84C7,$84CC,$849B,$84A9,$84AF,$84A8,$84D6,$8498,
$84B6,$84CF,$84A0,$84D7,$84D4,$84D2,$84DB,$84B0,$8491,$8661,$8733,$8723,$8728,
$876B,$8740,$872E,$871E,$8721,$8719,$871B,$8743,$872C,$8741,$873E,$8746,$8720,
$8732,$872A,$872D,$873C,$8712,$873A,$8731,$8735,$8742,$8726,$8727,$8738,$8724,
$871A,$8730,$8711,$88F7,$88E7,$88F1,$88F2,$88FA,$88FE,$88EE,$88FC,$88F6,$88FB,
$88F0,$88EC,$88EB,$899D,$89A1,$899F,$899E,$89E9,$89EB,$89E8,$8AAB,$8A99,$8A8B,
$8A92,$8A8F,$8A96,$8C3D,$8C68,$8C69,$8CD5,$8CCF,$8CD7,$8D96,$8E09,$8E02,$8DFF,
$8E0D,$8DFD,$8E0A,$8E03,$8E07,$8E06,$8E05,$8DFE,$8E00,$8E04,$8F10,$8F11,$8F0E,
$8F0D,$9123,$911C,$9120,$9122,$911F,$911D,$911A,$9124,$9121,$911B,$917A,$9172,
$9179,$9173,$92A5,$92A4,$9276,$929B,$927A,$92A0,$9294,$92AA,$928D,$92A6,$929A,
$92AB,$9279,$9297,$927F,$92A3,$92EE,$928E,$9282,$9295,$92A2,$927D,$9288,$92A1,
$928A,$9286,$928C,$9299,$92A7,$927E,$9287,$92A9,$929D,$928B,$922D,$969E,$96A1,
$96FF,$9758,$977D,$977A,$977E,$9783,$9780,$9782,$977B,$9784,$9781,$977F,$97CE,
$97CD,$9816,$98AD,$98AE,$9902,$9900,$9907,$999D,$999C,$99C3,$99B9,$99BB,$99BA,
$99C2,$99BD,$99C7,$9AB1,$9AE3,$9AE7,$9B3E,$9B3F,$9B60,$9B61,$9B5F,$9CF1,$9CF2,
$9CF5,$9EA7,$50FF,$5103,$5130,$50F8,$5106,$5107,$50F6,$50FE,$510B,$510C,$50FD,
$510A,$528B,$528C,$52F1,$52EF,$5648,$5642,$564C,$5635,$5641,$564A,$5649,$5646,
$5658,$565A,$5640,$5633,$563D,$562C,$563E,$5638,$562A,$563A,$571A,$58AB,$589D,
$58B1,$58A0,$58A3,$58AF,$58AC,$58A5,$58A1,$58FF,$5AFF,$5AF4,$5AFD,$5AF7,$5AF6,
$5B03,$5AF8,$5B02,$5AF9,$5B01,$5B07,$5B05,$5B0F,$5C67,$5D99,$5D97,$5D9F,$5D92,
$5DA2,$5D93,$5D95,$5DA0,$5D9C,$5DA1,$5D9A,$5D9E,$5E69,$5E5D,$5E60,$5E5C,$7DF3,
$5EDB,$5EDE,$5EE1,$5F49,$5FB2,$618B,$6183,$6179,$61B1,$61B0,$61A2,$6189,$619B,
$6193,$61AF,$61AD,$619F,$6192,$61AA,$61A1,$618D,$6166,$61B3,$622D,$646E,$6470,
$6496,$64A0,$6485,$6497,$649C,$648F,$648B,$648A,$648C,$64A3,$649F,$6468,$64B1,
$6498,$6576,$657A,$6579,$657B,$65B2,$65B3,$66B5,$66B0,$66A9,$66B2,$66B7,$66AA,
$66AF,$6A00,$6A06,$6A17,$69E5,$69F8,$6A15,$69F1,$69E4,$6A20,$69FF,$69EC,$69E2,
$6A1B,$6A1D,$69FE,$6A27,$69F2,$69EE,$6A14,$69F7,$69E7,$6A40,$6A08,$69E6,$69FB,
$6A0D,$69FC,$69EB,$6A09,$6A04,$6A18,$6A25,$6A0F,$69F6,$6A26,$6A07,$69F4,$6A16,
$6B51,$6BA5,$6BA3,$6BA2,$6BA6,$6C01,$6C00,$6BFF,$6C02,$6F41,$6F26,$6F7E,$6F87,
$6FC6,$6F92,$6F8D,$6F89,$6F8C,$6F62,$6F4F,$6F85,$6F5A,$6F96,$6F76,$6F6C,$6F82,
$6F55,$6F72,$6F52,$6F50,$6F57,$6F94,$6F93,$6F5D,$6F00,$6F61,$6F6B,$6F7D,$6F67,
$6F90,$6F53,$6F8B,$6F69,$6F7F,$6F95,$6F63,$6F77,$6F6A,$6F7B,$71B2,$71AF,$719B,
$71B0,$71A0,$719A,$71A9,$71B5,$719D,$71A5,$719E,$71A4,$71A1,$71AA,$719C,$71A7,
$71B3,$7298,$729A,$7358,$7352,$735E,$735F,$7360,$735D,$735B,$7361,$735A,$7359,
$7362,$7487,$7489,$748A,$7486,$7481,$747D,$7485,$7488,$747C,$7479,$7508,$7507,
$757E,$7625,$761E,$7619,$761D,$761C,$7623,$761A,$7628,$761B,$769C,$769D,$769E,
$769B,$778D,$778F,$7789,$7788,$78CD,$78BB,$78CF,$78CC,$78D1,$78CE,$78D4,$78C8,
$78C3,$78C4,$78C9,$799A,$79A1,$79A0,$799C,$79A2,$799B,$6B76,$7A39,$7AB2,$7AB4,
$7AB3,$7BB7,$7BCB,$7BBE,$7BAC,$7BCE,$7BAF,$7BB9,$7BCA,$7BB5,$7CC5,$7CC8,$7CCC,
$7CCB,$7DF7,$7DDB,$7DEA,$7DE7,$7DD7,$7DE1,$7E03,$7DFA,$7DE6,$7DF6,$7DF1,$7DF0,
$7DEE,$7DDF,$7F76,$7FAC,$7FB0,$7FAD,$7FED,$7FEB,$7FEA,$7FEC,$7FE6,$7FE8,$8064,
$8067,$81A3,$819F,$819E,$8195,$81A2,$8199,$8197,$8216,$824F,$8253,$8252,$8250,
$824E,$8251,$8524,$853B,$850F,$8500,$8529,$850E,$8509,$850D,$851F,$850A,$8527,
$851C,$84FB,$852B,$84FA,$8508,$850C,$84F4,$852A,$84F2,$8515,$84F7,$84EB,$84F3,
$84FC,$8512,$84EA,$84E9,$8516,$84FE,$8528,$851D,$852E,$8502,$84FD,$851E,$84F6,
$8531,$8526,$84E7,$84E8,$84F0,$84EF,$84F9,$8518,$8520,$8530,$850B,$8519,$852F,
$8662,$8756,$8763,$8764,$8777,$87E1,$8773,$8758,$8754,$875B,$8752,$8761,$875A,
$8751,$875E,$876D,$876A,$8750,$874E,$875F,$875D,$876F,$876C,$877A,$876E,$875C,
$8765,$874F,$877B,$8775,$8762,$8767,$8769,$885A,$8905,$890C,$8914,$890B,$8917,
$8918,$8919,$8906,$8916,$8911,$890E,$8909,$89A2,$89A4,$89A3,$89ED,$89F0,$89EC,
$8ACF,$8AC6,$8AB8,$8AD3,$8AD1,$8AD4,$8AD5,$8ABB,$8AD7,$8ABE,$8AC0,$8AC5,$8AD8,
$8AC3,$8ABA,$8ABD,$8AD9,$8C3E,$8C4D,$8C8F,$8CE5,$8CDF,$8CD9,$8CE8,$8CDA,$8CDD,
$8CE7,$8DA0,$8D9C,$8DA1,$8D9B,$8E20,$8E23,$8E25,$8E24,$8E2E,$8E15,$8E1B,$8E16,
$8E11,$8E19,$8E26,$8E27,$8E14,$8E12,$8E18,$8E13,$8E1C,$8E17,$8E1A,$8F2C,$8F24,
$8F18,$8F1A,$8F20,$8F23,$8F16,$8F17,$9073,$9070,$906F,$9067,$906B,$912F,$912B,
$9129,$912A,$9132,$9126,$912E,$9185,$9186,$918A,$9181,$9182,$9184,$9180,$92D0,
$92C3,$92C4,$92C0,$92D9,$92B6,$92CF,$92F1,$92DF,$92D8,$92E9,$92D7,$92DD,$92CC,
$92EF,$92C2,$92E8,$92CA,$92C8,$92CE,$92E6,$92CD,$92D5,$92C9,$92E0,$92DE,$92E7,
$92D1,$92D3,$92B5,$92E1,$92C6,$92B4,$957C,$95AC,$95AB,$95AE,$95B0,$96A4,$96A2,
$96D3,$9705,$9708,$9702,$975A,$978A,$978E,$9788,$97D0,$97CF,$981E,$981D,$9826,
$9829,$9828,$9820,$981B,$9827,$98B2,$9908,$98FA,$9911,$9914,$9916,$9917,$9915,
$99DC,$99CD,$99CF,$99D3,$99D4,$99CE,$99C9,$99D6,$99D8,$99CB,$99D7,$99CC,$9AB3,
$9AEC,$9AEB,$9AF3,$9AF2,$9AF1,$9B46,$9B43,$9B67,$9B74,$9B71,$9B66,$9B76,$9B75,
$9B70,$9B68,$9B64,$9B6C,$9CFC,$9CFA,$9CFD,$9CFF,$9CF7,$9D07,$9D00,$9CF9,$9CFB,
$9D08,$9D05,$9D04,$9E83,$9ED3,$9F0F,$9F10,$511C,$5113,$5117,$511A,$5111,$51DE,
$5334,$53E1,$5670,$5660,$566E,$5673,$5666,$5663,$566D,$5672,$565E,$5677,$571C,
$571B,$58C8,$58BD,$58C9,$58BF,$58BA,$58C2,$58BC,$58C6,$5B17,$5B19,$5B1B,$5B21,
$5B14,$5B13,$5B10,$5B16,$5B28,$5B1A,$5B20,$5B1E,$5BEF,$5DAC,$5DB1,$5DA9,$5DA7,
$5DB5,$5DB0,$5DAE,$5DAA,$5DA8,$5DB2,$5DAD,$5DAF,$5DB4,$5E67,$5E68,$5E66,$5E6F,
$5EE9,$5EE7,$5EE6,$5EE8,$5EE5,$5F4B,$5FBC,$619D,$61A8,$6196,$61C5,$61B4,$61C6,
$61C1,$61CC,$61BA,$61BF,$61B8,$618C,$64D7,$64D6,$64D0,$64CF,$64C9,$64BD,$6489,
$64C3,$64DB,$64F3,$64D9,$6533,$657F,$657C,$65A2,$66C8,$66BE,$66C0,$66CA,$66CB,
$66CF,$66BD,$66BB,$66BA,$66CC,$6723,$6A34,$6A66,$6A49,$6A67,$6A32,$6A68,$6A3E,
$6A5D,$6A6D,$6A76,$6A5B,$6A51,$6A28,$6A5A,$6A3B,$6A3F,$6A41,$6A6A,$6A64,$6A50,
$6A4F,$6A54,$6A6F,$6A69,$6A60,$6A3C,$6A5E,$6A56,$6A55,$6A4D,$6A4E,$6A46,$6B55,
$6B54,$6B56,$6BA7,$6BAA,$6BAB,$6BC8,$6BC7,$6C04,$6C03,$6C06,$6FAD,$6FCB,$6FA3,
$6FC7,$6FBC,$6FCE,$6FC8,$6F5E,$6FC4,$6FBD,$6F9E,$6FCA,$6FA8,$7004,$6FA5,$6FAE,
$6FBA,$6FAC,$6FAA,$6FCF,$6FBF,$6FB8,$6FA2,$6FC9,$6FAB,$6FCD,$6FAF,$6FB2,$6FB0,
$71C5,$71C2,$71BF,$71B8,$71D6,$71C0,$71C1,$71CB,$71D4,$71CA,$71C7,$71CF,$71BD,
$71D8,$71BC,$71C6,$71DA,$71DB,$729D,$729E,$7369,$7366,$7367,$736C,$7365,$736B,
$736A,$747F,$749A,$74A0,$7494,$7492,$7495,$74A1,$750B,$7580,$762F,$762D,$7631,
$763D,$7633,$763C,$7635,$7632,$7630,$76BB,$76E6,$779A,$779D,$77A1,$779C,$779B,
$77A2,$77A3,$7795,$7799,$7797,$78DD,$78E9,$78E5,$78EA,$78DE,$78E3,$78DB,$78E1,
$78E2,$78ED,$78DF,$78E0,$79A4,$7A44,$7A48,$7A47,$7AB6,$7AB8,$7AB5,$7AB1,$7AB7,
$7BDE,$7BE3,$7BE7,$7BDD,$7BD5,$7BE5,$7BDA,$7BE8,$7BF9,$7BD4,$7BEA,$7BE2,$7BDC,
$7BEB,$7BD8,$7BDF,$7CD2,$7CD4,$7CD7,$7CD0,$7CD1,$7E12,$7E21,$7E17,$7E0C,$7E1F,
$7E20,$7E13,$7E0E,$7E1C,$7E15,$7E1A,$7E22,$7E0B,$7E0F,$7E16,$7E0D,$7E14,$7E25,
$7E24,$7F43,$7F7B,$7F7C,$7F7A,$7FB1,$7FEF,$802A,$8029,$806C,$81B1,$81A6,$81AE,
$81B9,$81B5,$81AB,$81B0,$81AC,$81B4,$81B2,$81B7,$81A7,$81F2,$8255,$8256,$8257,
$8556,$8545,$856B,$854D,$8553,$8561,$8558,$8540,$8546,$8564,$8541,$8562,$8544,
$8551,$8547,$8563,$853E,$855B,$8571,$854E,$856E,$8575,$8555,$8567,$8560,$858C,
$8566,$855D,$8554,$8565,$856C,$8663,$8665,$8664,$879B,$878F,$8797,$8793,$8792,
$8788,$8781,$8796,$8798,$8779,$8787,$87A3,$8785,$8790,$8791,$879D,$8784,$8794,
$879C,$879A,$8789,$891E,$8926,$8930,$892D,$892E,$8927,$8931,$8922,$8929,$8923,
$892F,$892C,$891F,$89F1,$8AE0,$8AE2,$8AF2,$8AF4,$8AF5,$8ADD,$8B14,$8AE4,$8ADF,
$8AF0,$8AC8,$8ADE,$8AE1,$8AE8,$8AFF,$8AEF,$8AFB,$8C91,$8C92,$8C90,$8CF5,$8CEE,
$8CF1,$8CF0,$8CF3,$8D6C,$8D6E,$8DA5,$8DA7,$8E33,$8E3E,$8E38,$8E40,$8E45,$8E36,
$8E3C,$8E3D,$8E41,$8E30,$8E3F,$8EBD,$8F36,$8F2E,$8F35,$8F32,$8F39,$8F37,$8F34,
$9076,$9079,$907B,$9086,$90FA,$9133,$9135,$9136,$9193,$9190,$9191,$918D,$918F,
$9327,$931E,$9308,$931F,$9306,$930F,$937A,$9338,$933C,$931B,$9323,$9312,$9301,
$9346,$932D,$930E,$930D,$92CB,$931D,$92FA,$9325,$9313,$92F9,$92F7,$9334,$9302,
$9324,$92FF,$9329,$9339,$9335,$932A,$9314,$930C,$930B,$92FE,$9309,$9300,$92FB,
$9316,$95BC,$95CD,$95BE,$95B9,$95BA,$95B6,$95BF,$95B5,$95BD,$96A9,$96D4,$970B,
$9712,$9710,$9799,$9797,$9794,$97F0,$97F8,$9835,$982F,$9832,$9924,$991F,$9927,
$9929,$999E,$99EE,$99EC,$99E5,$99E4,$99F0,$99E3,$99EA,$99E9,$99E7,$9AB9,$9ABF,
$9AB4,$9ABB,$9AF6,$9AFA,$9AF9,$9AF7,$9B33,$9B80,$9B85,$9B87,$9B7C,$9B7E,$9B7B,
$9B82,$9B93,$9B92,$9B90,$9B7A,$9B95,$9B7D,$9B88,$9D25,$9D17,$9D20,$9D1E,$9D14,
$9D29,$9D1D,$9D18,$9D22,$9D10,$9D19,$9D1F,$9E88,$9E86,$9E87,$9EAE,$9EAD,$9ED5,
$9ED6,$9EFA,$9F12,$9F3D,$5126,$5125,$5122,$5124,$5120,$5129,$52F4,$5693,$568C,
$568D,$5686,$5684,$5683,$567E,$5682,$567F,$5681,$58D6,$58D4,$58CF,$58D2,$5B2D,
$5B25,$5B32,$5B23,$5B2C,$5B27,$5B26,$5B2F,$5B2E,$5B7B,$5BF1,$5BF2,$5DB7,$5E6C,
$5E6A,$5FBE,$5FBB,$61C3,$61B5,$61BC,$61E7,$61E0,$61E5,$61E4,$61E8,$61DE,$64EF,
$64E9,$64E3,$64EB,$64E4,$64E8,$6581,$6580,$65B6,$65DA,$66D2,$6A8D,$6A96,$6A81,
$6AA5,$6A89,$6A9F,$6A9B,$6AA1,$6A9E,$6A87,$6A93,$6A8E,$6A95,$6A83,$6AA8,$6AA4,
$6A91,$6A7F,$6AA6,$6A9A,$6A85,$6A8C,$6A92,$6B5B,$6BAD,$6C09,$6FCC,$6FA9,$6FF4,
$6FD4,$6FE3,$6FDC,$6FED,$6FE7,$6FE6,$6FDE,$6FF2,$6FDD,$6FE2,$6FE8,$71E1,$71F1,
$71E8,$71F2,$71E4,$71F0,$71E2,$7373,$736E,$736F,$7497,$74B2,$74AB,$7490,$74AA,
$74AD,$74B1,$74A5,$74AF,$7510,$7511,$7512,$750F,$7584,$7643,$7648,$7649,$7647,
$76A4,$76E9,$77B5,$77AB,$77B2,$77B7,$77B6,$77B4,$77B1,$77A8,$77F0,$78F3,$78FD,
$7902,$78FB,$78FC,$78F2,$7905,$78F9,$78FE,$7904,$79AB,$79A8,$7A5C,$7A5B,$7A56,
$7A58,$7A54,$7A5A,$7ABE,$7AC0,$7AC1,$7C05,$7C0F,$7BF2,$7C00,$7BFF,$7BFB,$7C0E,
$7BF4,$7C0B,$7BF3,$7C02,$7C09,$7C03,$7C01,$7BF8,$7BFD,$7C06,$7BF0,$7BF1,$7C10,
$7C0A,$7CE8,$7E2D,$7E3C,$7E42,$7E33,$9848,$7E38,$7E2A,$7E49,$7E40,$7E47,$7E29,
$7E4C,$7E30,$7E3B,$7E36,$7E44,$7E3A,$7F45,$7F7F,$7F7E,$7F7D,$7FF4,$7FF2,$802C,
$81BB,$81C4,$81CC,$81CA,$81C5,$81C7,$81BC,$81E9,$825B,$825A,$825C,$8583,$8580,
$858F,$85A7,$8595,$85A0,$858B,$85A3,$857B,$85A4,$859A,$859E,$8577,$857C,$8589,
$85A1,$857A,$8578,$8557,$858E,$8596,$8586,$858D,$8599,$859D,$8581,$85A2,$8582,
$8588,$8585,$8579,$8576,$8598,$8590,$859F,$8668,$87BE,$87AA,$87AD,$87C5,$87B0,
$87AC,$87B9,$87B5,$87BC,$87AE,$87C9,$87C3,$87C2,$87CC,$87B7,$87AF,$87C4,$87CA,
$87B4,$87B6,$87BF,$87B8,$87BD,$87DE,$87B2,$8935,$8933,$893C,$893E,$8941,$8952,
$8937,$8942,$89AD,$89AF,$89AE,$89F2,$89F3,$8B1E,$8B18,$8B16,$8B11,$8B05,$8B0B,
$8B22,$8B0F,$8B12,$8B15,$8B07,$8B0D,$8B08,$8B06,$8B1C,$8B13,$8B1A,$8C4F,$8C70,
$8C72,$8C71,$8C6F,$8C95,$8C94,$8CF9,$8D6F,$8E4E,$8E4D,$8E53,$8E50,$8E4C,$8E47,
$8F43,$8F40,$9085,$907E,$9138,$919A,$91A2,$919B,$9199,$919F,$91A1,$919D,$91A0,
$93A1,$9383,$93AF,$9364,$9356,$9347,$937C,$9358,$935C,$9376,$9349,$9350,$9351,
$9360,$936D,$938F,$934C,$936A,$9379,$9357,$9355,$9352,$934F,$9371,$9377,$937B,
$9361,$935E,$9363,$9367,$9380,$934E,$9359,$95C7,$95C0,$95C9,$95C3,$95C5,$95B7,
$96AE,$96B0,$96AC,$9720,$971F,$9718,$971D,$9719,$979A,$97A1,$979C,$979E,$979D,
$97D5,$97D4,$97F1,$9841,$9844,$984A,$9849,$9845,$9843,$9925,$992B,$992C,$992A,
$9933,$9932,$992F,$992D,$9931,$9930,$9998,$99A3,$99A1,$9A02,$99FA,$99F4,$99F7,
$99F9,$99F8,$99F6,$99FB,$99FD,$99FE,$99FC,$9A03,$9ABE,$9AFE,$9AFD,$9B01,$9AFC,
$9B48,$9B9A,$9BA8,$9B9E,$9B9B,$9BA6,$9BA1,$9BA5,$9BA4,$9B86,$9BA2,$9BA0,$9BAF,
$9D33,$9D41,$9D67,$9D36,$9D2E,$9D2F,$9D31,$9D38,$9D30,$9D45,$9D42,$9D43,$9D3E,
$9D37,$9D40,$9D3D,$7FF5,$9D2D,$9E8A,$9E89,$9E8D,$9EB0,$9EC8,$9EDA,$9EFB,$9EFF,
$9F24,$9F23,$9F22,$9F54,$9FA0,$5131,$512D,$512E,$5698,$569C,$5697,$569A,$569D,
$5699,$5970,$5B3C,$5C69,$5C6A,$5DC0,$5E6D,$5E6E,$61D8,$61DF,$61ED,$61EE,$61F1,
$61EA,$61F0,$61EB,$61D6,$61E9,$64FF,$6504,$64FD,$64F8,$6501,$6503,$64FC,$6594,
$65DB,$66DA,$66DB,$66D8,$6AC5,$6AB9,$6ABD,$6AE1,$6AC6,$6ABA,$6AB6,$6AB7,$6AC7,
$6AB4,$6AAD,$6B5E,$6BC9,$6C0B,$7007,$700C,$700D,$7001,$7005,$7014,$700E,$6FFF,
$7000,$6FFB,$7026,$6FFC,$6FF7,$700A,$7201,$71FF,$71F9,$7203,$71FD,$7376,$74B8,
$74C0,$74B5,$74C1,$74BE,$74B6,$74BB,$74C2,$7514,$7513,$765C,$7664,$7659,$7650,
$7653,$7657,$765A,$76A6,$76BD,$76EC,$77C2,$77BA,$78FF,$790C,$7913,$7914,$7909,
$7910,$7912,$7911,$79AD,$79AC,$7A5F,$7C1C,$7C29,$7C19,$7C20,$7C1F,$7C2D,$7C1D,
$7C26,$7C28,$7C22,$7C25,$7C30,$7E5C,$7E50,$7E56,$7E63,$7E58,$7E62,$7E5F,$7E51,
$7E60,$7E57,$7E53,$7FB5,$7FB3,$7FF7,$7FF8,$8075,$81D1,$81D2,$81D0,$825F,$825E,
$85B4,$85C6,$85C0,$85C3,$85C2,$85B3,$85B5,$85BD,$85C7,$85C4,$85BF,$85CB,$85CE,
$85C8,$85C5,$85B1,$85B6,$85D2,$8624,$85B8,$85B7,$85BE,$8669,$87E7,$87E6,$87E2,
$87DB,$87EB,$87EA,$87E5,$87DF,$87F3,$87E4,$87D4,$87DC,$87D3,$87ED,$87D8,$87E3,
$87A4,$87D7,$87D9,$8801,$87F4,$87E8,$87DD,$8953,$894B,$894F,$894C,$8946,$8950,
$8951,$8949,$8B2A,$8B27,$8B23,$8B33,$8B30,$8B35,$8B47,$8B2F, $8B3C,$8B3E,$8B31,
$8B25,$8B37,$8B26,$8B36,$8B2E,$8B24,$8B3B,$8B3D,$8B3A,$8C42,$8C75,$8C99,$8C98,
$8C97,$8CFE,$8D04,$8D02,$8D00,$8E5C,$8E62,$8E60,$8E57,$8E56,$8E5E,$8E65,$8E67,
$8E5B,$8E5A,$8E61,$8E5D,$8E69,$8E54,$8F46,$8F47,$8F48,$8F4B,$9128,$913A,$913B,
$913E,$91A8,$91A5,$91A7,$91AF,$91AA,$93B5,$938C,$9392,$93B7,$939B,$939D,$9389,
$93A7,$938E,$93AA,$939E,$93A6,$9395,$9388,$9399,$939F,$938D,$93B1,$9391,$93B2,
$93A4,$93A8,$93B4,$93A3,$93A5,$95D2,$95D3,$95D1,$96B3,$96D7,$96DA,$5DC2,$96DF,
$96D8,$96DD,$9723,$9722,$9725,$97AC,$97AE,$97A8,$97AB,$97A4,$97AA,$97A2,$97A5,
$97D7,$97D9,$97D6,$97D8,$97FA,$9850,$9851,$9852,$98B8,$9941,$993C,$993A,$9A0F,
$9A0B,$9A09,$9A0D,$9A04,$9A11,$9A0A,$9A05,$9A07,$9A06,$9AC0,$9ADC,$9B08,$9B04,
$9B05,$9B29,$9B35,$9B4A,$9B4C,$9B4B,$9BC7,$9BC6,$9BC3,$9BBF,$9BC1,$9BB5,$9BB8,
$9BD3,$9BB6,$9BC4,$9BB9,$9BBD,$9D5C,$9D53,$9D4F,$9D4A,$9D5B,$9D4B,$9D59,$9D56,
$9D4C,$9D57,$9D52,$9D54,$9D5F,$9D58,$9D5A,$9E8E,$9E8C,$9EDF,$9F01,$9F00,$9F16,
$9F25,$9F2B,$9F2A,$9F29,$9F28,$9F4C,$9F55,$5134,$5135,$5296,$52F7,$53B4,$56AB,
$56AD,$56A6,$56A7,$56AA,$56AC,$58DA,$58DD,$58DB,$5912,$5B3D,$5B3E,$5B3F,$5DC3,
$5E70,$5FBF,$61FB,$6507,$6510,$650D,$6509,$650C,$650E,$6584,$65DE,$65DD,$66DE,
$6AE7,$6AE0,$6ACC,$6AD1,$6AD9,$6ACB,$6ADF,$6ADC,$6AD0,$6AEB,$6ACF,$6ACD,$6ADE,
$6B60,$6BB0,$6C0C,$7019,$7027,$7020,$7016,$702B,$7021,$7022,$7023,$7029,$7017,
$7024,$701C,$702A,$720C,$720A,$7207,$7202,$7205,$72A5,$72A6,$72A4,$72A3,$72A1,
$74CB,$74C5,$74B7,$74C3,$7516,$7660,$77C9,$77CA,$77C4,$77F1,$791D,$791B,$7921,
$791C,$7917,$791E,$79B0,$7A67,$7A68,$7C33,$7C3C,$7C39,$7C2C,$7C3B,$7CEC,$7CEA,
$7E76,$7E75,$7E78,$7E70,$7E77,$7E6F,$7E7A,$7E72,$7E74,$7E68,$7F4B,$7F4A,$7F83,
$7F86,$7FB7,$7FFD,$7FFE,$8078,$81D7,$81D5,$8264,$8261,$8263,$85EB,$85F1,$85ED,
$85D9,$85E1,$85E8,$85DA,$85D7,$85EC,$85F2,$85F8,$85D8,$85DF,$85E3,$85DC,$85D1,
$85F0,$85E6,$85EF,$85DE,$85E2,$8800,$87FA,$8803,$87F6,$87F7,$8809,$880C,$880B,
$8806,$87FC,$8808,$87FF,$880A,$8802,$8962,$895A,$895B,$8957,$8961,$895C,$8958,
$895D,$8959,$8988,$89B7,$89B6,$89F6,$8B50,$8B48,$8B4A,$8B40,$8B53,$8B56,$8B54,
$8B4B,$8B55,$8B51,$8B42,$8B52,$8B57,$8C43,$8C77,$8C76,$8C9A,$8D06,$8D07,$8D09,
$8DAC,$8DAA,$8DAD,$8DAB,$8E6D,$8E78,$8E73,$8E6A,$8E6F,$8E7B,$8EC2,$8F52,$8F51,
$8F4F,$8F50,$8F53,$8FB4,$9140,$913F,$91B0,$91AD,$93DE,$93C7,$93CF,$93C2,$93DA,
$93D0,$93F9,$93EC,$93CC,$93D9,$93A9,$93E6,$93CA,$93D4,$93EE,$93E3,$93D5,$93C4,
$93CE,$93C0,$93D2,$93E7,$957D,$95DA,$95DB,$96E1,$9729,$972B,$972C,$9728,$9726,
$97B3,$97B7,$97B6,$97DD,$97DE,$97DF,$985C,$9859,$985D,$9857,$98BF,$98BD,$98BB,
$98BE,$9948,$9947,$9943,$99A6,$99A7,$9A1A,$9A15,$9A25,$9A1D,$9A24,$9A1B,$9A22,
$9A20,$9A27,$9A23,$9A1E,$9A1C,$9A14,$9AC2,$9B0B,$9B0A,$9B0E,$9B0C,$9B37,$9BEA,
$9BEB,$9BE0,$9BDE,$9BE4,$9BE6,$9BE2,$9BF0,$9BD4,$9BD7,$9BEC,$9BDC,$9BD9,$9BE5,
$9BD5,$9BE1,$9BDA,$9D77,$9D81,$9D8A,$9D84,$9D88,$9D71,$9D80,$9D78,$9D86,$9D8B,
$9D8C,$9D7D,$9D6B,$9D74,$9D75,$9D70,$9D69,$9D85,$9D73,$9D7B,$9D82,$9D6F,$9D79,
$9D7F,$9D87,$9D68,$9E94,$9E91,$9EC0,$9EFC,$9F2D,$9F40,$9F41,$9F4D,$9F56,$9F57,
$9F58,$5337,$56B2,$56B5,$56B3,$58E3,$5B45,$5DC6,$5DC7,$5EEE,$5EEF,$5FC0,$5FC1,
$61F9,$6517,$6516,$6515,$6513,$65DF,$66E8,$66E3,$66E4,$6AF3,$6AF0,$6AEA,$6AE8,
$6AF9,$6AF1,$6AEE,$6AEF,$703C,$7035,$702F,$7037,$7034,$7031,$7042,$7038,$703F,
$703A,$7039,$7040,$703B,$7033,$7041,$7213,$7214,$72A8,$737D,$737C,$74BA,$76AB,
$76AA,$76BE,$76ED,$77CC,$77CE,$77CF,$77CD,$77F2,$7925,$7923,$7927,$7928,$7924,
$7929,$79B2,$7A6E,$7A6C,$7A6D,$7AF7,$7C49,$7C48,$7C4A,$7C47,$7C45,$7CEE,$7E7B,
$7E7E,$7E81,$7E80,$7FBA,$7FFF,$8079,$81DB,$81D9,$820B,$8268,$8269,$8622,$85FF,
$8601,$85FE,$861B,$8600,$85F6,$8604,$8609,$8605,$860C,$85FD,$8819,$8810,$8811,
$8817,$8813,$8816,$8963,$8966,$89B9,$89F7,$8B60,$8B6A,$8B5D,$8B68,$8B63,$8B65,
$8B67,$8B6D,$8DAE,$8E86,$8E88,$8E84,$8F59,$8F56,$8F57,$8F55,$8F58,$8F5A,$908D,
$9143,$9141,$91B7,$91B5,$91B2,$91B3,$940B,$9413,$93FB,$9420,$940F,$9414,$93FE,
$9415,$9410,$9428,$9419,$940D,$93F5,$9400,$93F7,$9407,$940E,$9416,$9412,$93FA,
$9409,$93F8,$940A,$93FF,$93FC,$940C,$93F6,$9411,$9406,$95DE,$95E0,$95DF,$972E,
$972F,$97B9,$97BB,$97FD,$97FE,$9860,$9862,$9863,$985F,$98C1,$98C2,$9950,$994E,
$9959,$994C,$994B,$9953,$9A32,$9A34,$9A31,$9A2C,$9A2A,$9A36,$9A29,$9A2E,$9A38,
$9A2D,$9AC7,$9ACA,$9AC6,$9B10,$9B12,$9B11,$9C0B,$9C08,$9BF7,$9C05,$9C12,$9BF8,
$9C40,$9C07,$9C0E,$9C06,$9C17,$9C14,$9C09,$9D9F,$9D99,$9DA4,$9D9D,$9D92,$9D98,
$9D90,$9D9B,$9DA0,$9D94,$9D9C,$9DAA,$9D97,$9DA1,$9D9A,$9DA2,$9DA8,$9D9E,$9DA3,
$9DBF,$9DA9,$9D96,$9DA6,$9DA7,$9E99,$9E9B,$9E9A,$9EE5,$9EE4,$9EE7,$9EE6,$9F30,
$9F2E,$9F5B,$9F60,$9F5E,$9F5D,$9F59,$9F91,$513A,$5139,$5298,$5297,$56C3,$56BD,
$56BE,$5B48,$5B47,$5DCB,$5DCF,$5EF1,$61FD,$651B,$6B02,$6AFC,$6B03,$6AF8,$6B00,
$7043,$7044,$704A,$7048,$7049,$7045,$7046,$721D,$721A,$7219,$737E,$7517,$766A,
$77D0,$792D,$7931,$792F,$7C54,$7C53,$7CF2,$7E8A,$7E87,$7E88,$7E8B,$7E86,$7E8D,
$7F4D,$7FBB,$8030,$81DD,$8618,$862A,$8626,$861F,$8623,$861C,$8619,$8627,$862E,
$8621,$8620,$8629,$861E,$8625,$8829,$881D,$881B,$8820,$8824,$881C,$882B,$884A,
$896D,$8969,$896E,$896B,$89FA,$8B79,$8B78,$8B45,$8B7A,$8B7B,$8D10,$8D14,$8DAF,
$8E8E,$8E8C,$8F5E,$8F5B,$8F5D,$9146,$9144,$9145,$91B9,$943F,$943B,$9436,$9429,
$943D,$943C,$9430,$9439,$942A,$9437,$942C,$9440,$9431,$95E5,$95E4,$95E3,$9735,
$973A,$97BF,$97E1,$9864,$98C9,$98C6,$98C0,$9958,$9956,$9A39,$9A3D,$9A46,$9A44,
$9A42,$9A41,$9A3A,$9A3F,$9ACD,$9B15,$9B17,$9B18,$9B16,$9B3A,$9B52,$9C2B,$9C1D,
$9C1C,$9C2C,$9C23,$9C28,$9C29,$9C24,$9C21,$9DB7,$9DB6,$9DBC,$9DC1,$9DC7,$9DCA,
$9DCF,$9DBE,$9DC5,$9DC3,$9DBB,$9DB5,$9DCE,$9DB9,$9DBA,$9DAC,$9DC8,$9DB1,$9DAD,
$9DCC,$9DB3,$9DCD,$9DB2,$9E7A,$9E9C,$9EEB,$9EEE,$9EED,$9F1B,$9F18,$9F1A,$9F31,
$9F4E,$9F65,$9F64,$9F92,$4EB9,$56C6,$56C5,$56CB,$5971,$5B4B,$5B4C,$5DD5,$5DD1,
$5EF2,$6521,$6520,$6526,$6522,$6B0B,$6B08,$6B09,$6C0D,$7055,$7056,$7057,$7052,
$721E,$721F,$72A9,$737F,$74D8,$74D5,$74D9,$74D7,$766D,$76AD,$7935,$79B4,$7A70,
$7A71,$7C57,$7C5C,$7C59,$7C5B,$7C5A,$7CF4,$7CF1,$7E91,$7F4F,$7F87,$81DE,$826B,
$8634,$8635,$8633,$862C,$8632,$8636,$882C,$8828,$8826,$882A,$8825,$8971,$89BF,
$89BE,$89FB,$8B7E,$8B84,$8B82,$8B86,$8B85,$8B7F,$8D15,$8E95,$8E94,$8E9A,$8E92,
$8E90,$8E96,$8E97,$8F60,$8F62,$9147,$944C,$9450,$944A,$944B,$944F,$9447,$9445,
$9448,$9449,$9446,$973F,$97E3,$986A,$9869,$98CB,$9954,$995B,$9A4E,$9A53,$9A54,
$9A4C,$9A4F,$9A48,$9A4A,$9A49,$9A52,$9A50,$9AD0,$9B19,$9B2B,$9B3B,$9B56,$9B55,
$9C46,$9C48,$9C3F,$9C44,$9C39,$9C33,$9C41,$9C3C,$9C37,$9C34,$9C32,$9C3D,$9C36,
$9DDB,$9DD2,$9DDE,$9DDA,$9DCB,$9DD0,$9DDC,$9DD1,$9DDF,$9DE9,$9DD9,$9DD8,$9DD6,
$9DF5,$9DD5,$9DDD,$9EB6,$9EF0,$9F35,$9F33,$9F32,$9F42,$9F6B,$9F95,$9FA2,$513D,
$5299,$58E8,$58E7,$5972,$5B4D,$5DD8,$882F,$5F4F,$6201,$6203,$6204,$6529,$6525,
$6596,$66EB,$6B11,$6B12,$6B0F,$6BCA,$705B,$705A,$7222,$7382,$7381,$7383,$7670,
$77D4,$7C67,$7C66,$7E95,$826C,$863A,$8640,$8639,$863C,$8631,$863B,$863E,$8830,
$8832,$882E,$8833,$8976,$8974,$8973,$89FE,$8B8C,$8B8E,$8B8B,$8B88,$8C45,$8D19,
$8E98,$8F64,$8F63,$91BC,$9462,$9455,$945D,$9457,$945E,$97C4,$97C5,$9800,$9A56,
$9A59,$9B1E,$9B1F,$9B20,$9C52,$9C58,$9C50,$9C4A,$9C4D,$9C4B,$9C55,$9C59,$9C4C,
$9C4E,$9DFB,$9DF7,$9DEF,$9DE3,$9DEB,$9DF8,$9DE4,$9DF6,$9DE1,$9DEE,$9DE6,$9DF2,
$9DF0,$9DE2,$9DEC,$9DF4,$9DF3,$9DE8,$9DED,$9EC2,$9ED0,$9EF2,$9EF3,$9F06,$9F1C,
$9F38,$9F37,$9F36,$9F43,$9F4F,$9F71,$9F70,$9F6E,$9F6F,$56D3,$56CD,$5B4E,$5C6D,
$652D,$66ED,$66EE,$6B13,$705F,$7061,$705D,$7060,$7223,$74DB,$74E5,$77D5,$7938,
$79B7,$79B6,$7C6A,$7E97,$7F89,$826D,$8643,$8838,$8837,$8835,$884B,$8B94,$8B95,
$8E9E,$8E9F,$8EA0,$8E9D,$91BE,$91BD,$91C2,$946B,$9468,$9469,$96E5,$9746,$9743,
$9747,$97C7,$97E5,$9A5E,$9AD5,$9B59,$9C63,$9C67,$9C66,$9C62,$9C5E,$9C60,$9E02,
$9DFE,$9E07,$9E03,$9E06,$9E05,$9E00,$9E01,$9E09,$9DFF,$9DFD,$9E04,$9EA0,$9F1E,
$9F46,$9F74,$9F75,$9F76,$56D4,$652E,$65B8,$6B18,$6B19,$6B17,$6B1A,$7062,$7226,
$72AA,$77D8,$77D9,$7939,$7C69,$7C6B,$7CF6,$7E9A,$7E98,$7E9B,$7E99,$81E0,$81E1,
$8646,$8647,$8648,$8979,$897A,$897C,$897B,$89FF,$8B98,$8B99,$8EA5,$8EA4,$8EA3,
$946E,$946D,$946F,$9471,$9473,$9749,$9872,$995F,$9C68,$9C6E,$9C6D,$9E0B,$9E0D,
$9E10,$9E0F,$9E12,$9E11,$9EA1,$9EF5,$9F09,$9F47,$9F78,$9F7B,$9F7A,$9F79,$571E,
$7066,$7C6F,$883C,$8DB2,$8EA6,$91C3,$9474,$9478,$9476,$9475,$9A60,$9C74,$9C73,
$9C71,$9C75,$9E14,$9E13,$9EF6,$9F0A,$9FA4,$7068,$7065,$7CF7,$866A,$883E,$883D,
$883F,$8B9E,$8C9C,$8EA9,$8EC9,$974B,$9873,$9874,$98CC,$9961,$99AB,$9A64,$9A66,
$9A67,$9B24,$9E15,$9E17,$9F48,$6207,$6B1E,$7227,$864C,$8EA8,$9482,$9480,$9481,
$9A69,$9A68,$9B2E,$9E19,$7229,$864B,$8B9F,$9483,$9C79,$9EB7,$7675,$9A6B,$9C7A,
$9E1D,$7069,$706A,$9EA4,$9F7E,$9F49,$9F98,$7881,$92B9,$88CF,$58BB,$6052,$7CA7,
$5AFA,$2554,$2566,$2557,$2560,$256C,$2563,$255A,$2569,$255D,$2552,$2564,$2555,
$255E,$256A,$2561,$2558,$2567,$255B,$2553,$2565,$2556,$255F,$256B,$2562,$2559,
$2568,$255C,$2551,$2550,$256D,$256E,$2570,$256F,$2593);

{$IfNDef UseSystemCPConv}
const CP950CU: CP950Arr =
($80,$81,$82,$83,$84,$85,$86,$87,$88,$89,$8A,$8B,$8C,$8D,$8E,$8F,$90,$91,$92,
$93,$94,$95,$96,$97,$98,$99,$9A,$9B,$9C,$9D,$9E,$9F,$A0,$A1,$A2,$A3,$A4,$A5,
$A6,$A7,$A8,$A9,$AA,$AB,$AC,$AD,$AE,$AF,$B0,$B1,$B2,$B3,$B4,$B5,$B6,$B7,$B8,
$B9,$BA,$BB,$BC,$BD,$BE,$BF,$C0,$C1,$C2,$C3,$C4,$C5,$C6,$C7,$C8,$C9,$CA,$CB,
$CC,$CD,$CE,$CF,$D0,$D1,$D2,$D3,$D4,$D5,$D6,$D7,$D8,$D9,$DA,$DB,$DC,$DD,$DE,
$DF,$E0,$E1,$E2,$E3,$E4,$E5,$E6,$E7,$E8,$E9,$EA,$EB,$EC,$ED,$EE,$EF,$F0,$F1,
$F2,$F3,$F4,$F5,$F6,$F7,$F8,$F9,$FA,$FB,$FC,$FD,$FE,$FF,$00,$01,$02,$03,$04,
$05,$06,$07,$08,$09,$0A,$0B,$0C,$0D,$0E,$0F,$10,$11,$12,$13,$14,$15,$16,$17,
$18,$19,$1A,$1B,$1C,$1D,$1E,$1F,$20,$21,$22,$23,$24,$25,$26,$27,$28,$29,$2A,
$2B,$2C,$2D,$2E,$2F,$30,$31,$32,$33,$34,$35,$36,$37,$38,$39,$3A,$3B,$3C,$3D,
$3E,$3F,$40,$41,$42,$43,$44,$45,$46,$47,$48,$49,$4A,$4B,$4C,$4D,$4E,$4F,$50,
$51,$52,$53,$54,$55,$56,$57,$58,$59,$5A,$5B,$5C,$5D,$5E,$5F,$60,$61,$62,$63,
$64,$65,$66,$67,$68,$69,$6A,$6B,$6C,$6D,$6E,$6F,$70,$71,$72,$73,$74,$75,$76,
$77,$78,$79,$7A,$7B,$7C,$7D,$7E,$7F,$A1B1,$A1C2,$A258,$A1D3,$A150,$A1D1,$A1D2,
$A3BE,$A3BC,$A3BD,$A3BF,$A1C5,$A3BB,$A344,$A345,$A346,$A347,$A348,$A349,$A34A,
$A34B,$A34C,$A34D,$A34E,$A34F,$A350,$A351,$A352,$A353,$A354,$A355,$A356,$A357,
$A358,$A359,$A35A,$A35B,$A35C,$A35D,$A35E,$A35F,$A360,$A361,$A362,$A363,$A364,
$A365,$A366,$A367,$A368,$A369,$A36A,$A36B,$A36C,$A36D,$A36E,$A36F,$A370,$A371,
$A372,$A373,$A156,$A158,$A1A5,$A1A6,$A1A7,$A1A8,$A14C,$A14B,$A145,$A1AC,$A1AB,
$A1B0,$A3E1,$A24A,$A1C1,$A24B,$A2B9,$A2BA,$A2BB,$A2BC,$A2BD,$A2BE,$A2BF,$A2C0,
$A2C1,$A2C2,$A1F6,$A1F4,$A1F7,$A1F5,$A1F8,$A1F9,$A1FB,$A1FA,$A241,$A1D4,$A1DB,
$A1E8,$A1E7,$A1FD,$A1FC,$A1E4,$A1E5,$A1EC,$A1ED,$A1EF,$A1EE,$A1DC,$A1DA,$A1DD,
$A1D8,$A1D9,$A1F2,$A1F3,$A1E6,$A1E9,$A277,$A278,$A27A,$A27B,$A27C,$A27D,$A275,
$A274,$A273,$A272,$A271,$A2A4,$F9F9,$F9F8,$F9E6,$F9EF,$F9DD,$F9E8,$F9F1,$F9DF,
$F9EC,$F9F5,$F9E3,$F9EE,$F9F7,$F9E5,$A2A5,$F9E9,$F9F2,$F9E0,$A2A7,$F9EB,$F9F4,
$F9E2,$F9E7,$F9F0,$F9DE,$F9ED,$F9F6,$F9E4,$A2A6,$F9EA,$F9F3,$F9E1,$A27E,$F9FA,
$A2A1,$F9FB,$A2A3,$F9FD,$A2A2,$F9FC,$A2AC,$A2AD,$A2AE,$A15A,$A262,$A263,$A264,
$A265,$A266,$A267,$A268,$A269,$A270,$A26F,$A26E,$A26D,$A26C,$A26B,$A26A,$F9FE,
$A276,$A279,$A1BD,$A1BC,$A1B6,$A1B5,$A1BF,$A1BE,$A1BB,$A1BA,$A1B3,$A1B7,$A1B4,
$A2A8,$A2A9,$A2AB,$A2AA,$A1B9,$A1B8,$A1F0,$A1F1,$A140,$A142,$A143,$A1B2,$A171,
$A172,$A16D,$A16E,$A175,$A176,$A179,$A17A,$A169,$A16A,$A245,$A165,$A166,$A1A9,
$A1AA,$A2C3,$A2C4,$A2C5,$A2C6,$A2C7,$A2C8,$A2C9,$A2CA,$A2CB,$A374,$A375,$A376,
$A377,$A378,$A379,$A37A,$A37B,$A37C,$A37D,$A37E,$A3A1,$A3A2,$A3A3,$A3A4,$A3A5,
$A3A6,$A3A7,$A3A8,$A3A9,$A3AA,$A3AB,$A3AC,$A3AD,$A3AE,$A3AF,$A3B0,$A3B1,$A3B2,
$A3B3,$A3B4,$A3B5,$A3B6,$A3B7,$A3B8,$A3B9,$A3BA,$A1C0,$A255,$A256,$A250,$A251,
$A252,$A254,$A257,$A253,$A1EB,$A1EA,$A24F,$A440,$A442,$A443,$C945,$A456,$A454,
$A457,$A455,$C946,$A4A3,$C94F,$C94D,$A4A2,$A4A1,$A542,$A541,$A540,$A543,$A4FE,
$A5E0,$A5E1,$A8C3,$A458,$A4A4,$C950,$A4A5,$C963,$A6EA,$CBB1,$A459,$A4A6,$A544,
$C964,$C940,$A444,$A45B,$C947,$A45C,$A4A7,$A545,$A547,$A546,$A5E2,$A5E3,$A8C4,
$ADBC,$A441,$C941,$A445,$A45E,$A45D,$A5E4,$A8C5,$B0AE,$D44B,$B6C3,$DCB1,$DCB2,
$A446,$A4A9,$A8C6,$A447,$C948,$A45F,$A4AA,$A4AC,$C951,$A4AD,$A4AB,$A5E5,$A8C7,
$A8C8,$AB45,$A460,$A4AE,$A5E6,$A5E8,$A5E7,$A6EB,$A8C9,$A8CA,$AB46,$AB47,$ADBD,
$DCB3,$F6D6,$A448,$A4B0,$A4AF,$C952,$A4B1,$A4B7,$A4B2,$A4B3,$C954,$C953,$A4B5,
$A4B6,$A4B4,$A54A,$A54B,$A54C,$A54D,$A549,$A550,$C96A,$C966,$C969,$A551,$A561,
$C968,$A54E,$A54F,$A548,$C965,$C967,$A5F5,$C9B0,$A5F2,$A5F6,$C9BA,$C9AE,$A5F3,
$C9B2,$A5F4,$A5F7,$A5E9,$C9B1,$A5F8,$C9B5,$C9B9,$C9B6,$C9B3,$A5EA,$A5EC,$A5F9,
$A5EE,$C9AB,$A5F1,$A5EF,$A5F0,$C9BB,$C9B8,$C9AF,$A5ED,$C9AC,$A5EB,$C9B4,$C9B7,
$C9AD,$CA66,$A742,$A6F4,$CA67,$A6F1,$A744,$A6F9,$A6F8,$CA5B,$A6FC,$A6F7,$CA60,
$CA68,$CA64,$A6FA,$A6FD,$A6EE,$A747,$CA5D,$CBBD,$A6EC,$A743,$A6ED,$A6F5,$A6F6,
$CA62,$CA5E,$A6FB,$A6F3,$CA5A,$A6EF,$CA65,$A745,$A748,$A6F2,$A740,$A746,$A6F0,
$CA63,$A741,$CA69,$CA5C,$A6FE,$CA5F,$CA61,$A8D8,$CBBF,$CBCB,$A8D0,$CBCC,$A8CB,
$A8D5,$A8CE,$CBB9,$A8D6,$CBB8,$CBBC,$CBC3,$CBC1,$A8DE,$A8D9,$CBB3,$CBB5,$A8DB,
$A8CF,$CBB6,$CBC2,$CBC9,$A8D4,$CBBB,$CBB4,$A8D3,$CBB7,$A8D7,$CBBA,$A8D2,$A8CD,
$A8DC,$CBC4,$A8DD,$CBC8,$CBC6,$CBCA,$A8DA,$CBBE,$CBB2,$CBC0,$A8D1,$CBC5,$A8CC,
$CBC7,$AB56,$AB4A,$CDE0,$CDE8,$AB49,$AB51,$AB5D,$CDEE,$CDEC,$CDE7,$AB4B,$CDED,
$CDE3,$AB59,$AB50,$AB58,$CDDE,$CDEA,$CDE1,$AB54,$CDE2,$CDDD,$AB5B,$AB4E,$AB57,
$AB4D,$CDDF,$CDE4,$CDEB,$AB55,$AB52,$CDE6,$AB5A,$CDE9,$CDE5,$AB4F,$AB5C,$AB53,
$AB4C,$AB48,$CDEF,$ADD7,$ADC1,$ADD1,$ADD6,$D0D0,$D0CF,$D0D4,$D0D5,$ADC4,$ADCD,
$ADDA,$ADCE,$D0C9,$ADC7,$D0CA,$ADDC,$ADD3,$ADBE,$ADBF,$D0DD,$B0BF,$ADCC,$ADCB,
$D0CB,$ADCF,$D45B,$ADC6,$D0D6,$ADD5,$ADD4,$ADCA,$D0CE,$D0D7,$D0C8,$ADC9,$D0D8,
$ADD2,$D0CC,$ADC0,$ADC3,$ADC2,$D0D9,$ADD0,$ADC5,$ADD9,$ADDB,$D0D3,$ADD8,$D0DB,
$D0CD,$D0DC,$D0D1,$D0DA,$D0D2,$ADC8,$D463,$D457,$B0B3,$D45C,$D462,$B0B2,$D455,
$B0B6,$D459,$D452,$B0B4,$D456,$B0B9,$B0BE,$D467,$D451,$B0BA,$D466,$B0B5,$D458,
$B0B1,$D453,$D44F,$D45D,$D450,$D44E,$D45A,$D460,$D461,$B0B7,$D85B,$D45E,$D44D,
$D45F,$B0C1,$D464,$B0C0,$D44C,$D454,$D465,$B0BC,$B0BB,$B0B8,$B0BD,$B0AF,$B0B0,
$B3C8,$D85E,$D857,$B3C5,$D85F,$D855,$D858,$B3C4,$D859,$B3C7,$D85D,$D853,$D852,
$B3C9,$B3CA,$B3C6,$B3CB,$D851,$D85C,$D85A,$D854,$B3C3,$D856,$B6CA,$B6C4,$DCB7,
$B6CD,$DCBD,$DCC0,$B6C6,$B6C7,$DCBA,$B6C5,$DCC3,$B6CB,$DCC4,$DCBF,$B6CC,$DCB4,
$B6C9,$DCB5,$DCBE,$DCBC,$DCB8,$B6C8,$DCB6,$B6CE,$DCBB,$DCC2,$DCB9,$DCC1,$B9B6,
$B9B3,$B9B4,$E0F9,$E0F1,$B9B2,$B9AF,$E0F2,$B9B1,$E0F5,$E0F7,$E0FE,$E0FD,$E0F8,
$B9AE,$E0F0,$B9AC,$E0F3,$B9B7,$E0F6,$E0FA,$B9B0,$B9AD,$E0FC,$E0FB,$B9B5,$E0F4,
$BBF8,$E4EC,$E4E9,$BBF9,$BBF7,$E4F0,$E4ED,$E4E6,$BBF6,$BBFA,$E4E7,$BBF5,$BBFD,
$E4EA,$E4EB,$BBFB,$BBFC,$E4F1,$E4EE,$E4EF,$BEAA,$E8F8,$BEA7,$E8F5,$BEA9,$BEAB,
$E8F6,$BEA8,$E8F7,$E8F4,$C076,$ECBD,$C077,$ECBB,$ECBC,$ECBA,$ECB9,$ECBE,$C075,
$EFB8,$EFB9,$E4E8,$EFB7,$C078,$C35F,$F1EB,$F1EC,$C4D7,$C4D8,$F5C1,$F5C0,$C56C,
$C56B,$F7D0,$A449,$A461,$A4B9,$A4B8,$A553,$A552,$A5FC,$A5FB,$A5FD,$A5FA,$A74A,
$A749,$A74B,$A8E0,$A8DF,$A8E1,$AB5E,$A259,$D0DE,$A25A,$B0C2,$A25C,$A25B,$D860,
$A25D,$B9B8,$A25E,$A44A,$A4BA,$A5FE,$A8E2,$A44B,$A4BD,$A4BB,$A4BC,$A640,$A74C,
$A8E4,$A8E3,$A8E5,$ADDD,$BEAC,$C94E,$A554,$A555,$A641,$CA6A,$AB60,$AB5F,$D0E0,
$D0DF,$B0C3,$A4BE,$C955,$CBCD,$AB61,$ADE0,$ADDE,$ADDF,$BEAD,$A556,$A642,$C9BC,
$A74D,$A74E,$CA6B,$CBCE,$A8E6,$CBCF,$D0E2,$D0E3,$ADE3,$D0E4,$D0E1,$ADE4,$ADE2,
$ADE1,$D0E5,$D468,$D861,$DCC5,$E140,$BBFE,$BEAE,$E8F9,$A44C,$A45A,$B0C4,$B3CD,
$B9B9,$C942,$A4BF,$A559,$A557,$A558,$A8E7,$A44D,$A44E,$A462,$A4C0,$A4C1,$A4C2,
$C9BE,$A55A,$C96B,$A646,$C9BF,$A644,$A645,$C9BD,$A647,$A643,$CA6C,$AAEC,$CA6D,
$CA6E,$A750,$A74F,$A753,$A751,$A752,$A8ED,$A8EC,$CBD4,$CBD1,$CBD2,$CBD0,$A8EE,
$A8EA,$A8E9,$A8EB,$A8E8,$A8EF,$AB63,$CDF0,$CBD3,$AB68,$CDF1,$AB64,$AB67,$AB66,
$AB65,$AB62,$D0E8,$ADE7,$D0EB,$ADE5,$D0E7,$ADE8,$ADE6,$ADE9,$D0E9,$D0EA,$D0E6,
$D0EC,$B3D1,$B0C5,$D469,$D46B,$D46A,$D46C,$B0C6,$B3CE,$B3CF,$B3D0,$B6D0,$DCC7,
$DCC6,$DCC8,$DCC9,$B6D1,$B6CF,$E141,$E142,$B9BB,$B9BA,$E35A,$BC40,$BC41,$BC42,
$BC44,$E4F2,$E4F3,$BC43,$BEAF,$BEB0,$F1ED,$F5C3,$F5C2,$F7D1,$A44F,$A55C,$A55B,
$A648,$C9C0,$A755,$A756,$A754,$A757,$CA6F,$CA70,$A8F1,$CBD5,$A8F0,$CDF2,$AB6C,
$CDF3,$AB6B,$AB69,$AB6A,$D0ED,$B0C7,$D46E,$B0CA,$D46D,$B1E5,$B0C9,$B0C8,$B3D4,
$B3D3,$B3D2,$B6D2,$B6D5,$B6D6,$B6D4,$B6D3,$E143,$E144,$E4F5,$BC45,$E4F4,$BEB1,
$ECBF,$C079,$F1EE,$C455,$A463,$A4C3,$C956,$A4C4,$A4C5,$A55D,$A55E,$A649,$CA71,
$CBD6,$CBD7,$AB6D,$D0EE,$B0CC,$B0CB,$D863,$D862,$A450,$A4C6,$A55F,$B0CD,$C943,
$C96C,$A560,$C9C2,$A64B,$A64A,$C9C1,$A758,$ADEA,$D46F,$B6D7,$E145,$B9BC,$E8FA,
$F3FD,$A4C7,$CBD8,$CDF4,$B0D0,$B0CE,$B0CF,$A2CC,$A451,$A464,$A2CD,$A2CE,$A4CA,
$A4C9,$A4C8,$A563,$A562,$C96D,$C9C3,$A8F5,$A8F2,$A8F4,$A8F3,$AB6E,$B3D5,$A452,
$A4CB,$A565,$A564,$CA72,$A8F6,$C957,$A567,$A566,$A64C,$A64D,$CA73,$A759,$A75A,
$A8F7,$A8F8,$A8F9,$AB6F,$CDF5,$ADEB,$C944,$A4CC,$C9C4,$CA74,$CA75,$CBD9,$CBDA,
$CDF7,$CDF6,$CDF9,$CDF8,$AB70,$D470,$ADED,$D0EF,$ADEC,$D864,$B3D6,$D865,$E146,
$B9BD,$BC46,$F1EF,$C958,$A568,$B0D1,$A453,$A465,$A4CE,$A4CD,$A4CF,$A8FB,$A8FA,
$A8FC,$AB71,$ADEE,$E8FB,$C24F,$A466,$A56A,$A579,$A574,$A56F,$A56E,$A575,$A573,
$A56C,$A57A,$A56D,$A569,$A578,$A577,$A576,$A56B,$A572,$A571,$A57B,$A570,$A653,
$A659,$A655,$A65B,$C9C5,$A658,$A64E,$A651,$A654,$A650,$A657,$A65A,$A64F,$A652,
$A656,$A65C,$CA7E,$CA7B,$A767,$CA7C,$A75B,$A75D,$A775,$A770,$CAA5,$CA7D,$A75F,
$A761,$CAA4,$A768,$CA78,$A774,$A776,$A75C,$A76D,$CA76,$A773,$A764,$A76E,$A76F,
$CA77,$A76C,$A76A,$A76B,$A771,$CAA1,$A75E,$A772,$CAA3,$A766,$A763,$CA7A,$A762,
$CAA6,$A765,$A769,$A760,$CAA2,$CA79,$CBEB,$CBEA,$A94F,$CBED,$CBEF,$CBE4,$CBE7,
$CBEE,$A950,$CBE1,$CBE5,$CBE9,$CE49,$A94B,$CE4D,$A8FD,$CBE6,$A8FE,$A94C,$A945,
$A941,$CBE2,$A944,$A949,$A952,$CBE3,$CBDC,$A943,$CBDD,$CBDF,$A946,$A948,$CBDB,
$CBE0,$A951,$A94D,$CBE8,$A953,$A94A,$CBDE,$A947,$A942,$A940,$CBEC,$A94E,$CE48,
$CDFB,$CE4B,$CDFD,$AB78,$ABA8,$AB74,$ABA7,$AB7D,$ABA4,$AB72,$CDFC,$CE43,$ABA3,
$CE4F,$ABA5,$AB79,$CE45,$CE42,$AB77,$CDFA,$ABA6,$CE4A,$AB7C,$CE4C,$ABA9,$AB73,
$AB7E,$AB7B,$CE40,$ABA1,$CE46,$CE47,$AB7A,$ABA2,$AB76,$AB75,$CDFE,$CE44,$CE4E,
$D144,$ADFB,$D0F1,$D0F6,$ADF4,$AE40,$D0F4,$ADEF,$ADF9,$ADFE,$D0FB,$ADFA,$ADFD,
$D0FE,$ADF5,$D0F5,$D142,$D143,$ADF7,$D141,$ADF3,$AE43,$D0F8,$ADF1,$D146,$D0F9,
$D0FD,$ADF6,$AE42,$D0FA,$ADFC,$D140,$D147,$D4A1,$D145,$AE44,$ADF0,$D0FC,$D0F3,
$ADF8,$D0F2,$D0F7,$D0F0,$AE41,$D477,$B0E4,$D4A7,$B0E2,$B0DF,$D47C,$B0DB,$D4A2,
$B0E6,$D476,$D47B,$D47A,$ADF2,$B0E1,$D4A5,$D4A8,$D473,$B3E8,$D4A9,$B0E7,$B0D9,
$B0D6,$D47E,$B0D3,$D4A6,$B0DA,$D4AA,$D474,$D4A4,$B0DD,$D475,$D478,$D47D,$B0DE,
$B0DC,$B0E8,$B0E3,$B0D7,$B1D2,$B0D8,$D479,$B0E5,$B0E0,$D4A3,$B0D5,$B0D4,$D471,
$D472,$D86A,$B3D7,$B3DA,$D875,$B3EE,$D878,$B3D8,$D871,$B3DE,$B3E4,$B5BD,$B3E2,
$D86E,$B3EF,$B3DB,$B3E3,$D876,$DCD7,$D87B,$D86F,$D866,$D873,$D86D,$B3E1,$D879,
$B3DD,$B3F1,$B3EA,$B3DF,$B3DC,$B3E7,$D87A,$D86C,$D872,$D874,$D868,$D877,$B3D9,
$D867,$B3E0,$B3F0,$B3EC,$D869,$B3E6,$B3ED,$B3E9,$B3E5,$D870,$B3EB,$DCD5,$DCD1,
$DCE0,$DCCA,$DCD3,$B6E5,$B6E6,$B6DE,$DCDC,$B6E8,$DCCF,$DCCE,$DCCC,$DCDE,$B6DC,
$DCD8,$DCCD,$B6DF,$DCD6,$B6DA,$DCD2,$DCD9,$DCDB,$DCDF,$B6E3,$DCCB,$B6DD,$DCD0,
$B6D8,$B6E4,$DCDA,$B6E0,$B6E1,$B6E7,$B6DB,$A25F,$B6D9,$DCD4,$B6E2,$DCDD,$B9CD,
$B9C8,$E155,$E151,$E14B,$B9C2,$B9BE,$E154,$B9BF,$E14E,$E150,$E153,$B9C4,$B9CB,
$B9C5,$E149,$B9C6,$B9C7,$E14C,$B9CC,$E14A,$E14F,$B9C3,$E148,$B9C9,$B9C1,$B9C0,
$E14D,$E152,$B9CA,$E147,$BC4D,$E547,$E544,$BC47,$BC53,$BC54,$BC4A,$E542,$BC4C,
$E4F9,$BC52,$E546,$BC49,$E548,$BC48,$E543,$E545,$BC4B,$E541,$E4FA,$E4F7,$D86B,
$E4FD,$E4F6,$E4FC,$E4FB,$E4F8,$BC4F,$BC4E,$BC50,$E4FE,$BEB2,$E540,$E945,$E8FD,
$BEBE,$E942,$BEB6,$BEBA,$E941,$BEB9,$BEB5,$BEB8,$BEB3,$BEBD,$E943,$E8FE,$BEBC,
$E8FC,$BEBB,$E944,$E940,$BC51,$BEBF,$E946,$BEB7,$BEB4,$ECC6,$ECC8,$C07B,$ECC9,
$ECC7,$ECC5,$ECC4,$C07D,$ECC3,$C07E,$ECC1,$ECC2,$C07A,$C0A1,$C07C,$ECC0,$C250,
$EFBC,$EFBA,$EFBF,$EFBD,$EFBB,$EFBE,$C360,$F1F2,$F1F3,$C456,$F1F4,$F1F0,$F1F5,
$F1F1,$C251,$F3FE,$F441,$C459,$F440,$C458,$C457,$C45A,$F5C5,$F5C6,$C4DA,$C4D9,
$C4DB,$F5C4,$F6D8,$F6D7,$C56D,$C56F,$C56E,$F6D9,$C5C8,$F8A6,$C5F1,$F8A5,$F8EE,
$C949,$A57D,$A57C,$A65F,$A65E,$C9C7,$A65D,$C9C6,$A779,$CAA9,$CAA8,$A777,$A77A,
$CAA7,$A778,$CBF0,$CBF1,$A954,$ABAA,$D148,$D149,$AE45,$AE46,$D4AC,$B0E9,$B0EB,
$D4AB,$B0EA,$D87C,$B3F2,$B6E9,$B6EA,$DCE1,$B9CF,$B9CE,$E549,$E948,$E947,$F96B,
$A467,$C959,$C96E,$C96F,$A662,$A666,$C9C9,$A664,$A663,$C9C8,$A665,$A661,$A660,
$C9CA,$A7A6,$A7A3,$A77D,$CAAA,$CAAB,$A7A1,$CAAD,$A77B,$CAAE,$CAAC,$A77E,$A7A2,
$A7A5,$A7A4,$A77C,$CAAF,$A959,$CBFE,$A95B,$A95A,$CC40,$A958,$A957,$CBF5,$CBF4,
$CBF2,$CBF7,$CBF6,$CBF3,$CBFC,$CBFD,$CBFA,$CBF8,$A956,$CBFB,$A95C,$CC41,$CBF9,
$ABAB,$A955,$ABAC,$CE54,$CE5A,$ABB2,$CE58,$CE5E,$CE55,$CE59,$CE5B,$CE5D,$CE57,
$CE56,$CE51,$CE52,$ABAD,$ABAF,$ABAE,$CE53,$CE5C,$ABB1,$CE50,$D153,$D152,$D157,
$D14E,$D151,$D150,$D154,$D158,$AE47,$AE4A,$D14F,$D155,$AE49,$D14A,$ABB0,$D4BA,
$D156,$D14D,$AE48,$D14C,$D4B1,$B0EC,$B0F0,$D4C1,$D4AF,$D4BD,$B0F1,$D4BF,$D4C5,
$D4C9,$D4C0,$D4B4,$D4BC,$D4CA,$D4C8,$D4BE,$D4B9,$D4B2,$D8A6,$D4B0,$B0F5,$D4B7,
$B0F6,$B0F2,$D4AD,$D4C3,$D4B5,$D4B3,$D4C6,$B0F3,$D4CC,$B0ED,$B0EF,$D4BB,$D4B6,
$AE4B,$B0EE,$D4B8,$D4C7,$D4CB,$D4C2,$D4C4,$D4AE,$D8A1,$D8AA,$D8A9,$B3FA,$D8A2,
$B3FB,$B3F9,$D8A4,$B3F6,$D8A8,$D8A3,$D8A5,$D87D,$B3F4,$D8B2,$D8B1,$D8AE,$B3F3,
$B3F7,$B3F8,$D14B,$D8AB,$B3F5,$B0F4,$D8AD,$D87E,$D8B0,$D8AF,$D8B3,$DCEF,$D8AC,
$D8A7,$DCE7,$B6F4,$B6F7,$B6F2,$DCE6,$DCEA,$DCE5,$B6EC,$B6F6,$DCE2,$B6F0,$DCE9,
$B6EE,$B6ED,$DCEC,$B6EF,$DCEE,$DCEB,$B6EB,$B6F5,$DCF0,$DCE4,$DCED,$DCE3,$B6F1,
$B6F3,$DCE8,$DCF1,$E15D,$B9D0,$E163,$B9D5,$E15F,$E166,$E157,$B9D7,$B9D1,$E15C,
$BC55,$E15B,$E164,$B9D2,$B9D6,$E15A,$E160,$E165,$E156,$B9D4,$E15E,$E162,$E168,
$E158,$E161,$B9D3,$E167,$E159,$BC59,$E54B,$BC57,$BC56,$E54D,$E552,$E54E,$E551,
$BC5C,$BEA5,$BC5B,$E54A,$E550,$BC5A,$E54F,$E54C,$BC58,$E94D,$F9D9,$E94F,$E94A,
$BEC1,$E94C,$BEC0,$E94E,$BEC3,$E950,$BEC2,$E949,$E94B,$C0A5,$ECCC,$C0A4,$ECCD,
$C0A3,$ECCB,$C0A2,$ECCA,$C253,$C252,$F1F6,$F1F8,$F1F7,$C361,$C362,$C363,$F442,
$C45B,$F7D3,$F7D2,$C5F2,$A468,$A4D0,$A7A7,$CE5F,$B3FC,$B3FD,$DCF2,$B9D8,$E169,
$E553,$C95A,$CAB0,$CC42,$CE60,$D159,$AE4C,$F1F9,$C4DC,$A469,$A57E,$C970,$A667,
$A668,$A95D,$B0F7,$B9DA,$B9DB,$B9D9,$A46A,$A4D1,$A4D3,$A4D2,$C95B,$A4D4,$A5A1,
$C971,$A5A2,$A669,$A66A,$C9CB,$A7A8,$CAB1,$A961,$CC43,$A95F,$A960,$A95E,$D15A,
$ABB6,$ABB5,$ABB7,$ABB4,$CE61,$A962,$ABB3,$AE4D,$AE4E,$AE4F,$D4CD,$B3FE,$D8B4,
$B0F8,$B6F8,$B9DD,$B9DC,$E16A,$BC5D,$BEC4,$EFC0,$F6DA,$F7D4,$A46B,$A5A3,$A5A4,
$C9D1,$A66C,$A66F,$C9CF,$C9CD,$A66E,$C9D0,$C9D2,$C9CC,$A671,$A670,$A66D,$A66B,
$C9CE,$A7B3,$A7B0,$CAB6,$CAB9,$CAB8,$A7AA,$A7B2,$A7AF,$CAB5,$CAB3,$A7AE,$A7A9,
$A7AC,$CAB4,$CABB,$CAB7,$A7AD,$A7B1,$A7B4,$CAB2,$CABA,$A7AB,$A967,$A96F,$CC4F,
$CC48,$A970,$CC53,$CC44,$CC4B,$A966,$CC45,$A964,$CC4C,$CC50,$A963,$CC51,$CC4A,
$CC4D,$A972,$A969,$CC54,$CC52,$A96E,$A96C,$CC49,$A96B,$CC47,$CC46,$A96A,$A968,
$A971,$A96D,$A965,$CC4E,$ABB9,$ABC0,$CE6F,$ABB8,$CE67,$CE63,$CE73,$CE62,$ABBB,
$CE6C,$ABBE,$ABC1,$ABBC,$CE70,$ABBF,$AE56,$CE76,$CE64,$CE66,$CE6D,$CE71,$CE75,
$CE72,$CE6B,$CE6E,$CE68,$ABC3,$CE6A,$CE69,$CE74,$ABBA,$CE65,$ABC2,$ABBD,$AE5C,
$D162,$AE5B,$D160,$AE50,$AE55,$D15F,$D15C,$D161,$AE51,$D15B,$AE54,$AE52,$D163,
$AE53,$AE57,$AE58,$AE5A,$AE59,$D15D,$D15E,$D164,$D4D4,$B0F9,$D8C2,$D4D3,$D4E6,
$B140,$D4E4,$B0FE,$B0FA,$D4ED,$D4DD,$D4E0,$B143,$D4EA,$D4E2,$B0FB,$B144,$D4E7,
$D4E5,$D4D6,$D4EB,$D4DF,$D4DA,$D4D0,$D4EC,$D4DC,$D4CF,$B142,$D4E1,$D4EE,$D4DE,
$D4D2,$D4D7,$D4CE,$B141,$D4DB,$D4D8,$B0FC,$D4D1,$D4E9,$B0FD,$D4D9,$D4D5,$D4E8,
$B440,$D8BB,$D8B8,$D8C9,$D8BD,$D8CA,$B442,$D8C6,$D8C3,$D8C4,$D8C7,$D8CB,$D4E3,
$D8CD,$DD47,$B443,$D8CE,$D8B6,$D8C0,$D8C5,$B441,$B444,$D8CC,$D8CF,$D8BA,$D8B7,
$D8B9,$D8BE,$D8BC,$B445,$D8C8,$D8BF,$D8C1,$D8B5,$DCFA,$DCF8,$B742,$B740,$DD43,
$DCF9,$DD44,$DD40,$DCF7,$DD46,$DCF6,$DCFD,$B6FE,$B6FD,$B6FC,$DCFB,$DD41,$B6F9,
$B741,$DCF4,$DCFE,$DCF3,$DCFC,$B6FA,$DD42,$DCF5,$B6FB,$DD45,$E16E,$B9E2,$B9E1,
$B9E3,$E17A,$E170,$E176,$E16B,$E179,$E178,$E17C,$E175,$B9DE,$E174,$B9E4,$E16D,
$B9DF,$E17B,$B9E0,$E16F,$E172,$E177,$E171,$E16C,$E173,$E555,$BC61,$E558,$E557,
$E55A,$E55C,$F9DC,$BC5F,$E556,$E554,$E55D,$E55B,$E559,$E55F,$E55E,$BC63,$BC5E,
$BC60,$BC62,$E560,$E957,$E956,$E955,$E958,$E951,$E952,$E95A,$E953,$BEC5,$E95C,
$E95B,$E954,$ECD1,$C0A8,$ECCF,$ECD4,$ECD3,$E959,$C0A7,$ECD2,$ECCE,$ECD6,$ECD5,
$C0A6,$ECD0,$BEC6,$C254,$EFC1,$F1FA,$F1FB,$F1FC,$C45C,$C45D,$F443,$F5C8,$F5C7,
$F6DB,$F6DC,$F7D5,$F8A7,$A46C,$A46D,$A46E,$A4D5,$A5A5,$C9D3,$A672,$A673,$A7B7,
$A7B8,$A7B6,$A7B5,$A973,$CC55,$A975,$A974,$CC56,$ABC4,$AE5D,$D165,$D4F0,$B145,
$B447,$D4EF,$B446,$B9E5,$E17D,$BEC7,$C0A9,$ECD7,$C45E,$C570,$C972,$A5A6,$C973,
$A676,$A674,$A675,$A677,$A7BA,$A7B9,$CABC,$A7BB,$CABD,$CC57,$CC58,$A976,$A978,
$A97A,$A977,$A97B,$A979,$ABC8,$ABC5,$ABC7,$ABC9,$ABC6,$D166,$CE77,$D168,$D167,
$AE63,$AE5F,$AE60,$AE62,$AE64,$AE61,$AE66,$AE65,$B14A,$D4F2,$D4F1,$B149,$B148,
$B147,$B14B,$B146,$D8D5,$D8D2,$B449,$D8D1,$D8D6,$B44B,$D8D4,$B448,$B44A,$D8D3,
$DD48,$DD49,$DD4A,$B9E6,$B9EE,$E17E,$B9E8,$B9EC,$E1A1,$B9ED,$B9E9,$B9EA,$B9E7,
$B9EB,$BC66,$D8D0,$BC67,$BC65,$BC64,$E95D,$BEC8,$ECD8,$ECD9,$C364,$C45F,$A46F,
$A678,$ABCA,$D169,$AE67,$B14E,$B14D,$B14C,$B44C,$B44D,$D8D7,$B9EF,$BEC9,$A470,
$C95C,$A4D6,$C974,$C9D4,$A679,$A97C,$DD4B,$A471,$A4D7,$C9D5,$CABE,$CABF,$A7BC,
$D8D8,$B44E,$DD4C,$C0AA,$A472,$A4A8,$A4D8,$C975,$A5A7,$A7C0,$A7BF,$A7BD,$A7BE,
$CC59,$A97E,$A9A1,$CC5A,$A97D,$ABCE,$CE78,$ABCD,$ABCB,$ABCC,$AE6A,$AE68,$D16B,
$AE69,$D16A,$AE5E,$D4F3,$B150,$B151,$B14F,$B9F0,$E1A2,$BC68,$BC69,$E561,$C0AB,
$EFC2,$EFC3,$C4DD,$F8A8,$C94B,$A4D9,$A473,$C977,$C976,$A67A,$C9D7,$C9D8,$C9D6,
$C9D9,$CAC7,$CAC2,$CAC4,$CAC6,$CAC3,$A7C4,$CAC0,$CAC1,$A7C1,$A7C2,$CAC5,$CAC8,
$A7C3,$CAC9,$CC68,$CC62,$CC5D,$A9A3,$CC65,$CC63,$CC5C,$CC69,$CC6C,$CC67,$CC60,
$A9A5,$CC66,$A9A6,$CC61,$CC64,$CC5B,$CC5F,$CC6B,$A9A7,$A9A8,$CC5E,$CC6A,$A9A2,
$A9A4,$CEAB,$CEA4,$CEAA,$CEA3,$CEA5,$CE7D,$CE7B,$CEAC,$CEA9,$CE79,$ABD0,$CEA7,
$CEA8,$CEA6,$CE7C,$CE7A,$ABCF,$CEA2,$CE7E,$CEA1,$CEAD,$AE6F,$AE6E,$D16C,$AE6B,
$D16E,$AE70,$D16F,$AE73,$AE71,$D170,$CEAE,$D172,$AE6D,$AE6C,$D16D,$D171,$AE72,
$B153,$B152,$D4F5,$D4F9,$D4FB,$B154,$D4FE,$B158,$D541,$B15A,$B156,$B15E,$B15B,
$D4F7,$B155,$D4F6,$D4F4,$D543,$D4F8,$B157,$D542,$B15C,$D4FD,$D4FC,$B15D,$D4FA,
$B159,$D544,$D540,$D8E7,$D8EE,$D8E3,$B451,$D8DF,$D8EF,$D8D9,$D8EC,$D8EA,$D8E4,
$D8ED,$D8E6,$D8DE,$D8F0,$D8DC,$D8E9,$D8DA,$D8F1,$B452,$D8EB,$DD4F,$D8DD,$B44F,
$D8E1,$B450,$D8E0,$D8E5,$D8E2,$D8E8,$DD53,$DD56,$DD4E,$DD50,$DD55,$DD54,$B743,
$D8DB,$DD52,$B744,$DD4D,$DD51,$E1A9,$E1B0,$E1A7,$E1AE,$E1A5,$E1AD,$E1B1,$E1A4,
$E1A8,$E1A3,$B9F1,$E1A6,$B9F2,$E1AC,$E1AB,$E1AA,$E1AF,$E565,$E567,$BC6B,$E568,
$E563,$E562,$E56C,$E56A,$BC6A,$E56D,$E564,$E569,$E56B,$E566,$E961,$E966,$E960,
$E965,$E95E,$E968,$E964,$E969,$E963,$E95F,$E967,$E96A,$E962,$ECDA,$C0AF,$C0AD,
$C0AC,$C0AE,$EFC4,$F172,$F1FD,$F444,$F445,$C460,$F5C9,$C4DE,$F5CA,$F6DE,$C572,
$C571,$F6DD,$C5C9,$F7D6,$A474,$A67B,$C9DA,$CACA,$A8B5,$B15F,$A475,$A5AA,$A5A9,
$A5A8,$A7C5,$AE74,$DD57,$A476,$A477,$A478,$A4DA,$ABD1,$CEAF,$B453,$A479,$C95D,
$A5AB,$A5AC,$C978,$A67C,$CACB,$A7C6,$CACC,$A9AE,$CC6E,$A9AC,$A9AB,$CC6D,$A9A9,
$CC6F,$A9AA,$A9AD,$ABD2,$ABD4,$CEB3,$CEB0,$CEB1,$CEB2,$CEB4,$ABD3,$D174,$D173,
$AE76,$AE75,$B162,$D546,$B161,$B163,$B160,$B455,$D545,$B456,$D8F3,$B457,$D8F2,
$B454,$DD5A,$DD5C,$B745,$DD5B,$DD59,$DD58,$E1B4,$B9F7,$B9F5,$B9F6,$E1B2,$E1B3,
$B9F3,$E571,$E56F,$BC6D,$E570,$BC6E,$BC6C,$B9F4,$E96D,$E96B,$E96C,$E56E,$ECDC,
$C0B0,$ECDB,$EFC5,$EFC6,$E96E,$F1FE,$A47A,$A5AD,$A67E,$C9DB,$A67D,$A9AF,$B746,
$A4DB,$A5AE,$ABD5,$B458,$C979,$C97A,$C9DC,$A7C8,$CAD0,$CACE,$A7C9,$CACD,$CACF,
$CAD1,$A7C7,$A9B3,$A9B4,$A9B1,$A9B0,$CEB8,$A9B2,$ABD6,$CEB7,$CEB9,$CEB6,$CEBA,
$ABD7,$AE79,$D175,$D177,$AE77,$D178,$AE78,$D176,$CEB5,$D547,$D54A,$D54B,$D548,
$B167,$B166,$B164,$B165,$D549,$B168,$B45A,$B45B,$B45C,$DD5D,$DD5F,$DD61,$B748,
$B747,$B459,$DD60,$DD5E,$E1B8,$E1B6,$E1BC,$B9F8,$E1BD,$E1BA,$B9F9,$E1B7,$E1B5,
$E1BB,$BC70,$E573,$E1B9,$BC72,$E574,$BC71,$BC74,$E575,$BC6F,$BC73,$E973,$E971,
$E970,$E972,$E96F,$C366,$F446,$F447,$F5CB,$F6DF,$C655,$A9B5,$A7CA,$ABD8,$A47B,
$A4DC,$A5AF,$C9DD,$A7CB,$CAD2,$CEBB,$ABD9,$B9FA,$A47C,$A6A1,$B749,$A47D,$A4DD,
$A4DE,$A5B1,$A5B0,$C9DE,$A6A2,$CAD3,$A7CC,$CC71,$CC72,$CC73,$A9B6,$A9B7,$CC70,
$A9B8,$ABDA,$CEBC,$D17A,$AE7A,$D179,$B169,$D54C,$B16A,$D54D,$B45D,$DD62,$E1BF,
$E1BE,$B9FB,$BC75,$E576,$BECA,$E974,$C0B1,$C573,$F7D8,$CC74,$CEBD,$B16B,$D8F4,
$B74A,$C255,$A7CE,$A7CD,$ABDB,$D17B,$B16D,$B343,$B16E,$B16C,$B45E,$E1C0,$B9FC,
$BC76,$C94C,$C9DF,$CAD5,$A7CF,$CAD4,$A7D0,$A9BC,$CC77,$CC76,$A9BB,$A9B9,$A9BA,
$CC75,$ABDD,$CEBE,$ABE0,$ABDC,$ABE2,$ABDE,$ABDF,$ABE1,$AE7D,$AE7C,$AE7B,$D54F,
$B16F,$B172,$B170,$D54E,$B175,$B171,$D550,$B174,$B173,$D8F6,$D8F5,$B461,$B45F,
$B460,$D8F7,$B74B,$DD64,$B74C,$DD63,$E577,$BC78,$E1C1,$BC77,$B9FD,$ECDE,$E975,
$C0B2,$ECDD,$F240,$F448,$F449,$A4DF,$A5B2,$C97B,$A7D2,$A7D4,$C9E2,$CAD8,$CAD7,
$CAD6,$C9E1,$C9E0,$A6A4,$A7D3,$A7D1,$A6A3,$A9BD,$CC78,$A9BE,$CADD,$CADF,$CADE,
$CC79,$CADA,$A7D8,$A7D6,$CAD9,$CADB,$CAE1,$A7D5,$CADC,$CAE5,$A9C0,$CAE2,$A7D7,
$CAE0,$CAE3,$A9BF,$A9C1,$CAE4,$CCAF,$CCA2,$CC7E,$CCAE,$CCA9,$ABE7,$A9C2,$CCAA,
$CCAD,$ABE3,$CCAC,$A9C3,$A9C8,$A9C6,$CCA3,$CC7C,$CCA5,$A9CD,$CCB0,$ABE4,$CCA6,
$ABE5,$A9C9,$CCA8,$CECD,$ABE6,$CC7B,$A9CA,$ABE8,$A9CB,$A9C7,$A9CC,$CCA7,$CC7A,
$CCAB,$A9C4,$CC7D,$CCA4,$CCA1,$A9C5,$CEBF,$CEC0,$CECA,$D1A1,$CECB,$ABEE,$CECE,
$CEC4,$ABED,$CEC6,$CEC7,$CEC9,$ABE9,$AEA3,$F9DA,$CEC5,$CEC1,$AEA4,$CECF,$AE7E,
$D17D,$CEC8,$D17C,$CEC3,$CECC,$ABEC,$AEA1,$ABF2,$AEA2,$CED0,$D17E,$ABEB,$AEA6,
$ABF1,$ABF0,$ABEF,$AEA5,$CED1,$AEA7,$ABEA,$CEC2,$B176,$D1A4,$D1A6,$D1A8,$AEA8,
$AEAE,$D553,$D1AC,$D1A3,$B178,$D551,$AEAD,$AEAB,$D1AE,$D552,$D1A5,$AEAC,$D1A9,
$AEAF,$D1AB,$AEAA,$D1AA,$D1AD,$D1A7,$AEA9,$B179,$D1A2,$B177,$B17A,$D555,$D55E,
$B464,$B17C,$B1A3,$B465,$D560,$B1AA,$D8F9,$D556,$B1A2,$B1A5,$B17E,$D554,$D562,
$D565,$D949,$D563,$D8FD,$B1A1,$B1A8,$B1AC,$D55D,$D8F8,$D561,$B17B,$D8FA,$D564,
$D8FC,$D559,$B462,$D557,$D558,$B1A7,$B1A6,$D55B,$B1AB,$D55F,$B1A4,$D55C,$B1A9,
$B466,$B463,$D8FB,$D55A,$B17D,$B46B,$B46F,$D940,$B751,$B46D,$D944,$B471,$DD65,
$D946,$B753,$B469,$B46C,$D947,$D948,$D94E,$B473,$B754,$D94A,$D94F,$D943,$B75E,
$B755,$B472,$D941,$D950,$B75D,$B470,$B74E,$D94D,$B474,$D945,$D8FE,$B46A,$D942,
$D94B,$B74D,$B752,$B467,$D94C,$B750,$B468,$B75C,$E1C3,$DD70,$DD68,$E1C2,$DD6C,
$DD6E,$DD6B,$B75B,$DD6A,$B75F,$E1D2,$B75A,$BA40,$DD71,$E1C4,$B758,$DD69,$DD6D,
$B9FE,$B74F,$DD66,$DD67,$BA41,$B757,$B759,$B756,$DD6F,$E1C8,$E1C9,$E1CE,$BC7D,
$E1D5,$BA47,$BA46,$E1D0,$BC7C,$E1C5,$BA45,$E1D4,$BA43,$BA44,$E1D1,$E5AA,$BC7A,
$B46E,$E1D3,$BCA3,$E1CB,$BC7B,$BCA2,$E1C6,$E1CA,$E1C7,$E1CD,$BA48,$BC79,$BA42,
$E57A,$E1CF,$BCA1,$BCA4,$E1CC,$BC7E,$E579,$E57E,$BECE,$E578,$E9A3,$E5A9,$BCA8,
$BCA6,$BECC,$E5A6,$E5A2,$BCAC,$E978,$BCAA,$E5A1,$E976,$E5A5,$E5A8,$E57D,$BCAB,
$BCA5,$E977,$BECD,$E5A7,$BCA7,$BCA9,$E5A4,$BCAD,$E5A3,$E57C,$E57B,$BECB,$E5AB,
$E97A,$ECE0,$BED0,$E9A2,$E97E,$ECE1,$BED1,$E9A1,$E97C,$C0B4,$ECDF,$E979,$E97B,
$C0B5,$BED3,$C0B3,$BED2,$C0B7,$E97D,$BECF,$EFCF,$EFC7,$ECE7,$EFC8,$ECE3,$C256,
$ECE5,$ECE4,$C0B6,$ECE2,$ECE6,$EFD0,$EFCC,$EFCE,$EFC9,$EFCA,$EFCD,$EFCB,$C367,
$C36A,$C369,$C368,$C461,$F44A,$C462,$F241,$C4DF,$F5CC,$C4E0,$C574,$C5CA,$F7D9,
$F7DA,$F7DB,$F9BA,$A4E0,$C97C,$A5B3,$A6A6,$A6A7,$A6A5,$A6A8,$A7DA,$A7D9,$CCB1,
$A9CF,$A9CE,$D1AF,$B1AD,$B1AE,$B475,$DD72,$B760,$B761,$DD74,$DD76,$DD75,$E1D7,
$E1D6,$BA49,$E1D8,$E5AC,$BCAE,$BED4,$C0B8,$C257,$C0B9,$A4E1,$CAE6,$CCB2,$A9D1,
$A9D0,$A9D2,$ABF3,$CED2,$CED3,$D1B0,$AEB0,$B1AF,$B476,$D951,$A4E2,$A47E,$A4E3,
$C97D,$A5B7,$A5B6,$A5B4,$A5B5,$A6AB,$C9E9,$C9EB,$A6AA,$C9E3,$C9E4,$C9EA,$C9E6,
$C9E8,$A6A9,$C9E5,$C9EC,$C9E7,$A7E1,$A7EA,$A7E8,$CAF0,$CAED,$CAF5,$A7E6,$CAF6,
$A7DF,$CAF3,$A7E5,$CAEF,$CAEE,$A7E3,$CAF4,$A7E4,$A9D3,$A7DE,$CAF1,$CAE7,$A7DB,
$A7EE,$CAEC,$CAF2,$A7E0,$A7E2,$CAE8,$CAE9,$CAEA,$A7ED,$A7E7,$A7EC,$CAEB,$A7EB,
$A7DD,$A7DC,$A7E9,$A9E1,$CCBE,$CCB7,$A9DC,$A9EF,$CCB3,$CCBA,$CCBC,$CCBF,$A9EA,
$CCBB,$CCB4,$A9E8,$CCB8,$CCC0,$A9D9,$CCBD,$A9E3,$A9E2,$CCB6,$A9D7,$A9D8,$A9D6,
$A9EE,$A9E6,$A9E0,$A9D4,$CCB9,$A9DF,$A9D5,$A9E7,$A9F0,$CED4,$A9E4,$CCB5,$A9DA,
$A9DD,$A9DE,$A9EC,$A9ED,$A9EB,$A9E5,$A9E9,$A9DB,$ABF4,$CEDA,$AC41,$ABF8,$ABFA,
$AC40,$CEE6,$ABFD,$D1B1,$AEB1,$AC43,$CED7,$CEDF,$ABFE,$CEDE,$CEDB,$CEE3,$CEE5,
$ABF7,$ABFB,$AC42,$AEB3,$CEE0,$ABF9,$AC45,$CED9,$ABFC,$AEB2,$ABF6,$CED6,$CEDD,
$CED5,$CED8,$CEDC,$D1B2,$AC44,$CEE1,$CEE2,$CEE4,$ABF5,$AEC1,$D1BE,$AEBF,$AEC0,
$D1B4,$D1C4,$AEB6,$D566,$D1C6,$D1C0,$D1B7,$D1C9,$D1BA,$AEBC,$D57D,$D1BD,$AEBE,
$AEB5,$D1CB,$D1BF,$AEB8,$D1B8,$D1B5,$D1B6,$AEB9,$D1C5,$D1CC,$AEBB,$D1BC,$D1BB,
$AEC3,$AEC2,$AEB4,$AEBA,$AEBD,$D1C8,$D1C2,$AEB7,$D1B3,$D1CA,$D1C1,$D1C3,$D1C7,
$D567,$B1B7,$B1CB,$B1CA,$B1BF,$D579,$D575,$D572,$D5A6,$B1BA,$B1B2,$D577,$B4A8,
$B1B6,$D5A1,$B1CC,$B1C9,$D57B,$D56A,$B1C8,$D5A3,$D569,$B1BD,$B1C1,$D5A2,$D573,
$B1C2,$B1BC,$D568,$B478,$D5A5,$D571,$B1C7,$D574,$D5A4,$B1C6,$D952,$B1B3,$D56F,
$B1B8,$B1C3,$B1BE,$D578,$D56E,$D56C,$D57E,$B1B0,$B1C4,$B1B4,$B477,$D57C,$B1B5,
$B1B1,$B1C0,$B1BB,$B1B9,$D570,$B1C5,$D56D,$D57A,$D576,$D954,$D953,$D56B,$D964,
$B47A,$D96A,$D959,$D967,$DD77,$B47D,$D96B,$D96E,$B47C,$D95C,$D96D,$D96C,$B47E,
$D955,$B479,$B4A3,$B4A1,$D969,$D95F,$B4A5,$D970,$D968,$D971,$B4AD,$B4AB,$D966,
$D965,$D963,$D95D,$B4A4,$B4A2,$D1B9,$D956,$DDB7,$D957,$B47B,$B4AA,$DD79,$B4A6,
$B4A7,$D958,$D96F,$DD78,$D960,$D95B,$B4A9,$D961,$D95E,$B4AE,$B770,$DD7C,$DDB1,
$DDB6,$DDAA,$B76C,$DDBB,$B769,$DD7A,$DD7B,$B762,$B76B,$DDA4,$B76E,$B76F,$DDA5,
$DDB2,$DDB8,$B76A,$B764,$DDA3,$DD7D,$DDBA,$DDA8,$DDA9,$DD7E,$DDB4,$DDAB,$DDB5,
$DDAD,$B765,$E1D9,$B768,$B766,$DDB9,$DDB0,$DDAC,$DDA1,$BA53,$DDAF,$B76D,$DDA7,
$DDA6,$B767,$B763,$E1EE,$DDB3,$DDAE,$DDA2,$E1E9,$E1DA,$E1E5,$E1EC,$BA51,$B4AC,
$E1EA,$BA4C,$BA4B,$E1F1,$E1DB,$E1E8,$E1DC,$E1E7,$BA4F,$E1EB,$D962,$E1F2,$E1E3,
$BA52,$E5BA,$BCAF,$E1F0,$E1EF,$BA54,$E5AD,$BCB0,$E5AE,$E1DF,$E1E0,$E1DD,$E1E2,
$E1DE,$E1F3,$BA4E,$BCB1,$BA50,$BA55,$E1E1,$E1ED,$E1E6,$E5B1,$BA4A,$BCB4,$E9AA,
$E5B6,$E5B5,$E5B7,$E5B4,$BCB5,$BCBB,$BCB8,$BCB9,$E5AF,$E5B2,$E5BC,$BCC1,$BCBF,
$E5B3,$D95A,$BCB2,$E5B9,$E5B0,$BCC2,$E5B8,$BA4D,$BCB7,$E1E4,$BCBA,$BCBE,$BCC0,
$BCBD,$BCBC,$BCB6,$E5BB,$BCB3,$BCC3,$BED8,$BED9,$E9A9,$BEE2,$BEDF,$BED6,$BEDD,
$E9AB,$BEDB,$BED5,$BEDC,$E9A8,$C0BB,$BED7,$BEDE,$C0BA,$E9A7,$E9A6,$BEE0,$BEE1,
$E9A5,$E9A4,$C0BC,$E9AE,$BEDA,$E9AC,$C0BD,$C0C2,$ECEA,$ECEC,$C0BF,$ECED,$ECE9,
$ECEB,$C0C0,$C0C3,$ECE8,$C0BE,$C0C1,$C259,$E9AD,$C258,$C25E,$EFD4,$C25C,$C25D,
$EFD7,$EFD3,$C25A,$EFD1,$C36B,$EFD5,$EFD6,$EFD2,$C25B,$F242,$F245,$F246,$F244,
$F247,$C36C,$F243,$F44E,$C464,$F44D,$F44C,$F44B,$C463,$C465,$F5CD,$C4E2,$C4E1,
$F6E1,$F6E0,$F6E3,$C5CB,$C575,$F7DD,$F6E2,$F7DC,$C5CD,$C5CC,$C5F3,$F8A9,$F8EF,
$A4E4,$D972,$E9AF,$A6AC,$CAF7,$A7F1,$A7EF,$A7F0,$CCC1,$A9F1,$AC46,$CEE7,$CEE8,
$AC47,$D1CE,$AEC4,$AEC5,$D1CD,$B1D3,$B1CF,$D5A7,$B1D6,$B1D5,$B1CE,$B1D1,$B1D4,
$B1D0,$D976,$B1CD,$B4AF,$B4B1,$B4B2,$D975,$D978,$B4B0,$D973,$D977,$D974,$B771,
$DDBC,$BA56,$E1F4,$BEE3,$BCC4,$E5BD,$BCC5,$BCC6,$E5BF,$E5BE,$E5C0,$E9B1,$E9B0,
$ECEF,$ECEE,$C0C4,$C0C5,$F248,$A4E5,$D979,$B4B4,$B4B3,$DDBD,$EFD8,$C4E3,$F7DE,
$A4E6,$AEC6,$B1D8,$B1D7,$D97A,$D97B,$B772,$E1F5,$BA57,$E9B2,$A4E7,$A5B8,$A9F2,
$CCC2,$CEE9,$AC48,$B1D9,$D97C,$B4B5,$B773,$E5C1,$E5C2,$ECF0,$C25F,$F8F0,$A4E8,
$CCC3,$A9F3,$AC49,$CEEA,$AEC7,$D1D2,$D1D0,$D1D1,$AEC8,$D1CF,$B1DB,$B1DC,$D5A8,
$B1DD,$B1DA,$D97D,$D97E,$DDBE,$BA59,$BA58,$ECF1,$EFD9,$F24A,$F249,$F44F,$C95E,
$AC4A,$A4E9,$A5B9,$A6AE,$A6AD,$A6AF,$A6B0,$C9EE,$C9ED,$CAF8,$A7F2,$CAFB,$CAFA,
$CAF9,$CAFC,$A9F4,$CCC9,$CCC5,$CCCE,$A9FB,$A9F9,$CCCA,$CCC6,$CCCD,$A9F8,$AA40,
$CCC8,$CCC4,$A9FE,$CCCB,$A9F7,$CCCC,$A9FA,$A9FC,$CCD0,$CCCF,$CCC7,$A9F6,$A9F5,
$A9FD,$CEEF,$CEF5,$AC50,$AC4D,$CEEC,$CEF1,$AC53,$AC4B,$CEF0,$AC4E,$AC51,$CEF3,
$AC4C,$CEF8,$AC4F,$AC52,$CEED,$CEF2,$CEF6,$CEEE,$CEEB,$CEF7,$CEF4,$AED0,$AEC9,
$AECC,$AECF,$D1D5,$AECA,$D1D3,$AECE,$AECB,$D1D6,$AECD,$D5AC,$B1DF,$D5AB,$D5AD,
$B1DE,$B1E3,$D1D4,$D5AA,$D5AE,$B1E0,$D5A9,$B1E2,$B1E1,$D9A7,$D9A2,$B4B6,$B4BA,
$B4B7,$D9A5,$D9A8,$B4B8,$B4B9,$B4BE,$DDC7,$D9A6,$B4BC,$D9A3,$D9A1,$B4BD,$D9A4,
$B779,$DDBF,$B776,$B777,$B775,$DDC4,$DDC3,$DDC0,$B77B,$DDC2,$B4BB,$DDC6,$DDC1,
$B778,$B774,$B77A,$DDC5,$BA5C,$E1F8,$E1F7,$E1F6,$BA5A,$BA5B,$E5C5,$E5C8,$BCC8,
$BCC7,$E5C9,$E5C4,$BCCA,$E5C6,$BCC9,$E5C3,$E5C7,$BEE9,$BEE6,$E9BB,$E9BA,$E9B9,
$E9B4,$E9B5,$BEE7,$BEE4,$BEE8,$E9B3,$BEE5,$E9B6,$E9B7,$E9BC,$E9B8,$ECF2,$C0C7,
$EFDC,$C0C6,$EFDA,$EFDB,$C260,$C36E,$F24B,$C36D,$F451,$F452,$C466,$F450,$C4E4,
$F7DF,$C5CE,$F8AA,$F8AB,$A4EA,$A6B1,$A6B2,$A7F3,$CCD1,$AC54,$AED1,$B1E4,$B0D2,
$B4BF,$B4C0,$B3CC,$D9A9,$B77C,$E1FA,$E1F9,$A4EB,$A6B3,$CCD2,$AA42,$AA41,$CEF9,
$CEFA,$D1D7,$D1D8,$AED2,$AED3,$AED4,$D5AF,$B1E6,$B4C2,$B4C1,$DDC8,$DF7A,$E1FB,
$E9BD,$C261,$C467,$A4EC,$A5BC,$A5BD,$A5BB,$A5BE,$A5BA,$A6B6,$C9F6,$A6B5,$A6B7,
$C9F1,$C9F0,$C9F3,$C9F2,$C9F5,$A6B4,$C9EF,$C9F4,$CAFD,$A7FD,$CAFE,$CB43,$A7FC,
$CB47,$CB42,$CB45,$A7F5,$A7F6,$A7F7,$A7F8,$A840,$CB41,$A7FA,$A841,$CB40,$CB46,
$A7F9,$CB44,$A7FB,$A7F4,$A7FE,$AA57,$CCD4,$AA43,$AA4D,$AA4E,$AA46,$AA58,$AA48,
$CCDC,$AA53,$CCD7,$AA49,$CCE6,$CCE7,$CCDF,$CCD8,$AA56,$CCE4,$AA51,$AA4F,$CCE5,
$CCE3,$CCDB,$CCD3,$CCDA,$AA4A,$AA50,$AA44,$CCDE,$CCDD,$CCD5,$AA52,$CCE1,$CCD6,
$AA55,$CCE8,$AA45,$AA4C,$CCD9,$CCE2,$AA54,$AA47,$AA4B,$CCE0,$CF5B,$AC5C,$AC69,
$CF56,$CF4C,$AC62,$CF4A,$AC5B,$CF45,$AC65,$CF52,$CEFE,$CF41,$CF44,$CEFB,$CF51,
$CF61,$AC60,$CF46,$CF58,$CEFD,$CF5F,$CF60,$CF63,$CF5A,$CF4B,$CF53,$AC66,$AC59,
$AC61,$AC6D,$AC56,$AC58,$CF43,$AC6A,$AC63,$CF5D,$CF40,$AC6C,$AC67,$CF49,$AC6B,
$CF50,$CF48,$AC64,$CF5C,$CF54,$AC5E,$CF62,$CF47,$AC5A,$CF59,$CF4F,$AC5F,$CF55,
$AC57,$CEFC,$AC68,$AEE3,$AC5D,$CF4E,$CF4D,$CF42,$CF5E,$CF57,$AC55,$D1EC,$AEEA,
$D1ED,$D1E1,$AEDF,$AEEB,$D1DA,$D1E3,$D1EB,$D1D9,$D1F4,$AED5,$D1F3,$D1EE,$D1EF,
$AEDD,$AEE8,$D1E5,$D1E6,$D1F0,$D1E7,$D1E2,$D1DC,$D1DD,$D1EA,$D1E4,$AED6,$AEDA,
$D1F2,$D1DE,$AEE6,$AEE2,$AEE5,$AEEC,$AEDB,$AEE7,$D1E9,$AEE9,$AED8,$AED7,$D1DB,
$D1DF,$AEE0,$D1F1,$D1E8,$D1E0,$AEE4,$AEE1,$AED9,$AEDC,$D5C4,$D5B4,$D5B5,$D5B9,
$D5C8,$D5C5,$D5BE,$D5BD,$B1ED,$D5C1,$D5D0,$D5B0,$D5D1,$D5C3,$D5D5,$D5C9,$B1EC,
$D5C7,$B1E7,$B1FC,$B1F2,$B1F6,$B1F5,$D5B1,$D5CE,$D5D4,$D5CC,$D5D3,$D5C0,$D5B2,
$D5D2,$D5C2,$B1EA,$B1F7,$D5CB,$B1F0,$D5CA,$D5B3,$B1F8,$B1FA,$D5CD,$B1FB,$B1E9,
$D5BA,$D5CF,$B1EF,$B1F9,$D5BC,$D5C6,$D5B7,$D5BB,$B1F4,$D5B6,$B1E8,$B1F1,$B1EE,
$D5BF,$AEDE,$D9C0,$B1EB,$B1F3,$D9C3,$D9D9,$D9CE,$B4D6,$B4D1,$D9BD,$B4D2,$D9CD,
$D9C6,$D9D3,$B4CE,$D9AB,$D9D5,$B4C4,$D9B3,$B4C7,$B4C6,$B4D7,$D9AD,$D9CF,$D9D0,
$B4C9,$B4C5,$D9BB,$B4D0,$D9B6,$D9D1,$B4CC,$D9C9,$D9D6,$D9B0,$D9B5,$D9AF,$B4CB,
$D9C2,$DDDE,$D9B1,$B4CF,$D9BA,$D9D2,$B4CA,$D9B7,$D9B4,$D9C5,$B4CD,$B4C3,$B4D9,
$D9C8,$D9C7,$D9AC,$B4C8,$D9D4,$D9BC,$D9BE,$D9CB,$D9CA,$D9AA,$B4D3,$B4D5,$D9B2,
$D9B9,$D9C1,$B4D4,$D9B8,$D9C4,$D9D7,$D9CC,$D9D8,$D9AE,$DDF2,$B7A6,$DDF0,$DDDB,
$DDE0,$DDD9,$DDEC,$DDCB,$DDD2,$DDEA,$DDF4,$DDDC,$DDCF,$DDE2,$DDE7,$DDD3,$DDE4,
$DDD0,$DDD7,$DDD8,$B7A8,$DDEB,$DDE9,$DDCC,$DDEE,$DDEF,$DDF1,$B7AC,$B7A4,$D5B8,
$DDD4,$DDE6,$DDD5,$B7A1,$B7B1,$DDED,$B7AF,$B7AB,$DDCA,$B7A3,$DDCD,$B7B0,$DDDD,
$DDC9,$B7A9,$DDE1,$DDD1,$B7AA,$DDDA,$B77E,$B4D8,$DDE3,$D9BF,$DDCE,$DDE8,$B7A5,
$DDE5,$B7A2,$DDDF,$B7AD,$DDD6,$DDF3,$B7A7,$DEC6,$B7AE,$E24A,$E248,$E25E,$E246,
$E258,$B77D,$BA5F,$E242,$E25D,$E247,$E255,$BA64,$BA5D,$E25B,$E240,$E25A,$BA6F,
$E251,$E261,$BA6D,$E249,$BA5E,$E24B,$E259,$BA67,$E244,$BA6B,$BA61,$E24D,$E243,
$E1FC,$E257,$BA68,$E260,$E1FD,$BA65,$E253,$BA66,$E245,$E250,$E24C,$E24E,$BA60,
$E25F,$BA6E,$E24F,$E262,$E1FE,$E254,$BA63,$BA6C,$BA6A,$E241,$E256,$BA69,$BA62,
$E252,$E25C,$E5D5,$E5D1,$E5CD,$E5E1,$E5DE,$BCCD,$E5E5,$E5D4,$BCD8,$E5DB,$E5D0,
$E5DA,$BCD5,$E5EE,$E5EB,$E5DD,$E5CE,$E5E2,$E5E4,$BCD1,$E5D8,$E5D3,$E5CA,$BCCE,
$BCD6,$E5E7,$BCD7,$E5CB,$E5ED,$E5E0,$E5E6,$BCD4,$E5E3,$E5EA,$BCD9,$BCD3,$E5DC,
$E5CF,$E5EF,$E5CC,$E5E8,$BCD0,$E5D6,$E5D7,$BCCF,$BCCC,$E5D2,$BCD2,$BCCB,$E5E9,
$E5EC,$E5D9,$E9CA,$E9C2,$E9BE,$BEF6,$BEEB,$BEF0,$BEEC,$E9CC,$E9D7,$BEEA,$E9C4,
$E9CD,$E5DF,$E9CE,$BEF1,$E9DD,$BEF5,$BEF8,$E9C0,$BEF4,$E9DB,$E9DC,$E9D2,$E9D1,
$E9C9,$E9D3,$E9DA,$E9D9,$BEEF,$BEED,$E9CB,$E9C8,$E9C5,$E9D8,$BEF7,$E9D6,$BEF3,
$BEF2,$E9D0,$E9BF,$E9C1,$E9C3,$E9D5,$E9CF,$BEEE,$E9C6,$E9D4,$E9C7,$C0CF,$ED45,
$C0C8,$ECF5,$ED41,$C0CA,$ED48,$ECFC,$ECF7,$ED49,$ECF3,$ECFE,$C0D1,$ED44,$ED4A,
$ECFD,$C0C9,$ED40,$ECF4,$C0D0,$ED47,$ECF9,$C0CC,$ECFB,$ECF8,$C0D2,$ECFA,$C0CB,
$C0CE,$ED43,$ECF6,$ED46,$ED42,$C263,$EFE7,$C268,$C269,$C262,$EFE6,$EFE3,$EFE4,
$C266,$EFDE,$EFE2,$C265,$EFDF,$C267,$C264,$EFDD,$EFE1,$EFE5,$F251,$F24E,$F257,
$F256,$F254,$F24F,$C372,$F250,$C371,$C0CD,$F253,$C370,$F258,$F252,$F24D,$EFE0,
$C36F,$F24C,$F456,$F455,$F255,$C468,$F459,$F45A,$F454,$F458,$F453,$F5D1,$F457,
$C4E7,$C4E5,$F5CF,$F5D2,$F5CE,$F5D0,$C4E6,$F6E5,$F6E6,$C576,$F6E4,$F7E2,$C5CF,
$F7E0,$F7E1,$F8AC,$C656,$F8F3,$F8F1,$F8F2,$F8F4,$F9BB,$A4ED,$A6B8,$AA59,$CCE9,
$CF64,$D1F5,$D1F7,$D1F6,$D1F8,$B1FD,$D5D7,$D1F9,$D5D6,$D5D8,$D5D9,$D9DA,$B4DB,
$D9DB,$D9DD,$B4DC,$B4DA,$D9DC,$DDFA,$DDF8,$DDF7,$DDF6,$DDF5,$B7B2,$DDF9,$BA70,
$E263,$E265,$BA71,$E264,$BCDB,$BCDA,$E5F0,$E9DF,$E9DE,$E9E0,$BEF9,$ED4B,$C0D3,
$EFE8,$C26A,$F259,$C577,$A4EE,$A5BF,$A6B9,$A842,$AA5A,$AA5B,$AC6E,$D1FA,$B7B3,
$E6D1,$BEFA,$C26B,$A4EF,$A6BA,$CCEB,$AA5C,$CCEA,$CF65,$AC6F,$CF66,$AC70,$D1FC,
$AEEE,$AEED,$D5DE,$D5DC,$D5DD,$D5DB,$D5DA,$D9DE,$D9E1,$B4DE,$D9DF,$B4DD,$D9E0,
$DDFB,$E266,$E267,$E268,$E5F3,$E5F2,$BCDC,$E5F1,$E5F4,$E9E1,$E9E2,$E9E3,$ED4C,
$C0D4,$C26C,$F25A,$C4E8,$C95F,$AC71,$CF67,$AEEF,$B1FE,$B4DF,$D9E2,$B7B5,$B7B4,
$E269,$E26A,$BCDD,$BCDE,$E9E5,$E9E4,$EFE9,$F7E3,$A4F0,$C960,$A5C0,$A843,$CB48,
$AC72,$B7B6,$A4F1,$CF68,$AC73,$CF69,$C0D5,$A4F2,$CCEC,$CF6A,$D242,$D241,$D1FE,
$D1FD,$D243,$D240,$B240,$B241,$B4E0,$D9E3,$D9E4,$D9E5,$DE41,$DE42,$DE40,$DDFD,
$DDFE,$B7B7,$E26B,$E5F7,$E5F6,$E5F5,$E5F8,$E9E7,$E9E6,$BEFB,$E9E8,$C0D6,$ED4D,
$EFEA,$F25B,$F6E7,$A4F3,$A5C2,$A5C1,$AA5D,$C961,$C97E,$A6BB,$C9F7,$CB49,$CB4A,
$AA5E,$CCED,$AC74,$CF6B,$CF6C,$AEF0,$AEF4,$D244,$AEF3,$AEF1,$AEF2,$D5DF,$B242,
$B4E3,$B4E1,$B4E2,$D9E6,$BA72,$A4F4,$C9A1,$A5C3,$C9A4,$A5C6,$C9A3,$A5C5,$A5C4,
$A844,$C9A2,$C9F8,$C9FC,$C9FE,$CA40,$A6C5,$A6C6,$C9FB,$A6C1,$C9F9,$C9FD,$A6C2,
$A6BD,$A6BE,$A6C4,$C9FA,$A6BC,$A845,$A6BF,$A6C0,$A6C3,$CB5B,$CB59,$CB4C,$A851,
$CB53,$A84C,$CB4D,$CB55,$CB52,$A84F,$CB51,$A856,$CB5A,$A858,$A85A,$CB4B,$A84D,
$CB5C,$A854,$A857,$CD45,$A847,$A85E,$A855,$CB4E,$A84A,$A859,$CB56,$A848,$A849,
$CD43,$CB4F,$A850,$A85B,$CB5D,$CB50,$A84E,$A853,$CCEE,$A85C,$CB57,$A852,$A85D,
$A846,$CB54,$A84B,$CB58,$CD44,$AA6A,$AA7A,$CCF5,$AA71,$CD4B,$AA62,$AA65,$CD42,
$CCF3,$CCF7,$AA6D,$AA6F,$CCFA,$AA76,$AA68,$AA66,$AA67,$AA75,$CD47,$AA70,$CCF9,
$CCFB,$AA6E,$AA73,$CCFC,$CD4A,$AC75,$AA79,$AA63,$CD49,$CD4D,$CCF8,$CD4F,$CD40,
$AA6C,$CCF4,$AA6B,$AA7D,$AA72,$CCF2,$CF75,$AA78,$AA7C,$CD41,$CD46,$AA7E,$AA77,
$AA69,$AA5F,$AA64,$CCF6,$AA60,$CD4E,$CCF0,$CCEF,$CCFD,$CCF1,$AA7B,$AEF5,$AA74,
$CCFE,$AA61,$ACA6,$CD4C,$CF7C,$CFA1,$CFA4,$CF77,$CFA7,$CFAA,$CFAC,$CF74,$AC76,
$AC7B,$D249,$ACAD,$CFA5,$CFAD,$CF7B,$CF73,$D264,$AC7E,$CFA2,$CF78,$CF7A,$ACA5,
$CF7D,$AC7D,$CF70,$CFA8,$CFAB,$AC7A,$ACA8,$CF6D,$ACAA,$AC78,$ACAE,$CFA9,$CF6F,
$ACAB,$D25E,$CD48,$AC7C,$AC77,$CF76,$CF6E,$ACAC,$ACA4,$CFA3,$ACA9,$ACA7,$CF79,
$ACA1,$CF71,$ACA2,$ACA3,$CF72,$CFA6,$AC79,$CF7E,$D24C,$AEFD,$AF43,$D255,$D25B,
$D257,$D24A,$D24D,$D246,$D247,$AF4A,$AEFA,$D256,$D25F,$AF45,$AEF6,$AF40,$D24E,
$AF42,$D24F,$D259,$AF44,$D268,$D248,$AEFC,$AEFB,$AF48,$D245,$D266,$D25A,$D267,
$D261,$D253,$D262,$D25C,$D265,$D263,$AF49,$D254,$AEF9,$AEF8,$AF41,$AF47,$D260,
$AF46,$D251,$B243,$D269,$D250,$D24B,$AEFE,$AF4B,$AEF7,$D258,$D25D,$B265,$D5E1,
$D5E5,$B252,$B250,$B247,$D5E3,$D5E2,$B25B,$D5E8,$B255,$D5FA,$D647,$B244,$D5F7,
$D5F0,$B267,$D5E0,$D5FC,$B264,$B258,$B263,$B24E,$D5EC,$D5FE,$D5F6,$B24F,$B249,
$D645,$D5FD,$D640,$B251,$B259,$D642,$D5EA,$D5FB,$D5EF,$D644,$B25E,$B246,$B25C,
$D5F4,$D5F2,$D5F3,$B253,$D5EE,$D5ED,$B248,$D5E7,$D646,$B24A,$D5F1,$B268,$B262,
$D5E6,$B25F,$B25D,$B266,$D5F8,$B261,$D252,$D5F9,$B260,$D641,$B245,$D5F5,$B257,
$D5E9,$B256,$B254,$B24C,$B24B,$D9E7,$D643,$D5EB,$D9FC,$B24D,$B541,$B25A,$B4EE,
$D9F6,$B4FC,$D9EA,$B4EB,$B4E7,$DA49,$B4ED,$B4F1,$B4EC,$B4F5,$DA4D,$DA44,$D9F1,
$B4FA,$B4F4,$D9FD,$B4E4,$DA4A,$DA43,$B4E8,$D9F7,$B4F7,$DA55,$DA56,$B4E5,$DA48,
$B4F9,$D9FB,$D9ED,$D9EE,$B4FD,$D9F2,$D9F9,$D9F3,$B4FB,$B544,$D9EF,$D9E8,$D9E9,
$D9EB,$B4EA,$D9F8,$B4F8,$B542,$D9FA,$DA53,$DA4B,$B4E6,$DA51,$B4F2,$B4F0,$DA57,
$B4EF,$DA41,$D9F4,$D9FE,$B547,$DA45,$DA42,$D9F0,$B543,$DA4F,$DA4C,$DA54,$B4E9,
$DA40,$B546,$DA47,$B4F3,$B4F6,$DA46,$B545,$D9F5,$D5E4,$DA50,$DA4E,$DA52,$D9EC,
$B540,$DE61,$DE60,$DE46,$B7BD,$DE5F,$DE49,$DE4A,$B7C7,$DE68,$B7C2,$DE5E,$DE43,
$B7C8,$B7BE,$DE52,$DE48,$DE4B,$DE63,$B7B8,$DE6A,$DE62,$B7C1,$DE57,$B7CC,$B7CB,
$B7C5,$DE69,$B7B9,$DE55,$DE4C,$DE59,$DE65,$B7CD,$B7BB,$DE54,$DE4D,$B7C4,$B7C3,
$DE50,$DE5A,$DE64,$DE47,$DE51,$B7BC,$DE5B,$B7C9,$B7C0,$DE4E,$B7BF,$DE45,$DE53,
$DE67,$B4FE,$BAB0,$DE56,$E26C,$DE58,$DE66,$B7C6,$DE4F,$B7BA,$B7CA,$BCF0,$DE44,
$DE5D,$DE5C,$E2AA,$BAAD,$E27D,$E2A4,$BAA2,$E26E,$BAAF,$BA77,$E26D,$E2B0,$BAB1,
$E271,$E2A3,$E273,$E2B3,$E2AF,$BA75,$BAA1,$E653,$BAAE,$BA7D,$E26F,$E2AE,$BAA3,
$E2AB,$E2B8,$E275,$E27E,$E2B6,$E2AC,$BA7C,$E27C,$BA76,$BA74,$BAA8,$E27A,$E277,
$E278,$E2B2,$E2B7,$E2B5,$BA7A,$E2B9,$BA7E,$BAA7,$E270,$E5FA,$E279,$BA78,$BAAC,
$BAA9,$BA7B,$E2A5,$E274,$BAAA,$E2A7,$BAA4,$BAA6,$BA73,$E2A9,$E2A1,$E272,$BAA5,
$E2B1,$E2B4,$E27B,$E2A8,$BA79,$BCDF,$E2A6,$E5F9,$E2AD,$E276,$E644,$E64E,$BCE2,
$E64D,$E659,$BCE4,$E64B,$E64F,$BCEF,$E646,$BCE7,$E652,$E9F0,$BCF3,$BCF2,$E654,
$E643,$E65E,$BCED,$BCE3,$E657,$E65B,$E660,$E655,$E649,$BCE6,$BCE9,$BCF1,$BCEC,
$E64C,$E2A2,$E648,$E65F,$BCE8,$BCEB,$E661,$BCE0,$E656,$E5FB,$E65C,$C0DF,$E64A,
$BCE1,$E645,$BCE5,$E5FC,$BAAB,$E641,$E65A,$E642,$E640,$BCEA,$E658,$E5FE,$E651,
$E650,$E65D,$E647,$BCEE,$E9F3,$BF49,$BEFE,$EA40,$E9EB,$BF41,$E9F7,$BF48,$BF43,
$E9F5,$ED4F,$E9FB,$EA42,$E9FA,$E9E9,$E9F8,$EA44,$EA46,$BEFD,$EA45,$BF44,$BF4A,
$BF47,$E9FE,$BF46,$E9F9,$E9ED,$E9F2,$E9FD,$BF45,$BF42,$BEFC,$BF40,$E9F1,$E5FD,
$E9EC,$E9EF,$EA41,$E9F4,$E9EA,$ED4E,$EA43,$E9EE,$E9FC,$ED51,$C0E3,$C0D7,$C0DB,
$ED53,$ED59,$ED57,$C0D9,$C0DA,$C0E1,$ED5A,$ED52,$C0DC,$ED56,$ED55,$ED5B,$C0E2,
$C0DD,$C0E0,$ED54,$C0E4,$C0DE,$C0E5,$C0D8,$ED58,$ED50,$EFF7,$C271,$EFF4,$EFF6,
$C26F,$EFF2,$EFF3,$EFEE,$E9F6,$EFEF,$C270,$EFEB,$C26D,$EFF8,$C26E,$EFEC,$EFED,
$EFF1,$C273,$C272,$EFF0,$C378,$F25F,$F265,$C379,$F25C,$C376,$C373,$F267,$C377,
$C374,$F25E,$F261,$F262,$F263,$F266,$EFF5,$F25D,$C375,$F264,$F268,$F260,$F45D,
$C46A,$F460,$C46B,$F468,$F45F,$F45C,$F45E,$F462,$F465,$F464,$F467,$F45B,$C469,
$F463,$F466,$F469,$F461,$F5D3,$F5D4,$F5D8,$F5D9,$F5D6,$F5D7,$F5D5,$C4E9,$C578,
$F6EB,$F6E8,$F6E9,$F6EA,$C579,$F7E5,$F7E4,$F8AF,$C5F4,$F8AD,$F8B0,$F8AE,$F8F5,
$C657,$C665,$F9A3,$F96C,$F9A2,$F9D0,$F9D1,$A4F5,$A6C7,$CA41,$CB5E,$A85F,$A862,
$CB5F,$A860,$A861,$CD58,$CD5A,$CD55,$CD52,$CD54,$AAA4,$AAA2,$CD56,$AAA3,$CD53,
$CD50,$AAA1,$CD57,$CD51,$AAA5,$CD59,$CFAF,$CFB3,$ACB7,$CFB6,$ACAF,$ACB2,$ACB4,
$ACB6,$ACB3,$CFB2,$CFB1,$ACB1,$CFB4,$CFB5,$CFAE,$ACB5,$ACB0,$CFB0,$D277,$D278,
$D279,$AF50,$AF4C,$D26E,$D276,$D27B,$AF51,$D26C,$D272,$D26B,$D275,$D271,$AF4D,
$AF4F,$D27A,$D26A,$D26D,$D273,$D274,$D27C,$D270,$AF4E,$B26D,$D64E,$D650,$D64C,
$D658,$D64A,$D657,$B269,$D648,$DA5B,$D652,$B26C,$D653,$D656,$D65A,$D64F,$D654,
$B26A,$B26B,$D659,$D64D,$D649,$D65B,$D651,$D655,$D64B,$B548,$B549,$DA65,$B54F,
$DA59,$DA62,$DA58,$B54C,$DA60,$DA5E,$DA5F,$B54A,$DA63,$DA5C,$DA5A,$B54B,$DA5D,
$DA61,$B54D,$DA64,$DE70,$DE77,$DE79,$DEA1,$B7DA,$DE6B,$B7D2,$DE7A,$B7D7,$DEA2,
$B7CE,$DE7D,$DE6D,$DE7E,$DE6C,$B7DC,$DE78,$B7CF,$DEA3,$B7D4,$DE71,$B7D9,$DE7C,
$DE6F,$DE76,$DE72,$DE6E,$B7D1,$B7D8,$B7D6,$B7D3,$B7DB,$B7D0,$DE75,$B7D5,$B54E,
$DE7B,$DE73,$DE74,$E2C1,$BAB4,$E2BD,$E2C3,$E2BF,$BAB6,$E2BE,$E2C2,$E2BA,$E2BC,
$BAB5,$E2C0,$E2BB,$BAB7,$BAB2,$E2C4,$BAB3,$E667,$E664,$E670,$E66A,$E66C,$BCF4,
$E666,$E66E,$E66D,$E66B,$E671,$BCF7,$E668,$E66F,$BCF5,$E663,$E665,$BCF6,$E662,
$E672,$E669,$EA4A,$BF51,$EA55,$EA53,$BF4B,$EA49,$EA4C,$EA4D,$EA48,$BF55,$BF56,
$EA47,$EA56,$EA51,$BF4F,$BF4C,$EA50,$EA4E,$BF52,$EA52,$BF4D,$BF4E,$EA4F,$BF50,
$EA4B,$EA54,$BF53,$EA57,$EA58,$BF54,$C0E7,$C0EE,$ED5C,$ED62,$ED60,$C0EA,$C0E9,
$C0E6,$ED5E,$C0EC,$C0EB,$C0E8,$ED61,$ED5D,$ED5F,$C0ED,$C277,$EFFB,$C274,$C275,
$EFFD,$C276,$EFFA,$EFF9,$F26C,$EFFC,$F26D,$C37A,$F26B,$F26A,$F269,$C37B,$C46C,
$F46A,$F46B,$F5DC,$F5DB,$C4EA,$F5DA,$F6EC,$F6ED,$F7E6,$F8B1,$F8F6,$F9BC,$C679,
$F9C6,$A4F6,$AAA6,$AAA7,$ACB8,$C0EF,$A4F7,$AAA8,$AF52,$B7DD,$A4F8,$B26E,$BAB8,
$C962,$CFB7,$D27D,$E2C5,$C0F0,$A4F9,$AAA9,$CFB8,$CFB9,$DA66,$B550,$DEA4,$B7DE,
$E2C6,$BCF8,$C37C,$A4FA,$DA67,$A4FB,$A6C9,$CA42,$A6C8,$A865,$A864,$A863,$CB60,
$AAAA,$AAAB,$CD5B,$CFBA,$CFBD,$ACBA,$CFBB,$ACB9,$CFBC,$ACBB,$D2A2,$D2A1,$D27E,
$AF53,$D65D,$D65E,$B26F,$D65C,$D65F,$B552,$B270,$B551,$DA6B,$DA6A,$DA68,$DA69,
$DA6C,$DEA6,$DEA5,$DEA9,$DEA8,$DEA7,$BAB9,$E2C9,$E2C8,$BABA,$E2C7,$E673,$E674,
$BCF9,$EA59,$EA5A,$F272,$C37D,$F271,$F270,$F26E,$F26F,$C4EB,$F46C,$F6EE,$F8F7,
$A4FC,$C9A5,$A5C7,$C9A6,$CA43,$CA44,$CB66,$CB62,$CB61,$AAAC,$CB65,$A867,$CB63,
$A866,$CB67,$CB64,$CD5F,$CFBE,$CD5D,$CD64,$AAAD,$AAB0,$CD65,$CD61,$CD62,$CD5C,
$AAAF,$CD5E,$AAAE,$CD63,$CD60,$CFC2,$ACBD,$ACBE,$CFC5,$CFBF,$CFC4,$CFC0,$ACBC,
$CFC3,$CFC1,$D2A8,$D2A5,$D2A7,$AF58,$AF57,$AF55,$D2A4,$D2A9,$AF54,$AF56,$D2A6,
$D667,$D2A3,$D2AA,$D662,$D666,$D665,$DA6E,$DA79,$D668,$D663,$DA6D,$B274,$B273,
$D661,$D664,$B275,$B272,$B271,$D660,$D669,$DA70,$DA77,$B554,$DA76,$DA73,$B556,
$DA75,$DA6F,$DA71,$DA74,$DA72,$B555,$DA78,$B553,$B7DF,$DEAD,$DEAC,$DEAA,$B7E2,
$B7E1,$DEAE,$DEAB,$E2CA,$BABB,$B7E0,$DEB0,$DEAF,$E2CD,$E2CB,$BCFA,$BABC,$E2CC,
$E676,$BCFB,$E675,$E67E,$E67D,$E67B,$E67A,$E677,$E678,$E679,$E67C,$E6A1,$EA5F,
$EA5C,$EA5D,$BF57,$EA5B,$EA61,$EA60,$EA5E,$ED64,$ED65,$C0F1,$C0F2,$ED63,$C279,
$EFFE,$C278,$C37E,$C3A1,$C46D,$F46E,$F46D,$F5DD,$F6EF,$C57A,$F7E8,$F7E7,$F7E9,
$A5C8,$CFC6,$AF59,$B276,$D66A,$A5C9,$C9A7,$A4FD,$CA45,$CB6C,$CB6A,$CB6B,$CB68,
$A868,$CB69,$CD6D,$AAB3,$CD6B,$CD67,$CD6A,$CD66,$AAB5,$CD69,$AAB2,$AAB1,$AAB4,
$CD6C,$CD68,$ACC2,$ACC5,$CFCE,$CFCD,$CFCC,$ACBF,$CFD5,$CFCB,$ACC1,$D2AF,$CFD2,
$CFD0,$ACC4,$CFC8,$CFD3,$CFCA,$CFD4,$CFD1,$CFC9,$ACC0,$CFD6,$CFC7,$ACC3,$D2B4,
$D2AB,$D2B6,$D2AE,$D2B9,$D2BA,$D2AC,$D2B8,$D2B5,$D2B3,$D2B7,$AF5F,$AF5D,$D2B1,
$D2AD,$D2B0,$D2BB,$D2B2,$AF5E,$CFCF,$AF5A,$AF5C,$D678,$D66D,$D66B,$D66C,$D673,
$D674,$D670,$B27B,$D675,$D672,$D66F,$B279,$D66E,$B277,$B27A,$D671,$D679,$AF5B,
$B278,$D677,$D676,$B27C,$DA7E,$DAA1,$B560,$DAA7,$DAA9,$DAA2,$B55A,$DAA6,$DAA5,
$B55B,$B561,$B562,$DAA8,$B558,$DA7D,$DA7B,$DAA3,$DA7A,$B55F,$DA7C,$DAA4,$DAAA,
$B559,$B55E,$B55C,$B55D,$B557,$B7E9,$DEB7,$B7E8,$DEBB,$DEB1,$DEBC,$DEB2,$DEB3,
$DEBD,$DEBA,$DEB8,$DEB9,$DEB5,$DEB4,$DEBE,$B7E5,$DEB6,$B7EA,$B7E4,$B7EB,$B7EC,
$B7E7,$B7E6,$E2CE,$BABE,$BABD,$E2D3,$BCFC,$BABF,$BAC1,$E2D4,$B7E3,$BAC0,$E2D0,
$E2D2,$E2CF,$E2D1,$E6AB,$E6AA,$E6A7,$BD40,$EA62,$BD41,$E6A6,$BCFE,$E6A8,$E6A5,
$E6A2,$E6A9,$E6A3,$E6A4,$BCFD,$ED69,$EA66,$EA65,$EA67,$ED66,$BF5A,$EA63,$BF58,
$BF5C,$BF5B,$EA64,$EA68,$BF59,$ED6D,$C0F5,$C27A,$C0F6,$C0F3,$ED6A,$ED68,$ED6B,
$ED6E,$C0F4,$ED6C,$ED67,$F042,$F045,$F275,$F040,$F46F,$F046,$C3A2,$F044,$C27B,
$F041,$F043,$F047,$F276,$F274,$C3A3,$F273,$C46E,$C4ED,$F6F1,$C4EC,$F6F3,$F6F0,
$F6F2,$C5D0,$F8B2,$A5CA,$CD6E,$D2BC,$D2BD,$B27D,$DEBF,$BF5D,$C3A4,$C57B,$F8B3,
$A5CB,$CD6F,$A260,$CFD7,$CFD8,$D2BE,$D2BF,$B27E,$B2A1,$DAAB,$DEC2,$DEC1,$DEC0,
$E2D5,$E2D6,$E2D7,$BAC2,$E6AD,$E6AC,$EA69,$BF5E,$BF5F,$ED72,$ED6F,$ED70,$ED71,
$F049,$F048,$C27C,$F277,$F5DE,$A5CC,$ACC6,$B2A2,$DEC3,$A5CD,$D2C0,$B2A3,$B563,
$B564,$A5CE,$A5CF,$CA46,$A86A,$A869,$ACC7,$CFD9,$DAAC,$A5D0,$A5D1,$A5D2,$A5D3,
$A86B,$A86C,$CB6E,$CB6D,$AAB6,$CD72,$CD70,$CD71,$CFDA,$CFDB,$ACCB,$ACC9,$ACCA,
$ACC8,$AF60,$AF64,$AF63,$D2C1,$AF62,$AF61,$D2C2,$B2A6,$D67B,$D67A,$B2A4,$B2A5,
$B566,$B565,$DAAE,$DAAD,$B2A7,$B7ED,$DEC5,$B7EE,$DEC4,$E2D8,$E6AE,$BD42,$EA6A,
$ED73,$C3A6,$C3A5,$C57C,$A5D4,$CD73,$B2A8,$E2D9,$BAC3,$CB6F,$CB70,$CD74,$AAB8,
$AAB9,$AAB7,$ACCF,$ACD0,$ACCD,$ACCE,$CFDC,$CFDD,$ACCC,$D2C3,$AF68,$AF69,$B2AB,
$D2C9,$AF6E,$AF6C,$D2CA,$D2C5,$AF6B,$AF6A,$AF65,$D2C8,$D2C7,$D2C4,$AF6D,$D2C6,
$AF66,$AF67,$B2AC,$D6A1,$D6A2,$B2AD,$D67C,$D67E,$D6A4,$D6A3,$D67D,$B2A9,$B2AA,
$DAB6,$B56B,$B56A,$DAB0,$B568,$DAB3,$B56C,$DAB4,$B56D,$DAB1,$B567,$B569,$DAB5,
$DAB2,$DAAF,$DED2,$DEC7,$B7F0,$B7F3,$B7F2,$B7F7,$B7F6,$DED3,$DED1,$DECA,$DECE,
$DECD,$B7F4,$DED0,$DECC,$DED4,$DECB,$B7F5,$B7EF,$B7F1,$DEC9,$E2DB,$BAC7,$E2DF,
$BAC6,$E2DC,$BAC5,$DEC8,$DECF,$E2DE,$BAC8,$E2E0,$E2DD,$E2DA,$E6B1,$E6B5,$E6B7,
$E6B3,$E6B2,$E6B0,$BD45,$BD43,$BD48,$BD49,$E6B4,$BD46,$E6AF,$BD47,$BAC4,$E6B6,
$BD44,$EA6C,$EA6B,$EA73,$EA6D,$EA72,$EA6F,$BF60,$EA71,$BF61,$BF62,$EA70,$EA6E,
$C0F8,$ED74,$C0F7,$ED77,$ED75,$ED76,$C0F9,$F04D,$C2A1,$F04E,$C27D,$F04F,$C27E,
$F04C,$F050,$F04A,$C3A7,$F278,$C3A8,$C46F,$F04B,$C470,$C4EE,$F5DF,$C57E,$F6F4,
$C57D,$F7EA,$C5F5,$C5F6,$F9CC,$ACD1,$CFDE,$B56E,$B56F,$A5D5,$A6CA,$CA47,$CB71,
$A86D,$AABA,$ACD2,$ACD3,$ACD4,$D6A6,$D2CB,$AF6F,$B2AE,$D6A5,$DAB8,$B571,$DAB7,
$B570,$DED5,$BD4A,$E6BB,$E6B8,$E6B9,$E6BA,$ED78,$F051,$F471,$F470,$F6F5,$A5D6,
$CD75,$AF70,$B572,$DED6,$E2E1,$BD4B,$EA74,$F052,$F472,$A5D7,$AABB,$ACD7,$CFDF,
$ACD8,$ACD6,$ACD5,$D2CC,$AF71,$AF72,$AF73,$B2B0,$D6A7,$B2AF,$DAB9,$B2B1,$B573,
$DED7,$B7F8,$B7F9,$BAC9,$BACA,$BD4C,$BF64,$EA75,$BF63,$ED79,$C0FA,$F053,$F473,
$A5D8,$A86E,$CD78,$CD77,$AABC,$CD76,$AABD,$CD79,$CFE5,$ACDB,$ACDA,$CFE7,$CFE6,
$ACDF,$ACDE,$ACD9,$CFE1,$CFE2,$CFE3,$ACE0,$CFE0,$ACDC,$CFE4,$ACDD,$D2CF,$D2D3,
$D2D1,$D2D0,$D2D4,$D2D5,$D2D6,$D2CE,$D2CD,$AF75,$AF76,$D2D7,$D2D2,$D6B0,$D2D8,
$AF77,$AF74,$D6AA,$D6A9,$D6AB,$D6AC,$D6AE,$D6AD,$D6B2,$B2B5,$B2B2,$B2B6,$D6A8,
$B2B7,$D6B1,$B2B4,$D6AF,$B2B3,$DABC,$DABE,$DABA,$DABB,$DABF,$DAC1,$DAC2,$DABD,
$DAC0,$B574,$DEDB,$DEE0,$DED8,$DEDC,$DEE1,$DEDD,$B7FA,$B843,$B7FD,$DED9,$DEDA,
$BACE,$B846,$B7FE,$B844,$B7FC,$DEDF,$B845,$DEDE,$B841,$B7FB,$B842,$DEE2,$E2E6,
$E2E8,$B840,$E2E3,$BACC,$E2E9,$BACD,$E2E7,$E2E2,$E2E5,$E2EA,$BACB,$E2E4,$BD4E,
$E6BF,$E6BE,$BD51,$BD4F,$E6BC,$BD4D,$E6BD,$BD50,$EA7D,$EAA1,$EA7E,$EA76,$EA7A,
$EA79,$EA77,$BF66,$BF67,$BF65,$EA78,$EA7B,$EA7C,$BF68,$C140,$EDA3,$C0FC,$ED7B,
$C0FE,$C141,$C0FD,$EDA2,$ED7C,$C0FB,$EDA1,$ED7A,$ED7E,$ED7D,$F055,$C2A4,$C2A5,
$C2A2,$C2A3,$F054,$F27B,$C3A9,$F279,$F27A,$F474,$F477,$F475,$F476,$F5E0,$C4EF,
$F7EB,$F8B4,$C5F7,$F8F8,$F8F9,$C666,$A5D9,$ACE1,$DAC3,$DEE3,$A5DA,$A86F,$AABE,
$CFE8,$CFE9,$AF78,$DAC4,$B575,$B847,$C142,$EDA4,$F27C,$F478,$A5DB,$CDA1,$CD7A,
$CD7C,$CD7E,$CD7D,$CD7B,$AABF,$ACE2,$CFF2,$CFED,$CFEA,$CFF1,$ACE4,$ACE5,$CFF0,
$CFEF,$CFEE,$CFEB,$CFEC,$CFF3,$ACE3,$AF7C,$AFA4,$AFA3,$D2E1,$D2DB,$D2D9,$AFA1,
$D6B9,$AF7A,$D2DE,$D2E2,$D2E4,$D2E0,$D2DA,$AFA2,$D2DF,$D2DD,$AF79,$D2E5,$AFA5,
$D2E3,$AF7D,$D2DC,$AF7E,$AF7B,$B2B9,$D6BA,$D6B3,$D6B5,$D6B7,$D6B8,$D6B6,$B2BA,
$D6BB,$D6B4,$DAC8,$B576,$DAD0,$DAC5,$DAD1,$DAC6,$DAC7,$DACF,$DACE,$DACB,$B2B8,
$B577,$DAC9,$DACC,$B578,$DACD,$DACA,$DEEE,$DEF2,$B84E,$E2F0,$B851,$DEF0,$F9D6,
$DEED,$DEE8,$DEEA,$DEEB,$DEE4,$B84D,$B84C,$B848,$DEE7,$B84F,$B850,$DEE6,$DEE9,
$DEF1,$B84A,$B84B,$DEEF,$DEE5,$E2F2,$BAD0,$E2F4,$DEEC,$E2F6,$BAD4,$E2F7,$E2F3,
$BAD1,$E2EF,$BAD3,$E2EC,$E2F1,$E2F5,$E2EE,$B849,$E2EB,$BAD2,$E2ED,$BD54,$E6C1,
$BD58,$BD56,$BACF,$E6C8,$E6C9,$BD53,$E6C7,$E6CA,$BD55,$BD52,$E6C3,$E6C0,$E6C5,
$E6C2,$BD59,$E6C4,$E6C6,$BD57,$BF6A,$EAA8,$EAA2,$EAA6,$EAAC,$EAAD,$EAA9,$EAAA,
$EAA7,$EAA4,$BF6C,$BF69,$EAA3,$EAA5,$BF6B,$EAAB,$C146,$EDAA,$EDA5,$C145,$C143,
$EDAC,$C144,$EDA8,$EDA9,$EDA6,$EDAD,$F056,$C147,$EDA7,$EDAE,$EDAB,$F05A,$F057,
$C2A6,$F05B,$F05D,$F05C,$F058,$F059,$F2A3,$C3AA,$F27E,$F2A2,$F27D,$F2A4,$F2A1,
$F47A,$F47D,$F479,$C471,$F47B,$F47C,$F47E,$C472,$C474,$C473,$F5E1,$F5E3,$F5E2,
$F6F6,$F8B5,$F8FA,$A5DC,$CB72,$AAC0,$CDA3,$AAC1,$AAC2,$CDA2,$CFF8,$CFF7,$ACE6,
$ACE9,$ACE8,$ACE7,$CFF4,$CFF6,$CFF5,$D2E8,$AFA7,$D2EC,$D2EB,$D2EA,$D2E6,$AFA6,
$AFAA,$AFAD,$AFAE,$D2E7,$D2E9,$AFAC,$AFAB,$AFA9,$AFA8,$D6C2,$D6C0,$D6BC,$B2BB,
$D6BD,$B2BC,$D6BE,$D6BF,$D6C1,$B2BD,$DAD5,$DAD4,$DAD3,$DAD2,$DEF6,$B852,$DEF3,
$DEF5,$B853,$B854,$DEF4,$E341,$E2F9,$E2FA,$BAD7,$BAD5,$BAD6,$E343,$E342,$E2FE,
$E2FD,$E2FC,$E2FB,$E340,$E2F8,$E6CB,$E6D0,$E6CE,$E6CD,$E6CC,$E6CF,$EAAE,$BF6D,
$C148,$EDB0,$C149,$EDAF,$F05F,$F05E,$C2A7,$F2A5,$C3AB,$F4A1,$C5A1,$F6F7,$F8B7,
$F8B6,$C9A8,$ACEA,$ACEB,$D6C3,$B856,$A5DD,$A872,$A871,$A870,$CDA4,$AAC4,$AAC3,
$ACEE,$CFFA,$CFFD,$CFFB,$ACEC,$ACED,$CFF9,$CFFC,$AFB5,$D2F3,$D2F5,$D2F4,$AFB2,
$D2EF,$AFB0,$AFAF,$AFB3,$AFB1,$AFB4,$D2F2,$D2ED,$D2EE,$D2F1,$D2F0,$D6C6,$D6C7,
$D6C5,$D6C4,$B2BE,$B57D,$DAD6,$DAD8,$DADA,$B57C,$B57A,$DAD7,$B57B,$DAD9,$B579,
$DF41,$DEF7,$DEFA,$DEFE,$B85A,$DEFC,$DEFB,$DEF8,$DEF9,$B858,$DF40,$B857,$B85C,
$B85B,$B859,$DEFD,$E349,$E348,$E344,$BAD8,$E347,$E346,$BAD9,$BD5E,$E6D2,$BD5F,
$BD5B,$BD5D,$BD5A,$BD5C,$EAAF,$BF70,$EAB1,$EAB0,$E345,$BF72,$BF71,$BF6E,$BF6F,
$EDB5,$EDB3,$C14A,$EDB4,$EDB6,$EDB2,$EDB1,$F060,$C2AA,$C2A8,$C2A9,$F2A6,$F2A7,
$C3AD,$C3AC,$F4A3,$F4A4,$F4A2,$F6F8,$F6F9,$A5DE,$CA48,$A873,$CDA5,$AAC6,$AAC5,
$CDA6,$D040,$ACEF,$CFFE,$ACF0,$AFB6,$D2F8,$D2F6,$D2FC,$AFB7,$D2F7,$D2FB,$D2F9,
$D2FA,$D6C8,$D6CA,$B2BF,$D6C9,$B2C0,$B5A2,$B5A1,$B57E,$DADB,$DF44,$B85D,$B85E,
$DF43,$DF42,$E34A,$BADB,$BADA,$E34B,$E34C,$BD61,$BD60,$EAB5,$E6D3,$E6D5,$E6D4,
$EAB4,$EAB2,$EAB6,$EAB3,$BF73,$EDB7,$C14B,$EDB8,$EDB9,$C2AB,$C2AC,$C475,$C5D1,
$A5DF,$D041,$D2FD,$AFB8,$B3BA,$B3B9,$B5A4,$DADD,$B5A3,$DADC,$DF45,$BADC,$E34D,
$BADD,$C476,$F4A5,$A6CB,$AAC7,$CDA7,$ACF2,$ACF1,$D042,$D043,$D340,$D342,$AFB9,
$D344,$D347,$D345,$D346,$D343,$D2FE,$AFBA,$D348,$D341,$D6D3,$B2C6,$D6DC,$B2C3,
$D6D5,$B2C7,$B2C1,$D6D0,$D6DD,$D6D1,$D6CE,$B2C5,$B2C2,$D6D4,$D6D7,$B2C4,$D6D8,
$B2C8,$D6D9,$D6CF,$D6D6,$D6DA,$D6D2,$D6CD,$D6CB,$D6DB,$DADF,$DAE4,$DAE0,$DAE6,
$B5A7,$D6CC,$DAE1,$B5A5,$DADE,$B5AC,$DAE2,$B5AB,$DAE3,$B5AD,$B5A8,$B5AE,$B5A9,
$B5AA,$B5A6,$DAE5,$B861,$DF50,$DF53,$DF47,$DF4C,$DF46,$B863,$DF4A,$DF48,$B862,
$DF4F,$DF4E,$DF4B,$DF4D,$DF49,$BAE1,$DF52,$B85F,$DF51,$E35D,$BAE8,$E358,$BAE7,
$E34E,$E350,$BAE0,$E355,$E354,$E357,$BAE5,$E352,$E351,$BAE4,$BADF,$E353,$BAE2,
$E359,$E35B,$E356,$E34F,$BAE3,$BD69,$BADE,$E35C,$E6D9,$BD62,$E6DB,$BD63,$BD65,
$E6DE,$E6D6,$BAE6,$E6DC,$E6D8,$B860,$BD68,$BD64,$BD66,$BD67,$BF76,$E6DD,$E6D7,
$BD6A,$E6DA,$EAC0,$EABB,$EAC5,$BF74,$EABD,$BF78,$EAC3,$EABA,$EAB7,$EAC6,$C151,
$BF79,$EAC2,$EAB8,$BF77,$EABC,$BF7B,$EAB9,$EABE,$BF7A,$EAC1,$EAC4,$EDCB,$EDCC,
$EDBC,$EDC3,$EDC1,$C14F,$EDC8,$EABF,$EDBF,$EDC9,$C14E,$EDBE,$EDBD,$EDC7,$EDC4,
$EDC6,$EDBA,$EDCA,$C14C,$EDC5,$EDCE,$EDC2,$C150,$C14D,$EDC0,$EDBB,$EDCD,$BF75,
$F063,$F061,$F067,$C2B0,$F065,$F064,$C2B2,$F06A,$C2B1,$F06B,$F068,$C2AE,$F069,
$F062,$C2AF,$C2AD,$F2AB,$F066,$F06C,$F2A8,$C3B2,$C3B0,$F2AA,$F2AC,$F2A9,$C3B1,
$C3AE,$C3AF,$C3B3,$C478,$F4AA,$F4A9,$F4A7,$F4A6,$F4A8,$C477,$C479,$C4F0,$F5E5,
$F5E4,$F6FA,$F6FC,$F6FE,$F6FD,$F6FB,$C5A3,$C5A2,$C5D3,$C5D2,$C5D4,$F7ED,$F7EC,
$F8FB,$F8B8,$F8FC,$C658,$C659,$F96D,$C67E,$A6CC,$CDA8,$D045,$D046,$D044,$ACF3,
$D047,$D048,$D049,$D349,$D34F,$D34D,$AFBB,$D34B,$D34C,$D34E,$D34A,$B2C9,$D6DE,
$B2CB,$D6E0,$B2CA,$D6DF,$DAE8,$B5AF,$DAEA,$DAE7,$D6E1,$B5B0,$F9DB,$DAE9,$DF56,
$B864,$DF54,$B865,$DF55,$B866,$BAE9,$E361,$E35E,$E360,$BAEA,$BAEB,$E35F,$E6DF,
$E6E0,$BD6B,$E6E2,$E6E1,$A261,$EACA,$EACB,$EAC7,$EAC8,$BF7C,$BF7D,$EAC9,$C157,
$C153,$C158,$C154,$C156,$C152,$C155,$C2B3,$EDCF,$F2AE,$F2AD,$F4AB,$C47A,$C47B,
$F741,$F5E6,$F740,$F8FD,$F9A4,$A6CD,$A874,$CDA9,$AAC8,$ACF6,$D04C,$ACF4,$D04A,
$ACF9,$ACF5,$ACFA,$ACF8,$D04B,$ACF7,$AFBF,$AFBE,$D35A,$AFC7,$D353,$D359,$AFC3,
$D352,$D358,$D356,$AFC2,$AFC4,$D355,$AFBD,$D354,$AFC8,$AFC5,$AFC9,$AFC6,$D351,
$D350,$D357,$AFC0,$AFBC,$AFC1,$D6F0,$D6E9,$B5B5,$D6E8,$B2CF,$B2D6,$B2D3,$B2D9,
$B2D8,$B2D4,$D6E2,$D6E5,$D6E4,$B2D0,$D6E6,$D6EF,$B2D1,$D6E3,$D6EC,$D6ED,$B2D2,
$D6EA,$B2D7,$B2CD,$B2D5,$D6E7,$B2CC,$D6EB,$D6EE,$DAFB,$DAF2,$B5B2,$DAF9,$DAF6,
$DAEE,$DAF7,$B5B4,$DAEF,$DAEB,$B86C,$DAF4,$B5B1,$DAFA,$B5B8,$B5BA,$DAED,$B5B9,
$DAF0,$B5B3,$DAF8,$DAF1,$DAF5,$DAF3,$B5B6,$DAEC,$B5BB,$B2CE,$B5B7,$B5BC,$B868,
$DF5D,$DF5F,$DF61,$DF65,$DF5B,$DF59,$B86A,$DF60,$DF64,$DF5C,$DF58,$DF57,$DF62,
$DF5A,$DF5E,$B86B,$B869,$DF66,$B867,$DF63,$E372,$BAEE,$E36A,$BD78,$E374,$BAF1,
$E378,$BAF7,$E365,$E375,$E362,$E377,$E366,$BAFE,$BAFB,$E376,$E370,$BAED,$BAF5,
$BAF4,$BAF3,$BAF9,$E363,$BAFA,$E371,$BAF6,$BAEC,$E373,$BAEF,$BAF0,$BAF8,$E368,
$E367,$E364,$E36C,$E369,$E36D,$BAFD,$E379,$BAF2,$E36E,$E36F,$E36B,$BAFC,$E6E7,
$BD70,$BD79,$BD75,$E6E4,$BD72,$BD76,$E6F0,$BD6C,$E6E8,$BD74,$E6EB,$E6E6,$BD73,
$BD77,$E6E5,$BD71,$E6EF,$BD6E,$E6EE,$E6ED,$BD7A,$E572,$BD6D,$E6EC,$E6E3,$BD7B,
$E6EA,$BD6F,$E6E9,$BFA2,$BFA7,$BF7E,$EAD8,$EACF,$EADB,$EAD3,$EAD9,$BFA8,$BFA1,
$EACC,$EAD2,$EADC,$EAD5,$EADA,$EACE,$EAD6,$BFA3,$EAD4,$BFA6,$BFA5,$EAD0,$EAD1,
$EACD,$EAD7,$BFA4,$EADE,$EADD,$EDDA,$EDD6,$C15F,$EDD0,$C159,$C169,$EDDC,$C161,
$C15D,$EDD3,$C164,$C167,$EDDE,$C15C,$EDD5,$C165,$EDE0,$EDDD,$EDD1,$C160,$C15A,
$C168,$EDD8,$C163,$EDD2,$C15E,$EDDF,$C162,$C15B,$EDD9,$C166,$EDD7,$EDDB,$F06E,
$F074,$C2B9,$F077,$C2B4,$C2B5,$F06F,$F076,$F071,$C2BA,$C2B7,$F06D,$C2B6,$F073,
$F075,$C2B8,$F072,$F070,$F2B8,$C3B7,$C3B8,$C3B4,$C3B5,$F2B4,$F2B2,$F2B6,$C3BA,
$F2B7,$F2B0,$F2AF,$F2B3,$F2B1,$C3B6,$F2B5,$F4AC,$C47E,$C47D,$F4AD,$F4AF,$F4AE,
$C4A1,$F5EB,$F5E8,$F5E9,$F5E7,$F5EA,$C4F2,$F5EC,$C4F1,$F742,$C5D5,$C5D7,$F7EE,
$C5D6,$F8B9,$F940,$F942,$F8FE,$F941,$C66C,$A6CE,$ACFB,$D26F,$AFCA,$B2DA,$DAFC,
$DAFD,$EADF,$C16A,$EDE1,$C2BB,$F2BA,$F2B9,$C4A2,$F5ED,$F743,$C5F8,$CA49,$AAC9,
$A875,$D04D,$D360,$D35B,$D35F,$D35D,$AFCB,$D35E,$D35C,$D6F1,$DAFE,$DB40,$DF69,
$DF6A,$B86E,$B86F,$DF68,$DF6B,$DF67,$B86D,$BB40,$B870,$E37A,$BD7C,$E6F1,$BD7D,
$BFA9,$EAE2,$EAE0,$EAE1,$EDE4,$EDE3,$EDE2,$F2BB,$C3B9,$F2BC,$F744,$C5F9,$F8BA,
$A6CF,$AACB,$AACA,$D04F,$ACFC,$D04E,$D362,$AFCC,$D6F2,$D361,$B2DC,$D6F5,$D6F3,
$D6F4,$B2DB,$DB42,$DB43,$DB41,$B873,$DF6D,$DF6C,$DF6E,$B872,$B871,$E6F2,$E6F4,
$BD7E,$E6F3,$EAE3,$BFAA,$F079,$F078,$C3BB,$F2BD,$C3BD,$C3BC,$F4B0,$F5EE,$C4F3,
$A6D0,$D050,$ACFD,$D365,$AFCE,$D364,$D363,$AFCD,$D6FB,$D6FD,$D6F6,$D6F7,$B2DD,
$D6F8,$B2DE,$D6FC,$D6F9,$D6FA,$B2DF,$B5BE,$B5BF,$DB44,$DF6F,$DF70,$E37E,$BB43,
$BB41,$BB42,$E37B,$E37C,$E37D,$E6F9,$E6FA,$BDA1,$E6F7,$E6F6,$E6F8,$E6F5,$BFAD,
$EAE4,$BFAB,$BFAC,$EDE6,$C16B,$EDE5,$EFA8,$F07A,$F07B,$C2BC,$C2BD,$C16C,$F2BE,
$F2BF,$F4B1,$C4A3,$A6D1,$A6D2,$ACFE,$AACC,$AFCF,$D051,$B5C0,$A6D3,$AD41,$D052,
$D053,$AD40,$AD42,$A6D4,$D054,$AFD1,$D366,$AFD3,$AFD0,$AFD2,$D741,$B2E0,$D740,
$D6FE,$DF71,$E3A1,$BDA2,$BFAE,$EAE6,$EAE5,$EDE7,$F5EF,$A6D5,$CB73,$CDAA,$AD43,
$D055,$D368,$AFD4,$D367,$AFD5,$D743,$B2E2,$D742,$D744,$B2E1,$DB46,$DB47,$DB45,
$B5C1,$B874,$B875,$BB45,$E3A3,$E3A2,$BB44,$E6FB,$E6FC,$EAE7,$C170,$C16F,$C16D,
$C16E,$C171,$F07C,$C2BF,$C2BE,$F2C0,$F4B2,$C5A5,$C5A4,$A6D6,$D1FB,$B877,$B5C2,
$B876,$BB46,$A6D7,$C9A9,$A6D8,$A6D9,$CDAB,$CB76,$CB77,$A877,$CB74,$A876,$A879,
$CB75,$A87B,$A87A,$CB78,$A878,$AAD1,$AACF,$CDAD,$AACE,$AAD3,$AAD5,$AAD2,$CDB0,
$CDAC,$AAD6,$AAD0,$A87C,$AAD4,$CDAF,$CDAE,$AACD,$D05B,$AD47,$AD48,$D05D,$D057,
$D05A,$D063,$D061,$AD49,$D067,$AD4C,$D064,$D05C,$D059,$DB49,$D062,$AD44,$D065,
$D056,$D05F,$AD46,$AD4B,$D060,$AD4F,$AD4D,$D058,$AD4A,$D05E,$AD4E,$AD45,$D066,
$AFDA,$AFE3,$AFD8,$AFD6,$D36A,$AFDE,$AFDB,$D36C,$AFDD,$D36B,$D369,$D36E,$AFE2,
$AFE0,$DB48,$D36F,$D36D,$AFD7,$AFD9,$AFDC,$AFDF,$AFE1,$D74E,$B2E4,$D745,$D747,
$D748,$D750,$D74C,$D74A,$D74D,$D751,$B2E5,$B2E9,$D746,$D74F,$B2E7,$B2E6,$D74B,
$D749,$B2E3,$B2E8,$B5C8,$DB51,$DB4F,$B5CA,$DB4A,$DFA1,$B5C9,$DB4E,$DB4B,$B5C5,
$B5CB,$DB50,$B5C7,$DB4D,$BB47,$B5C6,$DB4C,$B5CC,$B5C4,$B5C3,$DF77,$DF75,$DF7B,
$DF73,$DFA2,$DF78,$DF72,$B87B,$B8A3,$DF7D,$DF76,$B87E,$B87C,$DF7E,$B879,$B878,
$DF79,$B87D,$B5CD,$DF7C,$DF74,$B87A,$B8A1,$B8A2,$BB4C,$BB48,$BB4D,$E3A6,$E3A5,
$E3A7,$BB4A,$E3A4,$BB4B,$E3AA,$E3A9,$E3A8,$BB49,$E741,$E744,$BDA8,$E743,$BDA7,
$BDA3,$BDA4,$BDA5,$E740,$E6FE,$BDA6,$E742,$E6FD,$EAE9,$EAF3,$BFB1,$BFB0,$EAED,
$EAEF,$EAEA,$EAEE,$EAE8,$EAF1,$BFAF,$EAF0,$EAEC,$EAF2,$EAEB,$C174,$EDE8,$EDEE,
$C178,$C17A,$C177,$C176,$C175,$C173,$EDE9,$EDEC,$C172,$EDED,$C179,$EDEB,$EDEA,
$C2C0,$C2C1,$F0A1,$F07D,$F07E,$F2C2,$F2C1,$C3BE,$F4B4,$C4A4,$F4B3,$F5F0,$F745,
$C5A6,$F943,$F944,$C5D8,$A6DA,$AAD7,$DB52,$BB4E,$C17B,$EDEF,$A6DB,$AFE5,$AFE4,
$DB53,$EAF4,$A6DC,$AD50,$DB54,$DB55,$DB56,$BB4F,$BFB2,$A6DD,$AAD8,$D068,$AFE6,
$D370,$B2EA,$DB57,$B8A4,$BB50,$BFB3,$C17C,$C2C2,$F4B5,$A6DE,$AAD9,$AFE7,$D752,
$B5CE,$BB51,$E3AB,$E745,$A6DF,$B5CF,$DFA3,$BB52,$A6E0,$CDB1,$D069,$AD51,$D372,
$AFEA,$AFE8,$AFE9,$AFEB,$D371,$D757,$D754,$D756,$B2EB,$B2ED,$B2EC,$D753,$B2EE,
$D755,$DB58,$DB59,$DB5A,$DFA6,$DFA7,$DFA5,$DFA8,$B8A5,$DFA4,$BB53,$E74A,$E746,
$E749,$E74B,$E748,$E747,$EAF5,$EAF6,$EAF7,$BFB4,$BFB5,$EDF1,$EDF0,$EDF2,$F0A3,
$F0A2,$F2C4,$F2C5,$F2C3,$C4A5,$F4B6,$F4B7,$F746,$F7EF,$F8BB,$A6E1,$A87D,$C17D,
$A6E2,$D758,$DB5B,$C641,$CA4A,$CA4B,$CA4D,$A6E3,$CA4E,$CA4C,$CBA2,$CBA3,$CB7B,
$CBA1,$A8A1,$A8A2,$CB7C,$CB7A,$CB79,$CB7D,$A87E,$CB7E,$D06A,$CDB6,$AADC,$CDB5,
$CDB7,$AADB,$CDBC,$AADF,$CDB2,$CDC0,$CDC6,$AAE6,$CDC3,$AAE3,$CDB9,$CDBF,$CDC1,
$CDB4,$AAE2,$AADD,$CDBA,$AAE4,$AAE7,$AAE1,$AADA,$CDBE,$CDB8,$CDC5,$AAE9,$AAE5,
$AAE0,$CDBD,$AFEC,$CDBB,$AADE,$AAE8,$CDB3,$CDC2,$CDC4,$AD62,$AD5C,$AD64,$AD61,
$D071,$D074,$AD5D,$D06B,$AD56,$AD60,$AD63,$AD65,$D0A2,$D077,$AD55,$D0A1,$AD59,
$AD57,$AD52,$D06F,$D07E,$D073,$D076,$D0A5,$AD66,$D07D,$AD5E,$D078,$D0A4,$D075,
$D079,$D07C,$D06D,$D0A3,$D07B,$D06C,$D070,$AD5F,$AD5A,$AD53,$AD58,$AD54,$AD67,
$D06E,$D3A5,$AD5B,$D07A,$CE41,$D3A8,$AFFA,$D376,$D3A3,$D37D,$D3B2,$D3AA,$D37E,
$D3A9,$D378,$D37C,$D3B5,$AFFD,$D3AD,$D3A4,$AFED,$D3B3,$D374,$D3AC,$AFFC,$AFF7,
$D373,$AFF5,$AFF4,$AFF9,$D3AB,$AFF1,$AFF8,$D072,$DB5C,$D3A6,$D37A,$AFFB,$D37B,
$D3A1,$AFFE,$D375,$D3AF,$D3AE,$D3B6,$AFF3,$AFF0,$D3B4,$D3B0,$D3A7,$D3A2,$AFF6,
$AFF2,$D377,$AFEE,$D3B1,$AFEF,$D379,$D75E,$D760,$D765,$D779,$B2FC,$B2F2,$D75D,
$B2FD,$B2FE,$D768,$D76F,$D775,$D762,$D769,$B340,$D777,$D772,$B2FA,$B2F8,$D76E,
$D76A,$D75C,$B2EF,$D761,$D759,$B2F7,$B2F9,$D766,$D763,$B2F4,$D773,$B2F1,$D764,
$D77A,$D76C,$D76B,$B2F0,$B2FB,$B2F3,$D75A,$D75F,$D770,$D776,$B341,$D75B,$D767,
$D76D,$B2F6,$D778,$D771,$D774,$B2F5,$DB6C,$DB60,$B5D7,$DB7D,$DBA7,$DBAA,$B5D5,
$DB68,$DBA3,$DB69,$DB77,$B5E2,$DB73,$B5DF,$DB74,$DB5D,$DBA4,$B5E8,$DBA1,$DB75,
$DBAC,$DB70,$DFC8,$DBAF,$B5E6,$DB6E,$DB7A,$B5E9,$B5D4,$DB72,$DBAD,$DB6B,$DB64,
$DB6F,$DB63,$DB61,$B5D0,$DBA5,$DB6A,$DBA8,$DBA9,$B5D8,$B5DD,$B5D9,$B5E1,$DB7E,
$B5DA,$DB76,$DB66,$B5D2,$DB5E,$DBA2,$DBAB,$DB65,$B5E0,$DBB0,$DB71,$DB6D,$B5D1,
$B5E5,$DB7C,$B5E7,$DB78,$B5DC,$B5D6,$B5DE,$B5D3,$B5E4,$DB79,$DB67,$DB7B,$DB62,
$DBA6,$DBAE,$DB5F,$DFC7,$DFDD,$B855,$DFCC,$DFCA,$DFB5,$B8A9,$DFC5,$DFD9,$DFC1,
$B8B1,$DFD8,$DFBF,$B5E3,$DFCF,$DFC0,$DFD6,$B8B0,$B8A8,$DFAA,$DFB2,$DFCB,$DFC3,
$DFDC,$DFC6,$B8B6,$DFD7,$B8AD,$DFC9,$DFD1,$DFB6,$DFD0,$DFE1,$DFB1,$DFD2,$DFDF,
$DFAB,$B5DB,$DFB9,$DFB8,$B8AF,$DFBC,$DFBE,$DFCD,$DFDE,$B8B2,$B8B3,$DFB0,$B8AB,
$DFB4,$DFDA,$B8B4,$B8AC,$B8AE,$B8B5,$DFE0,$DFD3,$DFCE,$DFBB,$DFBA,$B8AA,$DFAC,
$B8A7,$DFC4,$DFAD,$DFC2,$DFB7,$DFDB,$B8A6,$DFB3,$DFAF,$DFD5,$DFAE,$BB60,$E3D3,
$E3C2,$E3AC,$E3CA,$BB58,$E3BB,$E3C5,$BB5B,$E3BE,$BB59,$E3AF,$E3CD,$E3AE,$E3C1,
$E3AD,$E3BF,$E3C8,$E3C6,$E3BA,$E3B5,$E3B3,$E3B4,$E3C7,$E3D2,$E3BC,$BB5A,$E3B7,
$E3CB,$BB5D,$E3B6,$E3B0,$E3C0,$BB61,$BB55,$BB5E,$E3B8,$E3B2,$BB57,$DFD4,$BB56,
$E3C3,$BB54,$BB63,$BB5C,$E3C4,$E3B9,$E3B1,$E3CC,$E3BD,$BB62,$E3D0,$BB5F,$E3CF,
$E3C9,$E3CE,$E3D1,$E773,$E774,$E767,$E766,$E762,$BDB4,$BDAC,$E776,$E775,$DFA9,
$E75F,$E763,$E75D,$E770,$E761,$E777,$E75A,$E758,$E764,$E76E,$E769,$BDB6,$E74F,
$E76D,$BDB7,$DFBD,$E75B,$E752,$E755,$E77B,$E75C,$E753,$E751,$E74E,$BDB0,$E765,
$BDAF,$BDB3,$E760,$E768,$BDA9,$E778,$E77C,$BDAB,$E757,$E76B,$E76F,$E754,$E779,
$BDB2,$BDB1,$E74C,$BDB5,$E772,$E756,$E76A,$E750,$E75E,$E759,$BDAD,$BDAE,$E76C,
$E77D,$E77A,$E771,$E74D,$BDAA,$EB49,$EB40,$EB43,$BFBB,$EB45,$EAF9,$EB41,$EB47,
$BFB8,$BFBC,$BFB6,$EAFB,$EB4C,$EB46,$EAFC,$EB55,$EB4F,$EAF8,$EE46,$EAFE,$BFB7,
$EB4A,$EB54,$BFBF,$EB51,$EAFD,$EB44,$EB48,$EB42,$EB56,$EB53,$EB50,$BFB9,$BFBA,
$BFBE,$EAFA,$EB57,$BFBD,$EB4D,$EB4B,$EB4E,$EE53,$EE40,$EE45,$EE52,$EE44,$EDFB,
$EE41,$C1A2,$EDF4,$EE4D,$EE4F,$EDF3,$C1A1,$EE51,$EE49,$C1A8,$EE50,$EE42,$C1AA,
$EDF9,$EB52,$EE4A,$EE47,$EDF5,$EE55,$C1A4,$C1A5,$EDF7,$EE48,$EE54,$EE4B,$EDFD,
$C1A7,$C1A3,$EE4C,$EDFE,$EE56,$EDF8,$EE43,$EE4E,$EDFA,$EDFC,$C2CB,$EDF6,$C1A9,
$C2C4,$C17E,$C1A6,$C2C8,$F0B3,$F0A9,$F0A4,$F0AA,$F0B4,$F0B8,$F0B7,$C2CA,$C2C9,
$F0AB,$F0B9,$F0AE,$F0A6,$F0A8,$F0A7,$F0AD,$F0B2,$F0A5,$F0AC,$F0B1,$C2C7,$F0AF,
$C2C5,$F0B0,$C2C3,$C2C6,$F2D5,$F0B5,$C3C2,$F2CD,$F2D1,$F2C9,$F2CC,$F2D4,$C3C0,
$F2D9,$F2D2,$F2CA,$F2DA,$F2D3,$C3C3,$C3C4,$F2D7,$F2CB,$C3BF,$C3C1,$F2C6,$F2CE,
$F2C8,$F2D8,$F2D6,$F2C7,$F2CF,$F4BE,$C3C5,$F2D0,$C4A7,$C4A9,$C4A6,$F4C3,$F4BB,
$F4B9,$F4BD,$F4BA,$F4BF,$F4C1,$C4AA,$C4AC,$F4C0,$C4AD,$C4AB,$F4C2,$C4A8,$C4F4,
$F5F1,$F5F7,$C4F6,$F4BC,$F5F6,$F5FD,$F5F4,$F5FB,$F5FA,$F4B8,$F5F5,$F0B6,$F5FE,
$F5F3,$F5F8,$F5FC,$F5F2,$F74A,$C4F5,$F5F9,$F7F4,$F74B,$F749,$F747,$F748,$F74C,
$C5D9,$F7F2,$F7F0,$F7F5,$F7F3,$F7F6,$C5DA,$F7F1,$F8BC,$F945,$F946,$F947,$F9C7,
$F9BD,$CA4F,$AAEA,$AD68,$D3B8,$D3B7,$B040,$B342,$D77C,$D77B,$B5EA,$B8B8,$B8B7,
$B8B9,$E3D4,$E77E,$EB58,$EB5A,$EB59,$C1AB,$EE57,$F0BA,$F9A5,$A6E4,$CDC9,$CDCA,
$CDC8,$CDC7,$AAEB,$D0A9,$D0A7,$D0A6,$AD69,$AD6B,$AD6A,$D0A8,$D3C4,$D3C1,$D3BF,
$B041,$D3C2,$B046,$D3BC,$D3CB,$D3CD,$D3BD,$B043,$D3CE,$D3C9,$D3BB,$D3C0,$D3CA,
$D3C6,$D3C3,$B048,$D3CC,$D3BE,$D3C7,$D3B9,$B047,$B044,$D3C5,$D3C8,$D3BA,$B045,
$B042,$B34C,$D7A5,$B34B,$D7A8,$D7AB,$B348,$B346,$D77E,$D7A9,$D7A7,$D7A4,$D7AC,
$D7AD,$D7AF,$D7B0,$D77D,$B345,$D7A2,$D7A1,$D7AE,$B347,$D7A3,$B349,$B344,$D7A6,
$B34D,$B34A,$D7AA,$B5F1,$DBBF,$DBB4,$B5EE,$DFE7,$DBBD,$DBB1,$B5EC,$DBB6,$B5EF,
$DBBA,$DBB8,$B5F2,$B5EB,$DBB2,$DBB5,$B5F0,$DBB3,$DBBE,$DBBC,$DBB7,$DBB9,$DBBB,
$B5ED,$DFE8,$DFEE,$DFE4,$DFEA,$B8BA,$DFE6,$B8C0,$B8BF,$B8BE,$DFED,$B8C1,$B8C2,
$DFE3,$DFF0,$B8C3,$B8BD,$B8BC,$DFEC,$B8C4,$DFE2,$DFE5,$DFEF,$DFEB,$E3F4,$E3E9,
$B8BB,$BB6A,$E3DD,$E3F2,$E3DE,$BB65,$E3DB,$E3E4,$E3DC,$BB67,$E3D6,$E3F1,$BB68,
$E3EE,$E3EF,$E3D7,$BB6D,$E3E6,$E3E0,$E3E7,$E3DA,$E3F3,$E3EB,$E3E5,$E3D5,$BB69,
$E3EC,$BB6C,$E3F0,$E3EA,$BB66,$E3E8,$E3E2,$BB64,$E3D9,$E3E1,$E3ED,$E3DF,$E3E3,
$BDC1,$DFE9,$E7B2,$E7BB,$E7B1,$E7AD,$E7AA,$BDC2,$E7A8,$BB6B,$E7A1,$BDC0,$E7A7,
$BDBF,$E7AC,$E7A9,$E7B9,$E7B4,$E7AE,$E7B3,$BDBB,$E7AB,$E7BE,$E7A2,$E7A3,$E7BA,
$BDBC,$E7BF,$BDBE,$E7C0,$E7B0,$E3D8,$E7B6,$E7AF,$E7B8,$E7B5,$E7A6,$BDB9,$E7BD,
$BDBA,$E7A4,$BDBD,$EB64,$E7B7,$E7BC,$EB61,$BDB8,$BFC0,$EB6B,$EB67,$EB65,$EB60,
$EB6F,$BFC4,$EB5C,$EB68,$EB69,$EB5F,$EB5E,$EB6C,$EB62,$EB5D,$EB63,$EB6E,$EB5B,
$EB6D,$EB6A,$BFC2,$BFC1,$BFC3,$EB66,$F0CB,$EE59,$C1B1,$EE5D,$EE5A,$EE61,$EE67,
$EE5C,$EE70,$C1AE,$EE6A,$EE5F,$EE6B,$EE66,$EE6D,$EE5E,$C1B3,$C1B2,$EE60,$EE6E,
$EE58,$EE6C,$C1AC,$EE64,$EE63,$EE68,$EE5B,$C1B0,$C1B4,$EE62,$EE69,$C1B5,$EE65,
$C1AD,$C1AF,$F0C7,$F0C5,$F0CC,$F0C9,$F0CD,$F0BE,$F0C6,$F0D1,$EE6F,$F0C2,$C2CF,
$E7A5,$F0BD,$F0CA,$F0C4,$F0C1,$F0BC,$F0BB,$F0D0,$F0C0,$F0BF,$C2CD,$F0C8,$C2CC,
$C2CE,$F0C3,$F0CF,$F2DE,$F2DF,$C3C9,$F2DC,$C3C6,$F2E4,$C3CA,$F2E6,$F2DB,$F0CE,
$F2E8,$F2DD,$C3C7,$F2E3,$F2E5,$F2E0,$F2E7,$F2E2,$F2E1,$C3C8,$F4C5,$F4C6,$F4C8,
$C4AE,$C4AF,$F4C9,$F4C7,$F4C4,$F642,$F645,$F641,$C4FA,$F643,$C4F9,$C4F8,$C4F7,
$F644,$F751,$F74F,$F74E,$F640,$F750,$F646,$F74D,$F7F9,$F7D7,$F7F7,$C5DB,$F7F8,
$F7FA,$F8BF,$C5FA,$F8BE,$F8BD,$C5FB,$C65A,$F96E,$F9A7,$F9A6,$F9A8,$A6E5,$D0AA,
$D3CF,$D3D0,$DBC0,$F647,$F8C0,$A6E6,$AD6C,$D0AB,$D7B1,$B34E,$DBC2,$DBC1,$B5F3,
$B8C5,$E7C1,$BDC3,$BDC4,$BFC5,$C5FC,$A6E7,$D0AC,$AAED,$D0AE,$D0AD,$AD6D,$D3D1,
$D3D8,$B049,$D3D6,$D3D4,$D3DB,$D3D2,$D3D3,$B04A,$B04E,$D3DC,$B04D,$D3DA,$D3D7,
$D3D5,$B04B,$B04C,$D3D9,$B350,$D7B2,$B355,$D7C2,$B354,$D7C4,$D7B8,$B352,$D7C3,
$D7B3,$B353,$D7BF,$D7BB,$D7BD,$D7B7,$D7BE,$B34F,$D7BA,$D7B9,$D7B5,$D7C0,$D7BC,
$D7B4,$D7B6,$B351,$D7C1,$B5F6,$DBCD,$DBC9,$DBCB,$DBC6,$DBC5,$DBC3,$DBCA,$DBCC,
$DBC8,$DBC7,$B5F4,$B5F5,$DBCF,$B8CD,$DFF2,$DFF8,$DFF3,$DFF4,$F9D8,$DFF9,$B8CF,
$B8C7,$B8CE,$DFF1,$DBC4,$B8CA,$B8C8,$DFF7,$DFF6,$B8C9,$B8CB,$DFF5,$B8C6,$B8CC,
$E3F6,$BB74,$E442,$E441,$E3FB,$BB76,$E440,$E3F7,$E3F8,$BB6E,$BB70,$E3FD,$E3F5,
$BB72,$BB71,$E3F9,$E3FE,$E3FC,$BB73,$E3FA,$DBCE,$BB6F,$E7C2,$E7C9,$BDC6,$E7CD,
$BDCA,$E7C5,$E7C3,$E7CC,$BDC5,$E7CB,$BDC7,$BDC8,$E7C4,$BDC9,$E7CA,$E7C6,$E7C7,
$E7C8,$BB75,$EB70,$EB7C,$BFCA,$EB77,$EB79,$BFC8,$EB71,$EB75,$EB78,$BFC6,$BFC9,
$EB7B,$EB73,$EB74,$EB7A,$EB72,$EB76,$BFC7,$EE72,$EE71,$C1B7,$EE77,$C1B9,$C1B6,
$EE73,$C1BA,$EE74,$EE75,$EE78,$C1B8,$F0D6,$F0D9,$F0D3,$F0D5,$F0D4,$F0D7,$F0D8,
$EE76,$F0D2,$C3CD,$F2EC,$F2EF,$F2F1,$F2EA,$F2EB,$F2EE,$F2F0,$C3CE,$C3CC,$C3CB,
$F2ED,$F2E9,$F4CA,$C4B0,$F4CB,$F649,$C4FB,$F64B,$C4FC,$F648,$F64A,$C5A8,$F752,
$C5A7,$F7FD,$F7FC,$F7FB,$F948,$F949,$F94B,$F94A,$CA50,$A6E8,$AD6E,$D7C5,$B5F7,
$DFFA,$C2D0,$F2F2,$A8A3,$B357,$B356,$DBD0,$B5F8,$DBD2,$DBD1,$DFFB,$B8D0,$E443,
$E446,$E445,$E444,$E7CE,$E7D0,$E7CF,$BFCC,$BFCB,$C1BB,$EE79,$EE7B,$EE7A,$C2D1,
$F2F4,$F2F3,$F4CC,$C4B1,$C4FD,$F754,$F753,$C65B,$A8A4,$D0AF,$AD6F,$D7C8,$D7C6,
$D7C7,$DBD4,$DBD5,$E043,$DBD3,$DFFC,$E041,$E040,$E042,$B8D1,$DFFE,$DFFD,$E044,
$E449,$E447,$E448,$E7D3,$E7D1,$E7D2,$EB7D,$EE7C,$EE7D,$C2D2,$F2F5,$F4CD,$C4B2,
$F64C,$F755,$C5A9,$F7FE,$F94C,$A8A5,$AD71,$AD72,$D0B0,$D0B1,$AD70,$B054,$B052,
$B051,$B058,$B050,$B059,$D3DD,$B056,$B053,$B057,$B055,$B04F,$B35F,$B359,$D7CC,
$B35E,$B360,$B35A,$B35B,$D7CA,$B358,$D7CB,$B35D,$D7C9,$B35C,$B644,$B646,$DBD8,
$B645,$B5F9,$B5FD,$B8E4,$E049,$DBDA,$B5FE,$DBDD,$DBDE,$B643,$DBE0,$DBE2,$DBE3,
$DBD7,$DBD6,$DBE4,$B642,$DBE1,$DBDF,$B640,$B5FB,$B647,$DBDB,$DBDC,$DBD9,$B641,
$B5FC,$B5FA,$E048,$B8DF,$B8DA,$B8D5,$B8E5,$B8D6,$B8D2,$B8E1,$B8DE,$B8E0,$B8D7,
$B8DC,$B8D3,$B8D4,$E050,$E04D,$E045,$E04A,$B8E2,$E051,$B8E3,$B8D9,$E047,$E04F,
$E04B,$E04E,$E04C,$B8DD,$E046,$B8D8,$E44C,$BB78,$BB7B,$E44E,$BBA5,$E44D,$BB7D,
$BDCF,$E44F,$BBA4,$E44B,$BBA6,$BB79,$B8DB,$BB7C,$BB7A,$BB7E,$BBA2,$BB77,$BBA7,
$BBA3,$BBA1,$E44A,$BDD6,$BDD2,$BDD9,$E7D6,$BDDA,$E7E2,$E7DB,$BDCB,$E7E3,$E7DD,
$BDD5,$E7DE,$BDD4,$E7E1,$BDCE,$E7DF,$E7D5,$BDCD,$EBAA,$BDD3,$BDD0,$BDD8,$E7D4,
$E7D8,$BDCC,$E7D7,$E7D9,$E7DA,$BDD7,$E7DC,$E7E0,$E7E4,$BDDB,$BFD2,$EBA5,$EBAB,
$EBA8,$EB7E,$EBAC,$EBA1,$EBA7,$BFCD,$BFD3,$EBAD,$BFCF,$BFD9,$BFD4,$EBAF,$EBA9,
$BFD0,$EBA2,$BFDA,$EBA3,$EBA4,$BFDB,$BFD8,$BDD1,$BFCE,$EBB0,$BFDC,$BFD5,$EBAE,
$BFD1,$BFD6,$BFD7,$C1C3,$EEA4,$EEAD,$EEAA,$EEAC,$C1C0,$EEA5,$EEAB,$C1BC,$EEA7,
$C1C4,$EEA3,$EEA8,$EEAF,$EBA6,$EEA9,$EEA2,$C1BD,$EEA1,$C1BE,$EEB0,$C1BF,$EEAE,
$C1C2,$EE7E,$C1C1,$EEA6,$F0DC,$F0EA,$F0E5,$F0E7,$F0DB,$C2D3,$F0DA,$C2D6,$C2D5,
$F0E9,$F0E1,$F0DE,$F0E4,$F0DD,$F0DF,$F0E8,$F0E6,$C2D4,$F0ED,$F0EB,$F0E2,$F0EC,
$F0E3,$F2F9,$C3CF,$F341,$F64F,$C3D6,$F0E0,$F2F7,$C3D2,$F2F8,$F2FD,$C3D4,$C3D5,
$F2F6,$F340,$F342,$F2FA,$F2FC,$F2FE,$F2FB,$F343,$C3D1,$C3D7,$C3D3,$C3D0,$F4D0,
$C4B7,$F4CE,$F4D2,$F4D3,$C4B5,$F4D4,$F4D1,$F4CF,$C4B8,$C4B4,$F4D5,$C4B6,$C4B3,
$C4FE,$C540,$F64E,$F64D,$F650,$F651,$C541,$F756,$F75B,$C5AA,$F758,$F757,$F75A,
$F759,$F843,$C5DC,$F842,$F840,$F841,$C5FE,$C5FD,$F8C1,$F8C2,$C640,$F94D,$F94E,
$C667,$C66D,$F9A9,$F9C8,$A8A6,$D7CD,$D7CE,$E052,$E450,$E7E5,$C1C6,$C1C5,$F0EE,
$F344,$F844,$A8A7,$D3DE,$B05A,$B361,$E054,$E053,$BDDC,$E7E6,$BDDD,$EEB1,$C2D7,
$C676,$A8A8,$CDCB,$D3DF,$B362,$D7CF,$D7D0,$DBE5,$B648,$B8E6,$E056,$E055,$E057,
$E451,$E452,$BBA8,$BFDD,$BDDE,$BFDE,$EEB5,$EEB2,$EEB4,$EEB3,$C1C7,$F0EF,$F346,
$F345,$CBA4,$B05C,$B05B,$D3E0,$D7D1,$DBE7,$DBE6,$B649,$E059,$E05A,$E058,$B8E8,
$B8E7,$BBAA,$BBA9,$E7E7,$EBB3,$EBB1,$EBB2,$BFDF,$EEB7,$EEB6,$F0F2,$F0F1,$F0F0,
$F347,$F9AA,$A8A9,$AD73,$AD74,$B05D,$B05E,$D3E2,$D3E1,$D7D2,$B368,$B366,$B363,
$B367,$B365,$B364,$B64A,$DBEA,$B8ED,$B64C,$B651,$DBEC,$B653,$B652,$B655,$DBEB,
$DBE8,$B64F,$B64B,$B64D,$DBE9,$B654,$B650,$B64E,$B8EF,$B8EE,$B8EC,$B8F0,$B8EA,
$B8EB,$B8E9,$E05B,$E454,$BBAC,$BBAD,$BBAB,$E453,$E455,$E7EA,$E7EC,$BDE7,$E7ED,
$BDE0,$E7E9,$BDDF,$BDE9,$BDE5,$BDE6,$BDE2,$E7E8,$BDE1,$E7EE,$E7EB,$BDE8,$BDE3,
$BDE4,$EBB5,$EBB7,$EBB6,$EBB8,$BFE0,$EBB4,$C1CB,$EEB8,$C1C8,$C1CC,$C1CA,$C1C9,
$F0F3,$F0F6,$F0F5,$F0F4,$C2D8,$F348,$F349,$C3D8,$F34A,$C3D9,$C4BA,$C4B9,$F652,
$C542,$F653,$F75C,$C5AB,$C5AC,$F845,$C642,$A8AA,$B36A,$B369,$E05C,$E05D,$BBAE,
$EBB9,$BDEA,$EBBA,$EEB9,$A8AB,$D0B2,$AD76,$AD75,$D3E3,$B05F,$D3E4,$D7D5,$D7D4,
$D7D3,$DBEE,$B658,$DBED,$B657,$DBEF,$B656,$E05F,$E062,$E060,$E061,$E065,$E05E,
$E066,$E063,$E064,$BBB0,$E456,$BBAF,$E7F2,$E7F0,$BDEB,$E7EF,$E7F1,$BDEC,$EBBB,
$EBBC,$C1CD,$F34C,$F34E,$F34B,$F34D,$F4D6,$F654,$F96F,$A8AC,$AD77,$D3E5,$D3E7,
$D3E6,$D7D8,$B36C,$D7D6,$B36B,$D7D9,$D7DA,$D7D7,$DBFB,$B660,$DBF3,$DBF9,$B65B,
$B65E,$DBF2,$B659,$DBF6,$E06C,$B65D,$DBF1,$DBF7,$DBF4,$DBFA,$DBF0,$DBF8,$B65C,
$B65F,$DBF5,$B65A,$B8F2,$E068,$B8F1,$E06F,$E06E,$B8F8,$B8F9,$E070,$B8F3,$E06D,
$B8F7,$E072,$E069,$E06B,$B8F4,$E067,$E06A,$E071,$B8F5,$E073,$B8F6,$BBB1,$E45B,
$E461,$E459,$E462,$E458,$E45D,$E463,$E460,$E45F,$E45E,$E457,$E45C,$E45A,$BDF1,
$BDEE,$E7FB,$E841,$E843,$E840,$E7F8,$E7FA,$E845,$E842,$E7FC,$E846,$E7F9,$E844,
$BDEF,$BDF5,$BDF3,$E7F3,$BDF4,$BDF0,$E7F4,$E7F6,$E7F5,$E7FD,$E7FE,$BDF2,$BDED,
$E7F7,$EBC6,$BFE2,$EBBD,$BFE3,$BFE6,$EBC2,$EBBF,$BFE5,$EBC3,$EBC4,$EBBE,$EBC7,
$EBC0,$EBC5,$BFE4,$BFE1,$EBC1,$EEBF,$C1D0,$C1CE,$C1D1,$C1CF,$EEBE,$EEBB,$EEBA,
$EEBD,$EEBC,$F145,$C2DE,$F0FB,$F0FA,$C2D9,$F141,$F140,$F0F7,$F143,$F0FC,$C2DD,
$F0F9,$F142,$F0F8,$C2DA,$C2DC,$F0FD,$C2DB,$F0FE,$F144,$F352,$C3DE,$F34F,$F353,
$C3DB,$F351,$C3E0,$C3DD,$F350,$C3DF,$F354,$C3DA,$C4BC,$C4BE,$F4D9,$C4BD,$F4D7,
$C3DC,$F4D8,$C4BB,$C543,$C545,$F656,$C544,$F655,$F761,$C5AD,$F760,$C5AE,$F75E,
$F75D,$F762,$F763,$F846,$F75F,$F8C6,$F8C3,$F8C4,$F8C5,$C65C,$F951,$F950,$F94F,
$F970,$F9BE,$F9AB,$C66E,$A8AD,$B060,$B8FA,$BDF6,$EBC8,$C2DF,$F355,$F9AC,$A8AE,
$AAEE,$AD79,$AD78,$B063,$D3E8,$B061,$D3E9,$B062,$D7DF,$D7DB,$B36D,$D7DE,$D7DD,
$D7DC,$B36E,$D7E0,$D7E1,$DC43,$DC41,$DC45,$DC46,$DC4C,$DC48,$DC4A,$DC42,$DBFC,
$DC49,$DC4B,$DC44,$DC47,$DBFD,$B662,$DC40,$DBFE,$B661,$B663,$B8FD,$E075,$E077,
$E076,$E07B,$B8FB,$E078,$E074,$E079,$E07A,$B8FC,$B8FE,$E07C,$E467,$E466,$E464,
$E465,$BBB3,$BBB5,$BBB2,$BBB4,$E84D,$E84E,$E849,$E84A,$BDF8,$BDFD,$BDF7,$BDFE,
$BDF9,$E84B,$E84C,$E848,$BE40,$BDFB,$BDFA,$BDFC,$E847,$EBCA,$BFE8,$EBCC,$BFEA,
$EBCF,$EBCB,$EBC9,$EBCE,$BFE9,$EBCD,$BFE7,$C1D3,$C1D6,$EEC1,$C1D4,$EEC0,$C1D2,
$C1D5,$F146,$F147,$F148,$C2E0,$F149,$C2E1,$C3E2,$F358,$F359,$F357,$F356,$F35A,
$C3E1,$F4DD,$F4DB,$F4DC,$F4DE,$F4DA,$F4DF,$F658,$F659,$F657,$C546,$F764,$C5AF,
$F765,$F848,$F847,$A8AF,$B664,$B940,$BBB6,$BFEC,$BFEB,$C3E3,$C47C,$C547,$A8B0,
$B064,$B941,$F35B,$CBA6,$A8B1,$A8B4,$A8B3,$A8B2,$CBA5,$CDCD,$CDCF,$AAEF,$AAF1,
$CDCC,$CDCE,$AAF0,$CDD1,$CDD0,$CDD2,$D0B6,$D0B4,$AD7C,$D0B3,$ADA3,$AD7E,$AD7B,
$ADA4,$AD7D,$ADA2,$ADA1,$D0B5,$AD7A,$B06A,$D3EB,$D3F1,$B067,$B06E,$B069,$D3EE,
$D3F0,$B06C,$D3EA,$D3ED,$B068,$B065,$D3EC,$B06B,$D3EF,$B06D,$B066,$D7E3,$D7E6,
$B370,$B37A,$B376,$D7E4,$B37E,$B377,$B37C,$B372,$B36F,$B371,$B37D,$D7E5,$B375,
$B378,$B374,$B379,$D7E7,$B37B,$B373,$D7E2,$DC4D,$B665,$DC4F,$B667,$B669,$DC4E,
$B666,$B66A,$B668,$B947,$E0A3,$B94F,$E07E,$B950,$B945,$E0A1,$B94A,$E0A2,$B943,
$B942,$B94D,$B94C,$B94B,$B949,$B94E,$E07D,$B944,$B946,$B948,$BBB8,$BBBB,$BBBF,
$BBB9,$BBBE,$BBBC,$BBB7,$BBBD,$BBBA,$E852,$BE43,$BE41,$E853,$BE44,$BE42,$E851,
$E850,$BFF0,$E84F,$BFEE,$BFED,$EBD0,$BE45,$BFEF,$EBD1,$BFF2,$EBD2,$BFF1,$C1D8,
$EEC3,$C1D7,$C1DC,$C1DA,$C1DB,$C2E3,$C1D9,$EEC2,$EBD3,$C2E2,$C2E4,$C3E4,$C3E5,
$F4E0,$C5DE,$C5DD,$A8B6,$CA55,$B06F,$CA52,$CA53,$CA51,$CA54,$CBAA,$CBA7,$CBAC,
$CBA8,$A8B7,$A8BA,$CBA9,$A8B9,$CBAB,$A8B8,$CDD5,$CDD7,$AAF4,$CDD3,$CDD6,$CDD4,
$AAF2,$AAF5,$AAF3,$D0B8,$D0BC,$D0B9,$ADA7,$ADA8,$D0BB,$D0BD,$D0BF,$ADA5,$D0BE,
$ADA6,$D7EE,$D0BA,$D3F2,$D3FB,$D3F9,$D3F4,$D3F5,$D3FA,$D3FC,$B071,$D3F7,$D3F3,
$B070,$B072,$D3F6,$D3FD,$D3F8,$B3A1,$D7F1,$D7E9,$D7EF,$D7F0,$B3A2,$D7E8,$D7EA,
$D0B7,$D7EC,$D7ED,$D7EB,$B66C,$DC56,$EBD4,$DC57,$DC54,$B3A3,$B66E,$DC53,$DC59,
$DC58,$B66B,$DC5C,$DC52,$DC5B,$DC50,$DC5A,$DC55,$B66D,$E0AA,$E0A5,$E0AB,$E0A6,
$E0A4,$E0A7,$B951,$E0A9,$E0A8,$B952,$BBC1,$BBC0,$E46E,$E471,$E469,$E46D,$BBC2,
$E46C,$E46A,$E470,$E46B,$E468,$E46F,$E859,$BE48,$F14A,$E856,$E857,$E855,$DC51,
$BE47,$E85A,$E854,$BE46,$BE49,$E858,$EBD5,$BFF3,$EBD6,$EBD7,$EEC4,$C1DD,$F14B,
$F14C,$F14D,$F35D,$F35C,$F4E2,$F4E1,$F65B,$F65C,$F65A,$F766,$C5B0,$A8BB,$ADAA,
$ADA9,$B075,$B074,$D440,$D441,$D3FE,$B073,$D7F5,$D7F6,$D7F2,$B3A4,$D7F3,$D7F4,
$DC5F,$DC61,$DC5D,$DC60,$B66F,$DC5E,$B670,$DD73,$B955,$B954,$B953,$E0AC,$E0AD,
$E473,$E475,$BBC6,$BBC3,$BBC5,$BBC4,$E474,$E472,$E861,$E85E,$E85F,$BE4D,$E860,
$E85B,$E85C,$BE4A,$BE4B,$E85D,$BE4C,$EBDB,$EBDC,$EBD9,$EBDA,$BFF4,$EBD8,$EEC8,
$EEC5,$EEC7,$C1E0,$EECB,$C1DF,$EEC9,$EECC,$EECA,$EEC6,$C1DE,$F14F,$F150,$F14E,
$F152,$C2E5,$C2E6,$F35F,$C3E7,$F151,$F35E,$C3E6,$F4E5,$F4E6,$C4BF,$F4E4,$F4E3,
$F65D,$C548,$F849,$F8C8,$F8C7,$C643,$C65D,$F8C9,$F971,$C66F,$A8BC,$AAF6,$B956,
$C4C0,$A8BD,$ADAB,$B3A5,$B671,$C2E7,$AAF7,$D0C1,$D0C0,$D442,$B078,$B076,$B07A,
$D444,$B079,$B077,$D443,$B3A8,$D7FC,$B3A7,$B3A9,$D842,$B3AB,$D7FE,$D840,$D7F7,
$B3AA,$D843,$D7F9,$D7FA,$D7F8,$B3A6,$D841,$D7FB,$D7FD,$DC6D,$DC6C,$DC6A,$DC62,
$DC71,$DC65,$DC6F,$DC76,$DC6E,$B679,$B675,$DC63,$DC69,$B677,$DC68,$B678,$B67A,
$DC6B,$B672,$B673,$DC77,$DC75,$DC74,$DC66,$DC72,$B676,$B674,$DC73,$DC64,$DC67,
$DC70,$E4BA,$E0B7,$E0B0,$E0C3,$E0CC,$E0B3,$B961,$E0C0,$B957,$B959,$B965,$E0B1,
$B95A,$B95C,$B966,$B95B,$B964,$E0B9,$E0AE,$B962,$E0B8,$B95E,$E0CA,$B963,$E0C8,
$E0BC,$E0C6,$B960,$E0AF,$E0C9,$E0C4,$E0CB,$B958,$B967,$B95D,$E0B5,$E0BD,$E0C1,
$E0C5,$B95F,$E0B4,$E0B2,$E0BE,$E0BB,$E0BA,$E0BF,$E0C2,$E0C7,$E478,$BBC7,$E4A4,
$E47A,$BBCC,$BBD0,$E4AD,$E4B5,$E4A6,$BBC8,$E4AA,$E0B6,$BBC9,$E4B1,$E4B6,$E4AE,
$E4B0,$E4B9,$E4B2,$E47E,$E4A9,$BBD1,$BBCD,$E47C,$E4AB,$BBCB,$E4A5,$BBCA,$E4B3,
$E4A2,$E479,$BBCE,$E4B8,$E47B,$E4AF,$E4AC,$E4A7,$E477,$E476,$E4A1,$E4B4,$BBCF,
$E4B7,$E47D,$E4A3,$BE52,$BE5A,$BE55,$E8A4,$E8A1,$E867,$BE50,$F9D7,$BE4F,$BE56,
$E865,$BE54,$E871,$E863,$E864,$BE4E,$E8A3,$BE58,$E874,$E879,$E873,$EBEE,$E86F,
$E877,$E875,$E868,$E862,$E87D,$BE57,$E87E,$E878,$E86D,$E86B,$E866,$E86E,$E87B,
$E86A,$E87A,$E8A2,$BE53,$E876,$E87C,$E872,$E86C,$BE51,$E4A8,$E870,$BE59,$E869,
$EBF4,$BFF7,$EBF3,$EBF0,$EC44,$BFFB,$EC41,$EBF8,$EC43,$EBE9,$EBF6,$BFFD,$EBE1,
$EBDF,$EC42,$EC40,$EBFE,$EBED,$EBEC,$EBE2,$C040,$EBE8,$EBF2,$EBFD,$C043,$EC45,
$C1E8,$C045,$BFFE,$EBE6,$EBEF,$EBDE,$EBE0,$BFF5,$C042,$BFFA,$EBE7,$EBF7,$EBF1,
$C041,$EBDD,$C1E3,$EBF9,$EBFC,$BFFC,$EBEB,$C044,$BFF9,$BFF8,$EBF5,$EBFB,$BFF6,
$EBE4,$EBFA,$EBE5,$EBEA,$EED2,$EED7,$C1E5,$C1E7,$EEDD,$C1E1,$EEEC,$EEE3,$EED8,
$EED9,$EEE2,$C1EE,$EEE1,$EED1,$EEE0,$EED4,$EEED,$C1ED,$C1EB,$EED5,$EEE8,$EEDA,
$EEE7,$EEE9,$EED0,$C1E6,$EEEA,$EEDE,$C1EA,$EEDB,$C1EC,$EEE4,$C1E4,$EED6,$EEE5,
$EEDF,$EBE3,$EEE6,$EED3,$C1E9,$EEEB,$C1E2,$EECE,$F160,$F159,$C2E9,$F154,$F163,
$F15B,$EEDC,$F165,$F155,$C2E8,$F15F,$C2EA,$C2F2,$C2F0,$F161,$C2F1,$F157,$F158,
$F15D,$F162,$EECD,$C2EB,$F16A,$F167,$F16B,$F15E,$F15A,$F168,$F36A,$F15C,$C2EE,
$C2ED,$EECF,$C2EF,$F164,$F166,$C2EC,$F169,$F153,$F156,$F373,$F363,$C3EB,$F371,
$F361,$C3EC,$F36C,$F368,$C3F1,$F372,$F362,$F365,$C3E9,$F374,$F36D,$F370,$C3EF,
$C3F4,$C3F2,$F369,$F364,$C3ED,$C3EE,$F360,$C3EA,$C3E8,$C3F0,$F36F,$C3F3,$F36B,
$F375,$C3F5,$F367,$F36E,$F4F3,$F542,$F4F5,$F4FC,$F366,$F4FA,$F4E9,$F540,$C4C3,
$F4ED,$F4FE,$F4F4,$C4C2,$F544,$F4F6,$F4FB,$F4FD,$F4E7,$F541,$F4F2,$F4F7,$F4EB,
$F4EF,$F543,$F4F9,$F4E8,$F4EC,$F4EE,$F4F8,$C4C1,$F4F1,$F4EA,$F4F0,$F661,$F666,
$C54F,$F668,$C549,$F664,$F66A,$C54E,$C54A,$C54B,$F660,$F667,$C54D,$F665,$C54C,
$F65F,$F663,$F662,$F65E,$F669,$C5B1,$F76D,$F770,$F76C,$F76E,$F76F,$F769,$F76A,
$F767,$F76B,$F768,$C5B2,$C5B3,$F84B,$F84D,$F84C,$F84E,$C5E0,$F84A,$C5DF,$C5E1,
$F8CB,$F8CC,$C644,$F8CA,$F953,$F952,$F954,$C65F,$F955,$C65E,$F956,$F972,$F975,
$F974,$C668,$F973,$C672,$C670,$C671,$C677,$F9C0,$F9C1,$F9BF,$F9C9,$AAF8,$D844,
$DC78,$E8A5,$F376,$AAF9,$ADAC,$B07B,$D845,$D846,$B3AC,$B67D,$DC7A,$DC79,$B6A3,
$B67C,$DC7B,$B67E,$B6A2,$B6A1,$B67B,$B968,$E0D0,$E0CE,$E0CF,$E0CD,$BBD2,$BBD5,
$BBD7,$BBD6,$BBD3,$BBD4,$E8A7,$E8A6,$BE5B,$E8A8,$E8A9,$BE5C,$EC4D,$EC4B,$EEF3,
$EC49,$EC4A,$C046,$EC46,$EC4E,$EC48,$EC4C,$EEEF,$EEF1,$EEF2,$C1F3,$EEEE,$C1F2,
$EEF0,$C1EF,$C1F0,$C1F1,$EC47,$C2F5,$F16E,$F16C,$F16D,$C2F3,$C2F6,$C2F4,$F377,
$F378,$C3F6,$F545,$F547,$F546,$C4C4,$C550,$F66D,$F66C,$F66B,$AAFA,$C9AA,$CA58,
$A6E9,$CA56,$CA59,$CA57,$CBAE,$A8C1,$A8C2,$CBB0,$A8BF,$CBAF,$CBAD,$A8C0,$A8BE,
$CDD8,$CDDB,$AAFD,$CDDA,$CDD9,$AAFC,$AAFB,$AB40,$CDDC,$AAFE,$D0C6,$ADAE,$ADAF,
$ADB0,$D0C7,$D0C3,$ADAD,$D0C4,$D0C5,$D0C2,$B0A4,$B0A1,$D445,$B0A2,$B0A5,$D446,
$B07E,$B07C,$B07D,$B0A3,$B3AD,$D849,$B3B5,$D848,$D84B,$B3B1,$D84A,$B6AB,$B3AF,
$B3B2,$B3AE,$B3B3,$B3B4,$B3B0,$D847,$B6A7,$DC7D,$DCA3,$DCA2,$B6AC,$B6A8,$B6A9,
$DC7C,$DC7E,$DCA1,$B6A4,$B6A6,$B6AA,$B6A5,$E0D3,$E0D1,$E0D2,$B96A,$B96B,$E0D4,
$B969,$BBD8,$BBDA,$BBD9,$E4BB,$E4BC,$E8AB,$E8AA,$C047,$C048,$EC4F,$C049,$EEF6,
$EEF4,$EEF5,$C1F4,$F16F,$C3F7,$C1F5,$AB41,$B0A6,$D447,$D84C,$B3B6,$B6AD,$DCA4,
$DCA6,$B6AF,$B6AE,$B6B0,$B6B1,$DCA5,$B96E,$B96F,$B96D,$BBDB,$B96C,$E0D5,$BBDC,
$E8AC,$EC50,$C04A,$C1F6,$F170,$F174,$C2F9,$F171,$C2FA,$C2F8,$F175,$C2FB,$F173,
$F379,$C2F7,$C3F8,$F8CD,$AB42,$B3B8,$B3B7,$B6B2,$DCA8,$DCA7,$B6B3,$E0D9,$B973,
$B970,$E0D8,$B972,$E0D6,$B971,$E0D7,$E4BD,$BBDD,$E8AF,$BE5D,$E8AD,$BE5E,$BE5F,
$E8AE,$BE60,$EC51,$C04E,$C04B,$C050,$EC53,$C04C,$EC52,$C04F,$C04D,$EEF9,$EEFB,
$C1F7,$EEFA,$C1F8,$EEF8,$EEF7,$F177,$F176,$C2FC,$F178,$F37E,$C3FA,$F37D,$F37A,
$C3F9,$F37B,$F37C,$F548,$F549,$C4C5,$C553,$F66E,$C551,$C552,$F66F,$C5B4,$C5B5,
$F771,$C645,$F8CF,$C647,$F8CE,$F8D0,$C646,$F957,$F9AD,$AB43,$B974,$E4BE,$E8B0,
$C051,$C052,$AB44,$BE61,$C3FB,$ADB1,$C053,$C5E2,$ADB2,$D84D,$DCA9,$DCAB,$DCAA,
$E0DD,$E0DA,$B975,$B976,$E0DB,$E0DC,$E4C0,$E4C5,$BBDE,$E4BF,$E4C1,$E4C8,$E4C3,
$E4C7,$E4C4,$E4C2,$E4C6,$BBDF,$E8B3,$E8B1,$BE63,$BE62,$E8B2,$BE64,$EC56,$EC55,
$C054,$EC54,$EEFC,$EEFE,$EF41,$EF40,$C1F9,$EEFD,$F1A1,$C2FD,$F17D,$F1A2,$C2FE,
$F17B,$F17E,$F17C,$F179,$C340,$F17A,$F3A1,$F3A3,$F3A2,$F54A,$F54B,$F670,$C5B7,
$C5B6,$F84F,$F850,$C648,$F8D1,$C669,$ADB3,$B6B4,$E4CA,$E4C9,$E8B5,$E8B4,$C1FA,
$EF43,$EF42,$F1A5,$F1A3,$F1A6,$F1A4,$C3FC,$F3A4,$F3A5,$F3A6,$F671,$F772,$F8D2,
$ADB4,$EC57,$EF44,$ADB5,$BBE0,$EC58,$C341,$F1A7,$C3FD,$F54C,$F54D,$C554,$F851,
$ADB6,$B3BB,$B3BC,$D84E,$B6B5,$B6B6,$DCAC,$B6B7,$B97A,$B97C,$E0DF,$E0E0,$E0DE,
$B977,$B978,$B97B,$B979,$E4CB,$BBE1,$BBE2,$E8BC,$BE67,$E8B7,$E8B6,$E8BB,$BE65,
$C05B,$E8B8,$E8BD,$E8BA,$E8B9,$BE66,$C059,$EC5A,$C055,$EC5B,$EC59,$C058,$C056,
$C05A,$C057,$EF45,$EF4A,$EF46,$EF49,$C1FB,$EDD4,$EF48,$EF47,$C344,$C342,$C345,
$C343,$F1A8,$F1A9,$F1AA,$C346,$F3AA,$C440,$F3A8,$C441,$F3A7,$F3A9,$C3FE,$F551,
$F54E,$F54F,$F550,$F672,$C556,$C555,$F774,$F773,$C5B8,$C5E3,$C649,$C660,$F958,
$F9AE,$F9AF,$ADB7,$DCAD,$E0E1,$E4CC,$E4CD,$BBE3,$BBE4,$E8BE,$BE68,$C1FC,$F1AB,
$C347,$F3AD,$C442,$F3AC,$F3AE,$F3AB,$F675,$F552,$F553,$C4C6,$F674,$F673,$F775,
$F9B0,$ADB8,$ADB9,$B0A7,$D448,$D84F,$B6B8,$B6BB,$B6B9,$DCAE,$B6BD,$B6BA,$B6BC,
$B97E,$E0E2,$E0E3,$E8C0,$B97D,$B9A1,$B9A2,$E4CF,$E4CE,$BBE5,$BBE6,$E4D0,$E8BF,
$BBE8,$BE69,$BBE7,$C05C,$E8C1,$BE6B,$BE6A,$E8C2,$E8C5,$E8C3,$E8C4,$BE6C,$C061,
$C05F,$C05E,$EC5D,$C060,$EC5C,$EF4B,$EC5E,$C05D,$EC5F,$EF4E,$EF4C,$EF4D,$EF52,
$C34B,$EF51,$EF54,$EF53,$EF50,$EF4F,$C1FD,$F1AE,$F1AD,$C34A,$C348,$C349,$F1AC,
$F3B1,$C443,$F3B0,$F3AF,$C444,$F558,$F557,$F555,$F554,$C4C8,$C4C7,$F559,$F776,
$C5B9,$F677,$C557,$F676,$F556,$F777,$C5E4,$C661,$F959,$F9B1,$ADBA,$D850,$EF55,
$ADBB,$E4D2,$E4D1,$EC60,$EF57,$EF56,$C34C,$F3B2,$F3B3,$C4C9,$F9B2,$B0A8,$B6BF,
$B6BE,$E0E4,$E0E6,$B9A4,$E0E5,$B9A3,$B9A5,$E0E7,$E4D4,$E4D6,$E4D5,$E4D8,$BBE9,
$E4D7,$E4D3,$E4D9,$E8CC,$E8CF,$E8D1,$E8C7,$E8CB,$E8C8,$BE6E,$BE71,$BE73,$E8C9,
$E8CA,$BE72,$E8CD,$E8D0,$E8CE,$BE74,$BE70,$E8C6,$BE6D,$BE6F,$C063,$EC66,$EC64,
$EC63,$EC69,$EC68,$EC67,$EC62,$C062,$EC61,$EC65,$C064,$EF5A,$EF5E,$EF5B,$EF5D,
$EF5C,$EF59,$EF5F,$EF62,$EF60,$EF61,$C240,$C1FE,$EF58,$EF63,$F1B3,$F1B6,$F1B8,
$F1B7,$F1B1,$F1B5,$F1B0,$F1B2,$C34D,$F1AF,$F1B4,$F3C0,$F3B5,$C445,$C446,$F3B4,
$F3B9,$F3BF,$F3B7,$F3BE,$F3BB,$F3BA,$F3BD,$F3B8,$F3B6,$F3BC,$F560,$F55E,$C4CA,
$F55D,$F563,$F561,$C4CB,$F55C,$F55A,$F55B,$C4CD,$F55F,$C4CC,$F562,$F678,$F67E,
$F679,$C55B,$F6A1,$C55A,$F67D,$F67C,$C559,$F67B,$C558,$F67A,$F77D,$F7A1,$F77E,
$F77B,$C5BB,$F778,$F77C,$F7A3,$F7A2,$F779,$F77A,$C5BA,$F852,$C5E7,$F853,$C5E5,
$C5E6,$F8D3,$C64A,$F976,$C66A,$F9B3,$C66B,$F9B4,$F9B5,$F9C3,$F9C2,$C67A,$F9CD,
$B0A9,$E0E9,$E0E8,$BBEA,$BBEB,$E4DA,$E8D2,$EC6C,$BE75,$C065,$EC6A,$EC6D,$C066,
$EF64,$EC6B,$F1B9,$C34E,$F3C1,$F566,$F564,$F565,$F6A2,$C55C,$F7A4,$C5EA,$C5BC,
$C5E8,$C5E9,$F8D4,$C662,$B0AA,$F1BA,$D449,$B9A6,$E4DB,$BBEC,$E4DC,$E8D4,$E8D3,
$C068,$BE76,$BE77,$E8D7,$E8D6,$E8D5,$EC6E,$EC71,$EC70,$EC6F,$C067,$EF68,$EF66,
$EF65,$EF67,$C34F,$F1BC,$F1BD,$C350,$F1BB,$F3C3,$F3C2,$F3C5,$C447,$F3C4,$F567,
$F569,$F568,$F6A3,$F6A6,$F6A4,$F6A5,$F7A5,$C5BD,$F854,$F855,$F856,$C64B,$C663,
$F9B6,$B0AB,$BE78,$C069,$F1BE,$F7A6,$F9C4,$D44A,$C67B,$B0AC,$EC72,$F1BF,$F3C6,
$F6A7,$F7A7,$B0AD,$E4DD,$E4DE,$BBED,$BBEE,$E8D9,$BE7A,$BE79,$E8D8,$EF69,$F1C0,
$F1C2,$F1C1,$C353,$C352,$C351,$C55E,$F6A8,$C55D,$F7A9,$F7A8,$C64C,$F8D5,$B3BD,
$E0EA,$E4E1,$E4DF,$E4E0,$E8E2,$E8DD,$E8DA,$E8E1,$E8E3,$BE7C,$E8E0,$E8DC,$E8DB,
$E8DF,$E8DE,$BE7B,$EC7D,$EC78,$EC76,$ECA1,$EC77,$EC73,$EC79,$EC74,$EF72,$EC75,
$ECA2,$EC7C,$C06A,$EC7B,$EC7A,$EC7E,$EF6A,$EF6D,$EF6C,$EF74,$EF6F,$EF73,$EF71,
$EF70,$EF6E,$EF6B,$C243,$C242,$C244,$C241,$EF75,$F1C8,$F1CB,$F1C9,$F1CD,$F1CE,
$F1C6,$C358,$F1C7,$F1C5,$F1CC,$F1C4,$F1C3,$C357,$C355,$C354,$F1CA,$F3CF,$F3D5,
$C44A,$F3D0,$F3D3,$F3D7,$C44B,$F3D2,$F3CA,$F3C9,$F3D6,$F3CD,$F3CB,$F3D4,$F3CC,
$C449,$C448,$F3C7,$F3C8,$F3D1,$F3CE,$F56C,$F56F,$C356,$F56D,$F573,$F571,$F56B,
$F576,$F56A,$C4CF,$F572,$F56E,$C4CE,$F575,$F574,$F6AB,$F6AA,$F6B1,$F6AD,$F6B0,
$C560,$F6AE,$F6AF,$F6A9,$F6AC,$C55F,$C5BF,$F7B4,$F7AF,$F7B3,$F7B6,$F7B2,$F7AE,
$C5C1,$F7B1,$F7B5,$C5C0,$F7AC,$F570,$F7B0,$F7AD,$F7AA,$F7AB,$C5BE,$F85A,$F85C,
$F85F,$F85B,$F860,$F859,$F857,$C5EB,$F85D,$C5ED,$C5EC,$F858,$F85E,$F8DA,$C64D,
$F8DB,$F8D9,$F8D6,$F8D8,$F8D7,$F95A,$F95C,$F95B,$F979,$F978,$F977,$F97A,$C673,
$C674,$F9CA,$F9CE,$B3BE,$DCAF,$E0ED,$B9A7,$E0EB,$E0EC,$E4E2,$E4E3,$BBF1,$BBEF,
$E4E4,$BBF0,$E8E8,$E8EB,$E8E5,$E8EC,$E8E4,$E8E6,$E8E7,$E8EA,$BEA1,$E8EF,$E8EE,
$BE7D,$E8E9,$E8ED,$BE7E,$ECAC,$C06F,$ECA7,$C06B,$ECA4,$ECAA,$ECAD,$C070,$ECA9,
$ECA6,$ECAE,$ECA5,$ECAB,$C06C,$ECA3,$C06D,$C06E,$ECA8,$EFA9,$EF7A,$EF7B,$EF7E,
$EF7C,$EF76,$EF79,$EFA5,$EF7D,$C245,$EFA7,$EFA4,$C246,$EFA6,$EF77,$EFA2,$EFA3,
$EFA1,$F1D2,$F1D4,$F1D7,$F1D1,$C359,$F1D9,$F1D0,$F1DA,$F1D6,$F1D8,$F1DC,$F1D5,
$F1DD,$F1D3,$F1CF,$C35A,$F1DB,$C35B,$C44D,$EF78,$F3F1,$F3E8,$C44F,$F3E4,$C450,
$F3ED,$F3E7,$F3DD,$C44E,$F3EA,$F3E5,$F3E6,$F3D8,$F3DF,$F3EE,$F3EB,$F3E3,$F3EF,
$F3DE,$F3D9,$F3EC,$F3DB,$F3E9,$F3E0,$F3F0,$F3DC,$C44C,$F3DA,$F3E1,$F3E2,$F57D,
$F57B,$F5A2,$F5AE,$F5A5,$F57C,$F578,$F5A7,$F57E,$F5A3,$F57A,$F5AA,$F577,$F5A1,
$F5A6,$F5A8,$F5AB,$F579,$F5AF,$F5B0,$F5A9,$F5AD,$F5A4,$F6C1,$F6C4,$C561,$F6C3,
$F6C8,$F6C6,$C562,$F6BD,$F6B3,$F6B2,$C564,$F6BF,$F6C0,$F6BC,$F6B4,$F6B9,$F5AC,
$F6B5,$C563,$F6BB,$F6BA,$F6B6,$F6C2,$F6B7,$F7BB,$F6C5,$F6C7,$F6BE,$F6B8,$F7BC,
$F7BE,$F7B8,$C5C2,$F7C5,$F7C3,$C5C3,$F7C2,$F7C1,$F7BA,$F7B7,$F7BD,$F7C6,$F7B9,
$F7BF,$F869,$F86E,$F864,$F867,$C5EE,$F86B,$F872,$F7C0,$F865,$F86F,$F873,$F86A,
$F863,$F86D,$F86C,$F871,$F870,$F7C4,$F868,$F862,$F866,$C64E,$C64F,$F861,$F8E6,
$F8DD,$F8E5,$F8E2,$F8E3,$F8DC,$F8DF,$F8E7,$F8E1,$F8E0,$F8DE,$F8E4,$F95D,$F95E,
$F960,$F95F,$F962,$F961,$F97C,$F97B,$F9B7,$F9B8,$F9C5,$C678,$C67C,$F9CF,$C67D,
$B3BF,$C4D0,$F6C9,$C650,$C651,$B3C0,$E0EE,$B9A8,$E8F0,$ECB0,$ECB1,$ECAF,$EFAB,
$EFAA,$C247,$F1DF,$EFAC,$F1DE,$F3F3,$C451,$C453,$F3F2,$C452,$F5B1,$F5B3,$F5B2,
$F6CA,$C565,$C5EF,$F8E8,$F963,$F9D2,$B3C1,$E4E5,$BEA2,$ECB3,$ECB2,$EFAD,$C454,
$C4D1,$F7C7,$F9CB,$B3C2,$BBF2,$BEA3,$F3F4,$F874,$B6C0,$EFAE,$C664,$B6C1,$BEA4,
$C248,$F875,$B6C2,$E8F1,$C072,$ECB4,$ECB5,$C071,$EFAF,$C24C,$C24A,$C24B,$C249,
$F1E0,$C35C,$F5B5,$F5B4,$F5B7,$F5B6,$C4D2,$F6CB,$F6CD,$F6CC,$C566,$F7C8,$F876,
$F877,$C5F0,$F964,$F97D,$C675,$DCB0,$ECB6,$EFB0,$F3F5,$E0EF,$EFB1,$F1E2,$F1E1,
$F878,$C652,$F965,$F97E,$B9A9,$E8F2,$E8F3,$ECB7,$B9AA,$C35D,$F1E3,$F6CF,$C567,
$F6D0,$F6CE,$F879,$F8E9,$B9AB,$EFB4,$EFB3,$EFB2,$F1E4,$F1E8,$F1E7,$F1E6,$F1E5,
$C35E,$F3F6,$F5B9,$C4D3,$F5B8,$F6D1,$F7CB,$F7CA,$C5C4,$F7C9,$F87C,$F87B,$F87A,
$BBF3,$ECB8,$C24D,$F3F7,$F3F8,$F7CC,$F87D,$F8EA,$F966,$F9B9,$F9D4,$BBF4,$C24E,
$F1E9,$F3F9,$F6D2,$F87E,$BEA6,$EFB5,$F1EA,$F3FA,$F3FB,$F3FC,$F5BE,$F5BA,$C568,
$F5BD,$F5BC,$C4D4,$F5BB,$C4D6,$C4D5,$F6D4,$F6D3,$C569,$C56A,$C5C6,$F7CD,$C5C5,
$F8A3,$F8A4,$F8A2,$F8A1,$C654,$F8EB,$F8EC,$F8ED,$C653,$F967,$F96A,$F969,$F968,
$F9D3,$C073,$C365,$F5BF,$F6D5,$C5C7,$F7CE,$F9D5,$C074,$EFB6,$F7CF,$F9A1,$C94A,
$DDFC,$A14A,$A157,$A159,$A15B,$A15F,$A160,$A163,$A164,$A167,$A168,$A16B,$A16C,
$A16F,$A170,$A173,$A174,$A177,$A178,$A17B,$A17C,$A1C6,$A1C7,$A1CA,$A1CB,$A1C8,
$A1C9,$A15C,$A14D,$A14E,$A14F,$A151,$A152,$A153,$A154,$A17D,$A17E,$A1A1,$A1A2,
$A1A3,$A1A4,$A1CC,$A1CD,$A1CE,$A1DE,$A1DF,$A1E0,$A1E1,$A1E2,$A242,$A24C,$A24D,
$A24E,$A149,$A1AD,$A243,$A248,$A1AE,$A15D,$A15E,$A1AF,$A1CF,$A141,$A1D0,$A144,
$A1FE,$A2AF,$A2B0,$A2B1,$A2B2,$A2B3,$A2B4,$A2B5,$A2B6,$A2B7,$A2B8,$A147,$A146,
$A1D5,$A1D7,$A1D6,$A148,$A249,$A2CF,$A2D0,$A2D1,$A2D2,$A2D3,$A2D4,$A2D5,$A2D6,
$A2D7,$A2D8,$A2D9,$A2DA,$A2DB,$A2DC,$A2DD,$A2DE,$A2DF,$A2E0,$A2E1,$A2E2,$A2E3,
$A2E4,$A2E5,$A2E6,$A2E7,$A2E8,$A240,$A1C4,$A2E9,$A2EA,$A2EB,$A2EC,$A2ED,$A2EE,
$A2EF,$A2F0,$A2F1,$A2F2,$A2F3,$A2F4,$A2F5,$A2F6,$A2F7,$A2F8,$A2F9,$A2FA,$A2FB,
$A2FC,$A2FD,$A2FE,$A340,$A341,$A342,$A343,$A161,$A155,$A162,$A1E3,$A246,$A247,
$A1C3,$A244);

const Uni950U: CP950Arr =
(0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,$0000,$0001,$0002,$0003,$0004,$0005,$0006,$0007,$0008,$0009,$000A,
$000B,$000C,$000D,$000E,$000F,$0010,$0011,$0012,$0013,$0014,$0015,$0016,$0017,
$0018,$0019,$001A,$001B,$001C,$001D,$001E,$001F,$0020,$0021,$0022,$0023,$0024,
$0025,$0026,$0027,$0028,$0029,$002A,$002B,$002C,$002D,$002E,$002F,$0030,$0031,
$0032,$0033,$0034,$0035,$0036,$0037,$0038,$0039,$003A,$003B,$003C,$003D,$003E,
$003F,$0040,$0041,$0042,$0043,$0044,$0045,$0046,$0047,$0048,$0049,$004A,$004B,
$004C,$004D,$004E,$004F,$0050,$0051,$0052,$0053,$0054,$0055,$0056,$0057,$0058,
$0059,$005A,$005B,$005C,$005D,$005E,$005F,$0060,$0061,$0062,$0063,$0064,$0065,
$0066,$0067,$0068,$0069,$006A,$006B,$006C,$006D,$006E,$006F,$0070,$0071,$0072,
$0073,$0074,$0075,$0076,$0077,$0078,$0079,$007A,$007B,$007C,$007D,$007E,$007F,
$00A7,$00AF,$00B0,$00B1,$00B7,$00D7,$00F7,$02C7,$02C9,$02CA,$02CB,$02CD,$02D9,
$0391,$0392,$0393,$0394,$0395,$0396,$0397,$0398,$0399,$039A,$039B,$039C,$039D,
$039E,$039F,$03A0,$03A1,$03A3,$03A4,$03A5,$03A6,$03A7,$03A8,$03A9,$03B1,$03B2,
$03B3,$03B4,$03B5,$03B6,$03B7,$03B8,$03B9,$03BA,$03BB,$03BC,$03BD,$03BE,$03BF,
$03C0,$03C1,$03C3,$03C4,$03C5,$03C6,$03C7,$03C8,$03C9,$2013,$2014,$2018,$2019,
$201C,$201D,$2025,$2026,$2027,$2032,$2035,$203B,$20AC,$2103,$2105,$2109,$2160,
$2161,$2162,$2163,$2164,$2165,$2166,$2167,$2168,$2169,$2190,$2191,$2192,$2193,
$2196,$2197,$2198,$2199,$2215,$221A,$221E,$221F,$2220,$2223,$2225,$2229,$222A,
$222B,$222E,$2234,$2235,$2252,$2260,$2261,$2266,$2267,$2295,$2299,$22A5,$22BF,
$2500,$2502,$250C,$2510,$2514,$2518,$251C,$2524,$252C,$2534,$253C,$2550,$2550,
$2551,$2552,$2553,$2554,$2555,$2556,$2557,$2558,$2559,$255A,$255B,$255C,$255D,
$255E,$255E,$255F,$2560,$2561,$2561,$2562,$2563,$2564,$2565,$2566,$2567,$2568,
$2569,$256A,$256A,$256B,$256C,$256D,$256D,$256E,$256E,$256F,$256F,$2570,$2570,
$2571,$2572,$2573,$2574,$2581,$2582,$2583,$2584,$2585,$2586,$2587,$2588,$2589,
$258A,$258B,$258C,$258D,$258E,$258F,$2593,$2594,$2595,$25A0,$25A1,$25B2,$25B3,
$25BC,$25BD,$25C6,$25C7,$25CB,$25CE,$25CF,$25E2,$25E3,$25E4,$25E5,$2605,$2606,
$2640,$2642,$3000,$3001,$3002,$3003,$3008,$3009,$300A,$300B,$300C,$300D,$300E,
$300F,$3010,$3011,$3012,$3014,$3015,$301D,$301E,$3021,$3022,$3023,$3024,$3025,
$3026,$3027,$3028,$3029,$3105,$3106,$3107,$3108,$3109,$310A,$310B,$310C,$310D,
$310E,$310F,$3110,$3111,$3112,$3113,$3114,$3115,$3116,$3117,$3118,$3119,$311A,
$311B,$311C,$311D,$311E,$311F,$3120,$3121,$3122,$3123,$3124,$3125,$3126,$3127,
$3128,$3129,$32A3,$338E,$338F,$339C,$339D,$339E,$33A1,$33C4,$33CE,$33D1,$33D2,
$33D5,$4E00,$4E01,$4E03,$4E07,$4E08,$4E09,$4E0A,$4E0B,$4E0C,$4E0D,$4E0E,$4E0F,
$4E10,$4E11,$4E14,$4E15,$4E16,$4E18,$4E19,$4E1E,$4E1F,$4E26,$4E2B,$4E2D,$4E2E,
$4E30,$4E31,$4E32,$4E33,$4E38,$4E39,$4E3B,$4E3C,$4E42,$4E43,$4E45,$4E47,$4E48,
$4E4B,$4E4D,$4E4E,$4E4F,$4E52,$4E53,$4E56,$4E58,$4E59,$4E5C,$4E5D,$4E5E,$4E5F,
$4E69,$4E73,$4E7E,$4E7F,$4E82,$4E83,$4E84,$4E86,$4E88,$4E8B,$4E8C,$4E8D,$4E8E,
$4E91,$4E92,$4E93,$4E94,$4E95,$4E99,$4E9B,$4E9E,$4E9F,$4EA1,$4EA2,$4EA4,$4EA5,
$4EA6,$4EA8,$4EAB,$4EAC,$4EAD,$4EAE,$4EB3,$4EB6,$4EB9,$4EBA,$4EC0,$4EC1,$4EC2,
$4EC3,$4EC4,$4EC6,$4EC7,$4EC8,$4EC9,$4ECA,$4ECB,$4ECD,$4ED4,$4ED5,$4ED6,$4ED7,
$4ED8,$4ED9,$4EDA,$4EDC,$4EDD,$4EDE,$4EDF,$4EE1,$4EE3,$4EE4,$4EE5,$4EE8,$4EE9,
$4EF0,$4EF1,$4EF2,$4EF3,$4EF4,$4EF5,$4EF6,$4EF7,$4EFB,$4EFD,$4EFF,$4F00,$4F01,
$4F02,$4F04,$4F05,$4F08,$4F09,$4F0A,$4F0B,$4F0D,$4F0E,$4F0F,$4F10,$4F11,$4F12,
$4F13,$4F14,$4F15,$4F18,$4F19,$4F1D,$4F22,$4F2C,$4F2D,$4F2F,$4F30,$4F33,$4F34,
$4F36,$4F38,$4F3A,$4F3B,$4F3C,$4F3D,$4F3E,$4F3F,$4F41,$4F43,$4F46,$4F47,$4F48,
$4F49,$4F4C,$4F4D,$4F4E,$4F4F,$4F50,$4F51,$4F52,$4F53,$4F54,$4F55,$4F56,$4F57,
$4F58,$4F59,$4F5A,$4F5B,$4F5C,$4F5D,$4F5E,$4F5F,$4F60,$4F61,$4F62,$4F63,$4F64,
$4F67,$4F69,$4F6A,$4F6B,$4F6C,$4F6E,$4F6F,$4F70,$4F73,$4F74,$4F75,$4F76,$4F77,
$4F78,$4F79,$4F7A,$4F7B,$4F7C,$4F7D,$4F7E,$4F7F,$4F80,$4F81,$4F82,$4F83,$4F84,
$4F85,$4F86,$4F87,$4F88,$4F89,$4F8B,$4F8D,$4F8F,$4F90,$4F91,$4F92,$4F94,$4F95,
$4F96,$4F97,$4F98,$4F9A,$4F9B,$4F9C,$4F9D,$4F9E,$4FAE,$4FAF,$4FB2,$4FB3,$4FB5,
$4FB6,$4FB7,$4FB9,$4FBA,$4FBB,$4FBF,$4FC0,$4FC1,$4FC2,$4FC3,$4FC4,$4FC5,$4FC7,
$4FC9,$4FCA,$4FCB,$4FCD,$4FCE,$4FCF,$4FD0,$4FD1,$4FD3,$4FD4,$4FD6,$4FD7,$4FD8,
$4FD9,$4FDA,$4FDB,$4FDC,$4FDD,$4FDE,$4FDF,$4FE0,$4FE1,$4FEC,$4FEE,$4FEF,$4FF1,
$4FF3,$4FF4,$4FF5,$4FF6,$4FF7,$4FF8,$4FFA,$4FFE,$5000,$5005,$5006,$5007,$5009,
$500B,$500C,$500D,$500E,$500F,$5011,$5012,$5013,$5014,$5015,$5016,$5017,$5018,
$5019,$501A,$501B,$501C,$501E,$501F,$5020,$5021,$5022,$5023,$5025,$5026,$5027,
$5028,$5029,$502A,$502B,$502C,$502D,$502F,$5030,$5031,$5033,$5035,$5037,$503C,
$5040,$5041,$5043,$5045,$5046,$5047,$5048,$5049,$504A,$504B,$504C,$504D,$504E,
$504F,$5051,$5053,$5055,$5057,$505A,$505B,$505C,$505D,$505E,$505F,$5060,$5061,
$5062,$5063,$5064,$5065,$5068,$5069,$506A,$506B,$506D,$506E,$506F,$5070,$5072,
$5073,$5074,$5075,$5076,$5077,$507A,$507D,$5080,$5082,$5083,$5085,$5087,$508B,
$508C,$508D,$508E,$5091,$5092,$5094,$5095,$5096,$5098,$5099,$509A,$509B,$509C,
$509D,$509E,$50A2,$50A3,$50AC,$50AD,$50AE,$50AF,$50B0,$50B1,$50B2,$50B3,$50B4,
$50B5,$50B6,$50B7,$50B8,$50BA,$50BB,$50BD,$50BE,$50BF,$50C1,$50C2,$50C4,$50C5,
$50C6,$50C7,$50C8,$50C9,$50CA,$50CB,$50CE,$50CF,$50D1,$50D3,$50D4,$50D5,$50D6,
$50D7,$50DA,$50DB,$50DD,$50E0,$50E3,$50E4,$50E5,$50E6,$50E7,$50E8,$50E9,$50EA,
$50EC,$50ED,$50EE,$50EF,$50F0,$50F1,$50F3,$50F5,$50F6,$50F8,$50F9,$50FB,$50FD,
$50FE,$50FF,$5100,$5102,$5103,$5104,$5105,$5106,$5107,$5108,$5109,$510A,$510B,
$510C,$5110,$5111,$5112,$5113,$5114,$5115,$5117,$5118,$511A,$511C,$511F,$5120,
$5121,$5122,$5124,$5125,$5126,$5129,$512A,$512D,$512E,$5130,$5131,$5132,$5133,
$5134,$5135,$5137,$5138,$5139,$513A,$513B,$513C,$513D,$513F,$5140,$5141,$5143,
$5144,$5145,$5146,$5147,$5148,$5149,$514B,$514C,$514D,$5152,$5154,$5155,$5157,
$5159,$515A,$515B,$515C,$515D,$515E,$515F,$5161,$5162,$5163,$5165,$5167,$5168,
$5169,$516B,$516C,$516D,$516E,$5171,$5175,$5176,$5177,$5178,$517C,$5180,$5187,
$5189,$518A,$518D,$518F,$5191,$5192,$5193,$5194,$5195,$5197,$5198,$519E,$51A0,
$51A2,$51A4,$51A5,$51AA,$51AC,$51B0,$51B1,$51B6,$51B7,$51B9,$51BC,$51BD,$51BE,
$51C4,$51C5,$51C6,$51C8,$51CA,$51CB,$51CC,$51CD,$51CE,$51D0,$51D4,$51D7,$51D8,
$51DC,$51DD,$51DE,$51E0,$51E1,$51F0,$51F1,$51F3,$51F5,$51F6,$51F8,$51F9,$51FA,
$51FD,$5200,$5201,$5203,$5206,$5207,$5208,$5209,$520A,$520C,$520E,$5210,$5211,
$5212,$5213,$5216,$5217,$521C,$521D,$521E,$5221,$5224,$5225,$5228,$5229,$522A,
$522E,$5230,$5231,$5232,$5233,$5235,$5236,$5237,$5238,$523A,$523B,$5241,$5243,
$5244,$5246,$5247,$5249,$524A,$524B,$524C,$524D,$524E,$5252,$5254,$5255,$5256,
$525A,$525B,$525C,$525D,$525E,$525F,$5261,$5262,$5269,$526A,$526B,$526C,$526D,
$526E,$526F,$5272,$5274,$5275,$5277,$5278,$527A,$527B,$527C,$527D,$527F,$5280,
$5281,$5282,$5283,$5284,$5287,$5288,$5289,$528A,$528B,$528C,$528D,$5291,$5293,
$5296,$5297,$5298,$5299,$529B,$529F,$52A0,$52A3,$52A6,$52A9,$52AA,$52AB,$52AC,
$52AD,$52AE,$52BB,$52BC,$52BE,$52C0,$52C1,$52C2,$52C3,$52C7,$52C9,$52CD,$52D2,
$52D3,$52D5,$52D6,$52D7,$52D8,$52D9,$52DB,$52DD,$52DE,$52DF,$52E2,$52E3,$52E4,
$52E6,$52E9,$52EB,$52EF,$52F0,$52F1,$52F3,$52F4,$52F5,$52F7,$52F8,$52FA,$52FB,
$52FC,$52FE,$52FF,$5305,$5306,$5308,$5309,$530A,$530B,$530D,$530E,$530F,$5310,
$5311,$5312,$5315,$5316,$5317,$5319,$531A,$531C,$531D,$531F,$5320,$5321,$5322,
$5323,$532A,$532D,$532F,$5330,$5331,$5334,$5337,$5339,$533C,$533D,$533E,$533F,
$5340,$5341,$5341,$5343,$5344,$5345,$5345,$5347,$5348,$5349,$534A,$534C,$534D,
$5351,$5352,$5353,$5354,$5357,$535A,$535C,$535E,$5360,$5361,$5363,$5366,$536C,
$536E,$536F,$5370,$5371,$5372,$5373,$5375,$5377,$5378,$5379,$537B,$537C,$537F,
$5382,$5384,$538A,$538E,$538F,$5392,$5394,$5396,$5397,$5398,$5399,$539A,$539C,
$539D,$539E,$539F,$53A4,$53A5,$53A7,$53AC,$53AD,$53B2,$53B4,$53B9,$53BB,$53C3,
$53C8,$53C9,$53CA,$53CB,$53CD,$53D4,$53D6,$53D7,$53DB,$53DF,$53E1,$53E2,$53E3,
$53E4,$53E5,$53E6,$53E8,$53E9,$53EA,$53EB,$53EC,$53ED,$53EE,$53EF,$53F0,$53F1,
$53F2,$53F3,$53F5,$53F8,$53FB,$53FC,$5401,$5403,$5404,$5406,$5407,$5408,$5409,
$540A,$540B,$540C,$540D,$540E,$540F,$5410,$5411,$5412,$5418,$5419,$541B,$541C,
$541D,$541E,$541F,$5420,$5424,$5425,$5426,$5427,$5428,$5429,$542A,$542B,$542C,
$542D,$542E,$5430,$5431,$5433,$5435,$5436,$5437,$5438,$5439,$543B,$543C,$543D,
$543E,$5440,$5441,$5442,$5443,$5445,$5446,$5447,$5448,$544A,$544E,$544F,$5454,
$5460,$5461,$5462,$5463,$5464,$5465,$5466,$5467,$5468,$546B,$546C,$546F,$5470,
$5471,$5472,$5473,$5474,$5475,$5476,$5477,$5478,$547A,$547B,$547C,$547D,$547E,
$547F,$5480,$5481,$5482,$5484,$5486,$5487,$5488,$548B,$548C,$548D,$548E,$5490,
$5491,$5492,$5495,$5496,$5498,$549A,$54A0,$54A1,$54A2,$54A5,$54A6,$54A7,$54A8,
$54A9,$54AA,$54AB,$54AC,$54AD,$54AE,$54AF,$54B0,$54B1,$54B3,$54B6,$54B7,$54B8,
$54BA,$54BB,$54BC,$54BD,$54BE,$54BF,$54C0,$54C1,$54C2,$54C3,$54C4,$54C5,$54C6,
$54C7,$54C8,$54C9,$54CE,$54CF,$54D6,$54DE,$54E0,$54E1,$54E2,$54E4,$54E5,$54E6,
$54E7,$54E8,$54E9,$54EA,$54EB,$54ED,$54EE,$54F1,$54F2,$54F3,$54F7,$54F8,$54FA,
$54FB,$54FC,$54FD,$54FF,$5501,$5503,$5504,$5505,$5506,$5507,$5508,$5509,$550A,
$550B,$550C,$550E,$550F,$5510,$5511,$5512,$5514,$5517,$551A,$5526,$5527,$552A,
$552C,$552D,$552E,$552F,$5530,$5531,$5532,$5533,$5534,$5535,$5536,$5537,$5538,
$5539,$553B,$553C,$553E,$5540,$5541,$5543,$5544,$5545,$5546,$5548,$554A,$554B,
$554D,$554E,$554F,$5550,$5551,$5552,$5555,$5556,$5557,$555C,$555E,$555F,$5561,
$5562,$5563,$5564,$5565,$5566,$556A,$5575,$5576,$5577,$557B,$557C,$557D,$557E,
$557F,$5580,$5581,$5582,$5583,$5584,$5587,$5588,$5589,$558A,$558B,$558C,$558D,
$558E,$558F,$5591,$5592,$5593,$5594,$5595,$5598,$5599,$559A,$559C,$559D,$559F,
$55A1,$55A2,$55A3,$55A4,$55A5,$55A6,$55A7,$55A8,$55AA,$55AB,$55AC,$55AD,$55AE,
$55B1,$55B2,$55B3,$55B5,$55BB,$55BF,$55C0,$55C2,$55C3,$55C4,$55C5,$55C6,$55C7,
$55C8,$55C9,$55CA,$55CB,$55CC,$55CD,$55CE,$55CF,$55D0,$55D1,$55D2,$55D3,$55D4,
$55D5,$55D6,$55D9,$55DA,$55DB,$55DC,$55DD,$55DF,$55E1,$55E2,$55E3,$55E4,$55E5,
$55E6,$55E7,$55E8,$55E9,$55EF,$55F2,$55F6,$55F7,$55F9,$55FA,$55FC,$55FD,$55FE,
$55FF,$5600,$5601,$5602,$5604,$5606,$5608,$5609,$560C,$560D,$560E,$560F,$5610,
$5612,$5613,$5614,$5615,$5616,$5617,$561B,$561C,$561D,$561F,$5627,$5629,$562A,
$562C,$562E,$562F,$5630,$5632,$5633,$5634,$5635,$5636,$5638,$5639,$563A,$563B,
$563D,$563E,$563F,$5640,$5641,$5642,$5645,$5646,$5648,$5649,$564A,$564C,$564E,
$5653,$5657,$5658,$5659,$565A,$565E,$5660,$5662,$5663,$5664,$5665,$5666,$5668,
$5669,$566A,$566B,$566C,$566D,$566E,$566F,$5670,$5671,$5672,$5673,$5674,$5676,
$5677,$5678,$5679,$567E,$567F,$5680,$5681,$5682,$5683,$5684,$5685,$5686,$5687,
$568C,$568D,$568E,$568F,$5690,$5693,$5695,$5697,$5698,$5699,$569A,$569C,$569D,
$56A5,$56A6,$56A7,$56A8,$56AA,$56AB,$56AC,$56AD,$56AE,$56B2,$56B3,$56B4,$56B5,
$56B6,$56B7,$56BC,$56BD,$56BE,$56C0,$56C1,$56C2,$56C3,$56C5,$56C6,$56C8,$56C9,
$56CA,$56CB,$56CC,$56CD,$56D1,$56D3,$56D4,$56D7,$56DA,$56DB,$56DD,$56DE,$56DF,
$56E0,$56E1,$56E4,$56E5,$56E7,$56EA,$56EB,$56EE,$56F0,$56F7,$56F9,$56FA,$56FF,
$5701,$5702,$5703,$5704,$5707,$5708,$5709,$570A,$570B,$570C,$570D,$5712,$5713,
$5714,$5716,$5718,$571A,$571B,$571C,$571E,$571F,$5720,$5722,$5723,$5728,$5729,
$572A,$572C,$572D,$572E,$572F,$5730,$5733,$5734,$573B,$573E,$5740,$5741,$5745,
$5747,$5749,$574A,$574B,$574C,$574D,$574E,$574F,$5750,$5751,$5752,$5761,$5762,
$5764,$5766,$5768,$5769,$576A,$576B,$576D,$576F,$5770,$5771,$5772,$5773,$5774,
$5775,$5776,$5777,$577B,$577C,$577D,$5780,$5782,$5783,$578B,$578C,$578F,$5793,
$5794,$5795,$5797,$5798,$5799,$579A,$579B,$579D,$579E,$579F,$57A0,$57A2,$57A3,
$57A4,$57A5,$57AE,$57B5,$57B6,$57B8,$57B9,$57BA,$57BC,$57BD,$57BF,$57C1,$57C2,
$57C3,$57C6,$57C7,$57CB,$57CC,$57CE,$57CF,$57D0,$57D2,$57D4,$57D5,$57DC,$57DF,
$57E0,$57E1,$57E2,$57E3,$57E4,$57E5,$57E7,$57E9,$57EC,$57ED,$57EE,$57F0,$57F1,
$57F2,$57F3,$57F4,$57F5,$57F6,$57F7,$57F8,$57F9,$57FA,$57FB,$57FC,$57FD,$5800,
$5801,$5802,$5804,$5805,$5806,$5807,$5808,$5809,$580A,$580B,$580C,$580D,$580E,
$5810,$5814,$5819,$581B,$581C,$581D,$581E,$5820,$5821,$5823,$5824,$5825,$5827,
$5828,$5829,$582A,$582C,$582D,$582E,$582F,$5830,$5831,$5832,$5833,$5834,$5835,
$5836,$5837,$5838,$5839,$583B,$583D,$583F,$5848,$5849,$584A,$584B,$584C,$584D,
$584E,$584F,$5851,$5852,$5853,$5854,$5855,$5857,$5858,$5859,$585A,$585B,$585D,
$585E,$5862,$5863,$5864,$5865,$5868,$586B,$586D,$586F,$5871,$5874,$5875,$5876,
$5879,$587A,$587B,$587C,$587D,$587E,$587F,$5880,$5881,$5882,$5883,$5885,$5886,
$5887,$5888,$5889,$588A,$588B,$588E,$588F,$5890,$5891,$5893,$5894,$5898,$589C,
$589D,$589E,$589F,$58A0,$58A1,$58A3,$58A5,$58A6,$58A8,$58A9,$58AB,$58AC,$58AE,
$58AF,$58B1,$58B3,$58BA,$58BB,$58BC,$58BD,$58BE,$58BF,$58C1,$58C2,$58C5,$58C6,
$58C7,$58C8,$58C9,$58CE,$58CF,$58D1,$58D2,$58D3,$58D4,$58D5,$58D6,$58D8,$58D9,
$58DA,$58DB,$58DD,$58DE,$58DF,$58E2,$58E3,$58E4,$58E7,$58E8,$58E9,$58EB,$58EC,
$58EF,$58F4,$58F9,$58FA,$58FC,$58FD,$58FE,$58FF,$5903,$5906,$590C,$590D,$590E,
$590F,$5912,$5914,$5915,$5916,$5917,$5919,$591A,$591C,$5920,$5922,$5924,$5925,
$5927,$5929,$592A,$592B,$592C,$592D,$592E,$592F,$5931,$5937,$5938,$593C,$593E,
$5940,$5944,$5945,$5947,$5948,$5949,$594A,$594E,$594F,$5950,$5951,$5953,$5954,
$5955,$5957,$5958,$595A,$595C,$5960,$5961,$5962,$5967,$5969,$596A,$596B,$596D,
$596E,$5970,$5971,$5972,$5973,$5974,$5976,$5977,$5978,$5979,$597B,$597C,$597D,
$597E,$597F,$5980,$5981,$5982,$5983,$5984,$5985,$598A,$598D,$598E,$598F,$5990,
$5992,$5993,$5996,$5997,$5998,$5999,$599D,$599E,$59A0,$59A1,$59A2,$59A3,$59A4,
$59A5,$59A6,$59A7,$59A8,$59AE,$59AF,$59B1,$59B2,$59B3,$59B4,$59B5,$59B6,$59B9,
$59BA,$59BB,$59BC,$59BD,$59BE,$59C0,$59C1,$59C3,$59C5,$59C6,$59C7,$59C8,$59CA,
$59CB,$59CC,$59CD,$59CE,$59CF,$59D0,$59D1,$59D2,$59D3,$59D4,$59D6,$59D8,$59DA,
$59DB,$59DC,$59DD,$59DE,$59E0,$59E1,$59E3,$59E4,$59E5,$59E6,$59E8,$59E9,$59EA,
$59EC,$59ED,$59EE,$59F1,$59F2,$59F3,$59F4,$59F5,$59F6,$59F7,$59FA,$59FB,$59FC,
$59FD,$59FE,$59FF,$5A00,$5A01,$5A03,$5A09,$5A0A,$5A0C,$5A0F,$5A11,$5A13,$5A15,
$5A16,$5A17,$5A18,$5A19,$5A1B,$5A1C,$5A1E,$5A1F,$5A20,$5A23,$5A25,$5A29,$5A2D,
$5A2E,$5A33,$5A35,$5A36,$5A37,$5A38,$5A39,$5A3C,$5A3E,$5A40,$5A41,$5A42,$5A43,
$5A44,$5A46,$5A47,$5A48,$5A49,$5A4A,$5A4C,$5A4D,$5A50,$5A51,$5A52,$5A53,$5A55,
$5A56,$5A57,$5A58,$5A5A,$5A5B,$5A5C,$5A5D,$5A5E,$5A5F,$5A60,$5A62,$5A64,$5A65,
$5A66,$5A67,$5A69,$5A6A,$5A6C,$5A6D,$5A70,$5A77,$5A78,$5A7A,$5A7B,$5A7C,$5A7D,
$5A7F,$5A83,$5A84,$5A8A,$5A8B,$5A8C,$5A8E,$5A8F,$5A90,$5A92,$5A93,$5A94,$5A95,
$5A97,$5A9A,$5A9B,$5A9C,$5A9D,$5A9E,$5A9F,$5AA2,$5AA5,$5AA6,$5AA7,$5AA9,$5AAC,
$5AAE,$5AAF,$5AB0,$5AB1,$5AB2,$5AB3,$5AB4,$5AB5,$5AB6,$5AB7,$5AB8,$5AB9,$5ABA,
$5ABB,$5ABC,$5ABD,$5ABE,$5ABF,$5AC0,$5AC1,$5AC2,$5AC4,$5AC6,$5AC7,$5AC8,$5AC9,
$5ACA,$5ACB,$5ACC,$5ACD,$5AD5,$5AD6,$5AD7,$5AD8,$5AD9,$5ADA,$5ADB,$5ADC,$5ADD,
$5ADE,$5ADF,$5AE0,$5AE1,$5AE2,$5AE3,$5AE5,$5AE6,$5AE8,$5AE9,$5AEA,$5AEB,$5AEC,
$5AED,$5AEE,$5AF3,$5AF4,$5AF5,$5AF6,$5AF7,$5AF8,$5AF9,$5AFA,$5AFB,$5AFD,$5AFF,
$5B01,$5B02,$5B03,$5B05,$5B07,$5B08,$5B09,$5B0B,$5B0C,$5B0F,$5B10,$5B13,$5B14,
$5B16,$5B17,$5B19,$5B1A,$5B1B,$5B1D,$5B1E,$5B20,$5B21,$5B23,$5B24,$5B25,$5B26,
$5B27,$5B28,$5B2A,$5B2C,$5B2D,$5B2E,$5B2F,$5B30,$5B32,$5B34,$5B38,$5B3C,$5B3D,
$5B3E,$5B3F,$5B40,$5B43,$5B45,$5B47,$5B48,$5B4B,$5B4C,$5B4D,$5B4E,$5B50,$5B51,
$5B53,$5B54,$5B55,$5B56,$5B57,$5B58,$5B5A,$5B5B,$5B5C,$5B5D,$5B5F,$5B62,$5B63,
$5B64,$5B65,$5B69,$5B6B,$5B6C,$5B6E,$5B70,$5B71,$5B72,$5B73,$5B75,$5B77,$5B78,
$5B7A,$5B7B,$5B7D,$5B7F,$5B81,$5B83,$5B84,$5B85,$5B87,$5B88,$5B89,$5B8B,$5B8C,
$5B8E,$5B8F,$5B92,$5B93,$5B95,$5B97,$5B98,$5B99,$5B9A,$5B9B,$5B9C,$5BA2,$5BA3,
$5BA4,$5BA5,$5BA6,$5BA7,$5BA8,$5BAC,$5BAD,$5BAE,$5BB0,$5BB3,$5BB4,$5BB5,$5BB6,
$5BB8,$5BB9,$5BBF,$5BC0,$5BC1,$5BC2,$5BC4,$5BC5,$5BC6,$5BC7,$5BCA,$5BCB,$5BCC,
$5BCD,$5BCE,$5BD0,$5BD1,$5BD2,$5BD3,$5BD4,$5BD6,$5BD8,$5BD9,$5BDE,$5BDF,$5BE0,
$5BE1,$5BE2,$5BE3,$5BE4,$5BE5,$5BE6,$5BE7,$5BE8,$5BE9,$5BEA,$5BEB,$5BEC,$5BEE,
$5BEF,$5BF0,$5BF1,$5BF2,$5BF5,$5BF6,$5BF8,$5BFA,$5C01,$5C03,$5C04,$5C07,$5C08,
$5C09,$5C0A,$5C0B,$5C0C,$5C0D,$5C0E,$5C0F,$5C10,$5C11,$5C12,$5C15,$5C16,$5C1A,
$5C1F,$5C22,$5C24,$5C25,$5C28,$5C2A,$5C2C,$5C30,$5C31,$5C33,$5C37,$5C38,$5C39,
$5C3A,$5C3B,$5C3C,$5C3E,$5C3F,$5C40,$5C41,$5C44,$5C45,$5C46,$5C47,$5C48,$5C4B,
$5C4C,$5C4D,$5C4E,$5C4F,$5C50,$5C51,$5C54,$5C55,$5C56,$5C58,$5C59,$5C5C,$5C5D,
$5C60,$5C62,$5C63,$5C64,$5C65,$5C67,$5C68,$5C69,$5C6A,$5C6C,$5C6D,$5C6E,$5C6F,
$5C71,$5C73,$5C74,$5C79,$5C7A,$5C7B,$5C7C,$5C7E,$5C86,$5C88,$5C89,$5C8A,$5C8B,
$5C8C,$5C8D,$5C8F,$5C90,$5C91,$5C92,$5C93,$5C94,$5C95,$5C9D,$5C9F,$5CA0,$5CA1,
$5CA2,$5CA3,$5CA4,$5CA5,$5CA6,$5CA7,$5CA8,$5CA9,$5CAA,$5CAB,$5CAC,$5CAD,$5CAE,
$5CAF,$5CB0,$5CB1,$5CB3,$5CB5,$5CB6,$5CB7,$5CB8,$5CC6,$5CC7,$5CC8,$5CC9,$5CCA,
$5CCB,$5CCC,$5CCE,$5CCF,$5CD0,$5CD2,$5CD3,$5CD4,$5CD6,$5CD7,$5CD8,$5CD9,$5CDA,
$5CDB,$5CDE,$5CDF,$5CE8,$5CEA,$5CEC,$5CED,$5CEE,$5CF0,$5CF1,$5CF4,$5CF6,$5CF7,
$5CF8,$5CF9,$5CFB,$5CFD,$5CFF,$5D00,$5D01,$5D06,$5D07,$5D0B,$5D0C,$5D0D,$5D0E,
$5D0F,$5D11,$5D12,$5D14,$5D16,$5D17,$5D19,$5D1A,$5D1B,$5D1D,$5D1E,$5D1F,$5D20,
$5D22,$5D23,$5D24,$5D25,$5D26,$5D27,$5D28,$5D29,$5D2E,$5D30,$5D31,$5D32,$5D33,
$5D34,$5D35,$5D36,$5D37,$5D38,$5D39,$5D3A,$5D3C,$5D3D,$5D3F,$5D40,$5D41,$5D42,
$5D43,$5D45,$5D47,$5D49,$5D4A,$5D4B,$5D4C,$5D4E,$5D50,$5D51,$5D52,$5D55,$5D59,
$5D5E,$5D62,$5D63,$5D65,$5D67,$5D68,$5D69,$5D6B,$5D6C,$5D6F,$5D71,$5D72,$5D77,
$5D79,$5D7A,$5D7C,$5D7D,$5D7E,$5D7F,$5D80,$5D81,$5D82,$5D84,$5D86,$5D87,$5D88,
$5D89,$5D8A,$5D8D,$5D92,$5D93,$5D94,$5D95,$5D97,$5D99,$5D9A,$5D9C,$5D9D,$5D9E,
$5D9F,$5DA0,$5DA1,$5DA2,$5DA7,$5DA8,$5DA9,$5DAA,$5DAC,$5DAD,$5DAE,$5DAF,$5DB0,
$5DB1,$5DB2,$5DB4,$5DB5,$5DB7,$5DB8,$5DBA,$5DBC,$5DBD,$5DC0,$5DC2,$5DC3,$5DC6,
$5DC7,$5DC9,$5DCB,$5DCD,$5DCF,$5DD1,$5DD2,$5DD4,$5DD5,$5DD6,$5DD8,$5DDD,$5DDE,
$5DDF,$5DE0,$5DE1,$5DE2,$5DE5,$5DE6,$5DE7,$5DE8,$5DEB,$5DEE,$5DF0,$5DF1,$5DF2,
$5DF3,$5DF4,$5DF7,$5DF9,$5DFD,$5DFE,$5DFF,$5E02,$5E03,$5E04,$5E06,$5E0A,$5E0C,
$5E0E,$5E11,$5E14,$5E15,$5E16,$5E17,$5E18,$5E19,$5E1A,$5E1B,$5E1D,$5E1F,$5E20,
$5E21,$5E22,$5E23,$5E24,$5E25,$5E28,$5E29,$5E2B,$5E2D,$5E33,$5E34,$5E36,$5E37,
$5E38,$5E3D,$5E3E,$5E40,$5E41,$5E43,$5E44,$5E45,$5E4A,$5E4B,$5E4C,$5E4D,$5E4E,
$5E4F,$5E53,$5E54,$5E55,$5E57,$5E58,$5E59,$5E5B,$5E5C,$5E5D,$5E5F,$5E60,$5E61,
$5E62,$5E63,$5E66,$5E67,$5E68,$5E69,$5E6A,$5E6B,$5E6C,$5E6D,$5E6E,$5E6F,$5E70,
$5E72,$5E73,$5E74,$5E75,$5E76,$5E78,$5E79,$5E7B,$5E7C,$5E7D,$5E7E,$5E80,$5E82,
$5E84,$5E87,$5E88,$5E89,$5E8A,$5E8B,$5E8C,$5E8D,$5E8F,$5E95,$5E96,$5E97,$5E9A,
$5E9B,$5E9C,$5EA0,$5EA2,$5EA3,$5EA4,$5EA5,$5EA6,$5EA7,$5EA8,$5EAA,$5EAB,$5EAC,
$5EAD,$5EAE,$5EB0,$5EB1,$5EB2,$5EB3,$5EB4,$5EB5,$5EB6,$5EB7,$5EB8,$5EB9,$5EBE,
$5EC1,$5EC2,$5EC4,$5EC5,$5EC6,$5EC7,$5EC8,$5EC9,$5ECA,$5ECB,$5ECC,$5ECE,$5ED1,
$5ED2,$5ED3,$5ED4,$5ED5,$5ED6,$5ED7,$5ED8,$5ED9,$5EDA,$5EDB,$5EDC,$5EDD,$5EDE,
$5EDF,$5EE0,$5EE1,$5EE2,$5EE3,$5EE5,$5EE6,$5EE7,$5EE8,$5EE9,$5EEC,$5EEE,$5EEF,
$5EF1,$5EF2,$5EF3,$5EF6,$5EF7,$5EFA,$5EFE,$5EFF,$5F01,$5F02,$5F04,$5F05,$5F07,
$5F08,$5F0A,$5F0B,$5F0F,$5F12,$5F13,$5F14,$5F15,$5F17,$5F18,$5F1A,$5F1B,$5F1D,
$5F1F,$5F22,$5F23,$5F24,$5F26,$5F27,$5F28,$5F29,$5F2D,$5F2E,$5F30,$5F31,$5F33,
$5F35,$5F36,$5F37,$5F38,$5F3C,$5F40,$5F43,$5F44,$5F46,$5F48,$5F49,$5F4A,$5F4B,
$5F4C,$5F4E,$5F4F,$5F54,$5F56,$5F57,$5F58,$5F59,$5F5D,$5F62,$5F64,$5F65,$5F67,
$5F69,$5F6A,$5F6B,$5F6C,$5F6D,$5F6F,$5F70,$5F71,$5F73,$5F74,$5F76,$5F77,$5F78,
$5F79,$5F7C,$5F7D,$5F7E,$5F7F,$5F80,$5F81,$5F82,$5F85,$5F86,$5F87,$5F88,$5F89,
$5F8A,$5F8B,$5F8C,$5F90,$5F91,$5F92,$5F96,$5F97,$5F98,$5F99,$5F9B,$5F9C,$5F9E,
$5F9F,$5FA0,$5FA1,$5FA5,$5FA6,$5FA8,$5FA9,$5FAA,$5FAB,$5FAC,$5FAD,$5FAE,$5FAF,
$5FB2,$5FB5,$5FB6,$5FB7,$5FB9,$5FBB,$5FBC,$5FBD,$5FBE,$5FBF,$5FC0,$5FC1,$5FC3,
$5FC5,$5FC9,$5FCC,$5FCD,$5FCF,$5FD0,$5FD1,$5FD2,$5FD4,$5FD5,$5FD6,$5FD7,$5FD8,
$5FD9,$5FDD,$5FDE,$5FE0,$5FE1,$5FE3,$5FE4,$5FE5,$5FE8,$5FEA,$5FEB,$5FED,$5FEE,
$5FEF,$5FF1,$5FF3,$5FF4,$5FF5,$5FF7,$5FF8,$5FFA,$5FFB,$5FFD,$5FFF,$6000,$6009,
$600A,$600B,$600C,$600D,$600E,$600F,$6010,$6011,$6012,$6013,$6014,$6015,$6016,
$6017,$6019,$601A,$601B,$601C,$601D,$601E,$6020,$6021,$6022,$6024,$6025,$6026,
$6027,$6028,$6029,$602A,$602B,$602C,$602D,$602E,$602F,$6032,$6033,$6034,$6035,
$6037,$6039,$6040,$6041,$6042,$6043,$6044,$6045,$6046,$6047,$6049,$604C,$604D,
$6050,$6052,$6053,$6054,$6055,$6058,$6059,$605A,$605B,$605D,$605E,$605F,$6062,
$6063,$6064,$6065,$6066,$6067,$6068,$6069,$606A,$606B,$606C,$606D,$606E,$606F,
$6070,$6072,$607F,$6080,$6081,$6083,$6084,$6085,$6086,$6087,$6088,$6089,$608A,
$608C,$608D,$608E,$6090,$6092,$6094,$6095,$6096,$6097,$609A,$609B,$609C,$609D,
$609F,$60A0,$60A2,$60A3,$60A8,$60B0,$60B1,$60B2,$60B4,$60B5,$60B6,$60B7,$60B8,
$60B9,$60BA,$60BB,$60BC,$60BD,$60BE,$60BF,$60C0,$60C1,$60C3,$60C4,$60C5,$60C6,
$60C7,$60C8,$60C9,$60CA,$60CB,$60CC,$60CD,$60CE,$60CF,$60D1,$60D3,$60D4,$60D5,
$60D8,$60D9,$60DA,$60DB,$60DC,$60DD,$60DF,$60E0,$60E1,$60E2,$60E4,$60E6,$60F0,
$60F1,$60F2,$60F3,$60F4,$60F5,$60F6,$60F7,$60F8,$60F9,$60FA,$60FB,$60FC,$60FE,
$60FF,$6100,$6101,$6103,$6104,$6105,$6106,$6108,$6109,$610A,$610B,$610D,$610E,
$610F,$6110,$6112,$6113,$6114,$6115,$6116,$6118,$611A,$611B,$611C,$611D,$611F,
$6123,$6127,$6128,$6129,$612B,$612C,$612E,$612F,$6132,$6134,$6136,$6137,$613B,
$613E,$613F,$6140,$6141,$6144,$6145,$6146,$6147,$6148,$6149,$614A,$614B,$614C,
$614D,$614E,$614F,$6152,$6153,$6154,$6155,$6156,$6158,$615A,$615B,$615D,$615E,
$615F,$6161,$6162,$6163,$6165,$6166,$6167,$6168,$616A,$616B,$616C,$616E,$6170,
$6171,$6172,$6173,$6174,$6175,$6176,$6177,$6179,$617A,$617C,$617E,$6180,$6182,
$6183,$6189,$618A,$618B,$618C,$618D,$618E,$6190,$6191,$6192,$6193,$6194,$6196,
$619A,$619B,$619D,$619F,$61A1,$61A2,$61A4,$61A7,$61A8,$61A9,$61AA,$61AB,$61AC,
$61AD,$61AE,$61AF,$61B0,$61B1,$61B2,$61B3,$61B4,$61B5,$61B6,$61B8,$61BA,$61BC,
$61BE,$61BF,$61C1,$61C2,$61C3,$61C5,$61C6,$61C7,$61C8,$61C9,$61CA,$61CB,$61CC,
$61CD,$61D6,$61D8,$61DE,$61DF,$61E0,$61E3,$61E4,$61E5,$61E6,$61E7,$61E8,$61E9,
$61EA,$61EB,$61ED,$61EE,$61F0,$61F1,$61F2,$61F5,$61F6,$61F7,$61F8,$61F9,$61FA,
$61FB,$61FC,$61FD,$61FE,$61FF,$6200,$6201,$6203,$6204,$6207,$6208,$6209,$620A,
$620C,$620D,$620E,$6210,$6211,$6212,$6214,$6215,$6216,$6219,$621A,$621B,$621F,
$6220,$6221,$6222,$6223,$6224,$6225,$6227,$6229,$622A,$622B,$622D,$622E,$6230,
$6232,$6233,$6234,$6236,$623A,$623D,$623E,$623F,$6240,$6241,$6242,$6243,$6246,
$6247,$6248,$6249,$624A,$624B,$624D,$624E,$6250,$6251,$6252,$6253,$6254,$6258,
$6259,$625A,$625B,$625C,$625E,$6260,$6261,$6262,$6263,$6264,$6265,$6266,$626D,
$626E,$626F,$6270,$6271,$6272,$6273,$6274,$6276,$6277,$6279,$627A,$627B,$627C,
$627D,$627E,$627F,$6280,$6281,$6283,$6284,$6286,$6287,$6288,$6289,$628A,$628C,
$628E,$628F,$6291,$6292,$6293,$6294,$6295,$6296,$6297,$6298,$62A8,$62A9,$62AA,
$62AB,$62AC,$62AD,$62AE,$62AF,$62B0,$62B1,$62B3,$62B4,$62B5,$62B6,$62B8,$62B9,
$62BB,$62BC,$62BD,$62BE,$62BF,$62C2,$62C4,$62C6,$62C7,$62C8,$62C9,$62CA,$62CB,
$62CC,$62CD,$62CE,$62CF,$62D0,$62D1,$62D2,$62D3,$62D4,$62D6,$62D7,$62D8,$62D9,
$62DA,$62DB,$62DC,$62EB,$62EC,$62ED,$62EE,$62EF,$62F0,$62F1,$62F2,$62F3,$62F4,
$62F5,$62F6,$62F7,$62F8,$62F9,$62FA,$62FB,$62FC,$62FD,$62FE,$62FF,$6300,$6301,
$6302,$6303,$6307,$6308,$6309,$630B,$630C,$630D,$630E,$630F,$6310,$6311,$6313,
$6314,$6315,$6316,$6328,$6329,$632A,$632B,$632C,$632D,$632F,$6332,$6333,$6334,
$6336,$6338,$6339,$633A,$633B,$633C,$633D,$633E,$6340,$6341,$6342,$6343,$6344,
$6345,$6346,$6347,$6348,$6349,$634A,$634B,$634C,$634D,$634E,$634F,$6350,$6351,
$6354,$6355,$6356,$6357,$6358,$6359,$635A,$6365,$6367,$6368,$6369,$636B,$636D,
$636E,$636F,$6370,$6371,$6372,$6375,$6376,$6377,$6378,$637A,$637B,$637C,$637D,
$6380,$6381,$6382,$6383,$6384,$6385,$6387,$6388,$6389,$638A,$638C,$638D,$638E,
$638F,$6390,$6391,$6392,$6394,$6396,$6397,$6398,$6399,$639B,$639C,$639D,$639E,
$639F,$63A0,$63A1,$63A2,$63A3,$63A4,$63A5,$63A7,$63A8,$63A9,$63AA,$63AB,$63AC,
$63AD,$63AE,$63AF,$63B0,$63B1,$63BD,$63BE,$63C0,$63C2,$63C3,$63C4,$63C5,$63C6,
$63C7,$63C8,$63C9,$63CA,$63CB,$63CC,$63CD,$63CE,$63CF,$63D0,$63D2,$63D3,$63D5,
$63D6,$63D7,$63D8,$63D9,$63DA,$63DB,$63DC,$63DD,$63DF,$63E0,$63E1,$63E3,$63E4,
$63E5,$63E7,$63E8,$63E9,$63EA,$63EB,$63ED,$63EE,$63EF,$63F0,$63F1,$63F2,$63F3,
$63F4,$63F5,$63F6,$63F9,$6406,$6409,$640A,$640B,$640C,$640D,$640E,$640F,$6410,
$6412,$6413,$6414,$6415,$6416,$6417,$6418,$641A,$641B,$641C,$641E,$641F,$6420,
$6421,$6422,$6423,$6424,$6425,$6426,$6427,$6428,$642A,$642B,$642C,$642D,$642E,
$642F,$6430,$6433,$6434,$6435,$6436,$6437,$6439,$643D,$643E,$643F,$6440,$6441,
$6443,$644B,$644D,$644E,$6450,$6451,$6452,$6453,$6454,$6458,$6459,$645B,$645C,
$645D,$645E,$645F,$6460,$6461,$6465,$6466,$6467,$6468,$6469,$646B, $646C,$646D,
$646E,$646F,$6470,$6472,$6473,$6474,$6475,$6476,$6477,$6478,$6479,$647A,$647B,
$647D,$647F,$6482,$6485,$6487,$6488,$6489,$648A,$648B,$648C,$648F,$6490,$6492,
$6493,$6495,$6496,$6497,$6498,$6499,$649A,$649C,$649D,$649E,$649F,$64A0,$64A2,
$64A3,$64A4,$64A5,$64A6,$64A9,$64AB,$64AC,$64AD,$64AE,$64B0,$64B1,$64B2,$64B3,
$64BB,$64BC,$64BD,$64BE,$64BF,$64C1,$64C2,$64C3,$64C4,$64C5,$64C7,$64C9,$64CA,
$64CB,$64CD,$64CE,$64CF,$64D0,$64D2,$64D4,$64D6,$64D7,$64D8,$64D9,$64DA,$64DB,
$64E0,$64E2,$64E3,$64E4,$64E6,$64E8,$64E9,$64EB,$64EC,$64ED,$64EF,$64F0,$64F1,
$64F2,$64F3,$64F4,$64F7,$64F8,$64FA,$64FB,$64FC,$64FD,$64FE,$64FF,$6500,$6501,
$6503,$6504,$6506,$6507,$6509,$650C,$650D,$650E,$650F,$6510,$6513,$6514,$6515,
$6516,$6517,$6518,$6519,$651B,$651C,$651D,$6520,$6521,$6522,$6523,$6524,$6525,
$6526,$6529,$652A,$652B,$652C,$652D,$652E,$652F,$6532,$6533,$6536,$6537,$6538,
$6539,$653B,$653D,$653E,$653F,$6541,$6543,$6545,$6546,$6548,$6549,$654A,$654F,
$6551,$6553,$6554,$6555,$6556,$6557,$6558,$6559,$655C,$655D,$655E,$6562,$6563,
$6564,$6565,$6566,$6567,$6568,$656A,$656C,$656F,$6572,$6573,$6574,$6575,$6576,
$6577,$6578,$6579,$657A,$657B,$657C,$657F,$6580,$6581,$6582,$6583,$6584,$6587,
$658C,$6590,$6591,$6592,$6594,$6595,$6596,$6597,$6599,$659B,$659C,$659D,$659E,
$659F,$65A0,$65A1,$65A2,$65A4,$65A5,$65A7,$65A8,$65AA,$65AB,$65AC,$65AE,$65AF,
$65B0,$65B2,$65B3,$65B6,$65B7,$65B8,$65B9,$65BB,$65BC,$65BD,$65BF,$65C1,$65C2,
$65C3,$65C4,$65C5,$65C6,$65CB,$65CC,$65CD,$65CE,$65CF,$65D0,$65D2,$65D3,$65D6,
$65D7,$65DA,$65DB,$65DD,$65DE,$65DF,$65E1,$65E2,$65E5,$65E6,$65E8,$65E9,$65EC,
$65ED,$65EE,$65EF,$65F0,$65F1,$65F2,$65F3,$65F4,$65F5,$65FA,$65FB,$65FC,$65FD,
$6600,$6602,$6603,$6604,$6605,$6606,$6607,$6608,$6609,$660A,$660B,$660C,$660D,
$660E,$660F,$6610,$6611,$6612,$6613,$6614,$6615,$661C,$661D,$661F,$6620,$6621,
$6622,$6624,$6625,$6626,$6627,$6628,$662B,$662D,$662E,$662F,$6631,$6632,$6633,
$6634,$6635,$6636,$6639,$663A,$6641,$6642,$6643,$6645,$6647,$6649,$664A,$664C,
$664F,$6651,$6652,$6659,$665A,$665B,$665C,$665D,$665E,$665F,$6661,$6662,$6664,
$6665,$6666,$6668,$666A,$666C,$666E,$666F,$6670,$6671,$6672,$6674,$6676,$6677,
$6678,$6679,$667A,$667B,$667C,$667E,$6680,$6684,$6686,$6687,$6688,$6689,$668A,
$668B,$668C,$668D,$6690,$6691,$6694,$6695,$6696,$6697,$6698,$6699,$669D,$669F,
$66A0,$66A1,$66A2,$66A8,$66A9,$66AA,$66AB,$66AE,$66AF,$66B0,$66B1,$66B2,$66B4,
$66B5,$66B7,$66B8,$66B9,$66BA,$66BB,$66BD,$66BE,$66C0,$66C4,$66C6,$66C7,$66C8,
$66C9,$66CA,$66CB,$66CC,$66CF,$66D2,$66D6,$66D8,$66D9,$66DA,$66DB,$66DC,$66DD,
$66DE,$66E0,$66E3,$66E4,$66E6,$66E8,$66E9,$66EB,$66EC,$66ED,$66EE,$66F0,$66F2,
$66F3,$66F4,$66F6,$66F7,$66F8,$66F9,$66FC,$66FE,$66FF,$6700,$6701,$6703,$6704,
$6705,$6708,$6709,$670A,$670B,$670D,$670F,$6710,$6712,$6713,$6714,$6715,$6717,
$6718,$671B,$671D,$671F,$6720,$6721,$6722,$6723,$6726,$6727,$6728,$672A,$672B,
$672C,$672D,$672E,$6731,$6733,$6734,$6735,$6738,$6739,$673A,$673B,$673C,$673D,
$673E,$673F,$6745,$6746,$6747,$6748,$6749,$674B,$674C,$674D,$674E,$674F,$6750,
$6751,$6753,$6755,$6756,$6757,$6759,$675A,$675C,$675D,$675E,$675F,$6760,$676A,
$676C,$676D,$676F,$6770,$6771,$6772,$6773,$6774,$6775,$6776,$6777,$6778,$6779,
$677A,$677B,$677C,$677D,$677E,$677F,$6781,$6783,$6784,$6785,$6786,$6787,$6789,
$678B,$678C,$678D,$678E,$6790,$6791,$6792,$6793,$6794,$6795,$6797,$6798,$6799,
$679A,$679C,$679D,$679F,$67AE,$67AF,$67B0,$67B2,$67B3,$67B4,$67B5,$67B6,$67B7,
$67B8,$67B9,$67BA,$67BB,$67C0,$67C1,$67C2,$67C3,$67C4,$67C5,$67C6,$67C8,$67C9,
$67CA,$67CB,$67CC,$67CD,$67CE,$67CF,$67D0,$67D1,$67D2,$67D3,$67D4,$67D8,$67D9,
$67DA,$67DB,$67DC,$67DD,$67DE,$67DF,$67E2,$67E3,$67E4,$67E5,$67E6,$67E7,$67E9,
$67EA,$67EB,$67EC,$67ED,$67EE,$67EF,$67F0,$67F1,$67F2,$67F3,$67F4,$67F5,$67F6,
$67F7,$67F8,$67FA,$67FC,$67FF,$6812,$6813,$6814,$6816,$6817,$6818,$681A,$681C,
$681D,$681F,$6820,$6821,$6825,$6826,$6828,$6829,$682A,$682B,$682D,$682E,$682F,
$6831,$6832,$6833,$6834,$6835,$6838,$6839,$683A,$683B,$683C,$683D,$6840,$6841,
$6842,$6843,$6844,$6845,$6846,$6848,$6849,$684B,$684C,$684D,$684E,$684F,$6850,
$6851,$6853,$6854,$686B,$686D,$686E,$686F,$6871,$6872,$6874,$6875,$6876,$6877,
$6878,$6879,$687B,$687C,$687D,$687E,$687F,$6880,$6881,$6882,$6883,$6885,$6886,
$6887,$6889,$688A,$688B,$688C,$688F,$6890,$6891,$6892,$6893,$6894,$6896,$6897,
$689B,$689C,$689D,$689F,$68A0,$68A1,$68A2,$68A3,$68A4,$68A7,$68A8,$68A9,$68AA,
$68AB,$68AC,$68AD,$68AE,$68AF,$68B0,$68B1,$68B2,$68B3,$68B4,$68B5,$68C4,$68C6,
$68C7,$68C8,$68C9,$68CB,$68CC,$68CD,$68CE,$68D0,$68D1,$68D2,$68D3,$68D4,$68D5,
$68D6,$68D7,$68D8,$68DA,$68DC,$68DD,$68DE,$68DF,$68E0,$68E1,$68E3,$68E4,$68E6,
$68E7,$68E8,$68E9,$68EA,$68EB,$68EC,$68EE,$68EF,$68F0,$68F1,$68F2,$68F3,$68F4,
$68F5,$68F6,$68F7,$68F8,$68F9,$68FA,$68FB,$68FC,$68FD,$6904,$6905,$6906,$6907,
$6908,$690A,$690B,$690C,$690D,$690E,$690F,$6910,$6911,$6912,$6913,$6914,$6915,
$6917,$6925,$692A,$692F,$6930,$6932,$6933,$6934,$6935,$6937,$6938,$6939,$693B,
$693C,$693D,$693F,$6940,$6941,$6942,$6944,$6945,$6948,$6949,$694A,$694B,$694C,
$694E,$694F,$6951,$6952,$6953,$6954,$6956,$6957,$6958,$6959,$695A,$695B,$695C,
$695D,$695E,$695F,$6960,$6962,$6963,$6965,$6966,$6968,$6969,$696A,$696B,$696C,
$696D,$696E,$696F,$6970,$6971,$6974,$6975,$6976,$6977,$6978,$6979,$697A,$697B,
$6982,$6983,$6986,$698D,$698E,$6990,$6991,$6993,$6994,$6995,$6996,$6997,$6999,
$699A,$699B,$699C,$699E,$69A0,$69A1,$69A3,$69A4,$69A5,$69A6,$69A7,$69A8,$69A9,
$69AA,$69AB,$69AC,$69AD,$69AE,$69AF,$69B0,$69B1,$69B3,$69B4,$69B5,$69B6,$69B7,
$69B9,$69BB,$69BC,$69BD,$69BE,$69BF,$69C1,$69C2,$69C3,$69C4,$69C6,$69C9,$69CA,
$69CB,$69CC,$69CD,$69CE,$69CF,$69D0,$69D3,$69D4,$69D9,$69E2,$69E4,$69E5,$69E6,
$69E7,$69E8,$69EB,$69EC,$69ED,$69EE,$69F1,$69F2,$69F3,$69F4,$69F6,$69F7,$69F8,
$69FB,$69FC,$69FD,$69FE,$69FF,$6A00,$6A01,$6A02,$6A04,$6A05,$6A06,$6A07,$6A08,
$6A09,$6A0A,$6A0D,$6A0F,$6A11,$6A13,$6A14,$6A15,$6A16,$6A17,$6A18,$6A19,$6A1B,
$6A1D,$6A1E,$6A1F,$6A20,$6A21,$6A23,$6A25,$6A26,$6A27,$6A28,$6A32,$6A34,$6A35,
$6A38,$6A39,$6A3A,$6A3B,$6A3C,$6A3D,$6A3E,$6A3F,$6A40,$6A41,$6A44,$6A46,$6A47,
$6A48,$6A49,$6A4B,$6A4D,$6A4E,$6A4F,$6A50,$6A51,$6A54,$6A55,$6A56,$6A58,$6A59,
$6A5A,$6A5B,$6A5D,$6A5E,$6A5F,$6A60,$6A61,$6A62,$6A64,$6A66,$6A67,$6A68,$6A69,
$6A6A,$6A6B,$6A6D,$6A6F,$6A76,$6A7E,$6A7F,$6A80,$6A81,$6A83,$6A84,$6A85,$6A87,
$6A89,$6A8C,$6A8D,$6A8E,$6A90,$6A91,$6A92,$6A93,$6A94,$6A95,$6A96,$6A97,$6A9A,
$6A9B,$6A9C,$6A9E,$6A9F,$6AA0,$6AA1,$6AA2,$6AA3,$6AA4,$6AA5,$6AA6,$6AA8,$6AAC,
$6AAD,$6AAE,$6AAF,$6AB3,$6AB4,$6AB6,$6AB7,$6AB8,$6AB9,$6ABA,$6ABB,$6ABD,$6AC2,
$6AC3,$6AC5,$6AC6,$6AC7,$6ACB,$6ACC,$6ACD,$6ACF,$6AD0,$6AD1,$6AD3,$6AD9,$6ADA,
$6ADB,$6ADC,$6ADD,$6ADE,$6ADF,$6AE0,$6AE1,$6AE5,$6AE7,$6AE8,$6AEA,$6AEB,$6AEC,
$6AEE,$6AEF,$6AF0,$6AF1,$6AF3,$6AF8,$6AF9,$6AFA,$6AFB,$6AFC,$6B00,$6B02,$6B03,
$6B04,$6B08,$6B09,$6B0A,$6B0B,$6B0F,$6B10,$6B11,$6B12,$6B13,$6B16,$6B17,$6B18,
$6B19,$6B1A,$6B1E,$6B20,$6B21,$6B23,$6B25,$6B28,$6B2C,$6B2D,$6B2F,$6B31,$6B32,
$6B33,$6B34,$6B36,$6B37,$6B38,$6B39,$6B3A,$6B3B,$6B3C,$6B3D,$6B3E,$6B3F,$6B41,
$6B42,$6B43,$6B45,$6B46,$6B47,$6B48,$6B49,$6B4A,$6B4B,$6B4C,$6B4D,$6B4E,$6B50,
$6B51,$6B54,$6B55,$6B56,$6B59,$6B5B,$6B5C,$6B5E,$6B5F,$6B60,$6B61,$6B62,$6B63,
$6B64,$6B65,$6B66,$6B67,$6B6A,$6B6D,$6B72,$6B76,$6B77,$6B78,$6B79,$6B7B,$6B7E,
$6B7F,$6B80,$6B82,$6B83,$6B84,$6B86,$6B88,$6B89,$6B8A,$6B8C,$6B8D,$6B8E,$6B8F,
$6B91,$6B94,$6B95,$6B96,$6B97,$6B98,$6B99,$6B9B,$6B9E,$6B9F,$6BA0,$6BA2,$6BA3,
$6BA4,$6BA5,$6BA6,$6BA7,$6BAA,$6BAB,$6BAD,$6BAE,$6BAF,$6BB0,$6BB2,$6BB3,$6BB5,
$6BB6,$6BB7,$6BBA,$6BBC,$6BBD,$6BBF,$6BC0,$6BC3,$6BC4,$6BC5,$6BC6,$6BC7,$6BC8,
$6BC9,$6BCA,$6BCB,$6BCC,$6BCD,$6BCF,$6BD0,$6BD2,$6BD3,$6BD4,$6BD6,$6BD7,$6BD8,
$6BDA,$6BDB,$6BDE,$6BE0,$6BE2,$6BE3,$6BE4,$6BE6,$6BE7,$6BE8,$6BEB,$6BEC,$6BEF,
$6BF0,$6BF2,$6BF3,$6BF7,$6BF8,$6BF9,$6BFB,$6BFC,$6BFD,$6BFE,$6BFF,$6C00,$6C01,
$6C02,$6C03,$6C04,$6C05,$6C06,$6C08,$6C09,$6C0B,$6C0C,$6C0D,$6C0F,$6C10,$6C11,
$6C13,$6C14,$6C15,$6C16,$6C18,$6C19,$6C1A,$6C1B,$6C1D,$6C1F,$6C20,$6C21,$6C23,
$6C24,$6C25,$6C26,$6C27,$6C28,$6C2A,$6C2B,$6C2C,$6C2E,$6C2F,$6C30,$6C33,$6C34,
$6C36,$6C38,$6C3B,$6C3E,$6C3F,$6C40,$6C41,$6C42,$6C43,$6C46,$6C4A,$6C4B,$6C4C,
$6C4D,$6C4E,$6C4F,$6C50,$6C52,$6C54,$6C55,$6C57,$6C59,$6C5B,$6C5C,$6C5D,$6C5E,
$6C5F,$6C60,$6C61,$6C65,$6C66,$6C67,$6C68,$6C69,$6C6A,$6C6B,$6C6D,$6C6F,$6C70,
$6C71,$6C72,$6C73,$6C74,$6C76,$6C78,$6C7A,$6C7B,$6C7D,$6C7E,$6C80,$6C81,$6C82,
$6C83,$6C84,$6C85,$6C86,$6C87,$6C88,$6C89,$6C8A,$6C8B,$6C8C,$6C8D,$6C8E,$6C8F,
$6C90,$6C92,$6C93,$6C94,$6C95,$6C96,$6C98,$6C99,$6C9A,$6C9B,$6C9C,$6C9D,$6CAB,
$6CAC,$6CAD,$6CAE,$6CB0,$6CB1,$6CB3,$6CB4,$6CB6,$6CB7,$6CB8,$6CB9,$6CBA,$6CBB,
$6CBC,$6CBD,$6CBE,$6CBF,$6CC0,$6CC1,$6CC2,$6CC3,$6CC4,$6CC5,$6CC6,$6CC7,$6CC9,
$6CCA,$6CCC,$6CCD,$6CCF,$6CD0,$6CD1,$6CD2,$6CD3,$6CD4,$6CD5,$6CD6,$6CD7,$6CD9,
$6CDA,$6CDB,$6CDC,$6CDD,$6CDE,$6CE0,$6CE1,$6CE2,$6CE3,$6CE5,$6CE7,$6CE8,$6CE9,
$6CEB,$6CEC,$6CED,$6CEE,$6CEF,$6CF0,$6CF1,$6CF2,$6CF3,$6CF5,$6CF9,$6D00,$6D01,
$6D03,$6D04,$6D07,$6D08,$6D09,$6D0A,$6D0B,$6D0C,$6D0D,$6D0E,$6D0F,$6D10,$6D11,
$6D12,$6D16,$6D17,$6D18,$6D19,$6D1A,$6D1B,$6D1D,$6D1E,$6D1F,$6D20,$6D22,$6D25,
$6D27,$6D28,$6D29,$6D2A,$6D2B,$6D2C,$6D2D,$6D2E,$6D2F,$6D30,$6D31,$6D32,$6D33,
$6D34,$6D35,$6D36,$6D37,$6D38,$6D39,$6D3A,$6D3B,$6D3C,$6D3D,$6D3E,$6D3F,$6D40,
$6D41,$6D42,$6D58,$6D59,$6D5A,$6D5E,$6D5F,$6D60,$6D61,$6D62,$6D63,$6D64,$6D65,
$6D66,$6D67,$6D68,$6D69,$6D6A,$6D6C,$6D6D,$6D6E,$6D6F,$6D70,$6D74,$6D75,$6D76,
$6D77,$6D78,$6D79,$6D7A,$6D7B,$6D7C,$6D7D,$6D7E,$6D7F,$6D80,$6D82,$6D83,$6D84,
$6D85,$6D86,$6D87,$6D88,$6D89,$6D8A,$6D8B,$6D8C,$6D8D,$6D8E,$6D90,$6D91,$6D92,
$6D93,$6D94,$6D95,$6D97,$6D98,$6DAA,$6DAB,$6DAC,$6DAE,$6DAF,$6DB2,$6DB3,$6DB4,
$6DB5,$6DB7,$6DB8,$6DBA,$6DBB,$6DBC,$6DBD,$6DBE,$6DBF,$6DC0,$6DC2,$6DC4,$6DC5,
$6DC6,$6DC7,$6DC8,$6DC9,$6DCA,$6DCB,$6DCC,$6DCD,$6DCF,$6DD0,$6DD1,$6DD2,$6DD3,
$6DD4,$6DD5,$6DD6,$6DD7,$6DD8,$6DD9,$6DDA,$6DDB,$6DDC,$6DDD,$6DDE,$6DDF,$6DE0,
$6DE1,$6DE2,$6DE3,$6DE4,$6DE5,$6DE6,$6DE8,$6DE9,$6DEA,$6DEB,$6DEC,$6DED,$6DEE,
$6DEF,$6DF0,$6DF1,$6DF2,$6DF3,$6DF4,$6DF5,$6DF6,$6DF7,$6DF9,$6DFA,$6DFB,$6DFC,
$6DFD,$6E00,$6E03,$6E05,$6E19,$6E1A,$6E1B,$6E1C,$6E1D,$6E1F,$6E20,$6E21,$6E22,
$6E23,$6E24,$6E25,$6E26,$6E27,$6E28,$6E2B,$6E2C,$6E2D,$6E2E,$6E2F,$6E30,$6E31,
$6E32,$6E33,$6E34,$6E35,$6E36,$6E38,$6E39,$6E3A,$6E3B,$6E3C,$6E3D,$6E3E,$6E3F,
$6E40,$6E41,$6E43,$6E44,$6E45,$6E46,$6E47,$6E49,$6E4A,$6E4B,$6E4D,$6E4E,$6E51,
$6E52,$6E53,$6E54,$6E55,$6E56,$6E58,$6E5A,$6E5B,$6E5C,$6E5D,$6E5E,$6E5F,$6E60,
$6E61,$6E62,$6E63,$6E64,$6E65,$6E66,$6E67,$6E68,$6E69,$6E6B,$6E6E,$6E6F,$6E71,
$6E72,$6E73,$6E74,$6E77,$6E78,$6E79,$6E88,$6E89,$6E8D,$6E8E,$6E8F,$6E90,$6E92,
$6E93,$6E94,$6E96,$6E97,$6E98,$6E99,$6E9B,$6E9C,$6E9D,$6E9E,$6E9F,$6EA0,$6EA1,
$6EA2,$6EA3,$6EA4,$6EA5,$6EA6,$6EA7,$6EAA,$6EAB,$6EAE,$6EAF,$6EB0,$6EB1,$6EB2,
$6EB3,$6EB4,$6EB6,$6EB7,$6EB9,$6EBA,$6EBC,$6EBD,$6EBE,$6EBF,$6EC0,$6EC1,$6EC2,
$6EC3,$6EC4,$6EC5,$6EC6,$6EC7,$6EC8,$6EC9,$6ECA,$6ECB,$6ECC,$6ECD,$6ECE,$6ECF,
$6ED0,$6ED1,$6ED2,$6ED3,$6ED4,$6ED5,$6ED6,$6ED8,$6EDC,$6EEB,$6EEC,$6EED,$6EEE,
$6EEF,$6EF1,$6EF2,$6EF4,$6EF5,$6EF6,$6EF7,$6EF8,$6EF9,$6EFB,$6EFC,$6EFD,$6EFE,
$6EFF,$6F00,$6F01,$6F02,$6F03,$6F05,$6F06,$6F07,$6F08,$6F09,$6F0A,$6F0D,$6F0E,
$6F0F,$6F12,$6F13,$6F14,$6F15,$6F18,$6F19,$6F1A,$6F1C,$6F1E,$6F1F,$6F20,$6F21,
$6F22,$6F23,$6F25,$6F26,$6F27,$6F29,$6F2A,$6F2B,$6F2C,$6F2D,$6F2E,$6F2F,$6F30,
$6F31,$6F32,$6F33,$6F35,$6F36,$6F37,$6F38,$6F39,$6F3A,$6F3B,$6F3C,$6F3E,$6F3F,
$6F40,$6F41,$6F43,$6F4E,$6F4F,$6F50,$6F51,$6F52,$6F53,$6F54,$6F55,$6F57,$6F58,
$6F5A,$6F5B,$6F5D,$6F5E,$6F5F,$6F60,$6F61,$6F62,$6F63,$6F64,$6F66,$6F67,$6F69,
$6F6A,$6F6B,$6F6C,$6F6D,$6F6E,$6F6F,$6F70,$6F72,$6F73,$6F76,$6F77,$6F78,$6F7A,
$6F7B,$6F7C,$6F7D,$6F7E,$6F7F,$6F80,$6F82,$6F84,$6F85,$6F86,$6F87,$6F88,$6F89,
$6F8B,$6F8C,$6F8D,$6F8E,$6F90,$6F92,$6F93,$6F94,$6F95,$6F96,$6F97,$6F9E,$6FA0,
$6FA1,$6FA2,$6FA3,$6FA4,$6FA5,$6FA6,$6FA7,$6FA8,$6FA9,$6FAA,$6FAB,$6FAC,$6FAD,
$6FAE,$6FAF,$6FB0,$6FB1,$6FB2,$6FB3,$6FB4,$6FB6,$6FB8,$6FB9,$6FBA,$6FBC,$6FBD,
$6FBF,$6FC0,$6FC1,$6FC2,$6FC3,$6FC4,$6FC6,$6FC7,$6FC8,$6FC9,$6FCA,$6FCB,$6FCC,
$6FCD,$6FCE,$6FCF,$6FD4,$6FD5,$6FD8,$6FDB,$6FDC,$6FDD,$6FDE,$6FDF,$6FE0,$6FE1,
$6FE2,$6FE3,$6FE4,$6FE6,$6FE7,$6FE8,$6FE9,$6FEB,$6FEC,$6FED,$6FEE,$6FEF,$6FF0,
$6FF1,$6FF2,$6FF4,$6FF7,$6FFA,$6FFB,$6FFC,$6FFE,$6FFF,$7000,$7001,$7004,$7005,
$7006,$7007,$7009,$700A,$700B,$700C,$700D,$700E,$700F,$7011,$7014,$7015,$7016,
$7017,$7018,$7019,$701A,$701B,$701C,$701D,$701F,$7020,$7021,$7022,$7023,$7024,
$7026,$7027,$7028,$7029,$702A,$702B,$702F,$7030,$7031,$7032,$7033,$7034,$7035,
$7037,$7038,$7039,$703A,$703B,$703C,$703E,$703F,$7040,$7041,$7042,$7043,$7044,
$7045,$7046,$7048,$7049,$704A,$704C,$7051,$7052,$7055,$7056,$7057,$7058,$705A,
$705B,$705D,$705E,$705F,$7060,$7061,$7062,$7063,$7064,$7065,$7066,$7068,$7069,
$706A,$706B,$7070,$7071,$7074,$7076,$7078,$707A,$707C,$707D,$7082,$7083,$7084,
$7085,$7086,$708A,$708E,$7091,$7092,$7093,$7094,$7095,$7096,$7098,$7099,$709A,
$709F,$70A1,$70A4,$70A9,$70AB,$70AC,$70AD,$70AE,$70AF,$70B0,$70B1,$70B3,$70B4,
$70B5,$70B7,$70B8,$70BA,$70BE,$70C5,$70C6,$70C7,$70C8,$70CA,$70CB,$70CD,$70CE,
$70CF,$70D1,$70D2,$70D3,$70D4,$70D7,$70D8,$70D9,$70DA,$70DC,$70DD,$70DE,$70E0,
$70E1,$70E2,$70E4,$70EF,$70F0,$70F3,$70F4,$70F6,$70F7,$70F8,$70F9,$70FA,$70FB,
$70FC,$70FD,$70FF,$7100,$7102,$7104,$7106,$7109,$710A,$710B,$710C,$710D,$710E,
$7110,$7113,$7117,$7119,$711A,$711B,$711C,$711E,$711F,$7120,$7121,$7122,$7123,
$7125,$7126,$7128,$712E,$712F,$7130,$7131,$7132,$7136,$713A,$7141,$7142,$7143,
$7144,$7146,$7147,$7149,$714B,$714C,$714D,$714E,$7150,$7152,$7153,$7154,$7156,
$7158,$7159,$715A,$715C,$715D,$715E,$715F,$7160,$7161,$7162,$7163,$7164,$7165,
$7166,$7167,$7168,$7169,$716A,$716C,$716E,$7170,$7172,$7178,$717B,$717D,$7180,
$7181,$7182,$7184,$7185,$7186,$7187,$7189,$718A,$718F,$7190,$7192,$7194,$7197,
$7199,$719A,$719B,$719C,$719D,$719E,$719F,$71A0,$71A1,$71A4,$71A5,$71A7,$71A8,
$71A9,$71AA,$71AC,$71AF,$71B0,$71B1,$71B2,$71B3,$71B5,$71B8,$71B9,$71BC,$71BD,
$71BE,$71BF,$71C0,$71C1,$71C2,$71C3,$71C4,$71C5,$71C6,$71C7,$71C8,$71C9,$71CA,
$71CB,$71CE,$71CF,$71D0,$71D2,$71D4,$71D5,$71D6,$71D8,$71D9,$71DA,$71DB,$71DC,
$71DF,$71E0,$71E1,$71E2,$71E4,$71E5,$71E6,$71E7,$71E8,$71EC,$71ED,$71EE,$71F0,
$71F1,$71F2,$71F4,$71F8,$71F9,$71FB,$71FC,$71FD,$71FE,$71FF,$7201,$7202,$7203,
$7205,$7206,$7207,$720A,$720C,$720D,$7210,$7213,$7214,$7219,$721A,$721B,$721D,
$721E,$721F,$7222,$7223,$7226,$7227,$7228,$7229,$722A,$722C,$722D,$7230,$7235,
$7236,$7238,$7239,$723A,$723B,$723D,$723E,$723F,$7241,$7242,$7244,$7246,$7247,
$7248,$7249,$724A,$724B,$724C,$724F,$7252,$7253,$7256,$7258,$7259,$725A,$725B,
$725D,$725E,$725F,$7260,$7261,$7262,$7263,$7267,$7269,$726A,$726C,$726E,$726F,
$7270,$7272,$7273,$7274,$7276,$7277,$7278,$7279,$727B,$727C,$727D,$727E,$727F,
$7280,$7281,$7284,$7285,$7286,$7288,$7289,$728B,$728C,$728D,$728E,$7290,$7291,
$7292,$7293,$7295,$7296,$7297,$7298,$729A,$729B,$729D,$729E,$72A1,$72A2,$72A3,
$72A4,$72A5,$72A6,$72A7,$72A8,$72A9,$72AA,$72AC,$72AE,$72AF,$72B0,$72B4,$72B5,
$72BA,$72BD,$72BF,$72C0,$72C1,$72C2,$72C3,$72C4,$72C5,$72C6,$72C9,$72CA,$72CB,
$72CC,$72CE,$72D0,$72D1,$72D2,$72D4,$72D6,$72D7,$72D8,$72D9,$72DA,$72DC,$72DF,
$72E0,$72E1,$72E3,$72E4,$72E6,$72E8,$72E9,$72EA,$72EB,$72F3,$72F4,$72F6,$72F7,
$72F8,$72F9,$72FA,$72FB,$72FC,$72FD,$72FE,$72FF,$7300,$7301,$7307,$7308,$730A,
$730B,$730C,$730F,$7311,$7312,$7313,$7316,$7317,$7318,$7319,$731B,$731C,$731D,
$731E,$7322,$7323,$7325,$7326,$7327,$7329,$732D,$7330,$7331,$7332,$7333,$7334,
$7335,$7336,$7337,$733A,$733B,$733C,$733E,$733F,$7340,$7342,$7343,$7344,$7345,
$7349,$734A,$734C,$734D,$734E,$7350,$7351,$7352,$7357,$7358,$7359,$735A,$735B,
$735D,$735E,$735F,$7360,$7361,$7362,$7365,$7366,$7367,$7368,$7369,$736A,$736B,
$736C,$736E,$736F,$7370,$7372,$7373,$7375,$7376,$7377,$7378,$737A,$737B,$737C,
$737D,$737E,$737F,$7380,$7381,$7382,$7383,$7384,$7385,$7386,$7387,$7388,$7389,
$738A,$738B,$738E,$7392,$7393,$7394,$7395,$7396,$7397,$739D,$739F,$73A0,$73A1,
$73A2,$73A4,$73A5,$73A6,$73A8,$73A9,$73AB,$73AC,$73AD,$73B2,$73B3,$73B4,$73B5,
$73B6,$73B7,$73B8,$73B9,$73BB,$73BC,$73BE,$73BF,$73C0,$73C2,$73C3,$73C5,$73C6,
$73C7,$73C8,$73CA,$73CB,$73CC,$73CD,$73D2,$73D3,$73D4,$73D6,$73D7,$73D8,$73D9,
$73DA,$73DB,$73DC,$73DD,$73DE,$73E0,$73E3,$73E5,$73E7,$73E8,$73E9,$73EA,$73EB,
$73ED,$73EE,$73F4,$73F5,$73F6,$73F8,$73FA,$73FC,$73FD,$73FE,$73FF,$7400,$7401,
$7403,$7404,$7405,$7406,$7407,$7408,$7409,$740A,$740B,$740C,$740D,$7416,$741A,
$741B,$741D,$7420,$7421,$7422,$7423,$7424,$7425,$7426,$7428,$7429,$742A,$742B,
$742C,$742D,$742E,$742F,$7430,$7431,$7432,$7433,$7434,$7435,$7436,$743A,$743F,
$7440,$7441,$7442,$7444,$7446,$744A,$744B,$744D,$744E,$744F,$7450,$7451,$7452,
$7454,$7455,$7457,$7459,$745A,$745B,$745C,$745E,$745F,$7462,$7463,$7464,$7467,
$7469,$746A,$746D,$746E,$746F,$7470,$7471,$7472,$7473,$7475,$7479,$747C,$747D,
$747E,$747F,$7480,$7481,$7483,$7485,$7486,$7487,$7488,$7489,$748A,$748B,$7490,
$7492,$7494,$7495,$7497,$7498,$749A,$749C,$749E,$749F,$74A0,$74A1,$74A3,$74A5,
$74A6,$74A7,$74A8,$74A9,$74AA,$74AB,$74AD,$74AF,$74B0,$74B1,$74B2,$74B5,$74B6,
$74B7,$74B8,$74BA,$74BB,$74BD,$74BE,$74BF,$74C0,$74C1,$74C2,$74C3,$74C5,$74CA,
$74CB,$74CF,$74D4,$74D5,$74D6,$74D7,$74D8,$74D9,$74DA,$74DB,$74DC,$74DD,$74DE,
$74DF,$74E0,$74E1,$74E2,$74E3,$74E4,$74E5,$74E6,$74E8,$74E9,$74EC,$74EE,$74F4,
$74F5,$74F6,$74F7,$74FB,$74FD,$74FE,$74FF,$7500,$7502,$7503,$7504,$7507,$7508,
$750B,$750C,$750D,$750F,$7510,$7511,$7512,$7513,$7514,$7515,$7516,$7517,$7518,
$751A,$751C,$751D,$751F,$7521,$7522,$7525,$7526,$7528,$7529,$752A,$752B,$752C,
$752D,$752E,$752F,$7530,$7531,$7532,$7533,$7537,$7538,$7539,$753A,$753D,$753E,
$753F,$7540,$7547,$7548,$754B,$754C,$754E,$754F,$7554,$7559,$755A,$755B,$755C,
$755D,$755F,$7562,$7563,$7564,$7565,$7566,$756A,$756B,$756C,$756F,$7570,$7576,
$7577,$7578,$7579,$757D,$757E,$757F,$7580,$7584,$7586,$7587,$758A,$758B,$758C,
$758F,$7590,$7591,$7594,$7595,$7598,$7599,$759A,$759D,$75A2,$75A3,$75A4,$75A5,
$75A7,$75AA,$75AB,$75B0,$75B2,$75B3,$75B5,$75B6,$75B8,$75B9,$75BA,$75BB,$75BC,
$75BD,$75BE,$75BF,$75C0,$75C1,$75C2,$75C4,$75C5,$75C7,$75CA,$75CB,$75CC,$75CD,
$75CE,$75CF,$75D0,$75D1,$75D2,$75D4,$75D5,$75D7,$75D8,$75D9,$75DA,$75DB,$75DD,
$75DE,$75DF,$75E0,$75E1,$75E2,$75E3,$75E4,$75E6,$75E7,$75ED,$75EF,$75F0,$75F1,
$75F2,$75F3,$75F4,$75F5,$75F6,$75F7,$75F8,$75F9,$75FA,$75FB,$75FC,$75FD,$75FE,
$75FF,$7600,$7601,$7603,$7608,$7609,$760A,$760B,$760C,$760D,$760F,$7610,$7611,
$7613,$7614,$7615,$7616,$7619,$761A,$761B,$761C,$761D,$761E,$761F,$7620,$7621,
$7622,$7623,$7624,$7625,$7626,$7627,$7628,$7629,$762D,$762F,$7630,$7631,$7632,
$7633,$7634,$7635,$7638,$763A,$763C,$763D,$7642,$7643,$7646,$7647,$7648,$7649,
$764C,$7650,$7652,$7653,$7656,$7657,$7658,$7659,$765A,$765C,$765F,$7660,$7661,
$7662,$7664,$7665,$7669,$766A,$766C,$766D,$766E,$7670,$7671,$7672,$7675,$7678,
$7679,$767B,$767C,$767D,$767E,$767F,$7681,$7682,$7684,$7686,$7687,$7688,$7689,
$768A,$768B,$768E,$768F,$7692,$7693,$7695,$7696,$7699,$769A,$769B,$769C,$769D,
$769E,$76A4,$76A6,$76AA,$76AB,$76AD,$76AE,$76AF,$76B0,$76B4,$76B5,$76B8,$76BA,
$76BB,$76BD,$76BE,$76BF,$76C2,$76C3,$76C4,$76C5,$76C6,$76C8,$76C9,$76CA,$76CD,
$76CE,$76D2,$76D3,$76D4,$76DA,$76DB,$76DC,$76DD,$76DE,$76DF,$76E1,$76E3,$76E4,
$76E5,$76E6,$76E7,$76E9,$76EA,$76EC,$76ED,$76EE,$76EF,$76F0,$76F1,$76F2,$76F3,
$76F4,$76F5,$76F7,$76F8,$76F9,$76FA,$76FB,$76FC,$76FE,$7701,$7703,$7704,$7705,
$7707,$7708,$7709,$770A,$770B,$7710,$7711,$7712,$7713,$7715,$7719,$771A,$771B,
$771D,$771F,$7720,$7722,$7723,$7725,$7727,$7728,$7729,$772D,$772F,$7731,$7732,
$7733,$7734,$7735,$7736,$7737,$7738,$7739,$773A,$773B,$773C,$773D,$773E,$7744,
$7745,$7746,$7747,$774A,$774B,$774C,$774D,$774E,$774F,$7752,$7754,$7755,$7756,
$7759,$775A,$775B,$775C,$775E,$775F,$7760,$7761,$7762,$7763,$7765,$7766,$7767,
$7768,$7769,$776A,$776B,$776C,$776D,$776E,$776F,$7779,$777C,$777D,$777E,$777F,
$7780,$7781,$7782,$7783,$7784,$7785,$7787,$7788,$7789,$778B,$778C,$778D,$778E,
$778F,$7791,$7795,$7797,$7799,$779A,$779B,$779C,$779D,$779E,$779F,$77A0,$77A1,
$77A2,$77A3,$77A5,$77A7,$77A8,$77AA,$77AB,$77AC,$77AD,$77B0,$77B1,$77B2,$77B3,
$77B4,$77B5,$77B6,$77B7,$77BA,$77BB,$77BC,$77BD,$77BF,$77C2,$77C4,$77C7,$77C9,
$77CA,$77CC,$77CD,$77CE,$77CF,$77D0,$77D3,$77D4,$77D5,$77D7,$77D8,$77D9,$77DA,
$77DB,$77DC,$77DE,$77E0,$77E2,$77E3,$77E5,$77E7,$77E8,$77E9,$77EC,$77ED,$77EE,
$77EF,$77F0,$77F1,$77F2,$77F3,$77F7,$77F8,$77F9,$77FA,$77FB,$77FC,$77FD,$7802,
$7803,$7805,$7806,$7809,$780C,$780D,$780E,$780F,$7810,$7811,$7812,$7813,$7814,
$781D,$781F,$7820,$7821,$7822,$7823,$7825,$7826,$7827,$7828,$7829,$782A,$782B,
$782C,$782D,$782E,$782F,$7830,$7831,$7832,$7833,$7834,$7835,$7837,$7838,$7843,
$7845,$7848,$7849,$784A,$784C,$784D,$784E,$7850,$7852,$785C,$785D,$785E,$7860,
$7862,$7864,$7865,$7868,$7869,$786A,$786B,$786C,$786D,$786E,$786F,$7870,$7871,
$7879,$787B,$787C,$787E,$787F,$7880,$7881,$7883,$7884,$7885,$7886,$7887,$7889,
$788C,$788E,$788F,$7891,$7893,$7894,$7895,$7896,$7897,$7898,$7899,$789A,$789E,
$789F,$78A0,$78A1,$78A2,$78A3,$78A4,$78A5,$78A7,$78A8,$78A9,$78AA,$78AB,$78AC,
$78AD,$78B0,$78B2,$78B3,$78B4,$78BA,$78BB,$78BC,$78BE,$78C1,$78C3,$78C4,$78C5,
$78C8,$78C9,$78CA,$78CB,$78CC,$78CD,$78CE,$78CF,$78D0,$78D1,$78D4,$78D5,$78DA,
$78DB,$78DD,$78DE,$78DF,$78E0,$78E1,$78E2,$78E3,$78E5,$78E7,$78E8,$78E9,$78EA,
$78EC,$78ED,$78EF,$78F2,$78F3,$78F4,$78F7,$78F9,$78FA,$78FB,$78FC,$78FD,$78FE,
$78FF,$7901,$7902,$7904,$7905,$7909,$790C,$790E,$7910,$7911,$7912,$7913,$7914,
$7917,$7919,$791B,$791C,$791D,$791E,$7921,$7923,$7924,$7925,$7926,$7927,$7928,
$7929,$792A,$792B,$792C,$792D,$792F,$7931,$7935,$7938,$7939,$793A,$793D,$793E,
$793F,$7940,$7941,$7942,$7944,$7945,$7946,$7947,$7948,$7949,$794A,$794B,$794C,
$794F,$7950,$7951,$7952,$7953,$7954,$7955,$7956,$7957,$795A,$795B,$795C,$795D,
$795E,$795F,$7960,$7961,$7963,$7964,$7965,$7967,$7968,$7969,$796A,$796B,$796D,
$7970,$7972,$7973,$7974,$7979,$797A,$797C,$797D,$797F,$7981,$7982,$7988,$798A,
$798B,$798D,$798E,$798F,$7990,$7992,$7993,$7994,$7995,$7996,$7997,$7998,$799A,
$799B,$799C,$79A0,$79A1,$79A2,$79A4,$79A6,$79A7,$79A8,$79AA,$79AB,$79AC,$79AD,
$79AE,$79B0,$79B1,$79B2,$79B3,$79B4,$79B6,$79B7,$79B8,$79B9,$79BA,$79BB,$79BD,
$79BE,$79BF,$79C0,$79C1,$79C5,$79C8,$79C9,$79CB,$79CD,$79CE,$79CF,$79D1,$79D2,
$79D5,$79D6,$79D8,$79DC,$79DD,$79DE,$79DF,$79E0,$79E3,$79E4,$79E6,$79E7,$79E9,
$79EA,$79EB,$79EC,$79ED,$79EE,$79F6,$79F7,$79F8,$79FA,$79FB,$7A00,$7A02,$7A03,
$7A04,$7A05,$7A08,$7A0A,$7A0B,$7A0C,$7A0D,$7A10,$7A11,$7A12,$7A13,$7A14,$7A15,
$7A17,$7A18,$7A19,$7A1A,$7A1B,$7A1C,$7A1E,$7A1F,$7A20,$7A22,$7A26,$7A28,$7A2B,
$7A2E,$7A2F,$7A30,$7A31,$7A37,$7A39,$7A3B,$7A3C,$7A3D,$7A3F,$7A40,$7A44,$7A46,
$7A47,$7A48,$7A4A,$7A4B,$7A4C,$7A4D,$7A4E,$7A54,$7A56,$7A57,$7A58,$7A5A,$7A5B,
$7A5C,$7A5F,$7A60,$7A61,$7A62,$7A67,$7A68,$7A69,$7A6B,$7A6C,$7A6D,$7A6E,$7A70,
$7A71,$7A74,$7A75,$7A76,$7A78,$7A79,$7A7A,$7A7B,$7A7E,$7A7F,$7A80,$7A81,$7A84,
$7A85,$7A86,$7A87,$7A88,$7A89,$7A8A,$7A8B,$7A8C,$7A8F,$7A90,$7A92,$7A94,$7A95,
$7A96,$7A97,$7A98,$7A99,$7A9E,$7A9F,$7AA0,$7AA2,$7AA3,$7AA8,$7AA9,$7AAA,$7AAB,
$7AAC,$7AAE,$7AAF,$7AB1,$7AB2,$7AB3,$7AB4,$7AB5,$7AB6,$7AB7,$7AB8,$7ABA,$7ABE,
$7ABF,$7AC0,$7AC1,$7AC4,$7AC5,$7AC7,$7ACA,$7ACB,$7AD1,$7AD8,$7AD9,$7ADF,$7AE0,
$7AE3,$7AE4,$7AE5,$7AE6,$7AEB,$7AED,$7AEE,$7AEF,$7AF6,$7AF7,$7AF9,$7AFA,$7AFB,
$7AFD,$7AFF,$7B00,$7B01,$7B04,$7B05,$7B06,$7B08,$7B09,$7B0A,$7B0E,$7B0F,$7B10,
$7B11,$7B12,$7B13,$7B18,$7B19,$7B1A,$7B1B,$7B1D,$7B1E,$7B20,$7B22,$7B23,$7B24,
$7B25,$7B26,$7B28,$7B2A,$7B2B,$7B2C,$7B2D,$7B2E,$7B2F,$7B30,$7B31,$7B32,$7B33,
$7B34,$7B35,$7B38,$7B3B,$7B40,$7B44,$7B45,$7B46,$7B47,$7B48,$7B49,$7B4A,$7B4B,
$7B4C,$7B4D,$7B4E,$7B4F,$7B50,$7B51,$7B52,$7B54,$7B56,$7B58,$7B60,$7B61,$7B63,
$7B64,$7B65,$7B66,$7B67,$7B69,$7B6D,$7B6E,$7B70,$7B71,$7B72,$7B73,$7B74,$7B75,
$7B76,$7B77,$7B78,$7B82,$7B84,$7B85,$7B87,$7B88,$7B8A,$7B8B,$7B8C,$7B8D,$7B8E,
$7B8F,$7B90,$7B91,$7B94,$7B95,$7B96,$7B97,$7B98,$7B99,$7B9B,$7B9C,$7B9D,$7BA0,
$7BA1,$7BA4,$7BAC,$7BAD,$7BAF,$7BB1,$7BB4,$7BB5,$7BB7,$7BB8,$7BB9,$7BBE,$7BC0,
$7BC1,$7BC4,$7BC6,$7BC7,$7BC9,$7BCA,$7BCB,$7BCC,$7BCE,$7BD4,$7BD5,$7BD8,$7BD9,
$7BDA,$7BDB,$7BDC,$7BDD,$7BDE,$7BDF,$7BE0,$7BE1,$7BE2,$7BE3,$7BE4,$7BE5,$7BE6,
$7BE7,$7BE8,$7BE9,$7BEA,$7BEB,$7BF0,$7BF1,$7BF2,$7BF3,$7BF4,$7BF7,$7BF8,$7BF9,
$7BFB,$7BFD,$7BFE,$7BFF,$7C00,$7C01,$7C02,$7C03,$7C05,$7C06,$7C07,$7C09,$7C0A,
$7C0B,$7C0C,$7C0D,$7C0E,$7C0F,$7C10,$7C11,$7C19,$7C1C,$7C1D,$7C1E,$7C1F,$7C20,
$7C21,$7C22,$7C23,$7C25,$7C26,$7C27,$7C28,$7C29,$7C2A,$7C2B,$7C2C,$7C2D,$7C30,
$7C33,$7C37,$7C38,$7C39,$7C3B,$7C3C,$7C3D,$7C3E,$7C3F,$7C40,$7C43,$7C45,$7C47,
$7C48,$7C49,$7C4A,$7C4C,$7C4D,$7C50,$7C53,$7C54,$7C57,$7C59,$7C5A,$7C5B,$7C5C,
$7C5F,$7C60,$7C63,$7C64,$7C65,$7C66,$7C67,$7C69,$7C6A,$7C6B,$7C6C,$7C6E,$7C6F,
$7C72,$7C73,$7C75,$7C78,$7C79,$7C7A,$7C7D,$7C7F,$7C80,$7C81,$7C84,$7C85,$7C88,
$7C89,$7C8A,$7C8C,$7C8D,$7C91,$7C92,$7C94,$7C95,$7C96,$7C97,$7C98,$7C9E,$7C9F,
$7CA1,$7CA2,$7CA3,$7CA5,$7CA7,$7CA8,$7CAF,$7CB1,$7CB2,$7CB3,$7CB4,$7CB5,$7CB9,
$7CBA,$7CBB,$7CBC,$7CBD,$7CBE,$7CBF,$7CC5,$7CC8,$7CCA,$7CCB,$7CCC,$7CCE,$7CD0,
$7CD1,$7CD2,$7CD4,$7CD5,$7CD6,$7CD7,$7CD9,$7CDC,$7CDD,$7CDE,$7CDF,$7CE0, $7CE2,
$7CE7,$7CE8,$7CEA,$7CEC,$7CEE,$7CEF,$7CF0,$7CF1,$7CF2,$7CF4,$7CF6,$7CF7,$7CF8,
$7CFB,$7CFD,$7CFE,$7D00,$7D01,$7D02,$7D03,$7D04,$7D05,$7D06,$7D07,$7D08,$7D09,
$7D0A,$7D0B,$7D0C,$7D0D,$7D0E,$7D0F,$7D10,$7D11,$7D12,$7D13,$7D14,$7D15,$7D16,
$7D17,$7D18,$7D19,$7D1A,$7D1B,$7D1C,$7D1D,$7D1E,$7D1F,$7D20,$7D21,$7D22,$7D28,
$7D29,$7D2B,$7D2C,$7D2E,$7D2F,$7D30,$7D31,$7D32,$7D33,$7D35,$7D36,$7D38,$7D39,
$7D3A,$7D3B,$7D3C,$7D3D,$7D3E,$7D3F,$7D40,$7D41,$7D42,$7D43,$7D44,$7D45,$7D46,
$7D47,$7D4A,$7D4E,$7D4F,$7D50,$7D51,$7D52,$7D53,$7D54,$7D55,$7D56,$7D58,$7D5B,
$7D5C,$7D5E,$7D5F,$7D61,$7D62,$7D63,$7D66,$7D67,$7D68,$7D69,$7D6A,$7D6B,$7D6D,
$7D6E,$7D6F,$7D70,$7D71,$7D72,$7D73,$7D79,$7D7A,$7D7B,$7D7C,$7D7D,$7D7F,$7D80,
$7D81,$7D83,$7D84,$7D85,$7D86,$7D88,$7D8C,$7D8D,$7D8E,$7D8F,$7D91,$7D92,$7D93,
$7D94,$7D96,$7D9C,$7D9D,$7D9E,$7D9F,$7DA0,$7DA1,$7DA2,$7DA3,$7DA6,$7DA7,$7DA9,
$7DAA,$7DAC,$7DAD,$7DAE,$7DAF,$7DB0,$7DB1,$7DB2,$7DB4,$7DB5,$7DB7,$7DB8,$7DB9,
$7DBA,$7DBB,$7DBC,$7DBD,$7DBE,$7DBF,$7DC0,$7DC1,$7DC2,$7DC4,$7DC5,$7DC6,$7DC7,
$7DC9,$7DCA,$7DCB,$7DCC,$7DCE,$7DD2,$7DD7,$7DD8,$7DD9,$7DDA,$7DDB,$7DDD,$7DDE,
$7DDF,$7DE0,$7DE1,$7DE3,$7DE6,$7DE7,$7DE8,$7DE9,$7DEA,$7DEC,$7DEE,$7DEF,$7DF0,
$7DF1,$7DF2,$7DF3,$7DF4,$7DF6,$7DF7,$7DF9,$7DFA,$7DFB,$7E03,$7E08,$7E09,$7E0A,
$7E0B,$7E0C,$7E0D,$7E0E,$7E0F,$7E10,$7E11,$7E12,$7E13,$7E14,$7E15,$7E16,$7E17,
$7E1A,$7E1B,$7E1C,$7E1D,$7E1E,$7E1F,$7E20,$7E21,$7E22,$7E23,$7E24,$7E25,$7E29,
$7E2A,$7E2B,$7E2D,$7E2E,$7E2F,$7E30,$7E31,$7E32,$7E33,$7E34,$7E35,$7E36,$7E37,
$7E38,$7E39,$7E3A,$7E3B,$7E3C,$7E3D,$7E3E,$7E3F,$7E40,$7E41,$7E42,$7E43,$7E44,
$7E45,$7E46,$7E47,$7E48,$7E49,$7E4C,$7E50,$7E51,$7E52,$7E53,$7E54,$7E55,$7E56,
$7E57,$7E58,$7E59,$7E5A,$7E5C,$7E5E,$7E5F,$7E60,$7E61,$7E62,$7E63,$7E68,$7E69,
$7E6A,$7E6B,$7E6D,$7E6F,$7E70,$7E72,$7E73,$7E74,$7E75,$7E76,$7E77,$7E78,$7E79,
$7E7A,$7E7B,$7E7C,$7E7D,$7E7E,$7E80,$7E81,$7E82,$7E86,$7E87,$7E88,$7E8A,$7E8B,
$7E8C,$7E8D,$7E8F,$7E91,$7E93,$7E94,$7E95,$7E96,$7E97,$7E98,$7E99,$7E9A,$7E9B,
$7E9C,$7F36,$7F38,$7F39,$7F3A,$7F3D,$7F3E,$7F3F,$7F43,$7F44,$7F45,$7F48,$7F4A,
$7F4B,$7F4C,$7F4D,$7F4F,$7F50,$7F51,$7F54,$7F55,$7F58,$7F5B,$7F5C,$7F5D,$7F5E,
$7F5F,$7F60,$7F61,$7F63,$7F65,$7F66,$7F67,$7F68,$7F69,$7F6A,$7F6B,$7F6C,$7F6D,
$7F6E,$7F70,$7F72,$7F73,$7F75,$7F76,$7F77,$7F79,$7F7A,$7F7B,$7F7C,$7F7D,$7F7E,
$7F7F,$7F83,$7F85,$7F86,$7F87,$7F88,$7F89,$7F8A,$7F8B,$7F8C,$7F8D,$7F8E,$7F91,
$7F92,$7F94,$7F95,$7F96,$7F9A,$7F9B,$7F9C,$7F9D,$7F9E,$7FA0,$7FA1,$7FA2,$7FA4,
$7FA5,$7FA6,$7FA7,$7FA8,$7FA9,$7FAC,$7FAD,$7FAF,$7FB0,$7FB1,$7FB2,$7FB3,$7FB5,
$7FB6,$7FB7,$7FB8,$7FB9,$7FBA,$7FBB,$7FBC,$7FBD,$7FBE,$7FBF,$7FC0,$7FC1,$7FC2,
$7FC3,$7FC5,$7FC7,$7FC9,$7FCA,$7FCB,$7FCC,$7FCD,$7FCE,$7FCF,$7FD0,$7FD1,$7FD2,
$7FD4,$7FD5,$7FD7,$7FDB,$7FDC,$7FDE,$7FDF,$7FE0,$7FE1,$7FE2,$7FE3,$7FE5,$7FE6,
$7FE8,$7FE9,$7FEA,$7FEB,$7FEC,$7FED,$7FEE,$7FEF,$7FF0,$7FF1,$7FF2,$7FF3,$7FF4,
$7FF5,$7FF7,$7FF8,$7FF9,$7FFB,$7FFC,$7FFD,$7FFE,$7FFF,$8000,$8001,$8003,$8004,
$8005,$8006,$8007,$800B,$800C,$800D,$800E,$800F,$8010,$8011,$8012,$8014,$8015,
$8016,$8017,$8018,$8019,$801B,$801C,$801E,$801F,$8021,$8024,$8026,$8028,$8029,
$802A,$802C,$8030,$8033,$8034,$8035,$8036,$8037,$8039,$803D,$803E,$803F,$8043,
$8046,$8047,$8048,$804A,$804F,$8050,$8051,$8052,$8056,$8058,$805A,$805C,$805D,
$805E,$8064,$8067,$806C,$806F,$8070,$8071,$8072,$8073,$8075,$8076,$8077,$8078,
$8079,$807D,$807E,$807F,$8082,$8084,$8085,$8086,$8087,$8089,$808A,$808B,$808C,
$808F,$8090,$8092,$8093,$8095,$8096,$8098,$8099,$809A,$809B,$809C,$809D,$80A1,
$80A2,$80A3,$80A5,$80A9,$80AA,$80AB,$80AD,$80AE,$80AF,$80B1,$80B2,$80B4,$80B5,
$80B8,$80BA,$80C2,$80C3,$80C4,$80C5,$80C7,$80C8,$80C9,$80CA,$80CC,$80CD,$80CE,
$80CF,$80D0,$80D1,$80D4,$80D5,$80D6,$80D7,$80D8,$80D9,$80DA,$80DB,$80DC,$80DD,
$80DE,$80E0,$80E1,$80E3,$80E4,$80E5,$80E6,$80ED,$80EF,$80F0,$80F1,$80F2,$80F3,
$80F4,$80F5,$80F8,$80F9,$80FA,$80FB,$80FC,$80FD,$80FE,$8100,$8101,$8102,$8105,
$8106,$8108,$810A,$8115,$8116,$8118,$8119,$811B,$811D,$811E,$811F,$8121,$8122,
$8123,$8124,$8125,$8127,$8129,$812B,$812C,$812D,$812F,$8130,$8139,$813A,$813D,
$813E,$8143,$8144,$8146,$8147,$814A,$814B,$814C,$814D,$814E,$814F,$8150,$8151,
$8152,$8153,$8154,$8155,$815B,$815C,$815E,$8160,$8161,$8162,$8164,$8165,$8166,
$8167,$8169,$816B,$816E,$816F,$8170,$8171,$8172,$8173,$8174,$8176,$8177,$8178,
$8179,$817A,$817F,$8180,$8182,$8183,$8186,$8187,$8188,$8189,$818A,$818B,$818C,
$818D,$818F,$8195,$8197,$8198,$8199,$819A,$819B,$819C,$819D,$819E,$819F,$81A0,
$81A2,$81A3,$81A6,$81A7,$81A8,$81A9,$81AB,$81AC,$81AE,$81B0,$81B1,$81B2,$81B3,
$81B4,$81B5,$81B7,$81B9,$81BA,$81BB,$81BC,$81BD,$81BE,$81BF,$81C0,$81C2,$81C3,
$81C4,$81C5,$81C6,$81C7,$81C9,$81CA,$81CC,$81CD,$81CF,$81D0,$81D1,$81D2,$81D5,
$81D7,$81D8,$81D9,$81DA,$81DB,$81DD,$81DE,$81DF,$81E0,$81E1,$81E2,$81E3,$81E5,
$81E6,$81E7,$81E8,$81E9,$81EA,$81EC,$81ED,$81EE,$81F2,$81F3,$81F4,$81F7,$81F8,
$81F9,$81FA,$81FB,$81FC,$81FE,$81FF,$8200,$8201,$8202,$8204,$8205,$8207,$8208,
$8209,$820A,$820B,$820C,$820D,$8210,$8211,$8212,$8214,$8215,$8216,$821B,$821C,
$821D,$821E,$821F,$8220,$8221,$8222,$8225,$8228,$822A,$822B,$822C,$822F,$8232,
$8233,$8234,$8235,$8236,$8237,$8238,$8239,$823A,$823C,$823D,$823F,$8240,$8242,
$8244,$8245,$8247,$8249,$824B,$824E,$824F,$8250,$8251,$8252,$8253,$8255,$8256,
$8257,$8258,$8259,$825A,$825B,$825C,$825E,$825F,$8261,$8263,$8264,$8266,$8268,
$8269,$826B,$826C,$826D,$826E,$826F,$8271,$8272,$8274,$8275,$8277,$8278,$827C,
$827D,$827E,$827F,$8280,$8283,$8284,$8285,$828A,$828B,$828D,$828E,$828F,$8290,
$8291,$8292,$8293,$8294,$8298,$8299,$829A,$829B,$829D,$829E,$829F,$82A0,$82A1,
$82A2,$82A3,$82A4,$82A5,$82A7,$82A8,$82A9,$82AB,$82AC,$82AD,$82AE,$82AF,$82B0,
$82B1,$82B3,$82B4,$82B5,$82B6,$82B7,$82B8,$82B9,$82BA,$82BB,$82BC,$82BD,$82BE,
$82C0,$82C2,$82C3,$82D1,$82D2,$82D3,$82D4,$82D5,$82D6,$82D7,$82D9,$82DB,$82DC,
$82DE,$82DF,$82E0,$82E1,$82E3,$82E4,$82E5,$82E6,$82E7,$82E8,$82EA,$82EB,$82EC,
$82ED,$82EF,$82F0,$82F1,$82F2,$82F3,$82F4,$82F5,$82F6,$82F9,$82FA,$82FB,$82FE,
$8300,$8301,$8302,$8303,$8304,$8305,$8306,$8307,$8308,$8309,$830C,$830D,$8316,
$8317,$8319,$831B,$831C,$831E,$8320,$8322,$8324,$8325,$8326,$8327,$8328,$8329,
$832A,$832B,$832C,$832D,$832F,$8331,$8332,$8333,$8334,$8335,$8336,$8337,$8338,
$8339,$833A,$833B,$833C,$833F,$8340,$8341,$8342,$8343,$8344,$8345,$8347,$8348,
$8349,$834A,$834B,$834C,$834D,$834E,$834F,$8350,$8351,$8352,$8353,$8354,$8356,
$8373,$8374,$8375,$8376,$8377,$8378,$837A,$837B,$837C,$837D,$837E,$837F,$8381,
$8383,$8386,$8387,$8388,$8389,$838A,$838B,$838C,$838D,$838E,$838F,$8390,$8392,
$8393,$8394,$8395,$8396,$8397,$8398,$8399,$839A,$839B,$839D,$839E,$83A0,$83A2,
$83A3,$83A4,$83A5,$83A6,$83A7,$83A8,$83A9,$83AA,$83AB,$83AE,$83AF,$83B0,$83BD,
$83BF,$83C0,$83C1,$83C2,$83C3,$83C4,$83C5,$83C6,$83C7,$83C8,$83C9,$83CA,$83CB,
$83CC,$83CE,$83CF,$83D1,$83D4,$83D5,$83D6,$83D7,$83D8,$83D9,$83DB,$83DC,$83DD,
$83DE,$83DF,$83E0,$83E1,$83E2,$83E3,$83E4,$83E5,$83E7,$83E8,$83E9,$83EA,$83EB,
$83EC,$83EE,$83EF,$83F0,$83F1,$83F2,$83F3,$83F4,$83F5,$83F6,$83F8,$83F9,$83FA,
$83FB,$83FC,$83FD,$83FE,$83FF,$8401,$8403,$8404,$8406,$8407,$8409,$840A,$840B,
$840C,$840D,$840E,$840F,$8410,$8411,$8412,$8413,$841B,$8423,$8429,$842B,$842C,
$842D,$842F,$8430,$8431,$8432,$8433,$8434,$8435,$8436,$8437,$8438,$8439,$843A,
$843B,$843C,$843D,$843F,$8440,$8442,$8443,$8444,$8445,$8446,$8447,$8449,$844B,
$844C,$844D,$844E,$8450,$8451,$8452,$8454,$8456,$8457,$8459,$845A,$845B,$845D,
$845E,$845F,$8460,$8461,$8463,$8465,$8466,$8467,$8468,$8469,$846B,$846C,$846D,
$846E,$846F,$8470,$8473,$8474,$8475,$8476,$8477,$8478,$8479,$847A,$847D,$847E,
$8482,$8486,$848D,$848E,$848F,$8490,$8491,$8494,$8497,$8498,$8499,$849A,$849B,
$849C,$849D,$849E,$849F,$84A0,$84A1,$84A2,$84A4,$84A7,$84A8,$84A9,$84AA,$84AB,
$84AC,$84AE,$84AF,$84B0,$84B1,$84B2,$84B4,$84B6,$84B8,$84B9,$84BA,$84BB,$84BC,
$84BF,$84C0,$84C1,$84C2,$84C4,$84C5,$84C6,$84C7,$84C9,$84CA,$84CB,$84CC,$84CD,
$84CE,$84CF,$84D0,$84D1,$84D2,$84D3,$84D4,$84D6,$84D7,$84DB,$84E7,$84E8,$84E9,
$84EA,$84EB,$84EC,$84EE,$84EF,$84F0,$84F1,$84F2,$84F3,$84F4,$84F6,$84F7,$84F9,
$84FA,$84FB,$84FC,$84FD,$84FE,$84FF,$8500,$8502,$8506,$8507,$8508,$8509,$850A,
$850B,$850C,$850D,$850E,$850F,$8511,$8512,$8513,$8514,$8515,$8516,$8517,$8518,
$8519,$851A,$851C,$851D,$851E,$851F,$8520,$8521,$8523,$8524,$8525,$8526,$8527,
$8528,$8529,$852A,$852B,$852C,$852D,$852E,$852F,$8530,$8531,$853B,$853D,$853E,
$8540,$8541,$8543,$8544,$8545,$8546,$8547,$8548,$8549,$854A,$854D,$854E,$8551,
$8553,$8554,$8555,$8556,$8557,$8558,$8559,$855B,$855D,$855E,$8560,$8561,$8562,
$8563,$8564,$8565,$8566,$8567,$8568,$8569,$856A,$856B,$856C,$856D,$856E,$8571,
$8575,$8576,$8577,$8578,$8579,$857A,$857B,$857C,$857E,$8580,$8581,$8582,$8583,
$8584,$8585,$8586,$8587,$8588,$8589,$858A,$858B,$858C,$858D,$858E,$858F,$8590,
$8591,$8594,$8595,$8596,$8598,$8599,$859A,$859B,$859C,$859D,$859E,$859F,$85A0,
$85A1,$85A2,$85A3,$85A4,$85A6,$85A7,$85A8,$85A9,$85AA,$85AF,$85B0,$85B1,$85B3,
$85B4,$85B5,$85B6,$85B7,$85B8,$85B9,$85BA,$85BD,$85BE,$85BF,$85C0,$85C2,$85C3,
$85C4,$85C5,$85C6,$85C7,$85C8,$85C9,$85CB,$85CD,$85CE,$85CF,$85D0,$85D1,$85D2,
$85D5,$85D7,$85D8,$85D9,$85DA,$85DC,$85DD,$85DE,$85DF,$85E1,$85E2,$85E3,$85E4,
$85E5,$85E6,$85E8,$85E9,$85EA,$85EB,$85EC,$85ED,$85EF,$85F0,$85F1,$85F2,$85F6,
$85F7,$85F8,$85F9,$85FA,$85FB,$85FD,$85FE,$85FF,$8600,$8601,$8604,$8605,$8606,
$8607,$8609,$860A,$860B,$860C,$8611,$8617,$8618,$8619,$861A,$861B,$861C,$861E,
$861F,$8620,$8621,$8622,$8623,$8624,$8625,$8626,$8627,$8629,$862A,$862C,$862D,
$862E,$8631,$8632,$8633,$8634,$8635,$8636,$8638,$8639,$863A,$863B,$863C,$863E,
$863F,$8640,$8643,$8646,$8647,$8648,$864B,$864C,$864D,$864E,$8650,$8652,$8653,
$8654,$8655,$8656,$8659,$865B,$865C,$865E,$865F,$8661,$8662,$8663,$8664,$8665,
$8667,$8668,$8669,$866A,$866B,$866D,$866E,$866F,$8670,$8671,$8673,$8674,$8677,
$8679,$867A,$867B,$867C,$8685,$8686,$8687,$868A,$868B,$868C,$868D,$868E,$8690,
$8691,$8693,$8694,$8695,$8696,$8697,$8698,$8699,$869A,$869C,$869D,$869E,$86A1,
$86A2,$86A3,$86A4,$86A5,$86A7,$86A8,$86A9,$86AA,$86AF,$86B0,$86B1,$86B3,$86B4,
$86B5,$86B6,$86B7,$86B8,$86B9,$86BA,$86BB,$86BC,$86BD,$86BE,$86BF,$86C0,$86C1,
$86C2,$86C3,$86C4,$86C5,$86C6,$86C7,$86C8,$86C9,$86CB,$86CC,$86D0,$86D1,$86D3,
$86D4,$86D6,$86D7,$86D8,$86D9,$86DA,$86DB,$86DC,$86DD,$86DE,$86DF,$86E2,$86E3,
$86E4,$86E6,$86E8,$86E9,$86EA,$86EB,$86EC,$86ED,$86F5,$86F6,$86F7,$86F8,$86F9,
$86FA,$86FB,$86FE,$8700,$8701,$8702,$8703,$8704,$8705,$8706,$8707,$8708,$8709,
$870A,$870B,$870C,$870D,$870E,$8711,$8712,$8713,$8718,$8719,$871A,$871B,$871C,
$871E,$8720,$8721,$8722,$8723,$8724,$8725,$8726,$8727,$8728,$8729,$872A,$872C,
$872D,$872E,$8730,$8731,$8732,$8733,$8734,$8735,$8737,$8738,$873A,$873B,$873C,
$873E,$873F,$8740,$8741,$8742,$8743,$8746,$874C,$874D,$874E,$874F,$8750,$8751,
$8752,$8753,$8754,$8755,$8756,$8757,$8758,$8759,$875A,$875B,$875C,$875D,$875E,
$875F,$8760,$8761,$8762,$8763,$8764,$8765,$8766,$8767,$8768,$8769,$876A,$876B,
$876C,$876D,$876E,$876F,$8773,$8774,$8775,$8776,$8777,$8778,$8779,$877A,$877B,
$8781,$8782,$8783,$8784,$8785,$8787,$8788,$8789,$878D,$878F,$8790,$8791,$8792,
$8793,$8794,$8796,$8797,$8798,$879A,$879B,$879C,$879D,$879E,$879F,$87A2,$87A3,
$87A4,$87AA,$87AB,$87AC,$87AD,$87AE,$87AF,$87B0,$87B2,$87B3,$87B4,$87B5,$87B6,
$87B7,$87B8,$87B9,$87BA,$87BB,$87BC,$87BD,$87BE,$87BF,$87C0,$87C2,$87C3,$87C4,
$87C5,$87C6,$87C8,$87C9,$87CA,$87CB,$87CC,$87D1,$87D2,$87D3,$87D4,$87D7,$87D8,
$87D9,$87DB,$87DC,$87DD,$87DE,$87DF,$87E0,$87E1,$87E2,$87E3,$87E4,$87E5,$87E6,
$87E7,$87E8,$87EA,$87EB,$87EC,$87ED,$87EF,$87F2,$87F3,$87F4,$87F6,$87F7,$87F9,
$87FA,$87FB,$87FC,$87FE,$87FF,$8800,$8801,$8802,$8803,$8805,$8806,$8808,$8809,
$880A,$880B,$880C,$880D,$8810,$8811,$8813,$8814,$8815,$8816,$8817,$8819,$881B,
$881C,$881D,$881F,$8820,$8821,$8822,$8823,$8824,$8825,$8826,$8828,$8829,$882A,
$882B,$882C,$882E,$882F,$8830,$8831,$8832,$8833,$8835,$8836,$8837,$8838,$8839,
$883B,$883C,$883D,$883E,$883F,$8840,$8841,$8843,$8844,$8848,$884A,$884B,$884C,
$884D,$884E,$8852,$8853,$8855,$8856,$8857,$8859,$885A,$885B,$885D,$8861,$8862,
$8863,$8867,$8868,$8869,$886A,$886B,$886D,$886F,$8870,$8871,$8872,$8874,$8875,
$8876,$8877,$8879,$887C,$887D,$887E,$887F,$8880,$8881,$8882,$8883,$8888,$8889,
$888B,$888C,$888D,$888E,$8891,$8892,$8893,$8895,$8896,$8897,$8898,$8899,$889A,
$889B,$889E,$889F,$88A1,$88A2,$88A4,$88A7,$88A8,$88AA,$88AB,$88AC,$88B1,$88B2,
$88B6,$88B7,$88B8,$88B9,$88BA,$88BC,$88BD,$88BE,$88C0,$88C1,$88C2,$88C9,$88CA,
$88CB,$88CC,$88CD,$88CE,$88CF,$88D0,$88D2,$88D4,$88D5,$88D6,$88D7,$88D8,$88D9,
$88DA,$88DB,$88DC,$88DD,$88DE,$88DF,$88E1,$88E7,$88E8,$88EB,$88EC,$88EE,$88EF,
$88F0,$88F1,$88F2,$88F3,$88F4,$88F6,$88F7,$88F8,$88F9,$88FA,$88FB,$88FC,$88FD,
$88FE,$8901,$8902,$8905,$8906,$8907,$8909,$890A,$890B,$890C,$890E,$8910,$8911,
$8912,$8913,$8914,$8915,$8916,$8917,$8918,$8919,$891A,$891E,$891F,$8921,$8922,
$8923,$8925,$8926,$8927,$8929,$892A,$892B,$892C,$892D,$892E,$892F,$8930,$8931,
$8932,$8933,$8935,$8936,$8937,$8938,$893B,$893C,$893D,$893E,$8941,$8942,$8944,
$8946,$8949,$894B,$894C,$894F,$8950,$8951,$8952,$8953,$8956,$8957,$8958,$8959,
$895A,$895B,$895C,$895D,$895E,$895F,$8960,$8961,$8962,$8963,$8964,$8966,$8969,
$896A,$896B,$896C,$896D,$896E,$896F,$8971,$8972,$8973,$8974,$8976,$8979,$897A,
$897B,$897C,$897E,$897F,$8981,$8982,$8983,$8985,$8986,$8988,$898B,$898F,$8993,
$8995,$8996,$8997,$8998,$899B,$899C,$899D,$899E,$899F,$89A1,$89A2,$89A3,$89A4,
$89A6,$89AA,$89AC,$89AD,$89AE,$89AF,$89B2,$89B6,$89B7,$89B9,$89BA,$89BD,$89BE,
$89BF,$89C0,$89D2,$89D3,$89D4,$89D5,$89D6,$89D9,$89DA,$89DB,$89DC,$89DD,$89DF,
$89E0,$89E1,$89E2,$89E3,$89E4,$89E5,$89E6,$89E8,$89E9,$89EB,$89EC,$89ED,$89F0,
$89F1,$89F2,$89F3,$89F4,$89F6,$89F7,$89F8,$89FA,$89FB,$89FC,$89FE,$89FF,$8A00,
$8A02,$8A03,$8A04,$8A07,$8A08,$8A0A,$8A0C,$8A0E,$8A0F,$8A10,$8A11,$8A12,$8A13,
$8A15,$8A16,$8A17,$8A18,$8A1B,$8A1D,$8A1E,$8A1F,$8A22,$8A23,$8A25,$8A27,$8A2A,
$8A2C,$8A2D,$8A30,$8A31,$8A34,$8A36,$8A39,$8A3A,$8A3B,$8A3C,$8A3E,$8A3F,$8A40,
$8A41,$8A44,$8A45,$8A46,$8A48,$8A4A,$8A4C,$8A4D,$8A4E,$8A4F,$8A50,$8A51,$8A52,
$8A54,$8A55,$8A56,$8A57,$8A58,$8A59,$8A5B,$8A5E,$8A60,$8A61,$8A62,$8A63,$8A66,
$8A68,$8A69,$8A6B,$8A6C,$8A6D,$8A6E,$8A70,$8A71,$8A72,$8A73,$8A74,$8A75,$8A76,
$8A77,$8A79,$8A7A,$8A7B,$8A7C,$8A7F,$8A81,$8A82,$8A83,$8A84,$8A85,$8A86,$8A87,
$8A8B,$8A8C,$8A8D,$8A8F,$8A91,$8A92,$8A93,$8A95,$8A96,$8A98,$8A99,$8A9A,$8A9E,
$8AA0,$8AA1,$8AA3,$8AA4,$8AA5,$8AA6,$8AA7,$8AA8,$8AAA,$8AAB,$8AB0,$8AB2,$8AB6,
$8AB8,$8AB9,$8ABA,$8ABB,$8ABC,$8ABD,$8ABE,$8ABF,$8AC0,$8AC2,$8AC3,$8AC4,$8AC5,
$8AC6,$8AC7,$8AC8,$8AC9,$8ACB,$8ACD,$8ACF,$8AD1,$8AD2,$8AD3,$8AD4,$8AD5,$8AD6,
$8AD7,$8AD8,$8AD9,$8ADB,$8ADC,$8ADD,$8ADE,$8ADF,$8AE0,$8AE1,$8AE2,$8AE4,$8AE6,
$8AE7,$8AE8,$8AEB,$8AED,$8AEE,$8AEF,$8AF0,$8AF1,$8AF2,$8AF3,$8AF4,$8AF5,$8AF6,
$8AF7,$8AF8,$8AFA,$8AFB,$8AFC,$8AFE,$8AFF,$8B00,$8B01,$8B02,$8B04,$8B05,$8B06,
$8B07,$8B08,$8B0A,$8B0B,$8B0D,$8B0E,$8B0F,$8B10,$8B11,$8B12,$8B13,$8B14,$8B15,
$8B16,$8B17,$8B18,$8B19,$8B1A,$8B1B,$8B1C,$8B1D,$8B1E,$8B20,$8B22,$8B23,$8B24,
$8B25,$8B26,$8B27,$8B28,$8B2A,$8B2B,$8B2C,$8B2E,$8B2F,$8B30,$8B31,$8B33,$8B35,
$8B36,$8B37,$8B39,$8B3A,$8B3B,$8B3C,$8B3D,$8B3E,$8B40,$8B41,$8B42,$8B45,$8B46,
$8B47,$8B48,$8B49,$8B4A,$8B4B,$8B4E,$8B4F,$8B50,$8B51,$8B52,$8B53,$8B54,$8B55,
$8B56,$8B57,$8B58,$8B59,$8B5A,$8B5C,$8B5D,$8B5F,$8B60,$8B63,$8B65,$8B66,$8B67,
$8B68,$8B6A,$8B6B,$8B6C,$8B6D,$8B6F,$8B70,$8B74,$8B77,$8B78,$8B79,$8B7A,$8B7B,
$8B7D,$8B7E,$8B7F,$8B80,$8B82,$8B84,$8B85,$8B86,$8B88,$8B8A,$8B8B,$8B8C,$8B8E,
$8B92,$8B93,$8B94,$8B95,$8B96,$8B98,$8B99,$8B9A,$8B9C,$8B9E,$8B9F,$8C37,$8C39,
$8C3B,$8C3C,$8C3D,$8C3E,$8C3F,$8C41,$8C42,$8C43,$8C45,$8C46,$8C47,$8C48,$8C49,
$8C4A,$8C4B,$8C4C,$8C4D,$8C4E,$8C4F,$8C50,$8C54,$8C55,$8C56,$8C57,$8C5A,$8C5C,
$8C5D,$8C5F,$8C61,$8C62,$8C64,$8C65,$8C66,$8C68,$8C69,$8C6A,$8C6B,$8C6C,$8C6D,
$8C6F,$8C70,$8C71,$8C72,$8C73,$8C75,$8C76,$8C77,$8C78,$8C79,$8C7A,$8C7B,$8C7D,
$8C80,$8C81,$8C82,$8C84,$8C85,$8C86,$8C89,$8C8A,$8C8C,$8C8D,$8C8F,$8C90,$8C91,
$8C92,$8C93,$8C94,$8C95,$8C97,$8C98,$8C99,$8C9A,$8C9C,$8C9D,$8C9E,$8CA0,$8CA1,
$8CA2,$8CA3,$8CA4,$8CA5,$8CA7,$8CA8,$8CA9,$8CAA,$8CAB,$8CAC,$8CAF,$8CB0,$8CB2,
$8CB3,$8CB4,$8CB5,$8CB6,$8CB7,$8CB8,$8CB9,$8CBA,$8CBB,$8CBC,$8CBD,$8CBE,$8CBF,
$8CC0,$8CC1,$8CC2,$8CC3,$8CC4,$8CC5,$8CC7,$8CC8,$8CCA,$8CCC,$8CCF,$8CD1,$8CD2,
$8CD3,$8CD5,$8CD7,$8CD9,$8CDA,$8CDC,$8CDD,$8CDE,$8CDF,$8CE0,$8CE1,$8CE2,$8CE3,
$8CE4,$8CE5,$8CE6,$8CE7,$8CE8,$8CEA,$8CEC,$8CED,$8CEE,$8CF0,$8CF1,$8CF3,$8CF4,
$8CF5,$8CF8,$8CF9,$8CFA,$8CFB,$8CFC,$8CFD,$8CFE,$8D00,$8D02,$8D04,$8D05,$8D06,
$8D07,$8D08,$8D09,$8D0A,$8D0D,$8D0F,$8D10,$8D13,$8D14,$8D15,$8D16,$8D17,$8D19,
$8D1B,$8D64,$8D66,$8D67,$8D68,$8D69,$8D6B,$8D6C,$8D6D,$8D6E,$8D6F,$8D70,$8D72,
$8D73,$8D74,$8D76,$8D77,$8D78,$8D79,$8D7B,$8D7D,$8D80,$8D81,$8D84,$8D85,$8D89,
$8D8A,$8D8C,$8D8D,$8D8E,$8D8F,$8D90,$8D91,$8D92,$8D93,$8D94,$8D95,$8D96,$8D99,
$8D9B,$8D9C,$8D9F,$8DA0,$8DA1,$8DA3,$8DA5,$8DA7,$8DA8,$8DAA,$8DAB,$8DAC,$8DAD,
$8DAE,$8DAF,$8DB2,$8DB3,$8DB4,$8DB5,$8DB6,$8DB7,$8DB9,$8DBA,$8DBC,$8DBE,$8DBF,
$8DC1,$8DC2,$8DC5,$8DC6,$8DC7,$8DC8,$8DCB,$8DCC,$8DCD,$8DCE,$8DCF,$8DD0,$8DD1,
$8DD3,$8DD5,$8DD6,$8DD7,$8DD8,$8DD9,$8DDA,$8DDB,$8DDC,$8DDD,$8DDF,$8DE0,$8DE1,
$8DE2,$8DE3,$8DE4,$8DE6,$8DE7,$8DE8,$8DE9,$8DEA,$8DEB,$8DEC,$8DEE,$8DEF,$8DF0,
$8DF1,$8DF2,$8DF3,$8DF4,$8DFA,$8DFC,$8DFD,$8DFE,$8DFF,$8E00,$8E02,$8E03,$8E04,
$8E05,$8E06,$8E07,$8E09,$8E0A,$8E0D,$8E0F,$8E10,$8E11,$8E12,$8E13,$8E14,$8E15,
$8E16,$8E17,$8E18,$8E19,$8E1A,$8E1B,$8E1C,$8E1D,$8E1E,$8E1F,$8E20,$8E21,$8E22,
$8E23,$8E24,$8E25,$8E26,$8E27,$8E29,$8E2B,$8E2E,$8E30,$8E31,$8E33,$8E34,$8E35,
$8E36,$8E38,$8E39,$8E3C,$8E3D,$8E3E,$8E3F,$8E40,$8E41,$8E42,$8E44,$8E45,$8E47,
$8E48,$8E49,$8E4A,$8E4B,$8E4C,$8E4D,$8E4E,$8E50,$8E53,$8E54,$8E55,$8E56,$8E57,
$8E59,$8E5A,$8E5B,$8E5C,$8E5D,$8E5E,$8E5F,$8E60,$8E61,$8E62,$8E63,$8E64,$8E65,
$8E66,$8E67,$8E69,$8E6A,$8E6C,$8E6D,$8E6F,$8E72,$8E73,$8E74,$8E76,$8E78,$8E7A,
$8E7B,$8E7C,$8E81,$8E82,$8E84,$8E85,$8E86,$8E87,$8E88,$8E89,$8E8A,$8E8B,$8E8C,
$8E8D,$8E8E,$8E90,$8E91,$8E92,$8E93,$8E94,$8E95,$8E96,$8E97,$8E98,$8E9A,$8E9D,
$8E9E,$8E9F,$8EA0,$8EA1,$8EA3,$8EA4,$8EA5,$8EA6,$8EA8,$8EA9,$8EAA,$8EAB,$8EAC,
$8EB2,$8EBA,$8EBD,$8EC0,$8EC2,$8EC9,$8ECA,$8ECB,$8ECC,$8ECD,$8ECF,$8ED1,$8ED2,
$8ED3,$8ED4,$8ED7,$8ED8,$8EDB,$8EDC,$8EDD,$8EDE,$8EDF,$8EE0,$8EE1,$8EE5,$8EE6,
$8EE7,$8EE8,$8EE9,$8EEB,$8EEC,$8EEE,$8EEF,$8EF1,$8EF4,$8EF5,$8EF6,$8EF7,$8EF8,
$8EF9,$8EFA,$8EFB,$8EFC,$8EFE,$8EFF,$8F00,$8F01,$8F02,$8F03,$8F05,$8F06,$8F07,
$8F08,$8F09,$8F0A,$8F0B,$8F0D,$8F0E,$8F10,$8F11,$8F12,$8F13,$8F14,$8F15,$8F16,
$8F17,$8F18,$8F1A,$8F1B,$8F1C,$8F1D,$8F1E,$8F1F,$8F20,$8F23,$8F24,$8F25,$8F26,
$8F29,$8F2A,$8F2C,$8F2E,$8F2F,$8F32,$8F33,$8F34,$8F35,$8F36,$8F37,$8F38,$8F39,
$8F3B,$8F3E,$8F3F,$8F40,$8F42,$8F43,$8F44,$8F45,$8F46,$8F47,$8F48,$8F49,$8F4B,
$8F4D,$8F4E,$8F4F,$8F50,$8F51,$8F52,$8F53,$8F54,$8F55,$8F56,$8F57,$8F58,$8F59,
$8F5A,$8F5B,$8F5D,$8F5E,$8F5F,$8F60,$8F61,$8F62,$8F63,$8F64,$8F9B,$8F9C,$8F9F,
$8FA3,$8FA6,$8FA8,$8FAD,$8FAE,$8FAF,$8FB0,$8FB1,$8FB2,$8FB4,$8FBF,$8FC2,$8FC4,
$8FC5,$8FC6,$8FC9,$8FCB,$8FCD,$8FCE,$8FD1,$8FD2,$8FD3,$8FD4,$8FD5,$8FD6,$8FD7,
$8FE0,$8FE1,$8FE2,$8FE3,$8FE4,$8FE5,$8FE6,$8FE8,$8FEA,$8FEB,$8FED,$8FEE,$8FF0,
$8FF4,$8FF5,$8FF6,$8FF7,$8FF8,$8FFA,$8FFB,$8FFC,$8FFD,$8FFE,$8FFF,$9000,$9001,
$9002,$9003,$9004,$9005,$9006,$900B,$900C,$900D,$900F,$9010,$9011,$9014,$9015,
$9016,$9017,$9019,$901A,$901B,$901C,$901D,$901E,$901F,$9020,$9021,$9022,$9023,
$9024,$902D,$902E,$902F,$9031,$9032,$9034,$9035,$9036,$9038,$903C,$903D,$903E,
$903F,$9041,$9042,$9044,$9047,$9049,$904A,$904B,$904D,$904E,$904F,$9050,$9051,
$9052,$9053,$9054,$9055,$9058,$9059,$905B,$905C,$905D,$905E,$9060,$9062,$9063,
$9067,$9068,$9069,$906B,$906D,$906E,$906F,$9070,$9072,$9073,$9074,$9075,$9076,
$9077,$9078,$9079,$907A,$907B,$907C,$907D,$907E,$907F,$9080,$9081,$9082,$9083,
$9084,$9085,$9086,$9087,$9088,$908A,$908B,$908D,$908F,$9090,$9091,$9094,$9095,
$9097,$9098,$9099,$909B,$909E,$909F,$90A0,$90A1,$90A2,$90A3,$90A5,$90A6,$90A7,
$90AA,$90AF,$90B0,$90B1,$90B2,$90B3,$90B4,$90B5,$90B6,$90B8,$90BD,$90BE,$90BF,
$90C1,$90C3,$90C5,$90C7,$90C8,$90CA,$90CB,$90CE,$90D4,$90D5,$90D6,$90D7,$90D8,
$90D9,$90DA,$90DB,$90DC,$90DD,$90DF,$90E0,$90E1,$90E2,$90E3,$90E4,$90E5,$90E8,
$90E9,$90EA,$90EB,$90EC,$90ED,$90EF,$90F0,$90F1,$90F2,$90F3,$90F4,$90F5,$90F9,
$90FA,$90FB,$90FC,$90FD,$90FE,$90FF,$9100,$9101,$9102,$9103,$9104,$9105,$9106,
$9107,$9108,$9109,$910B,$910D,$910E,$910F,$9110,$9111,$9112,$9114,$9116,$9117,
$9118,$9119,$911A,$911B,$911C,$911D,$911E,$911F,$9120,$9121,$9122,$9123,$9124,
$9126,$9127,$9128,$9129,$912A,$912B,$912C,$912D,$912E,$912F,$9130,$9131,$9132,
$9133,$9134,$9135,$9136,$9138,$9139,$913A,$913B,$913E,$913F,$9140,$9141,$9143,
$9144,$9145,$9146,$9147,$9148,$9149,$914A,$914B,$914C,$914D,$914E,$914F,$9150,
$9152,$9153,$9155,$9156,$9157,$9158,$915A,$915F,$9160,$9161,$9162,$9163,$9164,
$9165,$9168,$9169,$916A,$916C,$916E,$916F,$9172,$9173,$9174,$9175,$9177,$9178,
$9179,$917A,$9180,$9181,$9182,$9183,$9184,$9185,$9186,$9187,$9189,$918A,$918B,
$918D,$918F,$9190,$9191,$9192,$9193,$9199,$919A,$919B,$919C,$919D,$919E,$919F,
$91A0,$91A1,$91A2,$91A3,$91A5,$91A7,$91A8,$91AA,$91AB,$91AC,$91AD,$91AE,$91AF,
$91B0,$91B1,$91B2,$91B3,$91B4,$91B5,$91B7,$91B9,$91BA,$91BC,$91BD,$91BE,$91C0,
$91C1,$91C2,$91C3,$91C5,$91C6,$91C7,$91C9,$91CB,$91CC,$91CD,$91CE,$91CF,$91D0,
$91D1,$91D3,$91D4,$91D5,$91D7,$91D8,$91D9,$91DA,$91DC,$91DD,$91E2,$91E3,$91E4,
$91E6,$91E7,$91E8,$91E9,$91EA,$91EB,$91EC,$91ED,$91EE,$91F1,$91F3,$91F4,$91F5,
$91F7,$91F8,$91F9,$91FD,$91FF,$9200,$9201,$9202,$9203,$9204,$9205,$9206,$9207,
$9209,$920A,$920C,$920D,$920F,$9210,$9211,$9212,$9214,$9215,$9216,$9217,$9219,
$921A,$921C,$921E,$9223,$9224,$9225,$9226,$9227,$922D,$922E,$9230,$9231,$9232,
$9233,$9234,$9236,$9237,$9238,$9239,$923A,$923D,$923E,$923F,$9240,$9245,$9246,
$9248,$9249,$924A,$924B,$924C,$924D,$924E,$924F,$9250,$9251,$9252,$9253,$9254,
$9256,$9257,$925A,$925B,$925E,$9260,$9261,$9263,$9264,$9265,$9266,$9267,$926C,
$926D,$926F,$9270,$9272,$9276,$9278,$9279,$927A,$927B,$927C,$927D,$927E,$927F,
$9280,$9282,$9283,$9285,$9286,$9287,$9288,$928A,$928B,$928C,$928D,$928E,$9291,
$9293,$9294,$9295,$9296,$9297,$9298,$9299,$929A,$929B,$929C,$929D,$92A0,$92A1,
$92A2,$92A3,$92A4,$92A5,$92A6,$92A7,$92A8,$92A9,$92AA,$92AB,$92AC,$92B2,$92B3,
$92B4,$92B5,$92B6,$92B7,$92B9,$92BB,$92BC,$92C0,$92C1,$92C2,$92C3,$92C4,$92C5,
$92C6,$92C7,$92C8,$92C9,$92CA,$92CB,$92CC,$92CD,$92CE,$92CF,$92D0,$92D1,$92D2,
$92D3,$92D5,$92D7,$92D8,$92D9,$92DD,$92DE,$92DF,$92E0,$92E1,$92E4,$92E6,$92E7,
$92E8,$92E9,$92EA,$92EE,$92EF,$92F0,$92F1,$92F7,$92F8,$92F9,$92FA,$92FB,$92FC,
$92FE,$92FF,$9300,$9301,$9302,$9304,$9306,$9308,$9309,$930B,$930C,$930D,$930E,
$930F,$9310,$9312,$9313,$9314,$9315,$9316,$9318,$9319,$931A,$931B,$931D,$931E,
$931F,$9320,$9321,$9322,$9323,$9324,$9325,$9326,$9327,$9328,$9329,$932A,$932B,
$932D,$932E,$932F,$9333,$9334,$9335,$9336,$9338,$9339,$933C,$9346,$9347,$9349,
$934A,$934B,$934C,$934D,$934E,$934F,$9350,$9351,$9352,$9354,$9355,$9356,$9357,
$9358,$9359,$935A,$935B,$935C,$935E,$9360,$9361,$9363,$9364,$9365,$9367,$936A,
$936C,$936D,$9370,$9371,$9375,$9376,$9377,$9379,$937A,$937B,$937C,$937E,$9380,
$9382,$9383,$9388,$9389,$938A,$938C,$938D,$938E,$938F,$9391,$9392,$9394,$9395,
$9396,$9397,$9398,$9399,$939A,$939B,$939D,$939E,$939F,$93A1,$93A2,$93A3,$93A4,
$93A5,$93A6,$93A7,$93A8,$93A9,$93AA,$93AC,$93AE,$93AF,$93B0,$93B1,$93B2,$93B3,
$93B4,$93B5,$93B7,$93C0,$93C2,$93C3,$93C4,$93C7,$93C8,$93CA,$93CC,$93CD,$93CE,
$93CF,$93D0,$93D1,$93D2,$93D4,$93D5,$93D6,$93D7,$93D8,$93D9,$93DA,$93DC,$93DD,
$93DE,$93DF,$93E1,$93E2,$93E3,$93E4,$93E6,$93E7,$93E8,$93EC,$93EE,$93F5,$93F6,
$93F7,$93F8,$93F9,$93FA,$93FB,$93FC,$93FD,$93FE,$93FF,$9400,$9403,$9406,$9407,
$9409,$940A,$940B,$940C,$940D,$940E,$940F,$9410,$9411,$9412,$9413,$9414,$9415,
$9416,$9418,$9419,$9420,$9428,$9429,$942A,$942B,$942C,$942E,$9430,$9431,$9432,
$9433,$9435,$9436,$9437,$9438,$9439,$943A,$943B,$943C,$943D,$943F,$9440,$9444,
$9445,$9446,$9447,$9448,$9449,$944A,$944B,$944C,$944F,$9450,$9451,$9452,$9455,
$9457,$945D,$945E,$9460,$9462,$9463,$9464,$9468,$9469,$946A,$946B,$946D,$946E,
$946F,$9470,$9471,$9472,$9473,$9474,$9475,$9476,$9477,$9478,$947C,$947D,$947E,
$947F,$9480,$9481,$9482,$9483,$9577,$957A,$957B,$957C,$957D,$9580,$9582,$9583,
$9586,$9588,$9589,$958B,$958C,$958D,$958E,$958F,$9590,$9591,$9592,$9593,$9594,
$9598,$959B,$959C,$959E,$959F,$95A1,$95A3,$95A4,$95A5,$95A8,$95A9,$95AB,$95AC,
$95AD,$95AE,$95B0,$95B1,$95B5,$95B6,$95B7,$95B9,$95BA,$95BB,$95BC,$95BD,$95BE,
$95BF,$95C0,$95C3,$95C5,$95C6,$95C7,$95C8,$95C9,$95CA,$95CB,$95CC,$95CD,$95D0,
$95D1,$95D2,$95D3,$95D4,$95D5,$95D6,$95DA,$95DB,$95DC,$95DE,$95DF,$95E0,$95E1,
$95E2,$95E3,$95E4,$95E5,$961C,$961E,$9620,$9621,$9622,$9623,$9624,$9628,$962A,
$962C,$962D,$962E,$962F,$9630,$9631,$9632,$9639,$963A,$963B,$963C,$963D,$963F,
$9640,$9642,$9643,$9644,$964A,$964B,$964C,$964D,$964E,$964F,$9650,$9651,$9653,
$9654,$9658,$965B,$965C,$965D,$965E,$965F,$9661,$9662,$9663,$9664,$966A,$966B,
$966C,$966D,$966F,$9670,$9671,$9672,$9673,$9674,$9675,$9676,$9677,$9678,$967C,
$967D,$967E,$9680,$9683,$9684,$9685,$9686,$9687,$9688,$9689,$968A,$968B,$968D, 
$968E,$9691,$9692,$9693,$9694,$9695,$9697,$9698,$9699,$969B,$969C,$969E,$96A1,
$96A2,$96A4,$96A7,$96A8,$96A9,$96AA,$96AC,$96AE,$96B0,$96B1,$96B3,$96B4,$96B8,
$96B9,$96BB,$96BC,$96BF,$96C0,$96C1,$96C2,$96C3,$96C4,$96C5,$96C6,$96C7,$96C8,
$96C9,$96CA,$96CB,$96CC,$96CD,$96CE,$96D2,$96D3,$96D4,$96D5,$96D6,$96D7,$96D8,
$96D9,$96DA,$96DB,$96DC,$96DD,$96DE,$96DF,$96E1,$96E2,$96E3,$96E5,$96E8,$96E9,
$96EA,$96EF,$96F0,$96F1,$96F2,$96F5,$96F6,$96F7,$96F8,$96F9,$96FA,$96FB,$96FD,
$96FF,$9700,$9702,$9704,$9705,$9706,$9707,$9708,$9709,$970B,$970D,$970E,$970F,
$9710,$9711,$9712,$9713,$9716,$9718,$9719,$971C,$971D,$971E,$971F,$9720,$9722,
$9723,$9724,$9725,$9726,$9727,$9728,$9729,$972A,$972B,$972C,$972E,$972F,$9730,
$9732,$9735,$9738,$9739,$973A,$973D,$973E,$973F,$9742,$9743,$9744,$9746,$9747,
$9748,$9749,$974B,$9752,$9756,$9758,$975A,$975B,$975C,$975E,$9760,$9761,$9762,
$9766,$9768,$9769,$976A,$976C,$976E,$9770,$9772,$9773,$9774,$9776,$9777,$9778,
$977A,$977B,$977C,$977D,$977E,$977F,$9780,$9781,$9782,$9783,$9784,$9785,$9788,
$978A,$978B,$978D,$978E,$978F,$9794,$9797,$9798,$9799,$979A,$979C,$979D,$979E,
$97A0,$97A1,$97A2,$97A3,$97A4,$97A5,$97A6,$97A8,$97AA,$97AB,$97AC,$97AD,$97AE,
$97B3,$97B6,$97B7,$97B9,$97BB,$97BF,$97C1,$97C3,$97C4,$97C5,$97C6,$97C7,$97C9,
$97CB,$97CC,$97CD,$97CE,$97CF,$97D0,$97D3,$97D4,$97D5,$97D6,$97D7,$97D8,$97D9,
$97DC,$97DD,$97DE,$97DF,$97E1,$97E3,$97E5,$97ED,$97F0,$97F1,$97F3,$97F6,$97F8,
$97F9,$97FA,$97FB,$97FD,$97FE,$97FF,$9800,$9801,$9802,$9803,$9804,$9805,$9806,
$9807,$9808,$980A,$980C,$980D,$980E,$980F,$9810,$9811,$9812,$9813,$9816,$9817,
$9818,$981B,$981C,$981D,$981E,$9820,$9821,$9824,$9826,$9827,$9828,$9829,$982B,
$982D,$982F,$9830,$9832,$9835,$9837,$9838,$9839,$983B,$9841,$9843,$9844,$9845,
$9846,$9848,$9849,$984A,$984C,$984D,$984E,$984F,$9850,$9851,$9852,$9853,$9857,
$9858,$9859,$985B,$985C,$985D,$985E,$985F,$9860,$9862,$9863,$9864,$9865,$9867,
$9869,$986A,$986B,$986F,$9870,$9871,$9872,$9873,$9874,$98A8,$98A9,$98AC,$98AD,
$98AE,$98AF,$98B1,$98B2,$98B3,$98B6,$98B8,$98BA,$98BB,$98BC,$98BD,$98BE,$98BF,
$98C0,$98C1,$98C2,$98C4,$98C6,$98C9,$98CB,$98CC,$98DB,$98DF,$98E2,$98E3,$98E5,
$98E7,$98E9,$98EA,$98EB,$98ED,$98EF,$98F2,$98F4,$98F6,$98F9,$98FA,$98FC,$98FD,
$98FE,$9900,$9902,$9903,$9905,$9907,$9908,$9909,$990A,$990C,$9910,$9911,$9912,
$9913,$9914,$9915,$9916,$9917,$9918,$991A,$991B,$991E,$991F,$9921,$9924,$9925,
$9927,$9928,$9929,$992A,$992B,$992C,$992D,$992E,$992F,$9930,$9931,$9932,$9933,
$9935,$993A,$993C,$993D,$993E,$993F,$9941,$9943,$9945,$9947,$9948,$9949,$994B,
$994C,$994E,$9950,$9951,$9952,$9953,$9954,$9955,$9956,$9957,$9958,$9959,$995B,
$995C,$995E,$995F,$9961,$9996,$9997,$9998,$9999,$999C,$999D,$999E,$99A1,$99A3,
$99A5,$99A6,$99A7,$99A8,$99AB,$99AC,$99AD,$99AE,$99AF,$99B0,$99B1,$99B2,$99B3,
$99B4,$99B5,$99B9,$99BA,$99BB,$99BD,$99C1,$99C2,$99C3,$99C7,$99C9,$99CB,$99CC,
$99CD,$99CE,$99CF,$99D0,$99D1,$99D2,$99D3,$99D4,$99D5,$99D6,$99D7,$99D8,$99D9,
$99DB,$99DC,$99DD,$99DF,$99E2,$99E3,$99E4,$99E5,$99E7,$99E9,$99EA,$99EC,$99ED,
$99EE,$99F0,$99F1,$99F4,$99F6,$99F7,$99F8,$99F9,$99FA,$99FB,$99FC,$99FD,$99FE,
$99FF,$9A01,$9A02,$9A03,$9A04,$9A05,$9A06,$9A07,$9A09,$9A0A,$9A0B,$9A0D,$9A0E,
$9A0F,$9A11,$9A14,$9A15,$9A16,$9A19,$9A1A,$9A1B,$9A1C,$9A1D,$9A1E,$9A20,$9A22,
$9A23,$9A24,$9A25,$9A27,$9A29,$9A2A,$9A2B,$9A2C,$9A2D,$9A2E,$9A30,$9A31,$9A32,
$9A34,$9A35,$9A36,$9A37,$9A38,$9A39,$9A3A,$9A3D,$9A3E,$9A3F,$9A40,$9A41,$9A42,
$9A43,$9A44,$9A45,$9A46,$9A48,$9A49,$9A4A,$9A4C,$9A4D,$9A4E,$9A4F,$9A50,$9A52,
$9A53,$9A54,$9A55,$9A56,$9A57,$9A59,$9A5A,$9A5B,$9A5E,$9A5F,$9A60,$9A62,$9A64,
$9A65,$9A66,$9A67,$9A68,$9A69,$9A6A,$9A6B,$9AA8,$9AAB,$9AAD,$9AAF,$9AB0,$9AB1,
$9AB3,$9AB4,$9AB7,$9AB8,$9AB9,$9ABB,$9ABC,$9ABE,$9ABF,$9AC0,$9AC1,$9AC2,$9AC6,
$9AC7,$9ACA,$9ACD,$9ACF,$9AD0,$9AD1,$9AD2,$9AD3,$9AD4,$9AD5,$9AD6,$9AD8,$9ADC,
$9ADF,$9AE1,$9AE3,$9AE6,$9AE7,$9AEB,$9AEC,$9AED,$9AEE,$9AEF,$9AF1,$9AF2,$9AF3,
$9AF6,$9AF7,$9AF9,$9AFA,$9AFB,$9AFC,$9AFD,$9AFE,$9B01,$9B03,$9B04,$9B05,$9B06,
$9B08,$9B0A,$9B0B,$9B0C,$9B0D,$9B0E,$9B10,$9B11,$9B12,$9B15,$9B16,$9B17,$9B18,
$9B19,$9B1A,$9B1E,$9B1F,$9B20,$9B22,$9B23,$9B24,$9B25,$9B27,$9B28,$9B29,$9B2B,
$9B2E,$9B2F,$9B31,$9B32,$9B33,$9B35,$9B37,$9B3A,$9B3B,$9B3C,$9B3E,$9B3F,$9B41,
$9B42,$9B43,$9B44,$9B45,$9B46,$9B48,$9B4A,$9B4B,$9B4C,$9B4D,$9B4E,$9B4F,$9B51,
$9B52,$9B54,$9B55,$9B56,$9B58,$9B59,$9B5A,$9B5B,$9B5F,$9B60,$9B61,$9B64,$9B66,
$9B67,$9B68,$9B6C,$9B6F,$9B70,$9B71,$9B74,$9B75,$9B76,$9B77,$9B7A,$9B7B,$9B7C,
$9B7D,$9B7E,$9B80,$9B82,$9B85,$9B86,$9B87,$9B88,$9B90,$9B91,$9B92,$9B93,$9B95,
$9B9A,$9B9B,$9B9E,$9BA0,$9BA1,$9BA2,$9BA4,$9BA5,$9BA6,$9BA8,$9BAA,$9BAB,$9BAD,
$9BAE,$9BAF,$9BB5,$9BB6,$9BB8,$9BB9,$9BBD,$9BBF,$9BC0,$9BC1,$9BC3,$9BC4,$9BC6,
$9BC7,$9BC8,$9BC9,$9BCA,$9BD3,$9BD4,$9BD5,$9BD6,$9BD7,$9BD9,$9BDA,$9BDB,$9BDC,
$9BDE,$9BE0,$9BE1,$9BE2,$9BE4,$9BE5,$9BE6,$9BE7,$9BE8,$9BEA,$9BEB,$9BEC,$9BF0,
$9BF7,$9BF8,$9BFD,$9C05,$9C06,$9C07,$9C08,$9C09,$9C0B,$9C0D,$9C0E,$9C12,$9C13,
$9C14,$9C17,$9C1C,$9C1D,$9C21,$9C23,$9C24,$9C25,$9C28,$9C29,$9C2B,$9C2C,$9C2D,
$9C31,$9C32,$9C33,$9C34,$9C36,$9C37,$9C39,$9C3B,$9C3C,$9C3D,$9C3E,$9C3F,$9C40,
$9C41,$9C44,$9C46,$9C48,$9C49,$9C4A,$9C4B,$9C4C,$9C4D,$9C4E,$9C50,$9C52,$9C54,
$9C55,$9C56,$9C57,$9C58,$9C59,$9C5E,$9C5F,$9C60,$9C62,$9C63,$9C66,$9C67,$9C68,
$9C6D,$9C6E,$9C71,$9C73,$9C74,$9C75,$9C77,$9C78,$9C79,$9C7A,$9CE5,$9CE6,$9CE7,
$9CE9,$9CEA,$9CED,$9CF1,$9CF2,$9CF3,$9CF4,$9CF5,$9CF6,$9CF7,$9CF9,$9CFA,$9CFB,
$9CFC,$9CFD,$9CFF,$9D00,$9D03,$9D04,$9D05,$9D06,$9D07,$9D08,$9D09,$9D10,$9D12,
$9D14,$9D15,$9D17,$9D18,$9D19,$9D1B,$9D1D,$9D1E,$9D1F,$9D20,$9D22,$9D23,$9D25,
$9D26,$9D28,$9D29,$9D2D,$9D2E,$9D2F,$9D30,$9D31,$9D33,$9D36,$9D37,$9D38,$9D3B,
$9D3D,$9D3E,$9D3F,$9D40,$9D41,$9D42,$9D43,$9D45,$9D4A,$9D4B,$9D4C,$9D4F,$9D51,
$9D52,$9D53,$9D54,$9D56,$9D57,$9D58,$9D59,$9D5A,$9D5B,$9D5C,$9D5D,$9D5F,$9D60,
$9D61,$9D67,$9D68,$9D69,$9D6A,$9D6B,$9D6C,$9D6F,$9D70,$9D71,$9D72,$9D73,$9D74,
$9D75,$9D77,$9D78,$9D79,$9D7B,$9D7D,$9D7F,$9D80,$9D81,$9D82,$9D84,$9D85,$9D86,
$9D87,$9D88,$9D89,$9D8A,$9D8B,$9D8C,$9D90,$9D92,$9D94,$9D96,$9D97,$9D98,$9D99,
$9D9A,$9D9B,$9D9C,$9D9D,$9D9E,$9D9F,$9DA0,$9DA1,$9DA2,$9DA3,$9DA4,$9DA6,$9DA7,
$9DA8,$9DA9,$9DAA,$9DAC,$9DAD,$9DAF,$9DB1,$9DB2,$9DB3,$9DB4,$9DB5,$9DB6,$9DB7,
$9DB8,$9DB9,$9DBA,$9DBB,$9DBC,$9DBE,$9DBF,$9DC1,$9DC2,$9DC3,$9DC5,$9DC7,$9DC8,
$9DCA,$9DCB,$9DCC,$9DCD,$9DCE,$9DCF,$9DD0,$9DD1,$9DD2,$9DD3,$9DD5,$9DD6,$9DD7,
$9DD8,$9DD9,$9DDA,$9DDB,$9DDC,$9DDD,$9DDE,$9DDF,$9DE1,$9DE2,$9DE3,$9DE4,$9DE5,
$9DE6,$9DE8,$9DE9,$9DEB,$9DEC,$9DED,$9DEE,$9DEF,$9DF0,$9DF2,$9DF3,$9DF4,$9DF5,
$9DF6,$9DF7,$9DF8,$9DF9,$9DFA,$9DFB,$9DFD,$9DFE,$9DFF,$9E00,$9E01,$9E02,$9E03,
$9E04,$9E05,$9E06,$9E07,$9E09,$9E0B,$9E0D,$9E0F,$9E10,$9E11,$9E12,$9E13,$9E14,
$9E15,$9E17,$9E19,$9E1A,$9E1B,$9E1D,$9E1E,$9E75,$9E79,$9E7A,$9E7C,$9E7D,$9E7F,
$9E80,$9E82,$9E83,$9E86,$9E87,$9E88,$9E89,$9E8A,$9E8B,$9E8C,$9E8D,$9E8E,$9E91,
$9E92,$9E93,$9E94,$9E97,$9E99,$9E9A,$9E9B,$9E9C,$9E9D,$9E9F,$9EA0,$9EA1,$9EA4,
$9EA5,$9EA7,$9EA9,$9EAD,$9EAE,$9EB0,$9EB4,$9EB5,$9EB6,$9EB7,$9EBB,$9EBC,$9EBE,
$9EC0,$9EC2,$9EC3,$9EC8,$9ECC,$9ECD,$9ECE,$9ECF,$9ED0,$9ED1,$9ED3,$9ED4,$9ED5,
$9ED6,$9ED8,$9EDA,$9EDB,$9EDC,$9EDD,$9EDE,$9EDF,$9EE0,$9EE4,$9EE5,$9EE6,$9EE7,
$9EE8,$9EEB,$9EED,$9EEE,$9EEF,$9EF0,$9EF2,$9EF3,$9EF4,$9EF5,$9EF6,$9EF7,$9EF9,
$9EFA,$9EFB,$9EFC,$9EFD,$9EFF,$9F00,$9F01,$9F06,$9F07,$9F09,$9F0A,$9F0E,$9F0F,
$9F10,$9F12,$9F13,$9F15,$9F16,$9F18,$9F19,$9F1A,$9F1B,$9F1C,$9F1E,$9F20,$9F22,
$9F23,$9F24,$9F25,$9F28,$9F29,$9F2A,$9F2B,$9F2C,$9F2D,$9F2E,$9F2F,$9F30,$9F31,
$9F32,$9F33,$9F34,$9F35,$9F36,$9F37,$9F38,$9F3B,$9F3D,$9F3E,$9F40,$9F41,$9F42,
$9F43,$9F46,$9F47,$9F48,$9F49,$9F4A,$9F4B,$9F4C,$9F4D,$9F4E,$9F4F,$9F52,$9F54,
$9F55,$9F56,$9F57,$9F58,$9F59,$9F5B,$9F5C,$9F5D,$9F5E,$9F5F,$9F60,$9F61,$9F63,
$9F64,$9F65,$9F66,$9F67,$9F6A,$9F6B,$9F6C,$9F6E,$9F6F,$9F70,$9F71,$9F72,$9F74,
$9F75,$9F76,$9F77,$9F78,$9F79,$9F7A,$9F7B,$9F7E,$9F8D,$9F90,$9F91,$9F92,$9F94,
$9F95,$9F98,$9F9C,$9FA0,$9FA2,$9FA4,$FA0C,$FA0D,$FE30,$FE31,$FE33,$FE34,$FE35,
$FE36,$FE37,$FE38,$FE39,$FE3A,$FE3B,$FE3C,$FE3D,$FE3E,$FE3F,$FE40,$FE41,$FE42,
$FE43,$FE44,$FE49,$FE4A,$FE4B,$FE4C,$FE4D,$FE4E,$FE4F,$FE50,$FE51,$FE52,$FE54,
$FE55,$FE56,$FE57,$FE59,$FE5A,$FE5B,$FE5C,$FE5D,$FE5E,$FE5F,$FE60,$FE61,$FE62,
$FE63,$FE64,$FE65,$FE66,$FE68,$FE69,$FE6A,$FE6B,$FF01,$FF03,$FF04,$FF05,$FF06,
$FF08,$FF09,$FF0A,$FF0B,$FF0C,$FF0D,$FF0E,$FF0F,$FF10,$FF11,$FF12,$FF13,$FF14,
$FF15,$FF16,$FF17,$FF18,$FF19,$FF1A,$FF1B,$FF1C,$FF1D,$FF1E,$FF1F,$FF20,$FF21,
$FF22,$FF23,$FF24,$FF25,$FF26,$FF27,$FF28,$FF29,$FF2A,$FF2B,$FF2C,$FF2D,$FF2E,
$FF2F,$FF30,$FF31,$FF32,$FF33,$FF34,$FF35,$FF36,$FF37,$FF38,$FF39,$FF3A,$FF3C,
$FF3F,$FF41,$FF42,$FF43,$FF44,$FF45,$FF46,$FF47,$FF48,$FF49,$FF4A,$FF4B,$FF4C,
$FF4D,$FF4E,$FF4F,$FF50,$FF51,$FF52,$FF53,$FF54,$FF55,$FF56,$FF57,$FF58,$FF59,
$FF5A,$FF5B,$FF5C,$FF5D,$FF5E,$FFE0,$FFE1,$FFE3,$FFE5);
{$endif}

const CP949CC: CP949Arr =
($00,$01,$02,$03,$04,$05,$06,$07,$08,$09,$0A,$0B,$0C,$0D,$0E,$0F,$10,$11,$12,
$13,$14,$15,$16,$17,$18,$19,$1A,$1B,$1C,$1D,$1E,$1F,$20,$21,$22,$23,$24,$25,
$26,$27,$28,$29,$2A,$2B,$2C,$2D,$2E,$2F,$30,$31,$32,$33,$34,$35,$36,$37,$38,
$39,$3A,$3B,$3C,$3D,$3E,$3F,$40,$41,$42,$43,$44,$45,$46,$47,$48,$49,$4A,$4B,
$4C,$4D,$4E,$4F,$50,$51,$52,$53,$54,$55,$56,$57,$58,$59,$5A,$5B,$5C,$5D,$5E,
$5F,$60,$61,$62,$63,$64,$65,$66,$67,$68,$69,$6A,$6B,$6C,$6D,$6E,$6F,$70,$71,
$72,$73,$74,$75,$76,$77,$78,$79,$7A,$7B,$7C,$7D,$7E,$7F,$80,$81,$82,$83,$84,
$85,$86,$87,$88,$89,$8A,$8B,$8C,$8D,$8E,$8F,$90,$91,$92,$93,$94,$95,$96,$97,
$98,$99,$9A,$9B,$9C,$9D,$9E,$9F,$A0,$A1,$A2,$A3,$A4,$A5,$A6,$A7,$A8,$A9,$AA,
$AB,$AC,$AD,$AE,$AF,$B0,$B1,$B2,$B3,$B4,$B5,$B6,$B7,$B8,$B9,$BA,$BB,$BC,$BD,
$BE,$BF,$C0,$C1,$C2,$C3,$C4,$C5,$C6,$C7,$C8,$C9,$CA,$CB,$CC,$CD,$CE,$CF,$D0,
$D1,$D2,$D3,$D4,$D5,$D6,$D7,$D8,$D9,$DA,$DB,$DC,$DD,$DE,$DF,$E0,$E1,$E2,$E3,
$E4,$E5,$E6,$E7,$E8,$E9,$EA,$EB,$EC,$ED,$EE,$EF,$F0,$F1,$F2,$F3,$F4,$F5,$F6,
$F7,$F8,$F9,$FA,$FB,$FC,$FD,$FE,$FF,$8141,$8142,$8143,$8144,$8145,$8146,$8147,
$8148,$8149,$814A,$814B,$814C,$814D,$814E,$814F,$8150,$8151,$8152,$8153,$8154,
$8155,$8156,$8157,$8158,$8159,$815A,$8161,$8162,$8163,$8164,$8165,$8166,$8167,
$8168,$8169,$816A,$816B,$816C,$816D,$816E,$816F,$8170,$8171,$8172,$8173,$8174,
$8175,$8176,$8177,$8178,$8179,$817A,$8181,$8182,$8183,$8184,$8185,$8186,$8187,
$8188,$8189,$818A,$818B,$818C,$818D,$818E,$818F,$8190,$8191,$8192,$8193,$8194,
$8195,$8196,$8197,$8198,$8199,$819A,$819B,$819C,$819D,$819E,$819F,$81A0,$81A1,
$81A2,$81A3,$81A4,$81A5,$81A6,$81A7,$81A8,$81A9,$81AA,$81AB,$81AC,$81AD,$81AE,
$81AF,$81B0,$81B1,$81B2,$81B3,$81B4,$81B5,$81B6,$81B7,$81B8,$81B9,$81BA,$81BB,
$81BC,$81BD,$81BE,$81BF,$81C0,$81C1,$81C2,$81C3,$81C4,$81C5,$81C6,$81C7,$81C8,
$81C9,$81CA,$81CB,$81CC,$81CD,$81CE,$81CF,$81D0,$81D1,$81D2,$81D3,$81D4,$81D5,
$81D6,$81D7,$81D8,$81D9,$81DA,$81DB, $81DC,$81DD,$81DE,$81DF,$81E0,$81E1,$81E2,
$81E3,$81E4,$81E5,$81E6,$81E7,$81E8,$81E9,$81EA,$81EB,$81EC,$81ED,$81EE,$81EF,
$81F0,$81F1,$81F2,$81F3,$81F4,$81F5,$81F6,$81F7,$81F8,$81F9,$81FA,$81FB,$81FC,
$81FD,$81FE,$8241,$8242,$8243,$8244,$8245,$8246,$8247,$8248,$8249,$824A,$824B,
$824C,$824D,$824E,$824F,$8250,$8251,$8252,$8253,$8254,$8255,$8256,$8257,$8258,
$8259,$825A,$8261,$8262,$8263,$8264,$8265,$8266,$8267,$8268,$8269,$826A,$826B,
$826C,$826D,$826E,$826F,$8270,$8271,$8272,$8273,$8274,$8275,$8276,$8277,$8278,
$8279,$827A,$8281,$8282,$8283,$8284,$8285,$8286,$8287,$8288,$8289,$828A,$828B,
$828C,$828D,$828E,$828F,$8290,$8291,$8292,$8293,$8294,$8295,$8296,$8297,$8298,
$8299,$829A,$829B,$829C,$829D,$829E,$829F,$82A0,$82A1,$82A2,$82A3,$82A4,$82A5,
$82A6,$82A7,$82A8,$82A9,$82AA,$82AB,$82AC,$82AD,$82AE,$82AF,$82B0,$82B1,$82B2,
$82B3,$82B4,$82B5,$82B6,$82B7,$82B8,$82B9,$82BA,$82BB,$82BC,$82BD,$82BE,$82BF,
$82C0,$82C1,$82C2,$82C3,$82C4,$82C5,$82C6,$82C7,$82C8,$82C9,$82CA,$82CB,$82CC,
$82CD,$82CE,$82CF,$82D0,$82D1,$82D2,$82D3,$82D4,$82D5,$82D6,$82D7,$82D8,$82D9,
$82DA,$82DB,$82DC,$82DD,$82DE,$82DF,$82E0,$82E1,$82E2,$82E3,$82E4,$82E5,$82E6,
$82E7,$82E8,$82E9,$82EA,$82EB,$82EC,$82ED,$82EE,$82EF,$82F0,$82F1,$82F2,$82F3,
$82F4,$82F5,$82F6,$82F7,$82F8,$82F9,$82FA,$82FB,$82FC,$82FD,$82FE,$8341,$8342,
$8343,$8344,$8345,$8346,$8347,$8348,$8349,$834A,$834B,$834C,$834D,$834E,$834F,
$8350,$8351,$8352,$8353,$8354,$8355,$8356,$8357,$8358,$8359,$835A,$8361,$8362,
$8363,$8364,$8365,$8366,$8367,$8368,$8369,$836A,$836B,$836C,$836D,$836E,$836F,
$8370,$8371,$8372,$8373,$8374,$8375,$8376,$8377,$8378,$8379,$837A,$8381,$8382,
$8383,$8384,$8385,$8386,$8387,$8388,$8389,$838A,$838B,$838C,$838D,$838E,$838F,
$8390,$8391,$8392,$8393,$8394,$8395,$8396,$8397,$8398,$8399,$839A,$839B,$839C,
$839D,$839E,$839F,$83A0,$83A1,$83A2,$83A3,$83A4,$83A5,$83A6,$83A7,$83A8,$83A9,
$83AA,$83AB,$83AC,$83AD,$83AE,$83AF,$83B0,$83B1,$83B2,$83B3,$83B4,$83B5,$83B6,
$83B7,$83B8,$83B9,$83BA,$83BB,$83BC,$83BD,$83BE,$83BF,$83C0,$83C1,$83C2,$83C3,
$83C4,$83C5,$83C6,$83C7,$83C8,$83C9,$83CA,$83CB,$83CC,$83CD,$83CE,$83CF,$83D0,
$83D1,$83D2,$83D3,$83D4,$83D5,$83D6,$83D7,$83D8,$83D9,$83DA,$83DB,$83DC,$83DD,
$83DE,$83DF,$83E0,$83E1,$83E2,$83E3,$83E4,$83E5,$83E6,$83E7,$83E8,$83E9,$83EA,
$83EB,$83EC,$83ED,$83EE,$83EF,$83F0,$83F1,$83F2,$83F3,$83F4,$83F5,$83F6,$83F7,
$83F8,$83F9,$83FA,$83FB,$83FC,$83FD,$83FE,$8441,$8442,$8443,$8444,$8445,$8446,
$8447,$8448,$8449,$844A,$844B,$844C,$844D,$844E,$844F,$8450,$8451,$8452,$8453,
$8454,$8455,$8456,$8457,$8458,$8459,$845A,$8461,$8462,$8463,$8464,$8465,$8466,
$8467,$8468,$8469,$846A,$846B,$846C,$846D,$846E,$846F,$8470,$8471,$8472,$8473,
$8474,$8475,$8476,$8477,$8478,$8479,$847A,$8481,$8482,$8483,$8484,$8485,$8486,
$8487,$8488,$8489,$848A,$848B,$848C,$848D,$848E,$848F,$8490,$8491,$8492,$8493,
$8494,$8495,$8496,$8497,$8498,$8499,$849A,$849B,$849C,$849D,$849E,$849F,$84A0,
$84A1,$84A2,$84A3,$84A4,$84A5,$84A6,$84A7,$84A8,$84A9,$84AA,$84AB,$84AC,$84AD,
$84AE,$84AF,$84B0,$84B1,$84B2,$84B3,$84B4,$84B5,$84B6,$84B7,$84B8,$84B9,$84BA,
$84BB,$84BC,$84BD,$84BE,$84BF,$84C0,$84C1,$84C2,$84C3,$84C4,$84C5,$84C6,$84C7,
$84C8,$84C9,$84CA,$84CB,$84CC,$84CD,$84CE,$84CF,$84D0,$84D1,$84D2,$84D3,$84D4,
$84D5,$84D6,$84D7,$84D8,$84D9,$84DA,$84DB,$84DC,$84DD,$84DE,$84DF,$84E0,$84E1,
$84E2,$84E3,$84E4,$84E5,$84E6,$84E7,$84E8,$84E9,$84EA,$84EB,$84EC,$84ED,$84EE,
$84EF,$84F0,$84F1,$84F2,$84F3,$84F4,$84F5,$84F6,$84F7,$84F8,$84F9,$84FA,$84FB,
$84FC,$84FD,$84FE,$8541,$8542,$8543,$8544,$8545,$8546,$8547,$8548,$8549,$854A,
$854B,$854C,$854D,$854E,$854F,$8550,$8551,$8552,$8553,$8554,$8555,$8556,$8557,
$8558,$8559,$855A,$8561,$8562,$8563,$8564,$8565,$8566,$8567,$8568,$8569,$856A,
$856B,$856C,$856D,$856E,$856F,$8570,$8571,$8572,$8573,$8574,$8575,$8576,$8577,
$8578,$8579,$857A,$8581,$8582,$8583,$8584,$8585,$8586,$8587,$8588,$8589,$858A,
$858B,$858C,$858D,$858E,$858F,$8590,$8591,$8592,$8593,$8594,$8595,$8596,$8597,
$8598,$8599,$859A,$859B,$859C,$859D,$859E,$859F,$85A0,$85A1,$85A2,$85A3,$85A4,
$85A5,$85A6,$85A7,$85A8,$85A9,$85AA,$85AB,$85AC,$85AD,$85AE,$85AF,$85B0,$85B1,
$85B2,$85B3,$85B4,$85B5,$85B6,$85B7,$85B8,$85B9,$85BA,$85BB,$85BC,$85BD,$85BE,
$85BF,$85C0,$85C1,$85C2,$85C3,$85C4,$85C5,$85C6,$85C7,$85C8,$85C9,$85CA,$85CB,
$85CC,$85CD,$85CE,$85CF,$85D0,$85D1,$85D2,$85D3,$85D4,$85D5,$85D6,$85D7,$85D8,
$85D9,$85DA,$85DB,$85DC,$85DD,$85DE,$85DF,$85E0,$85E1,$85E2,$85E3,$85E4,$85E5,
$85E6,$85E7,$85E8,$85E9,$85EA,$85EB,$85EC,$85ED,$85EE,$85EF,$85F0,$85F1,$85F2,
$85F3,$85F4,$85F5,$85F6,$85F7,$85F8,$85F9,$85FA,$85FB,$85FC,$85FD,$85FE,$8641,
$8642,$8643,$8644,$8645,$8646,$8647,$8648,$8649,$864A,$864B,$864C,$864D,$864E,
$864F,$8650,$8651,$8652,$8653,$8654,$8655,$8656,$8657,$8658,$8659,$865A,$8661,
$8662,$8663,$8664,$8665,$8666,$8667,$8668,$8669,$866A,$866B,$866C,$866D,$866E,
$866F,$8670,$8671,$8672,$8673,$8674,$8675,$8676,$8677,$8678,$8679,$867A,$8681,
$8682,$8683,$8684,$8685,$8686,$8687,$8688,$8689,$868A,$868B,$868C,$868D,$868E,
$868F,$8690,$8691,$8692,$8693,$8694,$8695,$8696,$8697,$8698,$8699,$869A,$869B,
$869C,$869D,$869E,$869F,$86A0,$86A1,$86A2,$86A3,$86A4,$86A5,$86A6,$86A7,$86A8,
$86A9,$86AA,$86AB,$86AC,$86AD,$86AE,$86AF,$86B0,$86B1,$86B2,$86B3,$86B4,$86B5,
$86B6,$86B7,$86B8,$86B9,$86BA,$86BB,$86BC,$86BD,$86BE,$86BF,$86C0,$86C1,$86C2,
$86C3,$86C4,$86C5,$86C6,$86C7,$86C8,$86C9,$86CA,$86CB,$86CC,$86CD,$86CE,$86CF,
$86D0,$86D1,$86D2,$86D3,$86D4,$86D5,$86D6,$86D7,$86D8,$86D9,$86DA,$86DB,$86DC,
$86DD,$86DE,$86DF,$86E0,$86E1,$86E2,$86E3,$86E4,$86E5,$86E6,$86E7,$86E8,$86E9,
$86EA,$86EB,$86EC,$86ED,$86EE,$86EF,$86F0,$86F1,$86F2,$86F3,$86F4,$86F5,$86F6,
$86F7,$86F8,$86F9,$86FA,$86FB,$86FC,$86FD,$86FE,$8741,$8742,$8743,$8744,$8745,
$8746,$8747,$8748,$8749,$874A,$874B,$874C,$874D,$874E,$874F,$8750,$8751,$8752,
$8753,$8754,$8755,$8756,$8757,$8758,$8759,$875A,$8761,$8762,$8763,$8764,$8765,
$8766,$8767,$8768,$8769,$876A,$876B,$876C,$876D,$876E,$876F,$8770,$8771,$8772,
$8773,$8774,$8775,$8776,$8777,$8778,$8779,$877A,$8781,$8782,$8783,$8784,$8785,
$8786,$8787,$8788,$8789,$878A,$878B,$878C,$878D,$878E,$878F,$8790,$8791,$8792,
$8793,$8794,$8795,$8796,$8797,$8798,$8799,$879A,$879B,$879C,$879D,$879E,$879F,
$87A0,$87A1,$87A2,$87A3,$87A4,$87A5,$87A6,$87A7,$87A8,$87A9,$87AA,$87AB,$87AC,
$87AD,$87AE,$87AF,$87B0,$87B1,$87B2,$87B3,$87B4,$87B5,$87B6,$87B7,$87B8,$87B9,
$87BA,$87BB,$87BC,$87BD,$87BE,$87BF,$87C0,$87C1,$87C2,$87C3,$87C4,$87C5,$87C6,
$87C7,$87C8,$87C9,$87CA,$87CB,$87CC,$87CD,$87CE,$87CF,$87D0,$87D1,$87D2,$87D3,
$87D4,$87D5,$87D6,$87D7,$87D8,$87D9,$87DA,$87DB,$87DC,$87DD,$87DE,$87DF,$87E0,
$87E1,$87E2,$87E3,$87E4,$87E5,$87E6,$87E7,$87E8,$87E9,$87EA,$87EB,$87EC,$87ED,
$87EE,$87EF,$87F0,$87F1,$87F2,$87F3,$87F4,$87F5,$87F6,$87F7,$87F8,$87F9,$87FA,
$87FB,$87FC,$87FD,$87FE,$8841,$8842,$8843,$8844,$8845,$8846,$8847,$8848,$8849,
$884A,$884B,$884C,$884D,$884E,$884F,$8850,$8851,$8852,$8853,$8854,$8855,$8856,
$8857,$8858,$8859,$885A,$8861,$8862,$8863,$8864,$8865,$8866,$8867,$8868,$8869,
$886A,$886B,$886C,$886D,$886E,$886F,$8870,$8871,$8872,$8873,$8874,$8875,$8876,
$8877,$8878,$8879,$887A,$8881,$8882,$8883,$8884,$8885,$8886,$8887,$8888,$8889,
$888A,$888B,$888C,$888D,$888E,$888F,$8890,$8891,$8892,$8893,$8894,$8895,$8896,
$8897,$8898,$8899,$889A,$889B,$889C,$889D,$889E,$889F,$88A0,$88A1,$88A2,$88A3,
$88A4,$88A5,$88A6,$88A7,$88A8,$88A9,$88AA,$88AB,$88AC,$88AD,$88AE,$88AF,$88B0,
$88B1,$88B2,$88B3,$88B4,$88B5,$88B6,$88B7,$88B8,$88B9,$88BA,$88BB,$88BC,$88BD,
$88BE,$88BF,$88C0,$88C1,$88C2,$88C3,$88C4,$88C5,$88C6,$88C7,$88C8,$88C9,$88CA,
$88CB,$88CC,$88CD,$88CE,$88CF,$88D0,$88D1,$88D2,$88D3,$88D4,$88D5,$88D6,$88D7,
$88D8,$88D9,$88DA,$88DB,$88DC,$88DD,$88DE,$88DF,$88E0,$88E1,$88E2,$88E3,$88E4,
$88E5,$88E6,$88E7,$88E8,$88E9,$88EA,$88EB,$88EC,$88ED,$88EE,$88EF,$88F0,$88F1,
$88F2,$88F3,$88F4,$88F5,$88F6,$88F7,$88F8,$88F9,$88FA,$88FB,$88FC,$88FD,$88FE,
$8941,$8942,$8943,$8944,$8945,$8946,$8947,$8948,$8949,$894A,$894B,$894C,$894D,
$894E,$894F,$8950,$8951,$8952,$8953,$8954,$8955,$8956,$8957,$8958,$8959,$895A,
$8961,$8962,$8963,$8964,$8965,$8966,$8967,$8968,$8969,$896A,$896B,$896C,$896D,
$896E,$896F,$8970,$8971,$8972,$8973,$8974,$8975,$8976,$8977,$8978,$8979,$897A,
$8981,$8982,$8983,$8984,$8985,$8986,$8987,$8988,$8989,$898A,$898B,$898C,$898D,
$898E,$898F,$8990,$8991,$8992,$8993,$8994,$8995,$8996,$8997,$8998,$8999,$899A,
$899B,$899C,$899D,$899E,$899F,$89A0,$89A1,$89A2,$89A3,$89A4,$89A5,$89A6,$89A7,
$89A8,$89A9,$89AA,$89AB,$89AC,$89AD,$89AE,$89AF,$89B0,$89B1,$89B2,$89B3,$89B4,
$89B5,$89B6,$89B7,$89B8,$89B9,$89BA,$89BB,$89BC,$89BD,$89BE,$89BF,$89C0,$89C1,
$89C2,$89C3,$89C4,$89C5,$89C6,$89C7,$89C8,$89C9,$89CA,$89CB,$89CC,$89CD,$89CE,
$89CF,$89D0,$89D1,$89D2,$89D3,$89D4,$89D5,$89D6,$89D7,$89D8,$89D9,$89DA,$89DB,
$89DC,$89DD,$89DE,$89DF,$89E0,$89E1,$89E2,$89E3,$89E4,$89E5,$89E6,$89E7,$89E8,
$89E9,$89EA,$89EB,$89EC,$89ED,$89EE,$89EF,$89F0,$89F1,$89F2,$89F3,$89F4,$89F5,
$89F6,$89F7,$89F8,$89F9,$89FA,$89FB,$89FC,$89FD,$89FE,$8A41,$8A42,$8A43,$8A44,
$8A45,$8A46,$8A47,$8A48,$8A49,$8A4A,$8A4B,$8A4C,$8A4D,$8A4E,$8A4F,$8A50,$8A51,
$8A52,$8A53,$8A54,$8A55,$8A56,$8A57,$8A58,$8A59,$8A5A,$8A61,$8A62,$8A63,$8A64,
$8A65,$8A66,$8A67,$8A68,$8A69,$8A6A,$8A6B,$8A6C,$8A6D,$8A6E,$8A6F,$8A70,$8A71,
$8A72,$8A73,$8A74,$8A75,$8A76,$8A77,$8A78,$8A79,$8A7A,$8A81,$8A82,$8A83,$8A84,
$8A85,$8A86,$8A87,$8A88,$8A89,$8A8A,$8A8B,$8A8C,$8A8D,$8A8E,$8A8F,$8A90,$8A91,
$8A92,$8A93,$8A94,$8A95,$8A96,$8A97,$8A98,$8A99,$8A9A,$8A9B,$8A9C,$8A9D,$8A9E,
$8A9F,$8AA0,$8AA1,$8AA2,$8AA3,$8AA4,$8AA5,$8AA6,$8AA7,$8AA8,$8AA9,$8AAA,$8AAB,
$8AAC,$8AAD,$8AAE,$8AAF,$8AB0,$8AB1,$8AB2,$8AB3,$8AB4,$8AB5,$8AB6,$8AB7,$8AB8,
$8AB9,$8ABA,$8ABB,$8ABC,$8ABD,$8ABE,$8ABF,$8AC0,$8AC1,$8AC2,$8AC3,$8AC4,$8AC5,
$8AC6,$8AC7,$8AC8,$8AC9,$8ACA,$8ACB,$8ACC,$8ACD,$8ACE,$8ACF,$8AD0,$8AD1,$8AD2,
$8AD3,$8AD4,$8AD5,$8AD6,$8AD7,$8AD8,$8AD9,$8ADA,$8ADB,$8ADC,$8ADD,$8ADE,$8ADF,
$8AE0,$8AE1,$8AE2,$8AE3,$8AE4,$8AE5,$8AE6,$8AE7,$8AE8,$8AE9,$8AEA,$8AEB,$8AEC,
$8AED,$8AEE,$8AEF,$8AF0,$8AF1,$8AF2,$8AF3,$8AF4,$8AF5,$8AF6,$8AF7,$8AF8,$8AF9,
$8AFA,$8AFB,$8AFC,$8AFD,$8AFE,$8B41,$8B42,$8B43,$8B44,$8B45,$8B46,$8B47,$8B48,
$8B49,$8B4A,$8B4B,$8B4C,$8B4D,$8B4E,$8B4F,$8B50,$8B51,$8B52,$8B53,$8B54,$8B55,
$8B56,$8B57,$8B58,$8B59,$8B5A,$8B61,$8B62,$8B63,$8B64,$8B65,$8B66,$8B67,$8B68,
$8B69,$8B6A,$8B6B,$8B6C,$8B6D,$8B6E,$8B6F,$8B70,$8B71,$8B72,$8B73,$8B74,$8B75,
$8B76,$8B77,$8B78,$8B79,$8B7A,$8B81,$8B82,$8B83,$8B84,$8B85,$8B86,$8B87,$8B88,
$8B89,$8B8A,$8B8B,$8B8C,$8B8D,$8B8E,$8B8F,$8B90,$8B91,$8B92,$8B93,$8B94,$8B95,
$8B96,$8B97,$8B98,$8B99,$8B9A,$8B9B,$8B9C,$8B9D,$8B9E,$8B9F,$8BA0,$8BA1,$8BA2,
$8BA3,$8BA4,$8BA5,$8BA6,$8BA7,$8BA8,$8BA9,$8BAA,$8BAB,$8BAC,$8BAD,$8BAE,$8BAF,
$8BB0,$8BB1,$8BB2,$8BB3,$8BB4,$8BB5,$8BB6,$8BB7,$8BB8,$8BB9,$8BBA,$8BBB,$8BBC,
$8BBD,$8BBE,$8BBF,$8BC0,$8BC1,$8BC2,$8BC3,$8BC4,$8BC5,$8BC6,$8BC7,$8BC8,$8BC9,
$8BCA,$8BCB,$8BCC,$8BCD,$8BCE,$8BCF,$8BD0,$8BD1,$8BD2,$8BD3,$8BD4,$8BD5,$8BD6,
$8BD7,$8BD8,$8BD9,$8BDA,$8BDB,$8BDC,$8BDD,$8BDE,$8BDF,$8BE0,$8BE1,$8BE2,$8BE3,
$8BE4,$8BE5,$8BE6,$8BE7,$8BE8,$8BE9,$8BEA,$8BEB,$8BEC,$8BED,$8BEE,$8BEF,$8BF0,
$8BF1,$8BF2,$8BF3,$8BF4,$8BF5,$8BF6,$8BF7,$8BF8,$8BF9,$8BFA,$8BFB,$8BFC,$8BFD,
$8BFE,$8C41,$8C42,$8C43,$8C44,$8C45,$8C46,$8C47,$8C48,$8C49,$8C4A,$8C4B,$8C4C,
$8C4D,$8C4E,$8C4F,$8C50,$8C51,$8C52,$8C53,$8C54,$8C55,$8C56,$8C57,$8C58,$8C59,
$8C5A,$8C61,$8C62,$8C63,$8C64,$8C65,$8C66,$8C67,$8C68,$8C69,$8C6A,$8C6B,$8C6C,
$8C6D,$8C6E,$8C6F,$8C70,$8C71,$8C72,$8C73,$8C74,$8C75,$8C76,$8C77,$8C78,$8C79,
$8C7A,$8C81,$8C82,$8C83,$8C84,$8C85,$8C86,$8C87,$8C88,$8C89,$8C8A,$8C8B,$8C8C,
$8C8D,$8C8E,$8C8F,$8C90,$8C91,$8C92,$8C93,$8C94,$8C95,$8C96,$8C97,$8C98,$8C99,
$8C9A,$8C9B,$8C9C,$8C9D,$8C9E,$8C9F,$8CA0,$8CA1,$8CA2,$8CA3,$8CA4,$8CA5,$8CA6,
$8CA7,$8CA8,$8CA9,$8CAA,$8CAB,$8CAC,$8CAD,$8CAE,$8CAF,$8CB0,$8CB1,$8CB2,$8CB3,
$8CB4,$8CB5,$8CB6,$8CB7,$8CB8,$8CB9,$8CBA,$8CBB,$8CBC,$8CBD,$8CBE,$8CBF,$8CC0,
$8CC1,$8CC2,$8CC3,$8CC4,$8CC5,$8CC6,$8CC7,$8CC8,$8CC9,$8CCA,$8CCB,$8CCC,$8CCD,
$8CCE,$8CCF,$8CD0,$8CD1,$8CD2,$8CD3,$8CD4,$8CD5,$8CD6,$8CD7,$8CD8,$8CD9,$8CDA,
$8CDB,$8CDC,$8CDD,$8CDE,$8CDF,$8CE0,$8CE1,$8CE2,$8CE3,$8CE4,$8CE5,$8CE6,$8CE7,
$8CE8,$8CE9,$8CEA,$8CEB,$8CEC,$8CED,$8CEE,$8CEF,$8CF0,$8CF1,$8CF2,$8CF3,$8CF4,
$8CF5,$8CF6,$8CF7,$8CF8,$8CF9,$8CFA,$8CFB,$8CFC,$8CFD,$8CFE,$8D41,$8D42,$8D43,
$8D44,$8D45,$8D46,$8D47,$8D48,$8D49,$8D4A,$8D4B,$8D4C,$8D4D,$8D4E,$8D4F,$8D50,
$8D51,$8D52,$8D53,$8D54,$8D55,$8D56,$8D57,$8D58,$8D59,$8D5A,$8D61,$8D62,$8D63,
$8D64,$8D65,$8D66,$8D67,$8D68,$8D69,$8D6A,$8D6B,$8D6C,$8D6D,$8D6E,$8D6F,$8D70,
$8D71,$8D72,$8D73,$8D74,$8D75,$8D76,$8D77,$8D78,$8D79,$8D7A,$8D81,$8D82,$8D83,
$8D84,$8D85,$8D86,$8D87,$8D88,$8D89,$8D8A,$8D8B,$8D8C,$8D8D,$8D8E,$8D8F,$8D90,
$8D91,$8D92,$8D93,$8D94,$8D95,$8D96,$8D97,$8D98,$8D99,$8D9A,$8D9B,$8D9C,$8D9D,
$8D9E,$8D9F,$8DA0,$8DA1,$8DA2,$8DA3,$8DA4,$8DA5,$8DA6,$8DA7,$8DA8,$8DA9,$8DAA,
$8DAB,$8DAC,$8DAD,$8DAE,$8DAF,$8DB0,$8DB1,$8DB2,$8DB3,$8DB4,$8DB5,$8DB6,$8DB7,
$8DB8,$8DB9,$8DBA,$8DBB,$8DBC,$8DBD,$8DBE,$8DBF,$8DC0,$8DC1,$8DC2,$8DC3,$8DC4,
$8DC5,$8DC6,$8DC7,$8DC8,$8DC9,$8DCA,$8DCB,$8DCC,$8DCD,$8DCE,$8DCF,$8DD0,$8DD1,
$8DD2,$8DD3,$8DD4,$8DD5,$8DD6,$8DD7,$8DD8,$8DD9,$8DDA,$8DDB,$8DDC,$8DDD,$8DDE,
$8DDF,$8DE0,$8DE1,$8DE2,$8DE3,$8DE4,$8DE5,$8DE6,$8DE7,$8DE8,$8DE9,$8DEA,$8DEB,
$8DEC,$8DED,$8DEE,$8DEF,$8DF0,$8DF1,$8DF2,$8DF3,$8DF4,$8DF5,$8DF6,$8DF7,$8DF8,
$8DF9,$8DFA,$8DFB,$8DFC,$8DFD,$8DFE,$8E41,$8E42,$8E43,$8E44,$8E45,$8E46,$8E47,
$8E48,$8E49,$8E4A,$8E4B,$8E4C,$8E4D,$8E4E,$8E4F,$8E50,$8E51,$8E52,$8E53,$8E54,
$8E55,$8E56,$8E57,$8E58,$8E59,$8E5A,$8E61,$8E62,$8E63,$8E64,$8E65,$8E66,$8E67,
$8E68,$8E69,$8E6A,$8E6B,$8E6C,$8E6D,$8E6E,$8E6F,$8E70,$8E71,$8E72,$8E73,$8E74,
$8E75,$8E76,$8E77,$8E78,$8E79,$8E7A,$8E81,$8E82,$8E83,$8E84,$8E85,$8E86,$8E87,
$8E88,$8E89,$8E8A,$8E8B,$8E8C,$8E8D,$8E8E,$8E8F,$8E90,$8E91,$8E92,$8E93,$8E94,
$8E95,$8E96,$8E97,$8E98,$8E99,$8E9A,$8E9B,$8E9C,$8E9D,$8E9E,$8E9F,$8EA0,$8EA1,
$8EA2,$8EA3,$8EA4,$8EA5,$8EA6,$8EA7,$8EA8,$8EA9,$8EAA,$8EAB,$8EAC,$8EAD,$8EAE,
$8EAF,$8EB0,$8EB1,$8EB2,$8EB3,$8EB4,$8EB5,$8EB6,$8EB7,$8EB8,$8EB9,$8EBA,$8EBB,
$8EBC,$8EBD,$8EBE,$8EBF,$8EC0,$8EC1,$8EC2,$8EC3,$8EC4,$8EC5,$8EC6,$8EC7,$8EC8,
$8EC9,$8ECA,$8ECB,$8ECC,$8ECD,$8ECE,$8ECF,$8ED0,$8ED1,$8ED2,$8ED3,$8ED4,$8ED5,
$8ED6,$8ED7,$8ED8,$8ED9,$8EDA,$8EDB,$8EDC,$8EDD,$8EDE,$8EDF,$8EE0,$8EE1,$8EE2,
$8EE3,$8EE4,$8EE5,$8EE6,$8EE7,$8EE8,$8EE9,$8EEA,$8EEB,$8EEC,$8EED,$8EEE,$8EEF,
$8EF0,$8EF1,$8EF2,$8EF3,$8EF4,$8EF5,$8EF6,$8EF7,$8EF8,$8EF9,$8EFA,$8EFB,$8EFC,
$8EFD,$8EFE,$8F41,$8F42,$8F43,$8F44,$8F45,$8F46,$8F47,$8F48,$8F49,$8F4A,$8F4B,
$8F4C,$8F4D,$8F4E,$8F4F,$8F50,$8F51,$8F52,$8F53,$8F54,$8F55,$8F56,$8F57,$8F58,
$8F59,$8F5A,$8F61,$8F62,$8F63,$8F64,$8F65,$8F66,$8F67,$8F68,$8F69,$8F6A,$8F6B,
$8F6C,$8F6D,$8F6E,$8F6F,$8F70,$8F71,$8F72,$8F73,$8F74,$8F75,$8F76,$8F77,$8F78,
$8F79,$8F7A,$8F81,$8F82,$8F83,$8F84,$8F85,$8F86,$8F87,$8F88,$8F89,$8F8A,$8F8B,
$8F8C,$8F8D,$8F8E,$8F8F,$8F90,$8F91,$8F92,$8F93,$8F94,$8F95,$8F96,$8F97,$8F98,
$8F99,$8F9A,$8F9B,$8F9C,$8F9D,$8F9E,$8F9F,$8FA0,$8FA1,$8FA2,$8FA3,$8FA4,$8FA5,
$8FA6,$8FA7,$8FA8,$8FA9,$8FAA,$8FAB,$8FAC,$8FAD,$8FAE,$8FAF,$8FB0,$8FB1,$8FB2,
$8FB3,$8FB4,$8FB5,$8FB6,$8FB7,$8FB8,$8FB9,$8FBA,$8FBB,$8FBC,$8FBD,$8FBE,$8FBF,
$8FC0,$8FC1,$8FC2,$8FC3,$8FC4,$8FC5,$8FC6,$8FC7,$8FC8,$8FC9,$8FCA,$8FCB,$8FCC,
$8FCD,$8FCE,$8FCF,$8FD0,$8FD1,$8FD2,$8FD3,$8FD4,$8FD5,$8FD6,$8FD7,$8FD8,$8FD9,
$8FDA,$8FDB,$8FDC,$8FDD,$8FDE,$8FDF,$8FE0,$8FE1,$8FE2,$8FE3,$8FE4,$8FE5,$8FE6,
$8FE7,$8FE8,$8FE9,$8FEA,$8FEB,$8FEC,$8FED,$8FEE,$8FEF,$8FF0,$8FF1,$8FF2,$8FF3,
$8FF4,$8FF5,$8FF6,$8FF7,$8FF8,$8FF9,$8FFA,$8FFB,$8FFC,$8FFD,$8FFE,$9041,$9042,
$9043,$9044,$9045,$9046,$9047,$9048,$9049,$904A,$904B,$904C,$904D,$904E,$904F,
$9050,$9051,$9052,$9053,$9054,$9055,$9056,$9057,$9058,$9059,$905A,$9061,$9062,
$9063,$9064,$9065,$9066,$9067,$9068,$9069,$906A,$906B,$906C,$906D,$906E,$906F,
$9070,$9071,$9072,$9073,$9074,$9075,$9076,$9077,$9078,$9079,$907A,$9081,$9082,
$9083,$9084,$9085,$9086,$9087,$9088,$9089,$908A,$908B,$908C,$908D,$908E,$908F,
$9090,$9091,$9092,$9093,$9094,$9095,$9096,$9097,$9098,$9099,$909A,$909B,$909C,
$909D,$909E,$909F,$90A0,$90A1,$90A2,$90A3,$90A4,$90A5,$90A6,$90A7,$90A8,$90A9,
$90AA,$90AB,$90AC,$90AD,$90AE,$90AF,$90B0,$90B1,$90B2,$90B3,$90B4,$90B5,$90B6,
$90B7,$90B8,$90B9,$90BA,$90BB,$90BC,$90BD,$90BE,$90BF,$90C0,$90C1,$90C2,$90C3,
$90C4,$90C5,$90C6,$90C7,$90C8,$90C9,$90CA,$90CB,$90CC,$90CD,$90CE,$90CF,$90D0,
$90D1,$90D2,$90D3,$90D4,$90D5,$90D6,$90D7,$90D8,$90D9,$90DA,$90DB,$90DC,$90DD,
$90DE,$90DF,$90E0,$90E1,$90E2,$90E3,$90E4,$90E5,$90E6,$90E7,$90E8,$90E9,$90EA,
$90EB,$90EC,$90ED,$90EE,$90EF,$90F0,$90F1,$90F2,$90F3,$90F4,$90F5,$90F6,$90F7,
$90F8,$90F9,$90FA,$90FB,$90FC,$90FD,$90FE,$9141,$9142,$9143,$9144,$9145,$9146,
$9147,$9148,$9149,$914A,$914B,$914C,$914D,$914E,$914F,$9150,$9151,$9152,$9153,
$9154,$9155,$9156,$9157,$9158,$9159,$915A,$9161,$9162,$9163,$9164,$9165,$9166,
$9167,$9168,$9169,$916A,$916B,$916C,$916D,$916E,$916F,$9170,$9171,$9172,$9173,
$9174,$9175,$9176,$9177,$9178,$9179,$917A,$9181,$9182,$9183,$9184,$9185,$9186,
$9187,$9188,$9189,$918A,$918B,$918C,$918D,$918E,$918F,$9190,$9191,$9192,$9193,
$9194,$9195,$9196,$9197,$9198,$9199,$919A,$919B,$919C,$919D,$919E,$919F,$91A0,
$91A1,$91A2,$91A3,$91A4,$91A5,$91A6,$91A7,$91A8,$91A9,$91AA,$91AB,$91AC,$91AD,
$91AE,$91AF,$91B0,$91B1,$91B2,$91B3,$91B4,$91B5,$91B6,$91B7,$91B8,$91B9,$91BA,
$91BB,$91BC,$91BD,$91BE,$91BF,$91C0,$91C1,$91C2,$91C3,$91C4,$91C5,$91C6,$91C7,
$91C8,$91C9,$91CA,$91CB,$91CC,$91CD,$91CE,$91CF,$91D0,$91D1,$91D2,$91D3,$91D4,
$91D5,$91D6,$91D7,$91D8,$91D9,$91DA,$91DB,$91DC,$91DD,$91DE,$91DF,$91E0,$91E1,
$91E2,$91E3,$91E4,$91E5,$91E6,$91E7,$91E8,$91E9,$91EA,$91EB,$91EC,$91ED,$91EE,
$91EF,$91F0,$91F1,$91F2,$91F3,$91F4,$91F5,$91F6,$91F7,$91F8,$91F9,$91FA,$91FB,
$91FC,$91FD,$91FE,$9241,$9242,$9243,$9244,$9245,$9246,$9247,$9248,$9249,$924A,
$924B,$924C,$924D,$924E,$924F,$9250,$9251,$9252,$9253,$9254,$9255,$9256,$9257,
$9258,$9259,$925A,$9261,$9262,$9263,$9264,$9265,$9266,$9267,$9268,$9269,$926A,
$926B,$926C,$926D,$926E,$926F,$9270,$9271,$9272,$9273,$9274,$9275,$9276,$9277,
$9278,$9279,$927A,$9281,$9282,$9283,$9284,$9285,$9286,$9287,$9288,$9289,$928A,
$928B,$928C,$928D,$928E,$928F,$9290,$9291,$9292,$9293,$9294,$9295,$9296,$9297,
$9298,$9299,$929A,$929B,$929C,$929D,$929E,$929F,$92A0,$92A1,$92A2,$92A3,$92A4,
$92A5,$92A6,$92A7,$92A8,$92A9,$92AA,$92AB,$92AC,$92AD,$92AE,$92AF,$92B0,$92B1,
$92B2,$92B3,$92B4,$92B5,$92B6,$92B7,$92B8,$92B9,$92BA,$92BB,$92BC,$92BD,$92BE,
$92BF,$92C0,$92C1,$92C2,$92C3,$92C4,$92C5,$92C6,$92C7,$92C8,$92C9,$92CA,$92CB,
$92CC,$92CD,$92CE,$92CF,$92D0,$92D1,$92D2,$92D3,$92D4,$92D5,$92D6,$92D7,$92D8,
$92D9,$92DA,$92DB,$92DC,$92DD,$92DE,$92DF,$92E0,$92E1,$92E2,$92E3,$92E4,$92E5,
$92E6,$92E7,$92E8,$92E9,$92EA,$92EB,$92EC,$92ED,$92EE,$92EF,$92F0,$92F1,$92F2,
$92F3,$92F4,$92F5,$92F6,$92F7,$92F8,$92F9,$92FA,$92FB,$92FC,$92FD,$92FE,$9341,
$9342,$9343,$9344,$9345,$9346,$9347,$9348,$9349,$934A,$934B,$934C,$934D,$934E,
$934F,$9350,$9351,$9352,$9353,$9354,$9355,$9356,$9357,$9358,$9359,$935A,$9361,
$9362,$9363,$9364,$9365,$9366,$9367,$9368,$9369,$936A,$936B,$936C,$936D,$936E,
$936F,$9370,$9371,$9372,$9373,$9374,$9375,$9376,$9377,$9378,$9379,$937A,$9381,
$9382,$9383,$9384,$9385,$9386,$9387,$9388,$9389,$938A,$938B,$938C,$938D,$938E,
$938F,$9390,$9391,$9392,$9393,$9394,$9395,$9396,$9397,$9398,$9399,$939A,$939B,
$939C,$939D,$939E,$939F,$93A0,$93A1,$93A2,$93A3,$93A4,$93A5,$93A6,$93A7,$93A8,
$93A9,$93AA,$93AB,$93AC,$93AD,$93AE,$93AF,$93B0,$93B1,$93B2,$93B3,$93B4,$93B5,
$93B6,$93B7,$93B8,$93B9,$93BA,$93BB,$93BC,$93BD,$93BE,$93BF,$93C0,$93C1,$93C2,
$93C3,$93C4,$93C5,$93C6,$93C7,$93C8,$93C9,$93CA,$93CB,$93CC,$93CD,$93CE,$93CF,
$93D0,$93D1,$93D2,$93D3,$93D4,$93D5,$93D6,$93D7,$93D8,$93D9,$93DA,$93DB,$93DC,
$93DD,$93DE,$93DF,$93E0,$93E1,$93E2,$93E3,$93E4,$93E5,$93E6,$93E7,$93E8,$93E9,
$93EA,$93EB,$93EC,$93ED,$93EE,$93EF,$93F0,$93F1,$93F2,$93F3,$93F4,$93F5,$93F6,
$93F7,$93F8,$93F9,$93FA,$93FB,$93FC,$93FD,$93FE,$9441,$9442,$9443,$9444,$9445,
$9446,$9447,$9448,$9449,$944A,$944B,$944C,$944D,$944E,$944F,$9450,$9451,$9452,
$9453,$9454,$9455,$9456,$9457,$9458,$9459,$945A,$9461,$9462,$9463,$9464,$9465,
$9466,$9467,$9468,$9469,$946A,$946B,$946C,$946D,$946E,$946F,$9470,$9471,$9472,
$9473,$9474,$9475,$9476,$9477,$9478,$9479,$947A,$9481,$9482,$9483,$9484,$9485,
$9486,$9487,$9488,$9489,$948A,$948B,$948C,$948D,$948E,$948F,$9490,$9491,$9492,
$9493,$9494,$9495,$9496,$9497,$9498,$9499,$949A,$949B,$949C,$949D,$949E,$949F,
$94A0,$94A1,$94A2,$94A3,$94A4,$94A5,$94A6,$94A7,$94A8,$94A9,$94AA,$94AB,$94AC,
$94AD,$94AE,$94AF,$94B0,$94B1,$94B2,$94B3,$94B4,$94B5,$94B6,$94B7,$94B8,$94B9,
$94BA,$94BB,$94BC,$94BD,$94BE,$94BF,$94C0,$94C1,$94C2,$94C3,$94C4,$94C5,$94C6,
$94C7,$94C8,$94C9,$94CA,$94CB,$94CC,$94CD,$94CE,$94CF,$94D0,$94D1,$94D2,$94D3,
$94D4,$94D5,$94D6,$94D7,$94D8,$94D9,$94DA,$94DB,$94DC,$94DD,$94DE,$94DF,$94E0,
$94E1,$94E2,$94E3,$94E4,$94E5,$94E6,$94E7,$94E8,$94E9,$94EA,$94EB,$94EC,$94ED,
$94EE,$94EF,$94F0,$94F1,$94F2,$94F3,$94F4,$94F5,$94F6,$94F7,$94F8,$94F9,$94FA,
$94FB,$94FC,$94FD,$94FE,$9541,$9542,$9543,$9544,$9545,$9546,$9547,$9548,$9549,
$954A,$954B,$954C,$954D,$954E,$954F,$9550,$9551,$9552,$9553,$9554,$9555,$9556,
$9557,$9558,$9559,$955A,$9561,$9562,$9563,$9564,$9565,$9566,$9567,$9568,$9569,
$956A,$956B,$956C,$956D,$956E,$956F,$9570,$9571,$9572,$9573,$9574,$9575,$9576,
$9577,$9578,$9579,$957A,$9581,$9582,$9583,$9584,$9585,$9586,$9587,$9588,$9589,
$958A,$958B,$958C,$958D,$958E,$958F,$9590,$9591,$9592,$9593,$9594,$9595,$9596,
$9597,$9598,$9599,$959A,$959B,$959C,$959D,$959E,$959F,$95A0,$95A1,$95A2,$95A3,
$95A4,$95A5,$95A6,$95A7,$95A8,$95A9,$95AA,$95AB,$95AC,$95AD,$95AE,$95AF,$95B0,
$95B1,$95B2,$95B3,$95B4,$95B5,$95B6,$95B7,$95B8,$95B9,$95BA,$95BB,$95BC,$95BD,
$95BE,$95BF,$95C0,$95C1,$95C2,$95C3,$95C4,$95C5,$95C6,$95C7,$95C8,$95C9,$95CA,
$95CB,$95CC,$95CD,$95CE,$95CF,$95D0,$95D1,$95D2,$95D3,$95D4,$95D5,$95D6,$95D7,
$95D8,$95D9,$95DA,$95DB,$95DC,$95DD,$95DE,$95DF,$95E0,$95E1,$95E2,$95E3,$95E4,
$95E5,$95E6,$95E7,$95E8,$95E9,$95EA,$95EB,$95EC,$95ED,$95EE,$95EF,$95F0,$95F1,
$95F2,$95F3,$95F4,$95F5,$95F6,$95F7,$95F8,$95F9,$95FA,$95FB,$95FC,$95FD,$95FE,
$9641,$9642,$9643,$9644,$9645,$9646,$9647,$9648,$9649,$964A,$964B,$964C,$964D,
$964E,$964F,$9650,$9651,$9652,$9653,$9654,$9655,$9656,$9657,$9658,$9659,$965A,
$9661,$9662,$9663,$9664,$9665,$9666,$9667,$9668,$9669,$966A,$966B,$966C,$966D,
$966E,$966F,$9670,$9671,$9672,$9673,$9674,$9675,$9676,$9677,$9678,$9679,$967A,
$9681,$9682,$9683,$9684,$9685,$9686,$9687,$9688,$9689,$968A,$968B,$968C,$968D,
$968E,$968F,$9690,$9691,$9692,$9693,$9694,$9695,$9696,$9697,$9698,$9699,$969A,
$969B,$969C,$969D,$969E,$969F,$96A0,$96A1,$96A2,$96A3,$96A4,$96A5,$96A6,$96A7,
$96A8,$96A9,$96AA,$96AB,$96AC,$96AD,$96AE,$96AF,$96B0,$96B1,$96B2,$96B3,$96B4,
$96B5,$96B6,$96B7,$96B8,$96B9,$96BA,$96BB,$96BC,$96BD,$96BE,$96BF,$96C0,$96C1,
$96C2,$96C3,$96C4,$96C5,$96C6,$96C7,$96C8,$96C9,$96CA,$96CB,$96CC,$96CD,$96CE,
$96CF,$96D0,$96D1,$96D2,$96D3,$96D4,$96D5,$96D6,$96D7,$96D8,$96D9,$96DA,$96DB,
$96DC,$96DD,$96DE,$96DF,$96E0,$96E1,$96E2,$96E3,$96E4,$96E5,$96E6,$96E7,$96E8,
$96E9,$96EA,$96EB,$96EC,$96ED,$96EE,$96EF,$96F0,$96F1,$96F2,$96F3,$96F4,$96F5,
$96F6,$96F7,$96F8,$96F9,$96FA,$96FB,$96FC,$96FD,$96FE,$9741,$9742,$9743,$9744,
$9745,$9746,$9747,$9748,$9749,$974A,$974B,$974C,$974D,$974E,$974F,$9750,$9751,
$9752,$9753,$9754,$9755,$9756,$9757,$9758,$9759,$975A,$9761,$9762,$9763,$9764,
$9765,$9766,$9767,$9768,$9769,$976A,$976B,$976C,$976D,$976E,$976F,$9770,$9771,
$9772,$9773,$9774,$9775,$9776,$9777,$9778,$9779,$977A,$9781,$9782,$9783,$9784,
$9785,$9786,$9787,$9788,$9789,$978A,$978B,$978C,$978D,$978E,$978F,$9790,$9791,
$9792,$9793,$9794,$9795,$9796,$9797,$9798,$9799,$979A,$979B,$979C,$979D,$979E,
$979F,$97A0,$97A1,$97A2,$97A3,$97A4,$97A5,$97A6,$97A7,$97A8,$97A9,$97AA,$97AB,
$97AC,$97AD,$97AE,$97AF,$97B0,$97B1,$97B2,$97B3,$97B4,$97B5,$97B6,$97B7,$97B8,
$97B9,$97BA,$97BB,$97BC,$97BD,$97BE,$97BF,$97C0,$97C1,$97C2,$97C3,$97C4,$97C5,
$97C6,$97C7,$97C8,$97C9,$97CA,$97CB,$97CC,$97CD,$97CE,$97CF,$97D0,$97D1,$97D2,
$97D3,$97D4,$97D5,$97D6,$97D7,$97D8,$97D9,$97DA,$97DB,$97DC,$97DD,$97DE,$97DF,
$97E0,$97E1,$97E2,$97E3,$97E4,$97E5,$97E6,$97E7,$97E8,$97E9,$97EA,$97EB,$97EC,
$97ED,$97EE,$97EF,$97F0,$97F1,$97F2,$97F3,$97F4,$97F5,$97F6,$97F7,$97F8,$97F9,
$97FA,$97FB,$97FC,$97FD,$97FE,$9841,$9842,$9843,$9844,$9845,$9846,$9847,$9848,
$9849,$984A,$984B,$984C,$984D,$984E,$984F,$9850,$9851,$9852,$9853,$9854,$9855,
$9856,$9857,$9858,$9859,$985A,$9861,$9862,$9863,$9864,$9865,$9866,$9867,$9868,
$9869,$986A,$986B,$986C,$986D,$986E,$986F,$9870,$9871,$9872,$9873,$9874,$9875,
$9876,$9877,$9878,$9879,$987A,$9881,$9882,$9883,$9884,$9885,$9886,$9887,$9888,
$9889,$988A,$988B,$988C,$988D,$988E,$988F,$9890,$9891,$9892,$9893,$9894,$9895,
$9896,$9897,$9898,$9899,$989A,$989B,$989C,$989D,$989E,$989F,$98A0,$98A1,$98A2,
$98A3,$98A4,$98A5,$98A6,$98A7,$98A8,$98A9,$98AA,$98AB,$98AC,$98AD,$98AE,$98AF,
$98B0,$98B1,$98B2,$98B3,$98B4,$98B5,$98B6,$98B7,$98B8,$98B9,$98BA,$98BB,$98BC,
$98BD,$98BE,$98BF,$98C0,$98C1,$98C2,$98C3,$98C4,$98C5,$98C6,$98C7,$98C8,$98C9,
$98CA,$98CB,$98CC,$98CD,$98CE,$98CF,$98D0,$98D1,$98D2,$98D3,$98D4,$98D5,$98D6,
$98D7,$98D8,$98D9,$98DA,$98DB,$98DC,$98DD,$98DE,$98DF,$98E0,$98E1,$98E2,$98E3,
$98E4,$98E5,$98E6,$98E7,$98E8,$98E9,$98EA,$98EB,$98EC,$98ED,$98EE,$98EF,$98F0,
$98F1,$98F2,$98F3,$98F4,$98F5,$98F6,$98F7,$98F8,$98F9,$98FA,$98FB,$98FC,$98FD,
$98FE,$9941,$9942,$9943,$9944,$9945,$9946,$9947,$9948,$9949,$994A,$994B,$994C,
$994D,$994E,$994F,$9950,$9951,$9952,$9953,$9954,$9955,$9956,$9957,$9958,$9959,
$995A,$9961,$9962,$9963,$9964,$9965,$9966,$9967,$9968,$9969,$996A,$996B,$996C,
$996D,$996E,$996F,$9970,$9971,$9972,$9973,$9974,$9975,$9976,$9977,$9978,$9979,
$997A,$9981,$9982,$9983,$9984,$9985,$9986,$9987,$9988,$9989,$998A,$998B,$998C,
$998D,$998E,$998F,$9990,$9991,$9992,$9993,$9994,$9995,$9996,$9997,$9998,$9999,
$999A,$999B,$999C,$999D,$999E,$999F,$99A0,$99A1,$99A2,$99A3,$99A4,$99A5,$99A6,
$99A7,$99A8,$99A9,$99AA,$99AB,$99AC,$99AD,$99AE,$99AF,$99B0,$99B1,$99B2,$99B3,
$99B4,$99B5,$99B6,$99B7,$99B8,$99B9,$99BA,$99BB,$99BC,$99BD,$99BE,$99BF,$99C0,
$99C1,$99C2,$99C3,$99C4,$99C5,$99C6,$99C7,$99C8,$99C9,$99CA,$99CB,$99CC,$99CD,
$99CE,$99CF,$99D0,$99D1,$99D2,$99D3,$99D4,$99D5,$99D6,$99D7,$99D8,$99D9,$99DA,
$99DB,$99DC,$99DD,$99DE,$99DF,$99E0,$99E1,$99E2,$99E3,$99E4,$99E5,$99E6,$99E7,
$99E8,$99E9,$99EA,$99EB,$99EC,$99ED,$99EE,$99EF,$99F0,$99F1,$99F2,$99F3,$99F4,
$99F5,$99F6,$99F7,$99F8,$99F9,$99FA,$99FB,$99FC,$99FD,$99FE,$9A41,$9A42,$9A43,
$9A44,$9A45,$9A46,$9A47,$9A48,$9A49,$9A4A,$9A4B,$9A4C,$9A4D,$9A4E,$9A4F,$9A50,
$9A51,$9A52,$9A53,$9A54,$9A55,$9A56,$9A57,$9A58,$9A59,$9A5A,$9A61,$9A62,$9A63,
$9A64,$9A65,$9A66,$9A67,$9A68,$9A69,$9A6A,$9A6B,$9A6C,$9A6D,$9A6E,$9A6F,$9A70,
$9A71,$9A72,$9A73,$9A74,$9A75,$9A76,$9A77,$9A78,$9A79,$9A7A,$9A81,$9A82,$9A83,
$9A84,$9A85,$9A86,$9A87,$9A88,$9A89,$9A8A,$9A8B,$9A8C,$9A8D,$9A8E,$9A8F,$9A90,
$9A91,$9A92,$9A93,$9A94,$9A95,$9A96,$9A97,$9A98,$9A99,$9A9A,$9A9B,$9A9C,$9A9D,
$9A9E,$9A9F,$9AA0,$9AA1,$9AA2,$9AA3,$9AA4,$9AA5,$9AA6,$9AA7,$9AA8,$9AA9,$9AAA,
$9AAB,$9AAC,$9AAD,$9AAE,$9AAF,$9AB0,$9AB1,$9AB2,$9AB3,$9AB4,$9AB5,$9AB6,$9AB7,
$9AB8,$9AB9,$9ABA,$9ABB,$9ABC,$9ABD,$9ABE,$9ABF,$9AC0,$9AC1,$9AC2,$9AC3,$9AC4,
$9AC5,$9AC6,$9AC7,$9AC8,$9AC9,$9ACA,$9ACB,$9ACC,$9ACD,$9ACE,$9ACF,$9AD0,$9AD1,
$9AD2,$9AD3,$9AD4,$9AD5,$9AD6,$9AD7,$9AD8,$9AD9,$9ADA,$9ADB,$9ADC,$9ADD,$9ADE,
$9ADF,$9AE0,$9AE1,$9AE2,$9AE3,$9AE4,$9AE5,$9AE6,$9AE7,$9AE8,$9AE9,$9AEA,$9AEB,
$9AEC,$9AED,$9AEE,$9AEF,$9AF0,$9AF1,$9AF2,$9AF3,$9AF4,$9AF5,$9AF6,$9AF7,$9AF8,
$9AF9,$9AFA,$9AFB,$9AFC,$9AFD,$9AFE,$9B41,$9B42,$9B43,$9B44,$9B45,$9B46,$9B47,
$9B48,$9B49,$9B4A,$9B4B,$9B4C,$9B4D,$9B4E,$9B4F,$9B50,$9B51,$9B52,$9B53,$9B54,
$9B55,$9B56,$9B57,$9B58,$9B59,$9B5A,$9B61,$9B62,$9B63,$9B64,$9B65,$9B66,$9B67,
$9B68,$9B69,$9B6A,$9B6B,$9B6C,$9B6D,$9B6E,$9B6F,$9B70,$9B71,$9B72,$9B73,$9B74,
$9B75,$9B76,$9B77,$9B78,$9B79,$9B7A,$9B81,$9B82,$9B83,$9B84,$9B85,$9B86,$9B87,
$9B88,$9B89,$9B8A,$9B8B,$9B8C,$9B8D,$9B8E,$9B8F,$9B90,$9B91,$9B92,$9B93,$9B94,
$9B95,$9B96,$9B97,$9B98,$9B99,$9B9A,$9B9B,$9B9C,$9B9D,$9B9E,$9B9F,$9BA0,$9BA1,
$9BA2,$9BA3,$9BA4,$9BA5,$9BA6,$9BA7,$9BA8,$9BA9,$9BAA,$9BAB,$9BAC,$9BAD,$9BAE,
$9BAF,$9BB0,$9BB1,$9BB2,$9BB3,$9BB4,$9BB5,$9BB6,$9BB7,$9BB8,$9BB9,$9BBA,$9BBB,
$9BBC,$9BBD,$9BBE,$9BBF,$9BC0,$9BC1,$9BC2,$9BC3,$9BC4,$9BC5,$9BC6,$9BC7,$9BC8,
$9BC9,$9BCA,$9BCB,$9BCC,$9BCD,$9BCE,$9BCF,$9BD0,$9BD1,$9BD2,$9BD3,$9BD4,$9BD5,
$9BD6,$9BD7,$9BD8,$9BD9,$9BDA,$9BDB,$9BDC,$9BDD,$9BDE,$9BDF,$9BE0,$9BE1,$9BE2,
$9BE3,$9BE4,$9BE5,$9BE6,$9BE7,$9BE8,$9BE9,$9BEA,$9BEB,$9BEC,$9BED,$9BEE,$9BEF,
$9BF0,$9BF1,$9BF2,$9BF3,$9BF4,$9BF5,$9BF6,$9BF7,$9BF8,$9BF9,$9BFA,$9BFB,$9BFC,
$9BFD,$9BFE,$9C41,$9C42,$9C43,$9C44,$9C45,$9C46,$9C47,$9C48,$9C49,$9C4A,$9C4B,
$9C4C,$9C4D,$9C4E,$9C4F,$9C50,$9C51,$9C52,$9C53,$9C54,$9C55,$9C56,$9C57,$9C58,
$9C59,$9C5A,$9C61,$9C62,$9C63,$9C64,$9C65,$9C66,$9C67,$9C68,$9C69,$9C6A,$9C6B,
$9C6C,$9C6D,$9C6E,$9C6F,$9C70,$9C71,$9C72,$9C73,$9C74,$9C75,$9C76,$9C77,$9C78,
$9C79,$9C7A,$9C81,$9C82,$9C83,$9C84,$9C85,$9C86,$9C87,$9C88,$9C89,$9C8A,$9C8B,
$9C8C,$9C8D,$9C8E,$9C8F,$9C90,$9C91,$9C92,$9C93,$9C94,$9C95,$9C96,$9C97,$9C98,
$9C99,$9C9A,$9C9B,$9C9C,$9C9D,$9C9E,$9C9F,$9CA0,$9CA1,$9CA2,$9CA3,$9CA4,$9CA5,
$9CA6,$9CA7,$9CA8,$9CA9,$9CAA,$9CAB,$9CAC,$9CAD,$9CAE,$9CAF,$9CB0,$9CB1,$9CB2,
$9CB3,$9CB4,$9CB5,$9CB6,$9CB7,$9CB8,$9CB9,$9CBA,$9CBB,$9CBC,$9CBD,$9CBE,$9CBF,
$9CC0,$9CC1,$9CC2,$9CC3,$9CC4,$9CC5,$9CC6,$9CC7,$9CC8,$9CC9,$9CCA,$9CCB,$9CCC,
$9CCD,$9CCE,$9CCF,$9CD0,$9CD1,$9CD2,$9CD3,$9CD4,$9CD5,$9CD6,$9CD7,$9CD8,$9CD9,
$9CDA,$9CDB,$9CDC,$9CDD,$9CDE,$9CDF,$9CE0,$9CE1,$9CE2,$9CE3,$9CE4,$9CE5,$9CE6,
$9CE7,$9CE8,$9CE9,$9CEA,$9CEB,$9CEC,$9CED,$9CEE,$9CEF,$9CF0,$9CF1,$9CF2,$9CF3,
$9CF4,$9CF5,$9CF6,$9CF7,$9CF8,$9CF9,$9CFA,$9CFB,$9CFC,$9CFD,$9CFE,$9D41,$9D42,
$9D43,$9D44,$9D45,$9D46,$9D47,$9D48,$9D49,$9D4A,$9D4B,$9D4C,$9D4D,$9D4E,$9D4F,
$9D50,$9D51,$9D52,$9D53,$9D54,$9D55,$9D56,$9D57,$9D58,$9D59,$9D5A,$9D61,$9D62,
$9D63,$9D64,$9D65,$9D66,$9D67,$9D68,$9D69,$9D6A,$9D6B,$9D6C,$9D6D,$9D6E,$9D6F,
$9D70,$9D71,$9D72,$9D73,$9D74,$9D75,$9D76,$9D77,$9D78,$9D79,$9D7A,$9D81,$9D82,
$9D83,$9D84,$9D85,$9D86,$9D87,$9D88,$9D89,$9D8A,$9D8B,$9D8C,$9D8D,$9D8E,$9D8F,
$9D90,$9D91,$9D92,$9D93,$9D94,$9D95,$9D96,$9D97,$9D98,$9D99,$9D9A,$9D9B,$9D9C,
$9D9D,$9D9E,$9D9F,$9DA0,$9DA1,$9DA2,$9DA3,$9DA4,$9DA5,$9DA6,$9DA7,$9DA8,$9DA9,
$9DAA,$9DAB,$9DAC,$9DAD,$9DAE,$9DAF,$9DB0,$9DB1,$9DB2,$9DB3,$9DB4,$9DB5,$9DB6,
$9DB7,$9DB8,$9DB9,$9DBA,$9DBB,$9DBC,$9DBD,$9DBE,$9DBF,$9DC0,$9DC1,$9DC2,$9DC3,
$9DC4,$9DC5,$9DC6,$9DC7,$9DC8,$9DC9,$9DCA,$9DCB,$9DCC,$9DCD,$9DCE,$9DCF,$9DD0,
$9DD1,$9DD2,$9DD3,$9DD4,$9DD5,$9DD6,$9DD7,$9DD8,$9DD9,$9DDA,$9DDB,$9DDC,$9DDD,
$9DDE,$9DDF,$9DE0,$9DE1,$9DE2,$9DE3,$9DE4,$9DE5,$9DE6,$9DE7,$9DE8,$9DE9,$9DEA,
$9DEB,$9DEC,$9DED,$9DEE,$9DEF,$9DF0,$9DF1,$9DF2,$9DF3,$9DF4,$9DF5,$9DF6,$9DF7,
$9DF8,$9DF9,$9DFA,$9DFB,$9DFC,$9DFD,$9DFE,$9E41,$9E42,$9E43,$9E44,$9E45,$9E46,
$9E47,$9E48,$9E49,$9E4A,$9E4B,$9E4C,$9E4D,$9E4E,$9E4F,$9E50,$9E51,$9E52,$9E53,
$9E54,$9E55,$9E56,$9E57,$9E58,$9E59,$9E5A,$9E61,$9E62,$9E63,$9E64,$9E65,$9E66,
$9E67,$9E68,$9E69,$9E6A,$9E6B,$9E6C,$9E6D,$9E6E,$9E6F,$9E70,$9E71,$9E72,$9E73,
$9E74,$9E75,$9E76,$9E77,$9E78,$9E79,$9E7A,$9E81,$9E82,$9E83,$9E84,$9E85,$9E86,
$9E87,$9E88,$9E89,$9E8A,$9E8B,$9E8C,$9E8D,$9E8E,$9E8F,$9E90,$9E91,$9E92,$9E93,
$9E94,$9E95,$9E96,$9E97,$9E98,$9E99,$9E9A,$9E9B,$9E9C,$9E9D,$9E9E,$9E9F,$9EA0,
$9EA1,$9EA2,$9EA3,$9EA4,$9EA5,$9EA6,$9EA7,$9EA8,$9EA9,$9EAA,$9EAB,$9EAC,$9EAD,
$9EAE,$9EAF,$9EB0,$9EB1,$9EB2,$9EB3,$9EB4,$9EB5,$9EB6,$9EB7,$9EB8,$9EB9,$9EBA,
$9EBB,$9EBC,$9EBD,$9EBE,$9EBF,$9EC0,$9EC1,$9EC2,$9EC3,$9EC4,$9EC5,$9EC6,$9EC7,
$9EC8,$9EC9,$9ECA,$9ECB,$9ECC,$9ECD,$9ECE,$9ECF,$9ED0,$9ED1,$9ED2,$9ED3,$9ED4,
$9ED5,$9ED6,$9ED7,$9ED8,$9ED9,$9EDA,$9EDB,$9EDC,$9EDD,$9EDE,$9EDF,$9EE0,$9EE1,
$9EE2,$9EE3,$9EE4,$9EE5,$9EE6,$9EE7,$9EE8,$9EE9,$9EEA,$9EEB,$9EEC,$9EED,$9EEE,
$9EEF,$9EF0,$9EF1,$9EF2,$9EF3,$9EF4,$9EF5,$9EF6,$9EF7,$9EF8,$9EF9,$9EFA,$9EFB,
$9EFC,$9EFD,$9EFE,$9F41,$9F42,$9F43,$9F44,$9F45,$9F46,$9F47,$9F48,$9F49,$9F4A,
$9F4B,$9F4C,$9F4D,$9F4E,$9F4F,$9F50,$9F51,$9F52,$9F53,$9F54,$9F55,$9F56,$9F57,
$9F58,$9F59,$9F5A,$9F61,$9F62,$9F63,$9F64,$9F65,$9F66,$9F67,$9F68,$9F69,$9F6A,
$9F6B,$9F6C,$9F6D,$9F6E,$9F6F,$9F70,$9F71,$9F72,$9F73,$9F74,$9F75,$9F76,$9F77,
$9F78,$9F79,$9F7A,$9F81,$9F82,$9F83,$9F84,$9F85,$9F86,$9F87,$9F88,$9F89,$9F8A,
$9F8B,$9F8C,$9F8D,$9F8E,$9F8F,$9F90,$9F91,$9F92,$9F93,$9F94,$9F95,$9F96,$9F97,
$9F98,$9F99,$9F9A,$9F9B,$9F9C,$9F9D,$9F9E,$9F9F,$9FA0,$9FA1,$9FA2,$9FA3,$9FA4,
$9FA5,$9FA6,$9FA7,$9FA8,$9FA9,$9FAA,$9FAB,$9FAC,$9FAD,$9FAE,$9FAF,$9FB0,$9FB1,
$9FB2,$9FB3,$9FB4,$9FB5,$9FB6,$9FB7,$9FB8,$9FB9,$9FBA,$9FBB,$9FBC,$9FBD,$9FBE,
$9FBF,$9FC0,$9FC1,$9FC2,$9FC3,$9FC4,$9FC5,$9FC6,$9FC7,$9FC8,$9FC9,$9FCA,$9FCB,
$9FCC,$9FCD,$9FCE,$9FCF,$9FD0,$9FD1,$9FD2,$9FD3,$9FD4,$9FD5,$9FD6,$9FD7,$9FD8,
$9FD9,$9FDA,$9FDB,$9FDC,$9FDD,$9FDE,$9FDF,$9FE0,$9FE1,$9FE2,$9FE3,$9FE4,$9FE5,
$9FE6,$9FE7,$9FE8,$9FE9,$9FEA,$9FEB,$9FEC,$9FED,$9FEE,$9FEF,$9FF0,$9FF1,$9FF2,
$9FF3,$9FF4,$9FF5,$9FF6,$9FF7,$9FF8,$9FF9,$9FFA,$9FFB,$9FFC,$9FFD,$9FFE,$A041,
$A042,$A043,$A044,$A045,$A046,$A047,$A048,$A049,$A04A,$A04B,$A04C,$A04D,$A04E,
$A04F,$A050,$A051,$A052,$A053,$A054,$A055,$A056,$A057,$A058,$A059,$A05A,$A061,
$A062,$A063,$A064,$A065,$A066,$A067,$A068,$A069,$A06A,$A06B,$A06C,$A06D,$A06E,
$A06F,$A070,$A071,$A072,$A073,$A074,$A075,$A076,$A077,$A078,$A079,$A07A,$A081,
$A082,$A083,$A084,$A085,$A086,$A087,$A088,$A089,$A08A,$A08B,$A08C,$A08D,$A08E,
$A08F,$A090,$A091,$A092,$A093,$A094,$A095,$A096,$A097,$A098,$A099,$A09A,$A09B,
$A09C,$A09D,$A09E,$A09F,$A0A0,$A0A1,$A0A2,$A0A3,$A0A4,$A0A5,$A0A6,$A0A7,$A0A8,
$A0A9,$A0AA,$A0AB,$A0AC,$A0AD,$A0AE,$A0AF,$A0B0,$A0B1,$A0B2,$A0B3,$A0B4,$A0B5,
$A0B6,$A0B7,$A0B8,$A0B9,$A0BA,$A0BB,$A0BC,$A0BD,$A0BE,$A0BF,$A0C0,$A0C1,$A0C2,
$A0C3,$A0C4,$A0C5,$A0C6,$A0C7,$A0C8,$A0C9,$A0CA,$A0CB,$A0CC,$A0CD,$A0CE,$A0CF,
$A0D0,$A0D1,$A0D2,$A0D3,$A0D4,$A0D5,$A0D6,$A0D7,$A0D8,$A0D9,$A0DA,$A0DB,$A0DC,
$A0DD,$A0DE,$A0DF,$A0E0,$A0E1,$A0E2,$A0E3,$A0E4,$A0E5,$A0E6,$A0E7,$A0E8,$A0E9,
$A0EA,$A0EB,$A0EC,$A0ED,$A0EE,$A0EF,$A0F0,$A0F1,$A0F2,$A0F3,$A0F4,$A0F5,$A0F6,
$A0F7,$A0F8,$A0F9,$A0FA,$A0FB,$A0FC,$A0FD,$A0FE,$A141,$A142,$A143,$A144,$A145,
$A146,$A147,$A148,$A149,$A14A,$A14B,$A14C,$A14D,$A14E,$A14F,$A150,$A151,$A152,
$A153,$A154,$A155,$A156,$A157,$A158,$A159,$A15A,$A161,$A162,$A163,$A164,$A165,
$A166,$A167,$A168,$A169,$A16A,$A16B,$A16C,$A16D,$A16E,$A16F,$A170,$A171,$A172,
$A173,$A174,$A175,$A176,$A177,$A178,$A179,$A17A,$A181,$A182,$A183,$A184,$A185,
$A186,$A187,$A188,$A189,$A18A,$A18B,$A18C,$A18D,$A18E,$A18F,$A190,$A191,$A192,
$A193,$A194,$A195,$A196,$A197,$A198,$A199,$A19A,$A19B,$A19C,$A19D,$A19E,$A19F,
$A1A0,$A1A1,$A1A2,$A1A3,$A1A4,$A1A5,$A1A6,$A1A7,$A1A8,$A1A9,$A1AA,$A1AB,$A1AC,
$A1AD,$A1AE,$A1AF,$A1B0,$A1B1,$A1B2,$A1B3,$A1B4,$A1B5,$A1B6,$A1B7,$A1B8,$A1B9,
$A1BA,$A1BB,$A1BC,$A1BD,$A1BE,$A1BF,$A1C0,$A1C1,$A1C2,$A1C3,$A1C4,$A1C5,$A1C6,
$A1C7,$A1C8,$A1C9,$A1CA,$A1CB,$A1CC,$A1CD,$A1CE,$A1CF,$A1D0,$A1D1,$A1D2,$A1D3,
$A1D4,$A1D5,$A1D6,$A1D7,$A1D8,$A1D9,$A1DA,$A1DB,$A1DC,$A1DD,$A1DE,$A1DF,$A1E0,
$A1E1,$A1E2,$A1E3,$A1E4,$A1E5,$A1E6,$A1E7,$A1E8,$A1E9,$A1EA,$A1EB,$A1EC,$A1ED,
$A1EE,$A1EF,$A1F0,$A1F1,$A1F2,$A1F3,$A1F4,$A1F5,$A1F6,$A1F7,$A1F8,$A1F9,$A1FA,
$A1FB,$A1FC,$A1FD,$A1FE,$A241,$A242,$A243,$A244,$A245,$A246,$A247,$A248,$A249,
$A24A,$A24B,$A24C,$A24D,$A24E,$A24F,$A250,$A251,$A252,$A253,$A254,$A255,$A256,
$A257,$A258,$A259,$A25A,$A261,$A262,$A263,$A264,$A265,$A266,$A267,$A268,$A269,
$A26A,$A26B,$A26C,$A26D,$A26E,$A26F,$A270,$A271,$A272,$A273,$A274,$A275,$A276,
$A277,$A278,$A279,$A27A,$A281,$A282,$A283,$A284,$A285,$A286,$A287,$A288,$A289,
$A28A,$A28B,$A28C,$A28D,$A28E,$A28F,$A290,$A291,$A292,$A293,$A294,$A295,$A296,
$A297,$A298,$A299,$A29A,$A29B,$A29C,$A29D,$A29E,$A29F,$A2A0,$A2A1,$A2A2,$A2A3,
$A2A4,$A2A5,$A2A6,$A2A7,$A2A8,$A2A9,$A2AA,$A2AB,$A2AC,$A2AD,$A2AE,$A2AF,$A2B0,
$A2B1,$A2B2,$A2B3,$A2B4,$A2B5,$A2B6,$A2B7,$A2B8,$A2B9,$A2BA,$A2BB,$A2BC,$A2BD,
$A2BE,$A2BF,$A2C0,$A2C1,$A2C2,$A2C3,$A2C4,$A2C5,$A2C6,$A2C7,$A2C8,$A2C9,$A2CA,
$A2CB,$A2CC,$A2CD,$A2CE,$A2CF,$A2D0,$A2D1,$A2D2,$A2D3,$A2D4,$A2D5,$A2D6,$A2D7,
$A2D8,$A2D9,$A2DA,$A2DB,$A2DC,$A2DD,$A2DE,$A2DF,$A2E0,$A2E1,$A2E2,$A2E3,$A2E4,
$A2E5,$A2E6,$A2E7,$A341,$A342,$A343,$A344,$A345,$A346,$A347,$A348,$A349,$A34A,
$A34B,$A34C,$A34D,$A34E,$A34F,$A350,$A351,$A352,$A353,$A354,$A355,$A356,$A357,
$A358,$A359,$A35A,$A361,$A362,$A363,$A364,$A365,$A366,$A367,$A368,$A369,$A36A,
$A36B,$A36C,$A36D,$A36E,$A36F,$A370,$A371,$A372,$A373,$A374,$A375,$A376,$A377,
$A378,$A379,$A37A,$A381,$A382,$A383,$A384,$A385,$A386,$A387,$A388,$A389,$A38A,
$A38B,$A38C,$A38D,$A38E,$A38F,$A390,$A391,$A392,$A393,$A394,$A395,$A396,$A397,
$A398,$A399,$A39A,$A39B,$A39C,$A39D,$A39E,$A39F,$A3A0,$A3A1,$A3A2,$A3A3,$A3A4,
$A3A5,$A3A6,$A3A7,$A3A8,$A3A9,$A3AA,$A3AB,$A3AC,$A3AD,$A3AE,$A3AF,$A3B0,$A3B1,
$A3B2,$A3B3,$A3B4,$A3B5,$A3B6,$A3B7,$A3B8,$A3B9,$A3BA,$A3BB,$A3BC,$A3BD,$A3BE,
$A3BF,$A3C0,$A3C1,$A3C2,$A3C3,$A3C4,$A3C5,$A3C6,$A3C7,$A3C8,$A3C9,$A3CA,$A3CB,
$A3CC,$A3CD,$A3CE,$A3CF,$A3D0,$A3D1,$A3D2,$A3D3,$A3D4,$A3D5,$A3D6,$A3D7,$A3D8,
$A3D9,$A3DA,$A3DB,$A3DC,$A3DD,$A3DE,$A3DF,$A3E0,$A3E1,$A3E2,$A3E3,$A3E4,$A3E5,
$A3E6,$A3E7,$A3E8,$A3E9,$A3EA,$A3EB,$A3EC,$A3ED,$A3EE,$A3EF,$A3F0,$A3F1,$A3F2,
$A3F3,$A3F4,$A3F5,$A3F6,$A3F7,$A3F8,$A3F9,$A3FA,$A3FB,$A3FC,$A3FD,$A3FE,$A441,
$A442,$A443,$A444,$A445,$A446,$A447,$A448,$A449,$A44A,$A44B,$A44C,$A44D,$A44E,
$A44F,$A450,$A451,$A452,$A453,$A454,$A455,$A456,$A457,$A458,$A459,$A45A,$A461,
$A462,$A463,$A464,$A465,$A466,$A467,$A468,$A469,$A46A,$A46B,$A46C,$A46D,$A46E,
$A46F,$A470,$A471,$A472,$A473,$A474,$A475,$A476,$A477,$A478,$A479,$A47A,$A481,
$A482,$A483,$A484,$A485,$A486,$A487,$A488,$A489,$A48A,$A48B,$A48C,$A48D,$A48E,
$A48F,$A490,$A491,$A492,$A493,$A494,$A495,$A496,$A497,$A498,$A499,$A49A,$A49B,
$A49C,$A49D,$A49E,$A49F,$A4A0,$A4A1,$A4A2,$A4A3,$A4A4,$A4A5,$A4A6,$A4A7,$A4A8,
$A4A9,$A4AA,$A4AB,$A4AC,$A4AD,$A4AE,$A4AF,$A4B0,$A4B1,$A4B2,$A4B3,$A4B4,$A4B5,
$A4B6,$A4B7,$A4B8,$A4B9,$A4BA,$A4BB,$A4BC,$A4BD,$A4BE,$A4BF,$A4C0,$A4C1,$A4C2,
$A4C3,$A4C4,$A4C5,$A4C6,$A4C7,$A4C8,$A4C9,$A4CA,$A4CB,$A4CC,$A4CD,$A4CE,$A4CF,
$A4D0,$A4D1,$A4D2,$A4D3,$A4D4,$A4D5,$A4D6,$A4D7,$A4D8,$A4D9,$A4DA,$A4DB,$A4DC,
$A4DD,$A4DE,$A4DF,$A4E0,$A4E1,$A4E2,$A4E3,$A4E4,$A4E5,$A4E6,$A4E7,$A4E8,$A4E9,
$A4EA,$A4EB,$A4EC,$A4ED,$A4EE,$A4EF,$A4F0,$A4F1,$A4F2,$A4F3,$A4F4,$A4F5,$A4F6,
$A4F7,$A4F8,$A4F9,$A4FA,$A4FB,$A4FC,$A4FD,$A4FE,$A541,$A542,$A543,$A544,$A545,
$A546,$A547,$A548,$A549,$A54A,$A54B,$A54C,$A54D,$A54E,$A54F,$A550,$A551,$A552,
$A553,$A554,$A555,$A556,$A557,$A558,$A559,$A55A,$A561,$A562,$A563,$A564,$A565,
$A566,$A567,$A568,$A569,$A56A,$A56B,$A56C,$A56D,$A56E,$A56F,$A570,$A571,$A572,
$A573,$A574,$A575,$A576,$A577,$A578,$A579,$A57A,$A581,$A582,$A583,$A584,$A585,
$A586,$A587,$A588,$A589,$A58A,$A58B,$A58C,$A58D,$A58E,$A58F,$A590,$A591,$A592,
$A593,$A594,$A595,$A596,$A597,$A598,$A599,$A59A,$A59B,$A59C,$A59D,$A59E,$A59F,
$A5A0,$A5A1,$A5A2,$A5A3,$A5A4,$A5A5,$A5A6,$A5A7,$A5A8,$A5A9,$A5AA,$A5B0,$A5B1,
$A5B2,$A5B3,$A5B4,$A5B5,$A5B6,$A5B7,$A5B8,$A5B9,$A5C1,$A5C2,$A5C3,$A5C4,$A5C5,
$A5C6,$A5C7,$A5C8,$A5C9,$A5CA,$A5CB,$A5CC,$A5CD,$A5CE,$A5CF,$A5D0,$A5D1,$A5D2,
$A5D3,$A5D4,$A5D5,$A5D6,$A5D7,$A5D8,$A5E1,$A5E2,$A5E3,$A5E4,$A5E5,$A5E6,$A5E7,
$A5E8,$A5E9,$A5EA,$A5EB,$A5EC,$A5ED,$A5EE,$A5EF,$A5F0,$A5F1,$A5F2,$A5F3,$A5F4,
$A5F5,$A5F6,$A5F7,$A5F8,$A641,$A642,$A643,$A644,$A645,$A646,$A647,$A648,$A649,
$A64A,$A64B,$A64C,$A64D,$A64E,$A64F,$A650,$A651,$A652,$A653,$A654,$A655,$A656,
$A657,$A658,$A659,$A65A,$A661,$A662,$A663,$A664,$A665,$A666,$A667,$A668,$A669,
$A66A,$A66B,$A66C,$A66D,$A66E,$A66F,$A670,$A671,$A672,$A673,$A674,$A675,$A676,
$A677,$A678,$A679,$A67A,$A681,$A682,$A683,$A684,$A685,$A686,$A687,$A688,$A689,
$A68A,$A68B,$A68C,$A68D,$A68E,$A68F,$A690,$A691,$A692,$A693,$A694,$A695,$A696,
$A697,$A698,$A699,$A69A,$A69B,$A69C,$A69D,$A69E,$A69F,$A6A0,$A6A1,$A6A2,$A6A3,
$A6A4,$A6A5,$A6A6,$A6A7,$A6A8,$A6A9,$A6AA,$A6AB,$A6AC,$A6AD,$A6AE,$A6AF,$A6B0,
$A6B1,$A6B2,$A6B3,$A6B4,$A6B5,$A6B6,$A6B7,$A6B8,$A6B9,$A6BA,$A6BB,$A6BC,$A6BD,
$A6BE,$A6BF,$A6C0,$A6C1,$A6C2,$A6C3,$A6C4,$A6C5,$A6C6,$A6C7,$A6C8,$A6C9,$A6CA,
$A6CB,$A6CC,$A6CD,$A6CE,$A6CF,$A6D0,$A6D1,$A6D2,$A6D3,$A6D4,$A6D5,$A6D6,$A6D7,
$A6D8,$A6D9,$A6DA,$A6DB,$A6DC,$A6DD,$A6DE,$A6DF,$A6E0,$A6E1,$A6E2,$A6E3,$A6E4,
$A741,$A742,$A743,$A744,$A745,$A746,$A747,$A748,$A749,$A74A,$A74B,$A74C,$A74D,
$A74E,$A74F,$A750,$A751,$A752,$A753,$A754,$A755,$A756,$A757,$A758,$A759,$A75A,
$A761,$A762,$A763,$A764,$A765,$A766,$A767,$A768,$A769,$A76A,$A76B,$A76C,$A76D,
$A76E,$A76F,$A770,$A771,$A772,$A773,$A774,$A775,$A776,$A777,$A778,$A779,$A77A,
$A781,$A782,$A783,$A784,$A785,$A786,$A787,$A788,$A789,$A78A,$A78B,$A78C,$A78D,
$A78E,$A78F,$A790,$A791,$A792,$A793,$A794,$A795,$A796,$A797,$A798,$A799,$A79A,
$A79B,$A79C,$A79D,$A79E,$A79F,$A7A0,$A7A1,$A7A2,$A7A3,$A7A4,$A7A5,$A7A6,$A7A7,
$A7A8,$A7A9,$A7AA,$A7AB,$A7AC,$A7AD,$A7AE,$A7AF,$A7B0,$A7B1,$A7B2,$A7B3,$A7B4,
$A7B5,$A7B6,$A7B7,$A7B8,$A7B9,$A7BA,$A7BB,$A7BC,$A7BD,$A7BE,$A7BF,$A7C0,$A7C1,
$A7C2,$A7C3,$A7C4,$A7C5,$A7C6,$A7C7,$A7C8,$A7C9,$A7CA,$A7CB,$A7CC,$A7CD,$A7CE,
$A7CF,$A7D0,$A7D1,$A7D2,$A7D3,$A7D4,$A7D5,$A7D6,$A7D7,$A7D8,$A7D9,$A7DA,$A7DB,
$A7DC,$A7DD,$A7DE,$A7DF,$A7E0,$A7E1,$A7E2,$A7E3,$A7E4,$A7E5,$A7E6,$A7E7,$A7E8,
$A7E9,$A7EA,$A7EB,$A7EC,$A7ED,$A7EE,$A7EF,$A841,$A842,$A843,$A844,$A845,$A846,
$A847,$A848,$A849,$A84A,$A84B,$A84C,$A84D,$A84E,$A84F,$A850,$A851,$A852,$A853,
$A854,$A855,$A856,$A857,$A858,$A859,$A85A,$A861,$A862,$A863,$A864,$A865,$A866,
$A867,$A868,$A869,$A86A,$A86B,$A86C,$A86D,$A86E,$A86F,$A870,$A871,$A872,$A873,
$A874,$A875,$A876,$A877,$A878,$A879,$A87A,$A881,$A882,$A883,$A884,$A885,$A886,
$A887,$A888,$A889,$A88A,$A88B,$A88C,$A88D,$A88E,$A88F,$A890,$A891,$A892,$A893,
$A894,$A895,$A896,$A897,$A898,$A899,$A89A,$A89B,$A89C,$A89D,$A89E,$A89F,$A8A0,
$A8A1,$A8A2,$A8A3,$A8A4,$A8A6,$A8A8,$A8A9,$A8AA,$A8AB,$A8AC,$A8AD,$A8AE,$A8AF,
$A8B1,$A8B2,$A8B3,$A8B4,$A8B5,$A8B6,$A8B7,$A8B8,$A8B9,$A8BA,$A8BB,$A8BC,$A8BD,
$A8BE,$A8BF,$A8C0,$A8C1,$A8C2,$A8C3,$A8C4,$A8C5,$A8C6,$A8C7,$A8C8,$A8C9,$A8CA,
$A8CB,$A8CC,$A8CD,$A8CE,$A8CF,$A8D0,$A8D1,$A8D2,$A8D3,$A8D4,$A8D5,$A8D6,$A8D7,
$A8D8,$A8D9,$A8DA,$A8DB,$A8DC,$A8DD,$A8DE,$A8DF,$A8E0,$A8E1,$A8E2,$A8E3,$A8E4,
$A8E5,$A8E6,$A8E7,$A8E8,$A8E9,$A8EA,$A8EB,$A8EC,$A8ED,$A8EE,$A8EF,$A8F0,$A8F1,
$A8F2,$A8F3,$A8F4,$A8F5,$A8F6,$A8F7,$A8F8,$A8F9,$A8FA,$A8FB,$A8FC,$A8FD,$A8FE,
$A941,$A942,$A943,$A944,$A945,$A946,$A947,$A948,$A949,$A94A,$A94B,$A94C,$A94D,
$A94E,$A94F,$A950,$A951,$A952,$A953,$A954,$A955,$A956,$A957,$A958,$A959,$A95A,
$A961,$A962,$A963,$A964,$A965,$A966,$A967,$A968,$A969,$A96A,$A96B,$A96C,$A96D,
$A96E,$A96F,$A970,$A971,$A972,$A973,$A974,$A975,$A976,$A977,$A978,$A979,$A97A,
$A981,$A982,$A983,$A984,$A985,$A986,$A987,$A988,$A989,$A98A,$A98B,$A98C,$A98D,
$A98E,$A98F,$A990,$A991,$A992,$A993,$A994,$A995,$A996,$A997,$A998,$A999,$A99A,
$A99B,$A99C,$A99D,$A99E,$A99F,$A9A0,$A9A1,$A9A2,$A9A3,$A9A4,$A9A5,$A9A6,$A9A7,
$A9A8,$A9A9,$A9AA,$A9AB,$A9AC,$A9AD,$A9AE,$A9AF,$A9B0,$A9B1,$A9B2,$A9B3,$A9B4,
$A9B5,$A9B6,$A9B7,$A9B8,$A9B9,$A9BA,$A9BB,$A9BC,$A9BD,$A9BE,$A9BF,$A9C0,$A9C1,
$A9C2,$A9C3,$A9C4,$A9C5,$A9C6,$A9C7,$A9C8,$A9C9,$A9CA,$A9CB,$A9CC,$A9CD,$A9CE,
$A9CF,$A9D0,$A9D1,$A9D2,$A9D3,$A9D4,$A9D5,$A9D6,$A9D7,$A9D8,$A9D9,$A9DA,$A9DB,
$A9DC,$A9DD,$A9DE,$A9DF,$A9E0,$A9E1,$A9E2,$A9E3,$A9E4,$A9E5,$A9E6,$A9E7,$A9E8,
$A9E9,$A9EA,$A9EB,$A9EC,$A9ED,$A9EE,$A9EF,$A9F0,$A9F1,$A9F2,$A9F3,$A9F4,$A9F5,
$A9F6,$A9F7,$A9F8,$A9F9,$A9FA,$A9FB,$A9FC,$A9FD,$A9FE,$AA41,$AA42,$AA43,$AA44,
$AA45,$AA46,$AA47,$AA48,$AA49,$AA4A,$AA4B,$AA4C,$AA4D,$AA4E,$AA4F,$AA50,$AA51,
$AA52,$AA53,$AA54,$AA55,$AA56,$AA57,$AA58,$AA59,$AA5A,$AA61,$AA62,$AA63,$AA64,
$AA65,$AA66,$AA67,$AA68,$AA69,$AA6A,$AA6B,$AA6C,$AA6D,$AA6E,$AA6F,$AA70,$AA71,
$AA72,$AA73,$AA74,$AA75,$AA76,$AA77,$AA78,$AA79,$AA7A,$AA81,$AA82,$AA83,$AA84,
$AA85,$AA86,$AA87,$AA88,$AA89,$AA8A,$AA8B,$AA8C,$AA8D,$AA8E,$AA8F,$AA90,$AA91,
$AA92,$AA93,$AA94,$AA95,$AA96,$AA97,$AA98,$AA99,$AA9A,$AA9B,$AA9C,$AA9D,$AA9E,
$AA9F,$AAA0,$AAA1,$AAA2,$AAA3,$AAA4,$AAA5,$AAA6,$AAA7,$AAA8,$AAA9,$AAAA,$AAAB,
$AAAC,$AAAD,$AAAE,$AAAF,$AAB0,$AAB1,$AAB2,$AAB3,$AAB4,$AAB5,$AAB6,$AAB7,$AAB8,
$AAB9,$AABA,$AABB,$AABC,$AABD,$AABE,$AABF,$AAC0,$AAC1,$AAC2,$AAC3,$AAC4,$AAC5,
$AAC6,$AAC7,$AAC8,$AAC9,$AACA,$AACB,$AACC,$AACD,$AACE,$AACF,$AAD0,$AAD1,$AAD2,
$AAD3,$AAD4,$AAD5,$AAD6,$AAD7,$AAD8,$AAD9,$AADA,$AADB,$AADC,$AADD,$AADE,$AADF,
$AAE0,$AAE1,$AAE2,$AAE3,$AAE4,$AAE5,$AAE6,$AAE7,$AAE8,$AAE9,$AAEA,$AAEB,$AAEC,
$AAED,$AAEE,$AAEF,$AAF0,$AAF1,$AAF2,$AAF3,$AB41,$AB42,$AB43,$AB44,$AB45,$AB46,
$AB47,$AB48,$AB49,$AB4A,$AB4B,$AB4C,$AB4D,$AB4E,$AB4F,$AB50,$AB51,$AB52,$AB53,
$AB54,$AB55,$AB56,$AB57,$AB58,$AB59,$AB5A,$AB61,$AB62,$AB63,$AB64,$AB65,$AB66,
$AB67,$AB68,$AB69,$AB6A,$AB6B,$AB6C,$AB6D,$AB6E,$AB6F,$AB70,$AB71,$AB72,$AB73,
$AB74,$AB75,$AB76,$AB77,$AB78,$AB79,$AB7A,$AB81,$AB82,$AB83,$AB84,$AB85,$AB86,
$AB87,$AB88,$AB89,$AB8A,$AB8B,$AB8C,$AB8D,$AB8E,$AB8F,$AB90,$AB91,$AB92,$AB93,
$AB94,$AB95,$AB96,$AB97,$AB98,$AB99,$AB9A,$AB9B,$AB9C,$AB9D,$AB9E,$AB9F,$ABA0,
$ABA1,$ABA2,$ABA3,$ABA4,$ABA5,$ABA6,$ABA7,$ABA8,$ABA9,$ABAA,$ABAB,$ABAC,$ABAD,
$ABAE,$ABAF,$ABB0,$ABB1,$ABB2,$ABB3,$ABB4,$ABB5,$ABB6,$ABB7,$ABB8,$ABB9,$ABBA,
$ABBB,$ABBC,$ABBD,$ABBE,$ABBF,$ABC0,$ABC1,$ABC2,$ABC3,$ABC4,$ABC5,$ABC6,$ABC7,
$ABC8,$ABC9,$ABCA,$ABCB,$ABCC,$ABCD,$ABCE,$ABCF,$ABD0,$ABD1,$ABD2,$ABD3,$ABD4,
$ABD5,$ABD6,$ABD7,$ABD8,$ABD9,$ABDA,$ABDB,$ABDC,$ABDD,$ABDE,$ABDF,$ABE0,$ABE1,
$ABE2,$ABE3,$ABE4,$ABE5,$ABE6,$ABE7,$ABE8,$ABE9,$ABEA,$ABEB,$ABEC,$ABED,$ABEE,
$ABEF,$ABF0,$ABF1,$ABF2,$ABF3,$ABF4,$ABF5,$ABF6,$AC41,$AC42,$AC43,$AC44,$AC45,
$AC46,$AC47,$AC48,$AC49,$AC4A,$AC4B,$AC4C,$AC4D,$AC4E,$AC4F,$AC50,$AC51,$AC52,
$AC53,$AC54,$AC55,$AC56,$AC57,$AC58,$AC59,$AC5A,$AC61,$AC62,$AC63,$AC64,$AC65,
$AC66,$AC67,$AC68,$AC69,$AC6A,$AC6B,$AC6C,$AC6D,$AC6E,$AC6F,$AC70,$AC71,$AC72,
$AC73,$AC74,$AC75,$AC76,$AC77,$AC78,$AC79,$AC7A,$AC81,$AC82,$AC83,$AC84,$AC85,
$AC86,$AC87,$AC88,$AC89,$AC8A,$AC8B,$AC8C,$AC8D,$AC8E,$AC8F,$AC90,$AC91,$AC92,
$AC93,$AC94,$AC95,$AC96,$AC97,$AC98,$AC99,$AC9A,$AC9B,$AC9C,$AC9D,$AC9E,$AC9F,
$ACA0,$ACA1,$ACA2,$ACA3,$ACA4,$ACA5,$ACA6,$ACA7,$ACA8,$ACA9,$ACAA,$ACAB,$ACAC,
$ACAD,$ACAE,$ACAF,$ACB0,$ACB1,$ACB2,$ACB3,$ACB4,$ACB5,$ACB6,$ACB7,$ACB8,$ACB9,
$ACBA,$ACBB,$ACBC,$ACBD,$ACBE,$ACBF,$ACC0,$ACC1,$ACD1,$ACD2,$ACD3,$ACD4,$ACD5,
$ACD6,$ACD7,$ACD8,$ACD9,$ACDA,$ACDB,$ACDC,$ACDD,$ACDE,$ACDF,$ACE0,$ACE1,$ACE2,
$ACE3,$ACE4,$ACE5,$ACE6,$ACE7,$ACE8,$ACE9,$ACEA,$ACEB,$ACEC,$ACED,$ACEE,$ACEF,
$ACF0,$ACF1,$AD41,$AD42,$AD43,$AD44,$AD45,$AD46,$AD47,$AD48,$AD49,$AD4A,$AD4B,
$AD4C,$AD4D,$AD4E,$AD4F,$AD50,$AD51,$AD52,$AD53,$AD54,$AD55,$AD56,$AD57,$AD58,
$AD59,$AD5A,$AD61,$AD62,$AD63,$AD64,$AD65,$AD66,$AD67,$AD68,$AD69,$AD6A,$AD6B,
$AD6C,$AD6D,$AD6E,$AD6F,$AD70,$AD71,$AD72,$AD73,$AD74,$AD75,$AD76,$AD77,$AD78,
$AD79,$AD7A,$AD81,$AD82,$AD83,$AD84,$AD85,$AD86,$AD87,$AD88,$AD89,$AD8A,$AD8B,
$AD8C,$AD8D,$AD8E,$AD8F,$AD90,$AD91,$AD92,$AD93,$AD94,$AD95,$AD96,$AD97,$AD98,
$AD99,$AD9A,$AD9B,$AD9C,$AD9D,$AD9E,$AD9F,$ADA0,$AE41,$AE42,$AE43,$AE44,$AE45,
$AE46,$AE47,$AE48,$AE49,$AE4A,$AE4B,$AE4C,$AE4D,$AE4E,$AE4F,$AE50,$AE51,$AE52,
$AE53,$AE54,$AE55,$AE56,$AE57,$AE58,$AE59,$AE5A,$AE61,$AE62,$AE63,$AE64,$AE65,
$AE66,$AE67,$AE68,$AE69,$AE6A,$AE6B,$AE6C,$AE6D,$AE6E,$AE6F,$AE70,$AE71,$AE72,
$AE73,$AE74,$AE75,$AE76,$AE77,$AE78,$AE79,$AE7A,$AE81,$AE82,$AE83,$AE84,$AE85,
$AE86,$AE87,$AE88,$AE89,$AE8A,$AE8B,$AE8C,$AE8D,$AE8E,$AE8F,$AE90,$AE91,$AE92,
$AE93,$AE94,$AE95,$AE96,$AE97,$AE98,$AE99,$AE9A,$AE9B,$AE9C,$AE9D,$AE9E,$AE9F,
$AEA0,$AF41,$AF42,$AF43,$AF44,$AF45,$AF46,$AF47,$AF48,$AF49,$AF4A,$AF4B,$AF4C,
$AF4D,$AF4E,$AF4F,$AF50,$AF51,$AF52,$AF53,$AF54,$AF55,$AF56,$AF57,$AF58,$AF59,
$AF5A,$AF61,$AF62,$AF63,$AF64,$AF65,$AF66,$AF67,$AF68,$AF69,$AF6A,$AF6B,$AF6C,
$AF6D,$AF6E,$AF6F,$AF70,$AF71,$AF72,$AF73,$AF74,$AF75,$AF76,$AF77,$AF78,$AF79,
$AF7A,$AF81,$AF82,$AF83,$AF84,$AF85,$AF86,$AF87,$AF88,$AF89,$AF8A,$AF8B,$AF8C,
$AF8D,$AF8E,$AF8F,$AF90,$AF91,$AF92,$AF93,$AF94,$AF95,$AF96,$AF97,$AF98,$AF99,
$AF9A,$AF9B,$AF9C,$AF9D,$AF9E,$AF9F,$AFA0,$B041,$B042,$B043,$B044,$B045,$B046,
$B047,$B048,$B049,$B04A,$B04B,$B04C,$B04D,$B04E,$B04F,$B050,$B051,$B052,$B053,
$B054,$B055,$B056,$B057,$B058,$B059,$B05A,$B061,$B062,$B063,$B064,$B065,$B066,
$B067,$B068,$B069,$B06A,$B06B,$B06C,$B06D,$B06E,$B06F,$B070,$B071,$B072,$B073,
$B074,$B075,$B076,$B077,$B078,$B079,$B07A,$B081,$B082,$B083,$B084,$B085,$B086,
$B087,$B088,$B089,$B08A,$B08B,$B08C,$B08D,$B08E,$B08F,$B090,$B091,$B092,$B093,
$B094,$B095,$B096,$B097,$B098,$B099,$B09A,$B09B,$B09C,$B09D,$B09E,$B09F,$B0A0,
$B0A1,$B0A2,$B0A3,$B0A4,$B0A5,$B0A6,$B0A7,$B0A8,$B0A9,$B0AA,$B0AB,$B0AC,$B0AD,
$B0AE,$B0AF,$B0B0,$B0B1,$B0B2,$B0B3,$B0B4,$B0B5,$B0B6,$B0B7,$B0B8,$B0B9,$B0BA,
$B0BB,$B0BC,$B0BD,$B0BE,$B0BF,$B0C0,$B0C1,$B0C2,$B0C3,$B0C4,$B0C5,$B0C6,$B0C7,
$B0C8,$B0C9,$B0CA,$B0CB,$B0CC,$B0CD,$B0CE,$B0CF,$B0D0,$B0D1,$B0D2,$B0D3,$B0D4,
$B0D5,$B0D6,$B0D7,$B0D8,$B0D9,$B0DA,$B0DB,$B0DC,$B0DD,$B0DE,$B0DF,$B0E0,$B0E1,
$B0E2,$B0E3,$B0E4,$B0E5,$B0E6,$B0E7,$B0E8,$B0E9,$B0EA,$B0EB,$B0EC,$B0ED,$B0EE,
$B0EF,$B0F0,$B0F1,$B0F2,$B0F3,$B0F4,$B0F5,$B0F6,$B0F7,$B0F8,$B0F9,$B0FA,$B0FB,
$B0FC,$B0FD,$B0FE,$B141,$B142,$B143,$B144,$B145,$B146,$B147,$B148,$B149,$B14A,
$B14B,$B14C,$B14D,$B14E,$B14F,$B150,$B151,$B152,$B153,$B154,$B155,$B156,$B157,
$B158,$B159,$B15A,$B161,$B162,$B163,$B164,$B165,$B166,$B167,$B168,$B169,$B16A,
$B16B,$B16C,$B16D,$B16E,$B16F,$B170,$B171,$B172,$B173,$B174,$B175,$B176,$B177,
$B178,$B179,$B17A,$B181,$B182,$B183,$B184,$B185,$B186,$B187,$B188,$B189,$B18A,
$B18B,$B18C,$B18D,$B18E,$B18F,$B190,$B191,$B192,$B193,$B194,$B195,$B196,$B197,
$B198,$B199,$B19A,$B19B,$B19C,$B19D,$B19E,$B19F,$B1A0,$B1A1,$B1A2,$B1A3,$B1A4,
$B1A5,$B1A6,$B1A7,$B1A8,$B1A9,$B1AA,$B1AB,$B1AC,$B1AD,$B1AE,$B1AF,$B1B0,$B1B1,
$B1B2,$B1B3,$B1B4,$B1B5,$B1B6,$B1B7,$B1B8,$B1B9,$B1BA,$B1BB,$B1BC,$B1BD,$B1BE,
$B1BF,$B1C0,$B1C1,$B1C2,$B1C3,$B1C4,$B1C5,$B1C6,$B1C7,$B1C8,$B1C9,$B1CA,$B1CB,
$B1CC,$B1CD,$B1CE,$B1CF,$B1D0,$B1D1,$B1D2,$B1D3,$B1D4,$B1D5,$B1D6,$B1D7,$B1D8,
$B1D9,$B1DA,$B1DB,$B1DC,$B1DD,$B1DE,$B1DF,$B1E0,$B1E1,$B1E2,$B1E3,$B1E4,$B1E5,
$B1E6,$B1E7,$B1E8,$B1E9,$B1EA,$B1EB,$B1EC,$B1ED,$B1EE,$B1EF,$B1F0,$B1F1,$B1F2,
$B1F3,$B1F4,$B1F5,$B1F6,$B1F7,$B1F8,$B1F9,$B1FA,$B1FB,$B1FC,$B1FD,$B1FE,$B241,
$B242,$B243,$B244,$B245,$B246,$B247,$B248,$B249,$B24A,$B24B,$B24C,$B24D,$B24E,
$B24F,$B250,$B251,$B252,$B253,$B254,$B255,$B256,$B257,$B258,$B259,$B25A,$B261,
$B262,$B263,$B264,$B265,$B266,$B267,$B268,$B269,$B26A,$B26B,$B26C,$B26D,$B26E,
$B26F,$B270,$B271,$B272,$B273,$B274,$B275,$B276,$B277,$B278,$B279,$B27A,$B281,
$B282,$B283,$B284,$B285,$B286,$B287,$B288,$B289,$B28A,$B28B,$B28C,$B28D,$B28E,
$B28F,$B290,$B291,$B292,$B293,$B294,$B295,$B296,$B297,$B298,$B299,$B29A,$B29B,
$B29C,$B29D,$B29E,$B29F,$B2A0,$B2A1,$B2A2,$B2A3,$B2A4,$B2A5,$B2A6,$B2A7,$B2A8,
$B2A9,$B2AA,$B2AB,$B2AC,$B2AD,$B2AE,$B2AF,$B2B0,$B2B1,$B2B2,$B2B3,$B2B4,$B2B5,
$B2B6,$B2B7,$B2B8,$B2B9,$B2BA,$B2BB,$B2BC,$B2BD,$B2BE,$B2BF,$B2C0,$B2C1,$B2C2,
$B2C3,$B2C4,$B2C5,$B2C6,$B2C7,$B2C8,$B2C9,$B2CA,$B2CB,$B2CC,$B2CD,$B2CE,$B2CF,
$B2D0,$B2D1,$B2D2,$B2D3,$B2D4,$B2D5,$B2D6,$B2D7,$B2D8,$B2D9,$B2DA,$B2DB,$B2DC,
$B2DD,$B2DE,$B2DF,$B2E0,$B2E1,$B2E2,$B2E3,$B2E4,$B2E5,$B2E6,$B2E7,$B2E8,$B2E9,
$B2EA,$B2EB,$B2EC,$B2ED,$B2EE,$B2EF,$B2F0,$B2F1,$B2F2,$B2F3,$B2F4,$B2F5,$B2F6,
$B2F7,$B2F8,$B2F9,$B2FA,$B2FB,$B2FC,$B2FD,$B2FE,$B341,$B342,$B343,$B344,$B345,
$B346,$B347,$B348,$B349,$B34A,$B34B,$B34C,$B34D,$B34E,$B34F,$B350,$B351,$B352,
$B353,$B354,$B355,$B356,$B357,$B358,$B359,$B35A,$B361,$B362,$B363,$B364,$B365,
$B366,$B367,$B368,$B369,$B36A,$B36B,$B36C,$B36D,$B36E,$B36F,$B370,$B371,$B372,
$B373,$B374,$B375,$B376,$B377,$B378,$B379,$B37A,$B381,$B382,$B383,$B384,$B385,
$B386,$B387,$B388,$B389,$B38A,$B38B,$B38C,$B38D,$B38E,$B38F,$B390,$B391,$B392,
$B393,$B394,$B395,$B396,$B397,$B398,$B399,$B39A,$B39B,$B39C,$B39D,$B39E,$B39F,
$B3A0,$B3A1,$B3A2,$B3A3,$B3A4,$B3A5,$B3A6,$B3A7,$B3A8,$B3A9,$B3AA,$B3AB,$B3AC,
$B3AD,$B3AE,$B3AF,$B3B0,$B3B1,$B3B2,$B3B3,$B3B4,$B3B5,$B3B6,$B3B7,$B3B8,$B3B9,
$B3BA,$B3BB,$B3BC,$B3BD,$B3BE,$B3BF,$B3C0,$B3C1,$B3C2,$B3C3,$B3C4,$B3C5,$B3C6,
$B3C7,$B3C8,$B3C9,$B3CA,$B3CB,$B3CC,$B3CD,$B3CE,$B3CF,$B3D0,$B3D1,$B3D2,$B3D3,
$B3D4,$B3D5,$B3D6,$B3D7,$B3D8,$B3D9,$B3DA,$B3DB,$B3DC,$B3DD,$B3DE,$B3DF,$B3E0,
$B3E1,$B3E2,$B3E3,$B3E4,$B3E5,$B3E6,$B3E7,$B3E8,$B3E9,$B3EA,$B3EB,$B3EC,$B3ED,
$B3EE,$B3EF,$B3F0,$B3F1,$B3F2,$B3F3,$B3F4,$B3F5,$B3F6,$B3F7,$B3F8,$B3F9,$B3FA,
$B3FB,$B3FC,$B3FD,$B3FE,$B441,$B442,$B443,$B444,$B445,$B446,$B447,$B448,$B449,
$B44A,$B44B,$B44C,$B44D,$B44E,$B44F,$B450,$B451,$B452,$B453,$B454,$B455,$B456,
$B457,$B458,$B459,$B45A,$B461,$B462,$B463,$B464,$B465,$B466,$B467,$B468,$B469,
$B46A,$B46B,$B46C,$B46D,$B46E,$B46F,$B470,$B471,$B472,$B473,$B474,$B475,$B476,
$B477,$B478,$B479,$B47A,$B481,$B482,$B483,$B484,$B485,$B486,$B487,$B488,$B489,
$B48A,$B48B,$B48C,$B48D,$B48E,$B48F,$B490,$B491,$B492,$B493,$B494,$B495,$B496,
$B497,$B498,$B499,$B49A,$B49B,$B49C,$B49D,$B49E,$B49F,$B4A0,$B4A1,$B4A2,$B4A3,
$B4A4,$B4A5,$B4A6,$B4A7,$B4A8,$B4A9,$B4AA,$B4AB,$B4AC,$B4AD,$B4AE,$B4AF,$B4B0,
$B4B1,$B4B2,$B4B3,$B4B4,$B4B5,$B4B6,$B4B7,$B4B8,$B4B9,$B4BA,$B4BB,$B4BC,$B4BD,
$B4BE,$B4BF,$B4C0,$B4C1,$B4C2,$B4C3,$B4C4,$B4C5,$B4C6,$B4C7,$B4C8,$B4C9,$B4CA,
$B4CB,$B4CC,$B4CD,$B4CE,$B4CF,$B4D0,$B4D1,$B4D2,$B4D3,$B4D4,$B4D5,$B4D6,$B4D7,
$B4D8,$B4D9,$B4DA,$B4DB,$B4DC,$B4DD,$B4DE,$B4DF,$B4E0,$B4E1,$B4E2,$B4E3,$B4E4,
$B4E5,$B4E6,$B4E7,$B4E8,$B4E9,$B4EA,$B4EB,$B4EC,$B4ED,$B4EE,$B4EF,$B4F0,$B4F1,
$B4F2,$B4F3,$B4F4,$B4F5,$B4F6,$B4F7,$B4F8,$B4F9,$B4FA,$B4FB,$B4FC,$B4FD,$B4FE,
$B541,$B542,$B543,$B544,$B545,$B546,$B547,$B548,$B549,$B54A,$B54B,$B54C,$B54D,
$B54E,$B54F,$B550,$B551,$B552,$B553,$B554,$B555,$B556,$B557,$B558,$B559,$B55A,
$B561,$B562,$B563,$B564,$B565,$B566,$B567,$B568,$B569,$B56A,$B56B,$B56C,$B56D,
$B56E,$B56F,$B570,$B571,$B572,$B573,$B574,$B575,$B576,$B577,$B578,$B579,$B57A,
$B581,$B582,$B583,$B584,$B585,$B586,$B587,$B588,$B589,$B58A,$B58B,$B58C,$B58D,
$B58E,$B58F,$B590,$B591,$B592,$B593,$B594,$B595,$B596,$B597,$B598,$B599,$B59A,
$B59B,$B59C,$B59D,$B59E,$B59F,$B5A0,$B5A1,$B5A2,$B5A3,$B5A4,$B5A5,$B5A6,$B5A7,
$B5A8,$B5A9,$B5AA,$B5AB,$B5AC,$B5AD,$B5AE,$B5AF,$B5B0,$B5B1,$B5B2,$B5B3,$B5B4,
$B5B5,$B5B6,$B5B7,$B5B8,$B5B9,$B5BA,$B5BB,$B5BC,$B5BD,$B5BE,$B5BF,$B5C0,$B5C1,
$B5C2,$B5C3,$B5C4,$B5C5,$B5C6,$B5C7,$B5C8,$B5C9,$B5CA,$B5CB,$B5CC,$B5CD,$B5CE,
$B5CF,$B5D0,$B5D1,$B5D2,$B5D3,$B5D4,$B5D5,$B5D6,$B5D7,$B5D8,$B5D9,$B5DA,$B5DB,
$B5DC,$B5DD,$B5DE,$B5DF,$B5E0,$B5E1,$B5E2,$B5E3,$B5E4,$B5E5,$B5E6,$B5E7,$B5E8,
$B5E9,$B5EA,$B5EB,$B5EC,$B5ED,$B5EE,$B5EF,$B5F0,$B5F1,$B5F2,$B5F3,$B5F4,$B5F5,
$B5F6,$B5F7,$B5F8,$B5F9,$B5FA,$B5FB,$B5FC,$B5FD,$B5FE,$B641,$B642,$B643,$B644,
$B645,$B646,$B647,$B648,$B649,$B64A,$B64B,$B64C,$B64D,$B64E,$B64F,$B650,$B651,
$B652,$B653,$B654,$B655,$B656,$B657,$B658,$B659,$B65A,$B661,$B662,$B663,$B664,
$B665,$B666,$B667,$B668,$B669,$B66A,$B66B,$B66C,$B66D,$B66E,$B66F,$B670,$B671,
$B672,$B673,$B674,$B675,$B676,$B677,$B678,$B679,$B67A,$B681,$B682,$B683,$B684,
$B685,$B686,$B687,$B688,$B689,$B68A,$B68B,$B68C,$B68D,$B68E,$B68F,$B690,$B691,
$B692,$B693,$B694,$B695,$B696,$B697,$B698,$B699,$B69A,$B69B,$B69C,$B69D,$B69E,
$B69F,$B6A0,$B6A1,$B6A2,$B6A3,$B6A4,$B6A5,$B6A6,$B6A7,$B6A8,$B6A9,$B6AA,$B6AB,
$B6AC,$B6AD,$B6AE,$B6AF,$B6B0,$B6B1,$B6B2,$B6B3,$B6B4,$B6B5,$B6B6,$B6B7,$B6B8,
$B6B9,$B6BA,$B6BB,$B6BC,$B6BD,$B6BE,$B6BF,$B6C0,$B6C1,$B6C2,$B6C3,$B6C4,$B6C5,
$B6C6,$B6C7,$B6C8,$B6C9,$B6CA,$B6CB,$B6CC,$B6CD,$B6CE,$B6CF,$B6D0,$B6D1,$B6D2,
$B6D3,$B6D4,$B6D5,$B6D6,$B6D7,$B6D8,$B6D9,$B6DA,$B6DB,$B6DC,$B6DD,$B6DE,$B6DF,
$B6E0,$B6E1,$B6E2,$B6E3,$B6E4,$B6E5,$B6E6,$B6E7,$B6E8,$B6E9,$B6EA,$B6EB,$B6EC,
$B6ED,$B6EE,$B6EF,$B6F0,$B6F1,$B6F2,$B6F3,$B6F4,$B6F5,$B6F6,$B6F7,$B6F8,$B6F9,
$B6FA,$B6FB,$B6FC,$B6FD,$B6FE,$B741,$B742,$B743,$B744,$B745,$B746,$B747,$B748,
$B749,$B74A,$B74B,$B74C,$B74D,$B74E,$B74F,$B750,$B751,$B752,$B753,$B754,$B755,
$B756,$B757,$B758,$B759,$B75A,$B761,$B762,$B763,$B764,$B765,$B766,$B767,$B768,
$B769,$B76A,$B76B,$B76C,$B76D,$B76E,$B76F,$B770,$B771,$B772,$B773,$B774,$B775,
$B776,$B777,$B778,$B779,$B77A,$B781,$B782,$B783,$B784,$B785,$B786,$B787,$B788,
$B789,$B78A,$B78B,$B78C,$B78D,$B78E,$B78F,$B790,$B791,$B792,$B793,$B794,$B795,
$B796,$B797,$B798,$B799,$B79A,$B79B,$B79C,$B79D,$B79E,$B79F,$B7A0,$B7A1,$B7A2,
$B7A3,$B7A4,$B7A5,$B7A6,$B7A7,$B7A8,$B7A9,$B7AA,$B7AB,$B7AC,$B7AD,$B7AE,$B7AF,
$B7B0,$B7B1,$B7B2,$B7B3,$B7B4,$B7B5,$B7B6,$B7B7,$B7B8,$B7B9,$B7BA,$B7BB,$B7BC,
$B7BD,$B7BE,$B7BF,$B7C0,$B7C1,$B7C2,$B7C3,$B7C4,$B7C5,$B7C6,$B7C7,$B7C8,$B7C9,
$B7CA,$B7CB,$B7CC,$B7CD,$B7CE,$B7CF,$B7D0,$B7D1,$B7D2,$B7D3,$B7D4,$B7D5,$B7D6,
$B7D7,$B7D8,$B7D9,$B7DA,$B7DB,$B7DC,$B7DD,$B7DE,$B7DF,$B7E0,$B7E1,$B7E2,$B7E3,
$B7E4,$B7E5,$B7E6,$B7E7,$B7E8,$B7E9,$B7EA,$B7EB,$B7EC,$B7ED,$B7EE,$B7EF,$B7F0,
$B7F1,$B7F2,$B7F3,$B7F4,$B7F5,$B7F6,$B7F7,$B7F8,$B7F9,$B7FA,$B7FB,$B7FC,$B7FD,
$B7FE,$B841,$B842,$B843,$B844,$B845,$B846,$B847,$B848,$B849,$B84A,$B84B,$B84C,
$B84D,$B84E,$B84F,$B850,$B851,$B852,$B853,$B854,$B855,$B856,$B857,$B858,$B859,
$B85A,$B861,$B862,$B863,$B864,$B865,$B866,$B867,$B868,$B869,$B86A,$B86B,$B86C,
$B86D,$B86E,$B86F,$B870,$B871,$B872,$B873,$B874,$B875,$B876,$B877,$B878,$B879,
$B87A,$B881,$B882,$B883,$B884,$B885,$B886,$B887,$B888,$B889,$B88A,$B88B,$B88C,
$B88D,$B88E,$B88F,$B890,$B891,$B892,$B893,$B894,$B895,$B896,$B897,$B898,$B899,
$B89A,$B89B,$B89C,$B89D,$B89E,$B89F,$B8A0,$B8A1,$B8A2,$B8A3,$B8A4,$B8A5,$B8A6,
$B8A7,$B8A8,$B8A9,$B8AA,$B8AB,$B8AC,$B8AD,$B8AE,$B8AF,$B8B0,$B8B1,$B8B2,$B8B3,
$B8B4,$B8B5,$B8B6,$B8B7,$B8B8,$B8B9,$B8BA,$B8BB,$B8BC,$B8BD,$B8BE,$B8BF,$B8C0,
$B8C1,$B8C2,$B8C3,$B8C4,$B8C5,$B8C6,$B8C7,$B8C8,$B8C9,$B8CA,$B8CB,$B8CC,$B8CD,
$B8CE,$B8CF,$B8D0,$B8D1,$B8D2,$B8D3,$B8D4,$B8D5,$B8D6,$B8D7,$B8D8,$B8D9,$B8DA,
$B8DB,$B8DC,$B8DD,$B8DE,$B8DF,$B8E0,$B8E1,$B8E2,$B8E3,$B8E4,$B8E5,$B8E6,$B8E7,
$B8E8,$B8E9,$B8EA,$B8EB,$B8EC,$B8ED,$B8EE,$B8EF,$B8F0,$B8F1,$B8F2,$B8F3,$B8F4,
$B8F5,$B8F6,$B8F7,$B8F8,$B8F9,$B8FA,$B8FB,$B8FC,$B8FD,$B8FE,$B941,$B942,$B943,
$B944,$B945,$B946,$B947,$B948,$B949,$B94A,$B94B,$B94C,$B94D,$B94E,$B94F,$B950,
$B951,$B952,$B953,$B954,$B955,$B956,$B957,$B958,$B959,$B95A,$B961,$B962,$B963,
$B964,$B965,$B966,$B967,$B968,$B969,$B96A,$B96B,$B96C,$B96D,$B96E,$B96F,$B970,
$B971,$B972,$B973,$B974,$B975,$B976,$B977,$B978,$B979,$B97A,$B981,$B982,$B983,
$B984,$B985,$B986,$B987,$B988,$B989,$B98A,$B98B,$B98C,$B98D,$B98E,$B98F,$B990,
$B991,$B992,$B993,$B994,$B995,$B996,$B997,$B998,$B999,$B99A,$B99B,$B99C,$B99D,
$B99E,$B99F,$B9A0,$B9A1,$B9A2,$B9A3,$B9A4,$B9A5,$B9A6,$B9A7,$B9A8,$B9A9,$B9AA,
$B9AB,$B9AC,$B9AD,$B9AE,$B9AF,$B9B0,$B9B1,$B9B2,$B9B3,$B9B4,$B9B5,$B9B6,$B9B7,
$B9B8,$B9B9,$B9BA,$B9BB,$B9BC,$B9BD,$B9BE,$B9BF,$B9C0,$B9C1,$B9C2,$B9C3,$B9C4,
$B9C5,$B9C6,$B9C7,$B9C8,$B9C9,$B9CA,$B9CB,$B9CC,$B9CD,$B9CE,$B9CF,$B9D0,$B9D1,
$B9D2,$B9D3,$B9D4,$B9D5,$B9D6,$B9D7,$B9D8,$B9D9,$B9DA,$B9DB,$B9DC,$B9DD,$B9DE,
$B9DF,$B9E0,$B9E1,$B9E2,$B9E3,$B9E4,$B9E5,$B9E6,$B9E7,$B9E8,$B9E9,$B9EA,$B9EB,
$B9EC,$B9ED,$B9EE,$B9EF,$B9F0,$B9F1,$B9F2,$B9F3,$B9F4,$B9F5,$B9F6,$B9F7,$B9F8,
$B9F9,$B9FA,$B9FB,$B9FC,$B9FD,$B9FE,$BA41,$BA42,$BA43,$BA44,$BA45,$BA46,$BA47,
$BA48,$BA49,$BA4A,$BA4B,$BA4C,$BA4D,$BA4E,$BA4F,$BA50,$BA51,$BA52,$BA53,$BA54,
$BA55,$BA56,$BA57,$BA58,$BA59,$BA5A,$BA61,$BA62,$BA63,$BA64,$BA65,$BA66,$BA67,
$BA68,$BA69,$BA6A,$BA6B,$BA6C,$BA6D,$BA6E,$BA6F,$BA70,$BA71,$BA72,$BA73,$BA74,
$BA75,$BA76,$BA77,$BA78,$BA79,$BA7A,$BA81,$BA82,$BA83,$BA84,$BA85,$BA86,$BA87,
$BA88,$BA89,$BA8A,$BA8B,$BA8C,$BA8D,$BA8E,$BA8F,$BA90,$BA91,$BA92,$BA93,$BA94,
$BA95,$BA96,$BA97,$BA98,$BA99,$BA9A,$BA9B,$BA9C,$BA9D,$BA9E,$BA9F,$BAA0,$BAA1,
$BAA2,$BAA3,$BAA4,$BAA5,$BAA6,$BAA7,$BAA8,$BAA9,$BAAA,$BAAB,$BAAC,$BAAD,$BAAE,
$BAAF,$BAB0,$BAB1,$BAB2,$BAB3,$BAB4,$BAB5,$BAB6,$BAB7,$BAB8,$BAB9,$BABA,$BABB,
$BABC,$BABD,$BABE,$BABF,$BAC0,$BAC1,$BAC2,$BAC3,$BAC4,$BAC5,$BAC6,$BAC7,$BAC8,
$BAC9,$BACA,$BACB,$BACC,$BACD,$BACE,$BACF,$BAD0,$BAD1,$BAD2,$BAD3,$BAD4,$BAD5,
$BAD6,$BAD7,$BAD8,$BAD9,$BADA,$BADB,$BADC,$BADD,$BADE,$BADF,$BAE0,$BAE1,$BAE2,
$BAE3,$BAE4,$BAE5,$BAE6,$BAE7,$BAE8,$BAE9,$BAEA,$BAEB,$BAEC,$BAED,$BAEE,$BAEF,
$BAF0,$BAF1,$BAF2,$BAF3,$BAF4,$BAF5,$BAF6,$BAF7,$BAF8,$BAF9,$BAFA,$BAFB,$BAFC,
$BAFD,$BAFE,$BB41,$BB42,$BB43,$BB44,$BB45,$BB46,$BB47,$BB48,$BB49,$BB4A,$BB4B,
$BB4C,$BB4D,$BB4E,$BB4F,$BB50,$BB51,$BB52,$BB53,$BB54,$BB55,$BB56,$BB57,$BB58,
$BB59,$BB5A,$BB61,$BB62,$BB63,$BB64,$BB65,$BB66,$BB67,$BB68,$BB69,$BB6A,$BB6B,
$BB6C,$BB6D,$BB6E,$BB6F,$BB70,$BB71,$BB72,$BB73,$BB74,$BB75,$BB76,$BB77,$BB78,
$BB79,$BB7A,$BB81,$BB82,$BB83,$BB84,$BB85,$BB86,$BB87,$BB88,$BB89,$BB8A,$BB8B,
$BB8C,$BB8D,$BB8E,$BB8F,$BB90,$BB91,$BB92,$BB93,$BB94,$BB95,$BB96,$BB97,$BB98,
$BB99,$BB9A,$BB9B,$BB9C,$BB9D,$BB9E,$BB9F,$BBA0,$BBA1,$BBA2,$BBA3,$BBA4,$BBA5,
$BBA6,$BBA7,$BBA8,$BBA9,$BBAA,$BBAB,$BBAC,$BBAD,$BBAE,$BBAF,$BBB0,$BBB1,$BBB2,
$BBB3,$BBB4,$BBB5,$BBB6,$BBB7,$BBB8,$BBB9,$BBBA,$BBBB,$BBBC,$BBBD,$BBBE,$BBBF,
$BBC0,$BBC1,$BBC2,$BBC3,$BBC4,$BBC5,$BBC6,$BBC7,$BBC8,$BBC9,$BBCA,$BBCB,$BBCC,
$BBCD,$BBCE,$BBCF,$BBD0,$BBD1,$BBD2,$BBD3,$BBD4,$BBD5,$BBD6,$BBD7,$BBD8,$BBD9,
$BBDA,$BBDB,$BBDC,$BBDD,$BBDE,$BBDF,$BBE0,$BBE1,$BBE2,$BBE3,$BBE4,$BBE5,$BBE6,
$BBE7,$BBE8,$BBE9,$BBEA,$BBEB,$BBEC,$BBED,$BBEE,$BBEF,$BBF0,$BBF1,$BBF2,$BBF3,
$BBF4,$BBF5,$BBF6,$BBF7,$BBF8,$BBF9,$BBFA,$BBFB,$BBFC,$BBFD,$BBFE,$BC41,$BC42,
$BC43,$BC44,$BC45,$BC46,$BC47,$BC48,$BC49,$BC4A,$BC4B,$BC4C,$BC4D,$BC4E,$BC4F,
$BC50,$BC51,$BC52,$BC53,$BC54,$BC55,$BC56,$BC57,$BC58,$BC59,$BC5A,$BC61,$BC62,
$BC63,$BC64,$BC65,$BC66,$BC67,$BC68,$BC69,$BC6A,$BC6B,$BC6C,$BC6D,$BC6E,$BC6F,
$BC70,$BC71,$BC72,$BC73,$BC74,$BC75,$BC76,$BC77,$BC78,$BC79,$BC7A,$BC81,$BC82,
$BC83,$BC84,$BC85,$BC86,$BC87,$BC88,$BC89,$BC8A,$BC8B,$BC8C,$BC8D,$BC8E,$BC8F,
$BC90,$BC91,$BC92,$BC93,$BC94,$BC95,$BC96,$BC97,$BC98,$BC99,$BC9A,$BC9B,$BC9C,
$BC9D,$BC9E,$BC9F,$BCA0,$BCA1,$BCA2,$BCA3,$BCA4,$BCA5,$BCA6,$BCA7,$BCA8,$BCA9,
$BCAA,$BCAB,$BCAC,$BCAD,$BCAE,$BCAF,$BCB0,$BCB1,$BCB2,$BCB3,$BCB4,$BCB5,$BCB6,
$BCB7,$BCB8,$BCB9,$BCBA,$BCBB,$BCBC,$BCBD,$BCBE,$BCBF,$BCC0,$BCC1,$BCC2,$BCC3,
$BCC4,$BCC5,$BCC6,$BCC7,$BCC8,$BCC9,$BCCA,$BCCB,$BCCC,$BCCD,$BCCE,$BCCF,$BCD0,
$BCD1,$BCD2,$BCD3,$BCD4,$BCD5,$BCD6,$BCD7,$BCD8,$BCD9,$BCDA,$BCDB,$BCDC,$BCDD,
$BCDE,$BCDF,$BCE0,$BCE1,$BCE2,$BCE3,$BCE4,$BCE5,$BCE6,$BCE7,$BCE8,$BCE9,$BCEA,
$BCEB,$BCEC,$BCED,$BCEE,$BCEF,$BCF0,$BCF1,$BCF2,$BCF3,$BCF4,$BCF5,$BCF6,$BCF7,
$BCF8,$BCF9,$BCFA,$BCFB,$BCFC,$BCFD,$BCFE,$BD41,$BD42,$BD43,$BD44,$BD45,$BD46,
$BD47,$BD48,$BD49,$BD4A,$BD4B,$BD4C,$BD4D,$BD4E,$BD4F,$BD50,$BD51,$BD52,$BD53,
$BD54,$BD55,$BD56,$BD57,$BD58,$BD59,$BD5A,$BD61,$BD62,$BD63,$BD64,$BD65,$BD66,
$BD67,$BD68,$BD69,$BD6A,$BD6B,$BD6C,$BD6D,$BD6E,$BD6F,$BD70,$BD71,$BD72,$BD73,
$BD74,$BD75,$BD76,$BD77,$BD78,$BD79,$BD7A,$BD81,$BD82,$BD83,$BD84,$BD85,$BD86,
$BD87,$BD88,$BD89,$BD8A,$BD8B,$BD8C,$BD8D,$BD8E,$BD8F,$BD90,$BD91,$BD92,$BD93,
$BD94,$BD95,$BD96,$BD97,$BD98,$BD99,$BD9A,$BD9B,$BD9C,$BD9D,$BD9E,$BD9F,$BDA0,
$BDA1,$BDA2,$BDA3,$BDA4,$BDA5,$BDA6,$BDA7,$BDA8,$BDA9,$BDAA,$BDAB,$BDAC,$BDAD,
$BDAE,$BDAF,$BDB0,$BDB1,$BDB2,$BDB3,$BDB4,$BDB5,$BDB6,$BDB7,$BDB8,$BDB9,$BDBA,
$BDBB,$BDBC,$BDBD,$BDBE,$BDBF,$BDC0,$BDC1,$BDC2,$BDC3,$BDC4,$BDC5,$BDC6,$BDC7,
$BDC8,$BDC9,$BDCA,$BDCB,$BDCC,$BDCD,$BDCE,$BDCF,$BDD0,$BDD1,$BDD2,$BDD3,$BDD4,
$BDD5,$BDD6,$BDD7,$BDD8,$BDD9,$BDDA,$BDDB,$BDDC,$BDDD,$BDDE,$BDDF,$BDE0,$BDE1,
$BDE2,$BDE3,$BDE4,$BDE5,$BDE6,$BDE7,$BDE8,$BDE9,$BDEA,$BDEB,$BDEC,$BDED,$BDEE,
$BDEF,$BDF0,$BDF1,$BDF2,$BDF3,$BDF4,$BDF5,$BDF6,$BDF7,$BDF8,$BDF9,$BDFA,$BDFB,
$BDFC,$BDFD,$BDFE,$BE41,$BE42,$BE43,$BE44,$BE45,$BE46,$BE47,$BE48,$BE49,$BE4A,
$BE4B,$BE4C,$BE4D,$BE4E,$BE4F,$BE50,$BE51,$BE52,$BE53,$BE54,$BE55,$BE56,$BE57,
$BE58,$BE59,$BE5A,$BE61,$BE62,$BE63,$BE64,$BE65,$BE66,$BE67,$BE68,$BE69,$BE6A,
$BE6B,$BE6C,$BE6D,$BE6E,$BE6F,$BE70,$BE71,$BE72,$BE73,$BE74,$BE75,$BE76,$BE77,
$BE78,$BE79,$BE7A,$BE81,$BE82,$BE83,$BE84,$BE85,$BE86,$BE87,$BE88,$BE89,$BE8A,
$BE8B,$BE8C,$BE8D,$BE8E,$BE8F,$BE90,$BE91,$BE92,$BE93,$BE94,$BE95,$BE96,$BE97,
$BE98,$BE99,$BE9A,$BE9B,$BE9C,$BE9D,$BE9E,$BE9F,$BEA0,$BEA1,$BEA2,$BEA3,$BEA4,
$BEA5,$BEA6,$BEA7,$BEA8,$BEA9,$BEAA,$BEAB,$BEAC,$BEAD,$BEAE,$BEAF,$BEB0,$BEB1,
$BEB2,$BEB3,$BEB4,$BEB5,$BEB6,$BEB7,$BEB8,$BEB9,$BEBA,$BEBB,$BEBC,$BEBD,$BEBE,
$BEBF,$BEC0,$BEC1,$BEC2,$BEC3,$BEC4,$BEC5,$BEC6,$BEC7,$BEC8,$BEC9,$BECA,$BECB,
$BECC,$BECD,$BECE,$BECF,$BED0,$BED1,$BED2,$BED3,$BED4,$BED5,$BED6,$BED7,$BED8,
$BED9,$BEDA,$BEDB,$BEDC,$BEDD,$BEDE,$BEDF,$BEE0,$BEE1,$BEE2,$BEE3,$BEE4,$BEE5,
$BEE6,$BEE7,$BEE8,$BEE9,$BEEA,$BEEB,$BEEC,$BEED,$BEEE,$BEEF,$BEF0,$BEF1,$BEF2,
$BEF3,$BEF4,$BEF5,$BEF6,$BEF7,$BEF8,$BEF9,$BEFA,$BEFB,$BEFC,$BEFD,$BEFE,$BF41,
$BF42,$BF43,$BF44,$BF45,$BF46,$BF47,$BF48,$BF49,$BF4A,$BF4B,$BF4C,$BF4D,$BF4E,
$BF4F,$BF50,$BF51,$BF52,$BF53,$BF54,$BF55,$BF56,$BF57,$BF58,$BF59,$BF5A,$BF61,
$BF62,$BF63,$BF64,$BF65,$BF66,$BF67,$BF68,$BF69,$BF6A,$BF6B,$BF6C,$BF6D,$BF6E,
$BF6F,$BF70,$BF71,$BF72,$BF73,$BF74,$BF75,$BF76,$BF77,$BF78,$BF79,$BF7A,$BF81,
$BF82,$BF83,$BF84,$BF85,$BF86,$BF87,$BF88,$BF89,$BF8A,$BF8B,$BF8C,$BF8D,$BF8E,
$BF8F,$BF90,$BF91,$BF92,$BF93,$BF94,$BF95,$BF96,$BF97,$BF98,$BF99,$BF9A,$BF9B,
$BF9C,$BF9D,$BF9E,$BF9F,$BFA0,$BFA1,$BFA2,$BFA3,$BFA4,$BFA5,$BFA6,$BFA7,$BFA8,
$BFA9,$BFAA,$BFAB,$BFAC,$BFAD,$BFAE,$BFAF,$BFB0,$BFB1,$BFB2,$BFB3,$BFB4,$BFB5,
$BFB6,$BFB7,$BFB8,$BFB9,$BFBA,$BFBB,$BFBC,$BFBD,$BFBE,$BFBF,$BFC0,$BFC1,$BFC2,
$BFC3,$BFC4,$BFC5,$BFC6,$BFC7,$BFC8,$BFC9,$BFCA,$BFCB,$BFCC,$BFCD,$BFCE,$BFCF,
$BFD0,$BFD1,$BFD2,$BFD3,$BFD4,$BFD5,$BFD6,$BFD7,$BFD8,$BFD9,$BFDA,$BFDB,$BFDC,
$BFDD,$BFDE,$BFDF,$BFE0,$BFE1,$BFE2,$BFE3,$BFE4,$BFE5,$BFE6,$BFE7,$BFE8,$BFE9,
$BFEA,$BFEB,$BFEC,$BFED,$BFEE,$BFEF,$BFF0,$BFF1,$BFF2,$BFF3,$BFF4,$BFF5,$BFF6,
$BFF7,$BFF8,$BFF9,$BFFA,$BFFB,$BFFC,$BFFD,$BFFE,$C041,$C042,$C043,$C044,$C045,
$C046,$C047,$C048,$C049,$C04A,$C04B,$C04C,$C04D,$C04E,$C04F,$C050,$C051,$C052,
$C053,$C054,$C055,$C056,$C057,$C058,$C059,$C05A,$C061,$C062,$C063,$C064,$C065,
$C066,$C067,$C068,$C069,$C06A,$C06B,$C06C,$C06D,$C06E,$C06F,$C070,$C071,$C072,
$C073,$C074,$C075,$C076,$C077,$C078,$C079,$C07A,$C081,$C082,$C083,$C084,$C085,
$C086,$C087,$C088,$C089,$C08A,$C08B,$C08C,$C08D,$C08E,$C08F,$C090,$C091,$C092,
$C093,$C094,$C095,$C096,$C097,$C098,$C099,$C09A,$C09B,$C09C,$C09D,$C09E,$C09F,
$C0A0,$C0A1,$C0A2,$C0A3,$C0A4,$C0A5,$C0A6,$C0A7,$C0A8,$C0A9,$C0AA,$C0AB,$C0AC,
$C0AD,$C0AE,$C0AF,$C0B0,$C0B1,$C0B2,$C0B3,$C0B4,$C0B5,$C0B6,$C0B7,$C0B8,$C0B9,
$C0BA,$C0BB,$C0BC,$C0BD,$C0BE,$C0BF,$C0C0,$C0C1,$C0C2,$C0C3,$C0C4,$C0C5,$C0C6,
$C0C7,$C0C8,$C0C9,$C0CA,$C0CB,$C0CC,$C0CD,$C0CE,$C0CF,$C0D0,$C0D1,$C0D2,$C0D3,
$C0D4,$C0D5,$C0D6,$C0D7,$C0D8,$C0D9,$C0DA,$C0DB,$C0DC,$C0DD,$C0DE,$C0DF,$C0E0,
$C0E1,$C0E2,$C0E3,$C0E4,$C0E5,$C0E6,$C0E7,$C0E8,$C0E9,$C0EA,$C0EB,$C0EC,$C0ED,
$C0EE,$C0EF,$C0F0,$C0F1,$C0F2,$C0F3,$C0F4,$C0F5,$C0F6,$C0F7,$C0F8,$C0F9,$C0FA,
$C0FB,$C0FC,$C0FD,$C0FE,$C141,$C142,$C143,$C144,$C145,$C146,$C147,$C148,$C149,
$C14A,$C14B,$C14C,$C14D,$C14E,$C14F,$C150,$C151,$C152,$C153,$C154,$C155,$C156,
$C157,$C158,$C159,$C15A,$C161,$C162,$C163,$C164,$C165,$C166,$C167,$C168,$C169,
$C16A,$C16B,$C16C,$C16D,$C16E,$C16F,$C170,$C171,$C172,$C173,$C174,$C175,$C176,
$C177,$C178,$C179,$C17A,$C181,$C182,$C183,$C184,$C185,$C186,$C187,$C188,$C189,
$C18A,$C18B,$C18C,$C18D,$C18E,$C18F,$C190,$C191,$C192,$C193,$C194,$C195,$C196,
$C197,$C198,$C199,$C19A,$C19B,$C19C,$C19D,$C19E,$C19F,$C1A0,$C1A1,$C1A2,$C1A3,
$C1A4,$C1A5,$C1A6,$C1A7,$C1A8,$C1A9,$C1AA,$C1AB,$C1AC,$C1AD,$C1AE,$C1AF,$C1B0,
$C1B1,$C1B2,$C1B3,$C1B4,$C1B5,$C1B6,$C1B7,$C1B8,$C1B9,$C1BA,$C1BB,$C1BC,$C1BD,
$C1BE,$C1BF,$C1C0,$C1C1,$C1C2,$C1C3,$C1C4,$C1C5,$C1C6,$C1C7,$C1C8,$C1C9,$C1CA,
$C1CB,$C1CC,$C1CD,$C1CE,$C1CF,$C1D0,$C1D1,$C1D2,$C1D3,$C1D4,$C1D5,$C1D6,$C1D7,
$C1D8,$C1D9,$C1DA,$C1DB,$C1DC,$C1DD,$C1DE,$C1DF,$C1E0,$C1E1,$C1E2,$C1E3,$C1E4,
$C1E5,$C1E6,$C1E7,$C1E8,$C1E9,$C1EA,$C1EB,$C1EC,$C1ED,$C1EE,$C1EF,$C1F0,$C1F1,
$C1F2,$C1F3,$C1F4,$C1F5,$C1F6,$C1F7,$C1F8,$C1F9,$C1FA,$C1FB,$C1FC,$C1FD,$C1FE,
$C241,$C242,$C243,$C244,$C245,$C246,$C247,$C248,$C249,$C24A,$C24B,$C24C,$C24D,
$C24E,$C24F,$C250,$C251,$C252,$C253,$C254,$C255,$C256,$C257,$C258,$C259,$C25A,
$C261,$C262,$C263,$C264,$C265,$C266,$C267,$C268,$C269,$C26A,$C26B,$C26C,$C26D,
$C26E,$C26F,$C270,$C271,$C272,$C273,$C274,$C275,$C276,$C277,$C278,$C279,$C27A,
$C281,$C282,$C283,$C284,$C285,$C286,$C287,$C288,$C289,$C28A,$C28B,$C28C,$C28D,
$C28E,$C28F,$C290,$C291,$C292,$C293,$C294,$C295,$C296,$C297,$C298,$C299,$C29A,
$C29B,$C29C,$C29D,$C29E,$C29F,$C2A0,$C2A1,$C2A2,$C2A3,$C2A4,$C2A5,$C2A6,$C2A7,
$C2A8,$C2A9,$C2AA,$C2AB,$C2AC,$C2AD,$C2AE,$C2AF,$C2B0,$C2B1,$C2B2,$C2B3,$C2B4,
$C2B5,$C2B6,$C2B7,$C2B8,$C2B9,$C2BA,$C2BB,$C2BC,$C2BD,$C2BE,$C2BF,$C2C0,$C2C1,
$C2C2,$C2C3,$C2C4,$C2C5,$C2C6,$C2C7,$C2C8,$C2C9,$C2CA,$C2CB,$C2CC,$C2CD,$C2CE,
$C2CF,$C2D0,$C2D1,$C2D2,$C2D3,$C2D4,$C2D5,$C2D6,$C2D7,$C2D8,$C2D9,$C2DA,$C2DB,
$C2DC,$C2DD,$C2DE,$C2DF,$C2E0,$C2E1,$C2E2,$C2E3,$C2E4,$C2E5,$C2E6,$C2E7,$C2E8,
$C2E9,$C2EA,$C2EB,$C2EC,$C2ED,$C2EE,$C2EF,$C2F0,$C2F1,$C2F2,$C2F3,$C2F4,$C2F5,
$C2F6,$C2F7,$C2F8,$C2F9,$C2FA,$C2FB,$C2FC,$C2FD,$C2FE,$C341,$C342,$C343,$C344,
$C345,$C346,$C347,$C348,$C349,$C34A,$C34B,$C34C,$C34D,$C34E,$C34F,$C350,$C351,
$C352,$C353,$C354,$C355,$C356,$C357,$C358,$C359,$C35A,$C361,$C362,$C363,$C364,
$C365,$C366,$C367,$C368,$C369,$C36A,$C36B,$C36C,$C36D,$C36E,$C36F,$C370,$C371,
$C372,$C373,$C374,$C375,$C376,$C377,$C378,$C379,$C37A,$C381,$C382,$C383,$C384,
$C385,$C386,$C387,$C388,$C389,$C38A,$C38B,$C38C,$C38D,$C38E,$C38F,$C390,$C391,
$C392,$C393,$C394,$C395,$C396,$C397,$C398,$C399,$C39A,$C39B,$C39C,$C39D,$C39E,
$C39F,$C3A0,$C3A1,$C3A2,$C3A3,$C3A4,$C3A5,$C3A6,$C3A7,$C3A8,$C3A9,$C3AA,$C3AB,
$C3AC,$C3AD,$C3AE,$C3AF,$C3B0,$C3B1,$C3B2,$C3B3,$C3B4,$C3B5,$C3B6,$C3B7,$C3B8,
$C3B9,$C3BA,$C3BB,$C3BC,$C3BD,$C3BE,$C3BF,$C3C0,$C3C1,$C3C2,$C3C3,$C3C4,$C3C5,
$C3C6,$C3C7,$C3C8,$C3C9,$C3CA,$C3CB,$C3CC,$C3CD,$C3CE,$C3CF,$C3D0,$C3D1,$C3D2,
$C3D3,$C3D4,$C3D5,$C3D6,$C3D7,$C3D8,$C3D9,$C3DA,$C3DB,$C3DC,$C3DD,$C3DE,$C3DF,
$C3E0,$C3E1,$C3E2,$C3E3,$C3E4,$C3E5,$C3E6,$C3E7,$C3E8,$C3E9,$C3EA,$C3EB,$C3EC,
$C3ED,$C3EE,$C3EF,$C3F0,$C3F1,$C3F2,$C3F3,$C3F4,$C3F5,$C3F6,$C3F7,$C3F8,$C3F9,
$C3FA,$C3FB,$C3FC,$C3FD,$C3FE,$C441,$C442,$C443,$C444,$C445,$C446,$C447,$C448,
$C449,$C44A,$C44B,$C44C,$C44D,$C44E,$C44F,$C450,$C451,$C452,$C453,$C454,$C455,
$C456,$C457,$C458,$C459,$C45A,$C461,$C462,$C463,$C464,$C465,$C466,$C467,$C468,
$C469,$C46A,$C46B,$C46C,$C46D,$C46E,$C46F,$C470,$C471,$C472,$C473,$C474,$C475,
$C476,$C477,$C478,$C479,$C47A,$C481,$C482,$C483,$C484,$C485,$C486,$C487,$C488,
$C489,$C48A,$C48B,$C48C,$C48D,$C48E,$C48F,$C490,$C491,$C492,$C493,$C494,$C495,
$C496,$C497,$C498,$C499,$C49A,$C49B,$C49C,$C49D,$C49E,$C49F,$C4A0,$C4A1,$C4A2,
$C4A3,$C4A4,$C4A5,$C4A6,$C4A7,$C4A8,$C4A9,$C4AA,$C4AB,$C4AC,$C4AD,$C4AE,$C4AF,
$C4B0,$C4B1,$C4B2,$C4B3,$C4B4,$C4B5,$C4B6,$C4B7,$C4B8,$C4B9,$C4BA,$C4BB,$C4BC,
$C4BD,$C4BE,$C4BF,$C4C0,$C4C1,$C4C2,$C4C3,$C4C4,$C4C5,$C4C6,$C4C7,$C4C8,$C4C9,
$C4CA,$C4CB,$C4CC,$C4CD,$C4CE,$C4CF,$C4D0,$C4D1,$C4D2,$C4D3,$C4D4,$C4D5,$C4D6,
$C4D7,$C4D8,$C4D9,$C4DA,$C4DB,$C4DC,$C4DD,$C4DE,$C4DF,$C4E0,$C4E1,$C4E2,$C4E3,
$C4E4,$C4E5,$C4E6,$C4E7,$C4E8,$C4E9,$C4EA,$C4EB,$C4EC,$C4ED,$C4EE,$C4EF,$C4F0,
$C4F1,$C4F2,$C4F3,$C4F4,$C4F5,$C4F6,$C4F7,$C4F8,$C4F9,$C4FA,$C4FB,$C4FC,$C4FD,
$C4FE,$C541,$C542,$C543,$C544,$C545,$C546,$C547,$C548,$C549,$C54A,$C54B,$C54C,
$C54D,$C54E,$C54F,$C550,$C551,$C552,$C553,$C554,$C555,$C556,$C557,$C558,$C559,
$C55A,$C561,$C562,$C563,$C564,$C565,$C566,$C567,$C568,$C569,$C56A,$C56B,$C56C,
$C56D,$C56E,$C56F,$C570,$C571,$C572,$C573,$C574,$C575,$C576,$C577,$C578,$C579,
$C57A,$C581,$C582,$C583,$C584,$C585,$C586,$C587,$C588,$C589,$C58A,$C58B,$C58C,
$C58D,$C58E,$C58F,$C590,$C591,$C592,$C593,$C594,$C595,$C596,$C597,$C598,$C599,
$C59A,$C59B,$C59C,$C59D,$C59E,$C59F,$C5A0,$C5A1,$C5A2,$C5A3,$C5A4,$C5A5,$C5A6,
$C5A7,$C5A8,$C5A9,$C5AA,$C5AB,$C5AC,$C5AD,$C5AE,$C5AF,$C5B0,$C5B1,$C5B2,$C5B3,
$C5B4,$C5B5,$C5B6,$C5B7,$C5B8,$C5B9,$C5BA,$C5BB,$C5BC,$C5BD,$C5BE,$C5BF,$C5C0,
$C5C1,$C5C2,$C5C3,$C5C4,$C5C5,$C5C6,$C5C7,$C5C8,$C5C9,$C5CA,$C5CB,$C5CC,$C5CD,
$C5CE,$C5CF,$C5D0,$C5D1,$C5D2,$C5D3,$C5D4,$C5D5,$C5D6,$C5D7,$C5D8,$C5D9,$C5DA,
$C5DB,$C5DC,$C5DD,$C5DE,$C5DF,$C5E0,$C5E1,$C5E2,$C5E3,$C5E4,$C5E5,$C5E6,$C5E7,
$C5E8,$C5E9,$C5EA,$C5EB,$C5EC,$C5ED,$C5EE,$C5EF,$C5F0,$C5F1,$C5F2,$C5F3,$C5F4,
$C5F5,$C5F6,$C5F7,$C5F8,$C5F9,$C5FA,$C5FB,$C5FC,$C5FD,$C5FE,$C641,$C642,$C643,
$C644,$C645,$C646,$C647,$C648,$C649,$C64A,$C64B,$C64C,$C64D,$C64E,$C64F,$C650,
$C651,$C652,$C6A1,$C6A2,$C6A3,$C6A4,$C6A5,$C6A6,$C6A7,$C6A8,$C6A9,$C6AA,$C6AB,
$C6AC,$C6AD,$C6AE,$C6AF,$C6B0,$C6B1,$C6B2,$C6B3,$C6B4,$C6B5,$C6B6,$C6B7,$C6B8,
$C6B9,$C6BA,$C6BB,$C6BC,$C6BD,$C6BE,$C6BF,$C6C0,$C6C1,$C6C2,$C6C3,$C6C4,$C6C5,
$C6C6,$C6C7,$C6C8,$C6C9,$C6CA,$C6CB,$C6CC,$C6CD,$C6CE,$C6CF,$C6D0,$C6D1,$C6D2,
$C6D3,$C6D4,$C6D5,$C6D6,$C6D7,$C6D8,$C6D9,$C6DA,$C6DB,$C6DC,$C6DD,$C6DE,$C6DF,
$C6E0,$C6E1,$C6E2,$C6E3,$C6E4,$C6E5,$C6E6,$C6E7,$C6E8,$C6E9,$C6EA,$C6EB,$C6EC,
$C6ED,$C6EE,$C6EF,$C6F0,$C6F1,$C6F2,$C6F3,$C6F4,$C6F5,$C6F6,$C6F7,$C6F8,$C6F9,
$C6FA,$C6FB,$C6FC,$C6FD,$C6FE,$C7A1,$C7A2,$C7A3,$C7A4,$C7A5,$C7A6,$C7A7,$C7A8,
$C7A9,$C7AA,$C7AB,$C7AC,$C7AD,$C7AE,$C7AF,$C7B0,$C7B1,$C7B2,$C7B3,$C7B4,$C7B5,
$C7B6,$C7B7,$C7B8,$C7B9,$C7BA,$C7BB,$C7BC,$C7BD,$C7BE,$C7BF,$C7C0,$C7C1,$C7C2,
$C7C3,$C7C4,$C7C5,$C7C6,$C7C7,$C7C8,$C7C9,$C7CA,$C7CB,$C7CC,$C7CD,$C7CE,$C7CF,
$C7D0,$C7D1,$C7D2,$C7D3,$C7D4,$C7D5,$C7D6,$C7D7,$C7D8,$C7D9,$C7DA,$C7DB,$C7DC,
$C7DD,$C7DE,$C7DF,$C7E0,$C7E1,$C7E2,$C7E3,$C7E4,$C7E5,$C7E6,$C7E7,$C7E8,$C7E9,
$C7EA,$C7EB,$C7EC,$C7ED,$C7EE,$C7EF,$C7F0,$C7F1,$C7F2,$C7F3,$C7F4,$C7F5,$C7F6,
$C7F7,$C7F8,$C7F9,$C7FA,$C7FB,$C7FC,$C7FD,$C7FE,$C8A1,$C8A2,$C8A3,$C8A4,$C8A5,
$C8A6,$C8A7,$C8A8,$C8A9,$C8AA,$C8AB,$C8AC,$C8AD,$C8AE,$C8AF,$C8B0,$C8B1,$C8B2,
$C8B3,$C8B4,$C8B5,$C8B6,$C8B7,$C8B8,$C8B9,$C8BA,$C8BB,$C8BC,$C8BD,$C8BE,$C8BF,
$C8C0,$C8C1,$C8C2,$C8C3,$C8C4,$C8C5,$C8C6,$C8C7,$C8C8,$C8C9,$C8CA,$C8CB,$C8CC,
$C8CD,$C8CE,$C8CF,$C8D0,$C8D1,$C8D2,$C8D3,$C8D4,$C8D5,$C8D6,$C8D7,$C8D8,$C8D9,
$C8DA,$C8DB,$C8DC,$C8DD,$C8DE,$C8DF,$C8E0,$C8E1,$C8E2,$C8E3,$C8E4,$C8E5,$C8E6,
$C8E7,$C8E8,$C8E9,$C8EA,$C8EB,$C8EC,$C8ED,$C8EE,$C8EF,$C8F0,$C8F1,$C8F2,$C8F3,
$C8F4,$C8F5,$C8F6,$C8F7,$C8F8,$C8F9,$C8FA,$C8FB,$C8FC,$C8FD,$C8FE,$CAA1,$CAA2,
$CAA3,$CAA4,$CAA5,$CAA6,$CAA7,$CAA8,$CAA9,$CAAA,$CAAB,$CAAC,$CAAD,$CAAE,$CAAF,
$CAB0,$CAB1,$CAB2,$CAB3,$CAB4,$CAB5,$CAB6,$CAB7,$CAB8,$CAB9,$CABA,$CABB,$CABC,
$CABD,$CABE,$CABF,$CAC0,$CAC1,$CAC2,$CAC3,$CAC4,$CAC5,$CAC6,$CAC7,$CAC8,$CAC9,
$CACA,$CACB,$CACC,$CACD,$CACE,$CACF,$CAD0,$CAD1,$CAD2,$CAD3,$CAD4,$CAD5,$CAD6,
$CAD7,$CAD8,$CAD9,$CADA,$CADB,$CADC,$CADD,$CADE,$CADF,$CAE0,$CAE1,$CAE2,$CAE3,
$CAE4,$CAE5,$CAE6,$CAE7,$CAE8,$CAE9,$CAEA,$CAEB,$CAEC,$CAED,$CAEE,$CAEF,$CAF0,
$CAF1,$CAF2,$CAF3,$CAF4,$CAF5,$CAF6,$CAF7,$CAF8,$CAF9,$CAFA,$CAFB,$CAFC,$CAFD,
$CAFE,$CBA1,$CBA2,$CBA3,$CBA4,$CBA5,$CBA6,$CBA7,$CBA8,$CBA9,$CBAA,$CBAB,$CBAC,
$CBAD,$CBAE,$CBAF,$CBB0,$CBB1,$CBB2,$CBB3,$CBB4,$CBB5,$CBB6,$CBB7,$CBB8,$CBB9,
$CBBA,$CBBB,$CBBC,$CBBD,$CBBE,$CBBF,$CBC0,$CBC1,$CBC2,$CBC3,$CBC4,$CBC5,$CBC6,
$CBC7,$CBC8,$CBC9,$CBCA,$CBCB,$CBCC,$CBCD,$CBCE,$CBCF,$CBD0,$CBD1,$CBD2,$CBD3,
$CBD4,$CBD5,$CBD6,$CBD7,$CBD8,$CBD9,$CBDA,$CBDB,$CBDC,$CBDD,$CBDE,$CBDF,$CBE0,
$CBE1,$CBE2,$CBE3,$CBE4,$CBE5,$CBE6,$CBE7,$CBE8,$CBE9,$CBEA,$CBEB,$CBEC,$CBED,
$CBEE,$CBEF,$CBF0,$CBF1,$CBF2,$CBF3,$CBF4,$CBF5,$CBF6,$CBF7,$CBF8,$CBF9,$CBFA,
$CBFB,$CBFC,$CBFD,$CBFE,$CCA1,$CCA2,$CCA3,$CCA4,$CCA5,$CCA6,$CCA7,$CCA8,$CCA9,
$CCAA,$CCAB,$CCAC,$CCAD,$CCAE,$CCAF,$CCB0,$CCB1,$CCB2,$CCB3,$CCB4,$CCB5,$CCB6,
$CCB7,$CCB8,$CCB9,$CCBA,$CCBB,$CCBC,$CCBD,$CCBE,$CCBF,$CCC0,$CCC1,$CCC2,$CCC3,
$CCC4,$CCC5,$CCC6,$CCC7,$CCC8,$CCC9,$CCCA,$CCCB,$CCCC,$CCCD,$CCCE,$CCCF,$CCD0,
$CCD1,$CCD2,$CCD3,$CCD4,$CCD5,$CCD6,$CCD7,$CCD8,$CCD9,$CCDA,$CCDB,$CCDC,$CCDD,
$CCDE,$CCDF,$CCE0,$CCE1,$CCE2,$CCE3,$CCE4,$CCE5,$CCE6,$CCE7,$CCE8,$CCE9,$CCEA,
$CCEB,$CCEC,$CCED,$CCEE,$CCEF,$CCF0,$CCF1,$CCF2,$CCF3,$CCF4,$CCF5,$CCF6,$CCF7,
$CCF8,$CCF9,$CCFA,$CCFB,$CCFC,$CCFD,$CCFE,$CDA1,$CDA2,$CDA3,$CDA4,$CDA5,$CDA6,
$CDA7,$CDA8,$CDA9,$CDAA,$CDAB,$CDAC,$CDAD,$CDAE,$CDAF,$CDB0,$CDB1,$CDB2,$CDB3,
$CDB4,$CDB5,$CDB6,$CDB7,$CDB8,$CDB9,$CDBA,$CDBB,$CDBC,$CDBD,$CDBE,$CDBF,$CDC0,
$CDC1,$CDC2,$CDC3,$CDC4,$CDC5,$CDC6,$CDC7,$CDC8,$CDC9,$CDCA,$CDCB,$CDCC,$CDCD,
$CDCE,$CDCF,$CDD0,$CDD1,$CDD2,$CDD3,$CDD4,$CDD5,$CDD6,$CDD7,$CDD8,$CDD9,$CDDA,
$CDDB,$CDDC,$CDDD,$CDDE,$CDDF,$CDE0,$CDE1,$CDE2,$CDE3,$CDE4,$CDE5,$CDE6,$CDE7,
$CDE8,$CDE9,$CDEA,$CDEB,$CDEC,$CDED,$CDEE,$CDEF,$CDF0,$CDF1,$CDF2,$CDF3,$CDF4,
$CDF5,$CDF6,$CDF7,$CDF8,$CDF9,$CDFA,$CDFB,$CDFC,$CDFD,$CDFE,$CEA1,$CEA2,$CEA3,
$CEA4,$CEA5,$CEA6,$CEA7,$CEA8,$CEA9,$CEAA,$CEAB,$CEAC,$CEAD,$CEAE,$CEAF,$CEB0,
$CEB1,$CEB2,$CEB3,$CEB4,$CEB5,$CEB6,$CEB7,$CEB8,$CEB9,$CEBA,$CEBB,$CEBC,$CEBD,
$CEBE,$CEBF,$CEC0,$CEC1,$CEC2,$CEC3,$CEC4,$CEC5,$CEC6,$CEC7,$CEC8,$CEC9,$CECA,
$CECB,$CECC,$CECD,$CECE,$CECF,$CED0,$CED1,$CED2,$CED3,$CED4,$CED5,$CED6,$CED7,
$CED8,$CED9,$CEDA,$CEDB,$CEDC,$CEDD,$CEDE,$CEDF,$CEE0,$CEE1,$CEE2,$CEE3,$CEE4,
$CEE5,$CEE6,$CEE7,$CEE8,$CEE9,$CEEA,$CEEB,$CEEC,$CEED,$CEEE,$CEEF,$CEF0,$CEF1,
$CEF2,$CEF3,$CEF4,$CEF5,$CEF6,$CEF7,$CEF8,$CEF9,$CEFA,$CEFB,$CEFC,$CEFD,$CEFE,
$CFA1,$CFA2,$CFA3,$CFA4,$CFA5,$CFA6,$CFA7,$CFA8,$CFA9,$CFAA,$CFAB,$CFAC,$CFAD,
$CFAE,$CFAF,$CFB0,$CFB1,$CFB2,$CFB3,$CFB4,$CFB5,$CFB6,$CFB7,$CFB8,$CFB9,$CFBA,
$CFBB,$CFBC,$CFBD,$CFBE,$CFBF,$CFC0,$CFC1,$CFC2,$CFC3,$CFC4,$CFC5,$CFC6,$CFC7,
$CFC8,$CFC9,$CFCA,$CFCB,$CFCC,$CFCD,$CFCE,$CFCF,$CFD0,$CFD1,$CFD2,$CFD3,$CFD4,
$CFD5,$CFD6,$CFD7,$CFD8,$CFD9,$CFDA,$CFDB,$CFDC,$CFDD,$CFDE,$CFDF,$CFE0,$CFE1,
$CFE2,$CFE3,$CFE4,$CFE5,$CFE6,$CFE7,$CFE8,$CFE9,$CFEA,$CFEB,$CFEC,$CFED,$CFEE,
$CFEF,$CFF0,$CFF1,$CFF2,$CFF3,$CFF4,$CFF5,$CFF6,$CFF7,$CFF8,$CFF9,$CFFA,$CFFB,
$CFFC,$CFFD,$CFFE,$D0A1,$D0A2,$D0A3,$D0A4,$D0A5,$D0A6,$D0A7,$D0A8,$D0A9,$D0AA,
$D0AB,$D0AC,$D0AD,$D0AE,$D0AF,$D0B0,$D0B1,$D0B2,$D0B3,$D0B4,$D0B5,$D0B6,$D0B7,
$D0B8,$D0B9,$D0BA,$D0BB,$D0BC,$D0BD,$D0BE,$D0BF,$D0C0,$D0C1,$D0C2,$D0C3,$D0C4,
$D0C5,$D0C6,$D0C7,$D0C8,$D0C9,$D0CA,$D0CB,$D0CC,$D0CD,$D0CE,$D0CF,$D0D0,$D0D1,
$D0D2,$D0D3,$D0D4,$D0D5,$D0D6,$D0D7,$D0D8,$D0D9,$D0DA,$D0DB,$D0DC,$D0DD,$D0DE,
$D0DF,$D0E0,$D0E1,$D0E2,$D0E3,$D0E4,$D0E5,$D0E6,$D0E7,$D0E8,$D0E9,$D0EA,$D0EB,
$D0EC,$D0ED,$D0EE,$D0EF,$D0F0,$D0F1,$D0F2,$D0F3,$D0F4,$D0F5,$D0F6,$D0F7,$D0F8,
$D0F9,$D0FA,$D0FB,$D0FC,$D0FD,$D0FE,$D1A1,$D1A2,$D1A3,$D1A4,$D1A5,$D1A6,$D1A7,
$D1A8,$D1A9,$D1AA,$D1AB,$D1AC,$D1AD,$D1AE,$D1AF,$D1B0,$D1B1,$D1B2,$D1B3,$D1B4,
$D1B5,$D1B6,$D1B7,$D1B8,$D1B9,$D1BA,$D1BB,$D1BC,$D1BD,$D1BE,$D1BF,$D1C0,$D1C1,
$D1C2,$D1C3,$D1C4,$D1C5,$D1C6,$D1C7,$D1C8,$D1C9,$D1CA,$D1CB,$D1CC,$D1CD,$D1CE,
$D1CF,$D1D0,$D1D1,$D1D2,$D1D3,$D1D4,$D1D5,$D1D6,$D1D7,$D1D8,$D1D9,$D1DA,$D1DB,
$D1DC,$D1DD,$D1DE,$D1DF,$D1E0,$D1E1,$D1E2,$D1E3,$D1E4,$D1E5,$D1E6,$D1E7,$D1E8,
$D1E9,$D1EA,$D1EB,$D1EC,$D1ED,$D1EE,$D1EF,$D1F0,$D1F1,$D1F2,$D1F3,$D1F4,$D1F5,
$D1F6,$D1F7,$D1F8,$D1F9,$D1FA,$D1FB,$D1FC,$D1FD,$D1FE,$D2A1,$D2A2,$D2A3,$D2A4,
$D2A5,$D2A6,$D2A7,$D2A8,$D2A9,$D2AA,$D2AB,$D2AC,$D2AD,$D2AE,$D2AF,$D2B0,$D2B1,
$D2B2,$D2B3,$D2B4,$D2B5,$D2B6,$D2B7,$D2B8,$D2B9,$D2BA,$D2BB,$D2BC,$D2BD,$D2BE,
$D2BF,$D2C0,$D2C1,$D2C2,$D2C3,$D2C4,$D2C5,$D2C6,$D2C7,$D2C8,$D2C9,$D2CA,$D2CB,
$D2CC,$D2CD,$D2CE,$D2CF,$D2D0,$D2D1,$D2D2,$D2D3,$D2D4,$D2D5,$D2D6,$D2D7,$D2D8,
$D2D9,$D2DA,$D2DB,$D2DC,$D2DD,$D2DE,$D2DF,$D2E0,$D2E1,$D2E2,$D2E3,$D2E4,$D2E5,
$D2E6,$D2E7,$D2E8,$D2E9,$D2EA,$D2EB,$D2EC,$D2ED,$D2EE,$D2EF,$D2F0,$D2F1,$D2F2,
$D2F3,$D2F4,$D2F5,$D2F6,$D2F7,$D2F8,$D2F9,$D2FA,$D2FB,$D2FC,$D2FD,$D2FE,$D3A1,
$D3A2,$D3A3,$D3A4,$D3A5,$D3A6,$D3A7,$D3A8,$D3A9,$D3AA,$D3AB,$D3AC,$D3AD,$D3AE,
$D3AF,$D3B0,$D3B1,$D3B2,$D3B3,$D3B4,$D3B5,$D3B6,$D3B7,$D3B8,$D3B9,$D3BA,$D3BB,
$D3BC,$D3BD,$D3BE,$D3BF,$D3C0,$D3C1,$D3C2,$D3C3,$D3C4,$D3C5,$D3C6,$D3C7,$D3C8,
$D3C9,$D3CA,$D3CB,$D3CC,$D3CD,$D3CE,$D3CF,$D3D0,$D3D1,$D3D2,$D3D3,$D3D4,$D3D5,
$D3D6,$D3D7,$D3D8,$D3D9,$D3DA,$D3DB,$D3DC,$D3DD,$D3DE,$D3DF,$D3E0,$D3E1,$D3E2,
$D3E3,$D3E4,$D3E5,$D3E6,$D3E7,$D3E8,$D3E9,$D3EA,$D3EB,$D3EC,$D3ED,$D3EE,$D3EF,
$D3F0,$D3F1,$D3F2,$D3F3,$D3F4,$D3F5,$D3F6,$D3F7,$D3F8,$D3F9,$D3FA,$D3FB,$D3FC,
$D3FD,$D3FE,$D4A1,$D4A2,$D4A3,$D4A4,$D4A5,$D4A6,$D4A7,$D4A8,$D4A9,$D4AA,$D4AB,
$D4AC,$D4AD,$D4AE,$D4AF,$D4B0,$D4B1,$D4B2,$D4B3,$D4B4,$D4B5,$D4B6,$D4B7,$D4B8,
$D4B9,$D4BA,$D4BB,$D4BC,$D4BD,$D4BE,$D4BF,$D4C0,$D4C1,$D4C2,$D4C3,$D4C4,$D4C5,
$D4C6,$D4C7,$D4C8,$D4C9,$D4CA,$D4CB,$D4CC,$D4CD,$D4CE,$D4CF,$D4D0,$D4D1,$D4D2,
$D4D3,$D4D4,$D4D5,$D4D6,$D4D7,$D4D8,$D4D9,$D4DA,$D4DB,$D4DC,$D4DD,$D4DE,$D4DF,
$D4E0,$D4E1,$D4E2,$D4E3,$D4E4,$D4E5,$D4E6,$D4E7,$D4E8,$D4E9,$D4EA,$D4EB,$D4EC,
$D4ED,$D4EE,$D4EF,$D4F0,$D4F1,$D4F2,$D4F3,$D4F4,$D4F5,$D4F6,$D4F7,$D4F8,$D4F9,
$D4FA,$D4FB,$D4FC,$D4FD,$D4FE,$D5A1,$D5A2,$D5A3,$D5A4,$D5A5,$D5A6,$D5A7,$D5A8,
$D5A9,$D5AA,$D5AB,$D5AC,$D5AD,$D5AE,$D5AF,$D5B0,$D5B1,$D5B2,$D5B3,$D5B4,$D5B5,
$D5B6,$D5B7,$D5B8,$D5B9,$D5BA,$D5BB,$D5BC,$D5BD,$D5BE,$D5BF,$D5C0,$D5C1,$D5C2,
$D5C3,$D5C4,$D5C5,$D5C6,$D5C7,$D5C8,$D5C9,$D5CA,$D5CB,$D5CC,$D5CD,$D5CE,$D5CF,
$D5D0,$D5D1,$D5D2,$D5D3,$D5D4,$D5D5,$D5D6,$D5D7,$D5D8,$D5D9,$D5DA,$D5DB,$D5DC,
$D5DD,$D5DE,$D5DF,$D5E0,$D5E1,$D5E2,$D5E3,$D5E4,$D5E5,$D5E6,$D5E7,$D5E8,$D5E9,
$D5EA,$D5EB,$D5EC,$D5ED,$D5EE,$D5EF,$D5F0,$D5F1,$D5F2,$D5F3,$D5F4,$D5F5,$D5F6,
$D5F7,$D5F8,$D5F9,$D5FA,$D5FB,$D5FC,$D5FD,$D5FE,$D6A1,$D6A2,$D6A3,$D6A4,$D6A5,
$D6A6,$D6A7,$D6A8,$D6A9,$D6AA,$D6AB,$D6AC,$D6AD,$D6AE,$D6AF,$D6B0,$D6B1,$D6B2,
$D6B3,$D6B4,$D6B5,$D6B6,$D6B7,$D6B8,$D6B9,$D6BA,$D6BB,$D6BC,$D6BD,$D6BE,$D6BF,
$D6C0,$D6C1,$D6C2,$D6C3,$D6C4,$D6C5,$D6C6,$D6C7,$D6C8,$D6C9,$D6CA,$D6CB,$D6CC,
$D6CD,$D6CE,$D6CF,$D6D0,$D6D1,$D6D2,$D6D3,$D6D4,$D6D5,$D6D6,$D6D7,$D6D8,$D6D9,
$D6DA,$D6DB,$D6DC,$D6DD,$D6DE,$D6DF,$D6E0,$D6E1,$D6E2,$D6E3,$D6E4,$D6E5,$D6E6,
$D6E7,$D6E8,$D6E9,$D6EA,$D6EB,$D6EC,$D6ED,$D6EE,$D6EF,$D6F0,$D6F1,$D6F2,$D6F3,
$D6F4,$D6F5,$D6F6,$D6F7,$D6F8,$D6F9,$D6FA,$D6FB,$D6FC,$D6FD,$D6FE,$D7A1,$D7A2,
$D7A3,$D7A4,$D7A5,$D7A6,$D7A7,$D7A8,$D7A9,$D7AA,$D7AB,$D7AC,$D7AD,$D7AE,$D7AF,
$D7B0,$D7B1,$D7B2,$D7B3,$D7B4,$D7B5,$D7B6,$D7B7,$D7B8,$D7B9,$D7BA,$D7BB,$D7BC,
$D7BD,$D7BE,$D7BF,$D7C0,$D7C1,$D7C2,$D7C3,$D7C4,$D7C5,$D7C6,$D7C7,$D7C8,$D7C9,
$D7CA,$D7CB,$D7CC,$D7CD,$D7CE,$D7CF,$D7D0,$D7D1,$D7D2,$D7D3,$D7D4,$D7D5,$D7D6,
$D7D7,$D7D8,$D7D9,$D7DA,$D7DB,$D7DC,$D7DD,$D7DE,$D7DF,$D7E0,$D7E1,$D7E2,$D7E3,
$D7E4,$D7E5,$D7E6,$D7E7,$D7E8,$D7E9,$D7EA,$D7EB,$D7EC,$D7ED,$D7EE,$D7EF,$D7F0,
$D7F1,$D7F2,$D7F3,$D7F4,$D7F5,$D7F6,$D7F7,$D7F8,$D7F9,$D7FA,$D7FB,$D7FC,$D7FD,
$D7FE,$D8A1,$D8A2,$D8A3,$D8A4,$D8A5,$D8A6,$D8A7,$D8A8,$D8A9,$D8AA,$D8AB,$D8AC,
$D8AD,$D8AE,$D8AF,$D8B0,$D8B1,$D8B2,$D8B3,$D8B4,$D8B5,$D8B6,$D8B7,$D8B8,$D8B9,
$D8BA,$D8BB,$D8BC,$D8BD,$D8BE,$D8BF,$D8C0,$D8C1,$D8C2,$D8C3,$D8C4,$D8C5,$D8C6,
$D8C7,$D8C8,$D8C9,$D8CA,$D8CB,$D8CC,$D8CD,$D8CE,$D8CF,$D8D0,$D8D1,$D8D2,$D8D3,
$D8D4,$D8D5,$D8D6,$D8D7,$D8D8,$D8D9,$D8DA,$D8DB,$D8DC,$D8DD,$D8DE,$D8DF,$D8E0,
$D8E1,$D8E2,$D8E3,$D8E4,$D8E5,$D8E6,$D8E7,$D8E8,$D8E9,$D8EA,$D8EB,$D8EC,$D8ED,
$D8EE,$D8EF,$D8F0,$D8F1,$D8F2,$D8F3,$D8F4,$D8F5,$D8F6,$D8F7,$D8F8,$D8F9,$D8FA,
$D8FB,$D8FC,$D8FD,$D8FE,$D9A1,$D9A2,$D9A3,$D9A4,$D9A5,$D9A6,$D9A7,$D9A8,$D9A9,
$D9AA,$D9AB,$D9AC,$D9AD,$D9AE,$D9AF,$D9B0,$D9B1,$D9B2,$D9B3,$D9B4,$D9B5,$D9B6,
$D9B7,$D9B8,$D9B9,$D9BA,$D9BB,$D9BC,$D9BD,$D9BE,$D9BF,$D9C0,$D9C1,$D9C2,$D9C3,
$D9C4,$D9C5,$D9C6,$D9C7,$D9C8,$D9C9,$D9CA,$D9CB,$D9CC,$D9CD,$D9CE,$D9CF,$D9D0,
$D9D1,$D9D2,$D9D3,$D9D4,$D9D5,$D9D6,$D9D7,$D9D8,$D9D9,$D9DA,$D9DB,$D9DC,$D9DD,
$D9DE,$D9DF,$D9E0,$D9E1,$D9E2,$D9E3,$D9E4,$D9E5,$D9E6,$D9E7,$D9E8,$D9E9,$D9EA,
$D9EB,$D9EC,$D9ED,$D9EE,$D9EF,$D9F0,$D9F1,$D9F2,$D9F3,$D9F4,$D9F5,$D9F6,$D9F7,
$D9F8,$D9F9,$D9FA,$D9FB,$D9FC,$D9FD,$D9FE,$DAA1,$DAA2,$DAA3,$DAA4,$DAA5,$DAA6,
$DAA7,$DAA8,$DAA9,$DAAA,$DAAB,$DAAC,$DAAD,$DAAE,$DAAF,$DAB0,$DAB1,$DAB2,$DAB3,
$DAB4,$DAB5,$DAB6,$DAB7,$DAB8,$DAB9,$DABA,$DABB,$DABC,$DABD,$DABE,$DABF,$DAC0,
$DAC1,$DAC2,$DAC3,$DAC4,$DAC5,$DAC6,$DAC7,$DAC8,$DAC9,$DACA,$DACB,$DACC,$DACD,
$DACE,$DACF,$DAD0,$DAD1,$DAD2,$DAD3,$DAD4,$DAD5,$DAD6,$DAD7,$DAD8,$DAD9,$DADA,
$DADB,$DADC,$DADD,$DADE,$DADF,$DAE0,$DAE1,$DAE2,$DAE3,$DAE4,$DAE5,$DAE6,$DAE7,
$DAE8,$DAE9,$DAEA,$DAEB,$DAEC,$DAED,$DAEE,$DAEF,$DAF0,$DAF1,$DAF2,$DAF3,$DAF4,
$DAF5,$DAF6,$DAF7,$DAF8,$DAF9,$DAFA,$DAFB,$DAFC,$DAFD,$DAFE,$DBA1,$DBA2,$DBA3,
$DBA4,$DBA5,$DBA6,$DBA7,$DBA8,$DBA9,$DBAA,$DBAB,$DBAC,$DBAD,$DBAE,$DBAF,$DBB0,
$DBB1,$DBB2,$DBB3,$DBB4,$DBB5,$DBB6,$DBB7,$DBB8,$DBB9,$DBBA,$DBBB,$DBBC,$DBBD,
$DBBE,$DBBF,$DBC0,$DBC1,$DBC2,$DBC3,$DBC4,$DBC5,$DBC6,$DBC7,$DBC8,$DBC9,$DBCA,
$DBCB,$DBCC,$DBCD,$DBCE,$DBCF,$DBD0,$DBD1,$DBD2,$DBD3,$DBD4,$DBD5,$DBD6,$DBD7,
$DBD8,$DBD9,$DBDA,$DBDB,$DBDC,$DBDD,$DBDE,$DBDF,$DBE0,$DBE1,$DBE2,$DBE3,$DBE4,
$DBE5,$DBE6,$DBE7,$DBE8,$DBE9,$DBEA,$DBEB,$DBEC,$DBED,$DBEE,$DBEF,$DBF0,$DBF1,
$DBF2,$DBF3,$DBF4,$DBF5,$DBF6,$DBF7,$DBF8,$DBF9,$DBFA,$DBFB,$DBFC,$DBFD,$DBFE,
$DCA1,$DCA2,$DCA3,$DCA4,$DCA5,$DCA6,$DCA7,$DCA8,$DCA9,$DCAA,$DCAB,$DCAC,$DCAD,
$DCAE,$DCAF,$DCB0,$DCB1,$DCB2,$DCB3,$DCB4,$DCB5,$DCB6,$DCB7,$DCB8,$DCB9,$DCBA,
$DCBB,$DCBC,$DCBD,$DCBE,$DCBF,$DCC0,$DCC1,$DCC2,$DCC3,$DCC4,$DCC5,$DCC6,$DCC7,
$DCC8,$DCC9,$DCCA,$DCCB,$DCCC,$DCCD,$DCCE,$DCCF,$DCD0,$DCD1,$DCD2,$DCD3,$DCD4,
$DCD5,$DCD6,$DCD7,$DCD8,$DCD9,$DCDA,$DCDB,$DCDC,$DCDD,$DCDE,$DCDF,$DCE0,$DCE1,
$DCE2,$DCE3,$DCE4,$DCE5,$DCE6,$DCE7,$DCE8,$DCE9,$DCEA,$DCEB,$DCEC,$DCED,$DCEE,
$DCEF,$DCF0,$DCF1,$DCF2,$DCF3,$DCF4,$DCF5,$DCF6,$DCF7,$DCF8,$DCF9,$DCFA,$DCFB,
$DCFC,$DCFD,$DCFE,$DDA1,$DDA2,$DDA3,$DDA4,$DDA5,$DDA6,$DDA7,$DDA8,$DDA9,$DDAA,
$DDAB,$DDAC,$DDAD,$DDAE,$DDAF,$DDB0,$DDB1,$DDB2,$DDB3,$DDB4,$DDB5,$DDB6,$DDB7,
$DDB8,$DDB9,$DDBA,$DDBB,$DDBC,$DDBD,$DDBE,$DDBF,$DDC0,$DDC1,$DDC2,$DDC3,$DDC4,
$DDC5,$DDC6,$DDC7,$DDC8,$DDC9,$DDCA,$DDCB,$DDCC,$DDCD,$DDCE,$DDCF,$DDD0,$DDD1,
$DDD2,$DDD3,$DDD4,$DDD5,$DDD6,$DDD7,$DDD8,$DDD9,$DDDA,$DDDB,$DDDC,$DDDD,$DDDE,
$DDDF,$DDE0,$DDE1,$DDE2,$DDE3,$DDE4,$DDE5,$DDE6,$DDE7,$DDE8,$DDE9,$DDEA,$DDEB,
$DDEC,$DDED,$DDEE,$DDEF,$DDF0,$DDF1,$DDF2,$DDF3,$DDF4,$DDF5,$DDF6,$DDF7,$DDF8,
$DDF9,$DDFA,$DDFB,$DDFC,$DDFD,$DDFE,$DEA1,$DEA2,$DEA3,$DEA4,$DEA5,$DEA6,$DEA7,
$DEA8,$DEA9,$DEAA,$DEAB,$DEAC,$DEAD,$DEAE,$DEAF,$DEB0,$DEB1,$DEB2,$DEB3,$DEB4,
$DEB5,$DEB6,$DEB7,$DEB8,$DEB9,$DEBA,$DEBB,$DEBC,$DEBD,$DEBE,$DEBF,$DEC0,$DEC1,
$DEC2,$DEC3,$DEC4,$DEC5,$DEC6,$DEC7,$DEC8,$DEC9,$DECA,$DECB,$DECC,$DECD,$DECE,
$DECF,$DED0,$DED1,$DED2,$DED3,$DED4,$DED5,$DED6,$DED7,$DED8,$DED9,$DEDA,$DEDB,
$DEDC,$DEDD,$DEDE,$DEDF,$DEE0,$DEE1,$DEE2,$DEE3,$DEE4,$DEE5,$DEE6,$DEE7,$DEE8,
$DEE9,$DEEA,$DEEB,$DEEC,$DEED,$DEEE,$DEEF,$DEF0,$DEF1,$DEF2,$DEF3,$DEF4,$DEF5,
$DEF6,$DEF7,$DEF8,$DEF9,$DEFA,$DEFB,$DEFC,$DEFD,$DEFE,$DFA1,$DFA2,$DFA3,$DFA4,
$DFA5,$DFA6,$DFA7,$DFA8,$DFA9,$DFAA,$DFAB,$DFAC,$DFAD,$DFAE,$DFAF,$DFB0,$DFB1,
$DFB2,$DFB3,$DFB4,$DFB5,$DFB6,$DFB7,$DFB8,$DFB9,$DFBA,$DFBB,$DFBC,$DFBD,$DFBE,
$DFBF,$DFC0,$DFC1,$DFC2,$DFC3,$DFC4,$DFC5,$DFC6,$DFC7,$DFC8,$DFC9,$DFCA,$DFCB,
$DFCC,$DFCD,$DFCE,$DFCF,$DFD0,$DFD1,$DFD2,$DFD3,$DFD4,$DFD5,$DFD6,$DFD7,$DFD8,
$DFD9,$DFDA,$DFDB,$DFDC,$DFDD,$DFDE,$DFDF,$DFE0,$DFE1,$DFE2,$DFE3,$DFE4,$DFE5,
$DFE6,$DFE7,$DFE8,$DFE9,$DFEA,$DFEB,$DFEC,$DFED,$DFEE,$DFEF,$DFF0,$DFF1,$DFF2,
$DFF3,$DFF4,$DFF5,$DFF6,$DFF7,$DFF8,$DFF9,$DFFA,$DFFB,$DFFC,$DFFD,$DFFE,$E0A1,
$E0A2,$E0A3,$E0A4,$E0A5,$E0A6,$E0A7,$E0A8,$E0A9,$E0AA,$E0AB,$E0AC,$E0AD,$E0AE,
$E0AF,$E0B0,$E0B1,$E0B2,$E0B3,$E0B4,$E0B5,$E0B6,$E0B7,$E0B8,$E0B9,$E0BA,$E0BB,
$E0BC,$E0BD,$E0BE,$E0BF,$E0C0,$E0C1,$E0C2,$E0C3,$E0C4,$E0C5,$E0C6,$E0C7,$E0C8,
$E0C9,$E0CA,$E0CB,$E0CC,$E0CD,$E0CE,$E0CF,$E0D0,$E0D1,$E0D2,$E0D3,$E0D4,$E0D5,
$E0D6,$E0D7,$E0D8,$E0D9,$E0DA,$E0DB,$E0DC,$E0DD,$E0DE,$E0DF,$E0E0,$E0E1,$E0E2,
$E0E3,$E0E4,$E0E5,$E0E6,$E0E7,$E0E8,$E0E9,$E0EA,$E0EB,$E0EC,$E0ED,$E0EE,$E0EF,
$E0F0,$E0F1,$E0F2,$E0F3,$E0F4,$E0F5,$E0F6,$E0F7,$E0F8,$E0F9,$E0FA,$E0FB,$E0FC,
$E0FD,$E0FE,$E1A1,$E1A2,$E1A3,$E1A4,$E1A5,$E1A6,$E1A7,$E1A8,$E1A9,$E1AA,$E1AB,
$E1AC,$E1AD,$E1AE,$E1AF,$E1B0,$E1B1,$E1B2,$E1B3,$E1B4,$E1B5,$E1B6,$E1B7,$E1B8,
$E1B9,$E1BA,$E1BB,$E1BC,$E1BD,$E1BE,$E1BF,$E1C0,$E1C1,$E1C2,$E1C3,$E1C4,$E1C5,
$E1C6,$E1C7,$E1C8,$E1C9,$E1CA,$E1CB,$E1CC,$E1CD,$E1CE,$E1CF,$E1D0,$E1D1,$E1D2,
$E1D3,$E1D4,$E1D5,$E1D6,$E1D7,$E1D8,$E1D9,$E1DA,$E1DB,$E1DC,$E1DD,$E1DE,$E1DF,
$E1E0,$E1E1,$E1E2,$E1E3,$E1E4,$E1E5,$E1E6,$E1E7,$E1E8,$E1E9,$E1EA,$E1EB,$E1EC,
$E1ED,$E1EE,$E1EF,$E1F0,$E1F1,$E1F2,$E1F3,$E1F4,$E1F5,$E1F6,$E1F7,$E1F8,$E1F9,
$E1FA,$E1FB,$E1FC,$E1FD,$E1FE,$E2A1,$E2A2,$E2A3,$E2A4,$E2A5,$E2A6,$E2A7,$E2A8,
$E2A9,$E2AA,$E2AB,$E2AC,$E2AD,$E2AE,$E2AF,$E2B0,$E2B1,$E2B2,$E2B3,$E2B4,$E2B5,
$E2B6,$E2B7,$E2B8,$E2B9,$E2BA,$E2BB,$E2BC,$E2BD,$E2BE,$E2BF,$E2C0,$E2C1,$E2C2,
$E2C3,$E2C4,$E2C5,$E2C6,$E2C7,$E2C8,$E2C9,$E2CA,$E2CB,$E2CC,$E2CD,$E2CE,$E2CF,
$E2D0,$E2D1,$E2D2,$E2D3,$E2D4,$E2D5,$E2D6,$E2D7,$E2D8,$E2D9,$E2DA,$E2DB,$E2DC,
$E2DD,$E2DE,$E2DF,$E2E0,$E2E1,$E2E2,$E2E3,$E2E4,$E2E5,$E2E6,$E2E7,$E2E8,$E2E9,
$E2EA,$E2EB,$E2EC,$E2ED,$E2EE,$E2EF,$E2F0,$E2F1,$E2F2,$E2F3,$E2F4,$E2F5,$E2F6,
$E2F7,$E2F8,$E2F9,$E2FA,$E2FB,$E2FC,$E2FD,$E2FE,$E3A1,$E3A2,$E3A3,$E3A4,$E3A5,
$E3A6,$E3A7,$E3A8,$E3A9,$E3AA,$E3AB,$E3AC,$E3AD,$E3AE,$E3AF,$E3B0,$E3B1,$E3B2,
$E3B3,$E3B4,$E3B5,$E3B6,$E3B7,$E3B8,$E3B9,$E3BA,$E3BB,$E3BC,$E3BD,$E3BE,$E3BF,
$E3C0,$E3C1,$E3C2,$E3C3,$E3C4,$E3C5,$E3C6,$E3C7,$E3C8,$E3C9,$E3CA,$E3CB,$E3CC,
$E3CD,$E3CE,$E3CF,$E3D0,$E3D1,$E3D2,$E3D3,$E3D4,$E3D5,$E3D6,$E3D7,$E3D8,$E3D9,
$E3DA,$E3DB,$E3DC,$E3DD,$E3DE,$E3DF,$E3E0,$E3E1,$E3E2,$E3E3,$E3E4,$E3E5,$E3E6,
$E3E7,$E3E8,$E3E9,$E3EA,$E3EB,$E3EC,$E3ED,$E3EE,$E3EF,$E3F0,$E3F1,$E3F2,$E3F3,
$E3F4,$E3F5,$E3F6,$E3F7,$E3F8,$E3F9,$E3FA,$E3FB,$E3FC,$E3FD,$E3FE,$E4A1,$E4A2,
$E4A3,$E4A4,$E4A5,$E4A6,$E4A7,$E4A8,$E4A9,$E4AA,$E4AB,$E4AC,$E4AD,$E4AE,$E4AF,
$E4B0,$E4B1,$E4B2,$E4B3,$E4B4,$E4B5,$E4B6,$E4B7,$E4B8,$E4B9,$E4BA,$E4BB,$E4BC,
$E4BD,$E4BE,$E4BF,$E4C0,$E4C1,$E4C2,$E4C3,$E4C4,$E4C5,$E4C6,$E4C7,$E4C8,$E4C9,
$E4CA,$E4CB,$E4CC,$E4CD,$E4CE,$E4CF,$E4D0,$E4D1,$E4D2,$E4D3,$E4D4,$E4D5,$E4D6,
$E4D7,$E4D8,$E4D9,$E4DA,$E4DB,$E4DC,$E4DD,$E4DE,$E4DF,$E4E0,$E4E1,$E4E2,$E4E3,
$E4E4,$E4E5,$E4E6,$E4E7,$E4E8,$E4E9,$E4EA,$E4EB,$E4EC,$E4ED,$E4EE,$E4EF,$E4F0,
$E4F1,$E4F2,$E4F3,$E4F4,$E4F5,$E4F6,$E4F7,$E4F8,$E4F9,$E4FA,$E4FB,$E4FC,$E4FD,
$E4FE,$E5A1,$E5A2,$E5A3,$E5A4,$E5A5,$E5A6,$E5A7,$E5A8,$E5A9,$E5AA,$E5AB,$E5AC,
$E5AD,$E5AE,$E5AF,$E5B0,$E5B1,$E5B2,$E5B3,$E5B4,$E5B5,$E5B6,$E5B7,$E5B8,$E5B9,
$E5BA,$E5BB,$E5BC,$E5BD,$E5BE,$E5BF,$E5C0,$E5C1,$E5C2,$E5C3,$E5C4,$E5C5,$E5C6,
$E5C7,$E5C8,$E5C9,$E5CA,$E5CB,$E5CC,$E5CD,$E5CE,$E5CF,$E5D0,$E5D1,$E5D2,$E5D3,
$E5D4,$E5D5,$E5D6,$E5D7,$E5D8,$E5D9,$E5DA,$E5DB,$E5DC,$E5DD,$E5DE,$E5DF,$E5E0,
$E5E1,$E5E2,$E5E3,$E5E4,$E5E5,$E5E6,$E5E7,$E5E8,$E5E9,$E5EA,$E5EB,$E5EC,$E5ED,
$E5EE,$E5EF,$E5F0,$E5F1,$E5F2,$E5F3,$E5F4,$E5F5,$E5F6,$E5F7,$E5F8,$E5F9,$E5FA,
$E5FB,$E5FC,$E5FD,$E5FE,$E6A1,$E6A2,$E6A3,$E6A4,$E6A5,$E6A6,$E6A7,$E6A8,$E6A9,
$E6AA,$E6AB,$E6AC,$E6AD,$E6AE,$E6AF,$E6B0,$E6B1,$E6B2,$E6B3,$E6B4,$E6B5,$E6B6,
$E6B7,$E6B8,$E6B9,$E6BA,$E6BB,$E6BC,$E6BD,$E6BE,$E6BF,$E6C0,$E6C1,$E6C2,$E6C3,
$E6C4,$E6C5,$E6C6,$E6C7,$E6C8,$E6C9,$E6CA,$E6CB,$E6CC,$E6CD,$E6CE,$E6CF,$E6D0,
$E6D1,$E6D2,$E6D3,$E6D4,$E6D5,$E6D6,$E6D7,$E6D8,$E6D9,$E6DA,$E6DB,$E6DC,$E6DD,
$E6DE,$E6DF,$E6E0,$E6E1,$E6E2,$E6E3,$E6E4,$E6E5,$E6E6,$E6E7,$E6E8,$E6E9,$E6EA,
$E6EB,$E6EC,$E6ED,$E6EE,$E6EF,$E6F0,$E6F1,$E6F2,$E6F3,$E6F4,$E6F5,$E6F6,$E6F7,
$E6F8,$E6F9,$E6FA,$E6FB,$E6FC,$E6FD,$E6FE,$E7A1,$E7A2,$E7A3,$E7A4,$E7A5,$E7A6,
$E7A7,$E7A8,$E7A9,$E7AA,$E7AB,$E7AC,$E7AD,$E7AE,$E7AF,$E7B0,$E7B1,$E7B2,$E7B3,
$E7B4,$E7B5,$E7B6,$E7B7,$E7B8,$E7B9,$E7BA,$E7BB,$E7BC,$E7BD,$E7BE,$E7BF,$E7C0,
$E7C1,$E7C2,$E7C3,$E7C4,$E7C5,$E7C6,$E7C7,$E7C8,$E7C9,$E7CA,$E7CB,$E7CC,$E7CD,
$E7CE,$E7CF,$E7D0,$E7D1,$E7D2,$E7D3,$E7D4,$E7D5,$E7D6,$E7D7,$E7D8,$E7D9,$E7DA,
$E7DB,$E7DC,$E7DD,$E7DE,$E7DF,$E7E0,$E7E1,$E7E2,$E7E3,$E7E4,$E7E5,$E7E6,$E7E7,
$E7E8,$E7E9,$E7EA,$E7EB,$E7EC,$E7ED,$E7EE,$E7EF,$E7F0,$E7F1,$E7F2,$E7F3,$E7F4,
$E7F5,$E7F6,$E7F7,$E7F8,$E7F9,$E7FA,$E7FB,$E7FC,$E7FD,$E7FE,$E8A1,$E8A2,$E8A3,
$E8A4,$E8A5,$E8A6,$E8A7,$E8A8,$E8A9,$E8AA,$E8AB,$E8AC,$E8AD,$E8AE,$E8AF,$E8B0,
$E8B1,$E8B2,$E8B3,$E8B4,$E8B5,$E8B6,$E8B7,$E8B8,$E8B9,$E8BA,$E8BB,$E8BC,$E8BD,
$E8BE,$E8BF,$E8C0,$E8C1,$E8C2,$E8C3,$E8C4,$E8C5,$E8C6,$E8C7,$E8C8,$E8C9,$E8CA,
$E8CB,$E8CC,$E8CD,$E8CE,$E8CF,$E8D0,$E8D1,$E8D2,$E8D3,$E8D4,$E8D5,$E8D6,$E8D7,
$E8D8,$E8D9,$E8DA,$E8DB,$E8DC,$E8DD,$E8DE,$E8DF,$E8E0,$E8E1,$E8E2,$E8E3,$E8E4,
$E8E5,$E8E6,$E8E7,$E8E8,$E8E9,$E8EA,$E8EB,$E8EC,$E8ED,$E8EE,$E8EF,$E8F0,$E8F1,
$E8F2,$E8F3,$E8F4,$E8F5,$E8F6,$E8F7,$E8F8,$E8F9,$E8FA,$E8FB,$E8FC,$E8FD,$E8FE,
$E9A1,$E9A2,$E9A3,$E9A4,$E9A5,$E9A6,$E9A7,$E9A8,$E9A9,$E9AA,$E9AB,$E9AC,$E9AD,
$E9AE,$E9AF,$E9B0,$E9B1,$E9B2,$E9B3,$E9B4,$E9B5,$E9B6,$E9B7,$E9B8,$E9B9,$E9BA,
$E9BB,$E9BC,$E9BD,$E9BE,$E9BF,$E9C0,$E9C1,$E9C2,$E9C3,$E9C4,$E9C5,$E9C6,$E9C7,
$E9C8,$E9C9,$E9CA,$E9CB,$E9CC,$E9CD,$E9CE,$E9CF,$E9D0,$E9D1,$E9D2,$E9D3,$E9D4,
$E9D5,$E9D6,$E9D7,$E9D8,$E9D9,$E9DA,$E9DB,$E9DC,$E9DD,$E9DE,$E9DF,$E9E0,$E9E1,
$E9E2,$E9E3,$E9E4,$E9E5,$E9E6,$E9E7,$E9E8,$E9E9,$E9EA,$E9EB,$E9EC,$E9ED,$E9EE,
$E9EF,$E9F0,$E9F1,$E9F2,$E9F3,$E9F4,$E9F5,$E9F6,$E9F7,$E9F8,$E9F9,$E9FA,$E9FB,
$E9FC,$E9FD,$E9FE,$EAA1,$EAA2,$EAA3,$EAA4,$EAA5,$EAA6,$EAA7,$EAA8,$EAA9,$EAAA,
$EAAB,$EAAC,$EAAD,$EAAE,$EAAF,$EAB0,$EAB1,$EAB2,$EAB3,$EAB4,$EAB5,$EAB6,$EAB7,
$EAB8,$EAB9,$EABA,$EABB,$EABC,$EABD,$EABE,$EABF,$EAC0,$EAC1,$EAC2,$EAC3,$EAC4,
$EAC5,$EAC6,$EAC7,$EAC8,$EAC9,$EACA,$EACB,$EACC,$EACD,$EACE,$EACF,$EAD0,$EAD1,
$EAD2,$EAD3,$EAD4,$EAD5,$EAD6,$EAD7,$EAD8,$EAD9,$EADA,$EADB,$EADC,$EADD,$EADE,
$EADF,$EAE0,$EAE1,$EAE2,$EAE3,$EAE4,$EAE5,$EAE6,$EAE7,$EAE8,$EAE9,$EAEA,$EAEB,
$EAEC,$EAED,$EAEE,$EAEF,$EAF0,$EAF1,$EAF2,$EAF3,$EAF4,$EAF5,$EAF6,$EAF7,$EAF8,
$EAF9,$EAFA,$EAFB,$EAFC,$EAFD,$EAFE,$EBA1,$EBA2,$EBA3,$EBA4,$EBA5,$EBA6,$EBA7,
$EBA8,$EBA9,$EBAA,$EBAB,$EBAC,$EBAD,$EBAE,$EBAF,$EBB0,$EBB1,$EBB2,$EBB3,$EBB4,
$EBB5,$EBB6,$EBB7,$EBB8,$EBB9,$EBBA,$EBBB,$EBBC,$EBBD,$EBBE,$EBBF,$EBC0,$EBC1,
$EBC2,$EBC3,$EBC4,$EBC5,$EBC6,$EBC7,$EBC8,$EBC9,$EBCA,$EBCB,$EBCC,$EBCD,$EBCE,
$EBCF,$EBD0,$EBD1,$EBD2,$EBD3,$EBD4,$EBD5,$EBD6,$EBD7,$EBD8,$EBD9,$EBDA,$EBDB,
$EBDC,$EBDD,$EBDE,$EBDF,$EBE0,$EBE1,$EBE2,$EBE3,$EBE4,$EBE5,$EBE6,$EBE7,$EBE8,
$EBE9,$EBEA,$EBEB,$EBEC,$EBED,$EBEE,$EBEF,$EBF0,$EBF1,$EBF2,$EBF3,$EBF4,$EBF5,
$EBF6,$EBF7,$EBF8,$EBF9,$EBFA,$EBFB,$EBFC,$EBFD,$EBFE,$ECA1,$ECA2,$ECA3,$ECA4,
$ECA5,$ECA6,$ECA7,$ECA8,$ECA9,$ECAA,$ECAB,$ECAC,$ECAD,$ECAE,$ECAF,$ECB0,$ECB1,
$ECB2,$ECB3,$ECB4,$ECB5,$ECB6,$ECB7,$ECB8,$ECB9,$ECBA,$ECBB,$ECBC,$ECBD,$ECBE,
$ECBF,$ECC0,$ECC1,$ECC2,$ECC3,$ECC4,$ECC5,$ECC6,$ECC7,$ECC8,$ECC9,$ECCA,$ECCB,
$ECCC,$ECCD,$ECCE,$ECCF,$ECD0,$ECD1,$ECD2,$ECD3,$ECD4,$ECD5,$ECD6,$ECD7,$ECD8,
$ECD9,$ECDA,$ECDB,$ECDC,$ECDD,$ECDE,$ECDF,$ECE0,$ECE1,$ECE2,$ECE3,$ECE4,$ECE5,
$ECE6,$ECE7,$ECE8,$ECE9,$ECEA,$ECEB,$ECEC,$ECED,$ECEE,$ECEF,$ECF0,$ECF1,$ECF2,
$ECF3,$ECF4,$ECF5,$ECF6,$ECF7,$ECF8,$ECF9,$ECFA,$ECFB,$ECFC,$ECFD,$ECFE,$EDA1,
$EDA2,$EDA3,$EDA4,$EDA5,$EDA6,$EDA7,$EDA8,$EDA9,$EDAA,$EDAB,$EDAC,$EDAD,$EDAE,
$EDAF,$EDB0,$EDB1,$EDB2,$EDB3,$EDB4,$EDB5,$EDB6,$EDB7,$EDB8,$EDB9,$EDBA,$EDBB,
$EDBC,$EDBD,$EDBE,$EDBF,$EDC0,$EDC1,$EDC2,$EDC3,$EDC4,$EDC5,$EDC6,$EDC7,$EDC8,
$EDC9,$EDCA,$EDCB,$EDCC,$EDCD,$EDCE,$EDCF,$EDD0,$EDD1,$EDD2,$EDD3,$EDD4,$EDD5,
$EDD6,$EDD7,$EDD8,$EDD9,$EDDA,$EDDB,$EDDC,$EDDD,$EDDE,$EDDF,$EDE0,$EDE1,$EDE2,
$EDE3,$EDE4,$EDE5,$EDE6,$EDE7,$EDE8,$EDE9,$EDEA,$EDEB,$EDEC,$EDED,$EDEE,$EDEF,
$EDF0,$EDF1,$EDF2,$EDF3,$EDF4,$EDF5,$EDF6,$EDF7,$EDF8,$EDF9,$EDFA,$EDFB,$EDFC,
$EDFD,$EDFE,$EEA1,$EEA2,$EEA3,$EEA4,$EEA5,$EEA6,$EEA7,$EEA8,$EEA9,$EEAA,$EEAB,
$EEAC,$EEAD,$EEAE,$EEAF,$EEB0,$EEB1,$EEB2,$EEB3,$EEB4,$EEB5,$EEB6,$EEB7,$EEB8,
$EEB9,$EEBA,$EEBB,$EEBC,$EEBD,$EEBE,$EEBF,$EEC0,$EEC1,$EEC2,$EEC3,$EEC4,$EEC5,
$EEC6,$EEC7,$EEC8,$EEC9,$EECA,$EECB,$EECC,$EECD,$EECE,$EECF,$EED0,$EED1,$EED2,
$EED3,$EED4,$EED5,$EED6,$EED7,$EED8,$EED9,$EEDA,$EEDB,$EEDC,$EEDD,$EEDE,$EEDF,
$EEE0,$EEE1,$EEE2,$EEE3,$EEE4,$EEE5,$EEE6,$EEE7,$EEE8,$EEE9,$EEEA,$EEEB,$EEEC,
$EEED,$EEEE,$EEEF,$EEF0,$EEF1,$EEF2,$EEF3,$EEF4,$EEF5,$EEF6,$EEF7,$EEF8,$EEF9,
$EEFA,$EEFB,$EEFC,$EEFD,$EEFE,$EFA1,$EFA2,$EFA3,$EFA4,$EFA5,$EFA6,$EFA7,$EFA8,
$EFA9,$EFAA,$EFAB,$EFAC,$EFAD,$EFAE,$EFAF,$EFB0,$EFB1,$EFB2,$EFB3,$EFB4,$EFB5,
$EFB6,$EFB7,$EFB8,$EFB9,$EFBA,$EFBB,$EFBC,$EFBD,$EFBE,$EFBF,$EFC0,$EFC1,$EFC2,
$EFC3,$EFC4,$EFC5,$EFC6,$EFC7,$EFC8,$EFC9,$EFCA,$EFCB,$EFCC,$EFCD,$EFCE,$EFCF,
$EFD0,$EFD1,$EFD2,$EFD3,$EFD4,$EFD5,$EFD6,$EFD7,$EFD8,$EFD9,$EFDA,$EFDB,$EFDC,
$EFDD,$EFDE,$EFDF,$EFE0,$EFE1,$EFE2,$EFE3,$EFE4,$EFE5,$EFE6,$EFE7,$EFE8,$EFE9,
$EFEA,$EFEB,$EFEC,$EFED,$EFEE,$EFEF,$EFF0,$EFF1,$EFF2,$EFF3,$EFF4,$EFF5,$EFF6,
$EFF7,$EFF8,$EFF9,$EFFA,$EFFB,$EFFC,$EFFD,$EFFE,$F0A1,$F0A2,$F0A3,$F0A4,$F0A5,
$F0A6,$F0A7,$F0A8,$F0A9,$F0AA,$F0AB,$F0AC,$F0AD,$F0AE,$F0AF,$F0B0,$F0B1,$F0B2,
$F0B3,$F0B4,$F0B5,$F0B6,$F0B7,$F0B8,$F0B9,$F0BA,$F0BB,$F0BC,$F0BD,$F0BE,$F0BF,
$F0C0,$F0C1,$F0C2,$F0C3,$F0C4,$F0C5,$F0C6,$F0C7,$F0C8,$F0C9,$F0CA,$F0CB,$F0CC,
$F0CD,$F0CE,$F0CF,$F0D0,$F0D1,$F0D2,$F0D3,$F0D4,$F0D5,$F0D6,$F0D7,$F0D8,$F0D9,
$F0DA,$F0DB,$F0DC,$F0DD,$F0DE,$F0DF,$F0E0,$F0E1,$F0E2,$F0E3,$F0E4,$F0E5,$F0E6,
$F0E7,$F0E8,$F0E9,$F0EA,$F0EB,$F0EC,$F0ED,$F0EE,$F0EF,$F0F0,$F0F1,$F0F2,$F0F3,
$F0F4,$F0F5,$F0F6,$F0F7,$F0F8,$F0F9,$F0FA,$F0FB,$F0FC,$F0FD,$F0FE,$F1A1,$F1A2,
$F1A3,$F1A4,$F1A5,$F1A6,$F1A7,$F1A8,$F1A9,$F1AA,$F1AB,$F1AC,$F1AD,$F1AE,$F1AF,
$F1B0,$F1B1,$F1B2,$F1B3,$F1B4,$F1B5,$F1B6,$F1B7,$F1B8,$F1B9,$F1BA,$F1BB,$F1BC,
$F1BD,$F1BE,$F1BF,$F1C0,$F1C1,$F1C2,$F1C3,$F1C4,$F1C5,$F1C6,$F1C7,$F1C8,$F1C9,
$F1CA,$F1CB,$F1CC,$F1CD,$F1CE,$F1CF,$F1D0,$F1D1,$F1D2,$F1D3,$F1D4,$F1D5,$F1D6,
$F1D7,$F1D8,$F1D9,$F1DA,$F1DB,$F1DC,$F1DD,$F1DE,$F1DF,$F1E0,$F1E1,$F1E2,$F1E3,
$F1E4,$F1E5,$F1E6,$F1E7,$F1E8,$F1E9,$F1EA,$F1EB,$F1EC,$F1ED,$F1EE,$F1EF,$F1F0,
$F1F1,$F1F2,$F1F3,$F1F4,$F1F5,$F1F6,$F1F7,$F1F8,$F1F9,$F1FA,$F1FB,$F1FC,$F1FD,
$F1FE,$F2A1,$F2A2,$F2A3,$F2A4,$F2A5,$F2A6,$F2A7,$F2A8,$F2A9,$F2AA,$F2AB,$F2AC,
$F2AD,$F2AE,$F2AF,$F2B0,$F2B1,$F2B2,$F2B3,$F2B4,$F2B5,$F2B6,$F2B7,$F2B8,$F2B9,
$F2BA,$F2BB,$F2BC,$F2BD,$F2BE,$F2BF,$F2C0,$F2C1,$F2C2,$F2C3,$F2C4,$F2C5,$F2C6,
$F2C7,$F2C8,$F2C9,$F2CA,$F2CB,$F2CC,$F2CD,$F2CE,$F2CF,$F2D0,$F2D1,$F2D2,$F2D3,
$F2D4,$F2D5,$F2D6,$F2D7,$F2D8,$F2D9,$F2DA,$F2DB,$F2DC,$F2DD,$F2DE,$F2DF,$F2E0,
$F2E1,$F2E2,$F2E3,$F2E4,$F2E5,$F2E6,$F2E7,$F2E8,$F2E9,$F2EA,$F2EB,$F2EC,$F2ED,
$F2EE,$F2EF,$F2F0,$F2F1,$F2F2,$F2F3,$F2F4,$F2F5,$F2F6,$F2F7,$F2F8,$F2F9,$F2FA,
$F2FB,$F2FC,$F2FD,$F2FE,$F3A1,$F3A2,$F3A3,$F3A4,$F3A5,$F3A6,$F3A7,$F3A8,$F3A9,
$F3AA,$F3AB,$F3AC,$F3AD,$F3AE,$F3AF,$F3B0,$F3B1,$F3B2,$F3B3,$F3B4,$F3B5,$F3B6,
$F3B7,$F3B8,$F3B9,$F3BA,$F3BB,$F3BC,$F3BD,$F3BE,$F3BF,$F3C0,$F3C1,$F3C2,$F3C3,
$F3C4,$F3C5,$F3C6,$F3C7,$F3C8,$F3C9,$F3CA,$F3CB,$F3CC,$F3CD,$F3CE,$F3CF,$F3D0,
$F3D1,$F3D2,$F3D3,$F3D4,$F3D5,$F3D6,$F3D7,$F3D8,$F3D9,$F3DA,$F3DB,$F3DC,$F3DD,
$F3DE,$F3DF,$F3E0,$F3E1,$F3E2,$F3E3,$F3E4,$F3E5,$F3E6,$F3E7,$F3E8,$F3E9,$F3EA,
$F3EB,$F3EC,$F3ED,$F3EE,$F3EF,$F3F0,$F3F1,$F3F2,$F3F3,$F3F4,$F3F5,$F3F6,$F3F7,
$F3F8,$F3F9,$F3FA,$F3FB,$F3FC,$F3FD,$F3FE,$F4A1,$F4A2,$F4A3,$F4A4,$F4A5,$F4A6,
$F4A7,$F4A8,$F4A9,$F4AA,$F4AB,$F4AC,$F4AD,$F4AE,$F4AF,$F4B0,$F4B1,$F4B2,$F4B3,
$F4B4,$F4B5,$F4B6,$F4B7,$F4B8,$F4B9,$F4BA,$F4BB,$F4BC,$F4BD,$F4BE,$F4BF,$F4C0,
$F4C1,$F4C2,$F4C3,$F4C4,$F4C5,$F4C6,$F4C7,$F4C8,$F4C9,$F4CA,$F4CB,$F4CC,$F4CD,
$F4CE,$F4CF,$F4D0,$F4D1,$F4D2,$F4D3,$F4D4,$F4D5,$F4D6,$F4D7,$F4D8,$F4D9,$F4DA,
$F4DB,$F4DC,$F4DD,$F4DE,$F4DF,$F4E0,$F4E1,$F4E2,$F4E3,$F4E4,$F4E5,$F4E6,$F4E7,
$F4E8,$F4E9,$F4EA,$F4EB,$F4EC,$F4ED,$F4EE,$F4EF,$F4F0,$F4F1,$F4F2,$F4F3,$F4F4,
$F4F5,$F4F6,$F4F7,$F4F8,$F4F9,$F4FA,$F4FB,$F4FC,$F4FD,$F4FE,$F5A1,$F5A2,$F5A3,
$F5A4,$F5A5,$F5A6,$F5A7,$F5A8,$F5A9,$F5AA,$F5AB,$F5AC,$F5AD,$F5AE,$F5AF,$F5B0,
$F5B1,$F5B2,$F5B3,$F5B4,$F5B5,$F5B6,$F5B7,$F5B8,$F5B9,$F5BA,$F5BB,$F5BC,$F5BD,
$F5BE,$F5BF,$F5C0,$F5C1,$F5C2,$F5C3,$F5C4,$F5C5,$F5C6,$F5C7,$F5C8,$F5C9,$F5CA,
$F5CB,$F5CC,$F5CD,$F5CE,$F5CF,$F5D0,$F5D1,$F5D2,$F5D3,$F5D4,$F5D5,$F5D6,$F5D7,
$F5D8,$F5D9,$F5DA,$F5DB,$F5DC,$F5DD,$F5DE,$F5DF,$F5E0,$F5E1,$F5E2,$F5E3,$F5E4,
$F5E5,$F5E6,$F5E7,$F5E8,$F5E9,$F5EA,$F5EB,$F5EC,$F5ED,$F5EE,$F5EF,$F5F0,$F5F1,
$F5F2,$F5F3,$F5F4,$F5F5,$F5F6,$F5F7,$F5F8,$F5F9,$F5FA,$F5FB,$F5FC,$F5FD,$F5FE,
$F6A1,$F6A2,$F6A3,$F6A4,$F6A5,$F6A6,$F6A7,$F6A8,$F6A9,$F6AA,$F6AB,$F6AC,$F6AD,
$F6AE,$F6AF,$F6B0,$F6B1,$F6B2,$F6B3,$F6B4,$F6B5,$F6B6,$F6B7,$F6B8,$F6B9,$F6BA,
$F6BB,$F6BC,$F6BD,$F6BE,$F6BF,$F6C0,$F6C1,$F6C2,$F6C3,$F6C4,$F6C5,$F6C6,$F6C7,
$F6C8,$F6C9,$F6CA,$F6CB,$F6CC,$F6CD,$F6CE,$F6CF,$F6D0,$F6D1,$F6D2,$F6D3,$F6D4,
$F6D5,$F6D6,$F6D7,$F6D8,$F6D9,$F6DA,$F6DB,$F6DC,$F6DD,$F6DE,$F6DF,$F6E0,$F6E1,
$F6E2,$F6E3,$F6E4,$F6E5,$F6E6,$F6E7,$F6E8,$F6E9,$F6EA,$F6EB,$F6EC,$F6ED,$F6EE,
$F6EF,$F6F0,$F6F1,$F6F2,$F6F3,$F6F4,$F6F5,$F6F6,$F6F7,$F6F8,$F6F9,$F6FA,$F6FB,
$F6FC,$F6FD,$F6FE,$F7A1,$F7A2,$F7A3,$F7A4,$F7A5,$F7A6,$F7A7,$F7A8,$F7A9,$F7AA,
$F7AB,$F7AC,$F7AD,$F7AE,$F7AF,$F7B0,$F7B1,$F7B2,$F7B3,$F7B4,$F7B5,$F7B6,$F7B7,
$F7B8,$F7B9,$F7BA,$F7BB,$F7BC,$F7BD,$F7BE,$F7BF,$F7C0,$F7C1,$F7C2,$F7C3,$F7C4,
$F7C5,$F7C6,$F7C7,$F7C8,$F7C9,$F7CA,$F7CB,$F7CC,$F7CD,$F7CE,$F7CF,$F7D0,$F7D1,
$F7D2,$F7D3,$F7D4,$F7D5,$F7D6,$F7D7,$F7D8,$F7D9,$F7DA,$F7DB,$F7DC,$F7DD,$F7DE,
$F7DF,$F7E0,$F7E1,$F7E2,$F7E3,$F7E4,$F7E5,$F7E6,$F7E7,$F7E8,$F7E9,$F7EA,$F7EB,
$F7EC,$F7ED,$F7EE,$F7EF,$F7F0,$F7F1,$F7F2,$F7F3,$F7F4,$F7F5,$F7F6,$F7F7,$F7F8,
$F7F9,$F7FA,$F7FB,$F7FC,$F7FD,$F7FE,$F8A1,$F8A2,$F8A3,$F8A4,$F8A5,$F8A6,$F8A7,
$F8A8,$F8A9,$F8AA,$F8AB,$F8AC,$F8AD,$F8AE,$F8AF,$F8B0,$F8B1,$F8B2,$F8B3,$F8B4,
$F8B5,$F8B6,$F8B7,$F8B8,$F8B9,$F8BA,$F8BB,$F8BC,$F8BD,$F8BE,$F8BF,$F8C0,$F8C1,
$F8C2,$F8C3,$F8C4,$F8C5,$F8C6,$F8C7,$F8C8,$F8C9,$F8CA,$F8CB,$F8CC,$F8CD,$F8CE,
$F8CF,$F8D0,$F8D1,$F8D2,$F8D3,$F8D4,$F8D5,$F8D6,$F8D7,$F8D8,$F8D9,$F8DA,$F8DB,
$F8DC,$F8DD,$F8DE,$F8DF,$F8E0,$F8E1,$F8E2,$F8E3,$F8E4,$F8E5,$F8E6,$F8E7,$F8E8,
$F8E9,$F8EA,$F8EB,$F8EC,$F8ED,$F8EE,$F8EF,$F8F0,$F8F1,$F8F2,$F8F3,$F8F4,$F8F5,
$F8F6,$F8F7,$F8F8,$F8F9,$F8FA,$F8FB,$F8FC,$F8FD,$F8FE,$F9A1,$F9A2,$F9A3,$F9A4,
$F9A5,$F9A6,$F9A7,$F9A8,$F9A9,$F9AA,$F9AB,$F9AC,$F9AD,$F9AE,$F9AF,$F9B0,$F9B1,
$F9B2,$F9B3,$F9B4,$F9B5,$F9B6,$F9B7,$F9B8,$F9B9,$F9BA,$F9BB,$F9BC,$F9BD,$F9BE,
$F9BF,$F9C0,$F9C1,$F9C2,$F9C3,$F9C4,$F9C5,$F9C6,$F9C7,$F9C8,$F9C9,$F9CA,$F9CB,
$F9CC,$F9CD,$F9CE,$F9CF,$F9D0,$F9D1,$F9D2,$F9D3,$F9D4,$F9D5,$F9D6,$F9D7,$F9D8,
$F9D9,$F9DA,$F9DB,$F9DC,$F9DD,$F9DE,$F9DF,$F9E0,$F9E1,$F9E2,$F9E3,$F9E4,$F9E5,
$F9E6,$F9E7,$F9E8,$F9E9,$F9EA,$F9EB,$F9EC,$F9ED,$F9EE,$F9EF,$F9F0,$F9F1,$F9F2,
$F9F3,$F9F4,$F9F5,$F9F6,$F9F7,$F9F8,$F9F9,$F9FA,$F9FB,$F9FC,$F9FD,$F9FE,$FAA1,
$FAA2,$FAA3,$FAA4,$FAA5,$FAA6,$FAA7,$FAA8,$FAA9,$FAAA,$FAAB,$FAAC,$FAAD,$FAAE,
$FAAF,$FAB0,$FAB1,$FAB2,$FAB3,$FAB4,$FAB5,$FAB6,$FAB7,$FAB8,$FAB9,$FABA,$FABB,
$FABC,$FABD,$FABE,$FABF,$FAC0,$FAC1,$FAC2,$FAC3,$FAC4,$FAC5,$FAC6,$FAC7,$FAC8,
$FAC9,$FACA,$FACB,$FACC,$FACD,$FACE,$FACF,$FAD0,$FAD1,$FAD2,$FAD3,$FAD4,$FAD5,
$FAD6,$FAD7,$FAD8,$FAD9,$FADA,$FADB,$FADC,$FADD,$FADE,$FADF,$FAE0,$FAE1,$FAE2,
$FAE3,$FAE4,$FAE5,$FAE6,$FAE7,$FAE8,$FAE9,$FAEA,$FAEB,$FAEC,$FAED,$FAEE,$FAEF,
$FAF0,$FAF1,$FAF2,$FAF3,$FAF4,$FAF5,$FAF6,$FAF7,$FAF8,$FAF9,$FAFA,$FAFB,$FAFC,
$FAFD,$FAFE,$FBA1,$FBA2,$FBA3,$FBA4,$FBA5,$FBA6,$FBA7,$FBA8,$FBA9,$FBAA,$FBAB,
$FBAC,$FBAD,$FBAE,$FBAF,$FBB0,$FBB1,$FBB2,$FBB3,$FBB4,$FBB5,$FBB6,$FBB7,$FBB8,
$FBB9,$FBBA,$FBBB,$FBBC,$FBBD,$FBBE,$FBBF,$FBC0,$FBC1,$FBC2,$FBC3,$FBC4,$FBC5,
$FBC6,$FBC7,$FBC8,$FBC9,$FBCA,$FBCB,$FBCC,$FBCD,$FBCE,$FBCF,$FBD0,$FBD1,$FBD2,
$FBD3,$FBD4,$FBD5,$FBD6,$FBD7,$FBD8,$FBD9,$FBDA,$FBDB,$FBDC,$FBDD,$FBDE,$FBDF,
$FBE0,$FBE1,$FBE2,$FBE3,$FBE4,$FBE5,$FBE6,$FBE7,$FBE8,$FBE9,$FBEA,$FBEB,$FBEC,
$FBED,$FBEE,$FBEF,$FBF0,$FBF1,$FBF2,$FBF3,$FBF4,$FBF5,$FBF6,$FBF7,$FBF8,$FBF9,
$FBFA,$FBFB,$FBFC,$FBFD,$FBFE,$FCA1,$FCA2,$FCA3,$FCA4,$FCA5,$FCA6,$FCA7,$FCA8,
$FCA9,$FCAA,$FCAB,$FCAC,$FCAD,$FCAE,$FCAF,$FCB0,$FCB1,$FCB2,$FCB3,$FCB4,$FCB5,
$FCB6,$FCB7,$FCB8,$FCB9,$FCBA,$FCBB,$FCBC,$FCBD,$FCBE,$FCBF,$FCC0,$FCC1,$FCC2,
$FCC3,$FCC4,$FCC5,$FCC6,$FCC7,$FCC8,$FCC9,$FCCA,$FCCB,$FCCC,$FCCD,$FCCE,$FCCF,
$FCD0,$FCD1,$FCD2,$FCD3,$FCD4,$FCD5,$FCD6,$FCD7,$FCD8,$FCD9,$FCDA,$FCDB,$FCDC,
$FCDD,$FCDE,$FCDF,$FCE0,$FCE1,$FCE2,$FCE3,$FCE4,$FCE5,$FCE6,$FCE7,$FCE8,$FCE9,
$FCEA,$FCEB,$FCEC,$FCED,$FCEE,$FCEF,$FCF0,$FCF1,$FCF2,$FCF3,$FCF4,$FCF5,$FCF6,
$FCF7,$FCF8,$FCF9,$FCFA,$FCFB,$FCFC,$FCFD,$FCFE,$FDA1,$FDA2,$FDA3,$FDA4,$FDA5,
$FDA6,$FDA7,$FDA8,$FDA9,$FDAA,$FDAB,$FDAC,$FDAD,$FDAE,$FDAF,$FDB0,$FDB1,$FDB2,
$FDB3,$FDB4,$FDB5,$FDB6,$FDB7,$FDB8,$FDB9,$FDBA,$FDBB,$FDBC,$FDBD,$FDBE,$FDBF,
$FDC0,$FDC1,$FDC2,$FDC3,$FDC4,$FDC5,$FDC6,$FDC7,$FDC8,$FDC9,$FDCA,$FDCB,$FDCC,
$FDCD,$FDCE,$FDCF,$FDD0,$FDD1,$FDD2,$FDD3,$FDD4,$FDD5,$FDD6,$FDD7,$FDD8,$FDD9,
$FDDA,$FDDB,$FDDC,$FDDD,$FDDE,$FDDF,$FDE0,$FDE1,$FDE2,$FDE3,$FDE4,$FDE5,$FDE6,
$FDE7,$FDE8,$FDE9,$FDEA,$FDEB,$FDEC,$FDED,$FDEE,$FDEF,$FDF0,$FDF1,$FDF2,$FDF3,
$FDF4,$FDF5,$FDF6,$FDF7,$FDF8,$FDF9,$FDFA,$FDFB,$FDFC,$FDFD,$FDFE);

const Uni949C: CP949Arr =
($0000,$0001,$0002,$0003,$0004,$0005,$0006,$0007,$0008,$0009,$000A,$000B,$000C,
$000D,$000E,$000F,$0010,$0011,$0012,$0013,$0014,$0015,$0016,$0017,$0018,$0019,
$001A,$001B,$001C,$001D,$001E,$001F,$0020,$0021,$0022,$0023,$0024,$0025,$0026,
$0027,$0028,$0029,$002A,$002B,$002C,$002D,$002E,$002F,$0030,$0031,$0032,$0033,
$0034,$0035,$0036,$0037,$0038,$0039,$003A,$003B,$003C,$003D,$003E,$003F,$0040,
$0041,$0042,$0043,$0044,$0045,$0046,$0047,$0048,$0049,$004A,$004B,$004C,$004D,
$004E,$004F,$0050,$0051,$0052,$0053,$0054,$0055,$0056,$0057,$0058,$0059,$005A,
$005B,$005C,$005D,$005E,$005F,$0060,$0061,$0062,$0063,$0064,$0065,$0066,$0067,
$0068,$0069,$006A,$006B,$006C,$006D,$006E,$006F,$0070,$0071,$0072,$0073,$0074,
$0075,$0076,$0077,$0078,$0079,$007A,$007B,$007C,$007D,$007E,$007F,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
$AC02,$AC03,$AC05,$AC06,$AC0B,$AC0C,$AC0D,$AC0E,$AC0F,$AC18,$AC1E,$AC1F,$AC21,
$AC22,$AC23,$AC25,$AC26,$AC27,$AC28,$AC29,$AC2A,$AC2B,$AC2E,$AC32,$AC33,$AC34,
$AC35,$AC36,$AC37,$AC3A,$AC3B,$AC3D,$AC3E,$AC3F,$AC41,$AC42,$AC43,$AC44,$AC45,
$AC46,$AC47,$AC48,$AC49,$AC4A,$AC4C,$AC4E,$AC4F,$AC50,$AC51,$AC52,$AC53,$AC55,
$AC56,$AC57,$AC59,$AC5A,$AC5B,$AC5D,$AC5E,$AC5F,$AC60,$AC61,$AC62,$AC63,$AC64,
$AC65,$AC66,$AC67,$AC68,$AC69,$AC6A,$AC6B,$AC6C,$AC6D,$AC6E,$AC6F,$AC72,$AC73,
$AC75,$AC76,$AC79,$AC7B,$AC7C,$AC7D,$AC7E,$AC7F,$AC82,$AC87,$AC88,$AC8D,$AC8E,
$AC8F,$AC91,$AC92,$AC93,$AC95,$AC96,$AC97,$AC98,$AC99,$AC9A,$AC9B,$AC9E,$ACA2,
$ACA3,$ACA4,$ACA5,$ACA6,$ACA7,$ACAB,$ACAD,$ACAE,$ACB1,$ACB2,$ACB3,$ACB4,$ACB5,
$ACB6,$ACB7,$ACBA,$ACBE,$ACBF,$ACC0,$ACC2,$ACC3,$ACC5,$ACC6,$ACC7,$ACC9,$ACCA,
$ACCB,$ACCD,$ACCE,$ACCF,$ACD0,$ACD1,$ACD2,$ACD3,$ACD4,$ACD6,$ACD8,$ACD9,$ACDA,
$ACDB,$ACDC,$ACDD,$ACDE,$ACDF,$ACE2,$ACE3,$ACE5,$ACE6,$ACE9,$ACEB,$ACED,$ACEE,
$ACF2,$ACF4,$ACF7,$ACF8,$ACF9,$ACFA,$ACFB,$ACFE,$ACFF,$AD01,$AD02,$AD03,$AD05,
$AD07,$AD08,$AD09,$AD0A,$AD0B,$AD0E,$AD10,$AD12,$AD13,$AD14,$AD15,$AD16,$AD17,
$AD19,$AD1A,$AD1B,$AD1D,$AD1E,$AD1F,$AD21,$AD22,$AD23,$AD24,$AD25,$AD26,$AD27,
$AD28,$AD2A,$AD2B,$AD2E,$AD2F,$AD30,$AD31,$AD32,$AD33,$AD36,$AD37,$AD39,$AD3A,
$AD3B,$AD3D,$AD3E,$AD3F,$AD40,$AD41,$AD42,$AD43,$AD46,$AD48,$AD4A,$AD4B,$AD4C,
$AD4D,$AD4E,$AD4F,$AD51,$AD52,$AD53,$AD55,$AD56,$AD57,$AD59,$AD5A,$AD5B,$AD5C,
$AD5D,$AD5E,$AD5F,$AD60,$AD62,$AD64,$AD65,$AD66,$AD67,$AD68,$AD69,$AD6A,$AD6B,
$AD6E,$AD6F,$AD71,$AD72,$AD77,$AD78,$AD79,$AD7A,$AD7E,$AD80,$AD83,$AD84,$AD85,
$AD86,$AD87,$AD8A,$AD8B,$AD8D,$AD8E,$AD8F,$AD91,$AD92,$AD93,$AD94,$AD95,$AD96,
$AD97,$AD98,$AD99,$AD9A,$AD9B,$AD9E,$AD9F,$ADA0,$ADA1,$ADA2,$ADA3,$ADA5,$ADA6,
$ADA7,$ADA8,$ADA9,$ADAA,$ADAB,$ADAC,$ADAD,$ADAE,$ADAF,$ADB0,$ADB1,$ADB2,$ADB3,
$ADB4,$ADB5,$ADB6,$ADB8,$ADB9,$ADBA,$ADBB,$ADBC,$ADBD,$ADBE,$ADBF,$ADC2,$ADC3,
$ADC5,$ADC6,$ADC7,$ADC9,$ADCA,$ADCB,$ADCC,$ADCD,$ADCE,$ADCF,$ADD2,$ADD4,$ADD5,
$ADD6,$ADD7,$ADD8,$ADD9,$ADDA,$ADDB,$ADDD,$ADDE,$ADDF,$ADE1,$ADE2,$ADE3,$ADE5,
$ADE6,$ADE7,$ADE8,$ADE9,$ADEA,$ADEB,$ADEC,$ADED,$ADEE,$ADEF,$ADF0,$ADF1,$ADF2,
$ADF3,$ADF4,$ADF5,$ADF6,$ADF7,$ADFA,$ADFB,$ADFD,$ADFE,$AE02,$AE03,$AE04,$AE05,
$AE06,$AE07,$AE0A,$AE0C,$AE0E,$AE0F,$AE10,$AE11,$AE12,$AE13,$AE15,$AE16,$AE17,
$AE18,$AE19,$AE1A,$AE1B,$AE1C,$AE1D,$AE1E,$AE1F,$AE20,$AE21,$AE22,$AE23,$AE24,
$AE25,$AE26,$AE27,$AE28,$AE29,$AE2A,$AE2B,$AE2C,$AE2D,$AE2E,$AE2F,$AE32,$AE33,
$AE35,$AE36,$AE39,$AE3B,$AE3C,$AE3D,$AE3E,$AE3F,$AE42,$AE44,$AE47,$AE48,$AE49,
$AE4B,$AE4F,$AE51,$AE52,$AE53,$AE55,$AE57,$AE58,$AE59,$AE5A,$AE5B,$AE5E,$AE62,
$AE63,$AE64,$AE66,$AE67,$AE6A,$AE6B,$AE6D,$AE6E,$AE6F,$AE71,$AE72,$AE73,$AE74,
$AE75,$AE76,$AE77,$AE7A,$AE7E,$AE7F,$AE80,$AE81,$AE82,$AE83,$AE86,$AE87,$AE88,
$AE89,$AE8A,$AE8B,$AE8D,$AE8E,$AE8F,$AE90,$AE91,$AE92,$AE93,$AE94,$AE95,$AE96,
$AE97,$AE98,$AE99,$AE9A,$AE9B,$AE9C,$AE9D,$AE9E,$AE9F,$AEA0,$AEA1,$AEA2,$AEA3,
$AEA4,$AEA5,$AEA6,$AEA7,$AEA8,$AEA9,$AEAA,$AEAB,$AEAC,$AEAD,$AEAE,$AEAF,$AEB0,
$AEB1,$AEB2,$AEB3,$AEB4,$AEB5,$AEB6,$AEB7,$AEB8,$AEB9,$AEBA,$AEBB,$AEBF,$AEC1,
$AEC2,$AEC3,$AEC5,$AEC6,$AEC7,$AEC8,$AEC9,$AECA,$AECB,$AECE,$AED2,$AED3,$AED4,
$AED5,$AED6,$AED7,$AEDA,$AEDB,$AEDD,$AEDE,$AEDF,$AEE0,$AEE1,$AEE2,$AEE3,$AEE4,
$AEE5,$AEE6,$AEE7,$AEE9,$AEEA,$AEEC,$AEEE,$AEEF,$AEF0,$AEF1,$AEF2,$AEF3,$AEF5,
$AEF6,$AEF7,$AEF9,$AEFA,$AEFB,$AEFD,$AEFE,$AEFF,$AF00,$AF01,$AF02,$AF03,$AF04,
$AF05,$AF06,$AF09,$AF0A,$AF0B,$AF0C,$AF0E,$AF0F,$AF11,$AF12,$AF13,$AF14,$AF15,
$AF16,$AF17,$AF18,$AF19,$AF1A,$AF1B,$AF1C,$AF1D,$AF1E,$AF1F,$AF20,$AF21,$AF22,
$AF23,$AF24,$AF25,$AF26,$AF27,$AF28,$AF29,$AF2A,$AF2B,$AF2E,$AF2F,$AF31,$AF33,
$AF35,$AF36,$AF37,$AF38,$AF39,$AF3A,$AF3B,$AF3E,$AF40,$AF44,$AF45,$AF46,$AF47,
$AF4A,$AF4B,$AF4C,$AF4D,$AF4E,$AF4F,$AF51,$AF52,$AF53,$AF54,$AF55,$AF56,$AF57,
$AF58,$AF59,$AF5A,$AF5B,$AF5E,$AF5F,$AF60,$AF61,$AF62,$AF63,$AF66,$AF67,$AF68,
$AF69,$AF6A,$AF6B,$AF6C,$AF6D,$AF6E,$AF6F,$AF70,$AF71,$AF72,$AF73,$AF74,$AF75,
$AF76,$AF77,$AF78,$AF7A,$AF7B,$AF7C,$AF7D,$AF7E,$AF7F,$AF81,$AF82,$AF83,$AF85,
$AF86,$AF87,$AF89,$AF8A,$AF8B,$AF8C,$AF8D,$AF8E,$AF8F,$AF92,$AF93,$AF94,$AF96,
$AF97,$AF98,$AF99,$AF9A,$AF9B,$AF9D,$AF9E,$AF9F,$AFA0,$AFA1,$AFA2,$AFA3,$AFA4,
$AFA5,$AFA6,$AFA7,$AFA8,$AFA9,$AFAA,$AFAB,$AFAC,$AFAD,$AFAE,$AFAF,$AFB0,$AFB1,
$AFB2,$AFB3,$AFB4,$AFB5,$AFB6,$AFB7,$AFBA,$AFBB,$AFBD,$AFBE,$AFBF,$AFC1,$AFC2,
$AFC3,$AFC4,$AFC5,$AFC6,$AFCA,$AFCC,$AFCF,$AFD0,$AFD1,$AFD2,$AFD3,$AFD5,$AFD6,
$AFD7,$AFD8,$AFD9,$AFDA,$AFDB,$AFDD,$AFDE,$AFDF,$AFE0,$AFE1,$AFE2,$AFE3,$AFE4,
$AFE5,$AFE6,$AFE7,$AFEA,$AFEB,$AFEC,$AFED,$AFEE,$AFEF,$AFF2,$AFF3,$AFF5,$AFF6,
$AFF7,$AFF9,$AFFA,$AFFB,$AFFC,$AFFD,$AFFE,$AFFF,$B002,$B003,$B005,$B006,$B007,
$B008,$B009,$B00A,$B00B,$B00D,$B00E,$B00F,$B011,$B012,$B013,$B015,$B016,$B017,
$B018,$B019,$B01A,$B01B,$B01E,$B01F,$B020,$B021,$B022,$B023,$B024,$B025,$B026,
$B027,$B029,$B02A,$B02B,$B02C,$B02D,$B02E,$B02F,$B030,$B031,$B032,$B033,$B034,
$B035,$B036,$B037,$B038,$B039,$B03A,$B03B,$B03C,$B03D,$B03E,$B03F,$B040,$B041,
$B042,$B043,$B046,$B047,$B049,$B04B,$B04D,$B04F,$B050,$B051,$B052,$B056,$B058,
$B05A,$B05B,$B05C,$B05E,$B05F,$B060,$B061,$B062,$B063,$B064,$B065,$B066,$B067,
$B068,$B069,$B06A,$B06B,$B06C,$B06D,$B06E,$B06F,$B070,$B071,$B072,$B073,$B074,
$B075,$B076,$B077,$B078,$B079,$B07A,$B07B,$B07E,$B07F,$B081,$B082,$B083,$B085,
$B086,$B087,$B088,$B089,$B08A,$B08B,$B08E,$B090,$B092,$B093,$B094,$B095,$B096,
$B097,$B09B,$B09D,$B09E,$B0A3,$B0A4,$B0A5,$B0A6,$B0A7,$B0AA,$B0B0,$B0B2,$B0B6,
$B0B7,$B0B9,$B0BA,$B0BB,$B0BD,$B0BE,$B0BF,$B0C0,$B0C1,$B0C2,$B0C3,$B0C6,$B0CA,
$B0CB,$B0CC,$B0CD,$B0CE,$B0CF,$B0D2,$B0D3,$B0D5,$B0D6,$B0D7,$B0D9,$B0DA,$B0DB,
$B0DC,$B0DD,$B0DE,$B0DF,$B0E1,$B0E2,$B0E3,$B0E4,$B0E6,$B0E7,$B0E8,$B0E9,$B0EA,
$B0EB,$B0EC,$B0ED,$B0EE,$B0EF,$B0F0,$B0F1,$B0F2,$B0F3,$B0F4,$B0F5,$B0F6,$B0F7,
$B0F8,$B0F9,$B0FA,$B0FB,$B0FC,$B0FD,$B0FE,$B0FF,$B100,$B101,$B102,$B103,$B104,
$B105,$B106,$B107,$B10A,$B10D,$B10E,$B10F,$B111,$B114,$B115,$B116,$B117,$B11A,
$B11E,$B11F,$B120,$B121,$B122,$B126,$B127,$B129,$B12A,$B12B,$B12D,$B12E,$B12F,
$B130,$B131,$B132,$B133,$B136,$B13A,$B13B,$B13C,$B13D,$B13E,$B13F,$B142,$B143,
$B145,$B146,$B147,$B149,$B14A,$B14B,$B14C,$B14D,$B14E,$B14F,$B152,$B153,$B156,
$B157,$B159,$B15A,$B15B,$B15D,$B15E,$B15F,$B161,$B162,$B163,$B164,$B165,$B166,
$B167,$B168,$B169,$B16A,$B16B,$B16C,$B16D,$B16E,$B16F,$B170,$B171,$B172,$B173,
$B174,$B175,$B176,$B177,$B17A,$B17B,$B17D,$B17E,$B17F,$B181,$B183,$B184,$B185,
$B186,$B187,$B18A,$B18C,$B18E,$B18F,$B190,$B191,$B195,$B196,$B197,$B199,$B19A,
$B19B,$B19D,$B19E,$B19F,$B1A0,$B1A1,$B1A2,$B1A3,$B1A4,$B1A5,$B1A6,$B1A7,$B1A9,
$B1AA,$B1AB,$B1AC,$B1AD,$B1AE,$B1AF,$B1B0,$B1B1,$B1B2,$B1B3,$B1B4,$B1B5,$B1B6,
$B1B7,$B1B8,$B1B9,$B1BA,$B1BB,$B1BC,$B1BD,$B1BE,$B1BF,$B1C0,$B1C1,$B1C2,$B1C3,
$B1C4,$B1C5,$B1C6,$B1C7,$B1C8,$B1C9,$B1CA,$B1CB,$B1CD,$B1CE,$B1CF,$B1D1,$B1D2,
$B1D3,$B1D5,$B1D6,$B1D7,$B1D8,$B1D9,$B1DA,$B1DB,$B1DE,$B1E0,$B1E1,$B1E2,$B1E3,
$B1E4,$B1E5,$B1E6,$B1E7,$B1EA,$B1EB,$B1ED,$B1EE,$B1EF,$B1F1,$B1F2,$B1F3,$B1F4,
$B1F5,$B1F6,$B1F7,$B1F8,$B1FA,$B1FC,$B1FE,$B1FF,$B200,$B201,$B202,$B203,$B206,
$B207,$B209,$B20A,$B20D,$B20E,$B20F,$B210,$B211,$B212,$B213,$B216,$B218,$B21A,
$B21B,$B21C,$B21D,$B21E,$B21F,$B221,$B222,$B223,$B224,$B225,$B226,$B227,$B228,
$B229,$B22A,$B22B,$B22C,$B22D,$B22E,$B22F,$B230,$B231,$B232,$B233,$B235,$B236,
$B237,$B238,$B239,$B23A,$B23B,$B23D,$B23E,$B23F,$B240,$B241,$B242,$B243,$B244,
$B245,$B246,$B247,$B248,$B249,$B24A,$B24B,$B24C,$B24D,$B24E,$B24F,$B250,$B251,
$B252,$B253,$B254,$B255,$B256,$B257,$B259,$B25A,$B25B,$B25D,$B25E,$B25F,$B261,
$B262,$B263,$B264,$B265,$B266,$B267,$B26A,$B26B,$B26C,$B26D,$B26E,$B26F,$B270,
$B271,$B272,$B273,$B276,$B277,$B278,$B279,$B27A,$B27B,$B27D,$B27E,$B27F,$B280,
$B281,$B282,$B283,$B286,$B287,$B288,$B28A,$B28B,$B28C,$B28D,$B28E,$B28F,$B292,
$B293,$B295,$B296,$B297,$B29B,$B29C,$B29D,$B29E,$B29F,$B2A2,$B2A4,$B2A7,$B2A8,
$B2A9,$B2AB,$B2AD,$B2AE,$B2AF,$B2B1,$B2B2,$B2B3,$B2B5,$B2B6,$B2B7,$B2B8,$B2B9,
$B2BA,$B2BB,$B2BC,$B2BD,$B2BE,$B2BF,$B2C0,$B2C1,$B2C2,$B2C3,$B2C4,$B2C5,$B2C6,
$B2C7,$B2CA,$B2CB,$B2CD,$B2CE,$B2CF,$B2D1,$B2D3,$B2D4,$B2D5,$B2D6,$B2D7,$B2DA,
$B2DC,$B2DE,$B2DF,$B2E0,$B2E1,$B2E3,$B2E7,$B2E9,$B2EA,$B2F0,$B2F1,$B2F2,$B2F6,
$B2FC,$B2FD,$B2FE,$B302,$B303,$B305,$B306,$B307,$B309,$B30A,$B30B,$B30C,$B30D,
$B30E,$B30F,$B312,$B316,$B317,$B318,$B319,$B31A,$B31B,$B31D,$B31E,$B31F,$B320,
$B321,$B322,$B323,$B324,$B325,$B326,$B327,$B328,$B329,$B32A,$B32B,$B32C,$B32D,
$B32E,$B32F,$B330,$B331,$B332,$B333,$B334,$B335,$B336,$B337,$B338,$B339,$B33A,
$B33B,$B33C,$B33D,$B33E,$B33F,$B340,$B341,$B342,$B343,$B344,$B345,$B346,$B347,
$B348,$B349,$B34A,$B34B,$B34C,$B34D,$B34E,$B34F,$B350,$B351,$B352,$B353,$B357,
$B359,$B35A,$B35D,$B360,$B361,$B362,$B363,$B366,$B368,$B36A,$B36C,$B36D,$B36F,
$B372,$B373,$B375,$B376,$B377,$B379,$B37A,$B37B,$B37C,$B37D,$B37E,$B37F,$B382,
$B386,$B387,$B388,$B389,$B38A,$B38B,$B38D,$B38E,$B38F,$B391,$B392,$B393,$B395,
$B396,$B397,$B398,$B399,$B39A,$B39B,$B39C,$B39D,$B39E,$B39F,$B3A2,$B3A3,$B3A4,
$B3A5,$B3A6,$B3A7,$B3A9,$B3AA,$B3AB,$B3AD,$B3AE,$B3AF,$B3B0,$B3B1,$B3B2,$B3B3,
$B3B4,$B3B5,$B3B6,$B3B7,$B3B8,$B3B9,$B3BA,$B3BB,$B3BC,$B3BD,$B3BE,$B3BF,$B3C0,
$B3C1,$B3C2,$B3C3,$B3C6,$B3C7,$B3C9,$B3CA,$B3CD,$B3CF,$B3D1,$B3D2,$B3D3,$B3D6,
$B3D8,$B3DA,$B3DC,$B3DE,$B3DF,$B3E1,$B3E2,$B3E3,$B3E5,$B3E6,$B3E7,$B3E9,$B3EA,
$B3EB,$B3EC,$B3ED,$B3EE,$B3EF,$B3F0,$B3F1,$B3F2,$B3F3,$B3F4,$B3F5,$B3F6,$B3F7,
$B3F8,$B3F9,$B3FA,$B3FB,$B3FD,$B3FE,$B3FF,$B400,$B401,$B402,$B403,$B404,$B405,
$B406,$B407,$B408,$B409,$B40A,$B40B,$B40C,$B40D,$B40E,$B40F,$B411,$B412,$B413,
$B414,$B415,$B416,$B417,$B419,$B41A,$B41B,$B41D,$B41E,$B41F,$B421,$B422,$B423,
$B424,$B425,$B426,$B427,$B42A,$B42C,$B42D,$B42E,$B42F,$B430,$B431,$B432,$B433,
$B435,$B436,$B437,$B438,$B439,$B43A,$B43B,$B43C,$B43D,$B43E,$B43F,$B440,$B441,
$B442,$B443,$B444,$B445,$B446,$B447,$B448,$B449,$B44A,$B44B,$B44C,$B44D,$B44E,
$B44F,$B452,$B453,$B455,$B456,$B457,$B459,$B45A,$B45B,$B45C,$B45D,$B45E,$B45F,
$B462,$B464,$B466,$B467,$B468,$B469,$B46A,$B46B,$B46D,$B46E,$B46F,$B470,$B471,
$B472,$B473,$B474,$B475,$B476,$B477,$B478,$B479,$B47A,$B47B,$B47C,$B47D,$B47E,
$B47F,$B481,$B482,$B483,$B484,$B485,$B486,$B487,$B489,$B48A,$B48B,$B48C,$B48D,
$B48E,$B48F,$B490,$B491,$B492,$B493,$B494,$B495,$B496,$B497,$B498,$B499,$B49A,
$B49B,$B49C,$B49E,$B49F,$B4A0,$B4A1,$B4A2,$B4A3,$B4A5,$B4A6,$B4A7,$B4A9,$B4AA,
$B4AB,$B4AD,$B4AE,$B4AF,$B4B0,$B4B1,$B4B2,$B4B3,$B4B4,$B4B6,$B4B8,$B4BA,$B4BB,
$B4BC,$B4BD,$B4BE,$B4BF,$B4C1,$B4C2,$B4C3,$B4C5,$B4C6,$B4C7,$B4C9,$B4CA,$B4CB,
$B4CC,$B4CD,$B4CE,$B4CF,$B4D1,$B4D2,$B4D3,$B4D4,$B4D6,$B4D7,$B4D8,$B4D9,$B4DA,
$B4DB,$B4DE,$B4DF,$B4E1,$B4E2,$B4E5,$B4E7,$B4E8,$B4E9,$B4EA,$B4EB,$B4EE,$B4F0,
$B4F2,$B4F3,$B4F4,$B4F5,$B4F6,$B4F7,$B4F9,$B4FA,$B4FB,$B4FC,$B4FD,$B4FE,$B4FF,
$B500,$B501,$B502,$B503,$B504,$B505,$B506,$B507,$B508,$B509,$B50A,$B50B,$B50C,
$B50D,$B50E,$B50F,$B510,$B511,$B512,$B513,$B516,$B517,$B519,$B51A,$B51D,$B51E,
$B51F,$B520,$B521,$B522,$B523,$B526,$B52B,$B52C,$B52D,$B52E,$B52F,$B532,$B533,
$B535,$B536,$B537,$B539,$B53A,$B53B,$B53C,$B53D,$B53E,$B53F,$B542,$B546,$B547,
$B548,$B549,$B54A,$B54E,$B54F,$B551,$B552,$B553,$B555,$B556,$B557,$B558,$B559,
$B55A,$B55B,$B55E,$B562,$B563,$B564,$B565,$B566,$B567,$B568,$B569,$B56A,$B56B,
$B56C,$B56D,$B56E,$B56F,$B570,$B571,$B572,$B573,$B574,$B575,$B576,$B577,$B578,
$B579,$B57A,$B57B,$B57C,$B57D,$B57E,$B57F,$B580,$B581,$B582,$B583,$B584,$B585,
$B586,$B587,$B588,$B589,$B58A,$B58B,$B58C,$B58D,$B58E,$B58F,$B590,$B591,$B592,
$B593,$B594,$B595,$B596,$B597,$B598,$B599,$B59A,$B59B,$B59C,$B59D,$B59E,$B59F,
$B5A2,$B5A3,$B5A5,$B5A6,$B5A7,$B5A9,$B5AC,$B5AD,$B5AE,$B5AF,$B5B2,$B5B6,$B5B7,
$B5B8,$B5B9,$B5BA,$B5BE,$B5BF,$B5C1,$B5C2,$B5C3,$B5C5,$B5C6,$B5C7,$B5C8,$B5C9,
$B5CA,$B5CB,$B5CE,$B5D2,$B5D3,$B5D4,$B5D5,$B5D6,$B5D7,$B5D9,$B5DA,$B5DB,$B5DC,
$B5DD,$B5DE,$B5DF,$B5E0,$B5E1,$B5E2,$B5E3,$B5E4,$B5E5,$B5E6,$B5E7,$B5E8,$B5E9,
$B5EA,$B5EB,$B5ED,$B5EE,$B5EF,$B5F0,$B5F1,$B5F2,$B5F3,$B5F4,$B5F5,$B5F6,$B5F7,
$B5F8,$B5F9,$B5FA,$B5FB,$B5FC,$B5FD,$B5FE,$B5FF,$B600,$B601,$B602,$B603,$B604,
$B605,$B606,$B607,$B608,$B609,$B60A,$B60B,$B60C,$B60D,$B60E,$B60F,$B612,$B613,
$B615,$B616,$B617,$B619,$B61A,$B61B,$B61C,$B61D,$B61E,$B61F,$B620,$B621,$B622,
$B623,$B624,$B626,$B627,$B628,$B629,$B62A,$B62B,$B62D,$B62E,$B62F,$B630,$B631,
$B632,$B633,$B635,$B636,$B637,$B638,$B639,$B63A,$B63B,$B63C,$B63D,$B63E,$B63F,
$B640,$B641,$B642,$B643,$B644,$B645,$B646,$B647,$B649,$B64A,$B64B,$B64C,$B64D,
$B64E,$B64F,$B650,$B651,$B652,$B653,$B654,$B655,$B656,$B657,$B658,$B659,$B65A,
$B65B,$B65C,$B65D,$B65E,$B65F,$B660,$B661,$B662,$B663,$B665,$B666,$B667,$B669,
$B66A,$B66B,$B66C,$B66D,$B66E,$B66F,$B670,$B671,$B672,$B673,$B674,$B675,$B676,
$B677,$B678,$B679,$B67A,$B67B,$B67C,$B67D,$B67E,$B67F,$B680,$B681,$B682,$B683,
$B684,$B685,$B686,$B687,$B688,$B689,$B68A,$B68B,$B68C,$B68D,$B68E,$B68F,$B690,
$B691,$B692,$B693,$B694,$B695,$B696,$B697,$B698,$B699,$B69A,$B69B,$B69E,$B69F,
$B6A1,$B6A2,$B6A3,$B6A5,$B6A6,$B6A7,$B6A8,$B6A9,$B6AA,$B6AD,$B6AE,$B6AF,$B6B0,
$B6B2,$B6B3,$B6B4,$B6B5,$B6B6,$B6B7,$B6B8,$B6B9,$B6BA,$B6BB,$B6BC,$B6BD,$B6BE,
$B6BF,$B6C0,$B6C1,$B6C2,$B6C3,$B6C4,$B6C5,$B6C6,$B6C7,$B6C8,$B6C9,$B6CA,$B6CB,
$B6CC,$B6CD,$B6CE,$B6CF,$B6D0,$B6D1,$B6D2,$B6D3,$B6D5,$B6D6,$B6D7,$B6D8,$B6D9,
$B6DA,$B6DB,$B6DC,$B6DD,$B6DE,$B6DF,$B6E0,$B6E1,$B6E2,$B6E3,$B6E4,$B6E5,$B6E6,
$B6E7,$B6E8,$B6E9,$B6EA,$B6EB,$B6EC,$B6ED,$B6EE,$B6EF,$B6F1,$B6F2,$B6F3,$B6F5,
$B6F6,$B6F7,$B6F9,$B6FA,$B6FB,$B6FC,$B6FD,$B6FE,$B6FF,$B702,$B703,$B704,$B706,
$B707,$B708,$B709,$B70A,$B70B,$B70C,$B70D,$B70E,$B70F,$B710,$B711,$B712,$B713,
$B714,$B715,$B716,$B717,$B718,$B719,$B71A,$B71B,$B71C,$B71D,$B71E,$B71F,$B720,
$B721,$B722,$B723,$B724,$B725,$B726,$B727,$B72A,$B72B,$B72D,$B72E,$B731,$B732,
$B733,$B734,$B735,$B736,$B737,$B73A,$B73C,$B73D,$B73E,$B73F,$B740,$B741,$B742,
$B743,$B745,$B746,$B747,$B749,$B74A,$B74B,$B74D,$B74E,$B74F,$B750,$B751,$B752,
$B753,$B756,$B757,$B758,$B759,$B75A,$B75B,$B75C,$B75D,$B75E,$B75F,$B761,$B762,
$B763,$B765,$B766,$B767,$B769,$B76A,$B76B,$B76C,$B76D,$B76E,$B76F,$B772,$B774,
$B776,$B777,$B778,$B779,$B77A,$B77B,$B77E,$B77F,$B781,$B782,$B783,$B785,$B786,
$B787,$B788,$B789,$B78A,$B78B,$B78E,$B793,$B794,$B795,$B79A,$B79B,$B79D,$B79E,
$B79F,$B7A1,$B7A2,$B7A3,$B7A4,$B7A5,$B7A6,$B7A7,$B7AA,$B7AE,$B7AF,$B7B0,$B7B1,
$B7B2,$B7B3,$B7B6,$B7B7,$B7B9,$B7BA,$B7BB,$B7BC,$B7BD,$B7BE,$B7BF,$B7C0,$B7C1,
$B7C2,$B7C3,$B7C4,$B7C5,$B7C6,$B7C8,$B7CA,$B7CB,$B7CC,$B7CD,$B7CE,$B7CF,$B7D0,
$B7D1,$B7D2,$B7D3,$B7D4,$B7D5,$B7D6,$B7D7,$B7D8,$B7D9,$B7DA,$B7DB,$B7DC,$B7DD,
$B7DE,$B7DF,$B7E0,$B7E1,$B7E2,$B7E3,$B7E4,$B7E5,$B7E6,$B7E7,$B7E8,$B7E9,$B7EA,
$B7EB,$B7EE,$B7EF,$B7F1,$B7F2,$B7F3,$B7F5,$B7F6,$B7F7,$B7F8,$B7F9,$B7FA,$B7FB,
$B7FE,$B802,$B803,$B804,$B805,$B806,$B80A,$B80B,$B80D,$B80E,$B80F,$B811,$B812,
$B813,$B814,$B815,$B816,$B817,$B81A,$B81C,$B81E,$B81F,$B820,$B821,$B822,$B823,
$B826,$B827,$B829,$B82A,$B82B,$B82D,$B82E,$B82F,$B830,$B831,$B832,$B833,$B836,
$B83A,$B83B,$B83C,$B83D,$B83E,$B83F,$B841,$B842,$B843,$B845,$B846,$B847,$B848,
$B849,$B84A,$B84B,$B84C,$B84D,$B84E,$B84F,$B850,$B852,$B854,$B855,$B856,$B857,
$B858,$B859,$B85A,$B85B,$B85E,$B85F,$B861,$B862,$B863,$B865,$B866,$B867,$B868,
$B869,$B86A,$B86B,$B86E,$B870,$B872,$B873,$B874,$B875,$B876,$B877,$B879,$B87A,
$B87B,$B87D,$B87E,$B87F,$B880,$B881,$B882,$B883,$B884,$B885,$B886,$B887,$B888,
$B889,$B88A,$B88B,$B88C,$B88E,$B88F,$B890,$B891,$B892,$B893,$B894,$B895,$B896,
$B897,$B898,$B899,$B89A,$B89B,$B89C,$B89D,$B89E,$B89F,$B8A0,$B8A1,$B8A2,$B8A3,
$B8A4,$B8A5,$B8A6,$B8A7,$B8A9,$B8AA,$B8AB,$B8AC,$B8AD,$B8AE,$B8AF,$B8B1,$B8B2,
$B8B3,$B8B5,$B8B6,$B8B7,$B8B9,$B8BA,$B8BB,$B8BC,$B8BD,$B8BE,$B8BF,$B8C2,$B8C4,
$B8C6,$B8C7,$B8C8,$B8C9,$B8CA,$B8CB,$B8CD,$B8CE,$B8CF,$B8D1,$B8D2,$B8D3,$B8D5,
$B8D6,$B8D7,$B8D8,$B8D9,$B8DA,$B8DB,$B8DC,$B8DE,$B8E0,$B8E2,$B8E3,$B8E4,$B8E5,
$B8E6,$B8E7,$B8EA,$B8EB,$B8ED,$B8EE,$B8EF,$B8F1,$B8F2,$B8F3,$B8F4,$B8F5,$B8F6,
$B8F7,$B8FA,$B8FC,$B8FE,$B8FF,$B900,$B901,$B902,$B903,$B905,$B906,$B907,$B908,
$B909,$B90A,$B90B,$B90C,$B90D,$B90E,$B90F,$B910,$B911,$B912,$B913,$B914,$B915,
$B916,$B917,$B919,$B91A,$B91B,$B91C,$B91D,$B91E,$B91F,$B921,$B922,$B923,$B924,
$B925,$B926,$B927,$B928,$B929,$B92A,$B92B,$B92C,$B92D,$B92E,$B92F,$B930,$B931,
$B932,$B933,$B934,$B935,$B936,$B937,$B938,$B939,$B93A,$B93B,$B93E,$B93F,$B941,
$B942,$B943,$B945,$B946,$B947,$B948,$B949,$B94A,$B94B,$B94D,$B94E,$B950,$B952,
$B953,$B954,$B955,$B956,$B957,$B95A,$B95B,$B95D,$B95E,$B95F,$B961,$B962,$B963,
$B964,$B965,$B966,$B967,$B96A,$B96C,$B96E,$B96F,$B970,$B971,$B972,$B973,$B976,
$B977,$B979,$B97A,$B97B,$B97D,$B97E,$B97F,$B980,$B981,$B982,$B983,$B986,$B988,
$B98B,$B98C,$B98F,$B990,$B991,$B992,$B993,$B994,$B995,$B996,$B997,$B998,$B999,
$B99A,$B99B,$B99C,$B99D,$B99E,$B99F,$B9A0,$B9A1,$B9A2,$B9A3,$B9A4,$B9A5,$B9A6,
$B9A7,$B9A8,$B9A9,$B9AA,$B9AB,$B9AE,$B9AF,$B9B1,$B9B2,$B9B3,$B9B5,$B9B6,$B9B7,
$B9B8,$B9B9,$B9BA,$B9BB,$B9BE,$B9C0,$B9C2,$B9C3,$B9C4,$B9C5,$B9C6,$B9C7,$B9CA,
$B9CB,$B9CD,$B9D3,$B9D4,$B9D5,$B9D6,$B9D7,$B9DA,$B9DC,$B9DF,$B9E0,$B9E2,$B9E6,
$B9E7,$B9E9,$B9EA,$B9EB,$B9ED,$B9EE,$B9EF,$B9F0,$B9F1,$B9F2,$B9F3,$B9F6,$B9FB,
$B9FC,$B9FD,$B9FE,$B9FF,$BA02,$BA03,$BA04,$BA05,$BA06,$BA07,$BA09,$BA0A,$BA0B,
$BA0C,$BA0D,$BA0E,$BA0F,$BA10,$BA11,$BA12,$BA13,$BA14,$BA16,$BA17,$BA18,$BA19,
$BA1A,$BA1B,$BA1C,$BA1D,$BA1E,$BA1F,$BA20,$BA21,$BA22,$BA23,$BA24,$BA25,$BA26,
$BA27,$BA28,$BA29,$BA2A,$BA2B,$BA2C,$BA2D,$BA2E,$BA2F,$BA30,$BA31,$BA32,$BA33,
$BA34,$BA35,$BA36,$BA37,$BA3A,$BA3B,$BA3D,$BA3E,$BA3F,$BA41,$BA43,$BA44,$BA45,
$BA46,$BA47,$BA4A,$BA4C,$BA4F,$BA50,$BA51,$BA52,$BA56,$BA57,$BA59,$BA5A,$BA5B,
$BA5D,$BA5E,$BA5F,$BA60,$BA61,$BA62,$BA63,$BA66,$BA6A,$BA6B,$BA6C,$BA6D,$BA6E,
$BA6F,$BA72,$BA73,$BA75,$BA76,$BA77,$BA79,$BA7A,$BA7B,$BA7C,$BA7D,$BA7E,$BA7F,
$BA80,$BA81,$BA82,$BA86,$BA88,$BA89,$BA8A,$BA8B,$BA8D,$BA8E,$BA8F,$BA90,$BA91,
$BA92,$BA93,$BA94,$BA95,$BA96,$BA97,$BA98,$BA99,$BA9A,$BA9B,$BA9C,$BA9D,$BA9E,
$BA9F,$BAA0,$BAA1,$BAA2,$BAA3,$BAA4,$BAA5,$BAA6,$BAA7,$BAAA,$BAAD,$BAAE,$BAAF,
$BAB1,$BAB3,$BAB4,$BAB5,$BAB6,$BAB7,$BABA,$BABC,$BABE,$BABF,$BAC0,$BAC1,$BAC2,
$BAC3,$BAC5,$BAC6,$BAC7,$BAC9,$BACA,$BACB,$BACC,$BACD,$BACE,$BACF,$BAD0,$BAD1,
$BAD2,$BAD3,$BAD4,$BAD5,$BAD6,$BAD7,$BADA,$BADB,$BADC,$BADD,$BADE,$BADF,$BAE0,
$BAE1,$BAE2,$BAE3,$BAE4,$BAE5,$BAE6,$BAE7,$BAE8,$BAE9,$BAEA,$BAEB,$BAEC,$BAED,
$BAEE,$BAEF,$BAF0,$BAF1,$BAF2,$BAF3,$BAF4,$BAF5,$BAF6,$BAF7,$BAF8,$BAF9,$BAFA,
$BAFB,$BAFD,$BAFE,$BAFF,$BB01,$BB02,$BB03,$BB05,$BB06,$BB07,$BB08,$BB09,$BB0A,
$BB0B,$BB0C,$BB0E,$BB10,$BB12,$BB13,$BB14,$BB15,$BB16,$BB17,$BB19,$BB1A,$BB1B,
$BB1D,$BB1E,$BB1F,$BB21,$BB22,$BB23,$BB24,$BB25,$BB26,$BB27,$BB28,$BB2A,$BB2C,
$BB2D,$BB2E,$BB2F,$BB30,$BB31,$BB32,$BB33,$BB37,$BB39,$BB3A,$BB3F,$BB40,$BB41,
$BB42,$BB43,$BB46,$BB48,$BB4A,$BB4B,$BB4C,$BB4E,$BB51,$BB52,$BB53,$BB55,$BB56,
$BB57,$BB59,$BB5A,$BB5B,$BB5C,$BB5D,$BB5E,$BB5F,$BB60,$BB62,$BB64,$BB65,$BB66,
$BB67,$BB68,$BB69,$BB6A,$BB6B,$BB6D,$BB6E,$BB6F,$BB70,$BB71,$BB72,$BB73,$BB74,
$BB75,$BB76,$BB77,$BB78,$BB79,$BB7A,$BB7B,$BB7C,$BB7D,$BB7E,$BB7F,$BB80,$BB81,
$BB82,$BB83,$BB84,$BB85,$BB86,$BB87,$BB89,$BB8A,$BB8B,$BB8D,$BB8E,$BB8F,$BB91,
$BB92,$BB93,$BB94,$BB95,$BB96,$BB97,$BB98,$BB99,$BB9A,$BB9B,$BB9C,$BB9D,$BB9E,
$BB9F,$BBA0,$BBA1,$BBA2,$BBA3,$BBA5,$BBA6,$BBA7,$BBA9,$BBAA,$BBAB,$BBAD,$BBAE,
$BBAF,$BBB0,$BBB1,$BBB2,$BBB3,$BBB5,$BBB6,$BBB8,$BBB9,$BBBA,$BBBB,$BBBC,$BBBD,
$BBBE,$BBBF,$BBC1,$BBC2,$BBC3,$BBC5,$BBC6,$BBC7,$BBC9,$BBCA,$BBCB,$BBCC,$BBCD,
$BBCE,$BBCF,$BBD1,$BBD2,$BBD4,$BBD5,$BBD6,$BBD7,$BBD8,$BBD9,$BBDA,$BBDB,$BBDC,
$BBDD,$BBDE,$BBDF,$BBE0,$BBE1,$BBE2,$BBE3,$BBE4,$BBE5,$BBE6,$BBE7,$BBE8,$BBE9,
$BBEA,$BBEB,$BBEC,$BBED,$BBEE,$BBEF,$BBF0,$BBF1,$BBF2,$BBF3,$BBF4,$BBF5,$BBF6,
$BBF7,$BBFA,$BBFB,$BBFD,$BBFE,$BC01,$BC03,$BC04,$BC05,$BC06,$BC07,$BC0A,$BC0E,
$BC10,$BC12,$BC13,$BC19,$BC1A,$BC20,$BC21,$BC22,$BC23,$BC26,$BC28,$BC2A,$BC2B,
$BC2C,$BC2E,$BC2F,$BC32,$BC33,$BC35,$BC36,$BC37,$BC39,$BC3A,$BC3B,$BC3C,$BC3D,
$BC3E,$BC3F,$BC42,$BC46,$BC47,$BC48,$BC4A,$BC4B,$BC4E,$BC4F,$BC51,$BC52,$BC53,
$BC54,$BC55,$BC56,$BC57,$BC58,$BC59,$BC5A,$BC5B,$BC5C,$BC5E,$BC5F,$BC60,$BC61,
$BC62,$BC63,$BC64,$BC65,$BC66,$BC67,$BC68,$BC69,$BC6A,$BC6B,$BC6C,$BC6D,$BC6E,
$BC6F,$BC70,$BC71,$BC72,$BC73,$BC74,$BC75,$BC76,$BC77,$BC78,$BC79,$BC7A,$BC7B,
$BC7C,$BC7D,$BC7E,$BC7F,$BC80,$BC81,$BC82,$BC83,$BC86,$BC87,$BC89,$BC8A,$BC8D,
$BC8F,$BC90,$BC91,$BC92,$BC93,$BC96,$BC98,$BC9B,$BC9C,$BC9D,$BC9E,$BC9F,$BCA2,
$BCA3,$BCA5,$BCA6,$BCA9,$BCAA,$BCAB,$BCAC,$BCAD,$BCAE,$BCAF,$BCB2,$BCB6,$BCB7,
$BCB8,$BCB9,$BCBA,$BCBB,$BCBE,$BCBF,$BCC1,$BCC2,$BCC3,$BCC5,$BCC6,$BCC7,$BCC8,
$BCC9,$BCCA,$BCCB,$BCCC,$BCCE,$BCD2,$BCD3,$BCD4,$BCD6,$BCD7,$BCD9,$BCDA,$BCDB,
$BCDD,$BCDE,$BCDF,$BCE0,$BCE1,$BCE2,$BCE3,$BCE4,$BCE5,$BCE6,$BCE7,$BCE8,$BCE9,
$BCEA,$BCEB,$BCEC,$BCED,$BCEE,$BCEF,$BCF0,$BCF1,$BCF2,$BCF3,$BCF7,$BCF9,$BCFA,
$BCFB,$BCFD,$BCFE,$BCFF,$BD00,$BD01,$BD02,$BD03,$BD06,$BD08,$BD0A,$BD0B,$BD0C,
$BD0D,$BD0E,$BD0F,$BD11,$BD12,$BD13,$BD15,$BD16,$BD17,$BD18,$BD19,$BD1A,$BD1B,
$BD1C,$BD1D,$BD1E,$BD1F,$BD20,$BD21,$BD22,$BD23,$BD25,$BD26,$BD27,$BD28,$BD29,
$BD2A,$BD2B,$BD2D,$BD2E,$BD2F,$BD30,$BD31,$BD32,$BD33,$BD34,$BD35,$BD36,$BD37,
$BD38,$BD39,$BD3A,$BD3B,$BD3C,$BD3D,$BD3E,$BD3F,$BD41,$BD42,$BD43,$BD44,$BD45,
$BD46,$BD47,$BD4A,$BD4B,$BD4D,$BD4E,$BD4F,$BD51,$BD52,$BD53,$BD54,$BD55,$BD56,
$BD57,$BD5A,$BD5B,$BD5C,$BD5D,$BD5E,$BD5F,$BD60,$BD61,$BD62,$BD63,$BD65,$BD66,
$BD67,$BD69,$BD6A,$BD6B,$BD6C,$BD6D,$BD6E,$BD6F,$BD70,$BD71,$BD72,$BD73,$BD74,
$BD75,$BD76,$BD77,$BD78,$BD79,$BD7A,$BD7B,$BD7C,$BD7D,$BD7E,$BD7F,$BD82,$BD83,
$BD85,$BD86,$BD8B,$BD8C,$BD8D,$BD8E,$BD8F,$BD92,$BD94,$BD96,$BD97,$BD98,$BD9B,
$BD9D,$BD9E,$BD9F,$BDA0,$BDA1,$BDA2,$BDA3,$BDA5,$BDA6,$BDA7,$BDA8,$BDA9,$BDAA,
$BDAB,$BDAC,$BDAD,$BDAE,$BDAF,$BDB1,$BDB2,$BDB3,$BDB4,$BDB5,$BDB6,$BDB7,$BDB9,
$BDBA,$BDBB,$BDBC,$BDBD,$BDBE,$BDBF,$BDC0,$BDC1,$BDC2,$BDC3,$BDC4,$BDC5,$BDC6,
$BDC7,$BDC8,$BDC9,$BDCA,$BDCB,$BDCC,$BDCD,$BDCE,$BDCF,$BDD0,$BDD1,$BDD2,$BDD3,
$BDD6,$BDD7,$BDD9,$BDDA,$BDDB,$BDDD,$BDDE,$BDDF,$BDE0,$BDE1,$BDE2,$BDE3,$BDE4,
$BDE5,$BDE6,$BDE7,$BDE8,$BDEA,$BDEB,$BDEC,$BDED,$BDEE,$BDEF,$BDF1,$BDF2,$BDF3,
$BDF5,$BDF6,$BDF7,$BDF9,$BDFA,$BDFB,$BDFC,$BDFD,$BDFE,$BDFF,$BE01,$BE02,$BE04,
$BE06,$BE07,$BE08,$BE09,$BE0A,$BE0B,$BE0E,$BE0F,$BE11,$BE12,$BE13,$BE15,$BE16,
$BE17,$BE18,$BE19,$BE1A,$BE1B,$BE1E,$BE20,$BE21,$BE22,$BE23,$BE24,$BE25,$BE26,
$BE27,$BE28,$BE29,$BE2A,$BE2B,$BE2C,$BE2D,$BE2E,$BE2F,$BE30,$BE31,$BE32,$BE33,
$BE34,$BE35,$BE36,$BE37,$BE38,$BE39,$BE3A,$BE3B,$BE3C,$BE3D,$BE3E,$BE3F,$BE40,
$BE41,$BE42,$BE43,$BE46,$BE47,$BE49,$BE4A,$BE4B,$BE4D,$BE4F,$BE50,$BE51,$BE52,
$BE53,$BE56,$BE58,$BE5C,$BE5D,$BE5E,$BE5F,$BE62,$BE63,$BE65,$BE66,$BE67,$BE69,
$BE6B,$BE6C,$BE6D,$BE6E,$BE6F,$BE72,$BE76,$BE77,$BE78,$BE79,$BE7A,$BE7E,$BE7F,
$BE81,$BE82,$BE83,$BE85,$BE86,$BE87,$BE88,$BE89,$BE8A,$BE8B,$BE8E,$BE92,$BE93,
$BE94,$BE95,$BE96,$BE97,$BE9A,$BE9B,$BE9C,$BE9D,$BE9E,$BE9F,$BEA0,$BEA1,$BEA2,
$BEA3,$BEA4,$BEA5,$BEA6,$BEA7,$BEA9,$BEAA,$BEAB,$BEAC,$BEAD,$BEAE,$BEAF,$BEB0,
$BEB1,$BEB2,$BEB3,$BEB4,$BEB5,$BEB6,$BEB7,$BEB8,$BEB9,$BEBA,$BEBB,$BEBC,$BEBD,
$BEBE,$BEBF,$BEC0,$BEC1,$BEC2,$BEC3,$BEC4,$BEC5,$BEC6,$BEC7,$BEC8,$BEC9,$BECA,
$BECB,$BECC,$BECD,$BECE,$BECF,$BED2,$BED3,$BED5,$BED6,$BED9,$BEDA,$BEDB,$BEDC,
$BEDD,$BEDE,$BEDF,$BEE1,$BEE2,$BEE6,$BEE7,$BEE8,$BEE9,$BEEA,$BEEB,$BEED,$BEEE,
$BEEF,$BEF0,$BEF1,$BEF2,$BEF3,$BEF4,$BEF5,$BEF6,$BEF7,$BEF8,$BEF9,$BEFA,$BEFB,
$BEFC,$BEFD,$BEFE,$BEFF,$BF00,$BF02,$BF03,$BF04,$BF05,$BF06,$BF07,$BF0A,$BF0B,
$BF0C,$BF0D,$BF0E,$BF0F,$BF10,$BF11,$BF12,$BF13,$BF14,$BF15,$BF16,$BF17,$BF1A,
$BF1E,$BF1F,$BF20,$BF21,$BF22,$BF23,$BF24,$BF25,$BF26,$BF27,$BF28,$BF29,$BF2A,
$BF2B,$BF2C,$BF2D,$BF2E,$BF2F,$BF30,$BF31,$BF32,$BF33,$BF34,$BF35,$BF36,$BF37,
$BF38,$BF39,$BF3A,$BF3B,$BF3C,$BF3D,$BF3E,$BF3F,$BF42,$BF43,$BF45,$BF46,$BF47,
$BF49,$BF4A,$BF4B,$BF4C,$BF4D,$BF4E,$BF4F,$BF52,$BF53,$BF54,$BF56,$BF57,$BF58,
$BF59,$BF5A,$BF5B,$BF5C,$BF5D,$BF5E,$BF5F,$BF60,$BF61,$BF62,$BF63,$BF64,$BF65,
$BF66,$BF67,$BF68,$BF69,$BF6A,$BF6B,$BF6C,$BF6D,$BF6E,$BF6F,$BF70,$BF71,$BF72,
$BF73,$BF74,$BF75,$BF76,$BF77,$BF78,$BF79,$BF7A,$BF7B,$BF7C,$BF7D,$BF7E,$BF7F,
$BF80,$BF81,$BF82,$BF83,$BF84,$BF85,$BF86,$BF87,$BF88,$BF89,$BF8A,$BF8B,$BF8C,
$BF8D,$BF8E,$BF8F,$BF90,$BF91,$BF92,$BF93,$BF95,$BF96,$BF97,$BF98,$BF99,$BF9A,
$BF9B,$BF9C,$BF9D,$BF9E,$BF9F,$BFA0,$BFA1,$BFA2,$BFA3,$BFA4,$BFA5,$BFA6,$BFA7,
$BFA8,$BFA9,$BFAA,$BFAB,$BFAC,$BFAD,$BFAE,$BFAF,$BFB1,$BFB2,$BFB3,$BFB4,$BFB5,
$BFB6,$BFB7,$BFB8,$BFB9,$BFBA,$BFBB,$BFBC,$BFBD,$BFBE,$BFBF,$BFC0,$BFC1,$BFC2,
$BFC3,$BFC4,$BFC6,$BFC7,$BFC8,$BFC9,$BFCA,$BFCB,$BFCE,$BFCF,$BFD1,$BFD2,$BFD3,
$BFD5,$BFD6,$BFD7,$BFD8,$BFD9,$BFDA,$BFDB,$BFDD,$BFDE,$BFE0,$BFE2,$BFE3,$BFE4,
$BFE5,$BFE6,$BFE7,$BFE8,$BFE9,$BFEA,$BFEB,$BFEC,$BFED,$BFEE,$BFEF,$BFF0,$BFF1,
$BFF2,$BFF3,$BFF4,$BFF5,$BFF6,$BFF7,$BFF8,$BFF9,$BFFA,$BFFB,$BFFC,$BFFD,$BFFE,
$BFFF,$C000,$C001,$C002,$C003,$C004,$C005,$C006,$C007,$C008,$C009,$C00A,$C00B,
$C00C,$C00D,$C00E,$C00F,$C010,$C011,$C012,$C013,$C014,$C015,$C016,$C017,$C018,
$C019,$C01A,$C01B,$C01C,$C01D,$C01E,$C01F,$C020,$C021,$C022,$C023,$C024,$C025,
$C026,$C027,$C028,$C029,$C02A,$C02B,$C02C,$C02D,$C02E,$C02F,$C030,$C031,$C032,
$C033,$C034,$C035,$C036,$C037,$C038,$C039,$C03A,$C03B,$C03D,$C03E,$C03F,$C040,
$C041,$C042,$C043,$C044,$C045,$C046,$C047,$C048,$C049,$C04A,$C04B,$C04C,$C04D,
$C04E,$C04F,$C050,$C052,$C053,$C054,$C055,$C056,$C057,$C059,$C05A,$C05B,$C05D,
$C05E,$C05F,$C061,$C062,$C063,$C064,$C065,$C066,$C067,$C06A,$C06B,$C06C,$C06D,
$C06E,$C06F,$C070,$C071,$C072,$C073,$C074,$C075,$C076,$C077,$C078,$C079,$C07A,
$C07B,$C07C,$C07D,$C07E,$C07F,$C080,$C081,$C082,$C083,$C084,$C085,$C086,$C087,
$C088,$C089,$C08A,$C08B,$C08C,$C08D,$C08E,$C08F,$C092,$C093,$C095,$C096,$C097,
$C099,$C09A,$C09B,$C09C,$C09D,$C09E,$C09F,$C0A2,$C0A4,$C0A6,$C0A7,$C0A8,$C0A9,
$C0AA,$C0AB,$C0AE,$C0B1,$C0B2,$C0B7,$C0B8,$C0B9,$C0BA,$C0BB,$C0BE,$C0C2,$C0C3,
$C0C4,$C0C6,$C0C7,$C0CA,$C0CB,$C0CD,$C0CE,$C0CF,$C0D1,$C0D2,$C0D3,$C0D4,$C0D5,
$C0D6,$C0D7,$C0DA,$C0DE,$C0DF,$C0E0,$C0E1,$C0E2,$C0E3,$C0E6,$C0E7,$C0E9,$C0EA,
$C0EB,$C0ED,$C0EE,$C0EF,$C0F0,$C0F1,$C0F2,$C0F3,$C0F6,$C0F8,$C0FA,$C0FB,$C0FC,
$C0FD,$C0FE,$C0FF,$C101,$C102,$C103,$C105,$C106,$C107,$C109,$C10A,$C10B,$C10C,
$C10D,$C10E,$C10F,$C111,$C112,$C113,$C114,$C116,$C117,$C118,$C119,$C11A,$C11B,
$C121,$C122,$C125,$C128,$C129,$C12A,$C12B,$C12E,$C132,$C133,$C134,$C135,$C137,
$C13A,$C13B,$C13D,$C13E,$C13F,$C141,$C142,$C143,$C144,$C145,$C146,$C147,$C14A,
$C14E,$C14F,$C150,$C151,$C152,$C153,$C156,$C157,$C159,$C15A,$C15B,$C15D,$C15E,
$C15F,$C160,$C161,$C162,$C163,$C166,$C16A,$C16B,$C16C,$C16D,$C16E,$C16F,$C171,
$C172,$C173,$C175,$C176,$C177,$C179,$C17A,$C17B,$C17C,$C17D,$C17E,$C17F,$C180,
$C181,$C182,$C183,$C184,$C186,$C187,$C188,$C189,$C18A,$C18B,$C18F,$C191,$C192,
$C193,$C195,$C197,$C198,$C199,$C19A,$C19B,$C19E,$C1A0,$C1A2,$C1A3,$C1A4,$C1A6,
$C1A7,$C1AA,$C1AB,$C1AD,$C1AE,$C1AF,$C1B1,$C1B2,$C1B3,$C1B4,$C1B5,$C1B6,$C1B7,
$C1B8,$C1B9,$C1BA,$C1BB,$C1BC,$C1BE,$C1BF,$C1C0,$C1C1,$C1C2,$C1C3,$C1C5,$C1C6,
$C1C7,$C1C9,$C1CA,$C1CB,$C1CD,$C1CE,$C1CF,$C1D0,$C1D1,$C1D2,$C1D3,$C1D5,$C1D6,
$C1D9,$C1DA,$C1DB,$C1DC,$C1DD,$C1DE,$C1DF,$C1E1,$C1E2,$C1E3,$C1E5,$C1E6,$C1E7,
$C1E9,$C1EA,$C1EB,$C1EC,$C1ED,$C1EE,$C1EF,$C1F2,$C1F4,$C1F5,$C1F6,$C1F7,$C1F8,
$C1F9,$C1FA,$C1FB,$C1FE,$C1FF,$C201,$C202,$C203,$C205,$C206,$C207,$C208,$C209,
$C20A,$C20B,$C20E,$C210,$C212,$C213,$C214,$C215,$C216,$C2