/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.serialization;

import java.io.ByteArrayOutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.TypeCastException;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.PackageFragmentDescriptor;
import org.jetbrains.kotlin.descriptors.PossiblyInnerType;
import org.jetbrains.kotlin.descriptors.PropertyAccessorDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyGetterDescriptor;
import org.jetbrains.kotlin.descriptors.PropertySetterDescriptor;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterUtilsKt;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.Annotated;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.protobuf.MessageLite;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.MemberComparator;
import org.jetbrains.kotlin.resolve.constants.ConstantValue;
import org.jetbrains.kotlin.resolve.constants.NullValue;
import org.jetbrains.kotlin.serialization.DescriptorSerializer$Companion$WhenMappings;
import org.jetbrains.kotlin.serialization.Flags;
import org.jetbrains.kotlin.serialization.MutableTypeTable;
import org.jetbrains.kotlin.serialization.ProtoBuf;
import org.jetbrains.kotlin.serialization.SerializerExtension;
import org.jetbrains.kotlin.serialization.StringTable;
import org.jetbrains.kotlin.types.Flexibility;
import org.jetbrains.kotlin.types.FlexibleTypesKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeProjection;
import org.jetbrains.kotlin.types.Variance;
import org.jetbrains.kotlin.utils.Interner;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000\u00de\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 J2\u00020\u0001:\u0001JB7\b\u0002\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rJ\u000e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015J\u000e\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019J\u0010\u0010\u001a\u001a\u00020\u00002\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u000e\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0018\u001a\u00020\u0015J\u0018\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$H\u0002J\u000e\u0010%\u001a\u00020&2\u0006\u0010\u0018\u001a\u00020'J\u0010\u0010(\u001a\u00020)2\u0006\u0010\u0018\u001a\u00020\u0015H\u0002J\u0010\u0010*\u001a\u00020)2\u0006\u0010+\u001a\u00020,H\u0002J\u0010\u0010-\u001a\u00020)2\u0006\u0010\u0018\u001a\u00020\u0006H\u0002J\u0014\u0010.\u001a\u00020/2\f\u00100\u001a\b\u0012\u0004\u0012\u00020\u000301J.\u00102\u001a\u00020/2\f\u00103\u001a\b\u0012\u0004\u0012\u000204012\u0016\b\u0002\u00105\u001a\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\f\u0018\u000106H\u0007J\u000e\u00107\u001a\u0002082\u0006\u0010\u0018\u001a\u000209J\u000e\u0010:\u001a\u00020;2\u0006\u0010<\u001a\u00020=J\u0010\u0010#\u001a\u00020\"2\u0006\u0010#\u001a\u00020>H\u0002J\u0010\u0010?\u001a\u00020@2\u0006\u0010A\u001a\u00020BH\u0002J\u0010\u0010C\u001a\u00020)2\u0006\u0010#\u001a\u00020>H\u0002J\u0010\u0010D\u001a\u00020E2\u0006\u0010D\u001a\u00020\u0006H\u0002J\b\u0010F\u001a\u00020\fH\u0002J\u0010\u0010G\u001a\u00020H2\u0006\u0010\u0018\u001a\u00020IH\u0002R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000e\u001a\u00020\u000f8F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006K"}, d2={"Lorg/jetbrains/kotlin/serialization/DescriptorSerializer;", "", "containingDeclaration", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "typeParameters", "Lorg/jetbrains/kotlin/utils/Interner;", "Lorg/jetbrains/kotlin/descriptors/TypeParameterDescriptor;", "extension", "Lorg/jetbrains/kotlin/serialization/SerializerExtension;", "typeTable", "Lorg/jetbrains/kotlin/serialization/MutableTypeTable;", "serializeTypeTableToFunction", "", "(Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;Lorg/jetbrains/kotlin/utils/Interner;Lorg/jetbrains/kotlin/serialization/SerializerExtension;Lorg/jetbrains/kotlin/serialization/MutableTypeTable;Z)V", "stringTable", "Lorg/jetbrains/kotlin/serialization/StringTable;", "getStringTable", "()Lorg/jetbrains/kotlin/serialization/StringTable;", "classProto", "Lorg/jetbrains/kotlin/serialization/ProtoBuf$Class$Builder;", "classDescriptor", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "constructorProto", "Lorg/jetbrains/kotlin/serialization/ProtoBuf$Constructor$Builder;", "descriptor", "Lorg/jetbrains/kotlin/descriptors/ConstructorDescriptor;", "createChildSerializer", "callable", "Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;", "enumEntryProto", "Lorg/jetbrains/kotlin/serialization/ProtoBuf$EnumEntry$Builder;", "fillFromPossiblyInnerType", "", "builder", "Lorg/jetbrains/kotlin/serialization/ProtoBuf$Type$Builder;", "type", "Lorg/jetbrains/kotlin/descriptors/PossiblyInnerType;", "functionProto", "Lorg/jetbrains/kotlin/serialization/ProtoBuf$Function$Builder;", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "getClassId", "", "getSimpleNameIndex", "name", "Lorg/jetbrains/kotlin/name/Name;", "getTypeParameterId", "packagePartProto", "Lorg/jetbrains/kotlin/serialization/ProtoBuf$Package$Builder;", "members", "", "packageProto", "fragments", "Lorg/jetbrains/kotlin/descriptors/PackageFragmentDescriptor;", "skip", "Lkotlin/Function1;", "propertyProto", "Lorg/jetbrains/kotlin/serialization/ProtoBuf$Property$Builder;", "Lorg/jetbrains/kotlin/descriptors/PropertyDescriptor;", "serialize", "", "message", "Lorg/jetbrains/kotlin/protobuf/MessageLite;", "Lorg/jetbrains/kotlin/types/KotlinType;", "typeArgument", "Lorg/jetbrains/kotlin/serialization/ProtoBuf$Type$Argument$Builder;", "typeProjection", "Lorg/jetbrains/kotlin/types/TypeProjection;", "typeId", "typeParameter", "Lorg/jetbrains/kotlin/serialization/ProtoBuf$TypeParameter$Builder;", "useTypeTable", "valueParameter", "Lorg/jetbrains/kotlin/serialization/ProtoBuf$ValueParameter$Builder;", "Lorg/jetbrains/kotlin/descriptors/ValueParameterDescriptor;", "Companion", "kotlin-compiler"})
public final class DescriptorSerializer {
    private final DeclarationDescriptor containingDeclaration;
    private final Interner<TypeParameterDescriptor> typeParameters;
    private final SerializerExtension extension;
    private final MutableTypeTable typeTable;
    private final boolean serializeTypeTableToFunction;
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final byte[] serialize(@NotNull MessageLite message) {
        Intrinsics.checkParameterIsNotNull(message, "message");
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ByteArrayOutputStream $receiver = byteArrayOutputStream;
        this.getStringTable().serializeTo($receiver);
        message.writeTo($receiver);
        byte[] byArray = byteArrayOutputStream.toByteArray();
        Intrinsics.checkExpressionValueIsNotNull(byArray, "ByteArrayOutputStream().\u2026)\n        }.toByteArray()");
        return byArray;
    }

    private final DescriptorSerializer createChildSerializer(CallableDescriptor callable) {
        return new DescriptorSerializer(callable, new Interner<TypeParameterDescriptor>(this.typeParameters), this.extension, this.typeTable, false);
    }

    @NotNull
    public final StringTable getStringTable() {
        return this.extension.getStringTable();
    }

    private final boolean useTypeTable() {
        return this.extension.shouldUseTypeTable();
    }

    @NotNull
    public final ProtoBuf.Class.Builder classProto(@NotNull ClassDescriptor classDescriptor) {
        ProtoBuf.TypeTable typeTableProto;
        Intrinsics.checkParameterIsNotNull(classDescriptor, "classDescriptor");
        ProtoBuf.Class.Builder builder = ProtoBuf.Class.newBuilder();
        int flags = Flags.getClassFlags(DescriptorSerializer.Companion.hasAnnotations(classDescriptor), classDescriptor.getVisibility(), classDescriptor.getModality(), classDescriptor.getKind(), classDescriptor.isInner(), classDescriptor.isCompanionObject(), classDescriptor.isData());
        if (flags != builder.getFlags()) {
            builder.setFlags(flags);
        }
        builder.setFqName(this.getClassId(classDescriptor));
        Iterator<Annotated> iterator2 = classDescriptor.getDeclaredTypeParameters().iterator();
        while (iterator2.hasNext()) {
            TypeParameterDescriptor typeParameterDescriptor;
            TypeParameterDescriptor typeParameterDescriptor2 = typeParameterDescriptor = iterator2.next();
            Intrinsics.checkExpressionValueIsNotNull(typeParameterDescriptor2, "typeParameterDescriptor");
            builder.addTypeParameter(this.typeParameter(typeParameterDescriptor2));
        }
        if (!KotlinBuiltIns.isSpecialClassWithNoSupertypes(classDescriptor)) {
            for (KotlinType kotlinType : classDescriptor.getTypeConstructor().getSupertypes()) {
                if (this.useTypeTable()) {
                    KotlinType kotlinType2 = kotlinType;
                    Intrinsics.checkExpressionValueIsNotNull(kotlinType2, "supertype");
                    builder.addSupertypeId(this.typeId(kotlinType2));
                    continue;
                }
                KotlinType kotlinType3 = kotlinType;
                Intrinsics.checkExpressionValueIsNotNull(kotlinType3, "supertype");
                builder.addSupertype(this.type(kotlinType3));
            }
        }
        iterator2 = classDescriptor.getConstructors().iterator();
        while (iterator2.hasNext()) {
            ConstructorDescriptor constructorDescriptor;
            ConstructorDescriptor constructorDescriptor2 = constructorDescriptor = (ConstructorDescriptor)iterator2.next();
            Intrinsics.checkExpressionValueIsNotNull(constructorDescriptor2, "descriptor");
            builder.addConstructor(this.constructorProto(constructorDescriptor2));
        }
        Collection<DeclarationDescriptor> collection = DescriptorUtils.getAllDescriptors(classDescriptor.getDefaultType().getMemberScope());
        Intrinsics.checkExpressionValueIsNotNull(collection, "DescriptorUtils.getAllDe\u2026.defaultType.memberScope)");
        for (DeclarationDescriptor declarationDescriptor : Companion.sort(collection)) {
            if (!(declarationDescriptor instanceof CallableMemberDescriptor) || Intrinsics.areEqual((Object)((CallableMemberDescriptor)declarationDescriptor).getKind(), (Object)CallableMemberDescriptor.Kind.FAKE_OVERRIDE)) continue;
            DeclarationDescriptor declarationDescriptor2 = declarationDescriptor;
            if (declarationDescriptor2 instanceof PropertyDescriptor) {
                builder.addProperty(this.propertyProto((PropertyDescriptor)declarationDescriptor));
                continue;
            }
            if (!(declarationDescriptor2 instanceof FunctionDescriptor)) continue;
            builder.addFunction(this.functionProto((FunctionDescriptor)declarationDescriptor));
        }
        Collection<DeclarationDescriptor> collection2 = DescriptorUtils.getAllDescriptors(classDescriptor.getUnsubstitutedInnerClassesScope());
        Intrinsics.checkExpressionValueIsNotNull(collection2, "DescriptorUtils.getAllDe\u2026titutedInnerClassesScope)");
        for (DeclarationDescriptor declarationDescriptor : Companion.sort(collection2)) {
            Name name = declarationDescriptor.getName();
            Intrinsics.checkExpressionValueIsNotNull(name, "descriptor.name");
            int name2 = this.getSimpleNameIndex(name);
            if (DescriptorUtils.isEnumEntry(declarationDescriptor)) {
                DeclarationDescriptor declarationDescriptor3 = declarationDescriptor;
                if (declarationDescriptor3 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.descriptors.ClassDescriptor");
                }
                builder.addEnumEntry(this.enumEntryProto((ClassDescriptor)declarationDescriptor3));
                continue;
            }
            builder.addNestedClassName(name2);
        }
        ClassDescriptor classDescriptor2 = classDescriptor.getCompanionObjectDescriptor();
        if (classDescriptor2 != null) {
            Name name = classDescriptor2.getName();
            Intrinsics.checkExpressionValueIsNotNull(name, "companionObjectDescriptor.name");
            builder.setCompanionObjectName(this.getSimpleNameIndex(name));
        }
        if ((typeTableProto = this.typeTable.serialize()) != null) {
            builder.setTypeTable(typeTableProto);
        }
        ProtoBuf.Class.Builder builder2 = builder;
        Intrinsics.checkExpressionValueIsNotNull(builder2, "builder");
        this.extension.serializeClass(classDescriptor, builder2);
        ProtoBuf.Class.Builder builder3 = builder;
        Intrinsics.checkExpressionValueIsNotNull(builder3, "builder");
        return builder3;
    }

    @NotNull
    public final ProtoBuf.Property.Builder propertyProto(@NotNull PropertyDescriptor descriptor2) {
        int flags;
        PropertySetterDescriptor setter;
        Intrinsics.checkParameterIsNotNull(descriptor2, "descriptor");
        ProtoBuf.Property.Builder builder = ProtoBuf.Property.newBuilder();
        DescriptorSerializer local = this.createChildSerializer(descriptor2);
        boolean hasGetter = false;
        boolean hasSetter = false;
        boolean lateInit = descriptor2.isLateInit();
        boolean isConst = descriptor2.isConst();
        ConstantValue<?> compileTimeConstant = descriptor2.getCompileTimeInitializer();
        boolean hasConstant = compileTimeConstant != null && !(compileTimeConstant instanceof NullValue);
        Collection collection = descriptor2.getAnnotations().getAllAnnotations();
        boolean hasAnnotations = !collection.isEmpty();
        int propertyFlags = Flags.getAccessorFlags(hasAnnotations, descriptor2.getVisibility(), descriptor2.getModality(), false, false);
        PropertyGetterDescriptor getter = descriptor2.getGetter();
        if (getter != null) {
            hasGetter = true;
            int accessorFlags = DescriptorSerializer.Companion.getAccessorFlags(getter);
            if (accessorFlags != propertyFlags) {
                builder.setGetterFlags(accessorFlags);
            }
        }
        if ((setter = descriptor2.getSetter()) != null) {
            hasSetter = true;
            int accessorFlags = DescriptorSerializer.Companion.getAccessorFlags(setter);
            if (accessorFlags != propertyFlags) {
                builder.setSetterFlags(accessorFlags);
            }
            if (!setter.isDefault()) {
                DescriptorSerializer setterLocal = local.createChildSerializer(setter);
                Iterator<ValueParameterDescriptor> iterator2 = setter.getValueParameters().iterator();
                while (iterator2.hasNext()) {
                    ValueParameterDescriptor valueParameterDescriptor;
                    ValueParameterDescriptor valueParameterDescriptor2 = valueParameterDescriptor = iterator2.next();
                    Intrinsics.checkExpressionValueIsNotNull(valueParameterDescriptor2, "valueParameterDescriptor");
                    builder.setSetterValueParameter(setterLocal.valueParameter(valueParameterDescriptor2));
                }
            }
        }
        if ((flags = Flags.getPropertyFlags(hasAnnotations, descriptor2.getVisibility(), descriptor2.getModality(), descriptor2.getKind(), descriptor2.isVar(), hasGetter, hasSetter, hasConstant, isConst, lateInit)) != builder.getFlags()) {
            builder.setFlags(flags);
        }
        Name name = descriptor2.getName();
        Intrinsics.checkExpressionValueIsNotNull(name, "descriptor.name");
        builder.setName(this.getSimpleNameIndex(name));
        if (this.useTypeTable()) {
            KotlinType kotlinType = descriptor2.getType();
            Intrinsics.checkExpressionValueIsNotNull(kotlinType, "descriptor.type");
            builder.setReturnTypeId(local.typeId(kotlinType));
        } else {
            KotlinType kotlinType = descriptor2.getType();
            Intrinsics.checkExpressionValueIsNotNull(kotlinType, "descriptor.type");
            builder.setReturnType(local.type(kotlinType));
        }
        Iterator<TypeParameterDescriptor> iterator3 = descriptor2.getTypeParameters().iterator();
        while (iterator3.hasNext()) {
            TypeParameterDescriptor typeParameterDescriptor;
            TypeParameterDescriptor typeParameterDescriptor2 = typeParameterDescriptor = iterator3.next();
            Intrinsics.checkExpressionValueIsNotNull(typeParameterDescriptor2, "typeParameterDescriptor");
            builder.addTypeParameter(local.typeParameter(typeParameterDescriptor2));
        }
        ReceiverParameterDescriptor receiverParameter = descriptor2.getExtensionReceiverParameter();
        if (receiverParameter != null) {
            if (this.useTypeTable()) {
                KotlinType kotlinType = receiverParameter.getType();
                Intrinsics.checkExpressionValueIsNotNull(kotlinType, "receiverParameter.type");
                builder.setReceiverTypeId(local.typeId(kotlinType));
            } else {
                KotlinType kotlinType = receiverParameter.getType();
                Intrinsics.checkExpressionValueIsNotNull(kotlinType, "receiverParameter.type");
                builder.setReceiverType(local.type(kotlinType));
            }
        }
        ProtoBuf.Property.Builder builder2 = builder;
        Intrinsics.checkExpressionValueIsNotNull(builder2, "builder");
        this.extension.serializeProperty(descriptor2, builder2);
        ProtoBuf.Property.Builder builder3 = builder;
        Intrinsics.checkExpressionValueIsNotNull(builder3, "builder");
        return builder3;
    }

    @NotNull
    public final ProtoBuf.Function.Builder functionProto(@NotNull FunctionDescriptor descriptor2) {
        ProtoBuf.TypeTable typeTableProto;
        Intrinsics.checkParameterIsNotNull(descriptor2, "descriptor");
        ProtoBuf.Function.Builder builder = ProtoBuf.Function.newBuilder();
        DescriptorSerializer local = this.createChildSerializer(descriptor2);
        int flags = Flags.getFunctionFlags(DescriptorSerializer.Companion.hasAnnotations(descriptor2), descriptor2.getVisibility(), descriptor2.getModality(), descriptor2.getKind(), descriptor2.isOperator(), descriptor2.isInfix(), descriptor2.isInline(), descriptor2.isTailrec(), descriptor2.isExternal());
        if (flags != builder.getFlags()) {
            builder.setFlags(flags);
        }
        Name name = descriptor2.getName();
        Intrinsics.checkExpressionValueIsNotNull(name, "descriptor.name");
        builder.setName(this.getSimpleNameIndex(name));
        if (this.useTypeTable()) {
            KotlinType kotlinType = descriptor2.getReturnType();
            if (kotlinType == null) {
                Intrinsics.throwNpe();
            }
            Intrinsics.checkExpressionValueIsNotNull(kotlinType, "descriptor.returnType!!");
            builder.setReturnTypeId(local.typeId(kotlinType));
        } else {
            KotlinType kotlinType = descriptor2.getReturnType();
            if (kotlinType == null) {
                Intrinsics.throwNpe();
            }
            Intrinsics.checkExpressionValueIsNotNull(kotlinType, "descriptor.returnType!!");
            builder.setReturnType(local.type(kotlinType));
        }
        Iterator<TypeParameterDescriptor> iterator2 = descriptor2.getTypeParameters().iterator();
        while (iterator2.hasNext()) {
            TypeParameterDescriptor typeParameterDescriptor;
            TypeParameterDescriptor typeParameterDescriptor2 = typeParameterDescriptor = iterator2.next();
            Intrinsics.checkExpressionValueIsNotNull(typeParameterDescriptor2, "typeParameterDescriptor");
            builder.addTypeParameter(local.typeParameter(typeParameterDescriptor2));
        }
        ReceiverParameterDescriptor receiverParameter = descriptor2.getExtensionReceiverParameter();
        if (receiverParameter != null) {
            if (this.useTypeTable()) {
                KotlinType kotlinType = receiverParameter.getType();
                Intrinsics.checkExpressionValueIsNotNull(kotlinType, "receiverParameter.type");
                builder.setReceiverTypeId(local.typeId(kotlinType));
            } else {
                KotlinType kotlinType = receiverParameter.getType();
                Intrinsics.checkExpressionValueIsNotNull(kotlinType, "receiverParameter.type");
                builder.setReceiverType(local.type(kotlinType));
            }
        }
        Iterator<ValueParameterDescriptor> iterator3 = descriptor2.getValueParameters().iterator();
        while (iterator3.hasNext()) {
            ValueParameterDescriptor valueParameterDescriptor;
            ValueParameterDescriptor valueParameterDescriptor2 = valueParameterDescriptor = iterator3.next();
            Intrinsics.checkExpressionValueIsNotNull(valueParameterDescriptor2, "valueParameterDescriptor");
            builder.addValueParameter(local.valueParameter(valueParameterDescriptor2));
        }
        if (this.serializeTypeTableToFunction && (typeTableProto = this.typeTable.serialize()) != null) {
            builder.setTypeTable(typeTableProto);
        }
        ProtoBuf.Function.Builder builder2 = builder;
        Intrinsics.checkExpressionValueIsNotNull(builder2, "builder");
        this.extension.serializeFunction(descriptor2, builder2);
        ProtoBuf.Function.Builder builder3 = builder;
        Intrinsics.checkExpressionValueIsNotNull(builder3, "builder");
        return builder3;
    }

    @NotNull
    public final ProtoBuf.Constructor.Builder constructorProto(@NotNull ConstructorDescriptor descriptor2) {
        Intrinsics.checkParameterIsNotNull(descriptor2, "descriptor");
        ProtoBuf.Constructor.Builder builder = ProtoBuf.Constructor.newBuilder();
        DescriptorSerializer local = this.createChildSerializer(descriptor2);
        int flags = Flags.getConstructorFlags(DescriptorSerializer.Companion.hasAnnotations(descriptor2), descriptor2.getVisibility(), !descriptor2.isPrimary());
        if (flags != builder.getFlags()) {
            builder.setFlags(flags);
        }
        Iterator<ValueParameterDescriptor> iterator2 = descriptor2.getValueParameters().iterator();
        while (iterator2.hasNext()) {
            ValueParameterDescriptor valueParameterDescriptor;
            ValueParameterDescriptor valueParameterDescriptor2 = valueParameterDescriptor = iterator2.next();
            Intrinsics.checkExpressionValueIsNotNull(valueParameterDescriptor2, "valueParameterDescriptor");
            builder.addValueParameter(local.valueParameter(valueParameterDescriptor2));
        }
        ProtoBuf.Constructor.Builder builder2 = builder;
        Intrinsics.checkExpressionValueIsNotNull(builder2, "builder");
        this.extension.serializeConstructor(descriptor2, builder2);
        ProtoBuf.Constructor.Builder builder3 = builder;
        Intrinsics.checkExpressionValueIsNotNull(builder3, "builder");
        return builder3;
    }

    @NotNull
    public final ProtoBuf.EnumEntry.Builder enumEntryProto(@NotNull ClassDescriptor descriptor2) {
        Intrinsics.checkParameterIsNotNull(descriptor2, "descriptor");
        ProtoBuf.EnumEntry.Builder builder = ProtoBuf.EnumEntry.newBuilder();
        Name name = descriptor2.getName();
        Intrinsics.checkExpressionValueIsNotNull(name, "descriptor.name");
        builder.setName(this.getSimpleNameIndex(name));
        ProtoBuf.EnumEntry.Builder builder2 = builder;
        Intrinsics.checkExpressionValueIsNotNull(builder2, "builder");
        this.extension.serializeEnumEntry(descriptor2, builder2);
        ProtoBuf.EnumEntry.Builder builder3 = builder;
        Intrinsics.checkExpressionValueIsNotNull(builder3, "builder");
        return builder3;
    }

    private final ProtoBuf.ValueParameter.Builder valueParameter(ValueParameterDescriptor descriptor2) {
        ProtoBuf.ValueParameter.Builder builder = ProtoBuf.ValueParameter.newBuilder();
        int flags = Flags.getValueParameterFlags(DescriptorSerializer.Companion.hasAnnotations(descriptor2), descriptor2.declaresDefaultValue(), descriptor2.isCrossinline(), descriptor2.isNoinline());
        if (flags != builder.getFlags()) {
            builder.setFlags(flags);
        }
        Name name = descriptor2.getName();
        Intrinsics.checkExpressionValueIsNotNull(name, "descriptor.name");
        builder.setName(this.getSimpleNameIndex(name));
        if (this.useTypeTable()) {
            KotlinType kotlinType = descriptor2.getType();
            Intrinsics.checkExpressionValueIsNotNull(kotlinType, "descriptor.type");
            builder.setTypeId(this.typeId(kotlinType));
        } else {
            KotlinType kotlinType = descriptor2.getType();
            Intrinsics.checkExpressionValueIsNotNull(kotlinType, "descriptor.type");
            builder.setType(this.type(kotlinType));
        }
        KotlinType varargElementType = descriptor2.getVarargElementType();
        if (varargElementType != null) {
            if (this.useTypeTable()) {
                builder.setVarargElementTypeId(this.typeId(varargElementType));
            } else {
                builder.setVarargElementType(this.type(varargElementType));
            }
        }
        ProtoBuf.ValueParameter.Builder builder2 = builder;
        Intrinsics.checkExpressionValueIsNotNull(builder2, "builder");
        this.extension.serializeValueParameter(descriptor2, builder2);
        ProtoBuf.ValueParameter.Builder builder3 = builder;
        Intrinsics.checkExpressionValueIsNotNull(builder3, "builder");
        return builder3;
    }

    private final ProtoBuf.TypeParameter.Builder typeParameter(TypeParameterDescriptor typeParameter) {
        ProtoBuf.TypeParameter.Builder builder = ProtoBuf.TypeParameter.newBuilder();
        builder.setId(this.getTypeParameterId(typeParameter));
        Name name = typeParameter.getName();
        Intrinsics.checkExpressionValueIsNotNull(name, "typeParameter.name");
        builder.setName(this.getSimpleNameIndex(name));
        if (typeParameter.isReified() != builder.getReified()) {
            builder.setReified(typeParameter.isReified());
        }
        Variance variance = typeParameter.getVariance();
        Intrinsics.checkExpressionValueIsNotNull((Object)variance, "typeParameter.variance");
        ProtoBuf.TypeParameter.Variance variance2 = DescriptorSerializer.Companion.variance(variance);
        if (Intrinsics.areEqual(variance2, builder.getVariance()) ^ true) {
            builder.setVariance(variance2);
        }
        ProtoBuf.TypeParameter.Builder builder2 = builder;
        Intrinsics.checkExpressionValueIsNotNull(builder2, "builder");
        this.extension.serializeTypeParameter(typeParameter, builder2);
        List<KotlinType> upperBounds = typeParameter.getUpperBounds();
        if (upperBounds.size() == 1 && KotlinBuiltIns.isDefaultBound(CollectionsKt.single(upperBounds))) {
            ProtoBuf.TypeParameter.Builder builder3 = builder;
            Intrinsics.checkExpressionValueIsNotNull(builder3, "builder");
            return builder3;
        }
        for (KotlinType upperBound : upperBounds) {
            if (this.useTypeTable()) {
                KotlinType kotlinType = upperBound;
                Intrinsics.checkExpressionValueIsNotNull(kotlinType, "upperBound");
                builder.addUpperBoundId(this.typeId(kotlinType));
                continue;
            }
            KotlinType kotlinType = upperBound;
            Intrinsics.checkExpressionValueIsNotNull(kotlinType, "upperBound");
            builder.addUpperBound(this.type(kotlinType));
        }
        ProtoBuf.TypeParameter.Builder builder4 = builder;
        Intrinsics.checkExpressionValueIsNotNull(builder4, "builder");
        return builder4;
    }

    private final int typeId(KotlinType type2) {
        return this.typeTable.get(this.type(type2));
    }

    private final ProtoBuf.Type.Builder type(KotlinType type2) {
        ProtoBuf.Type.Builder builder = ProtoBuf.Type.newBuilder();
        if (type2.isError()) {
            ProtoBuf.Type.Builder builder2 = builder;
            Intrinsics.checkExpressionValueIsNotNull(builder2, "builder");
            this.extension.serializeErrorType(type2, builder2);
            ProtoBuf.Type.Builder builder3 = builder;
            Intrinsics.checkExpressionValueIsNotNull(builder3, "builder");
            return builder3;
        }
        if (FlexibleTypesKt.isFlexible(type2)) {
            Flexibility flexibility = FlexibleTypesKt.flexibility(type2);
            ProtoBuf.Type.Builder lowerBound = this.type(flexibility.getLowerBound());
            lowerBound.setFlexibleTypeCapabilitiesId(this.getStringTable().getStringIndex(flexibility.getFactory().getId()));
            if (this.useTypeTable()) {
                lowerBound.setFlexibleUpperBoundId(this.typeId(flexibility.getUpperBound()));
            } else {
                lowerBound.setFlexibleUpperBound(this.type(flexibility.getUpperBound()));
            }
            return lowerBound;
        }
        ClassifierDescriptor descriptor2 = type2.getConstructor().getDeclarationDescriptor();
        ClassifierDescriptor classifierDescriptor = descriptor2;
        if (classifierDescriptor instanceof ClassDescriptor) {
            PossiblyInnerType possiblyInnerType = TypeParameterUtilsKt.buildPossiblyInnerType(type2);
            if (possiblyInnerType == null) {
                String string = "possiblyInnerType should not be null: " + type2;
                throw (Throwable)new IllegalStateException(string.toString());
            }
            PossiblyInnerType possiblyInnerType2 = possiblyInnerType;
            ProtoBuf.Type.Builder builder4 = builder;
            Intrinsics.checkExpressionValueIsNotNull(builder4, "builder");
            this.fillFromPossiblyInnerType(builder4, possiblyInnerType2);
        } else if (classifierDescriptor instanceof TypeParameterDescriptor) {
            if (((TypeParameterDescriptor)descriptor2).getContainingDeclaration() == this.containingDeclaration) {
                Name name = ((TypeParameterDescriptor)descriptor2).getName();
                Intrinsics.checkExpressionValueIsNotNull(name, "descriptor.name");
                builder.setTypeParameterName(this.getSimpleNameIndex(name));
            } else {
                builder.setTypeParameter(this.getTypeParameterId((TypeParameterDescriptor)descriptor2));
            }
            boolean bl = type2.getArguments().isEmpty();
            if (_Assertions.ENABLED && !bl) {
                String string = "Found arguments for type constructor build on type parameter: " + descriptor2;
                throw (Throwable)((Object)new AssertionError((Object)string));
            }
        }
        if (type2.isMarkedNullable() != builder.getNullable()) {
            builder.setNullable(type2.isMarkedNullable());
        }
        ProtoBuf.Type.Builder builder5 = builder;
        Intrinsics.checkExpressionValueIsNotNull(builder5, "builder");
        this.extension.serializeType(type2, builder5);
        ProtoBuf.Type.Builder builder6 = builder;
        Intrinsics.checkExpressionValueIsNotNull(builder6, "builder");
        return builder6;
    }

    private final void fillFromPossiblyInnerType(ProtoBuf.Type.Builder builder, PossiblyInnerType type2) {
        builder.setClassName(this.getClassId(type2.getClassDescriptor()));
        for (TypeProjection projection : type2.getArguments()) {
            builder.addArgument(this.typeArgument(projection));
        }
        if (type2.getOuterType() != null) {
            ProtoBuf.Type.Builder outerBuilder;
            ProtoBuf.Type.Builder builder2 = outerBuilder = ProtoBuf.Type.newBuilder();
            Intrinsics.checkExpressionValueIsNotNull(builder2, "outerBuilder");
            PossiblyInnerType possiblyInnerType = type2.getOuterType();
            if (possiblyInnerType == null) {
                Intrinsics.throwNpe();
            }
            this.fillFromPossiblyInnerType(builder2, possiblyInnerType);
            if (this.useTypeTable()) {
                ProtoBuf.Type.Builder builder3 = outerBuilder;
                Intrinsics.checkExpressionValueIsNotNull(builder3, "outerBuilder");
                builder.setOuterTypeId(this.typeTable.get(builder3));
            } else {
                builder.setOuterType(outerBuilder);
            }
        }
    }

    private final ProtoBuf.Type.Argument.Builder typeArgument(TypeProjection typeProjection) {
        ProtoBuf.Type.Argument.Builder builder = ProtoBuf.Type.Argument.newBuilder();
        if (typeProjection.isStarProjection()) {
            builder.setProjection(ProtoBuf.Type.Argument.Projection.STAR);
        } else {
            Variance variance = typeProjection.getProjectionKind();
            Intrinsics.checkExpressionValueIsNotNull((Object)variance, "typeProjection.projectionKind");
            ProtoBuf.Type.Argument.Projection projection = DescriptorSerializer.Companion.projection(variance);
            if (Intrinsics.areEqual(projection, builder.getProjection()) ^ true) {
                builder.setProjection(projection);
            }
            if (this.useTypeTable()) {
                KotlinType kotlinType = typeProjection.getType();
                Intrinsics.checkExpressionValueIsNotNull(kotlinType, "typeProjection.type");
                builder.setTypeId(this.typeId(kotlinType));
            } else {
                KotlinType kotlinType = typeProjection.getType();
                Intrinsics.checkExpressionValueIsNotNull(kotlinType, "typeProjection.type");
                builder.setType(this.type(kotlinType));
            }
        }
        ProtoBuf.Type.Argument.Builder builder2 = builder;
        Intrinsics.checkExpressionValueIsNotNull(builder2, "builder");
        return builder2;
    }

    /*
     * WARNING - void declaration
     */
    @JvmOverloads
    @NotNull
    public final ProtoBuf.Package.Builder packageProto(@NotNull Collection<? extends PackageFragmentDescriptor> fragments2, @Nullable Function1<? super DeclarationDescriptor, Boolean> skip2) {
        void destination$iv$iv;
        void $receiver$iv$iv;
        void $receiver$iv;
        Intrinsics.checkParameterIsNotNull(fragments2, "fragments");
        ProtoBuf.Package.Builder builder = ProtoBuf.Package.newBuilder();
        Iterable iterable = fragments2;
        Iterator iterator2 = $receiver$iv;
        Object object = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            PackageFragmentDescriptor fragment = (PackageFragmentDescriptor)element$iv$iv;
            Iterable list$iv$iv = DescriptorUtils.getAllDescriptors(fragment.getMemberScope());
            CollectionsKt.addAll(destination$iv$iv, list$iv$iv);
        }
        List members = (List)destination$iv$iv;
        for (DeclarationDescriptor declaration : Companion.sort(members)) {
            Boolean bl;
            Function1<? super DeclarationDescriptor, Boolean> function1 = skip2;
            if (function1 != null) {
                DeclarationDescriptor declarationDescriptor = declaration;
                Intrinsics.checkExpressionValueIsNotNull(declarationDescriptor, "declaration");
                bl = function1.invoke(declarationDescriptor);
            } else {
                bl = null;
            }
            if (Intrinsics.areEqual(bl, true)) continue;
            object = declaration;
            if (object instanceof PropertyDescriptor) {
                builder.addProperty(this.propertyProto((PropertyDescriptor)declaration));
                continue;
            }
            if (!(object instanceof FunctionDescriptor)) continue;
            builder.addFunction(this.functionProto((FunctionDescriptor)declaration));
        }
        ProtoBuf.TypeTable typeTableProto = this.typeTable.serialize();
        if (typeTableProto != null) {
            builder.setTypeTable(typeTableProto);
        }
        ProtoBuf.Package.Builder builder2 = builder;
        Intrinsics.checkExpressionValueIsNotNull(builder2, "builder");
        this.extension.serializePackage(builder2);
        ProtoBuf.Package.Builder builder3 = builder;
        Intrinsics.checkExpressionValueIsNotNull(builder3, "builder");
        return builder3;
    }

    @JvmOverloads
    @NotNull
    public static /* bridge */ /* synthetic */ ProtoBuf.Package.Builder packageProto$default(DescriptorSerializer descriptorSerializer, Collection collection, Function1 function1, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: packageProto");
        }
        if ((n & 2) != 0) {
            function1 = null;
        }
        return descriptorSerializer.packageProto(collection, function1);
    }

    @JvmOverloads
    @NotNull
    public ProtoBuf.Package.Builder packageProto(@NotNull Collection<? extends PackageFragmentDescriptor> fragments2) {
        return DescriptorSerializer.packageProto$default(this, fragments2, null, 2, null);
    }

    @NotNull
    public final ProtoBuf.Package.Builder packagePartProto(@NotNull Collection<? extends DeclarationDescriptor> members) {
        Intrinsics.checkParameterIsNotNull(members, "members");
        ProtoBuf.Package.Builder builder = ProtoBuf.Package.newBuilder();
        for (DeclarationDescriptor declarationDescriptor : Companion.sort(members)) {
            DeclarationDescriptor declarationDescriptor2 = declarationDescriptor;
            if (declarationDescriptor2 instanceof PropertyDescriptor) {
                builder.addProperty(this.propertyProto((PropertyDescriptor)declarationDescriptor));
                continue;
            }
            if (!(declarationDescriptor2 instanceof FunctionDescriptor)) continue;
            builder.addFunction(this.functionProto((FunctionDescriptor)declarationDescriptor));
        }
        ProtoBuf.TypeTable typeTable = this.typeTable.serialize();
        if (typeTable != null) {
            builder.setTypeTable(typeTable);
        }
        ProtoBuf.Package.Builder builder2 = builder;
        Intrinsics.checkExpressionValueIsNotNull(builder2, "builder");
        this.extension.serializePackage(builder2);
        ProtoBuf.Package.Builder builder3 = builder;
        Intrinsics.checkExpressionValueIsNotNull(builder3, "builder");
        return builder3;
    }

    private final int getClassId(ClassDescriptor descriptor2) {
        return this.getStringTable().getFqNameIndex(descriptor2);
    }

    private final int getSimpleNameIndex(Name name) {
        StringTable stringTable = this.getStringTable();
        String string = name.asString();
        Intrinsics.checkExpressionValueIsNotNull(string, "name.asString()");
        return stringTable.getStringIndex(string);
    }

    private final int getTypeParameterId(TypeParameterDescriptor descriptor2) {
        return this.typeParameters.intern(descriptor2);
    }

    private DescriptorSerializer(DeclarationDescriptor containingDeclaration, Interner<TypeParameterDescriptor> typeParameters, SerializerExtension extension, MutableTypeTable typeTable, boolean serializeTypeTableToFunction) {
        this.containingDeclaration = containingDeclaration;
        this.typeParameters = typeParameters;
        this.extension = extension;
        this.typeTable = typeTable;
        this.serializeTypeTableToFunction = serializeTypeTableToFunction;
    }

    public /* synthetic */ DescriptorSerializer(@Nullable DeclarationDescriptor containingDeclaration, @NotNull Interner typeParameters, @NotNull SerializerExtension extension, @NotNull MutableTypeTable typeTable, boolean serializeTypeTableToFunction, DefaultConstructorMarker $constructor_marker) {
        this(containingDeclaration, typeParameters, extension, typeTable, serializeTypeTableToFunction);
    }

    @JvmStatic
    @NotNull
    public static final DescriptorSerializer createTopLevel(@NotNull SerializerExtension extension) {
        Intrinsics.checkParameterIsNotNull(extension, "extension");
        return Companion.createTopLevel(extension);
    }

    @JvmStatic
    @NotNull
    public static final DescriptorSerializer createForLambda(@NotNull SerializerExtension extension) {
        Intrinsics.checkParameterIsNotNull(extension, "extension");
        return Companion.createForLambda(extension);
    }

    @JvmStatic
    @NotNull
    public static final DescriptorSerializer create(@NotNull ClassDescriptor descriptor2, @NotNull SerializerExtension extension) {
        Intrinsics.checkParameterIsNotNull(descriptor2, "descriptor");
        Intrinsics.checkParameterIsNotNull(extension, "extension");
        return Companion.create(descriptor2, extension);
    }

    @Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0007J\u0010\u0010\t\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\bH\u0007J\u0010\u0010\n\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\bH\u0007J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0005\u001a\u00020\u0011H\u0002J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J$\u0010\u0016\u001a\b\u0012\u0004\u0012\u0002H\u00180\u0017\"\b\b\u0000\u0010\u0018*\u00020\u00192\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u0002H\u00180\u001bJ\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001c\u001a\u00020\u0015H\u0002\u00a8\u0006\u001e"}, d2={"Lorg/jetbrains/kotlin/serialization/DescriptorSerializer$Companion;", "", "()V", "create", "Lorg/jetbrains/kotlin/serialization/DescriptorSerializer;", "descriptor", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "extension", "Lorg/jetbrains/kotlin/serialization/SerializerExtension;", "createForLambda", "createTopLevel", "getAccessorFlags", "", "accessor", "Lorg/jetbrains/kotlin/descriptors/PropertyAccessorDescriptor;", "hasAnnotations", "", "Lorg/jetbrains/kotlin/descriptors/annotations/Annotated;", "projection", "Lorg/jetbrains/kotlin/serialization/ProtoBuf$Type$Argument$Projection;", "projectionKind", "Lorg/jetbrains/kotlin/types/Variance;", "sort", "", "T", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "descriptors", "", "variance", "Lorg/jetbrains/kotlin/serialization/ProtoBuf$TypeParameter$Variance;", "kotlin-compiler"})
    public static final class Companion {
        @JvmStatic
        @NotNull
        public final DescriptorSerializer createTopLevel(@NotNull SerializerExtension extension) {
            Intrinsics.checkParameterIsNotNull(extension, "extension");
            return new DescriptorSerializer(null, new Interner(), extension, new MutableTypeTable(), false, null);
        }

        @JvmStatic
        @NotNull
        public final DescriptorSerializer createForLambda(@NotNull SerializerExtension extension) {
            Intrinsics.checkParameterIsNotNull(extension, "extension");
            return new DescriptorSerializer(null, new Interner(), extension, new MutableTypeTable(), true, null);
        }

        @JvmStatic
        @NotNull
        public final DescriptorSerializer create(@NotNull ClassDescriptor descriptor2, @NotNull SerializerExtension extension) {
            DescriptorSerializer descriptorSerializer;
            Intrinsics.checkParameterIsNotNull(descriptor2, "descriptor");
            Intrinsics.checkParameterIsNotNull(extension, "extension");
            DeclarationDescriptor container = descriptor2.getContainingDeclaration();
            if (container instanceof ClassDescriptor) {
                ClassDescriptor classDescriptor = (ClassDescriptor)container;
                Intrinsics.checkExpressionValueIsNotNull(classDescriptor, "container");
                descriptorSerializer = this.create(classDescriptor, extension);
            } else {
                descriptorSerializer = this.createTopLevel(extension);
            }
            DescriptorSerializer parentSerializer = descriptorSerializer;
            DescriptorSerializer serializer = new DescriptorSerializer(descriptor2, new Interner(parentSerializer.typeParameters), parentSerializer.extension, new MutableTypeTable(), false, null);
            for (TypeParameterDescriptor typeParameter : descriptor2.getDeclaredTypeParameters()) {
                serializer.typeParameters.intern(typeParameter);
            }
            return serializer;
        }

        private final int getAccessorFlags(PropertyAccessorDescriptor accessor) {
            return Flags.getAccessorFlags(this.hasAnnotations(accessor), accessor.getVisibility(), accessor.getModality(), !accessor.isDefault(), accessor.isExternal());
        }

        private final ProtoBuf.TypeParameter.Variance variance(Variance variance) {
            ProtoBuf.TypeParameter.Variance variance2;
            switch (DescriptorSerializer$Companion$WhenMappings.$EnumSwitchMapping$0[variance.ordinal()]) {
                case 1: {
                    variance2 = ProtoBuf.TypeParameter.Variance.INV;
                    break;
                }
                case 2: {
                    variance2 = ProtoBuf.TypeParameter.Variance.IN;
                    break;
                }
                case 3: {
                    variance2 = ProtoBuf.TypeParameter.Variance.OUT;
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            return variance2;
        }

        private final ProtoBuf.Type.Argument.Projection projection(Variance projectionKind) {
            ProtoBuf.Type.Argument.Projection projection;
            switch (DescriptorSerializer$Companion$WhenMappings.$EnumSwitchMapping$1[projectionKind.ordinal()]) {
                case 1: {
                    projection = ProtoBuf.Type.Argument.Projection.INV;
                    break;
                }
                case 2: {
                    projection = ProtoBuf.Type.Argument.Projection.IN;
                    break;
                }
                case 3: {
                    projection = ProtoBuf.Type.Argument.Projection.OUT;
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            return projection;
        }

        private final boolean hasAnnotations(Annotated descriptor2) {
            return !descriptor2.getAnnotations().isEmpty();
        }

        @NotNull
        public final <T extends DeclarationDescriptor> List<T> sort(@NotNull Collection<? extends T> descriptors) {
            Intrinsics.checkParameterIsNotNull(descriptors, "descriptors");
            ArrayList<? extends T> arrayList = new ArrayList<T>(descriptors);
            ArrayList<? extends T> $receiver = arrayList;
            Collections.sort((List)$receiver, MemberComparator.INSTANCE);
            return arrayList;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

