/*
 * Decompiled with CFR 0.152.
 */
package org.encog.neural.pattern;

import org.encog.engine.network.activation.ActivationFunction;
import org.encog.ml.MLMethod;
import org.encog.neural.pattern.NeuralNetworkPattern;
import org.encog.neural.pattern.PatternError;
import org.encog.neural.thermal.BoltzmannMachine;

public class BoltzmannPattern
implements NeuralNetworkPattern {
    private int neuronCount;
    private int annealCycles = 100;
    private int runCycles = 1000;
    private double temperature = 0.0;

    @Override
    public void addHiddenLayer(int count) {
        throw new PatternError("A Boltzmann network has no hidden layers.");
    }

    @Override
    public void clear() {
        this.neuronCount = 0;
    }

    @Override
    public MLMethod generate() {
        BoltzmannMachine boltz = new BoltzmannMachine(this.neuronCount);
        boltz.setTemperature(this.temperature);
        boltz.setRunCycles(this.runCycles);
        boltz.setAnnealCycles(this.annealCycles);
        return boltz;
    }

    public int getAnnealCycles() {
        return this.annealCycles;
    }

    public int getRunCycles() {
        return this.runCycles;
    }

    public double getTemperature() {
        return this.temperature;
    }

    @Override
    public void setActivationFunction(ActivationFunction activation) {
        throw new PatternError("A Boltzmann network will use the BiPolar activation function, no activation function needs to be specified.");
    }

    public void setAnnealCycles(int annealCycles) {
        this.annealCycles = annealCycles;
    }

    @Override
    public void setInputNeurons(int count) {
        this.neuronCount = count;
    }

    @Override
    public void setOutputNeurons(int count) {
        this.neuronCount = count;
    }

    public void setRunCycles(int runCycles) {
        this.runCycles = runCycles;
    }

    public void setTemperature(double temperature) {
        this.temperature = temperature;
    }
}

