/****************************************************************************
**
*W  objccoll.h                  GAP source                      Werner Nickel
**
**
*Y  (C) 1998 School Math and Comp. Sci., University of St Andrews, Scotland
*Y  Copyright (C) 2002 The GAP Group
*/

#ifndef libGAP_GAP_OBJCCOLL_H
#define libGAP_GAP_OBJCCOLL_H

/****************************************************************************
**

*D  SCP_SOMETHING . . . . . . . . . . . . . . .  for combinatorial collectors
**
**  Definitions which are needed by the combinatorial collectors in addition
**  to those made for single collectors.
*/
#define libGAP_SCP_WEIGHTS        libGAP_SCP_LAST+1   /* weight in a combi collector     */
#define libGAP_SCP_CLASS          libGAP_SCP_LAST+2   /* p-class in a combi collector    */
#define libGAP_SCP_AVECTOR2       libGAP_SCP_LAST+3   /* avector                         */

/****************************************************************************
**

*D  SC_SOMETHING( <sc> )  . . . . . . . . . . .  for combinatorial collectors
**
*/
#define libGAP_SC_CLASS(sc) \
    (libGAP_ADDR_OBJ(sc)[libGAP_SCP_CLASS])

#define libGAP_SC_WEIGHTS(sc) \
    (libGAP_ADDR_OBJ(sc)[libGAP_SCP_WEIGHTS])

#define libGAP_SC_AVECTOR2(sc) \
    (libGAP_ADDR_OBJ(sc)[libGAP_SCP_AVECTOR2])


/****************************************************************************
**
**  Here we declare the combinatorial collector  functions.  Pointer to those
**  functions  are  put into  the   relevant  data structures in  the  single
**  collector module.   Therefore,  the  single  collector  module needs   to
**  include this file.
*/
libGAP_Int libGAP_C8Bits_CombiCollectWord ( libGAP_Obj, libGAP_Obj, libGAP_Obj );
libGAP_Int libGAP_C16Bits_CombiCollectWord ( libGAP_Obj, libGAP_Obj, libGAP_Obj );
libGAP_Int libGAP_C32Bits_CombiCollectWord ( libGAP_Obj, libGAP_Obj, libGAP_Obj );


/****************************************************************************
**

*F * * * * * * * * * * * * * initialize package * * * * * * * * * * * * * * *
*/


/****************************************************************************
**

*F  InitInfoCombiCollector()  . . . . . . . . . . . . table of init functions
*/

libGAP_StructInitInfo * libGAP_InitInfoCombiCollector ( void );


#endif // GAP_OBJCCOLL_H

/****************************************************************************
**

*E  objccoll.h  . . . . . . . . . . . . . . . . . . . . . . . . . . ends here
*/
