/*
 * Decompiled with CFR 0.152.
 */
package com.baselet.gui;

import com.baselet.control.Main;
import com.baselet.control.config.Config;
import com.baselet.control.enums.Program;
import com.baselet.custom.CustomElementPanel;
import com.baselet.diagram.CurrentDiagram;
import com.baselet.diagram.PaletteHandler;
import com.baselet.element.old.custom.CustomElementHandler;
import com.baselet.gui.MailPanel;
import com.baselet.gui.listener.DividerListener;
import com.baselet.gui.listener.PaletteComboBoxListener;
import com.baselet.gui.listener.PropertyPanelListener;
import com.baselet.gui.pane.OwnSyntaxPane;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.plaf.basic.BasicSplitPaneUI;

public abstract class BaseGUIBuilder {
    private JPanel palettePanel;
    private CardLayout palettePanelLayout;
    private JSplitPane rightSplit;
    private JComboBox paletteList;
    private CustomElementHandler customHandler;
    private JSplitPane mainSplit;
    private MailPanel mailPanel;
    private JSplitPane customSplit;
    private JSplitPane mailSplit;
    private JPanel rightPanel;
    private OwnSyntaxPane propertyTextPane;

    protected JSplitPane initBase(Component mainComponent, final int mainDividerLoc) {
        this.propertyTextPane = this.createPropertyTextPane();
        this.palettePanel = this.newPalettePanel();
        this.rightSplit = this.newGenericSplitPane(0, this.palettePanel, this.propertyTextPane.getPanel(), 2, Config.getInstance().getRight_split_position(), true);
        this.rightPanel = this.newRightPanel();
        this.mainSplit = this.newGenericSplitPane(1, mainComponent, this.rightPanel, 2, mainDividerLoc, true);
        ((BasicSplitPaneUI)this.mainSplit.getUI()).getDivider().addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    BaseGUIBuilder.this.rightPanel.setVisible(!BaseGUIBuilder.this.rightPanel.isVisible());
                    BaseGUIBuilder.this.mainSplit.setDividerLocation(mainDividerLoc);
                }
            }
        });
        this.customHandler = new CustomElementHandler();
        this.customHandler.getPanel().setVisible(false);
        this.customSplit = this.newGenericSplitPane(0, this.mainSplit, this.getCustomPanel(), 0, 0, true);
        this.mailPanel = new MailPanel();
        this.mailPanel.setVisible(false);
        this.mailSplit = this.newGenericSplitPane(0, this.mailPanel, this.customSplit, 0, 0, true);
        return this.mailSplit;
    }

    public JSplitPane getMailSplit() {
        return this.mailSplit;
    }

    public JSplitPane getCustomSplit() {
        return this.customSplit;
    }

    public MailPanel getMailPanel() {
        return this.mailPanel;
    }

    public JSplitPane getMainSplit() {
        return this.mainSplit;
    }

    public JPanel getPalettePanel() {
        return this.palettePanel;
    }

    public JComboBox getPaletteList() {
        return this.paletteList;
    }

    public JSplitPane getRightSplit() {
        return this.rightSplit;
    }

    public CustomElementHandler getCustomHandler() {
        return this.customHandler;
    }

    public CustomElementPanel getCustomPanel() {
        return this.customHandler.getPanel();
    }

    public JPanel newPalettePanel() {
        this.palettePanelLayout = new CardLayout();
        JPanel palettePanel = new JPanel(this.palettePanelLayout);
        palettePanel.addComponentListener(new DividerListener());
        for (PaletteHandler palette : Main.getInstance().getPalettes().values()) {
            palettePanel.add((Component)palette.getDrawPanel().getScrollPane(), palette.getName());
        }
        return palettePanel;
    }

    public JSplitPane newGenericSplitPane(int newOrientation, Component newLeftComponent, Component newRightComponent, int dividerSize, int dividerLocation, boolean visible) {
        JSplitPane pane = new JSplitPane(newOrientation, newLeftComponent, newRightComponent);
        pane.setDividerSize(dividerSize);
        pane.setDividerLocation(dividerLocation);
        pane.setResizeWeight(1.0);
        pane.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0), 0));
        pane.setAlignmentX(1.0f);
        pane.setVisible(visible);
        return pane;
    }

    private JPanel newRightPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 1));
        this.rightSplit.setAlignmentX(0.5f);
        panel.add(this.newPaletteControlsPanel());
        panel.add(this.rightSplit);
        return panel;
    }

    private JPanel newPaletteControlsPanel() {
        this.createPaletteList();
        JPanel paletteControlsPanel = new JPanel();
        paletteControlsPanel.setLayout(new BoxLayout(paletteControlsPanel, 0));
        paletteControlsPanel.add(this.paletteList);
        return paletteControlsPanel;
    }

    public void createPaletteList() {
        this.paletteList = new JComboBox();
        this.paletteList.setMaximumRowCount(15);
        this.paletteList.setAlignmentX(0.5f);
        for (PaletteHandler palette : Main.getInstance().getPalettes().values()) {
            this.paletteList.addItem(palette.getName());
        }
        PaletteComboBoxListener pl = new PaletteComboBoxListener();
        this.paletteList.addActionListener(pl);
        this.paletteList.addMouseWheelListener(pl);
        String lastUsedPalette = Config.getInstance().getLastUsedPalette();
        if (Program.getInstance().getVersion().equals(Config.getInstance().getProgramVersion()) && lastUsedPalette != null) {
            this.paletteList.setSelectedItem(lastUsedPalette);
        }
    }

    private OwnSyntaxPane createPropertyTextPane() {
        OwnSyntaxPane propertyTextPane = new OwnSyntaxPane();
        PropertyPanelListener pListener = new PropertyPanelListener();
        propertyTextPane.getTextComponent().addKeyListener(pListener);
        propertyTextPane.getTextComponent().getDocument().addDocumentListener(pListener);
        return propertyTextPane;
    }

    public OwnSyntaxPane getPropertyTextPane() {
        return this.propertyTextPane;
    }

    public void setMailPanelEnabled(boolean enable) {
        this.getMailPanel().setVisible(enable);
        if (enable) {
            int mailDividerLoc = Math.max(250, Config.getInstance().getMail_split_position());
            this.mailSplit.setDividerLocation(mailDividerLoc);
            this.mailSplit.setDividerSize(2);
        } else {
            this.mailSplit.setDividerSize(0);
        }
    }

    public void setCustomPanelEnabled(boolean enable) {
        CustomElementPanel customPanel = this.getCustomPanel();
        if (customPanel.isVisible() != enable) {
            int loc = this.getMainSplit().getDividerLocation();
            customPanel.setVisible(enable);
            if (enable) {
                int rightloc = this.getRightSplit().getDividerLocation();
                this.getCustomSplit().setDividerSize(2);
                this.getRightSplit().setDividerSize(0);
                customPanel.getLeftSplit().setLeftComponent(this.propertyTextPane.getPanel());
                this.getCustomSplit().setDividerLocation(rightloc);
                customPanel.getRightSplit().setDividerLocation(loc);
                customPanel.getLeftSplit().setDividerLocation(CurrentDiagram.getInstance().getDiagramHandler().getDrawPanel().getWidth() / 2);
                customPanel.getLeftSplit().updateUI();
            } else {
                int rightloc = this.getCustomSplit().getDividerLocation();
                this.getCustomSplit().setDividerSize(0);
                this.getRightSplit().setDividerSize(2);
                this.getRightSplit().setRightComponent(this.propertyTextPane.getPanel());
                this.getRightSplit().setDividerLocation(rightloc);
            }
            this.getMainSplit().setDividerLocation(loc);
        }
    }

    public void setPaletteActive(String paletteName) {
        this.palettePanelLayout.show(this.palettePanel, paletteName);
    }
}

