/*
 * Decompiled with CFR 0.152.
 */
package com.baselet.element.elementnew.plot.parser;

import com.baselet.diagram.draw.DrawHandler;
import com.baselet.element.elementnew.plot.parser.KeyValue;
import com.baselet.element.elementnew.plot.parser.PlotState;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class ParserResult {
    private DrawHandler drawer;
    private final ArrayList<PlotState> plotStateList = new ArrayList();
    private final HashMap<String, KeyValue> plotGridValues = new HashMap();

    public void setDrawer(DrawHandler drawer) {
        this.drawer = drawer;
    }

    public DrawHandler getDrawer() {
        return this.drawer;
    }

    public ArrayList<PlotState> getPlotStateList() {
        return this.plotStateList;
    }

    public String getPlotGridValue(String key, String defaultValue) {
        KeyValue keyValue = this.plotGridValues.get(key);
        if (keyValue != null) {
            keyValue.setUsed(true);
        }
        if (keyValue == null || keyValue.getValue().equals("auto")) {
            return defaultValue;
        }
        return keyValue.getValue();
    }

    protected void addPlotState(PlotState plotState) {
        this.plotStateList.add(plotState);
    }

    protected void addPlotGridValue(String key, KeyValue value) {
        this.plotGridValues.put(key, value);
    }

    protected void removePlotGridValue(String key) {
        this.plotGridValues.remove(key);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("\n-----------------------------\n");
        sb.append("--------PARSER CONTENT-------\n");
        sb.append("-----------------------------\n\n");
        sb.append("##########PlotStates#########\n\n");
        for (PlotState plotState : this.plotStateList) {
            sb.append(plotState.toString()).append("\n");
        }
        sb.append("#########PlotGridValues########\n\n");
        for (Map.Entry entry : this.plotGridValues.entrySet()) {
            sb.append("\t").append((String)entry.getKey()).append(" -> ").append(entry.getValue()).append("\n");
        }
        sb.append("\n-----------------------------\n");
        sb.append("-----------------------------\n");
        return sb.toString();
    }
}

