/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.ext.awt.image.renderable;

import java.awt.Composite;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.RenderContext;
import org.apache.batik.ext.awt.image.GraphicsUtil;
import org.apache.batik.ext.awt.image.PadMode;
import org.apache.batik.ext.awt.image.SVGComposite;
import org.apache.batik.ext.awt.image.renderable.AbstractRable;
import org.apache.batik.ext.awt.image.renderable.Filter;
import org.apache.batik.ext.awt.image.renderable.FilterChainRable;
import org.apache.batik.ext.awt.image.renderable.FilterResRable;
import org.apache.batik.ext.awt.image.renderable.FilterResRable8Bit;
import org.apache.batik.ext.awt.image.renderable.PadRable;
import org.apache.batik.ext.awt.image.renderable.PadRable8Bit;
import org.apache.batik.ext.awt.image.renderable.PaintRable;

public class FilterChainRable8Bit
extends AbstractRable
implements FilterChainRable,
PaintRable {
    private int filterResolutionX;
    private int filterResolutionY;
    private Filter chainSource;
    private FilterResRable filterRes;
    private PadRable crop;
    private Rectangle2D filterRegion;

    public FilterChainRable8Bit(Filter filter, Rectangle2D rectangle2D) {
        if (filter == null) {
            throw new IllegalArgumentException();
        }
        if (rectangle2D == null) {
            throw new IllegalArgumentException();
        }
        Rectangle2D rectangle2D2 = (Rectangle2D)rectangle2D.clone();
        this.crop = new PadRable8Bit(filter, rectangle2D2, PadMode.ZERO_PAD);
        this.chainSource = filter;
        this.filterRegion = rectangle2D;
        this.init(this.crop);
    }

    @Override
    public int getFilterResolutionX() {
        return this.filterResolutionX;
    }

    @Override
    public void setFilterResolutionX(int n) {
        this.touch();
        this.filterResolutionX = n;
        this.setupFilterRes();
    }

    @Override
    public int getFilterResolutionY() {
        return this.filterResolutionY;
    }

    @Override
    public void setFilterResolutionY(int n) {
        this.touch();
        this.filterResolutionY = n;
        this.setupFilterRes();
    }

    private void setupFilterRes() {
        if (this.filterResolutionX >= 0) {
            if (this.filterRes == null) {
                this.filterRes = new FilterResRable8Bit();
                this.filterRes.setSource(this.chainSource);
            }
            this.filterRes.setFilterResolutionX(this.filterResolutionX);
            this.filterRes.setFilterResolutionY(this.filterResolutionY);
        } else {
            this.filterRes = null;
        }
        if (this.filterRes != null) {
            this.crop.setSource(this.filterRes);
        } else {
            this.crop.setSource(this.chainSource);
        }
    }

    @Override
    public void setFilterRegion(Rectangle2D rectangle2D) {
        if (rectangle2D == null) {
            throw new IllegalArgumentException();
        }
        this.touch();
        this.filterRegion = rectangle2D;
    }

    @Override
    public Rectangle2D getFilterRegion() {
        return this.filterRegion;
    }

    @Override
    public Filter getSource() {
        return this.crop;
    }

    @Override
    public void setSource(Filter filter) {
        if (filter == null) {
            throw new IllegalArgumentException("Null Source for Filter Chain");
        }
        this.touch();
        this.chainSource = filter;
        if (this.filterRes == null) {
            this.crop.setSource(filter);
        } else {
            this.filterRes.setSource(filter);
        }
    }

    @Override
    public Rectangle2D getBounds2D() {
        return (Rectangle2D)this.filterRegion.clone();
    }

    @Override
    public boolean paintRable(Graphics2D graphics2D) {
        Composite composite = graphics2D.getComposite();
        if (!SVGComposite.OVER.equals(composite)) {
            return false;
        }
        GraphicsUtil.drawImage(graphics2D, this.getSource());
        return true;
    }

    @Override
    public RenderedImage createRendering(RenderContext renderContext) {
        return this.crop.createRendering(renderContext);
    }
}

