/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.ext.awt.image.rendered;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.DataBufferInt;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.SinglePixelPackedSampleModel;
import java.awt.image.WritableRaster;
import org.apache.batik.ext.awt.image.GraphicsUtil;
import org.apache.batik.ext.awt.image.rendered.AbstractRed;
import org.apache.batik.ext.awt.image.rendered.AbstractTiledRed;
import org.apache.batik.ext.awt.image.rendered.CachableRed;
import org.apache.batik.ext.awt.image.rendered.TileCacheRed;
import org.apache.batik.ext.awt.image.rendered.TileGenerator;
import org.apache.batik.ext.awt.image.rendered.TileStore;
import org.apache.batik.util.HaltingThread;

public class TileRed
extends AbstractRed
implements TileGenerator {
    static final AffineTransform IDENTITY = new AffineTransform();
    Rectangle tiledRegion;
    int xStep;
    int yStep;
    TileStore tiles;
    private RenderingHints hints;
    final boolean is_INT_PACK;
    RenderedImage tile = null;
    WritableRaster raster = null;

    public TileRed(RenderedImage renderedImage, Rectangle rectangle) {
        this(renderedImage, rectangle, renderedImage.getWidth(), renderedImage.getHeight(), null);
    }

    public TileRed(RenderedImage renderedImage, Rectangle rectangle, RenderingHints renderingHints) {
        this(renderedImage, rectangle, renderedImage.getWidth(), renderedImage.getHeight(), renderingHints);
    }

    public TileRed(RenderedImage renderedImage, Rectangle rectangle, int n, int n2) {
        this(renderedImage, rectangle, n, n2, null);
    }

    public TileRed(RenderedImage renderedImage, Rectangle rectangle, int n, int n2, RenderingHints renderingHints) {
        if (rectangle == null) {
            throw new IllegalArgumentException();
        }
        if (renderedImage == null) {
            throw new IllegalArgumentException();
        }
        this.tiledRegion = rectangle;
        this.xStep = n;
        this.yStep = n2;
        this.hints = renderingHints;
        SampleModel sampleModel = TileRed.fixSampleModel(renderedImage, n, n2, rectangle.width, rectangle.height);
        ColorModel colorModel = renderedImage.getColorModel();
        double d = AbstractTiledRed.getDefaultTileSize();
        double d2 = (double)n * (double)n2;
        if (16.1 * (d *= d) > d2) {
            int n3 = n;
            int n4 = n2;
            if (4.0 * d2 <= d) {
                int n5 = (int)Math.ceil(Math.sqrt(d / d2));
                n3 *= n5;
                n4 *= n5;
            }
            sampleModel = sampleModel.createCompatibleSampleModel(n3, n4);
            this.raster = Raster.createWritableRaster(sampleModel, new Point(renderedImage.getMinX(), renderedImage.getMinY()));
        }
        this.is_INT_PACK = GraphicsUtil.is_INT_PACK_Data(sampleModel, false);
        this.init((CachableRed)null, rectangle, colorModel, sampleModel, renderedImage.getMinX(), renderedImage.getMinY(), null);
        if (this.raster != null) {
            WritableRaster writableRaster = this.raster.createWritableChild(renderedImage.getMinX(), renderedImage.getMinY(), n, n2, renderedImage.getMinX(), renderedImage.getMinY(), null);
            this.fillRasterFrom(writableRaster, renderedImage);
            this.fillOutRaster(this.raster);
        } else {
            this.tile = new TileCacheRed(GraphicsUtil.wrap(renderedImage));
        }
    }

    @Override
    public WritableRaster copyData(WritableRaster writableRaster) {
        int n = (int)Math.floor(writableRaster.getMinX() / this.xStep) * this.xStep;
        int n2 = (int)Math.floor(writableRaster.getMinY() / this.yStep) * this.yStep;
        int n3 = writableRaster.getMinX() - n;
        int n4 = writableRaster.getMinY() - n2;
        int n5 = this.getXTile(n3);
        int n6 = this.getYTile(n4);
        int n7 = this.getXTile(n3 + writableRaster.getWidth() - 1);
        int n8 = this.getYTile(n4 + writableRaster.getHeight() - 1);
        for (int i = n6; i <= n8; ++i) {
            for (int j = n5; j <= n7; ++j) {
                Raster raster = this.getTile(j, i);
                raster = raster.createChild(raster.getMinX(), raster.getMinY(), raster.getWidth(), raster.getHeight(), raster.getMinX() + n, raster.getMinY() + n2, null);
                if (this.is_INT_PACK) {
                    GraphicsUtil.copyData_INT_PACK(raster, writableRaster);
                    continue;
                }
                GraphicsUtil.copyData_FALLBACK(raster, writableRaster);
            }
        }
        return writableRaster;
    }

    @Override
    public Raster getTile(int n, int n2) {
        if (this.raster != null) {
            int n3 = this.tileGridXOff + n * this.tileWidth;
            int n4 = this.tileGridYOff + n2 * this.tileHeight;
            return this.raster.createTranslatedChild(n3, n4);
        }
        return this.genTile(n, n2);
    }

    @Override
    public Raster genTile(int n, int n2) {
        int n3 = this.tileGridXOff + n * this.tileWidth;
        int n4 = this.tileGridYOff + n2 * this.tileHeight;
        if (this.raster != null) {
            return this.raster.createTranslatedChild(n3, n4);
        }
        Point point = new Point(n3, n4);
        WritableRaster writableRaster = Raster.createWritableRaster(this.sm, point);
        this.fillRasterFrom(writableRaster, this.tile);
        return writableRaster;
    }

    public WritableRaster fillRasterFrom(WritableRaster writableRaster, RenderedImage renderedImage) {
        ColorModel colorModel = this.getColorModel();
        BufferedImage bufferedImage = new BufferedImage(colorModel, writableRaster.createWritableTranslatedChild(0, 0), colorModel.isAlphaPremultiplied(), null);
        Graphics2D graphics2D = GraphicsUtil.createGraphics(bufferedImage, this.hints);
        int n = writableRaster.getMinX();
        int n2 = writableRaster.getMinY();
        int n3 = writableRaster.getWidth();
        int n4 = writableRaster.getHeight();
        graphics2D.setComposite(AlphaComposite.Clear);
        graphics2D.setColor(new Color(0, 0, 0, 0));
        graphics2D.fillRect(0, 0, n3, n4);
        graphics2D.setComposite(AlphaComposite.SrcOver);
        graphics2D.translate(-n, -n2);
        int n5 = renderedImage.getMinX() + renderedImage.getWidth() - 1;
        int n6 = renderedImage.getMinY() + renderedImage.getHeight() - 1;
        int n7 = (int)Math.ceil((n - n5) / this.xStep) * this.xStep;
        int n8 = (int)Math.ceil((n2 - n6) / this.yStep) * this.yStep;
        graphics2D.translate(n7, n8);
        int n9 = n7 - writableRaster.getMinX() + renderedImage.getMinX();
        n = n9;
        for (int i = n8 - writableRaster.getMinY() + renderedImage.getMinY(); i < n4; i += this.yStep) {
            if (HaltingThread.hasBeenHalted()) {
                return writableRaster;
            }
            while (n9 < n3) {
                GraphicsUtil.drawImage(graphics2D, renderedImage);
                n9 += this.xStep;
                graphics2D.translate(this.xStep, 0);
            }
            graphics2D.translate(n - n9, this.yStep);
            n9 = n;
        }
        return writableRaster;
    }

    protected void fillOutRaster(WritableRaster writableRaster) {
        if (this.is_INT_PACK) {
            this.fillOutRaster_INT_PACK(writableRaster);
        } else {
            this.fillOutRaster_FALLBACK(writableRaster);
        }
    }

    protected void fillOutRaster_INT_PACK(WritableRaster writableRaster) {
        int n;
        int n2;
        int n3 = writableRaster.getMinX();
        int n4 = writableRaster.getMinY();
        int n5 = writableRaster.getWidth();
        int n6 = writableRaster.getHeight();
        SinglePixelPackedSampleModel singlePixelPackedSampleModel = (SinglePixelPackedSampleModel)writableRaster.getSampleModel();
        int n7 = singlePixelPackedSampleModel.getScanlineStride();
        DataBufferInt dataBufferInt = (DataBufferInt)writableRaster.getDataBuffer();
        int[] nArray = dataBufferInt.getBankData()[0];
        int n8 = dataBufferInt.getOffset() + singlePixelPackedSampleModel.getOffset(n3 - writableRaster.getSampleModelTranslateX(), n4 - writableRaster.getSampleModelTranslateY());
        int n9 = this.xStep;
        int n10 = this.xStep;
        while (n10 < n5) {
            int n11;
            int n12;
            n2 = n9;
            if (n10 + n2 > n5) {
                n2 = n5 - n10;
            }
            if (n2 >= 128) {
                n = n8;
                n12 = n8 + n10;
                for (n11 = 0; n11 < this.yStep; ++n11) {
                    System.arraycopy(nArray, n, nArray, n12, n2);
                    n += n7;
                    n12 += n7;
                }
            } else {
                n = n8;
                n12 = n8 + n10;
                for (n11 = 0; n11 < this.yStep; ++n11) {
                    int n13 = n;
                    n += n2 - 1;
                    n12 += n2 - 1;
                    while (n >= n13) {
                        nArray[n12--] = nArray[n--];
                    }
                    n += n7 + 1;
                    n12 += n7 + 1;
                }
            }
            n10 += n9;
            n9 *= 2;
        }
        n9 = this.yStep;
        n10 = this.yStep;
        while (n10 < n6) {
            n2 = n9;
            if (n10 + n2 > n6) {
                n2 = n6 - n10;
            }
            n = n8 + n10 * n7;
            System.arraycopy(nArray, n8, nArray, n, n2 * n7);
            n10 += n9;
            n9 *= 2;
        }
    }

    protected void fillOutRaster_FALLBACK(WritableRaster writableRaster) {
        int n;
        int n2 = writableRaster.getWidth();
        int n3 = writableRaster.getHeight();
        Object object = null;
        int n4 = this.xStep;
        int n5 = this.xStep;
        while (n5 < n2) {
            n = n4;
            if (n5 + n > n2) {
                n = n2 - n5;
            }
            object = writableRaster.getDataElements(0, 0, n, this.yStep, object);
            writableRaster.setDataElements(n5, 0, n, this.yStep, object);
            if ((n5 += n) >= n2) break;
            if (n5 + n > n2) {
                n = n2 - n5;
            }
            writableRaster.setDataElements(n5, 0, n, this.yStep, object);
            if ((n5 += n) >= n2) break;
            if (n5 + n > n2) {
                n = n2 - n5;
            }
            writableRaster.setDataElements(n5, 0, n, this.yStep, object);
            n5 += n4;
            n4 *= 4;
        }
        n4 = this.yStep;
        n5 = this.yStep;
        while (n5 < n3) {
            n = n4;
            if (n5 + n > n3) {
                n = n3 - n5;
            }
            object = writableRaster.getDataElements(0, 0, n2, n, object);
            writableRaster.setDataElements(0, n5, n2, n, object);
            n5 += n;
            if (n >= n3) break;
            if (n5 + n > n3) {
                n = n3 - n5;
            }
            writableRaster.setDataElements(0, n5, n2, n, object);
            n5 += n;
            if (n >= n3) break;
            if (n5 + n > n3) {
                n = n3 - n5;
            }
            writableRaster.setDataElements(0, n5, n2, n, object);
            n5 += n;
            n5 += n4;
            n4 *= 4;
        }
    }

    protected static SampleModel fixSampleModel(RenderedImage renderedImage, int n, int n2, int n3, int n4) {
        int n5;
        int n6 = AbstractTiledRed.getDefaultTileSize();
        SampleModel sampleModel = renderedImage.getSampleModel();
        int n7 = sampleModel.getWidth();
        if (n7 < n6) {
            n7 = n6;
        }
        if (n7 > n) {
            n7 = n;
        }
        if ((n5 = sampleModel.getHeight()) < n6) {
            n5 = n6;
        }
        if (n5 > n2) {
            n5 = n2;
        }
        return sampleModel.createCompatibleSampleModel(n7, n5);
    }
}

