"=============================================================================
" 	     File: mathmacros.vim
"      Author: Mikolaj Machowski
"     Created: Tue Apr 23 06:00 PM 2002 PST
" 
"  Description: macros for everything mathematical in latex.
"=============================================================================

if !(has('gui_running') && g:Tex_MathMenus && g:Tex_Menus)
	finish
endif

let s:MathMenuName = g:Tex_MenuPrefix.'Ma&th.'

function! Tex_MathMenuRemove()
	exe 'silent! aunmenu '.s:MathMenuName
endfunction

let s:pA = 'amenu <silent> 85 '.s:MathMenuName

" brackets and dollars {{{
exe s:pA.'\\&[\ \\]                 <plug><C-r>=IMAP_PutTextWithMovement("\\[<++>\\]<++>")<cr>'
exe s:pA.'\\&(\ \\)                 <plug><C-r>=IMAP_PutTextWithMovement("\\(<++>\\)<++>")<cr>'
exe s:pA.'&$\ $                     <plug>$$'
exe s:pA.'-sepmath1- :'
" }}}
" MATH arrows {{{
let s:pA1 = s:pA."&Arrows."
exe s:pA1.'Leftarrow<Tab>⇐           <plug>\Leftarrow '
exe s:pA1.'leftarrow<Tab>←           <plug>\leftarrow'
exe s:pA1.'longleftarrow<Tab>←       <plug>\longleftarrow '
exe s:pA1.'Longleftarrow<Tab>⇐       <plug>\Longleftarrow '
exe s:pA1.'rightarrow<Tab>→          <plug>\rightarrow '
exe s:pA1.'longrightarrow<Tab>→      <plug>\longrightarrow '
exe s:pA1.'Rightarrow<Tab>⇒          <plug>\Rightarrow '
exe s:pA1.'Longrightarrow<Tab>⇒      <plug>\Longrightarrow '
exe s:pA1.'leftrightarrow<Tab>⇆      <plug>\leftrightarrow '
exe s:pA1.'longleftrightarrow<Tab>↔  <plug>\longleftrightarrow '
exe s:pA1.'Leftrightarrow<Tab>⇔      <plug>\Leftrightarrow '
exe s:pA1.'Longleftrightarrow<Tab>⇔  <plug>\Longleftrightarrow '
exe s:pA1.'uparrow<Tab>↑             <plug>\uparrow '
exe s:pA1.'Uparrow<Tab>⇑             <plug>\Uparrow '
exe s:pA1.'downarrow<Tab>↓           <plug>\downarrow '
exe s:pA1.'Downarrow<Tab>⇓           <plug>\Downarrow '
exe s:pA1.'updownarrow<Tab>↕         <plug>\updownarrow '
exe s:pA1.'Updownarrow<Tab>⇕         <plug>\Updownarrow '
exe s:pA1.'nearrow<Tab>↗             <plug>\nearrow '
exe s:pA1.'searrow<Tab>↘             <plug>\searrow '
exe s:pA1.'swarrow<Tab>↙             <plug>\swarrow '
exe s:pA1.'nwarrow<Tab>↖             <plug>\nwarrow '
exe s:pA1.'mapsto<Tab>↦              <plug>\mapsto '
exe s:pA1.'leadsto<Tab>↝             <plug>\leadsto '
exe s:pA1.'longmapsto<Tab>⇖          <plug>\longmapsto '
exe s:pA1.'hookleftarrow<Tab>↩       <plug>\hookleftarrow '
exe s:pA1.'hookrightarrow<Tab>↪      <plug>\hookrightarrow '
exe s:pA1.'leftharpoonup<Tab>↼       <plug>\leftharpoonup '
exe s:pA1.'leftharpoondown<Tab>↽     <plug>\leftharpoondown '
exe s:pA1.'rightharpoonup<Tab>⇀      <plug>\rightharpoonup '
exe s:pA1.'rightharpoondown<Tab>⇁    <plug>\rightharpoondown '
exe s:pA1.'rightleftharpoons<Tab>⇌   <plug>\rightleftharpoons '
exe s:pA1.'overleftarrow<Tab>        <plug>\overleftarrow '
exe s:pA1.'overrightarrow<Tab>       <plug>\overrightarrow '
exe s:pA1.'overleftrightarrow<Tab>   <plug>\overleftrightarrow '
exe s:pA1.'underleftarrow<Tab>       <plug>\underleftarrow '
exe s:pA1.'underrightarrow<Tab>      <plug>\underrightarrow '
exe s:pA1.'underleftrightarrow<Tab>  <plug>\underleftrightarrow '
exe s:pA1.'xleftarrow<Tab>           <plug>\xleftarrow '
exe s:pA1.'xrightarrow<Tab>          <plug>\xrightarrow '
" }}}
" MATH Arrows2 {{{
let s:pA1a = s:pA."Arrows2."
exe s:pA1a.'dashleftarrow<Tab>⇠       <plug>\dashleftarrow '
exe s:pA1a.'leftleftarrows<Tab>⇇      <plug>\leftleftarrows '
exe s:pA1a.'leftrightarrows<Tab>⇆     <plug>\leftrightarrows '
exe s:pA1a.'Lleftarrow<Tab>⇚          <plug>\Lleftarrow '
exe s:pA1a.'twoheadleftarrow<Tab>↞    <plug>\twoheadleftarrow '
exe s:pA1a.'leftarrowtail<Tab>↢       <plug>\leftarrowtail '
exe s:pA1a.'leftrightharpoons<Tab>⇋   <plug>\leftrightharpoons '
exe s:pA1a.'Lsh<Tab>↰                 <plug>\Lsh '
exe s:pA1a.'looparrowleft<Tab>↫       <plug>\looparrowleft '
exe s:pA1a.'curvearrowleft<Tab>↶      <plug>\curvearrowleft '
exe s:pA1a.'circlearrowleft<Tab>↺     <plug>\circlearrowleft '
exe s:pA1a.'dashrightarrow<Tab>⇢      <plug>\dashrightarrow '
exe s:pA1a.'rightrightarrows<Tab>⇉    <plug>\rightrightarrows '
exe s:pA1a.'rightleftarrows<Tab>⇄     <plug>\rightleftarrows '
exe s:pA1a.'Rrightarrow<Tab>⇛         <plug>\Rrightarrow '
exe s:pA1a.'twoheadrightarrow<Tab>↠   <plug>\twoheadrightarrow '
exe s:pA1a.'rightarrowtail<Tab>↣      <plug>\rightarrowtail '
exe s:pA1a.'rightleftharpoons<Tab>⇌   <plug>\rightleftharpoons '
exe s:pA1a.'Rsh<Tab>↱                 <plug>\Rsh '
exe s:pA1a.'looparrowright<Tab>↬      <plug>\looparrowright '
exe s:pA1a.'curvearrowright<Tab>↷     <plug>\curvearrowright '
exe s:pA1a.'circlearrowright<Tab>↻    <plug>\circlearrowright '
exe s:pA1a.'multimap<Tab>⊸            <plug>\multimap '
exe s:pA1a.'upuparrows<Tab>⇈          <plug>\upuparrows '
exe s:pA1a.'downdownarrows<Tab>⇊      <plug>\downdownarrows '
exe s:pA1a.'upharpoonleft<Tab>↿       <plug>\upharpoonleft '
exe s:pA1a.'upharpoonright<Tab>↾      <plug>\upharpoonright '
exe s:pA1a.'downharpoonleft<Tab>⇃     <plug>\downharpoonleft '
exe s:pA1a.'downharpoonright<Tab>⇂    <plug>\downharpoonright '
exe s:pA1a.'rightsquigarrow<Tab>⇝     <plug>\rightsquigarrow '
exe s:pA1a.'leftrightsquigarrow<Tab>↭ <plug>\leftrightsquigarrow '
" }}}
" MATH nArrows {{{
let s:pA1b = s:pA."&nArrows."
exe s:pA1b.'nleftarrow<Tab>↚          <plug>\nleftarrow '
exe s:pA1b.'nLeftarrow<Tab>⇍          <plug>\nLeftarrow '
exe s:pA1b.'nleftrightarrow<Tab>↮     <plug>\nleftrightarrow '
exe s:pA1b.'nLeftrightarrow<Tab>⇎     <plug>\nleftrightarrow '
exe s:pA1b.'nrightarrow<Tab>↛         <plug>\nrightarrow '
exe s:pA1b.'nRightarrow<Tab>⇏         <plug>\nRightarrow '
" }}}
" MATH Fonts {{{
let s:pA2a = s:pA."&MathFonts."
exe s:pA2a.'mathbf{}                <plug><C-r>=IMAP_PutTextWithMovement("\\mathbf{<++>}<++>")<cr>'
exe s:pA2a.'mathrm{}                <plug><C-r>=IMAP_PutTextWithMovement("\\mathrm{<++>}<++>")<cr>'
exe s:pA2a.'mathsf{}                <plug><C-r>=IMAP_PutTextWithMovement("\\mathsf{<++>}<++>")<cr>'
exe s:pA2a.'mathtt{}                <plug><C-r>=IMAP_PutTextWithMovement("\\mathtt{<++>}<++>")<cr>'
exe s:pA2a.'mathit{}                <plug><C-r>=IMAP_PutTextWithMovement("\\mathit{<++>}<++>")<cr>'
exe s:pA2a.'mathfrak{}              <plug><C-r>=IMAP_PutTextWithMovement("\\mathfrak{<++>}<++>")<cr>'
exe s:pA2a.'mathcal{}               <plug><C-r>=IMAP_PutTextWithMovement("\\mathcal{<++>}<++>")<cr>'
exe s:pA2a.'mathscr{}               <plug><C-r>=IMAP_PutTextWithMovement("\\mathscr{<++>}<++>")<cr>'
exe s:pA2a.'mathbb{}                <plug><C-r>=IMAP_PutTextWithMovement("\\mathbb{<++>}<++>")<cr>'
" }}}
" Greek Letters small {{{
let s:pA2 = s:pA."&Greek.&Small."
exe s:pA2.'alpha<Tab>`a\ \ α       <plug>\alpha '
exe s:pA2.'beta<Tab>`b\ \ β        <plug>\beta '
exe s:pA2.'gamma<Tab>`g\ \ γ       <plug>\gamma '
exe s:pA2.'delta<Tab>`d\ \ δ       <plug>\delta '
exe s:pA2.'epsilon<Tab>∊           <plug>\epsilon '
exe s:pA2.'varepsilon<Tab>`e\ \ ε  <plug>\varepsilon '
exe s:pA2.'zeta<Tab>`z\ \ ζ        <plug>\zeta '
exe s:pA2.'eta<Tab>`h\ \ η         <plug>\eta '
exe s:pA2.'theta<Tab>`q\ \ θ       <plug>\theta '
exe s:pA2.'vartheta<Tab>ϑ          <plug>\vartheta '
exe s:pA2.'iota<Tab>`i\ \ ι        <plug>\iota '
exe s:pA2.'kappa<Tab>`k\ \ κ       <plug>\kappa '
exe s:pA2.'lambda<Tab>`l\ \ λ      <plug>\lambda '
exe s:pA2.'mu<Tab>`m\ \ μ          <plug>\mu '
exe s:pA2.'nu<Tab>`n\ \ ν          <plug>\nu '
exe s:pA2.'xi<Tab>`x\ \ ξ          <plug>\xi '
exe s:pA2.'pi<Tab>`p\ \ π          <plug>\pi '
exe s:pA2.'varpi<Tab>ϖ             <plug>\varpi '
exe s:pA2.'rho<Tab>`r\ \ ρ         <plug>\rho '
exe s:pA2.'varrho<Tab>ϱ            <plug>\varrho '
exe s:pA2.'sigma<Tab>`s\ \ σ       <plug>\sigma '
exe s:pA2.'varsigma<Tab>`v\ \ ς    <plug>\varsigma '
exe s:pA2.'tau<Tab>`t\ \ τ         <plug>\tau '
exe s:pA2.'upsilon<Tab>`u\ \ υ     <plug>\upsilon '
exe s:pA2.'phi<Tab>φ               <plug>\phi '
exe s:pA2.'varphi<Tab>`f\ \ ϕ      <plug>\varphi '
exe s:pA2.'chi<Tab>`c\ \ χ         <plug>\chi '
exe s:pA2.'psi<Tab>`y\ \ ψ         <plug>\psi '
exe s:pA2.'omega<Tab>`w\ \ ω       <plug>\omega '
" }}}
" Greek Letters big {{{
let s:pA3 = s:pA.'&Greek.&Big.' 
exe s:pA3.'Alpha<Tab>`A\ \ A        <plug>\Alpha '
exe s:pA3.'Beta<Tab>`B\ \ B         <plug>\Beta '
exe s:pA3.'Gamma<Tab>`G\ \ Γ        <plug>\Gamma '
exe s:pA3.'Delta<Tab>`D\ \ Δ        <plug>\Delta '
exe s:pA3.'Epsilon<Tab>`E\ \ E      <plug>\Epsilon '
exe s:pA3.'Zeta<Tab>`Z\ \ Z         <plug>\mathrm{Z} '
exe s:pA3.'Eta<Tab>`H\ \ H          <plug>\Eta '
exe s:pA3.'Theta<Tab>Θ              <plug>\Theta '
exe s:pA3.'Iota<Tab>I               <plug>\mathrm{I} '
exe s:pA3.'Kappa<Tab>`K\ \ K        <plug>\Kappa '
exe s:pA3.'Lambda<Tab>`L\ \ Λ       <plug>\Lambda '
exe s:pA3.'Mu<Tab>`M\ \ M           <plug>\Mu '
exe s:pA3.'Nu<Tab>`N\ \ N           <plug>\Nu '
exe s:pA3.'Xi<Tab>`X\ \ Ξ           <plug>\Xi '
exe s:pA3.'Pi<Tab>`P\ \ Π           <plug>\Pi '
exe s:pA3.'Rho<Tab>`R\ \ P          <plug>\Rho '
exe s:pA3.'Sigma<Tab>`S\ \ Σ        <plug>\Sigma '
exe s:pA3.'Tau<Tab>`T\ \ T          <plug>\Tau '
exe s:pA3.'Upsilon<Tab>`U\ \ Y      <plug>\Upsilon '
exe s:pA3.'Phi<Tab>Φ                <plug>\Phi '
exe s:pA3.'Chi<Tab>`C\ \ X          <plug>\Chi '
exe s:pA3.'Psi<Tab>`Y\ \ Ψ          <plug>\Psi '
exe s:pA3.'Omega<Tab>`W\ \ Ω        <plug>\Omega '
" }}}
" BinaryRel1 {{{
let s:pA4 = s:pA."&BinaryRel1."  
exe s:pA4.'ll<Tab>≪                    <plug>\ll '
exe s:pA4.'lll<Tab>⋘                   <plug>\lll '
exe s:pA4.'leqslant<Tab>≤              <plug>\leqslant '
exe s:pA4.'leq<Tab>≤                   <plug>\leq '
exe s:pA4.'leqq<Tab>≦                  <plug>\leqq '
exe s:pA4.'eqslantless<Tab>⋜            <plug>\eqslantless '
exe s:pA4.'lessdot<Tab>⋖               <plug>\lessdot '
exe s:pA4.'prec<Tab>≺                  <plug>\prec '
exe s:pA4.'preceq<Tab>≼                <plug>\preceq '
exe s:pA4.'preccurlyeq<Tab>≼           <plug>\preccurlyeq '
exe s:pA4.'curlyeqprec<Tab>⋞           <plug>\curlyeqprec '
exe s:pA4.'lesssim<Tab>≲                 <plug>\lesssim '
exe s:pA4.'lessapprox<Tab>             <plug>\lessapprox '
exe s:pA4.'precsim<Tab>≾               <plug>\precsim '
exe s:pA4.'precapprox<Tab>             <plug>\precapprox '
exe s:pA4.'in<Tab>∈                    <plug>\in '
exe s:pA4.'subset<Tab>`(\ \ ⊂          <plug>\subset '
exe s:pA4.'Subset<Tab>`)\ \ ⋐          <plug>\Subset '
exe s:pA4.'subseteq<Tab>⊆              <plug>\subseteq '
exe s:pA4.'subseteqq<Tab>              <plug>\subseteqq '
exe s:pA4.'sqsubset<Tab>⊏              <plug>\sqsubset '
exe s:pA4.'sqsubseteq<Tab>⊑            <plug>\sqsubseteq '
exe s:pA4.'smile<Tab>⌣                 <plug>\smile '
exe s:pA4.'smallsmile<Tab>⌣             <plug>\smallsmile '
exe s:pA4.'parallel<Tab>∥              <plug>\parallel '
exe s:pA4.'shortparallel<Tab>∥         <plug>\shortparallel '
exe s:pA4.'dashv<Tab>⊣                 <plug>\dashv '
exe s:pA4.'vdash<Tab>⊢                 <plug>\vdash '
exe s:pA4.'vDash<Tab>⊨                 <plug>\vDash '
exe s:pA4.'models<Tab>⊨                <plug>\models '
exe s:pA4.'therefore<Tab>∴             <plug>\therefore '
exe s:pA4.'backepsilon<Tab>∍           <plug>\backepsilon '
" }}}
" nBinaryRel1 {{{ 
let s:pA4a = s:pA."&nBinaryRel1."  
exe s:pA4a.'nless<Tab>≮                  <plug>\nless '
exe s:pA4a.'nleqslant<Tab>≰              <plug>\nleqslant '
exe s:pA4a.'nleq<Tab>                   <plug>\nleq '
exe s:pA4a.'lneq<Tab>                   <plug>\lneq '
exe s:pA4a.'nleqq<Tab>                  <plug>\nleqq '
exe s:pA4a.'lneqq<Tab>≨                  <plug>\lneqq '
exe s:pA4a.'lvertneqq<Tab>              <plug>\lvertneqq '
exe s:pA4a.'nprec<Tab>⊀                  <plug>\nprec '
exe s:pA4a.'npreceq<Tab>⋠                <plug>\npreceq '
exe s:pA4a.'precneqq<Tab>               <plug>\precneqq '
exe s:pA4a.'lnsim<Tab>⋦                  <plug>\lnsim '
exe s:pA4a.'lnapprox<Tab>               <plug>\lnapprox '
exe s:pA4a.'precnsim<Tab>⋨               <plug>\precnsim '
exe s:pA4a.'precnapprox<Tab>            <plug>\precnapprox '
exe s:pA4a.'notin<Tab>∉                  <plug>\notin '
exe s:pA4a.'nsubseteq<Tab>⊈              <plug>\nsubseteq '
exe s:pA4a.'varsubsetneq<Tab>           <plug>\varsubsetneq '
exe s:pA4a.'subsetneq<Tab>⊊              <plug>\subsetneq '
exe s:pA4a.'nsubseteqq<Tab>             <plug>\nsubseteqq '
exe s:pA4a.'varsubsetneqq<Tab>          <plug>\varsubsetneqq '
exe s:pA4a.'subsetneqq<Tab>⊈             <plug>\subsetneqq '
exe s:pA4a.'nparallel<Tab>∦              <plug>\nparallel '
exe s:pA4a.'nshortparallel<Tab>         <plug>\nshortparallel '
exe s:pA4a.'nvdash<Tab>⊬                 <plug>\nvdash '
exe s:pA4a.'nvDash<Tab>⊭                 <plug>\nvDash '
" }}}
" BinaryRel2 {{{ 
let s:pA5 = s:pA."&BinaryRel2."  
exe s:pA5.'gg<Tab>≫                      <plug>\gg '
exe s:pA5.'ggg<Tab>⋙                     <plug>\ggg '
exe s:pA5.'gggtr<Tab>⋙                    <plug>\gggtr '
exe s:pA5.'geqslant<Tab>                 <plug>\geqslant '
exe s:pA5.'geq<Tab>≥                     <plug>\geq '
exe s:pA5.'geqq<Tab>≧                    <plug>\geqq '
exe s:pA5.'eqslantgtr<Tab>               <plug>\eqslantgtr '
exe s:pA5.'gtrdot<Tab>⋗                  <plug>\gtrdot '
exe s:pA5.'succ<Tab>≻                    <plug>\succ '
exe s:pA5.'succeq<Tab>≽                  <plug>\succeq '
exe s:pA5.'succcurlyeq<Tab>≽             <plug>\succcurlyeq '
exe s:pA5.'curlyeqsucc<Tab>⋟             <plug>\curlyeqsucc '
exe s:pA5.'gtrsim<Tab>≳                  <plug>\gtrsim '
exe s:pA5.'gtrapprox<Tab>                <plug>\gtrapprox '
exe s:pA5.'succsim<Tab>≿                 <plug>\succsim '
exe s:pA5.'succapprox<Tab>               <plug>\succapprox '
exe s:pA5.'ni<Tab>∋                      <plug>\ni '
exe s:pA5.'owns<Tab>                     <plug>\owns '
exe s:pA5.'supset<Tab>⊃                  <plug>\supset '
exe s:pA5.'Supset<Tab>⋑                  <plug>\Supset '
exe s:pA5.'supseteq<Tab>⊇                <plug>\supseteq '
exe s:pA5.'supseteqq<Tab>                <plug>\supseteqq '
exe s:pA5.'sqsupset<Tab>⊐                <plug>\sqsupset '
exe s:pA5.'sqsupseteq<Tab>⊒              <plug>\sqsupseteq '
exe s:pA5.'frown<Tab>⌢                   <plug>\frown '
exe s:pA5.'smallfrown<Tab>⌢              <plug>\smallfrown '
exe s:pA5.'mid<Tab>∣                     <plug>\mid '
exe s:pA5.'shortmid<Tab>                 <plug>\shortmid '
exe s:pA5.'between<Tab>≬                 <plug>\between '
exe s:pA5.'Vdash<Tab>⊩                   <plug>\Vdash '
exe s:pA5.'bowtie<Tab>⋈                  <plug>\bowtie '
exe s:pA5.'Join<Tab>⋈                    <plug>\Join '
exe s:pA5.'pitchfork<Tab>⋔               <plug>\pitchfork '
" }}}
" {{{ nBinaryRel2
let s:pA5a = s:pA."n&BinaryRel2."  "TODO: dorobiæ logarytmy
exe s:pA5a.'ngtr<Tab>≯                   <plug>\ngtr '
exe s:pA5a.'ngeqslant<Tab>≱              <plug>\ngeqslant '
exe s:pA5a.'ngeq<Tab>                   <plug>\ngeq '
exe s:pA5a.'gneq<Tab>                   <plug>\gneq '
exe s:pA5a.'ngeqq<Tab>                  <plug>\ngeqq '
exe s:pA5a.'gneqq<Tab>≩                  <plug>\gneqq '
exe s:pA5a.'nsucc<Tab>⊁                  <plug>\nsucc '
exe s:pA5a.'nsucceq<Tab>⋡                <plug>\nsucceq '
exe s:pA5a.'succneqq<Tab>                <plug>\succneqq '
exe s:pA5a.'gnsim<Tab>⋧                  <plug>\gnsim '
exe s:pA5a.'gnapprox<Tab>               <plug>\gnapprox '
exe s:pA5a.'succnsim<Tab>⋩               <plug>\succnsim '
exe s:pA5a.'succnapprox<Tab>            <plug>\succnapprox '
exe s:pA5a.'nsupseteq<Tab>⊉              <plug>\nsupseteq '
exe s:pA5a.'varsupsetneq<Tab>           <plug>\varsupsetneq '
exe s:pA5a.'supsetneq<Tab>⊋              <plug>\supsetneq '
exe s:pA5a.'nsupseteqq<Tab>             <plug>\nsupseteqq '
exe s:pA5a.'varsupsetneqq<Tab>          <plug>\varsupsetneqq '
exe s:pA5a.'supsetneqq<Tab>             <plug>\supsetneqq '
exe s:pA5a.'nmid<Tab>∤                   <plug>\nmid '
exe s:pA5a.'nshortmid<Tab>              <plug>\nshortmid '
exe s:pA5a.'nVdash<Tab>⊮                 <plug>\nVdash '
" }}}
" {{{ BinaryRel3
let s:pA6 = s:pA."&BinaryRel3."  
exe s:pA6.'doteq<Tab>≐                   <plug>\doteq '
exe s:pA6.'circeq<Tab>≗                  <plug>\circeq '
exe s:pA6.'eqcirc<Tab>≖                  <plug>\eqcirc '
exe s:pA6.'risingdotseq<Tab>≓            <plug>\risingdotseq '
exe s:pA6.'doteqdot<Tab>≑                <plug>\doteqdot '
exe s:pA6.'Doteq<Tab>≑                   <plug>\Doteq '
exe s:pA6.'fallingdotseq<Tab>≒           <plug>\fallingdotseq '
exe s:pA6.'triangleq<Tab>≜               <plug>\triangleq '
exe s:pA6.'bumpeq<Tab>≏                  <plug>\bumpeq '
exe s:pA6.'Bumpeq<Tab>≎                  <plug>\Bumpeq '
exe s:pA6.'equiv<Tab>`=\ \ ≡             <plug>\equiv '
exe s:pA6.'sim<Tab>∼                     <plug>\sim '
exe s:pA6.'thicksim<Tab>∼                <plug>\thicksim '
exe s:pA6.'backsim<Tab>∽                 <plug>\backsim '
exe s:pA6.'simeq<Tab>≃                   <plug>\simeq '
exe s:pA6.'backsimeq<Tab>⋍               <plug>\backsimeq '
exe s:pA6.'cong<Tab>≅                    <plug>\cong '
exe s:pA6.'approx<tab>=~\ \ ≈            <plug>\approx '
exe s:pA6.'thickapprox<Tab>≈             <plug>\thickapprox '
exe s:pA6.'approxeq<Tab>≊                <plug>\approxeq '
exe s:pA6.'blacktriangleleft<Tab>◀       <plug>\blacktriangleleft '
exe s:pA6.'vartriangleleft<Tab>⊲         <plug>\vartriangleleft '
exe s:pA6.'trianglelefteq<Tab>⊴          <plug>\trianglelefteq '
exe s:pA6.'blacktriangleright<Tab>▶      <plug>\blacktriangleright '
exe s:pA6.'vartriangleright<Tab>⊳        <plug>\vartriangleright '
exe s:pA6.'trianglerighteq<Tab>⊵         <plug>\trianglerighteq '
exe s:pA6.'perp<Tab>⊥                    <plug>\perp '
exe s:pA6.'asymp<Tab>≍                   <plug>\asymp '
exe s:pA6.'Vvdash<Tab>⊪                  <plug>\Vvdash '
exe s:pA6.'propto<Tab>∝                  <plug>\propto '
exe s:pA6.'varpropto<Tab>∝               <plug>\varpropto '
exe s:pA6.'because<Tab>∵                 <plug>\because '
" }}}
" {{{ nBinaryRel3
let s:pA6a = s:pA."&nBinaryRel3."
exe s:pA6a.'neq<Tab>≠                    <plug>\neq '
exe s:pA6a.'nsim<Tab>≁                   <plug>\nsim '
exe s:pA6a.'ncong<Tab>≆                  <plug>\ncong '
exe s:pA6a.'ntriangleleft<Tab>⋪          <plug>\ntriangleleft '
exe s:pA6a.'ntrianglelefteq<Tab>⋬        <plug>\ntrianglelefteq '
exe s:pA6a.'ntriangleright<Tab>⋫         <plug>\ntriangleright '
exe s:pA6a.'ntrianglerighteq<Tab>⋭       <plug>\ntrianglerighteq '
" }}}
" {{{ BinaryRel4
let s:pA7 = s:pA."&BinaryRel4."  
exe s:pA7.'lessgtr<Tab>≶                 <plug>\lessgtr '
exe s:pA7.'gtrless<Tab>≷                 <plug>\gtrless '
exe s:pA7.'lesseqgtr<Tab>⋚               <plug>\lesseqgtr '
exe s:pA7.'gtreqless<Tab>⋛               <plug>\gtreqless '
exe s:pA7.'lesseqqgtr<Tab>              <plug>\lesseqqgtr '
exe s:pA7.'gtreqqless<Tab>              <plug>\gtreqqless '
" }}}
" {{{ BigOp
let s:pA8a = s:pA."&BigOp."
exe s:pA8a.'limits<Tab>                 <plug>\limits'
exe s:pA8a.'nolimits<Tab>               <plug>\nolimits'
exe s:pA8a.'displaylimits<Tab>          <plug>\displaylimits'
exe s:pA8a.'-seplimits- :'
exe s:pA8a.'bigcap<Tab>`-\ \ ⋂           <plug>\bigcap'
exe s:pA8a.'bigcup<Tab>`+\ \ ⋃        <plug>\bigcup'
exe s:pA8a.'bigodot<Tab>⊙                <plug>\bigodot'
exe s:pA8a.'bigoplus<Tab>⊕               <plug>\bigoplus'
exe s:pA8a.'bigotimes<Tab>⊗              <plug>\bigotimes'
exe s:pA8a.'bigsqcup<Tab>⊔               <plug>\bigsqcup'
exe s:pA8a.'biguplus<Tab>⊎               <plug>\biguplus'
exe s:pA8a.'bigvee<Tab>⋁                 <plug>\bigvee'
exe s:pA8a.'bigwedge<Tab>⋀               <plug>\bigwedge'
exe s:pA8a.'coprod<Tab>∐                 <plug>\coprod'
exe s:pA8a.'int<Tab>∫                    <plug>\int'
exe s:pA8a.'iint<Tab>∬                   <plug>\int'
exe s:pA8a.'iiint<Tab>∭                  <plug>\int'
exe s:pA8a.'oint<Tab>∮                   <plug>\oint'
exe s:pA8a.'prod<Tab>∏                   <plug>\prod'
exe s:pA8a.'sum<Tab>∑                    <plug>\sum'
" }}}
" {{{ BinaryOp
let s:pA8 = s:pA."&BinaryOp."
exe s:pA8.'pm<Tab>±                      <plug>\pm '
exe s:pA8.'mp<Tab>∓                      <plug>\mp '
exe s:pA8.'dotplus<Tab>∔                 <plug>\dotplus '
exe s:pA8.'cdot<Tab>`.\ \ ⋅              <plug>\cdot '
exe s:pA8.'centerdot<Tab>⋅               <plug>\centerdot '
exe s:pA8.'times<Tab>`*\ \ ×             <plug>\times '
exe s:pA8.'ltimes<Tab>⋉                  <plug>\ltimes '
exe s:pA8.'rtimes<Tab>⋊                  <plug>\rtimes '
exe s:pA8.'leftthreetimes<Tab>⋋          <plug>\leftthreetimes '
exe s:pA8.'rightthreetimes<Tab>⋌         <plug>\rightthreetimes '
exe s:pA8.'div<Tab>÷                     <plug>\div '
exe s:pA8.'divideontimes<Tab>⋇           <plug>\divideontimes '
exe s:pA8.'bmod<Tab>                     <plug>\bmod '
exe s:pA8.'ast<Tab>∗                     <plug>\ast '
exe s:pA8.'star<Tab>⋆                    <plug>\star '
exe s:pA8.'setminus<Tab>`\\\ \ ∖         <plug>\setminus '
exe s:pA8.'smallsetminus<Tab>∖           <plug>\smallsetminus '
exe s:pA8.'diamond<Tab>⋄                 <plug>\diamond '
exe s:pA8.'wr<Tab>≀                      <plug>\wr '
exe s:pA8.'intercal<Tab>⊺                <plug>\intercal '
exe s:pA8.'circ<Tab>`@\ \ ∘              <plug>\circ '
exe s:pA8.'bigcirc<Tab>○                 <plug>\bigcirc '
exe s:pA8.'bullet<Tab>∙                  <plug>\bullet '
exe s:pA8.'cap<Tab>∩                     <plug>\cap '
exe s:pA8.'Cap<Tab>⋒                     <plug>\Cap '
exe s:pA8.'cup<Tab>∪                     <plug>\cup '
exe s:pA8.'Cup<Tab>⋓                     <plug>\Cup '
exe s:pA8.'sqcap<Tab>⊓                   <plug>\sqcap '
exe s:pA8.'sqcup<Tab>⊔                   <plug>\sqcup'
exe s:pA8.'amalg<Tab>                    <plug>\amalg '
exe s:pA8.'uplus<Tab>⊎                   <plug>\uplus '
exe s:pA8.'triangleleft<Tab>◁            <plug>\triangleleft '
exe s:pA8.'triangleright<Tab>▷           <plug>\triangleright '
exe s:pA8.'bigtriangleup<Tab>△           <plug>\bigtriangleup '
exe s:pA8.'bigtriangledown<Tab>▽         <plug>\bigtriangledown '
exe s:pA8.'vee<Tab>∨                     <plug>\vee '
exe s:pA8.'veebar<Tab>⊻                  <plug>\veebar '
exe s:pA8.'curlyvee<Tab>⋎                <plug>\curlyvee '
exe s:pA8.'wedge<Tab>`&\ \ ∧             <plug>\wedge '
exe s:pA8.'barwedge<Tab>⊼                <plug>\barwedge '
exe s:pA8.'doublebarwedge<Tab>⌆          <plug>\doublebarwedge '
exe s:pA8.'curlywedge<Tab>⋏              <plug>\curlywedge '
exe s:pA8.'oplus<Tab>⊕                   <plug>\oplus '
exe s:pA8.'ominus<Tab>⊖                  <plug>\ominus '
exe s:pA8.'otimes<Tab>⊗                  <plug>\otimes '
exe s:pA8.'oslash<Tab>⊘                  <plug>\oslash '
exe s:pA8.'boxplus<Tab>⊞                 <plug>\boxplus '
exe s:pA8.'boxminus<Tab>⊟                <plug>\boxminus '
exe s:pA8.'boxtimes<Tab>⊠                <plug>\boxtimes '
exe s:pA8.'boxdot<Tab>⊡                  <plug>\boxdot '
exe s:pA8.'odot<Tab>⊙                    <plug>\odot '
exe s:pA8.'circledast<Tab>⊛              <plug>\circledast '
exe s:pA8.'circleddash<Tab>⊝             <plug>\circleddash '
exe s:pA8.'circledcirc<Tab>⊚             <plug>\circledcirc '
exe s:pA8.'dagger<Tab>†                  <plug>\dagger '
exe s:pA8.'ddagger<Tab>‡                 <plug>\ddagger '
exe s:pA8.'lhd<Tab>⊲                     <plug>\lhd '
exe s:pA8.'unlhd<Tab>⊴                   <plug>\unlhd '
exe s:pA8.'rhd<Tab>⊳                     <plug>\rhd '
exe s:pA8.'unrhd<Tab>⊵                   <plug>\unrhd '
" }}}
" {{{ Other1
let s:pA9 = s:pA."&Other1."
exe s:pA9.'hat<Tab>â                   <plug>\hat '
exe s:pA9.'check<Tab>ǎ                 <plug>\check '
exe s:pA9.'grave<Tab>à                 <plug>\grave '
exe s:pA9.'acute<Tab>á                 <plug>\acute '
exe s:pA9.'dot<Tab>ȧ                   <plug>\dot '
exe s:pA9.'ddot<Tab>ä                  <plug>\ddot '
exe s:pA9.'tilde<Tab>`,\ \ ã           <plug>\tilde '
exe s:pA9.'breve<Tab>ă                 <plug>\breve '
exe s:pA9.'bar<Tab>ā                   <plug>\bar '
exe s:pA9.'vec<Tab>a⃗                   <plug>\vec '
exe s:pA9.'aleph<Tab>א                 <plug>\aleph '
exe s:pA9.'hbar<Tab>ℏ                  <plug>\hbar '
exe s:pA9.'imath<Tab>                  <plug>\imath '
exe s:pA9.'jmath<Tab>                  <plug>\jmath '
exe s:pA9.'ell<Tab>ℓ                   <plug>\ell '
exe s:pA9.'wp<Tab>℘                    <plug>\wp '
exe s:pA9.'Re<Tab>ℜ                    <plug>\Re '
exe s:pA9.'Im<Tab>ℑ                    <plug>\Im '
exe s:pA9.'partial<Tab>∂               <plug>\partial '
exe s:pA9.'infty<Tab>`8\ \ ∞           <plug>\infty '
exe s:pA9.'prime<Tab>′                 <plug>\prime '
exe s:pA9.'emptyset<Tab>∅              <plug>\emptyset '
exe s:pA9.'nabla<Tab>∇                 <plug>\nabla '
exe s:pA9.'surd<Tab>√                  <plug>\surd '
exe s:pA9.'top<Tab>⊤                   <plug>\top '
exe s:pA9.'bot<Tab>⊥                   <plug>\bot '
exe s:pA9.'angle<Tab>∠                 <plug>\angle '
exe s:pA9.'triangle<Tab>△              <plug>\triangle '
exe s:pA9.'backslash<Tab>\\            <plug>\backslash '
exe s:pA9.'forall<Tab>∀                <plug>\forall '
exe s:pA9.'exists<Tab>∃                <plug>\exists '
exe s:pA9.'neg<Tab>¬                   <plug>\neg '
exe s:pA9.'flat<Tab>♭                  <plug>\flat '
exe s:pA9.'natural<Tab>♮               <plug>\natural '
exe s:pA9.'sharp<Tab>♯                 <plug>\sharp '
exe s:pA9.'clubsuit<Tab>♣              <plug>\clubsuit '
exe s:pA9.'diamondsuit<Tab>♢           <plug>\diamondsuit '
exe s:pA9.'heartsuit<Tab>♡             <plug>\heartsuit '
exe s:pA9.'spadesuit<Tab>♠             <plug>\spadesuit '
exe s:pA9.'S<Tab>§                     <plug>\S '
exe s:pA9.'P<Tab>¶                     <plug>\P'
" }}}
" {{{ MathCreating
let s:pA10 = s:pA."&MathCreating."
exe s:pA10.'not<Tab>                    <plug>\not'
exe s:pA10.'mkern<Tab>                  <plug>\mkern'
exe s:pA10.'mathbin<Tab>                <plug>\mathbin'
exe s:pA10.'mathrel<Tab>                <plug>\mathrel'
exe s:pA10.'stackrel<Tab>               <plug>\stackrel'
exe s:pA10.'mathord<Tab>                <plug>\mathord'
" }}}
" {{{ Styles
let s:pA11 = s:pA."&Styles."
exe s:pA11.'displaystyle<Tab>           <plug>\displaystyle'
exe s:pA11.'textstyle<Tab>              <plug>\textstyle'
exe s:pA11.'scritpstyle<Tab>            <plug>\scritpstyle'
exe s:pA11.'scriptscriptstyle<Tab>      <plug>\scriptscriptstyle'
" }}}
" {{{ MathDiacritics
let s:pA12 = s:pA."&MathDiacritics."
exe s:pA12.'acute{}<Tab>á            <plug><C-r>=IMAP_PutTextWithMovement("\\acute{<++>}<++>")<cr>'
exe s:pA12.'bar{}<Tab>`_\ \ ā        <plug><C-r>=IMAP_PutTextWithMovement("\\bar{<++>}<++>")<cr>'
exe s:pA12.'breve{}<Tab>ă            <plug><C-r>=IMAP_PutTextWithMovement("\\breve{<++>}<++>")<cr>'
exe s:pA12.'check{}<Tab>ǎ            <plug><C-r>=IMAP_PutTextWithMovement("\\check{<++>}<++>")<cr>'
exe s:pA12.'ddot{}<Tab>`:\ \ ä       <plug><C-r>=IMAP_PutTextWithMovement("\\ddot{<++>}<++>")<cr>'
exe s:pA12.'dot{}<Tab>`;\ \ ȧ        <plug><C-r>=IMAP_PutTextWithMovement("\\dot{<++>}<++>")<cr>'
exe s:pA12.'grave{}<Tab>à            <plug><C-r>=IMAP_PutTextWithMovement("\\grave{<++>}<++>")<cr>'
exe s:pA12.'hat{}<Tab>`^\ \ â        <plug><C-r>=IMAP_PutTextWithMovement("\\hat{<++>}<++>")<cr>'
exe s:pA12.'tilde{}<tab>`~\ \ ã      <plug><C-r>=IMAP_PutTextWithMovement("\\tilde{<++>}<++>")<cr>'
exe s:pA12.'vec{}<Tab>a⃗              <plug><C-r>=IMAP_PutTextWithMovement("\\vec{<++>}<++>")<cr>'
exe s:pA12.'widehat{}<Tab>           <plug><C-r>=IMAP_PutTextWithMovement("\\widehat{<++>}<++>")<cr>'
exe s:pA12.'widetilde{}<Tab>         <plug><C-r>=IMAP_PutTextWithMovement("\\widetilde{<++>}<++>")<cr>'
exe s:pA12.'imath<Tab>               <plug><C-r>=IMAP_PutTextWithMovement("\\imath")<cr>'
exe s:pA12.'jmath<Tab>               <plug><C-r>=IMAP_PutTextWithMovement("\\jmath")<cr>'
" }}}
" {{{ OverlineAndCo
let s:pA13 = s:pA."&OverlineAndCo."
exe s:pA13.'overline{}              <plug><C-r>=IMAP_PutTextWithMovement("\\overline{}")<cr>'
exe s:pA13.'underline{}             <plug><C-r>=IMAP_PutTextWithMovement("\\underline{}")<cr>'
exe s:pA13.'overrightarrow{}        <plug><C-r>=IMAP_PutTextWithMovement("\\overrightarrow{}")<cr>'
exe s:pA13.'overleftarrow{}         <plug><C-r>=IMAP_PutTextWithMovement("\\overleftarrow{}")<cr>'
exe s:pA13.'overbrace{}             <plug><C-r>=IMAP_PutTextWithMovement("\\overbrace{}")<cr>'
exe s:pA13.'underbrace{}            <plug><C-r>=IMAP_PutTextWithMovement("\\underbrace{}")<cr>'
" }}}
" {{{ Symbols1
let s:pA14a = s:pA."&Symbols1."
exe s:pA14a.'forall<Tab>∀               <plug>\forall '
exe s:pA14a.'exists<Tab>∃               <plug>\exists '
exe s:pA14a.'nexists<Tab>∄              <plug>\nexists '
exe s:pA14a.'neg<Tab>¬                  <plug>\neg '
exe s:pA14a.'top<Tab>⊤                  <plug>\top '
exe s:pA14a.'bot<Tab>⊥                  <plug>\bot '
exe s:pA14a.'emptyset<Tab>∅             <plug>\emptyset '
exe s:pA14a.'varnothing<Tab>⌀           <plug>\varnothing '
exe s:pA14a.'infty<Tab>∞                <plug>\infty '
exe s:pA14a.'aleph<Tab>א                <plug>\aleph '
exe s:pA14a.'beth<Tab>ב                 <plug>\beth '
exe s:pA14a.'gimel<Tab>ג                <plug>\gimel '
exe s:pA14a.'daleth<Tab>ד               <plug>\daleth '
exe s:pA14a.'hbar<Tab>                  <plug>\hbar '
exe s:pA14a.'hslash<Tab>ℏ               <plug>\hslash '
exe s:pA14a.'diagup<Tab>⁄               <plug>\diagup '
exe s:pA14a.'vert<Tab>\|                <plug>\vert '
exe s:pA14a.'Vert<Tab>∥                 <plug>\Vert '
exe s:pA14a.'backslash<Tab>\\           <plug>\backslash '
exe s:pA14a.'diagdown<Tab>              <plug>\diagdown '
exe s:pA14a.'Bbbk<Tab>ᵕ                  <plug>\Bbbk '
exe s:pA14a.'P<Tab>¶                    <plug>\P '
exe s:pA14a.'S<Tab>§                    <plug>\S '
" }}}
" {{{ Symbols2
let s:pA14b = s:pA."&Symbols2."
exe s:pA14b.'#                      <plug>\# '
exe s:pA14b.'%                      <plug>\% '
exe s:pA14b.'_<Tab>                 <plug>\_ '
exe s:pA14b.'$                      <plug>\$ '
exe s:pA14b.'&                      <plug>\& '
exe s:pA14b.'imath<Tab>             <plug>\imath '
exe s:pA14b.'jmath<Tab>             <plug>\jmath '
exe s:pA14b.'ell<Tab>ℓ              <plug>\ell '
exe s:pA14b.'wp<Tab>℘               <plug>\wp '
exe s:pA14b.'Re<Tab>ℜ               <plug>\Re '
exe s:pA14b.'Im<Tab>ℑ               <plug>\Im '
exe s:pA14b.'prime<Tab>′            <plug>\prime '
exe s:pA14b.'backprime<Tab>‵        <plug>\backprime '
exe s:pA14b.'nabla<Tab>∇            <plug>\nabla '
exe s:pA14b.'surd<Tab>√             <plug>\surd '
exe s:pA14b.'flat<Tab>♭             <plug>\flat '
exe s:pA14b.'sharp<Tab>♯            <plug>\sharp '
exe s:pA14b.'natural<Tab>♮          <plug>\natural '
exe s:pA14b.'eth<Tab>ð              <plug>\eth '
exe s:pA14b.'bigstar<Tab>★          <plug>\bigstar '
exe s:pA14b.'circledS<Tab>Ⓢ         <plug>\circledS '
exe s:pA14b.'Finv<Tab>Ⅎ             <plug>\Finv '
exe s:pA14b.'dag<Tab>†              <plug>\dag '
exe s:pA14b.'ddag<Tab>‡             <plug>\ddag '
" }}}
" {{{ Symbols3
let s:pA14c = s:pA."&Symbols3."
exe s:pA14c.'angle<Tab>∠                 <plug>\angle '
exe s:pA14c.'measuredangle<Tab>∡         <plug>\measuredangle '
exe s:pA14c.'sphericalangle<Tab>∢        <plug>\sphericalangle '
exe s:pA14c.'spadesuit<Tab>♠             <plug>\spadesuit '
exe s:pA14c.'heartsuit<Tab>♡             <plug>\heartsuit '
exe s:pA14c.'diamondsuit<Tab>♢           <plug>\diamondsuit '
exe s:pA14c.'clubsuit<Tab>♣              <plug>\clubsuit '
exe s:pA14c.'lozenge<Tab>◊               <plug>\lozenge '
exe s:pA14c.'blacklozenge<Tab>◆          <plug>\blacklozenge '
exe s:pA14c.'Diamond<Tab>◇               <plug>\Diamond '
exe s:pA14c.'triangle<Tab>△              <plug>\triangle '
exe s:pA14c.'vartriangle<Tab>△           <plug>\vartriangle '
exe s:pA14c.'blacktriangle<Tab>▲         <plug>\blacktriangle '
exe s:pA14c.'triangledown<Tab>▽          <plug>\triangledown '
exe s:pA14c.'blacktriangledown<Tab>▼     <plug>\blacktriangledown '
exe s:pA14c.'Box<Tab>□                   <plug>\Box '
exe s:pA14c.'square<Tab>□                <plug>\square '
exe s:pA14c.'blacksquare<Tab>■           <plug>\blacksquare '
exe s:pA14c.'complement<Tab>∁            <plug>\complement '
exe s:pA14c.'mho<Tab>℧                   <plug>\mho '
exe s:pA14c.'Game<Tab>⅁                  <plug>\Game '
exe s:pA14c.'partial<Tab>`6\ \ ∂         <plug>\partial '
exe s:pA14c.'smallint<Tab>∫              <plug>\smallint '
" }}}
" {{{ Logic
let s:pA15 = s:pA."&Logic."
exe s:pA15.'lnot<Tab>¬                   <plug>\lnot '
exe s:pA15.'lor<Tab>∨                    <plug>\lor '
exe s:pA15.'land<Tab>∧                   <plug>\land '
" }}}
" {{{ Limits1
let s:pA16 = s:pA."&Limits1."
exe s:pA16.'left<Tab>(                  <plug>\left'
exe s:pA16.'right<Tab>)                 <plug>\right'
exe s:pA16.'-sepbigl- :'
exe s:pA16.'bigl<Tab>                   <plug>\bigl'
exe s:pA16.'Bigl<Tab>                   <plug>\Bigl'
exe s:pA16.'biggl<Tab>                  <plug>\biggl'
exe s:pA16.'Biggl<Tab>                  <plug>\Biggl'
exe s:pA16.'-sepbigr- :'
exe s:pA16.'bigr<Tab>                   <plug>\bigr'
exe s:pA16.'Bigr<Tab>                   <plug>\Bigr'
exe s:pA16.'biggr<Tab>                  <plug>\biggr'
exe s:pA16.'Biggr<Tab>                  <plug>\Biggr'
exe s:pA16.'-sepbig- :'
exe s:pA16.'big<Tab>                    <plug>\big'
exe s:pA16.'bigm<Tab>                   <plug>\bigm'
exe s:pA16.'-sepfloor- :'
exe s:pA16.'lfloor<Tab>⌊                 <plug>\lfloor '
exe s:pA16.'lceil<Tab>⌈                  <plug>\lceil '
exe s:pA16.'rfloor<Tab>⌋                 <plug>\rfloor '
exe s:pA16.'rceil<Tab>⌉                  <plug>\rceil '
exe s:pA16.'-sepangle- :'
exe s:pA16.'langle<Tab>〈                 <plug>\langle '
exe s:pA16.'rangle<Tab>〉                 <plug>\rangle '
" }}}
" {{{ Limits2
let s:pA16a = s:pA."&Limits2."
exe s:pA16a.'ulcorner<Tab>⌜            <plug>\ulcorner '
exe s:pA16a.'urcorner<Tab>⌝            <plug>\urcorner '
exe s:pA16a.'llcorner<Tab>⌞            <plug>\llcorner '
exe s:pA16a.'rlcorner<Tab>⌟            <plug>\rlcorner '
exe s:pA16a.'-sepcorner- :'
exe s:pA16a.'vert<Tab>\|               <plug>\vert '
exe s:pA16a.'Vert<Tab>∥                <plug>\Vert '
exe s:pA16a.'lvert<Tab>                <plug>\lvert '
exe s:pA16a.'lVert<Tab>                <plug>\lVert '
exe s:pA16a.'rvert<Tab>                <plug>\rvert '
exe s:pA16a.'rVert<Tab>                <plug>\rVert '
exe s:pA16a.'uparrow<Tab>↑             <plug>\uparrow '
exe s:pA16a.'Uparrow<Tab>⇑             <plug>\Uparrow '
exe s:pA16a.'downarrow<Tab>↓           <plug>\downarrow '
exe s:pA16a.'Downarrow<Tab>⇓           <plug>\Downarrow '
exe s:pA16a.'updownarrow<Tab>↕         <plug>\updownarrow '
exe s:pA16a.'Updownarrow<Tab>⇕         <plug>\Updownarrow '
exe s:pA16a.'lgroup<Tab>               <plug>\lgroup '
exe s:pA16a.'rgroup<Tab>               <plug>\rgroup '
exe s:pA16a.'lmoustache<Tab>∫          <plug>\lmoustache '
exe s:pA16a.'rmoustache<Tab>           <plug>\rmoustache '
exe s:pA16a.'arrowvert<Tab>            <plug>\arrowvert '
exe s:pA16a.'Arrowvert<Tab>            <plug>\Arrowvert '
exe s:pA16a.'bracevert<Tab>            <plug>\bracevert '
" }}}
" {{{ Log-likes
let s:pA17 = s:pA."Lo&g-likes."
exe s:pA17.'arccos<Tab>                 <plug>\arccos '
exe s:pA17.'arcsin<Tab>                 <plug>\arcsin '
exe s:pA17.'arctan<Tab>                 <plug>\arctan '
exe s:pA17.'arg<Tab>                    <plug>\arg '
exe s:pA17.'cos<Tab>                    <plug>\cos '
exe s:pA17.'cosh<Tab>                   <plug>\cosh '
exe s:pA17.'cot<Tab>                    <plug>\cot '
exe s:pA17.'coth<Tab>                   <plug>\coth '
exe s:pA17.'csc<Tab>                    <plug>\csc '
exe s:pA17.'deg<Tab>                    <plug>\deg '
exe s:pA17.'det<Tab>                    <plug>\det '
exe s:pA17.'dim<Tab>                    <plug>\dim '
exe s:pA17.'exp<Tab>                    <plug>\exp '
exe s:pA17.'gcd<Tab>                    <plug>\gcd '
exe s:pA17.'hom<Tab>                    <plug>\hom '
exe s:pA17.'inf<Tab>                    <plug>\inf '
exe s:pA17.'injlim<Tab>                 <plug>\injlim '
exe s:pA17.'ker<Tab>                    <plug>\ker '
exe s:pA17.'lg<Tab>                     <plug>\lg '
exe s:pA17.'lim<Tab>                    <plug>\lim '
exe s:pA17.'liminf<Tab>                 <plug>\liminf '
exe s:pA17.'limsup<Tab>                 <plug>\limsup '
exe s:pA17.'ln<Tab>                     <plug>\ln '
exe s:pA17.'log<Tab>                    <plug>\log '
exe s:pA17.'max<Tab>                    <plug>\max '
exe s:pA17.'min<Tab>                    <plug>\min '
exe s:pA17.'Pr<Tab>                     <plug>\Pr '
exe s:pA17.'projlim<Tab>                <plug>\projlim '
exe s:pA17.'sec<Tab>                    <plug>\sec '
exe s:pA17.'sin<Tab>                    <plug>\sin '
exe s:pA17.'sinh<Tab>                   <plug>\sinh '
exe s:pA17.'sup<Tab>                    <plug>\sup '
exe s:pA17.'tan<Tab>                    <plug>\tan '
exe s:pA17.'tanh<Tab>                   <plug>\tanh '
exe s:pA17.'varlimsup<Tab>              <plug>\varlimsup '
exe s:pA17.'varliminf<Tab>              <plug>\varliminf '
exe s:pA17.'varinjlim<Tab>              <plug>\varinjlim '
exe s:pA17.'varprojlim<Tab>             <plug>\varprojlim '
" }}}
" {{{ MathSpacing
let s:pA18 = s:pA."MathSpacing."
exe s:pA18.',                       <plug>\, '
exe s:pA18.':                       <plug>\: '
exe s:pA18.';                       <plug>\; '
exe s:pA18.'[space]                 <plug>\  '
exe s:pA18.'quad<Tab>               <plug>\quad '
exe s:pA18.'qquad<Tab>              <plug>\qquad '
exe s:pA18.'!                       <plug>\! '
exe s:pA18.'thinspace<Tab>          <plug>\thinspace '
exe s:pA18.'medspace<Tab>           <plug>\medspace '
exe s:pA18.'thickspace<Tab>         <plug>\thickspace '
exe s:pA18.'negthinspace<Tab>       <plug>\negthinspace '
exe s:pA18.'negmedspace<Tab>        <plug>\negmedspace '
exe s:pA18.'negthickspace<Tab>      <plug>\negthickspace '
" 1}}}

" vim:fdm=marker:ff=unix:noet:ts=4:sw=4:fenc=utf-8
