/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.plugin.use.resolve.internal;

import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.internal.artifacts.DependencyResolutionServices;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.strategy.VersionSelectorScheme;
import org.gradle.plugin.internal.PluginId;
import org.gradle.plugin.use.internal.InvalidPluginRequestException;
import org.gradle.plugin.use.internal.PluginRequest;
import org.gradle.plugin.use.resolve.internal.PluginResolution;
import org.gradle.plugin.use.resolve.internal.PluginResolutionResult;
import org.gradle.plugin.use.resolve.internal.PluginResolveContext;
import org.gradle.plugin.use.resolve.internal.PluginResolver;

public class ArtifactRepositoryPluginResolver
implements PluginResolver {
    private static final String PLUGIN_MARKER_SUFFIX = ".gradle.plugin";
    private String name;
    private final DependencyResolutionServices resolution;
    private final VersionSelectorScheme versionSelectorScheme;

    public ArtifactRepositoryPluginResolver(String name, DependencyResolutionServices resolution, VersionSelectorScheme versionSelectorScheme) {
        this.name = name;
        this.resolution = resolution;
        this.versionSelectorScheme = versionSelectorScheme;
    }

    public void resolve(PluginRequest pluginRequest, PluginResolutionResult result) throws InvalidPluginRequestException {
        if (pluginRequest.getVersion() == null) {
            result.notFound(this.name, "plugin dependency must include a version number for this source");
            return;
        }
        if (pluginRequest.getVersion().endsWith("-SNAPSHOT")) {
            result.notFound(this.name, "snapshot plugin versions are not supported");
            return;
        }
        if (this.versionSelectorScheme.parseSelector(pluginRequest.getVersion()).isDynamic()) {
            result.notFound(this.name, "dynamic plugin versions are not supported");
            return;
        }
        if (this.exists(pluginRequest)) {
            this.handleFound(pluginRequest, result);
        } else {
            this.handleNotFound(pluginRequest, result);
        }
    }

    private boolean exists(PluginRequest request) {
        Dependency dependency = this.resolution.getDependencyHandler().create((Object)this.getMarkerCoordinates(request));
        ConfigurationContainer configurations = this.resolution.getConfigurationContainer();
        Configuration configuration = configurations.detachedConfiguration(new Dependency[]{dependency});
        configuration.setTransitive(false);
        return !configuration.getResolvedConfiguration().hasError();
    }

    private void handleFound(final PluginRequest pluginRequest, PluginResolutionResult result) {
        result.found(this.name, new PluginResolution(){

            public PluginId getPluginId() {
                return pluginRequest.getId();
            }

            public void execute(PluginResolveContext context) {
                context.addLegacy(pluginRequest.getId(), ArtifactRepositoryPluginResolver.this.getMarkerCoordinates(pluginRequest));
            }
        });
    }

    private void handleNotFound(PluginRequest pluginRequest, PluginResolutionResult result) {
        result.notFound(this.name, String.format("Could not resolve plugin artifact '%s'", this.getMarkerCoordinates(pluginRequest)));
    }

    private String getMarkerCoordinates(PluginRequest pluginRequest) {
        return pluginRequest.getId() + ":" + pluginRequest.getId() + PLUGIN_MARKER_SUFFIX + ":" + pluginRequest.getVersion();
    }
}

