/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.runtime;

import java.lang.reflect.Array;
import java.nio.channels.ClosedChannelException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import jnr.constants.platform.Errno;
import org.jcodings.Encoding;
import org.jcodings.specific.ASCIIEncoding;
import org.jcodings.specific.USASCIIEncoding;
import org.jcodings.specific.UTF8Encoding;
import org.jcodings.unicode.UnicodeEncoding;
import org.jruby.AbstractRubyMethod;
import org.jruby.MetaClass;
import org.jruby.NativeException;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyBasicObject;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyEncoding;
import org.jruby.RubyException;
import org.jruby.RubyFixnum;
import org.jruby.RubyFloat;
import org.jruby.RubyHash;
import org.jruby.RubyKernel;
import org.jruby.RubyLocalJumpError;
import org.jruby.RubyMatchData;
import org.jruby.RubyModule;
import org.jruby.RubyProc;
import org.jruby.RubyRegexp;
import org.jruby.RubyString;
import org.jruby.RubySymbol;
import org.jruby.ast.ArgsNode;
import org.jruby.ast.ArgumentNode;
import org.jruby.ast.DAsgnNode;
import org.jruby.ast.LocalAsgnNode;
import org.jruby.ast.MultipleAsgnNode;
import org.jruby.ast.Node;
import org.jruby.ast.OptArgNode;
import org.jruby.ast.RequiredKeywordArgumentValueNode;
import org.jruby.ast.UnnamedRestArgNode;
import org.jruby.ast.types.INameNode;
import org.jruby.ast.util.ArgsUtil;
import org.jruby.common.IRubyWarnings;
import org.jruby.exceptions.RaiseException;
import org.jruby.exceptions.Unrescuable;
import org.jruby.internal.runtime.methods.DynamicMethod;
import org.jruby.internal.runtime.methods.IRMethodArgs;
import org.jruby.internal.runtime.methods.MethodArgs2;
import org.jruby.internal.runtime.methods.UndefinedMethod;
import org.jruby.internal.runtime.methods.WrapperMethod;
import org.jruby.ir.IRScopeType;
import org.jruby.ir.operands.UndefinedValue;
import org.jruby.ir.runtime.IRRuntimeHelpers;
import org.jruby.javasupport.JavaClass;
import org.jruby.javasupport.JavaUtil;
import org.jruby.parser.StaticScope;
import org.jruby.platform.Platform;
import org.jruby.runtime.ArgumentDescriptor;
import org.jruby.runtime.ArgumentType;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Block;
import org.jruby.runtime.CallSite;
import org.jruby.runtime.CallType;
import org.jruby.runtime.ClassIndex;
import org.jruby.runtime.DynamicScope;
import org.jruby.runtime.Signature;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.backtrace.BacktraceData;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.invokedynamic.MethodNames;
import org.jruby.util.ByteList;
import org.jruby.util.CodegenUtils;
import org.jruby.util.DefinedMessage;
import org.jruby.util.JavaNameMangler;
import org.jruby.util.StringSupport;
import org.jruby.util.TypeConverter;
import org.jruby.util.io.EncodingUtils;

public class Helpers {
    public static final int MAX_SPECIFIC_ARITY_OBJECT_ARRAY = 10;
    public static final int MAX_SPECIFIC_ARITY_HASH = 5;

    public static CallSite selectAttrAsgnCallSite(IRubyObject receiver2, IRubyObject self2, CallSite normalSite, CallSite variableSite) {
        if (receiver2 == self2) {
            return variableSite;
        }
        return normalSite;
    }

    public static IRubyObject doAttrAsgn(IRubyObject receiver2, CallSite callSite, IRubyObject value2, ThreadContext context, IRubyObject caller) {
        callSite.call(context, caller, receiver2, value2);
        return value2;
    }

    public static IRubyObject doAttrAsgn(IRubyObject receiver2, CallSite callSite, IRubyObject arg0, IRubyObject value2, ThreadContext context, IRubyObject caller) {
        callSite.call(context, caller, receiver2, arg0, value2);
        return value2;
    }

    public static IRubyObject doAttrAsgn(IRubyObject receiver2, CallSite callSite, IRubyObject arg0, IRubyObject arg1, IRubyObject value2, ThreadContext context, IRubyObject caller) {
        callSite.call(context, caller, receiver2, arg0, arg1, value2);
        return value2;
    }

    public static IRubyObject doAttrAsgn(IRubyObject receiver2, CallSite callSite, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2, IRubyObject value2, ThreadContext context, IRubyObject caller) {
        callSite.call(context, caller, receiver2, arg0, arg1, arg2, value2);
        return value2;
    }

    public static IRubyObject doAttrAsgn(IRubyObject receiver2, CallSite callSite, IRubyObject[] args2, ThreadContext context, IRubyObject caller) {
        callSite.call(context, caller, receiver2, args2);
        return args2[args2.length - 1];
    }

    public static IRubyObject doAttrAsgn(IRubyObject receiver2, CallSite callSite, IRubyObject[] args2, IRubyObject value2, ThreadContext context, IRubyObject caller) {
        IRubyObject[] newArgs = new IRubyObject[args2.length + 1];
        System.arraycopy(args2, 0, newArgs, 0, args2.length);
        newArgs[args2.length] = value2;
        callSite.call(context, caller, receiver2, newArgs);
        return value2;
    }

    public static boolean invokeEqqForCaseWhen(CallSite callSite, ThreadContext context, IRubyObject caller, IRubyObject arg2, IRubyObject[] receivers) {
        for (int i2 = 0; i2 < receivers.length; ++i2) {
            IRubyObject receiver2 = receivers[i2];
            if (!Helpers.invokeEqqForCaseWhen(callSite, context, caller, arg2, receiver2)) continue;
            return true;
        }
        return false;
    }

    public static boolean invokeEqqForCaseWhen(CallSite callSite, ThreadContext context, IRubyObject caller, IRubyObject arg2, IRubyObject receiver2) {
        IRubyObject result2 = callSite.call(context, caller, receiver2, arg2);
        return result2.isTrue();
    }

    public static boolean invokeEqqForCaseWhen(CallSite callSite, ThreadContext context, IRubyObject caller, IRubyObject arg2, IRubyObject receiver0, IRubyObject receiver1) {
        IRubyObject result2 = callSite.call(context, caller, receiver0, arg2);
        if (result2.isTrue()) {
            return true;
        }
        return Helpers.invokeEqqForCaseWhen(callSite, context, caller, arg2, receiver1);
    }

    public static boolean invokeEqqForCaseWhen(CallSite callSite, ThreadContext context, IRubyObject caller, IRubyObject arg2, IRubyObject receiver0, IRubyObject receiver1, IRubyObject receiver2) {
        IRubyObject result2 = callSite.call(context, caller, receiver0, arg2);
        if (result2.isTrue()) {
            return true;
        }
        return Helpers.invokeEqqForCaseWhen(callSite, context, caller, arg2, receiver1, receiver2);
    }

    public static boolean invokeEqqForCaselessWhen(IRubyObject[] receivers) {
        for (int i2 = 0; i2 < receivers.length; ++i2) {
            if (!receivers[i2].isTrue()) continue;
            return true;
        }
        return false;
    }

    public static boolean invokeEqqForCaselessWhen(IRubyObject receiver2) {
        return receiver2.isTrue();
    }

    public static boolean invokeEqqForCaselessWhen(IRubyObject receiver0, IRubyObject receiver1) {
        return receiver0.isTrue() || receiver1.isTrue();
    }

    public static boolean invokeEqqForCaselessWhen(IRubyObject receiver0, IRubyObject receiver1, IRubyObject receiver2) {
        return receiver0.isTrue() || receiver1.isTrue() || receiver2.isTrue();
    }

    public static String[] parseBlockDescriptor(String descriptor) {
        String[] mangled = descriptor.split(":");
        mangled[0] = JavaNameMangler.demangleMethodName(mangled[0]);
        mangled[4] = JavaNameMangler.demangleMethodName(mangled[4]);
        return mangled;
    }

    public static RubyClass getSingletonClass(Ruby runtime, IRubyObject receiver2) {
        if (receiver2 instanceof RubyFixnum || receiver2 instanceof RubySymbol) {
            throw runtime.newTypeError("can't define singleton");
        }
        return receiver2.getSingletonClass();
    }

    @Deprecated
    public static IRubyObject invokeMethodMissing(IRubyObject receiver2, String name2, IRubyObject[] args2) {
        ThreadContext context = receiver2.getRuntime().getCurrentContext();
        context.setLastCallStatusAndVisibility(CallType.FUNCTIONAL, Visibility.PUBLIC);
        if (name2.equals("method_missing")) {
            return RubyKernel.method_missing(context, receiver2, args2, Block.NULL_BLOCK);
        }
        IRubyObject[] newArgs = Helpers.prepareMethodMissingArgs(args2, context, name2);
        return Helpers.invoke(context, receiver2, "method_missing", newArgs, Block.NULL_BLOCK);
    }

    public static IRubyObject callMethodMissing(ThreadContext context, IRubyObject receiver2, Visibility visibility, String name2, CallType callType, IRubyObject[] args2, Block block) {
        return Helpers.selectMethodMissing(context, receiver2, visibility, name2, callType).call(context, receiver2, (RubyModule)receiver2.getMetaClass(), name2, args2, block);
    }

    public static IRubyObject callMethodMissing(ThreadContext context, IRubyObject receiver2, Visibility visibility, String name2, CallType callType, IRubyObject arg0, Block block) {
        return Helpers.selectMethodMissing(context, receiver2, visibility, name2, callType).call(context, receiver2, (RubyModule)receiver2.getMetaClass(), name2, arg0, block);
    }

    public static IRubyObject callMethodMissing(ThreadContext context, IRubyObject receiver2, Visibility visibility, String name2, CallType callType, IRubyObject arg0, IRubyObject arg1, Block block) {
        return Helpers.selectMethodMissing(context, receiver2, visibility, name2, callType).call(context, receiver2, (RubyModule)receiver2.getMetaClass(), name2, arg0, arg1, block);
    }

    public static IRubyObject callMethodMissing(ThreadContext context, IRubyObject receiver2, Visibility visibility, String name2, CallType callType, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2, Block block) {
        return Helpers.selectMethodMissing(context, receiver2, visibility, name2, callType).call(context, receiver2, receiver2.getMetaClass(), name2, arg0, arg1, arg2, block);
    }

    public static IRubyObject callMethodMissing(ThreadContext context, IRubyObject receiver2, Visibility visibility, String name2, CallType callType, Block block) {
        return Helpers.selectMethodMissing(context, receiver2, visibility, name2, callType).call(context, receiver2, (RubyModule)receiver2.getMetaClass(), name2, block);
    }

    public static DynamicMethod selectMethodMissing(ThreadContext context, IRubyObject receiver2, Visibility visibility, String name2, CallType callType) {
        Ruby runtime = context.runtime;
        if (name2.equals("method_missing")) {
            return Helpers.selectInternalMM(runtime, visibility, callType);
        }
        DynamicMethod methodMissing = receiver2.getMetaClass().searchMethod("method_missing");
        if (methodMissing.isUndefined() || methodMissing.equals(runtime.getDefaultMethodMissing())) {
            return Helpers.selectInternalMM(runtime, visibility, callType);
        }
        return new MethodMissingMethod(methodMissing, visibility, callType);
    }

    public static DynamicMethod selectMethodMissing(ThreadContext context, RubyClass selfClass, Visibility visibility, String name2, CallType callType) {
        Ruby runtime = context.runtime;
        if (name2.equals("method_missing")) {
            return Helpers.selectInternalMM(runtime, visibility, callType);
        }
        DynamicMethod methodMissing = selfClass.searchMethod("method_missing");
        if (methodMissing.isUndefined() || methodMissing.equals(runtime.getDefaultMethodMissing())) {
            return Helpers.selectInternalMM(runtime, visibility, callType);
        }
        return new MethodMissingMethod(methodMissing, visibility, callType);
    }

    public static DynamicMethod selectMethodMissing(RubyClass selfClass, Visibility visibility, String name2, CallType callType) {
        Ruby runtime = selfClass.getClassRuntime();
        if (name2.equals("method_missing")) {
            return Helpers.selectInternalMM(runtime, visibility, callType);
        }
        DynamicMethod methodMissing = selfClass.searchMethod("method_missing");
        if (methodMissing.isUndefined() || methodMissing.equals(runtime.getDefaultMethodMissing())) {
            return Helpers.selectInternalMM(runtime, visibility, callType);
        }
        return new MethodMissingMethod(methodMissing, visibility, callType);
    }

    public static final Map<String, String> map(String ... keyValues) {
        HashMap<String, String> map = new HashMap<String, String>(keyValues.length / 2);
        int i2 = 0;
        while (i2 < keyValues.length) {
            map.put(keyValues[i2++], keyValues[i2++]);
        }
        return map;
    }

    public static boolean additionOverflowed(long original, long other, long result2) {
        return ((original ^ other ^ 0xFFFFFFFFFFFFFFFFL) & (original ^ result2) & Long.MIN_VALUE) != 0L;
    }

    public static boolean subtractionOverflowed(long original, long other, long result2) {
        return ((original ^ (other ^ 0xFFFFFFFFFFFFFFFFL) ^ 0xFFFFFFFFFFFFFFFFL) & (original ^ result2) & Long.MIN_VALUE) != 0L;
    }

    public static Errno errnoFromException(Throwable t) {
        if (t instanceof ClosedChannelException) {
            return Errno.EBADF;
        }
        if (t.getMessage() != null) {
            String errorMessage = t.getMessage();
            if ("Bad file descriptor".equals(errorMessage)) {
                return Errno.EBADF;
            }
            if ("File not open".equals(errorMessage)) {
                return null;
            }
            if ("An established connection was aborted by the software in your host machine".equals(errorMessage)) {
                return Errno.ECONNABORTED;
            }
            if (t.getMessage().equals("Broken pipe")) {
                return Errno.EPIPE;
            }
            if ("Connection reset by peer".equals(errorMessage) || "An existing connection was forcibly closed by the remote host".equals(errorMessage) || Platform.IS_WINDOWS && errorMessage.contains("connection was aborted")) {
                return Errno.ECONNRESET;
            }
            if (errorMessage.equals("No space left on device")) {
                return Errno.ENOSPC;
            }
            if (errorMessage.equals("Too many open files")) {
                return Errno.EMFILE;
            }
        }
        return null;
    }

    public static RubyModule getNthScopeModule(StaticScope scope, int depth) {
        int n = depth;
        while (n > 0) {
            if ((scope = scope.getEnclosingScope()).getScopeType() == null) continue;
            --n;
        }
        return scope.getModule();
    }

    public static RubyArray viewArgsArray(ThreadContext context, RubyArray rubyArray, int preArgsCount, int postArgsCount) {
        int n = rubyArray.getLength();
        if (preArgsCount + postArgsCount >= n) {
            return RubyArray.newEmptyArray(context.runtime);
        }
        return (RubyArray)rubyArray.subseq(context.runtime.getArray(), preArgsCount, n - preArgsCount - postArgsCount, true);
    }

    public static Class[] getStaticMethodParams(Class target, int args2) {
        switch (args2) {
            case 0: {
                return new Class[]{target, ThreadContext.class, IRubyObject.class, Block.class};
            }
            case 1: {
                return new Class[]{target, ThreadContext.class, IRubyObject.class, IRubyObject.class, Block.class};
            }
            case 2: {
                return new Class[]{target, ThreadContext.class, IRubyObject.class, IRubyObject.class, IRubyObject.class, Block.class};
            }
            case 3: {
                return new Class[]{target, ThreadContext.class, IRubyObject.class, IRubyObject.class, IRubyObject.class, IRubyObject.class, Block.class};
            }
            case 4: {
                return new Class[]{target, ThreadContext.class, IRubyObject.class, IRubyObject[].class, Block.class};
            }
        }
        throw new RuntimeException("unsupported arity: " + args2);
    }

    public static String getStaticMethodSignature(String classname, int args2) {
        switch (args2) {
            case 0: {
                return CodegenUtils.sig(IRubyObject.class, "L" + classname + ";", ThreadContext.class, IRubyObject.class, Block.class);
            }
            case 1: {
                return CodegenUtils.sig(IRubyObject.class, "L" + classname + ";", ThreadContext.class, IRubyObject.class, IRubyObject.class, Block.class);
            }
            case 2: {
                return CodegenUtils.sig(IRubyObject.class, "L" + classname + ";", ThreadContext.class, IRubyObject.class, IRubyObject.class, IRubyObject.class, Block.class);
            }
            case 3: {
                return CodegenUtils.sig(IRubyObject.class, "L" + classname + ";", ThreadContext.class, IRubyObject.class, IRubyObject.class, IRubyObject.class, IRubyObject.class, Block.class);
            }
            case 4: {
                return CodegenUtils.sig(IRubyObject.class, "L" + classname + ";", ThreadContext.class, IRubyObject.class, IRubyObject[].class, Block.class);
            }
        }
        throw new RuntimeException("unsupported arity: " + args2);
    }

    private static DynamicMethod selectInternalMM(Ruby runtime, Visibility visibility, CallType callType) {
        if (visibility == Visibility.PRIVATE) {
            return runtime.getPrivateMethodMissing();
        }
        if (visibility == Visibility.PROTECTED) {
            return runtime.getProtectedMethodMissing();
        }
        if (callType == CallType.VARIABLE) {
            return runtime.getVariableMethodMissing();
        }
        if (callType == CallType.SUPER) {
            return runtime.getSuperMethodMissing();
        }
        return runtime.getNormalMethodMissing();
    }

    private static IRubyObject[] prepareMethodMissingArgs(IRubyObject[] args2, ThreadContext context, String name2) {
        IRubyObject[] newArgs = new IRubyObject[args2.length + 1];
        System.arraycopy(args2, 0, newArgs, 1, args2.length);
        newArgs[0] = context.runtime.newSymbol(name2);
        return newArgs;
    }

    public static IRubyObject invoke(ThreadContext context, IRubyObject self2, String name2, Block block) {
        return self2.getMetaClass().finvoke(context, self2, name2, block);
    }

    public static IRubyObject invoke(ThreadContext context, IRubyObject self2, String name2, IRubyObject arg0, Block block) {
        return self2.getMetaClass().finvoke(context, self2, name2, arg0, block);
    }

    public static IRubyObject invoke(ThreadContext context, IRubyObject self2, String name2, IRubyObject arg0, IRubyObject arg1, Block block) {
        return self2.getMetaClass().finvoke(context, self2, name2, arg0, arg1, block);
    }

    public static IRubyObject invoke(ThreadContext context, IRubyObject self2, String name2, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2, Block block) {
        return self2.getMetaClass().finvoke(context, self2, name2, arg0, arg1, arg2, block);
    }

    public static IRubyObject invoke(ThreadContext context, IRubyObject self2, String name2, IRubyObject[] args2, Block block) {
        return self2.getMetaClass().finvoke(context, self2, name2, args2, block);
    }

    public static IRubyObject invoke(ThreadContext context, IRubyObject self2, String name2) {
        return self2.getMetaClass().finvoke(context, self2, name2);
    }

    public static IRubyObject invoke(ThreadContext context, IRubyObject self2, String name2, IRubyObject arg0) {
        return self2.getMetaClass().finvoke(context, self2, name2, arg0);
    }

    public static IRubyObject invoke(ThreadContext context, IRubyObject self2, String name2, IRubyObject arg0, IRubyObject arg1) {
        return self2.getMetaClass().finvoke(context, self2, name2, arg0, arg1);
    }

    public static IRubyObject invoke(ThreadContext context, IRubyObject self2, String name2, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2) {
        return self2.getMetaClass().finvoke(context, self2, name2, arg0, arg1, arg2);
    }

    public static IRubyObject invoke(ThreadContext context, IRubyObject self2, String name2, IRubyObject ... args2) {
        return self2.getMetaClass().finvoke(context, self2, name2, args2);
    }

    public static IRubyObject invoke(ThreadContext context, IRubyObject self2, String name2, CallType callType) {
        return Helpers.invoke(context, self2, name2, IRubyObject.NULL_ARRAY, callType, Block.NULL_BLOCK);
    }

    public static IRubyObject invoke(ThreadContext context, IRubyObject self2, String name2, IRubyObject[] args2, CallType callType, Block block) {
        return self2.getMetaClass().invoke(context, self2, name2, args2, callType, block);
    }

    public static IRubyObject invoke(ThreadContext context, IRubyObject self2, String name2, IRubyObject arg2, CallType callType, Block block) {
        return self2.getMetaClass().invoke(context, self2, name2, arg2, callType, block);
    }

    public static IRubyObject invokeAs(ThreadContext context, RubyClass asClass, IRubyObject self2, String name2, IRubyObject[] args2, Block block) {
        return asClass.finvoke(context, self2, name2, args2, block);
    }

    public static IRubyObject invokeAs(ThreadContext context, RubyClass asClass, IRubyObject self2, String name2, Block block) {
        return asClass.finvoke(context, self2, name2, block);
    }

    public static IRubyObject invokeAs(ThreadContext context, RubyClass asClass, IRubyObject self2, String name2, IRubyObject arg0, Block block) {
        return asClass.finvoke(context, self2, name2, arg0, block);
    }

    public static IRubyObject invokeAs(ThreadContext context, RubyClass asClass, IRubyObject self2, String name2, IRubyObject arg0, IRubyObject arg1, Block block) {
        return asClass.finvoke(context, self2, name2, arg0, arg1, block);
    }

    public static IRubyObject invokeAs(ThreadContext context, RubyClass asClass, IRubyObject self2, String name2, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2, Block block) {
        return asClass.finvoke(context, self2, name2, arg0, arg1, arg2, block);
    }

    public static IRubyObject invokeChecked(ThreadContext context, IRubyObject self2, String name2) {
        return self2.getMetaClass().finvokeChecked(context, self2, name2);
    }

    public static IRubyObject invokeChecked(ThreadContext context, IRubyObject self2, String name2, IRubyObject ... args2) {
        return self2.getMetaClass().finvokeChecked(context, self2, name2, args2);
    }

    public static IRubyObject invokeSuper(ThreadContext context, IRubyObject self2, IRubyObject[] args2, Block block) {
        return Helpers.invokeSuper(context, self2, context.getFrameKlazz(), context.getFrameName(), args2, block);
    }

    public static IRubyObject invokeSuper(ThreadContext context, IRubyObject self2, RubyModule klass, String name2, IRubyObject[] args2, Block block) {
        UndefinedMethod method;
        Helpers.checkSuperDisabledOrOutOfMethod(context, klass, name2);
        RubyClass superClass = Helpers.findImplementerIfNecessary(self2.getMetaClass(), klass).getSuperClass();
        DynamicMethod dynamicMethod = method = superClass != null ? superClass.searchMethod(name2) : UndefinedMethod.INSTANCE;
        if (method.isUndefined()) {
            return Helpers.callMethodMissing(context, self2, method.getVisibility(), name2, CallType.SUPER, args2, block);
        }
        return ((DynamicMethod)method).call(context, self2, (RubyModule)superClass, name2, args2, block);
    }

    public static IRubyObject invokeSuper(ThreadContext context, IRubyObject self2, Block block) {
        UndefinedMethod method;
        Helpers.checkSuperDisabledOrOutOfMethod(context);
        RubyModule klazz = context.getFrameKlazz();
        String name2 = context.getFrameName();
        RubyClass superClass = Helpers.findImplementerIfNecessary(self2.getMetaClass(), klazz).getSuperClass();
        DynamicMethod dynamicMethod = method = superClass != null ? superClass.searchMethod(name2) : UndefinedMethod.INSTANCE;
        if (method.isUndefined()) {
            return Helpers.callMethodMissing(context, self2, method.getVisibility(), name2, CallType.SUPER, block);
        }
        return method.call(context, self2, (RubyModule)superClass, name2, block);
    }

    public static IRubyObject invokeSuper(ThreadContext context, IRubyObject self2, IRubyObject arg0, Block block) {
        UndefinedMethod method;
        Helpers.checkSuperDisabledOrOutOfMethod(context);
        RubyModule klazz = context.getFrameKlazz();
        String name2 = context.getFrameName();
        RubyClass superClass = Helpers.findImplementerIfNecessary(self2.getMetaClass(), klazz).getSuperClass();
        DynamicMethod dynamicMethod = method = superClass != null ? superClass.searchMethod(name2) : UndefinedMethod.INSTANCE;
        if (method.isUndefined()) {
            return Helpers.callMethodMissing(context, self2, method.getVisibility(), name2, CallType.SUPER, arg0, block);
        }
        return method.call(context, self2, (RubyModule)superClass, name2, arg0, block);
    }

    public static IRubyObject invokeSuper(ThreadContext context, IRubyObject self2, IRubyObject arg0, IRubyObject arg1, Block block) {
        UndefinedMethod method;
        Helpers.checkSuperDisabledOrOutOfMethod(context);
        RubyModule klazz = context.getFrameKlazz();
        String name2 = context.getFrameName();
        RubyClass superClass = Helpers.findImplementerIfNecessary(self2.getMetaClass(), klazz).getSuperClass();
        DynamicMethod dynamicMethod = method = superClass != null ? superClass.searchMethod(name2) : UndefinedMethod.INSTANCE;
        if (method.isUndefined()) {
            return Helpers.callMethodMissing(context, self2, method.getVisibility(), name2, CallType.SUPER, arg0, arg1, block);
        }
        return method.call(context, self2, (RubyModule)superClass, name2, arg0, arg1, block);
    }

    public static IRubyObject invokeSuper(ThreadContext context, IRubyObject self2, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2, Block block) {
        UndefinedMethod method;
        Helpers.checkSuperDisabledOrOutOfMethod(context);
        RubyModule klazz = context.getFrameKlazz();
        String name2 = context.getFrameName();
        RubyClass superClass = Helpers.findImplementerIfNecessary(self2.getMetaClass(), klazz).getSuperClass();
        DynamicMethod dynamicMethod = method = superClass != null ? superClass.searchMethod(name2) : UndefinedMethod.INSTANCE;
        if (method.isUndefined()) {
            return Helpers.callMethodMissing(context, self2, method.getVisibility(), name2, CallType.SUPER, arg0, arg1, arg2, block);
        }
        return method.call(context, self2, superClass, name2, arg0, arg1, arg2, block);
    }

    public static RubyArray ensureRubyArray(IRubyObject value2) {
        return Helpers.ensureRubyArray(value2.getRuntime(), value2);
    }

    public static RubyArray ensureRubyArray(Ruby runtime, IRubyObject value2) {
        return value2 instanceof RubyArray ? (RubyArray)value2 : RubyArray.newArray(runtime, value2);
    }

    public static RubyArray ensureMultipleAssignableRubyArray(IRubyObject value2, Ruby runtime, boolean masgnHasHead) {
        if (!(value2 instanceof RubyArray)) {
            value2 = ArgsUtil.convertToRubyArray19(runtime, value2, masgnHasHead);
        }
        return (RubyArray)value2;
    }

    public static IRubyObject nullToNil(IRubyObject value2, ThreadContext context) {
        return value2 != null ? value2 : context.nil;
    }

    public static IRubyObject nullToNil(IRubyObject value2, Ruby runtime) {
        return value2 != null ? value2 : runtime.getNil();
    }

    public static IRubyObject nullToNil(IRubyObject value2, IRubyObject nil) {
        return value2 != null ? value2 : nil;
    }

    public static RubyClass prepareSuperClass(Ruby runtime, IRubyObject rubyClass) {
        RubyClass.checkInheritable(rubyClass);
        return (RubyClass)rubyClass;
    }

    public static RubyModule prepareClassNamespace(ThreadContext context, StaticScope scope, IRubyObject rubyModule) {
        if ((rubyModule == null || rubyModule.isNil()) && (rubyModule = scope.getModule()) == null) {
            throw context.runtime.newTypeError("no outer class/module");
        }
        if (rubyModule instanceof RubyModule) {
            return (RubyModule)rubyModule;
        }
        throw context.runtime.newTypeError(rubyModule + " is not a class/module");
    }

    public static void handleArgumentSizes(ThreadContext context, Ruby runtime, int given, int required, int opt, int rest2) {
        if (opt == 0) {
            if (rest2 < 0 ? given != required : given < required) {
                throw runtime.newArgumentError("wrong number of arguments (" + given + " for " + required + ")");
            }
        } else if (rest2 < 0) {
            if (given < required) {
                throw runtime.newArgumentError("wrong number of arguments (" + given + " for " + required + ")");
            }
            if (given > required + opt) {
                throw runtime.newArgumentError("wrong number of arguments (" + given + " for " + (required + opt) + ")");
            }
        } else if (given < required) {
            throw runtime.newArgumentError("wrong number of arguments (" + given + " for " + required + ")");
        }
    }

    public static String getLocalJumpTypeOrRethrow(RaiseException re) {
        RubyException exception2 = re.getException();
        Ruby runtime = exception2.getRuntime();
        if (runtime.getLocalJumpError().isInstance(exception2)) {
            RubyLocalJumpError jumpError = (RubyLocalJumpError)re.getException();
            IRubyObject reason2 = jumpError.reason();
            return reason2.asJavaString();
        }
        throw re;
    }

    public static IRubyObject unwrapLocalJumpErrorValue(RaiseException re) {
        return ((RubyLocalJumpError)re.getException()).exit_value();
    }

    public static IRubyObject processBlockArgument(Ruby runtime, Block block) {
        if (!block.isGiven()) {
            return runtime.getNil();
        }
        return Helpers.processGivenBlock(block, runtime);
    }

    private static IRubyObject processGivenBlock(Block block, Ruby runtime) {
        RubyProc blockArg = block.getProcObject();
        if (blockArg == null) {
            blockArg = runtime.newBlockPassProc(Block.Type.PROC, block);
            blockArg.getBlock().type = Block.Type.PROC;
        }
        return blockArg;
    }

    public static Block getBlockFromBlockPassBody(Ruby runtime, IRubyObject proc, Block currentBlock) {
        if (proc.isNil()) {
            return Block.NULL_BLOCK;
        }
        if (!(proc instanceof RubyProc)) {
            proc = Helpers.coerceProc(proc, runtime);
        }
        return Helpers.getBlockFromProc(currentBlock, proc);
    }

    private static IRubyObject coerceProc(IRubyObject maybeProc, Ruby runtime) throws RaiseException {
        IRubyObject proc = TypeConverter.convertToType(maybeProc, runtime.getProc(), "to_proc", false);
        if (!(proc instanceof RubyProc)) {
            throw runtime.newTypeError("wrong argument type " + maybeProc.getMetaClass().getName() + " (expected Proc)");
        }
        return proc;
    }

    private static Block getBlockFromProc(Block currentBlock, IRubyObject proc) {
        RubyProc procObject;
        if (currentBlock != null && currentBlock.isGiven() && (procObject = currentBlock.getProcObject()) != null && procObject == proc) {
            return currentBlock;
        }
        return ((RubyProc)proc).getBlock();
    }

    public static Block getBlockFromBlockPassBody(IRubyObject proc, Block currentBlock) {
        return Helpers.getBlockFromBlockPassBody(proc.getRuntime(), proc, currentBlock);
    }

    public static IRubyObject backref(ThreadContext context) {
        return RubyRegexp.getBackRef(context);
    }

    public static IRubyObject backrefLastMatch(ThreadContext context) {
        IRubyObject backref = context.getBackRef();
        return RubyRegexp.last_match(backref);
    }

    public static IRubyObject backrefMatchPre(ThreadContext context) {
        IRubyObject backref = context.getBackRef();
        return RubyRegexp.match_pre(backref);
    }

    public static IRubyObject backrefMatchPost(ThreadContext context) {
        IRubyObject backref = context.getBackRef();
        return RubyRegexp.match_post(backref);
    }

    public static IRubyObject backrefMatchLast(ThreadContext context) {
        IRubyObject backref = context.getBackRef();
        return RubyRegexp.match_last(backref);
    }

    public static IRubyObject[] appendToObjectArray(IRubyObject[] array, IRubyObject add2) {
        IRubyObject[] newArray = new IRubyObject[array.length + 1];
        System.arraycopy(array, 0, newArray, 0, array.length);
        newArray[array.length] = add2;
        return newArray;
    }

    public static IRubyObject breakLocalJumpError(Ruby runtime, IRubyObject value2) {
        throw runtime.newLocalJumpError(RubyLocalJumpError.Reason.BREAK, value2, "unexpected break");
    }

    public static IRubyObject[] concatObjectArrays(IRubyObject[] array, IRubyObject[] add2) {
        return Helpers.toArray(array, add2);
    }

    public static IRubyObject[] toArray(IRubyObject[] array, IRubyObject ... add2) {
        IRubyObject[] newArray = new IRubyObject[array.length + add2.length];
        System.arraycopy(array, 0, newArray, 0, array.length);
        System.arraycopy(add2, 0, newArray, array.length, add2.length);
        return newArray;
    }

    public static IRubyObject[] toArray(IRubyObject obj, IRubyObject ... rest2) {
        IRubyObject[] newArray = new IRubyObject[rest2.length + 1];
        newArray[0] = obj;
        System.arraycopy(rest2, 0, newArray, 1, rest2.length);
        return newArray;
    }

    public static IRubyObject[] toArray(IRubyObject obj0, IRubyObject obj1, IRubyObject ... rest2) {
        IRubyObject[] newArray = new IRubyObject[rest2.length + 2];
        newArray[0] = obj0;
        newArray[1] = obj1;
        System.arraycopy(rest2, 0, newArray, 2, rest2.length);
        return newArray;
    }

    public static IRubyObject[] toArray(IRubyObject obj0, IRubyObject obj1, IRubyObject obj2, IRubyObject ... rest2) {
        IRubyObject[] newArray = new IRubyObject[rest2.length + 3];
        newArray[0] = obj0;
        newArray[1] = obj1;
        newArray[2] = obj2;
        System.arraycopy(rest2, 0, newArray, 3, rest2.length);
        return newArray;
    }

    public static IRubyObject isExceptionHandled(RubyException currentException, IRubyObject[] exceptions, ThreadContext context) {
        for (int i2 = 0; i2 < exceptions.length; ++i2) {
            IRubyObject result2 = Helpers.isExceptionHandled(currentException, exceptions[i2], context);
            if (!result2.isTrue()) continue;
            return result2;
        }
        return context.runtime.getFalse();
    }

    public static IRubyObject isExceptionHandled(RubyException currentException, IRubyObject exception2, ThreadContext context) {
        return Helpers.isExceptionHandled((IRubyObject)currentException, exception2, context);
    }

    public static IRubyObject isExceptionHandled(IRubyObject currentException, IRubyObject exception2, ThreadContext context) {
        Ruby runtime = context.runtime;
        if (!runtime.getModule().isInstance(exception2)) {
            throw runtime.newTypeError("class or module required for rescue clause");
        }
        IRubyObject result2 = Helpers.invoke(context, exception2, "===", currentException);
        if (result2.isTrue()) {
            return result2;
        }
        return runtime.getFalse();
    }

    public static IRubyObject isExceptionHandled(RubyException currentException, IRubyObject exception0, IRubyObject exception1, ThreadContext context) {
        IRubyObject result2 = Helpers.isExceptionHandled(currentException, exception0, context);
        if (result2.isTrue()) {
            return result2;
        }
        return Helpers.isExceptionHandled(currentException, exception1, context);
    }

    public static IRubyObject isExceptionHandled(RubyException currentException, IRubyObject exception0, IRubyObject exception1, IRubyObject exception2, ThreadContext context) {
        IRubyObject result2 = Helpers.isExceptionHandled(currentException, exception0, context);
        if (result2.isTrue()) {
            return result2;
        }
        return Helpers.isExceptionHandled(currentException, exception1, exception2, context);
    }

    public static boolean checkJavaException(Throwable throwable, IRubyObject catchable, ThreadContext context) {
        Ruby runtime = context.runtime;
        if (runtime.getException() == catchable || runtime.getObject() == catchable || runtime.getStandardError() == catchable) {
            if (throwable instanceof RaiseException) {
                return Helpers.isExceptionHandled(((RaiseException)throwable).getException(), catchable, context).isTrue();
            }
            return Helpers.isExceptionHandled(JavaUtil.convertJavaToUsableRubyObject(runtime, throwable), catchable, context).isTrue();
        }
        if (runtime.getNativeException() == catchable) {
            return true;
        }
        if (catchable instanceof RubyClass && catchable.getInstanceVariables().hasInstanceVariable("@java_class")) {
            Class cls;
            RubyClass rubyClass = (RubyClass)catchable;
            JavaClass javaClass = (JavaClass)rubyClass.getInstanceVariable("@java_class");
            if (javaClass != null && (cls = javaClass.javaClass()).isInstance(throwable)) {
                return true;
            }
        } else if (catchable instanceof RubyModule) {
            IRubyObject exception2 = JavaUtil.convertJavaToUsableRubyObject(runtime, throwable);
            IRubyObject result2 = Helpers.invoke(context, catchable, "===", exception2);
            return result2.isTrue();
        }
        return false;
    }

    public static IRubyObject isJavaExceptionHandled(Throwable currentThrowable, IRubyObject[] throwables, ThreadContext context) {
        if (currentThrowable instanceof Unrescuable) {
            Helpers.throwException(currentThrowable);
        }
        if (currentThrowable instanceof RaiseException) {
            return Helpers.isExceptionHandled(((RaiseException)currentThrowable).getException(), throwables, context);
        }
        if (throwables.length == 0) {
            return context.runtime.getTrue();
        }
        for (int i2 = 0; i2 < throwables.length; ++i2) {
            if (!Helpers.checkJavaException(currentThrowable, throwables[i2], context)) continue;
            return context.runtime.getTrue();
        }
        return context.runtime.getFalse();
    }

    public static IRubyObject isJavaExceptionHandled(Throwable currentThrowable, IRubyObject throwable, ThreadContext context) {
        if (currentThrowable instanceof Unrescuable) {
            Helpers.throwException(currentThrowable);
        }
        if (currentThrowable instanceof RaiseException) {
            return Helpers.isExceptionHandled(((RaiseException)currentThrowable).getException(), throwable, context);
        }
        if (Helpers.checkJavaException(currentThrowable, throwable, context)) {
            return context.runtime.getTrue();
        }
        return context.runtime.getFalse();
    }

    public static IRubyObject isJavaExceptionHandled(Throwable currentThrowable, IRubyObject throwable0, IRubyObject throwable1, ThreadContext context) {
        if (currentThrowable instanceof Unrescuable) {
            Helpers.throwException(currentThrowable);
        }
        if (currentThrowable instanceof RaiseException) {
            return Helpers.isExceptionHandled(((RaiseException)currentThrowable).getException(), throwable0, throwable1, context);
        }
        if (Helpers.checkJavaException(currentThrowable, throwable0, context)) {
            return context.runtime.getTrue();
        }
        if (Helpers.checkJavaException(currentThrowable, throwable1, context)) {
            return context.runtime.getTrue();
        }
        return context.runtime.getFalse();
    }

    public static IRubyObject isJavaExceptionHandled(Throwable currentThrowable, IRubyObject throwable0, IRubyObject throwable1, IRubyObject throwable2, ThreadContext context) {
        if (currentThrowable instanceof Unrescuable) {
            Helpers.throwException(currentThrowable);
        }
        if (currentThrowable instanceof RaiseException) {
            return Helpers.isExceptionHandled(((RaiseException)currentThrowable).getException(), throwable0, throwable1, throwable2, context);
        }
        if (Helpers.checkJavaException(currentThrowable, throwable0, context)) {
            return context.runtime.getTrue();
        }
        if (Helpers.checkJavaException(currentThrowable, throwable1, context)) {
            return context.runtime.getTrue();
        }
        if (Helpers.checkJavaException(currentThrowable, throwable2, context)) {
            return context.runtime.getTrue();
        }
        return context.runtime.getFalse();
    }

    public static void storeExceptionInErrorInfo(Throwable currentThrowable, ThreadContext context) {
        IRubyObject exception2 = null;
        exception2 = currentThrowable instanceof RaiseException ? ((RaiseException)currentThrowable).getException() : JavaUtil.convertJavaToUsableRubyObject(context.runtime, currentThrowable);
        context.setErrorInfo(exception2);
    }

    public static void storeNativeExceptionInErrorInfo(Throwable currentThrowable, ThreadContext context) {
        RubyException exception2 = null;
        if (currentThrowable instanceof RaiseException) {
            exception2 = ((RaiseException)currentThrowable).getException();
        } else {
            Ruby runtime = context.runtime;
            exception2 = new NativeException(runtime, runtime.getNativeException(), currentThrowable);
            ((NativeException)exception2).prepareIntegratedBacktrace(context, currentThrowable.getStackTrace());
        }
        context.setErrorInfo(exception2);
    }

    public static void clearErrorInfo(ThreadContext context) {
        context.setErrorInfo(context.runtime.getNil());
    }

    public static void checkSuperDisabledOrOutOfMethod(ThreadContext context) {
        Helpers.checkSuperDisabledOrOutOfMethod(context, context.getFrameKlazz(), context.getFrameName());
    }

    public static void checkSuperDisabledOrOutOfMethod(ThreadContext context, RubyModule klass, String name2) {
        if (klass == null) {
            if (name2 != null) {
                throw context.runtime.newNameError("superclass method '" + name2 + "' disabled", name2);
            }
            throw context.runtime.newNoMethodError("super called outside of method", null, context.nil);
        }
    }

    public static Block ensureSuperBlock(Block given, Block parent) {
        if (!given.isGiven()) {
            return parent;
        }
        return given;
    }

    public static RubyModule findImplementerIfNecessary(RubyModule clazz, RubyModule implementationClass) {
        if (implementationClass.needsImplementer()) {
            return clazz.findImplementer(implementationClass);
        }
        return implementationClass.getMethodLocation();
    }

    public static RubyArray createSubarray(RubyArray input, int start2) {
        return (RubyArray)input.subseqLight(start2, input.size() - start2);
    }

    public static RubyArray createSubarray(RubyArray input, int start2, int post) {
        return (RubyArray)input.subseqLight(start2, input.size() - post - start2);
    }

    public static RubyArray createSubarray(IRubyObject[] input, Ruby runtime, int start2) {
        if (start2 >= input.length) {
            return RubyArray.newEmptyArray(runtime);
        }
        return RubyArray.newArrayNoCopy(runtime, input, start2);
    }

    public static RubyArray createSubarray(IRubyObject[] input, Ruby runtime, int start2, int exclude) {
        int length2 = input.length - exclude - start2;
        if (length2 <= 0) {
            return RubyArray.newEmptyArray(runtime);
        }
        return RubyArray.newArrayNoCopy(runtime, input, start2, length2);
    }

    public static IRubyObject elementOrNull(IRubyObject[] input, int element) {
        if (element >= input.length) {
            return null;
        }
        return input[element];
    }

    public static IRubyObject optElementOrNull(IRubyObject[] input, int element, int postCount) {
        if (element + postCount >= input.length) {
            return null;
        }
        return input[element];
    }

    public static IRubyObject elementOrNil(IRubyObject[] input, int element, IRubyObject nil) {
        if (element >= input.length) {
            return nil;
        }
        return input[element];
    }

    public static IRubyObject postElementOrNil(IRubyObject[] input, int postCount, int postIndex, IRubyObject nil) {
        int aryIndex = input.length - postCount + postIndex;
        if (aryIndex >= input.length || aryIndex < 0) {
            return nil;
        }
        return input[aryIndex];
    }

    public static RubyBoolean isWhenTriggered(IRubyObject expression, IRubyObject expressionsObject, ThreadContext context) {
        RubyArray expressions = Helpers.splatValue(expressionsObject);
        int k = expressions.getLength();
        for (int j = 0; j < k; ++j) {
            IRubyObject condition = expressions.eltInternal(j);
            if ((expression == null || !condition.callMethod(context, "===", expression).isTrue()) && (expression != null || !condition.isTrue())) continue;
            return context.runtime.getTrue();
        }
        return context.runtime.getFalse();
    }

    public static IRubyObject setConstantInModule(ThreadContext context, String name2, IRubyObject value2, IRubyObject module) {
        if (!(module instanceof RubyModule)) {
            throw context.runtime.newTypeError(module.toString() + " is not a class/module");
        }
        ((RubyModule)module).setConstant(name2, value2);
        return value2;
    }

    public static IRubyObject[] anewarrayIRubyObjects(int size2) {
        return new IRubyObject[size2];
    }

    public static IRubyObject[] aastoreIRubyObjects(IRubyObject[] ary, IRubyObject one, int start2) {
        ary[start2] = one;
        return ary;
    }

    public static IRubyObject[] aastoreIRubyObjects(IRubyObject[] ary, IRubyObject one, IRubyObject two, int start2) {
        ary[start2] = one;
        ary[start2 + 1] = two;
        return ary;
    }

    public static IRubyObject[] aastoreIRubyObjects(IRubyObject[] ary, IRubyObject one, IRubyObject two, IRubyObject three, int start2) {
        ary[start2] = one;
        ary[start2 + 1] = two;
        ary[start2 + 2] = three;
        return ary;
    }

    public static IRubyObject[] aastoreIRubyObjects(IRubyObject[] ary, IRubyObject one, IRubyObject two, IRubyObject three, IRubyObject four, int start2) {
        ary[start2] = one;
        ary[start2 + 1] = two;
        ary[start2 + 2] = three;
        ary[start2 + 3] = four;
        return ary;
    }

    public static IRubyObject[] aastoreIRubyObjects(IRubyObject[] ary, IRubyObject one, IRubyObject two, IRubyObject three, IRubyObject four, IRubyObject five, int start2) {
        ary[start2] = one;
        ary[start2 + 1] = two;
        ary[start2 + 2] = three;
        ary[start2 + 3] = four;
        ary[start2 + 4] = five;
        return ary;
    }

    public static IRubyObject[] aastoreIRubyObjects(IRubyObject[] ary, IRubyObject one, IRubyObject two, IRubyObject three, IRubyObject four, IRubyObject five, IRubyObject six, int start2) {
        ary[start2] = one;
        ary[start2 + 1] = two;
        ary[start2 + 2] = three;
        ary[start2 + 3] = four;
        ary[start2 + 4] = five;
        ary[start2 + 5] = six;
        return ary;
    }

    public static IRubyObject[] aastoreIRubyObjects(IRubyObject[] ary, IRubyObject one, IRubyObject two, IRubyObject three, IRubyObject four, IRubyObject five, IRubyObject six, IRubyObject seven, int start2) {
        ary[start2] = one;
        ary[start2 + 1] = two;
        ary[start2 + 2] = three;
        ary[start2 + 3] = four;
        ary[start2 + 4] = five;
        ary[start2 + 5] = six;
        ary[start2 + 6] = seven;
        return ary;
    }

    public static IRubyObject[] aastoreIRubyObjects(IRubyObject[] ary, IRubyObject one, IRubyObject two, IRubyObject three, IRubyObject four, IRubyObject five, IRubyObject six, IRubyObject seven, IRubyObject eight, int start2) {
        ary[start2] = one;
        ary[start2 + 1] = two;
        ary[start2 + 2] = three;
        ary[start2 + 3] = four;
        ary[start2 + 4] = five;
        ary[start2 + 5] = six;
        ary[start2 + 6] = seven;
        ary[start2 + 7] = eight;
        return ary;
    }

    public static IRubyObject[] aastoreIRubyObjects(IRubyObject[] ary, IRubyObject one, IRubyObject two, IRubyObject three, IRubyObject four, IRubyObject five, IRubyObject six, IRubyObject seven, IRubyObject eight, IRubyObject nine, int start2) {
        ary[start2] = one;
        ary[start2 + 1] = two;
        ary[start2 + 2] = three;
        ary[start2 + 3] = four;
        ary[start2 + 4] = five;
        ary[start2 + 5] = six;
        ary[start2 + 6] = seven;
        ary[start2 + 7] = eight;
        ary[start2 + 8] = nine;
        return ary;
    }

    public static IRubyObject[] aastoreIRubyObjects(IRubyObject[] ary, IRubyObject one, IRubyObject two, IRubyObject three, IRubyObject four, IRubyObject five, IRubyObject six, IRubyObject seven, IRubyObject eight, IRubyObject nine, IRubyObject ten, int start2) {
        ary[start2] = one;
        ary[start2 + 1] = two;
        ary[start2 + 2] = three;
        ary[start2 + 3] = four;
        ary[start2 + 4] = five;
        ary[start2 + 5] = six;
        ary[start2 + 6] = seven;
        ary[start2 + 7] = eight;
        ary[start2 + 8] = nine;
        ary[start2 + 9] = ten;
        return ary;
    }

    public static IRubyObject[] constructObjectArray(IRubyObject one) {
        return new IRubyObject[]{one};
    }

    public static IRubyObject[] constructObjectArray(IRubyObject one, IRubyObject two) {
        return new IRubyObject[]{one, two};
    }

    public static IRubyObject[] constructObjectArray(IRubyObject one, IRubyObject two, IRubyObject three) {
        return new IRubyObject[]{one, two, three};
    }

    public static IRubyObject[] constructObjectArray(IRubyObject one, IRubyObject two, IRubyObject three, IRubyObject four) {
        return new IRubyObject[]{one, two, three, four};
    }

    public static IRubyObject[] constructObjectArray(IRubyObject one, IRubyObject two, IRubyObject three, IRubyObject four, IRubyObject five) {
        return new IRubyObject[]{one, two, three, four, five};
    }

    public static IRubyObject[] constructObjectArray(IRubyObject one, IRubyObject two, IRubyObject three, IRubyObject four, IRubyObject five, IRubyObject six) {
        return new IRubyObject[]{one, two, three, four, five, six};
    }

    public static IRubyObject[] constructObjectArray(IRubyObject one, IRubyObject two, IRubyObject three, IRubyObject four, IRubyObject five, IRubyObject six, IRubyObject seven) {
        return new IRubyObject[]{one, two, three, four, five, six, seven};
    }

    public static IRubyObject[] constructObjectArray(IRubyObject one, IRubyObject two, IRubyObject three, IRubyObject four, IRubyObject five, IRubyObject six, IRubyObject seven, IRubyObject eight) {
        return new IRubyObject[]{one, two, three, four, five, six, seven, eight};
    }

    public static IRubyObject[] constructObjectArray(IRubyObject one, IRubyObject two, IRubyObject three, IRubyObject four, IRubyObject five, IRubyObject six, IRubyObject seven, IRubyObject eight, IRubyObject nine) {
        return new IRubyObject[]{one, two, three, four, five, six, seven, eight, nine};
    }

    public static IRubyObject[] constructObjectArray(IRubyObject one, IRubyObject two, IRubyObject three, IRubyObject four, IRubyObject five, IRubyObject six, IRubyObject seven, IRubyObject eight, IRubyObject nine, IRubyObject ten) {
        return new IRubyObject[]{one, two, three, four, five, six, seven, eight, nine, ten};
    }

    public static RubyArray constructRubyArray(Ruby runtime, IRubyObject one) {
        return RubyArray.newArrayLight(runtime, one);
    }

    public static RubyArray constructRubyArray(Ruby runtime, IRubyObject one, IRubyObject two) {
        return RubyArray.newArrayLight(runtime, one, two);
    }

    public static RubyArray constructRubyArray(Ruby runtime, IRubyObject one, IRubyObject two, IRubyObject three) {
        return RubyArray.newArrayLight(runtime, one, two, three);
    }

    public static RubyArray constructRubyArray(Ruby runtime, IRubyObject one, IRubyObject two, IRubyObject three, IRubyObject four) {
        return RubyArray.newArrayLight(runtime, one, two, three, four);
    }

    public static RubyArray constructRubyArray(Ruby runtime, IRubyObject one, IRubyObject two, IRubyObject three, IRubyObject four, IRubyObject five) {
        return RubyArray.newArrayLight(runtime, one, two, three, four, five);
    }

    public static RubyArray constructRubyArray(Ruby runtime, IRubyObject one, IRubyObject two, IRubyObject three, IRubyObject four, IRubyObject five, IRubyObject six) {
        return RubyArray.newArrayLight(runtime, one, two, three, four, five, six);
    }

    public static RubyArray constructRubyArray(Ruby runtime, IRubyObject one, IRubyObject two, IRubyObject three, IRubyObject four, IRubyObject five, IRubyObject six, IRubyObject seven) {
        return RubyArray.newArrayLight(runtime, one, two, three, four, five, six, seven);
    }

    public static RubyArray constructRubyArray(Ruby runtime, IRubyObject one, IRubyObject two, IRubyObject three, IRubyObject four, IRubyObject five, IRubyObject six, IRubyObject seven, IRubyObject eight) {
        return RubyArray.newArrayLight(runtime, one, two, three, four, five, six, seven, eight);
    }

    public static RubyArray constructRubyArray(Ruby runtime, IRubyObject one, IRubyObject two, IRubyObject three, IRubyObject four, IRubyObject five, IRubyObject six, IRubyObject seven, IRubyObject eight, IRubyObject nine) {
        return RubyArray.newArrayLight(runtime, one, two, three, four, five, six, seven, eight, nine);
    }

    public static RubyArray constructRubyArray(Ruby runtime, IRubyObject one, IRubyObject two, IRubyObject three, IRubyObject four, IRubyObject five, IRubyObject six, IRubyObject seven, IRubyObject eight, IRubyObject nine, IRubyObject ten) {
        return RubyArray.newArrayLight(runtime, one, two, three, four, five, six, seven, eight, nine, ten);
    }

    public static String[] constructStringArray(String one) {
        return new String[]{one};
    }

    public static String[] constructStringArray(String one, String two) {
        return new String[]{one, two};
    }

    public static String[] constructStringArray(String one, String two, String three) {
        return new String[]{one, two, three};
    }

    public static String[] constructStringArray(String one, String two, String three, String four) {
        return new String[]{one, two, three, four};
    }

    public static String[] constructStringArray(String one, String two, String three, String four, String five) {
        return new String[]{one, two, three, four, five};
    }

    public static String[] constructStringArray(String one, String two, String three, String four, String five, String six) {
        return new String[]{one, two, three, four, five, six};
    }

    public static String[] constructStringArray(String one, String two, String three, String four, String five, String six, String seven) {
        return new String[]{one, two, three, four, five, six, seven};
    }

    public static String[] constructStringArray(String one, String two, String three, String four, String five, String six, String seven, String eight) {
        return new String[]{one, two, three, four, five, six, seven, eight};
    }

    public static String[] constructStringArray(String one, String two, String three, String four, String five, String six, String seven, String eight, String nine) {
        return new String[]{one, two, three, four, five, six, seven, eight, nine};
    }

    public static String[] constructStringArray(String one, String two, String three, String four, String five, String six, String seven, String eight, String nine, String ten) {
        return new String[]{one, two, three, four, five, six, seven, eight, nine, ten};
    }

    public static RubyHash constructHash(Ruby runtime, IRubyObject key1, IRubyObject value1, boolean prepareString1) {
        RubyHash hash2 = RubyHash.newHash(runtime);
        hash2.fastASet(runtime, key1, value1, prepareString1);
        return hash2;
    }

    public static RubyHash constructHash(Ruby runtime, IRubyObject key1, IRubyObject value1, boolean prepareString1, IRubyObject key2, IRubyObject value2, boolean prepareString2) {
        RubyHash hash2 = RubyHash.newHash(runtime);
        hash2.fastASet(runtime, key1, value1, prepareString1);
        hash2.fastASet(runtime, key2, value2, prepareString2);
        return hash2;
    }

    public static RubyHash constructHash(Ruby runtime, IRubyObject key1, IRubyObject value1, boolean prepareString1, IRubyObject key2, IRubyObject value2, boolean prepareString2, IRubyObject key3, IRubyObject value3, boolean prepareString3) {
        RubyHash hash2 = RubyHash.newHash(runtime);
        hash2.fastASet(runtime, key1, value1, prepareString1);
        hash2.fastASet(runtime, key2, value2, prepareString2);
        hash2.fastASet(runtime, key3, value3, prepareString3);
        return hash2;
    }

    public static RubyHash constructHash(Ruby runtime, IRubyObject key1, IRubyObject value1, boolean prepareString1, IRubyObject key2, IRubyObject value2, boolean prepareString2, IRubyObject key3, IRubyObject value3, boolean prepareString3, IRubyObject key4, IRubyObject value4, boolean prepareString4) {
        RubyHash hash2 = RubyHash.newHash(runtime);
        hash2.fastASet(runtime, key1, value1, prepareString1);
        hash2.fastASet(runtime, key2, value2, prepareString2);
        hash2.fastASet(runtime, key3, value3, prepareString3);
        hash2.fastASet(runtime, key4, value4, prepareString4);
        return hash2;
    }

    public static RubyHash constructHash(Ruby runtime, IRubyObject key1, IRubyObject value1, boolean prepareString1, IRubyObject key2, IRubyObject value2, boolean prepareString2, IRubyObject key3, IRubyObject value3, boolean prepareString3, IRubyObject key4, IRubyObject value4, boolean prepareString4, IRubyObject key5, IRubyObject value5, boolean prepareString5) {
        RubyHash hash2 = RubyHash.newHash(runtime);
        hash2.fastASet(runtime, key1, value1, prepareString1);
        hash2.fastASet(runtime, key2, value2, prepareString2);
        hash2.fastASet(runtime, key3, value3, prepareString3);
        hash2.fastASet(runtime, key4, value4, prepareString4);
        hash2.fastASet(runtime, key5, value5, prepareString5);
        return hash2;
    }

    public static RubyHash constructSmallHash(Ruby runtime, IRubyObject key1, IRubyObject value1, boolean prepareString1) {
        RubyHash hash2 = RubyHash.newSmallHash(runtime);
        hash2.fastASetSmall(runtime, key1, value1, prepareString1);
        return hash2;
    }

    public static RubyHash constructSmallHash(Ruby runtime, IRubyObject key1, IRubyObject value1, boolean prepareString1, IRubyObject key2, IRubyObject value2, boolean prepareString2) {
        RubyHash hash2 = RubyHash.newSmallHash(runtime);
        hash2.fastASetSmall(runtime, key1, value1, prepareString1);
        hash2.fastASetSmall(runtime, key2, value2, prepareString2);
        return hash2;
    }

    public static RubyHash constructSmallHash(Ruby runtime, IRubyObject key1, IRubyObject value1, boolean prepareString1, IRubyObject key2, IRubyObject value2, boolean prepareString2, IRubyObject key3, IRubyObject value3, boolean prepareString3) {
        RubyHash hash2 = RubyHash.newSmallHash(runtime);
        hash2.fastASetSmall(runtime, key1, value1, prepareString1);
        hash2.fastASetSmall(runtime, key2, value2, prepareString2);
        hash2.fastASetSmall(runtime, key3, value3, prepareString3);
        return hash2;
    }

    public static RubyHash constructSmallHash(Ruby runtime, IRubyObject key1, IRubyObject value1, boolean prepareString1, IRubyObject key2, IRubyObject value2, boolean prepareString2, IRubyObject key3, IRubyObject value3, boolean prepareString3, IRubyObject key4, IRubyObject value4, boolean prepareString4) {
        RubyHash hash2 = RubyHash.newSmallHash(runtime);
        hash2.fastASetSmall(runtime, key1, value1, prepareString1);
        hash2.fastASetSmall(runtime, key2, value2, prepareString2);
        hash2.fastASetSmall(runtime, key3, value3, prepareString3);
        hash2.fastASetSmall(runtime, key4, value4, prepareString4);
        return hash2;
    }

    public static RubyHash constructSmallHash(Ruby runtime, IRubyObject key1, IRubyObject value1, boolean prepareString1, IRubyObject key2, IRubyObject value2, boolean prepareString2, IRubyObject key3, IRubyObject value3, boolean prepareString3, IRubyObject key4, IRubyObject value4, boolean prepareString4, IRubyObject key5, IRubyObject value5, boolean prepareString5) {
        RubyHash hash2 = RubyHash.newSmallHash(runtime);
        hash2.fastASetSmall(runtime, key1, value1, prepareString1);
        hash2.fastASetSmall(runtime, key2, value2, prepareString2);
        hash2.fastASetSmall(runtime, key3, value3, prepareString3);
        hash2.fastASetSmall(runtime, key4, value4, prepareString4);
        hash2.fastASetSmall(runtime, key5, value5, prepareString5);
        return hash2;
    }

    public static IRubyObject negate(IRubyObject value2, Ruby runtime) {
        if (value2.isTrue()) {
            return runtime.getFalse();
        }
        return runtime.getTrue();
    }

    @Deprecated
    public static IRubyObject stringOrNil(ByteList value2, ThreadContext context) {
        if (value2 == null) {
            return context.nil;
        }
        return RubyString.newStringShared(context.runtime, value2);
    }

    public static StaticScope preLoad(ThreadContext context, String[] varNames) {
        StaticScope staticScope = context.runtime.getStaticScopeFactory().newLocalScope(null, varNames);
        Helpers.preLoadCommon(context, staticScope, false);
        return staticScope;
    }

    public static void preLoadCommon(ThreadContext context, StaticScope staticScope, boolean wrap2) {
        RubyModule objectClass = context.runtime.getObject();
        if (wrap2) {
            objectClass = RubyModule.newModule(context.runtime);
        }
        staticScope.setModule(objectClass);
        DynamicScope scope = DynamicScope.newDynamicScope(staticScope);
        context.preScopedBody(scope);
        context.preNodeEval(context.runtime.getTopSelf());
    }

    public static void postLoad(ThreadContext context) {
        context.postNodeEval();
        context.postScopedBody();
    }

    public static void registerEndBlock(Block block, Ruby runtime) {
        runtime.pushExitBlock(runtime.newProc(Block.Type.LAMBDA, block));
    }

    public static IRubyObject match3(RubyRegexp regexp2, IRubyObject value2, ThreadContext context) {
        if (value2 instanceof RubyString) {
            return regexp2.op_match(context, value2);
        }
        return value2.callMethod(context, "=~", regexp2);
    }

    public static IRubyObject match3_19(RubyRegexp regexp2, IRubyObject value2, ThreadContext context) {
        if (value2 instanceof RubyString) {
            return regexp2.op_match19(context, value2);
        }
        return value2.callMethod(context, "=~", regexp2);
    }

    public static IRubyObject getErrorInfo(Ruby runtime) {
        return runtime.getGlobalVariables().get("$!");
    }

    public static void setErrorInfo(Ruby runtime, IRubyObject error2) {
        runtime.getGlobalVariables().set("$!", error2);
    }

    public static IRubyObject setLastLine(Ruby runtime, ThreadContext context, IRubyObject value2) {
        return context.setLastLine(value2);
    }

    public static IRubyObject getLastLine(Ruby runtime, ThreadContext context) {
        return context.getLastLine();
    }

    public static IRubyObject setBackref(Ruby runtime, ThreadContext context, IRubyObject value2) {
        if (!value2.isNil() && !(value2 instanceof RubyMatchData)) {
            throw runtime.newTypeError(value2, runtime.getMatchData());
        }
        return context.setBackRef(value2);
    }

    public static IRubyObject getBackref(Ruby runtime, ThreadContext context) {
        return Helpers.backref(context);
    }

    public static IRubyObject preOpAsgnWithOrAnd(IRubyObject receiver2, ThreadContext context, IRubyObject self2, CallSite varSite) {
        return varSite.call(context, self2, receiver2);
    }

    public static IRubyObject postOpAsgnWithOrAnd(IRubyObject receiver2, IRubyObject value2, ThreadContext context, IRubyObject self2, CallSite varAsgnSite) {
        varAsgnSite.call(context, self2, receiver2, value2);
        return value2;
    }

    public static IRubyObject opAsgnWithMethod(ThreadContext context, IRubyObject self2, IRubyObject receiver2, IRubyObject arg2, CallSite varSite, CallSite opSite, CallSite opAsgnSite) {
        IRubyObject var = varSite.call(context, self2, receiver2);
        IRubyObject result2 = opSite.call(context, self2, var, arg2);
        opAsgnSite.call(context, self2, receiver2, result2);
        return result2;
    }

    public static IRubyObject opElementAsgnWithMethod(ThreadContext context, IRubyObject self2, IRubyObject receiver2, IRubyObject value2, CallSite elementSite, CallSite opSite, CallSite elementAsgnSite) {
        IRubyObject var = elementSite.call(context, self2, receiver2);
        IRubyObject result2 = opSite.call(context, self2, var, value2);
        elementAsgnSite.call(context, self2, receiver2, result2);
        return result2;
    }

    public static IRubyObject opElementAsgnWithMethod(ThreadContext context, IRubyObject self2, IRubyObject receiver2, IRubyObject arg2, IRubyObject value2, CallSite elementSite, CallSite opSite, CallSite elementAsgnSite) {
        IRubyObject var = elementSite.call(context, self2, receiver2, arg2);
        IRubyObject result2 = opSite.call(context, self2, var, value2);
        elementAsgnSite.call(context, self2, receiver2, arg2, result2);
        return result2;
    }

    public static IRubyObject opElementAsgnWithMethod(ThreadContext context, IRubyObject self2, IRubyObject receiver2, IRubyObject arg1, IRubyObject arg2, IRubyObject value2, CallSite elementSite, CallSite opSite, CallSite elementAsgnSite) {
        IRubyObject var = elementSite.call(context, self2, receiver2, arg1, arg2);
        IRubyObject result2 = opSite.call(context, self2, var, value2);
        elementAsgnSite.call(context, self2, receiver2, arg1, arg2, result2);
        return result2;
    }

    public static IRubyObject opElementAsgnWithMethod(ThreadContext context, IRubyObject self2, IRubyObject receiver2, IRubyObject arg1, IRubyObject arg2, IRubyObject arg3, IRubyObject value2, CallSite elementSite, CallSite opSite, CallSite elementAsgnSite) {
        IRubyObject var = elementSite.call(context, self2, receiver2, arg1, arg2, arg3);
        IRubyObject result2 = opSite.call(context, self2, var, value2);
        elementAsgnSite.call(context, self2, receiver2, arg1, arg2, arg3, result2);
        return result2;
    }

    public static IRubyObject opElementAsgnWithMethod(ThreadContext context, IRubyObject self2, IRubyObject receiver2, IRubyObject[] args2, IRubyObject value2, CallSite elementSite, CallSite opSite, CallSite elementAsgnSite) {
        IRubyObject var = elementSite.call(context, self2, receiver2);
        IRubyObject result2 = opSite.call(context, self2, var, value2);
        elementAsgnSite.call(context, self2, receiver2, Helpers.appendToObjectArray(args2, result2));
        return result2;
    }

    public static IRubyObject opElementAsgnWithOrPartTwoOneArg(ThreadContext context, IRubyObject self2, IRubyObject receiver2, IRubyObject arg2, IRubyObject value2, CallSite asetSite) {
        asetSite.call(context, self2, receiver2, arg2, value2);
        return value2;
    }

    public static IRubyObject opElementAsgnWithOrPartTwoTwoArgs(ThreadContext context, IRubyObject self2, IRubyObject receiver2, IRubyObject[] args2, IRubyObject value2, CallSite asetSite) {
        asetSite.call(context, self2, receiver2, args2[0], args2[1], value2);
        return value2;
    }

    public static IRubyObject opElementAsgnWithOrPartTwoThreeArgs(ThreadContext context, IRubyObject self2, IRubyObject receiver2, IRubyObject[] args2, IRubyObject value2, CallSite asetSite) {
        asetSite.call(context, self2, receiver2, args2[0], args2[1], args2[2], value2);
        return value2;
    }

    public static IRubyObject opElementAsgnWithOrPartTwoNArgs(ThreadContext context, IRubyObject self2, IRubyObject receiver2, IRubyObject[] args2, IRubyObject value2, CallSite asetSite) {
        IRubyObject[] newArgs = new IRubyObject[args2.length + 1];
        System.arraycopy(args2, 0, newArgs, 0, args2.length);
        newArgs[args2.length] = value2;
        asetSite.call(context, self2, receiver2, newArgs);
        return value2;
    }

    public static RubyArray arrayValue(IRubyObject value2) {
        Ruby runtime = value2.getRuntime();
        return Helpers.arrayValue(runtime.getCurrentContext(), runtime, value2);
    }

    public static RubyArray arrayValue(ThreadContext context, Ruby runtime, IRubyObject value2) {
        IRubyObject tmp = value2.checkArrayType();
        if (tmp.isNil()) {
            if (value2.respondsTo("to_a")) {
                IRubyObject avalue = value2.callMethod(context, "to_a");
                if (!(avalue instanceof RubyArray)) {
                    if (avalue.isNil()) {
                        return runtime.newArray(value2);
                    }
                    throw runtime.newTypeError("`to_a' did not return Array");
                }
                return (RubyArray)avalue;
            }
            DynamicMethod methodMissing = value2.getMetaClass().searchMethod("method_missing");
            if (methodMissing.isUndefined() || runtime.isDefaultMethodMissing(methodMissing)) {
                return runtime.newArray(value2);
            }
            IRubyObject avalue = methodMissing.call(context, value2, (RubyModule)value2.getMetaClass(), "to_a", new IRubyObject[]{runtime.newSymbol("to_a")}, Block.NULL_BLOCK);
            if (!(avalue instanceof RubyArray)) {
                if (avalue.isNil()) {
                    return runtime.newArray(value2);
                }
                throw runtime.newTypeError("`to_a' did not return Array");
            }
            return (RubyArray)avalue;
        }
        RubyArray arr = (RubyArray)tmp;
        return arr.aryDup();
    }

    public static RubyArray asArray18(ThreadContext context, IRubyObject value2) {
        Ruby runtime = context.runtime;
        IRubyObject tmp = value2.checkArrayType();
        if (tmp.isNil()) {
            if (value2.respondsTo("to_a")) {
                IRubyObject avalue = value2.callMethod(context, "to_a");
                if (!(avalue instanceof RubyArray)) {
                    if (avalue.isNil()) {
                        return runtime.newArray(value2);
                    }
                    throw runtime.newTypeError("`to_a' did not return Array");
                }
                return (RubyArray)avalue;
            }
            return runtime.newArray(value2);
        }
        return (RubyArray)tmp;
    }

    public static RubyArray asArray(ThreadContext context, IRubyObject value2) {
        return TypeConverter.rb_Array(context, value2);
    }

    public static IRubyObject aryToAry(IRubyObject value2) {
        if (value2 instanceof RubyArray) {
            return value2;
        }
        if (value2.respondsTo("to_ary")) {
            return TypeConverter.convertToType(value2, value2.getRuntime().getArray(), "to_ary", false);
        }
        return value2.getRuntime().newArray(value2);
    }

    public static IRubyObject aValueSplat(IRubyObject value2) {
        if (!(value2 instanceof RubyArray) || ((RubyArray)value2).length().getLongValue() == 0L) {
            return value2.getRuntime().getNil();
        }
        RubyArray array = (RubyArray)value2;
        return array.getLength() == 1 ? array.first() : array;
    }

    public static IRubyObject aValueSplat19(IRubyObject value2) {
        if (!(value2 instanceof RubyArray)) {
            return value2.getRuntime().getNil();
        }
        return (RubyArray)value2;
    }

    public static RubyArray splatValue(IRubyObject value2) {
        if (value2.isNil()) {
            return value2.getRuntime().newArray(value2);
        }
        return Helpers.arrayValue(value2);
    }

    public static RubyArray splatValue19(IRubyObject value2) {
        if (value2.isNil()) {
            return value2.getRuntime().newEmptyArray();
        }
        return Helpers.arrayValue(value2);
    }

    public static IRubyObject unsplatValue19(IRubyObject argsResult) {
        IRubyObject newResult;
        RubyArray array;
        if (argsResult instanceof RubyArray && (array = (RubyArray)argsResult).size() == 1 && (!((newResult = array.eltInternal(0)) instanceof RubyArray) || ((RubyArray)newResult).size() != 0)) {
            argsResult = newResult;
        }
        return argsResult;
    }

    public static IRubyObject[] splatToArguments(IRubyObject value2) {
        Ruby runtime = value2.getRuntime();
        if (value2.isNil()) {
            return runtime.getSingleNilArray();
        }
        return Helpers.splatToArgumentsCommon(runtime, value2);
    }

    public static IRubyObject[] splatToArguments19(IRubyObject value2) {
        Ruby runtime = value2.getRuntime();
        if (value2.isNil()) {
            return IRubyObject.NULL_ARRAY;
        }
        return Helpers.splatToArgumentsCommon(runtime, value2);
    }

    private static IRubyObject[] splatToArgumentsCommon(Ruby runtime, IRubyObject value2) {
        if (value2.isNil()) {
            return runtime.getSingleNilArray();
        }
        IRubyObject tmp = value2.checkArrayType();
        if (tmp.isNil()) {
            return Helpers.convertSplatToJavaArray(runtime, value2);
        }
        return ((RubyArray)tmp).toJavaArrayMaybeUnsafe();
    }

    private static IRubyObject[] convertSplatToJavaArray(Ruby runtime, IRubyObject value2) {
        RubyClass metaClass = value2.getMetaClass();
        DynamicMethod method = metaClass.searchMethod("to_a");
        if (method.isUndefined() || method.isImplementedBy(runtime.getKernel())) {
            return new IRubyObject[]{value2};
        }
        IRubyObject avalue = method.call(runtime.getCurrentContext(), value2, metaClass, "to_a");
        if (!(avalue instanceof RubyArray)) {
            if (avalue.isNil()) {
                return new IRubyObject[]{value2};
            }
            throw runtime.newTypeError("`to_a' did not return Array");
        }
        return ((RubyArray)avalue).toJavaArray();
    }

    public static IRubyObject[] argsCatToArguments(IRubyObject[] args2, IRubyObject cat) {
        IRubyObject[] ary = Helpers.splatToArguments(cat);
        return Helpers.argsCatToArgumentsCommon(args2, ary);
    }

    public static IRubyObject[] argsCatToArguments19(IRubyObject[] args2, IRubyObject cat) {
        IRubyObject[] ary = Helpers.splatToArguments19(cat);
        return Helpers.argsCatToArgumentsCommon(args2, ary);
    }

    private static IRubyObject[] argsCatToArgumentsCommon(IRubyObject[] args2, IRubyObject[] ary) {
        if (ary.length > 0) {
            IRubyObject[] newArgs = new IRubyObject[args2.length + ary.length];
            System.arraycopy(args2, 0, newArgs, 0, args2.length);
            System.arraycopy(ary, 0, newArgs, args2.length, ary.length);
            args2 = newArgs;
        }
        return args2;
    }

    public static RubySymbol addInstanceMethod(RubyModule containingClass, String name2, DynamicMethod method, Visibility visibility, ThreadContext context, Ruby runtime) {
        containingClass.addMethod(name2, method);
        RubySymbol sym = runtime.fastNewSymbol(name2);
        if (visibility == Visibility.MODULE_FUNCTION) {
            Helpers.addModuleMethod(containingClass, name2, method, context, sym);
        }
        if (!containingClass.isRefinement()) {
            Helpers.callNormalMethodHook(containingClass, context, sym);
        }
        return sym;
    }

    private static void addModuleMethod(RubyModule containingClass, String name2, DynamicMethod method, ThreadContext context, RubySymbol sym) {
        containingClass.getSingletonClass().addMethod(name2, new WrapperMethod((RubyModule)containingClass.getSingletonClass(), method, Visibility.PUBLIC));
        containingClass.callMethod(context, "singleton_method_added", (IRubyObject)sym);
    }

    private static void callNormalMethodHook(RubyModule containingClass, ThreadContext context, RubySymbol name2) {
        if (containingClass.isSingleton()) {
            Helpers.callSingletonMethodHook(((MetaClass)containingClass).getAttached(), context, name2);
        } else {
            containingClass.callMethod(context, "method_added", (IRubyObject)name2);
        }
    }

    private static void callSingletonMethodHook(IRubyObject receiver2, ThreadContext context, RubySymbol name2) {
        receiver2.callMethod(context, "singleton_method_added", name2);
    }

    public static String encodeScope(StaticScope scope) {
        StringBuilder namesBuilder = new StringBuilder(scope.getType().name());
        namesBuilder.append(',');
        boolean first2 = true;
        for (String name2 : scope.getVariables()) {
            if (!first2) {
                namesBuilder.append(';');
            }
            first2 = false;
            namesBuilder.append(name2);
        }
        namesBuilder.append(',').append(scope.getSignature().encode());
        namesBuilder.append(',').append((Object)scope.getScopeType());
        return namesBuilder.toString();
    }

    public static StaticScope decodeScope(ThreadContext context, StaticScope parent, String scopeString) {
        String[][] decodedScope = Helpers.decodeScopeDescriptor(scopeString);
        String scopeTypeName = decodedScope[0][0];
        String[] names2 = decodedScope[1];
        StaticScope scope = null;
        switch (StaticScope.Type.valueOf(scopeTypeName)) {
            case BLOCK: {
                scope = context.runtime.getStaticScopeFactory().newBlockScope(parent, names2);
                break;
            }
            case EVAL: {
                scope = context.runtime.getStaticScopeFactory().newEvalScope(parent, names2);
                break;
            }
            case LOCAL: {
                scope = context.runtime.getStaticScopeFactory().newLocalScope(parent, names2);
            }
        }
        Helpers.setAritiesFromDecodedScope(scope, decodedScope[0][2]);
        scope.setScopeType(IRScopeType.valueOf(decodedScope[0][3]));
        return scope;
    }

    private static String[][] decodeScopeDescriptor(String scopeString) {
        String[] scopeElements = scopeString.split(",");
        String[] scopeNames = scopeElements[1].length() == 0 ? StringSupport.EMPTY_STRING_ARRAY : Helpers.getScopeNames(scopeElements[1]);
        return new String[][]{scopeElements, scopeNames};
    }

    private static void setAritiesFromDecodedScope(StaticScope scope, String encodedSignature) {
        scope.setSignature(Signature.decode(Long.parseLong(encodedSignature)));
    }

    public static StaticScope decodeScopeAndDetermineModule(ThreadContext context, StaticScope parent, String scopeString) {
        StaticScope scope = Helpers.decodeScope(context, parent, scopeString);
        scope.determineModule();
        return scope;
    }

    public static Visibility performNormalMethodChecksAndDetermineVisibility(Ruby runtime, RubyModule clazz, String name2, Visibility visibility) throws RaiseException {
        if (clazz == runtime.getDummy()) {
            throw runtime.newTypeError("no class/module to add method");
        }
        if (clazz == runtime.getObject() && "initialize".equals(name2)) {
            runtime.getWarnings().warn(IRubyWarnings.ID.REDEFINING_DANGEROUS, "redefining Object#initialize may cause infinite loop");
        }
        if ("__id__".equals(name2) || "__send__".equals(name2)) {
            runtime.getWarnings().warn(IRubyWarnings.ID.REDEFINING_DANGEROUS, "redefining `" + name2 + "' may cause serious problem");
        }
        if ("initialize".equals(name2) || "initialize_copy".equals(name2) || name2.equals("initialize_dup") || name2.equals("initialize_clone") || name2.equals("respond_to_missing?") || visibility == Visibility.MODULE_FUNCTION) {
            visibility = Visibility.PRIVATE;
        }
        return visibility;
    }

    public static RubyClass performSingletonMethodChecks(Ruby runtime, IRubyObject receiver2, String name2) throws RaiseException {
        if (receiver2 instanceof RubyFixnum || receiver2 instanceof RubySymbol) {
            throw runtime.newTypeError("can't define singleton method \"" + name2 + "\" for " + receiver2.getMetaClass().getBaseName());
        }
        if (receiver2.isFrozen()) {
            throw runtime.newFrozenError("object");
        }
        RubyClass rubyClass = receiver2.getSingletonClass();
        return rubyClass;
    }

    public static IRubyObject arrayEntryOrNil(RubyArray array, int index2) {
        if (index2 < array.getLength()) {
            return array.eltInternal(index2);
        }
        return array.getRuntime().getNil();
    }

    public static IRubyObject arrayEntryOrNilZero(RubyArray array) {
        if (0 < array.getLength()) {
            return array.eltInternal(0);
        }
        return array.getRuntime().getNil();
    }

    public static IRubyObject arrayEntryOrNilOne(RubyArray array) {
        if (1 < array.getLength()) {
            return array.eltInternal(1);
        }
        return array.getRuntime().getNil();
    }

    public static IRubyObject arrayEntryOrNilTwo(RubyArray array) {
        if (2 < array.getLength()) {
            return array.eltInternal(2);
        }
        return array.getRuntime().getNil();
    }

    public static IRubyObject arrayPostOrNil(RubyArray array, int pre, int post, int index2) {
        if (pre + post < array.getLength()) {
            return array.eltInternal(array.getLength() - post + index2);
        }
        if (pre + index2 < array.getLength()) {
            return array.eltInternal(pre + index2);
        }
        return array.getRuntime().getNil();
    }

    public static IRubyObject arrayPostOrNilZero(RubyArray array, int pre, int post) {
        if (pre + post < array.getLength()) {
            return array.eltInternal(array.getLength() - post + 0);
        }
        if (pre + 0 < array.getLength()) {
            return array.eltInternal(pre + 0);
        }
        return array.getRuntime().getNil();
    }

    public static IRubyObject arrayPostOrNilOne(RubyArray array, int pre, int post) {
        if (pre + post < array.getLength()) {
            return array.eltInternal(array.getLength() - post + 1);
        }
        if (pre + 1 < array.getLength()) {
            return array.eltInternal(pre + 1);
        }
        return array.getRuntime().getNil();
    }

    public static IRubyObject arrayPostOrNilTwo(RubyArray array, int pre, int post) {
        if (pre + post < array.getLength()) {
            return array.eltInternal(array.getLength() - post + 2);
        }
        if (pre + 2 < array.getLength()) {
            return array.eltInternal(pre + 2);
        }
        return array.getRuntime().getNil();
    }

    public static RubyArray subarrayOrEmpty(RubyArray array, Ruby runtime, int index2) {
        if (index2 < array.getLength()) {
            return Helpers.createSubarray(array, index2);
        }
        return RubyArray.newEmptyArray(runtime);
    }

    public static RubyArray subarrayOrEmpty(RubyArray array, Ruby runtime, int index2, int post) {
        if (index2 + post < array.getLength()) {
            return Helpers.createSubarray(array, index2, post);
        }
        return RubyArray.newEmptyArray(runtime);
    }

    public static RubyModule checkIsModule(IRubyObject maybeModule) {
        if (maybeModule instanceof RubyModule) {
            return (RubyModule)maybeModule;
        }
        throw maybeModule.getRuntime().newTypeError(maybeModule + " is not a class/module");
    }

    public static IRubyObject getGlobalVariable(Ruby runtime, String name2) {
        return runtime.getGlobalVariables().get(name2);
    }

    public static IRubyObject setGlobalVariable(IRubyObject value2, Ruby runtime, String name2) {
        return runtime.getGlobalVariables().set(name2, value2);
    }

    public static IRubyObject getInstanceVariable(IRubyObject self2, Ruby runtime, String internedName) {
        IRubyObject result2 = self2.getInstanceVariables().getInstanceVariable(internedName);
        if (result2 != null) {
            return result2;
        }
        if (runtime.isVerbose()) {
            Helpers.warnAboutUninitializedIvar(runtime, internedName);
        }
        return runtime.getNil();
    }

    public static IRubyObject getInstanceVariableNoWarn(IRubyObject self2, ThreadContext context, String internedName) {
        IRubyObject result2 = self2.getInstanceVariables().getInstanceVariable(internedName);
        if (result2 != null) {
            return result2;
        }
        return context.nil;
    }

    private static void warnAboutUninitializedIvar(Ruby runtime, String internedName) {
        runtime.getWarnings().warning(IRubyWarnings.ID.IVAR_NOT_INITIALIZED, "instance variable " + internedName + " not initialized");
    }

    public static IRubyObject setInstanceVariable(IRubyObject value2, IRubyObject self2, String name2) {
        return self2.getInstanceVariables().setInstanceVariable(name2, value2);
    }

    public static RubyProc newLiteralLambda(ThreadContext context, Block block, IRubyObject self2) {
        return RubyProc.newProc(context.runtime, block, Block.Type.LAMBDA);
    }

    public static void fillNil(IRubyObject[] arr, int from, int to, Ruby runtime) {
        if (arr.length == 0) {
            return;
        }
        IRubyObject[] nils = runtime.getNilPrefilledArray();
        int i2 = from;
        while (i2 + 128 < to) {
            System.arraycopy(nils, 0, arr, i2, 128);
            i2 += 128;
        }
        System.arraycopy(nils, 0, arr, i2, to - i2);
    }

    public static void fillNil(IRubyObject[] arr, Ruby runtime) {
        if (arr.length == 0) {
            return;
        }
        Helpers.fillNil(arr, 0, arr.length, runtime);
    }

    public static boolean isFastSwitchableString(IRubyObject str) {
        return str instanceof RubyString;
    }

    public static boolean isFastSwitchableSingleCharString(IRubyObject str) {
        return str instanceof RubyString && ((RubyString)str).getByteList().length() == 1;
    }

    public static int getFastSwitchString(IRubyObject str) {
        ByteList byteList = ((RubyString)str).getByteList();
        return byteList.hashCode();
    }

    public static int getFastSwitchSingleCharString(IRubyObject str) {
        ByteList byteList = ((RubyString)str).getByteList();
        return byteList.get(0);
    }

    public static boolean isFastSwitchableSymbol(IRubyObject sym) {
        return sym instanceof RubySymbol;
    }

    public static boolean isFastSwitchableSingleCharSymbol(IRubyObject sym) {
        return sym instanceof RubySymbol && ((RubySymbol)sym).asJavaString().length() == 1;
    }

    public static int getFastSwitchSymbol(IRubyObject sym) {
        String str = ((RubySymbol)sym).asJavaString();
        return str.hashCode();
    }

    public static int getFastSwitchSingleCharSymbol(IRubyObject sym) {
        String str = ((RubySymbol)sym).asJavaString();
        return str.charAt(0);
    }

    public static Block getBlock(ThreadContext context, IRubyObject self2, Node node) {
        throw new RuntimeException("Should not be called");
    }

    public static Block getBlock(Ruby runtime, ThreadContext context, IRubyObject self2, Node node, Block aBlock) {
        throw new RuntimeException("Should not be called");
    }

    public static RubyBoolean rbEqual(ThreadContext context, IRubyObject a, IRubyObject b2) {
        Ruby runtime = context.runtime;
        if (a == b2) {
            return runtime.getTrue();
        }
        IRubyObject res = Helpers.invokedynamic(context, a, MethodNames.OP_EQUAL, b2);
        return runtime.newBoolean(res.isTrue());
    }

    public static RubyBoolean rbEql(ThreadContext context, IRubyObject a, IRubyObject b2) {
        Ruby runtime = context.runtime;
        if (a == b2) {
            return runtime.getTrue();
        }
        IRubyObject res = Helpers.invokedynamic(context, a, MethodNames.EQL, b2);
        return runtime.newBoolean(res.isTrue());
    }

    public static void checkArgumentCount(ThreadContext context, IRubyObject[] args2, int min2, int max2) {
        Helpers.checkArgumentCount(context, args2.length, min2, max2);
    }

    public static void checkArgumentCount(ThreadContext context, IRubyObject[] args2, int req) {
        Helpers.checkArgumentCount(context, args2.length, req, req);
    }

    public static void checkArgumentCount(ThreadContext context, int length2, int min2, int max2) {
        int expected = 0;
        if (length2 < min2) {
            expected = min2;
        } else if (max2 > -1 && length2 > max2) {
            expected = max2;
        } else {
            return;
        }
        throw context.runtime.newArgumentError(length2, expected);
    }

    public static boolean isModuleAndHasConstant(IRubyObject left2, String name2) {
        return left2 instanceof RubyModule && ((RubyModule)left2).getConstantFromNoConstMissing(name2, false) != null;
    }

    public static RubyString getDefinedConstantOrBoundMethod(IRubyObject left2, String name2) {
        if (Helpers.isModuleAndHasConstant(left2, name2)) {
            return left2.getRuntime().getDefinedMessage(DefinedMessage.CONSTANT);
        }
        if (left2.getMetaClass().isMethodBound(name2, true)) {
            left2.getRuntime().getDefinedMessage(DefinedMessage.METHOD);
        }
        return null;
    }

    public static RubyModule getSuperClassForDefined(Ruby runtime, RubyModule klazz) {
        RubyClass superklazz = klazz.getSuperClass();
        if (superklazz == null && klazz.isModule()) {
            superklazz = runtime.getObject();
        }
        return superklazz;
    }

    public static boolean isGenerationEqual(IRubyObject object, int generation) {
        RubyClass metaClass = object instanceof RubyBasicObject ? ((RubyBasicObject)object).getMetaClass() : object.getMetaClass();
        return metaClass.getGeneration() == generation;
    }

    public static String[] getScopeNames(String scopeNames) {
        StringTokenizer toker = new StringTokenizer(scopeNames, ";");
        ArrayList<String> list2 = new ArrayList<String>(10);
        while (toker.hasMoreTokens()) {
            list2.add(toker.nextToken().intern());
        }
        return list2.toArray(new String[list2.size()]);
    }

    public static IRubyObject[] arraySlice1N(IRubyObject arrayish) {
        arrayish = Helpers.aryToAry(arrayish);
        RubyArray arrayish2 = Helpers.ensureMultipleAssignableRubyArray(arrayish, arrayish.getRuntime(), true);
        return new IRubyObject[]{Helpers.arrayEntryOrNilZero(arrayish2), Helpers.subarrayOrEmpty(arrayish2, arrayish2.getRuntime(), 1)};
    }

    public static IRubyObject arraySlice1(IRubyObject arrayish) {
        arrayish = Helpers.aryToAry(arrayish);
        RubyArray arrayish2 = Helpers.ensureMultipleAssignableRubyArray(arrayish, arrayish.getRuntime(), true);
        return Helpers.arrayEntryOrNilZero(arrayish2);
    }

    public static RubyClass metaclass(IRubyObject object) {
        return object instanceof RubyBasicObject ? ((RubyBasicObject)object).getMetaClass() : object.getMetaClass();
    }

    public static String rawBytesToString(byte[] bytes2) {
        char[] chars2 = new char[bytes2.length];
        for (int i2 = 0; i2 < bytes2.length; ++i2) {
            chars2[i2] = (char)bytes2[i2];
        }
        return new String(chars2);
    }

    public static byte[] stringToRawBytes(String string2) {
        char[] chars2 = string2.toCharArray();
        byte[] bytes2 = new byte[chars2.length];
        for (int i2 = 0; i2 < chars2.length; ++i2) {
            bytes2[i2] = (byte)chars2[i2];
        }
        return bytes2;
    }

    public static String encodeCaptureOffsets(int[] scopeOffsets) {
        char[] encoded = new char[scopeOffsets.length * 2];
        for (int i2 = 0; i2 < scopeOffsets.length; ++i2) {
            int offDepth = scopeOffsets[i2];
            char off = (char)(offDepth & 0xFFFF);
            char depth = (char)(offDepth >> 16);
            encoded[2 * i2] = off;
            encoded[2 * i2 + 1] = depth;
        }
        return new String(encoded);
    }

    public static int[] decodeCaptureOffsets(String encoded) {
        char[] chars2 = encoded.toCharArray();
        int[] scopeOffsets = new int[chars2.length / 2];
        for (int i2 = 0; i2 < scopeOffsets.length; ++i2) {
            char off = chars2[2 * i2];
            char depth = chars2[2 * i2 + 1];
            scopeOffsets[i2] = depth << 16 | off;
        }
        return scopeOffsets;
    }

    public static IRubyObject match2AndUpdateScope(IRubyObject receiver2, ThreadContext context, IRubyObject value2, String scopeOffsets) {
        IRubyObject match2 = ((RubyRegexp)receiver2).op_match(context, value2);
        Helpers.updateScopeWithCaptures(context, Helpers.decodeCaptureOffsets(scopeOffsets), match2);
        return match2;
    }

    public static IRubyObject match2AndUpdateScope19(IRubyObject receiver2, ThreadContext context, IRubyObject value2, String scopeOffsets) {
        IRubyObject match2 = ((RubyRegexp)receiver2).op_match19(context, value2);
        Helpers.updateScopeWithCaptures(context, Helpers.decodeCaptureOffsets(scopeOffsets), match2);
        return match2;
    }

    public static void updateScopeWithCaptures(ThreadContext context, int[] scopeOffsets, IRubyObject result2) {
        Ruby runtime = context.runtime;
        if (result2.isNil()) {
            IRubyObject nil = runtime.getNil();
            for (int i2 = 0; i2 < scopeOffsets.length; ++i2) {
                context.getCurrentScope().setValue(nil, scopeOffsets[i2], 0);
            }
        } else {
            RubyMatchData matchData = (RubyMatchData)context.getBackRef();
            IRubyObject[] namedValues = matchData.getNamedBackrefValues(runtime);
            for (int i3 = 0; i3 < scopeOffsets.length; ++i3) {
                context.getCurrentScope().setValue(namedValues[i3], scopeOffsets[i3] & 0xFFFF, scopeOffsets[i3] >> 16);
            }
        }
    }

    public static RubyArray argsPush(ThreadContext context, RubyArray first2, IRubyObject second) {
        return ((RubyArray)first2.dup()).append(second);
    }

    @Deprecated
    public static RubyArray argsPush(RubyArray first2, IRubyObject second) {
        return Helpers.argsPush(first2.getRuntime().getCurrentContext(), first2, second);
    }

    public static RubyArray argsCat(ThreadContext context, IRubyObject first2, IRubyObject second) {
        RubyArray secondArgs = IRRuntimeHelpers.irSplat(context, second);
        return ((RubyArray)Helpers.ensureRubyArray(context.runtime, first2).dup()).concat(secondArgs);
    }

    @Deprecated
    public static RubyArray argsCat(IRubyObject first2, IRubyObject second) {
        return Helpers.argsCat(first2.getRuntime().getCurrentContext(), first2, second);
    }

    public static ArgumentDescriptor[] argsNodeToArgumentDescriptors(ArgsNode argsNode) {
        int keywordsCount;
        int postCount;
        ArgumentNode restArg;
        int optCount;
        ArrayList<ArgumentDescriptor> descs = new ArrayList<ArgumentDescriptor>();
        Node[] args2 = argsNode.getArgs();
        int preCount = argsNode.getPreCount();
        if (preCount > 0) {
            for (int i2 = 0; i2 < preCount; ++i2) {
                if (args2[i2] instanceof MultipleAsgnNode) {
                    descs.add(new ArgumentDescriptor(ArgumentType.anonreq));
                    continue;
                }
                descs.add(new ArgumentDescriptor(ArgumentType.req, ((ArgumentNode)args2[i2]).getName()));
            }
        }
        if ((optCount = argsNode.getOptionalArgsCount()) > 0) {
            int optIndex = argsNode.getOptArgIndex();
            for (int i3 = 0; i3 < optCount; ++i3) {
                ArgumentType type2 = ArgumentType.opt;
                Node optNode = args2[optIndex + i3];
                String name2 = null;
                if (optNode instanceof OptArgNode) {
                    name2 = ((OptArgNode)optNode).getName();
                } else if (optNode instanceof LocalAsgnNode) {
                    name2 = ((LocalAsgnNode)optNode).getName();
                } else if (optNode instanceof DAsgnNode) {
                    name2 = ((DAsgnNode)optNode).getName();
                } else {
                    type2 = ArgumentType.anonopt;
                }
                descs.add(new ArgumentDescriptor(type2, name2));
            }
        }
        if ((restArg = argsNode.getRestArgNode()) != null) {
            if (restArg instanceof UnnamedRestArgNode) {
                if (((UnnamedRestArgNode)restArg).isStar()) {
                    descs.add(new ArgumentDescriptor(ArgumentType.anonrest));
                }
            } else {
                descs.add(new ArgumentDescriptor(ArgumentType.rest, restArg.getName()));
            }
        }
        if ((postCount = argsNode.getPostCount()) > 0) {
            int postIndex = argsNode.getPostIndex();
            for (int i4 = 0; i4 < postCount; ++i4) {
                Node postNode = args2[postIndex + i4];
                if (postNode instanceof MultipleAsgnNode) {
                    descs.add(new ArgumentDescriptor(ArgumentType.anonreq));
                    continue;
                }
                descs.add(new ArgumentDescriptor(ArgumentType.req, ((ArgumentNode)postNode).getName()));
            }
        }
        if ((keywordsCount = argsNode.getKeywordCount()) > 0) {
            int keywordsIndex = argsNode.getKeywordsIndex();
            for (int i5 = 0; i5 < keywordsCount; ++i5) {
                Node keyWordNode = args2[keywordsIndex + i5];
                for (Node asgnNode : keyWordNode.childNodes()) {
                    if (Helpers.isRequiredKeywordArgumentValueNode(asgnNode)) {
                        descs.add(new ArgumentDescriptor(ArgumentType.keyreq, ((INameNode)((Object)asgnNode)).getName()));
                        continue;
                    }
                    descs.add(new ArgumentDescriptor(ArgumentType.key, ((INameNode)((Object)asgnNode)).getName()));
                }
            }
        }
        if (argsNode.getKeyRest() != null) {
            String argName = argsNode.getKeyRest().getName();
            if (argName == null || argName.length() == 0) {
                descs.add(new ArgumentDescriptor(ArgumentType.anonkeyrest, argName));
            } else {
                descs.add(new ArgumentDescriptor(ArgumentType.keyrest, argsNode.getKeyRest().getName()));
            }
        }
        if (argsNode.getBlock() != null) {
            descs.add(new ArgumentDescriptor(ArgumentType.block, argsNode.getBlock().getName()));
        }
        return descs.toArray(new ArgumentDescriptor[descs.size()]);
    }

    public static ArgumentDescriptor[] parameterListToArgumentDescriptors(String[] parameterList, boolean isLambda) {
        String param;
        ArgumentDescriptor[] parms = new ArgumentDescriptor[parameterList.length];
        for (int i2 = 0; i2 < parameterList.length && !(param = parameterList[i2]).equals("NONE"); ++i2) {
            ArgumentType type2;
            if (param.equals("nil")) {
                param = "n";
            }
            if ((type2 = ArgumentType.valueOf(param.charAt(0))) == ArgumentType.req && !isLambda) {
                type2 = ArgumentType.opt;
            }
            parms[i2] = param.length() > 1 ? new ArgumentDescriptor(type2, param.substring(1)) : new ArgumentDescriptor(type2.anonymousForm());
        }
        return parms;
    }

    public static RubyArray argumentDescriptorsToParameters(Ruby runtime, ArgumentDescriptor[] argsDesc, boolean isLambda) {
        if (argsDesc == null) {
            Thread.dumpStack();
        }
        RubyArray params2 = RubyArray.newArray(runtime, argsDesc.length);
        for (ArgumentDescriptor param : argsDesc) {
            params2.append(param.toArrayForm(runtime, isLambda));
        }
        return params2;
    }

    public static ArgumentDescriptor[] methodToArgumentDescriptors(DynamicMethod method) {
        if ((method = method.getRealMethod()) instanceof MethodArgs2) {
            return Helpers.parameterListToArgumentDescriptors(((MethodArgs2)((Object)method)).getParameterList(), true);
        }
        if (method instanceof IRMethodArgs) {
            return ((IRMethodArgs)((Object)method)).getArgumentDescriptors();
        }
        return new ArgumentDescriptor[]{new ArgumentDescriptor(ArgumentType.anonrest)};
    }

    public static IRubyObject methodToParameters(Ruby runtime, AbstractRubyMethod recv2) {
        DynamicMethod method = recv2.getMethod().getRealMethod();
        return Helpers.argumentDescriptorsToParameters(runtime, Helpers.methodToArgumentDescriptors(method), true);
    }

    public static RubyString getDefinedCall(ThreadContext context, IRubyObject self2, IRubyObject receiver2, String name2) {
        RubyClass metaClass = receiver2.getMetaClass();
        DynamicMethod method = metaClass.searchMethod(name2);
        Visibility visibility = method.getVisibility();
        if (visibility != Visibility.PRIVATE && (visibility != Visibility.PROTECTED || metaClass.getRealClass().isInstance(self2)) && !method.isUndefined()) {
            return context.runtime.getDefinedMessage(DefinedMessage.METHOD);
        }
        if (receiver2.callMethod(context, "respond_to_missing?", new IRubyObject[]{context.runtime.newSymbol(name2), context.runtime.getFalse()}).isTrue()) {
            return context.runtime.getDefinedMessage(DefinedMessage.METHOD);
        }
        return null;
    }

    public static RubyString getDefinedNot(Ruby runtime, RubyString definition) {
        if (definition != null) {
            return runtime.getDefinedMessage(DefinedMessage.METHOD);
        }
        return definition;
    }

    public static IRubyObject invokedynamic(ThreadContext context, IRubyObject self2, MethodNames method) {
        RubyClass metaclass = self2.getMetaClass();
        String name2 = method.realName();
        return Helpers.getMethodCached(context, metaclass, method.ordinal(), name2).call(context, self2, metaclass, name2);
    }

    public static IRubyObject invokedynamic(ThreadContext context, IRubyObject self2, MethodNames method, IRubyObject arg0) {
        RubyClass metaclass = self2.getMetaClass();
        String name2 = method.realName();
        return Helpers.getMethodCached(context, metaclass, method.ordinal(), name2).call(context, self2, (RubyModule)metaclass, name2, arg0);
    }

    private static DynamicMethod getMethodCached(ThreadContext context, RubyClass metaclass, int index2, String name2) {
        if (metaclass.getClassIndex() == ClassIndex.NO_INDEX) {
            return metaclass.searchMethod(name2);
        }
        return context.runtimeCache.getMethod(context, metaclass, metaclass.getClassIndex().ordinal() * (index2 + 1), name2);
    }

    public static IRubyObject lastElement(IRubyObject[] ary) {
        return ary[ary.length - 1];
    }

    public static RubyString appendAsString(RubyString target, IRubyObject other) {
        return target.append(other.asString());
    }

    public static RubyString appendAsString19(RubyString target, IRubyObject other) {
        return target.append19(other.asString());
    }

    public static boolean needsSplat19(int requiredCount, boolean isRest) {
        return isRest && requiredCount > 0 || !isRest && requiredCount > 1;
    }

    public static IRubyObject[] restructureBlockArgs19(IRubyObject value2, Signature signature, Block.Type type2, boolean needsSplat, boolean alreadyArray) {
        if (!type2.checkArity && signature == Signature.NO_ARGUMENTS) {
            return IRubyObject.NULL_ARRAY;
        }
        if (value2 != null && !(value2 instanceof RubyArray) && needsSplat) {
            value2 = Helpers.aryToAry(value2);
        }
        IRubyObject[] parameters2 = value2 == null ? IRubyObject.NULL_ARRAY : (value2 instanceof RubyArray && (alreadyArray || needsSplat) ? ((RubyArray)value2).toJavaArray() : new IRubyObject[]{value2});
        return parameters2;
    }

    public static boolean BEQ(ThreadContext context, IRubyObject value1, IRubyObject value2) {
        return value1.op_equal(context, value2).isTrue();
    }

    public static boolean BNE(ThreadContext context, IRubyObject value1, IRubyObject value2) {
        boolean eql2 = value2 == context.nil || value2 == UndefinedValue.UNDEFINED ? value1 == value2 : value1.op_equal(context, value2).isTrue();
        return !eql2;
    }

    public static RubyModule checkIsRubyModule(ThreadContext context, Object object) {
        if (!(object instanceof RubyModule)) {
            throw context.runtime.newTypeError("no outer class/module");
        }
        return (RubyModule)object;
    }

    public static RubyClass newClassForIR(ThreadContext context, String name2, IRubyObject self2, RubyModule classContainer, Object superClass, boolean meta) {
        if (meta) {
            return classContainer.getMetaClass();
        }
        RubyClass sc = null;
        if (superClass == UndefinedValue.UNDEFINED) {
            sc = null;
        } else if (superClass != null) {
            RubyClass.checkInheritable((IRubyObject)superClass);
            sc = (RubyClass)superClass;
        }
        return classContainer.defineOrGetClassUnder(name2, sc);
    }

    public static RubyString appendByteList(RubyString target, ByteList source2) {
        target.getByteList().append(source2);
        return target;
    }

    public static RubyString appendByteList19(RubyString target, ByteList source2, int codeRange) {
        target.cat19(source2, codeRange);
        return target;
    }

    public static RubyString shortcutAppend18(RubyString string2, IRubyObject object) {
        if (object instanceof RubyFixnum || object instanceof RubyFloat || object instanceof RubySymbol) {
            return string2.append(object);
        }
        return string2.append(object.asString());
    }

    public static RubyString shortcutAppend(RubyString string2, IRubyObject object) {
        if (object instanceof RubyFixnum || object instanceof RubyFloat || object instanceof RubySymbol) {
            return string2.append19(object);
        }
        return string2.append19(object.asString());
    }

    public static void irCheckArgsArrayArity(ThreadContext context, RubyArray args2, int required, int opt, boolean rest2) {
        int numArgs = args2.size();
        if (numArgs < required || !rest2 && numArgs > required + opt) {
            Arity.raiseArgumentError(context.runtime, numArgs, required, required + opt);
        }
    }

    @Deprecated
    public static IRubyObject invokedynamic(ThreadContext context, IRubyObject self2, int index2) {
        return Helpers.invokedynamic(context, self2, MethodNames.values()[index2]);
    }

    @Deprecated
    public static IRubyObject invokedynamic(ThreadContext context, IRubyObject self2, int index2, IRubyObject arg0) {
        return Helpers.invokedynamic(context, self2, MethodNames.values()[index2], arg0);
    }

    public static void throwException(Throwable e) {
        Helpers.throwsUnchecked(e);
    }

    private static <T extends Throwable> void throwsUnchecked(Throwable e) throws T {
        throw e;
    }

    public static String symbolBytesToString(ByteList value2) {
        Encoding encoding2 = value2.getEncoding();
        if (encoding2 == USASCIIEncoding.INSTANCE || encoding2 == ASCIIEncoding.INSTANCE) {
            return value2.toString();
        }
        if (encoding2 instanceof UnicodeEncoding) {
            return new String(value2.getUnsafeBytes(), value2.getBegin(), value2.getRealSize(), value2.getEncoding().getCharset());
        }
        return value2.toString();
    }

    public static String decodeByteList(Ruby runtime, ByteList value2) {
        byte[] unsafeBytes = value2.getUnsafeBytes();
        int begin2 = value2.getBegin();
        int length2 = value2.length();
        Encoding encoding2 = value2.getEncoding();
        if (encoding2 == UTF8Encoding.INSTANCE) {
            return RubyEncoding.decodeUTF8(unsafeBytes, begin2, length2);
        }
        Charset charset = runtime.getEncodingService().charsetForEncoding(encoding2);
        if (charset == null) {
            Encoding utf16 = EncodingUtils.getUTF16ForPlatform();
            return EncodingUtils.strConvEnc(runtime.getCurrentContext(), value2, value2.getEncoding(), utf16).toString();
        }
        return RubyEncoding.decode(unsafeBytes, begin2, length2, charset);
    }

    public static String byteListToString(ByteList bytes2) {
        Charset charset = bytes2.getEncoding().getCharset();
        if (charset != null) {
            return new String(bytes2.getUnsafeBytes(), bytes2.getBegin(), bytes2.getRealSize(), charset);
        }
        return bytes2.toString();
    }

    public static IRubyObject rewriteStackTraceAndThrow(ThreadContext context, Throwable t) {
        Ruby runtime = context.runtime;
        StackTraceElement[] javaTrace = t.getStackTrace();
        BacktraceData backtraceData = runtime.getInstanceConfig().getTraceType().getIntegratedBacktrace(context, javaTrace);
        t.setStackTrace(RaiseException.javaTraceFromRubyTrace(backtraceData.getBacktrace(runtime)));
        Helpers.throwException(t);
        return null;
    }

    public static void rewriteStackTrace(Ruby runtime, Throwable e) {
        StackTraceElement[] javaTrace = e.getStackTrace();
        BacktraceData backtraceData = runtime.getInstanceConfig().getTraceType().getIntegratedBacktrace(runtime.getCurrentContext(), javaTrace);
        e.setStackTrace(RaiseException.javaTraceFromRubyTrace(backtraceData.getBacktrace(runtime)));
    }

    public static String stringJoin(String delimiter, String[] strings) {
        if (strings.length == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder(strings[0]);
        for (int i2 = 1; i2 < strings.length; ++i2) {
            sb.append(delimiter).append(strings[i2]);
        }
        return sb.toString();
    }

    public static <T> T[] arrayOf(T ... values2) {
        return values2;
    }

    public static <T> T[] arrayOf(Class<T> t, int size2, T fill2) {
        Object[] ary = (Object[])Array.newInstance(t, size2);
        Arrays.fill(ary, fill2);
        return ary;
    }

    public static int memchr(boolean[] ary, int start2, int len, boolean find2) {
        for (int i2 = 0; i2 < len; ++i2) {
            if (ary[i2 + start2] != find2) continue;
            return i2 + start2;
        }
        return -1;
    }

    public static boolean isRequiredKeywordArgumentValueNode(Node asgnNode) {
        return asgnNode.childNodes().get(0) instanceof RequiredKeywordArgumentValueNode;
    }

    @Deprecated
    public static String encodeParameterList(List<String[]> args2) {
        if (args2.size() == 0) {
            return "NONE";
        }
        StringBuilder builder = new StringBuilder();
        boolean added = false;
        for (String[] desc : args2) {
            if (added) {
                builder.append(';');
            }
            builder.append(desc[0]).append(desc[1]);
            added = true;
        }
        return builder.toString();
    }

    private static class MethodMissingMethod
    extends DynamicMethod {
        private final DynamicMethod delegate;
        private final CallType lastCallStatus;
        private final Visibility lastVisibility;

        public MethodMissingMethod(DynamicMethod delegate, Visibility lastVisibility, CallType lastCallStatus) {
            this.delegate = delegate;
            this.lastCallStatus = lastCallStatus;
            this.lastVisibility = lastVisibility;
        }

        @Override
        public IRubyObject call(ThreadContext context, IRubyObject self2, RubyModule clazz, String name2, IRubyObject[] args2, Block block) {
            context.setLastCallStatusAndVisibility(this.lastCallStatus, this.lastVisibility);
            return this.delegate.call(context, self2, clazz, "method_missing", Helpers.prepareMethodMissingArgs(args2, context, name2), block);
        }

        @Override
        public DynamicMethod dup() {
            return this;
        }
    }
}

