/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.core.klass;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.object.DynamicObjectFactory;
import com.oracle.truffle.api.object.FinalLocationException;
import com.oracle.truffle.api.object.HiddenKey;
import com.oracle.truffle.api.object.IncompatibleLocationException;
import com.oracle.truffle.api.object.LocationModifier;
import com.oracle.truffle.api.object.ObjectType;
import com.oracle.truffle.api.object.Property;
import com.oracle.truffle.api.object.Shape;
import java.util.EnumSet;
import org.jruby.truffle.core.klass.ClassLayout;
import org.jruby.truffle.core.module.ModuleFields;
import org.jruby.truffle.core.module.ModuleLayoutImpl;

@GeneratedBy(value=ClassLayout.class)
public class ClassLayoutImpl
extends ModuleLayoutImpl
implements ClassLayout {
    public static final ClassLayout INSTANCE = new ClassLayoutImpl();
    protected static final Shape.Allocator CLASS_ALLOCATOR = LAYOUT.createAllocator();
    protected static final HiddenKey IS_SINGLETON_IDENTIFIER;
    protected static final Property IS_SINGLETON_PROPERTY;
    protected static final HiddenKey ATTACHED_IDENTIFIER;
    protected static final Property ATTACHED_PROPERTY;
    protected static final HiddenKey INSTANCE_FACTORY_IDENTIFIER;
    protected static final Property INSTANCE_FACTORY_PROPERTY;
    protected static final HiddenKey SUPERCLASS_IDENTIFIER;
    protected static final Property SUPERCLASS_PROPERTY;

    protected ClassLayoutImpl() {
    }

    @Override
    public DynamicObjectFactory createClassShape(DynamicObject logicalClass, DynamicObject metaClass) {
        return LAYOUT.createShape(new ClassType(logicalClass, metaClass)).addProperty(FIELDS_PROPERTY).addProperty(IS_SINGLETON_PROPERTY).addProperty(ATTACHED_PROPERTY).addProperty(INSTANCE_FACTORY_PROPERTY).addProperty(SUPERCLASS_PROPERTY).createFactory();
    }

    @Override
    public DynamicObject createClass(DynamicObjectFactory factory, ModuleFields fields, boolean isSingleton, DynamicObject attached, DynamicObjectFactory instanceFactory, DynamicObject superclass) {
        assert (factory != null);
        CompilerAsserts.partialEvaluationConstant(factory);
        assert (ClassLayoutImpl.createsClass(factory));
        assert (factory.getShape().hasProperty(FIELDS_IDENTIFIER));
        assert (factory.getShape().hasProperty(IS_SINGLETON_IDENTIFIER));
        assert (factory.getShape().hasProperty(ATTACHED_IDENTIFIER));
        assert (factory.getShape().hasProperty(INSTANCE_FACTORY_IDENTIFIER));
        assert (factory.getShape().hasProperty(SUPERCLASS_IDENTIFIER));
        assert (fields != null);
        return factory.newInstance(fields, isSingleton, attached, instanceFactory, superclass);
    }

    @Override
    public boolean isClass(Object object) {
        return object instanceof DynamicObject && this.isClass((DynamicObject)object);
    }

    @Override
    public boolean isClass(DynamicObject object) {
        return ClassLayoutImpl.isClass(object.getShape().getObjectType());
    }

    private static boolean isClass(ObjectType objectType) {
        return objectType instanceof ClassType;
    }

    private static boolean createsClass(DynamicObjectFactory factory) {
        return ClassLayoutImpl.isClass(factory.getShape().getObjectType());
    }

    @Override
    public boolean getIsSingleton(DynamicObject object) {
        assert (this.isClass(object));
        assert (object.getShape().hasProperty(IS_SINGLETON_IDENTIFIER));
        return (Boolean)IS_SINGLETON_PROPERTY.get(object, this.isClass(object));
    }

    @Override
    public DynamicObject getAttached(DynamicObject object) {
        assert (this.isClass(object));
        assert (object.getShape().hasProperty(ATTACHED_IDENTIFIER));
        return (DynamicObject)ATTACHED_PROPERTY.get(object, this.isClass(object));
    }

    @Override
    public DynamicObjectFactory getInstanceFactory(DynamicObject object) {
        assert (this.isClass(object));
        assert (object.getShape().hasProperty(INSTANCE_FACTORY_IDENTIFIER));
        return (DynamicObjectFactory)INSTANCE_FACTORY_PROPERTY.get(object, this.isClass(object));
    }

    @Override
    public void setInstanceFactoryUnsafe(DynamicObject object, DynamicObjectFactory value) {
        assert (this.isClass(object));
        assert (object.getShape().hasProperty(INSTANCE_FACTORY_IDENTIFIER));
        INSTANCE_FACTORY_PROPERTY.setInternal(object, value);
    }

    @Override
    public DynamicObject getSuperclass(DynamicObject object) {
        assert (this.isClass(object));
        assert (object.getShape().hasProperty(SUPERCLASS_IDENTIFIER));
        return (DynamicObject)SUPERCLASS_PROPERTY.get(object, this.isClass(object));
    }

    @Override
    public void setSuperclass(DynamicObject object, DynamicObject value) {
        assert (this.isClass(object));
        assert (object.getShape().hasProperty(SUPERCLASS_IDENTIFIER));
        try {
            SUPERCLASS_PROPERTY.set(object, value, object.getShape());
        }
        catch (FinalLocationException | IncompatibleLocationException e) {
            throw new UnsupportedOperationException(e);
        }
    }

    static {
        CLASS_ALLOCATOR.locationForType(ModuleFields.class, EnumSet.of(LocationModifier.NonNull));
        IS_SINGLETON_IDENTIFIER = new HiddenKey("isSingleton");
        IS_SINGLETON_PROPERTY = Property.create(IS_SINGLETON_IDENTIFIER, CLASS_ALLOCATOR.locationForType(Boolean.TYPE, EnumSet.of(LocationModifier.NonNull, LocationModifier.Final)), 0);
        ATTACHED_IDENTIFIER = new HiddenKey("attached");
        ATTACHED_PROPERTY = Property.create(ATTACHED_IDENTIFIER, CLASS_ALLOCATOR.locationForType(DynamicObject.class, EnumSet.of(LocationModifier.Final)), 0);
        INSTANCE_FACTORY_IDENTIFIER = new HiddenKey("instanceFactory");
        INSTANCE_FACTORY_PROPERTY = Property.create(INSTANCE_FACTORY_IDENTIFIER, CLASS_ALLOCATOR.locationForType(DynamicObjectFactory.class, EnumSet.of(LocationModifier.Final)), 0);
        SUPERCLASS_IDENTIFIER = new HiddenKey("superclass");
        SUPERCLASS_PROPERTY = Property.create(SUPERCLASS_IDENTIFIER, CLASS_ALLOCATOR.locationForType(DynamicObject.class), 0);
    }

    public static class ClassType
    extends ModuleLayoutImpl.ModuleType {
        public ClassType(DynamicObject logicalClass, DynamicObject metaClass) {
            super(logicalClass, metaClass);
        }

        @Override
        public ClassType setLogicalClass(DynamicObject logicalClass) {
            return new ClassType(logicalClass, this.metaClass);
        }

        @Override
        public ClassType setMetaClass(DynamicObject metaClass) {
            return new ClassType(this.logicalClass, metaClass);
        }
    }
}

