/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.core.module;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.object.DynamicObjectFactory;
import com.oracle.truffle.api.object.FinalLocationException;
import com.oracle.truffle.api.object.HiddenKey;
import com.oracle.truffle.api.object.IncompatibleLocationException;
import com.oracle.truffle.api.object.LocationModifier;
import com.oracle.truffle.api.object.ObjectType;
import com.oracle.truffle.api.object.Property;
import com.oracle.truffle.api.object.Shape;
import java.util.EnumSet;
import org.jruby.truffle.core.basicobject.BasicObjectLayoutImpl;
import org.jruby.truffle.core.module.ModuleFields;
import org.jruby.truffle.core.module.ModuleLayout;

@GeneratedBy(value=ModuleLayout.class)
public class ModuleLayoutImpl
extends BasicObjectLayoutImpl
implements ModuleLayout {
    public static final ModuleLayout INSTANCE = new ModuleLayoutImpl();
    protected static final Shape.Allocator MODULE_ALLOCATOR = LAYOUT.createAllocator();
    protected static final HiddenKey FIELDS_IDENTIFIER = new HiddenKey("fields");
    protected static final Property FIELDS_PROPERTY = Property.create(FIELDS_IDENTIFIER, MODULE_ALLOCATOR.locationForType(ModuleFields.class, EnumSet.of(LocationModifier.NonNull)), 0);

    protected ModuleLayoutImpl() {
    }

    @Override
    public DynamicObjectFactory createModuleShape(DynamicObject logicalClass, DynamicObject metaClass) {
        return LAYOUT.createShape(new ModuleType(logicalClass, metaClass)).addProperty(FIELDS_PROPERTY).createFactory();
    }

    @Override
    public DynamicObject createModule(DynamicObjectFactory factory, ModuleFields fields) {
        assert (factory != null);
        CompilerAsserts.partialEvaluationConstant(factory);
        assert (this.createsModule(factory));
        assert (factory.getShape().hasProperty(FIELDS_IDENTIFIER));
        assert (fields != null);
        return factory.newInstance(fields);
    }

    @Override
    public boolean isModule(Object object) {
        return object instanceof DynamicObject && this.isModule((DynamicObject)object);
    }

    @Override
    public boolean isModule(DynamicObject object) {
        return this.isModule(object.getShape().getObjectType());
    }

    @Override
    public boolean isModule(ObjectType objectType) {
        return objectType instanceof ModuleType;
    }

    private boolean createsModule(DynamicObjectFactory factory) {
        return this.isModule(factory.getShape().getObjectType());
    }

    @Override
    public ModuleFields getFields(DynamicObject object) {
        assert (this.isModule(object));
        assert (object.getShape().hasProperty(FIELDS_IDENTIFIER));
        return (ModuleFields)FIELDS_PROPERTY.get(object, this.isModule(object));
    }

    @Override
    public void setFields(DynamicObject object, ModuleFields value) {
        assert (this.isModule(object));
        assert (object.getShape().hasProperty(FIELDS_IDENTIFIER));
        assert (value != null);
        try {
            FIELDS_PROPERTY.set(object, value, object.getShape());
        }
        catch (FinalLocationException | IncompatibleLocationException e) {
            throw new UnsupportedOperationException(e);
        }
    }

    public static class ModuleType
    extends BasicObjectLayoutImpl.BasicObjectType {
        public ModuleType(DynamicObject logicalClass, DynamicObject metaClass) {
            super(logicalClass, metaClass);
        }

        @Override
        public ModuleType setLogicalClass(DynamicObject logicalClass) {
            return new ModuleType(logicalClass, this.metaClass);
        }

        @Override
        public ModuleType setMetaClass(DynamicObject metaClass) {
            return new ModuleType(this.logicalClass, metaClass);
        }
    }
}

