/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.core.rubinius;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.object.DynamicObject;
import org.jcodings.Encoding;
import org.joni.Matcher;
import org.joni.Regex;
import org.jruby.Ruby;
import org.jruby.truffle.Layouts;
import org.jruby.truffle.RubyContext;
import org.jruby.truffle.builtins.Primitive;
import org.jruby.truffle.builtins.PrimitiveArrayArgumentsNode;
import org.jruby.truffle.core.regexp.RegexpGuards;
import org.jruby.truffle.core.regexp.RegexpNodes;
import org.jruby.truffle.core.rope.Rope;
import org.jruby.truffle.core.rope.RopeNodes;
import org.jruby.truffle.core.rope.RopeOperations;
import org.jruby.truffle.core.string.StringOperations;
import org.jruby.truffle.language.control.RaiseException;
import org.jruby.util.ByteList;
import org.jruby.util.RegexpSupport;

public abstract class RegexpPrimitiveNodes {

    @Primitive(name="regexp_set_block_last_match")
    public static abstract class RegexpSetBlockLastMatchPrimitiveNode
    extends PrimitiveArrayArgumentsNode {
        @Specialization
        public DynamicObject setBlockLastMatch(DynamicObject regexpClass) {
            return this.nil();
        }
    }

    @Primitive(name="regexp_set_last_match")
    public static abstract class RegexpSetLastMatchPrimitiveNode
    extends PrimitiveArrayArgumentsNode {
        @Specialization
        public Object setLastMatchData(DynamicObject regexpClass, Object matchData) {
            RegexpSetLastMatchPrimitiveNode.setLastMatch(this.getContext(), matchData);
            return matchData;
        }

        @CompilerDirectives.TruffleBoundary
        public static void setLastMatch(RubyContext context, Object matchData) {
            DynamicObject threadLocals = Layouts.THREAD.getThreadLocals(context.getThreadManager().getCurrentThread());
            threadLocals.set("$~", matchData);
        }
    }

    @Primitive(name="regexp_search_region", lowerFixnumParameters={1, 2})
    @ImportStatic(value={RegexpGuards.class})
    public static abstract class RegexpSearchRegionPrimitiveNode
    extends PrimitiveArrayArgumentsNode {
        @Specialization(guards={"!isInitialized(regexp)", "isRubyString(string)"})
        public Object searchRegionNotInitialized(DynamicObject regexp, DynamicObject string, int start, int end, boolean forward) {
            throw new RaiseException(this.coreExceptions().typeError("uninitialized Regexp", this));
        }

        @Specialization(guards={"isRubyString(string)", "!isValidEncoding(string)"})
        public Object searchRegionInvalidEncoding(DynamicObject regexp, DynamicObject string, int start, int end, boolean forward) {
            throw new RaiseException(this.coreExceptions().argumentError(this.formatError(string), this));
        }

        @CompilerDirectives.TruffleBoundary
        private String formatError(DynamicObject string) {
            return String.format("invalid byte sequence in %s", Layouts.STRING.getRope(string).getEncoding());
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"isInitialized(regexp)", "isRubyString(string)", "isValidEncoding(string)"})
        public Object searchRegion(DynamicObject regexp, DynamicObject string, int start, int end, boolean forward, @Cached(value="createX()") RopeNodes.MakeSubstringNode makeSubstringNode) {
            Rope stringRope = StringOperations.rope(string);
            Rope regexpSourceRope = Layouts.REGEXP.getSource(regexp);
            Encoding enc = RegexpNodes.checkEncoding(regexp, stringRope, true);
            ByteList preprocessed = RegexpSupport.preprocess((Ruby)this.getContext().getJRubyRuntime(), (ByteList)RopeOperations.getByteListReadOnly(regexpSourceRope), (Encoding)enc, (Encoding[])new Encoding[]{null}, (RegexpSupport.ErrorMode)RegexpSupport.ErrorMode.RAISE);
            Rope preprocessedRope = RegexpNodes.shimModifiers(StringOperations.ropeFromByteList(preprocessed));
            Regex r = new Regex(preprocessedRope.getBytes(), 0, preprocessedRope.byteLength(), Layouts.REGEXP.getRegex(regexp).getOptions(), RegexpNodes.checkEncoding(regexp, stringRope, true));
            Matcher matcher = r.matcher(stringRope.getBytes(), 0, stringRope.byteLength());
            if (forward) {
                return RegexpNodes.matchCommon(this.getContext(), makeSubstringNode, regexp, string, false, false, matcher, start, end);
            }
            return RegexpNodes.matchCommon(this.getContext(), makeSubstringNode, regexp, string, false, false, matcher, end, start);
        }
    }

    @Primitive(name="regexp_propagate_last_match")
    public static abstract class RegexpPropagateLastMatchPrimitiveNode
    extends PrimitiveArrayArgumentsNode {
        @Specialization
        public DynamicObject propagateLastMatch(DynamicObject regexpClass) {
            return this.nil();
        }
    }

    @Primitive(name="regexp_options")
    @ImportStatic(value={RegexpGuards.class})
    public static abstract class RegexpOptionsPrimitiveNode
    extends PrimitiveArrayArgumentsNode {
        @Specialization(guards={"isInitialized(regexp)"})
        public int options(DynamicObject regexp) {
            return Layouts.REGEXP.getOptions(regexp).toOptions();
        }

        @Specialization(guards={"!isInitialized(regexp)"})
        public int optionsNotInitialized(DynamicObject regexp) {
            throw new RaiseException(this.coreExceptions().typeError("uninitialized Regexp", this));
        }
    }

    @Primitive(name="regexp_initialize", lowerFixnumParameters={1})
    @ImportStatic(value={RegexpGuards.class})
    public static abstract class RegexpInitializePrimitiveNode
    extends PrimitiveArrayArgumentsNode {
        @Specialization(guards={"isRegexpLiteral(regexp)", "isRubyString(pattern)"})
        public DynamicObject initializeRegexpLiteral(DynamicObject regexp, DynamicObject pattern, int options) {
            throw new RaiseException(this.coreExceptions().securityError("can't modify literal regexp", this));
        }

        @Specialization(guards={"!isRegexpLiteral(regexp)", "isInitialized(regexp)", "isRubyString(pattern)"})
        public DynamicObject initializeAlreadyInitialized(DynamicObject regexp, DynamicObject pattern, int options) {
            throw new RaiseException(this.coreExceptions().typeError("already initialized regexp", this));
        }

        @Specialization(guards={"!isRegexpLiteral(regexp)", "!isInitialized(regexp)", "isRubyString(pattern)"})
        public DynamicObject initialize(DynamicObject regexp, DynamicObject pattern, int options) {
            RegexpNodes.initialize(this.getContext(), regexp, this, StringOperations.rope(pattern), options);
            return regexp;
        }
    }

    @Primitive(name="regexp_fixed_encoding_p")
    public static abstract class RegexpFixedEncodingPrimitiveNode
    extends PrimitiveArrayArgumentsNode {
        @Specialization
        public boolean fixedEncoding(DynamicObject regexp) {
            return Layouts.REGEXP.getOptions(regexp).isFixed();
        }
    }
}

