/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.layouting.renderer.text;

import java.util.ArrayList;
import org.jfree.layouting.LayoutProcess;
import org.jfree.layouting.State;
import org.jfree.layouting.StateException;
import org.jfree.layouting.StatefullComponent;
import org.jfree.layouting.input.style.keys.text.TextStyleKeys;
import org.jfree.layouting.input.style.keys.text.TextWrap;
import org.jfree.layouting.input.style.keys.text.WhitespaceCollapse;
import org.jfree.layouting.input.style.values.CSSValue;
import org.jfree.layouting.layouter.context.FontSpecification;
import org.jfree.layouting.layouter.context.LayoutContext;
import org.jfree.layouting.layouter.style.CSSValueResolverUtility;
import org.jfree.layouting.output.OutputProcessorMetaData;
import org.jfree.layouting.renderer.model.RenderNode;
import org.jfree.layouting.renderer.model.RenderableText;
import org.jfree.layouting.renderer.model.SpacerRenderNode;
import org.jfree.layouting.renderer.text.Glyph;
import org.jfree.layouting.renderer.text.RenderableTextFactory;
import org.jfree.layouting.renderer.text.TextUtility;
import org.pentaho.reporting.libraries.base.util.ObjectUtilities;
import org.pentaho.reporting.libraries.fonts.registry.FontMetrics;
import org.pentaho.reporting.libraries.fonts.text.ClassificationProducer;
import org.pentaho.reporting.libraries.fonts.text.DefaultLanguageClassifier;
import org.pentaho.reporting.libraries.fonts.text.GraphemeClusterProducer;
import org.pentaho.reporting.libraries.fonts.text.LanguageClassifier;
import org.pentaho.reporting.libraries.fonts.text.Spacing;
import org.pentaho.reporting.libraries.fonts.text.SpacingProducer;
import org.pentaho.reporting.libraries.fonts.text.StaticSpacingProducer;
import org.pentaho.reporting.libraries.fonts.text.breaks.BreakOpportunityProducer;
import org.pentaho.reporting.libraries.fonts.text.breaks.LineBreakProducer;
import org.pentaho.reporting.libraries.fonts.text.breaks.WordBreakProducer;
import org.pentaho.reporting.libraries.fonts.text.classifier.GlyphClassificationProducer;
import org.pentaho.reporting.libraries.fonts.text.classifier.LinebreakClassificationProducer;
import org.pentaho.reporting.libraries.fonts.text.classifier.WhitespaceClassificationProducer;
import org.pentaho.reporting.libraries.fonts.text.font.FontSizeProducer;
import org.pentaho.reporting.libraries.fonts.text.font.GlyphMetrics;
import org.pentaho.reporting.libraries.fonts.text.font.KerningProducer;
import org.pentaho.reporting.libraries.fonts.text.font.NoKerningProducer;
import org.pentaho.reporting.libraries.fonts.text.font.VariableFontSizeProducer;
import org.pentaho.reporting.libraries.fonts.text.whitespace.CollapseWhiteSpaceFilter;
import org.pentaho.reporting.libraries.fonts.text.whitespace.DiscardWhiteSpaceFilter;
import org.pentaho.reporting.libraries.fonts.text.whitespace.PreserveBreaksWhiteSpaceFilter;
import org.pentaho.reporting.libraries.fonts.text.whitespace.PreserveWhiteSpaceFilter;
import org.pentaho.reporting.libraries.fonts.text.whitespace.WhiteSpaceFilter;

public class DefaultRenderableTextFactory
implements RenderableTextFactory {
    private LayoutProcess layoutProcess;
    private GraphemeClusterProducer clusterProducer;
    private boolean startText;
    private boolean produced;
    private FontSizeProducer fontSizeProducer;
    private KerningProducer kerningProducer;
    private SpacingProducer spacingProducer;
    private BreakOpportunityProducer breakOpportunityProducer;
    private WhiteSpaceFilter whitespaceFilter;
    private CSSValue whitespaceCollapseValue;
    private GlyphClassificationProducer classificationProducer;
    private LayoutContext layoutContext;
    private LanguageClassifier languageClassifier;
    private transient GlyphMetrics dims;
    private ArrayList words;
    private ArrayList glyphList;
    private long leadingMargin;
    private int lastLanguage;
    private transient FontMetrics fontMetrics;
    private static final int[] EMPTY_EXTRA_CHARS = new int[0];
    private static final RenderNode[] EMPTY_RENDER_NODE = new RenderNode[0];
    private static final RenderableText[] EMPTY_TEXT = new RenderableText[0];

    public DefaultRenderableTextFactory(LayoutProcess layoutProcess) {
        this(layoutProcess, true);
    }

    protected DefaultRenderableTextFactory(LayoutProcess layoutProcess, boolean bl) {
        this.layoutProcess = layoutProcess;
        if (bl) {
            this.clusterProducer = new GraphemeClusterProducer();
            this.languageClassifier = new DefaultLanguageClassifier();
            this.startText = true;
            this.words = new ArrayList();
            this.glyphList = new ArrayList();
            this.dims = new GlyphMetrics();
        }
    }

    public RenderNode[] createText(int[] nArray, int n, int n2, LayoutContext layoutContext) {
        if (layoutContext == null) {
            throw new NullPointerException();
        }
        this.kerningProducer = this.createKerningProducer(layoutContext);
        this.fontSizeProducer = this.createFontSizeProducer(layoutContext);
        this.spacingProducer = this.createSpacingProducer(layoutContext);
        this.breakOpportunityProducer = this.createBreakProducer(layoutContext);
        this.whitespaceFilter = this.createWhitespaceFilter(layoutContext);
        this.classificationProducer = this.createGlyphClassifier(layoutContext);
        this.layoutContext = layoutContext;
        if (this.startText) {
            this.whitespaceFilter.filter(Integer.MIN_VALUE);
            this.breakOpportunityProducer.createBreakOpportunity(Integer.MIN_VALUE);
            this.kerningProducer.getKerning(Integer.MIN_VALUE);
            this.startText = false;
            this.produced = false;
        }
        FontSpecification fontSpecification = layoutContext.getFontSpecification();
        OutputProcessorMetaData outputProcessorMetaData = this.layoutProcess.getOutputMetaData();
        this.fontMetrics = outputProcessorMetaData.getFontMetrics(fontSpecification);
        return this.processText(nArray, n, n2);
    }

    protected RenderNode[] processText(int[] nArray, int n, int n2) {
        int n3;
        int n4 = -1;
        int n5 = Math.min(n2 + n, nArray.length);
        for (n3 = n; n3 < n5; ++n3) {
            int n6 = nArray[n3];
            boolean bl = this.clusterProducer.createGraphemeCluster(n6);
            if (!bl) continue;
            if (n3 > n) {
                int n7 = n3 - n4 - 1;
                if (n7 > 0) {
                    int[] nArray2 = new int[n7];
                    System.arraycopy(nArray, n4 + 1, nArray2, 0, nArray2.length);
                    this.addGlyph(nArray[n4], nArray2);
                } else {
                    this.addGlyph(nArray[n4], EMPTY_EXTRA_CHARS);
                }
            }
            n4 = n3;
        }
        if (n4 >= n) {
            n3 = n5 - n4 - 1;
            if (n3 > 0) {
                int[] nArray3 = new int[n3];
                System.arraycopy(nArray, n4 + 1, nArray3, 0, nArray3.length);
                this.addGlyph(nArray[n4], nArray3);
            } else {
                this.addGlyph(nArray[n4], EMPTY_EXTRA_CHARS);
            }
        }
        if (!this.words.isEmpty()) {
            RenderNode[] renderNodeArray = this.words.toArray(new RenderNode[this.words.size()]);
            this.words.clear();
            this.produced = true;
            return renderNodeArray;
        }
        return EMPTY_RENDER_NODE;
    }

    protected void addGlyph(int n, int[] nArray) {
        boolean bl;
        int n2;
        boolean bl2;
        if (n == Integer.MAX_VALUE) {
            this.whitespaceFilter.filter(n);
            this.classificationProducer.getClassification(n);
            this.kerningProducer.getKerning(n);
            this.breakOpportunityProducer.createBreakOpportunity(n);
            this.spacingProducer.createSpacing(n);
            this.fontSizeProducer.getCharacterSize(n, this.dims);
            if (this.leadingMargin != 0L || !this.glyphList.isEmpty()) {
                this.addWord(false);
            } else {
                this.glyphList.clear();
                this.leadingMargin = 0L;
            }
            return;
        }
        int n3 = this.whitespaceFilter.filter(n);
        if (n3 == -1) {
            if (nArray.length == 0) {
                bl2 = true;
            } else {
                n3 = 32;
                bl2 = false;
            }
        } else {
            bl2 = false;
        }
        int n4 = this.classificationProducer.getClassification(n3);
        long l = this.kerningProducer.getKerning(n3);
        int n5 = this.breakOpportunityProducer.createBreakOpportunity(n3);
        Spacing spacing = this.spacingProducer.createSpacing(n3);
        this.dims = this.fontSizeProducer.getCharacterSize(n3, this.dims);
        int n6 = this.dims.getWidth() & Integer.MAX_VALUE;
        int n7 = this.dims.getHeight() & Integer.MAX_VALUE;
        this.lastLanguage = this.languageClassifier.getScript(n3);
        for (n2 = 0; n2 < nArray.length; ++n2) {
            bl = nArray[n2];
            this.dims = this.fontSizeProducer.getCharacterSize(bl ? 1 : 0, this.dims);
            n6 = Math.max(n6, this.dims.getWidth() & Integer.MAX_VALUE);
            n7 = Math.max(n7, this.dims.getHeight() & Integer.MAX_VALUE);
            n5 = this.breakOpportunityProducer.createBreakOpportunity(bl ? 1 : 0);
            n4 = this.classificationProducer.getClassification(bl ? 1 : 0);
        }
        if (bl2) {
            return;
        }
        if (0 == n4 && this.isWordBreak(n5)) {
            int n8 = n2 = n5 == 4 ? 1 : 0;
            if (!this.glyphList.isEmpty() || n2 != 0) {
                this.addWord(n2 != 0);
            }
            this.leadingMargin += (long)n6;
            return;
        }
        Glyph glyph = new Glyph(n3, n5, n4, spacing, n6, n7, this.dims.getBaselinePosition(), (int)l, nArray);
        this.glyphList.add(glyph);
        if (this.isWordBreak(n5) && !this.glyphList.isEmpty()) {
            bl = n5 == 4;
            this.addWord(bl);
        }
    }

    protected void addWord(boolean bl) {
        if (this.glyphList.isEmpty()) {
            if (bl) {
                RenderableText renderableText = new RenderableText(TextUtility.createBaselineInfo(10, this.fontMetrics), new Glyph[0], 0, 0, this.lastLanguage, bl);
                renderableText.appyStyle(this.layoutContext, this.layoutProcess.getOutputMetaData());
                this.words.add(renderableText);
            } else if (this.produced) {
                SpacerRenderNode spacerRenderNode = new SpacerRenderNode(this.leadingMargin, 0L, false);
                spacerRenderNode.appyStyle(this.layoutContext, this.layoutProcess.getOutputMetaData());
                this.words.add(spacerRenderNode);
            }
        } else {
            Glyph[] glyphArray = this.glyphList.toArray(new Glyph[this.glyphList.size()]);
            if (this.leadingMargin > 0L) {
                SpacerRenderNode spacerRenderNode = new SpacerRenderNode(this.leadingMargin, 0L, false);
                spacerRenderNode.appyStyle(this.layoutContext, this.layoutProcess.getOutputMetaData());
                this.words.add(spacerRenderNode);
            }
            int n = glyphArray[0].getCodepoint();
            RenderableText renderableText = new RenderableText(TextUtility.createBaselineInfo(n, this.fontMetrics), glyphArray, 0, glyphArray.length, this.lastLanguage, bl);
            renderableText.appyStyle(this.layoutContext, this.layoutProcess.getOutputMetaData());
            this.words.add(renderableText);
            this.glyphList.clear();
        }
        this.leadingMargin = 0L;
    }

    private boolean isWordBreak(int n) {
        return 3 == n || 4 == n;
    }

    protected WhiteSpaceFilter createWhitespaceFilter(LayoutContext layoutContext) {
        CSSValue cSSValue = layoutContext.getValue(TextStyleKeys.WHITE_SPACE_COLLAPSE);
        if (ObjectUtilities.equal((Object)this.whitespaceCollapseValue, (Object)cSSValue) && this.whitespaceFilter != null) {
            this.whitespaceFilter.reset();
            return this.whitespaceFilter;
        }
        this.whitespaceCollapseValue = cSSValue;
        if (WhitespaceCollapse.DISCARD.equals(cSSValue)) {
            return new DiscardWhiteSpaceFilter();
        }
        if (WhitespaceCollapse.PRESERVE.equals(cSSValue)) {
            return new PreserveWhiteSpaceFilter();
        }
        if (WhitespaceCollapse.PRESERVE_BREAKS.equals(cSSValue)) {
            return new PreserveBreaksWhiteSpaceFilter();
        }
        return new CollapseWhiteSpaceFilter();
    }

    protected GlyphClassificationProducer createGlyphClassifier(LayoutContext layoutContext) {
        CSSValue cSSValue = layoutContext.getValue(TextStyleKeys.WHITE_SPACE_COLLAPSE);
        if (WhitespaceCollapse.PRESERVE.equals(cSSValue)) {
            return new LinebreakClassificationProducer();
        }
        return new WhitespaceClassificationProducer();
    }

    protected BreakOpportunityProducer createBreakProducer(LayoutContext layoutContext) {
        CSSValue cSSValue = layoutContext.getValue(TextStyleKeys.TEXT_WRAP);
        if (TextWrap.NONE.equals(cSSValue)) {
            return new LineBreakProducer();
        }
        return new WordBreakProducer();
    }

    protected SpacingProducer createSpacingProducer(LayoutContext layoutContext) {
        CSSValue cSSValue = layoutContext.getValue(TextStyleKeys.X_MIN_LETTER_SPACING);
        CSSValue cSSValue2 = layoutContext.getValue(TextStyleKeys.X_OPTIMUM_LETTER_SPACING);
        CSSValue cSSValue3 = layoutContext.getValue(TextStyleKeys.X_MAX_LETTER_SPACING);
        OutputProcessorMetaData outputProcessorMetaData = this.layoutProcess.getOutputMetaData();
        int n = (int)CSSValueResolverUtility.convertLengthToDouble(cSSValue, layoutContext, outputProcessorMetaData);
        int n2 = (int)CSSValueResolverUtility.convertLengthToDouble(cSSValue2, layoutContext, outputProcessorMetaData);
        int n3 = (int)CSSValueResolverUtility.convertLengthToDouble(cSSValue3, layoutContext, outputProcessorMetaData);
        Spacing spacing = new Spacing(n, n2, n3);
        return new StaticSpacingProducer(spacing);
    }

    protected FontSizeProducer createFontSizeProducer(LayoutContext layoutContext) {
        FontSpecification fontSpecification = layoutContext.getFontSpecification();
        OutputProcessorMetaData outputProcessorMetaData = this.layoutProcess.getOutputMetaData();
        FontMetrics fontMetrics = outputProcessorMetaData.getFontMetrics(fontSpecification);
        return new VariableFontSizeProducer(fontMetrics);
    }

    protected KerningProducer createKerningProducer(LayoutContext layoutContext) {
        return new NoKerningProducer();
    }

    public RenderNode[] finishText() {
        if (this.layoutContext == null) {
            return EMPTY_TEXT;
        }
        RenderNode[] renderNodeArray = this.processText(new int[]{Integer.MAX_VALUE}, 0, 1);
        this.layoutContext = null;
        this.classificationProducer = null;
        this.kerningProducer = null;
        this.fontSizeProducer = null;
        this.spacingProducer = null;
        this.breakOpportunityProducer = null;
        return renderNodeArray;
    }

    public void startText() {
        this.startText = true;
    }

    public State saveState() throws StateException {
        return new DefaultRenderableTextFactoryState(this);
    }

    protected static class DefaultRenderableTextFactoryState
    implements State {
        private GraphemeClusterProducer clusterProducer;
        private boolean startText;
        private boolean produced;
        private FontSizeProducer fontSizeProducer;
        private KerningProducer kerningProducer;
        private SpacingProducer spacingProducer;
        private BreakOpportunityProducer breakOpportunityProducer;
        private WhiteSpaceFilter whitespaceFilter;
        private CSSValue whitespaceCollapseValue;
        private ClassificationProducer classificationProducer;
        private LanguageClassifier languageClassifier;
        private ArrayList words;
        private ArrayList glyphList;
        private long leadingMargin;
        private int lastLanguage;

        protected DefaultRenderableTextFactoryState(DefaultRenderableTextFactory defaultRenderableTextFactory) throws StateException {
            try {
                this.lastLanguage = defaultRenderableTextFactory.lastLanguage;
                this.leadingMargin = defaultRenderableTextFactory.leadingMargin;
                this.glyphList = (ArrayList)defaultRenderableTextFactory.glyphList.clone();
                this.words = (ArrayList)defaultRenderableTextFactory.words.clone();
                this.languageClassifier = (LanguageClassifier)defaultRenderableTextFactory.languageClassifier.clone();
                this.clusterProducer = (GraphemeClusterProducer)defaultRenderableTextFactory.clusterProducer.clone();
                this.produced = defaultRenderableTextFactory.produced;
                this.startText = defaultRenderableTextFactory.startText;
                if (defaultRenderableTextFactory.layoutContext != null) {
                    this.classificationProducer = (ClassificationProducer)defaultRenderableTextFactory.classificationProducer.clone();
                    this.whitespaceCollapseValue = defaultRenderableTextFactory.whitespaceCollapseValue;
                    this.whitespaceFilter = (WhiteSpaceFilter)defaultRenderableTextFactory.whitespaceFilter.clone();
                    this.breakOpportunityProducer = (BreakOpportunityProducer)defaultRenderableTextFactory.breakOpportunityProducer.clone();
                    this.spacingProducer = (SpacingProducer)defaultRenderableTextFactory.spacingProducer.clone();
                    this.kerningProducer = (KerningProducer)defaultRenderableTextFactory.kerningProducer.clone();
                    this.fontSizeProducer = (FontSizeProducer)defaultRenderableTextFactory.fontSizeProducer.clone();
                }
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                throw new StateException("Failed to save state", cloneNotSupportedException);
            }
        }

        public StatefullComponent restore(LayoutProcess layoutProcess) throws StateException {
            try {
                DefaultRenderableTextFactory defaultRenderableTextFactory = new DefaultRenderableTextFactory(layoutProcess, false);
                defaultRenderableTextFactory.dims = null;
                defaultRenderableTextFactory.lastLanguage = this.lastLanguage;
                defaultRenderableTextFactory.leadingMargin = this.leadingMargin;
                defaultRenderableTextFactory.glyphList = (ArrayList)this.glyphList.clone();
                defaultRenderableTextFactory.words = (ArrayList)this.words.clone();
                defaultRenderableTextFactory.languageClassifier = (LanguageClassifier)this.languageClassifier.clone();
                defaultRenderableTextFactory.clusterProducer = (GraphemeClusterProducer)this.clusterProducer.clone();
                defaultRenderableTextFactory.produced = this.produced;
                defaultRenderableTextFactory.startText = this.startText;
                if (defaultRenderableTextFactory.classificationProducer != null) {
                    defaultRenderableTextFactory.classificationProducer = (GlyphClassificationProducer)this.classificationProducer.clone();
                    defaultRenderableTextFactory.whitespaceCollapseValue = this.whitespaceCollapseValue;
                    defaultRenderableTextFactory.whitespaceFilter = (WhiteSpaceFilter)this.whitespaceFilter.clone();
                    defaultRenderableTextFactory.breakOpportunityProducer = (BreakOpportunityProducer)this.breakOpportunityProducer.clone();
                    defaultRenderableTextFactory.spacingProducer = (SpacingProducer)this.spacingProducer.clone();
                    defaultRenderableTextFactory.kerningProducer = (KerningProducer)this.kerningProducer.clone();
                    defaultRenderableTextFactory.fontSizeProducer = (FontSizeProducer)this.fontSizeProducer.clone();
                }
                return defaultRenderableTextFactory;
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                throw new StateException("Restoring the state failed", cloneNotSupportedException);
            }
        }
    }
}

