/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.core.format.printf;

import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.Truffle;
import org.antlr.v4.runtime.ANTLRInputStream;
import org.antlr.v4.runtime.CommonTokenStream;
import org.jruby.truffle.RubyContext;
import org.jruby.truffle.core.format.DescriptionTruncater;
import org.jruby.truffle.core.format.FormatEncoding;
import org.jruby.truffle.core.format.FormatErrorListener;
import org.jruby.truffle.core.format.FormatRootNode;
import org.jruby.truffle.core.format.printf.PrintfLexer;
import org.jruby.truffle.core.format.printf.PrintfParser;
import org.jruby.truffle.core.format.printf.PrintfTreeBuilder;
import org.jruby.truffle.language.RubyNode;

public class PrintfCompiler {
    private final RubyContext context;
    private final RubyNode currentNode;

    public PrintfCompiler(RubyContext context, RubyNode currentNode) {
        this.context = context;
        this.currentNode = currentNode;
    }

    public CallTarget compile(String formatString, byte[] format) {
        FormatErrorListener errorListener = new FormatErrorListener(this.context, this.currentNode);
        ANTLRInputStream input = new ANTLRInputStream(PrintfCompiler.bytesToChars(format), format.length);
        PrintfLexer lexer = new PrintfLexer(input);
        lexer.removeErrorListeners();
        lexer.addErrorListener(errorListener);
        CommonTokenStream tokens = new CommonTokenStream(lexer);
        PrintfParser parser = new PrintfParser(tokens);
        PrintfTreeBuilder builder = new PrintfTreeBuilder(this.context, format);
        parser.addParseListener(builder);
        parser.removeErrorListeners();
        parser.addErrorListener(errorListener);
        parser.sequence();
        return Truffle.getRuntime().createCallTarget(new FormatRootNode(DescriptionTruncater.trunate(formatString), FormatEncoding.DEFAULT, builder.getNode()));
    }

    private static char[] bytesToChars(byte[] bytes) {
        char[] chars = new char[bytes.length];
        for (int n = 0; n < bytes.length; ++n) {
            chars[n] = (char)bytes[n];
        }
        return chars;
    }
}

