/*
 * Decompiled with CFR 0.152.
 */
package org.gnu.readline;

import java.io.BufferedReader;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.Collection;
import org.gnu.readline.ReadlineCompleter;
import org.gnu.readline.ReadlineLibrary;

public class Readline {
    private static ReadlineCompleter iCompleter = null;
    private static ReadlineLibrary iLib = ReadlineLibrary.PureJava;
    private static BufferedReader iReader = null;
    private static String iEncoding = System.getProperty("readline.encoding", null);
    private static boolean iThrowException = false;

    public static final void load(ReadlineLibrary readlineLibrary) throws UnsatisfiedLinkError {
        if (readlineLibrary == iLib) {
            return;
        }
        if (readlineLibrary == ReadlineLibrary.PureJava) {
            iLib = readlineLibrary;
            return;
        }
        System.loadLibrary(readlineLibrary.getName());
        iLib = readlineLibrary;
    }

    public static void initReadline(String string) {
        if (iLib == ReadlineLibrary.GnuReadline || iLib == ReadlineLibrary.Editline || iLib == ReadlineLibrary.Getline) {
            Readline.initReadlineImpl(string);
        }
    }

    public static String readline(String string) throws EOFException, IOException, UnsupportedEncodingException {
        return Readline.readline(string, true);
    }

    public static String readline(String string, boolean bl) throws EOFException, IOException, UnsupportedEncodingException {
        String string2;
        if (iLib != ReadlineLibrary.PureJava) {
            String string3 = Readline.readlineImpl(string);
            if (string3 != null && bl) {
                Readline.addToHistory(string3);
            }
            return string3;
        }
        System.out.print(string);
        if (iReader == null) {
            iReader = iEncoding == null ? new BufferedReader(new InputStreamReader(System.in)) : new BufferedReader(new InputStreamReader(System.in, iEncoding));
        }
        if ((string2 = iReader.readLine()) == null) {
            throw new EOFException("EOF");
        }
        if (string2.length() == 0) {
            string2 = null;
        }
        return string2;
    }

    public static void addToHistory(String string) {
        if (iLib == ReadlineLibrary.GnuReadline || iLib == ReadlineLibrary.Editline || iLib == ReadlineLibrary.Getline) {
            Readline.addToHistoryImpl(string);
        } else if (iThrowException) {
            throw new UnsupportedOperationException();
        }
    }

    public static void getHistory(Collection collection) {
        if (iLib == ReadlineLibrary.GnuReadline || iLib == ReadlineLibrary.Editline) {
            Readline.getHistoryImpl(collection);
        } else if (iThrowException) {
            throw new UnsupportedOperationException();
        }
    }

    public static int getHistorySize() {
        int n = 0;
        if (iLib == ReadlineLibrary.GnuReadline || iLib == ReadlineLibrary.Editline) {
            n = Readline.getHistorySizeImpl();
        } else if (iThrowException) {
            throw new UnsupportedOperationException();
        }
        return n;
    }

    public static void clearHistory() {
        if (iLib == ReadlineLibrary.GnuReadline || iLib == ReadlineLibrary.Editline) {
            Readline.clearHistoryImpl();
        } else if (iThrowException) {
            throw new UnsupportedOperationException();
        }
    }

    public static String getHistoryLine(int n) {
        String string = null;
        if (iLib == ReadlineLibrary.GnuReadline || iLib == ReadlineLibrary.Editline) {
            if (n < 0 || n >= Readline.getHistorySize()) {
                throw new ArrayIndexOutOfBoundsException(n);
            }
            string = Readline.getHistoryLineImpl(n);
        } else if (iThrowException) {
            throw new UnsupportedOperationException();
        }
        return string;
    }

    public static void readInitFile(String string) throws IOException {
        if (iLib == ReadlineLibrary.GnuReadline) {
            Readline.readInitFileImpl(string);
        } else if (iThrowException) {
            throw new UnsupportedOperationException();
        }
    }

    public static boolean parseAndBind(String string) {
        if (iLib == ReadlineLibrary.GnuReadline) {
            return Readline.parseAndBindImpl(string);
        }
        if (iThrowException) {
            throw new UnsupportedOperationException();
        }
        return true;
    }

    public static void readHistoryFile(String string) throws EOFException, UnsupportedEncodingException {
        if (iLib == ReadlineLibrary.GnuReadline || iLib == ReadlineLibrary.Editline) {
            Readline.readHistoryFileImpl(string);
        } else if (iThrowException) {
            throw new UnsupportedOperationException();
        }
    }

    public static void writeHistoryFile(String string) throws EOFException, UnsupportedEncodingException {
        if (iLib == ReadlineLibrary.GnuReadline || iLib == ReadlineLibrary.Editline) {
            Readline.writeHistoryFileImpl(string);
        } else if (iThrowException) {
            throw new UnsupportedOperationException();
        }
    }

    public static void setCompleter(ReadlineCompleter readlineCompleter) {
        iCompleter = readlineCompleter;
        if (iLib == ReadlineLibrary.GnuReadline || iLib == ReadlineLibrary.Editline) {
            Readline.setCompleterImpl(iCompleter);
        } else if (iThrowException) {
            throw new UnsupportedOperationException();
        }
    }

    public static ReadlineCompleter getCompleter() {
        return iCompleter;
    }

    public static void cleanup() {
        if (iLib == ReadlineLibrary.GnuReadline || iLib == ReadlineLibrary.Editline) {
            Readline.cleanupReadlineImpl();
        }
    }

    public static boolean hasTerminal() {
        if (iLib == ReadlineLibrary.GnuReadline || iLib == ReadlineLibrary.Editline) {
            return Readline.hasTerminalImpl();
        }
        return true;
    }

    public static String getWordBreakCharacters() {
        if (iLib == ReadlineLibrary.GnuReadline || iLib == ReadlineLibrary.Editline) {
            return Readline.getWordBreakCharactersImpl();
        }
        if (iThrowException) {
            throw new UnsupportedOperationException();
        }
        return null;
    }

    public static String getLineBuffer() {
        if (iLib == ReadlineLibrary.GnuReadline || iLib == ReadlineLibrary.Editline) {
            return Readline.getLineBufferImpl();
        }
        if (iThrowException) {
            throw new UnsupportedOperationException();
        }
        return null;
    }

    public static void setWordBreakCharacters(String string) throws UnsupportedEncodingException {
        if (iLib == ReadlineLibrary.GnuReadline || iLib == ReadlineLibrary.Editline) {
            Readline.setWordBreakCharactersImpl(string);
        } else if (iThrowException) {
            throw new UnsupportedOperationException();
        }
    }

    public static void setThrowExceptionOnUnsupportedMethod(boolean bl) {
        iThrowException = bl;
    }

    public static boolean getThrowExceptionOnUnsupportedMethod() {
        return iThrowException;
    }

    public static void setEncoding(String string) {
        iEncoding = string;
    }

    public static String getEncoding() {
        return iEncoding;
    }

    private static native void initReadlineImpl(String var0);

    private static native void cleanupReadlineImpl();

    private static native boolean hasTerminalImpl();

    private static native String readlineImpl(String var0) throws EOFException, UnsupportedEncodingException;

    private static native void addToHistoryImpl(String var0);

    private static native void getHistoryImpl(Collection var0);

    private static native int getHistorySizeImpl();

    private static native String getHistoryLineImpl(int var0);

    private static native void clearHistoryImpl();

    private static native void readInitFileImpl(String var0) throws IOException;

    private static native String getLineBufferImpl();

    private static native boolean parseAndBindImpl(String var0);

    private static native void readHistoryFileImpl(String var0) throws EOFException, UnsupportedEncodingException;

    private static native void writeHistoryFileImpl(String var0) throws EOFException, UnsupportedEncodingException;

    private static native void setCompleterImpl(ReadlineCompleter var0);

    private static native String getWordBreakCharactersImpl();

    private static native void setWordBreakCharactersImpl(String var0) throws UnsupportedEncodingException;
}

