If you set up Vim plugin for fzf, `:FZF` command will become available. The following variables are used to configure its behavior.

- `g:fzf_action`
- `g:fzf_height`
- `g:fzf_launcher`
    - `g:Fzf_launcher` for function reference

### Key bindings

```vim
" ctrl-[a-z], alt-[a-z], f[1-4], or any single character
let g:fzf_action = {
  \ 'ctrl-m': 'e',
  \ 'ctrl-t': 'tabedit',
  \ 'alt-j':  'botright split',
  \ 'alt-k':  'topleft split',
  \ 'alt-h':  'vertical topleft split',
  \ 'alt-l':  'vertical botright split' }
```

### Window size

If you're on a tmux session or using Neovim, `:FZF` will launch fzf in a
split-window whose height can be adjusted with `g:fzf_height` (default:
'40%'). However, the bang version (`:FZF!`) will always start in fullscreen.

### GVim

In GVim, you need an external terminal emulator to start fzf with. `xterm`
command is used by default, but you can customize it with `g:fzf_launcher`.

```vim
" This is the default. %s is replaced with fzf command
let g:fzf_launcher = 'xterm -e bash -ic %s'

" Use urxvt instead
let g:fzf_launcher = 'urxvt -geometry 120x30 -e sh -c %s'
```

If you're running MacVim on OSX, I recommend you to use iTerm2 as the
launcher. Refer to the [this wiki page][macvim-iterm2] to see how to set up.

[macvim-iterm2]: https://github.com/junegunn/fzf/wiki/On-MacVim-with-iTerm2