/*
 * Decompiled with CFR 0.152.
 */
package groovyx.gpars.remote;

import groovyx.gpars.remote.LocalHost;
import groovyx.gpars.remote.LocalNode;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class LocalHostRegistry {
    public static final Set<LocalHost> localHosts = Collections.synchronizedSet(new HashSet());

    private LocalHostRegistry() {
    }

    public static synchronized void connect(LocalNode node) {
        for (LocalHost transportProvider : localHosts) {
            node.connect(transportProvider);
        }
    }

    public static synchronized void disconnect(final LocalNode node) {
        for (final LocalHost transportProvider : localHosts) {
            node.getScheduler().execute(new Runnable(){

                @Override
                public void run() {
                    transportProvider.disconnect(node);
                }
            });
        }
    }

    public static synchronized void removeLocalHost(LocalHost localHost) {
        localHosts.remove(localHost);
    }

    public static synchronized void addLocalHost(LocalHost localHost) {
        localHosts.add(localHost);
    }
}

