/*
 * Decompiled with CFR 0.152.
 */
package javax.tv.service.navigation;

import java.util.Arrays;
import java.util.Comparator;
import java.util.LinkedList;
import javax.tv.locator.InvalidLocatorException;
import javax.tv.locator.Locator;
import javax.tv.service.Service;
import javax.tv.service.navigation.ServiceFilter;
import javax.tv.service.navigation.ServiceIterator;
import javax.tv.service.navigation.ServiceIteratorImpl;
import javax.tv.service.navigation.ServiceList;
import javax.tv.service.navigation.SortNotAvailableException;
import org.bluray.net.BDLocator;
import org.bluray.ti.TitleImpl;

public class ServiceListImpl
implements ServiceList {
    private LinkedList services;

    public ServiceListImpl(LinkedList services) {
        this.services = services;
    }

    public ServiceList sortByName() {
        Object[] array = this.services.toArray();
        Arrays.sort(array, new TitleComparator());
        LinkedList<Object> list = new LinkedList<Object>();
        for (int i = 0; i < array.length; ++i) {
            list.add(array[i]);
        }
        return new ServiceListImpl(list);
    }

    public ServiceList sortByNumber() throws SortNotAvailableException {
        return this.sortByName();
    }

    public Service findService(Locator locator) throws InvalidLocatorException {
        BDLocator bdLocator;
        if (!(locator instanceof BDLocator)) {
            try {
                bdLocator = new BDLocator(locator.toExternalForm());
            }
            catch (org.davic.net.InvalidLocatorException e) {
                throw new InvalidLocatorException(locator);
            }
        } else {
            bdLocator = (BDLocator)locator;
        }
        int title = bdLocator.getTitleNumber();
        if (title < 0) {
            throw new InvalidLocatorException(locator);
        }
        for (int i = 0; i < this.size(); ++i) {
            TitleImpl ti = (TitleImpl)this.services.get(i);
            if (((TitleImpl)this.services.get(i)).getTitleNum() != title) continue;
            return ti;
        }
        return null;
    }

    public ServiceList filterServices(ServiceFilter filter) {
        LinkedList<Service> list = new LinkedList<Service>();
        for (int i = 0; i < this.size(); ++i) {
            Service service = this.getService(i);
            if (!filter.accept(service)) continue;
            list.add(service);
        }
        return new ServiceListImpl(list);
    }

    public ServiceIterator createServiceIterator() {
        return new ServiceIteratorImpl(this.services);
    }

    public boolean contains(Service service) {
        return this.services.contains(service);
    }

    public int indexOf(Service service) {
        return this.services.indexOf(service);
    }

    public int size() {
        return this.services.size();
    }

    public Service getService(int num) {
        return (Service)this.services.get(num);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ServiceListImpl)) {
            return false;
        }
        return this.services.equals(((ServiceListImpl)obj).services);
    }

    public int hashCode() {
        return this.services.hashCode();
    }

    public void addService(Service service) {
        this.services.add(service);
    }

    private class TitleComparator
    implements Comparator {
        private TitleComparator() {
        }

        public int compare(Object obj1, Object obj2) {
            return ((TitleImpl)obj1).getTitleNum() - ((TitleImpl)obj2).getTitleNum();
        }
    }
}

