/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster;

import org.elasticsearch.common.Strings;
import org.elasticsearch.common.unit.ByteSizeValue;

public class DiskUsage {
    final String nodeId;
    final String nodeName;
    final String path;
    final long totalBytes;
    final long freeBytes;

    public DiskUsage(String nodeId, String nodeName, String path, long totalBytes, long freeBytes) {
        this.nodeId = nodeId;
        this.nodeName = nodeName;
        this.freeBytes = freeBytes;
        this.totalBytes = totalBytes;
        this.path = path;
    }

    public String getNodeId() {
        return this.nodeId;
    }

    public String getNodeName() {
        return this.nodeName;
    }

    public String getPath() {
        return this.path;
    }

    public double getFreeDiskAsPercentage() {
        if (this.totalBytes == 0L) {
            return 100.0;
        }
        return 100.0 * ((double)this.freeBytes / (double)this.totalBytes);
    }

    public double getUsedDiskAsPercentage() {
        return 100.0 - this.getFreeDiskAsPercentage();
    }

    public long getFreeBytes() {
        return this.freeBytes;
    }

    public long getTotalBytes() {
        return this.totalBytes;
    }

    public long getUsedBytes() {
        return this.getTotalBytes() - this.getFreeBytes();
    }

    public String toString() {
        return "[" + this.nodeId + "][" + this.nodeName + "][" + this.path + "] free: " + new ByteSizeValue(this.getFreeBytes()) + "[" + Strings.format1Decimals(this.getFreeDiskAsPercentage(), "%") + "]";
    }
}

