/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.launcher.exec;

import org.gradle.api.Action;
import org.gradle.api.JavaVersion;
import org.gradle.api.execution.internal.TaskInputsListener;
import org.gradle.api.internal.TaskInternal;
import org.gradle.api.internal.file.FileCollectionInternal;
import org.gradle.api.internal.file.FileSystemSubset;
import org.gradle.api.logging.LogLevel;
import org.gradle.execution.CancellableOperationManager;
import org.gradle.execution.DefaultCancellableOperationManager;
import org.gradle.execution.PassThruCancellableOperationManager;
import org.gradle.initialization.BuildCancellationToken;
import org.gradle.initialization.BuildRequestContext;
import org.gradle.initialization.ReportedException;
import org.gradle.internal.composite.CompositeBuildActionParameters;
import org.gradle.internal.concurrent.CompositeStoppable;
import org.gradle.internal.concurrent.ExecutorFactory;
import org.gradle.internal.event.ListenerManager;
import org.gradle.internal.filewatch.ChangeReporter;
import org.gradle.internal.filewatch.DefaultFileSystemChangeWaiterFactory;
import org.gradle.internal.filewatch.FileSystemChangeWaiter;
import org.gradle.internal.filewatch.FileSystemChangeWaiterFactory;
import org.gradle.internal.filewatch.FileWatcherFactory;
import org.gradle.internal.invocation.BuildAction;
import org.gradle.internal.logging.text.StyledTextOutput;
import org.gradle.internal.logging.text.StyledTextOutputFactory;
import org.gradle.internal.os.OperatingSystem;
import org.gradle.internal.service.ServiceRegistry;
import org.gradle.internal.service.scopes.BuildSessionScopeServices;
import org.gradle.launcher.exec.BuildActionExecuter;
import org.gradle.launcher.exec.BuildActionParameters;
import org.gradle.launcher.exec.BuildExecuter;
import org.gradle.util.DisconnectableInputStream;
import org.gradle.util.SingleMessageLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContinuousBuildActionExecuter
implements BuildExecuter {
    private final BuildActionExecuter<BuildActionParameters> delegate;
    private final BuildActionExecuter<CompositeBuildActionParameters> compositeDelegate;
    private final ListenerManager listenerManager;
    private final OperatingSystem operatingSystem;
    private final FileSystemChangeWaiterFactory changeWaiterFactory;
    private final ExecutorFactory executorFactory;
    private final JavaVersion javaVersion;
    private final StyledTextOutput logger;

    public ContinuousBuildActionExecuter(BuildActionExecuter<BuildActionParameters> delegate, FileWatcherFactory fileWatcherFactory, ListenerManager listenerManager, StyledTextOutputFactory styledTextOutputFactory, ExecutorFactory executorFactory, BuildActionExecuter<CompositeBuildActionParameters> compositeDelegate) {
        this(delegate, listenerManager, styledTextOutputFactory, JavaVersion.current(), OperatingSystem.current(), executorFactory, new DefaultFileSystemChangeWaiterFactory(fileWatcherFactory), compositeDelegate);
    }

    ContinuousBuildActionExecuter(BuildActionExecuter<BuildActionParameters> delegate, ListenerManager listenerManager, StyledTextOutputFactory styledTextOutputFactory, JavaVersion javaVersion, OperatingSystem operatingSystem, ExecutorFactory executorFactory, FileSystemChangeWaiterFactory changeWaiterFactory, BuildActionExecuter<CompositeBuildActionParameters> compositeDelegate) {
        this.delegate = delegate;
        this.listenerManager = listenerManager;
        this.javaVersion = javaVersion;
        this.operatingSystem = operatingSystem;
        this.changeWaiterFactory = changeWaiterFactory;
        this.executorFactory = executorFactory;
        this.logger = styledTextOutputFactory.create(ContinuousBuildActionExecuter.class, LogLevel.LIFECYCLE);
        this.compositeDelegate = compositeDelegate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object execute(BuildAction action, BuildRequestContext requestContext, BuildActionParameters actionParameters, ServiceRegistry contextServices) {
        BuildSessionScopeServices buildSessionScopeServices;
        block5: {
            block4: {
                Object object;
                buildSessionScopeServices = new BuildSessionScopeServices(contextServices, action.getStartParameter(), actionParameters.getInjectedPluginClasspath());
                try {
                    if (!(actionParameters instanceof CompositeBuildActionParameters)) break block4;
                    object = this.compositeDelegate.execute(action, requestContext, (CompositeBuildActionParameters)((Object)actionParameters), buildSessionScopeServices);
                }
                catch (Throwable throwable) {
                    CompositeStoppable.stoppable(buildSessionScopeServices).stop();
                    throw throwable;
                }
                CompositeStoppable.stoppable(buildSessionScopeServices).stop();
                return object;
            }
            if (!actionParameters.isContinuous()) break block5;
            Object object = this.executeMultipleBuilds(action, requestContext, actionParameters, buildSessionScopeServices);
            CompositeStoppable.stoppable(buildSessionScopeServices).stop();
            return object;
        }
        Object object = this.delegate.execute(action, requestContext, actionParameters, buildSessionScopeServices);
        CompositeStoppable.stoppable(buildSessionScopeServices).stop();
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object executeMultipleBuilds(BuildAction action, BuildRequestContext requestContext, final BuildActionParameters actionParameters, ServiceRegistry buildSessionScopeServices) {
        CancellableOperationManager cancellableOperationManager;
        if (!this.javaVersion.isJava7Compatible()) {
            throw new IllegalStateException("Continuous build requires Java 7 or later.");
        }
        SingleMessageLogger.incubatingFeatureUsed((String)"Continuous build");
        BuildCancellationToken cancellationToken = requestContext.getCancellationToken();
        if (actionParameters.isInteractive()) {
            if (!(System.in instanceof DisconnectableInputStream)) {
                System.setIn(new DisconnectableInputStream(System.in));
            }
            DisconnectableInputStream inputStream = (DisconnectableInputStream)System.in;
            cancellableOperationManager = new DefaultCancellableOperationManager(this.executorFactory.create("cancel signal monitor"), inputStream, cancellationToken);
        } else {
            cancellableOperationManager = new PassThruCancellableOperationManager(cancellationToken);
        }
        Object lastResult = null;
        int counter = 0;
        while (!cancellationToken.isCancellationRequested()) {
            if (++counter != 1) {
                requestContext.getBuildTimeClock().reset();
                this.logger.println((Object)"Change detected, executing build...").println();
            }
            final FileSystemChangeWaiter waiter = this.changeWaiterFactory.createChangeWaiter(cancellationToken);
            try {
                try {
                    lastResult = this.executeBuildAndAccumulateInputs(action, requestContext, actionParameters, waiter, buildSessionScopeServices);
                }
                catch (ReportedException t) {
                    lastResult = t;
                }
                if (!waiter.isWatching()) {
                    this.logger.println().withStyle(StyledTextOutput.Style.Failure).println((Object)"Exiting continuous build as no executed tasks declared file system inputs.");
                    if (lastResult instanceof ReportedException) {
                        throw (ReportedException)lastResult;
                    }
                    Object object = lastResult;
                    return object;
                }
                cancellableOperationManager.monitorInput((Action<? super BuildCancellationToken>)new Action<BuildCancellationToken>(){

                    @Override
                    public void execute(BuildCancellationToken cancellationToken) {
                        ChangeReporter reporter = new ChangeReporter();
                        waiter.wait(new Runnable(){

                            public void run() {
                                ContinuousBuildActionExecuter.this.logger.println().println((Object)("Waiting for changes to input files of tasks..." + ContinuousBuildActionExecuter.this.determineExitHint(actionParameters)));
                            }
                        }, reporter);
                        if (!cancellationToken.isCancellationRequested()) {
                            reporter.reportChanges(ContinuousBuildActionExecuter.this.logger);
                        }
                    }
                });
            }
            finally {
                waiter.stop();
            }
        }
        this.logger.println((Object)"Build cancelled.");
        if (lastResult instanceof ReportedException) {
            throw (ReportedException)lastResult;
        }
        return lastResult;
    }

    public String determineExitHint(BuildActionParameters actionParameters) {
        if (actionParameters.isInteractive()) {
            if (this.operatingSystem.isWindows()) {
                return " (ctrl-d then enter to exit)";
            }
            return " (ctrl-d to exit)";
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object executeBuildAndAccumulateInputs(BuildAction action, BuildRequestContext requestContext, BuildActionParameters actionParameters, final FileSystemChangeWaiter waiter, ServiceRegistry buildSessionScopeServices) {
        TaskInputsListener listener = new TaskInputsListener(){

            public void onExecute(TaskInternal taskInternal, FileCollectionInternal fileSystemInputs) {
                FileSystemSubset.Builder fileSystemSubsetBuilder = FileSystemSubset.builder();
                fileSystemInputs.registerWatchPoints(fileSystemSubsetBuilder);
                waiter.watch(fileSystemSubsetBuilder.build());
            }
        };
        this.listenerManager.addListener((Object)listener);
        try {
            Object object = this.delegate.execute(action, requestContext, actionParameters, buildSessionScopeServices);
            return object;
        }
        finally {
            this.listenerManager.removeListener((Object)listener);
        }
    }
}

