/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.renderspecial;

import javajs.util.P3;
import org.jmol.java.BS;
import org.jmol.renderspecial.DotsRenderer;
import org.jmol.shapespecial.GeoSurface;
import org.jmol.util.Geodesic;

public class GeoSurfaceRenderer
extends DotsRenderer {
    private boolean requireTranslucent;
    private P3 facePt1 = new P3();
    private P3 facePt2 = new P3();
    private P3 facePt3 = new P3();

    @Override
    protected boolean render() {
        GeoSurface gs = (GeoSurface)this.shape;
        boolean bl = this.iShowSolid = this.vwr.checkMotionRendering(1112150021) || gs.ec.getDotsConvexMax() <= 100;
        if (!this.iShowSolid && !this.g3d.setC((short)4)) {
            return false;
        }
        boolean tCover = this.vwr.gdata.translucentCoverOnly;
        if (this.iShowSolid) {
            this.vwr.gdata.translucentCoverOnly = true;
        }
        this.g3d.addRenderer(1073742182);
        if (this.iShowSolid && this.faceMap == null) {
            this.faceMap = new int[this.screenDotCount];
        }
        this.render1(gs);
        this.vwr.gdata.translucentCoverOnly = tCover;
        return this.requireTranslucent;
    }

    @Override
    protected void renderConvex(short colix, BS visibilityMap, int nPoints) {
        this.colix = colix;
        if (this.iShowSolid) {
            if (this.g3d.setC(colix)) {
                this.renderSurface(visibilityMap);
            } else {
                this.requireTranslucent = true;
            }
            return;
        }
        this.renderDots(nPoints);
    }

    private void renderSurface(BS points) {
        if (this.faceMap == null) {
            return;
        }
        short[] faces = Geodesic.getFaceVertexes(this.screenLevel);
        int[] coords = this.scrCoords;
        int mapMax = points.size();
        if (this.screenDotCount < mapMax) {
            mapMax = this.screenDotCount;
        }
        int f = 0;
        while (f < faces.length) {
            short p1 = faces[f++];
            short p2 = faces[f++];
            short p3 = faces[f++];
            if (p1 >= mapMax || p2 >= mapMax || p3 >= mapMax || !points.get(p1) || !points.get(p2) || !points.get(p3)) continue;
            this.facePt1.set(coords[this.faceMap[p1]], coords[this.faceMap[p1] + 1], coords[this.faceMap[p1] + 2]);
            this.facePt2.set(coords[this.faceMap[p2]], coords[this.faceMap[p2] + 1], coords[this.faceMap[p2] + 2]);
            this.facePt3.set(coords[this.faceMap[p3]], coords[this.faceMap[p3] + 1], coords[this.faceMap[p3] + 2]);
            this.g3d.fillTriangle3CNBits(this.facePt1, this.colix, p1, this.facePt2, this.colix, p2, this.facePt3, this.colix, p3);
        }
    }
}

