/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.jmol.app.nbo;

import java.awt.Color;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.Properties;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.border.LineBorder;
import javax.swing.filechooser.FileNameExtensionFilter;
import org.jmol.c.CBK;
import org.jmol.i18n.GT;
import org.jmol.viewer.Viewer;
import org.openscience.jmol.app.jmolpanel.JmolPanel;
import org.openscience.jmol.app.nbo.NBODialogSearch;
import org.openscience.jmol.app.nbo.NBOService;

public class NBODialog
extends NBODialogSearch {
    private JTextField jtRawInput;
    protected boolean isSet;

    public NBODialog(JFrame f, Viewer vwr, NBOService nboService) {
        super(f);
        this.vwr = vwr;
        this.nboService = nboService;
        Properties props = JmolPanel.historyFile.getProperties();
        this.savePath = props.getProperty("savePath", System.getProperty("user.home"));
        this.usePath = props.getProperty("usePath", System.getProperty("user.home"));
        this.workingPath = props.getProperty("workingPath", System.getProperty("user.home"));
        nboService.nboDialog = this;
        this.createDialog(570, 615);
        if (props.getProperty("useNBOView", "").equals("true")) {
            this.jCheckNboView.doClick();
        }
    }

    private void createDialog(int width, int height) {
        this.haveService = this.nboService.serverPath.length() > 0;
        this.setSize(new Dimension(width, height));
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                NBODialog.this.close();
            }
        });
        final NBODialog dialog = this;
        this.addComponentListener(new ComponentListener(){

            @Override
            public void componentResized(ComponentEvent e) {
                if (!NBODialog.this.isSet) {
                    NBODialog.this.placeNBODialog(dialog);
                }
                NBODialog.this.isSet = true;
            }

            @Override
            public void componentMoved(ComponentEvent e) {
            }

            @Override
            public void componentShown(ComponentEvent e) {
            }

            @Override
            public void componentHidden(ComponentEvent e) {
            }
        });
        this.modelButton = this.getMainButton("Model", 'm');
        this.mainButtons = new JButton[]{this.modelButton, this.runButton = this.getMainButton("Run", 'r'), this.viewButton = this.getMainButton("View", 'v'), this.searchButton = this.getMainButton("Search", 's')};
        this.topPanel = this.buildTopPanel();
        this.browse = new JButton("Browse");
        this.browse.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                switch (NBODialog.this.dialogMode) {
                    case 10: {
                        NBODialog.this.showWorkpathDialogM(NBODialog.this.usePath, "cfi,vfi,47,gau,log,gms,adf,jag,mm2,mnd,mp,nw,orc,pqs,qc");
                        break;
                    }
                    default: {
                        NBODialog.this.showWorkpathDialog(NBODialog.this.workingPath);
                    }
                }
            }
        });
        this.helpBtn = new JButton("Help");
        this.helpBtn.setFocusable(false);
        this.helpBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NBODialog.this.showHelp(null);
            }
        });
        this.jtRawInput = new JTextField();
        this.jtRawInput.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NBODialog.this.rawInput();
            }
        });
        this.statusPanel = this.buildStatusPanel();
        this.statusPanel.setSize(this.getWidth(), 60);
        this.jpNboOutput = new JTextPane();
        this.jpNboOutput.setEditable(false);
        this.jpNboOutput.setEnabled(false);
        this.jpNboOutput.setFont(new Font("Arial", 0, 16));
        this.jCheckAtomNum = new JCheckBox("Show Atom Numbers");
        this.jCheckAtomNum.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NBODialog.this.showAtomNums();
            }
        });
        this.jCheckAtomNum.setSelected(true);
        this.jCheckNboView = new JCheckBox("Use NBO View");
        this.jCheckNboView.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (NBODialog.this.jCheckNboView.isSelected()) {
                    NBODialog.this.setNBOColorScheme();
                } else {
                    NBODialog.this.resetColorScheme();
                }
                Properties props = new Properties();
                props.setProperty("useNBOView", NBODialog.this.nboView ? "true" : "false");
                JmolPanel.historyFile.addProperties(props);
            }
        });
        if (this.haveService) {
            this.connect();
        }
    }

    private JButton getMainButton(String path, final char mode) {
        JButton b = new JButton(path);
        b.setBorder(null);
        b.setMargin(new Insets(4, 4, 4, 4));
        b.setContentAreaFilled(false);
        b.setForeground(Color.white);
        b.setFont(new Font("Arial", 1, 20));
        b.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NBODialog.this.openPanel(mode);
            }
        });
        return b;
    }

    @Override
    protected void showWorkpathDialog(String workingPath) {
        String folder;
        JFileChooser myChooser = new JFileChooser();
        String useExt = this.tfExt.getText();
        if (!useExt.equals("")) {
            myChooser.setFileFilter(new FileNameExtensionFilter(useExt, useExt));
            myChooser.setFileHidingEnabled(true);
        }
        if (!(folder = this.tfFolder.getText().trim()).equals("")) {
            if (!folder.contains(":")) {
                folder = "C:/" + folder;
            }
            workingPath = folder + "/" + (this.tfName.getText().equals("") ? "new" : this.tfName.getText());
        }
        myChooser.setSelectedFile(new File(workingPath));
        int button = myChooser.showDialog(this, GT._("Select"));
        if (button == 0) {
            this.nboResetV();
            this.inputFile = myChooser.getSelectedFile();
            if (!(useExt.equals("47") || useExt.equals("31") || useExt.equals("nbo"))) {
                return;
            }
            this.setInputFile(this.newNBOFile(myChooser.getSelectedFile(), "47"), useExt, this.showWorkPathDone);
            switch (this.dialogMode) {
                case 30: {
                    this.dispBox();
                    this.basis.setSelectedIndex(5);
                    this.orbBox.setVisible(true);
                    break;
                }
                case 20: {
                    this.enableComponentsR(this, true);
                    this.addNBOKeylist();
                    this.editBox.setVisible(true);
                    break;
                }
                case 40: {
                    this.enableComponentsR(this, true);
                    if (this.keywordNumber == 0) break;
                    this.listClicked(this.keywordNumber);
                    break;
                }
                default: {
                    this.enableComponentsR(this, true);
                }
            }
        }
    }

    protected void showErrorFile(String err) {
        this.showNboOutput(err);
    }

    protected JPanel buildStatusPanel() {
        JPanel p = new JPanel();
        p.setLayout(new BoxLayout(p, 0));
        Box bo = Box.createHorizontalBox();
        bo.add(new JLabel("Command Input: "));
        bo.add(this.jtRawInput);
        bo.add(this.statusLab);
        bo.add(this.helpBtn);
        p.add(bo);
        this.setComponents(p, Color.white, Color.black);
        return p;
    }

    protected void close() {
        this.saveHistory();
        this.nboService.closeProcess();
        this.nboResetV();
        this.nboService.runScriptQueued("mo delete; nbo delete; select off");
        this.dispose();
    }

    private boolean checkEnabled() {
        this.haveService = this.nboService.serverPath.length() > 0;
        boolean enabled = this.haveService && this.nboService.restartIfNecessary();
        int i = this.mainButtons.length;
        while (--i >= 0) {
            this.mainButtons[i].setEnabled(enabled);
        }
        if (!enabled) {
            this.dialogMode = 0;
        }
        return enabled;
    }

    @Override
    protected boolean connect() {
        String arch = System.getenv("PROCESSOR_ARCHITECTURE");
        File f = new File(this.nboService.serverDir + "gennbo.bat");
        if (!f.exists()) {
            this.appendOutputWithCaret("gennbo.bat not found, make sure gennbo.bat is in same directory as nboserve.exe", 'b');
            return false;
        }
        String wow64Arch = System.getenv("PROCESSOR_ARCHITEW6432");
        String realArch = arch.endsWith("64") || wow64Arch != null && wow64Arch.endsWith("64") ? "64" : "32";
        BufferedReader b = null;
        try {
            String line;
            b = new BufferedReader(new FileReader(f));
            String contents = "";
            while ((line = b.readLine()) != null) {
                if (line.startsWith("set INT=")) {
                    line = realArch.equals("64") ? "set INT=i8" : "set INT=i4";
                }
                contents = contents + line + sep;
            }
            this.nboService.writeToFile(contents, f);
            b.close();
        }
        catch (FileNotFoundException e) {
            this.appendOutputWithCaret("Error opening gennbo.bat", 'b');
            return false;
        }
        catch (IOException e) {
            this.appendOutputWithCaret("Error opening gennbo.bat", 'b');
            return false;
        }
        boolean isOK = this.checkEnabled();
        this.appendOutputWithCaret(isOK ? "NBOServe successfully connected" : "Could not connect", 'p');
        return isOK;
    }

    public void openPanel(char type) {
        switch (this.dialogMode) {
            case 0: 
            case 10: 
            case 20: {
                break;
            }
            case 30: 
            case 40: {
                this.nboService.runScriptQueued("mo delete; nbo delete; select off");
            }
        }
        this.topPanel.remove(this.icon);
        this.isJmolNBO = this.checkJmolNBO();
        if (!this.checkEnabled()) {
            type = (char)99;
        }
        int i = this.mainButtons.length;
        while (--i >= 0) {
            this.mainButtons[i].setBorder(null);
        }
        switch (type) {
            case 'c': {
                this.dialogMode = 0;
                this.buildConfig(this.getContentPane());
                break;
            }
            case 'm': {
                this.dialogMode = 10;
                this.setThis(this.modelButton);
                this.buildModel(this.getContentPane());
                this.icon = new JLabel(new ImageIcon(this.getClass().getResource("nbomodel_logo.gif")));
                break;
            }
            case 'r': {
                this.dialogMode = 20;
                this.setThis(this.runButton);
                this.buildRun(this.getContentPane());
                this.icon = new JLabel(new ImageIcon(this.getClass().getResource("nborun_logo.gif")));
                break;
            }
            case 'v': {
                this.dialogMode = 30;
                this.setThis(this.viewButton);
                this.buildView(this.getContentPane());
                this.icon = new JLabel(new ImageIcon(this.getClass().getResource("nboview_logo.gif")));
                break;
            }
            case 's': {
                this.dialogMode = 40;
                this.setThis(this.searchButton);
                this.buildSearch(this.getContentPane());
                this.icon = new JLabel(new ImageIcon(this.getClass().getResource("nbosearch_logo.gif")));
            }
        }
        this.topPanel.add(this.icon);
        this.invalidate();
        this.setVisible(true);
        this.connect();
    }

    private void setThis(JButton btn) {
        btn.setEnabled(false);
        btn.setBorder(new LineBorder(Color.WHITE, 2));
        this.invalidate();
    }

    protected void rawInput() {
        String cmd0 = this.jtRawInput.getText();
        String cmd = cmd0.trim().toUpperCase();
        switch (this.dialogMode) {
            case 10: {
                if (cmd.startsWith("HELP")) {
                    this.showHelp(cmd.indexOf(" ") >= 0 ? cmd.split(" ")[1].toLowerCase() : "");
                    break;
                }
                this.rawInputM(cmd0);
                break;
            }
            case 20: {
                break;
            }
            case 30: {
                this.rawInputV(cmd);
                break;
            }
            case 40: {
                this.rawInputS(cmd);
            }
        }
        this.jtRawInput.setText("");
    }

    public void notifyCallback(CBK type, Object[] data) {
        switch (type) {
            case STRUCTUREMODIFIED: {
                if (this.dialogMode != 10) break;
                this.loadModel();
                break;
            }
            case PICK: {
                int atomIndex = (Integer)data[2];
                if (atomIndex < 0) break;
                String atomno = "" + (atomIndex + 1);
                switch (this.dialogMode) {
                    case 10: {
                        this.notifyCallbackM(atomno);
                        break;
                    }
                    case 30: {
                        this.notifyCallbackV(atomno);
                        break;
                    }
                    case 40: {
                        this.notifyCallbackS(atomIndex);
                    }
                }
                break;
            }
            case LOADSTRUCT: {
                if (this.dialogMode != 10) break;
                this.notifyLoadModel();
            }
        }
    }

    void alert(String msg) {
        try {
            switch (this.dialogMode) {
                case 10: {
                    this.appendOutputWithCaret(msg, 'b');
                    return;
                }
            }
        }
        catch (Exception e) {
            this.vwr.alert(msg);
        }
    }

    protected void showHelp(String key) {
        JDialog help = new JDialog((Dialog)this, "NBO Help");
        JTextPane p = new JTextPane();
        p.setEditable(false);
        p.setFont(new Font("Arial", 0, 16));
        JScrollPane sp = new JScrollPane();
        sp.getViewport().add(p);
        help.add(sp);
        help.setSize(new Dimension(400, 400));
        switch (this.dialogMode) {
            case 0: {
                p.setText(this.getHelp("config"));
                break;
            }
            case 10: {
                if (this.helpDialogM(p, key)) break;
                return;
            }
            case 20: {
                p.setText(this.getHelp("run"));
                break;
            }
            case 30: {
                p.setText(this.getHelp("view"));
                break;
            }
            case 40: {
                p.setText("             NBOSearch: COMMAND SYNTAX AND PROGRAM OVERVIEW\nPROGRAM OVERVIEW:\nFollow menu prompts through the decision tree to the keyword module and datum of interest. Each menu appears with 'Current [V-list] settings' and a scrolling list of output values. All output lines are also echoed to an external NBOLOG$$.DAT file and error messages go to NBOERR$$.DAT for later reference.\n\nGENERAL 'M V n' COMMAND SYNTAX:\nNBOSearch user responses generally consist of 'commands' \n(replies to prompts)\nof the form 'M (V (n))', where\n   M (integer)   = [M]enu selection from displayed items\n   V (character) = [V]ariable data type to be selected\n                   [J](obname)\n                   [B](asis)\n                   [O](rbital number)\n                   [A](tom number, in context)\n                   [U](nit number)\n                   [d](onor NBO number)\n                   [a](cceptor NBO number, in context)\n   n (integer)   = [n]umber of the desired O/A/U/d/a selection\nResponses may also be of simple 'M', 'V', or 'Vn' form , where\n  'M' : selects a numbered menu choice (for current [V] choices)\n  'V' : requests a menu of [V] choices\n  'Vn': selects [V] number 'n' (and current [S])\nNote that [V]-input is case-insensitive, so 'A' (or 'a') is interpreted as 'atom' or 'acceptor' according to context.  Note also that 'Vn' commands can be\ngiven in separated 'V n' form. Although not explicitly included in each active [V]-select list, the 'H'(elp) key is recognized at each prompt.  For NRT search (only), variable [V] may also be 'R' (for 'resonance structure' and A' (for 'interacting atom'). Current A (atom)  and A' (interacting atom) values determine the current A-A' 'bond' selection small fractional bond order.)\n\nEXAMPLES:\n  '2 a7'  : requests menu item 2 for atom 7 (if A-select active)\n  '3 o2'  : requests menu item 3 for orbital 2 \n");
            }
        }
        p.setCaretPosition(0);
        this.centerDialog(help);
        help.setVisible(true);
    }

    public void addLine(int type, String line) {
        if (line == null) {
            return;
        }
        switch (type) {
            case 0: {
                this.reqInfo = line;
                break;
            }
            case 10: {
                if (line.contains("NBOModel")) {
                    this.appendOutputWithCaret(line, 'b');
                    break;
                }
                if (this.editMode == 5) {
                    this.appendOutputWithCaret("   " + line, 'b');
                    break;
                }
                this.appendOutputWithCaret("   " + line.charAt(1) + "<sub>" + line.substring(2) + "</sub>", 'b');
                break;
            }
            case 30: {
                line = line.trim();
                while (line.length() % 20 != 0) {
                    line = line + " ";
                }
                this.reqInfo = this.reqInfo + line;
                break;
            }
            case 40: {
                this.reqInfo = this.reqInfo + "-" + line;
                break;
            }
            case -1: {
                if (this.reqInfo.trim().split(" ").length > this.jmolAtomCount) break;
                this.reqInfo = this.reqInfo + line + " ";
            }
        }
    }

    public void setStatus(String statusInfo) {
        this.statusLab.setText(statusInfo);
    }
}

