/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.dialogs.relation;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.table.AbstractTableModel;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.SelectionChangedListener;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.gui.layer.LayerManager;
import org.openstreetmap.josm.gui.layer.MainLayerManager;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.tools.CheckParameterUtil;

public class SelectionTableModel
extends AbstractTableModel
implements SelectionChangedListener,
MainLayerManager.ActiveLayerChangeListener,
LayerManager.LayerChangeListener {
    private final transient OsmDataLayer layer;
    private final transient List<OsmPrimitive> cache;

    public SelectionTableModel(OsmDataLayer osmDataLayer) {
        CheckParameterUtil.ensureParameterNotNull(osmDataLayer, "layer");
        this.layer = osmDataLayer;
        this.cache = new ArrayList<OsmPrimitive>();
        this.populateSelectedPrimitives(osmDataLayer);
    }

    public void register() {
        DataSet.addSelectionListener(this);
        Main.getLayerManager().addActiveLayerChangeListener(this);
    }

    public void unregister() {
        DataSet.removeSelectionListener(this);
        Main.getLayerManager().removeActiveLayerChangeListener(this);
    }

    @Override
    public int getColumnCount() {
        return 1;
    }

    @Override
    public int getRowCount() {
        if (Main.getLayerManager().getEditLayer() != this.layer) {
            return 0;
        }
        return this.cache.size();
    }

    @Override
    public Object getValueAt(int n, int n2) {
        return this.cache.get(n);
    }

    @Override
    public void activeOrEditLayerChanged(MainLayerManager.ActiveLayerChangeEvent activeLayerChangeEvent) {
        if (activeLayerChangeEvent.getPreviousActiveLayer() == this.layer) {
            this.cache.clear();
        }
        if (activeLayerChangeEvent.getSource().getActiveLayer() == this.layer) {
            this.cache.addAll(this.layer.data.getAllSelected());
        }
        this.fireTableDataChanged();
    }

    @Override
    public void layerAdded(LayerManager.LayerAddEvent layerAddEvent) {
    }

    @Override
    public void layerRemoving(LayerManager.LayerRemoveEvent layerRemoveEvent) {
        if (layerRemoveEvent.getRemovedLayer() == this.layer) {
            this.unregister();
        }
        this.cache.clear();
        this.fireTableDataChanged();
    }

    @Override
    public void layerOrderChanged(LayerManager.LayerOrderChangeEvent layerOrderChangeEvent) {
    }

    @Override
    public void selectionChanged(Collection<? extends OsmPrimitive> collection) {
        if (this.layer == Main.getLayerManager().getEditLayer()) {
            this.cache.clear();
            this.cache.addAll(collection);
        } else {
            this.cache.clear();
        }
        this.fireTableDataChanged();
    }

    public List<OsmPrimitive> getSelection() {
        return this.cache;
    }

    protected void populateSelectedPrimitives(OsmDataLayer osmDataLayer) {
        this.selectionChanged(osmDataLayer.data.getAllSelected());
    }

    public OsmPrimitive getPrimitive(int n) {
        return this.cache.get(n);
    }
}

