/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.download;

import java.awt.Component;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.Locale;
import java.util.Objects;
import javax.swing.DefaultListModel;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

public class BookmarkList
extends JList<Bookmark> {
    public BookmarkList() {
        this.setModel(new DefaultListModel());
        this.load();
        this.setVisibleRowCount(7);
        this.setCellRenderer(new BookmarkCellRenderer());
    }

    public final void load() {
        DefaultListModel defaultListModel = (DefaultListModel)this.getModel();
        defaultListModel.removeAllElements();
        Collection<Collection<String>> collection = Main.pref.getArray("bookmarks", null);
        if (collection != null) {
            LinkedList<Bookmark> linkedList = new LinkedList<Bookmark>();
            for (Collection<String> object : collection) {
                try {
                    linkedList.add(new Bookmark(object));
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    Main.error((Throwable)illegalArgumentException, I18n.tr("Error reading bookmark entry: %s", illegalArgumentException.getMessage()));
                }
            }
            Collections.sort(linkedList);
            for (Bookmark bookmark : linkedList) {
                defaultListModel.addElement(bookmark);
            }
        }
    }

    public final void save() {
        LinkedList<Collection<String>> linkedList = new LinkedList<Collection<String>>();
        for (Object object : ((DefaultListModel)this.getModel()).toArray()) {
            String[] stringArray = new String[5];
            Bookmark bookmark = (Bookmark)object;
            stringArray[0] = bookmark.getName();
            Bounds bounds = bookmark.getArea();
            stringArray[1] = String.valueOf(bounds.getMinLat());
            stringArray[2] = String.valueOf(bounds.getMinLon());
            stringArray[3] = String.valueOf(bounds.getMaxLat());
            stringArray[4] = String.valueOf(bounds.getMaxLon());
            linkedList.add(Arrays.asList(stringArray));
        }
        Main.pref.putArray("bookmarks", linkedList);
    }

    static class BookmarkCellRenderer
    extends JLabel
    implements ListCellRenderer<Bookmark> {
        BookmarkCellRenderer() {
            this.setOpaque(true);
            this.setIcon(ImageProvider.get("dialogs", "bookmark"));
        }

        protected void renderColor(boolean bl) {
            if (bl) {
                this.setBackground(UIManager.getColor("List.selectionBackground"));
                this.setForeground(UIManager.getColor("List.selectionForeground"));
            } else {
                this.setBackground(UIManager.getColor("List.background"));
                this.setForeground(UIManager.getColor("List.foreground"));
            }
        }

        protected String buildToolTipText(Bookmark bookmark) {
            Bounds bounds = bookmark.getArea();
            StringBuilder stringBuilder = new StringBuilder(128);
            stringBuilder.append("<html>min[latitude,longitude]=<strong>[").append(bounds.getMinLat()).append(',').append(bounds.getMinLon()).append("]</strong><br>max[latitude,longitude]=<strong>[").append(bounds.getMaxLat()).append(',').append(bounds.getMaxLon()).append("]</strong></html>");
            return stringBuilder.toString();
        }

        @Override
        public Component getListCellRendererComponent(JList<? extends Bookmark> jList, Bookmark bookmark, int n, boolean bl, boolean bl2) {
            this.renderColor(bl);
            this.setText(bookmark.getName());
            this.setToolTipText(this.buildToolTipText(bookmark));
            return this;
        }
    }

    public static class Bookmark
    implements Comparable<Bookmark> {
        private String name;
        private Bounds area;

        public Bookmark(Collection<String> collection) {
            ArrayList<String> arrayList = new ArrayList<String>(collection);
            if (arrayList.size() < 5) {
                throw new IllegalArgumentException(I18n.tr("Wrong number of arguments for bookmark", new Object[0]));
            }
            this.name = (String)arrayList.get(0);
            this.area = new Bounds(Double.parseDouble((String)arrayList.get(1)), Double.parseDouble((String)arrayList.get(2)), Double.parseDouble((String)arrayList.get(3)), Double.parseDouble((String)arrayList.get(4)));
        }

        public Bookmark() {
            this.area = null;
            this.name = null;
        }

        public Bookmark(Bounds bounds) {
            this.area = bounds;
        }

        public String toString() {
            return this.name;
        }

        @Override
        public int compareTo(Bookmark bookmark) {
            return this.name.toLowerCase(Locale.ENGLISH).compareTo(bookmark.name.toLowerCase(Locale.ENGLISH));
        }

        public int hashCode() {
            return Objects.hash(this.name, this.area);
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            Bookmark bookmark = (Bookmark)object;
            return Objects.equals(this.name, bookmark.name) && Objects.equals(this.area, bookmark.area);
        }

        public Bounds getArea() {
            return this.area;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String string) {
            this.name = string;
        }

        public void setArea(Bounds bounds) {
            this.area = bounds;
        }
    }
}

