/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.layer.imagery;

import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import org.openstreetmap.gui.jmapviewer.Tile;
import org.openstreetmap.gui.jmapviewer.interfaces.ICoordinate;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.MapViewState;
import org.openstreetmap.josm.gui.layer.imagery.TileSourceDisplaySettings;

public class TileCoordinateConverter {
    private MapView mapView;
    private TileSourceDisplaySettings settings;

    public TileCoordinateConverter(MapView mapView, TileSourceDisplaySettings tileSourceDisplaySettings) {
        this.mapView = mapView;
        this.settings = tileSourceDisplaySettings;
    }

    private MapViewState.MapViewPoint pos(ICoordinate iCoordinate) {
        return this.mapView.getState().getPointFor(new LatLon(iCoordinate)).add(this.settings.getDisplacement());
    }

    public Point2D getPixelForTile(Tile tile) {
        ICoordinate iCoordinate = tile.getTileSource().tileXYToLatLon(tile);
        return this.pos(iCoordinate).getInView();
    }

    public Rectangle2D getRectangleForTile(Tile tile) {
        ICoordinate iCoordinate = tile.getTileSource().tileXYToLatLon(tile);
        ICoordinate iCoordinate2 = tile.getTileSource().tileXYToLatLon(tile.getXtile() + 1, tile.getYtile() + 1, tile.getZoom());
        return this.pos(iCoordinate).rectTo(this.pos(iCoordinate2)).getInView();
    }
}

