/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.preferences.advanced;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.AbstractListModel;
import javax.swing.DefaultCellEditor;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JToolBar;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellEditor;
import org.openstreetmap.josm.gui.preferences.advanced.AbstractListEditor;
import org.openstreetmap.josm.gui.preferences.advanced.PrefEntry;
import org.openstreetmap.josm.gui.widgets.JosmTextField;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

public abstract class AbstractTableListEditor<T>
extends AbstractListEditor<T> {
    protected final AbstractEntryListModel entryModel = this.newEntryListModel();
    protected final JList<String> entryList = new JList<String>(this.entryModel);
    protected final JTable table;
    protected final AbstractTableModel tableModel;
    protected Integer entryIdx;

    public AbstractTableListEditor(Component component, String string, PrefEntry prefEntry) {
        super(component, string, prefEntry);
        this.entryList.getSelectionModel().addListSelectionListener(new EntryListener());
        this.tableModel = this.newTableModel();
        this.table = new JTable(this.tableModel);
        this.setContent(this.build(), false);
    }

    @Override
    protected JPanel build() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.add((Component)new JLabel(I18n.tr("Key: {0}", this.entry.getKey())), GBC.std(0, 0).span(2).weight(1.0, 0.0).insets(0, 0, 5, 10));
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        JScrollPane jScrollPane = new JScrollPane(this.entryList);
        jPanel2.add((Component)jScrollPane, GBC.eol().fill());
        JToolBar jToolBar = new JToolBar(0);
        jToolBar.setBorderPainted(false);
        jToolBar.setOpaque(false);
        jToolBar.add(new NewEntryAction());
        RemoveEntryAction removeEntryAction = new RemoveEntryAction();
        this.entryList.getSelectionModel().addListSelectionListener(removeEntryAction);
        jToolBar.add(removeEntryAction);
        jPanel2.add((Component)jToolBar, GBC.eol());
        jPanel2.setPreferredSize(new Dimension(80, 0));
        jPanel.add((Component)jPanel2, GBC.std(0, 1).fill().weight(0.3, 1.0));
        this.table.putClientProperty("terminateEditOnFocusLost", Boolean.TRUE);
        DefaultCellEditor defaultCellEditor = new DefaultCellEditor(new JosmTextField());
        defaultCellEditor.setClickCountToStart(1);
        this.table.setDefaultEditor(this.table.getColumnClass(0), defaultCellEditor);
        JScrollPane jScrollPane2 = new JScrollPane(this.table);
        jScrollPane2.setPreferredSize(new Dimension(140, 0));
        jPanel.add((Component)jScrollPane2, GBC.std(1, 1).insets(5, 0, 0, 0).fill().weight(0.7, 1.0));
        return jPanel;
    }

    protected abstract AbstractEntryListModel newEntryListModel();

    protected abstract AbstractTableModel newTableModel();

    private class EntryListener
    implements ListSelectionListener {
        private EntryListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            TableCellEditor tableCellEditor = AbstractTableListEditor.this.table.getCellEditor();
            if (tableCellEditor != null) {
                ((DefaultCellEditor)tableCellEditor).stopCellEditing();
            }
            if (AbstractTableListEditor.this.entryList.getSelectedIndices().length != 1) {
                AbstractTableListEditor.this.entryIdx = null;
                AbstractTableListEditor.this.table.setEnabled(false);
            } else {
                AbstractTableListEditor.this.entryIdx = AbstractTableListEditor.this.entryList.getSelectedIndices()[0];
                AbstractTableListEditor.this.table.setEnabled(true);
            }
            AbstractTableListEditor.this.tableModel.fireTableStructureChanged();
            AbstractTableListEditor.this.tableModel.fireTableDataChanged();
        }
    }

    protected final class RemoveEntryAction
    extends AbstractAction
    implements ListSelectionListener {
        RemoveEntryAction() {
            this.putValue("Name", I18n.tr("Remove", new Object[0]));
            this.putValue("ShortDescription", I18n.tr("Remove the selected entry", new Object[0]));
            this.putValue("SmallIcon", ImageProvider.get("dialogs", "delete"));
            this.updateEnabledState();
        }

        private void updateEnabledState() {
            this.setEnabled(AbstractTableListEditor.this.entryList.getSelectedIndices().length == 1);
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            this.updateEnabledState();
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            AbstractTableListEditor.this.entryModel.remove(AbstractTableListEditor.this.entryList.getSelectedIndices()[0]);
        }
    }

    protected final class NewEntryAction
    extends AbstractAction {
        NewEntryAction() {
            this.putValue("Name", I18n.tr("New", new Object[0]));
            this.putValue("ShortDescription", I18n.tr("add entry", new Object[0]));
            this.putValue("SmallIcon", ImageProvider.get("dialogs", "add"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            AbstractTableListEditor.this.entryModel.add();
        }
    }

    protected static abstract class AbstractEntryListModel
    extends AbstractListModel<String> {
        protected AbstractEntryListModel() {
        }

        abstract void add();

        abstract void remove(int var1);
    }
}

